"use strict";
// /server/api/kyc-level/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
exports.getActiveKycLevels = getActiveKycLevels;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Lists the active KYC levels",
    description: "Fetches all currently active KYC (Know Your Customer) levels that are used for KYC processes. This endpoint is accessible without authentication and returns an array of levels that are marked as active in the system.",
    operationId: "getActiveKycLevels",
    tags: ["KYC"],
    responses: {
        200: {
            description: "Active KYC levels retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: {
                                id: { type: "number", description: "Level ID" },
                                title: { type: "string", description: "Level title" },
                                options: {
                                    type: "object",
                                    description: "Level options as JSON object",
                                    nullable: true,
                                },
                                status: {
                                    type: "boolean",
                                    description: "Active status of the level",
                                },
                            },
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Kyc Level"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: false,
};
exports.default = async () => {
    return getActiveKycLevels();
};
async function getActiveKycLevels() {
    const response = await db_1.models.kycLevel.findAll({
        where: {
            status: "ACTIVE",
        },
    });
    if (!response || response.length === 0) {
        throw new Error("No active KYC levels found");
    }
    return response.map((level) => level.get({ plain: true }));
}
