"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Mark All Notifications as Read",
    description: "Marks all notifications as read for the authenticated creator.",
    operationId: "markAllNotificationsRead",
    tags: ["ICO", "Creator", "Notifications"],
    requiresAuth: true,
    responses: {
        200: { description: "All notifications marked as read successfully." },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    await db_1.models.notification.update({ read: true }, { where: { userId: user.id } });
    return { message: "All notifications marked as read successfully." };
};
