"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.broadcastStatus = broadcastStatus;
exports.broadcastProgress = broadcastProgress;
exports.broadcastLog = broadcastLog;
// utils/cronBroadcast.ts
const Websocket_1 = require("@b/handler/Websocket");
const cron_1 = __importDefault(require("@b/utils/cron"));
async function broadcastStatus(cronName, status, extra = {}) {
    // Update the job status in CronJobManager
    try {
        const cronJobManager = await cron_1.default.getInstance();
        cronJobManager.updateJobRunningStatus(cronName, status);
    }
    catch (error) {
        console.error(`Failed to update cron job status for ${cronName}:`, error);
    }
    // Broadcast to WebSocket clients
    Websocket_1.messageBroker.broadcastToRoute("/api/admin/system/cron", {
        type: "status",
        cronName,
        data: { status, ...extra },
        timestamp: new Date(),
    });
}
async function broadcastProgress(cronName, progress) {
    // Update the progress in CronJobManager
    try {
        const cronJobManager = await cron_1.default.getInstance();
        cronJobManager.updateJobRunningStatus(cronName, "running", progress);
    }
    catch (error) {
        console.error(`Failed to update cron job progress for ${cronName}:`, error);
    }
    // Broadcast to WebSocket clients
    Websocket_1.messageBroker.broadcastToRoute("/api/admin/system/cron", {
        type: "progress",
        cronName,
        data: { progress },
        timestamp: new Date(),
    });
}
function broadcastLog(cronName, logMessage, logType = "info") {
    Websocket_1.messageBroker.broadcastToRoute("/api/admin/system/cron", {
        type: "log",
        cronName,
        data: { message: logMessage, logType },
        timestamp: new Date(),
    });
}
