"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processPendingOrders = processPendingOrders;
const logger_1 = require("../logger");
const BinaryOrderService_1 = require("@b/api/exchange/binary/order/util/BinaryOrderService");
const broadcast_1 = require("./broadcast");
/**
 * Processes pending binary orders.
 * @param shouldBroadcast - If true, broadcasts status messages (useful for cron jobs).
 */
async function processPendingOrders(shouldBroadcast = true) {
    const cronName = "processPendingOrders";
    try {
        if (shouldBroadcast) {
            (0, broadcast_1.broadcastStatus)(cronName, "running");
            (0, broadcast_1.broadcastLog)(cronName, "Starting processing pending orders");
        }
        // Pass the flag to BinaryOrderService so it can conditionally log as well.
        await BinaryOrderService_1.BinaryOrderService.processPendingOrders(shouldBroadcast);
        if (shouldBroadcast) {
            (0, broadcast_1.broadcastStatus)(cronName, "completed");
            (0, broadcast_1.broadcastLog)(cronName, "Processing pending orders completed", "success");
        }
    }
    catch (error) {
        (0, logger_1.logError)("processPendingOrders", error, __filename);
        if (shouldBroadcast) {
            (0, broadcast_1.broadcastStatus)(cronName, "failed");
            (0, broadcast_1.broadcastLog)(cronName, `Processing pending orders failed: ${error.message}`, "error");
        }
        throw error;
    }
}
