"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNotification = createNotification;
exports.createAdminNotification = createAdminNotification;
// backend/src/api/utils/notification.ts
const db_1 = require("@b/db");
const Websocket_1 = require("@b/handler/Websocket");
const task_1 = require("./task");
async function createNotification(options) {
    try {
        // Wrap the notification creation and sending in a task
        const task = async () => {
            const newRecord = await db_1.models.notification.create({
                userId: options.userId,
                relatedId: options.relatedId,
                title: options.title,
                type: options.type,
                message: options.message,
                details: options.details,
                link: options.link,
                actions: options.actions,
                read: false,
            });
            const plainRecord = newRecord.get({ plain: true });
            Websocket_1.messageBroker.sendToClientOnRoute("/api/user", options.userId, {
                type: "notification",
                method: "create",
                payload: plainRecord,
            });
            return newRecord;
        };
        // Add the task to the queue and await its completion
        return await task_1.taskQueue.add(task);
    }
    catch (err) {
        console.error("Failed to create notification", err);
        throw err;
    }
}
async function createAdminNotification(permissionName, title, message, type, link, details, actions) {
    try {
        // Find all users whose role includes the specified permission
        const users = await db_1.models.user.findAll({
            include: [
                {
                    model: db_1.models.role,
                    as: "role",
                    include: [
                        {
                            model: db_1.models.permission,
                            as: "permissions",
                            through: { attributes: [] },
                            where: { name: permissionName },
                        },
                    ],
                    required: true,
                },
            ],
            attributes: ["id"],
        });
        // Create a task for each user to send the notification
        const tasks = users.map((user) => {
            return async () => {
                await createNotification({
                    userId: user.id,
                    title,
                    message,
                    type,
                    link,
                    details,
                    actions,
                });
            };
        });
        // Add all tasks to the task queue and wait for them to complete
        await Promise.all(tasks.map((task) => task_1.taskQueue.add(task)));
    }
    catch (error) {
        console.error("Failed to create admin notification", error);
        throw error;
    }
}
