"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSolanaService = getSolanaService;
exports.getTronService = getTronService;
exports.getMoneroService = getMoneroService;
exports.getTonService = getTonService;
exports.getBitcoinNodeService = getBitcoinNodeService;
exports.getEcosystemWalletUtils = getEcosystemWalletUtils;
exports.isServiceAvailable = isServiceAvailable;
// Safe import function that returns null if module doesn't exist
async function safeImport(modulePath) {
    try {
        const importedModule = await Promise.resolve(`${modulePath}`).then(s => __importStar(require(s)));
        return importedModule.default;
    }
    catch (error) {
        // Module doesn't exist or failed to load
        return null;
    }
}
// Cached service instances
let solanaService = null;
let tronService = null;
let moneroService = null;
let tonService = null;
let bitcoinNodeService = null;
// Flags to track if we've attempted to load services
let solanaChecked = false;
let tronChecked = false;
let moneroChecked = false;
let tonChecked = false;
let bitcoinNodeChecked = false;
async function getSolanaService() {
    if (!solanaChecked) {
        solanaService = await safeImport('@b/blockchains/sol');
        solanaChecked = true;
    }
    return solanaService;
}
async function getTronService() {
    if (!tronChecked) {
        tronService = await safeImport('@b/blockchains/tron');
        tronChecked = true;
    }
    return tronService;
}
async function getMoneroService() {
    if (!moneroChecked) {
        moneroService = await safeImport('@b/blockchains/xmr');
        moneroChecked = true;
    }
    return moneroService;
}
async function getTonService() {
    if (!tonChecked) {
        tonService = await safeImport('@b/blockchains/ton');
        tonChecked = true;
    }
    return tonService;
}
async function getBitcoinNodeService() {
    if (!bitcoinNodeChecked) {
        bitcoinNodeService = await safeImport('@b/api/(ext)/ecosystem/utils/utxo/btc-node');
        bitcoinNodeChecked = true;
    }
    return bitcoinNodeService;
}
// Cached ecosystem wallet utils
let ecosystemWalletUtils = null;
let ecosystemWalletUtilsChecked = false;
async function getEcosystemWalletUtils() {
    if (!ecosystemWalletUtilsChecked) {
        ecosystemWalletUtils = await safeImport('@b/api/(ext)/ecosystem/utils/wallet');
        ecosystemWalletUtilsChecked = true;
    }
    return ecosystemWalletUtils;
}
// Helper function to check if a service is available
function isServiceAvailable(service) {
    return service !== null && service !== undefined;
}
