# Version 5.4.2

**Release Date:** August 9, 2025  
**Tags:** FEATURE ENHANCEMENTS, ADMIN IMPROVEMENTS, USER MANAGEMENT

## Added

### CSV Import/Export for User Management
- **Bulk Import**: Upload users via CSV file with comprehensive validation
- **User Export**: Export to CSV for data backup and migration
- **Error Reporting**: Detailed validation with row numbers and specific errors
- **CSV Template**: Downloadable template with example data
- **Profile Support**: All user fields including profile and social data

### Exchange Market Fee Management
- **Fee Editing**: Modify taker and maker fees for spot markets
- **Market Flags**: Edit trending and hot market indicators
- **Precision Config**: Configure price and amount decimal places
- **Enhanced Interface**: Similar management features to ecosystem markets

## Features

### User CSV Import
- **Validation**: Required fields checking (email, firstName, lastName)
- **Duplicate Detection**: Prevents creating users with existing emails
- **Default Password**: Configurable for imported users without passwords
- **Welcome Emails**: Optional sending to newly imported users
- **Flexible Parsing**: Accepts true/false, yes/no, 1/0 for boolean fields
- **Batch Processing**: Transaction support for data integrity

### User CSV Export
- **Export Filters**: By user status (ACTIVE, INACTIVE, BANNED, SUSPENDED)
- **Complete Data**: Including all profile and social fields
- **Password Export**: Optional encrypted passwords for migration
- **Auto Filename**: Generated with current date
- **Compatible Format**: Works with import template

### Exchange Market Enhancements
- **Fee Structure**: Editable taker and maker fee percentages
- **Market Config**: Currency, pair, trending, and hot flags
- **Precision Settings**: Price and amount decimal configuration
- **API Improvements**: Fixed permissions and proper categorization

## CSV Format

### Required Fields
- **email**: User's email address (must be unique)
- **firstName**: User's first name
- **lastName**: User's last name

### Optional Fields
- **password**: User password (uses default if not provided)
- **phone**: Phone number
- **status**: ACTIVE, INACTIVE, BANNED, or SUSPENDED
- **emailVerified**: Email verification status
- **twoFactor**: Two-factor authentication enabled
- **roleId**: User role identifier
- **avatar**: Avatar URL

### Profile Fields
- **bio**: User biography
- **address**: Street address
- **city**: City name
- **country**: Country name
- **zip**: Postal code

### Social Media Fields
- **facebook**: Facebook profile URL
- **twitter**: Twitter profile URL
- **instagram**: Instagram profile URL
- **github**: GitHub profile URL
- **dribbble**: Dribbble profile URL
- **gitlab**: GitLab profile URL

## Improved

### Administrative Control
- **Bulk Operations**: Efficient management of large user bases
- **Data Migration**: Simplified with CSV export/import
- **Market Control**: Full control over exchange fee structures
- **Permission System**: Granular control with import.user and export.user permissions

### Security
- **Password Hashing**: Bcrypt encryption for all passwords
- **Data Validation**: All CSV data validated before insertion
- **Permission Based**: Separate permissions for bulk operations
- **Audit Trail**: Detailed logging for bulk operations
- **File Limits**: Upload size limits to prevent abuse