# Version 5.4.7

**Release Date:** August 31, 2025  
**Tags:** BUG FIXES, WEBSOCKET IMPROVEMENTS, LIVE CHAT, UI ENHANCEMENTS

## Fixed

### Live Chat System
- **WebSocket Message Routing**: Fixed messages not reaching handleMessage functions in live chat components
- **Stream Key Mismatch**: Resolved support ticket messages using incorrect routing keys
- **Message Routing**: Enhanced WebSocket manager to handle support ticket message routing properly
- **Message Display**: Fixed "Encountered two children with the same key" React warnings
- **Message IDs**: Corrected message ID generation to use unique message IDs instead of ticket IDs
- **Content Processing**: Fixed messages appearing blank due to incorrect field priority

### Admin Support Interface
- **Auto-Scroll**: Added missing auto-scroll to bottom functionality in admin chat drawer
- **Smooth Scrolling**: Implemented automatic scrolling when new messages arrive
- **Message Visibility**: Enhanced user experience with proper scroll management

## Improved

### WebSocket Management
- **Message Processing**: Optimized WebSocket message routing performance
- **Callback Execution**: Improved performance with cleaner error handling
- **Subscription Management**: Enhanced stream key matching and management
- **Console Logging**: Reduced debug noise while maintaining essential error logging

### Live Chat Experience
- **Message Consistency**: Enhanced message display consistency between user and admin interfaces
- **Real-time Delivery**: Improved message delivery with proper WebSocket routing
- **Conversation Flow**: Added smooth auto-scrolling for better chat experience
- **Duplicate Prevention**: Fixed message duplication issues

### Code Quality
- **Message ID Generation**: Standardized message ID generation across all chat components
- **Content Extraction**: Unified message content extraction logic
- **Type Safety**: Improved type safety in message handling functions
- **Error Handling**: Enhanced error boundaries around WebSocket message processing