# Core v5.5.8

**Release Date:** October 23, 2025
**Tags:** WEBSOCKET IMPROVEMENTS, TRADING INTERFACE, UI IMPROVEMENTS

## Fixed

### Trading Interface

- **Market Switching**: Fixed WebSocket unsubscribe not working when switching markets
- **Data Subscription**: Fixed orderbook and trades not subscribing when switching markets
- **Symbol Switching**: Fixed subscription conflicts when switching between different symbols
- **Locale Preservation**: Fixed locale prefix being removed from URLs (e.g., `/en/trade` changing to `/trade`)
- **Market Type Detection**: Fixed incorrect market type on initial page load
- **URL Parameters**: Fixed URL changing from `type=spot-eco` to `type=spot` on market switch
- **Chart Panel Resize**: Fixed chart panel resize getting stuck when mouse hovers over TradingView chart

## Improved

### WebSocket Performance

- **Subscription Timing**: Improved subscription timing for better user experience
  - New symbol subscribes immediately with no delay
  - Old symbol unsubscribes after 100ms
  - No data gap during market switching
- **Stream Management**: Improved stream availability tracking for instant re-subscription
- **Timer Management**: Improved unsubscribe timer management to prevent cross-symbol interference
