module.exports = [
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * TimeoutError is thrown when an operation times out.
 */ __turbopack_context__.s([
    "TimeoutError",
    ()=>TimeoutError,
    "UserInputValidationError",
    ()=>UserInputValidationError
]);
class TimeoutError extends Error {
    /**
     * Initializes a new TimeoutError instance.
     *
     * @param message - The error message.
     */ constructor(message = "Timeout Error"){
        super(message);
        this.name = "TimeoutError";
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, TimeoutError);
        }
    }
}
class UserInputValidationError extends Error {
    /**
     * Initializes a new UserInputValidationError instance.
     *
     * @param message - The user input validation error message.
     */ constructor(message){
        super(message);
        this.name = "UserInputValidationError";
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, UserInputValidationError);
        }
    }
} //# sourceMappingURL=errors.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/constants.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * The URL to the Coinbase CDP API error docs page.
 */ __turbopack_context__.s([
    "ERROR_DOCS_PAGE_URL",
    ()=>ERROR_DOCS_PAGE_URL,
    "ImportAccountPublicRSAKey",
    ()=>ImportAccountPublicRSAKey
]);
const ERROR_DOCS_PAGE_URL = "https://docs.cdp.coinbase.com/api-reference/v2/errors";
const ImportAccountPublicRSAKey = `-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA2Fxydgm/ryYk0IexQIuL
9DKyiIk2WmS36AZ83a9Z0QX53qdveg08b05g1Qr+o+COoYOT/FDi8anRGAs7rIyS
uigrjHR6VrmFjnGrrTr3MINwC9cYQFHwET8YVGRq+BB3iFTB1kIb9XJ/vT2sk1xP
hJ6JihEwSl4DgbeVjqw59wYqrNg355oa8EdFqkmfGU2tpbM56F8iv1F+shwkGo3y
GhW/UOQ5OLauXvsqo8ranwsK+lqFblLEMlNtn1VSJeO2vMxryeKFrY2ob8VqGchC
ftPJiLWs2Du6juw4C1rOWwSMlXzZ6cNMHkxdTcEHMr3C2TEHgzjZY41whMwNTB8q
/pxXnIbH77caaviRs4R/POe8cSsznalXj85LULvFWOIHp0w+jEYSii9Rp9XtHWAH
nrK/O/SVDtT1ohp2F+Zg1mojTgKfLOyGdOUXTi95naDTuG770rSjHdL80tJBz1Fd
+1pzGTGXGHLZQLX5YZm5iuy2cebWfF09VjIoCIlDB2++tr4M+O0Z1X1ZE0J5Ackq
rOluAFalaKynyH3KMyRg+NuLmibu5OmcMjCLK3D4X1YLiN2OK8/bbpEL8JYroDwb
EXIUW5mGS06YxfSUsxHzL9Tj00+GMm/Gvl0+4/+Vn8IXVHjQOSPNEy3EnqCiH/OW
8v0IMC32CeGrX7mGbU+MzlsCAwEAAQ==
-----END PUBLIC KEY-----`; //# sourceMappingURL=constants.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/errors.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "APIError",
    ()=>APIError,
    "NetworkError",
    ()=>NetworkError,
    "UnknownApiError",
    ()=>UnknownApiError,
    "UnknownError",
    ()=>UnknownError,
    "isOpenAPIError",
    ()=>isOpenAPIError
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/constants.js [app-ssr] (ecmascript)");
;
class APIError extends Error {
    statusCode;
    errorType;
    errorMessage;
    correlationId;
    errorLink;
    /**
     * Constructor for the APIError class
     *
     * @param statusCode - The HTTP status code
     * @param errorType - The type of error
     * @param errorMessage - The error message
     * @param correlationId - The correlation ID
     * @param errorLink - URL to documentation about this error
     * @param cause - The cause of the error
     */ constructor(statusCode, errorType, errorMessage, correlationId, errorLink, cause){
        super(errorMessage, {
            cause
        });
        this.name = "APIError";
        this.statusCode = statusCode;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        // Only set correlationId if it's defined
        if (correlationId !== undefined) {
            this.correlationId = correlationId;
        }
        // Only set errorLink if it's defined
        if (errorLink !== undefined) {
            this.errorLink = errorLink;
        }
    }
    /**
     * Convert the error to a JSON object, excluding undefined properties
     *
     * @returns The error as a JSON object
     */ toJSON() {
        return {
            name: this.name,
            statusCode: this.statusCode,
            errorType: this.errorType,
            errorMessage: this.errorMessage,
            ...this.correlationId && {
                correlationId: this.correlationId
            },
            ...this.errorLink && {
                errorLink: this.errorLink
            }
        };
    }
}
class UnknownApiError extends APIError {
    /**
     * Constructor for the UnknownApiError class
     *
     * @param errorType - The type of error
     * @param errorMessage - The error message
     * @param cause - The cause of the error
     */ constructor(errorType, errorMessage, cause){
        super(0, errorType, errorMessage, undefined, undefined, cause);
        this.name = "UnknownApiError";
    }
}
class UnknownError extends Error {
    /**
     * Constructor for the UnknownError class
     *
     * @param message - The error message
     * @param cause - The cause of the error
     */ constructor(message, cause){
        super(message, {
            cause
        });
        this.name = "UnknownError";
    }
}
class NetworkError extends APIError {
    networkDetails;
    /**
     * Constructor for the NetworkError class
     *
     * @param errorType - The type of network error
     * @param errorMessage - The error message
     * @param networkDetails - Additional network error details
     * @param networkDetails.code - The error code
     * @param networkDetails.message - The error message
     * @param networkDetails.retryable - Whether the error is retryable
     * @param cause - The cause of the error
     */ constructor(errorType, errorMessage, networkDetails, cause){
        super(0, errorType, errorMessage, undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}#network-errors`, cause);
        this.name = "NetworkError";
        this.networkDetails = networkDetails;
    }
    /**
     * Convert the error to a JSON object, including network details
     *
     * @returns The error as a JSON object
     */ toJSON() {
        return {
            ...super.toJSON(),
            ...this.networkDetails && {
                networkDetails: this.networkDetails
            }
        };
    }
}
function isOpenAPIError(obj) {
    return obj !== null && typeof obj === "object" && "errorType" in obj && typeof obj.errorType === "string" && "errorMessage" in obj && typeof obj.errorMessage === "string";
} //# sourceMappingURL=errors.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/version.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "version",
    ()=>version
]);
const version = "1.38.4"; //# sourceMappingURL=version.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Analytics",
    ()=>Analytics
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$md5$40$2$2e$3$2e$0$2f$node_modules$2f$md5$2f$md5$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/md5@2.3.0/node_modules/md5/md5.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$version$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/version.js [app-ssr] (ecmascript)");
;
;
;
;
// This is a public client id for the analytics service
const publicClientId = "54f2ee2fb3d2b901a829940d70fbfc13";
const Analytics = {
    identifier: "",
    wrapClassWithErrorTracking,
    wrapObjectMethodsWithErrorTracking,
    sendEvent,
    trackAction
};
/**
 * Sends an analytics event to the default endpoint
 *
 * @param event - The event data containing event-specific fields
 * @returns Promise that resolves when the event is sent
 */ async function sendEvent(event) {
    if (event.name === "error" && process.env.DISABLE_CDP_ERROR_REPORTING === "true") {
        return;
    }
    if (event.name !== "error" && process.env.DISABLE_CDP_USAGE_TRACKING === "true") {
        return;
    }
    const timestamp = Date.now();
    const enhancedEvent = {
        user_id: Analytics.identifier,
        event_type: event.name,
        platform: "server",
        timestamp,
        event_properties: {
            project_name: "cdp-sdk",
            cdp_sdk_language: "typescript",
            version: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$version$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["version"],
            ...event
        }
    };
    const events = [
        enhancedEvent
    ];
    const stringifiedEventData = JSON.stringify(events);
    const uploadTime = timestamp.toString();
    const checksum = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$md5$40$2$2e$3$2e$0$2f$node_modules$2f$md5$2f$md5$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"])(stringifiedEventData + uploadTime);
    const analyticsServiceData = {
        client: publicClientId,
        e: stringifiedEventData,
        checksum
    };
    const apiEndpoint = "https://cca-lite.coinbase.com";
    const eventPath = "/amp";
    const eventEndPoint = `${apiEndpoint}${eventPath}`;
    await fetch(eventEndPoint, {
        method: "POST",
        mode: "no-cors",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(analyticsServiceData)
    });
}
/**
 * Track an action being performed
 *
 * @param params - The parameters for tracking an action
 * @param params.action - The action being performed
 * @param params.accountType - The type of account
 * @param params.properties - Additional properties
 */ function trackAction(params) {
    if (params.properties?.network && typeof params.properties.network === "string" && params.properties.network.startsWith("http")) {
        const url = new URL(params.properties.network);
        params.properties.customRpcHost = url.hostname;
        params.properties.network = "custom";
    }
    sendEvent({
        action: params.action,
        accountType: params.accountType,
        properties: params.properties,
        name: "action"
    }).catch(()=>{
    // ignore error
    });
}
/**
 * Wraps all methods of a class with error tracking.
 *
 * @param ClassToWrap - The class whose prototype methods should be wrapped.
 */ // eslint-disable-next-line @typescript-eslint/no-explicit-any
function wrapClassWithErrorTracking(ClassToWrap) {
    if (process.env.DISABLE_CDP_ERROR_REPORTING === "true") {
        return;
    }
    const methods = Object.getOwnPropertyNames(ClassToWrap.prototype).filter((name)=>name !== "constructor" && typeof ClassToWrap.prototype[name] === "function");
    for (const method of methods){
        const originalMethod = ClassToWrap.prototype[method];
        ClassToWrap.prototype[method] = async function(...args) {
            try {
                return await originalMethod.apply(this, args);
            } catch (error) {
                if (!shouldTrackError(error)) {
                    throw error;
                }
                const { message, stack } = error;
                sendEvent({
                    method,
                    message,
                    stack,
                    name: "error"
                }).catch(()=>{
                // ignore error
                });
                throw error;
            }
        };
    }
}
/**
 * Wraps all methods of an object with error tracking.
 *
 * @param object - The object whose methods should be wrapped.
 */ // eslint-disable-next-line @typescript-eslint/no-explicit-any
function wrapObjectMethodsWithErrorTracking(object) {
    if (process.env.DISABLE_CDP_ERROR_REPORTING === "true") {
        return;
    }
    const methods = Object.getOwnPropertyNames(object).filter((name)=>name !== "constructor" && typeof object[name] === "function");
    for (const method of methods){
        const originalMethod = object[method];
        object[method] = async function(...args) {
            try {
                return await originalMethod.apply(this, args);
            } catch (error) {
                if (!shouldTrackError(error)) {
                    throw error;
                }
                const { message, stack } = error;
                sendEvent({
                    method,
                    message,
                    stack,
                    name: "error"
                }).catch(()=>{
                // ignore error
                });
                throw error;
            }
        };
    }
}
/**
 * Filters out non-errors and API errors
 *
 * @param error - The error to check.
 * @returns True if the error should be tracked, false otherwise.
 */ function shouldTrackError(error) {
    if (!(error instanceof Error)) {
        return false;
    }
    if (error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]) {
        return false;
    }
    if (error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]) {
        return true;
    }
    if (error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.errorType !== "unexpected_error") {
        return false;
    }
    return true;
} //# sourceMappingURL=analytics.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/bigint.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/* eslint-disable @typescript-eslint/no-explicit-any */ /**
 * Converts bigint values in an object to strings for safe serialization
 *
 * @param obj - The object to convert
 * @returns A new object with bigint values converted to strings
 */ __turbopack_context__.s([
    "convertBigIntsToStrings",
    ()=>convertBigIntsToStrings
]);
const convertBigIntsToStrings = (obj)=>{
    if (typeof obj === "bigint") {
        return obj.toString();
    }
    if (Array.isArray(obj)) {
        return obj.map(convertBigIntsToStrings);
    }
    if (obj && typeof obj === "object") {
        return Object.fromEntries(Object.entries(obj).map(([k, v])=>[
                k,
                convertBigIntsToStrings(v)
            ]));
    }
    return obj;
}; //# sourceMappingURL=bigint.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/hash.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module Hash
 */ __turbopack_context__.s([
    "authHash",
    ()=>authHash
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uncrypto$40$0$2e$1$2e$3$2f$node_modules$2f$uncrypto$2f$dist$2f$crypto$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/uncrypto@0.1.3/node_modules/uncrypto/dist/crypto.node.mjs [app-ssr] (ecmascript)");
;
const authHash = async (data)=>{
    const hashBuffer = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uncrypto$40$0$2e$1$2e$3$2f$node_modules$2f$uncrypto$2f$dist$2f$crypto$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["subtle"].digest("SHA-256", data);
    return Buffer.from(hashBuffer).toString("hex");
}; //# sourceMappingURL=hash.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/sortKeys.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/* eslint-disable @typescript-eslint/no-explicit-any */ /**
 * Recursively sorts object keys to ensure consistent JSON stringification
 *
 * @param obj - The object to sort
 * @returns A new object with sorted keys
 */ __turbopack_context__.s([
    "sortKeys",
    ()=>sortKeys
]);
const sortKeys = (obj)=>{
    if (!obj || typeof obj !== "object") {
        return obj;
    }
    if (Array.isArray(obj)) {
        return obj.map(sortKeys);
    }
    return Object.keys(obj).sort().reduce((acc, key)=>{
        acc[key] = sortKeys(obj[key]);
        return acc;
    }, {});
}; //# sourceMappingURL=sortKeys.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/errors.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module Errors
 */ /**
 * A class of errors for capturing stack traces.
 */ __turbopack_context__.s([
    "InvalidAPIKeyFormatError",
    ()=>InvalidAPIKeyFormatError,
    "InvalidWalletSecretFormatError",
    ()=>InvalidWalletSecretFormatError,
    "UndefinedWalletSecretError",
    ()=>UndefinedWalletSecretError
]);
class BaseError extends Error {
    /**
     * Base error constructor.
     *
     * @param message - The message to display.
     */ constructor(message){
        super(message);
        this.name = this.constructor.name;
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, this.constructor);
        }
    }
}
class InvalidAPIKeyFormatError extends BaseError {
    /**
     * Invalid API key format error constructor.
     *
     * @param message - The message to display.
     */ constructor(message){
        super("Invalid API key format: " + message);
    }
}
class InvalidWalletSecretFormatError extends BaseError {
    /**
     * Invalid Wallet Secret format error constructor.
     *
     * @param message - The message to display.
     */ constructor(message){
        super("Invalid Wallet Secret format: " + message);
    }
}
class UndefinedWalletSecretError extends BaseError {
    /**
     * Undefined Wallet Secret error constructor.
     *
     * @param message - The message to display.
     */ constructor(message){
        super("Undefined Wallet Secret: " + message);
    }
} //# sourceMappingURL=errors.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/jwt.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module JWT
 */ __turbopack_context__.s([
    "generateJwt",
    ()=>generateJwt,
    "generateWalletJwt",
    ()=>generateWalletJwt
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$jwt$2f$sign$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/jose@6.1.0/node_modules/jose/dist/webapi/jwt/sign.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$key$2f$import$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/jose@6.1.0/node_modules/jose/dist/webapi/key/import.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uncrypto$40$0$2e$1$2e$3$2f$node_modules$2f$uncrypto$2f$dist$2f$crypto$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/uncrypto@0.1.3/node_modules/uncrypto/dist/crypto.node.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$hash$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/hash.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$sortKeys$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/sortKeys.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/errors.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
async function generateJwt(options) {
    // Validate required parameters
    if (!options.apiKeyId) {
        throw new Error("Key name is required");
    }
    if (!options.apiKeySecret) {
        throw new Error("Private key is required");
    }
    // Check if we have a REST API request or a websocket connection
    const hasAllRequestParams = Boolean(options.requestMethod && options.requestHost && options.requestPath);
    const hasNoRequestParams = (options.requestMethod === undefined || options.requestMethod === null) && (options.requestHost === undefined || options.requestHost === null) && (options.requestPath === undefined || options.requestPath === null);
    // Ensure we either have all request parameters or none (for websocket)
    if (!hasAllRequestParams && !hasNoRequestParams) {
        throw new Error("Either all request details (method, host, path) must be provided, or all must be null for JWTs intended for websocket connections");
    }
    const now = Math.floor(Date.now() / 1000);
    const expiresIn = options.expiresIn || 120; // Default to 120 seconds if not specified
    // Prepare the JWT payload
    const claims = {
        sub: options.apiKeyId,
        iss: "cdp",
        aud: options.audience || [
            "cdp_service"
        ]
    };
    // Add the uris claim only for REST API requests
    if (hasAllRequestParams) {
        claims.uris = [
            `${options.requestMethod} ${options.requestHost}${options.requestPath}`
        ];
    }
    // Generate random nonce for the header
    const randomNonce = nonce();
    // Determine if we're using EC or Edwards key based on the key format
    if (await isValidECKey(options.apiKeySecret)) {
        return await buildECJWT(options.apiKeySecret, options.apiKeyId, claims, now, expiresIn, randomNonce);
    } else if (isValidEd25519Key(options.apiKeySecret)) {
        return await buildEdwardsJWT(options.apiKeySecret, options.apiKeyId, claims, now, expiresIn, randomNonce);
    } else {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid key format - must be either PEM EC key or base64 Ed25519 key");
    }
}
async function generateWalletJwt(options) {
    if (!options.walletSecret) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UndefinedWalletSecretError"]("Wallet Secret is not defined");
    }
    const uri = `${options.requestMethod} ${options.requestHost}${options.requestPath}`;
    const now = Math.floor(Date.now() / 1000);
    const claims = {
        uris: [
            uri
        ]
    };
    const shouldIncludeReqHash = typeof options.requestData === "object" && Object.keys(options.requestData).length > 0 && Object.values(options.requestData).some((value)=>value !== undefined);
    if (shouldIncludeReqHash) {
        const sortedData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$sortKeys$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sortKeys"])(options.requestData);
        claims.reqHash = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$hash$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["authHash"])(Buffer.from(JSON.stringify(sortedData)));
    }
    try {
        // Convert base64 DER to PEM format for jose
        const derBuffer = Buffer.from(options.walletSecret, "base64");
        const pemKey = `-----BEGIN PRIVATE KEY-----\n${derBuffer.toString("base64").match(/.{1,64}/g)?.join("\n")}\n-----END PRIVATE KEY-----`;
        const ecKey = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$key$2f$import$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["importPKCS8"])(pemKey, "ES256");
        return await new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$jwt$2f$sign$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignJWT"](claims).setProtectedHeader({
            alg: "ES256",
            typ: "JWT"
        }).setIssuedAt(now).setNotBefore(now).setJti(nonce()).sign(ecKey);
    } catch (error) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["InvalidWalletSecretFormatError"]("Could not create the EC key: " + error);
    }
}
/**
 * Determines if a string could be a valid Ed25519 key
 *
 * @param str - The string to test
 * @returns True if the string could be a valid Ed25519 key, false otherwise
 */ function isValidEd25519Key(str) {
    try {
        const decoded = Buffer.from(str, "base64");
        return decoded.length === 64;
    } catch  {
        return false;
    }
}
/**
 * Determines if a string is a valid EC private key in PEM format
 *
 * @param str - The string to test
 * @returns True if the string is a valid EC private key in PEM format
 */ async function isValidECKey(str) {
    try {
        // Try to import the key with jose - if it works, it's a valid EC key
        await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$key$2f$import$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["importPKCS8"])(str, "ES256");
        return true;
    } catch  {
        return false;
    }
}
/**
 * Builds a JWT using an EC key.
 *
 * @param privateKey - The EC private key in PEM format
 * @param keyName - The key name/ID
 * @param claims - The JWT claims
 * @param now - Current timestamp in seconds
 * @param expiresIn - Number of seconds until the token expires
 * @param nonce - Random nonce for the JWT header
 * @returns A JWT token signed with an EC key
 * @throws {Error} If key conversion, import, or signing fails
 */ async function buildECJWT(privateKey, keyName, claims, now, expiresIn, nonce) {
    try {
        // Import the key directly with jose
        const ecKey = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$key$2f$import$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["importPKCS8"])(privateKey, "ES256");
        // Sign and return the JWT
        return await new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$jwt$2f$sign$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignJWT"](claims).setProtectedHeader({
            alg: "ES256",
            kid: keyName,
            typ: "JWT",
            nonce
        }).setIssuedAt(Math.floor(now)).setNotBefore(Math.floor(now)).setExpirationTime(Math.floor(now + expiresIn)).sign(ecKey);
    } catch (error) {
        throw new Error(`Failed to generate EC JWT: ${error.message}`);
    }
}
/**
 * Builds a JWT using an Ed25519 key.
 *
 * @param privateKey - The Ed25519 private key in base64 format
 * @param keyName - The key name/ID
 * @param claims - The JWT claims
 * @param now - Current timestamp in seconds
 * @param expiresIn - Number of seconds until the token expires
 * @param nonce - Random nonce for the JWT header
 * @returns A JWT token using an Ed25519 key
 * @throws {Error} If key parsing, import, or signing fails
 */ async function buildEdwardsJWT(privateKey, keyName, claims, now, expiresIn, nonce) {
    try {
        // Decode the base64 key (expecting 64 bytes: 32 for seed + 32 for public key)
        const decoded = Buffer.from(privateKey, "base64");
        if (decoded.length !== 64) {
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid Ed25519 key length");
        }
        const seed = decoded.subarray(0, 32);
        const publicKey = decoded.subarray(32);
        // Create JWK from the key components
        const jwk = {
            kty: "OKP",
            crv: "Ed25519",
            d: seed.toString("base64url"),
            x: publicKey.toString("base64url")
        };
        // Import the key for signing
        const key = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$key$2f$import$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["importJWK"])(jwk, "EdDSA");
        // Sign and return the JWT
        return await new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$jose$40$6$2e$1$2e$0$2f$node_modules$2f$jose$2f$dist$2f$webapi$2f$jwt$2f$sign$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignJWT"](claims).setProtectedHeader({
            alg: "EdDSA",
            kid: keyName,
            typ: "JWT",
            nonce
        }).setIssuedAt(Math.floor(now)).setNotBefore(Math.floor(now)).setExpirationTime(Math.floor(now + expiresIn)).sign(key);
    } catch (error) {
        throw new Error(`Failed to generate Ed25519 JWT: ${error.message}`);
    }
}
/**
 * Generates a random nonce for the JWT.
 *
 * @returns {string} The generated nonce.
 */ function nonce() {
    const bytes = new Uint8Array(16);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uncrypto$40$0$2e$1$2e$3$2f$node_modules$2f$uncrypto$2f$dist$2f$crypto$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getRandomValues"])(bytes);
    return Buffer.from(bytes).toString("hex");
} //# sourceMappingURL=jwt.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/http.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module HTTP
 */ __turbopack_context__.s([
    "getAuthHeaders",
    ()=>getAuthHeaders,
    "getCorrelationData",
    ()=>getCorrelationData
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$jwt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/jwt.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$version$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/version.js [app-ssr] (ecmascript)");
;
;
async function getAuthHeaders(options) {
    const headers = {};
    // Generate and add JWT token
    const jwt = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$jwt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["generateJwt"])({
        apiKeyId: options.apiKeyId,
        apiKeySecret: options.apiKeySecret,
        requestMethod: options.requestMethod,
        requestHost: options.requestHost,
        requestPath: options.requestPath,
        expiresIn: options.expiresIn,
        audience: options.audience
    });
    headers["Authorization"] = `Bearer ${jwt}`;
    headers["Content-Type"] = "application/json";
    // Add wallet auth if needed
    if (requiresWalletAuth(options.requestMethod, options.requestPath)) {
        if (!options.walletSecret) {
            throw new Error("Wallet Secret not configured. Please set the CDP_WALLET_SECRET environment variable, or pass it as an option to the CdpClient constructor.");
        }
        const walletAuthToken = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$jwt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["generateWalletJwt"])({
            walletSecret: options.walletSecret,
            requestMethod: options.requestMethod,
            requestHost: options.requestHost,
            requestPath: options.requestPath,
            requestData: options.requestBody || {}
        });
        headers["X-Wallet-Auth"] = walletAuthToken;
    }
    // Add correlation data
    headers["Correlation-Context"] = getCorrelationData(options.source, options.sourceVersion);
    return headers;
}
/**
 * Returns true if the request indicated by the method and URL requires wallet authentication.
 *
 * @param requestMethod - The HTTP method of the request
 * @param requestPath - The URL path of the request
 * @returns True if the request requires wallet authentication, false otherwise
 */ function requiresWalletAuth(requestMethod, requestPath) {
    return (requestPath?.includes("/accounts") || requestPath?.includes("/spend-permissions")) && (requestMethod === "POST" || requestMethod === "DELETE" || requestMethod === "PUT");
}
function getCorrelationData(source, sourceVersion) {
    const data = {
        sdk_version: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$version$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["version"],
        sdk_language: "typescript",
        source: source || "sdk-auth"
    };
    if (sourceVersion) {
        data["source_version"] = sourceVersion;
    }
    return Object.keys(data).map((key)=>`${key}=${encodeURIComponent(data[key])}`).join(",");
} //# sourceMappingURL=http.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/hooks/axios/withAuth.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module Axios
 */ __turbopack_context__.s([
    "withAuth",
    ()=>withAuth
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/axios@1.13.1/node_modules/axios/index.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$bigint$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/bigint.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/http.js [app-ssr] (ecmascript)");
;
;
;
function withAuth(axiosClient, options) {
    axiosClient.interceptors.request.use(async (axiosConfig)=>{
        const method = axiosConfig.method?.toString().toUpperCase() || "GET";
        if (!axiosConfig.url) {
            throw new Error("URL is required for authentication");
        }
        const fullyQualifiedURL = axiosClient.getUri() + axiosConfig.url;
        // Parse URL to get host and path
        const url = new URL(fullyQualifiedURL);
        // Convert bigints in request body to strings for safe serialization
        if (axiosConfig.data) {
            axiosConfig.data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$bigint$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["convertBigIntsToStrings"])(axiosConfig.data);
        }
        // Get authentication headers
        const headers = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getAuthHeaders"])({
            apiKeyId: options.apiKeyId,
            apiKeySecret: options.apiKeySecret,
            requestMethod: method,
            requestHost: url.host,
            requestPath: url.pathname,
            requestBody: axiosConfig.data,
            walletSecret: options.walletSecret,
            source: options.source,
            sourceVersion: options.sourceVersion,
            expiresIn: options.expiresIn
        });
        // Add headers to request config
        axiosConfig.headers = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["AxiosHeaders"]({
            ...axiosConfig.headers,
            ...headers
        });
        if (options.debug) {
            // eslint-disable-next-line no-console
            console.log("Request:", {
                method,
                url: fullyQualifiedURL,
                headers: axiosConfig.headers,
                data: axiosConfig.data
            });
        }
        return axiosConfig;
    });
    if (options.debug) {
        axiosClient.interceptors.response.use((response)=>{
            // eslint-disable-next-line no-console
            console.log("Response:", {
                status: response.status,
                statusText: response.statusText,
                headers: response.headers,
                data: response.data
            });
            return response;
        }, (error)=>{
            // Ensure we have access to the error response details
            const errorDetails = {
                status: error.response?.status,
                statusText: error.response?.statusText,
                headers: error.response?.headers,
                data: error.response?.data,
                message: error.message,
                cause: error.cause
            };
            // eslint-disable-next-line no-console
            console.error("Response Error:", errorDetails);
            return Promise.reject(error);
        });
    }
    return axiosClient;
} //# sourceMappingURL=withAuth.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// eslint-disable-next-line import/no-named-as-default
__turbopack_context__.s([
    "cdpApiClient",
    ()=>cdpApiClient,
    "config",
    ()=>config,
    "configure",
    ()=>configure
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/axios@1.13.1/node_modules/axios/lib/axios.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$2d$retry$40$4$2e$5$2e$0_axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2d$retry$2f$dist$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/axios-retry@4.5.0_axios@1.13.1/node_modules/axios-retry/dist/esm/index.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$hooks$2f$axios$2f$withAuth$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/hooks/axios/withAuth.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/constants.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/errors.js [app-ssr] (ecmascript)");
;
;
;
;
;
let axiosInstance;
let config = undefined;
const configure = (options)=>{
    const baseURL = options.basePath || "https://api.cdp.coinbase.com/platform";
    config = {
        ...options,
        basePath: baseURL
    };
    axiosInstance = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].create({
        baseURL
    });
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$2d$retry$40$4$2e$5$2e$0_axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2d$retry$2f$dist$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"])(axiosInstance, {
        retryDelay: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$2d$retry$40$4$2e$5$2e$0_axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2d$retry$2f$dist$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["exponentialDelay"]
    });
    axiosInstance = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$hooks$2f$axios$2f$withAuth$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["withAuth"])(axiosInstance, {
        apiKeyId: options.apiKeyId,
        apiKeySecret: options.apiKeySecret,
        source: options.source || "sdk-openapi-client",
        sourceVersion: options.sourceVersion,
        walletSecret: options.walletSecret,
        expiresIn: options.expiresIn,
        debug: options.debugging
    });
};
/**
 * Adds an idempotency key to request config if provided
 *
 * @param config - The Axios request configuration.
 * @param idempotencyKey - The idempotency key.
 * @returns The Axios request configuration with the idempotency key.
 */ const addIdempotencyKey = (config, idempotencyKey)=>{
    if (!idempotencyKey) {
        return config;
    }
    return {
        ...config,
        headers: {
            ...config.headers || {},
            "X-Idempotency-Key": idempotencyKey
        }
    };
};
const cdpApiClient = async (config, idempotencyKey)=>{
    validateCall(config);
    // Add idempotency key to the request headers if provided
    const configWithIdempotencyKey = addIdempotencyKey(config, idempotencyKey);
    try {
        const response = await axiosInstance(configWithIdempotencyKey);
        return response.data;
    } catch (error) {
        // eslint-disable-next-line import/no-named-as-default-member
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].isAxiosError(error) && !error.response) {
            // Network-level errors (no response received)
            const errorMessage = (error.message || "").toLowerCase();
            const errorCode = error.code?.toLowerCase();
            // Categorize network errors based on error messages and codes
            if (errorCode === "econnrefused" || errorMessage.includes("connection refused")) {
                throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]("network_connection_failed", "Unable to connect to CDP service. The service may be unavailable.", {
                    code: error.code,
                    message: error.message,
                    retryable: true
                }, error.cause);
            } else if (errorCode === "etimedout" || errorCode === "econnaborted" || errorMessage.includes("timeout")) {
                throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]("network_timeout", "Request timed out. Please try again.", {
                    code: error.code,
                    message: error.message,
                    retryable: true
                }, error.cause);
            } else if (errorCode === "enotfound" || errorMessage.includes("getaddrinfo")) {
                throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]("network_dns_failure", "DNS resolution failed. Please check your network connection.", {
                    code: error.code,
                    message: error.message,
                    retryable: false
                }, error.cause);
            } else if (errorMessage.includes("network error") || errorMessage.includes("econnreset")) {
                throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]("network_connection_failed", "Network error occurred. Please check your connection and try again.", {
                    code: error.code,
                    message: error.message,
                    retryable: true
                }, error.cause);
            } else {
                // Generic network error
                throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]("unknown", error.cause instanceof Error ? error.cause.message : error.message, {
                    code: error.code,
                    message: error.message,
                    retryable: true
                }, error.cause);
            }
        }
        // eslint-disable-next-line import/no-named-as-default-member
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$axios$40$1$2e$13$2e$1$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].isAxiosError(error) && error.response) {
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isOpenAPIError"])(error.response.data)) {
                throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](error.response.status, error.response.data.errorType, error.response.data.errorMessage, error.response.data.correlationId, error.response.data.errorLink, error.cause);
            } else {
                const statusCode = error.response.status;
                const responseData = error.response.data;
                // Check for gateway-level errors that might indicate network issues
                const isGatewayError = responseData && typeof responseData === "string" && (responseData.toLowerCase().includes("forbidden") || responseData.toLowerCase().includes("ip") || responseData.toLowerCase().includes("blocked") || responseData.toLowerCase().includes("gateway"));
                switch(statusCode){
                    case 401:
                        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](statusCode, "unauthorized", "Unauthorized.", undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}#unauthorized`, error.cause);
                    case 403:
                        // Special handling for IP blocklist and other gateway-level 403s
                        if (isGatewayError) {
                            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NetworkError"]("network_ip_blocked", "Access denied. Your IP address may be blocked or restricted.", {
                                code: "IP_BLOCKED",
                                message: typeof responseData === "string" ? responseData : JSON.stringify(responseData),
                                retryable: false
                            }, error.cause);
                        }
                        // Regular 403 forbidden error
                        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](statusCode, "unauthorized", "Forbidden. You don't have permission to access this resource.", undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}#forbidden`, error.cause);
                    case 404:
                        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](statusCode, "not_found", "API not found.", undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}#not_found`, error.cause);
                    case 502:
                        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](statusCode, "bad_gateway", "Bad gateway.", undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}`, error.cause);
                    case 503:
                        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](statusCode, "service_unavailable", "Service unavailable. Please try again later.", undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}`, error.cause);
                    default:
                        {
                            let errorText = "";
                            if (error.response.data) {
                                try {
                                    errorText = JSON.stringify(error.response.data);
                                } catch  {
                                    errorText = String(error.response.data);
                                }
                            }
                            const errorMessage = errorText ? `An unexpected error occurred: ${errorText}` : "An unexpected error occurred.";
                            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"](statusCode, "unexpected_error", errorMessage, undefined, `${__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ERROR_DOCS_PAGE_URL"]}`, error.cause);
                        }
                }
            }
        }
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UnknownError"]("Something went wrong. Please reach out at https://discord.com/channels/1220414409550336183/1271495764580896789 for help.", error instanceof Error ? error : undefined);
    }
};
/**
 * Validates the call to the cdpApiClient.
 *
 * @param {AxiosRequestConfig} config - The Axios request configuration.
 * @throws {Error} If the call is not valid.
 */ const validateCall = (config)=>{
    if (!axiosInstance.getUri() || axiosInstance.getUri() === "") {
        throw new Error("CDP client URI not configured. Call configure() first.");
    }
    if (!config.url || config.url === "") {
        throw new Error("AxiosRequestConfig URL is empty. This should never happen.");
    }
    if (!config.method || config.method === "") {
        throw new Error("AxiosRequestConfig method is empty. This should never happen.");
    }
}; //# sourceMappingURL=cdpApiClient.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/end-user-accounts/end-user-accounts.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "validateEndUserAccessToken",
    ()=>validateEndUserAccessToken
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const validateEndUserAccessToken = (validateEndUserAccessTokenBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/end-users/auth/validate-token`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: validateEndUserAccessTokenBody
    }, options);
}; //# sourceMappingURL=end-user-accounts.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-accounts/evm-accounts.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createEvmAccount",
    ()=>createEvmAccount,
    "exportEvmAccount",
    ()=>exportEvmAccount,
    "exportEvmAccountByName",
    ()=>exportEvmAccountByName,
    "getEvmAccount",
    ()=>getEvmAccount,
    "getEvmAccountByName",
    ()=>getEvmAccountByName,
    "importEvmAccount",
    ()=>importEvmAccount,
    "listEvmAccounts",
    ()=>listEvmAccounts,
    "sendEvmTransaction",
    ()=>sendEvmTransaction,
    "signEvmHash",
    ()=>signEvmHash,
    "signEvmMessage",
    ()=>signEvmMessage,
    "signEvmTransaction",
    ()=>signEvmTransaction,
    "signEvmTypedData",
    ()=>signEvmTypedData,
    "updateEvmAccount",
    ()=>updateEvmAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listEvmAccounts = (params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts`,
        method: "GET",
        params
    }, options);
};
const createEvmAccount = (createEvmAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createEvmAccountBody
    }, options);
};
const getEvmAccount = (address, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}`,
        method: "GET"
    }, options);
};
const updateEvmAccount = (address, updateEvmAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}`,
        method: "PUT",
        headers: {
            "Content-Type": "application/json"
        },
        data: updateEvmAccountBody
    }, options);
};
const getEvmAccountByName = (name, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/by-name/${name}`,
        method: "GET"
    }, options);
};
const sendEvmTransaction = (address, sendEvmTransactionBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}/send/transaction`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: sendEvmTransactionBody
    }, options);
};
const signEvmTransaction = (address, signEvmTransactionBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}/sign/transaction`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: signEvmTransactionBody
    }, options);
};
const signEvmHash = (address, signEvmHashBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}/sign`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: signEvmHashBody
    }, options);
};
const signEvmMessage = (address, signEvmMessageBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}/sign/message`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: signEvmMessageBody
    }, options);
};
const signEvmTypedData = (address, eIP712Message, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}/sign/typed-data`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: eIP712Message
    }, options);
};
const importEvmAccount = (importEvmAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/import`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: importEvmAccountBody
    }, options);
};
const exportEvmAccount = (address, exportEvmAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/${address}/export`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: exportEvmAccountBody
    }, options);
};
const exportEvmAccountByName = (name, exportEvmAccountByNameBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/accounts/export/by-name/${name}`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: exportEvmAccountByNameBody
    }, options);
}; //# sourceMappingURL=evm-accounts.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-smart-accounts/evm-smart-accounts.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createEvmSmartAccount",
    ()=>createEvmSmartAccount,
    "createSpendPermission",
    ()=>createSpendPermission,
    "getEvmSmartAccount",
    ()=>getEvmSmartAccount,
    "getEvmSmartAccountByName",
    ()=>getEvmSmartAccountByName,
    "getUserOperation",
    ()=>getUserOperation,
    "listEvmSmartAccounts",
    ()=>listEvmSmartAccounts,
    "listSpendPermissions",
    ()=>listSpendPermissions,
    "prepareUserOperation",
    ()=>prepareUserOperation,
    "revokeSpendPermission",
    ()=>revokeSpendPermission,
    "sendUserOperation",
    ()=>sendUserOperation,
    "updateEvmSmartAccount",
    ()=>updateEvmSmartAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listEvmSmartAccounts = (params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts`,
        method: "GET",
        params
    }, options);
};
const createEvmSmartAccount = (createEvmSmartAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createEvmSmartAccountBody
    }, options);
};
const getEvmSmartAccountByName = (name, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/by-name/${name}`,
        method: "GET"
    }, options);
};
const getEvmSmartAccount = (address, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}`,
        method: "GET"
    }, options);
};
const updateEvmSmartAccount = (address, updateEvmSmartAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}`,
        method: "PUT",
        headers: {
            "Content-Type": "application/json"
        },
        data: updateEvmSmartAccountBody
    }, options);
};
const prepareUserOperation = (address, prepareUserOperationBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}/user-operations`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: prepareUserOperationBody
    }, options);
};
const getUserOperation = (address, userOpHash, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}/user-operations/${userOpHash}`,
        method: "GET"
    }, options);
};
const sendUserOperation = (address, userOpHash, sendUserOperationBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}/user-operations/${userOpHash}/send`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: sendUserOperationBody
    }, options);
};
const createSpendPermission = (address, createSpendPermissionRequest, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}/spend-permissions`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createSpendPermissionRequest
    }, options);
};
const listSpendPermissions = (address, params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}/spend-permissions/list`,
        method: "GET",
        params
    }, options);
};
const revokeSpendPermission = (address, revokeSpendPermissionRequest, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/smart-accounts/${address}/spend-permissions/revoke`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: revokeSpendPermissionRequest
    }, options);
}; //# sourceMappingURL=evm-smart-accounts.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-swaps/evm-swaps.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createEvmSwapQuote",
    ()=>createEvmSwapQuote,
    "getEvmSwapPrice",
    ()=>getEvmSwapPrice
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const getEvmSwapPrice = (params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/swaps/quote`,
        method: "GET",
        params
    }, options);
};
const createEvmSwapQuote = (createEvmSwapQuoteBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/swaps`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createEvmSwapQuoteBody
    }, options);
}; //# sourceMappingURL=evm-swaps.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-token-balances/evm-token-balances.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "listEvmTokenBalances",
    ()=>listEvmTokenBalances
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listEvmTokenBalances = (network, address, params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/token-balances/${network}/${address}`,
        method: "GET",
        params
    }, options);
}; //# sourceMappingURL=evm-token-balances.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/faucets/faucets.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "requestEvmFaucet",
    ()=>requestEvmFaucet,
    "requestSolanaFaucet",
    ()=>requestSolanaFaucet
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const requestEvmFaucet = (requestEvmFaucetBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/evm/faucet`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: requestEvmFaucetBody
    }, options);
};
const requestSolanaFaucet = (requestSolanaFaucetBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/faucet`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: requestSolanaFaucetBody
    }, options);
}; //# sourceMappingURL=faucets.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/onchain-data/onchain-data.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "listDataTokenBalances",
    ()=>listDataTokenBalances,
    "listTokensForAccount",
    ()=>listTokensForAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listTokensForAccount = (network, address, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/data/evm/token-ownership/${network}/${address}`,
        method: "GET"
    }, options);
};
const listDataTokenBalances = (network, address, params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/data/evm/token-balances/${network}/${address}`,
        method: "GET",
        params
    }, options);
}; //# sourceMappingURL=onchain-data.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/payments-alpha/payments-alpha.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createPaymentTransferQuote",
    ()=>createPaymentTransferQuote,
    "executePaymentTransferQuote",
    ()=>executePaymentTransferQuote,
    "getCryptoRails",
    ()=>getCryptoRails,
    "getPaymentMethods",
    ()=>getPaymentMethods,
    "getPaymentTransfer",
    ()=>getPaymentTransfer
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const getPaymentMethods = (options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/payments/rails/payment-methods`,
        method: "GET"
    }, options);
};
const getCryptoRails = (params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/payments/rails/crypto`,
        method: "GET",
        params
    }, options);
};
const createPaymentTransferQuote = (createPaymentTransferQuoteBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/payments/transfers`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createPaymentTransferQuoteBody
    }, options);
};
const executePaymentTransferQuote = (transferId, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/payments/transfers/${transferId}/execute`,
        method: "POST"
    }, options);
};
const getPaymentTransfer = (transferId, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/payments/transfers/${transferId}`,
        method: "GET"
    }, options);
}; //# sourceMappingURL=payments-alpha.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/policy-engine/policy-engine.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createPolicy",
    ()=>createPolicy,
    "deletePolicy",
    ()=>deletePolicy,
    "getPolicyById",
    ()=>getPolicyById,
    "listPolicies",
    ()=>listPolicies,
    "updatePolicy",
    ()=>updatePolicy
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listPolicies = (params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/policy-engine/policies`,
        method: "GET",
        params
    }, options);
};
const createPolicy = (createPolicyBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/policy-engine/policies`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createPolicyBody
    }, options);
};
const getPolicyById = (policyId, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/policy-engine/policies/${policyId}`,
        method: "GET"
    }, options);
};
const deletePolicy = (policyId, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/policy-engine/policies/${policyId}`,
        method: "DELETE"
    }, options);
};
const updatePolicy = (policyId, updatePolicyBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/policy-engine/policies/${policyId}`,
        method: "PUT",
        headers: {
            "Content-Type": "application/json"
        },
        data: updatePolicyBody
    }, options);
}; //# sourceMappingURL=policy-engine.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/solana-accounts/solana-accounts.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createSolanaAccount",
    ()=>createSolanaAccount,
    "exportSolanaAccount",
    ()=>exportSolanaAccount,
    "exportSolanaAccountByName",
    ()=>exportSolanaAccountByName,
    "getSolanaAccount",
    ()=>getSolanaAccount,
    "getSolanaAccountByName",
    ()=>getSolanaAccountByName,
    "importSolanaAccount",
    ()=>importSolanaAccount,
    "listSolanaAccounts",
    ()=>listSolanaAccounts,
    "sendSolanaTransaction",
    ()=>sendSolanaTransaction,
    "signSolanaMessage",
    ()=>signSolanaMessage,
    "signSolanaTransaction",
    ()=>signSolanaTransaction,
    "updateSolanaAccount",
    ()=>updateSolanaAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listSolanaAccounts = (params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts`,
        method: "GET",
        params
    }, options);
};
const createSolanaAccount = (createSolanaAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: createSolanaAccountBody
    }, options);
};
const getSolanaAccount = (address, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/${address}`,
        method: "GET"
    }, options);
};
const updateSolanaAccount = (address, updateSolanaAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/${address}`,
        method: "PUT",
        headers: {
            "Content-Type": "application/json"
        },
        data: updateSolanaAccountBody
    }, options);
};
const getSolanaAccountByName = (name, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/by-name/${name}`,
        method: "GET"
    }, options);
};
const importSolanaAccount = (importSolanaAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/import`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: importSolanaAccountBody
    }, options);
};
const exportSolanaAccount = (address, exportSolanaAccountBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/${address}/export`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: exportSolanaAccountBody
    }, options);
};
const exportSolanaAccountByName = (name, exportSolanaAccountByNameBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/export/by-name/${name}`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: exportSolanaAccountByNameBody
    }, options);
};
const signSolanaTransaction = (address, signSolanaTransactionBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/${address}/sign/transaction`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: signSolanaTransactionBody
    }, options);
};
const signSolanaMessage = (address, signSolanaMessageBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/${address}/sign/message`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: signSolanaMessageBody
    }, options);
};
const sendSolanaTransaction = (sendSolanaTransactionBody, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/accounts/send/transaction`,
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        data: sendSolanaTransactionBody
    }, options);
}; //# sourceMappingURL=solana-accounts.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/solana-token-balances/solana-token-balances.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "listSolanaTokenBalances",
    ()=>listSolanaTokenBalances
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
const listSolanaTokenBalances = (network, address, params, options)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cdpApiClient"])({
        url: `/v2/solana/token-balances/${network}/${address}`,
        method: "GET",
        params
    }, options);
}; //# sourceMappingURL=solana-token-balances.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/index.js [app-ssr] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "CdpOpenApiClient",
    ()=>CdpOpenApiClient,
    "OpenApiEvmMethods",
    ()=>OpenApiEvmMethods,
    "OpenApiPoliciesMethods",
    ()=>OpenApiPoliciesMethods,
    "OpenApiSolanaMethods",
    ()=>OpenApiSolanaMethods
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$end$2d$user$2d$accounts$2f$end$2d$user$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/end-user-accounts/end-user-accounts.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$accounts$2f$evm$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-accounts/evm-accounts.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$smart$2d$accounts$2f$evm$2d$smart$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-smart-accounts/evm-smart-accounts.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$swaps$2f$evm$2d$swaps$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-swaps/evm-swaps.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$token$2d$balances$2f$evm$2d$token$2d$balances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/evm-token-balances/evm-token-balances.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$faucets$2f$faucets$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/faucets/faucets.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$onchain$2d$data$2f$onchain$2d$data$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/onchain-data/onchain-data.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$payments$2d$alpha$2f$payments$2d$alpha$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/payments-alpha/payments-alpha.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$policy$2d$engine$2f$policy$2d$engine$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/policy-engine/policy-engine.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$solana$2d$accounts$2f$solana$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/solana-accounts/solana-accounts.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$solana$2d$token$2d$balances$2f$solana$2d$token$2d$balances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/solana-token-balances/solana-token-balances.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
const CdpOpenApiClient = {
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$accounts$2f$evm$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$smart$2d$accounts$2f$evm$2d$smart$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$swaps$2f$evm$2d$swaps$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$token$2d$balances$2f$evm$2d$token$2d$balances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$solana$2d$accounts$2f$solana$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$solana$2d$token$2d$balances$2f$solana$2d$token$2d$balances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$faucets$2f$faucets$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$onchain$2d$data$2f$onchain$2d$data$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$policy$2d$engine$2f$policy$2d$engine$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$payments$2d$alpha$2f$payments$2d$alpha$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$end$2d$user$2d$accounts$2f$end$2d$user$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    configure: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["configure"]
};
const OpenApiEvmMethods = {
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$accounts$2f$evm$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$smart$2d$accounts$2f$evm$2d$smart$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$swaps$2f$evm$2d$swaps$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$evm$2d$token$2d$balances$2f$evm$2d$token$2d$balances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    requestEvmFaucet: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$faucets$2f$faucets$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.requestEvmFaucet
};
const OpenApiSolanaMethods = {
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$solana$2d$accounts$2f$solana$2d$accounts$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__,
    requestSolanaFaucet: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$faucets$2f$faucets$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.requestSolanaFaucet
};
const OpenApiPoliciesMethods = {
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$policy$2d$engine$2f$policy$2d$engine$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__
}; //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/end-user/endUser.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "CDPEndUserClient",
    ()=>CDPEndUserClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/index.js [app-ssr] (ecmascript) <locals>");
;
;
class CDPEndUserClient {
    /**
     * Validates an end user's access token. Throws an error if the access token is invalid.
     *
     * @param options - The options for validating an access token.
     *
     * @returns The end user object if the access token is valid.
     */ async validateAccessToken(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "validate_access_token"
        });
        const { accessToken } = options;
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].validateEndUserAccessToken({
            accessToken
        });
    }
} //# sourceMappingURL=endUser.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/chainToNetworkMapper.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Maps a viem chain to a Coinbase network identifier.
 * This function only supports the networks defined in KnownEvmNetworks.
 *
 * @param chain - The viem chain object
 * @returns The Coinbase network identifier, or undefined if the chain is not supported
 */ __turbopack_context__.s([
    "mapChainToNetwork",
    ()=>mapChainToNetwork
]);
function mapChainToNetwork(chain) {
    // Map chain IDs to Coinbase network identifiers
    const chainIdToNetwork = {
        // Ethereum networks
        1: "ethereum",
        11155111: "ethereum-sepolia",
        17000: "ethereum-hoodi",
        // Base networks
        8453: "base",
        84532: "base-sepolia",
        // Polygon networks
        137: "polygon",
        80001: "polygon-mumbai",
        // Arbitrum networks
        42161: "arbitrum",
        421614: "arbitrum-sepolia",
        // Optimism networks
        10: "optimism",
        11155420: "optimism-sepolia"
    };
    return chainIdToNetwork[chain.id];
} //# sourceMappingURL=chainToNetworkMapper.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/networkCapabilities.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Centralized configuration for network capabilities.
 * This defines which methods are available on which networks.
 */ /**
 * Network capabilities configuration.
 * Each network has a set of boolean flags indicating which methods are supported.
 */ __turbopack_context__.s([
    "NETWORK_CAPABILITIES",
    ()=>NETWORK_CAPABILITIES,
    "getNetworksSupportingMethod",
    ()=>getNetworksSupportingMethod,
    "isMethodSupportedOnNetwork",
    ()=>isMethodSupportedOnNetwork
]);
const NETWORK_CAPABILITIES = {
    base: {
        listTokenBalances: true,
        requestFaucet: false,
        quoteFund: true,
        fund: true,
        waitForFundOperationReceipt: true,
        transfer: true,
        sendTransaction: true,
        quoteSwap: true,
        swap: true,
        useSpendPermission: true
    },
    "base-sepolia": {
        listTokenBalances: true,
        requestFaucet: true,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: true,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    ethereum: {
        listTokenBalances: true,
        requestFaucet: false,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: true,
        sendTransaction: true,
        quoteSwap: true,
        swap: true,
        useSpendPermission: true
    },
    "ethereum-sepolia": {
        listTokenBalances: false,
        requestFaucet: true,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: true,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    "ethereum-hoodi": {
        listTokenBalances: false,
        requestFaucet: true,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: false
    },
    optimism: {
        listTokenBalances: false,
        requestFaucet: false,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: true,
        swap: true,
        useSpendPermission: true
    },
    "optimism-sepolia": {
        listTokenBalances: false,
        requestFaucet: true,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    arbitrum: {
        listTokenBalances: false,
        requestFaucet: true,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: true,
        swap: true,
        useSpendPermission: true
    },
    "arbitrum-sepolia": {
        listTokenBalances: false,
        requestFaucet: true,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    avalanche: {
        listTokenBalances: false,
        requestFaucet: false,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    binance: {
        listTokenBalances: false,
        requestFaucet: false,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    polygon: {
        listTokenBalances: false,
        requestFaucet: false,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    },
    zora: {
        listTokenBalances: false,
        requestFaucet: false,
        quoteFund: false,
        fund: false,
        waitForFundOperationReceipt: false,
        transfer: false,
        sendTransaction: true,
        quoteSwap: false,
        swap: false,
        useSpendPermission: true
    }
};
function getNetworksSupportingMethod(method) {
    return Object.keys(NETWORK_CAPABILITIES).filter((network)=>NETWORK_CAPABILITIES[network][method]);
}
function isMethodSupportedOnNetwork(method, network) {
    const networkConfig = NETWORK_CAPABILITIES[network];
    return networkConfig ? networkConfig[method] : false;
} //# sourceMappingURL=networkCapabilities.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/getBaseNodeRpcUrl.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getBaseNodeRpcUrl",
    ()=>getBaseNodeRpcUrl
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$jwt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/auth/utils/jwt.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/cdpApiClient.js [app-ssr] (ecmascript)");
;
;
async function getBaseNodeRpcUrl(network) {
    if (!__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["config"]) {
        return;
    }
    try {
        const basePath = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["config"].basePath?.replace("/platform", "");
        const jwt = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$auth$2f$utils$2f$jwt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["generateJwt"])({
            apiKeyId: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["config"].apiKeyId,
            apiKeySecret: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$cdpApiClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["config"].apiKeySecret,
            requestMethod: "GET",
            requestHost: basePath.replace("https://", ""),
            requestPath: "/apikeys/v1/tokens/active"
        });
        const response = await fetch(`${basePath}/apikeys/v1/tokens/active`, {
            headers: {
                Authorization: `Bearer ${jwt}`,
                "Content-Type": "application/json"
            }
        });
        const json = await response.json();
        return `${basePath}/rpc/v1/${network}/${json.id}`;
    } catch  {
        return;
    }
} //# sourceMappingURL=getBaseNodeRpcUrl.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/networkToChainResolver.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "NETWORK_TO_CHAIN_MAP",
    ()=>NETWORK_TO_CHAIN_MAP,
    "resolveNetworkToChain",
    ()=>resolveNetworkToChain
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/base.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/baseSepolia.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/mainnet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/sepolia.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/polygon.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygonMumbai$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/polygonMumbai.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/arbitrum.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrumSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/arbitrumSepolia.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/optimism.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimismSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/optimismSepolia.js [app-ssr] (ecmascript)");
;
const NETWORK_TO_CHAIN_MAP = {
    base: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["base"],
    "base-sepolia": __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["baseSepolia"],
    ethereum: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mainnet"],
    "ethereum-sepolia": __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sepolia"],
    polygon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["polygon"],
    "polygon-mumbai": __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygonMumbai$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["polygonMumbai"],
    arbitrum: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["arbitrum"],
    "arbitrum-sepolia": __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrumSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["arbitrumSepolia"],
    optimism: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["optimism"],
    "optimism-sepolia": __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimismSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["optimismSepolia"]
};
function resolveNetworkToChain(network) {
    const chain = NETWORK_TO_CHAIN_MAP[network.toLowerCase()];
    if (!chain) {
        throw new Error(`Unsupported network identifier: ${network}`);
    }
    return chain;
} //# sourceMappingURL=networkToChainResolver.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/resolveViemClients.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "resolveViemClients",
    ()=>resolveViemClients
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createPublicClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/clients/createPublicClient.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createWalletClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/clients/createWalletClient.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/clients/transports/http.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$accounts$2f$toAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/accounts/toAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/index.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$getBaseNodeRpcUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/getBaseNodeRpcUrl.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkToChainResolver$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/networkToChainResolver.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
/**
 * Get a chain from the viem chains object
 *
 * @param id - The chain ID
 * @returns The chain
 */ function getChain(id) {
    const chainList = Object.values(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__);
    const found = chainList.find((chain)=>chain.id === id);
    if (!found) throw new Error(`Unsupported chain ID: ${id}`);
    return found;
}
/**
 * Determines if the input string is a network identifier or a Node URL
 *
 * @param input - The string to check
 * @returns True if the input is a network identifier, false otherwise
 */ function isNetworkIdentifier(input) {
    const normalizedInput = input.toLowerCase();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkToChainResolver$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["NETWORK_TO_CHAIN_MAP"][normalizedInput] !== undefined;
}
/**
 * Resolves a Node URL to a viem chain by making a getChainId call
 *
 * @param nodeUrl - The Node URL to resolve
 * @returns Promise resolving to the viem chain
 */ async function resolveNodeUrlToChain(nodeUrl) {
    // First validate that it's a proper URL
    if (!isValidUrl(nodeUrl)) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"](`Invalid URL format: ${nodeUrl}`);
    }
    // Create a temporary public client to get the chain ID
    const tempPublicClient = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createPublicClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createPublicClient"])({
        transport: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["http"])(nodeUrl)
    });
    try {
        const chainId = await tempPublicClient.getChainId();
        const chain = getChain(Number(chainId));
        return chain;
    } catch (error) {
        throw new Error(`Failed to resolve chain ID from Node URL: ${error instanceof Error ? error.message : "Unknown error"}`);
    }
}
/**
 * Determines if the input string is a valid URL
 *
 * @param input - The string to validate as a URL
 * @returns True if the input is a valid URL, false otherwise
 */ function isValidUrl(input) {
    try {
        new URL(input);
        return true;
    } catch  {
        return false;
    }
}
async function resolveViemClients(options) {
    const { networkOrNodeUrl } = options;
    let chain;
    // If it's a valid network identifier, use the mapping
    if (isNetworkIdentifier(networkOrNodeUrl)) {
        const rpcUrl = networkOrNodeUrl === "base" || networkOrNodeUrl === "base-sepolia" ? await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$getBaseNodeRpcUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBaseNodeRpcUrl"])(networkOrNodeUrl) : undefined;
        chain = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkToChainResolver$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["resolveNetworkToChain"])(networkOrNodeUrl);
        const publicClient = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createPublicClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createPublicClient"])({
            chain,
            transport: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["http"])(rpcUrl)
        });
        const walletClient = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createWalletClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createWalletClient"])({
            account: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$accounts$2f$toAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toAccount"])(options.account),
            chain,
            transport: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["http"])(rpcUrl)
        });
        return {
            chain,
            publicClient,
            walletClient
        };
    }
    // If it's not a valid network identifier, try to treat it as a Node URL
    try {
        chain = await resolveNodeUrlToChain(networkOrNodeUrl);
        const publicClient = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createPublicClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createPublicClient"])({
            chain,
            transport: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["http"])(networkOrNodeUrl)
        });
        const walletClient = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$createWalletClient$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createWalletClient"])({
            account: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$accounts$2f$toAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toAccount"])(options.account),
            chain,
            transport: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$http$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["http"])(networkOrNodeUrl)
        });
        return {
            chain,
            publicClient,
            walletClient
        };
    } catch (error) {
        // If the error is from resolveNodeUrlToChain, re-throw it as-is
        if (error instanceof Error && (error.message.includes("Invalid URL format") || error.message.includes("Unsupported chain ID") || error.message.includes("Failed to resolve chain ID"))) {
            throw error;
        }
        // Otherwise, throw a generic error about unsupported input
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"](`Unsupported network identifier or invalid Node URL: ${networkOrNodeUrl}`);
    }
} //# sourceMappingURL=resolveViemClients.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/utils.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * The address of an ERC20 token for a given network.
 */ __turbopack_context__.s([
    "getErc20Address",
    ()=>getErc20Address
]);
const addressMap = {
    base: {
        usdc: "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913"
    },
    "base-sepolia": {
        usdc: "0x036CbD53842c5426634e7929541eC2318f3dCF7e"
    }
};
function getErc20Address(token, network) {
    return addressMap[network][token] ?? token;
} //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/transferWithViem.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "transferWithViem",
    ()=>transferWithViem
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/constants/abis.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/utils.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$chainToNetworkMapper$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/chainToNetworkMapper.js [app-ssr] (ecmascript)");
;
;
;
async function transferWithViem(walletClient, from, transferArgs) {
    const token = transferArgs.token;
    const to = typeof transferArgs.to === "string" ? transferArgs.to : transferArgs.to.address;
    const value = transferArgs.amount;
    if (token === "eth") {
        const hash = await walletClient.sendTransaction({
            account: from.address,
            to,
            value
        });
        return {
            transactionHash: hash
        };
    }
    const network = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$chainToNetworkMapper$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mapChainToNetwork"])(walletClient.chain);
    const erc20Address = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getErc20Address"])(token, network);
    // First approve the transfer
    await walletClient.sendTransaction({
        account: from.address,
        to: erc20Address,
        data: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
            abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["erc20Abi"],
            functionName: "approve",
            args: [
                to,
                value
            ]
        })
    });
    // Then execute the transfer
    const hash = await walletClient.sendTransaction({
        account: from.address,
        to: erc20Address,
        data: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
            abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["erc20Abi"],
            functionName: "transfer",
            args: [
                to,
                value
            ]
        })
    });
    return {
        transactionHash: hash
    };
} //# sourceMappingURL=transferWithViem.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toNetworkScopedEvmServerAccount.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "toNetworkScopedEvmServerAccount",
    ()=>toNetworkScopedEvmServerAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/base.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/baseSepolia.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/mainnet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/chains/definitions/sepolia.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$chainToNetworkMapper$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/chainToNetworkMapper.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/networkCapabilities.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$resolveViemClients$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/resolveViemClients.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transferWithViem$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/transferWithViem.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
async function toNetworkScopedEvmServerAccount(options) {
    const { publicClient, walletClient, chain } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$resolveViemClients$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["resolveViemClients"])({
        networkOrNodeUrl: options.network,
        account: options.account
    });
    /*
     * Determine the actual network name from the resolved chain
     * This handles cases where options.network is an RPC URL
     */ const resolvedNetworkName = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$chainToNetworkMapper$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mapChainToNetwork"])(chain) ?? options.network;
    const shouldUseApiForSends = chain.id === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["base"].id || chain.id === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["baseSepolia"].id || chain.id === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mainnet"].id || chain.id === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sepolia"].id;
    const account = {
        address: options.account.address,
        network: options.network,
        signMessage: options.account.signMessage,
        sign: options.account.sign,
        signTransaction: options.account.signTransaction,
        signTypedData: options.account.signTypedData,
        name: options.account.name,
        type: "evm-server",
        policies: options.account.policies,
        sendTransaction: async (txOpts)=>{
            if (shouldUseApiForSends) {
                return options.account.sendTransaction({
                    ...txOpts,
                    network: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$chainToNetworkMapper$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mapChainToNetwork"])(chain)
                });
            } else {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "send_transaction",
                    accountType: "evm_server",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                const hash = await walletClient.sendTransaction(txOpts.transaction);
                return {
                    transactionHash: hash
                };
            }
        },
        transfer: async (transferArgs)=>{
            if (shouldUseApiForSends) {
                return options.account.transfer({
                    ...transferArgs,
                    network: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$chainToNetworkMapper$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mapChainToNetwork"])(chain)
                });
            } else {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "transfer",
                    accountType: "evm_server",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transferWithViem$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["transferWithViem"])(walletClient, account, transferArgs);
            }
        },
        waitForTransactionReceipt: async (waitOptions)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "wait_for_transaction_receipt",
                accountType: "evm_server",
                properties: {
                    managed: true
                }
            });
            if ("transactionHash" in waitOptions) {
                return publicClient.waitForTransactionReceipt({
                    hash: waitOptions.transactionHash
                });
            }
            return publicClient.waitForTransactionReceipt(waitOptions);
        }
    };
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("listTokenBalances", resolvedNetworkName)) {
        Object.assign(account, {
            listTokenBalances: async (listTokenBalancesOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "list_token_balances",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.listTokenBalances({
                    ...listTokenBalancesOptions,
                    network: options.network
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("requestFaucet", resolvedNetworkName)) {
        Object.assign(account, {
            requestFaucet: async (faucetOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "request_faucet",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.requestFaucet({
                    ...faucetOptions,
                    network: chain.id === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["baseSepolia"].id ? "base-sepolia" : "ethereum-sepolia"
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("quoteFund", resolvedNetworkName)) {
        Object.assign(account, {
            quoteFund: async (quoteFundOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "quote_fund",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.quoteFund({
                    ...quoteFundOptions
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("fund", resolvedNetworkName)) {
        Object.assign(account, {
            fund: async (fundOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "fund",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.fund({
                    ...fundOptions
                });
            },
            waitForFundOperationReceipt: async (waitOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "wait_for_fund_operation_receipt",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.waitForFundOperationReceipt(waitOptions);
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("quoteSwap", resolvedNetworkName)) {
        Object.assign(account, {
            quoteSwap: async (quoteSwapOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "quote_swap",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.quoteSwap({
                    ...quoteSwapOptions,
                    network: options.network
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("swap", resolvedNetworkName)) {
        Object.assign(account, {
            swap: async (swapOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "swap",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                /*
                 * For network-scoped accounts, we need to add the network parameter
                 * for inline swaps while preserving quote-based swaps as-is
                 */ const swapOptionsWithNetwork = "swapQuote" in swapOptions ? swapOptions // Quote-based swap, pass through
                 : {
                    ...swapOptions,
                    network: options.network
                }; // Inline swap, add network
                return options.account.swap(swapOptionsWithNetwork);
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("useSpendPermission", resolvedNetworkName)) {
        Object.assign(account, {
            useSpendPermission: async (spendPermissionOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "use_spend_permission",
                    accountType: "evm_server",
                    properties: {
                        managed: true
                    }
                });
                return options.account.useSpendPermission({
                    ...spendPermissionOptions,
                    network: options.network
                });
            }
        });
    }
    return account;
} //# sourceMappingURL=toNetworkScopedEvmServerAccount.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// eslint-disable-next-line @typescript-eslint/no-redeclare
__turbopack_context__.s([
    "AbiFunctionType",
    ()=>AbiFunctionType,
    "AbiInputType",
    ()=>AbiInputType,
    "AbiStateMutability",
    ()=>AbiStateMutability,
    "CreatePaymentTransferQuoteBodySourceType",
    ()=>CreatePaymentTransferQuoteBodySourceType,
    "CreatePaymentTransferQuoteBodyTargetType",
    ()=>CreatePaymentTransferQuoteBodyTargetType,
    "CreatePolicyBodyScope",
    ()=>CreatePolicyBodyScope,
    "DeveloperJWTAuthenticationType",
    ()=>DeveloperJWTAuthenticationType,
    "EmailAuthenticationType",
    ()=>EmailAuthenticationType,
    "ErrorType",
    ()=>ErrorType,
    "EthValueCriterionOperator",
    ()=>EthValueCriterionOperator,
    "EthValueCriterionType",
    ()=>EthValueCriterionType,
    "EvmAddressCriterionOperator",
    ()=>EvmAddressCriterionOperator,
    "EvmAddressCriterionType",
    ()=>EvmAddressCriterionType,
    "EvmDataCriterionType",
    ()=>EvmDataCriterionType,
    "EvmDataParameterConditionListOperator",
    ()=>EvmDataParameterConditionListOperator,
    "EvmDataParameterConditionOperator",
    ()=>EvmDataParameterConditionOperator,
    "EvmMessageCriterionType",
    ()=>EvmMessageCriterionType,
    "EvmNetworkCriterionNetworksItem",
    ()=>EvmNetworkCriterionNetworksItem,
    "EvmNetworkCriterionOperator",
    ()=>EvmNetworkCriterionOperator,
    "EvmNetworkCriterionType",
    ()=>EvmNetworkCriterionType,
    "EvmSwapsNetwork",
    ()=>EvmSwapsNetwork,
    "EvmTypedAddressConditionOperator",
    ()=>EvmTypedAddressConditionOperator,
    "EvmTypedNumericalConditionOperator",
    ()=>EvmTypedNumericalConditionOperator,
    "EvmUserOperationNetwork",
    ()=>EvmUserOperationNetwork,
    "EvmUserOperationStatus",
    ()=>EvmUserOperationStatus,
    "FeeType",
    ()=>FeeType,
    "KnownAbiType",
    ()=>KnownAbiType,
    "KnownIdlType",
    ()=>KnownIdlType,
    "ListEvmTokenBalancesNetwork",
    ()=>ListEvmTokenBalancesNetwork,
    "ListPoliciesScope",
    ()=>ListPoliciesScope,
    "ListSolanaTokenBalancesNetwork",
    ()=>ListSolanaTokenBalancesNetwork,
    "MintAddressCriterionOperator",
    ()=>MintAddressCriterionOperator,
    "MintAddressCriterionType",
    ()=>MintAddressCriterionType,
    "NetUSDChangeCriterionOperator",
    ()=>NetUSDChangeCriterionOperator,
    "NetUSDChangeCriterionType",
    ()=>NetUSDChangeCriterionType,
    "OnchainDataResultSchemaColumnsItemType",
    ()=>OnchainDataResultSchemaColumnsItemType,
    "OnrampOrderFeeType",
    ()=>OnrampOrderFeeType,
    "OnrampOrderPaymentMethodTypeId",
    ()=>OnrampOrderPaymentMethodTypeId,
    "OnrampOrderStatus",
    ()=>OnrampOrderStatus,
    "OnrampPaymentLinkType",
    ()=>OnrampPaymentLinkType,
    "OnrampQuotePaymentMethodTypeId",
    ()=>OnrampQuotePaymentMethodTypeId,
    "PaymentMethodType",
    ()=>PaymentMethodType,
    "PaymentRailAction",
    ()=>PaymentRailAction,
    "PolicyScope",
    ()=>PolicyScope,
    "PrepareUserOperationRuleAction",
    ()=>PrepareUserOperationRuleAction,
    "PrepareUserOperationRuleOperation",
    ()=>PrepareUserOperationRuleOperation,
    "ProgramIdCriterionOperator",
    ()=>ProgramIdCriterionOperator,
    "ProgramIdCriterionType",
    ()=>ProgramIdCriterionType,
    "RequestEvmFaucetBodyNetwork",
    ()=>RequestEvmFaucetBodyNetwork,
    "RequestEvmFaucetBodyToken",
    ()=>RequestEvmFaucetBodyToken,
    "RequestSolanaFaucetBodyToken",
    ()=>RequestSolanaFaucetBodyToken,
    "SendEvmTransactionBodyNetwork",
    ()=>SendEvmTransactionBodyNetwork,
    "SendEvmTransactionRuleAction",
    ()=>SendEvmTransactionRuleAction,
    "SendEvmTransactionRuleOperation",
    ()=>SendEvmTransactionRuleOperation,
    "SendSolTransactionRuleAction",
    ()=>SendSolTransactionRuleAction,
    "SendSolTransactionRuleOperation",
    ()=>SendSolTransactionRuleOperation,
    "SendSolanaTransactionBodyNetwork",
    ()=>SendSolanaTransactionBodyNetwork,
    "SendUserOperationRuleAction",
    ()=>SendUserOperationRuleAction,
    "SendUserOperationRuleOperation",
    ()=>SendUserOperationRuleOperation,
    "SignEvmHashRuleAction",
    ()=>SignEvmHashRuleAction,
    "SignEvmHashRuleOperation",
    ()=>SignEvmHashRuleOperation,
    "SignEvmMessageRuleAction",
    ()=>SignEvmMessageRuleAction,
    "SignEvmMessageRuleOperation",
    ()=>SignEvmMessageRuleOperation,
    "SignEvmTransactionRuleAction",
    ()=>SignEvmTransactionRuleAction,
    "SignEvmTransactionRuleOperation",
    ()=>SignEvmTransactionRuleOperation,
    "SignEvmTypedDataFieldCriterionType",
    ()=>SignEvmTypedDataFieldCriterionType,
    "SignEvmTypedDataRuleAction",
    ()=>SignEvmTypedDataRuleAction,
    "SignEvmTypedDataRuleOperation",
    ()=>SignEvmTypedDataRuleOperation,
    "SignEvmTypedDataVerifyingContractCriterionOperator",
    ()=>SignEvmTypedDataVerifyingContractCriterionOperator,
    "SignEvmTypedDataVerifyingContractCriterionType",
    ()=>SignEvmTypedDataVerifyingContractCriterionType,
    "SignSolMessageRuleAction",
    ()=>SignSolMessageRuleAction,
    "SignSolMessageRuleOperation",
    ()=>SignSolMessageRuleOperation,
    "SignSolTransactionRuleAction",
    ()=>SignSolTransactionRuleAction,
    "SignSolTransactionRuleOperation",
    ()=>SignSolTransactionRuleOperation,
    "SmsAuthenticationType",
    ()=>SmsAuthenticationType,
    "SolAddressCriterionOperator",
    ()=>SolAddressCriterionOperator,
    "SolAddressCriterionType",
    ()=>SolAddressCriterionType,
    "SolDataCriterionType",
    ()=>SolDataCriterionType,
    "SolDataParameterConditionListOperator",
    ()=>SolDataParameterConditionListOperator,
    "SolDataParameterConditionOperator",
    ()=>SolDataParameterConditionOperator,
    "SolMessageCriterionType",
    ()=>SolMessageCriterionType,
    "SolNetworkCriterionNetworksItem",
    ()=>SolNetworkCriterionNetworksItem,
    "SolNetworkCriterionOperator",
    ()=>SolNetworkCriterionOperator,
    "SolNetworkCriterionType",
    ()=>SolNetworkCriterionType,
    "SolValueCriterionOperator",
    ()=>SolValueCriterionOperator,
    "SolValueCriterionType",
    ()=>SolValueCriterionType,
    "SpendPermissionNetwork",
    ()=>SpendPermissionNetwork,
    "SplAddressCriterionOperator",
    ()=>SplAddressCriterionOperator,
    "SplAddressCriterionType",
    ()=>SplAddressCriterionType,
    "SplValueCriterionOperator",
    ()=>SplValueCriterionOperator,
    "SplValueCriterionType",
    ()=>SplValueCriterionType,
    "TransferSourceType",
    ()=>TransferSourceType,
    "TransferStatus",
    ()=>TransferStatus,
    "TransferTargetType",
    ()=>TransferTargetType,
    "X402PaymentPayloadNetwork",
    ()=>X402PaymentPayloadNetwork,
    "X402PaymentPayloadScheme",
    ()=>X402PaymentPayloadScheme,
    "X402PaymentRequirementsNetwork",
    ()=>X402PaymentRequirementsNetwork,
    "X402PaymentRequirementsScheme",
    ()=>X402PaymentRequirementsScheme,
    "X402SettleErrorReason",
    ()=>X402SettleErrorReason,
    "X402SupportedPaymentKindNetwork",
    ()=>X402SupportedPaymentKindNetwork,
    "X402SupportedPaymentKindScheme",
    ()=>X402SupportedPaymentKindScheme,
    "X402VerifyInvalidReason",
    ()=>X402VerifyInvalidReason,
    "X402Version",
    ()=>X402Version
]);
const EmailAuthenticationType = {
    email: "email"
};
const SmsAuthenticationType = {
    sms: "sms"
};
const DeveloperJWTAuthenticationType = {
    jwt: "jwt"
};
const ErrorType = {
    already_exists: "already_exists",
    bad_gateway: "bad_gateway",
    faucet_limit_exceeded: "faucet_limit_exceeded",
    forbidden: "forbidden",
    idempotency_error: "idempotency_error",
    internal_server_error: "internal_server_error",
    invalid_request: "invalid_request",
    invalid_sql_query: "invalid_sql_query",
    invalid_signature: "invalid_signature",
    malformed_transaction: "malformed_transaction",
    not_found: "not_found",
    payment_method_required: "payment_method_required",
    rate_limit_exceeded: "rate_limit_exceeded",
    request_canceled: "request_canceled",
    service_unavailable: "service_unavailable",
    timed_out: "timed_out",
    unauthorized: "unauthorized",
    policy_violation: "policy_violation",
    policy_in_use: "policy_in_use",
    account_limit_exceeded: "account_limit_exceeded",
    network_not_tradable: "network_not_tradable",
    guest_permission_denied: "guest_permission_denied",
    guest_region_forbidden: "guest_region_forbidden",
    guest_transaction_limit: "guest_transaction_limit",
    guest_transaction_count: "guest_transaction_count",
    phone_number_verification_expired: "phone_number_verification_expired",
    document_verification_failed: "document_verification_failed",
    recipient_allowlist_violation: "recipient_allowlist_violation",
    recipient_allowlist_pending: "recipient_allowlist_pending",
    travel_rules_recipient_violation: "travel_rules_recipient_violation"
};
const EvmUserOperationNetwork = {
    "base-sepolia": "base-sepolia",
    base: "base",
    arbitrum: "arbitrum",
    optimism: "optimism",
    zora: "zora",
    polygon: "polygon",
    bnb: "bnb",
    avalanche: "avalanche",
    ethereum: "ethereum",
    "ethereum-sepolia": "ethereum-sepolia"
};
const EvmUserOperationStatus = {
    pending: "pending",
    signed: "signed",
    broadcast: "broadcast",
    complete: "complete",
    dropped: "dropped",
    failed: "failed"
};
const SpendPermissionNetwork = {
    base: "base",
    "base-sepolia": "base-sepolia",
    ethereum: "ethereum",
    "ethereum-sepolia": "ethereum-sepolia",
    optimism: "optimism",
    arbitrum: "arbitrum",
    avalanche: "avalanche",
    polygon: "polygon"
};
const EvmSwapsNetwork = {
    base: "base",
    ethereum: "ethereum",
    arbitrum: "arbitrum",
    optimism: "optimism"
};
const ListEvmTokenBalancesNetwork = {
    base: "base",
    "base-sepolia": "base-sepolia",
    ethereum: "ethereum"
};
const EthValueCriterionType = {
    ethValue: "ethValue"
};
const EthValueCriterionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const EvmAddressCriterionType = {
    evmAddress: "evmAddress"
};
const EvmAddressCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const KnownAbiType = {
    erc20: "erc20",
    erc721: "erc721",
    erc1155: "erc1155"
};
const AbiStateMutability = {
    pure: "pure",
    view: "view",
    nonpayable: "nonpayable",
    payable: "payable"
};
const AbiFunctionType = {
    function: "function"
};
const AbiInputType = {
    constructor: "constructor",
    error: "error",
    event: "event",
    fallback: "fallback",
    receive: "receive"
};
const EvmDataParameterConditionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const EvmDataParameterConditionListOperator = {
    in: "in",
    not_in: "not in"
};
const EvmDataCriterionType = {
    evmData: "evmData"
};
const NetUSDChangeCriterionType = {
    netUSDChange: "netUSDChange"
};
const NetUSDChangeCriterionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const SignEvmTransactionRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SignEvmTransactionRuleOperation = {
    signEvmTransaction: "signEvmTransaction"
};
const EvmNetworkCriterionType = {
    evmNetwork: "evmNetwork"
};
const EvmNetworkCriterionNetworksItem = {
    "base-sepolia": "base-sepolia",
    base: "base",
    ethereum: "ethereum",
    "ethereum-sepolia": "ethereum-sepolia",
    avalanche: "avalanche",
    polygon: "polygon",
    optimism: "optimism",
    arbitrum: "arbitrum",
    zora: "zora",
    bnb: "bnb"
};
const EvmNetworkCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const SendEvmTransactionRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SendEvmTransactionRuleOperation = {
    sendEvmTransaction: "sendEvmTransaction"
};
const EvmMessageCriterionType = {
    evmMessage: "evmMessage"
};
const SignEvmMessageRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SignEvmMessageRuleOperation = {
    signEvmMessage: "signEvmMessage"
};
const EvmTypedAddressConditionOperator = {
    in: "in",
    not_in: "not in"
};
const EvmTypedNumericalConditionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const SignEvmTypedDataFieldCriterionType = {
    evmTypedDataField: "evmTypedDataField"
};
const SignEvmTypedDataVerifyingContractCriterionType = {
    evmTypedDataVerifyingContract: "evmTypedDataVerifyingContract"
};
const SignEvmTypedDataVerifyingContractCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const SignEvmTypedDataRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SignEvmTypedDataRuleOperation = {
    signEvmTypedData: "signEvmTypedData"
};
const SolAddressCriterionType = {
    solAddress: "solAddress"
};
const SolAddressCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const SolValueCriterionType = {
    solValue: "solValue"
};
const SolValueCriterionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const SplAddressCriterionType = {
    splAddress: "splAddress"
};
const SplAddressCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const SplValueCriterionType = {
    splValue: "splValue"
};
const SplValueCriterionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const MintAddressCriterionType = {
    mintAddress: "mintAddress"
};
const MintAddressCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const KnownIdlType = {
    SystemProgram: "SystemProgram",
    TokenProgram: "TokenProgram",
    AssociatedTokenProgram: "AssociatedTokenProgram"
};
const SolDataParameterConditionOperator = {
    ">": ">",
    ">=": ">=",
    "<": "<",
    "<=": "<=",
    "==": "=="
};
const SolDataParameterConditionListOperator = {
    in: "in",
    not_in: "not in"
};
const SolDataCriterionType = {
    solData: "solData"
};
const ProgramIdCriterionType = {
    programId: "programId"
};
const ProgramIdCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const SignSolTransactionRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SignSolTransactionRuleOperation = {
    signSolTransaction: "signSolTransaction"
};
const SolNetworkCriterionType = {
    solNetwork: "solNetwork"
};
const SolNetworkCriterionNetworksItem = {
    "solana-devnet": "solana-devnet",
    solana: "solana"
};
const SolNetworkCriterionOperator = {
    in: "in",
    not_in: "not in"
};
const SendSolTransactionRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SendSolTransactionRuleOperation = {
    sendSolTransaction: "sendSolTransaction"
};
const SolMessageCriterionType = {
    solMessage: "solMessage"
};
const SignSolMessageRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SignSolMessageRuleOperation = {
    signSolMessage: "signSolMessage"
};
const SignEvmHashRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SignEvmHashRuleOperation = {
    signEvmHash: "signEvmHash"
};
const PrepareUserOperationRuleAction = {
    reject: "reject",
    accept: "accept"
};
const PrepareUserOperationRuleOperation = {
    prepareUserOperation: "prepareUserOperation"
};
const SendUserOperationRuleAction = {
    reject: "reject",
    accept: "accept"
};
const SendUserOperationRuleOperation = {
    sendUserOperation: "sendUserOperation"
};
const PolicyScope = {
    project: "project",
    account: "account"
};
const ListSolanaTokenBalancesNetwork = {
    solana: "solana",
    "solana-devnet": "solana-devnet"
};
const OnchainDataResultSchemaColumnsItemType = {
    String: "String",
    UInt8: "UInt8",
    UInt16: "UInt16",
    UInt32: "UInt32",
    UInt64: "UInt64",
    UInt128: "UInt128",
    UInt256: "UInt256",
    Int8: "Int8",
    Int16: "Int16",
    Int32: "Int32",
    Int64: "Int64",
    Int128: "Int128",
    Int256: "Int256",
    Float32: "Float32",
    Float64: "Float64",
    Bool: "Bool",
    Date: "Date",
    DateTime: "DateTime",
    DateTime64: "DateTime64",
    UUID: "UUID"
};
const X402Version = {
    NUMBER_1: 1
};
const X402PaymentPayloadScheme = {
    exact: "exact"
};
const X402PaymentPayloadNetwork = {
    "base-sepolia": "base-sepolia",
    base: "base",
    "solana-devnet": "solana-devnet",
    solana: "solana"
};
const X402PaymentRequirementsScheme = {
    exact: "exact"
};
const X402PaymentRequirementsNetwork = {
    "base-sepolia": "base-sepolia",
    base: "base",
    "solana-devnet": "solana-devnet",
    solana: "solana"
};
const X402VerifyInvalidReason = {
    insufficient_funds: "insufficient_funds",
    invalid_scheme: "invalid_scheme",
    invalid_network: "invalid_network",
    invalid_x402_version: "invalid_x402_version",
    invalid_payment_requirements: "invalid_payment_requirements",
    invalid_payload: "invalid_payload",
    invalid_exact_evm_payload_authorization_value: "invalid_exact_evm_payload_authorization_value",
    invalid_exact_evm_payload_authorization_valid_after: "invalid_exact_evm_payload_authorization_valid_after",
    invalid_exact_evm_payload_authorization_valid_before: "invalid_exact_evm_payload_authorization_valid_before",
    invalid_exact_evm_payload_authorization_typed_data_message: "invalid_exact_evm_payload_authorization_typed_data_message",
    invalid_exact_evm_payload_authorization_from_address_kyt: "invalid_exact_evm_payload_authorization_from_address_kyt",
    invalid_exact_evm_payload_authorization_to_address_kyt: "invalid_exact_evm_payload_authorization_to_address_kyt",
    invalid_exact_evm_payload_signature: "invalid_exact_evm_payload_signature",
    invalid_exact_evm_payload_signature_address: "invalid_exact_evm_payload_signature_address",
    invalid_exact_svm_payload_transaction: "invalid_exact_svm_payload_transaction",
    invalid_exact_svm_payload_transaction_amount_mismatch: "invalid_exact_svm_payload_transaction_amount_mismatch",
    invalid_exact_svm_payload_transaction_create_ata_instruction: "invalid_exact_svm_payload_transaction_create_ata_instruction",
    invalid_exact_svm_payload_transaction_create_ata_instruction_incorrect_payee: "invalid_exact_svm_payload_transaction_create_ata_instruction_incorrect_payee",
    invalid_exact_svm_payload_transaction_create_ata_instruction_incorrect_asset: "invalid_exact_svm_payload_transaction_create_ata_instruction_incorrect_asset",
    invalid_exact_svm_payload_transaction_instructions: "invalid_exact_svm_payload_transaction_instructions",
    invalid_exact_svm_payload_transaction_instructions_length: "invalid_exact_svm_payload_transaction_instructions_length",
    invalid_exact_svm_payload_transaction_instructions_compute_limit_instruction: "invalid_exact_svm_payload_transaction_instructions_compute_limit_instruction",
    invalid_exact_svm_payload_transaction_instructions_compute_price_instruction: "invalid_exact_svm_payload_transaction_instructions_compute_price_instruction",
    invalid_exact_svm_payload_transaction_instructions_compute_price_instruction_too_high: "invalid_exact_svm_payload_transaction_instructions_compute_price_instruction_too_high",
    invalid_exact_svm_payload_transaction_instruction_not_spl_token_transfer_checked: "invalid_exact_svm_payload_transaction_instruction_not_spl_token_transfer_checked",
    invalid_exact_svm_payload_transaction_instruction_not_token_2022_transfer_checked: "invalid_exact_svm_payload_transaction_instruction_not_token_2022_transfer_checked",
    invalid_exact_svm_payload_transaction_not_a_transfer_instruction: "invalid_exact_svm_payload_transaction_not_a_transfer_instruction",
    invalid_exact_svm_payload_transaction_cannot_derive_receiver_ata: "invalid_exact_svm_payload_transaction_cannot_derive_receiver_ata",
    invalid_exact_svm_payload_transaction_receiver_ata_not_found: "invalid_exact_svm_payload_transaction_receiver_ata_not_found",
    invalid_exact_svm_payload_transaction_sender_ata_not_found: "invalid_exact_svm_payload_transaction_sender_ata_not_found",
    invalid_exact_svm_payload_transaction_simulation_failed: "invalid_exact_svm_payload_transaction_simulation_failed",
    invalid_exact_svm_payload_transaction_transfer_to_incorrect_ata: "invalid_exact_svm_payload_transaction_transfer_to_incorrect_ata"
};
const X402SettleErrorReason = {
    insufficient_funds: "insufficient_funds",
    invalid_scheme: "invalid_scheme",
    invalid_network: "invalid_network",
    invalid_x402_version: "invalid_x402_version",
    invalid_payment_requirements: "invalid_payment_requirements",
    invalid_payload: "invalid_payload",
    invalid_exact_evm_payload_authorization_value: "invalid_exact_evm_payload_authorization_value",
    invalid_exact_evm_payload_authorization_valid_after: "invalid_exact_evm_payload_authorization_valid_after",
    invalid_exact_evm_payload_authorization_valid_before: "invalid_exact_evm_payload_authorization_valid_before",
    invalid_exact_evm_payload_authorization_typed_data_message: "invalid_exact_evm_payload_authorization_typed_data_message",
    invalid_exact_evm_payload_authorization_from_address_kyt: "invalid_exact_evm_payload_authorization_from_address_kyt",
    invalid_exact_evm_payload_authorization_to_address_kyt: "invalid_exact_evm_payload_authorization_to_address_kyt",
    invalid_exact_evm_payload_signature_address: "invalid_exact_evm_payload_signature_address",
    settle_exact_svm_block_height_exceeded: "settle_exact_svm_block_height_exceeded",
    settle_exact_svm_transaction_confirmation_timed_out: "settle_exact_svm_transaction_confirmation_timed_out"
};
const X402SupportedPaymentKindScheme = {
    exact: "exact"
};
const X402SupportedPaymentKindNetwork = {
    "base-sepolia": "base-sepolia",
    base: "base",
    "solana-devnet": "solana-devnet",
    solana: "solana"
};
const PaymentRailAction = {
    source: "source",
    target: "target"
};
const PaymentMethodType = {
    card: "card",
    fiat_account: "fiat_account"
};
const FeeType = {
    exchange_fee: "exchange_fee",
    network_fee: "network_fee"
};
const TransferSourceType = {
    payment_method: "payment_method"
};
const TransferTargetType = {
    crypto_rail: "crypto_rail"
};
const TransferStatus = {
    created: "created",
    pending: "pending",
    started: "started",
    completed: "completed",
    failed: "failed"
};
const OnrampOrderPaymentMethodTypeId = {
    GUEST_CHECKOUT_APPLE_PAY: "GUEST_CHECKOUT_APPLE_PAY"
};
const OnrampOrderFeeType = {
    FEE_TYPE_NETWORK: "FEE_TYPE_NETWORK",
    FEE_TYPE_EXCHANGE: "FEE_TYPE_EXCHANGE"
};
const OnrampOrderStatus = {
    ONRAMP_ORDER_STATUS_PENDING_AUTH: "ONRAMP_ORDER_STATUS_PENDING_AUTH",
    ONRAMP_ORDER_STATUS_PENDING_PAYMENT: "ONRAMP_ORDER_STATUS_PENDING_PAYMENT",
    ONRAMP_ORDER_STATUS_PROCESSING: "ONRAMP_ORDER_STATUS_PROCESSING",
    ONRAMP_ORDER_STATUS_COMPLETED: "ONRAMP_ORDER_STATUS_COMPLETED",
    ONRAMP_ORDER_STATUS_FAILED: "ONRAMP_ORDER_STATUS_FAILED"
};
const OnrampPaymentLinkType = {
    PAYMENT_LINK_TYPE_APPLE_PAY_BUTTON: "PAYMENT_LINK_TYPE_APPLE_PAY_BUTTON"
};
const OnrampQuotePaymentMethodTypeId = {
    CARD: "CARD",
    ACH: "ACH",
    APPLE_PAY: "APPLE_PAY",
    PAYPAL: "PAYPAL",
    FIAT_WALLET: "FIAT_WALLET",
    CRYPTO_WALLET: "CRYPTO_WALLET"
};
const SendEvmTransactionBodyNetwork = {
    base: "base",
    "base-sepolia": "base-sepolia",
    ethereum: "ethereum",
    "ethereum-sepolia": "ethereum-sepolia",
    avalanche: "avalanche",
    polygon: "polygon",
    optimism: "optimism",
    arbitrum: "arbitrum"
};
const RequestEvmFaucetBodyNetwork = {
    "base-sepolia": "base-sepolia",
    "ethereum-sepolia": "ethereum-sepolia",
    "ethereum-hoodi": "ethereum-hoodi"
};
const RequestEvmFaucetBodyToken = {
    eth: "eth",
    usdc: "usdc",
    eurc: "eurc",
    cbbtc: "cbbtc"
};
const ListPoliciesScope = {
    project: "project",
    account: "account"
};
const CreatePolicyBodyScope = {
    project: "project",
    account: "account"
};
const SendSolanaTransactionBodyNetwork = {
    solana: "solana",
    "solana-devnet": "solana-devnet"
};
const RequestSolanaFaucetBodyToken = {
    sol: "sol",
    usdc: "usdc"
};
const CreatePaymentTransferQuoteBodySourceType = {
    payment_method: "payment_method"
};
const CreatePaymentTransferQuoteBodyTargetType = {
    crypto_rail: "crypto_rail"
}; //# sourceMappingURL=coinbaseDeveloperPlatformAPIs.schemas.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/fund.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "fund",
    ()=>fund
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/unit/formatUnits.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
;
;
;
async function fund(apiClient, options) {
    if (options.token !== "eth" && options.token !== "usdc") {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid token, must be eth or usdc");
    }
    const decimals = options.token === "eth" ? 18 : 6;
    const amount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["formatUnits"])(options.amount, decimals);
    const paymentMethods = await apiClient.getPaymentMethods();
    const cardPaymentMethod = paymentMethods.find((method)=>method.type === "card" && method.actions.includes("source"));
    if (!cardPaymentMethod) {
        throw new Error("No card found to fund account");
    }
    const response = await apiClient.createPaymentTransferQuote({
        sourceType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodySourceType"].payment_method,
        source: {
            id: cardPaymentMethod.id
        },
        targetType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodyTargetType"].crypto_rail,
        target: {
            currency: options.token,
            network: options.network,
            address: options.address
        },
        amount,
        currency: options.token,
        execute: true
    });
    return {
        id: response.transfer.id,
        network: response.transfer.target.network,
        status: response.transfer.status,
        targetAmount: response.transfer.targetAmount,
        targetCurrency: response.transfer.targetCurrency,
        transactionHash: response.transfer.transactionHash
    };
} //# sourceMappingURL=fund.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/Quote.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Base class representing a funding quote that can be executed.
 */ __turbopack_context__.s([
    "EvmQuote",
    ()=>EvmQuote,
    "SolanaQuote",
    ()=>SolanaQuote
]);
class BaseQuote {
    /** Quote for the transfer. */ quoteId;
    /** The amount in fiat currency. */ fiatAmount;
    /** The fiat currency. */ fiatCurrency;
    /** The amount in the token to transfer. */ tokenAmount;
    /** The token to transfer. */ token;
    /** Fees in the token to transfer. */ fees;
    apiClient;
    /**
     * Creates a new BaseQuote instance.
     *
     * @param apiClient - The API client.
     * @param quoteId - The quote ID.
     * @param fiatAmount - The amount in fiat currency.
     * @param fiatCurrency - The fiat currency.
     * @param tokenAmount - The amount in the token to transfer.
     * @param token - The token to transfer.
     * @param fees - Fees for the transfer.
     */ constructor(apiClient, quoteId, fiatAmount, fiatCurrency, tokenAmount, token, fees){
        this.apiClient = apiClient;
        this.quoteId = quoteId;
        this.fiatAmount = fiatAmount;
        this.fiatCurrency = fiatCurrency;
        this.tokenAmount = tokenAmount;
        this.token = token;
        this.fees = fees;
    }
    /**
     * Executes the quote to perform the actual fund transfer.
     *
     * @returns A promise that resolves to the result of the executed quote.
     */ async execute() {
        const transfer = await this.apiClient.executePaymentTransferQuote(this.quoteId);
        return {
            id: transfer.id,
            network: transfer.target.network,
            targetAmount: transfer.targetAmount,
            targetCurrency: transfer.targetCurrency,
            status: transfer.status,
            transactionHash: transfer.transactionHash
        };
    }
}
class EvmQuote extends BaseQuote {
    /** Network to transfer the funds to (EVM networks). */ network;
    /**
     * Creates a new EvmQuote instance.
     *
     * @param apiClient - The API client.
     * @param quoteId - The quote ID.
     * @param network - The EVM network to transfer funds to.
     * @param fiatAmount - The amount in fiat currency.
     * @param fiatCurrency - The fiat currency.
     * @param tokenAmount - The amount in the token to transfer.
     * @param token - The token to transfer.
     * @param fees - Fees for the transfer.
     */ constructor(apiClient, quoteId, network, fiatAmount, fiatCurrency, tokenAmount, token, fees){
        super(apiClient, quoteId, fiatAmount, fiatCurrency, tokenAmount, token, fees);
        this.network = network;
    }
}
class SolanaQuote extends BaseQuote {
    /** Network to transfer the funds to (Solana). */ network;
    /**
     * Creates a new SolanaQuote instance.
     *
     * @param apiClient - The API client.
     * @param quoteId - The quote ID.
     * @param network - The Solana network to transfer funds to.
     * @param fiatAmount - The amount in fiat currency.
     * @param fiatCurrency - The fiat currency.
     * @param tokenAmount - The amount in the token to transfer.
     * @param token - The token to transfer.
     * @param fees - Fees for the transfer.
     */ constructor(apiClient, quoteId, network, fiatAmount, fiatCurrency, tokenAmount, token, fees){
        super(apiClient, quoteId, fiatAmount, fiatCurrency, tokenAmount, token, fees);
        this.network = network;
    }
} //# sourceMappingURL=Quote.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/quoteFund.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "quoteFund",
    ()=>quoteFund
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/unit/formatUnits.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$Quote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/Quote.js [app-ssr] (ecmascript)");
;
;
;
;
async function quoteFund(apiClient, options) {
    if (options.token !== "eth" && options.token !== "usdc") {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid token, must be eth or usdc");
    }
    const decimals = options.token === "eth" ? 18 : 6;
    const amount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["formatUnits"])(options.amount, decimals);
    const paymentMethods = await apiClient.getPaymentMethods();
    const cardPaymentMethod = paymentMethods.find((method)=>method.type === "card" && method.actions.includes("source"));
    if (!cardPaymentMethod) {
        throw new Error("No card found to fund account");
    }
    const response = await apiClient.createPaymentTransferQuote({
        sourceType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodySourceType"].payment_method,
        source: {
            id: cardPaymentMethod.id
        },
        targetType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodyTargetType"].crypto_rail,
        target: {
            currency: options.token,
            network: options.network,
            address: options.address
        },
        amount,
        currency: options.token
    });
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$Quote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmQuote"](apiClient, response.transfer.id, options.network, response.transfer.sourceAmount, response.transfer.sourceCurrency, response.transfer.targetAmount, response.transfer.targetCurrency, response.transfer.fees.map((fee)=>({
            type: fee.type,
            amount: fee.amount,
            currency: fee.currency
        })));
} //# sourceMappingURL=quoteFund.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listTokenBalances.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * List the token balances for an EVM account.
 *
 * @param client - The client to use to list the token balances.
 * @param options - The options for listing the token balances.
 * @returns The result of listing the token balances.
 */ __turbopack_context__.s([
    "listTokenBalances",
    ()=>listTokenBalances
]);
async function listTokenBalances(client, options) {
    const response = await client.listDataTokenBalances(options.network, options.address, {
        pageSize: options.pageSize,
        pageToken: options.pageToken
    });
    const balances = response.balances.map((balance)=>{
        return {
            token: {
                network: balance.token.network,
                contractAddress: balance.token.contractAddress,
                symbol: balance.token.symbol,
                name: balance.token.name
            },
            amount: {
                amount: BigInt(balance.amount.amount),
                decimals: balance.amount.decimals
            }
        };
    });
    return {
        balances,
        nextPageToken: response.nextPageToken
    };
} //# sourceMappingURL=listTokenBalances.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/requestFaucet.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Requests funds from an EVM faucet.
 *
 * @param apiClient - The API client.
 * @param options - The options for requesting funds from the EVM faucet.
 *
 * @returns A promise that resolves to the transaction hash.
 */ __turbopack_context__.s([
    "requestFaucet",
    ()=>requestFaucet
]);
async function requestFaucet(apiClient, options) {
    const { transactionHash } = await apiClient.requestEvmFaucet({
        address: options.address,
        network: options.network,
        token: options.token
    }, options.idempotencyKey);
    return {
        transactionHash: transactionHash
    };
} //# sourceMappingURL=requestFaucet.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendTransaction.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "sendTransaction",
    ()=>sendTransaction
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$transaction$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/transaction/serializeTransaction.js [app-ssr] (ecmascript)");
;
async function sendTransaction(apiClient, options) {
    const { address, network, idempotencyKey } = options;
    let transaction = options.transaction;
    if (typeof transaction !== "string") {
        transaction = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$transaction$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["serializeTransaction"])({
            ...transaction,
            // chainId is ignored in favor of network
            chainId: 1,
            type: "eip1559"
        });
    }
    const result = await apiClient.sendEvmTransaction(address, {
        transaction,
        network
    }, idempotencyKey);
    return {
        transactionHash: result.transactionHash
    };
} //# sourceMappingURL=sendTransaction.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/spend-permissions/constants.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "SPEND_PERMISSION_MANAGER_ABI",
    ()=>SPEND_PERMISSION_MANAGER_ABI,
    "SPEND_PERMISSION_MANAGER_ADDRESS",
    ()=>SPEND_PERMISSION_MANAGER_ADDRESS
]);
const SPEND_PERMISSION_MANAGER_ADDRESS = "0xf85210B21cC50302F477BA56686d2019dC9b67Ad";
const SPEND_PERMISSION_MANAGER_ABI = [
    {
        inputs: [
            {
                internalType: "contract PublicERC6492Validator",
                name: "publicERC6492Validator",
                type: "address"
            },
            {
                internalType: "address",
                name: "magicSpend",
                type: "address"
            }
        ],
        stateMutability: "nonpayable",
        type: "constructor"
    },
    {
        inputs: [
            {
                internalType: "uint48",
                name: "currentTimestamp",
                type: "uint48"
            },
            {
                internalType: "uint48",
                name: "end",
                type: "uint48"
            }
        ],
        name: "AfterSpendPermissionEnd",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint48",
                name: "currentTimestamp",
                type: "uint48"
            },
            {
                internalType: "uint48",
                name: "start",
                type: "uint48"
            }
        ],
        name: "BeforeSpendPermissionStart",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "address",
                name: "token",
                type: "address"
            }
        ],
        name: "ERC721TokenNotSupported",
        type: "error"
    },
    {
        inputs: [],
        name: "EmptySpendPermissionBatch",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint256",
                name: "value",
                type: "uint256"
            },
            {
                internalType: "uint256",
                name: "allowance",
                type: "uint256"
            }
        ],
        name: "ExceededSpendPermission",
        type: "error"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint160",
                        name: "spend",
                        type: "uint160"
                    }
                ],
                internalType: "struct SpendPermissionManager.PeriodSpend",
                name: "actualLastUpdatedPeriod",
                type: "tuple"
            },
            {
                components: [
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint160",
                        name: "spend",
                        type: "uint160"
                    }
                ],
                internalType: "struct SpendPermissionManager.PeriodSpend",
                name: "expectedLastUpdatedPeriod",
                type: "tuple"
            }
        ],
        name: "InvalidLastUpdatedPeriod",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "address",
                name: "sender",
                type: "address"
            },
            {
                internalType: "address",
                name: "expected",
                type: "address"
            }
        ],
        name: "InvalidSender",
        type: "error"
    },
    {
        inputs: [],
        name: "InvalidSignature",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint48",
                name: "start",
                type: "uint48"
            },
            {
                internalType: "uint48",
                name: "end",
                type: "uint48"
            }
        ],
        name: "InvalidStartEnd",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint128",
                name: "noncePostfix",
                type: "uint128"
            },
            {
                internalType: "uint128",
                name: "permissionHashPostfix",
                type: "uint128"
            }
        ],
        name: "InvalidWithdrawRequestNonce",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "address",
                name: "firstAccount",
                type: "address"
            },
            {
                internalType: "address",
                name: "secondAccount",
                type: "address"
            }
        ],
        name: "MismatchedAccounts",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "address",
                name: "token",
                type: "address"
            }
        ],
        name: "SafeERC20FailedOperation",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "address",
                name: "spendToken",
                type: "address"
            },
            {
                internalType: "address",
                name: "withdrawAsset",
                type: "address"
            }
        ],
        name: "SpendTokenWithdrawAssetMismatch",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint256",
                name: "value",
                type: "uint256"
            }
        ],
        name: "SpendValueOverflow",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint256",
                name: "spendValue",
                type: "uint256"
            },
            {
                internalType: "uint256",
                name: "withdrawAmount",
                type: "uint256"
            }
        ],
        name: "SpendValueWithdrawAmountMismatch",
        type: "error"
    },
    {
        inputs: [],
        name: "UnauthorizedSpendPermission",
        type: "error"
    },
    {
        inputs: [
            {
                internalType: "uint256",
                name: "received",
                type: "uint256"
            },
            {
                internalType: "uint256",
                name: "expected",
                type: "uint256"
            }
        ],
        name: "UnexpectedReceiveAmount",
        type: "error"
    },
    {
        inputs: [],
        name: "ZeroAllowance",
        type: "error"
    },
    {
        inputs: [],
        name: "ZeroPeriod",
        type: "error"
    },
    {
        inputs: [],
        name: "ZeroSpender",
        type: "error"
    },
    {
        inputs: [],
        name: "ZeroToken",
        type: "error"
    },
    {
        inputs: [],
        name: "ZeroValue",
        type: "error"
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: "bytes32",
                name: "hash",
                type: "bytes32"
            },
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                indexed: false,
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "SpendPermissionApproved",
        type: "event"
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: "bytes32",
                name: "hash",
                type: "bytes32"
            },
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                indexed: false,
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "SpendPermissionRevoked",
        type: "event"
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: "bytes32",
                name: "hash",
                type: "bytes32"
            },
            {
                indexed: true,
                internalType: "address",
                name: "account",
                type: "address"
            },
            {
                indexed: true,
                internalType: "address",
                name: "spender",
                type: "address"
            },
            {
                indexed: false,
                internalType: "address",
                name: "token",
                type: "address"
            },
            {
                components: [
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint160",
                        name: "spend",
                        type: "uint160"
                    }
                ],
                indexed: false,
                internalType: "struct SpendPermissionManager.PeriodSpend",
                name: "periodSpend",
                type: "tuple"
            }
        ],
        name: "SpendPermissionUsed",
        type: "event"
    },
    {
        inputs: [],
        name: "MAGIC_SPEND",
        outputs: [
            {
                internalType: "address",
                name: "",
                type: "address"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [],
        name: "NATIVE_TOKEN",
        outputs: [
            {
                internalType: "address",
                name: "",
                type: "address"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [],
        name: "PERMISSION_DETAILS_TYPEHASH",
        outputs: [
            {
                internalType: "bytes32",
                name: "",
                type: "bytes32"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [],
        name: "PUBLIC_ERC6492_VALIDATOR",
        outputs: [
            {
                internalType: "contract PublicERC6492Validator",
                name: "",
                type: "address"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [],
        name: "SPEND_PERMISSION_BATCH_TYPEHASH",
        outputs: [
            {
                internalType: "bytes32",
                name: "",
                type: "bytes32"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [],
        name: "SPEND_PERMISSION_TYPEHASH",
        outputs: [
            {
                internalType: "bytes32",
                name: "",
                type: "bytes32"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "approve",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        components: [
                            {
                                internalType: "address",
                                name: "spender",
                                type: "address"
                            },
                            {
                                internalType: "address",
                                name: "token",
                                type: "address"
                            },
                            {
                                internalType: "uint160",
                                name: "allowance",
                                type: "uint160"
                            },
                            {
                                internalType: "uint256",
                                name: "salt",
                                type: "uint256"
                            },
                            {
                                internalType: "bytes",
                                name: "extraData",
                                type: "bytes"
                            }
                        ],
                        internalType: "struct SpendPermissionManager.PermissionDetails[]",
                        name: "permissions",
                        type: "tuple[]"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermissionBatch",
                name: "spendPermissionBatch",
                type: "tuple"
            },
            {
                internalType: "bytes",
                name: "signature",
                type: "bytes"
            }
        ],
        name: "approveBatchWithSignature",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "permissionToApprove",
                type: "tuple"
            },
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "permissionToRevoke",
                type: "tuple"
            },
            {
                components: [
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint160",
                        name: "spend",
                        type: "uint160"
                    }
                ],
                internalType: "struct SpendPermissionManager.PeriodSpend",
                name: "expectedLastUpdatedPeriod",
                type: "tuple"
            }
        ],
        name: "approveWithRevoke",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            },
            {
                internalType: "bytes",
                name: "signature",
                type: "bytes"
            }
        ],
        name: "approveWithSignature",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [],
        name: "eip712Domain",
        outputs: [
            {
                internalType: "bytes1",
                name: "fields",
                type: "bytes1"
            },
            {
                internalType: "string",
                name: "name",
                type: "string"
            },
            {
                internalType: "string",
                name: "version",
                type: "string"
            },
            {
                internalType: "uint256",
                name: "chainId",
                type: "uint256"
            },
            {
                internalType: "address",
                name: "verifyingContract",
                type: "address"
            },
            {
                internalType: "bytes32",
                name: "salt",
                type: "bytes32"
            },
            {
                internalType: "uint256[]",
                name: "extensions",
                type: "uint256[]"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        components: [
                            {
                                internalType: "address",
                                name: "spender",
                                type: "address"
                            },
                            {
                                internalType: "address",
                                name: "token",
                                type: "address"
                            },
                            {
                                internalType: "uint160",
                                name: "allowance",
                                type: "uint160"
                            },
                            {
                                internalType: "uint256",
                                name: "salt",
                                type: "uint256"
                            },
                            {
                                internalType: "bytes",
                                name: "extraData",
                                type: "bytes"
                            }
                        ],
                        internalType: "struct SpendPermissionManager.PermissionDetails[]",
                        name: "permissions",
                        type: "tuple[]"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermissionBatch",
                name: "spendPermissionBatch",
                type: "tuple"
            }
        ],
        name: "getBatchHash",
        outputs: [
            {
                internalType: "bytes32",
                name: "",
                type: "bytes32"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "getCurrentPeriod",
        outputs: [
            {
                components: [
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint160",
                        name: "spend",
                        type: "uint160"
                    }
                ],
                internalType: "struct SpendPermissionManager.PeriodSpend",
                name: "",
                type: "tuple"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "getHash",
        outputs: [
            {
                internalType: "bytes32",
                name: "",
                type: "bytes32"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "getLastUpdatedPeriod",
        outputs: [
            {
                components: [
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint160",
                        name: "spend",
                        type: "uint160"
                    }
                ],
                internalType: "struct SpendPermissionManager.PeriodSpend",
                name: "",
                type: "tuple"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "isApproved",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "isRevoked",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "isValid",
        outputs: [
            {
                internalType: "bool",
                name: "",
                type: "bool"
            }
        ],
        stateMutability: "view",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "revoke",
        outputs: [],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            }
        ],
        name: "revokeAsSpender",
        outputs: [],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            },
            {
                internalType: "uint160",
                name: "value",
                type: "uint160"
            }
        ],
        name: "spend",
        outputs: [],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        inputs: [
            {
                components: [
                    {
                        internalType: "address",
                        name: "account",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "spender",
                        type: "address"
                    },
                    {
                        internalType: "address",
                        name: "token",
                        type: "address"
                    },
                    {
                        internalType: "uint160",
                        name: "allowance",
                        type: "uint160"
                    },
                    {
                        internalType: "uint48",
                        name: "period",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "start",
                        type: "uint48"
                    },
                    {
                        internalType: "uint48",
                        name: "end",
                        type: "uint48"
                    },
                    {
                        internalType: "uint256",
                        name: "salt",
                        type: "uint256"
                    },
                    {
                        internalType: "bytes",
                        name: "extraData",
                        type: "bytes"
                    }
                ],
                internalType: "struct SpendPermissionManager.SpendPermission",
                name: "spendPermission",
                type: "tuple"
            },
            {
                internalType: "uint160",
                name: "value",
                type: "uint160"
            },
            {
                components: [
                    {
                        internalType: "bytes",
                        name: "signature",
                        type: "bytes"
                    },
                    {
                        internalType: "address",
                        name: "asset",
                        type: "address"
                    },
                    {
                        internalType: "uint256",
                        name: "amount",
                        type: "uint256"
                    },
                    {
                        internalType: "uint256",
                        name: "nonce",
                        type: "uint256"
                    },
                    {
                        internalType: "uint48",
                        name: "expiry",
                        type: "uint48"
                    }
                ],
                internalType: "struct MagicSpend.WithdrawRequest",
                name: "withdrawRequest",
                type: "tuple"
            }
        ],
        name: "spendWithWithdraw",
        outputs: [],
        stateMutability: "nonpayable",
        type: "function"
    },
    {
        stateMutability: "payable",
        type: "receive"
    }
]; //# sourceMappingURL=constants.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/serializeTransaction.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "serializeEIP1559Transaction",
    ()=>serializeEIP1559Transaction
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$transaction$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/transaction/serializeTransaction.js [app-ssr] (ecmascript)");
;
function serializeEIP1559Transaction(transaction) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$transaction$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["serializeTransaction"])({
        ...transaction,
        chainId: 1,
        type: "eip1559"
    });
} //# sourceMappingURL=serializeTransaction.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/spend-permissions/account.use.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useSpendPermission",
    ()=>useSpendPermission
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/spend-permissions/constants.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/serializeTransaction.js [app-ssr] (ecmascript)");
;
;
;
async function useSpendPermission(apiClient, address, options) {
    const { spendPermission, value, network } = options;
    const result = await apiClient.sendEvmTransaction(address, {
        transaction: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["serializeEIP1559Transaction"])({
            to: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SPEND_PERMISSION_MANAGER_ADDRESS"],
            data: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
                abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SPEND_PERMISSION_MANAGER_ABI"],
                functionName: "spend",
                args: [
                    spendPermission,
                    value
                ]
            })
        }),
        network: network
    });
    return {
        transactionHash: result.transactionHash
    };
} //# sourceMappingURL=account.use.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/uuidV4.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createDeterministicUuidV4",
    ()=>createDeterministicUuidV4
]);
var __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/crypto [external] (crypto, cjs)");
;
function createDeterministicUuidV4(input, salt = "salt") {
    const hash = (0, __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["createHash"])("sha256").update(input + "-" + salt).digest("hex");
    // Format as UUIDv4: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
    return [
        hash.slice(0, 8),
        hash.slice(8, 12),
        "4" + hash.slice(13, 16),
        (parseInt(hash.slice(16, 17), 16) & 0x3 | 0x8).toString(16) + hash.slice(17, 20),
        hash.slice(20, 32)
    ].join("-");
} //# sourceMappingURL=uuidV4.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "sendUserOperation",
    ()=>sendUserOperation
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$getBaseNodeRpcUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/getBaseNodeRpcUrl.js [app-ssr] (ecmascript)");
;
;
async function sendUserOperation(client, options) {
    const { calls, network, paymasterUrl: _paymasterUrl } = options;
    const paymasterUrl = await (async ()=>{
        if (!_paymasterUrl && network === "base") {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$getBaseNodeRpcUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBaseNodeRpcUrl"])("base");
        }
        return _paymasterUrl;
    })();
    if (calls.length === 0) {
        throw new Error("Calls array is empty");
    }
    const encodedCalls = calls.map((call)=>{
        const value = (call.value ?? BigInt(0)).toString();
        if ("abi" in call && call.abi && "functionName" in call) {
            return {
                to: call.to,
                data: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
                    abi: call.abi,
                    functionName: call.functionName,
                    args: call.args
                }),
                value
            };
        }
        return {
            to: call.to,
            data: call.data ?? "0x",
            value
        };
    });
    const createOpResponse = await client.prepareUserOperation(options.smartAccount.address, {
        network,
        calls: encodedCalls,
        paymasterUrl
    });
    const owner = options.smartAccount.owners[0];
    const signature = await owner.sign({
        hash: createOpResponse.userOpHash
    });
    const broadcastResponse = await client.sendUserOperation(options.smartAccount.address, createOpResponse.userOpHash, {
        signature
    }, options.idempotencyKey);
    return {
        smartAccountAddress: options.smartAccount.address,
        status: broadcastResponse.status,
        userOpHash: createOpResponse.userOpHash
    };
} //# sourceMappingURL=sendUserOperation.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/signAndWrapTypedDataForSmartAccount.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createReplaySafeTypedData",
    ()=>createReplaySafeTypedData,
    "createSmartAccountSignatureWrapper",
    ()=>createSmartAccountSignatureWrapper,
    "signAndWrapTypedDataForSmartAccount",
    ()=>signAndWrapTypedDataForSmartAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeAbiParameters$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeAbiParameters.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodePacked$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodePacked.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$signature$2f$hashTypedData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/signature/hashTypedData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$slice$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/data/slice.js [app-ssr] (ecmascript)");
;
async function signAndWrapTypedDataForSmartAccount(client, options) {
    const { smartAccount, chainId, typedData, ownerIndex = 0n } = options;
    // Create the replay-safe typed data
    const replaySafeTypedData = createReplaySafeTypedData({
        typedData,
        chainId,
        smartAccountAddress: smartAccount.address
    });
    // Sign the replay-safe typed data with the smart account owner
    const owner = smartAccount.owners[Number(ownerIndex)];
    const signature = await client.signEvmTypedData(owner.address, replaySafeTypedData, options.idempotencyKey);
    // Wrap the signature in the format expected by the smart contract
    const wrappedSignature = createSmartAccountSignatureWrapper({
        signatureHex: signature.signature,
        ownerIndex
    });
    return {
        signature: wrappedSignature
    };
}
function createReplaySafeTypedData({ typedData, chainId, smartAccountAddress }) {
    // First hash the original typed data
    const originalHash = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$signature$2f$hashTypedData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["hashTypedData"])(typedData);
    // Create and return the replay-safe typed data structure
    return {
        domain: {
            name: "Coinbase Smart Wallet",
            version: "1",
            chainId: Number(chainId),
            verifyingContract: smartAccountAddress
        },
        types: {
            EIP712Domain: [
                {
                    name: "name",
                    type: "string"
                },
                {
                    name: "version",
                    type: "string"
                },
                {
                    name: "chainId",
                    type: "uint256"
                },
                {
                    name: "verifyingContract",
                    type: "address"
                }
            ],
            CoinbaseSmartWalletMessage: [
                {
                    name: "hash",
                    type: "bytes32"
                }
            ]
        },
        primaryType: "CoinbaseSmartWalletMessage",
        message: {
            hash: originalHash
        }
    };
}
function createSmartAccountSignatureWrapper({ signatureHex, ownerIndex }) {
    // Decompose 65-byte hex signature into r (32 bytes), s (32 bytes), v (1 byte)
    const r = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$slice$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sliceHex"])(signatureHex, 0, 32);
    const s = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$slice$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sliceHex"])(signatureHex, 32, 64);
    const v = Number(`0x${signatureHex.slice(130, 132)}`); // 130 = 2 + 64 + 64
    const signatureData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodePacked$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodePacked"])([
        "bytes32",
        "bytes32",
        "uint8"
    ], [
        r,
        s,
        v
    ]);
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeAbiParameters$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeAbiParameters"])([
        SignatureWrapperStruct
    ], [
        {
            ownerIndex: Number(ownerIndex),
            signatureData
        }
    ]);
}
/**
 * The ABI structure for the SignatureWrapper struct expected by Coinbase Smart Wallets.
 * This matches the struct defined in the smart contract:
 *
 * struct SignatureWrapper {
 *   uint256 ownerIndex;
 *   bytes signatureData;
 * }
 */ const SignatureWrapperStruct = {
    components: [
        {
            name: "ownerIndex",
            type: "uint8"
        },
        {
            name: "signatureData",
            type: "bytes"
        }
    ],
    name: "SignatureWrapper",
    type: "tuple"
}; //# sourceMappingURL=signAndWrapTypedDataForSmartAccount.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapOperation.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "sendSwapOperation",
    ()=>sendSwapOperation
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/data/concat.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/encoding/toHex.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$size$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/data/size.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$uuidV4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/uuidV4.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$signAndWrapTypedDataForSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/signAndWrapTypedDataForSmartAccount.js [app-ssr] (ecmascript)");
;
;
;
;
;
async function sendSwapOperation(client, options) {
    const { smartAccount, paymasterUrl, idempotencyKey } = options;
    let swapResult;
    // Determine if we need to create the swap quote or use the provided one
    if ("swapQuote" in options) {
        // Use the provided swap quote
        swapResult = options.swapQuote;
    } else {
        // Create the swap quote using the provided options (inline options)
        /**
         * Deterministically derive a new idempotency key from the provided idempotency key for swap quote creation to avoid key reuse.
         */ const swapQuoteIdempotencyKey = idempotencyKey ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$uuidV4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createDeterministicUuidV4"])(idempotencyKey, "createSwapQuote") : undefined;
        swapResult = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSwapQuote"])(client, {
            network: options.network,
            toToken: options.toToken,
            fromToken: options.fromToken,
            fromAmount: options.fromAmount,
            taker: options.taker,
            signerAddress: options.signerAddress,
            gasPrice: options.gasPrice,
            slippageBps: options.slippageBps,
            idempotencyKey: swapQuoteIdempotencyKey
        });
    }
    // Check if liquidity is available
    if (!swapResult.liquidityAvailable) {
        throw new Error("Insufficient liquidity for swap");
    }
    // At this point, we know that swapResult is CreateSwapQuoteResult
    const swap = swapResult;
    // Check for allowance issues
    if (swap.issues?.allowance) {
        const { currentAllowance, spender } = swap.issues.allowance;
        throw new Error(`Insufficient token allowance for swap. Current allowance: ${currentAllowance}. ` + `Please approve the Permit2 contract (${spender}) to spend your tokens.`);
    }
    // If the transaction doesn't exist, throw an error
    if (!swap.transaction) {
        throw new Error("No transaction data found in the swap");
    }
    // Get the transaction data and modify it if needed for Permit2
    let txData = swap.transaction.data;
    if (swap.permit2?.eip712) {
        // Create the permit2 idempotency key
        const permit2IdempotencyKey = idempotencyKey ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$uuidV4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createDeterministicUuidV4"])(idempotencyKey, "permit2") : undefined;
        // Sign and wrap the permit2 typed data according to the Coinbase Smart Wallet contract requirements for EIP-712 signatures
        const { signature: wrappedSignature } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$signAndWrapTypedDataForSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["signAndWrapTypedDataForSmartAccount"])(client, {
            smartAccount,
            chainId: BigInt(swap.permit2.eip712.domain.chainId || 1),
            typedData: swap.permit2.eip712,
            ownerIndex: 0n,
            idempotencyKey: permit2IdempotencyKey
        });
        // Calculate the Permit2 signature length as a 32-byte hex value
        const permit2SignatureLengthInHex = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["numberToHex"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$size$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["size"])(wrappedSignature), {
            signed: false,
            size: 32
        });
        // Append the Permit2 signature length and signature to the transaction data
        txData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["concat"])([
            txData,
            permit2SignatureLengthInHex,
            wrappedSignature
        ]);
    }
    // Send the swap as a user operation
    const result = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(client, {
        smartAccount: smartAccount,
        network: swap.network,
        paymasterUrl,
        idempotencyKey,
        calls: [
            {
                to: swap.transaction.to,
                data: txData,
                // Only include value if it exists
                ...swap.transaction.value ? {
                    value: BigInt(swap.transaction.value)
                } : {}
            }
        ]
    });
    return result;
} //# sourceMappingURL=sendSwapOperation.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapTransaction.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "sendSwapTransaction",
    ()=>sendSwapTransaction
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/data/concat.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/encoding/toHex.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$size$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/data/size.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$uuidV4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/uuidV4.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendTransaction.js [app-ssr] (ecmascript)");
;
;
;
;
async function sendSwapTransaction(client, options) {
    const { address, idempotencyKey } = options;
    let swapResult;
    // Determine if we need to create the swap quote or use the provided one
    if ("swapQuote" in options) {
        // Use the provided swap quote
        swapResult = options.swapQuote;
    } else {
        // Create the swap quote using the provided options (InlineSendSwapTransactionOptions)
        /**
         * Deterministically derive a new idempotency key from the provided idempotency key for swap quote creation to avoid key reuse.
         */ const swapQuoteIdempotencyKey = idempotencyKey ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$uuidV4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createDeterministicUuidV4"])(idempotencyKey, "createSwapQuote") : undefined;
        swapResult = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSwapQuote"])(client, {
            network: options.network,
            toToken: options.toToken,
            fromToken: options.fromToken,
            fromAmount: options.fromAmount,
            taker: options.taker,
            signerAddress: options.signerAddress,
            gasPrice: options.gasPrice,
            slippageBps: options.slippageBps,
            idempotencyKey: swapQuoteIdempotencyKey
        });
    }
    // Check if liquidity is available
    if (!swapResult.liquidityAvailable) {
        throw new Error("Insufficient liquidity for swap");
    }
    // At this point, we know that swapResult is CreateSwapQuoteResult
    const swap = swapResult;
    // Check for allowance issues
    if (swap.issues?.allowance) {
        const { currentAllowance, spender } = swap.issues.allowance;
        throw new Error(`Insufficient token allowance for swap. Current allowance: ${currentAllowance}. ` + `Please approve the Permit2 contract (${spender}) to spend your tokens.`);
    }
    // If the transaction doesn't exist, throw an error
    if (!swap.transaction) {
        throw new Error("No transaction data found in the swap");
    }
    // Get the transaction data and modify it if needed for Permit2
    let txData = swap.transaction.data;
    if (swap.permit2?.eip712) {
        /**
         * Sign the Permit2 EIP-712 message.
         * Deterministically derive a new idempotency key from the provided idempotency key for permit2 signing to avoid key reuse.
         */ const permit2IdempotencyKey = idempotencyKey ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$uuidV4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createDeterministicUuidV4"])(idempotencyKey, "permit2") : undefined;
        const signature = await client.signEvmTypedData(address, {
            domain: swap.permit2.eip712.domain,
            types: swap.permit2.eip712.types,
            primaryType: swap.permit2.eip712.primaryType,
            message: swap.permit2.eip712.message
        }, permit2IdempotencyKey);
        // Calculate the signature length as a 32-byte hex value
        const signatureLengthInHex = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["numberToHex"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$size$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["size"])(signature.signature), {
            signed: false,
            size: 32
        });
        // Append the signature length and signature to the transaction data
        txData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["concat"])([
            txData,
            signatureLengthInHex,
            signature.signature
        ]);
    }
    // Create a transaction object
    const transaction = {
        to: swap.transaction.to,
        data: txData,
        // Only include these properties if they exist
        ...swap.transaction.value ? {
            value: BigInt(swap.transaction.value)
        } : {},
        ...swap.transaction.gas ? {
            gas: BigInt(swap.transaction.gas)
        } : {}
    };
    // Use sendTransaction instead of directly calling client.sendEvmTransaction
    const result = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendTransaction"])(client, {
        address,
        network: swap.network,
        transaction,
        idempotencyKey
    });
    return {
        transactionHash: result.transactionHash
    };
} //# sourceMappingURL=sendSwapTransaction.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createSwapQuote",
    ()=>createSwapQuote
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapTransaction.js [app-ssr] (ecmascript)");
;
;
async function createSwapQuote(client, options) {
    // Validate required parameters
    if (!options.taker) {
        throw new Error("taker is required for createSwapQuote");
    }
    // Store validated taker for type safety
    const taker = options.taker;
    // Call the createEvmSwapQuote function directly with the client's configured API
    const response = await client.createEvmSwapQuote({
        network: options.network,
        toToken: options.toToken,
        fromToken: options.fromToken,
        fromAmount: options.fromAmount.toString(),
        taker: taker,
        signerAddress: options.signerAddress,
        gasPrice: options.gasPrice?.toString(),
        slippageBps: options.slippageBps
    }, options.idempotencyKey);
    // Check if liquidity is unavailable
    if (!response.liquidityAvailable) {
        // Return the SwapUnavailableResult
        return {
            liquidityAvailable: false
        };
    }
    // At this point we know it's a CreateSwapQuoteResponse with liquidityAvailable as true
    const swapResponse = response;
    const result = {
        liquidityAvailable: true,
        network: options.network,
        toToken: swapResponse.toToken,
        fromToken: swapResponse.fromToken,
        fromAmount: BigInt(swapResponse.fromAmount),
        toAmount: BigInt(swapResponse.toAmount),
        minToAmount: BigInt(swapResponse.minToAmount),
        blockNumber: BigInt(swapResponse.blockNumber),
        fees: {
            gasFee: swapResponse.fees.gasFee ? {
                amount: BigInt(swapResponse.fees.gasFee.amount),
                token: swapResponse.fees.gasFee.token
            } : undefined,
            protocolFee: swapResponse.fees.protocolFee ? {
                amount: BigInt(swapResponse.fees.protocolFee.amount),
                token: swapResponse.fees.protocolFee.token
            } : undefined
        },
        issues: {
            allowance: swapResponse.issues.allowance ? {
                currentAllowance: BigInt(swapResponse.issues.allowance.currentAllowance),
                spender: swapResponse.issues.allowance.spender
            } : undefined,
            balance: swapResponse.issues.balance ? {
                token: swapResponse.issues.balance.token,
                currentBalance: BigInt(swapResponse.issues.balance.currentBalance),
                requiredBalance: BigInt(swapResponse.issues.balance.requiredBalance)
            } : undefined,
            simulationIncomplete: swapResponse.issues.simulationIncomplete
        },
        transaction: swapResponse.transaction ? {
            to: swapResponse.transaction.to,
            data: swapResponse.transaction.data,
            value: BigInt(swapResponse.transaction.value),
            gas: BigInt(swapResponse.transaction.gas),
            gasPrice: BigInt(swapResponse.transaction.gasPrice)
        } : undefined,
        permit2: swapResponse.permit2 ? {
            eip712: {
                domain: {
                    ...swapResponse.permit2.eip712.domain,
                    verifyingContract: swapResponse.permit2.eip712.domain.verifyingContract,
                    salt: swapResponse.permit2.eip712.domain.salt
                },
                types: swapResponse.permit2.eip712.types,
                primaryType: swapResponse.permit2.eip712.primaryType,
                message: swapResponse.permit2.eip712.message
            }
        } : undefined,
        // Add the execute method
        execute: async (executeOptions = {})=>{
            if (options.smartAccount) {
                // Smart account execution - use sendSwapOperation
                const userOpResult = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendSwapOperation"])(client, {
                    smartAccount: options.smartAccount,
                    network: result.network,
                    swapQuote: result,
                    idempotencyKey: executeOptions.idempotencyKey
                });
                return {
                    userOpHash: userOpResult.userOpHash,
                    smartAccountAddress: userOpResult.smartAccountAddress,
                    status: userOpResult.status
                };
            } else {
                // EOA execution - use sendSwapTransaction
                const { transactionHash } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendSwapTransaction"])(client, {
                    address: taker,
                    network: result.network,
                    swapQuote: result,
                    idempotencyKey: executeOptions.idempotencyKey
                });
                return {
                    transactionHash
                };
            }
        }
    };
    return result;
} //# sourceMappingURL=createSwapQuote.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/accountTransferStrategy.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "accountTransferStrategy",
    ()=>accountTransferStrategy
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/constants/abis.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/utils.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/serializeTransaction.js [app-ssr] (ecmascript)");
;
;
;
const accountTransferStrategy = {
    executeTransfer: async ({ apiClient, from, to, value, token, network })=>{
        network = network;
        if (token === "eth") {
            return apiClient.sendEvmTransaction(from.address, {
                transaction: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["serializeEIP1559Transaction"])({
                    value,
                    to
                }),
                network
            });
        }
        const erc20Address = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getErc20Address"])(token, network);
        return apiClient.sendEvmTransaction(from.address, {
            transaction: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["serializeEIP1559Transaction"])({
                to: erc20Address,
                data: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
                    abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["erc20Abi"],
                    functionName: "transfer",
                    args: [
                        to,
                        value
                    ]
                })
            }),
            network
        });
    }
}; //# sourceMappingURL=accountTransferStrategy.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/types.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "isSmartAccount",
    ()=>isSmartAccount,
    "isValidNetworkForAccount",
    ()=>isValidNetworkForAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
;
function isValidNetworkForAccount(network, account) {
    if (isSmartAccount(account)) {
        return Object.values(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationNetwork"]).includes(network);
    }
    return true;
}
function isSmartAccount(account) {
    return "type" in account && account.type === "evm-smart";
} //# sourceMappingURL=types.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/transfer.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "transfer",
    ()=>transfer
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$types$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/types.js [app-ssr] (ecmascript)");
;
async function transfer(apiClient, from, transferArgs, transferStrategy) {
    if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$types$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isValidNetworkForAccount"])(transferArgs.network, from)) {
        throw new Error(`Network "${transferArgs.network}" is not supported for the given account type.`);
    }
    const to = typeof transferArgs.to === "string" ? transferArgs.to : transferArgs.to.address;
    const transfer = {
        apiClient,
        from,
        to,
        value: transferArgs.amount,
        token: transferArgs.token,
        network: transferArgs.network,
        paymasterUrl: "paymasterUrl" in transferArgs ? transferArgs.paymasterUrl : undefined
    };
    return transferStrategy.executeTransfer(transfer);
} //# sourceMappingURL=transfer.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/wait.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "wait",
    ()=>wait
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
;
async function wait(reload, isTerminal, transform = (obj)=>obj, options = {}) {
    const { intervalSeconds = 0.2, timeoutSeconds = 10 } = options;
    const startTime = Date.now();
    while(Date.now() - startTime < timeoutSeconds * 1000){
        const updatedObject = await reload();
        if (isTerminal(updatedObject)) {
            return transform(updatedObject);
        }
        await new Promise((resolve)=>setTimeout(resolve, intervalSeconds * 1000));
    }
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TimeoutError"](`Operation has not reached a terminal state after ${timeoutSeconds} seconds and may still succeed. Retry with a longer timeout using the timeoutSeconds option.`);
} //# sourceMappingURL=wait.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/waitForFundOperationReceipt.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "waitForFundOperationReceipt",
    ()=>waitForFundOperationReceipt
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$wait$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/wait.js [app-ssr] (ecmascript)");
;
;
async function waitForFundOperationReceipt(client, options) {
    const { transferId } = options;
    const reload = async ()=>{
        const response = await client.getPaymentTransfer(transferId);
        return response;
    };
    const transform = (operation)=>{
        if (operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TransferStatus"].failed) {
            return {
                id: operation.id,
                network: operation.target.network,
                targetAmount: operation.targetAmount,
                targetCurrency: operation.targetCurrency,
                status: operation.status
            };
        } else if (operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TransferStatus"].completed) {
            return {
                id: operation.id,
                network: operation.target.network,
                targetAmount: operation.targetAmount,
                targetCurrency: operation.targetCurrency,
                status: operation.status,
                transactionHash: operation.transactionHash
            };
        } else {
            throw new Error("Transfer is not terminal");
        }
    };
    const waitOptions = options.waitOptions || {
        timeoutSeconds: 900,
        intervalSeconds: 1
    };
    return await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$wait$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wait"])(reload, isTerminal, transform, waitOptions);
}
const isTerminal = (operation)=>{
    return operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TransferStatus"].completed || operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TransferStatus"].failed;
}; //# sourceMappingURL=waitForFundOperationReceipt.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toEvmServerAccount.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "toEvmServerAccount",
    ()=>toEvmServerAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$typedData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/typedData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$transaction$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/transaction/serializeTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toNetworkScopedEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toNetworkScopedEvmServerAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/fund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/quoteFund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listTokenBalances.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/requestFaucet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$spend$2d$permissions$2f$account$2e$use$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/spend-permissions/account.use.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$accountTransferStrategy$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/accountTransferStrategy.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/transfer.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/waitForFundOperationReceipt.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
;
function toEvmServerAccount(apiClient, options) {
    const account = {
        address: options.account.address,
        async signMessage ({ message }) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign_message",
                accountType: "evm_server"
            });
            const result = await apiClient.signEvmMessage(options.account.address, {
                message: message.toString()
            });
            return result.signature;
        },
        async sign (parameters) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign",
                accountType: "evm_server"
            });
            const result = await apiClient.signEvmHash(options.account.address, {
                hash: parameters.hash
            });
            return result.signature;
        },
        async signTransaction (transaction) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign_transaction",
                accountType: "evm_server"
            });
            const result = await apiClient.signEvmTransaction(options.account.address, {
                transaction: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$transaction$2f$serializeTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["serializeTransaction"])(transaction)
            });
            return result.signedTransaction;
        },
        async signTypedData (parameters) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign_typed_data",
                accountType: "evm_server"
            });
            const { domain = {}, message, primaryType } = parameters;
            const types = {
                EIP712Domain: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$typedData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTypesForEIP712Domain"])({
                    domain
                }),
                ...parameters.types
            };
            const openApiMessage = {
                domain: domain,
                types,
                primaryType,
                message
            };
            const result = await apiClient.signEvmTypedData(options.account.address, openApiMessage);
            return result.signature;
        },
        async transfer (transferArgs) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "transfer",
                accountType: "evm_server",
                properties: {
                    network: transferArgs.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["transfer"])(apiClient, account, transferArgs, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$accountTransferStrategy$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["accountTransferStrategy"]);
        },
        async listTokenBalances (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "list_token_balances",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["listTokenBalances"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async requestFaucet (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "request_faucet",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["requestFaucet"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async sendTransaction (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "send_transaction",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendTransaction"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async quoteFund (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "quote_fund",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["quoteFund"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async fund (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "fund",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fund"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async waitForFundOperationReceipt (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "wait_for_fund_operation_receipt",
                accountType: "evm_server"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForFundOperationReceipt"])(apiClient, options);
        },
        async quoteSwap (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "quote_swap",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSwapQuote"])(apiClient, {
                ...options,
                taker: this.address
            });
        },
        async swap (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "swap",
                accountType: "evm_server",
                properties: {
                    network: "network" in options ? options.network : undefined
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendSwapTransaction"])(apiClient, {
                ...options,
                address: this.address,
                taker: this.address
            });
        },
        async useSpendPermission (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "use_spend_permission",
                accountType: "evm_server",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$spend$2d$permissions$2f$account$2e$use$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useSpendPermission"])(apiClient, this.address, options);
        },
        name: options.account.name,
        type: "evm-server",
        policies: options.account.policies,
        useNetwork: async (networkOrRpcUrl)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "use_network",
                accountType: "evm_server",
                properties: {
                    network: networkOrRpcUrl
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toNetworkScopedEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toNetworkScopedEvmServerAccount"])({
                account,
                network: networkOrRpcUrl
            });
        }
    };
    return account;
} //# sourceMappingURL=toEvmServerAccount.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/getUserOperation.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Gets a user operation for a smart account by user operation hash.
 *
 * @param {CdpOpenApiClientType} client - The client to use to get the user operation.
 * @param {GetUserOperationOptions} options - Parameters for getting the user operation.
 * @param {SmartAccount} options.smartAccount - The smart account signing the user operation.
 * @param {string} options.userOpHash - The user operation hash.
 *
 * @returns A promise that resolves to the user operation.
 *
 * @example
 * ```ts
 * const userOp = await getUserOperation(client, {
 *   smartAccount,
 *   userOpHash: "0x1234567890123456789012345678901234567890123456789012345678901234",
 * });
 * ```
 */ __turbopack_context__.s([
    "getUserOperation",
    ()=>getUserOperation
]);
async function getUserOperation(client, options) {
    const address = typeof options.smartAccount === "string" ? options.smartAccount : options.smartAccount.address;
    const userOp = await client.getUserOperation(address, options.userOpHash);
    return {
        calls: userOp.calls.map((call)=>({
                to: call.to,
                value: BigInt(call.value),
                data: call.data
            })),
        network: userOp.network,
        status: userOp.status,
        transactionHash: userOp.transactionHash,
        userOpHash: userOp.userOpHash,
        receipts: userOp.receipts
    };
} //# sourceMappingURL=getUserOperation.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/smartAccountTransferStrategy.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "smartAccountTransferStrategy",
    ()=>smartAccountTransferStrategy
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/constants/abis.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/utils.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)");
;
;
;
const smartAccountTransferStrategy = {
    executeTransfer: async ({ apiClient, from, to, value, token, network, paymasterUrl })=>{
        const smartAccountNetwork = network;
        if (token === "eth") {
            const result = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(apiClient, {
                smartAccount: from,
                paymasterUrl,
                network: smartAccountNetwork,
                calls: [
                    {
                        to,
                        value,
                        data: "0x"
                    }
                ]
            });
            return result;
        } else {
            const erc20Address = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getErc20Address"])(token, network);
            const result = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(apiClient, {
                smartAccount: from,
                paymasterUrl,
                network: smartAccountNetwork,
                calls: [
                    {
                        to: erc20Address,
                        data: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
                            abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$constants$2f$abis$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["erc20Abi"],
                            functionName: "transfer",
                            args: [
                                to,
                                value
                            ]
                        })
                    }
                ]
            });
            return result;
        }
    }
}; //# sourceMappingURL=smartAccountTransferStrategy.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/waitForUserOperation.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "waitForUserOperation",
    ()=>waitForUserOperation
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$wait$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/wait.js [app-ssr] (ecmascript)");
;
;
async function waitForUserOperation(client, options) {
    const { userOpHash, smartAccountAddress } = options;
    const reload = async ()=>{
        const response = await client.getUserOperation(smartAccountAddress, userOpHash);
        return response;
    };
    const transform = (operation)=>{
        if (operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationStatus"].failed) {
            return {
                smartAccountAddress: smartAccountAddress,
                status: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationStatus"].failed,
                userOpHash: operation.userOpHash
            };
        } else if (operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationStatus"].complete) {
            return {
                smartAccountAddress: smartAccountAddress,
                transactionHash: operation.transactionHash,
                status: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationStatus"].complete,
                userOpHash: operation.userOpHash
            };
        } else {
            throw new Error("User operation is not terminal");
        }
    };
    const waitOptions = options.waitOptions || {
        timeoutSeconds: 30
    };
    return await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$wait$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wait"])(reload, isTerminal, transform, waitOptions);
}
const isTerminal = (operation)=>{
    return operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationStatus"].complete || operation.status === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmUserOperationStatus"].failed;
}; //# sourceMappingURL=waitForUserOperation.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toNetworkScopedEvmSmartAccount.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "toNetworkScopedEvmSmartAccount",
    ()=>toNetworkScopedEvmSmartAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$getBaseNodeRpcUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/getBaseNodeRpcUrl.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/networkCapabilities.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/fund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/quoteFund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$getUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/getUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listTokenBalances.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/requestFaucet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$smartAccountTransferStrategy$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/smartAccountTransferStrategy.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/transfer.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$waitForUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/waitForUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/waitForFundOperationReceipt.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
async function toNetworkScopedEvmSmartAccount(apiClient, options) {
    const paymasterUrl = await (async ()=>{
        if (options.network === "base") {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$getBaseNodeRpcUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBaseNodeRpcUrl"])(options.network);
        }
        return undefined;
    })();
    const account = {
        address: options.smartAccount.address,
        network: options.network,
        owners: [
            options.owner
        ],
        name: options.smartAccount.name,
        type: "evm-smart",
        sendUserOperation: async (userOpOptions)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "send_user_operation",
                accountType: "evm_smart",
                properties: {
                    network: options.network,
                    managed: true
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(apiClient, {
                ...userOpOptions,
                smartAccount: options.smartAccount,
                network: options.network,
                paymasterUrl: userOpOptions.paymasterUrl ?? paymasterUrl
            });
        },
        waitForUserOperation: async (waitOptions)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "wait_for_user_operation",
                accountType: "evm_smart",
                properties: {
                    managed: true
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$waitForUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForUserOperation"])(apiClient, {
                ...waitOptions,
                smartAccountAddress: options.smartAccount.address
            });
        },
        getUserOperation: async (getOptions)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "get_user_operation",
                accountType: "evm_smart",
                properties: {
                    managed: true
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$getUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUserOperation"])(apiClient, {
                ...getOptions,
                smartAccount: options.smartAccount
            });
        }
    };
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("transfer", options.network)) {
        Object.assign(account, {
            transfer: async (transferOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "transfer",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["transfer"])(apiClient, options.smartAccount, {
                    ...transferOptions,
                    network: options.network,
                    paymasterUrl: transferOptions.paymasterUrl ?? paymasterUrl
                }, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$smartAccountTransferStrategy$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["smartAccountTransferStrategy"]);
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("listTokenBalances", options.network)) {
        Object.assign(account, {
            listTokenBalances: async (listOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "list_token_balances",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["listTokenBalances"])(apiClient, {
                    ...listOptions,
                    address: options.smartAccount.address,
                    network: options.network
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("requestFaucet", options.network)) {
        Object.assign(account, {
            requestFaucet: async (faucetOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "request_faucet",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["requestFaucet"])(apiClient, {
                    ...faucetOptions,
                    address: options.smartAccount.address,
                    network: options.network
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("quoteFund", options.network)) {
        Object.assign(account, {
            quoteFund: async (quoteOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "quote_fund",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["quoteFund"])(apiClient, {
                    ...quoteOptions,
                    address: options.smartAccount.address
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("fund", options.network)) {
        Object.assign(account, {
            fund: async (fundOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "fund",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fund"])(apiClient, {
                    ...fundOptions,
                    address: options.smartAccount.address
                });
            },
            waitForFundOperationReceipt: async (waitOptions)=>{
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForFundOperationReceipt"])(apiClient, waitOptions);
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("quoteSwap", options.network)) {
        Object.assign(account, {
            quoteSwap: async (quoteSwapOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "quote_swap",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSwapQuote"])(apiClient, {
                    ...quoteSwapOptions,
                    taker: options.smartAccount.address,
                    signerAddress: options.owner.address,
                    smartAccount: options.smartAccount,
                    network: options.network
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("swap", options.network)) {
        Object.assign(account, {
            swap: async (swapOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "swap",
                    accountType: "evm_smart",
                    properties: {
                        network: options.network,
                        managed: true
                    }
                });
                /*
                 * For network-scoped accounts, we need to add the network parameter
                 * for inline swaps while preserving quote-based swaps as-is
                 */ const swapOptionsWithNetwork = "swapQuote" in swapOptions ? swapOptions // Quote-based swap, pass through
                 : {
                    ...swapOptions,
                    network: options.network
                }; // Inline swap, add network
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendSwapOperation"])(apiClient, {
                    ...swapOptionsWithNetwork,
                    smartAccount: options.smartAccount,
                    taker: options.smartAccount.address,
                    signerAddress: options.owner.address,
                    paymasterUrl: swapOptions.paymasterUrl ?? paymasterUrl
                });
            }
        });
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkCapabilities$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isMethodSupportedOnNetwork"])("useSpendPermission", options.network)) {
        Object.assign(account, {
            useSpendPermission: async (spendPermissionOptions)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                    action: "use_spend_permission",
                    accountType: "evm_smart",
                    properties: {
                        managed: true
                    }
                });
                return options.smartAccount.useSpendPermission({
                    ...spendPermissionOptions,
                    network: options.network
                });
            }
        });
    }
    return account;
} //# sourceMappingURL=toNetworkScopedEvmSmartAccount.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/spend-permissions/smartAccount.use.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useSpendPermission",
    ()=>useSpendPermission
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/spend-permissions/constants.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)");
;
;
;
function useSpendPermission(apiClient, account, options) {
    const { spendPermission, value, network } = options;
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
        abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SPEND_PERMISSION_MANAGER_ABI"],
        functionName: "spend",
        args: [
            spendPermission,
            value
        ]
    });
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(apiClient, {
        smartAccount: account,
        network: network,
        calls: [
            {
                to: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SPEND_PERMISSION_MANAGER_ADDRESS"],
                data,
                value: 0n
            }
        ]
    });
} //# sourceMappingURL=smartAccount.use.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toEvmSmartAccount.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "toEvmSmartAccount",
    ()=>toEvmSmartAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkToChainResolver$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/networkToChainResolver.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toNetworkScopedEvmSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toNetworkScopedEvmSmartAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/fund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/fund/quoteFund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$getUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/getUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listTokenBalances.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/requestFaucet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$signAndWrapTypedDataForSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/signAndWrapTypedDataForSmartAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$spend$2d$permissions$2f$smartAccount$2e$use$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/spend-permissions/smartAccount.use.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/sendSwapOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$smartAccountTransferStrategy$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/smartAccountTransferStrategy.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/transfer.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$waitForUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/waitForUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/waitForFundOperationReceipt.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
function toEvmSmartAccount(apiClient, options) {
    const account = {
        address: options.smartAccount.address,
        owners: [
            options.owner
        ],
        policies: options.smartAccount.policies,
        async transfer (transferArgs) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "transfer",
                accountType: "evm_smart",
                properties: {
                    network: transferArgs.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["transfer"])(apiClient, account, transferArgs, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$smartAccountTransferStrategy$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["smartAccountTransferStrategy"]);
        },
        async listTokenBalances (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "list_token_balances",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["listTokenBalances"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async sendUserOperation (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "send_user_operation",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(apiClient, {
                ...options,
                smartAccount: account
            });
        },
        async waitForUserOperation (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "wait_for_user_operation",
                accountType: "evm_smart"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$waitForUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForUserOperation"])(apiClient, {
                ...options,
                smartAccountAddress: account.address
            });
        },
        async getUserOperation (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "get_user_operation",
                accountType: "evm_smart"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$getUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUserOperation"])(apiClient, {
                ...options,
                smartAccount: account
            });
        },
        async requestFaucet (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "request_faucet",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["requestFaucet"])(apiClient, {
                ...options,
                address: account.address
            });
        },
        async quoteFund (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "quote_fund",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["quoteFund"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async fund (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "fund",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fund"])(apiClient, {
                ...options,
                address: this.address
            });
        },
        async waitForFundOperationReceipt (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "wait_for_fund_operation_receipt",
                accountType: "evm_smart"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForFundOperationReceipt"])(apiClient, options);
        },
        async quoteSwap (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "quote_swap",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSwapQuote"])(apiClient, {
                ...options,
                taker: this.address,
                signerAddress: this.owners[0].address,
                smartAccount: account
            });
        },
        async swap (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "swap",
                accountType: "evm_smart",
                properties: {
                    network: "network" in options ? options.network : undefined
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$sendSwapOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendSwapOperation"])(apiClient, {
                ...options,
                smartAccount: account,
                taker: this.address,
                signerAddress: this.owners[0].address
            });
        },
        async signTypedData (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign_typed_data",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            const result = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$signAndWrapTypedDataForSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["signAndWrapTypedDataForSmartAccount"])(apiClient, {
                chainId: BigInt((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$networkToChainResolver$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["resolveNetworkToChain"])(options.network).id),
                smartAccount: account,
                typedData: options
            });
            return result.signature;
        },
        async useSpendPermission (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "use_spend_permission",
                accountType: "evm_smart",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$spend$2d$permissions$2f$smartAccount$2e$use$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useSpendPermission"])(apiClient, account, options);
        },
        name: options.smartAccount.name,
        type: "evm-smart",
        useNetwork: async (network)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "use_network",
                accountType: "evm_smart",
                properties: {
                    network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toNetworkScopedEvmSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toNetworkScopedEvmSmartAccount"])(apiClient, {
                smartAccount: account,
                owner: options.owner,
                network
            });
        }
    };
    return account;
} //# sourceMappingURL=toEvmSmartAccount.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listSpendPermissions.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Lists the spend permissions for a smart account.
 *
 * @param client - The OpenApiClient instance.
 * @param options - The options for listing the spend permissions.
 *
 * @returns A promise that resolves to the spend permissions.
 */ __turbopack_context__.s([
    "listSpendPermissions",
    ()=>listSpendPermissions
]);
async function listSpendPermissions(client, options) {
    const result = await client.listSpendPermissions(options.address, {
        pageSize: options.pageSize,
        pageToken: options.pageToken
    });
    return {
        spendPermissions: result.spendPermissions.map((permission)=>({
                ...permission,
                permissionHash: permission.permissionHash,
                permission: {
                    ...permission.permission,
                    account: permission.permission.account,
                    spender: permission.permission.spender,
                    token: permission.permission.token,
                    allowance: BigInt(permission.permission.allowance),
                    period: Number(permission.permission.period),
                    start: Number(permission.permission.start),
                    end: Number(permission.permission.end),
                    salt: BigInt(permission.permission.salt),
                    extraData: permission.permission.extraData
                }
            }))
    };
} //# sourceMappingURL=listSpendPermissions.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/spend-permissions/utils.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "resolveTokenAddress",
    ()=>resolveTokenAddress
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/transfer/utils.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
;
;
function resolveTokenAddress(token, network) {
    if (token === "eth") {
        return "0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE";
    }
    if (token === "usdc" && (network === "base" || network === "base-sepolia")) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$transfer$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getErc20Address"])(token, network);
    }
    if (token === "usdc") {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"](`Automatic token address lookup for ${token} is not supported on ${network}. Please provide the token address manually.`);
    }
    return token;
} //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/spend-permissions/resolveSpendPermission.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "resolveSpendPermission",
    ()=>resolveSpendPermission
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/spend-permissions/utils.js [app-ssr] (ecmascript)");
;
;
/**
 * Generate a random salt using crypto.getRandomValues().
 *
 * @returns A random bigint salt.
 */ function generateRandomSalt() {
    const randomBytes = new Uint8Array(32);
    crypto.getRandomValues(randomBytes);
    // Convert bytes to bigint
    let result = 0n;
    for(let i = 0; i < randomBytes.length; i++){
        result = (result << 8n) + BigInt(randomBytes[i]);
    }
    return result;
}
function resolveSpendPermission(spendPermissionInput, network) {
    // Validate that either period or periodInDays is provided, but not both
    if (spendPermissionInput.period !== undefined && spendPermissionInput.periodInDays !== undefined) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Cannot specify both 'period' and 'periodInDays'. Please provide only one.");
    }
    if (spendPermissionInput.period === undefined && spendPermissionInput.periodInDays === undefined) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Must specify either 'period' (in seconds) or 'periodInDays'.");
    }
    // Convert periodInDays to period in seconds if provided
    const period = spendPermissionInput.period ?? spendPermissionInput.periodInDays * 24 * 60 * 60;
    // Set defaults for start and end
    const now = new Date();
    const startDate = spendPermissionInput.start ?? now;
    /*
     * For end date default, we need to handle the max uint48 value carefully
     * JavaScript Date max is around year 275760, but uint48 max (281474976710655) is much larger
     * So we'll use the max uint48 value directly for end if no end date is provided
     */ const endDate = spendPermissionInput.end;
    // Convert Date objects to seconds since epoch for the contract
    const start = Math.floor(startDate.getTime() / 1000);
    const end = endDate ? Math.floor(endDate.getTime() / 1000) : 281474976710655; // Max uint48 value (never expires)
    const { periodInDays: _periodInDays, ...inputWithoutPeriodInDays } = spendPermissionInput;
    return {
        ...inputWithoutPeriodInDays,
        token: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["resolveTokenAddress"])(spendPermissionInput.token, network),
        period,
        start,
        end,
        salt: spendPermissionInput.salt ?? generateRandomSalt(),
        extraData: spendPermissionInput.extraData ?? "0x"
    };
} //# sourceMappingURL=resolveSpendPermission.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/getSwapPrice.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Gets the price for a swap between two tokens on an EVM network.
 *
 * @param {CdpOpenApiClientType} client - The client to use to get the swap price.
 * @param {GetSwapPriceOptions} options - The options for getting a swap price.
 *
 * @returns {Promise<GetSwapPriceResult | SwapUnavailableResult>} A promise that resolves to the swap price result or a response indicating that liquidity is unavailable.
 *
 * @example **Getting a swap price**
 * ```ts
 * const price = await getSwapPrice(client, {
 *   network: "ethereum-mainnet",
 *   toToken: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48", // USDC
 *   fromToken: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2", // WETH
 *   fromAmount: BigInt("1000000000000000000"), // 1 WETH in wei
 *   taker: "0x1234567890123456789012345678901234567890",
 *   idempotencyKey: "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx" // Optional: for request deduplication
 * });
 * ```
 */ __turbopack_context__.s([
    "getSwapPrice",
    ()=>getSwapPrice
]);
async function getSwapPrice(client, options) {
    // Call the getEvmSwapPrice function directly with the client's configured API
    const response = await client.getEvmSwapPrice({
        network: options.network,
        toToken: options.toToken,
        fromToken: options.fromToken,
        fromAmount: options.fromAmount.toString(),
        taker: options.taker,
        signerAddress: options.signerAddress,
        gasPrice: options.gasPrice?.toString(),
        slippageBps: options.slippageBps
    }, options.idempotencyKey);
    // Check if liquidity is unavailable
    if (!response.liquidityAvailable) {
        // Return the SwapUnavailableResult
        return {
            liquidityAvailable: false
        };
    }
    // At this point we know it's a GetSwapPriceResponse with liquidityAvailable as true
    const quoteResponse = response;
    return {
        blockNumber: BigInt(quoteResponse.blockNumber),
        toAmount: BigInt(quoteResponse.toAmount),
        toToken: quoteResponse.toToken,
        fees: {
            gasFee: quoteResponse.fees.gasFee ? {
                amount: BigInt(quoteResponse.fees.gasFee.amount),
                token: quoteResponse.fees.gasFee.token
            } : undefined,
            protocolFee: quoteResponse.fees.protocolFee ? {
                amount: BigInt(quoteResponse.fees.protocolFee.amount),
                token: quoteResponse.fees.protocolFee.token
            } : undefined
        },
        issues: {
            allowance: quoteResponse.issues.allowance ? {
                currentAllowance: BigInt(quoteResponse.issues.allowance.currentAllowance),
                spender: quoteResponse.issues.allowance.spender
            } : undefined,
            balance: quoteResponse.issues.balance ? {
                token: quoteResponse.issues.balance.token,
                currentBalance: BigInt(quoteResponse.issues.balance.currentBalance),
                requiredBalance: BigInt(quoteResponse.issues.balance.requiredBalance)
            } : undefined,
            simulationIncomplete: quoteResponse.issues.simulationIncomplete
        },
        liquidityAvailable: true,
        minToAmount: BigInt(quoteResponse.minToAmount),
        fromAmount: BigInt(quoteResponse.fromAmount),
        fromToken: quoteResponse.fromToken,
        gas: quoteResponse.gas ? BigInt(quoteResponse.gas) : undefined,
        gasPrice: quoteResponse.gasPrice ? BigInt(quoteResponse.gasPrice) : undefined
    };
} //# sourceMappingURL=getSwapPrice.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/export.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decryptWithPrivateKey",
    ()=>decryptWithPrivateKey,
    "formatSolanaPrivateKey",
    ()=>formatSolanaPrivateKey,
    "generateExportEncryptionKeyPair",
    ()=>generateExportEncryptionKeyPair
]);
var __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/crypto [external] (crypto, cjs)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$web3$2e$js$40$1$2e$98$2e$4_buff_1d00a4737ce00f2fb6141572da6194da$2f$node_modules$2f40$solana$2f$web3$2e$js$2f$lib$2f$index$2e$esm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+web3.js@1.98.4_buff_1d00a4737ce00f2fb6141572da6194da/node_modules/@solana/web3.js/lib/index.esm.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$bs58$40$6$2e$0$2e$0$2f$node_modules$2f$bs58$2f$src$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/bs58@6.0.0/node_modules/bs58/src/esm/index.js [app-ssr] (ecmascript)");
;
;
;
const generateExportEncryptionKeyPair = async ()=>{
    return await new Promise((resolve, reject)=>{
        (0, __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["generateKeyPair"])("rsa", {
            modulusLength: 4096,
            publicKeyEncoding: {
                type: "spki",
                format: "der"
            },
            privateKeyEncoding: {
                type: "pkcs1",
                format: "der"
            }
        }, (err, publicKey, privateKey)=>{
            if (err) {
                reject(err);
            }
            resolve({
                publicKey: publicKey.toString("base64"),
                privateKey: privateKey.toString("base64")
            });
        });
    });
};
const decryptWithPrivateKey = (b64PrivateKey, b64Cipher)=>{
    try {
        // Create a private key object from the PKCS1 DER format
        const privateKey = (0, __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["createPrivateKey"])({
            key: Buffer.from(b64PrivateKey, "base64"),
            format: "der",
            type: "pkcs1"
        });
        const decryptedBuffer = (0, __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["privateDecrypt"])({
            key: privateKey,
            padding: __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["constants"].RSA_PKCS1_OAEP_PADDING,
            oaepHash: "sha256"
        }, Buffer.from(b64Cipher, "base64"));
        return decryptedBuffer.toString("hex");
    } catch (error) {
        throw new Error(`Decryption failed: ${String(error)}`);
    }
};
const formatSolanaPrivateKey = (privateKey)=>{
    const privateKeyBytes = Buffer.from(privateKey, "hex");
    const keypair = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$web3$2e$js$40$1$2e$98$2e$4_buff_1d00a4737ce00f2fb6141572da6194da$2f$node_modules$2f40$solana$2f$web3$2e$js$2f$lib$2f$index$2e$esm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Keypair"].fromSeed(privateKeyBytes);
    const fullKey = Buffer.concat([
        keypair.secretKey.subarray(0, 32),
        keypair.publicKey.toBytes()
    ]);
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$bs58$40$6$2e$0$2e$0$2f$node_modules$2f$bs58$2f$src$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].encode(fullKey);
}; //# sourceMappingURL=export.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/evm/evm.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module Client
 */ __turbopack_context__.s([
    "EvmClient",
    ()=>EvmClient
]);
var __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/crypto [external] (crypto, cjs)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$typedData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/typedData.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toEvmServerAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/evm/toEvmSmartAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$getUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/getUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listSpendPermissions$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listSpendPermissions.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/listTokenBalances.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/requestFaucet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/sendUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$spend$2d$permissions$2f$resolveSpendPermission$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/spend-permissions/resolveSpendPermission.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/createSwapQuote.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$getSwapPrice$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/swap/getSwapPrice.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$waitForUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/evm/waitForUserOperation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/constants.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/index.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/spend-permissions/constants.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/export.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
class EvmClient {
    /**
     * Creates a new CDP EVM account.
     *
     * @param {CreateServerAccountOptions} [options] - Optional parameters for creating the account.
     * @param {string} [options.name] - A name for the account to create.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the newly created account.
     *
     * @example **Without arguments**
     *          ```ts
     *          const account = await cdp.evm.createAccount();
     *          ```
     *
     * @example **With a name**
     *          ```ts
     *          const account = await cdp.evm.createAccount({ name: "MyAccount" });
     *          ```
     *
     * @example **With an idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call
     *          await cdp.evm.createAccount({
     *            idempotencyKey,
     *          });
     *
     *          // Second call with the same idempotency key will return the same account
     *          await cdp.evm.createAccount({
     *            idempotencyKey,
     *          });
     *          ```
     */ async createAccount(options = {}) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "create_account",
            accountType: "evm_server"
        });
        return this._createAccountInternal(options);
    }
    /**
     * Imports a CDP EVM account from an external source.
     *
     * @param {ImportServerAccountOptions} options - Parameters for importing the account.
     * @param {string} options.privateKey - The private key of the account to import.
     * @param {string} [options.name] - A name for the account to import.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the imported account.
     *
     * @example **Without arguments**
     *          ```ts
     *          const account = await cdp.evm.importAccount({
     *            privateKey: "0x123456"
     *          });
     *          ```
     *
     * @example **With a name**
     *          ```ts
     *          const account = await cdp.evm.importAccount({
     *            privateKey: "0x123456",
     *            name: "MyAccount"
     *          });
     *          ```
     *
     * @example **With an idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call
     *          await cdp.evm.importAccount({
     *            privateKey: "0x123456",
     *            idempotencyKey,
     *          });
     *
     *          // Second call with the same idempotency key will return the same account
     *          await cdp.evm.importAccount({
     *            privateKey: "0x123456"
     *            idempotencyKey,
     *          });
     *          ```
     */ async importAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "import_account",
            accountType: "evm_server"
        });
        const encryptionPublicKey = options.encryptionPublicKey || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ImportAccountPublicRSAKey"];
        const privateKeyHex = options.privateKey.startsWith("0x") ? options.privateKey.slice(2) : options.privateKey;
        if (!/^[0-9a-fA-F]+$/.test(privateKeyHex)) {
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Private key must be a valid hexadecimal string");
        }
        try {
            const privateKeyBytes = Buffer.from(privateKeyHex, "hex");
            const encryptedPrivateKey = (0, __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["publicEncrypt"])({
                key: encryptionPublicKey,
                padding: __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["constants"].RSA_PKCS1_OAEP_PADDING,
                oaepHash: "sha256"
            }, privateKeyBytes);
            const openApiAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].importEvmAccount({
                name: options.name,
                encryptedPrivateKey: encryptedPrivateKey.toString("base64")
            }, options.idempotencyKey);
            const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmServerAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
                account: openApiAccount
            });
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
            return account;
        } catch (error) {
            if (error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"]) {
                throw error;
            }
            throw new Error(`Failed to import account: ${String(error)}`);
        }
    }
    /**
     * Exports a CDP EVM account's private key.
     * It is important to store the private key in a secure place after it's exported.
     *
     * @param {ExportServerAccountOptions} options - Parameters for exporting the account.
     * @param {string} [options.address] - The address of the account to export.
     * @param {string} [options.name] - The name of the account to export.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the exported account’s 32-byte private key as a hex string, without the "0x" prefix.
     *
     * @example **With an address**
     * ```ts
     * const privateKey = await cdp.evm.exportAccount({
     *   address: "0x1234567890123456789012345678901234567890",
     * });
     * ```
     *
     * @example **With a name**
     * ```ts
     * const privateKey = await cdp.evm.exportAccount({
     *   name: "MyAccount",
     * });
     * ```
     */ async exportAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "export_account",
            accountType: "evm_server"
        });
        const { publicKey, privateKey } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["generateExportEncryptionKeyPair"])();
        const { encryptedPrivateKey } = await (async ()=>{
            if (options.address) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].exportEvmAccount(options.address, {
                    exportEncryptionKey: publicKey
                }, options.idempotencyKey);
            }
            if (options.name) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].exportEvmAccountByName(options.name, {
                    exportEncryptionKey: publicKey
                }, options.idempotencyKey);
            }
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Either address or name must be provided");
        })();
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["decryptWithPrivateKey"])(privateKey, encryptedPrivateKey);
    }
    /**
     * Creates a new CDP EVM smart account.
     *
     * @param {CreateSmartAccountOptions} options - Parameters for creating the smart account.
     * @param {Account} options.owner - The owner of the smart account.
     * The owner can be any Ethereum account with signing capabilities,
     * such as a CDP EVM account or a Viem LocalAccount.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the newly created smart account.
     *
     * @example **With a CDP EVM Account as the owner**
     *          ```ts
     *          const account = await cdp.evm.createAccount();
     *          const smartAccount = await cdp.evm.createSmartAccount({
     *            owner: account,
     *          });
     *          ```
     *
     * @example **With a Viem LocalAccount as the owner**
     *          ```ts
     *          // See https://viem.sh/docs/accounts/local/privateKeyToAccount
     *          const privateKey = generatePrivateKey();
     *          const account = privateKeyToAccount(privateKey);
     *          const smartAccount = await client.evm.createSmartAccount({
     *            owner: account,
     *          });
     *          ```
     *
     * @example **With an idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call
     *          await cdp.evm.createSmartAccount({
     *            owner: account,
     *            idempotencyKey,
     *          });
     *
     *          // Second call with the same idempotency key will return the same smart account
     *          await cdp.evm.createSmartAccount({
     *            owner: account,
     *            idempotencyKey,
     *          ```
     */ async createSmartAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "create_smart_account",
            accountType: "evm_smart"
        });
        return this._createSmartAccountInternal(options);
    }
    /**
     * Creates a spend permission for a smart account.
     *
     * @param {CreateSpendPermissionOptions} options - Parameters for creating the spend permission.
     * @param {SpendPermission} options.spendPermission - The spend permission to create.
     * @param {string} [options.idempotencyKey] - The idempotency key to use for the spend permission.
     *
     * @returns A promise that resolves to the spend permission.
     *
     * @example
     * ```ts
     * const userOperation = await cdp.evm.createSpendPermission({
     *   spendPermission,
     *   network: "base-sepolia",
     * });
     * ```
     */ async createSpendPermission(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "create_spend_permission"
        });
        const resolvedSpendPermission = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$spend$2d$permissions$2f$resolveSpendPermission$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["resolveSpendPermission"])(options.spendPermission, options.network);
        const userOperation = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].createSpendPermission(resolvedSpendPermission.account, {
            spender: resolvedSpendPermission.spender,
            token: resolvedSpendPermission.token,
            allowance: resolvedSpendPermission.allowance.toString(),
            period: resolvedSpendPermission.period.toString(),
            start: resolvedSpendPermission.start.toString(),
            end: resolvedSpendPermission.end.toString(),
            salt: resolvedSpendPermission.salt.toString(),
            extraData: resolvedSpendPermission.extraData,
            network: options.network,
            paymasterUrl: options.paymasterUrl
        }, options.idempotencyKey);
        return {
            network: userOperation.network,
            userOpHash: userOperation.userOpHash,
            status: userOperation.status,
            calls: userOperation.calls.map((call)=>({
                    to: call.to,
                    value: BigInt(call.value),
                    data: call.data
                }))
        };
    }
    /**
     * Revokes a spend permission for a smart account.
     *
     * @param {RevokeSpendPermissionOptions} options - Parameters for revoking the spend permission.
     * @param {string} options.address - The address of the smart account.
     * @param {string} options.permissionHash - The hash of the spend permission to revoke.
     * @param {string} options.network - The network of the spend permission.
     * @param {string} [options.paymasterUrl] - The paymaster URL of the spend permission.
     *
     * @returns A promise that resolves to the user operation.
     *
     * @example
     * ```ts
     * const userOperation = await cdp.evm.revokeSpendPermission({
     *   address: "0x1234567890123456789012345678901234567890",
     *   permissionHash: "0x1234567890123456789012345678901234567890123456789012345678901234",
     *   network: "base-sepolia",
     * });
     * ```
     */ async revokeSpendPermission(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "revoke_spend_permission"
        });
        const userOperation = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].revokeSpendPermission(options.address, {
            network: options.network,
            permissionHash: options.permissionHash,
            paymasterUrl: options.paymasterUrl
        }, options.idempotencyKey);
        return {
            network: userOperation.network,
            userOpHash: userOperation.userOpHash,
            status: userOperation.status,
            calls: userOperation.calls.map((call)=>({
                    to: call.to,
                    value: BigInt(call.value),
                    data: call.data
                }))
        };
    }
    /**
     * Gets a CDP EVM account.
     *
     * @param {GetServerAccountOptions} options - Parameters for getting the account.
     * Either `address` or `name` must be provided.
     * If both are provided, lookup will be done by `address` and `name` will be ignored.
     * @param {string} [options.address] - The address of the account to get.
     * @param {string} [options.name] - The name of the account to get.
     *
     * @returns A promise that resolves to the account.
     *
     * @example **Get an account by address**
     *          ```ts
     *          const account = await cdp.evm.getAccount({
     *            address: "0x1234567890123456789012345678901234567890",
     *          });
     *          ```
     *
     * @example **Get an account by name**
     *          ```ts
     *          const account = await cdp.evm.getAccount({
     *            name: "MyAccount",
     *          });
     *          ```
     */ async getAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_account",
            accountType: "evm_server"
        });
        return this._getAccountInternal(options);
    }
    /**
     * Gets a CDP EVM smart account.
     *
     * @param {GetSmartAccountOptions} options - Parameters for getting the smart account.
     * Either `address` or `name` must be provided.
     * If both are provided, lookup will be done by `address` and `name` will be ignored.
     * @param {string} [options.address] - The address of the smart account to get.
     * @param {string} [options.name] - The name of the smart account to get.
     * @param {Account} options.owner - The owner of the smart account.
     * You must pass the signing-capable owner of the smart account so that the returned smart account
     * can be functional.
     *
     * @returns A promise that resolves to the smart account.
     *
     * @example
     * ```ts
     * const smartAccount = await cdp.evm.getSmartAccount({
     *   address: "0x1234567890123456789012345678901234567890",
     *   owner: account,
     * });
     * ```
     */ async getSmartAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_smart_account"
        });
        return this._getSmartAccountInternal(options);
    }
    /**
     * Gets a CDP EVM account, or creates one if it doesn't exist.
     *
     * @param {GetOrCreateServerAccountOptions} options - Parameters for getting or creating the account.
     * @param {string} [options.name] - The name of the account to get or create.
     *
     * @returns A promise that resolves to the account.
     *
     * @example
     * ```ts
     * const account = await cdp.evm.getOrCreateAccount({
     *   name: "MyAccount",
     * });
     * ```
     */ async getOrCreateAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_or_create_account",
            accountType: "evm_server"
        });
        try {
            const account = await this._getAccountInternal(options);
            return account;
        } catch (error) {
            // If it failed because the account doesn't exist, create it
            const doesAccountNotExist = error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.statusCode === 404;
            if (doesAccountNotExist) {
                try {
                    const account = await this._createAccountInternal(options);
                    return account;
                } catch (error) {
                    // If it failed because the account already exists, get the existing account
                    const doesAccountAlreadyExist = error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.statusCode === 409;
                    if (doesAccountAlreadyExist) {
                        const account = await this._getAccountInternal(options);
                        return account;
                    }
                    throw error;
                }
            }
            throw error;
        }
    }
    /**
     * Gets a CDP EVM smart account, or creates one if it doesn't exist.
     * This method first attempts to retrieve an existing smart account with the given parameters.
     * If no account exists, it creates a new one with the specified owner.
     *
     * @param {GetOrCreateSmartAccountOptions} options - Configuration options for getting or creating the smart account.
     * @param {string} [options.name] - The name of the smart account to get or create.
     * @param {Account} options.owner - The owner of the smart account.
     *
     * @returns {Promise<SmartAccount>} A promise that resolves to the retrieved or newly created smart account.
     *
     * @example
     * ```ts
     * const smartAccount = await cdp.evm.getOrCreateSmartAccount({
     *   name: "MySmartAccount",
     *   owner: account,
     * });
     * ```
     */ async getOrCreateSmartAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_or_create_smart_account",
            accountType: "evm_smart"
        });
        try {
            const account = await this._getSmartAccountInternal(options);
            return account;
        } catch (error) {
            // If it failed because the account doesn't exist, create it
            const doesAccountNotExist = error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.statusCode === 404;
            if (doesAccountNotExist) {
                try {
                    const account = await this._createSmartAccountInternal(options);
                    return account;
                } catch (error) {
                    // If it failed because the account already exists, get the existing account
                    const doesAccountAlreadyExist = error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.statusCode === 409;
                    if (doesAccountAlreadyExist) {
                        const account = await this._getSmartAccountInternal(options);
                        return account;
                    }
                    throw error;
                }
            }
            throw error;
        }
    }
    /**
     * Gets the price for a swap between two tokens on an EVM network.
     *
     * @param {GetSwapPriceOptions} options - The options for getting a swap price.
     *
     * @returns {Promise<GetSwapPriceResult | SwapUnavailableResult>} A promise that resolves to the swap price result or a response indicating that liquidity is unavailable.
     *
     * @example
     * ```typescript
     * const price = await cdp.evm.getSwapPrice({
     *   network: "ethereum-mainnet",
     *   toToken: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48", // USDC
     *   fromToken: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2", // WETH
     *   fromAmount: BigInt("1000000000000000000"), // 1 WETH
     *   taker: "0x1234567890123456789012345678901234567890"
     * });
     * ```
     */ async getSwapPrice(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_swap_price",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$getSwapPrice$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getSwapPrice"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Creates a quote for a swap between two tokens on an EVM network.
     *
     * @param {CreateSwapQuoteOptions} options - The options for creating a swap quote.
     *
     * @returns {Promise<CreateSwapQuoteResult | SwapUnavailableResult>} A promise that resolves to the swap quote result or a response indicating that liquidity is unavailable.
     *
     * @example
     * ```typescript
     * const swapQuote = await cdp.evm.createSwapQuote({
     *   network: "ethereum",
     *   toToken: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48", // USDC
     *   fromToken: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2", // WETH
     *   fromAmount: BigInt("1000000000000000000"), // 1 WETH
     *   taker: "0x1234567890123456789012345678901234567890"
     * });
     * ```
     */ async createSwapQuote(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "create_swap_quote",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$swap$2f$createSwapQuote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSwapQuote"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Gets a user operation for a smart account by user operation hash.
     *
     * @param {GetUserOperationOptions} options - Parameters for getting the user operation.
     * @param {SmartAccount} options.smartAccount - The smart account signing the user operation.
     * @param {string} options.userOpHash - The user operation hash.
     *
     * @returns A promise that resolves to the user operation.
     *
     * @example
     * ```ts
     * const userOp = await cdp.evm.getUserOperation({
     *   smartAccount,
     *   userOpHash: "0x1234567890123456789012345678901234567890123456789012345678901234",
     * });
     * ```
     */ async getUserOperation(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_user_operation"
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$getUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUserOperation"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Lists CDP EVM accounts.
     *
     * @param {ListServerAccountsOptions} [options] - Optional parameters for listing the accounts.
     * @param {number} [options.pageSize] - The number of accounts to return.
     * @param {string} [options.pageToken] - The page token to begin listing from.
     * This is obtained by previous calls to this method.
     *
     * @returns A promise that resolves to an array of accounts, and a token to paginate through the accounts.
     *
     * @example
     * ```ts
     * const accounts = await cdp.evm.listAccounts();
     * ```
     *
     * @example **With pagination**
     *          ```ts
     *          let page = await cdp.evm.listAccounts();
     *
     *          while (page.nextPageToken) {
     *            page = await cdp.evm.listAccounts({ pageToken: page.nextPageToken });
     *          }
     *          ```
     */ async listAccounts(options = {}) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_accounts",
            accountType: "evm_server"
        });
        const ethAccounts = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].listEvmAccounts({
            pageSize: options.pageSize,
            pageToken: options.pageToken
        });
        return {
            accounts: ethAccounts.accounts.map((account)=>{
                const evmAccount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmServerAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
                    account
                });
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(evmAccount);
                return evmAccount;
            }),
            nextPageToken: ethAccounts.nextPageToken
        };
    }
    /**
     * Lists CDP EVM token balances.
     *
     * @param {ListTokenBalancesOptions} options - Parameters for listing the token balances.
     * @param {number} [options.pageSize] - The number of token balances to return.
     * @param {string} [options.pageToken] - The page token to begin listing from.
     * This is obtained by previous calls to this method.
     *
     * @returns A promise that resolves to an array of token balances, and a token to paginate through the token balances.
     *
     * @example
     * ```ts
     * const tokenBalances = await cdp.evm.listTokenBalances({
     *   address: "0x1234567890123456789012345678901234567890",
     *   network: "base-sepolia",
     * });
     * ```
     *
     * @example
     * **With pagination**
     * ```ts
     * let page = await cdp.evm.listTokenBalances({
     *   address: "0x1234567890123456789012345678901234567890",
     *   network: "base-sepolia",
     * });
     *
     * while (page.nextPageToken) {
     *   page = await cdp.evm.listTokenBalances({
     *     address: "0x1234567890123456789012345678901234567890",
     *     network: "base-sepolia",
     *     pageToken: page.nextPageToken,
     *   });
     * }
     */ async listTokenBalances(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_token_balances",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listTokenBalances$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["listTokenBalances"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Lists CDP EVM smart accounts.
     *
     * @param {ListSmartAccountsOptions} options - Parameters for listing the smart accounts.
     * @param {number} [options.pageSize] - The number of smart accounts to return.
     * @param {string} [options.pageToken] - The page token to begin listing from.
     * This is obtained by previous calls to this method.
     *
     * @returns A promise that resolves to an array of smart accounts, and a token to paginate through the smart accounts.
     *
     * @example
     * ```ts
     * const smartAccounts = await cdp.evm.listSmartAccounts();
     * ```
     *
     * @example **With pagination**
     *          ```ts
     *          let page = await cdp.evm.listSmartAccounts();
     *
     *          while (page.nextPageToken) {
     *            page = await cdp.evm.listSmartAccounts({ pageToken: page.nextPageToken });
     *          }
     *          ```
     */ async listSmartAccounts(options = {}) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_smart_accounts"
        });
        const smartAccounts = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].listEvmSmartAccounts({
            pageSize: options.pageSize,
            pageToken: options.pageToken
        });
        return {
            accounts: smartAccounts.accounts.map((account)=>({
                    address: account.address,
                    owners: [
                        account.owners[0]
                    ],
                    type: "evm-smart",
                    policies: account.policies
                })),
            nextPageToken: smartAccounts.nextPageToken
        };
    }
    /**
     * Lists the spend permissions for a smart account.
     *
     * @param {ListSpendPermissionsOptions} options - Parameters for listing the spend permissions.
     * @param {string} options.address - The address of the smart account.
     * @param {number} [options.pageSize] - The number of spend permissions to return.
     * @param {string} [options.pageToken] - The page token to return the next page of spend permissions.
     *
     * @returns A promise that resolves to the spend permissions.
     */ async listSpendPermissions(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_spend_permissions"
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$listSpendPermissions$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["listSpendPermissions"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Prepares a user operation for a smart account.
     *
     * @param {PrepareUserOperationOptions} options - Parameters for preparing the user operation.
     * @param {SmartAccount} options.smartAccount - The smart account signing the user operation.
     * @param {string} options.network - The network to prepare the user operation for.
     * @param {EvmCall[]} options.calls - The calls to include in the user operation.
     * @param {string} [options.paymasterUrl] - The optional paymaster URL to use for the user operation.
     *
     * @returns A promise that resolves to the user operation hash.
     *
     * @example
     * ```ts
     * const userOp = await cdp.evm.prepareUserOperation({
     *   smartAccount,
     *   network: "base-sepolia",
     *   calls: [
     *     {
     *       to: "0x1234567890123456789012345678901234567890",
     *       value: parseEther("0.000001"),
     *       data: "0x",
     *     },
     *   ],
     * });
     * ```
     */ async prepareUserOperation(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "prepare_user_operation",
            properties: {
                network: options.network
            }
        });
        const userOp = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].prepareUserOperation(options.smartAccount.address, {
            network: options.network,
            calls: options.calls.map((call)=>({
                    to: call.to,
                    value: call.value.toString(),
                    data: call.data
                })),
            paymasterUrl: options.paymasterUrl
        });
        return {
            network: userOp.network,
            userOpHash: userOp.userOpHash,
            status: userOp.status,
            calls: userOp.calls.map((call)=>({
                    to: call.to,
                    value: BigInt(call.value),
                    data: call.data
                }))
        };
    }
    /**
     * Requests funds from an EVM faucet.
     *
     * @param {RequestFaucetOptions} options - Parameters for requesting funds from the EVM faucet.
     * @param {string} options.address - The address to request funds for.
     * @param {string} options.network - The network to request funds from.
     * @param {string} options.token - The token to request funds for.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the transaction hash.
     *
     * @example
     * ```ts
     * const result = await cdp.evm.requestFaucet({
     *   address: "0x1234567890123456789012345678901234567890",
     *   network: "base-sepolia",
     *   token: "eth",
     * });
     * ```
     */ async requestFaucet(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "request_faucet",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["requestFaucet"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Signs an EVM transaction and sends it to the specified network using the Coinbase API.
     * This method handles nonce management and gas estimation automatically.
     *
     * @param {SendTransactionOptions} options - Configuration options for sending the transaction.
     * @returns A promise that resolves to the transaction hash.
     *
     * @example
     * **Sending an RLP-encoded transaction**
     * ```ts
     * import { parseEther, serializeTransaction } from "viem";
     * import { baseSepolia } from "viem/chains";
     *
     * const { transactionHash } = await cdp.evm.sendTransaction({
     *   address: account.address,
     *   transaction: serializeTransaction({
     *     to: "0x4252e0c9A3da5A2700e7d91cb50aEf522D0C6Fe8",
     *     value: parseEther("0.000001"),
     *     chainId: baseSepolia.id,
     *     // Fields below are optional, CDP API will populate them if omitted.
     *     // nonce
     *     // maxPriorityFeePerGas
     *     // maxFeePerGas
     *     // gas
     *   }),
     *   network: "base-sepolia",
     * });
     * ```
     * @example
     * **Sending an EIP-1559 transaction request object**
     * ```ts
     * const { transactionHash } = await cdp.evm.sendTransaction({
     *   address: account.address,
     *   transaction: {
     *     to: "0x4252e0c9A3da5A2700e7d91cb50aEf522D0C6Fe8",
     *     value: parseEther("0.000001"),
     *     // Fields below are optional, CDP API will populate them if omitted.
     *     // nonce
     *     // maxPriorityFeePerGas
     *     // maxFeePerGas
     *     // gas
     *   },
     *   network: "base-sepolia",
     * });
     * ```
     */ async sendTransaction(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "send_transaction",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendTransaction"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Sends a user operation.
     *
     * @param {SendUserOperationOptions} options - Parameters for sending the user operation.
     * @param {SmartAccount} options.smartAccount - The smart account sending the user operation.
     * @param {string} options.network - The network to send the user operation on.
     * @param {EvmCall[]} options.calls - The calls to include in the user operation.
     * @param {string} [options.paymasterUrl] - The optional paymaster URL to use for the user operation.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to an object containing the smart account address,
     * the user operation hash, and the status of the user operation.
     *
     * @example
     * ```ts
     * const userOp = await cdp.evm.sendUserOperation({
     *   smartAccount,
     *   network: "base-sepolia",
     *   calls: [
     *     {
     *       to: "0x1234567890123456789012345678901234567890",
     *       value: parseEther("0.000001"),
     *       data: "0x",
     *     },
     *   ],
     * });
     * ```
     */ async sendUserOperation(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "send_user_operation",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$sendUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendUserOperation"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            smartAccount: options.smartAccount,
            network: options.network,
            calls: options.calls,
            paymasterUrl: options.paymasterUrl,
            idempotencyKey: options.idempotencyKey
        });
    }
    /**
     * Signs an EVM hash.
     *
     * @param {SignHashOptions} options - Parameters for signing the hash.
     * @param {string} options.address - The address to sign the hash for.
     * @param {string} options.hash - The hash to sign.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the signature.
     *
     * @example
     * ```ts
     * // Create a new EVM server account to sign with
     * const ethAccount = await cdp.createEvmServerAccount({});
     *
     * const signature = await cdp.evm.signHash({
     *   address: ethAccount.address,
     *   hash: "0x1234567890123456789012345678901234567890123456789012345678901234",
     * });
     * ```
     */ async signHash(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "sign_hash"
        });
        const signature = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].signEvmHash(options.address, {
            hash: options.hash
        }, options.idempotencyKey);
        return {
            signature: signature.signature
        };
    }
    /**
     * Signs an EIP-191 message.
     *
     * @param {SignMessageOptions} options - Parameters for signing the message.
     * @param {string} options.address - The address to sign the message for.
     * @param {string} options.message - The message to sign.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the signature.
     *
     * @example
     * ```ts
     * // Create a new EVM server account to sign with
     * const ethAccount = await cdp.createEvmServerAccount({});
     *
     * const signature = await cdp.evm.signMessage({
     *   address: ethAccount.address,
     *   message: "Hello, world!",
     * });
     * ```
     */ async signMessage(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "sign_message"
        });
        const signature = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].signEvmMessage(options.address, {
            message: options.message
        }, options.idempotencyKey);
        return {
            signature: signature.signature
        };
    }
    /**
     * Signs an EIP-712 message.
     *
     * @param {SignTypedDataOptions} options - Parameters for signing the EIP-712 message.
     * @returns A promise that resolves to the signature.
     *
     * @example
     * ```ts
     * const signature = await cdp.evm.signTypedData({
     *   address: account.address,
     *   domain: {
     *     name: "Permit2",
     *     chainId: 1,
     *     verifyingContract: "0x000000000022D473030F116dDEE9F6B43aC78BA3",
     *   },
     *   types: {
     *     EIP712Domain: [
     *       { name: "name", type: "string" },
     *       { name: "chainId", type: "uint256" },
     *       { name: "verifyingContract", type: "address" },
     *     ],
     *     PermitTransferFrom: [
     *       { name: "permitted", type: "TokenPermissions" },
     *       { name: "spender", type: "address" },
     *       { name: "nonce", type: "uint256" },
     *       { name: "deadline", type: "uint256" },
     *     ],
     *     TokenPermissions: [
     *       { name: "token", type: "address" },
     *       { name: "amount", type: "uint256" },
     *     ],
     *   },
     *   primaryType: "PermitTransferFrom",
     *   message: {
     *     permitted: {
     *       token: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
     *       amount: "1000000",
     *     },
     *     spender: "0xFfFfFfFFfFFfFFfFFfFFFFFffFFFffffFfFFFfFf",
     *     nonce: "0",
     *     deadline: "1717123200",
     *   },
     * });
     * ```
     */ async signTypedData(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "sign_typed_data"
        });
        const { domain, message, primaryType } = options;
        const types = {
            EIP712Domain: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$typedData$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTypesForEIP712Domain"])({
                domain
            }),
            ...options.types
        };
        const openApiMessage = {
            domain,
            types,
            primaryType,
            message
        };
        const signature = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].signEvmTypedData(options.address, openApiMessage, options.idempotencyKey);
        return {
            signature: signature.signature
        };
    }
    /**
     * Signs an EVM transaction.
     *
     * @param {SignTransactionOptions} options - Configuration options for signing the transaction.
     * @returns A promise that resolves to the signature.
     *
     * @example
     * ```ts
     * import { parseEther, serializeTransaction } from "viem";
     * import { baseSepolia } from "viem/chains";
     *
     * // Create a new EVM server account to sign with
     * const ethAccount = await cdp.createEvmServerAccount({});
     *
     * const serializedTx = serializeTransaction(
     *   {
     *     chainId: baseSepolia.id,
     *     data: "0x",
     *     to: "0x4252e0c9A3da5A2700e7d91cb50aEf522D0C6Fe8",
     *     type: "eip1559",
     *     value: parseEther("0.000001"),
     *   },
     * );
     *
     * const signature = await cdp.evm.signTransaction({
     *   address: ethAccount.address,
     *   transaction: serializedTx,
     * });
     * ```
     */ async signTransaction(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "sign_transaction"
        });
        const signature = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].signEvmTransaction(options.address, {
            transaction: options.transaction
        }, options.idempotencyKey);
        return {
            signature: signature.signedTransaction
        };
    }
    /**
     * Updates a CDP EVM account.
     *
     * @param {UpdateEvmAccountOptions} [options] - Optional parameters for creating the account.
     * @param {string} options.address - The address of the account to update
     * @param {UpdateEvmAccountBody} options.update - An object containing account fields to update.
     * @param {string} [options.update.name] - The new name for the account.
     * @param {string} [options.update.accountPolicy] - The ID of a Policy to apply to the account.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the updated account.
     *
     * @example **With a name**
     *          ```ts
     *          const account = await cdp.evm.updateAccount({ address: "0x...", update: { name: "New Name" } });
     *          ```
     *
     * @example **With an account policy**
     *          ```ts
     *          const account = await cdp.evm.updateAccount({ address: "0x...", update: { accountPolicy: "73bcaeeb-d7af-4615-b064-42b5fe83a31e" } });
     *          ```
     *
     * @example **With an idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call
     *          await cdp.evm.updateAccount({
     *            address: "0x...",
     *            update: { accountPolicy: "73bcaeeb-d7af-4615-b064-42b5fe83a31e" },
     *            idempotencyKey,
     *          });
     *
     *          // Second call with the same idempotency key will not update
     *          await cdp.evm.updateAccount({
     *            address: '0x...',
     *            update: { name: "" },
     *            idempotencyKey,
     *          });
     *          ```
     */ async updateAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "update_account"
        });
        const openApiAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].updateEvmAccount(options.address, options.update, options.idempotencyKey);
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmServerAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
    /**
     * Updates a CDP EVM smart account.
     *
     * @param {UpdateEvmSmartAccountOptions} [options] - Optional parameters for updating the account.
     * @param {string} options.address - The address of the account to update
     * @param {UpdateEvmSmartAccount} options.update - An object containing account fields to update.
     * @param {string} options.owner - The owner of the account.
     * @param {string} [options.update.name] - The new name for the account.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the updated account.
     */ async updateSmartAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "update_smart_account"
        });
        const openApiSmartAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].updateEvmSmartAccount(options.address, options.update, options.idempotencyKey);
        const smartAccount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmSmartAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            smartAccount: openApiSmartAccount,
            owner: options.owner
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(smartAccount);
        return smartAccount;
    }
    /**
     * Waits for a user operation to complete or fail.
     *
     * @param {WaitForUserOperationOptions} options - Parameters for waiting for the user operation.
     * @param {string} options.smartAccountAddress - The address of the smart account.
     * @param {string} options.userOpHash - The user operation hash.
     * @param {WaitOptions} [options.waitOptions] - Optional parameters for the wait operation.
     *
     * @returns A promise that resolves to the transaction receipt.
     *
     * @example
     * ```ts
     * // Send a user operation and get the user operation hash
     * const { userOpHash } = await cdp.evm.sendUserOperation({
     *   smartAccount,
     *   network: "base-sepolia",
     *   calls: [
     *     {
     *       to: "0x0000000000000000000000000000000000000000",
     *       value: parseEther("0.000001"),
     *       data: "0x",
     *     },
     *   ],
     * });
     *
     * // Wait for the user operation to complete or fail
     * const result = await cdp.evm.waitForUserOperation({
     *   smartAccountAddress: smartAccount.address,
     *   userOpHash: userOp.userOpHash,
     * });
     * ```
     */ async waitForUserOperation(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "wait_for_user_operation"
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$evm$2f$waitForUserOperation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForUserOperation"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            ...options
        });
    }
    /**
     * Internal method to create an account without tracking analytics.
     * Used internally by composite operations to avoid double-counting.
     *
     * @param {CreateServerAccountOptions} options - Parameters for creating the account.
     * @returns {Promise<ServerAccount>} A promise that resolves to the newly created account.
     */ async _createAccountInternal(options = {}) {
        const openApiAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].createEvmAccount({
            name: options.name,
            accountPolicy: options.accountPolicy
        }, options.idempotencyKey);
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmServerAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
    /**
     * Internal method to get an account without tracking analytics.
     * Used internally by composite operations to avoid double-counting.
     *
     * @param {GetServerAccountOptions} options - Parameters for getting the account.
     * @returns {Promise<ServerAccount>} A promise that resolves to the account.
     */ async _getAccountInternal(options) {
        const openApiAccount = await (()=>{
            if (options.address) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getEvmAccount(options.address);
            }
            if (options.name) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getEvmAccountByName(options.name);
            }
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Either address or name must be provided");
        })();
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmServerAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmServerAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
    /**
     * Internal method to create a smart account without tracking analytics.
     * Used internally by composite operations to avoid double-counting.
     *
     * @param {CreateSmartAccountOptions} options - Parameters for creating the smart account.
     * @returns {Promise<SmartAccount>} A promise that resolves to the newly created smart account.
     */ async _createSmartAccountInternal(options) {
        const owners = [
            options.owner.address
        ];
        if (options.enableSpendPermissions) {
            owners.push(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$spend$2d$permissions$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SPEND_PERMISSION_MANAGER_ADDRESS"]);
        }
        const openApiSmartAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].createEvmSmartAccount({
            owners: owners,
            name: options.name
        }, options.idempotencyKey);
        const smartAccount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmSmartAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            smartAccount: openApiSmartAccount,
            owner: options.owner
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(smartAccount);
        return smartAccount;
    }
    /**
     * Internal method to get a smart account without tracking analytics.
     * Used internally by composite operations to avoid double-counting.
     *
     * @param {GetSmartAccountOptions} options - Parameters for getting the smart account.
     * @returns {Promise<SmartAccount>} A promise that resolves to the smart account.
     */ async _getSmartAccountInternal(options) {
        const openApiSmartAccount = await (async ()=>{
            if (options.address) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getEvmSmartAccount(options.address);
            } else if (options.name) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getEvmSmartAccountByName(options.name);
            }
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Either address or name must be provided");
        })();
        if (!openApiSmartAccount.owners.includes(options.owner.address)) {
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"](`Owner mismatch: The provided owner address is not an owner of the smart account. Please use a valid owner for this smart account.

Smart Account Address: ${openApiSmartAccount.address}
Smart Account Owners: ${openApiSmartAccount.owners.join(", ")}
Provided Owner Address: ${options.owner.address}\n`);
        }
        const smartAccount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$evm$2f$toEvmSmartAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toEvmSmartAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            smartAccount: openApiSmartAccount,
            owner: options.owner
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(smartAccount);
        return smartAccount;
    }
} //# sourceMappingURL=evm.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/policies/evmSchema.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ActionEnum",
    ()=>ActionEnum,
    "EthValueCriterionSchema",
    ()=>EthValueCriterionSchema,
    "EthValueOperatorEnum",
    ()=>EthValueOperatorEnum,
    "EvmAddressCriterionSchema",
    ()=>EvmAddressCriterionSchema,
    "EvmAddressOperatorEnum",
    ()=>EvmAddressOperatorEnum,
    "EvmDataConditionSchema",
    ()=>EvmDataConditionSchema,
    "EvmDataCriterionSchema",
    ()=>EvmDataCriterionSchema,
    "EvmDataParameterConditionListSchema",
    ()=>EvmDataParameterConditionListSchema,
    "EvmDataParameterConditionSchema",
    ()=>EvmDataParameterConditionSchema,
    "EvmMessageCriterionSchema",
    ()=>EvmMessageCriterionSchema,
    "EvmNetworkCriterionSchema",
    ()=>EvmNetworkCriterionSchema,
    "EvmNetworkOperatorEnum",
    ()=>EvmNetworkOperatorEnum,
    "EvmOperationEnum",
    ()=>EvmOperationEnum,
    "EvmTypedAddressConditionSchema",
    ()=>EvmTypedAddressConditionSchema,
    "EvmTypedNumericalConditionSchema",
    ()=>EvmTypedNumericalConditionSchema,
    "EvmTypedStringConditionSchema",
    ()=>EvmTypedStringConditionSchema,
    "NetUSDChangeCriterionSchema",
    ()=>NetUSDChangeCriterionSchema,
    "PrepareUserOperationCriteriaSchema",
    ()=>PrepareUserOperationCriteriaSchema,
    "PrepareUserOperationEvmNetworkCriterionSchema",
    ()=>PrepareUserOperationEvmNetworkCriterionSchema,
    "PrepareUserOperationEvmNetworkEnum",
    ()=>PrepareUserOperationEvmNetworkEnum,
    "PrepareUserOperationRuleSchema",
    ()=>PrepareUserOperationRuleSchema,
    "SendEvmTransactionCriteriaSchema",
    ()=>SendEvmTransactionCriteriaSchema,
    "SendEvmTransactionEvmNetworkCriterionSchema",
    ()=>SendEvmTransactionEvmNetworkCriterionSchema,
    "SendEvmTransactionEvmNetworkEnum",
    ()=>SendEvmTransactionEvmNetworkEnum,
    "SendEvmTransactionRuleSchema",
    ()=>SendEvmTransactionRuleSchema,
    "SendUserOperationCriteriaSchema",
    ()=>SendUserOperationCriteriaSchema,
    "SendUserOperationRuleSchema",
    ()=>SendUserOperationRuleSchema,
    "SignEvmHashRuleSchema",
    ()=>SignEvmHashRuleSchema,
    "SignEvmMessageCriteriaSchema",
    ()=>SignEvmMessageCriteriaSchema,
    "SignEvmMessageRuleSchema",
    ()=>SignEvmMessageRuleSchema,
    "SignEvmTransactionCriteriaSchema",
    ()=>SignEvmTransactionCriteriaSchema,
    "SignEvmTransactionRuleSchema",
    ()=>SignEvmTransactionRuleSchema,
    "SignEvmTypedDataCriteriaSchema",
    ()=>SignEvmTypedDataCriteriaSchema,
    "SignEvmTypedDataFieldCriterionSchema",
    ()=>SignEvmTypedDataFieldCriterionSchema,
    "SignEvmTypedDataRuleSchema",
    ()=>SignEvmTypedDataRuleSchema,
    "SignEvmTypedDataVerifyingContractCriterionSchema",
    ()=>SignEvmTypedDataVerifyingContractCriterionSchema
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$0$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$25$2e$76$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$zod$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.0.6_typescript@5.9.3_zod@3.25.76/node_modules/abitype/dist/esm/zod.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zod@3.25.76/node_modules/zod/v3/external.js [app-ssr] (ecmascript) <export * as z>");
;
;
const EthValueOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    ">",
    ">=",
    "<",
    "<=",
    "=="
]);
const EvmAddressOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const EvmNetworkOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const EthValueCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "ethValue" for Ethereum value-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("ethValue"),
    /**
     * The ETH value amount in wei to compare against, as a string.
     * Must contain only digits.
     */ ethValue: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[0-9]+$/),
    /** The comparison operator to use for evaluating transaction values against the threshold. */ operator: EthValueOperatorEnum
});
const EvmAddressCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmAddress" for EVM address-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmAddress"),
    /**
     * Array of EVM addresses to compare against.
     * Each address must be a 0x-prefixed 40-character hexadecimal string.
     * Limited to a maximum of 300 addresses per criterion.
     */ addresses: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$0$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$25$2e$76$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$zod$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Address"]).max(300),
    /**
     * The operator to use for evaluating transaction addresses.
     * "in" checks if an address is in the provided list.
     * "not in" checks if an address is not in the provided list.
     */ operator: EvmAddressOperatorEnum
});
const PrepareUserOperationEvmNetworkEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "base-sepolia",
    "base",
    "arbitrum",
    "optimism",
    "zora",
    "polygon",
    "bnb",
    "avalanche",
    "ethereum",
    "ethereum-sepolia"
]);
const SendEvmTransactionEvmNetworkEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "base",
    "base-sepolia",
    "ethereum",
    "ethereum-sepolia",
    "avalanche",
    "polygon",
    "optimism",
    "arbitrum"
]);
const SendEvmTransactionEvmNetworkCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmAddress" for EVM address-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmNetwork"),
    /**
     * Array of EVM network identifiers to compare against.
     * Either "base", "base-sepolia", "ethereum", "ethereum-sepolia", "avalanche", "polygon", "optimism", "arbitrum"
     */ networks: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(SendEvmTransactionEvmNetworkEnum),
    /**
     * The operator to use for evaluating transaction network.
     * "in" checks if a network is in the provided list.
     * "not in" checks if a network is not in the provided list.
     */ operator: EvmNetworkOperatorEnum
});
const PrepareUserOperationEvmNetworkCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmAddress" for EVM address-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmNetwork"),
    /**
     * Array of EVM network identifiers to compare against.
     * Either "base-sepolia", "base", "arbitrum", "optimism", "zora", "polygon", "bnb", "avalanche", "ethereum", "ethereum-sepolia"
     */ networks: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(PrepareUserOperationEvmNetworkEnum),
    /**
     * The operator to use for evaluating transaction network.
     * "in" checks if a network is in the provided list.
     * "not in" checks if a network is not in the provided list.
     */ operator: EvmNetworkOperatorEnum
});
const EvmNetworkCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
    SendEvmTransactionEvmNetworkCriterionSchema,
    PrepareUserOperationEvmNetworkCriterionSchema
]);
const EvmMessageCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmMessage" for EVM message-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmMessage"),
    /**
     * A regular expression the message is matched against.
     * Accepts valid regular expression syntax described by [RE2](https://github.com/google/re2/wiki/Syntax).
     */ match: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1)
});
const NetUSDChangeCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "netUSDChange" for USD denominated asset transfer rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("netUSDChange"),
    /**
     * The amount of USD, in cents, that the total USD value of a transaction's asset transfer and exposure should be compared to.
     */ changeCents: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].number().int().nonnegative(),
    /**
     * The operator to use for the comparison. The total value of a transaction's asset transfer and exposure in USD will be on the left-hand side of the operator, and the `changeCents` field will be on the right-hand side.
     */ operator: EthValueOperatorEnum
});
const EvmTypedAddressConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Array of EVM addresses to compare against.
     * Each address must be a 0x-prefixed 40-character hexadecimal string.
     * Limited to a maximum of 300 addresses per condition.
     */ addresses: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$0$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$25$2e$76$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$zod$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Address"]).max(300),
    /**
     * The operator to use for evaluating addresses.
     * "in" checks if an address is in the provided list.
     * "not in" checks if an address is not in the provided list.
     */ operator: EvmAddressOperatorEnum,
    /**
     * The path to the field to compare against this criterion.
     * To reference deeply nested fields, use dot notation (e.g., "order.buyer").
     */ path: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1)
});
const EvmTypedNumericalConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * The numerical value to compare against, as a string.
     * Must contain only digits.
     */ value: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[0-9]+$/),
    /**
     * The comparison operator to use.
     */ operator: EthValueOperatorEnum,
    /**
     * The path to the field to compare against this criterion.
     * To reference deeply nested fields, use dot notation (e.g., "order.price").
     */ path: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1)
});
const EvmTypedStringConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * A regular expression the string field is matched against.
     * Accepts valid regular expression syntax described by [RE2](https://github.com/google/re2/wiki/Syntax).
     */ match: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1),
    /**
     * The path to the field to compare against this criterion.
     * To reference deeply nested fields, use dot notation (e.g., "metadata.description").
     */ path: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1)
});
const SignEvmTypedDataFieldCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmTypedDataField" for typed data field-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmTypedDataField"),
    /**
     * The EIP-712 type definitions for the typed data.
     * Must include at minimum the primary type being signed.
     */ types: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
        /**
         * EIP-712 compliant map of model names to model definitions.
         */ types: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].record(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
            name: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
            type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
        }))),
        /**
         * The name of the root EIP-712 type. This value must be included in the `types` object.
         */ primaryType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
    }),
    /**
     * Array of conditions to apply against typed data fields.
     * Each condition specifies how to validate a specific field within the typed data.
     */ conditions: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        EvmTypedAddressConditionSchema,
        EvmTypedNumericalConditionSchema,
        EvmTypedStringConditionSchema
    ])).min(1)
});
const SignEvmTypedDataVerifyingContractCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmTypedDataVerifyingContract" for verifying contract-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmTypedDataVerifyingContract"),
    /**
     * Array of EVM addresses allowed or disallowed as verifying contracts.
     * Each address must be a 0x-prefixed 40-character hexadecimal string.
     * Limited to a maximum of 300 addresses per criterion.
     */ addresses: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$0$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$25$2e$76$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$zod$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Address"]).max(300),
    /**
     * The operator to use for evaluating verifying contract addresses.
     * "in" checks if the verifying contract is in the provided list.
     * "not in" checks if the verifying contract is not in the provided list.
     */ operator: EvmAddressOperatorEnum
});
const SignEvmTypedDataCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    SignEvmTypedDataFieldCriterionSchema,
    SignEvmTypedDataVerifyingContractCriterionSchema
])).max(10).min(1);
const EvmDataParameterConditionListSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * The name of the parameter to check against a transaction's calldata.
     * If name is unknown, or is not named, you may supply an array index, e.g., `0` for first parameter.
     */ name: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1),
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^\d+$/)
    ]),
    /**
     * The operator to use for the comparison. The value resolved at the `name` will be on the
     * left-hand side of the operator, and the `values` field will be on the right-hand side.
     */ operator: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
        "in",
        "not in"
    ]),
    /**
     * Values to compare against the resolved `name` value.
     * All values are encoded as strings. Refer to the table in the documentation for how values
     * should be encoded, and which operators are supported for each type.
     */ values: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string())
});
const EvmDataParameterConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * The name of the parameter to check against a transaction's calldata.
     * If name is unknown, or is not named, you may supply an array index, e.g., `0` for first parameter.
     */ name: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1),
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^\d+$/)
    ]),
    /**
     * The operator to use for the comparison. The value resolved at the `name` will be on the
     * left-hand side of the operator, and the `value` field will be on the right-hand side.
     */ operator: EthValueOperatorEnum,
    /**
     * A single value to compare the value resolved at `name` to.
     * All values are encoded as strings. Refer to the table in the documentation for how values
     * should be encoded, and which operators are supported for each type.
     */ value: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
});
const EvmDataConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * The name of a smart contract function being called.
     */ function: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().min(1),
    /**
     * An optional list of parameter conditions to apply against encoded arguments in the transaction's `data` field.
     */ params: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        EvmDataParameterConditionSchema,
        EvmDataParameterConditionListSchema
    ])).min(1).optional()
});
const EvmDataCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "evmData" for EVM transaction rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("evmData"),
    /**
     * The ABI of the smart contract being called. This can be a partial structure with only specific functions.
     */ abi: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
            "erc20",
            "erc721",
            "erc1155"
        ]),
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$0$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$25$2e$76$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$zod$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Abi"]
    ]),
    /**
     * A list of conditions to apply against the function and encoded arguments in the transaction's `data` field.
     * Each condition must be met in order for this policy to be accepted or rejected.
     */ conditions: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(EvmDataConditionSchema).min(1)
});
const SignEvmTransactionCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    EthValueCriterionSchema,
    EvmAddressCriterionSchema,
    EvmDataCriterionSchema,
    NetUSDChangeCriterionSchema
])).max(10).min(1);
const SignEvmMessageCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    EvmMessageCriterionSchema
])).max(10).min(1);
const SendEvmTransactionCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    EthValueCriterionSchema,
    EvmAddressCriterionSchema,
    SendEvmTransactionEvmNetworkCriterionSchema,
    EvmDataCriterionSchema,
    NetUSDChangeCriterionSchema
])).max(10).min(1);
const PrepareUserOperationCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    EthValueCriterionSchema,
    EvmAddressCriterionSchema,
    PrepareUserOperationEvmNetworkCriterionSchema,
    EvmDataCriterionSchema,
    NetUSDChangeCriterionSchema
])).max(10).min(1);
const SendUserOperationCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    EthValueCriterionSchema,
    EvmAddressCriterionSchema,
    EvmDataCriterionSchema,
    NetUSDChangeCriterionSchema
])).max(10).min(1);
const EvmOperationEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "signEvmTransaction",
    "sendEvmTransaction",
    "signEvmMessage",
    "signEvmTypedData",
    "signEvmHash",
    "prepareUserOperation",
    "sendUserOperation"
]);
const ActionEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "reject",
    "accept"
]);
const SignEvmTransactionRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the transaction, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "signEvmTransaction".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("signEvmTransaction"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SignEvmTransactionCriteriaSchema
});
const SignEvmHashRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the signing, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "signEvmHash".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("signEvmHash")
});
const SignEvmMessageRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the signing, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "signEvmMessage".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("signEvmMessage"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SignEvmMessageCriteriaSchema
});
const SignEvmTypedDataRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the signing, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "signEvmTypedData".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("signEvmTypedData"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SignEvmTypedDataCriteriaSchema
});
const SendEvmTransactionRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the transaction, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "sendEvmTransaction".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("sendEvmTransaction"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SendEvmTransactionCriteriaSchema
});
const PrepareUserOperationRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the operation, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "prepareUserOperation".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("prepareUserOperation"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: PrepareUserOperationCriteriaSchema
});
const SendUserOperationRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the operation, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "sendUserOperation".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("sendUserOperation"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SendUserOperationCriteriaSchema
}); //# sourceMappingURL=evmSchema.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/policies/solanaSchema.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ActionEnum",
    ()=>ActionEnum,
    "IdlSchema",
    ()=>IdlSchema,
    "KnownIdlTypeEnum",
    ()=>KnownIdlTypeEnum,
    "MintAddressCriterionSchema",
    ()=>MintAddressCriterionSchema,
    "MintAddressOperatorEnum",
    ()=>MintAddressOperatorEnum,
    "ProgramIdCriterionSchema",
    ()=>ProgramIdCriterionSchema,
    "ProgramIdOperatorEnum",
    ()=>ProgramIdOperatorEnum,
    "SendSolTransactionCriteriaSchema",
    ()=>SendSolTransactionCriteriaSchema,
    "SendSolTransactionRuleSchema",
    ()=>SendSolTransactionRuleSchema,
    "SignSolMessageCriteriaSchema",
    ()=>SignSolMessageCriteriaSchema,
    "SignSolMessageRuleSchema",
    ()=>SignSolMessageRuleSchema,
    "SignSolTransactionCriteriaSchema",
    ()=>SignSolTransactionCriteriaSchema,
    "SignSolTransactionRuleSchema",
    ()=>SignSolTransactionRuleSchema,
    "SolAddressCriterionSchema",
    ()=>SolAddressCriterionSchema,
    "SolAddressOperatorEnum",
    ()=>SolAddressOperatorEnum,
    "SolDataConditionSchema",
    ()=>SolDataConditionSchema,
    "SolDataCriterionSchema",
    ()=>SolDataCriterionSchema,
    "SolDataParameterConditionListSchema",
    ()=>SolDataParameterConditionListSchema,
    "SolDataParameterConditionSchema",
    ()=>SolDataParameterConditionSchema,
    "SolDataParameterListOperatorEnum",
    ()=>SolDataParameterListOperatorEnum,
    "SolDataParameterOperatorEnum",
    ()=>SolDataParameterOperatorEnum,
    "SolMessageCriterionSchema",
    ()=>SolMessageCriterionSchema,
    "SolNetworkCriterionSchema",
    ()=>SolNetworkCriterionSchema,
    "SolNetworkEnum",
    ()=>SolNetworkEnum,
    "SolNetworkOperatorEnum",
    ()=>SolNetworkOperatorEnum,
    "SolOperationEnum",
    ()=>SolOperationEnum,
    "SolValueCriterionSchema",
    ()=>SolValueCriterionSchema,
    "SolValueOperatorEnum",
    ()=>SolValueOperatorEnum,
    "SplAddressCriterionSchema",
    ()=>SplAddressCriterionSchema,
    "SplAddressOperatorEnum",
    ()=>SplAddressOperatorEnum,
    "SplValueCriterionSchema",
    ()=>SplValueCriterionSchema,
    "SplValueOperatorEnum",
    ()=>SplValueOperatorEnum
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zod@3.25.76/node_modules/zod/v3/external.js [app-ssr] (ecmascript) <export * as z>");
;
const ActionEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "reject",
    "accept"
]);
const SolAddressOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const SolValueOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    ">",
    ">=",
    "<",
    "<=",
    "=="
]);
const SplAddressOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const SplValueOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    ">",
    ">=",
    "<",
    "<=",
    "=="
]);
const MintAddressOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const ProgramIdOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const SolNetworkOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const SolNetworkEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "solana-devnet",
    "solana"
]);
const KnownIdlTypeEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "SystemProgram",
    "TokenProgram",
    "AssociatedTokenProgram"
]);
const IdlSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The program address */ address: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    /** Array of instruction specifications */ instructions: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].any())
}).passthrough();
const SolDataParameterOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    ">",
    ">=",
    "<",
    "<=",
    "=="
]);
const SolDataParameterListOperatorEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "in",
    "not in"
]);
const SolDataParameterConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The parameter name */ name: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    /** The operator to use for the comparison */ operator: SolDataParameterOperatorEnum,
    /** The value to compare against */ value: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
});
const SolDataParameterConditionListSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The parameter name */ name: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    /** The operator to use for the comparison */ operator: SolDataParameterListOperatorEnum,
    /** The values to compare against */ values: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string())
});
const SolDataConditionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The instruction name */ instruction: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string(),
    /** Parameter conditions for the instruction */ params: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        SolDataParameterConditionSchema,
        SolDataParameterConditionListSchema
    ])).optional()
});
const SolAddressCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "solAddress" for Solana address-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("solAddress"),
    /**
     * Array of Solana addresses to compare against.
     * Each address must be a valid Base58-encoded Solana address (32-44 characters).
     */ addresses: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[1-9A-HJ-NP-Za-km-z]{32,44}$/)),
    /**
     * The operator to use for evaluating transaction addresses.
     * "in" checks if an address is in the provided list.
     * "not in" checks if an address is not in the provided list.
     */ operator: SolAddressOperatorEnum
});
const SolValueCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "solValue" for SOL value-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("solValue"),
    /**
     * The SOL value amount in lamports to compare against, as a string.
     * Must contain only digits.
     */ solValue: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[0-9]+$/),
    /** The comparison operator to use for evaluating transaction SOL values against the threshold. */ operator: SolValueOperatorEnum
});
const SplAddressCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "splAddress" for SPL address-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("splAddress"),
    /**
     * Array of Solana addresses to compare against for SPL token transfer recipients.
     * Each address must be a valid Base58-encoded Solana address (32-44 characters).
     */ addresses: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[1-9A-HJ-NP-Za-km-z]{32,44}$/)),
    /**
     * The operator to use for evaluating SPL token transfer recipient addresses.
     * "in" checks if an address is in the provided list.
     * "not in" checks if an address is not in the provided list.
     */ operator: SplAddressOperatorEnum
});
const SplValueCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "splValue" for SPL token value-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("splValue"),
    /**
     * The SPL token value amount to compare against, as a string.
     * Must contain only digits.
     */ splValue: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[0-9]+$/),
    /** The comparison operator to use for evaluating SPL token values against the threshold. */ operator: SplValueOperatorEnum
});
const MintAddressCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "mintAddress" for token mint address-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("mintAddress"),
    /**
     * Array of Solana addresses to compare against for token mint addresses.
     * Each address must be a valid Base58-encoded Solana address (32-44 characters).
     */ addresses: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[1-9A-HJ-NP-Za-km-z]{32,44}$/)),
    /**
     * The operator to use for evaluating token mint addresses.
     * "in" checks if an address is in the provided list.
     * "not in" checks if an address is not in the provided list.
     */ operator: MintAddressOperatorEnum
});
const SolDataCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "solData" for Solana data-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("solData"),
    /**
     * List of IDL specifications. Can contain known program names (strings) or custom IDL objects.
     */ idls: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].union([
        KnownIdlTypeEnum,
        IdlSchema
    ])),
    /**
     * A list of conditions to apply against the transaction instruction.
     * Only one condition must evaluate to true for this criterion to be met.
     */ conditions: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(SolDataConditionSchema)
});
const ProgramIdCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "programId" for program ID-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("programId"),
    /**
     * Array of Solana program IDs to compare against.
     * Each program ID must be a valid Base58-encoded Solana address (32-44 characters).
     */ programIds: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[1-9A-HJ-NP-Za-km-z]{32,44}$/)),
    /**
     * The operator to use for evaluating transaction program IDs.
     * "in" checks if a program ID is in the provided list.
     * "not in" checks if a program ID is not in the provided list.
     */ operator: ProgramIdOperatorEnum
});
const SolNetworkCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "solNetwork" for network-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("solNetwork"),
    /**
     * Array of Solana networks to compare against.
     */ networks: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(SolNetworkEnum),
    /**
     * The operator to use for evaluating transaction network.
     * "in" checks if the network is in the provided list.
     * "not in" checks if the network is not in the provided list.
     */ operator: SolNetworkOperatorEnum
});
const SolMessageCriterionSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /** The type of criterion, must be "solMessage" for message-based rules. */ type: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("solMessage"),
    /**
     * A regular expression pattern to match against the message.
     */ match: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string()
});
const SignSolTransactionCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    SolAddressCriterionSchema,
    SolValueCriterionSchema,
    SplAddressCriterionSchema,
    SplValueCriterionSchema,
    MintAddressCriterionSchema,
    SolDataCriterionSchema,
    ProgramIdCriterionSchema
])).max(10).min(1);
const SendSolTransactionCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("type", [
    SolAddressCriterionSchema,
    SolValueCriterionSchema,
    SplAddressCriterionSchema,
    SplValueCriterionSchema,
    MintAddressCriterionSchema,
    SolDataCriterionSchema,
    ProgramIdCriterionSchema,
    SolNetworkCriterionSchema
])).max(10).min(1);
const SolOperationEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "signSolTransaction",
    "sendSolTransaction",
    "signSolMessage"
]);
const SignSolTransactionRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the transaction, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "signSolTransaction".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("signSolTransaction"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SignSolTransactionCriteriaSchema
});
const SendSolTransactionRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the transaction, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "sendSolTransaction".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("sendSolTransaction"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SendSolTransactionCriteriaSchema
});
const SignSolMessageCriteriaSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(SolMessageCriterionSchema).max(10).min(1);
const SignSolMessageRuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * Determines whether matching the rule will cause a request to be rejected or accepted.
     * "accept" will allow the message signing, "reject" will block it.
     */ action: ActionEnum,
    /**
     * The operation to which this rule applies.
     * Must be "signSolMessage".
     */ operation: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].literal("signSolMessage"),
    /**
     * The set of criteria that must be matched for this rule to apply.
     * Must be compatible with the specified operation type.
     */ criteria: SignSolMessageCriteriaSchema
}); //# sourceMappingURL=solanaSchema.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/policies/types.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "CreatePolicyBodySchema",
    ()=>CreatePolicyBodySchema,
    "PolicyScopeEnum",
    ()=>PolicyScopeEnum,
    "RuleSchema",
    ()=>RuleSchema,
    "UpdatePolicyBodySchema",
    ()=>UpdatePolicyBodySchema
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zod@3.25.76/node_modules/zod/v3/external.js [app-ssr] (ecmascript) <export * as z>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/policies/evmSchema.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$solanaSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/policies/solanaSchema.js [app-ssr] (ecmascript)");
;
;
;
const PolicyScopeEnum = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].enum([
    "project",
    "account"
]);
const RuleSchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].discriminatedUnion("operation", [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignEvmTransactionRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignEvmHashRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignEvmMessageRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignEvmTypedDataRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SendEvmTransactionRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$solanaSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignSolTransactionRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$solanaSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SendSolTransactionRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$solanaSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SignSolMessageRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["PrepareUserOperationRuleSchema"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$evmSchema$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SendUserOperationRuleSchema"]
]);
const CreatePolicyBodySchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * The scope of the policy.
     * "project" applies to the entire project, "account" applies to specific accounts.
     */ scope: PolicyScopeEnum,
    /**
     * An optional human-readable description for the policy.
     * Limited to 50 characters of alphanumeric characters, spaces, commas, and periods.
     */ description: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[A-Za-z0-9 ,.]{1,50}$/).optional(),
    /**
     * Array of rules that comprise the policy.
     * Limited to a maximum of 10 rules per policy.
     */ rules: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(RuleSchema).max(10).min(1)
});
const UpdatePolicyBodySchema = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].object({
    /**
     * An optional human-readable description for the policy.
     * Limited to 50 characters of alphanumeric characters, spaces, commas, and periods.
     */ description: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].string().regex(/^[A-Za-z0-9 ,.]{1,50}$/).optional(),
    /**
     * Array of rules that comprise the policy.
     * Limited to a maximum of 10 rules per policy.
     */ rules: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zod$40$3$2e$25$2e$76$2f$node_modules$2f$zod$2f$v3$2f$external$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__$2a$__as__z$3e$__["z"].array(RuleSchema).max(10).min(1)
}); //# sourceMappingURL=types.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/policies/policies.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module Client
 */ __turbopack_context__.s([
    "PoliciesClient",
    ()=>PoliciesClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/index.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$types$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/policies/types.js [app-ssr] (ecmascript)");
;
;
;
class PoliciesClient {
    /**
     * Lists policies belonging to the developer's CDP Project.
     * Can be filtered by scope (project or account).
     *
     * @param {ListPoliciesOptions} [options] - Options for filtering and paginating the results
     * @param {string} [options.scope] - Filter policies by scope ('project' or 'account')
     * @param {number} [options.pageSize] - Maximum number of policies to return
     * @param {string} [options.pageToken] - Pagination cursor for fetching next page of results
     *
     * @returns {Promise<ListPoliciesResult>} A paginated list of policies
     *
     * @example **List all policies**
     *          ```ts
     *          const { policies } = await cdp.policies.listPolicies();
     *          ```
     *
     * @example **Filter by scope**
     *          ```ts
     *          const { policies } = await cdp.policies.listPolicies({
     *            scope: 'project'
     *          });
     *          ```
     *
     * @example **With pagination**
     *          ```ts
     *          // Get first page
     *          const firstPage = await cdp.policies.listPolicies({
     *            pageSize: 10
     *          });
     *
     *          // Get next page using cursor
     *          const nextPage = await cdp.policies.listPolicies({
     *            pageSize: 10,
     *            pageToken: firstPage.pageToken
     *          });
     *          ```
     */ async listPolicies(options = {}) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_policies",
            properties: {
                scope: options.scope
            }
        });
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].listPolicies(options);
    }
    /**
     * Creates a new policy that can be used to govern the behavior of projects and accounts.
     *
     * @param {CreatePolicyOptions} options - Options for creating the policy
     * @param {CreatePolicyBody} options.policy - The policy configuration to create
     * @param {string} [options.policy.description] - Description of the policy's purpose
     * @param {Rule[]} options.policy.rules - Rules that define the policy behavior
     * @param {string} [options.idempotencyKey] - An idempotency key to prevent duplicate policy creation
     *
     * @returns {Promise<Policy>} The created policy
     * @throws {ZodError<typeof CreatePolicyBodySchema>} When the policy is invalid
     *
     * @example **Creating a new EVM policy**
     *          ```ts
     *          const policy = await cdp.policies.createPolicy({
     *            policy: {
     *              scope: "account",
     *              description: "Limits the amount of ETH in transaction",
     *              rules: [
     *                {
     *                  action: "reject",
     *                  operation: "signEvmTransaction",
     *                  criteria: [
     *                    {
     *                      type: "ethValue",
     *                      ethValue: "1000000000000000000",
     *                      operator: ">",
     *                    },
     *                  ],
     *                },
     *              ],
     *            }
     *          });
     *          ```
     *
     * @example **Creating a new Solana policy**
     *          ```ts
     *          const policy = await cdp.policies.createPolicy({
     *            policy: {
     *              scope: "account",
     *              description: "Limits SOL transfers and SPL token operations",
     *              rules: [
     *                {
     *                  action: "reject",
     *                  operation: "signSolTransaction",
     *                  criteria: [
     *                    {
     *                      type: "solValue",
     *                      solValue: "1000000000", // 1 SOL in lamports
     *                      operator: ">",
     *                    },
     *                    {
     *                      type: "solAddress",
     *                      addresses: ["9xQeWvG816bUx9EPjHmaT23yvVM2ZWbrrpZb9PusVFin"],
     *                      operator: "in",
     *                    },
     *                  ],
     *                },
     *                {
     *                  action: "accept",
     *                  operation: "sendSolTransaction",
     *                  criteria: [
     *                    {
     *                      type: "mintAddress",
     *                      addresses: ["EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v"], // USDC mint
     *                      operator: "in",
     *                    },
     *                  ],
     *                },
     *              ],
     *            }
     *          });
     *          ```
     *
     * @example **With idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call creates the policy
     *          const policy = await cdp.policies.createPolicy({
     *            policy: {
     *              scope: "account",
     *              description: "Limits the amount of ETH in transaction",
     *              rules: [
     *                {
     *                  action: "reject",
     *                  operation: "signEvmTransaction",
     *                  criteria: [
     *                    {
     *                      type: "ethValue",
     *                      ethValue: "1000000000000000000",
     *                      operator: ">",
     *                    },
     *                  ],
     *                },
     *              ],
     *            },
     *            idempotencyKey
     *          });
     *
     *          // Second call with same key returns the same policy
     *          const samePolicy = await cdp.policies.createPolicy({
     *            policy: { ... },
     *            idempotencyKey
     *          });
     *          ```
     */ async createPolicy(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "create_policy",
            properties: {
                scope: options.policy.scope
            }
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$types$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePolicyBodySchema"].parse(options.policy);
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].createPolicy(// There are arbitrary differences between the abitype Abi and the openapi Abi
        options.policy, options.idempotencyKey);
    }
    /**
     * Retrieves a policy by its unique identifier.
     *
     * @param {GetPolicyByIdOptions} options - Options containing the policy ID to retrieve
     * @param {string} options.id - The unique identifier of the policy to retrieve
     *
     * @returns {Promise<Policy>} The requested policy
     *
     * @example **Retrieving a policy by ID**
     *          ```ts
     *          const policy = await cdp.policies.getPolicyById({
     *            id: "__ID__"
     *          });
     *
     *          console.log(policy.name);
     *          console.log(policy.rules);
     *          ```
     */ async getPolicyById(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_policy_by_id"
        });
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getPolicyById(options.id);
    }
    /**
     * Deletes a policy by its unique identifier.
     * If a policy is referenced by an active project or account, this operation will fail.
     *
     * @param {DeletePolicyOptions} options - Options containing the policy ID to delete
     * @param {string} options.id - The unique identifier of the policy to delete
     * @param {string} [options.idempotencyKey] - An idempotency key to prevent duplicate deletion
     *
     * @returns {Promise<void>} Void on successful deletion
     *
     * @example **Deleting a policy**
     *          ```ts
     *          await cdp.policies.deletePolicy({
     *            id: "__ID__"
     *          });
     *          ```
     *
     * @example **With idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // This operation is idempotent with the key
     *          await cdp.policies.deletePolicy({
     *            id: "__ID__",
     *            idempotencyKey
     *          });
     *          ```
     */ async deletePolicy(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "delete_policy"
        });
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].deletePolicy(options.id, options.idempotencyKey);
    }
    /**
     * Updates an existing policy by its unique identifier.
     * This will apply the updated policy to any project or accounts that are currently using it.
     *
     * @param {UpdatePolicyOptions} options - Options containing the policy ID and updated policy data
     * @param {string} options.id - The unique identifier of the policy to update
     * @param {UpdatePolicyBody} options.policy - The updated policy configuration
     * @param {string} [options.policy.description] - Updated description of the policy's purpose
     * @param {Rule[]} [options.policy.rules] - Updated rules that define the policy behavior
     * @param {string} [options.idempotencyKey] - An idempotency key to prevent duplicate updates
     *
     * @returns {Promise<Policy>} The updated policy
     * @throws {ZodError<typeof UpdatePolicyBodySchema>} When the updated policy is invalid
     *
     * @example **Updating an EVM policy**
     *          ```ts
     *          const updatedPolicy = await cdp.policies.updatePolicy({
     *            id: "__ID__",
     *            policy: {
     *              description: "Now with lower transaction limits",
     *              rules: [
     *                {
     *                  action: "reject",
     *                  operation: "signEvmTransaction",
     *                  criteria: [
     *                    {
     *                      type: "ethValue",
     *                      ethValue: "1000000000",
     *                      operator: ">",
     *                    },
     *                  ],
     *                },
     *              ],
     *            },
     *          });
     *          ```
     *
     * @example **Updating a Solana policy**
     *          ```ts
     *          const updatedPolicy = await cdp.policies.updatePolicy({
     *            id: "__ID__",
     *            policy: {
     *              description: "Updated Solana transaction limits",
     *              rules: [
     *                {
     *                  action: "reject",
     *                  operation: "signSolTransaction",
     *                  criteria: [
     *                    {
     *                      type: "splValue",
     *                      splValue: "1000000", // SPL token amount
     *                      operator: ">=",
     *                    },
     *                    {
     *                      type: "mintAddress",
     *                      addresses: ["EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v"], // USDC mint
     *                      operator: "in",
     *                    },
     *                  ],
     *                },
     *              ],
     *            },
     *          });
     *          ```
     *
     * @example **With idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // This operation is idempotent with the key
     *          await cdp.policies.updatePolicy({
     *            id: "__ID__",
     *            policy: {
     *              description: "Modified Policy",
     *              rules: { ... }
     *            },
     *            idempotencyKey
     *          });
     *          ```
     */ async updatePolicy(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "update_policy"
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$policies$2f$types$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UpdatePolicyBodySchema"].parse(options.policy);
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].updatePolicy(options.id, // There are arbitrary differences between the abitype Abi and the openapi Abi
        options.policy, options.idempotencyKey);
    }
} //# sourceMappingURL=policies.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/fund/fund.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "fund",
    ()=>fund
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/unit/formatUnits.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
;
;
;
async function fund(apiClient, options) {
    if (options.token !== "sol" && options.token !== "usdc") {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid token, must be sol or usdc");
    }
    const decimals = options.token === "sol" ? 9 : 6;
    const amount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["formatUnits"])(options.amount, decimals);
    const paymentMethods = await apiClient.getPaymentMethods();
    const cardPaymentMethod = paymentMethods.find((method)=>method.type === "card" && method.actions.includes("source"));
    if (!cardPaymentMethod) {
        throw new Error("No card found to fund account");
    }
    const response = await apiClient.createPaymentTransferQuote({
        sourceType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodySourceType"].payment_method,
        source: {
            id: cardPaymentMethod.id
        },
        targetType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodyTargetType"].crypto_rail,
        target: {
            currency: options.token,
            network: "solana",
            address: options.address
        },
        amount,
        currency: options.token,
        execute: true
    });
    return {
        id: response.transfer.id,
        network: response.transfer.target.network,
        status: response.transfer.status,
        targetAmount: response.transfer.targetAmount,
        targetCurrency: response.transfer.targetCurrency,
        transactionHash: response.transfer.transactionHash
    };
} //# sourceMappingURL=fund.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/fund/quoteFund.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "quoteFund",
    ()=>quoteFund
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._95fcb29be1e3bab86b514a645df2fca0/node_modules/viem/_esm/utils/unit/formatUnits.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/generated/coinbaseDeveloperPlatformAPIs.schemas.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$Quote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/Quote.js [app-ssr] (ecmascript)");
;
;
;
;
async function quoteFund(apiClient, options) {
    if (options.token !== "sol" && options.token !== "usdc") {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid token, must be sol or usdc");
    }
    const decimals = options.token === "sol" ? 9 : 6;
    const amount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_95fcb29be1e3bab86b514a645df2fca0$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$unit$2f$formatUnits$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["formatUnits"])(options.amount, decimals);
    const paymentMethods = await apiClient.getPaymentMethods();
    const cardPaymentMethod = paymentMethods.find((method)=>method.type === "card" && method.actions.includes("source"));
    if (!cardPaymentMethod) {
        throw new Error("No card found to fund account");
    }
    const response = await apiClient.createPaymentTransferQuote({
        sourceType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodySourceType"].payment_method,
        source: {
            id: cardPaymentMethod.id
        },
        targetType: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$generated$2f$coinbaseDeveloperPlatformAPIs$2e$schemas$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CreatePaymentTransferQuoteBodyTargetType"].crypto_rail,
        target: {
            currency: options.token,
            network: "solana",
            address: options.address
        },
        amount,
        currency: options.token
    });
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$Quote$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SolanaQuote"](apiClient, response.transfer.id, "solana", response.transfer.sourceAmount, response.transfer.sourceCurrency, response.transfer.targetAmount, response.transfer.targetCurrency, response.transfer.fees.map((fee)=>({
            type: fee.type,
            amount: fee.amount,
            currency: fee.currency
        })));
} //# sourceMappingURL=quoteFund.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/requestFaucet.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Requests funds from a Solana faucet.
 *
 * @param apiClient - The API client.
 * @param {RequestFaucetOptions} options - Parameters for requesting funds from the Solana faucet.
 * @param {string} options.address - The address to request funds for.
 * @param {string} options.token - The token to request funds for.
 * @param {string} [options.idempotencyKey] - An idempotency key.
 *
 * @returns A promise that resolves to the transaction signature.
 *
 * @example
 *          ```ts
 *          const signature = await requestFaucet(cdp.solana, {
 *            address: "1234567890123456789012345678901234567890",
 *            token: "sol",
 *          });
 *          ```
 */ __turbopack_context__.s([
    "requestFaucet",
    ()=>requestFaucet
]);
async function requestFaucet(apiClient, options) {
    const signature = await apiClient.requestSolanaFaucet({
        address: options.address,
        token: options.token
    }, options.idempotencyKey);
    return {
        signature: signature.transactionSignature
    };
} //# sourceMappingURL=requestFaucet.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/sendTransaction.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Sends a Solana transaction using the Coinbase API.
 *
 * @param {CdpOpenApiClientType} apiClient - The API client to use.
 * @param {SendTransactionOptions} options - Parameters for sending the Solana transaction.
 * @param {string} options.network - The network to send the transaction to.
 * @param {string} options.transaction - The base64 encoded transaction to send.
 * @param {string} [options.idempotencyKey] - An idempotency key.
 *
 * @returns A promise that resolves to the transaction result.
 *
 * @example
 * ```ts
 * const signature = await sendTransaction({
 *   network: "solana-devnet",
 *   transaction: "...",
 * });
 * ```
 */ __turbopack_context__.s([
    "sendTransaction",
    ()=>sendTransaction
]);
async function sendTransaction(apiClient, options) {
    const signature = await apiClient.sendSolanaTransaction({
        network: options.network,
        transaction: options.transaction
    }, options.idempotencyKey);
    return {
        transactionSignature: signature.transactionSignature,
        signature: signature.transactionSignature
    };
} //# sourceMappingURL=sendTransaction.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/signMessage.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Sign a message.
 *
 * @param apiClient - The API client.
 * @param {SignMessageOptions} options - Parameters for signing the message.
 * @param {string} options.address - The address to sign the message for.
 * @param {string} options.message - The message to sign.
 * @param {string} [options.idempotencyKey] - An idempotency key.
 *
 * @returns A promise that resolves to the transaction signature.
 *
 * @example
 *          ```ts
 *          const signature = await signMessage(cdp.solana, {
 *            address: "1234567890123456789012345678901234567890",
 *            message: "Hello, world!",
 *          });
 *          ```
 */ __turbopack_context__.s([
    "signMessage",
    ()=>signMessage
]);
async function signMessage(apiClient, options) {
    const signature = await apiClient.signSolanaMessage(options.address, {
        message: options.message
    }, options.idempotencyKey);
    return {
        signature: signature.signature
    };
} //# sourceMappingURL=signMessage.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/signTransaction.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Signs a transaction.
 *
 * @param apiClient - The API client.
 * @param {SignTransactionOptions} options - Parameters for signing the transaction.
 * @param {string} options.address - The address to sign the transaction for.
 * @param {string} options.transaction - The transaction to sign.
 * @param {string} [options.idempotencyKey] - An idempotency key.
 *
 * @returns A promise that resolves to the signature.
 *
 * @example
 * ```ts
 * // Create a Solana account
 * const account = await cdp.solana.createAccount();
 *
 * // Add your transaction instructions here
 * const transaction = new Transaction()
 *
 * // Make sure to set requireAllSignatures to false, since signing will be done through the API
 * const serializedTransaction = transaction.serialize({
 *   requireAllSignatures: false,
 * });
 *
 * // Base64 encode the serialized transaction
 * const transaction = Buffer.from(serializedTransaction).toString("base64");
 *
 * // When you want to sign a transaction, you can do so by address and base64 encoded transaction
 * const signature = await signTransaction(cdp.solana, {
 *   address: account.address,
 *   transaction,
 * });
 * ```
 */ __turbopack_context__.s([
    "signTransaction",
    ()=>signTransaction
]);
async function signTransaction(apiClient, options) {
    const signature = await apiClient.signSolanaTransaction(options.address, {
        transaction: options.transaction
    }, options.idempotencyKey);
    return {
        signedTransaction: signature.signedTransaction,
        signature: signature.signedTransaction
    };
} //# sourceMappingURL=signTransaction.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/rpc.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createRpcClient",
    ()=>createRpcClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$rpc$40$3$2e$0$2e$3_fastestsm_afe0c3df33d562b7fe90d96e10bceb65$2f$node_modules$2f40$solana$2f$rpc$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+rpc@3.0.3_fastestsm_afe0c3df33d562b7fe90d96e10bceb65/node_modules/@solana/rpc/dist/index.node.mjs [app-ssr] (ecmascript) <locals>");
;
function createRpcClient(network) {
    const endpoint = network === "mainnet" ? "https://api.mainnet-beta.solana.com" : "https://api.devnet.solana.com";
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$rpc$40$3$2e$0$2e$3_fastestsm_afe0c3df33d562b7fe90d96e10bceb65$2f$node_modules$2f40$solana$2f$rpc$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["createSolanaRpc"])(endpoint);
} //# sourceMappingURL=rpc.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/constants.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "GENESIS_HASH_DEVNET",
    ()=>GENESIS_HASH_DEVNET,
    "GENESIS_HASH_MAINNET",
    ()=>GENESIS_HASH_MAINNET,
    "GENESIS_HASH_TESTNET",
    ()=>GENESIS_HASH_TESTNET,
    "USDC_DEVNET_MINT_ADDRESS",
    ()=>USDC_DEVNET_MINT_ADDRESS,
    "USDC_MAINNET_MINT_ADDRESS",
    ()=>USDC_MAINNET_MINT_ADDRESS
]);
const GENESIS_HASH_MAINNET = "5eykt4UsFv8P8NJdTREpY1vzqKqZKvdpKuc147dw2N9d";
const GENESIS_HASH_DEVNET = "EtWTRABZaYq6iMfeYKouRu166VU2xqa1wcaWoxPkrZBG";
const GENESIS_HASH_TESTNET = "4uhcVJyU9pJkvQyS88uRDiswHXSCkY3zQawwpjk2NsNY";
const USDC_MAINNET_MINT_ADDRESS = "EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v";
const USDC_DEVNET_MINT_ADDRESS = "4zMMC9srt5Ri5X14GAgXhaHii3GnPAEERYPJgZJDncDU"; //# sourceMappingURL=constants.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/utils.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getConnectedNetwork",
    ()=>getConnectedNetwork,
    "getOrCreateConnection",
    ()=>getOrCreateConnection,
    "getUsdcMintAddress",
    ()=>getUsdcMintAddress
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$web3$2e$js$40$1$2e$98$2e$4_buff_1d00a4737ce00f2fb6141572da6194da$2f$node_modules$2f40$solana$2f$web3$2e$js$2f$lib$2f$index$2e$esm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+web3.js@1.98.4_buff_1d00a4737ce00f2fb6141572da6194da/node_modules/@solana/web3.js/lib/index.esm.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/constants.js [app-ssr] (ecmascript)");
;
;
function getOrCreateConnection({ networkOrConnection }) {
    if (typeof networkOrConnection !== "string") {
        return networkOrConnection;
    }
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$web3$2e$js$40$1$2e$98$2e$4_buff_1d00a4737ce00f2fb6141572da6194da$2f$node_modules$2f40$solana$2f$web3$2e$js$2f$lib$2f$index$2e$esm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Connection"](networkOrConnection === "mainnet" ? "https://api.mainnet-beta.solana.com" : "https://api.devnet.solana.com");
}
async function getConnectedNetwork(connection) {
    const genesisHash = await connection.getGenesisHash();
    if (genesisHash === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["GENESIS_HASH_MAINNET"]) {
        return "mainnet";
    } else if (genesisHash === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["GENESIS_HASH_DEVNET"]) {
        return "devnet";
    }
    throw new Error("Unknown or unsupported network");
}
function getUsdcMintAddress(network) {
    if (network === "mainnet") {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["USDC_MAINNET_MINT_ADDRESS"];
    }
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["USDC_DEVNET_MINT_ADDRESS"];
} //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/transfer.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getNativeTransferBase64Transaction",
    ()=>getNativeTransferBase64Transaction,
    "getSplTransferBase64Transaction",
    ()=>getSplTransferBase64Transaction,
    "transfer",
    ()=>transfer
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$functional$40$3$2e$0$2e$3_typescript$40$5$2e$9$2e$3$2f$node_modules$2f40$solana$2f$functional$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+functional@3.0.3_typescript@5.9.3/node_modules/@solana/functional/dist/index.node.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+transaction-message_74b41be3cf17943d8fe6aa723a6ba225/node_modules/@solana/transaction-messages/dist/index.node.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$addresses$40$3$2e$0$2e$3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff$2f$node_modules$2f40$solana$2f$addresses$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+addresses@3.0.3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff/node_modules/@solana/addresses/dist/index.node.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transactions$40$3$2e$0$2e$3_$5f$819b82c46e1d4867418becedf2bb6280$2f$node_modules$2f40$solana$2f$transactions$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+transactions@3.0.3__819b82c46e1d4867418becedf2bb6280/node_modules/@solana/transactions/dist/index.node.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$signers$40$3$2e$0$2e$3_faste_3609c4397eb0340fb8e8a680f2e57b1c$2f$node_modules$2f40$solana$2f$signers$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana+signers@3.0.3_faste_3609c4397eb0340fb8e8a680f2e57b1c/node_modules/@solana/signers/dist/index.node.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$system$40$0$2e$8$2e$_dc97f28ced21facc4a2f6a543c2f7841$2f$node_modules$2f40$solana$2d$program$2f$system$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana-program+system@0.8._dc97f28ced21facc4a2f6a543c2f7841/node_modules/@solana-program/system/dist/src/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@solana-program+token@0.6.0_e33755254f50a788fc628f1033650f1b/node_modules/@solana-program/token/dist/src/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$rpc$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/rpc.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/sendTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/utils.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
async function transfer(apiClient, options) {
    const connection = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getOrCreateConnection"])({
        networkOrConnection: options.network
    });
    const connectedNetwork = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getConnectedNetwork"])(connection);
    const rpc = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$rpc$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createRpcClient"])(connectedNetwork);
    const base64Transaction = options.token === "sol" ? await getNativeTransferBase64Transaction({
        rpc,
        from: options.from,
        to: options.to,
        amount: options.amount
    }) : await getSplTransferBase64Transaction({
        rpc,
        from: options.from,
        to: options.to,
        mintAddress: options.token === "usdc" ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$utils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUsdcMintAddress"])(connectedNetwork) : options.token,
        amount: options.amount
    });
    const signature = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendTransaction"])(apiClient, {
        network: connectedNetwork === "mainnet" ? "solana" : "solana-devnet",
        transaction: base64Transaction
    });
    return signature;
}
async function getNativeTransferBase64Transaction({ rpc, from, to, amount }) {
    const fromAddr = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$addresses$40$3$2e$0$2e$3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff$2f$node_modules$2f40$solana$2f$addresses$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["address"])(from);
    const toAddr = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$addresses$40$3$2e$0$2e$3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff$2f$node_modules$2f40$solana$2f$addresses$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["address"])(to);
    const instructions = [
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$system$40$0$2e$8$2e$_dc97f28ced21facc4a2f6a543c2f7841$2f$node_modules$2f40$solana$2d$program$2f$system$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTransferSolInstruction"])({
            source: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$signers$40$3$2e$0$2e$3_faste_3609c4397eb0340fb8e8a680f2e57b1c$2f$node_modules$2f40$solana$2f$signers$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createNoopSigner"])(fromAddr),
            destination: toAddr,
            amount
        })
    ];
    const { value: latestBlockhash } = await rpc.getLatestBlockhash().send();
    const txMsg = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$functional$40$3$2e$0$2e$3_typescript$40$5$2e$9$2e$3$2f$node_modules$2f40$solana$2f$functional$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["pipe"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createTransactionMessage"])({
        version: 0
    }), (tx)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["setTransactionMessageFeePayer"])(fromAddr, tx), (tx)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["setTransactionMessageLifetimeUsingBlockhash"])(latestBlockhash, tx), (tx)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["appendTransactionMessageInstructions"])(instructions, tx));
    const compiledTransaction = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transactions$40$3$2e$0$2e$3_$5f$819b82c46e1d4867418becedf2bb6280$2f$node_modules$2f40$solana$2f$transactions$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["compileTransaction"])(txMsg);
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transactions$40$3$2e$0$2e$3_$5f$819b82c46e1d4867418becedf2bb6280$2f$node_modules$2f40$solana$2f$transactions$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBase64EncodedWireTransaction"])(compiledTransaction);
}
async function getSplTransferBase64Transaction({ rpc, from, to, mintAddress, amount }) {
    const fromAddr = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$addresses$40$3$2e$0$2e$3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff$2f$node_modules$2f40$solana$2f$addresses$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["address"])(from);
    const toAddr = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$addresses$40$3$2e$0$2e$3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff$2f$node_modules$2f40$solana$2f$addresses$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["address"])(to);
    const mintAddr = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$addresses$40$3$2e$0$2e$3_fas_1a33c18bbf49e3b7dfbf68bf16b959ff$2f$node_modules$2f40$solana$2f$addresses$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["address"])(mintAddress);
    const mintInfo = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchMint"])(rpc, mintAddr);
    const [sourceAta] = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["findAssociatedTokenPda"])({
        mint: mintAddr,
        owner: fromAddr,
        tokenProgram: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TOKEN_PROGRAM_ADDRESS"]
    });
    const [destAta] = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["findAssociatedTokenPda"])({
        mint: mintAddr,
        owner: toAddr,
        tokenProgram: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TOKEN_PROGRAM_ADDRESS"]
    });
    const sourceAcct = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchToken"])(rpc, sourceAta);
    if (sourceAcct.data.amount < amount) {
        throw new Error(`Insufficient token balance: have ${sourceAcct.data.amount}, need ${amount}`);
    }
    const instructions = [];
    // If destination ATA does not exist, add create instruction
    try {
        await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchToken"])(rpc, destAta);
    } catch  {
        const createDestIx = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getCreateAssociatedTokenInstructionAsync"])({
            payer: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$signers$40$3$2e$0$2e$3_faste_3609c4397eb0340fb8e8a680f2e57b1c$2f$node_modules$2f40$solana$2f$signers$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createNoopSigner"])(fromAddr),
            owner: toAddr,
            ata: destAta,
            mint: mintAddr
        });
        instructions.push(createDestIx);
    }
    instructions.push((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2d$program$2b$token$40$0$2e$6$2e$0_e33755254f50a788fc628f1033650f1b$2f$node_modules$2f40$solana$2d$program$2f$token$2f$dist$2f$src$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTransferCheckedInstruction"])({
        source: sourceAta,
        mint: mintAddr,
        destination: destAta,
        authority: fromAddr,
        amount,
        decimals: mintInfo.data.decimals
    }));
    const { value: latestBlockhash } = await rpc.getLatestBlockhash().send();
    const txMsg = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$functional$40$3$2e$0$2e$3_typescript$40$5$2e$9$2e$3$2f$node_modules$2f40$solana$2f$functional$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["pipe"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createTransactionMessage"])({
        version: 0
    }), (tx)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["setTransactionMessageFeePayer"])(fromAddr, tx), (tx)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["setTransactionMessageLifetimeUsingBlockhash"])(latestBlockhash, tx), (tx)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transaction$2d$message_74b41be3cf17943d8fe6aa723a6ba225$2f$node_modules$2f40$solana$2f$transaction$2d$messages$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["appendTransactionMessageInstructions"])(instructions, tx));
    const compiledTransaction = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transactions$40$3$2e$0$2e$3_$5f$819b82c46e1d4867418becedf2bb6280$2f$node_modules$2f40$solana$2f$transactions$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["compileTransaction"])(txMsg);
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$solana$2b$transactions$40$3$2e$0$2e$3_$5f$819b82c46e1d4867418becedf2bb6280$2f$node_modules$2f40$solana$2f$transactions$2f$dist$2f$index$2e$node$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBase64EncodedWireTransaction"])(compiledTransaction);
} //# sourceMappingURL=transfer.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/solana/toSolanaAccount.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "toSolanaAccount",
    ()=>toSolanaAccount
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/fund/fund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/fund/quoteFund.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/requestFaucet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/sendTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signMessage$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/signMessage.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/signTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/transfer.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/waitForFundOperationReceipt.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
function toSolanaAccount(apiClient, options) {
    const account = {
        address: options.account.address,
        name: options.account.name,
        policies: options.account.policies,
        async requestFaucet (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "request_faucet",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["requestFaucet"])(apiClient, {
                ...options,
                address: account.address
            });
        },
        async signMessage (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign_message",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signMessage$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["signMessage"])(apiClient, {
                ...options,
                address: account.address
            });
        },
        async signTransaction (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "sign_transaction",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["signTransaction"])(apiClient, {
                ...options,
                address: account.address
            });
        },
        async sendTransaction (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "send_transaction",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendTransaction"])(apiClient, {
                ...options
            });
        },
        async transfer (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "transfer",
                accountType: "solana",
                properties: {
                    network: options.network
                }
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$transfer$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["transfer"])(apiClient, {
                ...options,
                from: account.address
            });
        },
        async quoteFund (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "quote_fund",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$fund$2f$quoteFund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["quoteFund"])(apiClient, {
                ...options,
                address: account.address
            });
        },
        async fund (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "fund",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$fund$2f$fund$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fund"])(apiClient, {
                ...options,
                address: account.address
            });
        },
        async waitForFundOperationReceipt (options) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
                action: "wait_for_fund_operation_receipt",
                accountType: "solana"
            });
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$waitForFundOperationReceipt$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["waitForFundOperationReceipt"])(apiClient, options);
        }
    };
    return account;
} //# sourceMappingURL=toSolanaAccount.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/solana/solana.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @module Client
 */ __turbopack_context__.s([
    "SolanaClient",
    ()=>SolanaClient
]);
var __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/crypto [external] (crypto, cjs)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$bs58$40$6$2e$0$2e$0$2f$node_modules$2f$bs58$2f$src$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/bs58@6.0.0/node_modules/bs58/src/esm/index.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$solana$2f$toSolanaAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/accounts/solana/toSolanaAccount.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/requestFaucet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/sendTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signMessage$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/signMessage.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/actions/solana/signTransaction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/constants.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/errors.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/index.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/utils/export.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
class SolanaClient {
    /**
     * Creates a new Solana account.
     *
     * @param {CreateAccountOptions} options - Parameters for creating the Solana account.
     * @param {string} [options.name] - The name of the account.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the newly created account.
     *
     * @example **Without arguments**
     *          ```ts
     *          const account = await cdp.solana.createAccount();
     *          ```
     *
     * @example **With a name**
     *          ```ts
     *          const account = await cdp.solana.createAccount({ name: "MyAccount" });
     *          ```
     *
     * @example **With an idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call
     *          await cdp.solana.createAccount({ idempotencyKey });
     *
     *          // Second call with the same idempotency key will return the same account
     *          await cdp.solana.createAccount({ idempotencyKey });
     *          ```
     */ async createAccount(options = {}) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "create_account",
            accountType: "solana"
        });
        return this._createAccountInternal(options);
    }
    /**
     * Exports a CDP Solana account's private key.
     * It is important to store the private key in a secure place after it's exported.
     *
     * @param {ExportAccountOptions} options - Parameters for exporting the Solana account.
     * @param {string} [options.address] - The address of the account.
     * @param {string} [options.name] - The name of the account.
     *
     * @returns A promise that resolves to the exported account's full 64-byte private key as a base58 encoded string.
     *
     * @example **With an address**
     * ```ts
     * const privateKey = await cdp.solana.exportAccount({
     *   address: "1234567890123456789012345678901234567890",
     * });
     * ```
     *
     * @example **With a name**
     * ```ts
     * const privateKey = await cdp.solana.exportAccount({
     *   name: "MyAccount",
     * });
     * ```
     */ async exportAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "export_account",
            accountType: "solana"
        });
        const { publicKey, privateKey } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["generateExportEncryptionKeyPair"])();
        const { encryptedPrivateKey } = await (async ()=>{
            if (options.address) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].exportSolanaAccount(options.address, {
                    exportEncryptionKey: publicKey
                }, options.idempotencyKey);
            }
            if (options.name) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].exportSolanaAccountByName(options.name, {
                    exportEncryptionKey: publicKey
                }, options.idempotencyKey);
            }
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Either address or name must be provided");
        })();
        const decryptedPrivateKey = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["decryptWithPrivateKey"])(privateKey, encryptedPrivateKey);
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$utils$2f$export$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["formatSolanaPrivateKey"])(decryptedPrivateKey);
    }
    /**
     * Imports a Solana account using a private key.
     * The private key will be encrypted before being stored securely.
     *
     * @param {ImportAccountOptions} options - Parameters for importing the Solana account.
     * @param {string} options.privateKey - The private key to import (32 or 64 bytes). Can be a base58 encoded string or raw bytes.
     * @param {string} [options.name] - The name of the account.
     * @param {string} [options.encryptionPublicKey] - The RSA public key for encrypting the private key.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the imported account.
     *
     * @example **Import with private key only**
     *          ```ts
     *          const account = await cdp.solana.importAccount({
     *            privateKey: "3Kzjw8qSxx8bQkV7EHrVFWYiPyNLbBVxtVe1Q5h2zKZY8DdcuT2dKxyz9kU5vQrP",
     *          });
     *          ```
     *
     * @example **Import with name**
     *          ```ts
     *          const account = await cdp.solana.importAccount({
     *            privateKey: "3Kzjw8qSxx8bQkV7EHrVFWYiPyNLbBVxtVe1Q5h2zKZY8DdcuT2dKxyz9kU5vQrP",
     *            name: "ImportedAccount",
     *          });
     *          ```
     *
     * @example **Import with idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          const account = await cdp.solana.importAccount({
     *            privateKey: "3Kzjw8qSxx8bQkV7EHrVFWYiPyNLbBVxtVe1Q5h2zKZY8DdcuT2dKxyz9kU5vQrP",
     *            name: "ImportedAccount",
     *            idempotencyKey,
     *          });
     *          ```
     */ async importAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "import_account",
            accountType: "solana"
        });
        let privateKeyBytes = new Uint8Array();
        if (typeof options.privateKey === "string") {
            privateKeyBytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$bs58$40$6$2e$0$2e$0$2f$node_modules$2f$bs58$2f$src$2f$esm$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].decode(options.privateKey);
        } else {
            privateKeyBytes = options.privateKey;
        }
        if (privateKeyBytes.length !== 32 && privateKeyBytes.length !== 64) {
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Invalid private key length");
        }
        if (privateKeyBytes.length === 64) {
            privateKeyBytes = privateKeyBytes.subarray(0, 32);
        }
        const encryptionPublicKey = options.encryptionPublicKey || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$constants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ImportAccountPublicRSAKey"];
        const encryptedPrivateKey = (0, __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["publicEncrypt"])({
            key: encryptionPublicKey,
            padding: __TURBOPACK__imported__module__$5b$externals$5d2f$crypto__$5b$external$5d$__$28$crypto$2c$__cjs$29$__["constants"].RSA_PKCS1_OAEP_PADDING,
            oaepHash: "sha256"
        }, privateKeyBytes);
        const openApiAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].importSolanaAccount({
            encryptedPrivateKey: encryptedPrivateKey.toString("base64"),
            name: options.name
        }, options.idempotencyKey);
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$solana$2f$toSolanaAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toSolanaAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
    /**
     * Gets a Solana account by its address.
     *
     * @param {GetAccountOptions} options - Parameters for getting the Solana account.
     * Either `address` or `name` must be provided.
     * If both are provided, lookup will be done by `address` and `name` will be ignored.
     * @param {string} [options.address] - The address of the account.
     * @param {string} [options.name] - The name of the account.
     *
     * @returns A promise that resolves to the account.
     *
     * @example **Get an account by address**
     *          ```ts
     *          const account = await cdp.solana.getAccount({
     *            address: "1234567890123456789012345678901234567890",
     *          });
     *          ```
     *
     * @example **Get an account by name**
     *          ```ts
     *          const account = await cdp.solana.getAccount({
     *            name: "MyAccount",
     *          });
     *          ```
     */ async getAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_account",
            accountType: "solana"
        });
        return this._getAccountInternal(options);
    }
    /**
     * Gets a Solana account by its address.
     *
     * @param {GetOrCreateAccountOptions} options - Parameters for getting or creating the Solana account.
     * @param {string} options.name - The name of the account.
     *
     * @returns A promise that resolves to the account.
     *
     * @example
     * ```ts
     * const account = await cdp.solana.getOrCreateAccount({
     *   name: "MyAccount",
     * });
     * ```
     */ async getOrCreateAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "get_or_create_account",
            accountType: "solana"
        });
        try {
            const account = await this._getAccountInternal(options);
            return account;
        } catch (error) {
            // If it failed because the account doesn't exist, create it
            const doesAccountNotExist = error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.statusCode === 404;
            if (doesAccountNotExist) {
                try {
                    const account = await this._createAccountInternal(options);
                    return account;
                } catch (error) {
                    // If it failed because the account already exists, get the existing account
                    const doesAccountAlreadyExist = error instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["APIError"] && error.statusCode === 409;
                    if (doesAccountAlreadyExist) {
                        const account = await this._getAccountInternal(options);
                        return account;
                    }
                    throw error;
                }
            }
            throw error;
        }
    }
    /**
     * Lists all Solana accounts.
     *
     * @param {ListAccountsOptions} options - Parameters for listing the Solana accounts.
     * @param {number} [options.pageSize] - The number of accounts to return.
     * @param {string} [options.pageToken] - The page token to begin listing from.
     * This is obtained by previous calls to this method.
     *
     * @returns A promise that resolves to an array of Solana account instances.
     *
     * @example **Without arguments**
     *          ```ts
     *          const accounts = await cdp.solana.listAccounts();
     *          ```
     *
     * @example **With pagination**
     *          ```ts
     *          let page = await cdp.solana.listAccounts();
     *
     *          while (page.nextPageToken) {
     *            page = await cdp.solana.listAccounts({ pageToken: page.nextPageToken });
     *          }
     *
     *          page.accounts.forEach(account => console.log(account));
     *          ```
     * }
     * ```
     */ async listAccounts(options = {}) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_accounts",
            accountType: "solana"
        });
        const solAccounts = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].listSolanaAccounts({
            pageSize: options.pageSize,
            pageToken: options.pageToken
        });
        return {
            accounts: solAccounts.accounts.map((account)=>{
                const solanaAccount = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$solana$2f$toSolanaAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toSolanaAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
                    account
                });
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(solanaAccount);
                return solanaAccount;
            }),
            nextPageToken: solAccounts.nextPageToken
        };
    }
    /**
     * Requests funds from a Solana faucet.
     *
     * @param {RequestFaucetOptions} options - Parameters for requesting funds from the Solana faucet.
     * @param {string} options.address - The address to request funds for.
     * @param {string} options.token - The token to request funds for.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the transaction signature.
     *
     * @example
     *          ```ts
     *          const signature = await cdp.solana.requestFaucet({
     *            address: "1234567890123456789012345678901234567890",
     *            token: "sol",
     *          });
     *          ```
     */ async requestFaucet(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "request_faucet",
            accountType: "solana"
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$requestFaucet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["requestFaucet"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Signs a message.
     *
     * @param {SignMessageOptions} options - Parameters for signing the message.
     * @param {string} options.address - The address to sign the message for.
     * @param {string} options.message - The message to sign.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the signature.
     *
     * @example
     * ```ts
     * // Create a Solana account
     * const account = await cdp.solana.createAccount();
     *
     * // When you want to sign a message, you can do so by address
     * const signature = await cdp.solana.signMessage({
     *   address: account.address,
     *   message: "Hello, world!",
     * });
     * ```
     */ async signMessage(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "sign_message",
            accountType: "solana"
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signMessage$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["signMessage"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Signs a transaction.
     *
     * @param {SignTransactionOptions} options - Parameters for signing the transaction.
     * @param {string} options.address - The address to sign the transaction for.
     * @param {string} options.transaction - The transaction to sign.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the signature.
     *
     * @example
     * ```ts
     * // Create a Solana account
     * const account = await cdp.solana.createAccount();
     *
     * // Add your transaction instructions here
     * const transaction = new Transaction()
     *
     * // Make sure to set requireAllSignatures to false, since signing will be done through the API
     * const serializedTransaction = transaction.serialize({
     *   requireAllSignatures: false,
     * });
     *
     * // Base64 encode the serialized transaction
     * const transaction = Buffer.from(serializedTransaction).toString("base64");
     *
     * // When you want to sign a transaction, you can do so by address and base64 encoded transaction
     * const signature = await cdp.solana.signTransaction({
     *   address: account.address,
     *   transaction,
     * });
     * ```
     */ async signTransaction(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "sign_transaction",
            accountType: "solana"
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$signTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["signTransaction"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Updates a CDP Solana account.
     *
     * @param {UpdateSolanaAccountOptions} [options] - Optional parameters for creating the account.
     * @param {string} options.address - The address of the account to update
     * @param {UpdateSolanaAccountBody} options.update - An object containing account fields to update.
     * @param {string} [options.update.name] - The new name for the account.
     * @param {string} [options.update.accountPolicy] - The ID of a Policy to apply to the account.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the updated account.
     *
     * @example **With a name**
     *          ```ts
     *          const account = await cdp.sol.updateAccount({ address: "...", update: { name: "New Name" } });
     *          ```
     *
     * @example **With an account policy**
     *          ```ts
     *          const account = await cdp.sol.updateAccount({ address: "...", update: { accountPolicy: "73bcaeeb-d7af-4615-b064-42b5fe83a31e" } });
     *          ```
     *
     * @example **With an idempotency key**
     *          ```ts
     *          const idempotencyKey = uuidv4();
     *
     *          // First call
     *          await cdp.sol.updateAccount({
     *            address: "0x...",
     *            update: { accountPolicy: "73bcaeeb-d7af-4615-b064-42b5fe83a31e" },
     *            idempotencyKey,
     *          });
     *
     *          // Second call with the same idempotency key will not update
     *          await cdp.sol.updateAccount({
     *            address: '0x...',
     *            update: { name: "" },
     *            idempotencyKey,
     *          });
     *          ```
     */ async updateAccount(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "update_account",
            accountType: "solana"
        });
        const openApiAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].updateSolanaAccount(options.address, options.update, options.idempotencyKey);
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$solana$2f$toSolanaAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toSolanaAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
    /**
     * Sends a Solana transaction using the Coinbase API.
     *
     * @param {SendTransactionOptions} options - Parameters for sending the Solana transaction.
     * @param {string} options.network - The network to send the transaction to.
     * @param {string} options.transaction - The base64 encoded transaction to send.
     * @param {string} [options.idempotencyKey] - An idempotency key.
     *
     * @returns A promise that resolves to the transaction result.
     *
     * @example
     * ```ts
     * const signature = await cdp.solana.sendTransaction({
     *   network: "solana-devnet",
     *   transaction: "...",
     * });
     * ```
     */ async sendTransaction(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "send_transaction",
            accountType: "solana",
            properties: {
                network: options.network
            }
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$actions$2f$solana$2f$sendTransaction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["sendTransaction"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], options);
    }
    /**
     * Lists the token balances for a Solana account.
     *
     * @param {ListTokenBalancesOptions} options - Parameters for listing the Solana token balances.
     * @param {string} options.address - The address of the account to list token balances for.
     * @param {string} [options.network] - The network to list token balances for. Defaults to "solana".
     * @param {number} [options.pageSize] - The number of token balances to return.
     * @param {string} [options.pageToken] - The page token to begin listing from.
     * This is obtained by previous calls to this method.
     *
     * @returns A promise that resolves to an array of Solana token balance instances.
     *
     * @example
     * ```ts
     * const balances = await cdp.solana.listTokenBalances({ address: "...", network: "solana-devnet" });
     * ```
     */ async listTokenBalances(options) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].trackAction({
            action: "list_token_balances",
            accountType: "solana",
            properties: {
                network: options.network
            }
        });
        const tokenBalances = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].listSolanaTokenBalances(options.network || "solana", options.address, {
            pageSize: options.pageSize,
            pageToken: options.pageToken
        });
        return {
            balances: tokenBalances.balances.map((balance)=>{
                return {
                    amount: {
                        amount: BigInt(balance.amount.amount),
                        decimals: balance.amount.decimals
                    },
                    token: {
                        mintAddress: balance.token.mintAddress,
                        name: balance.token.name,
                        symbol: balance.token.symbol
                    }
                };
            }),
            nextPageToken: tokenBalances.nextPageToken
        };
    }
    /**
     * Internal method to create a Solana account without tracking analytics.
     * Used internally by composite operations to avoid double-counting.
     *
     * @param {CreateAccountOptions} options - Parameters for creating the account.
     * @returns {Promise<SolanaAccount>} A promise that resolves to the newly created account.
     */ async _createAccountInternal(options = {}) {
        const openApiAccount = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].createSolanaAccount({
            name: options.name,
            accountPolicy: options.accountPolicy
        }, options.idempotencyKey);
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$solana$2f$toSolanaAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toSolanaAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
    /**
     * Internal method to get a Solana account without tracking analytics.
     * Used internally by composite operations to avoid double-counting.
     *
     * @param {GetAccountOptions} options - Parameters for getting the account.
     * @returns {Promise<SolanaAccount>} A promise that resolves to the account.
     */ async _getAccountInternal(options) {
        const openApiAccount = await (()=>{
            if (options.address) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getSolanaAccount(options.address);
            }
            if (options.name) {
                return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].getSolanaAccountByName(options.name);
            }
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["UserInputValidationError"]("Either address or name must be provided");
        })();
        const account = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$accounts$2f$solana$2f$toSolanaAccount$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toSolanaAccount"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"], {
            account: openApiAccount
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapObjectMethodsWithErrorTracking(account);
        return account;
    }
} //# sourceMappingURL=solana.js.map
}),
"[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/cdp.js [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "CdpClient",
    ()=>CdpClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/analytics.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/openapi-client/index.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$version$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/version.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$end$2d$user$2f$endUser$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/end-user/endUser.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$evm$2f$evm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/evm/evm.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$policies$2f$policies$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/policies/policies.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$solana$2f$solana$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@coinbase+cdp-sdk@1.38.4_bu_740928bbf56d984df22d169dda7a39c5/node_modules/@coinbase/cdp-sdk/_esm/client/solana/solana.js [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
class CdpClient {
    /** Namespace containing all EVM methods. */ evm;
    /** Namespace containing all Solana methods. */ solana;
    /** Namespace containing all Policies methods. */ policies;
    /** Namespace containing all end user methods. */ endUser;
    /**
     * The CdpClient is the main class for interacting with the CDP API.
     *
     * There are a few required parameters that are configured in the [CDP Portal](https://portal.cdp.coinbase.com/projects/api-keys):
     * - **CDP Secret API Key** (`apiKeyId` & `apiKeySecret`): These are used to authenticate requests to the entire suite of
     *   APIs offered on Coinbase Developer Platform.
     *   [Read more about CDP API keys](https://docs.cdp.coinbase.com/get-started/docs/cdp-api-keys).
     * - **Wallet Secret** (`walletSecret`): This secret is used specifically to authenticate requests to `POST`, and `DELETE`
     *   endpoints in the EVM and Solana Account APIs.
     *
     * These parameters can be set as environment variables:
     * ```
     * CDP_API_KEY_ID=your-api-key-id
     * CDP_API_KEY_SECRET=your-api-key-secret
     * CDP_WALLET_SECRET=your-wallet-secret
     * ```
     *
     * Or passed as options to the constructor:
     *
     * ```typescript
     * const cdp = new CdpClient({
     *   apiKeyId: "your-api-key-id",
     *   apiKeySecret: "your-api-key-secret",
     *   walletSecret: "your-wallet-secret",
     * });
     * ```
     *
     * The CdpClient is namespaced by chain type: `evm` or `solana`.
     *
     * As an example, to create a new EVM account, use `cdp.evm.createAccount()`.
     *
     * To create a new Solana account, use `cdp.solana.createAccount()`.
     *
     * @param {CdpClientOptions} [options] - Configuration options for the CdpClient.
     */ constructor(options = {}){
        if (Number(process.versions.node.split(".")[0]) < 19) {
            throw new Error(`
Node.js version ${process.versions.node} is not supported. CDP SDK requires Node.js version 19 or higher. Please upgrade your Node.js version to use the CDP SDK.
We recommend using https://github.com/Schniz/fnm for managing your Node.js version.
        `);
        }
        const apiKeyId = options.apiKeyId ?? process.env.CDP_API_KEY_ID ?? process.env.CDP_API_KEY_NAME;
        const apiKeySecret = options.apiKeySecret ?? process.env.CDP_API_KEY_SECRET;
        const walletSecret = options.walletSecret ?? process.env.CDP_WALLET_SECRET;
        if (!apiKeyId || !apiKeySecret) {
            throw new Error(`
\nMissing required CDP Secret API Key configuration parameters.

You can set them as environment variables:

CDP_API_KEY_ID=your-api-key-id
CDP_API_KEY_SECRET=your-api-key-secret

You can also pass them as options to the constructor:

const cdp = new CdpClient({
  apiKeyId: "your-api-key-id",
  apiKeySecret: "your-api-key-secret",
});

If you're performing write operations, make sure to also set your wallet secret:

CDP_WALLET_SECRET=your-wallet-secret

This is also available as an option to the constructor:

const cdp = new CdpClient({
  apiKeyId: "your-api-key-id",
  apiKeySecret: "your-api-key-secret",
  walletSecret: "your-wallet-secret",
});

For more information, see: https://github.com/coinbase/cdp-sdk/blob/main/typescript/README.md#api-keys.
`);
        }
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$openapi$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["CdpOpenApiClient"].configure({
            ...options,
            apiKeyId,
            apiKeySecret,
            walletSecret,
            source: "sdk",
            sourceVersion: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$version$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["version"]
        });
        if (process.env.DISABLE_CDP_ERROR_REPORTING !== "true" || process.env.DISABLE_CDP_USAGE_TRACKING !== "true") {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].identifier = apiKeyId;
        }
        if (process.env.DISABLE_CDP_ERROR_REPORTING !== "true") {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapClassWithErrorTracking(CdpClient);
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapClassWithErrorTracking(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$evm$2f$evm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmClient"]);
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapClassWithErrorTracking(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$solana$2f$solana$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SolanaClient"]);
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$analytics$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Analytics"].wrapClassWithErrorTracking(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$policies$2f$policies$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["PoliciesClient"]);
        }
        this.evm = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$evm$2f$evm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["EvmClient"]();
        this.solana = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$solana$2f$solana$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SolanaClient"]();
        this.policies = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$policies$2f$policies$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["PoliciesClient"]();
        this.endUser = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$coinbase$2b$cdp$2d$sdk$40$1$2e$38$2e$4_bu_740928bbf56d984df22d169dda7a39c5$2f$node_modules$2f40$coinbase$2f$cdp$2d$sdk$2f$_esm$2f$client$2f$end$2d$user$2f$endUser$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CDPEndUserClient"]();
    }
} //# sourceMappingURL=cdp.js.map
}),
];

//# sourceMappingURL=51a3e_%40coinbase_cdp-sdk__esm_8e2e92a1._.js.map