module.exports = [
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module exposes a list of named identifiers, shared across the parser generator
// and the parsers that are generated.
module.exports = {
    // Identifies the operator type. Used by the generator
    // to indicate operator types in the grammar object.
    // Used by the [parser](./parser.html) when interpreting the grammar object.
    /* the original ABNF operators */ ALT: 1 /* alternation */ ,
    CAT: 2 /* concatenation */ ,
    REP: 3 /* repetition */ ,
    RNM: 4 /* rule name */ ,
    TRG: 5 /* terminal range */ ,
    TBS: 6 /* terminal binary string, case sensitive */ ,
    TLS: 7 /* terminal literal string, case insensitive */ ,
    /* the super set, SABNF operators */ UDT: 11 /* user-defined terminal */ ,
    AND: 12 /* positive look ahead */ ,
    NOT: 13 /* negative look ahead */ ,
    BKR: 14 /* back reference to a previously matched rule name */ ,
    BKA: 15 /* positive look behind */ ,
    BKN: 16 /* negative look behind */ ,
    ABG: 17 /* anchor - begin of string */ ,
    AEN: 18 /* anchor - end of string */ ,
    // Used by the parser and the user's `RNM` and `UDT` callback functions.
    // Identifies the parser state as it traverses the parse tree nodes.
    // - *ACTIVE* - indicates the downward direction through the parse tree node.
    // - *MATCH* - indicates the upward direction and a phrase, of length \> 0, has been successfully matched
    // - *EMPTY* - indicates the upward direction and a phrase, of length = 0, has been successfully matched
    // - *NOMATCH* - indicates the upward direction and the parser failed to match any phrase at all
    ACTIVE: 100,
    MATCH: 101,
    EMPTY: 102,
    NOMATCH: 103,
    // Used by [`AST` translator](./ast.html) (semantic analysis) and the user's callback functions
    // to indicate the direction of flow through the `AST` nodes.
    // - *SEM_PRE* - indicates the downward (pre-branch) direction through the `AST` node.
    // - *SEM_POST* - indicates the upward (post-branch) direction through the `AST` node.
    SEM_PRE: 200,
    SEM_POST: 201,
    // Used by the user's callback functions to indicate to the `AST` translator (semantic analysis) how to proceed.
    // - *SEM_OK* - normal return value
    // - *SEM_SKIP* - if a callback function returns this value from the SEM_PRE state,
    // the translator will skip processing all `AST` nodes in the branch below the current node.
    // Ignored if returned from the SEM_POST state.
    SEM_OK: 300,
    SEM_SKIP: 301,
    // Used in attribute generation to distinguish the necessary attribute categories.
    // - *ATTR_N* - non-recursive
    // - *ATTR_R* - recursive
    // - *ATTR_MR* - belongs to a mutually-recursive set
    ATTR_N: 400,
    ATTR_R: 401,
    ATTR_MR: 402,
    // Look around values indicate whether the parser is in look ahead or look behind mode.
    // Used by the tracing facility to indicate the look around mode in the trace records display.
    // - *LOOKAROUND_NONE* - the parser is in normal parsing mode
    // - *LOOKAROUND_AHEAD* - the parse is in look-ahead mode, phrase matching for operator `AND(&)` or `NOT(!)`
    // - *LOOKAROUND_BEHIND* - the parse is in look-behind mode, phrase matching for operator `BKA(&&)` or `BKN(!!)`
    LOOKAROUND_NONE: 500,
    LOOKAROUND_AHEAD: 501,
    LOOKAROUND_BEHIND: 502,
    // Back reference rule mode indicators
    // - *BKR_MODE_UM* - the back reference is using universal mode
    // - *BKR_MODE_PM* - the back reference is using parent frame mode
    // - *BKR_MODE_CS* - the back reference is using case-sensitive phrase matching
    // - *BKR_MODE_CI* - the back reference is using case-insensitive phrase matching
    BKR_MODE_UM: 601,
    BKR_MODE_PM: 602,
    BKR_MODE_CS: 603,
    BKR_MODE_CI: 604
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/style.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

module.exports = {
    // Generated by apglib/style.js 
    CLASS_MONOSPACE: 'apg-mono',
    CLASS_ACTIVE: 'apg-active',
    CLASS_EMPTY: 'apg-empty',
    CLASS_MATCH: 'apg-match',
    CLASS_NOMATCH: 'apg-nomatch',
    CLASS_LOOKAHEAD: 'apg-lh-match',
    CLASS_LOOKBEHIND: 'apg-lb-match',
    CLASS_REMAINDER: 'apg-remainder',
    CLASS_CTRLCHAR: 'apg-ctrl-char',
    CLASS_LINEEND: 'apg-line-end',
    CLASS_ERROR: 'apg-error',
    CLASS_PHRASE: 'apg-phrase',
    CLASS_EMPTYPHRASE: 'apg-empty-phrase',
    CLASS_STATE: 'apg-state',
    CLASS_STATS: 'apg-stats',
    CLASS_TRACE: 'apg-trace',
    CLASS_GRAMMAR: 'apg-grammar',
    CLASS_RULES: 'apg-rules',
    CLASS_RULESLINK: 'apg-rules-link',
    CLASS_ATTRIBUTES: 'apg-attrs'
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-conv-api/transformers.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/* eslint-disable prefer-destructuring */ /* eslint-disable no-plusplus */ /* eslint-disable no-bitwise */ /*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module contains the actual encoding and decoding algorithms.
// Throws "RangeError" exceptions on characters or bytes out of range for the given encoding.
const { Buffer } = __turbopack_context__.r("[externals]/buffer [external] (buffer, cjs)");
/* decoding error codes */ const NON_SHORTEST = 0xfffffffc;
const TRAILING = 0xfffffffd;
const RANGE = 0xfffffffe;
const ILL_FORMED = 0xffffffff;
/* mask[n] = 2**n - 1, ie. mask[n] = n bits on. e.g. mask[6] = %b111111 */ const mask = [
    0,
    1,
    3,
    7,
    15,
    31,
    63,
    127,
    255,
    511,
    1023
];
/* ascii[n] = 'HH', where 0xHH = n, eg. ascii[254] = 'FE' */ const ascii = [
    '00',
    '01',
    '02',
    '03',
    '04',
    '05',
    '06',
    '07',
    '08',
    '09',
    '0A',
    '0B',
    '0C',
    '0D',
    '0E',
    '0F',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '1A',
    '1B',
    '1C',
    '1D',
    '1E',
    '1F',
    '20',
    '21',
    '22',
    '23',
    '24',
    '25',
    '26',
    '27',
    '28',
    '29',
    '2A',
    '2B',
    '2C',
    '2D',
    '2E',
    '2F',
    '30',
    '31',
    '32',
    '33',
    '34',
    '35',
    '36',
    '37',
    '38',
    '39',
    '3A',
    '3B',
    '3C',
    '3D',
    '3E',
    '3F',
    '40',
    '41',
    '42',
    '43',
    '44',
    '45',
    '46',
    '47',
    '48',
    '49',
    '4A',
    '4B',
    '4C',
    '4D',
    '4E',
    '4F',
    '50',
    '51',
    '52',
    '53',
    '54',
    '55',
    '56',
    '57',
    '58',
    '59',
    '5A',
    '5B',
    '5C',
    '5D',
    '5E',
    '5F',
    '60',
    '61',
    '62',
    '63',
    '64',
    '65',
    '66',
    '67',
    '68',
    '69',
    '6A',
    '6B',
    '6C',
    '6D',
    '6E',
    '6F',
    '70',
    '71',
    '72',
    '73',
    '74',
    '75',
    '76',
    '77',
    '78',
    '79',
    '7A',
    '7B',
    '7C',
    '7D',
    '7E',
    '7F',
    '80',
    '81',
    '82',
    '83',
    '84',
    '85',
    '86',
    '87',
    '88',
    '89',
    '8A',
    '8B',
    '8C',
    '8D',
    '8E',
    '8F',
    '90',
    '91',
    '92',
    '93',
    '94',
    '95',
    '96',
    '97',
    '98',
    '99',
    '9A',
    '9B',
    '9C',
    '9D',
    '9E',
    '9F',
    'A0',
    'A1',
    'A2',
    'A3',
    'A4',
    'A5',
    'A6',
    'A7',
    'A8',
    'A9',
    'AA',
    'AB',
    'AC',
    'AD',
    'AE',
    'AF',
    'B0',
    'B1',
    'B2',
    'B3',
    'B4',
    'B5',
    'B6',
    'B7',
    'B8',
    'B9',
    'BA',
    'BB',
    'BC',
    'BD',
    'BE',
    'BF',
    'C0',
    'C1',
    'C2',
    'C3',
    'C4',
    'C5',
    'C6',
    'C7',
    'C8',
    'C9',
    'CA',
    'CB',
    'CC',
    'CD',
    'CE',
    'CF',
    'D0',
    'D1',
    'D2',
    'D3',
    'D4',
    'D5',
    'D6',
    'D7',
    'D8',
    'D9',
    'DA',
    'DB',
    'DC',
    'DD',
    'DE',
    'DF',
    'E0',
    'E1',
    'E2',
    'E3',
    'E4',
    'E5',
    'E6',
    'E7',
    'E8',
    'E9',
    'EA',
    'EB',
    'EC',
    'ED',
    'EE',
    'EF',
    'F0',
    'F1',
    'F2',
    'F3',
    'F4',
    'F5',
    'F6',
    'F7',
    'F8',
    'F9',
    'FA',
    'FB',
    'FC',
    'FD',
    'FE',
    'FF'
];
/* vector of base 64 characters */ const base64chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='.split('');
/* vector of base 64 character codes */ const base64codes = [];
base64chars.forEach((char)=>{
    base64codes.push(char.charCodeAt(0));
});
// The UTF8 algorithms.
exports.utf8 = {
    encode (chars) {
        const bytes = [];
        chars.forEach((char)=>{
            if (char >= 0 && char <= 0x7f) {
                bytes.push(char);
            } else if (char <= 0x7ff) {
                bytes.push(0xc0 + (char >> 6 & mask[5]));
                bytes.push(0x80 + (char & mask[6]));
            } else if (char < 0xd800 || char > 0xdfff && char <= 0xffff) {
                bytes.push(0xe0 + (char >> 12 & mask[4]));
                bytes.push(0x80 + (char >> 6 & mask[6]));
                bytes.push(0x80 + (char & mask[6]));
            } else if (char >= 0x10000 && char <= 0x10ffff) {
                const u = char >> 16 & mask[5];
                bytes.push(0xf0 + (u >> 2));
                bytes.push(0x80 + ((u & mask[2]) << 4) + (char >> 12 & mask[4]));
                bytes.push(0x80 + (char >> 6 & mask[6]));
                bytes.push(0x80 + (char & mask[6]));
            } else {
                throw new RangeError(`utf8.encode: character out of range: char: ${char}`);
            }
        });
        return Buffer.from(bytes);
    },
    decode (buf, bom) {
        /* bytes functions return error for non-shortest forms & values out of range */ function bytes2(b1, b2) {
            /* U+0080..U+07FF */ /* 00000000 00000yyy yyxxxxxx | 110yyyyy 10xxxxxx */ if ((b2 & 0xc0) !== 0x80) {
                return TRAILING;
            }
            const x = ((b1 & mask[5]) << 6) + (b2 & mask[6]);
            if (x < 0x80) {
                return NON_SHORTEST;
            }
            return x;
        }
        function bytes3(b1, b2, b3) {
            /* U+0800..U+FFFF */ /* 00000000 zzzzyyyy yyxxxxxx | 1110zzzz 10yyyyyy 10xxxxxx */ if ((b3 & 0xc0) !== 0x80 || (b2 & 0xc0) !== 0x80) {
                return TRAILING;
            }
            const x = ((b1 & mask[4]) << 12) + ((b2 & mask[6]) << 6) + (b3 & mask[6]);
            if (x < 0x800) {
                return NON_SHORTEST;
            }
            if (x >= 0xd800 && x <= 0xdfff) {
                return RANGE;
            }
            return x;
        }
        function bytes4(b1, b2, b3, b4) {
            /* U+10000..U+10FFFF */ /* 000uuuuu zzzzyyyy yyxxxxxx | 11110uuu 10uuzzzz 10yyyyyy 10xxxxxx */ if ((b4 & 0xc0) !== 0x80 || (b3 & 0xc0) !== 0x80 || (b2 & 0xc0) !== 0x80) {
                return TRAILING;
            }
            const x = (((b1 & mask[3]) << 2) + (b2 >> 4 & mask[2]) << 16) + ((b2 & mask[4]) << 12) + ((b3 & mask[6]) << 6) + (b4 & mask[6]);
            if (x < 0x10000) {
                return NON_SHORTEST;
            }
            if (x > 0x10ffff) {
                return RANGE;
            }
            return x;
        }
        let c;
        let b1;
        let i1;
        let i2;
        let i3;
        let inc;
        const len = buf.length;
        let i = bom ? 3 : 0;
        const chars = [];
        while(i < len){
            b1 = buf[i];
            c = ILL_FORMED;
            const TRUE = true;
            while(TRUE){
                if (b1 >= 0 && b1 <= 0x7f) {
                    /* U+0000..U+007F 00..7F */ c = b1;
                    inc = 1;
                    break;
                }
                i1 = i + 1;
                if (i1 < len && b1 >= 0xc2 && b1 <= 0xdf) {
                    /* U+0080..U+07FF C2..DF 80..BF */ c = bytes2(b1, buf[i1]);
                    inc = 2;
                    break;
                }
                i2 = i + 2;
                if (i2 < len && b1 >= 0xe0 && b1 <= 0xef) {
                    /* U+0800..U+FFFF */ c = bytes3(b1, buf[i1], buf[i2]);
                    inc = 3;
                    break;
                }
                i3 = i + 3;
                if (i3 < len && b1 >= 0xf0 && b1 <= 0xf4) {
                    /* U+10000..U+10FFFF */ c = bytes4(b1, buf[i1], buf[i2], buf[i3]);
                    inc = 4;
                    break;
                }
                break;
            }
            if (c > 0x10ffff) {
                const at = `byte[${i}]`;
                if (c === ILL_FORMED) {
                    throw new RangeError(`utf8.decode: ill-formed UTF8 byte sequence found at: ${at}`);
                }
                if (c === TRAILING) {
                    throw new RangeError(`utf8.decode: illegal trailing byte found at: ${at}`);
                }
                if (c === RANGE) {
                    throw new RangeError(`utf8.decode: code point out of range found at: ${at}`);
                }
                if (c === NON_SHORTEST) {
                    throw new RangeError(`utf8.decode: non-shortest form found at: ${at}`);
                }
                throw new RangeError(`utf8.decode: unrecognized error found at: ${at}`);
            }
            chars.push(c);
            i += inc;
        }
        return chars;
    }
};
// The UTF16BE algorithms.
exports.utf16be = {
    encode (chars) {
        const bytes = [];
        let char;
        let h;
        let l;
        for(let i = 0; i < chars.length; i += 1){
            char = chars[i];
            if (char >= 0 && char <= 0xd7ff || char >= 0xe000 && char <= 0xffff) {
                bytes.push(char >> 8 & mask[8]);
                bytes.push(char & mask[8]);
            } else if (char >= 0x10000 && char <= 0x10ffff) {
                l = char - 0x10000;
                h = 0xd800 + (l >> 10);
                l = 0xdc00 + (l & mask[10]);
                bytes.push(h >> 8 & mask[8]);
                bytes.push(h & mask[8]);
                bytes.push(l >> 8 & mask[8]);
                bytes.push(l & mask[8]);
            } else {
                throw new RangeError(`utf16be.encode: UTF16BE value out of range: char[${i}]: ${char}`);
            }
        }
        return Buffer.from(bytes);
    },
    decode (buf, bom) {
        /* assumes caller has insured that buf is a Buffer of bytes */ if (buf.length % 2 > 0) {
            throw new RangeError(`utf16be.decode: data length must be even multiple of 2: length: ${buf.length}`);
        }
        const chars = [];
        const len = buf.length;
        let i = bom ? 2 : 0;
        let j = 0;
        let c;
        let inc;
        let i1;
        let i3;
        let high;
        let low;
        while(i < len){
            const TRUE = true;
            while(TRUE){
                i1 = i + 1;
                if (i1 < len) {
                    high = (buf[i] << 8) + buf[i1];
                    if (high < 0xd800 || high > 0xdfff) {
                        c = high;
                        inc = 2;
                        break;
                    }
                    i3 = i + 3;
                    if (i3 < len) {
                        low = (buf[i + 2] << 8) + buf[i3];
                        if (high <= 0xdbff && low >= 0xdc00 && low <= 0xdfff) {
                            c = 0x10000 + (high - 0xd800 << 10) + (low - 0xdc00);
                            inc = 4;
                            break;
                        }
                    }
                }
                /* if we fall through to here, it is an ill-formed sequence */ throw new RangeError(`utf16be.decode: ill-formed UTF16BE byte sequence found: byte[${i}]`);
            }
            chars[j++] = c;
            i += inc;
        }
        return chars;
    }
};
// The UTF16LE algorithms.
exports.utf16le = {
    encode (chars) {
        const bytes = [];
        let char;
        let h;
        let l;
        for(let i = 0; i < chars.length; i += 1){
            char = chars[i];
            if (char >= 0 && char <= 0xd7ff || char >= 0xe000 && char <= 0xffff) {
                bytes.push(char & mask[8]);
                bytes.push(char >> 8 & mask[8]);
            } else if (char >= 0x10000 && char <= 0x10ffff) {
                l = char - 0x10000;
                h = 0xd800 + (l >> 10);
                l = 0xdc00 + (l & mask[10]);
                bytes.push(h & mask[8]);
                bytes.push(h >> 8 & mask[8]);
                bytes.push(l & mask[8]);
                bytes.push(l >> 8 & mask[8]);
            } else {
                throw new RangeError(`utf16le.encode: UTF16LE value out of range: char[${i}]: ${char}`);
            }
        }
        return Buffer.from(bytes);
    },
    decode (buf, bom) {
        /* assumes caller has insured that buf is a Buffer of bytes */ if (buf.length % 2 > 0) {
            throw new RangeError(`utf16le.decode: data length must be even multiple of 2: length: ${buf.length}`);
        }
        const chars = [];
        const len = buf.length;
        let i = bom ? 2 : 0;
        let j = 0;
        let c;
        let inc;
        let i1;
        let i3;
        let high;
        let low;
        while(i < len){
            const TRUE = true;
            while(TRUE){
                i1 = i + 1;
                if (i1 < len) {
                    high = (buf[i1] << 8) + buf[i];
                    if (high < 0xd800 || high > 0xdfff) {
                        c = high;
                        inc = 2;
                        break;
                    }
                    i3 = i + 3;
                    if (i3 < len) {
                        low = (buf[i3] << 8) + buf[i + 2];
                        if (high <= 0xdbff && low >= 0xdc00 && low <= 0xdfff) {
                            c = 0x10000 + (high - 0xd800 << 10) + (low - 0xdc00);
                            inc = 4;
                            break;
                        }
                    }
                }
                /* if we fall through to here, it is an ill-formed sequence */ throw new RangeError(`utf16le.decode: ill-formed UTF16LE byte sequence found: byte[${i}]`);
            }
            chars[j++] = c;
            i += inc;
        }
        return chars;
    }
};
// The UTF32BE algorithms.
exports.utf32be = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length * 4);
        let i = 0;
        chars.forEach((char)=>{
            if (char >= 0xd800 && char <= 0xdfff || char > 0x10ffff) {
                throw new RangeError(`utf32be.encode: UTF32BE character code out of range: char[${i / 4}]: ${char}`);
            }
            buf[i++] = char >> 24 & mask[8];
            buf[i++] = char >> 16 & mask[8];
            buf[i++] = char >> 8 & mask[8];
            buf[i++] = char & mask[8];
        });
        return buf;
    },
    decode (buf, bom) {
        /* caller to insure buf is a Buffer of bytes */ if (buf.length % 4 > 0) {
            throw new RangeError(`utf32be.decode: UTF32BE byte length must be even multiple of 4: length: ${buf.length}`);
        }
        const chars = [];
        let i = bom ? 4 : 0;
        for(; i < buf.length; i += 4){
            const char = (buf[i] << 24) + (buf[i + 1] << 16) + (buf[i + 2] << 8) + buf[i + 3];
            if (char >= 0xd800 && char <= 0xdfff || char > 0x10ffff) {
                throw new RangeError(`utf32be.decode: UTF32BE character code out of range: char[${i / 4}]: ${char}`);
            }
            chars.push(char);
        }
        return chars;
    }
};
// The UTF32LE algorithms.
exports.utf32le = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length * 4);
        let i = 0;
        chars.forEach((char)=>{
            if (char >= 0xd800 && char <= 0xdfff || char > 0x10ffff) {
                throw new RangeError(`utf32le.encode: UTF32LE character code out of range: char[${i / 4}]: ${char}`);
            }
            buf[i++] = char & mask[8];
            buf[i++] = char >> 8 & mask[8];
            buf[i++] = char >> 16 & mask[8];
            buf[i++] = char >> 24 & mask[8];
        });
        return buf;
    },
    decode (buf, bom) {
        /* caller to insure buf is a Buffer of bytes */ if (buf.length % 4 > 0) {
            throw new RangeError(`utf32be.decode: UTF32LE byte length must be even multiple of 4: length: ${buf.length}`);
        }
        const chars = [];
        let i = bom ? 4 : 0;
        for(; i < buf.length; i += 4){
            const char = (buf[i + 3] << 24) + (buf[i + 2] << 16) + (buf[i + 1] << 8) + buf[i];
            if (char >= 0xd800 && char <= 0xdfff || char > 0x10ffff) {
                throw new RangeError(`utf32le.encode: UTF32LE character code out of range: char[${i / 4}]: ${char}`);
            }
            chars.push(char);
        }
        return chars;
    }
};
// The UINT7 algorithms. ASCII or 7-bit unsigned integers.
exports.uint7 = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length);
        for(let i = 0; i < chars.length; i += 1){
            if (chars[i] > 0x7f) {
                throw new RangeError(`uint7.encode: UINT7 character code out of range: char[${i}]: ${chars[i]}`);
            }
            buf[i] = chars[i];
        }
        return buf;
    },
    decode (buf) {
        const chars = [];
        for(let i = 0; i < buf.length; i += 1){
            if (buf[i] > 0x7f) {
                throw new RangeError(`uint7.decode: UINT7 character code out of range: byte[${i}]: ${buf[i]}`);
            }
            chars[i] = buf[i];
        }
        return chars;
    }
};
// The UINT8 algorithms. BINARY, Latin 1 or 8-bit unsigned integers.
exports.uint8 = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length);
        for(let i = 0; i < chars.length; i += 1){
            if (chars[i] > 0xff) {
                throw new RangeError(`uint8.encode: UINT8 character code out of range: char[${i}]: ${chars[i]}`);
            }
            buf[i] = chars[i];
        }
        return buf;
    },
    decode (buf) {
        const chars = [];
        for(let i = 0; i < buf.length; i += 1){
            chars[i] = buf[i];
        }
        return chars;
    }
};
// The UINT16BE algorithms. Big-endian 16-bit unsigned integers.
exports.uint16be = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length * 2);
        let i = 0;
        chars.forEach((char)=>{
            if (char > 0xffff) {
                throw new RangeError(`uint16be.encode: UINT16BE character code out of range: char[${i / 2}]: ${char}`);
            }
            buf[i++] = char >> 8 & mask[8];
            buf[i++] = char & mask[8];
        });
        return buf;
    },
    decode (buf) {
        if (buf.length % 2 > 0) {
            throw new RangeError(`uint16be.decode: UINT16BE byte length must be even multiple of 2: length: ${buf.length}`);
        }
        const chars = [];
        for(let i = 0; i < buf.length; i += 2){
            chars.push((buf[i] << 8) + buf[i + 1]);
        }
        return chars;
    }
};
// The UINT16LE algorithms. Little-endian 16-bit unsigned integers.
exports.uint16le = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length * 2);
        let i = 0;
        chars.forEach((char)=>{
            if (char > 0xffff) {
                throw new RangeError(`uint16le.encode: UINT16LE character code out of range: char[${i / 2}]: ${char}`);
            }
            buf[i++] = char & mask[8];
            buf[i++] = char >> 8 & mask[8];
        });
        return buf;
    },
    decode (buf) {
        if (buf.length % 2 > 0) {
            throw new RangeError(`uint16le.decode: UINT16LE byte length must be even multiple of 2: length: ${buf.length}`);
        }
        const chars = [];
        for(let i = 0; i < buf.length; i += 2){
            chars.push((buf[i + 1] << 8) + buf[i]);
        }
        return chars;
    }
};
// The UINT32BE algorithms. Big-endian 32-bit unsigned integers.
exports.uint32be = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length * 4);
        let i = 0;
        chars.forEach((char)=>{
            buf[i++] = char >> 24 & mask[8];
            buf[i++] = char >> 16 & mask[8];
            buf[i++] = char >> 8 & mask[8];
            buf[i++] = char & mask[8];
        });
        return buf;
    },
    decode (buf) {
        if (buf.length % 4 > 0) {
            throw new RangeError(`uint32be.decode: UINT32BE byte length must be even multiple of 4: length: ${buf.length}`);
        }
        const chars = [];
        for(let i = 0; i < buf.length; i += 4){
            chars.push((buf[i] << 24) + (buf[i + 1] << 16) + (buf[i + 2] << 8) + buf[i + 3]);
        }
        return chars;
    }
};
// The UINT32LE algorithms. Little-endian 32-bit unsigned integers.
exports.uint32le = {
    encode (chars) {
        const buf = Buffer.alloc(chars.length * 4);
        let i = 0;
        chars.forEach((char)=>{
            buf[i++] = char & mask[8];
            buf[i++] = char >> 8 & mask[8];
            buf[i++] = char >> 16 & mask[8];
            buf[i++] = char >> 24 & mask[8];
        });
        return buf;
    },
    decode (buf) {
        /* caller to insure buf is a Buffer of bytes */ if (buf.length % 4 > 0) {
            throw new RangeError(`uint32le.decode: UINT32LE byte length must be even multiple of 4: length: ${buf.length}`);
        }
        const chars = [];
        for(let i = 0; i < buf.length; i += 4){
            chars.push((buf[i + 3] << 24) + (buf[i + 2] << 16) + (buf[i + 1] << 8) + buf[i]);
        }
        return chars;
    }
};
// The STRING algorithms. Converts JavaScript strings to Array of 32-bit integers and vice versa.
// Uses the node.js Buffer's native "utf16le" capabilites.
exports.string = {
    encode (chars) {
        return exports.utf16le.encode(chars).toString('utf16le');
    },
    decode (str) {
        return exports.utf16le.decode(Buffer.from(str, 'utf16le'), 0);
    }
};
// The ESCAPED algorithms.
// Note that ESCAPED format contains only ASCII characters.
// The characters are always in the form of a Buffer of bytes.
exports.escaped = {
    // Encodes an Array of 32-bit integers into ESCAPED format.
    encode (chars) {
        const bytes = [];
        for(let i = 0; i < chars.length; i += 1){
            const char = chars[i];
            if (char === 96) {
                bytes.push(char);
                bytes.push(char);
            } else if (char === 10) {
                bytes.push(char);
            } else if (char >= 32 && char <= 126) {
                bytes.push(char);
            } else {
                let str = '';
                if (char >= 0 && char <= 31) {
                    str += `\`x${ascii[char]}`;
                } else if (char >= 127 && char <= 255) {
                    str += `\`x${ascii[char]}`;
                } else if (char >= 0x100 && char <= 0xffff) {
                    str += `\`u${ascii[char >> 8 & mask[8]]}${ascii[char & mask[8]]}`;
                } else if (char >= 0x10000 && char <= 0xffffffff) {
                    str += '`u{';
                    const digit = char >> 24 & mask[8];
                    if (digit > 0) {
                        str += ascii[digit];
                    }
                    str += `${ascii[char >> 16 & mask[8]] + ascii[char >> 8 & mask[8]] + ascii[char & mask[8]]}}`;
                } else {
                    throw new Error('escape.encode(char): char > 0xffffffff not allowed');
                }
                const buf = Buffer.from(str);
                buf.forEach((b)=>{
                    bytes.push(b);
                });
            }
        }
        return Buffer.from(bytes);
    },
    // Decodes ESCAPED format from a Buffer of bytes to an Array of 32-bit integers.
    decode (buf) {
        function isHex(hex) {
            if (hex >= 48 && hex <= 57 || hex >= 65 && hex <= 70 || hex >= 97 && hex <= 102) {
                return true;
            }
            return false;
        }
        function getx(i, len, bufArg) {
            const ret = {
                char: null,
                nexti: i + 2,
                error: true
            };
            if (i + 1 < len) {
                if (isHex(bufArg[i]) && isHex(bufArg[i + 1])) {
                    const str = String.fromCodePoint(bufArg[i], bufArg[i + 1]);
                    ret.char = parseInt(str, 16);
                    if (!Number.isNaN(ret.char)) {
                        ret.error = false;
                    }
                }
            }
            return ret;
        }
        function getu(i, len, bufArg) {
            const ret = {
                char: null,
                nexti: i + 4,
                error: true
            };
            if (i + 3 < len) {
                if (isHex(bufArg[i]) && isHex(bufArg[i + 1]) && isHex(bufArg[i + 2]) && isHex(bufArg[i + 3])) {
                    const str = String.fromCodePoint(bufArg[i], bufArg[i + 1], bufArg[i + 2], bufArg[i + 3]);
                    ret.char = parseInt(str, 16);
                    if (!Number.isNaN(ret.char)) {
                        ret.error = false;
                    }
                }
            }
            return ret;
        }
        function getU(i, len, bufArg) {
            const ret = {
                char: null,
                nexti: i + 4,
                error: true
            };
            let str = '';
            while(i < len && isHex(bufArg[i])){
                str += String.fromCodePoint(bufArg[i]);
                // eslint-disable-next-line no-param-reassign
                i += 1;
            }
            ret.char = parseInt(str, 16);
            if (bufArg[i] === 125 && !Number.isNaN(ret.char)) {
                ret.error = false;
            }
            ret.nexti = i + 1;
            return ret;
        }
        const chars = [];
        const len = buf.length;
        let i1;
        let ret;
        let error;
        let i = 0;
        while(i < len){
            const TRUE = true;
            while(TRUE){
                error = true;
                if (buf[i] !== 96) {
                    /* unescaped character */ chars.push(buf[i]);
                    i += 1;
                    error = false;
                    break;
                }
                i1 = i + 1;
                if (i1 >= len) {
                    break;
                }
                if (buf[i1] === 96) {
                    /* escaped grave accent */ chars.push(96);
                    i += 2;
                    error = false;
                    break;
                }
                if (buf[i1] === 120) {
                    ret = getx(i1 + 1, len, buf);
                    if (ret.error) {
                        break;
                    }
                    /* escaped hex */ chars.push(ret.char);
                    i = ret.nexti;
                    error = false;
                    break;
                }
                if (buf[i1] === 117) {
                    if (buf[i1 + 1] === 123) {
                        ret = getU(i1 + 2, len, buf);
                        if (ret.error) {
                            break;
                        }
                        /* escaped utf-32 */ chars.push(ret.char);
                        i = ret.nexti;
                        error = false;
                        break;
                    }
                    ret = getu(i1 + 1, len, buf);
                    if (ret.error) {
                        break;
                    }
                    /* escaped utf-16 */ chars.push(ret.char);
                    i = ret.nexti;
                    error = false;
                    break;
                }
                break;
            }
            if (error) {
                throw new Error(`escaped.decode: ill-formed escape sequence at buf[${i}]`);
            }
        }
        return chars;
    }
};
// The line end conversion algorigthms.
const CR = 13;
const LF = 10;
exports.lineEnds = {
    crlf (chars) {
        const lfchars = [];
        let i = 0;
        while(i < chars.length){
            switch(chars[i]){
                case CR:
                    if (i + 1 < chars.length && chars[i + 1] === LF) {
                        i += 2;
                    } else {
                        i += 1;
                    }
                    lfchars.push(CR);
                    lfchars.push(LF);
                    break;
                case LF:
                    lfchars.push(CR);
                    lfchars.push(LF);
                    i += 1;
                    break;
                default:
                    lfchars.push(chars[i]);
                    i += 1;
                    break;
            }
        }
        if (lfchars.length > 0 && lfchars[lfchars.length - 1] !== LF) {
            lfchars.push(CR);
            lfchars.push(LF);
        }
        return lfchars;
    },
    lf (chars) {
        const lfchars = [];
        let i = 0;
        while(i < chars.length){
            switch(chars[i]){
                case CR:
                    if (i + 1 < chars.length && chars[i + 1] === LF) {
                        i += 2;
                    } else {
                        i += 1;
                    }
                    lfchars.push(LF);
                    break;
                case LF:
                    lfchars.push(LF);
                    i += 1;
                    break;
                default:
                    lfchars.push(chars[i]);
                    i += 1;
                    break;
            }
        }
        if (lfchars.length > 0 && lfchars[lfchars.length - 1] !== LF) {
            lfchars.push(LF);
        }
        return lfchars;
    }
};
// The base 64 algorithms.
exports.base64 = {
    encode (buf) {
        if (buf.length === 0) {
            return Buffer.alloc(0);
        }
        let i;
        let j;
        let n;
        let tail = buf.length % 3;
        tail = tail > 0 ? 3 - tail : 0;
        let units = (buf.length + tail) / 3;
        const base64 = Buffer.alloc(units * 4);
        if (tail > 0) {
            units -= 1;
        }
        i = 0;
        j = 0;
        for(let u = 0; u < units; u += 1){
            n = buf[i++] << 16;
            n += buf[i++] << 8;
            n += buf[i++];
            base64[j++] = base64codes[n >> 18 & mask[6]];
            base64[j++] = base64codes[n >> 12 & mask[6]];
            base64[j++] = base64codes[n >> 6 & mask[6]];
            base64[j++] = base64codes[n & mask[6]];
        }
        if (tail === 0) {
            return base64;
        }
        if (tail === 1) {
            n = buf[i++] << 16;
            n += buf[i] << 8;
            base64[j++] = base64codes[n >> 18 & mask[6]];
            base64[j++] = base64codes[n >> 12 & mask[6]];
            base64[j++] = base64codes[n >> 6 & mask[6]];
            base64[j] = base64codes[64];
            return base64;
        }
        if (tail === 2) {
            n = buf[i] << 16;
            base64[j++] = base64codes[n >> 18 & mask[6]];
            base64[j++] = base64codes[n >> 12 & mask[6]];
            base64[j++] = base64codes[64];
            base64[j] = base64codes[64];
            return base64;
        }
        return undefined;
    },
    decode (codes) {
        /* remove white space and ctrl characters, validate & translate characters */ function validate(buf) {
            const chars = [];
            let tail = 0;
            for(let i = 0; i < buf.length; i += 1){
                const char = buf[i];
                const TRUE = true;
                while(TRUE){
                    if (char === 32 || char === 9 || char === 10 || char === 13) {
                        break;
                    }
                    if (char >= 65 && char <= 90) {
                        chars.push(char - 65);
                        break;
                    }
                    if (char >= 97 && char <= 122) {
                        chars.push(char - 71);
                        break;
                    }
                    if (char >= 48 && char <= 57) {
                        chars.push(char + 4);
                        break;
                    }
                    if (char === 43) {
                        chars.push(62);
                        break;
                    }
                    if (char === 47) {
                        chars.push(63);
                        break;
                    }
                    if (char === 61) {
                        chars.push(64);
                        tail += 1;
                        break;
                    }
                    /* invalid character */ throw new RangeError(`base64.decode: invalid character buf[${i}]: ${char}`);
                }
            }
            /* validate length */ if (chars.length % 4 > 0) {
                throw new RangeError(`base64.decode: string length not integral multiple of 4: ${chars.length}`);
            }
            /* validate tail */ switch(tail){
                case 0:
                    break;
                case 1:
                    if (chars[chars.length - 1] !== 64) {
                        throw new RangeError('base64.decode: one tail character found: not last character');
                    }
                    break;
                case 2:
                    if (chars[chars.length - 1] !== 64 || chars[chars.length - 2] !== 64) {
                        throw new RangeError('base64.decode: two tail characters found: not last characters');
                    }
                    break;
                default:
                    throw new RangeError(`base64.decode: more than two tail characters found: ${tail}`);
            }
            return {
                tail,
                buf: Buffer.from(chars)
            };
        }
        if (codes.length === 0) {
            return Buffer.alloc(0);
        }
        const val = validate(codes);
        const { tail } = val;
        const base64 = val.buf;
        let i;
        let j;
        let n;
        let units = base64.length / 4;
        const buf = Buffer.alloc(units * 3 - tail);
        if (tail > 0) {
            units -= 1;
        }
        j = 0;
        i = 0;
        for(let u = 0; u < units; u += 1){
            n = base64[i++] << 18;
            n += base64[i++] << 12;
            n += base64[i++] << 6;
            n += base64[i++];
            buf[j++] = n >> 16 & mask[8];
            buf[j++] = n >> 8 & mask[8];
            buf[j++] = n & mask[8];
        }
        if (tail === 1) {
            n = base64[i++] << 18;
            n += base64[i++] << 12;
            n += base64[i] << 6;
            buf[j++] = n >> 16 & mask[8];
            buf[j] = n >> 8 & mask[8];
        }
        if (tail === 2) {
            n = base64[i++] << 18;
            n += base64[i++] << 12;
            buf[j] = n >> 16 & mask[8];
        }
        return buf;
    },
    // Converts a base 64 Buffer of bytes to a JavaScript string with line breaks.
    toString (buf) {
        if (buf.length % 4 > 0) {
            throw new RangeError(`base64.toString: input buffer length not multiple of 4: ${buf.length}`);
        }
        let str = '';
        let lineLen = 0;
        function buildLine(c1, c2, c3, c4) {
            switch(lineLen){
                case 76:
                    str += `\r\n${c1}${c2}${c3}${c4}`;
                    lineLen = 4;
                    break;
                case 75:
                    str += `${c1}\r\n${c2}${c3}${c4}`;
                    lineLen = 3;
                    break;
                case 74:
                    str += `${c1 + c2}\r\n${c3}${c4}`;
                    lineLen = 2;
                    break;
                case 73:
                    str += `${c1 + c2 + c3}\r\n${c4}`;
                    lineLen = 1;
                    break;
                default:
                    str += c1 + c2 + c3 + c4;
                    lineLen += 4;
                    break;
            }
        }
        function validate(c) {
            if (c >= 65 && c <= 90) {
                return true;
            }
            if (c >= 97 && c <= 122) {
                return true;
            }
            if (c >= 48 && c <= 57) {
                return true;
            }
            if (c === 43) {
                return true;
            }
            if (c === 47) {
                return true;
            }
            if (c === 61) {
                return true;
            }
            return false;
        }
        for(let i = 0; i < buf.length; i += 4){
            for(let j = i; j < i + 4; j += 1){
                if (!validate(buf[j])) {
                    throw new RangeError(`base64.toString: buf[${j}]: ${buf[j]} : not valid base64 character code`);
                }
            }
            buildLine(String.fromCharCode(buf[i]), String.fromCharCode(buf[i + 1]), String.fromCharCode(buf[i + 2]), String.fromCharCode(buf[i + 3]));
        }
        return str;
    }
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-conv-api/converter.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module exposes the public encoding, decoding and conversion functions.
// Its private functions provide the disassembling and interpetation of the source and destination encoding types.
// In the case of Unicode encodings, private functions determine the presence of Byte Order Marks (BOMs), if any.
//
// Throws "TypeError" exceptions on input errors.
//
const { Buffer } = __turbopack_context__.r("[externals]/buffer [external] (buffer, cjs)");
const trans = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-conv-api/transformers.js [app-ssr] (ecmascript)");
/* types */ const UTF8 = 'UTF8';
const UTF16 = 'UTF16';
const UTF16BE = 'UTF16BE';
const UTF16LE = 'UTF16LE';
const UTF32 = 'UTF32';
const UTF32BE = 'UTF32BE';
const UTF32LE = 'UTF32LE';
const UINT7 = 'UINT7';
const ASCII = 'ASCII';
const BINARY = 'BINARY';
const UINT8 = 'UINT8';
const UINT16 = 'UINT16';
const UINT16LE = 'UINT16LE';
const UINT16BE = 'UINT16BE';
const UINT32 = 'UINT32';
const UINT32LE = 'UINT32LE';
const UINT32BE = 'UINT32BE';
const ESCAPED = 'ESCAPED';
const STRING = 'STRING';
/* private functions */ // Find the UTF8 BOM, if any.
const bom8 = function bom8(src) {
    src.type = UTF8;
    const buf = src.data;
    src.bom = 0;
    if (buf.length >= 3) {
        if (buf[0] === 0xef && buf[1] === 0xbb && buf[2] === 0xbf) {
            src.bom = 3;
        }
    }
};
// Find the UTF16 BOM, if any, and determine the UTF16 type.
// Defaults to UTF16BE.
// Throws TypeError exception if BOM does not match the specified type.
const bom16 = function bom16(src) {
    const buf = src.data;
    src.bom = 0;
    switch(src.type){
        case UTF16:
            src.type = UTF16BE;
            if (buf.length >= 2) {
                if (buf[0] === 0xfe && buf[1] === 0xff) {
                    src.bom = 2;
                } else if (buf[0] === 0xff && buf[1] === 0xfe) {
                    src.type = UTF16LE;
                    src.bom = 2;
                }
            }
            break;
        case UTF16BE:
            src.type = UTF16BE;
            if (buf.length >= 2) {
                if (buf[0] === 0xfe && buf[1] === 0xff) {
                    src.bom = 2;
                } else if (buf[0] === 0xff && buf[1] === 0xfe) {
                    throw new TypeError(`src type: "${UTF16BE}" specified but BOM is for "${UTF16LE}"`);
                }
            }
            break;
        case UTF16LE:
            src.type = UTF16LE;
            if (buf.length >= 0) {
                if (buf[0] === 0xfe && buf[1] === 0xff) {
                    throw new TypeError(`src type: "${UTF16LE}" specified but BOM is for "${UTF16BE}"`);
                } else if (buf[0] === 0xff && buf[1] === 0xfe) {
                    src.bom = 2;
                }
            }
            break;
        default:
            throw new TypeError(`UTF16 BOM: src type "${src.type}" unrecognized`);
    }
};
// Find the UTF32 BOM, if any, and determine the UTF32 type.
// Defaults to UTF32BE.
// Throws exception if BOM does not match the specified type.
const bom32 = function bom32(src) {
    const buf = src.data;
    src.bom = 0;
    switch(src.type){
        case UTF32:
            src.type = UTF32BE;
            if (buf.length >= 4) {
                if (buf[0] === 0 && buf[1] === 0 && buf[2] === 0xfe && buf[3] === 0xff) {
                    src.bom = 4;
                }
                if (buf[0] === 0xff && buf[1] === 0xfe && buf[2] === 0 && buf[3] === 0) {
                    src.type = UTF32LE;
                    src.bom = 4;
                }
            }
            break;
        case UTF32BE:
            src.type = UTF32BE;
            if (buf.length >= 4) {
                if (buf[0] === 0 && buf[1] === 0 && buf[2] === 0xfe && buf[3] === 0xff) {
                    src.bom = 4;
                }
                if (buf[0] === 0xff && buf[1] === 0xfe && buf[2] === 0 && buf[3] === 0) {
                    throw new TypeError(`src type: ${UTF32BE} specified but BOM is for ${UTF32LE}"`);
                }
            }
            break;
        case UTF32LE:
            src.type = UTF32LE;
            if (buf.length >= 4) {
                if (buf[0] === 0 && buf[1] === 0 && buf[2] === 0xfe && buf[3] === 0xff) {
                    throw new TypeError(`src type: "${UTF32LE}" specified but BOM is for "${UTF32BE}"`);
                }
                if (buf[0] === 0xff && buf[1] === 0xfe && buf[2] === 0 && buf[3] === 0) {
                    src.bom = 4;
                }
            }
            break;
        default:
            throw new TypeError(`UTF32 BOM: src type "${src.type}" unrecognized`);
    }
};
// Validates the source encoding type and matching data.
// If the BASE64: prefix is present, the base 64 decoding is done here as the initial step.
// - For type STRING, data must be a JavaScript string.
// - For type BASE64:*, data may be a string or Buffer.
// - For all other types, data must be a Buffer.
// - The BASE64: prefix is not allowed for type STRING.
const validateSrc = function validateSrc(type, data) {
    function getType(typeArg) {
        const ret = {
            type: '',
            base64: false
        };
        const rx = /^(base64:)?([a-zA-Z0-9]+)$/i;
        const result = rx.exec(typeArg);
        if (result) {
            if (result[2]) {
                ret.type = result[2].toUpperCase();
            }
            if (result[1]) {
                ret.base64 = true;
            }
        }
        return ret;
    }
    const ret = getType(type.toUpperCase());
    if (ret.base64) {
        /* handle base 64 */ if (ret.type === STRING) {
            throw new TypeError(`type: "${type} "BASE64:" prefix not allowed with type ${STRING}`);
        }
        if (Buffer.isBuffer(data)) {
            ret.data = trans.base64.decode(data);
        } else if (typeof data === 'string') {
            const buf = Buffer.from(data, 'ascii');
            ret.data = trans.base64.decode(buf);
        } else {
            throw new TypeError(`type: "${type} unrecognized data type: typeof(data): ${typeof data}`);
        }
    } else {
        ret.data = data;
    }
    switch(ret.type){
        case UTF8:
            bom8(ret);
            break;
        case UTF16:
        case UTF16BE:
        case UTF16LE:
            bom16(ret);
            break;
        case UTF32:
        case UTF32BE:
        case UTF32LE:
            bom32(ret);
            break;
        case UINT16:
            ret.type = UINT16BE;
            break;
        case UINT32:
            ret.type = UINT32BE;
            break;
        case ASCII:
            ret.type = UINT7;
            break;
        case BINARY:
            ret.type = UINT8;
            break;
        case UINT7:
        case UINT8:
        case UINT16LE:
        case UINT16BE:
        case UINT32LE:
        case UINT32BE:
        case STRING:
        case ESCAPED:
            break;
        default:
            throw new TypeError(`type: "${type}" not recognized`);
    }
    if (ret.type === STRING) {
        if (typeof ret.data !== 'string') {
            throw new TypeError(`type: "${type}" but data is not a string`);
        }
    } else if (!Buffer.isBuffer(ret.data)) {
        throw new TypeError(`type: "${type}" but data is not a Buffer`);
    }
    return ret;
};
// Disassembles and validates the destination type.
// `chars` must be an Array of integers.
// The :BASE64 suffix is not allowed for type STRING.
const validateDst = function validateDst(type, chars) {
    function getType(typeArg) {
        let fix;
        let rem;
        const ret = {
            crlf: false,
            lf: false,
            base64: false,
            type: ''
        };
        /* prefix, if any */ const TRUE = true;
        while(TRUE){
            rem = typeArg;
            fix = typeArg.slice(0, 5);
            if (fix === 'CRLF:') {
                ret.crlf = true;
                rem = typeArg.slice(5);
                break;
            }
            fix = typeArg.slice(0, 3);
            if (fix === 'LF:') {
                ret.lf = true;
                rem = typeArg.slice(3);
                break;
            }
            break;
        }
        /* suffix, if any */ fix = rem.split(':');
        if (fix.length === 1) {
            // eslint-disable-next-line prefer-destructuring
            ret.type = fix[0];
        } else if (fix.length === 2 && fix[1] === 'BASE64') {
            ret.base64 = true;
            // eslint-disable-next-line prefer-destructuring
            ret.type = fix[0];
        }
        return ret;
    }
    if (!Array.isArray(chars)) {
        throw new TypeError(`dst chars: not array: "${typeof chars}`);
    }
    if (typeof type !== 'string') {
        throw new TypeError(`dst type: not string: "${typeof type}`);
    }
    const ret = getType(type.toUpperCase());
    switch(ret.type){
        case UTF8:
        case UTF16BE:
        case UTF16LE:
        case UTF32BE:
        case UTF32LE:
        case UINT7:
        case UINT8:
        case UINT16LE:
        case UINT16BE:
        case UINT32LE:
        case UINT32BE:
        case ESCAPED:
            break;
        case STRING:
            if (ret.base64) {
                throw new TypeError(`":BASE64" suffix not allowed with type ${STRING}`);
            }
            break;
        case ASCII:
            ret.type = UINT7;
            break;
        case BINARY:
            ret.type = UINT8;
            break;
        case UTF16:
            ret.type = UTF16BE;
            break;
        case UTF32:
            ret.type = UTF32BE;
            break;
        case UINT16:
            ret.type = UINT16BE;
            break;
        case UINT32:
            ret.type = UINT32BE;
            break;
        default:
            throw new TypeError(`dst type unrecognized: "${type}" : must have form [crlf:|lf:]type[:base64]`);
    }
    return ret;
};
// Select and call the requested encoding function.
const encode = function encode(type, chars) {
    switch(type){
        case UTF8:
            return trans.utf8.encode(chars);
        case UTF16BE:
            return trans.utf16be.encode(chars);
        case UTF16LE:
            return trans.utf16le.encode(chars);
        case UTF32BE:
            return trans.utf32be.encode(chars);
        case UTF32LE:
            return trans.utf32le.encode(chars);
        case UINT7:
            return trans.uint7.encode(chars);
        case UINT8:
            return trans.uint8.encode(chars);
        case UINT16BE:
            return trans.uint16be.encode(chars);
        case UINT16LE:
            return trans.uint16le.encode(chars);
        case UINT32BE:
            return trans.uint32be.encode(chars);
        case UINT32LE:
            return trans.uint32le.encode(chars);
        case STRING:
            return trans.string.encode(chars);
        case ESCAPED:
            return trans.escaped.encode(chars);
        default:
            throw new TypeError(`encode type "${type}" not recognized`);
    }
};
// Select and call the requested decoding function.
// `src` contains BOM information as well as the source type and data.
const decode = function decode(src) {
    switch(src.type){
        case UTF8:
            return trans.utf8.decode(src.data, src.bom);
        case UTF16LE:
            return trans.utf16le.decode(src.data, src.bom);
        case UTF16BE:
            return trans.utf16be.decode(src.data, src.bom);
        case UTF32BE:
            return trans.utf32be.decode(src.data, src.bom);
        case UTF32LE:
            return trans.utf32le.decode(src.data, src.bom);
        case UINT7:
            return trans.uint7.decode(src.data);
        case UINT8:
            return trans.uint8.decode(src.data);
        case UINT16BE:
            return trans.uint16be.decode(src.data);
        case UINT16LE:
            return trans.uint16le.decode(src.data);
        case UINT32BE:
            return trans.uint32be.decode(src.data);
        case UINT32LE:
            return trans.uint32le.decode(src.data);
        case STRING:
            return trans.string.decode(src.data);
        case ESCAPED:
            return trans.escaped.decode(src.data);
        default:
            throw new TypeError(`decode type "${src.type}" not recognized`);
    }
};
// The public decoding function. Returns an array of integers.
exports.decode = function exportsDecode(type, data) {
    const src = validateSrc(type, data);
    return decode(src);
};
// The public encoding function. Returns a Buffer-typed byte array.
exports.encode = function exportsEncode(type, chars) {
    let c;
    let buf;
    const dst = validateDst(type, chars);
    if (dst.crlf) {
        /* prefix with CRLF line end conversion, don't contaminate caller's chars array */ c = trans.lineEnds.crlf(chars);
        buf = encode(dst.type, c);
    } else if (dst.lf) {
        /* prefix with LF line end conversion, don't contaminate caller's chars array */ c = trans.lineEnds.lf(chars);
        buf = encode(dst.type, c);
    } else {
        buf = encode(dst.type, chars);
    }
    if (dst.base64) {
        /* post base 64 encoding */ buf = trans.base64.encode(buf);
    }
    return buf;
};
// Converts data of type `srcType` to data of type `dstType`.
// `srcData` may be a JavaScript String, or node.js Buffer, depending on the corresponding type.
const convert = function convert(srcType, srcData, dstType) {
    return exports.encode(dstType, exports.decode(srcType, srcData));
};
exports.convert = convert;
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/emitcss.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

// This module has been developed programmatically in the `apg-lib` build process.
// It is used to build web pages programatically on the fly without the need for <script> or <style> tags.
module.exports = function emittcss() {
    return '/* This file automatically generated by jsonToless() and LESS. */\n.apg-mono {\n  font-family: monospace;\n}\n.apg-active {\n  font-weight: bold;\n  color: #000000;\n}\n.apg-match {\n  font-weight: bold;\n  color: #264BFF;\n}\n.apg-empty {\n  font-weight: bold;\n  color: #0fbd0f;\n}\n.apg-nomatch {\n  font-weight: bold;\n  color: #FF4000;\n}\n.apg-lh-match {\n  font-weight: bold;\n  color: #1A97BA;\n}\n.apg-lb-match {\n  font-weight: bold;\n  color: #5F1687;\n}\n.apg-remainder {\n  font-weight: bold;\n  color: #999999;\n}\n.apg-ctrl-char {\n  font-weight: bolder;\n  font-style: italic;\n  font-size: 0.6em;\n}\n.apg-line-end {\n  font-weight: bold;\n  color: #000000;\n}\n.apg-error {\n  font-weight: bold;\n  color: #FF4000;\n}\n.apg-phrase {\n  color: #000000;\n  background-color: #8caae6;\n}\n.apg-empty-phrase {\n  color: #0fbd0f;\n}\ntable.apg-state {\n  font-family: monospace;\n  margin-top: 5px;\n  font-size: 11px;\n  line-height: 130%;\n  text-align: left;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-state th,\ntable.apg-state td {\n  text-align: left;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-state th:nth-last-child(2),\ntable.apg-state td:nth-last-child(2) {\n  text-align: right;\n}\ntable.apg-state caption {\n  font-size: 125%;\n  line-height: 130%;\n  font-weight: bold;\n  text-align: left;\n}\ntable.apg-stats {\n  font-family: monospace;\n  margin-top: 5px;\n  font-size: 11px;\n  line-height: 130%;\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-stats th,\ntable.apg-stats td {\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-stats caption {\n  font-size: 125%;\n  line-height: 130%;\n  font-weight: bold;\n  text-align: left;\n}\ntable.apg-trace {\n  font-family: monospace;\n  margin-top: 5px;\n  font-size: 11px;\n  line-height: 130%;\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-trace caption {\n  font-size: 125%;\n  line-height: 130%;\n  font-weight: bold;\n  text-align: left;\n}\ntable.apg-trace th,\ntable.apg-trace td {\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-trace th:last-child,\ntable.apg-trace th:nth-last-child(2),\ntable.apg-trace td:last-child,\ntable.apg-trace td:nth-last-child(2) {\n  text-align: left;\n}\ntable.apg-grammar {\n  font-family: monospace;\n  margin-top: 5px;\n  font-size: 11px;\n  line-height: 130%;\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-grammar caption {\n  font-size: 125%;\n  line-height: 130%;\n  font-weight: bold;\n  text-align: left;\n}\ntable.apg-grammar th,\ntable.apg-grammar td {\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-grammar th:last-child,\ntable.apg-grammar td:last-child {\n  text-align: left;\n}\ntable.apg-rules {\n  font-family: monospace;\n  margin-top: 5px;\n  font-size: 11px;\n  line-height: 130%;\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-rules caption {\n  font-size: 125%;\n  line-height: 130%;\n  font-weight: bold;\n  text-align: left;\n}\ntable.apg-rules th,\ntable.apg-rules td {\n  text-align: right;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-rules a {\n  color: #003399 !important;\n}\ntable.apg-rules a:hover {\n  color: #8caae6 !important;\n}\ntable.apg-attrs {\n  font-family: monospace;\n  margin-top: 5px;\n  font-size: 11px;\n  line-height: 130%;\n  text-align: center;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-attrs caption {\n  font-size: 125%;\n  line-height: 130%;\n  font-weight: bold;\n  text-align: left;\n}\ntable.apg-attrs th,\ntable.apg-attrs td {\n  text-align: center;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\ntable.apg-attrs th:nth-child(1),\ntable.apg-attrs th:nth-child(2),\ntable.apg-attrs th:nth-child(3) {\n  text-align: right;\n}\ntable.apg-attrs td:nth-child(1),\ntable.apg-attrs td:nth-child(2),\ntable.apg-attrs td:nth-child(3) {\n  text-align: right;\n}\ntable.apg-attrs a {\n  color: #003399 !important;\n}\ntable.apg-attrs a:hover {\n  color: #8caae6 !important;\n}\n';
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/utilities.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/* eslint-disable func-names */ /*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module exports a variety of utility functions that support
// [`apg`](https://github.com/ldthomas/apg-js2), [`apg-lib`](https://github.com/ldthomas/apg-js2-lib)
// and the generated parser applications.
const style = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/style.js [app-ssr] (ecmascript)");
const converter = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-conv-api/converter.js [app-ssr] (ecmascript)");
const emitCss = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/emitcss.js [app-ssr] (ecmascript)");
const id = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)");
const thisFileName = 'utilities.js: ';
/* translate (implied) phrase beginning character and length to actual first and last character indexes */ /* used by multiple phrase handling functions */ const getBounds = function(length, begArg, len) {
    let end;
    let beg = begArg;
    const TRUE = true;
    while(TRUE){
        if (length <= 0) {
            beg = 0;
            end = 0;
            break;
        }
        if (typeof beg !== 'number') {
            beg = 0;
            end = length;
            break;
        }
        if (beg >= length) {
            beg = length;
            end = length;
            break;
        }
        if (typeof len !== 'number') {
            end = length;
            break;
        }
        end = beg + len;
        if (end > length) {
            end = length;
            break;
        }
        break;
    }
    return {
        beg,
        end
    };
};
// Generates a complete, minimal HTML5 page, inserting the user's HTML text on the page.
// - *html* - the page text in HTML format
// - *title* - the HTML page `<title>` - defaults to `htmlToPage`.
exports.htmlToPage = function(html, titleArg) {
    let title;
    if (typeof html !== 'string') {
        throw new Error(`${thisFileName}htmlToPage: input HTML is not a string`);
    }
    if (typeof titleArg !== 'string') {
        title = 'htmlToPage';
    } else {
        title = titleArg;
    }
    let page = '';
    page += '<!DOCTYPE html>\n';
    page += '<html lang="en">\n';
    page += '<head>\n';
    page += '<meta charset="utf-8">\n';
    page += `<title>${title}</title>\n`;
    page += '<style>\n';
    page += emitCss();
    page += '</style>\n';
    page += '</head>\n<body>\n';
    page += `<p>${new Date()}</p>\n`;
    page += html;
    page += '</body>\n</html>\n';
    return page;
};
// Formats the returned object from `parser.parse()`
// into an HTML table.
// ```
// return {
//   success : sysData.success,
//   state : sysData.state,
//   length : charsLength,
//   matched : sysData.phraseLength,
//   maxMatched : maxMatched,
//   maxTreeDepth : maxTreeDepth,
//   nodeHits : nodeHits,
//   inputLength : chars.length,
//   subBegin : charsBegin,
//   subEnd : charsEnd,
//   subLength : charsLength
// };
// ```
exports.parserResultToHtml = function(result, caption) {
    let cap = null;
    if (typeof caption === 'string' && caption !== '') {
        cap = caption;
    }
    let success;
    let state;
    if (result.success === true) {
        success = `<span class="${style.CLASS_MATCH}">true</span>`;
    } else {
        success = `<span class="${style.CLASS_NOMATCH}">false</span>`;
    }
    if (result.state === id.EMPTY) {
        state = `<span class="${style.CLASS_EMPTY}">EMPTY</span>`;
    } else if (result.state === id.MATCH) {
        state = `<span class="${style.CLASS_MATCH}">MATCH</span>`;
    } else if (result.state === id.NOMATCH) {
        state = `<span class="${style.CLASS_NOMATCH}">NOMATCH</span>`;
    } else {
        state = `<span class="${style.CLASS_NOMATCH}">unrecognized</span>`;
    }
    let html = '';
    html += `<table class="${style.CLASS_STATE}">\n`;
    if (cap) {
        html += `<caption>${cap}</caption>\n`;
    }
    html += '<tr><th>state item</th><th>value</th><th>description</th></tr>\n';
    html += `<tr><td>parser success</td><td>${success}</td>\n`;
    html += `<td><span class="${style.CLASS_MATCH}">true</span> if the parse succeeded,\n`;
    html += ` <span class="${style.CLASS_NOMATCH}">false</span> otherwise`;
    html += '<br><i>NOTE: for success, entire string must be matched</i></td></tr>\n';
    html += `<tr><td>parser state</td><td>${state}</td>\n`;
    html += `<td><span class="${style.CLASS_EMPTY}">EMPTY</span>, `;
    html += `<span class="${style.CLASS_MATCH}">MATCH</span> or \n`;
    html += `<span class="${style.CLASS_NOMATCH}">NOMATCH</span></td></tr>\n`;
    html += `<tr><td>string length</td><td>${result.length}</td><td>length of the input (sub)string</td></tr>\n`;
    html += `<tr><td>matched length</td><td>${result.matched}</td><td>number of input string characters matched</td></tr>\n`;
    html += `<tr><td>max matched</td><td>${result.maxMatched}</td><td>maximum number of input string characters matched</td></tr>\n`;
    html += `<tr><td>max tree depth</td><td>${result.maxTreeDepth}</td><td>maximum depth of the parse tree reached</td></tr>\n`;
    html += `<tr><td>node hits</td><td>${result.nodeHits}</td><td>number of parse tree node hits (opcode function calls)</td></tr>\n`;
    html += `<tr><td>input length</td><td>${result.inputLength}</td><td>length of full input string</td></tr>\n`;
    html += `<tr><td>sub-string begin</td><td>${result.subBegin}</td><td>sub-string first character index</td></tr>\n`;
    html += `<tr><td>sub-string end</td><td>${result.subEnd}</td><td>sub-string end-of-string index</td></tr>\n`;
    html += `<tr><td>sub-string length</td><td>${result.subLength}</td><td>sub-string length</td></tr>\n`;
    html += '</table>\n';
    return html;
};
// Translates a sub-array of integer character codes into a string.
// Very useful in callback functions to translate the matched phrases into strings.
exports.charsToString = function(chars, phraseIndex, phraseLength) {
    let beg;
    let end;
    if (typeof phraseIndex === 'number') {
        if (phraseIndex >= chars.length) {
            return '';
        }
        beg = phraseIndex < 0 ? 0 : phraseIndex;
    } else {
        beg = 0;
    }
    if (typeof phraseLength === 'number') {
        if (phraseLength <= 0) {
            return '';
        }
        end = phraseLength > chars.length - beg ? chars.length : beg + phraseLength;
    } else {
        end = chars.length;
    }
    if (beg < end) {
        return converter.encode('UTF16LE', chars.slice(beg, end)).toString('utf16le');
    }
    return '';
};
// Translates a string into an array of integer character codes.
exports.stringToChars = function(string) {
    return converter.decode('STRING', string);
};
// Translates an opcode identifier into a human-readable string.
exports.opcodeToString = function(type) {
    let ret = 'unknown';
    switch(type){
        case id.ALT:
            ret = 'ALT';
            break;
        case id.CAT:
            ret = 'CAT';
            break;
        case id.RNM:
            ret = 'RNM';
            break;
        case id.UDT:
            ret = 'UDT';
            break;
        case id.AND:
            ret = 'AND';
            break;
        case id.NOT:
            ret = 'NOT';
            break;
        case id.REP:
            ret = 'REP';
            break;
        case id.TRG:
            ret = 'TRG';
            break;
        case id.TBS:
            ret = 'TBS';
            break;
        case id.TLS:
            ret = 'TLS';
            break;
        case id.BKR:
            ret = 'BKR';
            break;
        case id.BKA:
            ret = 'BKA';
            break;
        case id.BKN:
            ret = 'BKN';
            break;
        case id.ABG:
            ret = 'ABG';
            break;
        case id.AEN:
            ret = 'AEN';
            break;
        default:
            throw new Error('unrecognized opcode');
    }
    return ret;
};
// Translates an state identifier into a human-readable string.
exports.stateToString = function(state) {
    let ret = 'unknown';
    switch(state){
        case id.ACTIVE:
            ret = 'ACTIVE';
            break;
        case id.MATCH:
            ret = 'MATCH';
            break;
        case id.EMPTY:
            ret = 'EMPTY';
            break;
        case id.NOMATCH:
            ret = 'NOMATCH';
            break;
        default:
            throw new Error('unrecognized state');
    }
    return ret;
};
// Array which translates all 128, 7-bit ASCII character codes to their respective HTML format.
exports.asciiChars = [
    'NUL',
    'SOH',
    'STX',
    'ETX',
    'EOT',
    'ENQ',
    'ACK',
    'BEL',
    'BS',
    'TAB',
    'LF',
    'VT',
    'FF',
    'CR',
    'SO',
    'SI',
    'DLE',
    'DC1',
    'DC2',
    'DC3',
    'DC4',
    'NAK',
    'SYN',
    'ETB',
    'CAN',
    'EM',
    'SUB',
    'ESC',
    'FS',
    'GS',
    'RS',
    'US',
    '&nbsp;',
    '!',
    '&#34;',
    '#',
    '$',
    '%',
    '&#38;',
    '&#39;',
    '(',
    ')',
    '*',
    '+',
    ',',
    '-',
    '.',
    '/',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    ':',
    ';',
    '&#60;',
    '=',
    '&#62;',
    '?',
    '@',
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z',
    '[',
    '&#92;',
    ']',
    '^',
    '_',
    '`',
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
    '{',
    '|',
    '}',
    '~',
    'DEL'
];
// Translates a single character to hexadecimal with leading zeros for 2, 4, or 8 digit display.
exports.charToHex = function(char) {
    let ch = char.toString(16).toUpperCase();
    switch(ch.length){
        case 1:
        case 3:
        case 7:
            ch = `0${ch}`;
            break;
        case 2:
        case 6:
            ch = `00${ch}`;
            break;
        case 4:
            break;
        case 5:
            ch = `000${ch}`;
            break;
        default:
            throw new Error('unrecognized option');
    }
    return ch;
};
// Translates a sub-array of character codes to decimal display format.
exports.charsToDec = function(chars, beg, len) {
    let ret = '';
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToDec: input must be an array of integers`);
    }
    const bounds = getBounds(chars.length, beg, len);
    if (bounds.end > bounds.beg) {
        ret += chars[bounds.beg];
        for(let i = bounds.beg + 1; i < bounds.end; i += 1){
            ret += `,${chars[i]}`;
        }
    }
    return ret;
};
// Translates a sub-array of character codes to hexadecimal display format.
exports.charsToHex = function(chars, beg, len) {
    let ret = '';
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToHex: input must be an array of integers`);
    }
    const bounds = getBounds(chars.length, beg, len);
    if (bounds.end > bounds.beg) {
        ret += `\\x${exports.charToHex(chars[bounds.beg])}`;
        for(let i = bounds.beg + 1; i < bounds.end; i += 1){
            ret += `,\\x${exports.charToHex(chars[i])}`;
        }
    }
    return ret;
};
exports.charsToHtmlEntities = function(chars, beg, len) {
    let ret = '';
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToHex: input must be an array of integers`);
    }
    const bounds = getBounds(chars.length, beg, len);
    if (bounds.end > bounds.beg) {
        for(let i = bounds.beg; i < bounds.end; i += 1){
            ret += `&#x${chars[i].toString(16)};`;
        }
    }
    return ret;
};
// Translates a sub-array of character codes to Unicode display format.
function isUnicode(char) {
    if (char >= 0xd800 && char <= 0xdfff) {
        return false;
    }
    if (char > 0x10ffff) {
        return false;
    }
    return true;
}
exports.charsToUnicode = function(chars, beg, len) {
    let ret = '';
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToUnicode: input must be an array of integers`);
    }
    const bounds = getBounds(chars.length, beg, len);
    if (bounds.end > bounds.beg) {
        for(let i = bounds.beg; i < bounds.end; i += 1){
            if (isUnicode(chars[i])) {
                ret += `&#${chars[i]};`;
            } else {
                ret += ` U+${exports.charToHex(chars[i])}`;
            }
        }
    }
    return ret;
};
// Translates a sub-array of character codes to JavaScript Unicode display format (`\uXXXX`).
exports.charsToJsUnicode = function(chars, beg, len) {
    let ret = '';
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToJsUnicode: input must be an array of integers`);
    }
    const bounds = getBounds(chars.length, beg, len);
    if (bounds.end > bounds.beg) {
        ret += `\\u${exports.charToHex(chars[bounds.beg])}`;
        for(let i = bounds.beg + 1; i < bounds.end; i += 1){
            ret += `,\\u${exports.charToHex(chars[i])}`;
        }
    }
    return ret;
};
// Translates a sub-array of character codes to printing ASCII character display format.
exports.charsToAscii = function(chars, beg, len) {
    let ret = '';
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToAscii: input must be an array of integers`);
    }
    const bounds = getBounds(chars.length, beg, len);
    for(let i = bounds.beg; i < bounds.end; i += 1){
        const char = chars[i];
        if (char >= 32 && char <= 126) {
            ret += String.fromCharCode(char);
        } else {
            ret += `\\x${exports.charToHex(char)}`;
        }
    }
    return ret;
};
// Translates a sub-array of character codes to HTML display format.
exports.charsToAsciiHtml = function(chars, beg, len) {
    if (!Array.isArray(chars)) {
        throw new Error(`${thisFileName}charsToAsciiHtml: input must be an array of integers`);
    }
    let html = '';
    let char;
    const bounds = getBounds(chars.length, beg, len);
    for(let i = bounds.beg; i < bounds.end; i += 1){
        char = chars[i];
        if (char < 32 || char === 127) {
            /* control characters */ html += `<span class="${style.CLASS_CTRLCHAR}">${exports.asciiChars[char]}</span>`;
        } else if (char > 127) {
            /* non-ASCII */ html += `<span class="${style.CLASS_CTRLCHAR}">U+${exports.charToHex(char)}</span>`;
        } else {
            /* printing ASCII, 32 <= char <= 126 */ html += exports.asciiChars[char];
        }
    }
    return html;
};
// Translates a JavaScript string to HTML display format.
exports.stringToAsciiHtml = function(str) {
    const chars = converter.decode('STRING', str);
    return this.charsToAsciiHtml(chars);
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/ast.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/* eslint-disable guard-for-in */ /* eslint-disable no-restricted-syntax */ /*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module is used by the parser to build an [Abstract Syntax Tree](https://en.wikipedia.org/wiki/Abstract_syntax_tree) (AST).
// The AST can be thought of as a subset of the full parse tree.
// Each node of the AST holds the phrase that was matched at the corresponding, named parse tree node.
// It is built as the parser successfully matches phrases to the rule names
// (`RNM` operators) and `UDT`s as it parses an input string.
// The user controls which `RNM` or `UDT` names to keep on the AST.
// The user can also associate callback functions with some or all of the retained
// AST nodes to be used to translate the node phrases. That is, associate semantic
// actions to the matched phrases.
// Translating the AST rather that attempting to apply semantic actions during
// the parsing process, has the advantage that there is no backtracking and that the phrases
// are known while traversing down tree as will as up.
//
// Let `ast` be an `ast.js` object. To identify a node to be kept on the AST:
// ```
// ast.callbacks["rulename"] = true; (all nodes default to false)
// ```
// To associate a callback function with a node:
// ```
// ast.callbacks["rulename"] = fn
// ```
// `rulename` is any `RNM` or `UDT` name defined by the associated grammar
// and `fn` is a user-written callback function.
// (See [`apg-examples`](https://github.com/ldthomas/apg-js2-examples/tree/master/ast) for examples of how to create an AST,
// define the nodes and callback functions and attach it to a parser.)
module.exports = function exportsAst() {
    const id = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)");
    const utils = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/utilities.js [app-ssr] (ecmascript)");
    const thisFileName = 'ast.js: ';
    const that = this;
    let rules = null;
    let udts = null;
    let chars = null;
    let nodeCount = 0;
    const nodesDefined = [];
    const nodeCallbacks = [];
    const stack = [];
    const records = [];
    this.callbacks = [];
    this.astObject = 'astObject';
    /* called by the parser to initialize the AST with the rules, UDTs and the input characters */ this.init = function init(rulesIn, udtsIn, charsIn) {
        stack.length = 0;
        records.length = 0;
        nodesDefined.length = 0;
        nodeCount = 0;
        rules = rulesIn;
        udts = udtsIn;
        chars = charsIn;
        let i;
        const list = [];
        for(i = 0; i < rules.length; i += 1){
            list.push(rules[i].lower);
        }
        for(i = 0; i < udts.length; i += 1){
            list.push(udts[i].lower);
        }
        nodeCount = rules.length + udts.length;
        for(i = 0; i < nodeCount; i += 1){
            nodesDefined[i] = false;
            nodeCallbacks[i] = null;
        }
        for(const index in that.callbacks){
            const lower = index.toLowerCase();
            i = list.indexOf(lower);
            if (i < 0) {
                throw new Error(`${thisFileName}init: node '${index}' not a rule or udt name`);
            }
            if (typeof that.callbacks[index] === 'function') {
                nodesDefined[i] = true;
                nodeCallbacks[i] = that.callbacks[index];
            }
            if (that.callbacks[index] === true) {
                nodesDefined[i] = true;
            }
        }
    };
    /* AST node definitions - called by the parser's `RNM` operator */ this.ruleDefined = function ruleDefined(index) {
        return nodesDefined[index] !== false;
    };
    /* AST node definitions - called by the parser's `UDT` operator */ this.udtDefined = function udtDefined(index) {
        return nodesDefined[rules.length + index] !== false;
    };
    /* called by the parser's `RNM` & `UDT` operators */ /* builds a record for the downward traversal of the node */ this.down = function down(callbackIndex, name) {
        const thisIndex = records.length;
        stack.push(thisIndex);
        records.push({
            name,
            thisIndex,
            thatIndex: null,
            state: id.SEM_PRE,
            callbackIndex,
            phraseIndex: null,
            phraseLength: null,
            stack: stack.length
        });
        return thisIndex;
    };
    /* called by the parser's `RNM` & `UDT` operators */ /* builds a record for the upward traversal of the node */ this.up = function up(callbackIndex, name, phraseIndex, phraseLength) {
        const thisIndex = records.length;
        const thatIndex = stack.pop();
        records.push({
            name,
            thisIndex,
            thatIndex,
            state: id.SEM_POST,
            callbackIndex,
            phraseIndex,
            phraseLength,
            stack: stack.length
        });
        records[thatIndex].thatIndex = thisIndex;
        records[thatIndex].phraseIndex = phraseIndex;
        records[thatIndex].phraseLength = phraseLength;
        return thisIndex;
    };
    // Called by the user to translate the AST.
    // Translate means to associate or apply some semantic action to the
    // phrases that were syntactically matched to the AST nodes according
    // to the defining grammar.
    // ```
    // data - optional user-defined data
    //        passed to the callback functions by the translator
    // ```
    this.translate = function translate(data) {
        let ret;
        let callback;
        let record;
        for(let i = 0; i < records.length; i += 1){
            record = records[i];
            callback = nodeCallbacks[record.callbackIndex];
            if (record.state === id.SEM_PRE) {
                if (callback !== null) {
                    ret = callback(id.SEM_PRE, chars, record.phraseIndex, record.phraseLength, data);
                    if (ret === id.SEM_SKIP) {
                        i = record.thatIndex;
                    }
                }
            } else if (callback !== null) {
                callback(id.SEM_POST, chars, record.phraseIndex, record.phraseLength, data);
            }
        }
    };
    /* called by the parser to reset the length of the records array */ /* necessary on backtracking */ this.setLength = function setLength(length) {
        records.length = length;
        if (length > 0) {
            stack.length = records[length - 1].stack;
        } else {
            stack.length = 0;
        }
    };
    /* called by the parser to get the length of the records array */ this.getLength = function getLength() {
        return records.length;
    };
    /* helper for XML display */ function indent(n) {
        let ret = '';
        for(let i = 0; i < n; i += 1){
            ret += ' ';
        }
        return ret;
    }
    // Generate an `XML` version of the AST.
    // Useful if you want to use a special or favorite XML parser to translate the
    // AST.
    // ```
    // mode - the display mode of the captured phrases
    //      - default mode is "ascii"
    //      - can be: "ascii"
    //                "decimal"
    //                "hexadecimal"
    //                "unicode"
    // ```
    this.toXml = function toSml(modeArg) {
        let display = utils.charsToDec;
        let caption = 'decimal integer character codes';
        if (typeof modeArg === 'string' && modeArg.length >= 3) {
            const mode = modeArg.slice(0, 3).toLowerCase();
            if (mode === 'asc') {
                display = utils.charsToAscii;
                caption = 'ASCII for printing characters, hex for non-printing';
            } else if (mode === 'hex') {
                display = utils.charsToHex;
                caption = 'hexadecimal integer character codes';
            } else if (mode === 'uni') {
                display = utils.charsToUnicode;
                caption = 'Unicode UTF-32 integer character codes';
            }
        }
        let xml = '';
        let depth = 0;
        xml += '<?xml version="1.0" encoding="utf-8"?>\n';
        xml += `<root nodes="${records.length / 2}" characters="${chars.length}">\n`;
        xml += `<!-- input string, ${caption} -->\n`;
        xml += indent(depth + 2);
        xml += display(chars);
        xml += '\n';
        records.forEach((rec)=>{
            if (rec.state === id.SEM_PRE) {
                depth += 1;
                xml += indent(depth);
                xml += `<node name="${rec.name}" index="${rec.phraseIndex}" length="${rec.phraseLength}">\n`;
                xml += indent(depth + 2);
                xml += display(chars, rec.phraseIndex, rec.phraseLength);
                xml += '\n';
            } else {
                xml += indent(depth);
                xml += `</node><!-- name="${rec.name}" -->\n`;
                depth -= 1;
            }
        });
        xml += '</root>\n';
        return xml;
    };
    /* generate a JavaScript object version of the AST */ /* for the phrase-matching engine apg-exp */ this.phrases = function phrases() {
        const obj = {};
        let i;
        let record;
        for(i = 0; i < records.length; i += 1){
            record = records[i];
            if (record.state === id.SEM_PRE) {
                if (!Array.isArray(obj[record.name])) {
                    obj[record.name] = [];
                }
                obj[record.name].push({
                    index: record.phraseIndex,
                    length: record.phraseLength
                });
            }
        }
        return obj;
    };
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/circular-buffer.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module acts as a "circular buffer". It is used to keep track
// only the last N records in an array of records. If more than N records
// are saved, each additional record overwrites the previously oldest record.
// This module deals only with the record indexes and does not save
// any actual records. It is used by [`trace.js`](./trace.html) for limiting the number of
// trace records saved.
module.exports = function exportsCircularBuffer() {
    'use strict;';
    const thisFileName = 'circular-buffer.js: ';
    let itemIndex = -1;
    let maxListSize = 0;
    // Initialize buffer.<br>
    // *size* is `maxListSize`, the maximum number of records saved before overwriting begins.
    this.init = function init(size) {
        if (typeof size !== 'number' || size <= 0) {
            throw new Error(`${thisFileName}init: circular buffer size must an integer > 0`);
        }
        maxListSize = Math.ceil(size);
        itemIndex = -1;
    };
    // Call this to increment the number of records collected.<br>
    // Returns the array index number to store the next record in.
    this.increment = function increment() {
        itemIndex += 1;
        return (itemIndex + maxListSize) % maxListSize;
    };
    // Returns `maxListSize` - the maximum number of records to keep in the buffer.
    this.maxSize = function maxSize() {
        return maxListSize;
    };
    // Returns the highest number of items saved.<br>
    // (The number of items is the actual number of records processed
    // even though only `maxListSize` records are actually retained.)
    this.items = function items() {
        return itemIndex + 1;
    };
    // Returns the record number associated with this item index.
    this.getListIndex = function getListIndex(item) {
        if (itemIndex === -1) {
            return -1;
        }
        if (item < 0 || item > itemIndex) {
            return -1;
        }
        if (itemIndex - item >= maxListSize) {
            return -1;
        }
        return (item + maxListSize) % maxListSize;
    };
    // The iterator over the circular buffer.
    // The user's function, `fn`, will be called with arguments `fn(listIndex, itemIndex)`
    // where `listIndex` is the saved record index and `itemIndex` is the actual item index.
    this.forEach = function forEach(fn) {
        if (itemIndex === -1) {
            /* no records have been collected */ return;
        }
        if (itemIndex < maxListSize) {
            /* fewer than maxListSize records have been collected - number of items = number of records */ for(let i = 0; i <= itemIndex; i += 1){
                fn(i, i);
            }
            return;
        }
        /* start with the oldest record saved and finish with the most recent record saved */ for(let i = itemIndex - maxListSize + 1; i <= itemIndex; i += 1){
            const listIndex = (i + maxListSize) % maxListSize;
            fn(listIndex, i);
        }
    };
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/parser.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/* eslint-disable func-names */ /* eslint-disable no-restricted-syntax */ /* eslint-disable new-cap */ /* eslint-disable guard-for-in */ /*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This is the primary object of `apg-lib`. Calling its `parse()` member function
// walks the parse tree of opcodes, matching phrases from the input string as it goes.
// The working code for all of the operators, `ALT`, `CAT`, etc. is in this module.
module.exports = function parser() {
    const id = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)");
    const utils = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/utilities.js [app-ssr] (ecmascript)");
    const thisFileName = 'parser.js: ';
    const thisThis = this;
    let opExecute;
    this.ast = null;
    this.stats = null;
    this.trace = null;
    this.callbacks = [];
    let opcodes = null;
    let chars = null;
    let charsBegin;
    let charsLength;
    let charsEnd;
    let lookAround;
    let treeDepth = 0;
    let maxTreeDepth = 0;
    let nodeHits = 0;
    let ruleCallbacks = null;
    let udtCallbacks = null;
    let rules = null;
    let udts = null;
    let syntaxData = null;
    let maxMatched = 0;
    let limitTreeDepth = Infinity;
    let limitNodeHits = Infinity;
    // Evaluates any given rule. This can be called from the syntax callback
    // functions to evaluate any rule in the grammar's rule list. Great caution
    // should be used. Use of this function will alter the language that the
    // parser accepts.
    const evaluateRule = function evaluateRule(ruleIndex, phraseIndex, sysData) {
        const functionName = `${thisFileName}evaluateRule(): `;
        if (ruleIndex >= rules.length) {
            throw new Error(`${functionName}rule index: ${ruleIndex} out of range`);
        }
        if (phraseIndex >= charsEnd) {
            throw new Error(`${functionName}phrase index: ${phraseIndex} out of range`);
        }
        const { length } = opcodes;
        opcodes.push({
            type: id.RNM,
            index: ruleIndex
        });
        opExecute(length, phraseIndex, sysData);
        opcodes.pop();
    };
    // Evaluates any given UDT. This can be called from the syntax callback
    // functions to evaluate any UDT in the grammar's UDT list. Great caution
    // should be used. Use of this function will alter the language that the
    // parser accepts.
    const evaluateUdt = function(udtIndex, phraseIndex, sysData) {
        const functionName = `${thisFileName}evaluateUdt(): `;
        if (udtIndex >= udts.length) {
            throw new Error(`${functionName}udt index: ${udtIndex} out of range`);
        }
        if (phraseIndex >= charsEnd) {
            throw new Error(`${functionName}phrase index: ${phraseIndex} out of range`);
        }
        const { length } = opcodes;
        opcodes.push({
            type: id.UDT,
            empty: udts[udtIndex].empty,
            index: udtIndex
        });
        opExecute(length, phraseIndex, sysData);
        opcodes.pop();
    };
    /* Clears this object of any/all data that has been initialized or added to it. */ /* Called by parse() on initialization, allowing this object to be re-used for multiple parsing calls. */ const clear = function() {
        treeDepth = 0;
        maxTreeDepth = 0;
        nodeHits = 0;
        maxMatched = 0;
        lookAround = [
            {
                lookAround: id.LOOKAROUND_NONE,
                anchor: 0,
                charsEnd: 0,
                charsLength: 0
            }
        ];
        rules = null;
        udts = null;
        chars = null;
        charsBegin = 0;
        charsLength = 0;
        charsEnd = 0;
        ruleCallbacks = null;
        udtCallbacks = null;
        syntaxData = null;
        opcodes = null;
    };
    /* object for maintaining a stack of back reference frames */ const backRef = function() {
        const stack = [];
        const init = function() {
            const obj = {};
            rules.forEach((rule)=>{
                if (rule.isBkr) {
                    obj[rule.lower] = null;
                }
            });
            if (udts.length > 0) {
                udts.forEach((udt)=>{
                    if (udt.isBkr) {
                        obj[udt.lower] = null;
                    }
                });
            }
            stack.push(obj);
        };
        const copy = function() {
            const top = stack[stack.length - 1];
            const obj = {};
            /* // eslint-disable-next-line no-restricted-syntax */ for(const name in top){
                obj[name] = top[name];
            }
            return obj;
        };
        this.push = function push() {
            stack.push(copy());
        };
        this.pop = function pop(lengthArg) {
            let length = lengthArg;
            if (!length) {
                length = stack.length - 1;
            }
            if (length < 1 || length > stack.length) {
                throw new Error(`${thisFileName}backRef.pop(): bad length: ${length}`);
            }
            stack.length = length;
            return stack[stack.length - 1];
        };
        this.length = function length() {
            return stack.length;
        };
        this.savePhrase = function savePhrase(name, index, length) {
            stack[stack.length - 1][name] = {
                phraseIndex: index,
                phraseLength: length
            };
        };
        this.getPhrase = function(name) {
            return stack[stack.length - 1][name];
        };
        /* constructor */ init();
    };
    // The system data structure that relays system information to and from the rule and UDT callback functions.
    // - *state* - the state of the parser, ACTIVE, MATCH, EMPTY or NOMATCH (see the `identifiers` object in
    // [`apg-lib`](https://github.com/ldthomas/apg-js2-lib))
    // - *phraseLength* - the number of characters matched if the state is MATCHED or EMPTY
    // - *lookaround* - the top of the stack holds the current look around state,
    // LOOKAROUND_NONE, LOOKAROUND_AHEAD or LOOKAROUND_BEHIND,
    // - *uFrame* - the "universal" back reference frame.
    // Holds the last matched phrase for each of the back referenced rules and UDTs.
    // - *pFrame* - the stack of "parent" back reference frames.
    // Holds the matched phrase from the parent frame of each back referenced rules and UDTs.
    // - *evaluateRule* - a reference to this object's `evaluateRule()` function.
    // Can be called from a callback function (use with extreme caution!)
    // - *evaluateUdt* - a reference to this object's `evaluateUdt()` function.
    // Can be called from a callback function (use with extreme caution!)
    const systemData = function systemData() {
        const thisData = this;
        this.state = id.ACTIVE;
        this.phraseLength = 0;
        this.ruleIndex = 0;
        this.udtIndex = 0;
        this.lookAround = lookAround[lookAround.length - 1];
        this.uFrame = new backRef();
        this.pFrame = new backRef();
        this.evaluateRule = evaluateRule;
        this.evaluateUdt = evaluateUdt;
        /* refresh the parser state for the next operation */ this.refresh = function refresh() {
            thisData.state = id.ACTIVE;
            thisData.phraseLength = 0;
            thisData.lookAround = lookAround[lookAround.length - 1];
        };
    };
    /* some look around helper functions */ const lookAroundValue = function lookAroundValue() {
        return lookAround[lookAround.length - 1];
    };
    /* return true if parser is in look around (ahead or behind) state */ const inLookAround = function inLookAround() {
        return lookAround.length > 1;
    };
    /* return true if parser is in look behind state */ const inLookBehind = function() {
        return lookAround[lookAround.length - 1].lookAround === id.LOOKAROUND_BEHIND;
    };
    /* called by parse() to initialize the AST object, if one has been defined */ const initializeAst = function() {
        const functionName = `${thisFileName}initializeAst(): `;
        const TRUE = true;
        while(TRUE){
            if (thisThis.ast === undefined) {
                thisThis.ast = null;
                break;
            }
            if (thisThis.ast === null) {
                break;
            }
            if (thisThis.ast.astObject !== 'astObject') {
                throw new Error(`${functionName}ast object not recognized`);
            }
            break;
        }
        if (thisThis.ast !== null) {
            thisThis.ast.init(rules, udts, chars);
        }
    };
    /* called by parse() to initialize the trace object, if one has been defined */ const initializeTrace = function() {
        const functionName = `${thisFileName}initializeTrace(): `;
        const TRUE = true;
        while(TRUE){
            if (thisThis.trace === undefined) {
                thisThis.trace = null;
                break;
            }
            if (thisThis.trace === null) {
                break;
            }
            if (thisThis.trace.traceObject !== 'traceObject') {
                throw new Error(`${functionName}trace object not recognized`);
            }
            break;
        }
        if (thisThis.trace !== null) {
            thisThis.trace.init(rules, udts, chars);
        }
    };
    /* called by parse() to initialize the statistics object, if one has been defined */ const initializeStats = function() {
        const functionName = `${thisFileName}initializeStats(): `;
        const TRUE = true;
        while(TRUE){
            if (thisThis.stats === undefined) {
                thisThis.stats = null;
                break;
            }
            if (thisThis.stats === null) {
                break;
            }
            if (thisThis.stats.statsObject !== 'statsObject') {
                throw new Error(`${functionName}stats object not recognized`);
            }
            break;
        }
        if (thisThis.stats !== null) {
            thisThis.stats.init(rules, udts);
        }
    };
    /* called by parse() to initialize the rules & udts from the grammar object */ /* (the grammar object generated previously by apg) */ const initializeGrammar = function(grammar) {
        const functionName = `${thisFileName}initializeGrammar(): `;
        if (!grammar) {
            throw new Error(`${functionName}grammar object undefined`);
        }
        if (grammar.grammarObject !== 'grammarObject') {
            throw new Error(`${functionName}bad grammar object`);
        }
        rules = grammar.rules;
        udts = grammar.udts;
    };
    /* called by parse() to initialize the start rule */ const initializeStartRule = function(startRule) {
        const functionName = `${thisFileName}initializeStartRule(): `;
        let start = null;
        if (typeof startRule === 'number') {
            if (startRule >= rules.length) {
                throw new Error(`${functionName}start rule index too large: max: ${rules.length}: index: ${startRule}`);
            }
            start = startRule;
        } else if (typeof startRule === 'string') {
            const lower = startRule.toLowerCase();
            for(let i = 0; i < rules.length; i += 1){
                if (lower === rules[i].lower) {
                    start = rules[i].index;
                    break;
                }
            }
            if (start === null) {
                throw new Error(`${functionName}start rule name '${startRule}' not recognized`);
            }
        } else {
            throw new Error(`${functionName}type of start rule '${typeof startRule}' not recognized`);
        }
        return start;
    };
    /* called by parse() to initialize the array of characters codes representing the input string */ const initializeInputChars = function initializeInputChars(inputArg, begArg, lenArg) {
        const functionName = `${thisFileName}initializeInputChars(): `;
        /* varify and normalize input */ let input = inputArg;
        let beg = begArg;
        let len = lenArg;
        if (input === undefined) {
            throw new Error(`${functionName}input string is undefined`);
        }
        if (input === null) {
            throw new Error(`${functionName}input string is null`);
        }
        if (typeof input === 'string') {
            input = utils.stringToChars(input);
        } else if (!Array.isArray(input)) {
            throw new Error(`${functionName}input string is not a string or array`);
        }
        if (input.length > 0) {
            if (typeof input[0] !== 'number') {
                throw new Error(`${functionName}input string not an array of integers`);
            }
        }
        /* verify and normalize beginning index */ if (typeof beg !== 'number') {
            beg = 0;
        } else {
            beg = Math.floor(beg);
            if (beg < 0 || beg > input.length) {
                throw new Error(`${functionName}input beginning index out of range: ${beg}`);
            }
        }
        /* verify and normalize input length */ if (typeof len !== 'number') {
            len = input.length - beg;
        } else {
            len = Math.floor(len);
            if (len < 0 || len > input.length - beg) {
                throw new Error(`${functionName}input length out of range: ${len}`);
            }
        }
        chars = input;
        charsBegin = beg;
        charsLength = len;
        charsEnd = charsBegin + charsLength;
    };
    /* called by parse() to initialize the user-written, syntax callback functions, if any */ const initializeCallbacks = function() {
        const functionName = `${thisFileName}initializeCallbacks(): `;
        let i;
        ruleCallbacks = [];
        udtCallbacks = [];
        for(i = 0; i < rules.length; i += 1){
            ruleCallbacks[i] = null;
        }
        for(i = 0; i < udts.length; i += 1){
            udtCallbacks[i] = null;
        }
        let func;
        const list = [];
        for(i = 0; i < rules.length; i += 1){
            list.push(rules[i].lower);
        }
        for(i = 0; i < udts.length; i += 1){
            list.push(udts[i].lower);
        }
        for(const index in thisThis.callbacks){
            i = list.indexOf(index.toLowerCase());
            if (i < 0) {
                throw new Error(`${functionName}syntax callback '${index}' not a rule or udt name`);
            }
            func = thisThis.callbacks[index];
            if (!func) {
                func = null;
            }
            if (typeof func === 'function' || func === null) {
                if (i < rules.length) {
                    ruleCallbacks[i] = func;
                } else {
                    udtCallbacks[i - rules.length] = func;
                }
            } else {
                throw new Error(`${functionName}syntax callback[${index}] must be function reference or 'false' (false/null/undefined/etc.)`);
            }
        }
        /* make sure all udts have been defined - the parser can't work without them */ for(i = 0; i < udts.length; i += 1){
            if (udtCallbacks[i] === null) {
                throw new Error(`${functionName}all UDT callbacks must be defined. UDT callback[${udts[i].lower}] not a function reference`);
            }
        }
    };
    // Set the maximum parse tree depth allowed. The default is `Infinity`.
    // A limit is not normally needed, but can be used to protect against an
    // exponentual or "catastrophically backtracking" grammar.
    // <ul>
    // <li>
    // depth - max allowed parse tree depth. An exception is thrown if exceeded.
    // </li>
    // </ul>
    this.setMaxTreeDepth = function(depth) {
        if (typeof depth !== 'number') {
            throw new Error(`parser: max tree depth must be integer > 0: ${depth}`);
        }
        limitTreeDepth = Math.floor(depth);
        if (limitTreeDepth <= 0) {
            throw new Error(`parser: max tree depth must be integer > 0: ${depth}`);
        }
    };
    // Set the maximum number of node hits (parser unit steps or opcode function calls) allowed.
    // The default is `Infinity`.
    // A limit is not normally needed, but can be used to protect against an
    // exponentual or "catastrophically backtracking" grammar.
    // <ul>
    // <li>
    // hits - maximum number of node hits or parser unit steps allowed.
    // An exception thrown if exceeded.
    // </li>
    // </ul>
    this.setMaxNodeHits = function(hits) {
        if (typeof hits !== 'number') {
            throw new Error(`parser: max node hits must be integer > 0: ${hits}`);
        }
        limitNodeHits = Math.floor(hits);
        if (limitNodeHits <= 0) {
            throw new Error(`parser: max node hits must be integer > 0: ${hits}`);
        }
    };
    /* the main parser function */ const privateParse = function(grammar, startRuleArg, callbackData) {
        let success;
        const functionName = `${thisFileName}parse(): `;
        initializeGrammar(grammar);
        const startRule = initializeStartRule(startRuleArg);
        initializeCallbacks();
        initializeTrace();
        initializeStats();
        initializeAst();
        const sysData = new systemData();
        if (!(callbackData === undefined || callbackData === null)) {
            syntaxData = callbackData;
        }
        /* create a dummy opcode for the start rule */ opcodes = [
            {
                type: id.RNM,
                index: startRule
            }
        ];
        /* execute the start rule */ opExecute(0, charsBegin, sysData);
        opcodes = null;
        /* test and return the sysData */ switch(sysData.state){
            case id.ACTIVE:
                throw new Error(`${functionName}final state should never be 'ACTIVE'`);
            case id.NOMATCH:
                success = false;
                break;
            case id.EMPTY:
            case id.MATCH:
                if (sysData.phraseLength === charsLength) {
                    success = true;
                } else {
                    success = false;
                }
                break;
            default:
                throw new Error('unrecognized state');
        }
        return {
            success,
            state: sysData.state,
            length: charsLength,
            matched: sysData.phraseLength,
            maxMatched,
            maxTreeDepth,
            nodeHits,
            inputLength: chars.length,
            subBegin: charsBegin,
            subEnd: charsEnd,
            subLength: charsLength
        };
    };
    // This form allows parsing of a sub-string of the full input string.
    // <ul>
    // <li>*inputIndex* - index of the first character in the sub-string</li>
    // <li>*inputLength* - length of the sub-string</li>
    // </ul>
    // All other parameters as for the above function `parse()`.
    this.parseSubstring = function parseSubstring(grammar, startRule, inputChars, inputIndex, inputLength, callbackData) {
        clear();
        initializeInputChars(inputChars, inputIndex, inputLength);
        return privateParse(grammar, startRule, callbackData);
    };
    // This is the main function, called to parse an input string.
    // <ul>
    // <li>*grammar* - an instantiated grammar object - the output of `apg` for a
    // specific SABNF grammar</li>
    // <li>*startRule* - the rule name or rule index to be used as the root of the
    // parse tree. This is usually the first rule, index = 0, of the grammar
    // but can be any rule defined in the above grammar object.</li>
    // <li>*inputChars* - the input string. Can be a string or an array of integer character codes representing the
    // string.</li>
    // <li>*callbackData* - user-defined data object to be passed to the user's
    // callback functions.
    // This is not used by the parser in any way, merely passed on to the user.
    // May be `null` or omitted.</li>
    // </ul>
    this.parse = function parse(grammar, startRule, inputChars, callbackData) {
        clear();
        initializeInputChars(inputChars, 0, inputChars.length);
        return privateParse(grammar, startRule, callbackData);
    };
    // The `ALT` operator.<br>
    // Executes its child nodes, from left to right, until it finds a match.
    // Fails if *all* of its child nodes fail.
    const opALT = function(opIndex, phraseIndex, sysData) {
        const op = opcodes[opIndex];
        for(let i = 0; i < op.children.length; i += 1){
            opExecute(op.children[i], phraseIndex, sysData);
            if (sysData.state !== id.NOMATCH) {
                break;
            }
        }
    };
    // The `CAT` operator.<br>
    // Executes all of its child nodes, from left to right,
    // concatenating the matched phrases.
    // Fails if *any* child nodes fail.
    const opCAT = function(opIndex, phraseIndex, sysData) {
        let success;
        let astLength;
        let catCharIndex;
        let catPhrase;
        const op = opcodes[opIndex];
        const ulen = sysData.uFrame.length();
        const plen = sysData.pFrame.length();
        if (thisThis.ast) {
            astLength = thisThis.ast.getLength();
        }
        success = true;
        catCharIndex = phraseIndex;
        catPhrase = 0;
        for(let i = 0; i < op.children.length; i += 1){
            opExecute(op.children[i], catCharIndex, sysData);
            if (sysData.state === id.NOMATCH) {
                success = false;
                break;
            } else {
                catCharIndex += sysData.phraseLength;
                catPhrase += sysData.phraseLength;
            }
        }
        if (success) {
            sysData.state = catPhrase === 0 ? id.EMPTY : id.MATCH;
            sysData.phraseLength = catPhrase;
        } else {
            sysData.state = id.NOMATCH;
            sysData.phraseLength = 0;
            /* reset the back referencing frames on failure */ sysData.uFrame.pop(ulen);
            sysData.pFrame.pop(plen);
            if (thisThis.ast) {
                thisThis.ast.setLength(astLength);
            }
        }
    };
    // The `REP` operator.<br>
    // Repeatedly executes its single child node,
    // concatenating each of the matched phrases found.
    // The number of repetitions executed and its final sysData depends
    // on its `min` & `max` repetition values.
    const opREP = function(opIndex, phraseIndex, sysData) {
        let astLength;
        let repCharIndex;
        let repPhrase;
        let repCount;
        const op = opcodes[opIndex];
        if (op.max === 0) {
            // this is an empty-string acceptor
            // deprecated: use the TLS empty string operator, "", instead
            sysData.state = id.EMPTY;
            sysData.phraseLength = 0;
            return;
        }
        repCharIndex = phraseIndex;
        repPhrase = 0;
        repCount = 0;
        const ulen = sysData.uFrame.length();
        const plen = sysData.pFrame.length();
        if (thisThis.ast) {
            astLength = thisThis.ast.getLength();
        }
        const TRUE = true;
        while(TRUE){
            if (repCharIndex >= charsEnd) {
                break;
            }
            opExecute(opIndex + 1, repCharIndex, sysData);
            if (sysData.state === id.NOMATCH) {
                break;
            }
            if (sysData.state === id.EMPTY) {
                break;
            }
            repCount += 1;
            repPhrase += sysData.phraseLength;
            repCharIndex += sysData.phraseLength;
            if (repCount === op.max) {
                break;
            }
        }
        /* evaluate the match count according to the min, max values */ if (sysData.state === id.EMPTY) {
            sysData.state = repPhrase === 0 ? id.EMPTY : id.MATCH;
            sysData.phraseLength = repPhrase;
        } else if (repCount >= op.min) {
            sysData.state = repPhrase === 0 ? id.EMPTY : id.MATCH;
            sysData.phraseLength = repPhrase;
        } else {
            sysData.state = id.NOMATCH;
            sysData.phraseLength = 0;
            /* reset the back referencing frames on failure */ sysData.uFrame.pop(ulen);
            sysData.pFrame.pop(plen);
            if (thisThis.ast) {
                thisThis.ast.setLength(astLength);
            }
        }
    };
    // Validate the callback function's returned sysData values.
    // It's the user's responsibility to get them right
    // but `RNM` fails if not.
    const validateRnmCallbackResult = function(rule, sysData, charsLeft, down) {
        if (sysData.phraseLength > charsLeft) {
            let str = `${thisFileName}opRNM(${rule.name}): callback function error: `;
            str += `sysData.phraseLength: ${sysData.phraseLength}`;
            str += ` must be <= remaining chars: ${charsLeft}`;
            throw new Error(str);
        }
        switch(sysData.state){
            case id.ACTIVE:
                if (down !== true) {
                    throw new Error(`${thisFileName}opRNM(${rule.name}): callback function return error. ACTIVE state not allowed.`);
                }
                break;
            case id.EMPTY:
                sysData.phraseLength = 0;
                break;
            case id.MATCH:
                if (sysData.phraseLength === 0) {
                    sysData.state = id.EMPTY;
                }
                break;
            case id.NOMATCH:
                sysData.phraseLength = 0;
                break;
            default:
                throw new Error(`${thisFileName}opRNM(${rule.name}): callback function return error. Unrecognized return state: ${sysData.state}`);
        }
    };
    // The `RNM` operator.<br>
    // This operator will acts as a root node for a parse tree branch below and
    // returns the matched phrase to its parent.
    // However, its larger responsibility is handling user-defined callback functions, back references and `AST` nodes.
    // Note that the `AST` is a separate object, but `RNM` calls its functions to create its nodes.
    // See [`ast.js`](./ast.html) for usage.
    const opRNM = function(opIndex, phraseIndex, sysData) {
        let astLength;
        let astDefined;
        let savedOpcodes;
        let ulen;
        let plen;
        let saveFrame;
        const op = opcodes[opIndex];
        const rule = rules[op.index];
        const callback = ruleCallbacks[rule.index];
        const notLookAround = !inLookAround();
        /* ignore AST and back references in lookaround */ if (notLookAround) {
            /* begin AST and back references */ astDefined = thisThis.ast && thisThis.ast.ruleDefined(op.index);
            if (astDefined) {
                astLength = thisThis.ast.getLength();
                thisThis.ast.down(op.index, rules[op.index].name);
            }
            ulen = sysData.uFrame.length();
            plen = sysData.pFrame.length();
            sysData.uFrame.push();
            sysData.pFrame.push();
            saveFrame = sysData.pFrame;
            sysData.pFrame = new backRef();
        }
        if (callback === null) {
            /* no callback - just execute the rule */ savedOpcodes = opcodes;
            opcodes = rule.opcodes;
            opExecute(0, phraseIndex, sysData);
            opcodes = savedOpcodes;
        } else {
            /* call user's callback */ const charsLeft = charsEnd - phraseIndex;
            sysData.ruleIndex = rule.index;
            callback(sysData, chars, phraseIndex, syntaxData);
            validateRnmCallbackResult(rule, sysData, charsLeft, true);
            if (sysData.state === id.ACTIVE) {
                savedOpcodes = opcodes;
                opcodes = rule.opcodes;
                opExecute(0, phraseIndex, sysData);
                opcodes = savedOpcodes;
                sysData.ruleIndex = rule.index;
                callback(sysData, chars, phraseIndex, syntaxData);
                validateRnmCallbackResult(rule, sysData, charsLeft, false);
            } /* implied else clause: just accept the callback sysData - RNM acting as UDT */ 
        }
        if (notLookAround) {
            /* end AST */ if (astDefined) {
                if (sysData.state === id.NOMATCH) {
                    thisThis.ast.setLength(astLength);
                } else {
                    thisThis.ast.up(op.index, rule.name, phraseIndex, sysData.phraseLength);
                }
            }
            /* end back reference */ sysData.pFrame = saveFrame;
            if (sysData.state === id.NOMATCH) {
                sysData.uFrame.pop(ulen);
                sysData.pFrame.pop(plen);
            } else if (rule.isBkr) {
                /* save phrase on both the parent and universal frames */ /* BKR operator will decide which to use later */ sysData.pFrame.savePhrase(rule.lower, phraseIndex, sysData.phraseLength);
                sysData.uFrame.savePhrase(rule.lower, phraseIndex, sysData.phraseLength);
            }
        }
    };
    // Validate the callback function's returned sysData values.
    // It's the user's responsibility to get it right but `UDT` fails if not.
    const validateUdtCallbackResult = function(udt, sysData, charsLeft) {
        if (sysData.phraseLength > charsLeft) {
            let str = `${thisFileName}opUDT(${udt.name}): callback function error: `;
            str += `sysData.phraseLength: ${sysData.phraseLength}`;
            str += ` must be <= remaining chars: ${charsLeft}`;
            throw new Error(str);
        }
        switch(sysData.state){
            case id.ACTIVE:
                throw new Error(`${thisFileName}opUDT(${udt.name}): callback function return error. ACTIVE state not allowed.`);
            case id.EMPTY:
                if (udt.empty === false) {
                    throw new Error(`${thisFileName}opUDT(${udt.name}): callback function return error. May not return EMPTY.`);
                } else {
                    sysData.phraseLength = 0;
                }
                break;
            case id.MATCH:
                if (sysData.phraseLength === 0) {
                    if (udt.empty === false) {
                        throw new Error(`${thisFileName}opUDT(${udt.name}): callback function return error. May not return EMPTY.`);
                    } else {
                        sysData.state = id.EMPTY;
                    }
                }
                break;
            case id.NOMATCH:
                sysData.phraseLength = 0;
                break;
            default:
                throw new Error(`${thisFileName}opUDT(${udt.name}): callback function return error. Unrecognized return state: ${sysData.state}`);
        }
    };
    // The `UDT` operator.<br>
    // Simply calls the user's callback function, but operates like `RNM` with regard to the `AST`
    // and back referencing.
    // There is some ambiguity here. `UDT`s act as terminals for phrase recognition but as named rules
    // for `AST` nodes and back referencing.
    // See [`ast.js`](./ast.html) for usage.
    const opUDT = function(opIndex, phraseIndex, sysData) {
        let astLength;
        let astIndex;
        let astDefined;
        let ulen;
        let plen;
        let saveFrame;
        const op = opcodes[opIndex];
        const udt = udts[op.index];
        sysData.UdtIndex = udt.index;
        const notLookAround = !inLookAround();
        /* ignore AST and back references in lookaround */ if (notLookAround) {
            /* begin AST and back reference */ astDefined = thisThis.ast && thisThis.ast.udtDefined(op.index);
            if (astDefined) {
                astIndex = rules.length + op.index;
                astLength = thisThis.ast.getLength();
                thisThis.ast.down(astIndex, udt.name);
            }
            /* NOTE: push and pop of the back reference frame is normally not necessary */ /* only in the case that the UDT calls evaluateRule() or evaluateUdt() */ ulen = sysData.uFrame.length();
            plen = sysData.pFrame.length();
            sysData.uFrame.push();
            sysData.pFrame.push();
            saveFrame = sysData.pFrame;
            sysData.pFrame = new backRef();
        }
        /* call the UDT */ const charsLeft = charsEnd - phraseIndex;
        udtCallbacks[op.index](sysData, chars, phraseIndex, syntaxData);
        validateUdtCallbackResult(udt, sysData, charsLeft);
        if (notLookAround) {
            /* end AST */ if (astDefined) {
                if (sysData.state === id.NOMATCH) {
                    thisThis.ast.setLength(astLength);
                } else {
                    thisThis.ast.up(astIndex, udt.name, phraseIndex, sysData.phraseLength);
                }
            }
            /* end back reference */ sysData.pFrame = saveFrame;
            if (sysData.state === id.NOMATCH) {
                sysData.uFrame.pop(ulen);
                sysData.pFrame.pop(plen);
            } else if (udt.isBkr) {
                /* save phrase on both the parent and universal frames */ /* BKR operator will decide which to use later */ sysData.pFrame.savePhrase(udt.lower, phraseIndex, sysData.phraseLength);
                sysData.uFrame.savePhrase(udt.lower, phraseIndex, sysData.phraseLength);
            }
        }
    };
    // The `AND` operator.<br>
    // This is the positive `look ahead` operator.
    // Executes its single child node, returning the EMPTY state
    // if it succeedsand NOMATCH if it fails.
    // *Always* backtracks on any matched phrase and returns EMPTY on success.
    const opAND = function(opIndex, phraseIndex, sysData) {
        lookAround.push({
            lookAround: id.LOOKAROUND_AHEAD,
            anchor: phraseIndex,
            charsEnd,
            charsLength
        });
        charsEnd = chars.length;
        charsLength = chars.length - charsBegin;
        opExecute(opIndex + 1, phraseIndex, sysData);
        const pop = lookAround.pop();
        charsEnd = pop.charsEnd;
        charsLength = pop.charsLength;
        sysData.phraseLength = 0;
        switch(sysData.state){
            case id.EMPTY:
                sysData.state = id.EMPTY;
                break;
            case id.MATCH:
                sysData.state = id.EMPTY;
                break;
            case id.NOMATCH:
                sysData.state = id.NOMATCH;
                break;
            default:
                throw new Error(`opAND: invalid state ${sysData.state}`);
        }
    };
    // The `NOT` operator.<br>
    // This is the negative `look ahead` operator.
    // Executes its single child node, returning the EMPTY state
    // if it *fails* and NOMATCH if it succeeds.
    // *Always* backtracks on any matched phrase and returns EMPTY
    // on success (failure of its child node).
    const opNOT = function(opIndex, phraseIndex, sysData) {
        lookAround.push({
            lookAround: id.LOOKAROUND_AHEAD,
            anchor: phraseIndex,
            charsEnd,
            charsLength
        });
        charsEnd = chars.length;
        charsLength = chars.length - charsBegin;
        opExecute(opIndex + 1, phraseIndex, sysData);
        const pop = lookAround.pop();
        charsEnd = pop.charsEnd;
        charsLength = pop.charsLength;
        sysData.phraseLength = 0;
        switch(sysData.state){
            case id.EMPTY:
            case id.MATCH:
                sysData.state = id.NOMATCH;
                break;
            case id.NOMATCH:
                sysData.state = id.EMPTY;
                break;
            default:
                throw new Error(`opNOT: invalid state ${sysData.state}`);
        }
    };
    // The `TRG` operator.<br>
    // Succeeds if the single first character of the phrase is
    // within the `min - max` range.
    const opTRG = function(opIndex, phraseIndex, sysData) {
        const op = opcodes[opIndex];
        sysData.state = id.NOMATCH;
        if (phraseIndex < charsEnd) {
            if (op.min <= chars[phraseIndex] && chars[phraseIndex] <= op.max) {
                sysData.state = id.MATCH;
                sysData.phraseLength = 1;
            }
        }
    };
    // The `TBS` operator.<br>
    // Matches its pre-defined phrase against the input string.
    // All characters must match exactly.
    // Case-sensitive literal strings (`'string'` & `%s"string"`) are translated to `TBS`
    // operators by `apg`.
    // Phrase length of zero is not allowed.
    // Empty phrases can only be defined with `TLS` operators.
    const opTBS = function(opIndex, phraseIndex, sysData) {
        let i;
        const op = opcodes[opIndex];
        const len = op.string.length;
        sysData.state = id.NOMATCH;
        if (phraseIndex + len <= charsEnd) {
            for(i = 0; i < len; i += 1){
                if (chars[phraseIndex + i] !== op.string[i]) {
                    return;
                }
            }
            sysData.state = id.MATCH;
            sysData.phraseLength = len;
        } /* implied else NOMATCH */ 
    };
    // The `TLS` operator.<br>
    // Matches its pre-defined phrase against the input string.
    // A case-insensitive match is attempted for ASCII alphbetical characters.
    // `TLS` is the only operator that explicitly allows empty phrases.
    // `apg` will fail for empty `TBS`, case-sensitive strings (`''`) or
    // zero repetitions (`0*0RuleName` or `0RuleName`).
    const opTLS = function(opIndex, phraseIndex, sysData) {
        let i;
        let code;
        const op = opcodes[opIndex];
        sysData.state = id.NOMATCH;
        const len = op.string.length;
        if (len === 0) {
            /* EMPTY match allowed for TLS */ sysData.state = id.EMPTY;
            return;
        }
        if (phraseIndex + len <= charsEnd) {
            for(i = 0; i < len; i += 1){
                code = chars[phraseIndex + i];
                if (code >= 65 && code <= 90) {
                    code += 32;
                }
                if (code !== op.string[i]) {
                    return;
                }
            }
            sysData.state = id.MATCH;
            sysData.phraseLength = len;
        } /* implied else NOMATCH */ 
    };
    // The `ABG` operator.<br>
    // This is an "anchor" for the beginning of the string, similar to the familiar regex `^` anchor.
    // An anchor matches a position rather than a phrase.
    // Returns EMPTY if `phraseIndex` is 0, NOMATCH otherwise.
    const opABG = function(opIndex, phraseIndex, sysData) {
        sysData.state = id.NOMATCH;
        sysData.phraseLength = 0;
        sysData.state = phraseIndex === 0 ? id.EMPTY : id.NOMATCH;
    };
    // The `AEN` operator.<br>
    // This is an "anchor" for the end of the string, similar to the familiar regex `$` anchor.
    // An anchor matches a position rather than a phrase.
    // Returns EMPTY if `phraseIndex` equals the input string length, NOMATCH otherwise.
    const opAEN = function(opIndex, phraseIndex, sysData) {
        sysData.state = id.NOMATCH;
        sysData.phraseLength = 0;
        sysData.state = phraseIndex === chars.length ? id.EMPTY : id.NOMATCH;
    };
    // The `BKR` operator.<br>
    // The back reference operator.
    // Matches the last matched phrase of the named rule or UDT against the input string.
    // For ASCII alphbetical characters the match may be case sensitive (`%s`) or insensitive (`%i`),
    // depending on the back reference definition.
    // For `universal` mode (`%u`) matches the last phrase found anywhere in the grammar.
    // For `parent frame` mode (`%p`) matches the last phrase found in the parent rule only.
    const opBKR = function(opIndex, phraseIndex, sysData) {
        let i;
        let code;
        let lmcode;
        let lower;
        const op = opcodes[opIndex];
        sysData.state = id.NOMATCH;
        if (op.index < rules.length) {
            lower = rules[op.index].lower;
        } else {
            lower = udts[op.index - rules.length].lower;
        }
        const frame = op.bkrMode === id.BKR_MODE_PM ? sysData.pFrame.getPhrase(lower) : sysData.uFrame.getPhrase(lower);
        const insensitive = op.bkrCase === id.BKR_MODE_CI;
        if (frame === null) {
            return;
        }
        const lmIndex = frame.phraseIndex;
        const len = frame.phraseLength;
        if (len === 0) {
            sysData.state = id.EMPTY;
            return;
        }
        if (phraseIndex + len <= charsEnd) {
            if (insensitive) {
                /* case-insensitive match */ for(i = 0; i < len; i += 1){
                    code = chars[phraseIndex + i];
                    lmcode = chars[lmIndex + i];
                    if (code >= 65 && code <= 90) {
                        code += 32;
                    }
                    if (lmcode >= 65 && lmcode <= 90) {
                        lmcode += 32;
                    }
                    if (code !== lmcode) {
                        return;
                    }
                }
                sysData.state = id.MATCH;
                sysData.phraseLength = len;
            } else {
                /* case-sensitive match */ for(i = 0; i < len; i += 1){
                    code = chars[phraseIndex + i];
                    lmcode = chars[lmIndex + i];
                    if (code !== lmcode) {
                        return;
                    }
                }
            }
            sysData.state = id.MATCH;
            sysData.phraseLength = len;
        }
    };
    // The `BKA` operator.<br>
    // This is the positive `look behind` operator.
    // It's child node is parsed right-to-left.
    // Returns the EMPTY state if a match is found, NOMATCH otherwise.
    // Like the look ahead operators, it always backtracks to `phraseIndex`.
    const opBKA = function(opIndex, phraseIndex, sysData) {
        lookAround.push({
            lookAround: id.LOOKAROUND_BEHIND,
            anchor: phraseIndex
        });
        opExecute(opIndex + 1, phraseIndex, sysData);
        lookAround.pop();
        sysData.phraseLength = 0;
        switch(sysData.state){
            case id.EMPTY:
                sysData.state = id.EMPTY;
                break;
            case id.MATCH:
                sysData.state = id.EMPTY;
                break;
            case id.NOMATCH:
                sysData.state = id.NOMATCH;
                break;
            default:
                throw new Error(`opBKA: invalid state ${sysData.state}`);
        }
    };
    // The `BKN` operator.<br>
    // This is the negative `look behind` operator.
    // It's child node is parsed right-to-left.
    // Returns the EMPTY state if a match is *not* found, NOMATCH otherwise.
    // Like the look ahead operators, it always backtracks to `phraseIndex`.
    const opBKN = function(opIndex, phraseIndex, sysData) {
        // let op;
        // op = opcodes[opIndex];
        lookAround.push({
            lookAround: id.LOOKAROUND_BEHIND,
            anchor: phraseIndex
        });
        opExecute(opIndex + 1, phraseIndex, sysData);
        lookAround.pop();
        sysData.phraseLength = 0;
        switch(sysData.state){
            case id.EMPTY:
            case id.MATCH:
                sysData.state = id.NOMATCH;
                break;
            case id.NOMATCH:
                sysData.state = id.EMPTY;
                break;
            default:
                throw new Error(`opBKN: invalid state ${sysData.state}`);
        }
    };
    // The right-to-left `CAT` operator.<br>
    // Called for `CAT` operators when in look behind mode.
    // Calls its child nodes from right to left concatenating matched phrases right to left.
    const opCATBehind = function(opIndex, phraseIndex, sysData) {
        let success;
        let astLength;
        let catCharIndex;
        let catMatched;
        const op = opcodes[opIndex];
        const ulen = sysData.uFrame.length();
        const plen = sysData.pFrame.length();
        if (thisThis.ast) {
            astLength = thisThis.ast.getLength();
        }
        success = true;
        catCharIndex = phraseIndex;
        catMatched = 0;
        // catPhrase = 0;
        for(let i = op.children.length - 1; i >= 0; i -= 1){
            opExecute(op.children[i], catCharIndex, sysData);
            catCharIndex -= sysData.phraseLength;
            catMatched += sysData.phraseLength;
            // catPhrase += sysData.phraseLength;
            if (sysData.state === id.NOMATCH) {
                success = false;
                break;
            }
        }
        if (success) {
            sysData.state = catMatched === 0 ? id.EMPTY : id.MATCH;
            sysData.phraseLength = catMatched;
        } else {
            sysData.state = id.NOMATCH;
            sysData.phraseLength = 0;
            sysData.uFrame.pop(ulen);
            sysData.pFrame.pop(plen);
            if (thisThis.ast) {
                thisThis.ast.setLength(astLength);
            }
        }
    };
    // The right-to-left `REP` operator.<br>
    // Called for `REP` operators in look behind mode.
    // Makes repeated calls to its child node, concatenating matched phrases right to left.
    const opREPBehind = function(opIndex, phraseIndex, sysData) {
        let astLength;
        let repCharIndex;
        let repPhrase;
        let repCount;
        const op = opcodes[opIndex];
        repCharIndex = phraseIndex;
        repPhrase = 0;
        repCount = 0;
        const ulen = sysData.uFrame.length();
        const plen = sysData.pFrame.length();
        if (thisThis.ast) {
            astLength = thisThis.ast.getLength();
        }
        const TRUE = true;
        while(TRUE){
            if (repCharIndex <= 0) {
                break;
            }
            opExecute(opIndex + 1, repCharIndex, sysData);
            if (sysData.state === id.NOMATCH) {
                break;
            }
            if (sysData.state === id.EMPTY) {
                break;
            }
            repCount += 1;
            repPhrase += sysData.phraseLength;
            repCharIndex -= sysData.phraseLength;
            if (repCount === op.max) {
                break;
            }
        }
        /* evaluate the match count according to the min, max values */ if (sysData.state === id.EMPTY) {
            sysData.state = repPhrase === 0 ? id.EMPTY : id.MATCH;
            sysData.phraseLength = repPhrase;
        } else if (repCount >= op.min) {
            sysData.state = repPhrase === 0 ? id.EMPTY : id.MATCH;
            sysData.phraseLength = repPhrase;
        } else {
            sysData.state = id.NOMATCH;
            sysData.phraseLength = 0;
            sysData.uFrame.pop(ulen);
            sysData.pFrame.pop(plen);
            if (thisThis.ast) {
                thisThis.ast.setLength(astLength);
            }
        }
    };
    // The right-to-left `TRG` operator.<br>
    // Called for `TRG` operators in look behind mode.
    // Matches a single character at `phraseIndex - 1` to the `min` - `max` range.
    const opTRGBehind = function(opIndex, phraseIndex, sysData) {
        const op = opcodes[opIndex];
        sysData.state = id.NOMATCH;
        sysData.phraseLength = 0;
        if (phraseIndex > 0) {
            const char = chars[phraseIndex - 1];
            if (op.min <= char && char <= op.max) {
                sysData.state = id.MATCH;
                sysData.phraseLength = 1;
            }
        }
    };
    // The right-to-left `TBS` operator.<br>
    // Called for `TBS` operators in look behind mode.
    // Matches the `TBS` phrase to the left of `phraseIndex`.
    const opTBSBehind = function(opIndex, phraseIndex, sysData) {
        let i;
        const op = opcodes[opIndex];
        sysData.state = id.NOMATCH;
        const len = op.string.length;
        const beg = phraseIndex - len;
        if (beg >= 0) {
            for(i = 0; i < len; i += 1){
                if (chars[beg + i] !== op.string[i]) {
                    return;
                }
            }
            sysData.state = id.MATCH;
            sysData.phraseLength = len;
        }
    };
    // The right-to-left `TLS` operator.<br>
    // Called for `TLS` operators in look behind mode.
    // Matches the `TLS` phrase to the left of `phraseIndex`.
    const opTLSBehind = function(opIndex, phraseIndex, sysData) {
        let char;
        const op = opcodes[opIndex];
        sysData.state = id.NOMATCH;
        const len = op.string.length;
        if (len === 0) {
            /* EMPTY match allowed for TLS */ sysData.state = id.EMPTY;
            return;
        }
        const beg = phraseIndex - len;
        if (beg >= 0) {
            for(let i = 0; i < len; i += 1){
                char = chars[beg + i];
                if (char >= 65 && char <= 90) {
                    char += 32;
                }
                if (char !== op.string[i]) {
                    return;
                }
            }
            sysData.state = id.MATCH;
            sysData.phraseLength = len;
        }
    };
    // The right-to-left back reference operator.<br>
    // Matches the back referenced phrase to the left of `phraseIndex`.
    const opBKRBehind = function(opIndex, phraseIndex, sysData) {
        let i;
        let code;
        let lmcode;
        let lower;
        const op = opcodes[opIndex];
        /* NOMATCH default */ sysData.state = id.NOMATCH;
        sysData.phraseLength = 0;
        if (op.index < rules.length) {
            lower = rules[op.index].lower;
        } else {
            lower = udts[op.index - rules.length].lower;
        }
        const frame = op.bkrMode === id.BKR_MODE_PM ? sysData.pFrame.getPhrase(lower) : sysData.uFrame.getPhrase(lower);
        const insensitive = op.bkrCase === id.BKR_MODE_CI;
        if (frame === null) {
            return;
        }
        const lmIndex = frame.phraseIndex;
        const len = frame.phraseLength;
        if (len === 0) {
            sysData.state = id.EMPTY;
            sysData.phraseLength = 0;
            return;
        }
        const beg = phraseIndex - len;
        if (beg >= 0) {
            if (insensitive) {
                /* case-insensitive match */ for(i = 0; i < len; i += 1){
                    code = chars[beg + i];
                    lmcode = chars[lmIndex + i];
                    if (code >= 65 && code <= 90) {
                        code += 32;
                    }
                    if (lmcode >= 65 && lmcode <= 90) {
                        lmcode += 32;
                    }
                    if (code !== lmcode) {
                        return;
                    }
                }
                sysData.state = id.MATCH;
                sysData.phraseLength = len;
            } else {
                /* case-sensitive match */ for(i = 0; i < len; i += 1){
                    code = chars[beg + i];
                    lmcode = chars[lmIndex + i];
                    if (code !== lmcode) {
                        return;
                    }
                }
            }
            sysData.state = id.MATCH;
            sysData.phraseLength = len;
        }
    };
    // Generalized execution function.<br>
    // Having a single, generalized function, allows a single location
    // for tracing and statistics gathering functions to be called.
    // Tracing and statistics are handled in separate objects.
    // However, the parser calls their API to build the object data records.
    // See [`trace.js`](./trace.html) and [`stats.js`](./stats.html) for their
    // usage.
    opExecute = function opExecuteFunc(opIndex, phraseIndex, sysData) {
        let ret = true;
        const op = opcodes[opIndex];
        nodeHits += 1;
        if (nodeHits > limitNodeHits) {
            throw new Error(`parser: maximum number of node hits exceeded: ${limitNodeHits}`);
        }
        treeDepth += 1;
        if (treeDepth > maxTreeDepth) {
            maxTreeDepth = treeDepth;
            if (maxTreeDepth > limitTreeDepth) {
                throw new Error(`parser: maximum parse tree depth exceeded: ${limitTreeDepth}`);
            }
        }
        sysData.refresh();
        if (thisThis.trace !== null) {
            /* collect the trace record for down the parse tree */ const lk = lookAroundValue();
            thisThis.trace.down(op, sysData.state, phraseIndex, sysData.phraseLength, lk.anchor, lk.lookAround);
        }
        if (inLookBehind()) {
            switch(op.type){
                case id.ALT:
                    opALT(opIndex, phraseIndex, sysData);
                    break;
                case id.CAT:
                    opCATBehind(opIndex, phraseIndex, sysData);
                    break;
                case id.REP:
                    opREPBehind(opIndex, phraseIndex, sysData);
                    break;
                case id.RNM:
                    opRNM(opIndex, phraseIndex, sysData);
                    break;
                case id.UDT:
                    opUDT(opIndex, phraseIndex, sysData);
                    break;
                case id.AND:
                    opAND(opIndex, phraseIndex, sysData);
                    break;
                case id.NOT:
                    opNOT(opIndex, phraseIndex, sysData);
                    break;
                case id.TRG:
                    opTRGBehind(opIndex, phraseIndex, sysData);
                    break;
                case id.TBS:
                    opTBSBehind(opIndex, phraseIndex, sysData);
                    break;
                case id.TLS:
                    opTLSBehind(opIndex, phraseIndex, sysData);
                    break;
                case id.BKR:
                    opBKRBehind(opIndex, phraseIndex, sysData);
                    break;
                case id.BKA:
                    opBKA(opIndex, phraseIndex, sysData);
                    break;
                case id.BKN:
                    opBKN(opIndex, phraseIndex, sysData);
                    break;
                case id.ABG:
                    opABG(opIndex, phraseIndex, sysData);
                    break;
                case id.AEN:
                    opAEN(opIndex, phraseIndex, sysData);
                    break;
                default:
                    ret = false;
                    break;
            }
        } else {
            switch(op.type){
                case id.ALT:
                    opALT(opIndex, phraseIndex, sysData);
                    break;
                case id.CAT:
                    opCAT(opIndex, phraseIndex, sysData);
                    break;
                case id.REP:
                    opREP(opIndex, phraseIndex, sysData);
                    break;
                case id.RNM:
                    opRNM(opIndex, phraseIndex, sysData);
                    break;
                case id.UDT:
                    opUDT(opIndex, phraseIndex, sysData);
                    break;
                case id.AND:
                    opAND(opIndex, phraseIndex, sysData);
                    break;
                case id.NOT:
                    opNOT(opIndex, phraseIndex, sysData);
                    break;
                case id.TRG:
                    opTRG(opIndex, phraseIndex, sysData);
                    break;
                case id.TBS:
                    opTBS(opIndex, phraseIndex, sysData);
                    break;
                case id.TLS:
                    opTLS(opIndex, phraseIndex, sysData);
                    break;
                case id.BKR:
                    opBKR(opIndex, phraseIndex, sysData);
                    break;
                case id.BKA:
                    opBKA(opIndex, phraseIndex, sysData);
                    break;
                case id.BKN:
                    opBKN(opIndex, phraseIndex, sysData);
                    break;
                case id.ABG:
                    opABG(opIndex, phraseIndex, sysData);
                    break;
                case id.AEN:
                    opAEN(opIndex, phraseIndex, sysData);
                    break;
                default:
                    ret = false;
                    break;
            }
        }
        if (!inLookAround() && phraseIndex + sysData.phraseLength > maxMatched) {
            maxMatched = phraseIndex + sysData.phraseLength;
        }
        if (thisThis.stats !== null) {
            /* collect the statistics */ thisThis.stats.collect(op, sysData);
        }
        if (thisThis.trace !== null) {
            /* collect the trace record for up the parse tree */ const lk = lookAroundValue();
            thisThis.trace.up(op, sysData.state, phraseIndex, sysData.phraseLength, lk.anchor, lk.lookAround);
        }
        treeDepth -= 1;
        return ret;
    };
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/stats.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module is the constructor for the statistics gathering object.
// The statistics are nothing more than keeping a count of the
// number of times each node in the parse tree is traversed.
//
// Counts are collected for each of the individual types of operators.
// Additionally, counts are collected for each of the individually named
// `RNM` and `UDT` operators.
module.exports = function statsFunc() {
    const id = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)");
    const utils = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/utilities.js [app-ssr] (ecmascript)");
    const style = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/style.js [app-ssr] (ecmascript)");
    const thisFileName = 'stats.js: ';
    let rules = [];
    let udts = [];
    const stats = [];
    let totals;
    const ruleStats = [];
    const udtStats = [];
    this.statsObject = 'statsObject';
    const nameId = 'stats';
    /* `Array.sort()` callback function for sorting `RNM` and `UDT` operators alphabetically by name. */ const sortAlpha = function sortAlpha(lhs, rhs) {
        if (lhs.lower < rhs.lower) {
            return -1;
        }
        if (lhs.lower > rhs.lower) {
            return 1;
        }
        return 0;
    };
    /* `Array.sort()` callback function for sorting `RNM` and `UDT` operators by hit count. */ const sortHits = function sortHits(lhs, rhs) {
        if (lhs.total < rhs.total) {
            return 1;
        }
        if (lhs.total > rhs.total) {
            return -1;
        }
        return sortAlpha(lhs, rhs);
    };
    /* `Array.sort()` callback function for sorting `RNM` and `UDT` operators by index */ /* (in the order in which they appear in the SABNF grammar). */ const sortIndex = function sortIndex(lhs, rhs) {
        if (lhs.index < rhs.index) {
            return -1;
        }
        if (lhs.index > rhs.index) {
            return 1;
        }
        return 0;
    };
    const EmptyStat = function EmptyStat() {
        this.empty = 0;
        this.match = 0;
        this.nomatch = 0;
        this.total = 0;
    };
    /* Zero out all stats */ const clear = function clear() {
        stats.length = 0;
        totals = new EmptyStat();
        stats[id.ALT] = new EmptyStat();
        stats[id.CAT] = new EmptyStat();
        stats[id.REP] = new EmptyStat();
        stats[id.RNM] = new EmptyStat();
        stats[id.TRG] = new EmptyStat();
        stats[id.TBS] = new EmptyStat();
        stats[id.TLS] = new EmptyStat();
        stats[id.UDT] = new EmptyStat();
        stats[id.AND] = new EmptyStat();
        stats[id.NOT] = new EmptyStat();
        stats[id.BKR] = new EmptyStat();
        stats[id.BKA] = new EmptyStat();
        stats[id.BKN] = new EmptyStat();
        stats[id.ABG] = new EmptyStat();
        stats[id.AEN] = new EmptyStat();
        ruleStats.length = 0;
        for(let i = 0; i < rules.length; i += 1){
            ruleStats.push({
                empty: 0,
                match: 0,
                nomatch: 0,
                total: 0,
                name: rules[i].name,
                lower: rules[i].lower,
                index: rules[i].index
            });
        }
        if (udts.length > 0) {
            udtStats.length = 0;
            for(let i = 0; i < udts.length; i += 1){
                udtStats.push({
                    empty: 0,
                    match: 0,
                    nomatch: 0,
                    total: 0,
                    name: udts[i].name,
                    lower: udts[i].lower,
                    index: udts[i].index
                });
            }
        }
    };
    /* increment the designated operator hit count by one */ const incStat = function incStat(stat, state) {
        stat.total += 1;
        switch(state){
            case id.EMPTY:
                stat.empty += 1;
                break;
            case id.MATCH:
                stat.match += 1;
                break;
            case id.NOMATCH:
                stat.nomatch += 1;
                break;
            default:
                throw new Error(`${thisFileName}collect(): incStat(): unrecognized state: ${state}`);
        }
    };
    /* helper for toHtml() */ const displayRow = function displayRow(name, stat) {
        let html = '';
        html += '<tr>';
        html += `<td class="${style.CLASS_ACTIVE}">${name}</td>`;
        html += `<td class="${style.CLASS_EMPTY}">${stat.empty}</td>`;
        html += `<td class="${style.CLASS_MATCH}">${stat.match}</td>`;
        html += `<td class="${style.CLASS_NOMATCH}">${stat.nomatch}</td>`;
        html += `<td class="${style.CLASS_ACTIVE}">${stat.total}</td>`;
        html += '</tr>\n';
        return html;
    };
    const displayOpsOnly = function displayOpsOnly() {
        let html = '';
        html += displayRow('ALT', stats[id.ALT]);
        html += displayRow('CAT', stats[id.CAT]);
        html += displayRow('REP', stats[id.REP]);
        html += displayRow('RNM', stats[id.RNM]);
        html += displayRow('TRG', stats[id.TRG]);
        html += displayRow('TBS', stats[id.TBS]);
        html += displayRow('TLS', stats[id.TLS]);
        html += displayRow('UDT', stats[id.UDT]);
        html += displayRow('AND', stats[id.AND]);
        html += displayRow('NOT', stats[id.NOT]);
        html += displayRow('BKR', stats[id.BKR]);
        html += displayRow('BKA', stats[id.BKA]);
        html += displayRow('BKN', stats[id.BKN]);
        html += displayRow('ABG', stats[id.ABG]);
        html += displayRow('AEN', stats[id.AEN]);
        html += displayRow('totals', totals);
        return html;
    };
    /* helper for toHtml() */ const displayRules = function displayRules() {
        let html = '';
        html += '<tr><th></th><th></th><th></th><th></th><th></th></tr>\n';
        html += '<tr><th>rules</th><th></th><th></th><th></th><th></th></tr>\n';
        for(let i = 0; i < rules.length; i += 1){
            if (ruleStats[i].total > 0) {
                html += '<tr>';
                html += `<td class="${style.CLASS_ACTIVE}">${ruleStats[i].name}</td>`;
                html += `<td class="${style.CLASS_EMPTY}">${ruleStats[i].empty}</td>`;
                html += `<td class="${style.CLASS_MATCH}">${ruleStats[i].match}</td>`;
                html += `<td class="${style.CLASS_NOMATCH}">${ruleStats[i].nomatch}</td>`;
                html += `<td class="${style.CLASS_ACTIVE}">${ruleStats[i].total}</td>`;
                html += '</tr>\n';
            }
        }
        if (udts.length > 0) {
            html += '<tr><th></th><th></th><th></th><th></th><th></th></tr>\n';
            html += '<tr><th>udts</th><th></th><th></th><th></th><th></th></tr>\n';
            for(let i = 0; i < udts.length; i += 1){
                if (udtStats[i].total > 0) {
                    html += '<tr>';
                    html += `<td class="${style.CLASS_ACTIVE}">${udtStats[i].name}</td>`;
                    html += `<td class="${style.CLASS_EMPTY}">${udtStats[i].empty}</td>`;
                    html += `<td class="${style.CLASS_MATCH}">${udtStats[i].match}</td>`;
                    html += `<td class="${style.CLASS_NOMATCH}">${udtStats[i].nomatch}</td>`;
                    html += `<td class="${style.CLASS_ACTIVE}">${udtStats[i].total}</td>`;
                    html += '</tr>\n';
                }
            }
        }
        return html;
    };
    /* called only by the parser to validate a stats object */ this.validate = function validate(name) {
        let ret = false;
        if (typeof name === 'string' && nameId === name) {
            ret = true;
        }
        return ret;
    };
    /* no verification of input - only called by parser() */ this.init = function init(inputRules, inputUdts) {
        rules = inputRules;
        udts = inputUdts;
        clear();
    };
    /* This function is the main interaction with the parser. */ /* The parser calls it after each node has been traversed. */ this.collect = function collect(op, result) {
        incStat(totals, result.state, result.phraseLength);
        incStat(stats[op.type], result.state, result.phraseLength);
        if (op.type === id.RNM) {
            incStat(ruleStats[op.index], result.state, result.phraseLength);
        }
        if (op.type === id.UDT) {
            incStat(udtStats[op.index], result.state, result.phraseLength);
        }
    };
    // Display the statistics as an HTML table.
    // - *type*
    //   - "ops" - (default) display only the total hit counts for all operator types.
    //   - "index" - additionally, display the hit counts for the individual `RNM` and `UDT` operators ordered by index.
    //   - "hits" - additionally, display the hit counts for the individual `RNM` and `UDT` operators by hit count.
    //   - "alpha" - additionally, display the hit counts for the individual `RNM` and `UDT` operators by name alphabetically.
    // - *caption* - optional caption for the table
    this.toHtml = function toHtml(type, caption) {
        let html = '';
        html += `<table class="${style.CLASS_STATS}">\n`;
        if (typeof caption === 'string') {
            html += `<caption>${caption}</caption>\n`;
        }
        html += `<tr><th class="${style.CLASS_ACTIVE}">ops</th>\n`;
        html += `<th class="${style.CLASS_EMPTY}">EMPTY</th>\n`;
        html += `<th class="${style.CLASS_MATCH}">MATCH</th>\n`;
        html += `<th class="${style.CLASS_NOMATCH}">NOMATCH</th>\n`;
        html += `<th class="${style.CLASS_ACTIVE}">totals</th></tr>\n`;
        const test = true;
        while(test){
            if (type === undefined) {
                html += displayOpsOnly();
                break;
            }
            if (type === null) {
                html += displayOpsOnly();
                break;
            }
            if (type === 'ops') {
                html += displayOpsOnly();
                break;
            }
            if (type === 'index') {
                ruleStats.sort(sortIndex);
                if (udtStats.length > 0) {
                    udtStats.sort(sortIndex);
                }
                html += displayOpsOnly();
                html += displayRules();
                break;
            }
            if (type === 'hits') {
                ruleStats.sort(sortHits);
                if (udtStats.length > 0) {
                    udtStats.sort(sortIndex);
                }
                html += displayOpsOnly();
                html += displayRules();
                break;
            }
            if (type === 'alpha') {
                ruleStats.sort(sortAlpha);
                if (udtStats.length > 0) {
                    udtStats.sort(sortAlpha);
                }
                html += displayOpsOnly();
                html += displayRules();
                break;
            }
            break;
        }
        html += '</table>\n';
        return html;
    };
    // Display the stats table in a complete HTML5 page.
    this.toHtmlPage = function toHtmlPage(type, caption, title) {
        return utils.htmlToPage(this.toHtml(type, caption), title);
    };
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/trace.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/* eslint-disable func-names */ /* eslint-disable prefer-destructuring */ /* eslint-disable no-restricted-syntax */ /* eslint-disable guard-for-in */ /*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module provides a means of tracing the parser through the parse tree as it goes.
// It is the primary debugging facility for debugging both the SABNF grammar syntax
// and the input strings that are supposed to be valid grammar sentences.
// It is also a very informative and educational tool for understanding
// how a parser actually operates for a given language.
//
// Tracing is the process of generating and saving a record of information for each passage
// of the parser through a parse tree node. And since it traverses each node twice, once down the tree
// and once coming back up, there are two records for each node.
// This, obviously, has the potential of generating lots of records.
// And since these records are normally displayed on a web page
// it is important to have a means to limit the actual number of records generated to
// probably no more that a few thousand. This is almost always enough to find any errors.
// The problem is to get the *right* few thousand records.
// Therefore, this module has a number of ways of limiting and/or filtering, the number and type of records.
// Considerable effort has been made to make this filtering of the trace output as simple
// and intuitive as possible.
//
// However, the ability to filter the trace records, or for that matter even understand what they are
// and the information they contain, does require a minimum amount of understanding of the APG parsing
// method. The parse tree nodes are all represented by APG operators. They break down into two natural groups.
// - The `RNM` operators and `UDT` operators are named phrases.
// These are names chosen by the writer of the SABNF grammar to represent special phrases of interest.
// - All others collect, concatenate and otherwise manipulate various intermediate phrases along the way.
//
// There are separate means of filtering which of these operators in each of these two groups get traced.
// Let `trace` be an instantiated `trace.js` object.
// Prior to parsing the string, filtering the rules and UDTs can be defined as follows:
// ```
// trace.filter.rules["rulename"] = true;
//     /* trace rule name "rulename" */
// trace.filter.rules["udtname"]  = true;
//     /* trace UDT name "udtname" */
// trace.filter.rules["<ALL>"]    = true;
//     /* trace all rules and UDTs (the default) */
// trace.filter.rules["<NONE>"]   = true;
//     /* trace no rules or UDTS */
// ```
// If any rule or UDT name other than "&lt;ALL>" or "&lt;NONE>" is specified, all other names are turned off.
// Therefore, to be selective of rule names, a filter statement is required for each rule/UDT name desired.
//
// Filtering of the other operators follows a similar procedure.
// ```
// trace.filter.operators["TRG"] = true;
//     /* trace the terminal range, TRG, operators */
// trace.filter.operators["CAT"]  = true;
//     /* trace the concatenations, CAT, operators */
// trace.filter.operators["<ALL>"]    = true;
//     /* trace all operators */
// trace.filter.operators["<NONE>"]   = true;
//     /* trace no operators (the default) */
// ```
// If any operator name other than "&lt;ALL>" or "&lt;NONE>" is specified, all other names are turned off.
// Therefore, to be selective of operator names, a filter statement is required for each name desired.
//
// There is, additionally, a means for limiting the total number of filtered or saved trace records.
// See the function, `setMaxRecords(max)` below. This will result in only the last `max` records being saved.
//
// (See [`apg-examples`](https://github.com/ldthomas/apg-js-examples) for examples of using `trace.js`.)
module.exports = function exportTrace() {
    const utils = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/utilities.js [app-ssr] (ecmascript)");
    const style = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/style.js [app-ssr] (ecmascript)");
    const circular = new (__turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/circular-buffer.js [app-ssr] (ecmascript)"))();
    const id = __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)");
    const thisFileName = 'trace.js: ';
    const that = this;
    const MODE_HEX = 16;
    const MODE_DEC = 10;
    const MODE_ASCII = 8;
    const MODE_UNICODE = 32;
    const MAX_PHRASE = 80;
    const MAX_TLS = 5;
    const records = [];
    let maxRecords = 5000;
    let lastRecord = -1;
    let filteredRecords = 0;
    let treeDepth = 0;
    const recordStack = [];
    let chars = null;
    let rules = null;
    let udts = null;
    const operatorFilter = [];
    const ruleFilter = [];
    /* special trace table phrases */ const PHRASE_END = `<span class="${style.CLASS_LINEEND}">&bull;</span>`;
    const PHRASE_CONTINUE = `<span class="${style.CLASS_LINEEND}">&hellip;</span>`;
    const PHRASE_EMPTY = `<span class="${style.CLASS_EMPTY}">&#120634;</span>`;
    /* filter the non-RNM & non-UDT operators */ const initOperatorFilter = function() {
        const setOperators = function(set) {
            operatorFilter[id.ALT] = set;
            operatorFilter[id.CAT] = set;
            operatorFilter[id.REP] = set;
            operatorFilter[id.TLS] = set;
            operatorFilter[id.TBS] = set;
            operatorFilter[id.TRG] = set;
            operatorFilter[id.AND] = set;
            operatorFilter[id.NOT] = set;
            operatorFilter[id.BKR] = set;
            operatorFilter[id.BKA] = set;
            operatorFilter[id.BKN] = set;
            operatorFilter[id.ABG] = set;
            operatorFilter[id.AEN] = set;
        };
        let items = 0;
        // eslint-disable-next-line no-unused-vars
        for(const name in that.filter.operators){
            items += 1;
        }
        if (items === 0) {
            /* case 1: no operators specified: default: do not trace any operators */ setOperators(false);
            return;
        }
        for(const name in that.filter.operators){
            const upper = name.toUpperCase();
            if (upper === '<ALL>') {
                /* case 2: <all> operators specified: trace all operators ignore all other operator commands */ setOperators(true);
                return;
            }
            if (upper === '<NONE>') {
                /* case 3: <none> operators specified: trace NO operators ignore all other operator commands */ setOperators(false);
                return;
            }
        }
        setOperators(false);
        for(const name in that.filter.operators){
            const upper = name.toUpperCase();
            /* case 4: one or more individual operators specified: trace 'true' operators only */ if (upper === 'ALT') {
                operatorFilter[id.ALT] = that.filter.operators[name] === true;
            } else if (upper === 'CAT') {
                operatorFilter[id.CAT] = that.filter.operators[name] === true;
            } else if (upper === 'REP') {
                operatorFilter[id.REP] = that.filter.operators[name] === true;
            } else if (upper === 'AND') {
                operatorFilter[id.AND] = that.filter.operators[name] === true;
            } else if (upper === 'NOT') {
                operatorFilter[id.NOT] = that.filter.operators[name] === true;
            } else if (upper === 'TLS') {
                operatorFilter[id.TLS] = that.filter.operators[name] === true;
            } else if (upper === 'TBS') {
                operatorFilter[id.TBS] = that.filter.operators[name] === true;
            } else if (upper === 'TRG') {
                operatorFilter[id.TRG] = that.filter.operators[name] === true;
            } else if (upper === 'BKR') {
                operatorFilter[id.BKR] = that.filter.operators[name] === true;
            } else if (upper === 'BKA') {
                operatorFilter[id.BKA] = that.filter.operators[name] === true;
            } else if (upper === 'BKN') {
                operatorFilter[id.BKN] = that.filter.operators[name] === true;
            } else if (upper === 'ABG') {
                operatorFilter[id.ABG] = that.filter.operators[name] === true;
            } else if (upper === 'AEN') {
                operatorFilter[id.AEN] = that.filter.operators[name] === true;
            } else {
                throw new Error(`${thisFileName}initOpratorFilter: '${name}' not a valid operator name.` + ` Must be <all>, <none>, alt, cat, rep, tls, tbs, trg, and, not, bkr, bka or bkn`);
            }
        }
    };
    /* filter the rule and `UDT` named operators */ const initRuleFilter = function() {
        const setRules = function(set) {
            operatorFilter[id.RNM] = set;
            operatorFilter[id.UDT] = set;
            const count = rules.length + udts.length;
            ruleFilter.length = 0;
            for(let i = 0; i < count; i += 1){
                ruleFilter.push(set);
            }
        };
        let items;
        let i;
        const list = [];
        for(i = 0; i < rules.length; i += 1){
            list.push(rules[i].lower);
        }
        for(i = 0; i < udts.length; i += 1){
            list.push(udts[i].lower);
        }
        ruleFilter.length = 0;
        items = 0;
        // eslint-disable-next-line no-unused-vars
        for(const name in that.filter.rules){
            items += 1;
        }
        if (items === 0) {
            /* case 1: default to all rules & udts */ setRules(true);
            return;
        }
        for(const name in that.filter.rules){
            const lower = name.toLowerCase();
            if (lower === '<all>') {
                /* case 2: trace all rules ignore all other rule commands */ setRules(true);
                return;
            }
            if (lower === '<none>') {
                /* case 3: trace no rules */ setRules(false);
                return;
            }
        }
        /* case 4: trace only individually specified rules */ setRules(false);
        operatorFilter[id.RNM] = true;
        operatorFilter[id.UDT] = true;
        for(const name in that.filter.rules){
            const lower = name.toLowerCase();
            i = list.indexOf(lower);
            if (i < 0) {
                throw new Error(`${thisFileName}initRuleFilter: '${name}' not a valid rule or udt name`);
            }
            ruleFilter[i] = that.filter.rules[name] === true;
        }
    };
    /* used by other APG components to verify that they have a valid trace object */ this.traceObject = 'traceObject';
    this.filter = {
        operators: [],
        rules: []
    };
    // Set the maximum number of records to keep (default = 5000).
    // Each record number larger than `maxRecords`
    // will result in deleting the previously oldest record.
    // - `max`: maximum number of records to retain (default = 5000)
    // - `last`: last record number to retain, (default = -1 for (unknown) actual last record)
    this.setMaxRecords = function(max, last) {
        lastRecord = -1;
        if (typeof max === 'number' && max > 0) {
            maxRecords = Math.ceil(max);
        } else {
            maxRecords = 0;
            return;
        }
        if (typeof last === 'number') {
            lastRecord = Math.floor(last);
            if (lastRecord < 0) {
                lastRecord = -1;
            }
        }
    };
    // Returns `maxRecords` to the caller.
    this.getMaxRecords = function() {
        return maxRecords;
    };
    // Returns `lastRecord` to the caller.
    this.getLastRecord = function() {
        return lastRecord;
    };
    /* Called only by the `parser.js` object. No verification of input. */ this.init = function(rulesIn, udtsIn, charsIn) {
        records.length = 0;
        recordStack.length = 0;
        filteredRecords = 0;
        treeDepth = 0;
        chars = charsIn;
        rules = rulesIn;
        udts = udtsIn;
        initOperatorFilter();
        initRuleFilter();
        circular.init(maxRecords);
    };
    /* returns true if this records passes through the designated filter, false if the record is to be skipped */ const filterOps = function(op) {
        let ret = false;
        if (op.type === id.RNM) {
            if (operatorFilter[op.type] && ruleFilter[op.index]) {
                ret = true;
            } else {
                ret = false;
            }
        } else if (op.type === id.UDT) {
            if (operatorFilter[op.type] && ruleFilter[rules.length + op.index]) {
                ret = true;
            } else {
                ret = false;
            }
        } else {
            ret = operatorFilter[op.type];
        }
        return ret;
    };
    const filterRecords = function(record) {
        if (lastRecord === -1) {
            return true;
        }
        if (record <= lastRecord) {
            return true;
        }
        return false;
    };
    /* Collect the "down" record. */ this.down = function(op, state, offset, length, anchor, lookAround) {
        if (filterRecords(filteredRecords) && filterOps(op)) {
            recordStack.push(filteredRecords);
            records[circular.increment()] = {
                dirUp: false,
                depth: treeDepth,
                thisLine: filteredRecords,
                thatLine: undefined,
                opcode: op,
                state,
                phraseIndex: offset,
                phraseLength: length,
                lookAnchor: anchor,
                lookAround
            };
            filteredRecords += 1;
            treeDepth += 1;
        }
    };
    /* Collect the "up" record. */ this.up = function(op, state, offset, length, anchor, lookAround) {
        if (filterRecords(filteredRecords) && filterOps(op)) {
            const thisLine = filteredRecords;
            const thatLine = recordStack.pop();
            const thatRecord = circular.getListIndex(thatLine);
            if (thatRecord !== -1) {
                records[thatRecord].thatLine = thisLine;
            }
            treeDepth -= 1;
            records[circular.increment()] = {
                dirUp: true,
                depth: treeDepth,
                thisLine,
                thatLine,
                opcode: op,
                state,
                phraseIndex: offset,
                phraseLength: length,
                lookAnchor: anchor,
                lookAround
            };
            filteredRecords += 1;
        }
    };
    /* convert the trace records to a tree of nodes */ const toTreeObj = function() {
        /* private helper functions */ function nodeOpcode(node, opcode) {
            let name;
            let casetype;
            let modetype;
            if (opcode) {
                node.op = {
                    id: opcode.type,
                    name: utils.opcodeToString(opcode.type)
                };
                node.opData = undefined;
                switch(opcode.type){
                    case id.RNM:
                        node.opData = rules[opcode.index].name;
                        break;
                    case id.UDT:
                        node.opData = udts[opcode.index].name;
                        break;
                    case id.BKR:
                        if (opcode.index < rules.length) {
                            name = rules[opcode.index].name;
                        } else {
                            name = udts[opcode.index - rules.length].name;
                        }
                        casetype = opcode.bkrCase === id.BKR_MODE_CI ? '%i' : '%s';
                        modetype = opcode.bkrMode === id.BKR_MODE_UM ? '%u' : '%p';
                        node.opData = `\\\\${casetype}${modetype}${name}`;
                        break;
                    case id.TLS:
                        node.opData = [];
                        for(let i = 0; i < opcode.string.length; i += 1){
                            node.opData.push(opcode.string[i]);
                        }
                        break;
                    case id.TBS:
                        node.opData = [];
                        for(let i = 0; i < opcode.string.length; i += 1){
                            node.opData.push(opcode.string[i]);
                        }
                        break;
                    case id.TRG:
                        node.opData = [
                            opcode.min,
                            opcode.max
                        ];
                        break;
                    case id.REP:
                        node.opData = [
                            opcode.min,
                            opcode.max
                        ];
                        break;
                    default:
                        throw new Error('unrecognized opcode');
                }
            } else {
                node.op = {
                    id: undefined,
                    name: undefined
                };
                node.opData = undefined;
            }
        }
        function nodePhrase(state, index, length) {
            if (state === id.MATCH) {
                return {
                    index,
                    length
                };
            }
            if (state === id.NOMATCH) {
                return {
                    index,
                    length: 0
                };
            }
            if (state === id.EMPTY) {
                return {
                    index,
                    length: 0
                };
            }
            return null;
        }
        let nodeId = -1;
        function nodeDown(parent, record, depth) {
            const node = {
                // eslint-disable-next-line no-plusplus
                id: nodeId++,
                branch: -1,
                parent,
                up: false,
                down: false,
                depth,
                children: []
            };
            if (record) {
                node.down = true;
                node.state = {
                    id: record.state,
                    name: utils.stateToString(record.state)
                };
                node.phrase = null;
                nodeOpcode(node, record.opcode);
            } else {
                node.state = {
                    id: undefined,
                    name: undefined
                };
                node.phrase = nodePhrase();
                nodeOpcode(node, undefined);
            }
            return node;
        }
        function nodeUp(node, record) {
            if (record) {
                node.up = true;
                node.state = {
                    id: record.state,
                    name: utils.stateToString(record.state)
                };
                node.phrase = nodePhrase(record.state, record.phraseIndex, record.phraseLength);
                if (!node.down) {
                    nodeOpcode(node, record.opcode);
                }
            }
        }
        /* walk the final tree: label branches and count leaf nodes */ let leafNodes = 0;
        let depth = -1;
        let branchCount = 1;
        function walk(node) {
            depth += 1;
            node.branch = branchCount;
            if (depth > treeDepth) {
                treeDepth = depth;
            }
            if (node.children.length === 0) {
                leafNodes += 1;
            } else {
                for(let i = 0; i < node.children.length; i += 1){
                    if (i > 0) {
                        branchCount += 1;
                    }
                    node.children[i].leftMost = false;
                    node.children[i].rightMost = false;
                    if (node.leftMost) {
                        node.children[i].leftMost = i === 0;
                    }
                    if (node.rightMost) {
                        node.children[i].rightMost = i === node.children.length - 1;
                    }
                    walk(node.children[i]);
                }
            }
            depth -= 1;
        }
        function display(node, offset) {
            let name;
            const obj = {};
            obj.id = node.id;
            obj.branch = node.branch;
            obj.leftMost = node.leftMost;
            obj.rightMost = node.rightMost;
            name = node.state.name ? node.state.name : 'ACTIVE';
            obj.state = {
                id: node.state.id,
                name
            };
            name = node.op.name ? node.op.name : '?';
            obj.op = {
                id: node.op.id,
                name
            };
            if (typeof node.opData === 'string') {
                obj.opData = node.opData;
            } else if (Array.isArray(node.opData)) {
                obj.opData = [];
                for(let i = 0; i < node.opData.length; i += 1){
                    obj.opData[i] = node.opData[i];
                }
            } else {
                obj.opData = undefined;
            }
            if (node.phrase) {
                obj.phrase = {
                    index: node.phrase.index,
                    length: node.phrase.length
                };
            } else {
                obj.phrase = null;
            }
            obj.depth = node.depth;
            obj.children = [];
            for(let i = 0; i < node.children.length; i += 1){
                const c = i !== node.children.length - 1;
                obj.children[i] = display(node.children[i], offset, c);
            }
            return obj;
        }
        /* construct the tree beginning here */ const branch = [];
        let root;
        let node;
        let parent;
        let record;
        let firstRecord = true;
        /* push a dummy node so the root node will have a non-null parent */ const dummy = nodeDown(null, null, -1);
        branch.push(dummy);
        node = dummy;
        circular.forEach((lineIndex)=>{
            record = records[lineIndex];
            if (firstRecord) {
                firstRecord = false;
                if (record.depth > 0) {
                    /* push some dummy nodes to fill in for missing records */ const num = record.dirUp ? record.depth + 1 : record.depth;
                    for(let i = 0; i < num; i += 1){
                        parent = node;
                        node = nodeDown(node, null, i);
                        branch.push(node);
                        parent.children.push(node);
                    }
                }
            }
            if (record.dirUp) {
                /* handle the next record up */ node = branch.pop();
                nodeUp(node, record);
                node = branch[branch.length - 1];
            } else {
                /* handle the next record down */ parent = node;
                node = nodeDown(node, record, record.depth);
                branch.push(node);
                parent.children.push(node);
            }
        });
        /* if not at root, walk it up to root */ while(branch.length > 1){
            node = branch.pop();
            nodeUp(node, null);
        }
        /* maybe redundant or paranoid tests: these should never happen */ if (dummy.children.length === 0) {
            throw new Error('trace.toTree(): parse tree has no nodes');
        }
        if (branch.length === 0) {
            throw new Error('trace.toTree(): integrity check: dummy root node disappeared?');
        }
        /* if no record for start rule: find the pseudo root node (first dummy node above a real node) */ root = dummy.children[0];
        let prev = root;
        while(root && !root.down && !root.up){
            prev = root;
            root = root.children[0];
        }
        root = prev;
        /* walk the tree of nodes: label brances and count leaves */ root.leftMost = true;
        root.rightMost = true;
        walk(root);
        root.branch = 0;
        /* generate the exported object */ const obj = {};
        obj.string = [];
        for(let i = 0; i < chars.length; i += 1){
            obj.string[i] = chars[i];
        }
        /* generate the exported rule names */ obj.rules = [];
        for(let i = 0; i < rules.length; i += 1){
            obj.rules[i] = rules[i].name;
        }
        /* generate the exported UDT names */ obj.udts = [];
        for(let i = 0; i < udts.length; i += 1){
            obj.udts[i] = udts[i].name;
        }
        /* generate the ids */ obj.id = {};
        obj.id.ALT = {
            id: id.ALT,
            name: 'ALT'
        };
        obj.id.CAT = {
            id: id.CAT,
            name: 'CAT'
        };
        obj.id.REP = {
            id: id.REP,
            name: 'REP'
        };
        obj.id.RNM = {
            id: id.RNM,
            name: 'RNM'
        };
        obj.id.TLS = {
            id: id.TLS,
            name: 'TLS'
        };
        obj.id.TBS = {
            id: id.TBS,
            name: 'TBS'
        };
        obj.id.TRG = {
            id: id.TRG,
            name: 'TRG'
        };
        obj.id.UDT = {
            id: id.UDT,
            name: 'UDT'
        };
        obj.id.AND = {
            id: id.AND,
            name: 'AND'
        };
        obj.id.NOT = {
            id: id.NOT,
            name: 'NOT'
        };
        obj.id.BKR = {
            id: id.BKR,
            name: 'BKR'
        };
        obj.id.BKA = {
            id: id.BKA,
            name: 'BKA'
        };
        obj.id.BKN = {
            id: id.BKN,
            name: 'BKN'
        };
        obj.id.ABG = {
            id: id.ABG,
            name: 'ABG'
        };
        obj.id.AEN = {
            id: id.AEN,
            name: 'AEN'
        };
        obj.id.ACTIVE = {
            id: id.ACTIVE,
            name: 'ACTIVE'
        };
        obj.id.MATCH = {
            id: id.MATCH,
            name: 'MATCH'
        };
        obj.id.EMPTY = {
            id: id.EMPTY,
            name: 'EMPTY'
        };
        obj.id.NOMATCH = {
            id: id.NOMATCH,
            name: 'NOMATCH'
        };
        /* generate the max tree depth */ obj.treeDepth = treeDepth;
        /* generate the number of leaf nodes (branches) */ obj.leafNodes = leafNodes;
        /* generate the types of the left- and right-most branches */ let branchesIncomplete;
        if (root.down) {
            if (root.up) {
                branchesIncomplete = 'none';
            } else {
                branchesIncomplete = 'right';
            }
        } else if (root.up) {
            branchesIncomplete = 'left';
        } else {
            branchesIncomplete = 'both';
        }
        obj.branchesIncomplete = branchesIncomplete;
        obj.tree = display(root, root.depth, false);
        return obj;
    };
    // Returns the trace records as JSON parse tree object.
    // - stringify: if `true`, the object is 'stringified' before returning, otherwise, the object itself is returned.
    this.toTree = function(stringify) {
        const obj = toTreeObj();
        if (stringify) {
            return JSON.stringify(obj);
        }
        return obj;
    };
    // Translate the trace records to HTML format and create a complete HTML page for browser display.
    this.toHtmlPage = function(mode, caption, title) {
        return utils.htmlToPage(this.toHtml(mode, caption), title);
    };
    /* From here on down, these are just helper functions for `toHtml()`. */ const htmlHeader = function(mode, caption) {
        /* open the page */ /* write the HTML5 header with table style */ /* open the <table> tag */ let modeName;
        switch(mode){
            case MODE_HEX:
                modeName = 'hexadecimal';
                break;
            case MODE_DEC:
                modeName = 'decimal';
                break;
            case MODE_ASCII:
                modeName = 'ASCII';
                break;
            case MODE_UNICODE:
                modeName = 'UNICODE';
                break;
            default:
                throw new Error(`${thisFileName}htmlHeader: unrecognized mode: ${mode}`);
        }
        let header = '';
        header += `<p>display mode: ${modeName}</p>\n`;
        header += `<table class="${style.CLASS_TRACE}">\n`;
        if (typeof caption === 'string') {
            header += `<caption>${caption}</caption>`;
        }
        return header;
    };
    const htmlFooter = function() {
        let footer = '';
        /* close the </table> tag */ footer += '</table>\n';
        /* display a table legend */ footer += `<p class="${style.CLASS_MONOSPACE}">legend:<br>\n`;
        footer += '(a)&nbsp;-&nbsp;line number<br>\n';
        footer += '(b)&nbsp;-&nbsp;matching line number<br>\n';
        footer += '(c)&nbsp;-&nbsp;phrase offset<br>\n';
        footer += '(d)&nbsp;-&nbsp;phrase length<br>\n';
        footer += '(e)&nbsp;-&nbsp;tree depth<br>\n';
        footer += '(f)&nbsp;-&nbsp;operator state<br>\n';
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_ACTIVE}">&darr;</span>&nbsp;&nbsp;phrase opened<br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_MATCH}">&uarr;M</span> phrase matched<br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_EMPTY}">&uarr;E</span> empty phrase matched<br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_NOMATCH}">&uarr;N</span> phrase not matched<br>\n`;
        footer += 'operator&nbsp;-&nbsp;ALT, CAT, REP, RNM, TRG, TLS, TBS<sup>&dagger;</sup>, UDT, AND, NOT, BKA, BKN, BKR, ABG, AEN<sup>&Dagger;</sup><br>\n';
        footer += `phrase&nbsp;&nbsp;&nbsp;-&nbsp;up to ${MAX_PHRASE} characters of the phrase being matched<br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_MATCH}">matched characters</span><br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_LOOKAHEAD}">matched characters in look ahead mode</span><br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_LOOKBEHIND}">matched characters in look behind mode</span><br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_REMAINDER}">remainder characters(not yet examined by parser)</span><br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;<span class="${style.CLASS_CTRLCHAR}">control characters, TAB, LF, CR, etc. (ASCII mode only)</span><br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;${PHRASE_EMPTY} empty string<br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;${PHRASE_END} end of input string<br>\n`;
        footer += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;${PHRASE_CONTINUE} input string display truncated<br>\n`;
        footer += '</p>\n';
        footer += `<p class="${style.CLASS_MONOSPACE}">\n`;
        footer += '<sup>&dagger;</sup>original ABNF operators:<br>\n';
        footer += 'ALT - alternation<br>\n';
        footer += 'CAT - concatenation<br>\n';
        footer += 'REP - repetition<br>\n';
        footer += 'RNM - rule name<br>\n';
        footer += 'TRG - terminal range<br>\n';
        footer += 'TLS - terminal literal string (case insensitive)<br>\n';
        footer += 'TBS - terminal binary string (case sensitive)<br>\n';
        footer += '<br>\n';
        footer += '<sup>&Dagger;</sup>super set SABNF operators:<br>\n';
        footer += 'UDT - user-defined terminal<br>\n';
        footer += 'AND - positive look ahead<br>\n';
        footer += 'NOT - negative look ahead<br>\n';
        footer += 'BKA - positive look behind<br>\n';
        footer += 'BKN - negative look behind<br>\n';
        footer += 'BKR - back reference<br>\n';
        footer += 'ABG - anchor - begin of input string<br>\n';
        footer += 'AEN - anchor - end of input string<br>\n';
        footer += '</p>\n';
        return footer;
    };
    this.indent = function(depth) {
        let html = '';
        for(let i = 0; i < depth; i += 1){
            html += '.';
        }
        return html;
    };
    /* format the TRG operator */ const displayTrg = function(mode, op) {
        let html = '';
        if (op.type === id.TRG) {
            if (mode === MODE_HEX || mode === MODE_UNICODE) {
                let hex = op.min.toString(16).toUpperCase();
                if (hex.length % 2 !== 0) {
                    hex = `0${hex}`;
                }
                html += mode === MODE_HEX ? '%x' : 'U+';
                html += hex;
                hex = op.max.toString(16).toUpperCase();
                if (hex.length % 2 !== 0) {
                    hex = `0${hex}`;
                }
                html += `&ndash;${hex}`;
            } else {
                html = `%d${op.min.toString(10)}&ndash;${op.max.toString(10)}`;
            }
        }
        return html;
    };
    /* format the REP operator */ const displayRep = function(mode, op) {
        let html = '';
        if (op.type === id.REP) {
            if (mode === MODE_HEX) {
                let hex = op.min.toString(16).toUpperCase();
                if (hex.length % 2 !== 0) {
                    hex = `0${hex}`;
                }
                html = `x${hex}`;
                if (op.max < Infinity) {
                    hex = op.max.toString(16).toUpperCase();
                    if (hex.length % 2 !== 0) {
                        hex = `0${hex}`;
                    }
                } else {
                    hex = 'inf';
                }
                html += `&ndash;${hex}`;
            } else if (op.max < Infinity) {
                html = `${op.min.toString(10)}&ndash;${op.max.toString(10)}`;
            } else {
                html = `${op.min.toString(10)}&ndash;inf`;
            }
        }
        return html;
    };
    /* format the TBS operator */ const displayTbs = function(mode, op) {
        let html = '';
        if (op.type === id.TBS) {
            const len = Math.min(op.string.length, MAX_TLS * 2);
            if (mode === MODE_HEX || mode === MODE_UNICODE) {
                html += mode === MODE_HEX ? '%x' : 'U+';
                for(let i = 0; i < len; i += 1){
                    let hex;
                    if (i > 0) {
                        html += '.';
                    }
                    hex = op.string[i].toString(16).toUpperCase();
                    if (hex.length % 2 !== 0) {
                        hex = `0${hex}`;
                    }
                    html += hex;
                }
            } else {
                html = '%d';
                for(let i = 0; i < len; i += 1){
                    if (i > 0) {
                        html += '.';
                    }
                    html += op.string[i].toString(10);
                }
            }
            if (len < op.string.length) {
                html += PHRASE_CONTINUE;
            }
        }
        return html;
    };
    /* format the TLS operator */ const displayTls = function(mode, op) {
        let html = '';
        if (op.type === id.TLS) {
            const len = Math.min(op.string.length, MAX_TLS);
            if (mode === MODE_HEX || mode === MODE_DEC) {
                let charu;
                let charl;
                let base;
                if (mode === MODE_HEX) {
                    html = '%x';
                    base = 16;
                } else {
                    html = '%d';
                    base = 10;
                }
                for(let i = 0; i < len; i += 1){
                    if (i > 0) {
                        html += '.';
                    }
                    charl = op.string[i];
                    if (charl >= 97 && charl <= 122) {
                        charu = charl - 32;
                        html += `${charu.toString(base)}/${charl.toString(base)}`.toUpperCase();
                    } else if (charl >= 65 && charl <= 90) {
                        charu = charl;
                        charl += 32;
                        html += `${charu.toString(base)}/${charl.toString(base)}`.toUpperCase();
                    } else {
                        html += charl.toString(base).toUpperCase();
                    }
                }
                if (len < op.string.length) {
                    html += PHRASE_CONTINUE;
                }
            } else {
                html = '"';
                for(let i = 0; i < len; i += 1){
                    html += utils.asciiChars[op.string[i]];
                }
                if (len < op.string.length) {
                    html += PHRASE_CONTINUE;
                }
                html += '"';
            }
        }
        return html;
    };
    const subPhrase = function(mode, charsArg, index, length, prev) {
        if (length === 0) {
            return '';
        }
        let phrase = '';
        const comma = prev ? ',' : '';
        switch(mode){
            case MODE_HEX:
                phrase = comma + utils.charsToHex(charsArg, index, length);
                break;
            case MODE_DEC:
                if (prev) {
                    return `,${utils.charsToDec(charsArg, index, length)}`;
                }
                phrase = comma + utils.charsToDec(charsArg, index, length);
                break;
            case MODE_UNICODE:
                phrase = utils.charsToUnicode(charsArg, index, length);
                break;
            case MODE_ASCII:
            default:
                phrase = utils.charsToAsciiHtml(charsArg, index, length);
                break;
        }
        return phrase;
    };
    /* display phrases matched in look-behind mode */ const displayBehind = function(mode, charsArg, state, index, length, anchor) {
        let html = '';
        let beg1;
        let len1;
        let beg2;
        let len2;
        let lastchar = PHRASE_END;
        const spanBehind = `<span class="${style.CLASS_LOOKBEHIND}">`;
        const spanRemainder = `<span class="${style.CLASS_REMAINDER}">`;
        const spanend = '</span>';
        let prev = false;
        switch(state){
            case id.EMPTY:
                html += PHRASE_EMPTY;
            /* // eslint-disable-next-line no-fallthrough */ case id.NOMATCH:
            case id.MATCH:
            case id.ACTIVE:
                beg1 = index - length;
                len1 = anchor - beg1;
                beg2 = anchor;
                len2 = charsArg.length - beg2;
                break;
            default:
                throw new Error('unrecognized state');
        }
        lastchar = PHRASE_END;
        if (len1 > MAX_PHRASE) {
            len1 = MAX_PHRASE;
            lastchar = PHRASE_CONTINUE;
            len2 = 0;
        } else if (len1 + len2 > MAX_PHRASE) {
            lastchar = PHRASE_CONTINUE;
            len2 = MAX_PHRASE - len1;
        }
        if (len1 > 0) {
            html += spanBehind;
            html += subPhrase(mode, charsArg, beg1, len1, prev);
            html += spanend;
            prev = true;
        }
        if (len2 > 0) {
            html += spanRemainder;
            html += subPhrase(mode, charsArg, beg2, len2, prev);
            html += spanend;
        }
        return html + lastchar;
    };
    const displayForward = function(mode, charsArg, state, index, length, spanAhead) {
        let html = '';
        let beg1;
        let len1;
        let beg2;
        let len2;
        let lastchar = PHRASE_END;
        const spanRemainder = `<span class="${style.CLASS_REMAINDER}">`;
        const spanend = '</span>';
        let prev = false;
        switch(state){
            case id.EMPTY:
                html += PHRASE_EMPTY;
            /* // eslint-disable-next-line no-fallthrough */ case id.NOMATCH:
            case id.ACTIVE:
                beg1 = index;
                len1 = 0;
                beg2 = index;
                len2 = charsArg.length - beg2;
                break;
            case id.MATCH:
                beg1 = index;
                len1 = length;
                beg2 = index + len1;
                len2 = charsArg.length - beg2;
                break;
            default:
                throw new Error('unrecognized state');
        }
        lastchar = PHRASE_END;
        if (len1 > MAX_PHRASE) {
            len1 = MAX_PHRASE;
            lastchar = PHRASE_CONTINUE;
            len2 = 0;
        } else if (len1 + len2 > MAX_PHRASE) {
            lastchar = PHRASE_CONTINUE;
            len2 = MAX_PHRASE - len1;
        }
        if (len1 > 0) {
            html += spanAhead;
            html += subPhrase(mode, charsArg, beg1, len1, prev);
            html += spanend;
            prev = true;
        }
        if (len2 > 0) {
            html += spanRemainder;
            html += subPhrase(mode, charsArg, beg2, len2, prev);
            html += spanend;
        }
        return html + lastchar;
    };
    /* display phrases matched in look-ahead mode */ const displayAhead = function(mode, charsArg, state, index, length) {
        const spanAhead = `<span class="${style.CLASS_LOOKAHEAD}">`;
        return displayForward(mode, charsArg, state, index, length, spanAhead);
    };
    /* display phrases matched in normal parsing mode */ const displayNone = function(mode, charsArg, state, index, length) {
        const spanAhead = `<span class="${style.CLASS_MATCH}">`;
        return displayForward(mode, charsArg, state, index, length, spanAhead);
    };
    /* Returns the filtered records, formatted as an HTML table. */ const htmlTable = function(mode) {
        if (rules === null) {
            return '';
        }
        let html = '';
        let thisLine;
        let thatLine;
        let lookAhead;
        let lookBehind;
        let lookAround;
        let anchor;
        html += '<tr><th>(a)</th><th>(b)</th><th>(c)</th><th>(d)</th><th>(e)</th><th>(f)</th>';
        html += '<th>operator</th><th>phrase</th></tr>\n';
        circular.forEach((lineIndex)=>{
            const line = records[lineIndex];
            thisLine = line.thisLine;
            thatLine = line.thatLine !== undefined ? line.thatLine : '--';
            lookAhead = false;
            lookBehind = false;
            lookAround = false;
            if (line.lookAround === id.LOOKAROUND_AHEAD) {
                lookAhead = true;
                lookAround = true;
                anchor = line.lookAnchor;
            }
            if (line.opcode.type === id.AND || line.opcode.type === id.NOT) {
                lookAhead = true;
                lookAround = true;
                anchor = line.phraseIndex;
            }
            if (line.lookAround === id.LOOKAROUND_BEHIND) {
                lookBehind = true;
                lookAround = true;
                anchor = line.lookAnchor;
            }
            if (line.opcode.type === id.BKA || line.opcode.type === id.BKN) {
                lookBehind = true;
                lookAround = true;
                anchor = line.phraseIndex;
            }
            html += '<tr>';
            html += `<td>${thisLine}</td><td>${thatLine}</td>`;
            html += `<td>${line.phraseIndex}</td>`;
            html += `<td>${line.phraseLength}</td>`;
            html += `<td>${line.depth}</td>`;
            html += '<td>';
            switch(line.state){
                case id.ACTIVE:
                    html += `<span class="${style.CLASS_ACTIVE}">&darr;&nbsp;</span>`;
                    break;
                case id.MATCH:
                    html += `<span class="${style.CLASS_MATCH}">&uarr;M</span>`;
                    break;
                case id.NOMATCH:
                    html += `<span class="${style.CLASS_NOMATCH}">&uarr;N</span>`;
                    break;
                case id.EMPTY:
                    html += `<span class="${style.CLASS_EMPTY}">&uarr;E</span>`;
                    break;
                default:
                    html += `<span class="${style.CLASS_ACTIVE}">--</span>`;
                    break;
            }
            html += '</td>';
            html += '<td>';
            html += that.indent(line.depth);
            if (lookAhead) {
                html += `<span class="${style.CLASS_LOOKAHEAD}">`;
            } else if (lookBehind) {
                html += `<span class="${style.CLASS_LOOKBEHIND}">`;
            }
            html += utils.opcodeToString(line.opcode.type);
            if (line.opcode.type === id.RNM) {
                html += `(${rules[line.opcode.index].name}) `;
            }
            if (line.opcode.type === id.BKR) {
                const casetype = line.opcode.bkrCase === id.BKR_MODE_CI ? '%i' : '%s';
                const modetype = line.opcode.bkrMode === id.BKR_MODE_UM ? '%u' : '%p';
                html += `(\\${casetype}${modetype}${rules[line.opcode.index].name}) `;
            }
            if (line.opcode.type === id.UDT) {
                html += `(${udts[line.opcode.index].name}) `;
            }
            if (line.opcode.type === id.TRG) {
                html += `(${displayTrg(mode, line.opcode)}) `;
            }
            if (line.opcode.type === id.TBS) {
                html += `(${displayTbs(mode, line.opcode)}) `;
            }
            if (line.opcode.type === id.TLS) {
                html += `(${displayTls(mode, line.opcode)}) `;
            }
            if (line.opcode.type === id.REP) {
                html += `(${displayRep(mode, line.opcode)}) `;
            }
            if (lookAround) {
                html += '</span>';
            }
            html += '</td>';
            html += '<td>';
            if (lookBehind) {
                html += displayBehind(mode, chars, line.state, line.phraseIndex, line.phraseLength, anchor);
            } else if (lookAhead) {
                html += displayAhead(mode, chars, line.state, line.phraseIndex, line.phraseLength);
            } else {
                html += displayNone(mode, chars, line.state, line.phraseIndex, line.phraseLength);
            }
            html += '</td></tr>\n';
        });
        html += '<tr><th>(a)</th><th>(b)</th><th>(c)</th><th>(d)</th><th>(e)</th><th>(f)</th>';
        html += '<th>operator</th><th>phrase</th></tr>\n';
        html += '</table>\n';
        return html;
    };
    // Translate the trace records to HTML format.
    // - *modearg* - can be `"ascii"`, `"decimal"`, `"hexadecimal"` or `"unicode"`.
    // Determines the format of the string character code display.
    // - *caption* - optional caption for the HTML table.
    this.toHtml = function(modearg, caption) {
        /* writes the trace records as a table in a complete html page */ let mode = MODE_ASCII;
        if (typeof modearg === 'string' && modearg.length >= 3) {
            const modein = modearg.toLowerCase().slice(0, 3);
            if (modein === 'hex') {
                mode = MODE_HEX;
            } else if (modein === 'dec') {
                mode = MODE_DEC;
            } else if (modein === 'uni') {
                mode = MODE_UNICODE;
            }
        }
        let html = '';
        html += htmlHeader(mode, caption);
        html += htmlTable(mode);
        html += htmlFooter();
        return html;
    };
};
}),
"[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/node-exports.js [app-ssr] (ecmascript)", ((__turbopack_context__, module, exports) => {

/*  *************************************************************************************
 *   copyright: Copyright (c) 2021 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *   ********************************************************************************* */ // This module serves to export all library objects and object constructors with the `require("apg-lib")` statement.
// For example, to create a new parser in your program,
// ````
// let apglib = require("../apg-lib/node-exports");
// let my-parser = new apglib.parser();
// ````
module.exports = {
    ast: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/ast.js [app-ssr] (ecmascript)"),
    circular: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/circular-buffer.js [app-ssr] (ecmascript)"),
    ids: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/identifiers.js [app-ssr] (ecmascript)"),
    parser: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/parser.js [app-ssr] (ecmascript)"),
    stats: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/stats.js [app-ssr] (ecmascript)"),
    trace: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/trace.js [app-ssr] (ecmascript)"),
    utils: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/utilities.js [app-ssr] (ecmascript)"),
    emitcss: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/emitcss.js [app-ssr] (ecmascript)"),
    style: __turbopack_context__.r("[project]/node_modules/.pnpm/apg-js@4.4.0/node_modules/apg-js/src/apg-lib/style.js [app-ssr] (ecmascript)")
};
}),
];

//# sourceMappingURL=a251c_apg-js_src_d51de41f._.js.map