module.exports = [
"[project]/frontend/hooks/use-animations.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useAnimationInView",
    ()=>useAnimationInView,
    "useHoverEffect",
    ()=>useHoverEffect,
    "useParallaxEffect",
    ()=>useParallaxEffect,
    "useParallaxSection",
    ()=>useParallaxSection,
    "useScrollDirection",
    ()=>useScrollDirection,
    "useScrollProgressBar",
    ()=>useScrollProgressBar,
    "useScrollYProgress",
    ()=>useScrollYProgress,
    "useWindowSize",
    ()=>useWindowSize
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$utils$2f$use$2d$in$2d$view$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/utils/use-in-view.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$value$2f$use$2d$scroll$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/value/use-scroll.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$value$2f$use$2d$transform$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/value/use-transform.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$utils$2f$use$2d$motion$2d$value$2d$event$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/utils/use-motion-value-event.mjs [app-ssr] (ecmascript)");
"use client";
;
;
function useAnimationInView(threshold = 0.1) {
    const ref = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const isInView = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$utils$2f$use$2d$in$2d$view$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useInView"])(ref, {
        once: true,
        amount: threshold
    });
    return {
        ref,
        isInView
    };
}
function useParallaxEffect() {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Create a global CSS variable for scroll position
        const handleScroll = ()=>{
            document.documentElement.style.setProperty("--scroll", window.scrollY.toString());
        };
        // Initialize on mount
        handleScroll();
        window.addEventListener("scroll", handleScroll);
        return ()=>window.removeEventListener("scroll", handleScroll);
    }, []);
}
function useParallaxSection(direction = "up", intensity = 0.2) {
    const ref = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const { scrollYProgress } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$value$2f$use$2d$scroll$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useScroll"])({
        target: ref,
        offset: [
            "start end",
            "end start"
        ]
    });
    // Calculate transform based on direction
    const y = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$value$2f$use$2d$transform$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTransform"])(scrollYProgress, [
        0,
        1
    ], direction === "up" ? [
        intensity * 100,
        0
    ] : [
        0,
        intensity * 100
    ]);
    const opacity = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$value$2f$use$2d$transform$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTransform"])(scrollYProgress, [
        0,
        0.2,
        0.8,
        1
    ], [
        0,
        1,
        1,
        0
    ]);
    return {
        ref,
        y,
        opacity
    };
}
function useScrollProgressBar() {
    const [progress, setProgress] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const updateProgress = ()=>{
            // Calculate how much the user has scrolled through the page
            const scrollTop = window.scrollY;
            const docHeight = document.documentElement.scrollHeight - window.innerHeight;
            const scrollPercent = scrollTop / docHeight * 100;
            setProgress(scrollPercent);
        };
        window.addEventListener("scroll", updateProgress);
        return ()=>window.removeEventListener("scroll", updateProgress);
    }, []);
    return progress;
}
function useWindowSize() {
    const [windowSize, setWindowSize] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        width: ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : 0,
        height: ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : 0
    });
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleResize = ()=>{
            setWindowSize({
                width: window.innerWidth,
                height: window.innerHeight
            });
        };
        window.addEventListener("resize", handleResize);
        return ()=>window.removeEventListener("resize", handleResize);
    }, []);
    return windowSize;
}
function useScrollDirection() {
    const [scrollDirection, setScrollDirection] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("up");
    const [lastScrollY, setLastScrollY] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const updateScrollDirection = ()=>{
            const scrollY = window.scrollY;
            const direction = scrollY > lastScrollY ? "down" : "up";
            if (direction !== scrollDirection && Math.abs(scrollY - lastScrollY) > 10) {
                setScrollDirection(direction);
            }
            setLastScrollY(scrollY > 0 ? scrollY : 0);
        };
        window.addEventListener("scroll", updateScrollDirection);
        return ()=>window.removeEventListener("scroll", updateScrollDirection);
    }, [
        scrollDirection,
        lastScrollY
    ]);
    return scrollDirection;
}
function useHoverEffect() {
    const [isHovered, setIsHovered] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const handlers = {
        onMouseEnter: ()=>setIsHovered(true),
        onMouseLeave: ()=>setIsHovered(false),
        onTouchStart: ()=>setIsHovered(true),
        onTouchEnd: ()=>setIsHovered(false)
    };
    return {
        isHovered,
        handlers
    };
}
function useScrollYProgress(ref) {
    const { scrollYProgress } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$value$2f$use$2d$scroll$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useScroll"])({
        target: ref,
        offset: [
            "start start",
            "end end"
        ]
    });
    const [progress, setProgress] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$utils$2f$use$2d$motion$2d$value$2d$event$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMotionValueEvent"])(scrollYProgress, "change", (latest)=>{
        setProgress(latest);
    });
    return progress;
}
}),
"[project]/frontend/services/ws-manager.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ConnectionStatus",
    ()=>ConnectionStatus,
    "wsManager",
    ()=>wsManager
]);
var ConnectionStatus = /*#__PURE__*/ function(ConnectionStatus) {
    ConnectionStatus["CONNECTING"] = "connecting";
    ConnectionStatus["CONNECTED"] = "connected";
    ConnectionStatus["DISCONNECTED"] = "disconnected";
    ConnectionStatus["RECONNECTING"] = "reconnecting";
    ConnectionStatus["ERROR"] = "error";
    return ConnectionStatus;
}({});
class WebSocketManager {
    static instance;
    connections = new Map();
    connectionStatus = new Map();
    subscriptions = new Map();
    statusListeners = new Map();
    reconnectTimeouts = new Map();
    reconnectAttempts = new Map();
    messageQueues = new Map();
    maxReconnectAttempts = 5;
    reconnectDelay = 1000;
    debug = ("TURBOPACK compile-time value", "development") !== "production";
    // Get singleton instance
    static getInstance() {
        if (!WebSocketManager.instance) {
            WebSocketManager.instance = new WebSocketManager();
        }
        return WebSocketManager.instance;
    }
    // Connect to a WebSocket server
    connect(url, connectionId = "default") {
        // If already connected or connecting, do nothing
        if (this.connections.has(connectionId) && (this.connectionStatus.get(connectionId) === "connected" || this.connectionStatus.get(connectionId) === "connecting")) {
            return;
        }
        // Initialize message queue for this connection if it doesn't exist
        if (!this.messageQueues.has(connectionId)) {
            this.messageQueues.set(connectionId, []);
        }
        // Update connection status
        this.connectionStatus.set(connectionId, "connecting");
        this.notifyStatusListeners(connectionId);
        // Create a new WebSocket connection
        // Note: WebSocket in browser automatically includes cookies for same-origin requests
        try {
            // Get access token from cookies if available
            const getCookie = (name)=>{
                const value = `; ${document.cookie}`;
                const parts = value.split(`; ${name}=`);
                if (parts.length === 2) return parts.pop()?.split(';').shift();
                return null;
            };
            const accessToken = getCookie('accessToken');
            // Add token to URL if available (for authentication)
            let authUrl = url;
            if (accessToken) {
                const separator = url.includes('?') ? '&' : '?';
                authUrl = `${url}${separator}token=${accessToken}`;
            }
            const ws = new WebSocket(authUrl);
            // Set up event handlers
            ws.onopen = ()=>this.handleOpen(connectionId);
            ws.onmessage = (event)=>this.handleMessage(event, connectionId);
            ws.onclose = ()=>this.handleClose(connectionId, url);
            ws.onerror = (error)=>this.handleError(error, connectionId);
            // Store the connection
            this.connections.set(connectionId, ws);
        } catch (error) {
            console.error(`Error creating WebSocket connection for ${connectionId}:`, error);
            this.handleError(new Event("error"), connectionId);
        }
    }
    // Handle WebSocket open event
    handleOpen(connectionId) {
        this.connectionStatus.set(connectionId, "connected");
        this.reconnectAttempts.set(connectionId, 0); // Reset reconnect attempts
        this.notifyStatusListeners(connectionId);
        // Process any queued messages
        this.processMessageQueue(connectionId);
    }
    // Process queued messages
    processMessageQueue(connectionId) {
        if (!this.messageQueues.has(connectionId)) return;
        const queue = this.messageQueues.get(connectionId);
        if (queue.length === 0) return;
        // Send all queued messages
        while(queue.length > 0){
            const message = queue.shift();
            this.sendMessageImmediate(message, connectionId);
        }
    }
    // Handle WebSocket message event
    handleMessage(event, connectionId) {
        try {
            const data = JSON.parse(event.data);
            // Handle different message formats
            let streamKey = data.stream || "default";
            // Special handling for support ticket messages
            if (data.method === "reply" && data.payload?.id) {
                streamKey = `ticket-${data.payload.id}`;
            } else if (data.method === "update" && data.payload?.id) {
                streamKey = `ticket-${data.payload.id}`;
            }
            // Notify subscribers
            if (this.subscriptions.has(connectionId)) {
                const connectionSubscriptions = this.subscriptions.get(connectionId);
                if (connectionSubscriptions.has(streamKey)) {
                    const callbacks = connectionSubscriptions.get(streamKey);
                    callbacks.forEach((callback)=>{
                        try {
                            callback(data.data || data);
                        } catch (error) {
                            console.error(`Error in callback for ${streamKey}:`, error);
                        }
                    });
                }
            }
        } catch (error) {
            console.error(`Error parsing WebSocket message for ${connectionId}:`, error);
        }
    }
    // Handle WebSocket close event
    handleClose(connectionId, url) {
        this.connections.delete(connectionId);
        this.connectionStatus.set(connectionId, "disconnected");
        this.notifyStatusListeners(connectionId);
        // Attempt to reconnect
        this.reconnect(connectionId, url);
    }
    // Handle WebSocket error event
    handleError(error, connectionId) {
        console.error(`WebSocket error for ${connectionId}:`, error);
    }
    // Attempt to reconnect to the WebSocket server
    reconnect(connectionId, url) {
        // Clear any existing reconnect timeout
        if (this.reconnectTimeouts.has(connectionId)) {
            clearTimeout(this.reconnectTimeouts.get(connectionId));
        }
        // Get current reconnect attempts
        const attempts = this.reconnectAttempts.get(connectionId) || 0;
        // Check if we've exceeded the maximum number of reconnect attempts
        if (attempts >= this.maxReconnectAttempts) {
            console.error(`Maximum reconnect attempts (${this.maxReconnectAttempts}) reached for ${connectionId}`);
            return;
        }
        // Update connection status
        this.connectionStatus.set(connectionId, "reconnecting");
        this.notifyStatusListeners(connectionId);
        // Calculate exponential backoff delay
        const delay = Math.min(this.reconnectDelay * Math.pow(2, attempts), 30000); // Max 30 seconds
        // Set a timeout to reconnect
        const timeout = setTimeout(()=>{
            this.reconnectAttempts.set(connectionId, attempts + 1);
            this.connect(url, connectionId);
        }, delay);
        // Store the timeout
        this.reconnectTimeouts.set(connectionId, timeout);
    }
    // Subscribe to a WebSocket stream
    subscribe(streamKey, callback, connectionId = "default") {
        // Initialize subscriptions map for this connection if it doesn't exist
        if (!this.subscriptions.has(connectionId)) {
            this.subscriptions.set(connectionId, new Map());
        }
        // Initialize callbacks set for this stream if it doesn't exist
        const connectionSubscriptions = this.subscriptions.get(connectionId);
        if (!connectionSubscriptions.has(streamKey)) {
            connectionSubscriptions.set(streamKey, new Set());
        }
        // Add the callback to the set
        connectionSubscriptions.get(streamKey).add(callback);
    }
    // Unsubscribe from a WebSocket stream
    unsubscribe(streamKey, callback, connectionId = "default") {
        if (this.subscriptions.has(connectionId)) {
            const connectionSubscriptions = this.subscriptions.get(connectionId);
            if (connectionSubscriptions.has(streamKey)) {
                const callbacks = connectionSubscriptions.get(streamKey);
                callbacks.delete(callback);
                // If no more callbacks, remove the stream
                if (callbacks.size === 0) {
                    connectionSubscriptions.delete(streamKey);
                }
            }
        }
    }
    // Send a message to the WebSocket server (queues if not connected)
    sendMessage(message, connectionId = "default") {
        // Check if the connection is ready
        if (this.connections.has(connectionId) && this.connectionStatus.get(connectionId) === "connected") {
            // Connection is ready, send immediately
            this.sendMessageImmediate(message, connectionId);
        } else {
            // Connection is not ready, queue the message
            if (!this.messageQueues.has(connectionId)) {
                this.messageQueues.set(connectionId, []);
            }
            this.messageQueues.get(connectionId).push(message);
        }
    }
    // Send a message immediately without queueing
    sendMessageImmediate(message, connectionId) {
        const connection = this.connections.get(connectionId);
        if (connection && connection.readyState === WebSocket.OPEN) {
            const messageStr = JSON.stringify(message);
            connection.send(messageStr);
        } else {
            console.error(`Cannot send message: WebSocket for ${connectionId} is not open`);
        }
    }
    // Add a status listener
    addStatusListener(callback, connectionId = "default") {
        // Initialize status listeners set for this connection if it doesn't exist
        if (!this.statusListeners.has(connectionId)) {
            this.statusListeners.set(connectionId, new Set());
        }
        // Add the callback to the set
        this.statusListeners.get(connectionId).add(callback);
        // Notify the listener of the current status
        const status = this.connectionStatus.get(connectionId) || "disconnected";
        callback(status);
    }
    // Remove a status listener
    removeStatusListener(callback, connectionId = "default") {
        if (this.statusListeners.has(connectionId)) {
            this.statusListeners.get(connectionId).delete(callback);
        }
    }
    // Notify all status listeners of a status change
    notifyStatusListeners(connectionId) {
        const status = this.connectionStatus.get(connectionId) || "disconnected";
        if (this.statusListeners.has(connectionId)) {
            this.statusListeners.get(connectionId).forEach((callback)=>{
                try {
                    callback(status);
                } catch (error) {
                    console.error(`Error in status listener for ${connectionId}:`, error);
                }
            });
        }
    }
    // Get the current connection status
    getStatus(connectionId = "default") {
        return this.connectionStatus.get(connectionId) || "disconnected";
    }
    // Close a WebSocket connection
    close(connectionId = "default") {
        // Clear any reconnect timeouts for this connection
        const timeout = this.reconnectTimeouts.get(connectionId);
        if (timeout) {
            clearTimeout(timeout);
            this.reconnectTimeouts.delete(connectionId);
        }
        const connection = this.connections.get(connectionId);
        if (connection) {
            connection.close();
            this.connections.delete(connectionId);
            this.connectionStatus.set(connectionId, "disconnected");
            this.notifyStatusListeners(connectionId);
            // Clear associated data
            this.subscriptions.delete(connectionId);
            this.messageQueues.delete(connectionId);
            this.reconnectAttempts.delete(connectionId);
        }
    }
    // Close all WebSocket connections
    closeAll() {
        this.connections.forEach((connection, connectionId)=>{
            this.close(connectionId);
        });
    }
}
const wsManager = WebSocketManager.getInstance();
}),
"[project]/frontend/services/tickers-ws.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "TickersWebSocketManager",
    ()=>TickersWebSocketManager,
    "tickersWs",
    ()=>tickersWs
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/services/ws-manager.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/extensions.ts [app-ssr] (ecmascript)");
;
;
class TickersWebSocketManager {
    static instance;
    // WebSocket connections
    spotWs = null;
    ecoWs = null;
    futuresWs = null;
    // Connection states
    spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    // Subscription counts to track when we can close connections
    spotSubscriptionCount = 0;
    ecoSubscriptionCount = 0;
    futuresSubscriptionCount = 0;
    // Callbacks
    spotCallbacks = new Set();
    ecoCallbacks = new Set();
    futuresCallbacks = new Set();
    connectionStatusCallbacks = new Set();
    // Data cache
    spotData = {};
    ecoData = {};
    futuresData = {};
    // Connection promises to prevent multiple connection attempts
    spotConnectionPromise = null;
    ecoConnectionPromise = null;
    futuresConnectionPromise = null;
    // Connection timeouts to prevent premature closing
    spotCloseTimeout = null;
    ecoCloseTimeout = null;
    futuresCloseTimeout = null;
    isInitialized = false;
    isClosing = false;
    constructor(){}
    static getInstance() {
        if (!TickersWebSocketManager.instance) {
            TickersWebSocketManager.instance = new TickersWebSocketManager();
        }
        return TickersWebSocketManager.instance;
    }
    initialize() {
        if (this.isInitialized) return;
        this.isInitialized = true;
        this.isClosing = false;
    // We no longer connect all at initialization
    // Instead, connections are made on-demand when subscribed
    }
    createWebSocketUrl(path) {
        // Use the environment variable if available, otherwise construct from window location
        if (typeof process !== "undefined" && process.env.NEXT_PUBLIC_WEBSOCKET_URL) {
            return `${process.env.NEXT_PUBLIC_WEBSOCKET_URL}/${path}`;
        }
        const protocol = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : "ws:";
        const host = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : "localhost:3000";
        return `${protocol}//${host}/${path}`;
    }
    // Get overall connection status (for UI indicators)
    getConnectionStatus() {
        // If any connection is in ERROR state, return ERROR
        if (this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR || this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR || this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
        }
        // If any active connection is CONNECTING, return CONNECTING
        if (this.spotSubscriptionCount > 0 && this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING || this.ecoSubscriptionCount > 0 && this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING || this.futuresSubscriptionCount > 0 && this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        }
        // If all active connections are CONNECTED, return CONNECTED
        if ((this.spotSubscriptionCount === 0 || this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) && (this.ecoSubscriptionCount === 0 || this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) && (this.futuresSubscriptionCount === 0 || this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED)) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
        }
        // Otherwise, return DISCONNECTED
        return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    }
    // Connect to spot WebSocket
    connectSpot() {
        // If already connecting, return the existing promise
        if (this.spotConnectionPromise) {
            return this.spotConnectionPromise;
        }
        // If already connected, return resolved promise
        if (this.spotWs && this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            return Promise.resolve();
        }
        // Create new connection
        this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        this.updateAllConnectionStatus();
        this.spotConnectionPromise = new Promise((resolve, reject)=>{
            const url = this.createWebSocketUrl("api/exchange/ticker");
            try {
                this.spotWs = new WebSocket(url);
                this.spotWs.onopen = ()=>{
                    this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
                    this.updateAllConnectionStatus();
                    if (this.spotWs && this.spotWs.readyState === WebSocket.OPEN) {
                        this.spotWs.send(JSON.stringify({
                            action: "SUBSCRIBE",
                            payload: {
                                type: "tickers"
                            }
                        }));
                    }
                    resolve();
                };
                this.spotWs.onmessage = (event)=>{
                    try {
                        const data = JSON.parse(event.data);
                        if (data.data) {
                            // Only update tickers that have new data
                            Object.entries(data.data).forEach(([symbol, tickerData])=>{
                                if (tickerData && tickerData.last !== undefined) {
                                    this.spotData[symbol] = tickerData;
                                }
                            });
                            this.notifySpotCallbacks(this.spotData);
                        }
                    } catch (error) {
                        console.error("Error parsing spot WebSocket message:", error);
                    }
                };
                this.spotWs.onerror = (error)=>{
                    console.error("Spot WebSocket error:", error);
                    this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                    this.updateAllConnectionStatus();
                    reject(error);
                };
                this.spotWs.onclose = ()=>{
                    console.log("Spot WebSocket closed");
                    this.spotWs = null;
                    this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
                    this.spotConnectionPromise = null;
                    this.updateAllConnectionStatus();
                    // Only attempt to reconnect if we still have subscribers and we're not in the process of closing
                    if (this.spotSubscriptionCount > 0 && !this.isClosing) {
                        // Attempt to reconnect after a delay
                        setTimeout(()=>{
                            this.connectSpot().catch(console.error);
                        }, 5000);
                    }
                };
            } catch (error) {
                console.error("Error creating spot WebSocket:", error);
                this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                this.updateAllConnectionStatus();
                this.spotConnectionPromise = null;
                reject(error);
            }
        });
        return this.spotConnectionPromise;
    }
    // Connect to eco WebSocket
    connectEco() {
        // Check if ecosystem extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("ecosystem")) {
            console.warn("Ecosystem extension not available, skipping eco WebSocket connection");
            return Promise.resolve();
        }
        // If already connecting, return the existing promise
        if (this.ecoConnectionPromise) {
            return this.ecoConnectionPromise;
        }
        // If already connected, return resolved promise
        if (this.ecoWs && this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            return Promise.resolve();
        }
        // Create new connection
        this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        this.updateAllConnectionStatus();
        this.ecoConnectionPromise = new Promise((resolve, reject)=>{
            const url = this.createWebSocketUrl("api/ecosystem/ticker");
            try {
                this.ecoWs = new WebSocket(url);
                this.ecoWs.onopen = ()=>{
                    this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
                    this.updateAllConnectionStatus();
                    if (this.ecoWs && this.ecoWs.readyState === WebSocket.OPEN) {
                        this.ecoWs.send(JSON.stringify({
                            action: "SUBSCRIBE",
                            payload: {
                                type: "tickers"
                            }
                        }));
                    }
                    resolve();
                };
                this.ecoWs.onmessage = (event)=>{
                    try {
                        const data = JSON.parse(event.data);
                        if (data.data) {
                            // Only update tickers that have new data
                            Object.entries(data.data).forEach(([symbol, tickerData])=>{
                                if (tickerData && tickerData.last !== undefined) {
                                    this.ecoData[symbol] = tickerData;
                                }
                            });
                            this.notifyEcoCallbacks(this.ecoData);
                        }
                    } catch (error) {
                        console.error("Error parsing eco WebSocket message:", error);
                    }
                };
                this.ecoWs.onerror = (error)=>{
                    console.error("Eco WebSocket error:", error);
                    this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                    this.updateAllConnectionStatus();
                    reject(error);
                };
                this.ecoWs.onclose = ()=>{
                    console.log("Eco WebSocket closed");
                    this.ecoWs = null;
                    this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
                    this.ecoConnectionPromise = null;
                    this.updateAllConnectionStatus();
                    // Only attempt to reconnect if we still have subscribers and we're not in the process of closing
                    if (this.ecoSubscriptionCount > 0 && !this.isClosing) {
                        // Attempt to reconnect after a delay
                        setTimeout(()=>{
                            this.connectEco().catch(console.error);
                        }, 5000);
                    }
                };
            } catch (error) {
                console.error("Error creating eco WebSocket:", error);
                this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                this.updateAllConnectionStatus();
                this.ecoConnectionPromise = null;
                reject(error);
            }
        });
        return this.ecoConnectionPromise;
    }
    // Connect to futures WebSocket
    connectFutures() {
        // Check if futures extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("futures")) {
            console.warn("Futures extension not available, skipping futures WebSocket connection");
            return Promise.resolve();
        }
        // If already connecting, return the existing promise
        if (this.futuresConnectionPromise) {
            return this.futuresConnectionPromise;
        }
        // If already connected, return resolved promise
        if (this.futuresWs && this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            return Promise.resolve();
        }
        // Create new connection
        this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        this.updateAllConnectionStatus();
        this.futuresConnectionPromise = new Promise((resolve, reject)=>{
            const url = this.createWebSocketUrl("api/futures/ticker");
            try {
                this.futuresWs = new WebSocket(url);
                this.futuresWs.onopen = ()=>{
                    this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
                    this.updateAllConnectionStatus();
                    if (this.futuresWs && this.futuresWs.readyState === WebSocket.OPEN) {
                        this.futuresWs.send(JSON.stringify({
                            action: "SUBSCRIBE",
                            payload: {
                                type: "tickers"
                            }
                        }));
                    }
                    resolve();
                };
                this.futuresWs.onmessage = (event)=>{
                    try {
                        const message = JSON.parse(event.data);
                        if (message.stream === "tickers" && message.data) {
                            // Bulk tickers format: {"stream": "tickers", "data": {"SYMBOL": {...}}}
                            Object.entries(message.data).forEach(([symbol, tickerData])=>{
                                if (tickerData && tickerData.last !== undefined) {
                                    this.futuresData[symbol] = tickerData;
                                }
                            });
                            this.notifyFuturesCallbacks(this.futuresData);
                        } else if (message.stream === "ticker" && message.data) {
                            // Individual ticker format: {"stream": "ticker", "data": {"symbol": "SYMBOL", ...}}
                            const tickerData = message.data;
                            if (tickerData.symbol && tickerData.last !== undefined) {
                                this.futuresData[tickerData.symbol] = {
                                    last: tickerData.last,
                                    change: tickerData.change || 0,
                                    percentage: tickerData.percentage || 0,
                                    baseVolume: tickerData.baseVolume || 0,
                                    quoteVolume: tickerData.quoteVolume || 0,
                                    high: tickerData.high || 0,
                                    low: tickerData.low || 0,
                                    bid: tickerData.bid || 0,
                                    ask: tickerData.ask || 0,
                                    fundingRate: tickerData.fundingRate || 0
                                };
                                console.log("Updated futures data for", tickerData.symbol, ":", this.futuresData[tickerData.symbol]);
                                this.notifyFuturesCallbacks(this.futuresData);
                            }
                        }
                    } catch (error) {
                        console.error("Error parsing futures WebSocket message:", error);
                    }
                };
                this.futuresWs.onerror = (error)=>{
                    console.error("Futures WebSocket error:", error);
                    this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                    this.updateAllConnectionStatus();
                    reject(error);
                };
                this.futuresWs.onclose = ()=>{
                    console.log("Futures WebSocket closed");
                    this.futuresWs = null;
                    this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
                    this.futuresConnectionPromise = null;
                    this.updateAllConnectionStatus();
                    // Only attempt to reconnect if we still have subscribers and we're not in the process of closing
                    if (this.futuresSubscriptionCount > 0 && !this.isClosing) {
                        // Attempt to reconnect after a delay
                        setTimeout(()=>{
                            this.connectFutures().catch(console.error);
                        }, 5000);
                    }
                };
            } catch (error) {
                console.error("Error creating futures WebSocket:", error);
                this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                this.updateAllConnectionStatus();
                this.futuresConnectionPromise = null;
                reject(error);
            }
        });
        return this.futuresConnectionPromise;
    }
    // Subscribe to spot data
    subscribeToSpotData(callback) {
        // Increment subscription count
        this.spotSubscriptionCount++;
        // Add callback to set
        this.spotCallbacks.add(callback);
        // If we already have data, notify immediately
        if (Object.keys(this.spotData).length > 0) {
            callback(this.spotData);
        }
        // Connect if not already connected
        if (this.spotConnectionState !== __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            this.connectSpot().catch(console.error);
        }
        // Clear any pending close timeout
        if (this.spotCloseTimeout) {
            clearTimeout(this.spotCloseTimeout);
            this.spotCloseTimeout = null;
        }
        // Return unsubscribe function
        return ()=>{
            this.spotCallbacks.delete(callback);
            this.spotSubscriptionCount--;
            // If no more subscribers, schedule closing the connection after a delay
            // This prevents rapid subscribe/unsubscribe cycles from breaking connections
            if (this.spotSubscriptionCount === 0 && this.spotWs) {
                // Clear any existing timeout
                if (this.spotCloseTimeout) {
                    clearTimeout(this.spotCloseTimeout);
                }
                // Set a new timeout to close the connection after a delay
                this.spotCloseTimeout = setTimeout(()=>{
                    if (this.spotWs) {
                        this.spotWs.close();
                        this.spotWs = null;
                    }
                    this.spotCloseTimeout = null;
                }, 5000); // 5 second delay before closing
            }
        };
    }
    // Subscribe to eco data
    subscribeToEcoData(callback) {
        // Check if ecosystem extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("ecosystem")) {
            console.warn("Ecosystem extension not available, skipping eco data subscription");
            // Return a no-op unsubscribe function
            return ()=>{};
        }
        // Increment subscription count
        this.ecoSubscriptionCount++;
        // Add callback to set
        this.ecoCallbacks.add(callback);
        // If we already have data, notify immediately
        if (Object.keys(this.ecoData).length > 0) {
            callback(this.ecoData);
        }
        // Connect if not already connected
        if (this.ecoConnectionState !== __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            this.connectEco().catch(console.error);
        }
        // Clear any pending close timeout
        if (this.ecoCloseTimeout) {
            clearTimeout(this.ecoCloseTimeout);
            this.ecoCloseTimeout = null;
        }
        // Return unsubscribe function
        return ()=>{
            this.ecoCallbacks.delete(callback);
            this.ecoSubscriptionCount--;
            // If no more subscribers, schedule closing the connection after a delay
            if (this.ecoSubscriptionCount === 0 && this.ecoWs) {
                // Clear any existing timeout
                if (this.ecoCloseTimeout) {
                    clearTimeout(this.ecoCloseTimeout);
                }
                // Set a new timeout to close the connection after a delay
                this.ecoCloseTimeout = setTimeout(()=>{
                    if (this.ecoWs) {
                        this.ecoWs.close();
                        this.ecoWs = null;
                    }
                    this.ecoCloseTimeout = null;
                }, 5000); // 5 second delay before closing
            }
        };
    }
    // Subscribe to futures data
    subscribeToFuturesData(callback) {
        // Check if futures extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("futures")) {
            console.warn("Futures extension not available, skipping futures data subscription");
            // Return a no-op unsubscribe function
            return ()=>{};
        }
        // Increment subscription count
        this.futuresSubscriptionCount++;
        // Add callback to set
        this.futuresCallbacks.add(callback);
        // If we already have data, notify immediately
        if (Object.keys(this.futuresData).length > 0) {
            callback(this.futuresData);
        }
        // Connect to futures bulk ticker WebSocket if not already connected
        if (this.futuresConnectionState !== __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            this.connectFutures().catch(console.error);
        }
        // Clear any pending close timeout
        if (this.futuresCloseTimeout) {
            clearTimeout(this.futuresCloseTimeout);
            this.futuresCloseTimeout = null;
        }
        // Return unsubscribe function
        return ()=>{
            this.futuresCallbacks.delete(callback);
            this.futuresSubscriptionCount--;
            // If no more subscribers, schedule closing the connection after a delay
            if (this.futuresSubscriptionCount === 0 && this.futuresWs) {
                // Clear any existing timeout
                if (this.futuresCloseTimeout) {
                    clearTimeout(this.futuresCloseTimeout);
                }
                // Set a new timeout to close the connection after a delay
                this.futuresCloseTimeout = setTimeout(()=>{
                    if (this.futuresWs) {
                        this.futuresWs.close();
                        this.futuresWs = null;
                    }
                    this.futuresCloseTimeout = null;
                }, 5000); // 5 second delay before closing
            }
        };
    }
    // Subscribe to connection status
    subscribeToConnectionStatus(callback) {
        this.connectionStatusCallbacks.add(callback);
        // Notify immediately with current status
        callback(this.getConnectionStatus());
        return ()=>{
            this.connectionStatusCallbacks.delete(callback);
        };
    }
    // Notify spot callbacks
    notifySpotCallbacks(data) {
        this.spotCallbacks.forEach((callback)=>{
            try {
                callback(data);
            } catch (error) {
                console.error("Error in spot callback:", error);
            }
        });
    }
    // Notify eco callbacks
    notifyEcoCallbacks(data) {
        this.ecoCallbacks.forEach((callback)=>{
            try {
                callback(data);
            } catch (error) {
                console.error("Error in eco callback:", error);
            }
        });
    }
    // Notify futures callbacks
    notifyFuturesCallbacks(data) {
        this.futuresCallbacks.forEach((callback)=>{
            try {
                callback(data);
            } catch (error) {
                console.error("Error in futures callback:", error);
            }
        });
    }
    // Update all connection status callbacks
    updateAllConnectionStatus() {
        const status = this.getConnectionStatus();
        this.connectionStatusCallbacks.forEach((callback)=>{
            try {
                callback(status);
            } catch (error) {
                console.error("Error in connection status callback:", error);
            }
        });
    }
    /**
   * Force unsubscribe from a specific symbol's data across all connections
   * This helps prevent duplicate trades when navigating between pages
   * @param symbol The symbol to unsubscribe from
   */ unsubscribeFromSymbol(symbol) {
        // Normalize the symbol to handle different formats
        const normalizedSymbol = symbol.replace('/', '').replace('-', '').toUpperCase();
        const slashSymbol = symbol.includes('/') ? symbol : symbol.replace(/([A-Z]+)([A-Z]{3,4})$/, '$1/$2');
        const dashSymbol = symbol.includes('-') ? symbol : symbol.replace(/([A-Z]+)([A-Z]{3,4})$/, '$1-$2');
        // Create an array of possible symbol formats to check
        const symbolVariations = [
            symbol,
            normalizedSymbol,
            slashSymbol,
            dashSymbol,
            symbol.toUpperCase(),
            symbol.toLowerCase()
        ];
        // Check if we have this symbol in any of our data caches
        const hasInSpot = symbolVariations.some((s)=>this.spotData[s] !== undefined);
        const hasInEco = symbolVariations.some((s)=>this.ecoData[s] !== undefined);
        const hasInFutures = symbolVariations.some((s)=>this.futuresData[s] !== undefined);
        console.log(`Unsubscribing from symbol: ${symbol} (found in spot: ${hasInSpot}, eco: ${hasInEco}, futures: ${hasInFutures})`);
        // Remove the symbol from our data caches
        symbolVariations.forEach((s)=>{
            delete this.spotData[s];
            delete this.ecoData[s];
            delete this.futuresData[s];
        });
        // If we have active WebSocket connections, send unsubscribe messages
        if (this.spotWs && this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED && hasInSpot) {
            try {
                this.spotWs.send(JSON.stringify({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type: "ticker",
                        symbol
                    }
                }));
            } catch (error) {
                console.error(`Error unsubscribing from spot ticker for ${symbol}:`, error);
            }
        }
        if (this.ecoWs && this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED && hasInEco) {
            try {
                this.ecoWs.send(JSON.stringify({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type: "ticker",
                        symbol
                    }
                }));
            } catch (error) {
                console.error(`Error unsubscribing from eco ticker for ${symbol}:`, error);
            }
        }
        if (this.futuresWs && this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED && hasInFutures) {
            try {
                this.futuresWs.send(JSON.stringify({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type: "ticker",
                        symbol
                    }
                }));
            } catch (error) {
                console.error(`Error unsubscribing from futures ticker for ${symbol}:`, error);
            }
        }
    }
    cleanup() {
        this.isClosing = true;
        // Clear all timeouts
        if (this.spotCloseTimeout) {
            clearTimeout(this.spotCloseTimeout);
            this.spotCloseTimeout = null;
        }
        if (this.ecoCloseTimeout) {
            clearTimeout(this.ecoCloseTimeout);
            this.ecoCloseTimeout = null;
        }
        if (this.futuresCloseTimeout) {
            clearTimeout(this.futuresCloseTimeout);
            this.futuresCloseTimeout = null;
        }
        // Close all WebSocket connections
        if (this.spotWs) {
            this.spotWs.close();
            this.spotWs = null;
        }
        if (this.ecoWs) {
            this.ecoWs.close();
            this.ecoWs = null;
        }
        if (this.futuresWs) {
            this.futuresWs.close();
            this.futuresWs = null;
        }
        // Reset all state
        this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
        this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
        this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
        this.spotSubscriptionCount = 0;
        this.ecoSubscriptionCount = 0;
        this.futuresSubscriptionCount = 0;
        this.spotCallbacks.clear();
        this.ecoCallbacks.clear();
        this.futuresCallbacks.clear();
        this.connectionStatusCallbacks.clear();
        this.spotConnectionPromise = null;
        this.ecoConnectionPromise = null;
        this.futuresConnectionPromise = null;
        this.isInitialized = false;
        this.isClosing = false;
    }
}
const tickersWs = TickersWebSocketManager.getInstance();
}),
"[project]/frontend/utils/image-fallback.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Utility function to handle image fallbacks consistently across the application.
 * Prevents infinite loops by using data attributes to track fallback attempts.
 */ // Generic crypto icon as base64 SVG data URI
__turbopack_context__.s([
    "GENERIC_CRYPTO_ICON",
    ()=>GENERIC_CRYPTO_ICON,
    "createCryptoImage",
    ()=>createCryptoImage,
    "getCryptoImageUrl",
    ()=>getCryptoImageUrl,
    "handleImageError",
    ()=>handleImageError
]);
const GENERIC_CRYPTO_ICON = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjAiIGN5PSIyMCIgcj0iMjAiIGZpbGw9IiNGM0Y0RjYiLz4KPHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4PSI4IiB5PSI4Ij4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iMTAiIHN0cm9rZT0iIzY5NzA3QiIgc3Ryb2tlLXdpZHRoPSIyIi8+CjxwYXRoIGQ9Im0xNSA5LTYgNiIgc3Ryb2tlPSIjNjk3MDdCIiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJtOSA5IDYgNiIgc3Ryb2tlPSIjNjk3MDdCIiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4KPC9zdmc+';
const handleImageError = (event, fallbackUrl)=>{
    const img = event.target;
    // Prevent infinite loops by checking if we already tried fallback
    if (img.dataset.fallbackAttempted) {
        return;
    }
    img.dataset.fallbackAttempted = 'true';
    if (fallbackUrl) {
        img.src = fallbackUrl;
    } else {
        img.src = GENERIC_CRYPTO_ICON;
    }
};
const getCryptoImageUrl = (currency, size = 'md')=>{
    // Clean and validate currency input
    if (!currency || typeof currency !== 'string') {
        return '/img/crypto/generic.webp';
    }
    // Remove any slashes and clean the currency name
    const cleanCurrency = currency.toLowerCase().replace(/[^a-z0-9]/g, '') // Remove non-alphanumeric characters
    .trim();
    // Ensure we don't have empty string
    if (!cleanCurrency) {
        return '/img/crypto/generic.webp';
    }
    // Construct path without double slashes
    return `/img/crypto/${cleanCurrency}.webp`;
};
const createCryptoImage = (currency, alt, className, size = 'md')=>{
    const imageUrl = getCryptoImageUrl(currency, size);
    const altText = alt || currency || 'Cryptocurrency';
    return {
        src: imageUrl,
        alt: altText,
        className,
        onError: (e)=>handleImageError(e, '/img/crypto/generic.webp')
    };
};
}),
"[project]/frontend/store/pages-store.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "usePagesStore",
    ()=>usePagesStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/middleware.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-ssr] (ecmascript)");
;
;
;
const usePagesStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["persist"])((set, get)=>({
        pages: [],
        currentPage: null,
        isLoading: false,
        error: null,
        fetchPages: async ()=>{
            set({
                isLoading: true,
                error: null
            });
            try {
                const response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/content/page",
                    silentSuccess: true
                });
                if (response.data && Array.isArray(response.data)) {
                    // Handle direct array response
                    set({
                        pages: response.data,
                        isLoading: false
                    });
                } else if (response.data && response.data.pages) {
                    // Handle wrapped response
                    set({
                        pages: response.data.pages,
                        isLoading: false
                    });
                } else {
                    const errorMsg = response.error || "Failed to fetch pages";
                    console.warn("Pages fetch error:", errorMsg);
                    set({
                        error: errorMsg,
                        isLoading: false
                    });
                }
            } catch (error) {
                console.error("Error fetching pages:", error);
                const errorMsg = error instanceof Error ? error.message : "Failed to fetch pages";
                set({
                    error: errorMsg,
                    isLoading: false
                });
            }
        },
        fetchPageById: async (id)=>{
            if (!id || typeof id !== "string") {
                console.warn("Invalid page ID provided:", id);
                return null;
            }
            set({
                isLoading: true,
                error: null
            });
            try {
                const response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/content/page/${id}`,
                    silentSuccess: true
                });
                if (response.data && response.data.id) {
                    // Handle direct page response
                    const page = response.data;
                    set({
                        currentPage: page,
                        isLoading: false
                    });
                    return page;
                } else if (response.data && response.data.page) {
                    // Handle wrapped response
                    const page = response.data.page;
                    set({
                        currentPage: page,
                        isLoading: false
                    });
                    return page;
                } else {
                    const errorMsg = response.error || "Failed to fetch page";
                    console.warn(`Page fetch error for ID ${id}:`, errorMsg);
                    set({
                        error: errorMsg,
                        isLoading: false
                    });
                    return null;
                }
            } catch (error) {
                console.error(`Error fetching page ${id}:`, error);
                const errorMsg = error instanceof Error ? error.message : "Failed to fetch page";
                set({
                    error: errorMsg,
                    isLoading: false
                });
                return null;
            }
        },
        setCurrentPage: (page)=>{
            set({
                currentPage: page
            });
        }
    }), {
    name: "pages-store",
    partialize: (state)=>({
            pages: state.pages,
            currentPage: state.currentPage
        })
}));
}),
"[project]/frontend/store/builder-store.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "BuilderRegistry",
    ()=>BuilderRegistry,
    "createEmptyRow",
    ()=>createEmptyRow,
    "generateId",
    ()=>generateId,
    "useBuilderStore",
    ()=>useBuilderStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/middleware.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/immer@10.2.0/node_modules/immer/dist/immer.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/builder/patch-utils.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
/* =====================================================
   Zustand Store Creation with Immer & DevTools
===================================================== */ const useBuilderStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["devtools"])((set, get)=>({
        pageId: null,
        page: {
            id: "page-1",
            title: "Untitled Page",
            sections: [],
            elements: []
        },
        history: [],
        future: [],
        historyIndex: -1,
        selectedElementId: null,
        selectedSectionId: null,
        selectedRowId: null,
        selectedColumnId: null,
        isSettingsPanelOpen: false,
        isAddSectionModalOpen: false,
        canUndo: false,
        canRedo: false,
        viewMode: "desktop",
        isPreviewMode: false,
        isLayersOpen: false,
        isSettingsOpen: false,
        currentPageId: null,
        currentPageTitle: null,
        pageSnapshots: {},
        initializeBuilder: (pageId)=>{
            set({
                pageId: pageId || null,
                page: {
                    id: pageId || "page-1",
                    title: "Untitled Page",
                    sections: [],
                    elements: []
                },
                history: [],
                future: [],
                historyIndex: -1,
                selectedElementId: null,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: null,
                isSettingsPanelOpen: true,
                canUndo: false,
                canRedo: false,
                viewMode: "desktop",
                isPreviewMode: false,
                isLayersOpen: false,
                isSettingsOpen: false
            });
        },
        setPage: (page)=>{
            // Ensure sections is always an array to prevent map errors
            const safePage = {
                ...page,
                sections: Array.isArray(page.sections) ? page.sections : [],
                elements: Array.isArray(page.elements) ? page.elements : []
            };
            set({
                page: safePage
            });
        },
        // --- ELEMENT ACTIONS ---
        addElement: (element)=>{
            const { page, history, future, selectedColumnId } = get();
            const elementWithSettings = createElementWithDefaultSettings(element);
            // Create a new state with the element added
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                if (selectedColumnId) {
                    const registry = new BuilderRegistry(draft.sections);
                    const columnInfo = registry.getColumn(selectedColumnId);
                    if (columnInfo) {
                        columnInfo.column.elements.push(elementWithSettings);
                    }
                } else {
                    draft.elements = [
                        ...draft.elements || [],
                        elementWithSettings
                    ];
                }
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Add element");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false
            });
            setTimeout(()=>{
                set({
                    selectedElementId: element.id,
                    selectedSectionId: null,
                    selectedRowId: null,
                    selectedColumnId: null,
                    isSettingsPanelOpen: true,
                    isLayersOpen: false,
                    isSettingsOpen: false
                });
            }, 10);
        },
        updateElement: (id, updatedElement)=>{
            const { page, history, future } = get();
            // Create a new state with the element updated
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                const updatedSections = updateElementRecursive(draft.sections, id, updatedElement);
                draft.sections = updatedSections;
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Update element");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false
            });
        },
        duplicateElement: (id)=>{
            const { page, history, future } = get();
            // Create a new state with the element duplicated
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                const registry = new BuilderRegistry(draft.sections);
                const elementInfo = registry.getElement(id);
                let duplicatedElement;
                if (elementInfo) {
                    const { element, column, row, section, parentColumnId } = elementInfo;
                    duplicatedElement = {
                        ...element,
                        id: generateId("element")
                    };
                    if (parentColumnId) {
                        draft.sections = updateSectionInArray(draft.sections, section.id, (s)=>{
                            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(s, (sectionDraft)=>{
                                sectionDraft.rows = sectionDraft.rows.map((r)=>{
                                    if (r.id === row.id) {
                                        r.columns = r.columns.map((col)=>{
                                            if (col.id === parentColumnId && col.rows) {
                                                col.rows = col.rows.map((nestedRow)=>{
                                                    if (nestedRow.id === row.id) {
                                                        const elementIndex = nestedRow.elements.findIndex((el)=>el.id === id);
                                                        nestedRow.elements.splice(elementIndex + 1, 0, duplicatedElement);
                                                    }
                                                    return nestedRow;
                                                });
                                            }
                                            return col;
                                        });
                                    }
                                    return r;
                                });
                            });
                        });
                    } else {
                        const result = duplicateElementRecursive(draft.sections, id);
                        draft.sections = result.sections;
                        duplicatedElement = result.duplicatedElement;
                    }
                } else {
                    const result = duplicateElementRecursive(draft.sections, id);
                    draft.sections = result.sections;
                    duplicatedElement = result.duplicatedElement;
                    if (!duplicatedElement) {
                        const elementToDuplicate = (draft.elements || []).find((el)=>el.id === id);
                        if (elementToDuplicate) {
                            duplicatedElement = {
                                ...elementToDuplicate,
                                id: generateId("element")
                            };
                            const originalIndex = (draft.elements || []).findIndex((el)=>el.id === id);
                            const updatedElements = [
                                ...draft.elements || []
                            ];
                            updatedElements.splice(originalIndex + 1, 0, duplicatedElement);
                            draft.elements = updatedElements;
                        }
                    }
                }
                // Store the duplicated element ID for selection after state update
                if (duplicatedElement) {
                // We can't directly modify the draft to add custom properties
                // So we'll handle the selection in the set() call
                }
            });
            // Find the duplicated element ID for selection
            const registry = new BuilderRegistry(newPage.sections);
            const duplicatedElementId = findDuplicatedElementId(page, newPage);
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Duplicate element");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false,
                selectedElementId: duplicatedElementId,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: null,
                isSettingsPanelOpen: true
            });
        },
        deleteElement: (id)=>{
            const { page, history, future } = get();
            // Create a new state with the element deleted
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                const registry = new BuilderRegistry(draft.sections);
                const elementInfo = registry.getElement(id);
                if (elementInfo) {
                    const { column, row, section, parentColumnId } = elementInfo;
                    if (parentColumnId) {
                        draft.sections = updateSectionInArray(draft.sections, section.id, (s)=>{
                            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(s, (sectionDraft)=>{
                                sectionDraft.rows = sectionDraft.rows.map((r)=>{
                                    if (r.id === row.id) {
                                        r.columns = r.columns.map((col)=>{
                                            if (col.id === parentColumnId && col.rows) {
                                                col.rows = col.rows.map((nestedRow)=>{
                                                    if (nestedRow.id === row.id) {
                                                        nestedRow.columns = nestedRow.columns.map((nestedCol)=>{
                                                            if (nestedCol.id === column.id) {
                                                                nestedCol.elements = nestedCol.elements.filter((el)=>el.id !== id);
                                                            }
                                                            return nestedCol;
                                                        });
                                                    }
                                                    return nestedRow;
                                                });
                                            }
                                            return col;
                                        });
                                    }
                                    return r;
                                });
                            });
                        });
                    } else {
                        draft.sections = updateSectionInArray(draft.sections, section.id, (s)=>updateRowInSection(s, row.id, (r)=>updateColumnInRow(r, column.id, (c)=>removeElementFromColumn(c, id))));
                    }
                } else {
                    draft.sections = deleteElementRecursive(draft.sections, id);
                    draft.elements = (draft.elements || []).filter((el)=>el.id !== id);
                }
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Delete element");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false,
                selectedElementId: null
            });
        },
        selectElement: (id, containerInfo)=>{
            set({
                selectedElementId: id,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: null,
                isSettingsPanelOpen: id !== null,
                isLayersOpen: false,
                isSettingsOpen: false
            });
        },
        getSelectedElement: ()=>{
            const { page, selectedElementId } = get();
            if (!selectedElementId) return null;
            const registry = new BuilderRegistry(page.sections || []);
            const elementInfo = registry.getElement(selectedElementId);
            if (elementInfo) {
                return elementInfo.element;
            }
            return (page.elements || []).find((el)=>el.id === selectedElementId) || null;
        },
        // --- SECTION ACTIONS ---
        addSection: (section)=>{
            const { page, history, future } = get();
            // Create a new state with the section added
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                draft.sections = [
                    ...draft.sections,
                    section
                ];
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Add section");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false,
                selectedSectionId: section.id,
                selectedRowId: null,
                selectedColumnId: null,
                selectedElementId: null,
                isSettingsPanelOpen: true
            });
        },
        updateSection: (id, updatedSection)=>{
            const { page, history, future } = get();
            // Create a new state with the section updated
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                draft.sections = draft.sections.map((section)=>section.id === id ? updatedSection : section);
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Update section");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false
            });
        },
        updateSectionSnapshots: (id, snapshots)=>{
            const { page } = get();
            const sections = Array.isArray(page.sections) ? page.sections : [];
            const updatedSections = sections.map((section)=>section.id === id ? {
                    ...section,
                    snapshots
                } : section);
            set({
                page: {
                    ...page,
                    sections: updatedSections
                }
            });
        },
        deleteSection: (id)=>{
            const { page, history, future } = get();
            // Create a new state with the section deleted
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                draft.sections = draft.sections.filter((section)=>section.id !== id);
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Delete section");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: null,
                selectedElementId: null
            });
        },
        selectSection: (id)=>{
            set({
                selectedElementId: null,
                selectedSectionId: id,
                selectedRowId: null,
                selectedColumnId: null,
                isSettingsPanelOpen: id !== null,
                isLayersOpen: false,
                isSettingsOpen: false
            });
        },
        getSelectedSection: ()=>{
            const { page, selectedSectionId } = get();
            if (!selectedSectionId) return null;
            const sections = Array.isArray(page.sections) ? page.sections : [];
            return sections.find((section)=>section.id === selectedSectionId) || null;
        },
        // --- ROW ACTIONS ---
        addRow: (sectionId, row, parentColumnId)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Add Row");
            let updatedSections;
            if (parentColumnId) {
                updatedSections = addRowToColumn(page.sections, sectionId, parentColumnId, row);
            } else {
                updatedSections = page.sections.map((section)=>{
                    if (section.id !== sectionId) return section;
                    return {
                        ...section,
                        rows: [
                            ...section.rows,
                            row
                        ]
                    };
                });
            }
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false,
                selectedSectionId: null,
                selectedRowId: row.id,
                selectedColumnId: null,
                selectedElementId: null,
                isSettingsPanelOpen: true
            });
        },
        updateRow: (sectionId, rowId, updatedRow, parentColumnId)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Update Row");
            let updatedSections;
            if (parentColumnId) {
                updatedSections = updateRowRecursive(page.sections, rowId, updatedRow);
            } else {
                updatedSections = page.sections.map((section)=>{
                    if (section.id !== sectionId) return section;
                    return {
                        ...section,
                        rows: section.rows.map((r)=>r.id === rowId ? updatedRow : r)
                    };
                });
            }
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        deleteRow: (sectionId, rowId, parentColumnId)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Delete Row");
            let updatedSections;
            if (parentColumnId) {
                updatedSections = deleteRowRecursive(page.sections, rowId);
            } else {
                updatedSections = page.sections.map((section)=>{
                    if (section.id !== sectionId) return section;
                    return {
                        ...section,
                        rows: section.rows.filter((row)=>row.id !== rowId)
                    };
                });
            }
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false,
                selectedRowId: null,
                selectedColumnId: null,
                selectedElementId: null
            });
        },
        selectRow: (sectionId, rowId, parentColumnId)=>{
            set({
                selectedElementId: null,
                selectedSectionId: null,
                selectedRowId: rowId,
                selectedColumnId: null,
                isSettingsPanelOpen: rowId !== null,
                isLayersOpen: false,
                isSettingsOpen: false
            });
        },
        getSelectedRow: ()=>{
            const { page, selectedRowId } = get();
            if (!selectedRowId) return null;
            const sections = Array.isArray(page.sections) ? page.sections : [];
            const registry = new BuilderRegistry(sections);
            const rowInfo = registry.getRow(selectedRowId);
            if (rowInfo) {
                return {
                    section: rowInfo.section,
                    row: rowInfo.row
                };
            }
            return null;
        },
        // --- COLUMN ACTIONS ---
        addColumn: (sectionId, rowId, column, parentColumnId)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Add Column");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const section = draft.find((s)=>s.id === sectionId);
                if (section) {
                    section.rows = addColumnToRowFn(section.rows, rowId, column, parentColumnId);
                }
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false,
                selectedColumnId: column.id,
                selectedElementId: null,
                selectedSectionId: null,
                selectedRowId: parentColumnId || rowId,
                isSettingsPanelOpen: true
            });
        },
        updateColumn: (sectionId, rowId, columnId, updatedColumn, parentRowId)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Update Column");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const section = draft.find((s)=>s.id === sectionId);
                if (section) {
                    section.rows = updateColumnInRows(section.rows, rowId, columnId, updatedColumn, parentRowId || null);
                }
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        deleteColumn: (sectionId, rowId, columnId, parentColumnId)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Delete Column");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const section = draft.find((s)=>s.id === sectionId);
                if (section) {
                    section.rows = deleteColumnFromRows(section.rows, rowId, columnId, parentColumnId || null);
                }
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false,
                selectedColumnId: null,
                selectedElementId: null
            });
        },
        selectColumn: (sectionId, rowId, columnId, parentRowId)=>{
            set({
                selectedElementId: null,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: columnId,
                isSettingsPanelOpen: columnId !== null,
                isLayersOpen: false,
                isSettingsOpen: false
            });
        },
        getSelectedColumn: ()=>{
            const { page, selectedColumnId } = get();
            if (!selectedColumnId) return null;
            const sections = Array.isArray(page.sections) ? page.sections : [];
            return findColumnById(sections, selectedColumnId);
        },
        // --- UI ACTIONS ---
        toggleSettingsPanel: ()=>{
            set((state)=>({
                    isSettingsPanelOpen: !state.isSettingsPanelOpen
                }));
        },
        openSettingsPanel: ()=>{
            set({
                isSettingsPanelOpen: true
            });
        },
        closeSettingsPanel: ()=>{
            set({
                isSettingsPanelOpen: false
            });
        },
        toggleAddSectionModal: ()=>{
            set((state)=>({
                    isAddSectionModalOpen: !state.isAddSectionModalOpen
                }));
        },
        setViewMode: (viewMode)=>{
            set({
                viewMode
            });
        },
        togglePreviewMode: ()=>{
            set((state)=>({
                    isPreviewMode: !state.isPreviewMode
                }));
        },
        toggleLayers: ()=>{
            set((state)=>({
                    isLayersOpen: !state.isLayersOpen
                }));
        },
        toggleSettings: ()=>{
            set((state)=>({
                    isSettingsOpen: !state.isSettingsOpen
                }));
        },
        undoAction: ()=>{
            const { page, history, future } = get();
            if (history.length === 0) {
                console.warn("Undo action not available: no history available.");
                return;
            }
            // Get the last history entry
            const lastEntry = history[history.length - 1];
            // Apply the inverse patches to go back to the previous state
            const previousState = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["applyPatch"])(page, lastEntry.inversePatches);
            // Update the state
            set({
                page: previousState,
                history: history.slice(0, -1),
                future: [
                    lastEntry,
                    ...future
                ],
                canUndo: history.length > 1,
                canRedo: true,
                selectedElementId: null,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: null
            });
        },
        redoAction: ()=>{
            const { page, history, future } = get();
            if (future.length === 0) {
                console.warn("Redo action not available: no future actions.");
                return;
            }
            // Get the first future entry
            const nextEntry = future[0];
            // Apply the patches to go forward to the next state
            const nextState = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["applyPatch"])(page, nextEntry.patches);
            // Update the state
            set({
                page: nextState,
                history: [
                    ...history,
                    nextEntry
                ],
                future: future.slice(1),
                canUndo: true,
                canRedo: future.length > 1,
                selectedElementId: null,
                selectedSectionId: null,
                selectedRowId: null,
                selectedColumnId: null
            });
        },
        moveSection: (sectionId, newIndex)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Move Section");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const sectionIndex = draft.findIndex((section)=>section.id === sectionId);
                if (sectionIndex === -1) return;
                const [movedSection] = draft.splice(sectionIndex, 1);
                draft.splice(newIndex, 0, movedSection);
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        moveRow: (rowId, sourceSectionId, sourceParentColumnId, targetSectionId, targetParentColumnId, targetIndex)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Move Row");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const sourceSection = draft.find((s)=>s.id === sourceSectionId);
                if (!sourceSection) return;
                const targetSection = draft.find((s)=>s.id === targetSectionId);
                if (!targetSection) return;
                let rowToMove = null;
                if (!sourceParentColumnId) {
                    const rowIndex = sourceSection.rows.findIndex((row)=>row.id === rowId);
                    if (rowIndex === -1) return;
                    [rowToMove] = sourceSection.rows.splice(rowIndex, 1);
                } else {
                    let foundParentColumn = false;
                    for(let i = 0; i < sourceSection.rows.length; i++){
                        const row = sourceSection.rows[i];
                        for(let j = 0; j < row.columns.length; j++){
                            const col = row.columns[j];
                            if (col.id === sourceParentColumnId) {
                                if (!col.rows) col.rows = [];
                                const nestedRowIndex = col.rows.findIndex((nestedRow)=>nestedRow.id === rowId);
                                if (nestedRowIndex === -1) continue;
                                [rowToMove] = col.rows.splice(nestedRowIndex, 1);
                                foundParentColumn = true;
                                break;
                            }
                        }
                        if (foundParentColumn) break;
                    }
                    if (!rowToMove) return;
                }
                if (!sourceParentColumnId && targetParentColumnId) {
                    rowToMove.nestingLevel = 2;
                    rowToMove.columns.forEach((col)=>col.nestingLevel = 2);
                } else if (sourceParentColumnId && !targetParentColumnId) {
                    rowToMove.nestingLevel = 1;
                    rowToMove.columns.forEach((col)=>col.nestingLevel = 1);
                }
                if (!targetParentColumnId) {
                    targetSection.rows.splice(targetIndex, 0, rowToMove);
                } else {
                    let foundTargetColumn = false;
                    for(let i = 0; i < targetSection.rows.length; i++){
                        const row = targetSection.rows[i];
                        for(let j = 0; j < row.columns.length; j++){
                            const col = row.columns[j];
                            if (col.id === targetParentColumnId) {
                                if (!col.rows) col.rows = [];
                                col.rows.splice(targetIndex, 0, rowToMove);
                                foundTargetColumn = true;
                                break;
                            }
                        }
                        if (foundTargetColumn) break;
                    }
                    if (!foundTargetColumn) return;
                }
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        moveColumn: (columnId, sourceSectionId, sourceRowId, sourceParentColumnId, targetSectionId, targetRowId, targetParentColumnId, targetIndex)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Move Column");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const sourceSection = draft.find((s)=>s.id === sourceSectionId);
                if (!sourceSection) return;
                const targetSection = draft.find((s)=>s.id === targetSectionId);
                if (!targetSection) return;
                let columnToMove = null;
                let sourceRow = null;
                if (!sourceParentColumnId) {
                    sourceRow = sourceSection.rows.find((row)=>row.id === sourceRowId);
                    if (!sourceRow) return;
                    const columnIndex = sourceRow.columns.findIndex((col)=>col.id === columnId);
                    if (columnIndex === -1) return;
                    [columnToMove] = sourceRow.columns.splice(columnIndex, 1);
                    if (sourceRow.columns.length > 0) {
                        const newWidth = 100 / sourceRow.columns.length;
                        sourceRow.columns.forEach((col)=>col.width = newWidth);
                    }
                } else {
                    let foundParentColumn = false;
                    let parentColumn = null;
                    for(let i = 0; i < sourceSection.rows.length; i++){
                        const row = sourceSection.rows[i];
                        for(let j = 0; j < row.columns.length; j++){
                            const col = row.columns[j];
                            if (col.id === sourceParentColumnId) {
                                parentColumn = col;
                                if (!parentColumn.rows) parentColumn.rows = [];
                                sourceRow = parentColumn.rows.find((nestedRow)=>nestedRow.id === sourceRowId);
                                if (!sourceRow) break;
                                const columnIndex = sourceRow.columns.findIndex((c)=>c.id === columnId);
                                if (columnIndex === -1) break;
                                [columnToMove] = sourceRow.columns.splice(columnIndex, 1);
                                if (sourceRow.columns.length > 0) {
                                    const newWidth = 100 / sourceRow.columns.length;
                                    sourceRow.columns.forEach((c)=>c.width = newWidth);
                                }
                                foundParentColumn = true;
                                break;
                            }
                        }
                        if (foundParentColumn) break;
                    }
                    if (!columnToMove) return;
                }
                if (!sourceParentColumnId && targetParentColumnId) {
                    columnToMove.nestingLevel = 2;
                } else if (sourceParentColumnId && !targetParentColumnId) {
                    columnToMove.nestingLevel = 1;
                }
                let targetRow = null;
                if (!targetParentColumnId) {
                    targetRow = targetSection.rows.find((row)=>row.id === targetRowId);
                    if (!targetRow) return;
                    targetRow.columns.splice(targetIndex, 0, columnToMove);
                    const newWidth = 100 / targetRow.columns.length;
                    targetRow.columns.forEach((col)=>col.width = newWidth);
                } else {
                    let foundTargetColumn = false;
                    let targetParentCol = null;
                    for(let i = 0; i < targetSection.rows.length; i++){
                        const row = targetSection.rows[i];
                        for(let j = 0; j < row.columns.length; j++){
                            const col = row.columns[j];
                            if (col.id === targetParentColumnId) {
                                targetParentCol = col;
                                if (!targetParentCol.rows) targetParentCol.rows = [];
                                targetRow = targetParentCol.rows.find((nestedRow)=>nestedRow.id === targetRowId);
                                if (!targetRow) break;
                                targetRow.columns.splice(targetIndex, 0, columnToMove);
                                const newWidth = 100 / targetRow.columns.length;
                                targetRow.columns.forEach((c)=>c.width = newWidth);
                                foundTargetColumn = true;
                                break;
                            }
                        }
                        if (foundTargetColumn) break;
                    }
                    if (!foundTargetColumn) return;
                }
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        moveElement: (elementId, sourceSectionId, sourceRowId, sourceColumnId, targetSectionId, targetRowId, targetColumnId, targetIndex)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Move Element");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const findColumnInSection = (rows, targetRowId, targetColumnId)=>{
                    for (const row of rows){
                        if (row.id === targetRowId) {
                            const column = row.columns.find((c)=>c.id === targetColumnId);
                            if (column) return {
                                column,
                                row,
                                parentColumn: null,
                                isNested: false
                            };
                        }
                        for (const column of row.columns){
                            if (column.rows) {
                                for (const nestedRow of column.rows){
                                    if (nestedRow.id === targetRowId) {
                                        const nestedColumn = nestedRow.columns.find((c)=>c.id === targetColumnId);
                                        if (nestedColumn) return {
                                            column: nestedColumn,
                                            row: nestedRow,
                                            parentColumn: column,
                                            isNested: true
                                        };
                                    }
                                }
                            }
                        }
                    }
                    return {
                        column: null,
                        row: null,
                        parentColumn: null,
                        isNested: false
                    };
                };
                const sourceSectionDraft = draft.find((s)=>s.id === sourceSectionId);
                if (!sourceSectionDraft) return;
                const targetSectionDraft = draft.find((s)=>s.id === targetSectionId);
                if (!targetSectionDraft) return;
                const sourceLookup = findColumnInSection(sourceSectionDraft.rows, sourceRowId, sourceColumnId);
                if (!sourceLookup.column) return;
                const sourceColumn = sourceLookup.column;
                const sourceElementIndex = sourceColumn.elements.findIndex((e)=>e.id === elementId);
                if (sourceElementIndex === -1) return;
                const [elementToMove] = sourceColumn.elements.splice(sourceElementIndex, 1);
                const targetLookup = findColumnInSection(targetSectionDraft.rows, targetRowId, targetColumnId);
                if (!targetLookup.column) return;
                const targetColumn = targetLookup.column;
                let adjustedTargetIndex = targetIndex;
                if (sourceColumn === targetColumn && sourceElementIndex < targetIndex) {
                    adjustedTargetIndex = Math.max(0, targetIndex - 1);
                }
                targetColumn.elements.splice(adjustedTargetIndex, 0, elementToMove);
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        reorderElement: (elementId, sectionId, rowId, columnId, direction)=>{
            const { page, history, future } = get();
            // Create a new state with the element reordered
            const newPage = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page, (draft)=>{
                const findColumnInSection = (section, targetRowId, targetColumnId)=>{
                    for (const row of section.rows){
                        if (row.id === targetRowId) {
                            const column = row.columns.find((c)=>c.id === targetColumnId);
                            if (column) return {
                                column,
                                row,
                                parentColumn: null,
                                isNested: false
                            };
                        }
                        for (const column of row.columns){
                            if (column.rows) {
                                for (const nestedRow of column.rows){
                                    if (nestedRow.id === targetRowId) {
                                        const nestedColumn = nestedRow.columns.find((c)=>c.id === targetColumnId);
                                        if (nestedColumn) return {
                                            column: nestedColumn,
                                            row: nestedRow,
                                            parentColumn: column,
                                            isNested: true
                                        };
                                    }
                                }
                            }
                        }
                    }
                    return {
                        column: null,
                        row: null,
                        parentColumn: null,
                        isNested: false
                    };
                };
                const sectionDraft = draft.sections.find((s)=>s.id === sectionId);
                if (!sectionDraft) return;
                const { column } = findColumnInSection(sectionDraft, rowId, columnId);
                if (!column) return;
                const elementIndex = column.elements.findIndex((e)=>e.id === elementId);
                if (elementIndex === -1) return;
                const newIndex = direction === "up" ? Math.max(0, elementIndex - 1) : Math.min(column.elements.length - 1, elementIndex + 1);
                if (newIndex === elementIndex) return;
                const [element] = column.elements.splice(elementIndex, 1);
                column.elements.splice(newIndex, 0, element);
            });
            // Create a history entry
            const historyEntry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createHistoryEntryFromChange"])(page, newPage, "Reorder Element");
            set({
                page: newPage,
                history: historyEntry ? [
                    ...history,
                    historyEntry
                ] : history,
                future: [],
                canUndo: history.length > 0 || !!historyEntry,
                canRedo: false
            });
        },
        reorderColumn: (columnId, sectionId, rowId, parentRowId, direction)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Reorder Column");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const section = draft.find((s)=>s.id === sectionId);
                if (!section) return;
                let targetRow, parentColumn;
                if (parentRowId) {
                    for (const topRow of section.rows){
                        for (const col of topRow.columns){
                            if (col.rows) {
                                const nestedRow = col.rows.find((r)=>r.id === rowId);
                                if (nestedRow) {
                                    targetRow = nestedRow;
                                    parentColumn = col;
                                    break;
                                }
                            }
                        }
                        if (targetRow) break;
                    }
                } else {
                    targetRow = section.rows.find((r)=>r.id === rowId);
                }
                if (!targetRow) return;
                const columnIndex = targetRow.columns.findIndex((c)=>c.id === columnId);
                if (columnIndex === -1) return;
                const newIndex = direction === "up" ? Math.max(0, columnIndex - 1) : Math.min(targetRow.columns.length - 1, columnIndex + 1);
                if (newIndex === columnIndex) return;
                const [column] = targetRow.columns.splice(columnIndex, 1);
                targetRow.columns.splice(newIndex, 0, column);
                const newWidth = 100 / targetRow.columns.length;
                targetRow.columns.forEach((col)=>col.width = Number.parseFloat(newWidth.toFixed(2)));
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        reorderRow: (rowId, sectionId, parentColumnId, direction)=>{
            const { page, history, historyIndex } = get();
            const newHistory = createHistorySnapshot(page, history, "Reorder Row");
            const updatedSections = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(page.sections, (draft)=>{
                const section = draft.find((s)=>s.id === sectionId);
                if (!section) return;
                if (!parentColumnId) {
                    const rowIndex = section.rows.findIndex((r)=>r.id === rowId);
                    if (rowIndex === -1) return;
                    const newIndex = direction === "up" ? Math.max(0, rowIndex - 1) : Math.min(section.rows.length - 1, rowIndex + 1);
                    if (newIndex === rowIndex) return;
                    const [row] = section.rows.splice(rowIndex, 1);
                    section.rows.splice(newIndex, 0, row);
                } else {
                    let parentColumn = null;
                    for (const r of section.rows){
                        for (const c of r.columns){
                            if (c.id === parentColumnId) {
                                parentColumn = c;
                                break;
                            }
                        }
                        if (parentColumn) break;
                    }
                    if (!parentColumn || !parentColumn.rows) return;
                    const rowIndex = parentColumn.rows.findIndex((r)=>r.id === rowId);
                    if (rowIndex === -1) return;
                    const newIndex = direction === "up" ? Math.max(0, rowIndex - 1) : Math.min(parentColumn.rows.length - 1, rowIndex + 1);
                    if (newIndex === rowIndex) return;
                    const [row] = parentColumn.rows.splice(rowIndex, 1);
                    parentColumn.rows.splice(newIndex, 0, row);
                }
            });
            set({
                page: {
                    ...page,
                    sections: updatedSections
                },
                history: newHistory,
                historyIndex: newHistory.length - 1,
                canUndo: true,
                canRedo: false
            });
        },
        setCurrentPageInfo: (pageInfo)=>{
            set({
                currentPageId: pageInfo.id,
                currentPageTitle: pageInfo.title
            });
        },
        savePage: async ()=>null,
        setPageSnapshots: (pageId, snapshots)=>{
            set((state)=>({
                    pageSnapshots: {
                        ...state.pageSnapshots,
                        [pageId]: snapshots
                    }
                }));
        }
    }), {
    name: "builderStore"
}));
// Helper function to find the duplicated element ID
function findDuplicatedElementId(oldPage, newPage) {
    // Find elements that exist in the new page but not in the old page
    const oldElements = getAllElementIds(oldPage);
    const newElements = getAllElementIds(newPage);
    const newElementIds = newElements.filter((id)=>!oldElements.includes(id));
    return newElementIds.length > 0 ? newElementIds[0] : null;
}
// Helper function to get all element IDs from a page
function getAllElementIds(page) {
    const ids = [];
    // Add page-level elements
    if (page.elements) {
        ids.push(...page.elements.map((el)=>el.id));
    }
    // Add elements from sections - ensure sections is an array
    const sections = Array.isArray(page.sections) ? page.sections : [];
    sections.forEach((section)=>{
        section.rows.forEach((row)=>{
            row.columns.forEach((column)=>{
                // Add elements from this column
                ids.push(...column.elements.map((el)=>el.id));
                // Add elements from nested rows
                if (column.rows) {
                    column.rows.forEach((nestedRow)=>{
                        nestedRow.columns.forEach((nestedColumn)=>{
                            ids.push(...nestedColumn.elements.map((el)=>el.id));
                        });
                    });
                }
            });
        });
    });
    return ids;
}
/* =====================================================
   HELPER FUNCTIONS
===================================================== */ /**
 * In case you still need to clone sections outside of a state update, this returns a deep clone.
 * (Alternatively, remove this helper if you exclusively use produce.)
 */ function cloneSections(sections) {
    return JSON.parse(JSON.stringify(sections));
}
/**
 * Creates a selective clone of the page for history persisting.
 */ function selectiveClonePage(page) {
    return {
        id: page.id,
        title: page.title,
        sections: Array.isArray(page.sections) ? cloneSections(page.sections) : [],
        elements: Array.isArray(page.elements) ? page.elements.map((el)=>({
                ...el
            })) : []
    };
}
function createHistorySnapshot(page, history, action = "Update") {
    // Create a deep clone of the page to avoid modifying the original
    const clonedPage = JSON.parse(JSON.stringify(page));
    // Create an empty history entry
    const emptyPage = {
        id: page.id,
        title: page.title,
        sections: [],
        elements: []
    };
    // Create patches
    const patches = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createPatch"])(emptyPage, clonedPage);
    const inversePatches = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$builder$2f$patch$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createPatch"])(clonedPage, emptyPage);
    const newEntry = {
        action,
        patches,
        inversePatches
    };
    return [
        ...history,
        newEntry
    ];
}
/**
 * Creates a deep clone of the page.
 */ function deepClonePage(obj) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(obj, (draft)=>{});
}
function createEmptyRow(nestingLevel = 1) {
    return {
        id: generateId("row"),
        columns: [],
        settings: {
            gutter: 20,
            paddingTop: 20,
            paddingRight: 0,
            paddingBottom: 20,
            paddingLeft: 0,
            verticalAlign: "top"
        },
        nestingLevel
    };
}
/**
 * Creates an empty column.
 */ function createEmptyColumn(nestingLevel = 1) {
    return {
        id: generateId("column"),
        width: 100,
        elements: [],
        settings: {
            paddingTop: 15,
            paddingRight: 15,
            paddingBottom: 15,
            paddingLeft: 15,
            marginTop: 0,
            marginRight: 0,
            marginBottom: 0,
            marginLeft: 0
        },
        nestingLevel
    };
}
/**
 * Merges default element settings.
 */ function createElementWithDefaultSettings(element) {
    return {
        ...element,
        settings: {
            width: "100%",
            height: "auto",
            paddingTop: 16,
            paddingRight: 16,
            paddingBottom: 16,
            paddingLeft: 16,
            marginTop: 0,
            marginRight: 0,
            marginBottom: 16,
            marginLeft: 0,
            ...element.settings
        }
    };
}
/**
 * Recalculates widths for columns.
 */ function recalcWidths(columns) {
    if (columns.length === 0) return columns;
    if (columns.length === 1) return [
        {
            ...columns[0],
            width: 100
        }
    ];
    const newWidth = Number.parseFloat((100 / columns.length).toFixed(2));
    return columns.map((col)=>({
            ...col,
            width: newWidth
        }));
}
function generateId(prefix) {
    return `${prefix}-${Date.now()}-${Math.random().toString(36).substr(2, 5)}`;
}
/**
 * Updates an element within a column.
 */ function updateElementInColumn(column, elementId, updateElement) {
    return {
        ...column,
        elements: column.elements.map((el)=>el.id === elementId ? updateElement() : el)
    };
}
/**
 * Recursively updates an element by ID.
 */ function updateElementRecursive(sections, elementId, updatedElement) {
    const registry = new BuilderRegistry(sections);
    const elementInfo = registry.getElement(elementId);
    if (!elementInfo) return sections;
    const { column, row, section } = elementInfo;
    return updateSectionInArray(sections, section.id, (s)=>updateRowInSection(s, row.id, (r)=>updateColumnInRow(r, column.id, (c)=>updateElementInColumn(c, elementId, ()=>updatedElement))));
}
/**
 * Recursively deletes an element.
 */ function deleteElementRecursive(sections, elementId) {
    const registry = new BuilderRegistry(sections);
    const elementInfo = registry.getElement(elementId);
    if (!elementInfo) return sections;
    const { column, row, section } = elementInfo;
    return updateSectionInArray(sections, section.id, (s)=>updateRowInSection(s, row.id, (r)=>updateColumnInRow(r, column.id, (c)=>removeElementFromColumn(c, elementId))));
}
/**
 * Recursively duplicates an element.
 */ function duplicateElementRecursive(sections, elementId) {
    const registry = new BuilderRegistry(sections);
    const elementInfo = registry.getElement(elementId);
    if (!elementInfo) return {
        sections
    };
    const { element, column, row, section } = elementInfo;
    const duplicatedElement = {
        ...element,
        id: generateId("element")
    };
    const elementIndex = column.elements.findIndex((el)=>el.id === elementId);
    const updatedSections = updateSectionInArray(sections, section.id, (s)=>updateRowInSection(s, row.id, (r)=>updateColumnInRow(r, column.id, (c)=>{
                const updatedElements = [
                    ...c.elements
                ];
                updatedElements.splice(elementIndex + 1, 0, duplicatedElement);
                return {
                    ...c,
                    elements: updatedElements
                };
            })));
    return {
        sections: updatedSections,
        duplicatedElement
    };
}
/**
 * Recursively updates a row.
 */ function updateRowRecursive(sections, rowId, updatedRow) {
    const registry = new BuilderRegistry(sections);
    const rowInfo = registry.getRow(rowId);
    if (!rowInfo) return sections;
    const { row, section, parentColumnId } = rowInfo;
    if (parentColumnId) {
        return updateSectionInArray(sections, section.id, (s)=>{
            const updateNestedRow = (columns)=>columns.map((col)=>col.id === parentColumnId ? {
                        ...col,
                        rows: col.rows?.map((r)=>r.id === rowId ? updatedRow : r) || []
                    } : col);
            return {
                ...s,
                rows: s.rows.map((r)=>({
                        ...r,
                        columns: updateNestedRow(r.columns)
                    }))
            };
        });
    }
    return updateSectionInArray(sections, section.id, (s)=>({
            ...s,
            rows: s.rows.map((r)=>r.id === rowId ? updatedRow : r)
        }));
}
/**
 * Recursively deletes a row.
 */ function deleteRowRecursive(sections, rowId) {
    const registry = new BuilderRegistry(sections);
    const rowInfo = registry.getRow(rowId);
    if (!rowInfo) return sections;
    const { section, parentColumnId } = rowInfo;
    if (parentColumnId) {
        return updateSectionInArray(sections, section.id, (s)=>{
            const removeNestedRow = (columns)=>columns.map((col)=>col.id === parentColumnId ? {
                        ...col,
                        rows: col.rows?.filter((r)=>r.id !== rowId) || []
                    } : col);
            return {
                ...s,
                rows: s.rows.map((r)=>({
                        ...r,
                        columns: removeNestedRow(r.columns)
                    }))
            };
        });
    }
    return updateSectionInArray(sections, section.id, (s)=>({
            ...s,
            rows: s.rows.filter((r)=>r.id !== rowId)
        }));
}
/**
 * Adds a row to a column.
 */ function addRowToColumn(sections, sectionId, columnId, row) {
    const registry = new BuilderRegistry(sections);
    const columnInfo = registry.getColumn(columnId);
    if (!columnInfo) return sections;
    const { row: parentRow, section } = columnInfo;
    return updateSectionInArray(sections, section.id, (s)=>updateRowInSection(s, parentRow.id, (r)=>updateColumnInRow(r, columnId, (c)=>({
                    ...c,
                    rows: [
                        ...c.rows || [],
                        row
                    ]
                }))));
}
/**
 * Updates a section by applying an updater function.
 */ const updateSectionInArray = (sections, sectionId, updateSection)=>{
    return sections.map((section)=>section.id === sectionId ? updateSection(section) : section);
};
/**
 * Updates a row in a section.
 */ const updateRowInSection = (section, rowId, updateRow)=>{
    return {
        ...section,
        rows: section.rows.map((row)=>row.id === rowId ? updateRow(row) : row)
    };
};
/**
 * Updates a column in a row.
 */ const updateColumnInRow = (row, columnId, updateColumn)=>{
    return {
        ...row,
        columns: row.columns.map((column)=>column.id === columnId ? updateColumn(column) : column)
    };
};
/**
 * Recursively updates a column within an array of rows.
 */ function updateColumnInRows(rows, targetRowId, targetColumnId, updatedCol, parentId = null) {
    return rows.map((row)=>{
        if (row.id === targetRowId) {
            return {
                ...row,
                columns: row.columns.map((col)=>col.id === targetColumnId ? updatedCol : col)
            };
        }
        return {
            ...row,
            columns: row.columns.map((col)=>{
                if (parentId && col.id === parentId || col.rows && col.rows.length > 0) {
                    return {
                        ...col,
                        rows: col.rows ? updateColumnInRows(col.rows, targetRowId, targetColumnId, updatedCol, col.id) : col.rows
                    };
                }
                return col;
            })
        };
    });
}
/**
 * Helper to delete a column from an array of rows.
 */ function deleteColumnFromRows(rows, targetRowId, targetColumnId, parentId = null) {
    return rows.map((row)=>{
        if (row.id === targetRowId) {
            const filteredColumns = row.columns.filter((col)=>col.id !== targetColumnId);
            return {
                ...row,
                columns: recalcWidths(filteredColumns)
            };
        }
        return {
            ...row,
            columns: row.columns.map((col)=>{
                if (col.rows && col.rows.length > 0) {
                    return {
                        ...col,
                        rows: deleteColumnFromRows(col.rows, targetRowId, targetColumnId, col.id)
                    };
                }
                return col;
            })
        };
    });
}
/**
 * Removes an element from a column.
 */ const removeElementFromColumn = (column, elementId)=>{
    return {
        ...column,
        elements: column.elements.filter((el)=>el.id !== elementId)
    };
};
/**
 * Finds a column by ID.
 */ function findColumnById(sections, columnId) {
    const registry = new BuilderRegistry(sections);
    return registry.getColumn(columnId);
}
/**
 * Finds a row by ID.
 */ function findRowById(sections, rowId) {
    const registry = new BuilderRegistry(sections);
    return registry.getRow(rowId);
}
/**
 * Finds an element by ID.
 */ function findElementById(sections, elementId) {
    const registry = new BuilderRegistry(sections);
    return registry.getElement(elementId);
}
class BuilderRegistry {
    sections;
    elementMap;
    columnMap;
    rowMap;
    constructor(sections){
        this.sections = sections;
        this.elementMap = new Map();
        this.columnMap = new Map();
        this.rowMap = new Map();
        this.populateMaps(sections);
    }
    populateMaps(sections) {
        sections.forEach((section)=>{
            section.rows.forEach((row)=>{
                this.rowMap.set(row.id, {
                    row,
                    section
                });
                row.columns.forEach((column)=>{
                    this.columnMap.set(column.id, {
                        column,
                        row,
                        section
                    });
                    column.elements.forEach((element)=>{
                        this.elementMap.set(element.id, {
                            element,
                            column,
                            row,
                            section
                        });
                    });
                    if (column.rows) {
                        column.rows.forEach((nestedRow)=>{
                            this.rowMap.set(nestedRow.id, {
                                row: nestedRow,
                                section,
                                parentColumnId: column.id
                            });
                            nestedRow.columns.forEach((nestedColumn)=>{
                                this.columnMap.set(nestedColumn.id, {
                                    column: nestedColumn,
                                    row: nestedRow,
                                    section,
                                    parentColumnId: column.id
                                });
                                nestedColumn.elements.forEach((element)=>{
                                    this.elementMap.set(element.id, {
                                        element,
                                        column: nestedColumn,
                                        row: nestedRow,
                                        section,
                                        parentColumnId: column.id
                                    });
                                });
                            });
                        });
                    }
                });
            });
        });
    }
    getElement(elementId) {
        return this.elementMap.get(elementId);
    }
    getColumn(columnId) {
        return this.columnMap.get(columnId);
    }
    getRow(rowId) {
        return this.rowMap.get(rowId);
    }
}
/**
 * Deep clone using Immer.
 */ function deepClone(obj) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(obj, (draft)=>{});
}
/**
 * Adds a column to a row.
 */ function addColumnToRowFn(rows, rowId, column, parentColumnId) {
    return rows.map((row)=>{
        if (row.id === rowId) {
            const updatedColumns = [
                ...row.columns,
                column
            ];
            const newWidth = 100 / updatedColumns.length;
            updatedColumns.forEach((col)=>col.width = newWidth);
            return {
                ...row,
                columns: updatedColumns
            };
        }
        return row;
    });
}
// Helper function to add a row to a column
function addRowToColumnFn(sections, sectionId, columnId, row) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(sections, (draft)=>{
        const registry = new BuilderRegistry(draft);
        const columnInfo = registry.getColumn(columnId);
        if (!columnInfo) return;
        const { row: parentRow, section } = columnInfo;
        if (!section || !parentRow) return;
        const column = parentRow.columns.find((c)=>c.id === columnId);
        if (!column) return;
        if (!column.rows) column.rows = [];
        column.rows.push(row);
    });
}
;
}),
"[project]/frontend/store/websocket-store.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__,
    "useWebSocketStore",
    ()=>useWebSocketStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$websocket$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/websocket-manager.ts [app-ssr] (ecmascript)");
;
;
const createWebSocketConnection = ()=>({
        isConnected: false,
        wsManager: null,
        subscriptions: [],
        subscriptionQueue: [],
        isTypeSubscribed: function(type, payload) {
            return this.subscriptions.some((sub)=>sub.type === type && JSON.stringify(sub.payload) === JSON.stringify(payload));
        }
    });
const useWebSocketStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((set, get)=>({
        connections: {},
        messageHandlers: {},
        createConnection: async (connectionKey, path, options)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (!path) {
                return Promise.reject("Path is invalid");
            }
            if (connection && connection.isConnected) {
                options?.onOpen?.();
                return Promise.resolve();
            }
            const wsManager = new __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$websocket$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"](path);
            set((state)=>({
                    connections: {
                        ...state.connections,
                        [connectionKey]: {
                            isConnected: false,
                            wsManager,
                            subscriptions: [],
                            subscriptionQueue: [],
                            isTypeSubscribed: createWebSocketConnection().isTypeSubscribed
                        }
                    }
                }));
            wsManager.on("open", ()=>{
                console.log("WebSocket Connected to", path);
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                isConnected: true
                            }
                        }
                    }));
                options?.onOpen?.();
                // Process subscription queue
                const connection = get().connections[connectionKey];
                connection.subscriptionQueue.forEach((sub)=>{
                    wsManager.send({
                        action: "SUBSCRIBE",
                        payload: {
                            type: sub.type,
                            ...sub.payload
                        }
                    });
                });
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                subscriptionQueue: []
                            }
                        }
                    }));
            });
            wsManager.on("close", ()=>{
                console.log("WebSocket Disconnected from", path);
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                isConnected: false
                            }
                        }
                    }));
                options?.onClose?.();
            });
            wsManager.on("error", (error)=>{
                console.error("WebSocket error on", path, ":", error);
                options?.onError?.(error);
            });
            wsManager.on("message", (message)=>{
                const handlers = get().messageHandlers[connectionKey] || [];
                handlers.forEach(({ handler, filter })=>{
                    if (filter(message)) {
                        handler(message);
                    }
                });
                options?.onMessage?.(message);
            });
            wsManager.connect();
        },
        removeConnection: (connectionKey)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (connection && connection.isConnected && connection.wsManager) {
                connection.wsManager.disconnect();
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                isConnected: false,
                                wsManager: null
                            }
                        }
                    }));
            }
        },
        send: (connectionKey, message)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (connection && connection.isConnected && connection.wsManager) {
                connection.wsManager.send(message);
            }
        },
        subscribe: (connectionKey, type, payload)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (!connection) return;
            if (!connection.isTypeSubscribed(type, payload)) {
                const newSubscription = {
                    type,
                    payload
                };
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                subscriptions: [
                                    ...state.connections[connectionKey].subscriptions,
                                    newSubscription
                                ]
                            }
                        }
                    }));
                if (connection.wsManager?.isConnected()) {
                    connection.wsManager.send({
                        action: "SUBSCRIBE",
                        payload: {
                            type,
                            ...payload
                        }
                    });
                } else {
                    set((state)=>({
                            connections: {
                                ...state.connections,
                                [connectionKey]: {
                                    ...state.connections[connectionKey],
                                    subscriptionQueue: [
                                        ...state.connections[connectionKey].subscriptionQueue,
                                        newSubscription
                                    ]
                                }
                            }
                        }));
                }
            }
        },
        unsubscribe: (connectionKey, type, payload)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (!connection) return;
            set((state)=>({
                    connections: {
                        ...state.connections,
                        [connectionKey]: {
                            ...state.connections[connectionKey],
                            subscriptions: state.connections[connectionKey].subscriptions.filter((sub)=>sub.type !== type || JSON.stringify(sub.payload) !== JSON.stringify(payload))
                        }
                    }
                }));
            if (connection.wsManager?.isConnected()) {
                connection.wsManager.send({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type,
                        ...payload
                    }
                });
            }
        },
        addMessageHandler: (connectionKey, handler, filter = ()=>true)=>{
            set((state)=>({
                    messageHandlers: {
                        ...state.messageHandlers,
                        [connectionKey]: [
                            ...state.messageHandlers[connectionKey] || [],
                            {
                                handler,
                                filter
                            }
                        ]
                    }
                }));
        },
        removeMessageHandler: (connectionKey, handler)=>{
            set((state)=>({
                    messageHandlers: {
                        ...state.messageHandlers,
                        [connectionKey]: (state.messageHandlers[connectionKey] || []).filter((item)=>item.handler !== handler)
                    }
                }));
        },
        isConnectionOpen: (connectionKey)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            return connection?.isConnected || false;
        }
    }));
const __TURBOPACK__default__export__ = useWebSocketStore;
}),
"[project]/frontend/lib/builder/patch-utils.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "applyPatch",
    ()=>applyPatch,
    "createHistoryEntryFromChange",
    ()=>createHistoryEntryFromChange,
    "createPatch",
    ()=>createPatch
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/immer@10.2.0/node_modules/immer/dist/immer.mjs [app-ssr] (ecmascript)");
;
// Enable patches in Immer
(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["enablePatches"])();
function createPatch(currentState, nextState) {
    let patches = [];
    // Use Immer's produce with patches enabled
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["produce"])(currentState, (draft)=>{
        // This is a special case where we're not actually modifying the draft
        // We're just using produce to generate patches between currentState and nextState
        Object.keys(nextState).forEach((key)=>{
            draft[key] = nextState[key];
        });
    }, (p)=>{
        patches = p;
    });
    return patches;
}
function applyPatch(state, patches) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$immer$40$10$2e$2$2e$0$2f$node_modules$2f$immer$2f$dist$2f$immer$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["applyPatches"])(state, patches);
}
function createHistoryEntryFromChange(baseState, newState, action = "State change") {
    // Create forward and inverse patches
    const patches = createPatch(baseState, newState);
    const inversePatches = createPatch(newState, baseState);
    // If no changes were made, return null
    if (patches.length === 0) {
        return null;
    }
    return {
        patches,
        inversePatches,
        action
    };
}
}),
"[project]/frontend/lib/websocket-manager.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>WebSocketManager
]);
class WebSocketManager {
    url;
    socket = null;
    reconnectAttempts = 0;
    maxReconnectAttempts = 5;
    reconnectTimeout = 1000;
    eventHandlers = {
        open: [],
        close: [],
        error: [],
        message: []
    };
    constructor(url){
        this.url = url;
    }
    connect() {
        if (this.socket && (this.socket.readyState === WebSocket.OPEN || this.socket.readyState === WebSocket.CONNECTING)) {
            return;
        }
        try {
            this.socket = new WebSocket(this.url);
            this.socket.onopen = (event)=>{
                this.reconnectAttempts = 0;
                this.eventHandlers.open.forEach((handler)=>handler(event));
            };
            this.socket.onclose = (event)=>{
                this.eventHandlers.close.forEach((handler)=>handler(event));
                this.attemptReconnect();
            };
            this.socket.onerror = (event)=>{
                this.eventHandlers.error.forEach((handler)=>handler(event));
            };
            this.socket.onmessage = (event)=>{
                try {
                    const data = JSON.parse(event.data);
                    this.eventHandlers.message.forEach((handler)=>handler(data));
                } catch (error) {
                    console.error("Failed to parse WebSocket message:", error);
                }
            };
        } catch (error) {
            console.error("WebSocket connection error:", error);
            this.attemptReconnect();
        }
    }
    attemptReconnect() {
        if (this.reconnectAttempts < this.maxReconnectAttempts) {
            this.reconnectAttempts++;
            setTimeout(()=>{
                this.connect();
            }, this.reconnectTimeout * this.reconnectAttempts);
        }
    }
    disconnect() {
        if (this.socket) {
            this.socket.close();
            this.socket = null;
        }
    }
    isConnected() {
        return this.socket !== null && this.socket.readyState === WebSocket.OPEN;
    }
    send(data) {
        if (this.isConnected() && this.socket) {
            this.socket.send(typeof data === "string" ? data : JSON.stringify(data));
        } else {
            console.warn("Cannot send message, WebSocket is not connected");
        }
    }
    on(event, handler) {
        if (this.eventHandlers[event]) {
            this.eventHandlers[event].push(handler);
        } else {
            this.eventHandlers[event] = [
                handler
            ];
        }
    }
    off(event, handler) {
        if (this.eventHandlers[event]) {
            this.eventHandlers[event] = this.eventHandlers[event].filter((h)=>h !== handler);
        }
    }
}
}),
];

//# sourceMappingURL=frontend_2596f0be._.js.map