module.exports = [
"[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "cn",
    ()=>cn,
    "formatCurrency",
    ()=>formatCurrency,
    "formatDate",
    ()=>formatDate,
    "formatTime",
    ()=>formatTime,
    "getDynamicPath",
    ()=>getDynamicPath,
    "getWords",
    ()=>getWords,
    "isLocationMatch",
    ()=>isLocationMatch,
    "isObjectNotEmpty",
    ()=>isObjectNotEmpty
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$clsx$40$2$2e$1$2e$1$2f$node_modules$2f$clsx$2f$dist$2f$clsx$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$tailwind$2d$merge$40$2$2e$6$2e$0$2f$node_modules$2f$tailwind$2d$merge$2f$dist$2f$bundle$2d$mjs$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/tailwind-merge@2.6.0/node_modules/tailwind-merge/dist/bundle-mjs.mjs [app-ssr] (ecmascript)");
;
;
function cn(...inputs) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$tailwind$2d$merge$40$2$2e$6$2e$0$2f$node_modules$2f$tailwind$2d$merge$2f$dist$2f$bundle$2d$mjs$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["twMerge"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$clsx$40$2$2e$1$2e$1$2f$node_modules$2f$clsx$2f$dist$2f$clsx$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["clsx"])(inputs));
}
function isLocationMatch(href, locationName, hasChildren = false) {
    // If the item has children, treat it as a parent route:
    //   - Active if exactly at its href (e.g. `/admin/crm`)
    //   - OR if the route starts with its href + "/" (e.g. `/admin/crm/user`)
    if (hasChildren) {
        return locationName === href || locationName.startsWith(href + "/");
    } else {
        // If no children, must be an exact match
        return locationName === href;
    }
}
const formatTime = (time)=>{
    if (!time) return "";
    const date = new Date(time);
    const formattedTime = date.toLocaleTimeString([], {
        hour: "2-digit",
        minute: "2-digit",
        hour12: true
    });
    return formattedTime;
};
function isObjectNotEmpty(obj) {
    if (typeof obj !== "object" || obj === null) {
        return false;
    }
    return Object.keys(obj).length > 0;
}
function formatDate(dateInput) {
    const date = typeof dateInput === "string" ? new Date(dateInput) : dateInput;
    return date.toLocaleDateString(undefined, {
        year: "numeric",
        month: "short",
        day: "numeric"
    });
}
function getWords(inputString) {
    // Remove spaces from the input string
    const stringWithoutSpaces = inputString.replace(/\s/g, "");
    // Extract the first three characters
    return stringWithoutSpaces.substring(0, 3);
}
function getDynamicPath(pathname) {
    // Get configured locales from environment variable
    const languagesString = ("TURBOPACK compile-time value", "en") || "";
    const configuredLocales = languagesString.split(/[,\n\r]+/).map((code)=>code.trim()).filter((code)=>code.length > 0);
    // Use configured locales or fallback to common ones
    const locales = configuredLocales.length > 0 ? configuredLocales : [
        "en",
        "ar"
    ];
    for (const locale of locales){
        if (pathname.startsWith(`/${locale}/`)) {
            return `/${pathname.slice(locale.length + 2)}`;
        }
    }
    return pathname;
}
const formatCurrency = (amount, currency)=>{
    // List of valid ISO 4217 currency codes that Intl.NumberFormat supports
    const validCurrencyCodes = [
        "USD",
        "EUR",
        "GBP",
        "JPY",
        "AUD",
        "CAD",
        "CHF",
        "CNY",
        "SEK",
        "NZD",
        "MXN",
        "SGD",
        "HKD",
        "NOK",
        "TRY",
        "ZAR",
        "BRL",
        "INR",
        "KRW",
        "RUB"
    ];
    // Check if the currency is a valid ISO currency code
    const isValidCurrency = validCurrencyCodes.includes(currency.toUpperCase());
    if (isValidCurrency) {
        try {
            return new Intl.NumberFormat("en-US", {
                style: "currency",
                currency
            }).format(amount);
        } catch (error) {
            // Fallback if there's still an error
            return `${currency} ${amount.toFixed(2)}`;
        }
    } else {
        // For cryptocurrencies and other non-ISO currencies, format manually
        const formattedValue = new Intl.NumberFormat("en-US", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 8
        }).format(amount);
        return `${formattedValue} ${currency}`;
    }
};
}),
"[project]/frontend/lib/api.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// lib/api.ts
__turbopack_context__.s([
    "$fetch",
    ()=>$fetch,
    "$serverFetch",
    ()=>$serverFetch,
    "default",
    ()=>__TURBOPACK__default__export__,
    "fileToBase64",
    ()=>fileToBase64
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/sonner@1.7.4_react-dom@19.1.1_react@19.1.1__react@19.1.1/node_modules/sonner/dist/index.mjs [app-ssr] (ecmascript)");
;
// Helper function to get the correct API base URL
function getApiBaseUrl() {
    const isDev = ("TURBOPACK compile-time value", "development") === "development";
    const backendPort = ("TURBOPACK compile-time value", "4000") || 4000;
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
    // Server-side
    if ("TURBOPACK compile-time truthy", 1) {
        return `http://localhost:${backendPort}`;
    }
    //TURBOPACK unreachable
    ;
}
function fileToBase64(file) {
    return new Promise((resolve, reject)=>{
        if (!(file instanceof Blob)) {
            reject(new Error("The provided value is not a Blob or File."));
            return;
        }
        const reader = new FileReader();
        reader.onloadend = ()=>{
            resolve(reader.result);
        };
        reader.onerror = (error)=>{
            reject(new Error(`FileReader error: ${error}`));
        };
        reader.readAsDataURL(file);
    });
}
async function $fetch({ url, method = "GET", body = null, headers = {}, params = {}, successMessage = "Success", errorMessage = "Something went wrong", silent = false, silentSuccess = false }) {
    const toastId = !silent ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].loading("Loading...") : null;
    // Check if body is FormData
    const isFormData = body instanceof FormData;
    // Don't set Content-Type for FormData, let browser set it with boundary
    const defaultHeaders = isFormData ? {
        ...headers
    } : {
        "Content-Type": "application/json",
        ...headers
    };
    let urlWithQuery = url;
    try {
        // Construct full URL with proper base URL
        const baseUrl = getApiBaseUrl();
        const fullUrl = url.startsWith("http") ? url : `${baseUrl}${url}`;
        // Handle query parameters
        if (Object.keys(params).length > 0) {
            const urlObj = new URL(fullUrl);
            Object.entries(params).forEach(([key, value])=>{
                urlObj.searchParams.set(key, String(value));
            });
            urlWithQuery = urlObj.toString();
        } else {
            urlWithQuery = fullUrl;
        }
        const fetchOptions = {
            method,
            headers: defaultHeaders,
            credentials: "include",
            body: isFormData ? body : body ? JSON.stringify(body) : null
        };
        const response = await fetch(urlWithQuery, fetchOptions);
        if (!silent && toastId !== null) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].dismiss(toastId);
        // Check if response is ok before proceeding
        if (!response.ok && response.status === 0) {
            throw new TypeError("Failed to fetch");
        }
        // Handle response parsing more safely
        let data = null;
        try {
            const responseText = await response.text();
            if (responseText) {
                try {
                    data = JSON.parse(responseText);
                } catch (parseError) {
                    // For non-JSON responses (like 404 "Not Found"), handle gracefully
                    const isNotFoundError = responseText.includes("Not Found") || response.status === 404;
                    if (isNotFoundError) {
                        if (!silent && toastId !== null) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].dismiss(toastId);
                        return {
                            data: null,
                            error: "Resource not found"
                        };
                    }
                    console.warn("Failed to parse response as JSON:", parseError);
                    if (!silent && toastId !== null) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].dismiss(toastId);
                    if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(errorMessage);
                    return {
                        data: null,
                        error: "Invalid response format"
                    };
                }
            } else {
                // Handle empty response
                if (!response.ok) {
                    if (!silent && toastId !== null) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].dismiss(toastId);
                    if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(errorMessage);
                    return {
                        data: null,
                        error: `Request failed with status ${response.status}`
                    };
                }
                // Empty response but status is OK
                return {
                    data: null,
                    error: null
                };
            }
        } catch (parseError) {
            console.warn("Failed to read response:", parseError);
            if (!silent && toastId !== null) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].dismiss(toastId);
            if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(errorMessage);
            return {
                data: null,
                error: "Failed to read response"
            };
        }
        if (response.ok) {
            // Check if the response data indicates an error even though status is 2xx
            if (data && typeof data === "object") {
                const d = data;
                // Debug logging for statusCode detection
                if (("TURBOPACK compile-time value", "development") === "development" && d.statusCode) {
                    console.log("Response contains statusCode:", d.statusCode, "Type:", typeof d.statusCode, "Number:", Number(d.statusCode));
                }
                // Check for status code in response body (new error format)
                if (d.statusCode && Number(d.statusCode) >= 400) {
                    console.log("Detected error statusCode in response body, calling handleBodyIndicatedError");
                    return handleBodyIndicatedError(d, silent, errorMessage);
                }
                // Legacy error format check
                if (d.success === false || d.error || d.errors) {
                    console.log("Detected legacy error format, calling handleBodyIndicatedError");
                    return handleBodyIndicatedError(d, silent, errorMessage);
                }
            }
            // Otherwise treat as success
            handleSuccess(data, successMessage, silent, silentSuccess);
            return {
                data: data,
                error: null
            };
        } else {
            // Non-2xx status, standard error handling
            return await handleError(response, data, silent, errorMessage);
        }
    } catch (error) {
        return handleNetworkError(error, silent, toastId);
    }
}
function handleSuccess(data, successMessage, silent, silentSuccess) {
    if (silent || silentSuccess) return;
    let messageToShow = "Success";
    if (typeof successMessage === "function") {
        messageToShow = successMessage(data);
    } else {
        messageToShow = successMessage;
    }
    if (messageToShow === "Success" && data && typeof data === "object" && data.message) {
        messageToShow = data.message;
    }
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].success(messageToShow);
}
function handleBodyIndicatedError(data, silent, errorMessage) {
    // Get message from data, prioritizing the message field
    const message = data.message || errorMessage;
    // Debug logging to help diagnose toast issues
    if ("TURBOPACK compile-time truthy", 1) {
        console.log("handleBodyIndicatedError called:", {
            data,
            silent,
            message
        });
    }
    // Check if the response already contains validationErrors
    if (data.validationErrors) {
        if (!silent) {
            console.log("Showing validation error toast");
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error("Validation failed. Please check the required fields.");
        }
        return {
            data: null,
            error: message,
            validationErrors: data.validationErrors
        };
    }
    const parsedValidation = attemptParseValidationErrors(message);
    if (parsedValidation) {
        if (!silent) {
            console.log("Showing validation error toast");
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error("Validation error");
        }
        return {
            data: null,
            error: "Validation error",
            validationErrors: parsedValidation
        };
    }
    if (!silent) {
        console.log("Showing error toast:", message);
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(message);
    }
    return {
        data: null,
        error: message
    };
}
async function handleError(response, data, silent, errorMessage) {
    // First check if data contains a status code (new error format)
    if (data && typeof data === "object" && data.statusCode && Number(data.statusCode) >= 400) {
        const message = data.message || errorMessage;
        // Check if the response already contains validationErrors
        if (data.validationErrors) {
            if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error("Validation failed. Please check the required fields.");
            return {
                data: null,
                error: message,
                validationErrors: data.validationErrors
            };
        }
        const parsedValidation = attemptParseValidationErrors(message);
        if (parsedValidation) {
            if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error("Validation error");
            return {
                data: null,
                error: "Validation error",
                validationErrors: parsedValidation
            };
        }
        if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(message);
        return {
            data: null,
            error: message
        };
    }
    // Fallback to legacy error handling
    const message = data && data.message || response.statusText || errorMessage;
    const parsedValidation = attemptParseValidationErrors(message);
    if (parsedValidation) {
        if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error("Validation error");
        return {
            data: null,
            error: "Validation error",
            validationErrors: parsedValidation
        };
    }
    if (!silent) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(message);
    return {
        data: null,
        error: message
    };
}
function attemptParseValidationErrors(message) {
    if (!message) return null;
    // Invalid request body scenario
    if (message.startsWith("Invalid request body:")) {
        const cleanMessage = message.replace("Invalid request body:", "").trim();
        try {
            const errorObjectRaw = JSON.parse(cleanMessage);
            return parseDotNotatedJsonToNestedObject(errorObjectRaw);
        } catch  {
            return null;
        }
    }
    // Generic validation error lines
    if (message.includes("Validation error:")) {
        return parseValidationError(message);
    }
    return null;
}
function parseDotNotatedJsonToNestedObject(errorObjectRaw) {
    const nestedErrors = {};
    Object.entries(errorObjectRaw).forEach(([key, value])=>{
        const path = key.split(".");
        path.reduce((acc, part, index)=>{
            if (index === path.length - 1) {
                acc[part] = Array.isArray(value) ? value[0] : value;
            } else {
                acc[part] = acc[part] || {};
            }
            return acc[part];
        }, nestedErrors);
    });
    return nestedErrors;
}
function parseValidationError(errorMessage) {
    const errorLines = errorMessage.split("\n");
    const errors = {};
    errorLines.forEach((line)=>{
        const cleanLine = line.replace("Validation error: ", "");
        const firstColonIndex = cleanLine.indexOf(":");
        if (firstColonIndex !== -1) {
            const key = cleanLine.substring(0, firstColonIndex).trim();
            const msg = cleanLine.substring(firstColonIndex + 1).trim();
            errors[key] = msg;
        }
    });
    return errors;
}
function handleNetworkError(error, silent, toastId) {
    console.error("Fetch error:", error);
    if (!silent) {
        if (toastId !== null) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].dismiss(toastId);
        }
        let message = "Network error";
        if (error instanceof TypeError && error.message === "Failed to fetch") {
            message = "Backend server is not running. Please start the backend server on port 4000.";
        } else if (error instanceof Error) {
            message = error.message;
        }
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$sonner$40$1$2e$7$2e$4_react$2d$dom$40$19$2e$1$2e$1_react$40$19$2e$1$2e$1_$5f$react$40$19$2e$1$2e$1$2f$node_modules$2f$sonner$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["toast"].error(message);
    }
    return {
        data: null,
        error: error instanceof Error ? error.message : "Unknown error"
    };
}
async function $serverFetch(context, { url, method = "GET", body = null, headers = {} }) {
    // Use the same API base URL logic for server-side calls
    const baseUrl = getApiBaseUrl();
    const fullUrl = url.startsWith("http") ? url : `${baseUrl}${url}`;
    const defaultHeaders = {
        "Content-Type": "application/json",
        ...headers
    };
    const fetchOptions = {
        method,
        headers: defaultHeaders,
        body: body ? JSON.stringify(body) : null
    };
    try {
        const response = await fetch(fullUrl, fetchOptions);
        // Handle response parsing more safely
        let data = null;
        try {
            const responseText = await response.text();
            if (responseText) {
                data = JSON.parse(responseText);
            }
        } catch (parseError) {
            console.warn("Failed to parse server response as JSON:", parseError);
            return {
                data: null,
                error: "Invalid server response format"
            };
        }
        if (!response.ok) {
            const errorMessage = data?.message || response.statusText || "Server Error";
            return {
                data: null,
                error: errorMessage
            };
        }
        // Check for status code in response body (new error format)
        if (data && typeof data === "object") {
            const d = data;
            if (d.statusCode && Number(d.statusCode) >= 400) {
                const errorMessage = d.message || "Server Error";
                return {
                    data: null,
                    error: errorMessage
                };
            }
        }
        return {
            data,
            error: null
        };
    } catch (error) {
        console.error("Server-side Fetch error:", error);
        return {
            data: null,
            error: "Server Error"
        };
    }
}
const __TURBOPACK__default__export__ = $fetch;
}),
"[project]/frontend/lib/extensions.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ExtensionChecker",
    ()=>ExtensionChecker,
    "areExtensionsAvailable",
    ()=>areExtensionsAvailable,
    "isExtensionAvailable",
    ()=>isExtensionAvailable,
    "useExtensionChecker",
    ()=>useExtensionChecker
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/config.ts [app-ssr] (ecmascript)");
;
class ExtensionChecker {
    static instance;
    availableExtensions = new Set();
    initialized = false;
    constructor(){}
    static getInstance() {
        if (!ExtensionChecker.instance) {
            ExtensionChecker.instance = new ExtensionChecker();
        }
        return ExtensionChecker.instance;
    }
    /**
   * Initialize the extension checker with available extensions
   */ initialize(extensions) {
        this.availableExtensions = new Set(extensions);
        this.initialized = true;
    }
    /**
   * Check if an extension is available
   */ isExtensionAvailable(extensionName) {
        if (!this.initialized) {
            // If not initialized, try to get extensions from config store
            const configStore = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"].getState();
            if (configStore.extensions && configStore.extensions.length > 0) {
                this.initialize(configStore.extensions);
            } else {
                // If no extensions available, return false
                return false;
            }
        }
        return this.availableExtensions.has(extensionName);
    }
    /**
   * Check if multiple extensions are available
   */ areExtensionsAvailable(extensionNames) {
        return extensionNames.every((name)=>this.isExtensionAvailable(name));
    }
    /**
   * Get all available extensions
   */ getAvailableExtensions() {
        if (!this.initialized) {
            const configStore = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"].getState();
            if (configStore.extensions && configStore.extensions.length > 0) {
                this.initialize(configStore.extensions);
            }
        }
        return Array.from(this.availableExtensions);
    }
    /**
   * Update available extensions (useful when extensions are dynamically loaded)
   */ updateExtensions(extensions) {
        this.initialize(extensions);
    }
}
function isExtensionAvailable(extensionName) {
    return ExtensionChecker.getInstance().isExtensionAvailable(extensionName);
}
function areExtensionsAvailable(extensionNames) {
    return ExtensionChecker.getInstance().areExtensionsAvailable(extensionNames);
}
function useExtensionChecker() {
    const { extensions } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"])();
    // Initialize extension checker with current extensions
    const checker = ExtensionChecker.getInstance();
    if (extensions && extensions.length > 0) {
        checker.initialize(extensions);
    }
    return {
        isExtensionAvailable: (extensionName)=>checker.isExtensionAvailable(extensionName),
        areExtensionsAvailable: (extensionNames)=>checker.areExtensionsAvailable(extensionNames),
        getAvailableExtensions: ()=>checker.getAvailableExtensions(),
        // Re-export extensions for dependency tracking
        extensions
    };
}
}),
"[project]/frontend/lib/siteInfo.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "frontendUrl",
    ()=>frontendUrl,
    "siteDescription",
    ()=>siteDescription,
    "siteName",
    ()=>siteName,
    "siteUrl",
    ()=>siteUrl
]);
const dev = ("TURBOPACK compile-time value", "development") !== "production";
const frontendPort = ("TURBOPACK compile-time value", "3000") || 3000;
const backendPort = ("TURBOPACK compile-time value", "4000") || 4000;
const frontendUrl = ("TURBOPACK compile-time truthy", 1) ? `http://localhost:${frontendPort}` : "TURBOPACK unreachable";
const siteUrl = ("TURBOPACK compile-time truthy", 1) ? `http://localhost:${backendPort}` : "TURBOPACK unreachable";
const siteName = ("TURBOPACK compile-time value", "Bicrypto") || "Bicrypto";
const siteDescription = ("TURBOPACK compile-time value", "Bicrypto is a cryptocurrency exchange platform, where you can trade Bitcoin, Ethereum, Litecoin, and other cryptocurrencies.") || "Bicrypto";
}),
"[project]/frontend/lib/variants/layout.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "footerVariants",
    ()=>footerVariants,
    "headerVariants",
    ()=>headerVariants,
    "mapFooterType",
    ()=>mapFooterType,
    "mapNavbarType",
    ()=>mapNavbarType
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$class$2d$variance$2d$authority$40$0$2e$7$2e$1$2f$node_modules$2f$class$2d$variance$2d$authority$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/class-variance-authority@0.7.1/node_modules/class-variance-authority/dist/index.mjs [app-ssr] (ecmascript)");
;
const headerVariants = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$class$2d$variance$2d$authority$40$0$2e$7$2e$1$2f$node_modules$2f$class$2d$variance$2d$authority$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cva"])("z-50", {
    variants: {
        navbarType: {
            sticky: "sticky top-0 z-50",
            floating: "has-sticky-header rounded-md sticky top-6 px-6",
            default: "",
            hidden: ""
        }
    },
    defaultVariants: {
        navbarType: "default"
    }
});
const footerVariants = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$class$2d$variance$2d$authority$40$0$2e$7$2e$1$2f$node_modules$2f$class$2d$variance$2d$authority$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cva"])("", {
    variants: {
        footerType: {
            sticky: "sticky bottom-0",
            default: ""
        }
    },
    defaultVariants: {
        footerType: "default"
    }
});
function mapNavbarType(navbarType) {
    if (navbarType === "sticky") return "sticky";
    if (navbarType === "floating") return "floating";
    if (navbarType === "hidden") return "hidden";
    return "default";
}
function mapFooterType(footerType) {
    return footerType === "sticky" ? "sticky" : "default";
}
}),
"[project]/frontend/utils/kyc.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// User type definition based on backend model
__turbopack_context__.s([
    "getKycRequirement",
    ()=>getKycRequirement,
    "getUserKycLevel",
    ()=>getUserKycLevel,
    "hasFeature",
    ()=>hasFeature,
    "isKycEnabled",
    ()=>isKycEnabled,
    "isUserKycApproved",
    ()=>isUserKycApproved,
    "needsHigherKycLevel",
    ()=>needsHigherKycLevel,
    "needsKycVerification",
    ()=>needsKycVerification,
    "requiresKyc",
    ()=>requiresKyc
]);
function isKycEnabled(settings) {
    return settings?.kycStatus === true || settings?.kycStatus === "true";
}
function isUserKycApproved(user) {
    if (!user) return false;
    // Check the kyc object for approved status
    return !!user.kyc && user.kyc.status === "APPROVED";
}
function hasFeature(user, feature) {
    if (!user) {
        return false;
    }
    // First check if KYC is approved - if not, user has no features
    if (!isUserKycApproved(user)) {
        return false;
    }
    // Normalize feature name to handle case variations
    const normalizedFeature = feature.toLowerCase();
    // Get the user's KYC level
    const userLevel = user.kycLevel || user.kyc?.level?.level || 0;
    // IMPORTANT: Special handling for high-level KYC users
    // Many sites configure their highest level differently (3, 4, 5, etc.)
    // If user has level >= 3, they should have access to all features
    if (userLevel >= 3) {
        return true;
    }
    // For sites that have many features configured (20+ features)
    // This likely means they want to give access to most/all features
    const MIN_FEATURES_FOR_FULL_ACCESS = 20;
    // Check featureAccess array (primary source set by backend)
    if (Array.isArray(user.featureAccess)) {
        // If user has many features (20+), grant access to all
        if (user.featureAccess.length >= MIN_FEATURES_FOR_FULL_ACCESS) {
            return true;
        }
        // Empty array with approved KYC and level > 0 means all features
        if (user.featureAccess.length === 0 && userLevel > 0) {
            return true;
        }
        // Check if specific feature is in the array
        const hasFeatureInArray = user.featureAccess.some((f)=>f.toLowerCase() === normalizedFeature);
        if (hasFeatureInArray) {
            return true;
        }
    }
    // Check features from kyc.level (fallback)
    if (user.kyc?.level?.features) {
        let features = [];
        try {
            features = typeof user.kyc.level.features === 'string' ? JSON.parse(user.kyc.level.features) : user.kyc.level.features;
        } catch  {
            // If parsing fails, assume no features
            features = [];
        }
        if (Array.isArray(features)) {
            // If user has many features (20+), grant access to all
            if (features.length >= MIN_FEATURES_FOR_FULL_ACCESS) {
                return true;
            }
            // Empty features with approved KYC and level > 0 means all features
            if (features.length === 0 && userLevel > 0) {
                return true;
            }
            // Check if specific feature is in the array
            const hasFeatureInLevel = features.some((f)=>(typeof f === 'string' ? f.toLowerCase() : '') === normalizedFeature);
            if (hasFeatureInLevel) {
                return true;
            }
        }
    }
    // Final fallback: If KYC is approved, user has a level > 0, 
    // but no features are configured, grant access (misconfigured site)
    if (!user.featureAccess && !user.kyc?.level?.features && userLevel > 0) {
        return true;
    }
    return false;
}
function getUserKycLevel(user) {
    if (!user) return 0;
    // Check if user has a KYC level set directly
    if (user.kycLevel) {
        return user.kycLevel;
    }
    // Fallback to kyc.level.level
    if (user.kyc?.level?.level) {
        return user.kyc.level.level;
    }
    return 0;
}
function needsKycVerification(user) {
    if (!user) return true;
    // User needs KYC if it's not approved
    return !isUserKycApproved(user);
}
function needsHigherKycLevel(user, feature) {
    if (!user) return true;
    // First check if KYC is approved
    if (!isUserKycApproved(user)) {
        return false; // They need basic KYC first, not higher level
    }
    // If KYC is approved, check if they have the feature
    return !hasFeature(user, feature);
}
function getKycRequirement(user, feature) {
    if (!user) {
        return {
            required: true,
            type: 'verification',
            message: 'Please log in to continue'
        };
    }
    // Check if basic KYC is approved
    if (!isUserKycApproved(user)) {
        return {
            required: true,
            type: 'verification',
            message: 'KYC verification required'
        };
    }
    // Check if user has access to the feature
    if (!hasFeature(user, feature)) {
        return {
            required: true,
            type: 'higher_level',
            message: `Higher KYC level required for ${feature.toLowerCase().replace(/_/g, ' ')}`
        };
    }
    // User has everything they need
    return {
        required: false,
        type: 'none',
        message: ''
    };
}
function requiresKyc(user, feature) {
    console.warn('requiresKyc() is deprecated. Use getKycRequirement() instead.');
    const requirement = getKycRequirement(user, feature);
    return requirement.required;
}
}),
"[project]/frontend/utils/ws.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// WebSocketManager.ts
__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
class WebSocketManager {
    url;
    ws = null;
    manualDisconnect = false;
    listeners = {};
    reconnectInterval;
    reconnectAttempts = 0;
    maxReconnectAttempts;
    // Ping/pong settings
    pingIntervalId = null;
    pongTimeoutId = null;
    pingIntervalMs;
    pongTimeoutMs;
    constructor(wsPath, config){
        const wsProtocol = window.location.protocol === "https:" ? "wss:" : "ws:";
        const wsHost = window.location.host.replace("3000", "4000");
        this.url = `${wsProtocol}//${wsHost}${wsPath}`;
        // Set configurable parameters with defaults.
        this.pingIntervalMs = config?.pingIntervalMs || 30000;
        this.pongTimeoutMs = config?.pongTimeoutMs || 10000;
        this.reconnectInterval = config?.reconnectInterval || 5000;
        this.maxReconnectAttempts = config?.maxReconnectAttempts || 10;
    }
    connect() {
        if (!this.ws || this.ws.readyState === WebSocket.CLOSED) {
            this.ws = new WebSocket(this.url);
            this.ws.onopen = ()=>{
                console.log("WebSocket connection opened.");
                this.manualDisconnect = false;
                this.listeners["open"]?.forEach((cb)=>cb());
                this.reconnectAttempts = 0;
            };
            this.ws.onmessage = (event)=>{
                let message;
                try {
                    message = JSON.parse(event.data);
                } catch (e) {
                    console.error("Error parsing message:", e);
                    return;
                }
                // If the server sends a PONG (in response to our PING), clear our pong timeout.
                if (message.type === "PONG") {
                    this.clearPongTimeout();
                    return;
                }
                // **NEW:** If the server sends a PING, reply with a PONG.
                if (message.type === "PING") {
                    this.send({
                        type: "PONG"
                    });
                    return;
                }
                // Process other messages.
                this.listeners["message"]?.forEach((cb)=>cb(message));
            };
            this.ws.onclose = ()=>{
                console.log("WebSocket connection closed");
                this.listeners["close"]?.forEach((cb)=>cb());
                this.stopPing();
                if (!this.manualDisconnect) {
                    this.reconnect();
                }
            };
            this.ws.onerror = (error)=>{
                console.error("WebSocket error:", error);
            };
        }
    }
    disconnect() {
        if (this.ws) {
            this.manualDisconnect = true;
            this.ws.close();
            this.ws = null;
            this.stopPing();
        }
    }
    send(message) {
        if (this.ws && this.ws.readyState === WebSocket.OPEN) {
            this.ws.send(JSON.stringify(message));
        } else if (!this.manualDisconnect) {
            console.error("WebSocket connection not open.");
        }
    }
    on(event, callback) {
        if (!this.listeners[event]) {
            this.listeners[event] = [];
        }
        this.listeners[event].push(callback);
    }
    off(event, callback) {
        if (this.listeners[event]) {
            this.listeners[event] = this.listeners[event].filter((cb)=>cb !== callback);
        }
    }
    isConnected() {
        return this.ws?.readyState === WebSocket.OPEN;
    }
    reconnect() {
        if (this.reconnectAttempts < this.maxReconnectAttempts) {
            setTimeout(()=>this.connect(), this.reconnectInterval);
            this.reconnectAttempts++;
            console.log(`Reconnection attempt ${this.reconnectAttempts}`);
        } else {
            console.log("Max reconnection attempts reached, giving up.");
        }
    }
    // --- Ping-Pong Methods ---
    startPing() {
        this.pingIntervalId = setInterval(()=>{
            if (this.ws && this.ws.readyState === WebSocket.OPEN) {
                this.send({
                    type: "PING"
                });
                // Start a timeout waiting for pong response.
                this.pongTimeoutId = setTimeout(()=>{
                    console.error("Pong not received in time, closing connection.");
                    this.ws?.close();
                }, this.pongTimeoutMs);
            }
        }, this.pingIntervalMs);
    }
    stopPing() {
        if (this.pingIntervalId) {
            clearInterval(this.pingIntervalId);
            this.pingIntervalId = null;
        }
        this.clearPongTimeout();
    }
    clearPongTimeout() {
        if (this.pongTimeoutId) {
            clearTimeout(this.pongTimeoutId);
            this.pongTimeoutId = null;
        }
    }
}
const __TURBOPACK__default__export__ = WebSocketManager;
}),
"[project]/frontend/utils/validation.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "validateValue",
    ()=>validateValue,
    "validationRules",
    ()=>validationRules
]);
function validateValue(value, rules) {
    for (const rule of rules){
        if (!rule.validate(value)) {
            return {
                isValid: false,
                message: rule.message
            };
        }
    }
    return {
        isValid: true,
        message: ""
    };
}
const validationRules = {
    required: (message = "This field is required")=>({
            validate: (value)=>{
                if (value === undefined || value === null) return false;
                if (typeof value === "string") return value.trim().length > 0;
                if (typeof value === "number") return true;
                if (Array.isArray(value)) return value.length > 0;
                return !!value;
            },
            message
        }),
    minLength: (length, message = `Must be at least ${length} characters`)=>({
            validate: (value)=>{
                if (typeof value !== "string") return true;
                return value.length >= length;
            },
            message
        }),
    maxLength: (length, message = `Must be no more than ${length} characters`)=>({
            validate: (value)=>{
                if (typeof value !== "string") return true;
                return value.length <= length;
            },
            message
        }),
    email: (message = "Please enter a valid email address")=>({
            validate: (value)=>{
                if (typeof value !== "string" || !value) return true;
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return emailRegex.test(value);
            },
            message
        }),
    numeric: (message = "Must be a number")=>({
            validate: (value)=>{
                if (value === "" || value === undefined || value === null) return true;
                return !isNaN(Number(value));
            },
            message
        }),
    min: (min, message = `Must be at least ${min}`)=>({
            validate: (value)=>{
                if (value === "" || value === undefined || value === null) return true;
                return Number(value) >= min;
            },
            message
        }),
    max: (max, message = `Must be no more than ${max}`)=>({
            validate: (value)=>{
                if (value === "" || value === undefined || value === null) return true;
                return Number(value) <= max;
            },
            message
        }),
    pattern: (regex, message = "Invalid format")=>({
            validate: (value)=>{
                if (typeof value !== "string" || !value) return true;
                return regex.test(value);
            },
            message
        }),
    custom: (validateFn, message)=>({
            validate: validateFn,
            message
        })
};
}),
"[project]/frontend/utils/google-auth.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "initializeGoogleAuth",
    ()=>initializeGoogleAuth,
    "loadGoogleAuthScript",
    ()=>loadGoogleAuthScript,
    "openGoogleLoginPopup",
    ()=>openGoogleLoginPopup
]);
const loadGoogleAuthScript = ()=>{
    return new Promise((resolve, reject)=>{
        if ("TURBOPACK compile-time truthy", 1) {
            reject(new Error("Cannot load Google Auth script on server side"));
            return;
        }
        //TURBOPACK unreachable
        ;
        const script = undefined;
    });
};
const initializeGoogleAuth = (clientId)=>{
    return new Promise((resolve, reject)=>{
        if ("TURBOPACK compile-time truthy", 1) {
            reject(new Error("Cannot initialize Google Auth on server side"));
            return;
        }
        //TURBOPACK unreachable
        ;
    });
};
const openGoogleLoginPopup = async (clientId)=>{
    return new Promise((resolve, reject)=>{
        if (!clientId) {
            reject(new Error("Google Client ID is not configured"));
            return;
        }
        // Add timeout to handle user cancellation
        const timeout = setTimeout(()=>{
            reject(new Error("Google authentication was cancelled or timed out"));
        }, 60000); // 60 second timeout
        initializeGoogleAuth(clientId).then((googleAccounts)=>{
            let isResolved = false;
            // Initialize the ID token client
            googleAccounts.id.initialize({
                client_id: clientId,
                callback: (response)=>{
                    if (isResolved) return;
                    clearTimeout(timeout);
                    isResolved = true;
                    if (response.error) {
                        reject(new Error(response.error));
                        return;
                    }
                    if (response.credential) {
                        resolve(response.credential);
                        return;
                    }
                    reject(new Error("No credential received from Google"));
                }
            });
            // Handle cancellation/dismissal for One Tap
            googleAccounts.id.cancel = ()=>{
                if (!isResolved) {
                    clearTimeout(timeout);
                    isResolved = true;
                    reject(new Error("Google authentication was cancelled"));
                }
            };
            // Create a temporary button to trigger the popup
            const tempContainer = document.createElement('div');
            tempContainer.style.position = 'absolute';
            tempContainer.style.top = '-9999px';
            tempContainer.style.left = '-9999px';
            document.body.appendChild(tempContainer);
            // Render the sign-in button
            googleAccounts.id.renderButton(tempContainer, {
                theme: 'outline',
                size: 'large',
                type: 'standard',
                shape: 'rectangular',
                text: 'signin_with',
                logo_alignment: 'left',
                width: 250
            });
            // Find and click the button
            setTimeout(()=>{
                const button = tempContainer.querySelector('[role="button"]');
                if (button) {
                    button.click();
                } else {
                    // Fallback to One Tap
                    googleAccounts.id.prompt((notification)=>{
                        // Handle One Tap dismissal
                        if (notification.isNotDisplayed() || notification.isSkippedMoment() || notification.isDismissedMoment()) {
                            if (!isResolved) {
                                clearTimeout(timeout);
                                isResolved = true;
                                reject(new Error("Google authentication was cancelled"));
                            }
                        }
                    });
                }
                // Clean up
                setTimeout(()=>{
                    if (tempContainer.parentNode) {
                        tempContainer.parentNode.removeChild(tempContainer);
                    }
                }, 1000);
            }, 100);
            // Additional timeout check for popup closure detection
            const checkInterval = setInterval(()=>{
                // Check if the popup/One Tap was closed without authentication
                if (!isResolved && !document.querySelector('[data-onload="gis_loaded"]')) {
                    // This is a heuristic check - if Google's elements are removed, assume popup was closed
                    clearTimeout(timeout);
                    clearInterval(checkInterval);
                    isResolved = true;
                    reject(new Error("Google authentication popup was closed"));
                }
            }, 1000);
            // Clear interval after timeout
            setTimeout(()=>{
                clearInterval(checkInterval);
            }, 60000);
        }).catch((error)=>{
            clearTimeout(timeout);
            reject(error);
        });
    });
};
}),
"[project]/frontend/utils/url-cleanup.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Utility function to clean up authentication-related URL parameters
 * This helps prevent auth=false from persisting in the URL after successful authentication
 */ __turbopack_context__.s([
    "cleanupAuthFalseParam",
    ()=>cleanupAuthFalseParam,
    "cleanupAuthParams",
    ()=>cleanupAuthParams,
    "hasAuthFalseParam",
    ()=>hasAuthFalseParam
]);
function cleanupAuthParams(paramsToRemove = [
    'auth',
    'return'
]) {
    if ("TURBOPACK compile-time truthy", 1) return; // Server-side safety check
    //TURBOPACK unreachable
    ;
}
function cleanupAuthFalseParam() {
    cleanupAuthParams([
        'auth',
        'return'
    ]);
}
function hasAuthFalseParam() {
    if ("TURBOPACK compile-time truthy", 1) return false;
    //TURBOPACK unreachable
    ;
}
}),
"[project]/frontend/store/user.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useUserStore",
    ()=>useUserStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$kyc$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/kyc.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
"use client";
;
;
// Helper function to convert User to the format expected by KYC utils
function convertToKycUserType(user) {
    if (!user) return null;
    return {
        ...user,
        kyc: {
            status: user.kyc?.status || '',
            level: {
                level: typeof user.kyc?.level === 'number' ? user.kyc.level : user.kyc?.level?.level,
                features: user.kyc?.level?.features || user.featureAccess || []
            }
        }
    };
}
;
// Memoize expensive calculations
const calculateSecurityScoreImpl = (user)=>{
    if (!user) return 0;
    let score = 0;
    // Base score for having an account
    score += 30;
    // 2FA enabled
    if (user.twoFactor?.enabled) score += 30;
    // Email verified
    if (user.emailVerified) score += 20;
    // Phone verified
    if (user.phoneVerified) score += 20;
    return score;
};
const calculateProfileCompletionImpl = (user)=>{
    if (!user) return 0;
    const fields = [
        user.firstName,
        user.lastName,
        user.email,
        user.phone,
        user.profile,
        user.avatar !== null && user.avatar !== "/user/placeholder.svg",
        user.emailVerified,
        user.phoneVerified,
        user.twoFactor?.enabled,
        !!user.walletAddress
    ];
    const total = fields.length;
    const completed = fields.filter(Boolean).length;
    return Math.round(completed / total * 100);
};
const useUserStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])((set, get)=>{
    // Helper to ensure API key fields are in the correct format
    const normalizeApiKey = (apiKey)=>{
        let permissions = apiKey.permissions;
        let ipWhitelist = apiKey.ipWhitelist;
        // Try parsing permissions if it's a string that looks like a JSON array.
        if (typeof permissions === "string") {
            try {
                permissions = JSON.parse(permissions);
            } catch  {
                // Fallback: split by comma if JSON parsing fails.
                permissions = permissions.split(",").map((p)=>p.trim());
            }
        }
        if (!Array.isArray(permissions)) {
            permissions = [];
        }
        // Try parsing ipWhitelist if it's a string that looks like a JSON array.
        if (typeof ipWhitelist === "string") {
            try {
                ipWhitelist = JSON.parse(ipWhitelist);
            } catch  {
                // Fallback: split by comma if JSON parsing fails.
                ipWhitelist = ipWhitelist.split(",").map((ip)=>ip.trim());
            }
        }
        if (!Array.isArray(ipWhitelist)) {
            ipWhitelist = [];
        }
        return {
            ...apiKey,
            permissions,
            ipWhitelist
        };
    };
    return {
        user: null,
        apiKeys: [],
        apiPermissions: [
            {
                label: "Trade",
                value: "trade",
                description: "Allows placing orders and trading on the exchange."
            },
            {
                label: "Futures",
                value: "futures",
                description: "Allows trading in futures markets."
            },
            {
                label: "Deposit",
                value: "deposit",
                description: "Allows viewing deposit addresses and history."
            },
            {
                label: "Withdraw",
                value: "withdraw",
                description: "Allows withdrawals from the account."
            },
            {
                label: "Transfer",
                value: "transfer",
                description: "Allows transfers between your accounts."
            },
            {
                label: "Payment",
                value: "payment",
                description: "Allows creating and confirming payments."
            }
        ],
        securityScore: 0,
        profileCompletion: 0,
        isLoading: true,
        error: null,
        apiKeyLoading: false,
        apiKeyError: null,
        activeTab: "dashboard",
        showTwoFactorSetup: false,
        setUser: (user)=>set({
                user,
                isLoading: false,
                error: null
            }),
        setActiveTab: (tab)=>set({
                activeTab: tab
            }),
        setShowTwoFactorSetup: (show)=>set({
                showTwoFactorSetup: show
            }),
        hasKyc: ()=>{
            const { user } = get();
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$kyc$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isUserKycApproved"])(convertToKycUserType(user));
        },
        canAccessFeature: (feature)=>{
            const { user } = get();
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$kyc$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["hasFeature"])(convertToKycUserType(user), feature);
        },
        logout: async ()=>{
            const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                url: "/api/auth/logout",
                method: "POST"
            });
            if (!error) {
                set({
                    user: null,
                    apiKeys: [],
                    securityScore: 0,
                    profileCompletion: 0
                });
                return true;
            }
            return false;
        },
        hasPermission: (permission)=>{
            const { user, apiKeys } = get();
            // 1) If user is Super Admin, grant all permissions
            if (user?.role?.name === "Super Admin") {
                return true;
            }
            // 2) If user has no role, deny
            if (!user?.role) {
                return false;
            }
            // 3) Check role permissions first
            const userPermissions = user.role.permissions || [];
            // Handle both cases: permissions as objects [{id, name}] or as strings ["permission.name"]
            const hasRolePermission = userPermissions.some((p)=>{
                if (typeof p === "string") {
                    return p === permission;
                }
                if (typeof p === "object" && p.name) {
                    return p.name === permission;
                }
                return false;
            });
            if (hasRolePermission) {
                return true;
            }
            // 4) Fallback to API key permissions
            return apiKeys.some((apiKey)=>apiKey.permissions.includes(permission));
        },
        calculateSecurityScore: ()=>{
            const { user } = get();
            const score = calculateSecurityScoreImpl(user);
            set({
                securityScore: score
            });
        },
        calculateProfileCompletion: ()=>{
            const { user } = get();
            const completion = calculateProfileCompletionImpl(user);
            set({
                profileCompletion: completion
            });
        },
        updateUser: async (userData)=>{
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/profile",
                    method: "PUT",
                    body: userData
                });
                if (error) {
                    set({
                        error
                    });
                    return false;
                }
                const { user } = get();
                if (!user) {
                    set({
                        error: "User not logged in"
                    });
                    return false;
                }
                set({
                    user: {
                        ...user,
                        ...userData
                    },
                    error: null
                });
                get().calculateSecurityScore();
                get().calculateProfileCompletion();
                return true;
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Failed to update user"
                });
                return false;
            }
        },
        updateAvatar: async (avatarUrl)=>{
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/profile",
                    method: "PUT",
                    body: {
                        avatar: avatarUrl
                    }
                });
                if (error) {
                    set({
                        error
                    });
                    return false;
                }
                const { user } = get();
                if (!user) {
                    set({
                        error: "User not logged in"
                    });
                    return false;
                }
                set({
                    user: {
                        ...user,
                        avatar: avatarUrl
                    },
                    error: null
                });
                get().calculateProfileCompletion();
                return true;
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Failed to update avatar"
                });
                return false;
            }
        },
        fetchApiKeys: async ()=>{
            set({
                apiKeyLoading: true,
                apiKeyError: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/api-key",
                    silentSuccess: true
                });
                if (error) {
                    set({
                        apiKeyError: error,
                        apiKeyLoading: false
                    });
                    return;
                }
                const normalizedKeys = Array.isArray(data) ? data.map(normalizeApiKey) : [];
                set({
                    apiKeys: normalizedKeys,
                    apiKeyLoading: false
                });
            } catch (error) {
                set({
                    apiKeyError: error instanceof Error ? error.message : "Unknown error occurred",
                    apiKeyLoading: false
                });
            }
        },
        createApiKey: async (name, permissions, ipWhitelist, ipRestriction)=>{
            set({
                apiKeyLoading: true,
                apiKeyError: null
            });
            if (get().apiKeys.length >= 10) {
                set({
                    apiKeyError: "Cannot create more than 10 API keys",
                    apiKeyLoading: false
                });
                return;
            }
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/api-key",
                    method: "POST",
                    body: {
                        name,
                        permissions,
                        ipWhitelist,
                        ipRestriction
                    },
                    silentSuccess: true
                });
                if (error) {
                    set({
                        apiKeyError: error,
                        apiKeyLoading: false
                    });
                    return;
                }
                const normalizedKey = normalizeApiKey(data);
                set((state)=>({
                        apiKeys: [
                            ...state.apiKeys,
                            normalizedKey
                        ],
                        apiKeyLoading: false
                    }));
                return normalizedKey;
            } catch (error) {
                set({
                    apiKeyError: error instanceof Error ? error.message : "Unknown error occurred",
                    apiKeyLoading: false
                });
                return;
            }
        },
        updateApiKey: async (id, permissions, ipWhitelist, ipRestriction)=>{
            set({
                apiKeyLoading: true,
                apiKeyError: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/user/api-key/${id}`,
                    method: "PUT",
                    body: {
                        permissions,
                        ipWhitelist,
                        ipRestriction
                    },
                    silentSuccess: true
                });
                if (error) {
                    set({
                        apiKeyError: error,
                        apiKeyLoading: false
                    });
                    return;
                }
                const normalizedKey = normalizeApiKey(data);
                set((state)=>({
                        apiKeys: state.apiKeys.map((apiKey)=>apiKey.id === id ? normalizedKey : apiKey),
                        apiKeyLoading: false
                    }));
                return normalizedKey;
            } catch (error) {
                set({
                    apiKeyError: error instanceof Error ? error.message : "Unknown error occurred",
                    apiKeyLoading: false
                });
                return;
            }
        },
        deleteApiKey: async (id)=>{
            set({
                apiKeyLoading: true,
                apiKeyError: null
            });
            const { error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                url: `/api/user/api-key/${id}`,
                method: "DELETE",
                silentSuccess: true
            });
            if (error) {
                set({
                    apiKeyError: error,
                    apiKeyLoading: false
                });
                return;
            }
            set((state)=>({
                    apiKeys: state.apiKeys.filter((apiKey)=>apiKey.id !== id),
                    apiKeyLoading: false
                }));
        },
        connectWallet: async (address, chainId)=>{
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/profile/wallet/connect",
                    method: "POST",
                    body: {
                        address,
                        chainId
                    }
                });
                if (error) {
                    console.error("Error connecting wallet:", error);
                    return false;
                }
                return true;
            } catch (error) {
                console.error("Error connecting wallet:", error);
                return false;
            }
        },
        disconnectWallet: async (address)=>{
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/profile/wallet/disconnect",
                    method: "POST",
                    body: {
                        address
                    }
                });
                if (error) {
                    console.error("Error disconnecting wallet:", error);
                    return false;
                }
                return true;
            } catch (error) {
                console.error("Error disconnecting wallet:", error);
                return false;
            }
        },
        // Authentication functions
        login: async (email, password)=>{
            set({
                isLoading: true,
                error: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/auth/login",
                    method: "POST",
                    body: {
                        email,
                        password
                    },
                    silentSuccess: true
                });
                if (error) {
                    set({
                        error,
                        isLoading: false
                    });
                    return false;
                }
                // Check if 2FA is required
                if (data && data.twoFactor && data.twoFactor.enabled) {
                    // Return the 2FA data instead of proceeding with login
                    set({
                        isLoading: false,
                        error: null
                    });
                    return {
                        requiresTwoFactor: true,
                        ...data
                    };
                }
                // After successful login, fetch user profile
                try {
                    const { data: profileData, error: profileError } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                        url: "/api/user/profile",
                        method: "GET",
                        silentSuccess: true
                    });
                    if (profileError) {
                        console.warn("Failed to fetch user profile after login:", profileError);
                        // Still consider login successful even if profile fetch fails
                        set({
                            isLoading: false,
                            error: null
                        });
                        return true;
                    }
                    if (profileData) {
                        set({
                            user: profileData,
                            isLoading: false,
                            error: null
                        });
                        return true;
                    }
                } catch (profileFetchError) {
                    console.warn("Error fetching user profile after login:", profileFetchError);
                // Still consider login successful even if profile fetch fails
                }
                set({
                    isLoading: false
                });
                return true;
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Login failed",
                    isLoading: false
                });
                return false;
            }
        },
        register: async (userData)=>{
            set({
                isLoading: true,
                error: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/auth/register",
                    method: "POST",
                    body: userData
                });
                // First check if there's an explicit error
                if (error) {
                    console.log("Registration error detected:", error);
                    set({
                        error,
                        isLoading: false
                    });
                    return {
                        success: false,
                        data: null,
                        userLoggedIn: false
                    };
                }
                // Check if response data indicates an error (fallback for HTTP 200 with error content)
                if (data && typeof data === "object") {
                    // If the response contains just a message without success indicators, check if it's an error or success
                    if (data.message && !data.cookies && !data.user && !data.accessToken) {
                        const messageText = data.message.toLowerCase();
                        // Success patterns - messages that indicate successful operations
                        const successPatterns = [
                            'successful',
                            'success',
                            'verify your email',
                            'verification email sent',
                            'registered successfully',
                            'registration successful',
                            'created successfully',
                            'completed',
                            'sent',
                            'you have been registered successfully',
                            'you have been logged in successfully',
                            'email verified successfully',
                            'password reset successfully',
                            'email with reset instructions sent successfully',
                            'otp saved successfully',
                            'otp resent successfully',
                            'you have been logged out',
                            'user already registered but email not verified'
                        ];
                        // Error patterns - messages that indicate errors
                        const errorPatterns = [
                            'already in use',
                            'not found',
                            'invalid',
                            'failed',
                            'error',
                            'denied',
                            'forbidden',
                            'unauthorized',
                            'expired',
                            'missing',
                            'required'
                        ];
                        const looksLikeSuccess = successPatterns.some((pattern)=>messageText.includes(pattern));
                        const looksLikeError = errorPatterns.some((pattern)=>messageText.includes(pattern));
                        if (looksLikeError) {
                            const errorMessage = data.message;
                            console.log("Registration failed - error message in response:", errorMessage);
                            set({
                                error: errorMessage,
                                isLoading: false
                            });
                            return {
                                success: false,
                                data: null,
                                userLoggedIn: false
                            };
                        } else if (looksLikeSuccess) {
                            console.log("Registration succeeded - success message in response:", data.message);
                            set({
                                isLoading: false,
                                error: null
                            });
                            return {
                                success: true,
                                data: data,
                                userLoggedIn: false
                            };
                        }
                    // If it's neither clearly success nor error, fall through to default handling
                    }
                    // Check for explicit error fields
                    if (data.error || data.errors || data.success === false) {
                        const errorMessage = data.error || data.message || "Registration failed";
                        console.log("Registration failed - error fields in response:", errorMessage);
                        set({
                            error: errorMessage,
                            isLoading: false
                        });
                        return {
                            success: false,
                            data: null,
                            userLoggedIn: false
                        };
                    }
                }
                // If the backend returns tokens, it means the user is logged in
                if (data && data.cookies) {
                    // Try to fetch user profile after successful registration with tokens
                    try {
                        const { data: profileData, error: profileError } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                            url: "/api/user/profile",
                            method: "GET",
                            silentSuccess: true
                        });
                        if (profileData && !profileError) {
                            set({
                                user: profileData,
                                isLoading: false,
                                error: null
                            });
                            return {
                                success: true,
                                data: data,
                                userLoggedIn: true
                            };
                        }
                    } catch (profileFetchError) {
                        console.warn("Error fetching user profile after registration:", profileFetchError);
                    }
                }
                set({
                    isLoading: false
                });
                return {
                    success: true,
                    data: data,
                    userLoggedIn: false
                };
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Registration failed",
                    isLoading: false
                });
                return {
                    success: false,
                    data: null,
                    userLoggedIn: false
                };
            }
        },
        // Note: Google login is now handled directly in components using openGoogleLoginPopup utility
        // New password reset functions
        requestPasswordReset: async (email)=>{
            set({
                isLoading: true,
                error: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/auth/reset",
                    method: "POST",
                    body: {
                        email
                    },
                    silentSuccess: true
                });
                set({
                    isLoading: false
                });
                if (error) {
                    set({
                        error
                    });
                    return false;
                }
                return true;
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Failed to request password reset",
                    isLoading: false
                });
                return false;
            }
        },
        verifyResetToken: async (token)=>{
            set({
                isLoading: true,
                error: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/auth/verify/reset",
                    method: "POST",
                    body: {
                        token
                    },
                    silentSuccess: true
                });
                set({
                    isLoading: false
                });
                if (error) {
                    set({
                        error
                    });
                    return false;
                }
                return true;
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Failed to verify reset token",
                    isLoading: false
                });
                return false;
            }
        },
        resetPassword: async (token, newPassword)=>{
            set({
                isLoading: true,
                error: null
            });
            try {
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/auth/verify/reset",
                    method: "POST",
                    body: {
                        token,
                        newPassword
                    },
                    silentSuccess: true
                });
                set({
                    isLoading: false
                });
                if (error) {
                    set({
                        error
                    });
                    return false;
                }
                return true;
            } catch (error) {
                set({
                    error: error instanceof Error ? error.message : "Failed to reset password",
                    isLoading: false
                });
                return false;
            }
        }
    };
});
}),
"[project]/frontend/store/config.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useConfigStore",
    ()=>useConfigStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/middleware.mjs [app-ssr] (ecmascript)");
"use client";
;
;
// Normalize menu items ensuring `href` is always defined
function normalizeMenuItems(items) {
    return items.map((item)=>{
        const newItem = {
            ...item,
            href: typeof item.href === "string" ? item.href : "#",
            child: item.child ? normalizeMenuItems(item.child) : item.child,
            megaMenu: item.megaMenu ? normalizeMenuItems(item.megaMenu) : item.megaMenu
        };
        return newItem;
    });
}
// Process menu to flatten any megaMenu items
function processSideMenu(normalizedMenu) {
    if (!normalizedMenu) return [];
    return normalizedMenu.map((item)=>{
        if (item.megaMenu && item.megaMenu.length > 0) {
            const combinedChild = [];
            for (const mm of item.megaMenu){
                if (mm.child && mm.child.length > 0) {
                    combinedChild.push(...mm.child);
                }
            }
            // Sort combinedChild alphabetically by title
            combinedChild.sort((a, b)=>{
                const titleA = a.title?.toLowerCase() || "";
                const titleB = b.title?.toLowerCase() || "";
                return titleA.localeCompare(titleB);
            });
            return {
                ...item,
                child: combinedChild,
                megaMenu: undefined
            };
        }
        return item;
    });
}
const useConfigStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["persist"])((set)=>({
        // State
        settings: {},
        extensions: [],
        isLoading: false,
        settingsFetched: false,
        settingsError: null,
        navMenu: null,
        sideMenu: null,
        // Mutations
        setSettings: (settings)=>set({
                settings,
                settingsFetched: true,
                settingsError: null
            }),
        setExtensions: (extensions)=>set({
                extensions
            }),
        setIsLoading: (isLoading)=>set({
                isLoading
            }),
        setSettingsFetched: (fetched)=>set({
                settingsFetched: fetched
            }),
        setSettingsError: (error)=>set({
                settingsError: error
            }),
        // Reset settings state for retry
        resetSettings: ()=>set({
                settings: {},
                extensions: [],
                settingsFetched: false,
                settingsError: null,
                navMenu: null,
                sideMenu: null
            }),
        // Update or add a single setting
        updateSetting: (key, value)=>set((state)=>({
                    settings: {
                        ...state.settings,
                        [key]: value
                    }
                })),
        // Menu
        setMenu: (menu)=>{
            const normalized = normalizeMenuItems(menu);
            const processed = processSideMenu(normalized);
            set({
                navMenu: normalized,
                sideMenu: processed
            });
        }
    }), {
    name: 'bicrypto-config-store',
    partialize: (state)=>({
            settings: state.settings,
            extensions: state.extensions,
            navMenu: state.navMenu,
            sideMenu: state.sideMenu
        })
}));
}),
"[project]/frontend/store/index.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useSidebar",
    ()=>useSidebar,
    "useThemeStore",
    ()=>useThemeStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/middleware.mjs [app-ssr] (ecmascript)");
;
;
// Default site configuration values
const defaultSiteConfig = {
    radius: 0.5,
    navbarType: "sticky",
    footerType: "default"
};
const useThemeStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["persist"])((set)=>({
        radius: defaultSiteConfig.radius,
        setRadius: (value)=>set({
                radius: value
            }),
        setLayout: (_value)=>{
            set({
                navbarType: "sticky"
            });
        },
        navbarType: defaultSiteConfig.navbarType,
        setNavbarType: (value)=>set({
                navbarType: value
            }),
        // Map footerType "static" to "default"
        footerType: defaultSiteConfig.footerType,
        setFooterType: (value)=>set({
                footerType: value
            }),
        isRtl: false,
        setRtl: (value)=>set({
                isRtl: value
            }),
        searchOpen: false,
        setSearchOpen: (open)=>set({
                searchOpen: open
            })
    }), {
    name: "theme-store",
    storage: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createJSONStorage"])(()=>localStorage)
}));
const useSidebar = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["persist"])((set)=>({
        collapsed: false,
        setCollapsed: (value)=>set({
                collapsed: value
            }),
        subMenu: false,
        setSubmenu: (value)=>set({
                subMenu: value
            }),
        mobileMenu: false,
        setMobileMenu: (value)=>set({
                mobileMenu: value
            })
    }), {
    name: "sidebar-store",
    storage: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createJSONStorage"])(()=>localStorage)
}));
}),
"[project]/frontend/store/notification-store.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useNotificationsStore",
    ()=>useNotificationsStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-ssr] (ecmascript)");
;
;
const computeStats = (notifications)=>{
    // Ensure notifications is an array
    const notificationArray = Array.isArray(notifications) ? notifications : [];
    const total = notificationArray.length;
    const unread = notificationArray.filter((n)=>!n.read).length;
    const typesCount = notificationArray.reduce((acc, notification)=>{
        if (notification.type in acc) {
            acc[notification.type] += 1;
        }
        return acc;
    }, {
        investment: 0,
        message: 0,
        alert: 0,
        system: 0,
        user: 0
    });
    return {
        total,
        unread,
        types: {
            investment: typesCount.investment,
            message: typesCount.message,
            alert: typesCount.alert,
            system: typesCount.system,
            user: typesCount.user
        },
        trend: {
            percentage: 0,
            increasing: true
        }
    };
};
const useNotificationsStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((set, get)=>({
        notifications: [],
        isLoading: false,
        error: null,
        stats: {
            total: 0,
            unread: 0,
            types: {
                investment: 0,
                message: 0,
                alert: 0,
                system: 0,
                user: 0
            },
            trend: {
                percentage: 0,
                increasing: true
            }
        },
        lastFetched: null,
        cacheExpiry: 5 * 60 * 1000,
        fetchNotifications: async ()=>{
            const now = Date.now();
            const { lastFetched, cacheExpiry, notifications } = get();
            if (lastFetched && now - lastFetched < cacheExpiry && notifications.length > 0) {
                return;
            }
            try {
                set({
                    isLoading: true,
                    error: null
                });
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/notification",
                    silent: true
                });
                if (!error && data) {
                    // Ensure notifications array exists and is an array
                    const notificationsArray = Array.isArray(data.notifications) ? data.notifications : Array.isArray(data) ? data : [];
                    // Parse the actions field if it's a string
                    const parsedNotifications = notificationsArray.map((notification)=>{
                        let actions = notification.actions;
                        if (typeof actions === "string") {
                            try {
                                actions = JSON.parse(actions);
                            } catch (parseError) {
                                console.error("Error parsing notification actions:", parseError);
                                actions = [];
                            }
                        }
                        // If title is missing, default to an empty string.
                        return {
                            ...notification,
                            actions,
                            title: notification.title || ""
                        };
                    });
                    set({
                        notifications: parsedNotifications,
                        stats: computeStats(parsedNotifications),
                        lastFetched: Date.now(),
                        isLoading: false
                    });
                } else {
                    set({
                        isLoading: false,
                        error: error || "Failed to fetch notifications"
                    });
                }
            } catch (error) {
                console.error("Error fetching notifications:", error);
                set({
                    isLoading: false,
                    error: error instanceof Error ? error.message : "Failed to fetch notifications",
                    notifications: []
                });
            }
        },
        markAsRead: async (id)=>{
            try {
                const { error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/user/notification/${id}/read`,
                    method: "POST",
                    silent: true
                });
                if (!error) {
                    const { notifications } = get();
                    const notificationArray = Array.isArray(notifications) ? notifications : [];
                    const updatedNotifications = notificationArray.map((n)=>n.id === id ? {
                            ...n,
                            read: true
                        } : n);
                    set({
                        notifications: updatedNotifications,
                        stats: computeStats(updatedNotifications)
                    });
                } else {
                    console.error("Error marking notification as read:", error);
                }
            } catch (error) {
                console.error("Error marking notification as read:", error);
            }
        },
        markAsUnread: async (id)=>{
            try {
                const { error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/user/notification/${id}/unread`,
                    method: "POST",
                    silent: true
                });
                if (!error) {
                    const { notifications } = get();
                    const notificationArray = Array.isArray(notifications) ? notifications : [];
                    const updatedNotifications = notificationArray.map((n)=>n.id === id ? {
                            ...n,
                            read: false
                        } : n);
                    set({
                        notifications: updatedNotifications,
                        stats: computeStats(updatedNotifications)
                    });
                } else {
                    console.error("Error marking notification as unread:", error);
                }
            } catch (error) {
                console.error("Error marking notification as unread:", error);
            }
        },
        markAllAsRead: async ()=>{
            try {
                const { error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/notification/mark-all-read",
                    method: "POST",
                    silent: true
                });
                if (!error) {
                    const { notifications } = get();
                    const notificationArray = Array.isArray(notifications) ? notifications : [];
                    const updatedNotifications = notificationArray.map((n)=>({
                            ...n,
                            read: true
                        }));
                    set({
                        notifications: updatedNotifications,
                        stats: {
                            ...get().stats,
                            unread: 0
                        }
                    });
                } else {
                    console.error("Error marking all notifications as read:", error);
                }
            } catch (error) {
                console.error("Error marking all notifications as read:", error);
            }
        },
        deleteNotification: async (id)=>{
            try {
                const { error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/user/notification/${id}`,
                    method: "DELETE",
                    silent: true
                });
                if (!error) {
                    const { notifications } = get();
                    const notificationArray = Array.isArray(notifications) ? notifications : [];
                    const updatedNotifications = notificationArray.filter((n)=>n.id !== id);
                    set({
                        notifications: updatedNotifications,
                        stats: computeStats(updatedNotifications)
                    });
                } else {
                    console.error("Error deleting notification:", error);
                }
            } catch (error) {
                console.error("Error deleting notification:", error);
            }
        },
        deleteAllNotifications: async ()=>{
            try {
                const { error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/notification",
                    method: "DELETE",
                    silent: true
                });
                if (!error) {
                    set({
                        notifications: [],
                        stats: {
                            total: 0,
                            unread: 0,
                            types: {
                                investment: 0,
                                message: 0,
                                alert: 0,
                                system: 0,
                                user: 0
                            },
                            trend: {
                                percentage: 0,
                                increasing: true
                            }
                        }
                    });
                } else {
                    console.error("Error deleting all notifications:", error);
                }
            } catch (error) {
                console.error("Error deleting all notifications:", error);
            }
        },
        filterNotifications: (types)=>{
            const { notifications } = get();
            const notificationArray = Array.isArray(notifications) ? notifications : [];
            return notificationArray.filter((n)=>types.includes(n.type));
        },
        searchNotifications: (query)=>{
            const { notifications } = get();
            const notificationArray = Array.isArray(notifications) ? notifications : [];
            const lowerQuery = query.toLowerCase();
            return notificationArray.filter((n)=>n.message.toLowerCase().includes(lowerQuery) || n.details && n.details.toLowerCase().includes(lowerQuery));
        },
        // Handle incoming websocket messages for notifications
        handleNotificationMessage: (msg)=>{
            const { notifications } = get();
            const notificationArray = Array.isArray(notifications) ? notifications : [];
            let newNotifications = notificationArray;
            if (msg.method === "create") {
                newNotifications = [
                    msg.payload,
                    ...notificationArray
                ];
            } else if (msg.method === "update") {
                newNotifications = notificationArray.map((n)=>n.id === msg.payload.id ? {
                        ...n,
                        ...msg.payload
                    } : n);
            } else if (msg.method === "delete") {
                const idToDelete = typeof msg.payload === "object" ? msg.payload.id : msg.payload;
                newNotifications = notificationArray.filter((n)=>n.id !== idToDelete);
            }
            set({
                notifications: newNotifications,
                stats: computeStats(newNotifications)
            });
        },
        // New: Sound preference and toggle function.
        soundEnabled: false,
        toggleSound: ()=>{
            const newVal = !get().soundEnabled;
            set({
                soundEnabled: newVal
            });
        }
    }));
}),
"[project]/frontend/store/logo-cache.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useLogoCacheStore",
    ()=>useLogoCacheStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
"use client";
;
const useLogoCacheStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])((set)=>({
        logoVersion: 1,
        logoTimestamp: Date.now(),
        updateLogoVersion: ()=>set(()=>({
                    logoVersion: Date.now(),
                    logoTimestamp: Date.now()
                }))
    }));
}),
"[project]/frontend/provider/websocket.provider.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "WebSocketProvider",
    ()=>WebSocketProvider,
    "useWebSocket",
    ()=>useWebSocket
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/ws.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$notification$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/notification-store.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
const WebSocketContext = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createContext"])({
    wsManager: null
});
const WebSocketProvider = ({ children, userId, config })=>{
    const [wsManager, setWsManager] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    // Create the audio element immediately (only on client) with better error handling
    const audioRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const isPlayingRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const lastPlayTimeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Initialize audio only once
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (typeof Audio !== "undefined" && !audioRef.current) {
            audioRef.current = new Audio("/sound/notification.mp3");
            audioRef.current.preload = "auto";
            audioRef.current.volume = 0.7;
            // Add event listeners to track audio state
            audioRef.current.onended = ()=>{
                isPlayingRef.current = false;
            };
            audioRef.current.onerror = (e)=>{
                console.warn("Audio failed to load:", e);
                isPlayingRef.current = false;
            };
        }
    }, []);
    // Use a stable reference to the notification handler to prevent WebSocket recreation
    const handleNotificationMessageRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$notification$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useNotificationsStore"].getState().handleNotificationMessage);
    // Update the ref whenever the store changes (but don't recreate WebSocket)
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        handleNotificationMessageRef.current = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$notification$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useNotificationsStore"].getState().handleNotificationMessage;
    });
    // Use a ref to avoid re-running the effect for soundEnabled.
    const soundEnabledRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$notification$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useNotificationsStore"].getState().soundEnabled);
    const soundEnabled = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$notification$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useNotificationsStore"])((state)=>state.soundEnabled);
    // Update the ref whenever the store value changes.
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        soundEnabledRef.current = soundEnabled;
    }, [
        soundEnabled
    ]);
    // Effect to unlock audio on first user interaction with throttling
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        let isUnlocked = false;
        const unlockAudio = ()=>{
            if (audioRef.current && !isUnlocked) {
                isUnlocked = true;
                audioRef.current.play().then(()=>{
                    audioRef.current?.pause();
                    audioRef.current.currentTime = 0;
                    console.log("Audio unlocked successfully");
                }).catch((err)=>console.warn("Audio unlock failed:", err));
                document.removeEventListener("click", unlockAudio);
                document.removeEventListener("touchstart", unlockAudio);
            }
        };
        document.addEventListener("click", unlockAudio, {
            once: true
        });
        document.addEventListener("touchstart", unlockAudio, {
            once: true
        });
        return ()=>{
            document.removeEventListener("click", unlockAudio);
            document.removeEventListener("touchstart", unlockAudio);
        };
    }, []);
    // Throttled audio play function
    const playNotificationSound = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (!soundEnabledRef.current || !audioRef.current || isPlayingRef.current) {
            return;
        }
        const now = Date.now();
        // Throttle audio to prevent spam (min 1 second between notifications)
        if (now - lastPlayTimeRef.current < 1000) {
            return;
        }
        lastPlayTimeRef.current = now;
        isPlayingRef.current = true;
        audioRef.current.currentTime = 0;
        audioRef.current.play().catch((err)=>{
            console.warn("Sound blocked by browser:", err);
            isPlayingRef.current = false;
        });
    }, []);
    // Create the WebSocketManager only once per userId/config (removed handleNotificationMessage dependency)
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Don't create WebSocket connection if userId is not provided
        if (!userId) {
            console.warn("WebSocketProvider: No userId provided, skipping WebSocket connection");
            return;
        }
        // Instantiate the WebSocketManager.
        const manager = new __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"](`/api/user?userId=${userId}`, config);
        manager.on("open", ()=>{
            // Subscribe when the connection opens.
            manager.send({
                type: "SUBSCRIBE",
                payload: {
                    type: "auth"
                }
            });
        });
        // Listen for messages and handle notification messages.
        const messageHandler = (msg)=>{
            if (msg.type === "notification") {
                // Update the store with the new notification using stable ref.
                handleNotificationMessageRef.current({
                    method: msg.method,
                    payload: msg.payload
                });
                // Play the notification sound with throttling
                playNotificationSound();
            }
        };
        manager.on("message", messageHandler);
        manager.connect();
        setWsManager(manager);
        // Cleanup on unmount.
        return ()=>{
            manager.off("message", messageHandler);
            manager.disconnect();
        };
    }, [
        userId,
        config,
        playNotificationSound
    ]); // Added playNotificationSound dependency
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(WebSocketContext.Provider, {
        value: {
            wsManager
        },
        children: children
    }, void 0, false, {
        fileName: "[project]/frontend/provider/websocket.provider.tsx",
        lineNumber: 173,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const useWebSocket = ()=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useContext"])(WebSocketContext);
}),
"[project]/frontend/provider/providers.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__,
    "useFontClasses",
    ()=>useFontClasses
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
// Providers.tsx
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$next$5d2f$internal$2f$font$2f$google$2f$geist_daf87d82$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[next]/internal/font/google/geist_daf87d82.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$next$5d2f$internal$2f$font$2f$google$2f$geist_mono_c3b31ddc$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[next]/internal/font/google/geist_mono_c3b31ddc.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-themes@1.0.0-beta.0_ne_fd389c5db48046672a7f720e88c0bc38/node_modules/next-themes/dist/index.module.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$sonner$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/sonner.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/user.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/config.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$index$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/index.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$provider$2f$websocket$2e$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/provider/websocket.provider.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/extensions.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$global$2f$floating$2d$chat$2d$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/global/floating-chat-provider.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$hooks$2f$use$2d$settings$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/hooks/use-settings-sync.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
;
;
;
;
;
;
;
;
;
const ConfigInitializer = ({ profile, settings, extensions })=>{
    const setUser = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useUserStore"])((state)=>state.setUser);
    const { setSettings, setExtensions, setSettingsFetched, setSettingsError } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"])();
    // Use the settings sync hook for optimistic updates
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$hooks$2f$use$2d$settings$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useSettingsSync"])();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        setUser(profile);
        // Only mark as fetched if we actually have settings data
        if (settings && Object.keys(settings).length > 0) {
            setSettings(settings);
            setExtensions(extensions || []);
            // Initialize extension checker with available extensions
            if (extensions && extensions.length > 0) {
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ExtensionChecker"].getInstance().initialize(extensions);
            }
        } else {
            // If settings are empty, don't mark as fetched so it will retry
            setSettingsFetched(false);
            setSettingsError(null);
        }
    }, [
        profile,
        settings,
        extensions,
        setSettings,
        setExtensions,
        setSettingsFetched,
        setSettingsError
    ]);
    return null;
};
// Add error handler component
function GlobalErrorHandler() {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleUnhandledRejection = (event)=>{
            console.error("Unhandled promise rejection:", event.reason);
            // Prevent the default browser behavior which might crash the app
            event.preventDefault();
        };
        const handleError = (event)=>{
            console.error("Global error:", event.error);
        };
        // Add global error listeners
        window.addEventListener("unhandledrejection", handleUnhandledRejection);
        window.addEventListener("error", handleError);
        return ()=>{
            window.removeEventListener("unhandledrejection", handleUnhandledRejection);
            window.removeEventListener("error", handleError);
        };
    }, []);
    return null;
}
const useFontClasses = ()=>{
    const { radius } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$index$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useThemeStore"])();
    return {
        className: `${__TURBOPACK__imported__module__$5b$next$5d2f$internal$2f$font$2f$google$2f$geist_daf87d82$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].variable} ${__TURBOPACK__imported__module__$5b$next$5d2f$internal$2f$font$2f$google$2f$geist_mono_c3b31ddc$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].variable} antialiased`,
        style: {
            "--radius": `${radius}rem`
        }
    };
};
const Providers = ({ children, profile, settings, extensions })=>{
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ThemeProvider"], {
        attribute: "class",
        enableSystem: true,
        defaultTheme: "system",
        disableTransitionOnChange: false,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ConfigInitializer, {
                profile: profile,
                settings: settings,
                extensions: extensions
            }, void 0, false, {
                fileName: "[project]/frontend/provider/providers.tsx",
                lineNumber: 128,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            profile?.id ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$provider$2f$websocket$2e$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["WebSocketProvider"], {
                userId: profile.id,
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("h-full"),
                        children: children
                    }, void 0, false, {
                        fileName: "[project]/frontend/provider/providers.tsx",
                        lineNumber: 135,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$global$2f$floating$2d$chat$2d$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                        fileName: "[project]/frontend/provider/providers.tsx",
                        lineNumber: 136,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/provider/providers.tsx",
                lineNumber: 134,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0)) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("h-full"),
                        children: children
                    }, void 0, false, {
                        fileName: "[project]/frontend/provider/providers.tsx",
                        lineNumber: 140,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$global$2f$floating$2d$chat$2d$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                        fileName: "[project]/frontend/provider/providers.tsx",
                        lineNumber: 141,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$sonner$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Toaster"], {}, void 0, false, {
                fileName: "[project]/frontend/provider/providers.tsx",
                lineNumber: 144,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(GlobalErrorHandler, {}, void 0, false, {
                fileName: "[project]/frontend/provider/providers.tsx",
                lineNumber: 145,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/provider/providers.tsx",
        lineNumber: 122,
        columnNumber: 7
    }, ("TURBOPACK compile-time value", void 0));
};
const __TURBOPACK__default__export__ = Providers;
}),
"[project]/frontend/provider/direction.provider.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$index$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/index.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$direction$40$1_f37a56dc23f6e5de1dd0644374a11d96$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$direction$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@radix-ui+react-direction@1_f37a56dc23f6e5de1dd0644374a11d96/node_modules/@radix-ui/react-direction/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$provider$2f$websocket$2e$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/provider/websocket.provider.tsx [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
const DirectionProvider = ({ children, locale })=>{
    const { isRtl } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$index$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useThemeStore"])();
    const { wsManager } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$provider$2f$websocket$2e$provider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useWebSocket"])();
    const direction = locale === "ar" || isRtl ? "rtl" : "ltr";
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (wsManager && wsManager.isConnected()) {
            wsManager.send({
                type: "SUBSCRIBE",
                payload: {
                    type: "auth"
                }
            });
        }
    }, [
        wsManager
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        dir: direction,
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$direction$40$1_f37a56dc23f6e5de1dd0644374a11d96$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$direction$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DirectionProvider"], {
            dir: direction,
            children: children
        }, void 0, false, {
            fileName: "[project]/frontend/provider/direction.provider.tsx",
            lineNumber: 28,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false, {
        fileName: "[project]/frontend/provider/direction.provider.tsx",
        lineNumber: 27,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const __TURBOPACK__default__export__ = DirectionProvider;
}),
"[project]/frontend/provider/dashboard.provider.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/user.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/config.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$index$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/index.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$header$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/partials/header/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$sidebar$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/partials/sidebar/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/partials/footer/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$i18n$2f$routing$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/i18n/routing.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$dashboard$2f$layout$2d$wrapper$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/partials/dashboard/layout-wrapper.tsx [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
;
;
;
;
;
// Default site configuration
const defaultSiteConfig = {
    navbarType: "sticky",
    footerType: "default",
    radius: 0.5
};
// Helper function to convert a path with variables to a regex and test it.
const matchPath = (pattern, pathname)=>{
    // Replace dynamic segments (e.g., [id]) with a regex that matches any non-slash sequence.
    const regexPattern = "^" + pattern.replace(/\[(\w+)\]/g, "[^/]+") + "$";
    const regex = new RegExp(regexPattern);
    return regex.test(pathname);
};
// Helper function to get path after locale
function getPathAfterLocale(pathname) {
    return pathname.replace(/^\/[a-z]{2}(\/|$)/, "/");
}
const DashBoardLayoutProvider = ({ isGuest = false, children })=>{
    const location = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$i18n$2f$routing$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["usePathname"])();
    // Define an array of paths to exclude from using Header, Sidebar, and Footer.
    // These paths now support dynamic segments wrapped in square brackets.
    const excludedPaths = [
        "/admin/crm/kyc/level/create",
        "/admin/crm/kyc/level/[id]"
    ];
    // Check if the current path should exclude the layout components using our helper.
    const shouldExcludeLayout = excludedPaths.some((pattern)=>matchPath(pattern, location));
    // Check if current path is an admin path
    const normalizedPath = getPathAfterLocale(location);
    const isAdminPath = normalizedPath.startsWith("/admin");
    const menuType = isAdminPath ? "admin" : "user";
    // Retrieve global configuration from the stores.
    const profile = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useUserStore"])((state)=>state.user);
    const { settings, extensions } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"])();
    // Calculate layout settings and menu only when dependencies change.
    const { layoutSettings } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>{
        let layoutConfig = defaultSiteConfig;
        if (typeof settings?.layout === "string") {
            try {
                layoutConfig = JSON.parse(settings.layout);
            } catch (e) {
                console.error("Failed to parse settings.layout as JSON:", e);
                layoutConfig = defaultSiteConfig;
            }
        } else if (typeof settings?.layout === "object" && settings.layout !== null) {
            layoutConfig = settings.layout;
        }
        const layoutSettings = {
            navbarType: layoutConfig.navbarType ?? defaultSiteConfig.navbarType,
            footerType: layoutConfig.footerType ?? defaultSiteConfig.footerType,
            radius: typeof layoutConfig.radius === "number" ? layoutConfig.radius : defaultSiteConfig.radius
        };
        return {
            layoutSettings
        };
    }, [
        settings,
        extensions,
        profile,
        location
    ]); // Add location to dependencies
    // Update the global store with the computed menu and theme settings.
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useLayoutEffect"])(()=>{
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$index$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useThemeStore"].setState({
            navbarType: layoutSettings.navbarType,
            footerType: layoutSettings.footerType,
            radius: layoutSettings.radius
        });
    }, [
        layoutSettings
    ]);
    // Conditionally render the layout based on the excluded paths.
    if (shouldExcludeLayout) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "content-wrapper transition-all duration-150",
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "page-min-height-horizontal",
                children: children
            }, void 0, false, {
                fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                lineNumber: 105,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        }, void 0, false, {
            fileName: "[project]/frontend/provider/dashboard.provider.tsx",
            lineNumber: 104,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0));
    }
    if (isGuest || location.startsWith("/admin/builder/")) return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
        children: children
    }, void 0, false);
    // Only render admin layout for admin pages
    if (isAdminPath) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$header$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                    fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                    lineNumber: 116,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$sidebar$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {
                    menu: menuType
                }, void 0, false, {
                    fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                    lineNumber: 118,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "content-wrapper transition-all duration-150",
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "pt-5 px-6 pb-20 page-min-height-horizontal",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$dashboard$2f$layout$2d$wrapper$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["LayoutWrapper"], {
                            location: location,
                            children: children
                        }, void 0, false, {
                            fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                            lineNumber: 121,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0))
                    }, void 0, false, {
                        fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                        lineNumber: 120,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                    lineNumber: 119,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$partials$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                    fileName: "[project]/frontend/provider/dashboard.provider.tsx",
                    lineNumber: 124,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true);
    }
    // For non-admin pages, just render children without admin layout
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
        children: children
    }, void 0, false);
};
const __TURBOPACK__default__export__ = DashBoardLayoutProvider;
}),
"[project]/frontend/i18n/routing.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Link",
    ()=>Link,
    "redirect",
    ()=>redirect,
    "routing",
    ()=>routing,
    "usePathname",
    ()=>usePathname,
    "useRouter",
    ()=>useRouter
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$navigation$2f$react$2d$client$2f$createNavigation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__createNavigation$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/navigation/react-client/createNavigation.js [app-ssr] (ecmascript) <export default as createNavigation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$routing$2f$defineRouting$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__defineRouting$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/routing/defineRouting.js [app-ssr] (ecmascript) <export default as defineRouting>");
;
;
// Get default locale from environment variable or fallback to "en"
const defaultLocale = ("TURBOPACK compile-time value", "en") || "en";
// Handle multi-line environment variable with proper parsing
const languagesString = ("TURBOPACK compile-time value", "en") || "";
const locales = languagesString.split(/[,\n\r]+/) // Split by comma, newline, or carriage return
.map((code)=>code.trim()) // Remove whitespace
.filter((code)=>code.length > 0) || [
    defaultLocale,
    "ar"
]; // Use default locale in fallback
const routing = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$routing$2f$defineRouting$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__defineRouting$3e$__["defineRouting"])({
    locales: locales,
    defaultLocale: defaultLocale,
    localePrefix: "always",
    localeDetection: true
});
const { Link, usePathname, useRouter, redirect } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$navigation$2f$react$2d$client$2f$createNavigation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__createNavigation$3e$__["createNavigation"])(routing);
}),
"[project]/frontend/config/settings.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "DEFAULT_SETTINGS",
    ()=>DEFAULT_SETTINGS,
    "FIELD_DEFINITIONS",
    ()=>FIELD_DEFINITIONS,
    "TABS",
    ()=>TABS
]);
const TABS = [
    {
        id: "general",
        label: "General"
    },
    {
        id: "wallet",
        label: "Wallet"
    },
    {
        id: "features",
        label: "Trading & Features"
    },
    {
        id: "social",
        label: "Social"
    },
    {
        id: "logos",
        label: "Logos"
    }
];
const FIELD_DEFINITIONS = [
    // General Settings
    {
        key: "layoutSwitcher",
        label: "Theme Switcher",
        type: "switch",
        description: "Allow users to switch between light and dark themes",
        category: "general",
        subcategory: "UI Options"
    },
    {
        key: "landingPageType",
        label: "Landing Page Type",
        type: "select",
        description: "Choose the landing page to display for users.",
        category: "general",
        subcategory: "UI Options",
        options: [
            {
                label: "Default",
                value: "DEFAULT"
            },
            {
                label: "Custom",
                value: "CUSTOM"
            }
        ]
    },
    {
        key: "themeSwitcher",
        label: "Theme Switcher",
        type: "switch",
        description: "Allow users to switch between light and dark themes",
        category: "general",
        subcategory: "UI Options"
    },
    {
        key: "floatingLiveChat",
        label: "Floating Live Chat",
        type: "switch",
        description: "Show floating live chat button",
        category: "general",
        subcategory: "UI Options"
    },
    {
        key: "navbarLogoDisplay",
        label: "Navbar Logo Display",
        type: "select",
        description: "Choose how to display the logo in navigation bars",
        category: "general",
        subcategory: "UI Options",
        options: [
            {
                label: "Square Logo + Site Name",
                value: "SQUARE_WITH_NAME"
            },
            {
                label: "Full Logo Only",
                value: "FULL_LOGO_ONLY"
            }
        ]
    },
    {
        key: "newsStatus",
        label: "News Section",
        type: "switch",
        description: "Enable news section on the platform",
        category: "general",
        subcategory: "Content"
    },
    {
        key: "blogPostLayout",
        label: "Blog Post Layout",
        type: "select",
        description: "Select the layout for blog posts",
        category: "general",
        subcategory: "Content",
        options: [
            {
                label: "Default",
                value: "DEFAULT"
            },
            {
                label: "Modern",
                value: "MODERN"
            },
            {
                label: "Classic",
                value: "CLASSIC"
            }
        ],
        preview: {
            light: {
                DEFAULT: "/img/preview/blog/layout/default.webp",
                CLASSIC: "/img/preview/blog/layout/trail.webp",
                MODERN: "/img/preview/blog/layout/toc.webp"
            },
            dark: {
                DEFAULT: "/img/preview/blog/layout/default-dark.webp",
                CLASSIC: "/img/preview/blog/layout/trail-dark.webp",
                MODERN: "/img/preview/blog/layout/toc-dark.webp"
            }
        }
    },
    // Wallet Settings
    {
        key: "deposit",
        label: "Deposits",
        type: "switch",
        description: "Enable deposit functionality",
        category: "wallet",
        subcategory: "Core Functions"
    },
    {
        key: "withdraw",
        label: "Withdrawals",
        type: "switch",
        description: "Enable withdrawal functionality",
        category: "wallet",
        subcategory: "Core Functions"
    },
    {
        key: "transfer",
        label: "Transfers",
        type: "switch",
        description: "Enable transfer functionality",
        category: "wallet",
        subcategory: "Core Functions"
    },
    {
        key: "depositExpiration",
        label: "Deposit Expiration",
        type: "switch",
        description: "Enable deposit expiration",
        category: "wallet",
        subcategory: "Restrictions"
    },
    {
        key: "fiatWallets",
        label: "Fiat Wallets",
        type: "switch",
        description: "Enable fiat currency wallets",
        category: "wallet",
        subcategory: "Wallet Types"
    },
    {
        key: "walletTransferFee",
        label: "Wallet Transfer Fee (%)",
        type: "number",
        description: "Fee percentage for wallet transfers",
        category: "wallet",
        subcategory: "Fees",
        min: 0,
        max: 100,
        step: 0.1
    },
    {
        key: "spotWithdrawFee",
        label: "Spot Withdraw Fee (%)",
        type: "number",
        description: "Fee percentage for spot withdrawals",
        category: "wallet",
        subcategory: "Fees",
        min: 0,
        max: 100,
        step: 0.1
    },
    // Features Settings
    {
        key: "investment",
        label: "Investment",
        type: "switch",
        description: "Enable investment features",
        category: "features",
        subcategory: "Investment"
    },
    // {
    //   key: "forexInvestment",
    //   label: "Forex Investment",
    //   type: "switch",
    //   description: "Enable forex investment features",
    //   category: "features",
    //   subcategory: "Investment",
    // },
    {
        key: "kycStatus",
        label: "KYC Verification",
        type: "switch",
        description: "Enable KYC verification for users",
        category: "features",
        subcategory: "Verification"
    },
    {
        key: "spotWallets",
        label: "Spot Trading",
        type: "switch",
        description: "Enable spot trading functionality",
        category: "features",
        subcategory: "Trading"
    },
    {
        key: "chartType",
        label: "Chart Type",
        type: "select",
        description: "Choose the charting library for trading pages",
        category: "features",
        subcategory: "Trading",
        options: [
            {
                label: "Native Chart",
                value: "NATIVE"
            },
            {
                label: "TradingView Advanced",
                value: "TRADINGVIEW"
            }
        ]
    },
    // {
    //   key: "p2pCommission",
    //   label: "P2P Commission (%)",
    //   type: "number",
    //   description: "Commission percentage for P2P transactions",
    //   category: "features",
    //   subcategory: "P2P",
    //   min: 0,
    //   max: 100,
    //   step: 0.1,
    // },
    // {
    //   key: "mlmSystem",
    //   label: "MLM System",
    //   type: "select",
    //   description: "Select the MLM system type",
    //   category: "features",
    //   subcategory: "Affiliate",
    //   options: [
    //     { label: "Direct", value: "DIRECT" },
    //     { label: "Binary", value: "BINARY" },
    //     { label: "Unilevel", value: "UNILEVEL" },
    //   ],
    // },
    // {
    //   key: "binaryLevels",
    //   label: "Binary Levels",
    //   type: "number",
    //   description: "Number of binary levels",
    //   category: "features",
    //   subcategory: "Affiliate",
    //   showIf: (values) => values.mlmSystem === "BINARY",
    //   min: 2,
    //   max: 10,
    //   step: 1,
    // },
    // {
    //   key: "unilevelLevels",
    //   label: "Unilevel Levels",
    //   type: "number",
    //   description: "Number of unilevel levels",
    //   category: "features",
    //   subcategory: "Affiliate",
    //   showIf: (values) => values.mlmSystem === "UNILEVEL",
    //   min: 2,
    //   max: 10,
    //   step: 1,
    // },
    // {
    //   key: "referralApprovalRequired",
    //   label: "Referral Approval Required",
    //   type: "switch",
    //   description: "Require approval for referrals",
    //   category: "features",
    //   subcategory: "Affiliate",
    // },
    // Social Links
    {
        key: "facebookLink",
        label: "Facebook",
        type: "url",
        description: "Facebook page URL",
        category: "social"
    },
    {
        key: "twitterLink",
        label: "Twitter",
        type: "url",
        description: "Twitter profile URL",
        category: "social"
    },
    {
        key: "instagramLink",
        label: "Instagram",
        type: "url",
        description: "Instagram profile URL",
        category: "social"
    },
    {
        key: "linkedinLink",
        label: "LinkedIn",
        type: "url",
        description: "LinkedIn page URL",
        category: "social"
    },
    {
        key: "telegramLink",
        label: "Telegram",
        type: "url",
        description: "Telegram channel URL",
        category: "social"
    },
    {
        key: "appStoreLink",
        label: "App Store Link",
        type: "url",
        description: "Link to your iOS app on the App Store",
        category: "social"
    },
    {
        key: "googlePlayLink",
        label: "Google Play Link",
        type: "url",
        description: "Link to your Android app on Google Play Store",
        category: "social"
    },
    // Logos
    {
        key: "logo",
        label: "Main Logo",
        type: "file",
        description: "Main logo (96x96px)",
        category: "logos",
        subcategory: "Main",
        fileSize: {
            width: 96,
            height: 96
        }
    },
    {
        key: "darkLogo",
        label: "Dark Logo",
        type: "file",
        description: "Logo for dark theme (96x96px)",
        category: "logos",
        subcategory: "Main",
        fileSize: {
            width: 96,
            height: 96
        }
    },
    {
        key: "fullLogo",
        label: "Full Logo",
        type: "file",
        description: "Full logo with text (350x75px)",
        category: "logos",
        subcategory: "Main",
        fileSize: {
            width: 350,
            height: 75
        }
    },
    {
        key: "darkFullLogo",
        label: "Dark Full Logo",
        type: "file",
        description: "Full logo for dark theme (350x75px)",
        category: "logos",
        subcategory: "Main",
        fileSize: {
            width: 350,
            height: 75
        }
    },
    {
        key: "cardLogo",
        label: "Card Logo",
        type: "file",
        description: "Logo for cards (256x256px)",
        category: "logos",
        subcategory: "Main",
        fileSize: {
            width: 256,
            height: 256
        }
    },
    {
        key: "favicon16",
        label: "Favicon 16x16",
        type: "file",
        description: "Favicon (16x16px)",
        category: "logos",
        subcategory: "Favicons",
        fileSize: {
            width: 16,
            height: 16
        }
    },
    {
        key: "favicon32",
        label: "Favicon 32x32",
        type: "file",
        description: "Favicon (32x32px)",
        category: "logos",
        subcategory: "Favicons",
        fileSize: {
            width: 32,
            height: 32
        }
    },
    {
        key: "favicon96",
        label: "Favicon 96x96",
        type: "file",
        description: "Favicon (96x96px)",
        category: "logos",
        subcategory: "Favicons",
        fileSize: {
            width: 96,
            height: 96
        }
    },
    {
        key: "appleIcon57",
        label: "Apple Icon 57x57",
        type: "file",
        description: "Apple touch icon (57x57px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 57,
            height: 57
        }
    },
    {
        key: "appleIcon60",
        label: "Apple Icon 60x60",
        type: "file",
        description: "Apple touch icon (60x60px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 60,
            height: 60
        }
    },
    {
        key: "appleIcon72",
        label: "Apple Icon 72x72",
        type: "file",
        description: "Apple touch icon (72x72px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 72,
            height: 72
        }
    },
    {
        key: "appleIcon76",
        label: "Apple Icon 76x76",
        type: "file",
        description: "Apple touch icon (76x76px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 76,
            height: 76
        }
    },
    {
        key: "appleIcon114",
        label: "Apple Icon 114x114",
        type: "file",
        description: "Apple touch icon (114x114px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 114,
            height: 114
        }
    },
    {
        key: "appleIcon120",
        label: "Apple Icon 120x120",
        type: "file",
        description: "Apple touch icon (120x120px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 120,
            height: 120
        }
    },
    {
        key: "appleIcon144",
        label: "Apple Icon 144x144",
        type: "file",
        description: "Apple touch icon (144x144px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 144,
            height: 144
        }
    },
    {
        key: "appleIcon152",
        label: "Apple Icon 152x152",
        type: "file",
        description: "Apple touch icon (152x152px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 152,
            height: 152
        }
    },
    {
        key: "appleIcon180",
        label: "Apple Icon 180x180",
        type: "file",
        description: "Apple touch icon (180x180px)",
        category: "logos",
        subcategory: "Apple Icons",
        fileSize: {
            width: 180,
            height: 180
        }
    },
    {
        key: "androidIcon192",
        label: "Android Icon 192x192",
        type: "file",
        description: "Android icon (192x192px)",
        category: "logos",
        subcategory: "Android Icons",
        fileSize: {
            width: 192,
            height: 192
        }
    },
    {
        key: "androidIcon256",
        label: "Android Icon 256x256",
        type: "file",
        description: "Android icon (256x256px)",
        category: "logos",
        subcategory: "Android Icons",
        fileSize: {
            width: 256,
            height: 256
        }
    },
    {
        key: "androidIcon384",
        label: "Android Icon 384x384",
        type: "file",
        description: "Android icon (384x384px)",
        category: "logos",
        subcategory: "Android Icons",
        fileSize: {
            width: 384,
            height: 384
        }
    },
    {
        key: "androidIcon512",
        label: "Android Icon 512x512",
        type: "file",
        description: "Android icon (512x512px)",
        category: "logos",
        subcategory: "Android Icons",
        fileSize: {
            width: 512,
            height: 512
        }
    },
    {
        key: "msIcon144",
        label: "MS Icon 144x144",
        type: "file",
        description: "Microsoft icon (144x144px)",
        category: "logos",
        subcategory: "Microsoft Icons",
        fileSize: {
            width: 144,
            height: 144
        }
    }
];
const DEFAULT_SETTINGS = {
    binaryLevel1: "1",
    binaryLevel2: "1",
    binaryLevels: "2",
    binaryRestrictions: "false",
    blogPostLayout: "DEFAULT",
    botRestrictions: "false",
    cardLogo: "",
    deposit: "true",
    depositExpiration: "true",
    depositRestrictions: "true",
    ecommerceRestrictions: "false",
    enableStickyTopNavigationHeader: "true",
    facebookLink: "https://facebook.com/#mash",
    fiatWallets: "true",
    spotWallets: "true",
    floatingLiveChat: "true",
    forexInvestment: "true",
    forexRestrictions: "false",
    frontendType: "default",
    googleTargetLanguage: "en",
    googleTranslateStatus: "false",
    icoRestrictions: "false",
    instagramLink: "https://instagram.com/#mash",
    investment: "true",
    kycStatus: "true",
    layoutSwitcher: "true",
    logo: "",
    mlmRestrictions: "false",
    mlmSettings: '{"unilevel":{"levels":"5","levelsPercentage":[{"level":1,"value":"1"},{"level":2,"value":"2"},{"level":3,"value":"3"},{"level":4,"value":"4"},{"level":5,"value":"5"}]}}',
    mlmSystem: "UNILEVEL",
    navbarLogoDisplay: "SQUARE_WITH_NAME",
    newsStatus: "true",
    referralApprovalRequired: "true",
    siteMaintenanceMode: "true",
    spotWithdrawFee: "1",
    stakingRestrictions: "false",
    themeSwitcher: "true",
    tradeRestrictions: "false",
    transfer: "true",
    transferRestrictions: "true",
    twitterLink: "https://x.com/#mash",
    appStoreLink: "",
    googlePlayLink: "",
    unilevelLevel1: "1",
    unilevelLevel2: "2",
    unilevelLevel3: "3",
    unilevelLevel4: "4",
    unilevelLevel5: "5",
    unilevelLevels: "5",
    walletRestrictions: "true",
    walletTransferFee: "1",
    withdraw: "true",
    withdrawalRestrictions: "false",
    withdrawApproval: "true",
    withdrawChainFee: "false"
};
}),
"[project]/frontend/config/menu.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// lib/menu.ts
__turbopack_context__.s([
    "adminMenu",
    ()=>adminMenu,
    "getMenu",
    ()=>getMenu,
    "userMenu",
    ()=>userMenu
]);
const adminMenu = [
    {
        key: "admin-dashboard",
        title: "Dashboard",
        href: "/admin",
        permission: "access.admin",
        icon: "solar:home-angle-line-duotone",
        description: "Comprehensive administrative overview with real-time analytics, system health monitoring, and quick access to critical management functions."
    },
    {
        key: "admin-user-management",
        title: "Users",
        href: "/admin/crm",
        icon: "solar:users-group-two-rounded-bold-duotone",
        description: "Complete user lifecycle management including registration, verification, role assignment, and customer relationship tools for comprehensive user administration.",
        permission: [
            "access.user",
            "access.role",
            "access.permission",
            "access.kyc.application",
            "access.kyc.level",
            "access.support.ticket"
        ],
        child: [
            {
                key: "admin-users",
                title: "Users",
                icon: "ph:users-duotone",
                href: "/admin/crm/user",
                description: "Comprehensive user database with advanced filtering, bulk operations, profile management, and detailed activity tracking.",
                permission: "access.user"
            },
            {
                key: "admin-roles-permissions",
                title: "Roles & Permissions",
                icon: "ph:shield-check-duotone",
                description: "Advanced access control system for defining user roles, managing permissions, and implementing security policies across the platform.",
                permission: [
                    "access.role",
                    "access.permission"
                ],
                child: [
                    {
                        key: "admin-roles",
                        title: "User Roles",
                        href: "/admin/crm/role",
                        permission: "access.role",
                        icon: "ph:shield-check-duotone",
                        description: "Create and manage user roles with customizable permission sets and hierarchical access control structures."
                    },
                    {
                        key: "admin-permissions",
                        title: "Permissions",
                        href: "/admin/crm/permission",
                        permission: "access.permission",
                        icon: "ph:key-duotone",
                        description: "Granular permission management for fine-tuned access control across all system functions and features."
                    }
                ]
            },
            {
                key: "admin-compliance",
                title: "Compliance & Verification",
                icon: "ph:certificate-duotone",
                description: "Regulatory compliance tools including KYC processing, document verification, and identity management for legal adherence.",
                permission: [
                    "access.kyc.application",
                    "access.kyc.level"
                ],
                child: [
                    {
                        key: "admin-kyc-applications",
                        title: "KYC Applications",
                        href: "/admin/crm/kyc/application",
                        permission: "access.kyc.application",
                        icon: "ph:identification-card-duotone",
                        description: "Review and process Know Your Customer applications with document verification, risk assessment, and approval workflows."
                    },
                    {
                        key: "admin-kyc-levels",
                        title: "Verification Levels",
                        href: "/admin/crm/kyc/level",
                        permission: "access.kyc.level",
                        icon: "ph:ranking-duotone",
                        description: "Configure verification tiers with customizable requirements, limits, and access privileges for different user categories."
                    }
                ]
            },
            {
                key: "admin-support",
                title: "Customer Support",
                icon: "ph:headset-duotone",
                href: "/admin/crm/support",
                permission: "access.support.ticket",
                description: "Integrated support ticket system with priority management, response tracking, and customer satisfaction monitoring."
            },
            {
                key: "admin-api-management",
                title: "API Management",
                icon: "carbon:api",
                href: "/admin/api/key",
                permission: "access.api.key",
                description: "API key lifecycle management with usage monitoring, rate limiting, and security controls for third-party integrations."
            }
        ]
    },
    {
        key: "admin-financial-operations",
        title: "Finance",
        href: "/admin/finance",
        icon: "solar:dollar-minimalistic-bold-duotone",
        description: "Comprehensive financial management suite covering revenue analytics, currency management, payment processing, and transaction oversight.",
        permission: [
            "access.admin.profit",
            "access.fiat.currency",
            "access.spot.currency",
            "access.deposit.gateway",
            "access.deposit.method",
            "access.deposit",
            "access.exchange",
            "access.investment.plan",
            "access.investment.duration",
            "access.investment",
            "access.binary.order",
            "access.exchange.order",
            "access.ecosystem.order",
            "access.futures.order",
            "access.transaction",
            "access.transfer",
            "access.wallet",
            "access.withdraw.method",
            "access.withdraw"
        ],
        child: [
            {
                key: "admin-analytics",
                title: "Revenue Analytics",
                icon: "ph:chart-line-up-duotone",
                href: "/admin/finance/profit",
                permission: "access.admin.profit",
                description: "Advanced financial analytics with profit tracking, revenue streams analysis, and comprehensive business intelligence dashboards."
            },
            {
                key: "admin-currencies",
                title: "Currency Management",
                icon: "ph:currency-circle-dollar-duotone",
                description: "Multi-currency support with real-time exchange rates, trading pairs configuration, and market data integration.",
                permission: [
                    "access.fiat.currency",
                    "access.spot.currency"
                ],
                child: [
                    {
                        key: "admin-fiat-currencies",
                        title: "Fiat Currencies",
                        href: "/admin/finance/currency/fiat",
                        permission: "access.fiat.currency",
                        icon: "ph:currency-dollar-duotone",
                        description: "Traditional currency management with exchange rate monitoring, regional settings, and payment gateway integration."
                    },
                    {
                        key: "admin-crypto-currencies",
                        title: "Cryptocurrencies",
                        href: "/admin/finance/currency/spot",
                        permission: "access.spot.currency",
                        icon: "ph:currency-btc-duotone",
                        description: "Digital asset management with blockchain integration, wallet connectivity, and real-time market data feeds."
                    }
                ]
            },
            {
                key: "admin-payment-systems",
                title: "Payment Systems",
                icon: "ph:credit-card-duotone",
                description: "Complete payment infrastructure management including gateways, methods, and transaction processing oversight.",
                permission: [
                    "access.deposit.gateway",
                    "access.deposit.method",
                    "access.deposit"
                ],
                child: [
                    {
                        key: "admin-payment-gateways",
                        title: "Payment Gateways",
                        href: "/admin/finance/deposit/gateway",
                        permission: "access.deposit.gateway",
                        icon: "ri:secure-payment-line",
                        description: "Configure and monitor payment gateways with fraud detection, compliance checks, and performance analytics."
                    },
                    {
                        key: "admin-payment-methods",
                        title: "Payment Methods",
                        href: "/admin/finance/deposit/method",
                        permission: "access.deposit.method",
                        icon: "ph:wallet-duotone",
                        description: "Manage available payment options including cards, bank transfers, digital wallets, and cryptocurrency payments."
                    },
                    {
                        key: "admin-deposit-logs",
                        title: "Deposit Records",
                        href: "/admin/finance/deposit/log",
                        permission: "access.deposit",
                        icon: "ph:download-simple-duotone",
                        description: "Comprehensive deposit transaction logs with status tracking, reconciliation tools, and audit capabilities."
                    }
                ]
            },
            {
                key: "admin-trading-infrastructure",
                title: "Trading Infrastructure",
                icon: "ph:chart-bar-duotone",
                description: "Trading platform management including exchange providers, market configurations, and order processing systems.",
                permission: "access.exchange",
                child: [
                    {
                        key: "admin-exchange-providers",
                        title: "Exchange Providers",
                        href: "/admin/finance/exchange",
                        icon: "material-symbols-light:component-exchange",
                        permission: "access.exchange",
                        description: "Manage exchange integrations with liquidity providers, API configurations, and performance monitoring."
                    }
                ]
            },
            {
                key: "admin-binary-trading",
                title: "Binary Options",
                icon: "humbleicons:exchange-vertical",
                href: "/admin/finance/binary",
                description: "Binary options trading system with market setup, duration management, and payout configuration.",
                permission: [
                    "access.binary.market",
                    "access.binary.duration"
                ],
                child: [
                    {
                        key: "admin-binary-markets",
                        title: "Binary Markets",
                        href: "/admin/finance/binary/market",
                        permission: "access.binary.market",
                        icon: "ri:exchange-2-line",
                        description: "Configure binary options markets with asset pairs, trading parameters, and market hours."
                    },
                    {
                        key: "admin-binary-durations",
                        title: "Trading Durations",
                        href: "/admin/finance/binary/duration",
                        permission: "access.binary.duration",
                        icon: "ph:clock-duotone",
                        description: "Set trading timeframes and payout percentages for binary options with risk management controls."
                    }
                ]
            },
            {
                key: "admin-investment-management",
                title: "Investment Management",
                icon: "solar:course-up-bold-duotone",
                settings: [
                    "investment"
                ],
                description: "Investment product management with plan creation, performance tracking, and portfolio oversight tools.",
                permission: [
                    "access.investment.plan",
                    "access.investment.duration",
                    "access.investment"
                ],
                child: [
                    {
                        key: "admin-investment-plans",
                        title: "Investment Plans",
                        href: "/admin/finance/investment/plan",
                        permission: "access.investment.plan",
                        settings: [
                            "investment"
                        ],
                        icon: "solar:planet-2-bold-duotone",
                        description: "Create and manage investment products with risk profiles, return calculations, and term configurations."
                    },
                    {
                        key: "admin-investment-durations",
                        title: "Investment Durations",
                        href: "/admin/finance/investment/duration",
                        permission: "access.investment.duration",
                        settings: [
                            "investment"
                        ],
                        icon: "ph:hourglass-duotone",
                        description: "Configure investment durations, maturity periods, and compound interest calculations for various products."
                    },
                    {
                        key: "admin-investment-history",
                        title: "Investment Analytics",
                        href: "/admin/finance/investment/history",
                        permission: "access.investment",
                        settings: [
                            "investment"
                        ],
                        icon: "ph:chart-line-duotone",
                        description: "Comprehensive investment performance analytics with ROI tracking and portfolio management insights."
                    }
                ]
            },
            {
                key: "admin-order-management",
                title: "Order Management",
                icon: "solar:clipboard-list-bold-duotone",
                description: "Centralized order processing and management across all trading platforms and asset classes.",
                permission: [
                    "access.binary.order",
                    "access.exchange.order",
                    "access.ecosystem.order",
                    "access.futures.order"
                ],
                child: [
                    {
                        key: "admin-binary-orders",
                        title: "Binary Orders",
                        href: "/admin/finance/order/binary",
                        icon: "tabler:binary-tree",
                        permission: "access.binary.order",
                        env: ("TURBOPACK compile-time value", "true"),
                        description: "Monitor and manage binary options orders with execution tracking and settlement processing."
                    },
                    {
                        key: "admin-spot-orders",
                        title: "Spot Orders",
                        href: "/admin/finance/order/exchange",
                        permission: "access.exchange.order",
                        icon: "bi:currency-exchange",
                        description: "Spot trading order management with real-time execution monitoring and market impact analysis."
                    },
                    {
                        key: "admin-ecosystem-orders",
                        title: "Ecosystem Orders",
                        href: "/admin/finance/order/ecosystem",
                        permission: "access.ecosystem.order",
                        extension: "ecosystem",
                        icon: "mdi:briefcase-exchange-outline",
                        description: "Blockchain ecosystem trading orders with smart contract integration and decentralized execution."
                    },
                    {
                        key: "admin-futures-orders",
                        title: "Futures Orders",
                        href: "/admin/finance/order/futures",
                        permission: "access.futures.order",
                        extension: "futures",
                        icon: "mdi:chart-line-variant",
                        description: "Futures contract order management with margin tracking and risk assessment tools."
                    }
                ]
            },
            {
                key: "admin-transaction-management",
                title: "Transaction Management",
                icon: "solar:transfer-horizontal-bold-duotone",
                description: "Complete transaction oversight with detailed logging, reconciliation, and transfer management capabilities.",
                permission: [
                    "access.transaction",
                    "access.transfer",
                    "access.wallet"
                ],
                child: [
                    {
                        key: "admin-transaction-logs",
                        title: "Transaction Logs",
                        href: "/admin/finance/transaction",
                        permission: "access.transaction",
                        icon: "solar:clipboard-list-bold-duotone",
                        description: "Comprehensive transaction history with advanced filtering, export capabilities, and audit trails."
                    },
                    {
                        key: "admin-internal-transfers",
                        title: "Internal Transfers",
                        href: "/admin/finance/transfer",
                        permission: "access.transfer",
                        icon: "solar:transfer-vertical-line-duotone",
                        description: "Manage internal fund transfers between accounts with approval workflows and compliance checks."
                    },
                    {
                        key: "admin-wallet-management",
                        title: "Wallet Management",
                        href: "/admin/finance/wallet",
                        permission: "access.wallet",
                        icon: "ph:wallet-duotone",
                        description: "Multi-currency wallet administration with balance monitoring, security controls, and backup management."
                    }
                ]
            },
            {
                key: "admin-withdrawal-management",
                title: "Withdrawal Management",
                icon: "ph:hand-withdraw-duotone",
                href: "/admin/finance/withdraw/log",
                description: "Comprehensive withdrawal system management with automated processing, fraud prevention, and compliance controls.",
                permission: [
                    "access.withdraw.method",
                    "access.withdraw"
                ],
                child: [
                    {
                        key: "admin-withdrawal-methods",
                        title: "Withdrawal Methods",
                        href: "/admin/finance/withdraw/method",
                        permission: "access.withdraw.method",
                        icon: "ph:bank-duotone",
                        description: "Configure withdrawal options including bank transfers, crypto withdrawals, and third-party processors."
                    },
                    {
                        key: "admin-withdrawal-logs",
                        title: "Withdrawal Records",
                        href: "/admin/finance/withdraw/log",
                        permission: "access.withdraw",
                        icon: "ph:upload-simple-duotone",
                        description: "Monitor withdrawal requests with status tracking, approval workflows, and compliance verification."
                    }
                ]
            }
        ]
    },
    {
        key: "admin-content-management",
        title: "Content",
        href: "/admin/content",
        icon: "solar:document-text-bold-duotone",
        description: "Comprehensive content management system for blogs, media assets, and dynamic website content.",
        permission: [
            "access.content.media",
            "access.content.slider"
        ],
        child: [
            {
                key: "admin-blog-system",
                title: "Blog System",
                href: "/admin/blog",
                icon: "solar:document-add-bold-duotone",
                description: "Complete blog management with author profiles, content scheduling, SEO optimization, and engagement analytics."
            },
            {
                key: "admin-media-library",
                title: "Media Library",
                icon: "ph:image-duotone",
                href: "/admin/content/media",
                permission: "access.content.media",
                description: "Centralized media management with cloud storage, image optimization, and CDN integration for optimal performance."
            },
            {
                key: "admin-homepage-sliders",
                title: "Homepage Sliders",
                icon: "solar:slider-vertical-bold-duotone",
                href: "/admin/content/slider",
                permission: "access.content.slider",
                description: "Dynamic homepage content management with responsive sliders, call-to-action buttons, and A/B testing capabilities."
            }
        ]
    },
    {
        key: "admin-platform-extensions",
        title: "Extensions",
        href: "/admin/extensions",
        icon: "ph:puzzle-piece-duotone",
        description: "Advanced platform extensions providing specialized functionality for trading, marketplace, and business operations.",
        megaMenu: [
            {
                key: "admin-trading-extensions",
                title: "Trading Platforms",
                icon: "ph:chart-line-duotone",
                image: "/img/megamenu/extensions/trading.svg",
                description: "Professional trading platforms with advanced order types, market analysis tools, and institutional-grade execution.",
                child: [
                    {
                        key: "admin-ecosystem-platform",
                        title: "Blockchain Ecosystem",
                        icon: "ph:globe-duotone",
                        extension: "ecosystem",
                        permission: "access.ecosystem",
                        description: "Decentralized trading ecosystem with blockchain integration, DeFi protocols, and smart contract automation.",
                        child: [
                            {
                                key: "admin-blockchain-networks",
                                title: "Blockchain Networks",
                                href: "/admin/ecosystem",
                                permission: "access.ecosystem.blockchain",
                                icon: "hugeicons:blockchain-02",
                                description: "Multi-chain network management with node monitoring, consensus tracking, and network health analytics."
                            },
                            {
                                key: "admin-master-wallets",
                                title: "Master Wallets",
                                href: "/admin/ecosystem/wallet/master",
                                permission: "access.ecosystem.master.wallet",
                                icon: "ph:vault-duotone",
                                description: "Enterprise-grade master wallet management with multi-signature security and cold storage integration."
                            },
                            {
                                key: "admin-custodial-wallets",
                                title: "Custodial Services",
                                href: "/admin/ecosystem/wallet/custodial",
                                permission: "access.ecosystem.custodial.wallet",
                                icon: "ph:shield-check-duotone",
                                description: "Institutional custodial wallet services with regulatory compliance and insurance coverage."
                            },
                            {
                                key: "admin-ecosystem-markets",
                                title: "DeFi Markets",
                                href: "/admin/ecosystem/market",
                                permission: "access.ecosystem.market",
                                icon: "ri:exchange-2-line",
                                description: "Decentralized market management with AMM protocols, liquidity pools, and yield farming integration."
                            },
                            {
                                key: "admin-token-management",
                                title: "Token Management",
                                href: "/admin/ecosystem/token",
                                permission: "access.ecosystem.token",
                                icon: "ph:coin-duotone",
                                description: "Comprehensive token lifecycle management with minting, burning, and governance capabilities."
                            },
                            {
                                key: "admin-utxo-tracking",
                                title: "UTXO Tracking",
                                href: "/admin/ecosystem/utxo",
                                permission: "access.ecosystem.utxo",
                                icon: "carbon:cics-transaction-server-zos",
                                description: "Advanced UTXO management with transaction graph analysis and privacy-preserving features."
                            },
                            {
                                key: "admin-blockchain-ledgers",
                                title: "Blockchain Ledgers",
                                href: "/admin/ecosystem/ledger",
                                permission: "access.ecosystem.private.ledger",
                                icon: "ph:books-duotone",
                                description: "Immutable ledger management with audit trails, compliance reporting, and forensic analysis tools."
                            }
                        ]
                    },
                    {
                        key: "admin-futures-platform",
                        title: "Futures Trading",
                        icon: "ph:chart-line-duotone",
                        extension: "futures",
                        permission: "access.futures.market",
                        description: "Professional futures trading platform with margin management, risk controls, and institutional execution.",
                        child: [
                            {
                                key: "admin-futures-markets",
                                title: "Futures Markets",
                                href: "/admin/futures/market",
                                permission: "access.futures.market",
                                icon: "ri:exchange-2-line",
                                description: "Futures market configuration with contract specifications, margin requirements, and settlement procedures."
                            },
                            {
                                key: "admin-futures-positions",
                                title: "Position Management",
                                href: "/admin/futures/position",
                                permission: "access.futures.position",
                                icon: "humbleicons:exchange-vertical",
                                description: "Real-time position monitoring with P&L tracking, margin calls, and automated risk management."
                            }
                        ]
                    },
                    {
                        key: "admin-forex-platform",
                        title: "Forex Trading",
                        icon: "ph:currency-dollar-simple-duotone",
                        extension: "forex",
                        permission: "access.forex.account",
                        href: "/admin/forex/account",
                        description: "Professional forex trading with MetaTrader integration, algorithmic trading, and institutional liquidity."
                    },
                    {
                        key: "admin-p2p-platform",
                        title: "P2P Exchange",
                        icon: "ph:users-four-duotone",
                        extension: "p2p",
                        permission: "access.p2p",
                        href: "/admin/p2p",
                        description: "Peer-to-peer trading platform with escrow services, dispute resolution, and multi-payment gateway support."
                    }
                ]
            },
            {
                key: "admin-investment-extensions",
                title: "Investment Products",
                icon: "ph:lightning-duotone",
                image: "/img/megamenu/extensions/investment.svg",
                description: "Advanced investment products with AI-driven strategies, staking services, and tokenization platforms.",
                child: [
                    {
                        key: "admin-ai-investment",
                        title: "AI Investment",
                        icon: "ph:robot-duotone",
                        extension: "ai_investment",
                        permission: "access.ai.investment",
                        description: "Artificial intelligence-powered investment management with machine learning algorithms and automated portfolio optimization.",
                        child: [
                            {
                                key: "admin-ai-strategies",
                                title: "AI Strategies",
                                href: "/admin/ai/investment/plan",
                                permission: "access.ai.investment.plan",
                                icon: "ph:brain-duotone",
                                description: "Machine learning investment strategies with backtesting, risk assessment, and performance optimization."
                            },
                            {
                                key: "admin-ai-durations",
                                title: "Strategy Durations",
                                href: "/admin/ai/investment/duration",
                                permission: "access.ai.investment.duration",
                                icon: "ph:clock-countdown-duotone",
                                description: "Configure AI strategy timeframes with dynamic rebalancing and market condition adaptations."
                            },
                            {
                                key: "admin-ai-performance",
                                title: "AI Performance",
                                href: "/admin/ai/investment/log",
                                permission: "access.ai.investment",
                                icon: "ph:chart-line-up-duotone",
                                description: "AI investment performance analytics with model accuracy tracking and strategy effectiveness metrics."
                            }
                        ]
                    },
                    {
                        key: "admin-staking-platform",
                        title: "Staking Services",
                        icon: "ph:stack-duotone",
                        extension: "staking",
                        permission: "access.staking",
                        href: "/admin/staking",
                        description: "Comprehensive staking platform with validator management, reward distribution, and slashing protection."
                    },
                    {
                        key: "admin-ico-platform",
                        title: "Token Sales",
                        icon: "hugeicons:ico",
                        extension: "ico",
                        permission: "access.ico",
                        href: "/admin/ico",
                        description: "Initial Coin Offering platform with KYC integration, smart contract deployment, and regulatory compliance."
                    }
                ]
            },
            {
                key: "admin-marketplace-extensions",
                title: "Marketplace Solutions",
                icon: "ph:shopping-cart-duotone",
                image: "/img/megamenu/extensions/marketplace.svg",
                description: "E-commerce and digital marketplace platforms with comprehensive seller tools and buyer protection.",
                child: [
                    {
                        key: "admin-ecommerce-platform",
                        title: "E-commerce Platform",
                        icon: "ph:storefront-duotone",
                        extension: "ecommerce",
                        permission: "access.ecommerce.category",
                        href: "/admin/ecommerce",
                        description: "Full-featured e-commerce platform with inventory management, order processing, and multi-vendor support."
                    },
                    {
                        key: "admin-nft-marketplace",
                        title: "NFT Marketplace",
                        icon: "ph:image-square-duotone",
                        extension: "nft",
                        permission: "access.nft",
                        href: "/admin/nft",
                        description: "Professional NFT marketplace with minting tools, royalty management, and auction capabilities."
                    }
                ]
            },
            {
                key: "admin-business-extensions",
                title: "Business Tools",
                icon: "ph:briefcase-duotone",
                image: "/img/megamenu/extensions/others.svg",
                description: "Essential business tools for marketing, customer support, and knowledge management.",
                child: [
                    {
                        key: "admin-affiliate-system",
                        title: "Affiliate Program",
                        icon: "ph:handshake-duotone",
                        extension: "mlm",
                        permission: "access.affiliate",
                        href: "/admin/affiliate",
                        description: "Multi-level affiliate program with commission tracking, performance analytics, and automated payouts."
                    },
                    {
                        key: "admin-knowledge-base",
                        title: "Knowledge Base",
                        icon: "ph:book-open-duotone",
                        extension: "knowledge_base",
                        permission: "access.faq",
                        href: "/admin/faq",
                        description: "Comprehensive knowledge management system with AI-powered search and content optimization."
                    },
                    {
                        key: "admin-email-marketing",
                        title: "Email Marketing",
                        icon: "ph:envelope-duotone",
                        extension: "mailwizard",
                        permission: "access.mailwizard.campaign",
                        description: "Professional email marketing platform with automation workflows, A/B testing, and analytics.",
                        child: [
                            {
                                key: "admin-email-campaigns",
                                title: "Email Campaigns",
                                href: "/admin/mailwizard/campaign",
                                permission: "access.mailwizard.campaign",
                                icon: "ph:megaphone-duotone",
                                description: "Create and manage email campaigns with segmentation, personalization, and performance tracking."
                            },
                            {
                                key: "admin-email-templates",
                                title: "Email Templates",
                                href: "/admin/mailwizard/template",
                                permission: "access.mailwizard.template",
                                icon: "fluent-mdl2:chart-template",
                                description: "Professional email template library with responsive design and brand customization options."
                            }
                        ]
                    }
                ]
            }
        ]
    },
    {
        key: "admin-system-administration",
        title: "System",
        href: "/admin/system",
        icon: "solar:settings-bold-duotone",
        description: "Complete system administration suite for platform configuration, monitoring, and maintenance operations.",
        permission: [
            "access.system.announcement",
            "access.cron",
            "access.extension",
            "access.system.log",
            "access.notification.template",
            "access.settings",
            "access.system.update",
            "access.admin.system.upgrade"
        ],
        child: [
            {
                key: "admin-platform-settings",
                title: "Platform Settings",
                href: "/admin/system/settings",
                icon: "ph:gear-duotone",
                permission: "access.settings",
                description: "Core platform configuration including branding, localization, security policies, and feature toggles."
            },
            {
                key: "admin-system-updates",
                title: "System Updates",
                href: "/admin/system/update",
                icon: "ph:download-duotone",
                permission: "access.system.update",
                description: "Automated system updates with rollback capabilities, security patches, and feature deployment management."
            },
            {
                key: "admin-extension-manager",
                title: "Extension Manager",
                href: "/admin/system/extension",
                icon: "ph:puzzle-piece-duotone",
                permission: "access.extension",
                description: "Extension lifecycle management with installation, updates, dependency resolution, and compatibility checking."
            },
            {
                key: "admin-communication",
                title: "Communication Tools",
                icon: "ph:chat-circle-duotone",
                description: "Platform communication management including notifications, announcements, and user messaging systems.",
                permission: [
                    "access.notification.template",
                    "access.system.announcement"
                ],
                child: [
                    {
                        key: "admin-notification-templates",
                        title: "Notification Templates",
                        href: "/admin/system/notification/template",
                        permission: "access.notification.template",
                        icon: "ph:bell-duotone",
                        description: "Customizable notification templates with multi-channel delivery and personalization variables."
                    },
                    {
                        key: "admin-system-announcements",
                        title: "System Announcements",
                        href: "/admin/system/announcement",
                        permission: "access.system.announcement",
                        icon: "ph:megaphone-duotone",
                        description: "Platform-wide announcement system with scheduling, targeting, and engagement tracking capabilities."
                    }
                ]
            },
            {
                key: "admin-monitoring",
                title: "System Monitoring",
                icon: "ph:monitor-duotone",
                description: "Comprehensive system monitoring with logging, performance metrics, and automated task management.",
                permission: [
                    "access.system.log",
                    "access.cron"
                ],
                child: [
                    {
                        key: "admin-system-logs",
                        title: "System Logs",
                        href: "/admin/system/log",
                        icon: "ph:file-text-duotone",
                        permission: "access.system.log",
                        description: "Centralized logging system with real-time monitoring, log aggregation, and advanced search capabilities."
                    },
                    {
                        key: "admin-scheduled-tasks",
                        title: "Scheduled Tasks",
                        href: "/admin/system/cron",
                        permission: "access.cron",
                        icon: "ph:calendar-duotone",
                        description: "Automated task scheduler with job monitoring, failure handling, and performance optimization."
                    }
                ]
            },
            {
                key: "admin-maintenance-tools",
                title: "Maintenance Tools",
                href: "/admin/system/upgrade-helper",
                icon: "ph:wrench-duotone",
                permission: "access.admin.system.upgrade",
                description: "System maintenance utilities including database optimization, cache management, and migration tools."
            }
        ]
    },
    {
        key: "admin-design-customization",
        title: "Design",
        icon: "solar:palette-bold-duotone",
        permission: "access.admin",
        description: "Customize your website appearance and design with advanced visual tools.",
        child: [
            {
                key: "admin-design-builder",
                title: "Page Builder",
                href: "/admin/builder",
                icon: "solar:widget-4-bold-duotone",
                permission: "access.admin",
                settingConditions: {
                    landingPageType: "CUSTOM"
                },
                description: "Advanced visual page builder with drag-and-drop interface, responsive design tools, and brand customization options."
            },
            {
                key: "admin-design-default-editor",
                title: "Default Pages",
                href: "/admin/default-editor",
                icon: "solar:code-bold-duotone",
                permission: "access.admin",
                settingConditions: {
                    landingPageType: "DEFAULT"
                },
                description: "Edit default frontend pages including home, legal pages, and layouts with code editor interface."
            }
        ]
    }
];
const userMenu = [
    {
        key: "user-trading",
        title: "Trading",
        href: "/trade",
        icon: "solar:chart-2-bold-duotone",
        description: "Access comprehensive trading platforms with advanced charting tools, real-time market data, and professional-grade execution capabilities for all asset classes.",
        child: [
            {
                key: "user-trading-spot",
                title: "Spot Trading",
                href: "/trade",
                icon: "solar:chart-2-bold-duotone",
                description: "Execute immediate buy and sell orders at current market prices with advanced order types, depth charts, and professional trading tools."
            },
            {
                key: "user-trading-binary",
                title: "Binary Options",
                href: "/binary",
                icon: "mdi:chart-line",
                env: ("TURBOPACK compile-time value", "true"),
                description: "Trade binary options with sophisticated analytics, risk management tools, and streamlined execution for time-sensitive strategies."
            },
            {
                key: "user-trading-forex",
                title: "Forex",
                href: "/forex",
                icon: "mdi:chart-line-variant",
                extension: "forex",
                description: "Access global foreign exchange markets with MetaTrader 4/5 integration, advanced charting, and institutional-grade execution."
            },
            {
                key: "user-trading-p2p",
                title: "P2P Exchange",
                href: "/p2p",
                icon: "material-symbols-light:p2p-outline",
                extension: "p2p",
                description: "Engage in secure peer-to-peer cryptocurrency trading with escrow protection, flexible payment methods, and competitive rates."
            }
        ]
    },
    {
        key: "user-portfolio",
        title: "Portfolio",
        icon: "solar:wallet-money-bold-duotone",
        auth: true,
        description: "Comprehensive portfolio management suite for tracking assets, analyzing performance, and managing your financial instruments across all platforms.",
        child: [
            {
                key: "user-portfolio-wallet",
                title: "Wallet Management",
                href: "/finance/wallet",
                icon: "mdi:wallet",
                auth: true,
                description: "Secure multi-currency wallet with real-time balance tracking, transaction history, and seamless deposit/withdrawal capabilities."
            },
            {
                key: "user-portfolio-transactions",
                title: "Transaction History",
                href: "/finance/history",
                icon: "solar:clipboard-list-bold-duotone",
                auth: true,
                description: "Detailed transaction records with advanced filtering, export capabilities, and comprehensive audit trails for all financial activities."
            },
            {
                key: "user-portfolio-transfers",
                title: "Transfers",
                href: "/finance/transfer",
                icon: "solar:transfer-vertical-line-duotone",
                auth: true,
                description: "Internal and external transfer services with instant processing, competitive fees, and multi-currency support."
            }
        ]
    },
    {
        key: "user-investments",
        title: "Investments",
        icon: "solar:course-up-line-duotone",
        auth: true,
        description: "Diversified investment opportunities with professional-grade analytics, risk assessment tools, and performance tracking across multiple asset classes.",
        child: [
            {
                key: "user-investments-plans",
                title: "Investment Plans",
                href: "/investment",
                icon: "solar:course-up-line-duotone",
                auth: true,
                settings: [
                    "investment"
                ],
                description: "Curated investment strategies with detailed risk profiles, historical performance data, and flexible terms to match your financial goals."
            },
            {
                key: "user-investments-staking",
                title: "Staking Rewards",
                href: "/staking",
                icon: "mdi:bank-outline",
                extension: "staking",
                description: "Earn passive income through cryptocurrency staking with competitive APY rates, flexible lock periods, and automated reward distribution."
            },
            {
                key: "user-investments-ico",
                title: "Token Sales",
                href: "/ico",
                icon: "solar:dollar-minimalistic-line-duotone",
                extension: "ico",
                description: "Early access to vetted Initial Coin Offerings with comprehensive due diligence reports, tokenomics analysis, and investment tracking."
            }
        ]
    },
    {
        key: "user-marketplace",
        title: "Marketplace",
        icon: "solar:bag-smile-bold-duotone",
        description: "Explore premium digital and physical marketplaces with secure transactions, verified sellers, and comprehensive buyer protection.",
        child: [
            {
                key: "user-marketplace-nft",
                title: "NFT Gallery",
                href: "/nft",
                icon: "ph:image-square-duotone",
                extension: "nft",
                description: "Discover, create, and trade unique digital assets in our curated NFT marketplace with auction capabilities and creator royalties."
            },
            {
                key: "user-marketplace-store",
                title: "Store",
                href: "/ecommerce",
                icon: "solar:bag-smile-bold-duotone",
                extension: "ecommerce",
                description: "Premium marketplace featuring both digital and physical products with secure payment processing, worldwide shipping, and buyer protection."
            }
        ]
    },
    {
        key: "user-services",
        title: "Services",
        icon: "solar:settings-bold-duotone",
        auth: true,
        description: "Professional services and tools to enhance your trading experience, including affiliate programs, educational resources, and premium support.",
        child: [
            {
                key: "user-services-affiliate",
                title: "Affiliate Program",
                href: "/affiliate/dashboard",
                icon: "mdi:handshake-outline",
                extension: "mlm",
                auth: true,
                description: "Monetize your network through our comprehensive affiliate program with competitive commissions, real-time tracking, and marketing tools."
            },
            {
                key: "user-services-support",
                title: "Support Center",
                href: "/support",
                icon: "mdi:head-question",
                auth: true,
                description: "Professional customer support with ticket management, live chat capabilities, and dedicated account management for premium users."
            },
            {
                key: "user-services-faq",
                title: "Knowledge Base",
                href: "/faq",
                icon: "ph:question-duotone",
                extension: "knowledge_base",
                description: "Comprehensive documentation, tutorials, and frequently asked questions to help you maximize platform capabilities."
            }
        ]
    },
    {
        key: "user-insights",
        title: "Insights",
        href: "/blog",
        icon: "fluent:content-view-28-regular",
        env: ("TURBOPACK compile-time value", "true"),
        description: "Professional market analysis, trading insights, and industry news from our team of financial experts and market researchers."
    }
];
function isItemVisible(item, user, checkPermission, hasExtension, getSetting, isAdminMenu = false) {
    const hasPermission = item.auth === false ? !user : item.permission ? user !== null && checkPermission(item.permission) : true;
    const hasRequiredExtension = !item.extension || hasExtension(item.extension);
    const hasRequiredSetting = !item.settings || item.settings.every((s)=>getSetting(s) === "true");
    const hasRequiredSettingConditions = !item.settingConditions || Object.entries(item.settingConditions).every(([key, value])=>getSetting(key) === value);
    const isEnvValid = !item.env || item.env === "true";
    // For admin menu, show extensions even if not enabled (they'll be marked as disabled)
    // This allows admins to see what extensions are available but not enabled
    if (isAdminMenu && item.extension) {
        return hasPermission && hasRequiredSetting && hasRequiredSettingConditions && isEnvValid;
    }
    // For regular user menu, hide items that require extensions that are not installed/enabled
    // This ensures users don't see menu items for features they can't access
    return hasPermission && hasRequiredExtension && hasRequiredSetting && hasRequiredSettingConditions && isEnvValid;
}
function filterChildItems(items, user, checkPermission, hasExtension, getSetting, isAdminMenu = false) {
    if (!items) return undefined;
    const filtered = items.map((item)=>filterMenuItem(item, user, checkPermission, hasExtension, getSetting, isAdminMenu)).filter((item)=>!!item);
    return filtered.length > 0 ? filtered : undefined;
}
function filterMegaMenuItems(megaMenu, user, checkPermission, hasExtension, getSetting, isAdminMenu = false) {
    if (!megaMenu) return undefined;
    const filtered = megaMenu.map((item)=>filterMenuItem(item, user, checkPermission, hasExtension, getSetting, isAdminMenu)).filter((item)=>!!item);
    return filtered.length > 0 ? filtered : undefined;
}
function filterMenuItem(item, user, checkPermission, hasExtension, getSetting, isAdminMenu = false) {
    const filteredChild = filterChildItems(item.child, user, checkPermission, hasExtension, getSetting, isAdminMenu);
    const filteredMegaMenu = filterMegaMenuItems(item.megaMenu, user, checkPermission, hasExtension, getSetting, isAdminMenu);
    const updatedItem = {
        ...item,
        child: filteredChild,
        megaMenu: filteredMegaMenu,
        // Add disabled state for admin menu extensions
        disabled: isAdminMenu && item.extension && !hasExtension(item.extension) ? true : false
    };
    if (!isItemVisible(updatedItem, user, checkPermission, hasExtension, getSetting, isAdminMenu)) {
        return null;
    }
    // For user menu: Hide parent items that have children but no visible children after filtering
    // This ensures menu items like "Marketplace" are hidden when all child extensions are disabled
    if (!isAdminMenu && item.child && !filteredChild) {
        return null;
    }
    return updatedItem;
}
function getMenu({ user, settings, extensions, activeMenuType = "user" }) {
    const menu = activeMenuType === "admin" ? adminMenu : userMenu;
    const isAdminMenu = activeMenuType === "admin";
    const userPermissions = user?.role?.permissions ?? [];
    const checkPermission = (permissions)=>{
        if (user?.role?.name === "Super Admin") return true;
        if (!permissions) return true;
        const perms = Array.isArray(permissions) ? permissions : [
            permissions
        ];
        if (perms.length === 0) return true;
        // Convert permission objects to permission names for comparison
        const userPermissionNames = userPermissions.map((p)=>typeof p === 'string' ? p : p.name);
        return perms.every((perm)=>userPermissionNames.includes(perm));
    };
    const hasExtension = (name)=>{
        if (!extensions) return false;
        const hasExt = extensions.includes(name);
        return hasExt;
    };
    const getSetting = (key)=>{
        if (!settings) return null;
        return settings[key] || null;
    };
    const filteredMenu = menu.map((item)=>filterMenuItem(item, user, checkPermission, hasExtension, getSetting, isAdminMenu)).filter((item)=>!!item);
    // Debug logging for final filtered menu in admin
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
    return filteredMenu;
}
}),
"[project]/frontend/config/wallet.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getWagmiAdapter",
    ()=>getWagmiAdapter,
    "modal",
    ()=>modal,
    "networks",
    ()=>networks,
    "projectId",
    ()=>projectId,
    "useAppKit",
    ()=>useAppKit,
    "useAppKitAccount",
    ()=>useAppKitAccount,
    "useAppKitEvents",
    ()=>useAppKitEvents,
    "useAppKitNetwork",
    ()=>useAppKitNetwork,
    "useAppKitState",
    ()=>useAppKitState,
    "useAppKitTheme",
    ()=>useAppKitTheme,
    "useDisconnect",
    ()=>useDisconnect,
    "useWalletInfo",
    ()=>useWalletInfo,
    "wagmiAdapter",
    ()=>getWagmiAdapter
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$adapter$2d$wagmi_e43583c509f629213ef718ccfb421765$2f$node_modules$2f40$reown$2f$appkit$2d$adapter$2d$wagmi$2f$dist$2f$esm$2f$src$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-adapter-wagmi_e43583c509f629213ef718ccfb421765/node_modules/@reown/appkit-adapter-wagmi/dist/esm/src/client.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$40$1$2e$8$2e$12_$40$types_5a4689f7f9dfe5fec10859673d0c6892$2f$node_modules$2f40$reown$2f$appkit$2f$dist$2f$esm$2f$exports$2f$networks$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit@1.8.12_@types_5a4689f7f9dfe5fec10859673d0c6892/node_modules/@reown/appkit/dist/esm/exports/networks.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/arbitrum.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/mainnet.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/optimism.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/polygon.js [app-ssr] (ecmascript)");
;
;
const projectId = process.env.NEXT_PUBLIC_WALLET_CONNECT_PROJECT_ID || "b56e18d47c72ab683b10814fe9495694";
const networks = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mainnet"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["polygon"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["arbitrum"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["optimism"]
];
// Setup wagmi adapter lazily
let wagmiAdapter = null;
let walletModal = null;
let hooks = {};
async function initializeWallet() {
    if ("TURBOPACK compile-time truthy", 1) return null;
    //TURBOPACK unreachable
    ;
}
// Initialize wallet on client side
let walletPromise = null;
function getWalletInitialization() {
    if (!walletPromise) {
        walletPromise = initializeWallet();
    }
    return walletPromise;
}
function useAppKit() {
    if ("TURBOPACK compile-time truthy", 1) return {
        open: ()=>{}
    };
    //TURBOPACK unreachable
    ;
}
function useAppKitAccount() {
    if ("TURBOPACK compile-time truthy", 1) return {
        isConnected: false,
        address: null
    };
    //TURBOPACK unreachable
    ;
}
function useAppKitNetwork() {
    if ("TURBOPACK compile-time truthy", 1) return {
        chainId: null,
        caipNetwork: null
    };
    //TURBOPACK unreachable
    ;
}
function useAppKitState() {
    if ("TURBOPACK compile-time truthy", 1) return {};
    //TURBOPACK unreachable
    ;
}
function useAppKitTheme() {
    if ("TURBOPACK compile-time truthy", 1) return {};
    //TURBOPACK unreachable
    ;
}
function useAppKitEvents() {
    if ("TURBOPACK compile-time truthy", 1) return {};
    //TURBOPACK unreachable
    ;
}
function useWalletInfo() {
    if ("TURBOPACK compile-time truthy", 1) return {};
    //TURBOPACK unreachable
    ;
}
function useDisconnect() {
    if ("TURBOPACK compile-time truthy", 1) return {
        disconnect: async ()=>{}
    };
    //TURBOPACK unreachable
    ;
}
const modal = ()=>{
    if ("TURBOPACK compile-time truthy", 1) return null;
    //TURBOPACK unreachable
    ;
};
// Initialize wallet when imported on client side
if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
;
const getWagmiAdapter = ()=>{
    if ("TURBOPACK compile-time truthy", 1) {
        // Create a basic adapter for SSR
        return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$adapter$2d$wagmi_e43583c509f629213ef718ccfb421765$2f$node_modules$2f40$reown$2f$appkit$2d$adapter$2d$wagmi$2f$dist$2f$esm$2f$src$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["WagmiAdapter"]({
            networks,
            projectId
        });
    }
    //TURBOPACK unreachable
    ;
};
;
}),
"[project]/frontend/hooks/use-settings-sync.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useSettingsSync",
    ()=>useSettingsSync
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/config.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$config$2f$settings$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/config/settings.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
const useSettingsSync = ()=>{
    const { settings, settingsFetched, setSettings, setExtensions, setSettingsFetched, setSettingsError } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"])();
    const hasInitialized = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Only run once per app load
        if ("TURBOPACK compile-time truthy", 1) return;
        //TURBOPACK unreachable
        ;
        const fetchFreshSettings = undefined;
    }, []);
    return {
        settings,
        settingsFetched,
        isLoading: !settingsFetched
    };
};
}),
"[project]/frontend/hooks/use-media-query.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useMediaQuery",
    ()=>useMediaQuery
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
;
function useMediaQuery(query) {
    const [matches, setMatches] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const media = window.matchMedia(query);
        if (media.matches !== matches) {
            setMatches(media.matches);
        }
        const listener = ()=>setMatches(media.matches);
        window.addEventListener("resize", listener);
        return ()=>window.removeEventListener("resize", listener);
    }, [
        matches,
        query
    ]);
    return matches;
}
}),
"[project]/frontend/hooks/use-settings.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useSettings",
    ()=>useSettings
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/config.ts [app-ssr] (ecmascript)");
;
function useSettings() {
    const { settings, extensions, isLoading, settingsFetched, settingsError } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"])();
    return {
        settings,
        extensions,
        isLoading,
        settingsFetched,
        settingsError
    };
}
}),
"[project]/frontend/hooks/use-toast.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "reducer",
    ()=>reducer,
    "toast",
    ()=>toast,
    "useToast",
    ()=>useToast
]);
// Inspired by react-hot-toast library
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
const TOAST_LIMIT = 1;
const TOAST_REMOVE_DELAY = 1000000;
const actionTypes = {
    ADD_TOAST: "ADD_TOAST",
    UPDATE_TOAST: "UPDATE_TOAST",
    DISMISS_TOAST: "DISMISS_TOAST",
    REMOVE_TOAST: "REMOVE_TOAST"
};
let count = 0;
function genId() {
    count = (count + 1) % Number.MAX_SAFE_INTEGER;
    return count.toString();
}
const toastTimeouts = new Map();
const addToRemoveQueue = (toastId)=>{
    if (toastTimeouts.has(toastId)) {
        return;
    }
    const timeout = setTimeout(()=>{
        toastTimeouts.delete(toastId);
        dispatch({
            type: "REMOVE_TOAST",
            toastId: toastId
        });
    }, TOAST_REMOVE_DELAY);
    toastTimeouts.set(toastId, timeout);
};
const reducer = (state, action)=>{
    switch(action.type){
        case "ADD_TOAST":
            return {
                ...state,
                toasts: [
                    action.toast,
                    ...state.toasts
                ].slice(0, TOAST_LIMIT)
            };
        case "UPDATE_TOAST":
            return {
                ...state,
                toasts: state.toasts.map((t)=>t.id === action.toast.id ? {
                        ...t,
                        ...action.toast
                    } : t)
            };
        case "DISMISS_TOAST":
            {
                const { toastId } = action;
                // ! Side effects ! - This could be extracted into a dismissToast() action,
                // but I'll keep it here for simplicity
                if (toastId) {
                    addToRemoveQueue(toastId);
                } else {
                    state.toasts.forEach((toast)=>{
                        addToRemoveQueue(toast.id);
                    });
                }
                return {
                    ...state,
                    toasts: state.toasts.map((t)=>t.id === toastId || toastId === undefined ? {
                            ...t,
                            open: false
                        } : t)
                };
            }
        case "REMOVE_TOAST":
            if (action.toastId === undefined) {
                return {
                    ...state,
                    toasts: []
                };
            }
            return {
                ...state,
                toasts: state.toasts.filter((t)=>t.id !== action.toastId)
            };
    }
};
const listeners = [];
let memoryState = {
    toasts: []
};
function dispatch(action) {
    memoryState = reducer(memoryState, action);
    listeners.forEach((listener)=>{
        listener(memoryState);
    });
}
function toast({ ...props }) {
    const id = genId();
    const update = (props)=>dispatch({
            type: "UPDATE_TOAST",
            toast: {
                ...props,
                id
            }
        });
    const dismiss = ()=>dispatch({
            type: "DISMISS_TOAST",
            toastId: id
        });
    dispatch({
        type: "ADD_TOAST",
        toast: {
            ...props,
            id,
            open: true,
            onOpenChange: (open)=>{
                if (!open) dismiss();
            }
        }
    });
    return {
        id: id,
        dismiss,
        update
    };
}
// Add convenience methods for different variants
toast.default = (props)=>toast({
        ...props,
        variant: "default"
    });
toast.destructive = (props)=>toast({
        ...props,
        variant: "destructive"
    });
toast.success = (props)=>toast({
        ...props,
        variant: "success"
    });
toast.warning = (props)=>toast({
        ...props,
        variant: "warning"
    });
toast.info = (props)=>toast({
        ...props,
        variant: "info"
    });
function useToast() {
    const [state, setState] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"](memoryState);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"](()=>{
        listeners.push(setState);
        return ()=>{
            const index = listeners.indexOf(setState);
            if (index > -1) {
                listeners.splice(index, 1);
            }
        };
    }, [
        state
    ]);
    return {
        ...state,
        toast,
        dismiss: (toastId)=>dispatch({
                type: "DISMISS_TOAST",
                toastId
            })
    };
}
;
}),
"[project]/frontend/hooks/use-return-param.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// hooks/use-return-param.ts
__turbopack_context__.s([
    "useReturnParam",
    ()=>useReturnParam
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
function useReturnParam() {
    const [returnTo, setReturnTo] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // On mount (client-side only), get the 'return' param
        const params = new URLSearchParams(window.location.search);
        const ret = params.get("return");
        if (ret) setReturnTo(ret);
    }, []);
    return returnTo;
}
}),
"[project]/frontend/hooks/use-sidebar-menu.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useSidebarMenu",
    ()=>useSidebarMenu
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$i18n$2f$routing$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/i18n/routing.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
function useSidebarMenu({ sideMenu }) {
    const [activeSubmenu, setActiveSubmenu] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [activeMultiMenu, setActiveMultiMenu] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [activeItem, setActiveItem] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        parentIndex: null,
        childIndex: null,
        grandChildIndex: null
    });
    const pathname = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$i18n$2f$routing$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["usePathname"])();
    const locationName = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getDynamicPath"])(pathname);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!sideMenu || sideMenu.length === 0) return;
        let foundSubMenuIndex = null;
        let foundMultiMenuIndex = null;
        let foundActiveItem = {
            parentIndex: null,
            childIndex: null,
            grandChildIndex: null
        };
        sideMenu.forEach((item, i)=>{
            if (item.child && item.child.length > 0) {
                item.child.forEach((childItem, j)=>{
                    // Check if direct child is active
                    if (childItem.href && (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isLocationMatch"])(childItem.href, locationName)) {
                        foundSubMenuIndex = i;
                        foundActiveItem = {
                            parentIndex: i,
                            childIndex: j,
                            grandChildIndex: null
                        };
                    }
                    // Check grandchild level
                    if (childItem.child && childItem.child.length > 0) {
                        childItem.child.forEach((grandChildItem, k)=>{
                            if (grandChildItem.href && (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isLocationMatch"])(grandChildItem.href, locationName)) {
                                foundSubMenuIndex = i;
                                foundMultiMenuIndex = j;
                                foundActiveItem = {
                                    parentIndex: i,
                                    childIndex: j,
                                    grandChildIndex: k
                                };
                            }
                        });
                    }
                });
            } else {
                // Match top-level without children
                if (item.href && (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isLocationMatch"])(item.href, locationName)) {
                    foundSubMenuIndex = null;
                    foundMultiMenuIndex = null;
                    foundActiveItem = {
                        parentIndex: i,
                        childIndex: null,
                        grandChildIndex: null
                    };
                }
            }
        });
        setActiveSubmenu(foundSubMenuIndex);
        setActiveMultiMenu(foundMultiMenuIndex);
        setActiveItem(foundActiveItem);
    }, [
        locationName,
        sideMenu
    ]);
    const toggleSubmenu = (i)=>{
        setActiveSubmenu((prev)=>prev === i ? null : i);
    };
    const toggleMultiMenu = (subIndex)=>{
        setActiveMultiMenu((prev)=>prev === subIndex ? null : subIndex);
    };
    const isItemActive = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((parentIndex, childIndex, grandChildIndex)=>{
        return parentIndex === activeItem.parentIndex && (childIndex === undefined || childIndex === activeItem.childIndex) && (grandChildIndex === undefined || grandChildIndex === activeItem.grandChildIndex);
    }, [
        activeItem
    ]);
    return {
        activeSubmenu,
        activeMultiMenu,
        locationName,
        toggleSubmenu,
        toggleMultiMenu,
        isItemActive
    };
}
}),
"[project]/frontend/hooks/use-mounted.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useMounted",
    ()=>useMounted
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
;
function useMounted() {
    const [mounted, setMounted] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"](false);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"](()=>{
        setMounted(true);
    }, []);
    return mounted;
}
}),
];

//# sourceMappingURL=frontend_28b1f2f0._.js.map