module.exports = [
"[project]/frontend/hooks/use-mobile.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useIsMobile",
    ()=>useIsMobile
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
function useIsMobile() {
    const [isMobile, setIsMobile] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isTablet, setIsTablet] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const checkDevice = ()=>{
            setIsMobile(window.innerWidth < 768);
            setIsTablet(window.innerWidth >= 768 && window.innerWidth < 1024);
        };
        // Initial check
        checkDevice();
        // Add event listener for window resize
        window.addEventListener("resize", checkDevice);
        // Clean up
        return ()=>window.removeEventListener("resize", checkDevice);
    }, []);
    return {
        isMobile,
        isTablet,
        isDesktop: !isMobile && !isTablet
    };
}
}),
"[project]/frontend/services/wishlist-service.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "wishlistService",
    ()=>wishlistService
]);
class WishlistService {
    items = [];
    subscribers = [];
    storageKey = "trading-watchlist";
    constructor(){
        this.loadFromStorage();
    }
    loadFromStorage() {
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
    }
    saveToStorage() {
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
    }
    notifySubscribers() {
        this.subscribers.forEach((subscriber)=>subscriber([
                ...this.items
            ]));
    }
    subscribe(callback) {
        this.subscribers.push(callback);
        callback([
            ...this.items
        ]);
        return ()=>{
            this.subscribers = this.subscribers.filter((sub)=>sub !== callback);
        };
    }
    toggleWishlist(symbol, marketType = "spot") {
        // Find the item with matching symbol AND market type
        const index = this.items.findIndex((item)=>item.symbol === symbol && item.marketType === marketType);
        if (index >= 0) {
            this.items.splice(index, 1);
        } else {
            this.items.push({
                symbol,
                addedAt: Date.now(),
                marketType
            });
        }
        this.saveToStorage();
        this.notifySubscribers();
    }
    isInWishlist(symbol, marketType = "spot") {
        return this.items.some((item)=>item.symbol === symbol && item.marketType === marketType);
    }
    getWishlist() {
        return [
            ...this.items
        ];
    }
    clearWishlist() {
        this.items = [];
        this.saveToStorage();
        this.notifySubscribers();
    }
}
const wishlistService = new WishlistService();
}),
"[project]/frontend/services/ws-manager.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ConnectionStatus",
    ()=>ConnectionStatus,
    "wsManager",
    ()=>wsManager
]);
var ConnectionStatus = /*#__PURE__*/ function(ConnectionStatus) {
    ConnectionStatus["CONNECTING"] = "connecting";
    ConnectionStatus["CONNECTED"] = "connected";
    ConnectionStatus["DISCONNECTED"] = "disconnected";
    ConnectionStatus["RECONNECTING"] = "reconnecting";
    ConnectionStatus["ERROR"] = "error";
    return ConnectionStatus;
}({});
class WebSocketManager {
    static instance;
    connections = new Map();
    connectionStatus = new Map();
    subscriptions = new Map();
    statusListeners = new Map();
    reconnectTimeouts = new Map();
    reconnectAttempts = new Map();
    messageQueues = new Map();
    maxReconnectAttempts = 5;
    reconnectDelay = 1000;
    debug = ("TURBOPACK compile-time value", "development") !== "production";
    // Get singleton instance
    static getInstance() {
        if (!WebSocketManager.instance) {
            WebSocketManager.instance = new WebSocketManager();
        }
        return WebSocketManager.instance;
    }
    // Connect to a WebSocket server
    connect(url, connectionId = "default") {
        // If already connected or connecting, do nothing
        if (this.connections.has(connectionId) && (this.connectionStatus.get(connectionId) === "connected" || this.connectionStatus.get(connectionId) === "connecting")) {
            return;
        }
        // Initialize message queue for this connection if it doesn't exist
        if (!this.messageQueues.has(connectionId)) {
            this.messageQueues.set(connectionId, []);
        }
        // Update connection status
        this.connectionStatus.set(connectionId, "connecting");
        this.notifyStatusListeners(connectionId);
        // Create a new WebSocket connection
        // Note: WebSocket in browser automatically includes cookies for same-origin requests
        try {
            // Get access token from cookies if available
            const getCookie = (name)=>{
                const value = `; ${document.cookie}`;
                const parts = value.split(`; ${name}=`);
                if (parts.length === 2) return parts.pop()?.split(';').shift();
                return null;
            };
            const accessToken = getCookie('accessToken');
            // Add token to URL if available (for authentication)
            let authUrl = url;
            if (accessToken) {
                const separator = url.includes('?') ? '&' : '?';
                authUrl = `${url}${separator}token=${accessToken}`;
            }
            const ws = new WebSocket(authUrl);
            // Set up event handlers
            ws.onopen = ()=>this.handleOpen(connectionId);
            ws.onmessage = (event)=>this.handleMessage(event, connectionId);
            ws.onclose = ()=>this.handleClose(connectionId, url);
            ws.onerror = (error)=>this.handleError(error, connectionId);
            // Store the connection
            this.connections.set(connectionId, ws);
        } catch (error) {
            console.error(`Error creating WebSocket connection for ${connectionId}:`, error);
            this.handleError(new Event("error"), connectionId);
        }
    }
    // Handle WebSocket open event
    handleOpen(connectionId) {
        this.connectionStatus.set(connectionId, "connected");
        this.reconnectAttempts.set(connectionId, 0); // Reset reconnect attempts
        this.notifyStatusListeners(connectionId);
        // Process any queued messages
        this.processMessageQueue(connectionId);
    }
    // Process queued messages
    processMessageQueue(connectionId) {
        if (!this.messageQueues.has(connectionId)) return;
        const queue = this.messageQueues.get(connectionId);
        if (queue.length === 0) return;
        // Send all queued messages
        while(queue.length > 0){
            const message = queue.shift();
            this.sendMessageImmediate(message, connectionId);
        }
    }
    // Handle WebSocket message event
    handleMessage(event, connectionId) {
        try {
            const data = JSON.parse(event.data);
            // Handle different message formats
            let streamKey = data.stream || "default";
            // Special handling for support ticket messages
            if (data.method === "reply" && data.payload?.id) {
                streamKey = `ticket-${data.payload.id}`;
            } else if (data.method === "update" && data.payload?.id) {
                streamKey = `ticket-${data.payload.id}`;
            }
            // Notify subscribers
            if (this.subscriptions.has(connectionId)) {
                const connectionSubscriptions = this.subscriptions.get(connectionId);
                if (connectionSubscriptions.has(streamKey)) {
                    const callbacks = connectionSubscriptions.get(streamKey);
                    callbacks.forEach((callback)=>{
                        try {
                            callback(data.data || data);
                        } catch (error) {
                            console.error(`Error in callback for ${streamKey}:`, error);
                        }
                    });
                }
            }
        } catch (error) {
            console.error(`Error parsing WebSocket message for ${connectionId}:`, error);
        }
    }
    // Handle WebSocket close event
    handleClose(connectionId, url) {
        this.connections.delete(connectionId);
        this.connectionStatus.set(connectionId, "disconnected");
        this.notifyStatusListeners(connectionId);
        // Attempt to reconnect
        this.reconnect(connectionId, url);
    }
    // Handle WebSocket error event
    handleError(error, connectionId) {
        console.error(`WebSocket error for ${connectionId}:`, error);
    }
    // Attempt to reconnect to the WebSocket server
    reconnect(connectionId, url) {
        // Clear any existing reconnect timeout
        if (this.reconnectTimeouts.has(connectionId)) {
            clearTimeout(this.reconnectTimeouts.get(connectionId));
        }
        // Get current reconnect attempts
        const attempts = this.reconnectAttempts.get(connectionId) || 0;
        // Check if we've exceeded the maximum number of reconnect attempts
        if (attempts >= this.maxReconnectAttempts) {
            console.error(`Maximum reconnect attempts (${this.maxReconnectAttempts}) reached for ${connectionId}`);
            return;
        }
        // Update connection status
        this.connectionStatus.set(connectionId, "reconnecting");
        this.notifyStatusListeners(connectionId);
        // Calculate exponential backoff delay
        const delay = Math.min(this.reconnectDelay * Math.pow(2, attempts), 30000); // Max 30 seconds
        // Set a timeout to reconnect
        const timeout = setTimeout(()=>{
            this.reconnectAttempts.set(connectionId, attempts + 1);
            this.connect(url, connectionId);
        }, delay);
        // Store the timeout
        this.reconnectTimeouts.set(connectionId, timeout);
    }
    // Subscribe to a WebSocket stream
    subscribe(streamKey, callback, connectionId = "default") {
        // Initialize subscriptions map for this connection if it doesn't exist
        if (!this.subscriptions.has(connectionId)) {
            this.subscriptions.set(connectionId, new Map());
        }
        // Initialize callbacks set for this stream if it doesn't exist
        const connectionSubscriptions = this.subscriptions.get(connectionId);
        if (!connectionSubscriptions.has(streamKey)) {
            connectionSubscriptions.set(streamKey, new Set());
        }
        // Add the callback to the set
        connectionSubscriptions.get(streamKey).add(callback);
    }
    // Unsubscribe from a WebSocket stream
    unsubscribe(streamKey, callback, connectionId = "default") {
        if (this.subscriptions.has(connectionId)) {
            const connectionSubscriptions = this.subscriptions.get(connectionId);
            if (connectionSubscriptions.has(streamKey)) {
                const callbacks = connectionSubscriptions.get(streamKey);
                callbacks.delete(callback);
                // If no more callbacks, remove the stream
                if (callbacks.size === 0) {
                    connectionSubscriptions.delete(streamKey);
                }
            }
        }
    }
    // Send a message to the WebSocket server (queues if not connected)
    sendMessage(message, connectionId = "default") {
        // Check if the connection is ready
        if (this.connections.has(connectionId) && this.connectionStatus.get(connectionId) === "connected") {
            // Connection is ready, send immediately
            this.sendMessageImmediate(message, connectionId);
        } else {
            // Connection is not ready, queue the message
            if (!this.messageQueues.has(connectionId)) {
                this.messageQueues.set(connectionId, []);
            }
            this.messageQueues.get(connectionId).push(message);
        }
    }
    // Send a message immediately without queueing
    sendMessageImmediate(message, connectionId) {
        const connection = this.connections.get(connectionId);
        if (connection && connection.readyState === WebSocket.OPEN) {
            const messageStr = JSON.stringify(message);
            connection.send(messageStr);
        } else {
            console.error(`Cannot send message: WebSocket for ${connectionId} is not open`);
        }
    }
    // Add a status listener
    addStatusListener(callback, connectionId = "default") {
        // Initialize status listeners set for this connection if it doesn't exist
        if (!this.statusListeners.has(connectionId)) {
            this.statusListeners.set(connectionId, new Set());
        }
        // Add the callback to the set
        this.statusListeners.get(connectionId).add(callback);
        // Notify the listener of the current status
        const status = this.connectionStatus.get(connectionId) || "disconnected";
        callback(status);
    }
    // Remove a status listener
    removeStatusListener(callback, connectionId = "default") {
        if (this.statusListeners.has(connectionId)) {
            this.statusListeners.get(connectionId).delete(callback);
        }
    }
    // Notify all status listeners of a status change
    notifyStatusListeners(connectionId) {
        const status = this.connectionStatus.get(connectionId) || "disconnected";
        if (this.statusListeners.has(connectionId)) {
            this.statusListeners.get(connectionId).forEach((callback)=>{
                try {
                    callback(status);
                } catch (error) {
                    console.error(`Error in status listener for ${connectionId}:`, error);
                }
            });
        }
    }
    // Get the current connection status
    getStatus(connectionId = "default") {
        return this.connectionStatus.get(connectionId) || "disconnected";
    }
    // Close a WebSocket connection
    close(connectionId = "default") {
        // Clear any reconnect timeouts for this connection
        const timeout = this.reconnectTimeouts.get(connectionId);
        if (timeout) {
            clearTimeout(timeout);
            this.reconnectTimeouts.delete(connectionId);
        }
        const connection = this.connections.get(connectionId);
        if (connection) {
            connection.close();
            this.connections.delete(connectionId);
            this.connectionStatus.set(connectionId, "disconnected");
            this.notifyStatusListeners(connectionId);
            // Clear associated data
            this.subscriptions.delete(connectionId);
            this.messageQueues.delete(connectionId);
            this.reconnectAttempts.delete(connectionId);
        }
    }
    // Close all WebSocket connections
    closeAll() {
        this.connections.forEach((connection, connectionId)=>{
            this.close(connectionId);
        });
    }
}
const wsManager = WebSocketManager.getInstance();
}),
"[project]/frontend/services/market-data-ws.ts [app-ssr] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "MarketDataWebSocketService",
    ()=>MarketDataWebSocketService,
    "marketDataWs",
    ()=>marketDataWs
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/services/ws-manager.ts [app-ssr] (ecmascript)");
;
;
// Helper function to get current candle timestamp
function getCurrentCandleTimestamp(interval) {
    const now = Date.now();
    let intervalMs = 0;
    switch(interval){
        case "1m":
            intervalMs = 60 * 1000;
            break;
        case "5m":
            intervalMs = 5 * 60 * 1000;
            break;
        case "15m":
            intervalMs = 15 * 60 * 1000;
            break;
        case "30m":
            intervalMs = 30 * 60 * 1000;
            break;
        case "1h":
            intervalMs = 60 * 60 * 1000;
            break;
        case "4h":
            intervalMs = 4 * 60 * 60 * 1000;
            break;
        case "1d":
            intervalMs = 24 * 60 * 60 * 1000;
            break;
        default:
            intervalMs = 60 * 60 * 1000; // Default to 1 hour
    }
    return Math.floor(now / intervalMs) * intervalMs;
}
class MarketDataWebSocketService {
    static instance;
    isInitialized = false;
    activeSubscriptions = new Map();
    callbacks = new Map();
    connectedMarketTypes = new Set();
    subscriptionSent = new Map();
    pendingSubscriptions = new Map();
    connectionStatusMap = new Map();
    debug = ("TURBOPACK compile-time value", "development") !== "production" && true;
    // Track active stream subscriptions to prevent duplicates
    activeStreamSubscriptions = new Map();
    // WebSocket connections for different market types
    wsConnections = new Map();
    constructor(){
        // Initialize WebSocket URLs for different market types
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
        else {
            this.wsConnections.set("spot", "ws://localhost:3000/api/exchange/market");
            this.wsConnections.set("eco", "ws://localhost:3000/api/ecosystem/market");
            this.wsConnections.set("futures", "ws://localhost:3000/api/futures/market");
        }
        // Initialize connection status for all market types
        this.wsConnections.forEach((_, marketType)=>{
            this.connectionStatusMap.set(marketType, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED);
            this.pendingSubscriptions.set(marketType, new Set());
            this.activeStreamSubscriptions.set(marketType, new Set());
        });
    }
    // Get singleton instance
    static getInstance() {
        if (!MarketDataWebSocketService.instance) {
            MarketDataWebSocketService.instance = new MarketDataWebSocketService();
        }
        return MarketDataWebSocketService.instance;
    }
    // Get appropriate limit based on provider and tick size
    getProviderLimit(tickSize) {
        const provider = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : "bin"; // Default to binance if not specified
        // Define limits based on provider and tick size
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
        else if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
        else {
            // Binance and others
            if (tickSize <= 0.01) return 40;
            if (tickSize <= 0.1) return 80;
            if (tickSize <= 1) return 160;
            return 320;
        }
    }
    // Initialize the WebSocket service
    initialize() {
        if (this.isInitialized) return;
        this.isInitialized = true;
        if (this.debug) {
            console.log("Market data WebSocket service initialized");
        }
    }
    // Format symbol for WebSocket (ensure it has a / between currency and pair)
    formatSymbol(symbol) {
        // If the symbol already contains a /, return it as is
        if (symbol.includes("/")) {
            return symbol;
        }
        // Convert other delimiters to slash format
        if (symbol.includes("-")) {
            return symbol.replace("-", "/");
        }
        if (symbol.includes("_")) {
            return symbol.replace("_", "/");
        }
        // For symbols without delimiters (like BTCUSDT), try to split intelligently
        const midPoint = Math.floor(symbol.length / 2);
        // Try different split points around the middle to find a reasonable split
        for(let i = Math.max(2, midPoint - 2); i <= Math.min(symbol.length - 2, midPoint + 2); i++){
            const base = symbol.substring(0, i);
            const quote = symbol.substring(i);
            // Prefer splits where quote is 3-4 characters (common for crypto quotes)
            if (quote.length >= 3 && quote.length <= 4) {
                return `${base}/${quote}`;
            }
        }
        // Fallback: split at midpoint
        const currency = symbol.substring(0, midPoint);
        const pair = symbol.substring(midPoint);
        return `${currency}/${pair}`;
    }
    // Ensure connection for a specific market type
    ensureConnection(marketType) {
        // If already connected to this market type, do nothing
        if (this.connectedMarketTypes.has(marketType)) return;
        // Get the WebSocket URL for this market type
        const url = this.wsConnections.get(marketType);
        if (!url) {
            console.error(`No WebSocket URL defined for market type: ${marketType}`);
            return;
        }
        // Connect to the WebSocket server
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].connect(url, marketType);
        this.connectedMarketTypes.add(marketType);
        if (this.debug) {
            console.log(`Connected to ${marketType} market WebSocket at ${url}`);
        }
        // Add a status listener to monitor connection state
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].addStatusListener((status)=>{
            if (this.debug) {
                console.log(`WebSocket status for ${marketType}: ${status}`);
            }
            // Update connection status
            this.connectionStatusMap.set(marketType, status);
            // If connection is established, process pending subscriptions
            if (status === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
                this.processPendingSubscriptions(marketType);
            }
        }, marketType);
    }
    // Process pending subscriptions for a market type
    processPendingSubscriptions(marketType) {
        if (!this.pendingSubscriptions.has(marketType)) return;
        const pendingKeys = this.pendingSubscriptions.get(marketType);
        if (pendingKeys.size === 0) return;
        // Create a set of unique subscriptions to send
        const uniqueSubscriptions = new Map();
        // Process each pending subscription
        for (const key of pendingKeys){
            const subscription = this.activeSubscriptions.get(key);
            if (subscription) {
                // Use type and symbol as deduplication key
                const dedupeKey = `${subscription.type}:${subscription.symbol}`;
                uniqueSubscriptions.set(dedupeKey, subscription);
            }
        }
        // Send subscription messages for each unique subscription
        for (const subscription of uniqueSubscriptions.values()){
            this.sendSubscriptionMessage(subscription);
        }
        // Clear pending subscriptions
        this.pendingSubscriptions.get(marketType).clear();
    }
    // Get the subscription key
    getSubscriptionKey(type, symbol, marketType, interval) {
        return interval ? `${marketType}:${type}:${symbol}:${interval}` : `${marketType}:${type}:${symbol}`;
    }
    // Get the stream key
    getStreamKey(type, limit, interval) {
        if (type === "ohlcv" && interval) {
            return `${type}:${interval}`;
        }
        return limit ? `${type}:${limit}` : type;
    }
    // Check if a stream is already subscribed
    isStreamSubscribed(streamKey, marketType) {
        return this.activeStreamSubscriptions.get(marketType)?.has(streamKey) || false;
    }
    // Normalize OHLCV data to a consistent format
    normalizeOHLCVData(data, interval) {
        // If data is already an array of candles, wrap it in the expected format
        if (Array.isArray(data) && data.length > 0 && Array.isArray(data[0]) && data[0].length >= 6) {
            return {
                stream: `ohlcv:${interval}`,
                data: data
            };
        }
        // If data has stream and data properties, return it as is (backend enhanced format)
        if (data && data.stream && data.stream.startsWith("ohlcv:") && Array.isArray(data.data)) {
            return data;
        }
        // Try to parse if it's a string
        if (typeof data === "string") {
            try {
                const parsedData = JSON.parse(data);
                if (parsedData && parsedData.stream && parsedData.stream.startsWith("ohlcv:") && Array.isArray(parsedData.data)) {
                    return parsedData;
                }
                // Handle case where the data might be a single candle update
                if (parsedData && Array.isArray(parsedData) && parsedData.length >= 6) {
                    return {
                        stream: `ohlcv:${interval}`,
                        data: [
                            parsedData
                        ]
                    };
                }
            } catch (e) {
                console.error("[Market Data WS] Failed to parse string data:", e);
            }
        }
        // Try to return it in the expected format anyway
        if (data && data.stream && data.data) {
            return data;
        }
        return null;
    }
    // Enhance the WebSocket service to better handle current candle updates
    // Add this function to the MarketDataWebSocketService class
    ensureCurrentCandleInMessage(message, interval) {
        // Skip if not an OHLCV message or no data
        if (!message?.stream?.startsWith("ohlcv") || !Array.isArray(message.data) || message.data.length === 0) {
            return message;
        }
        // Get the current candle timestamp
        const currentCandleTimestamp = getCurrentCandleTimestamp(interval);
        // Check if the current candle is in the message
        let hasCurrentCandle = false;
        for (const candleData of message.data){
            if (Array.isArray(candleData) && candleData.length >= 6) {
                const timestamp = Number(candleData[0]);
                // Use a 5-second tolerance to account for potential timing differences
                if (Math.abs(timestamp - currentCandleTimestamp) < 5000) {
                    hasCurrentCandle = true;
                    break;
                }
            }
        }
        // If the current candle is not in the message, add it
        if (!hasCurrentCandle && message.data.length > 0) {
            // Get the last candle in the message
            const lastCandle = message.data[message.data.length - 1];
            if (Array.isArray(lastCandle) && lastCandle.length >= 6) {
                // Create a new candle with the current timestamp
                const newCandle = [
                    currentCandleTimestamp,
                    lastCandle[4],
                    lastCandle[4],
                    lastCandle[4],
                    lastCandle[4],
                    0
                ];
                // Add the new candle to the message
                const newData = [
                    ...message.data,
                    newCandle
                ];
                // Sort by timestamp
                newData.sort((a, b)=>a[0] - b[0]);
                // Create a new message with the updated data
                const newMessage = {
                    ...message,
                    data: newData
                };
                return newMessage;
            }
        }
        return message;
    }
    // Modify the processOHLCVMessage method to use the new function
    processCurrentCandleUpdate(message, interval) {
        // First ensure the current candle is in the message
        const enhancedMessage = this.ensureCurrentCandleInMessage(message, interval);
        // Skip if not an OHLCV message or no data
        if (!enhancedMessage?.stream?.startsWith("ohlcv") || !Array.isArray(enhancedMessage.data) || enhancedMessage.data.length === 0) {
            return false;
        }
        // Get the current candle timestamp
        const currentCandleTimestamp = getCurrentCandleTimestamp(interval);
        // Check if any of the candles in the message is the current candle
        for (const candleData of enhancedMessage.data){
            if (Array.isArray(candleData) && candleData.length >= 6) {
                const timestamp = Number(candleData[0]);
                // Check if this is the current candle (with some tolerance for timestamp differences)
                // Use a 5-second tolerance to account for potential timing differences
                const isCurrentCandle = Math.abs(timestamp - currentCandleTimestamp) < 5000;
                if (isCurrentCandle) {
                    return true;
                }
            }
        }
        return false;
    }
    // Subscribe to market data
    subscribe(subscription, callback) {
        if (!this.isInitialized) {
            this.initialize();
        }
        // Format the symbol to ensure it has a / between currency and pair
        const formattedSymbol = this.formatSymbol(subscription.symbol);
        const { type, marketType, interval } = subscription;
        // Determine appropriate limit based on provider if it's an orderbook subscription
        let limit = subscription.limit;
        if (type === "orderbook" && !limit) {
            // Default tick size if not specified
            const tickSize = 0.01;
            limit = this.getProviderLimit(tickSize);
        }
        // Create a new subscription object with the formatted symbol and adjusted limit
        const formattedSubscription = {
            ...subscription,
            symbol: formattedSymbol,
            limit
        };
        const subscriptionKey = this.getSubscriptionKey(type, formattedSymbol, marketType, interval);
        const streamKey = this.getStreamKey(type, limit, interval);
        if (this.debug) {
            console.log(`Subscribing to ${type} for ${formattedSymbol} on ${marketType} market with limit ${limit || "N/A"}${interval ? ` and interval ${interval}` : ""}`);
        }
        // Ensure we have a connection for this market type
        this.ensureConnection(marketType);
        // Register the callback
        if (!this.callbacks.has(subscriptionKey)) {
            this.callbacks.set(subscriptionKey, new Set());
        }
        this.callbacks.get(subscriptionKey).add(callback);
        // Store the subscription
        this.activeSubscriptions.set(subscriptionKey, formattedSubscription);
        // Check if we're connected
        const isConnected = this.connectionStatusMap.get(marketType) === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
        // If connected, send subscription immediately (if not already sent)
        // Otherwise, queue it for when connection is established
        if (isConnected) {
            if (!this.subscriptionSent.has(subscriptionKey) && !this.isStreamSubscribed(streamKey, marketType)) {
                this.sendSubscriptionMessage(formattedSubscription);
                this.subscriptionSent.set(subscriptionKey, true);
                // Mark this stream as subscribed
                this.activeStreamSubscriptions.get(marketType).add(streamKey);
            }
        } else {
            // Add to pending subscriptions
            if (!this.pendingSubscriptions.has(marketType)) {
                this.pendingSubscriptions.set(marketType, new Set());
            }
            this.pendingSubscriptions.get(marketType).add(subscriptionKey);
            if (this.debug) {
                console.log(`Queued subscription for ${formattedSymbol} on ${marketType} market`);
            }
        }
        // Subscribe to the WebSocket stream for the specific market type
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].subscribe(streamKey, (data)=>{
            try {
                // Handle different OHLCV data formats
                if (type === "ohlcv") {
                    // Normalize the data format
                    const normalizedData = this.normalizeOHLCVData(data, interval || "1h");
                    if (!normalizedData) {
                        console.error("[Market Data WS] Failed to normalize data:", data);
                        return;
                    }
                    // Check if the interval matches - handle both formats: ohlcv:interval and ohlcv:interval:symbol
                    if (interval && normalizedData.stream) {
                        const streamParts = normalizedData.stream.split(":");
                        const dataInterval = streamParts[1]; // Should be the interval part
                        if (dataInterval !== interval) {
                            return;
                        }
                    }
                    // Get callbacks for this subscription and call them
                    const callbacks = this.callbacks.get(subscriptionKey);
                    if (callbacks && callbacks.size > 0) {
                        callbacks.forEach((cb)=>{
                            try {
                                cb(normalizedData);
                            } catch (error) {
                                console.error(`[Market Data WS] Error in callback for ${subscriptionKey}:`, error);
                            }
                        });
                    }
                    return;
                }
                // Handle data structure - check if data is wrapped in a data property
                let actualData = data;
                let dataSymbol = data.symbol; // Keep track of symbol from wrapper
                if (data.data && typeof data.data === 'object') {
                    actualData = data.data;
                }
                // For orderbook and ticker data, we don't need to validate symbol since it's already filtered by subscription
                // For trades data, check if the data is for this symbol
                if (type === "trades") {
                    // Check symbol from wrapper first, then from data
                    const checkSymbol = dataSymbol || actualData.symbol || Array.isArray(actualData) && actualData.length > 0 && actualData[0].symbol;
                    if (checkSymbol && checkSymbol !== formattedSymbol) {
                        if (this.debug) {
                            console.log(`[Market Data WS] Skipping trades data - symbol mismatch. Expected: ${formattedSymbol}, Got: ${checkSymbol}`);
                        }
                        return; // Skip if the symbol doesn't match
                    }
                }
                // Ensure orderbook and ticker data have symbol property
                if ((type === "orderbook" || type === "ticker") && !actualData.symbol) {
                    actualData.symbol = formattedSymbol;
                    actualData.timestamp = actualData.timestamp || Date.now();
                }
                const callbacks = this.callbacks.get(subscriptionKey);
                if (callbacks) {
                    callbacks.forEach((cb)=>{
                        try {
                            cb(actualData);
                        } catch (error) {
                            console.error(`Error in callback for ${subscriptionKey}:`, error);
                        }
                    });
                }
            } catch (error) {
                console.error(`Error processing WebSocket data for ${subscriptionKey}:`, error);
            }
        }, marketType);
        // Return unsubscribe function
        return ()=>{
            this.unsubscribe(formattedSubscription, callback);
        };
    }
    // Unsubscribe from market data
    unsubscribe(subscription, callback) {
        const { type, symbol, marketType, interval } = subscription;
        const formattedSymbol = this.formatSymbol(symbol);
        const subscriptionKey = this.getSubscriptionKey(type, formattedSymbol, marketType, interval);
        const streamKey = this.getStreamKey(type, subscription.limit, interval);
        // Remove the callback
        const callbacks = this.callbacks.get(subscriptionKey);
        if (callbacks) {
            callbacks.delete(callback);
            // If no more callbacks, unsubscribe from the WebSocket
            if (callbacks.size === 0) {
                // Check if any other subscriptions are using this stream BEFORE removing the current one
                let shouldUnsubscribe = true;
                for (const [key, sub] of this.activeSubscriptions.entries()){
                    if (key !== subscriptionKey && // Don't count the current subscription we're removing
                    sub.marketType === marketType && sub.type === type && this.getStreamKey(sub.type, sub.limit, sub.interval) === streamKey) {
                        shouldUnsubscribe = false;
                        break;
                    }
                }
                // Clean up the subscription data
                this.callbacks.delete(subscriptionKey);
                this.activeSubscriptions.delete(subscriptionKey);
                // Only send unsubscribe if we previously sent a subscribe and no other subscriptions are using this stream
                if (this.subscriptionSent.has(subscriptionKey) && shouldUnsubscribe) {
                    this.sendUnsubscriptionMessage(subscription);
                    this.subscriptionSent.delete(subscriptionKey);
                    // Remove this stream from active subscriptions
                    this.activeStreamSubscriptions.get(marketType)?.delete(streamKey);
                }
                // Remove from pending subscriptions if it's there
                if (this.pendingSubscriptions.has(marketType)) {
                    this.pendingSubscriptions.get(marketType).delete(subscriptionKey);
                }
            }
        }
    }
    // Send a subscription message
    sendSubscriptionMessage(subscription) {
        const { symbol, type, marketType, limit, interval } = subscription;
        const formattedSymbol = this.formatSymbol(symbol);
        const streamKey = this.getStreamKey(type, limit, interval);
        const subscriptionKey = this.getSubscriptionKey(type, formattedSymbol, marketType, interval);
        // Check if this stream is already subscribed
        if (this.isStreamSubscribed(streamKey, marketType)) {
            if (this.debug) {
                console.log(`Stream ${streamKey} for ${marketType} is already subscribed, skipping subscription message`);
            }
            return;
        }
        // Create the subscription message
        const message = {
            action: "SUBSCRIBE",
            payload: {
                type,
                ...limit ? {
                    limit
                } : {},
                ...interval ? {
                    interval
                } : {},
                symbol: formattedSymbol
            }
        };
        // Send subscription message to the appropriate WebSocket connection
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].sendMessage(message, marketType);
        // Mark this stream as subscribed
        this.activeStreamSubscriptions.get(marketType).add(streamKey);
        // Mark this subscription as sent so it can be properly unsubscribed later
        this.subscriptionSent.set(subscriptionKey, true);
        if (this.debug) {
            console.log(`Sent subscription message for ${type} for ${formattedSymbol} on ${marketType} market:`, message);
        }
    }
    // Send an unsubscription message
    sendUnsubscriptionMessage(subscription) {
        const { symbol, type, marketType, limit, interval } = subscription;
        const formattedSymbol = this.formatSymbol(symbol);
        const streamKey = this.getStreamKey(type, limit, interval);
        // Create the unsubscription message
        const message = {
            action: "UNSUBSCRIBE",
            payload: {
                type,
                ...limit ? {
                    limit
                } : {},
                ...interval ? {
                    interval
                } : {},
                symbol: formattedSymbol
            }
        };
        // Send unsubscription message to the appropriate WebSocket connection
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].sendMessage(message, marketType);
        // Remove this stream from active subscriptions
        this.activeStreamSubscriptions.get(marketType)?.delete(streamKey);
    }
    // Get the API endpoint for a market type
    getMarketEndpoint(marketType) {
        switch(marketType){
            case "spot":
                return "/api/exchange/market";
            case "eco":
                return "/api/ecosystem/market";
            case "futures":
                return "/api/futures/market";
            default:
                return "/api/exchange/market";
        }
    }
    // Subscribe to connection status updates for a specific market type
    subscribeToConnectionStatus(callback, marketType) {
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].addStatusListener(callback, marketType);
        return ()=>__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].removeStatusListener(callback, marketType);
    }
    // Get the current connection status for a specific market type
    getConnectionStatus(marketType) {
        return this.connectionStatusMap.get(marketType) || __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    }
    // Check if we have any active subscriptions for a market type
    hasActiveSubscriptionsForMarketType(marketType) {
        for (const subscription of this.activeSubscriptions.values()){
            if (subscription.marketType === marketType) {
                return true;
            }
        }
        return false;
    }
    // Close connection for a market type if no active subscriptions
    closeUnusedConnections() {
        for (const marketType of this.connectedMarketTypes){
            if (!this.hasActiveSubscriptionsForMarketType(marketType)) {
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].close(marketType);
                this.connectedMarketTypes.delete(marketType);
                this.connectionStatusMap.set(marketType, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED);
                if (this.debug) {
                    console.log(`Closed unused connection for ${marketType} market`);
                }
            }
        }
    }
    // Clean up all subscriptions
    cleanup() {
        // Unsubscribe from all streams
        this.activeSubscriptions.forEach((subscription)=>{
            if (this.subscriptionSent.has(this.getSubscriptionKey(subscription.type, subscription.symbol, subscription.marketType, subscription.interval))) {
                this.sendUnsubscriptionMessage(subscription);
            }
        });
        // Close all connections
        this.connectedMarketTypes.forEach((marketType)=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["wsManager"].close(marketType);
            this.connectionStatusMap.set(marketType, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED);
        });
        // Clear all maps and sets
        this.activeSubscriptions.clear();
        this.callbacks.clear();
        this.connectedMarketTypes.clear();
        this.subscriptionSent.clear();
        this.activeStreamSubscriptions.forEach((set)=>set.clear());
        // Clear pending subscriptions
        this.pendingSubscriptions.forEach((set)=>set.clear());
        // Reset initialization flag
        this.isInitialized = false;
        if (this.debug) {
            console.log("Market data WebSocket service cleaned up");
        }
    }
}
const marketDataWs = MarketDataWebSocketService.getInstance();
}),
"[project]/frontend/services/market-service.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "marketService",
    ()=>marketService
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/extensions.ts [app-ssr] (ecmascript)");
;
// Market data service to centralize market data fetching and sharing
class MarketService {
    static instance;
    // Market data cache
    spotMarkets = [];
    futuresMarkets = [];
    ecoMarkets = [];
    // Loading states
    isLoadingSpot = false;
    isLoadingFutures = false;
    isLoadingEco = false;
    // Data fetched flags
    spotDataFetched = false;
    futuresDataFetched = false;
    ecoDataFetched = false;
    // Subscribers for data updates
    spotSubscribers = new Set();
    futuresSubscribers = new Set();
    ecoSubscribers = new Set();
    // Promises to prevent duplicate fetches
    spotPromise = null;
    futuresPromise = null;
    ecoPromise = null;
    constructor(){}
    static getInstance() {
        if (!MarketService.instance) {
            MarketService.instance = new MarketService();
        }
        return MarketService.instance;
    }
    // Fetch spot markets
    async getSpotMarkets() {
        // Return cached data if already fetched
        if (this.spotDataFetched) {
            return this.spotMarkets;
        }
        // Return existing promise if already fetching
        if (this.spotPromise) {
            return this.spotPromise;
        }
        // Start fetching
        this.isLoadingSpot = true;
        this.spotPromise = this.fetchSpotMarkets();
        try {
            const markets = await this.spotPromise;
            this.spotMarkets = markets;
            this.spotDataFetched = true;
            this.notifySpotSubscribers();
            return markets;
        } finally{
            this.isLoadingSpot = false;
            this.spotPromise = null;
        }
    }
    // Fetch futures markets
    async getFuturesMarkets() {
        // Check if futures extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("futures")) {
            return [];
        }
        // Return cached data if already fetched
        if (this.futuresDataFetched) {
            return this.futuresMarkets;
        }
        // Return existing promise if already fetching
        if (this.futuresPromise) {
            return this.futuresPromise;
        }
        // Start fetching
        this.isLoadingFutures = true;
        this.futuresPromise = this.fetchFuturesMarkets();
        try {
            const markets = await this.futuresPromise;
            this.futuresMarkets = markets;
            this.futuresDataFetched = true;
            this.notifyFuturesSubscribers();
            return markets;
        } finally{
            this.isLoadingFutures = false;
            this.futuresPromise = null;
        }
    }
    // Subscribe to spot market updates
    subscribeToSpotMarkets(callback) {
        this.spotSubscribers.add(callback);
        // Immediately call with current data if available
        if (this.spotDataFetched) {
            callback(this.spotMarkets);
        }
        return ()=>{
            this.spotSubscribers.delete(callback);
        };
    }
    // Subscribe to futures market updates
    subscribeToFuturesMarkets(callback) {
        this.futuresSubscribers.add(callback);
        // Immediately call with current data if available
        if (this.futuresDataFetched) {
            callback(this.futuresMarkets);
        }
        return ()=>{
            this.futuresSubscribers.delete(callback);
        };
    }
    // Get cached spot markets without fetching
    getCachedSpotMarkets() {
        return this.spotMarkets;
    }
    // Get cached futures markets without fetching
    getCachedFuturesMarkets() {
        return this.futuresMarkets;
    }
    // Check if spot markets are loading
    isSpotMarketsLoading() {
        return this.isLoadingSpot;
    }
    // Check if futures markets are loading
    isFuturesMarketsLoading() {
        return this.isLoadingFutures;
    }
    // Private method to fetch spot markets from API
    async fetchSpotMarkets() {
        try {
            // Include ecosystem markets in the request
            const response = await fetch("/api/exchange/market?eco=true");
            if (!response.ok) {
                throw new Error(`Failed to fetch spot markets: ${response.status} ${response.statusText}`);
            }
            const data = await response.json();
            if (Array.isArray(data)) {
                // Process and deduplicate markets, prioritizing ecosystem markets
                const processedMarkets = data.map((market)=>({
                        ...market,
                        displaySymbol: market.symbol || `${market.currency}/${market.pair}`,
                        // Use symbol from API if available, otherwise construct it
                        symbol: market.symbol || `${market.currency}/${market.pair}`,
                        metadata: market.metadata || {
                            precision: {
                                price: 2,
                                amount: 2
                            }
                        }
                    }));
                // Deduplicate markets: ecosystem markets take priority over spot markets
                const marketMap = new Map();
                // First pass: add all spot markets (non-eco)
                const spotMarkets = processedMarkets.filter((market)=>!market.isEco);
                const ecoMarkets = processedMarkets.filter((market)=>market.isEco);
                spotMarkets.forEach((market)=>{
                    marketMap.set(market.symbol, market);
                });
                // Second pass: add ecosystem markets, overwriting any existing spot markets with same symbol
                const overriddenSymbols = [];
                ecoMarkets.forEach((market)=>{
                    if (marketMap.has(market.symbol)) {
                        overriddenSymbols.push(market.symbol);
                    }
                    marketMap.set(market.symbol, market);
                });
                // Convert back to array and sort by symbol for consistent ordering
                const deduplicatedMarkets = Array.from(marketMap.values()).sort((a, b)=>a.symbol.localeCompare(b.symbol));
                return deduplicatedMarkets;
            }
            return [];
        } catch (error) {
            console.error("Error fetching spot markets:", error);
            return [];
        }
    }
    // Private method to fetch futures markets from API
    async fetchFuturesMarkets() {
        try {
            const response = await fetch("/api/futures/market");
            if (!response.ok) {
                throw new Error(`Failed to fetch futures markets: ${response.status} ${response.statusText}`);
            }
            const data = await response.json();
            // Handle direct array response (like spot markets)
            if (Array.isArray(data)) {
                return data.map((market)=>({
                        ...market,
                        displaySymbol: market.symbol || `${market.currency}/${market.pair}`,
                        // Use symbol from API if available, otherwise construct it
                        symbol: market.symbol || `${market.currency}/${market.pair}`
                    }));
            }
            // Fallback: handle wrapped response format
            if (data.success && Array.isArray(data.data)) {
                return data.data;
            }
            return [];
        } catch (error) {
            console.error("Error fetching futures markets:", error);
            return [];
        }
    }
    // Notify spot market subscribers
    notifySpotSubscribers() {
        this.spotSubscribers.forEach((callback)=>{
            try {
                callback(this.spotMarkets);
            } catch (error) {
                console.error("Error in spot market subscriber:", error);
            }
        });
    }
    // Notify futures market subscribers
    notifyFuturesSubscribers() {
        this.futuresSubscribers.forEach((callback)=>{
            try {
                callback(this.futuresMarkets);
            } catch (error) {
                console.error("Error in futures market subscriber:", error);
            }
        });
    }
    // Initialize all market data (called once on app load)
    async initialize() {
        try {
            const promises = [
                this.getSpotMarkets()
            ];
            // Only fetch futures markets if the extension is available
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("futures")) {
                promises.push(this.getFuturesMarkets());
            }
            await Promise.all(promises);
        } catch (error) {
            console.error("Error initializing market service:", error);
        }
    }
    // Clear cache and reset state (useful for testing)
    reset() {
        this.spotMarkets = [];
        this.futuresMarkets = [];
        this.ecoMarkets = [];
        this.spotDataFetched = false;
        this.futuresDataFetched = false;
        this.ecoDataFetched = false;
        this.isLoadingSpot = false;
        this.isLoadingFutures = false;
        this.isLoadingEco = false;
        this.spotPromise = null;
        this.futuresPromise = null;
        this.ecoPromise = null;
    }
}
const marketService = MarketService.getInstance();
}),
"[project]/frontend/services/tickers-ws.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "TickersWebSocketManager",
    ()=>TickersWebSocketManager,
    "tickersWs",
    ()=>tickersWs
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/services/ws-manager.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/extensions.ts [app-ssr] (ecmascript)");
;
;
class TickersWebSocketManager {
    static instance;
    // WebSocket connections
    spotWs = null;
    ecoWs = null;
    futuresWs = null;
    // Connection states
    spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    // Subscription counts to track when we can close connections
    spotSubscriptionCount = 0;
    ecoSubscriptionCount = 0;
    futuresSubscriptionCount = 0;
    // Callbacks
    spotCallbacks = new Set();
    ecoCallbacks = new Set();
    futuresCallbacks = new Set();
    connectionStatusCallbacks = new Set();
    // Data cache
    spotData = {};
    ecoData = {};
    futuresData = {};
    // Connection promises to prevent multiple connection attempts
    spotConnectionPromise = null;
    ecoConnectionPromise = null;
    futuresConnectionPromise = null;
    // Connection timeouts to prevent premature closing
    spotCloseTimeout = null;
    ecoCloseTimeout = null;
    futuresCloseTimeout = null;
    isInitialized = false;
    isClosing = false;
    constructor(){}
    static getInstance() {
        if (!TickersWebSocketManager.instance) {
            TickersWebSocketManager.instance = new TickersWebSocketManager();
        }
        return TickersWebSocketManager.instance;
    }
    initialize() {
        if (this.isInitialized) return;
        this.isInitialized = true;
        this.isClosing = false;
    // We no longer connect all at initialization
    // Instead, connections are made on-demand when subscribed
    }
    createWebSocketUrl(path) {
        // Use the environment variable if available, otherwise construct from window location
        if (typeof process !== "undefined" && process.env.NEXT_PUBLIC_WEBSOCKET_URL) {
            return `${process.env.NEXT_PUBLIC_WEBSOCKET_URL}/${path}`;
        }
        const protocol = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : "ws:";
        const host = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : "localhost:3000";
        return `${protocol}//${host}/${path}`;
    }
    // Get overall connection status (for UI indicators)
    getConnectionStatus() {
        // If any connection is in ERROR state, return ERROR
        if (this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR || this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR || this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
        }
        // If any active connection is CONNECTING, return CONNECTING
        if (this.spotSubscriptionCount > 0 && this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING || this.ecoSubscriptionCount > 0 && this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING || this.futuresSubscriptionCount > 0 && this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        }
        // If all active connections are CONNECTED, return CONNECTED
        if ((this.spotSubscriptionCount === 0 || this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) && (this.ecoSubscriptionCount === 0 || this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) && (this.futuresSubscriptionCount === 0 || this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED)) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
        }
        // Otherwise, return DISCONNECTED
        return __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
    }
    // Connect to spot WebSocket
    connectSpot() {
        // If already connecting, return the existing promise
        if (this.spotConnectionPromise) {
            return this.spotConnectionPromise;
        }
        // If already connected, return resolved promise
        if (this.spotWs && this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            return Promise.resolve();
        }
        // Create new connection
        this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        this.updateAllConnectionStatus();
        this.spotConnectionPromise = new Promise((resolve, reject)=>{
            const url = this.createWebSocketUrl("api/exchange/ticker");
            try {
                this.spotWs = new WebSocket(url);
                this.spotWs.onopen = ()=>{
                    this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
                    this.updateAllConnectionStatus();
                    if (this.spotWs && this.spotWs.readyState === WebSocket.OPEN) {
                        this.spotWs.send(JSON.stringify({
                            action: "SUBSCRIBE",
                            payload: {
                                type: "tickers"
                            }
                        }));
                    }
                    resolve();
                };
                this.spotWs.onmessage = (event)=>{
                    try {
                        const data = JSON.parse(event.data);
                        if (data.data) {
                            // Only update tickers that have new data
                            Object.entries(data.data).forEach(([symbol, tickerData])=>{
                                if (tickerData && tickerData.last !== undefined) {
                                    this.spotData[symbol] = tickerData;
                                }
                            });
                            this.notifySpotCallbacks(this.spotData);
                        }
                    } catch (error) {
                        console.error("Error parsing spot WebSocket message:", error);
                    }
                };
                this.spotWs.onerror = (error)=>{
                    console.error("Spot WebSocket error:", error);
                    this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                    this.updateAllConnectionStatus();
                    reject(error);
                };
                this.spotWs.onclose = ()=>{
                    console.log("Spot WebSocket closed");
                    this.spotWs = null;
                    this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
                    this.spotConnectionPromise = null;
                    this.updateAllConnectionStatus();
                    // Only attempt to reconnect if we still have subscribers and we're not in the process of closing
                    if (this.spotSubscriptionCount > 0 && !this.isClosing) {
                        // Attempt to reconnect after a delay
                        setTimeout(()=>{
                            this.connectSpot().catch(console.error);
                        }, 5000);
                    }
                };
            } catch (error) {
                console.error("Error creating spot WebSocket:", error);
                this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                this.updateAllConnectionStatus();
                this.spotConnectionPromise = null;
                reject(error);
            }
        });
        return this.spotConnectionPromise;
    }
    // Connect to eco WebSocket
    connectEco() {
        // Check if ecosystem extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("ecosystem")) {
            console.warn("Ecosystem extension not available, skipping eco WebSocket connection");
            return Promise.resolve();
        }
        // If already connecting, return the existing promise
        if (this.ecoConnectionPromise) {
            return this.ecoConnectionPromise;
        }
        // If already connected, return resolved promise
        if (this.ecoWs && this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            return Promise.resolve();
        }
        // Create new connection
        this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        this.updateAllConnectionStatus();
        this.ecoConnectionPromise = new Promise((resolve, reject)=>{
            const url = this.createWebSocketUrl("api/ecosystem/ticker");
            try {
                this.ecoWs = new WebSocket(url);
                this.ecoWs.onopen = ()=>{
                    this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
                    this.updateAllConnectionStatus();
                    if (this.ecoWs && this.ecoWs.readyState === WebSocket.OPEN) {
                        this.ecoWs.send(JSON.stringify({
                            action: "SUBSCRIBE",
                            payload: {
                                type: "tickers"
                            }
                        }));
                    }
                    resolve();
                };
                this.ecoWs.onmessage = (event)=>{
                    try {
                        const data = JSON.parse(event.data);
                        if (data.data) {
                            // Only update tickers that have new data
                            Object.entries(data.data).forEach(([symbol, tickerData])=>{
                                if (tickerData && tickerData.last !== undefined) {
                                    this.ecoData[symbol] = tickerData;
                                }
                            });
                            this.notifyEcoCallbacks(this.ecoData);
                        }
                    } catch (error) {
                        console.error("Error parsing eco WebSocket message:", error);
                    }
                };
                this.ecoWs.onerror = (error)=>{
                    console.error("Eco WebSocket error:", error);
                    this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                    this.updateAllConnectionStatus();
                    reject(error);
                };
                this.ecoWs.onclose = ()=>{
                    console.log("Eco WebSocket closed");
                    this.ecoWs = null;
                    this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
                    this.ecoConnectionPromise = null;
                    this.updateAllConnectionStatus();
                    // Only attempt to reconnect if we still have subscribers and we're not in the process of closing
                    if (this.ecoSubscriptionCount > 0 && !this.isClosing) {
                        // Attempt to reconnect after a delay
                        setTimeout(()=>{
                            this.connectEco().catch(console.error);
                        }, 5000);
                    }
                };
            } catch (error) {
                console.error("Error creating eco WebSocket:", error);
                this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                this.updateAllConnectionStatus();
                this.ecoConnectionPromise = null;
                reject(error);
            }
        });
        return this.ecoConnectionPromise;
    }
    // Connect to futures WebSocket
    connectFutures() {
        // Check if futures extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("futures")) {
            console.warn("Futures extension not available, skipping futures WebSocket connection");
            return Promise.resolve();
        }
        // If already connecting, return the existing promise
        if (this.futuresConnectionPromise) {
            return this.futuresConnectionPromise;
        }
        // If already connected, return resolved promise
        if (this.futuresWs && this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            return Promise.resolve();
        }
        // Create new connection
        this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTING;
        this.updateAllConnectionStatus();
        this.futuresConnectionPromise = new Promise((resolve, reject)=>{
            const url = this.createWebSocketUrl("api/futures/ticker");
            try {
                this.futuresWs = new WebSocket(url);
                this.futuresWs.onopen = ()=>{
                    this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED;
                    this.updateAllConnectionStatus();
                    if (this.futuresWs && this.futuresWs.readyState === WebSocket.OPEN) {
                        this.futuresWs.send(JSON.stringify({
                            action: "SUBSCRIBE",
                            payload: {
                                type: "tickers"
                            }
                        }));
                    }
                    resolve();
                };
                this.futuresWs.onmessage = (event)=>{
                    try {
                        const message = JSON.parse(event.data);
                        if (message.stream === "tickers" && message.data) {
                            // Bulk tickers format: {"stream": "tickers", "data": {"SYMBOL": {...}}}
                            Object.entries(message.data).forEach(([symbol, tickerData])=>{
                                if (tickerData && tickerData.last !== undefined) {
                                    this.futuresData[symbol] = tickerData;
                                }
                            });
                            this.notifyFuturesCallbacks(this.futuresData);
                        } else if (message.stream === "ticker" && message.data) {
                            // Individual ticker format: {"stream": "ticker", "data": {"symbol": "SYMBOL", ...}}
                            const tickerData = message.data;
                            if (tickerData.symbol && tickerData.last !== undefined) {
                                this.futuresData[tickerData.symbol] = {
                                    last: tickerData.last,
                                    change: tickerData.change || 0,
                                    percentage: tickerData.percentage || 0,
                                    baseVolume: tickerData.baseVolume || 0,
                                    quoteVolume: tickerData.quoteVolume || 0,
                                    high: tickerData.high || 0,
                                    low: tickerData.low || 0,
                                    bid: tickerData.bid || 0,
                                    ask: tickerData.ask || 0,
                                    fundingRate: tickerData.fundingRate || 0
                                };
                                console.log("Updated futures data for", tickerData.symbol, ":", this.futuresData[tickerData.symbol]);
                                this.notifyFuturesCallbacks(this.futuresData);
                            }
                        }
                    } catch (error) {
                        console.error("Error parsing futures WebSocket message:", error);
                    }
                };
                this.futuresWs.onerror = (error)=>{
                    console.error("Futures WebSocket error:", error);
                    this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                    this.updateAllConnectionStatus();
                    reject(error);
                };
                this.futuresWs.onclose = ()=>{
                    console.log("Futures WebSocket closed");
                    this.futuresWs = null;
                    this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
                    this.futuresConnectionPromise = null;
                    this.updateAllConnectionStatus();
                    // Only attempt to reconnect if we still have subscribers and we're not in the process of closing
                    if (this.futuresSubscriptionCount > 0 && !this.isClosing) {
                        // Attempt to reconnect after a delay
                        setTimeout(()=>{
                            this.connectFutures().catch(console.error);
                        }, 5000);
                    }
                };
            } catch (error) {
                console.error("Error creating futures WebSocket:", error);
                this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].ERROR;
                this.updateAllConnectionStatus();
                this.futuresConnectionPromise = null;
                reject(error);
            }
        });
        return this.futuresConnectionPromise;
    }
    // Subscribe to spot data
    subscribeToSpotData(callback) {
        // Increment subscription count
        this.spotSubscriptionCount++;
        // Add callback to set
        this.spotCallbacks.add(callback);
        // If we already have data, notify immediately
        if (Object.keys(this.spotData).length > 0) {
            callback(this.spotData);
        }
        // Connect if not already connected
        if (this.spotConnectionState !== __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            this.connectSpot().catch(console.error);
        }
        // Clear any pending close timeout
        if (this.spotCloseTimeout) {
            clearTimeout(this.spotCloseTimeout);
            this.spotCloseTimeout = null;
        }
        // Return unsubscribe function
        return ()=>{
            this.spotCallbacks.delete(callback);
            this.spotSubscriptionCount--;
            // If no more subscribers, schedule closing the connection after a delay
            // This prevents rapid subscribe/unsubscribe cycles from breaking connections
            if (this.spotSubscriptionCount === 0 && this.spotWs) {
                // Clear any existing timeout
                if (this.spotCloseTimeout) {
                    clearTimeout(this.spotCloseTimeout);
                }
                // Set a new timeout to close the connection after a delay
                this.spotCloseTimeout = setTimeout(()=>{
                    if (this.spotWs) {
                        this.spotWs.close();
                        this.spotWs = null;
                    }
                    this.spotCloseTimeout = null;
                }, 5000); // 5 second delay before closing
            }
        };
    }
    // Subscribe to eco data
    subscribeToEcoData(callback) {
        // Check if ecosystem extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("ecosystem")) {
            console.warn("Ecosystem extension not available, skipping eco data subscription");
            // Return a no-op unsubscribe function
            return ()=>{};
        }
        // Increment subscription count
        this.ecoSubscriptionCount++;
        // Add callback to set
        this.ecoCallbacks.add(callback);
        // If we already have data, notify immediately
        if (Object.keys(this.ecoData).length > 0) {
            callback(this.ecoData);
        }
        // Connect if not already connected
        if (this.ecoConnectionState !== __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            this.connectEco().catch(console.error);
        }
        // Clear any pending close timeout
        if (this.ecoCloseTimeout) {
            clearTimeout(this.ecoCloseTimeout);
            this.ecoCloseTimeout = null;
        }
        // Return unsubscribe function
        return ()=>{
            this.ecoCallbacks.delete(callback);
            this.ecoSubscriptionCount--;
            // If no more subscribers, schedule closing the connection after a delay
            if (this.ecoSubscriptionCount === 0 && this.ecoWs) {
                // Clear any existing timeout
                if (this.ecoCloseTimeout) {
                    clearTimeout(this.ecoCloseTimeout);
                }
                // Set a new timeout to close the connection after a delay
                this.ecoCloseTimeout = setTimeout(()=>{
                    if (this.ecoWs) {
                        this.ecoWs.close();
                        this.ecoWs = null;
                    }
                    this.ecoCloseTimeout = null;
                }, 5000); // 5 second delay before closing
            }
        };
    }
    // Subscribe to futures data
    subscribeToFuturesData(callback) {
        // Check if futures extension is available
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$extensions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isExtensionAvailable"])("futures")) {
            console.warn("Futures extension not available, skipping futures data subscription");
            // Return a no-op unsubscribe function
            return ()=>{};
        }
        // Increment subscription count
        this.futuresSubscriptionCount++;
        // Add callback to set
        this.futuresCallbacks.add(callback);
        // If we already have data, notify immediately
        if (Object.keys(this.futuresData).length > 0) {
            callback(this.futuresData);
        }
        // Connect to futures bulk ticker WebSocket if not already connected
        if (this.futuresConnectionState !== __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
            this.connectFutures().catch(console.error);
        }
        // Clear any pending close timeout
        if (this.futuresCloseTimeout) {
            clearTimeout(this.futuresCloseTimeout);
            this.futuresCloseTimeout = null;
        }
        // Return unsubscribe function
        return ()=>{
            this.futuresCallbacks.delete(callback);
            this.futuresSubscriptionCount--;
            // If no more subscribers, schedule closing the connection after a delay
            if (this.futuresSubscriptionCount === 0 && this.futuresWs) {
                // Clear any existing timeout
                if (this.futuresCloseTimeout) {
                    clearTimeout(this.futuresCloseTimeout);
                }
                // Set a new timeout to close the connection after a delay
                this.futuresCloseTimeout = setTimeout(()=>{
                    if (this.futuresWs) {
                        this.futuresWs.close();
                        this.futuresWs = null;
                    }
                    this.futuresCloseTimeout = null;
                }, 5000); // 5 second delay before closing
            }
        };
    }
    // Subscribe to connection status
    subscribeToConnectionStatus(callback) {
        this.connectionStatusCallbacks.add(callback);
        // Notify immediately with current status
        callback(this.getConnectionStatus());
        return ()=>{
            this.connectionStatusCallbacks.delete(callback);
        };
    }
    // Notify spot callbacks
    notifySpotCallbacks(data) {
        this.spotCallbacks.forEach((callback)=>{
            try {
                callback(data);
            } catch (error) {
                console.error("Error in spot callback:", error);
            }
        });
    }
    // Notify eco callbacks
    notifyEcoCallbacks(data) {
        this.ecoCallbacks.forEach((callback)=>{
            try {
                callback(data);
            } catch (error) {
                console.error("Error in eco callback:", error);
            }
        });
    }
    // Notify futures callbacks
    notifyFuturesCallbacks(data) {
        this.futuresCallbacks.forEach((callback)=>{
            try {
                callback(data);
            } catch (error) {
                console.error("Error in futures callback:", error);
            }
        });
    }
    // Update all connection status callbacks
    updateAllConnectionStatus() {
        const status = this.getConnectionStatus();
        this.connectionStatusCallbacks.forEach((callback)=>{
            try {
                callback(status);
            } catch (error) {
                console.error("Error in connection status callback:", error);
            }
        });
    }
    /**
   * Force unsubscribe from a specific symbol's data across all connections
   * This helps prevent duplicate trades when navigating between pages
   * @param symbol The symbol to unsubscribe from
   */ unsubscribeFromSymbol(symbol) {
        // Normalize the symbol to handle different formats
        const normalizedSymbol = symbol.replace('/', '').replace('-', '').toUpperCase();
        const slashSymbol = symbol.includes('/') ? symbol : symbol.replace(/([A-Z]+)([A-Z]{3,4})$/, '$1/$2');
        const dashSymbol = symbol.includes('-') ? symbol : symbol.replace(/([A-Z]+)([A-Z]{3,4})$/, '$1-$2');
        // Create an array of possible symbol formats to check
        const symbolVariations = [
            symbol,
            normalizedSymbol,
            slashSymbol,
            dashSymbol,
            symbol.toUpperCase(),
            symbol.toLowerCase()
        ];
        // Check if we have this symbol in any of our data caches
        const hasInSpot = symbolVariations.some((s)=>this.spotData[s] !== undefined);
        const hasInEco = symbolVariations.some((s)=>this.ecoData[s] !== undefined);
        const hasInFutures = symbolVariations.some((s)=>this.futuresData[s] !== undefined);
        console.log(`Unsubscribing from symbol: ${symbol} (found in spot: ${hasInSpot}, eco: ${hasInEco}, futures: ${hasInFutures})`);
        // Remove the symbol from our data caches
        symbolVariations.forEach((s)=>{
            delete this.spotData[s];
            delete this.ecoData[s];
            delete this.futuresData[s];
        });
        // If we have active WebSocket connections, send unsubscribe messages
        if (this.spotWs && this.spotConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED && hasInSpot) {
            try {
                this.spotWs.send(JSON.stringify({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type: "ticker",
                        symbol
                    }
                }));
            } catch (error) {
                console.error(`Error unsubscribing from spot ticker for ${symbol}:`, error);
            }
        }
        if (this.ecoWs && this.ecoConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED && hasInEco) {
            try {
                this.ecoWs.send(JSON.stringify({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type: "ticker",
                        symbol
                    }
                }));
            } catch (error) {
                console.error(`Error unsubscribing from eco ticker for ${symbol}:`, error);
            }
        }
        if (this.futuresWs && this.futuresConnectionState === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED && hasInFutures) {
            try {
                this.futuresWs.send(JSON.stringify({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type: "ticker",
                        symbol
                    }
                }));
            } catch (error) {
                console.error(`Error unsubscribing from futures ticker for ${symbol}:`, error);
            }
        }
    }
    cleanup() {
        this.isClosing = true;
        // Clear all timeouts
        if (this.spotCloseTimeout) {
            clearTimeout(this.spotCloseTimeout);
            this.spotCloseTimeout = null;
        }
        if (this.ecoCloseTimeout) {
            clearTimeout(this.ecoCloseTimeout);
            this.ecoCloseTimeout = null;
        }
        if (this.futuresCloseTimeout) {
            clearTimeout(this.futuresCloseTimeout);
            this.futuresCloseTimeout = null;
        }
        // Close all WebSocket connections
        if (this.spotWs) {
            this.spotWs.close();
            this.spotWs = null;
        }
        if (this.ecoWs) {
            this.ecoWs.close();
            this.ecoWs = null;
        }
        if (this.futuresWs) {
            this.futuresWs.close();
            this.futuresWs = null;
        }
        // Reset all state
        this.spotConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
        this.ecoConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
        this.futuresConnectionState = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ConnectionStatus"].DISCONNECTED;
        this.spotSubscriptionCount = 0;
        this.ecoSubscriptionCount = 0;
        this.futuresSubscriptionCount = 0;
        this.spotCallbacks.clear();
        this.ecoCallbacks.clear();
        this.futuresCallbacks.clear();
        this.connectionStatusCallbacks.clear();
        this.spotConnectionPromise = null;
        this.ecoConnectionPromise = null;
        this.futuresConnectionPromise = null;
        this.isInitialized = false;
        this.isClosing = false;
    }
}
const tickersWs = TickersWebSocketManager.getInstance();
}),
"[project]/frontend/utils/time-sync.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// Time synchronization utilities
// For testing use this time offset to match the chart time
// This simulates getting the correct time that matches the chart display
// const TIME_OFFSET_MS = -5 * 60 * 60 * 1000; // -5 hours in milliseconds
// Get chart-synchronized time
__turbopack_context__.s([
    "calculateNextExpiryTime",
    ()=>calculateNextExpiryTime,
    "dateToUnixTimestamp",
    ()=>dateToUnixTimestamp,
    "formatChartTime",
    ()=>formatChartTime,
    "formatCountdown",
    ()=>formatCountdown,
    "getChartSynchronizedTime",
    ()=>getChartSynchronizedTime,
    "unixTimestampToDate",
    ()=>unixTimestampToDate
]);
function getChartSynchronizedTime() {
    // In a real implementation, this would sync with the chart's time reference
    // For now, we'll just use the current time
    // return new Date(Date.now() + TIME_OFFSET_MS);
    return new Date();
}
function formatChartTime(date) {
    return date.toLocaleTimeString([], {
        hour: "2-digit",
        minute: "2-digit"
    });
}
function calculateNextExpiryTime(intervalMinutes) {
    const now = getChartSynchronizedTime();
    const minutes = now.getMinutes();
    const remainder = minutes % intervalMinutes;
    const nextExpiryTime = new Date(now);
    if (remainder === 0) {
        // If we're exactly at an interval, use the next one
        nextExpiryTime.setMinutes(minutes + intervalMinutes);
    } else {
        // Otherwise round up to the next interval
        nextExpiryTime.setMinutes(minutes + (intervalMinutes - remainder));
    }
    nextExpiryTime.setSeconds(0);
    nextExpiryTime.setMilliseconds(0);
    return nextExpiryTime;
}
function formatCountdown(timeLeftMs) {
    if (timeLeftMs <= 0) return "00:00";
    const minutes = Math.floor(timeLeftMs / 60000);
    const seconds = Math.floor(timeLeftMs % 60000 / 1000);
    return `${minutes.toString().padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;
}
function dateToUnixTimestamp(date) {
    return Math.floor(date.getTime() / 1000);
}
function unixTimestampToDate(timestamp) {
    return new Date(timestamp * 1000);
}
}),
"[project]/frontend/store/trade/use-binary-store.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "cleanupBinaryStore",
    ()=>cleanupBinaryStore,
    "cleanupRegistry",
    ()=>cleanupRegistry,
    "extractBaseCurrency",
    ()=>extractBaseCurrency,
    "extractQuoteCurrency",
    ()=>extractQuoteCurrency,
    "formatPairFromSymbol",
    ()=>formatPairFromSymbol,
    "getMarketFromSymbol",
    ()=>getMarketFromSymbol,
    "getSymbolFromPair",
    ()=>getSymbolFromPair,
    "initializeBinaryStore",
    ()=>initializeBinaryStore,
    "useBinaryStore",
    ()=>useBinaryStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/middleware.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/time-sync.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/user.ts [app-ssr] (ecmascript)");
;
;
;
;
;
// Global cleanup registry for intervals and subscriptions
class CleanupRegistry {
    intervals = new Set();
    subscriptions = new Set();
    isCleaningUp = false;
    addInterval(interval) {
        this.intervals.add(interval);
    }
    addSubscription(unsubscribe) {
        this.subscriptions.add(unsubscribe);
    }
    cleanup() {
        if (this.isCleaningUp) return;
        this.isCleaningUp = true;
        // Clear all intervals
        this.intervals.forEach((interval)=>{
            try {
                clearInterval(interval);
            } catch (error) {
                console.warn("Error clearing interval:", error);
            }
        });
        this.intervals.clear();
        // Call all unsubscribe functions
        this.subscriptions.forEach((unsubscribe)=>{
            try {
                unsubscribe();
            } catch (error) {
                console.warn("Error during unsubscribe:", error);
            }
        });
        this.subscriptions.clear();
        this.isCleaningUp = false;
    }
    removeInterval(interval) {
        this.intervals.delete(interval);
    }
    removeSubscription(unsubscribe) {
        this.subscriptions.delete(unsubscribe);
    }
}
const cleanupRegistry = new CleanupRegistry();
// Global initialization flag to prevent duplicate initializations
let isInitializing = false;
let isInitialized = false;
let initializationPromise = null;
function getMarketFromSymbol(symbol, markets) {
    return markets.find((m)=>m.symbol === symbol || m.label === symbol || `${m.currency}${m.pair}` === symbol || `${m.currency}/${m.pair}` === symbol) || null;
}
function extractBaseCurrency(symbol, markets = []) {
    // First try to find the market and use its currency field
    const market = getMarketFromSymbol(symbol, markets);
    if (market?.currency) {
        return market.currency;
    }
    // Fallback to old parsing logic only if no market data available
    if (!symbol || typeof symbol !== 'string' || symbol.length < 2) {
        console.warn('Invalid symbol for base currency extraction:', symbol);
        return '';
    }
    // Simple parsing for fallback
    if (symbol.includes('/')) {
        const parts = symbol.split('/');
        return parts[0] || '';
    }
    // Default fallback
    return symbol.slice(0, 3);
}
function extractQuoteCurrency(symbol, markets = []) {
    // First try to find the market and use its pair field
    const market = getMarketFromSymbol(symbol, markets);
    if (market?.pair) {
        return market.pair;
    }
    // Fallback to old parsing logic only if no market data available
    if (!symbol || typeof symbol !== 'string' || symbol.length < 2) {
        console.warn('Invalid symbol for quote currency extraction:', symbol);
        return '';
    }
    // Simple parsing for fallback
    if (symbol.includes('/')) {
        const parts = symbol.split('/');
        return parts[1] || '';
    }
    // Default fallback
    return 'USDT';
}
function formatPairFromSymbol(symbol, markets = []) {
    const base = extractBaseCurrency(symbol, markets);
    const quote = extractQuoteCurrency(symbol, markets);
    return `${base}/${quote}`;
}
function getSymbolFromPair(currency, pair) {
    // Convert currency/pair format back to symbol format
    return `${currency}${pair}`;
}
// Smart market selection with performance optimization
function selectBestMarket(markets) {
    if (markets.length === 0) return null;
    // First, find any active market (status: true)
    const activeMarket = markets.find((m)=>m.status);
    if (activeMarket) return activeMarket;
    // If no active markets, return the first available market
    return markets[0];
}
const useBinaryStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["devtools"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["persist"])((set, get)=>({
        // Market data - initialized with empty values
        activeMarkets: [],
        currentSymbol: "",
        currentPrice: 0,
        priceMovements: {},
        timeFrame: "1m",
        candleData: [],
        // Binary markets data
        binaryMarkets: [],
        isLoadingMarkets: false,
        isLoading: false,
        // Wallet data
        balance: 10000,
        realBalance: null,
        demoBalance: 10000,
        netPL: 0,
        isLoadingWallet: false,
        // Orders
        orders: [],
        completedOrders: [],
        isLoadingOrders: false,
        positionMarkers: [],
        // Trading settings
        tradingMode: "demo",
        selectedExpiryMinutes: 1,
        isInSafeZone: false,
        binaryDurations: [],
        isLoadingDurations: false,
        // UI state
        isMarketSwitching: false,
        // Actions
        setCurrentSymbol: (symbol)=>{
            const { currentSymbol: prevSymbol } = get();
            // Only update if symbol actually changed
            if (prevSymbol === symbol) return;
            set({
                currentSymbol: symbol,
                activeMarkets: [
                    {
                        symbol,
                        price: 0,
                        change: 0
                    }
                ],
                isMarketSwitching: true
            });
            // Fetch wallet data for the new symbol
            const { binaryMarkets } = get();
            const quoteCurrency = extractQuoteCurrency(symbol, binaryMarkets);
            get().fetchWalletData(quoteCurrency);
            // Fetch orders for the new symbol if user is authenticated
            const { user } = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useUserStore"].getState();
            if (user?.id) {
                // Use setTimeout to ensure state is updated first
                setTimeout(()=>{
                    Promise.all([
                        get().fetchCompletedOrders(),
                        get().fetchActiveOrders()
                    ]).catch((error)=>{
                        console.warn('Failed to fetch orders:', error);
                    });
                }, 100);
            }
            // Reset market switching flag after a short delay
            setTimeout(()=>{
                set({
                    isMarketSwitching: false
                });
            }, 500);
        },
        setTimeFrame: (timeFrame)=>set({
                timeFrame
            }),
        setTradingMode: (mode)=>{
            set({
                tradingMode: mode,
                balance: mode === "demo" ? get().demoBalance : get().realBalance ?? 0
            });
            // Use requestAnimationFrame to defer wallet data fetch
            requestAnimationFrame(()=>{
                // Always refresh wallet data when switching modes (to ensure we have latest balance)
                if (get().currentSymbol) {
                    const { binaryMarkets } = get();
                    const quoteCurrency = extractQuoteCurrency(get().currentSymbol, binaryMarkets);
                    get().fetchWalletData(quoteCurrency);
                }
            });
        },
        setSelectedExpiryMinutes: (minutes)=>set({
                selectedExpiryMinutes: minutes
            }),
        addMarket: (symbol)=>{
            const { activeMarkets } = get();
            if (!activeMarkets.find((m)=>m.symbol === symbol)) {
                set({
                    activeMarkets: [
                        ...activeMarkets,
                        {
                            symbol,
                            price: 0,
                            change: 0
                        }
                    ]
                });
            }
        },
        // Add method to update market data with real-time prices
        updateMarketData: (symbol, price, change)=>{
            const { activeMarkets } = get();
            const updatedMarkets = activeMarkets.map((market)=>market.symbol === symbol ? {
                    ...market,
                    price,
                    change
                } : market);
            set({
                activeMarkets: updatedMarkets
            });
        },
        // Update all active markets with ticker data
        updateActiveMarketsFromTicker: (tickerData)=>{
            const { activeMarkets, binaryMarkets } = get();
            const updatedMarkets = activeMarkets.map((market)=>{
                // Find the corresponding binary market to get currency and pair
                const binaryMarket = binaryMarkets.find((m)=>m.symbol === market.symbol || `${m.currency}${m.pair}` === market.symbol || `${m.currency}/${m.pair}` === market.symbol);
                if (!binaryMarket) {
                    return market; // No matching binary market found
                }
                // Try different ticker data key formats using the actual market data
                let marketData = null;
                // Format 1: Use the label from binary market (e.g., "TRX/USDT")
                if (binaryMarket.label) {
                    marketData = tickerData[binaryMarket.label];
                }
                // Format 2: Use symbol from binary market
                if (!marketData && binaryMarket.symbol) {
                    marketData = tickerData[binaryMarket.symbol];
                }
                // Format 3: Construct from currency/pair (e.g., "TRX/USDT")
                if (!marketData) {
                    const symbolKey = `${binaryMarket.currency}/${binaryMarket.pair}`;
                    marketData = tickerData[symbolKey];
                }
                // Format 4: Try without slash (e.g., "TRXUSDT")
                if (!marketData) {
                    const noSlashSymbol = `${binaryMarket.currency}${binaryMarket.pair}`;
                    marketData = tickerData[noSlashSymbol];
                }
                // Update market with new data if found
                if (marketData) {
                    return {
                        ...market,
                        price: marketData.last || market.price,
                        change: marketData.percentage || marketData.change || market.change
                    };
                }
                return market;
            });
            set({
                activeMarkets: updatedMarkets
            });
        },
        removeMarket: (symbol)=>{
            const { activeMarkets, currentSymbol } = get();
            if (activeMarkets.length > 1) {
                set({
                    activeMarkets: activeMarkets.filter((m)=>m.symbol !== symbol)
                });
                // If removing the current symbol, switch to another one
                if (symbol === currentSymbol) {
                    const newSymbol = activeMarkets.find((m)=>m.symbol !== symbol)?.symbol || "";
                    if (newSymbol) {
                        get().setCurrentSymbol(newSymbol);
                    }
                }
            }
        },
        placeOrder: async (side, amount, expiryMinutes)=>{
            const { currentSymbol, currentPrice, balance, tradingMode, binaryMarkets } = get();
            // Check if we have enough balance
            if (amount <= 0 || amount > balance) {
                return false;
            }
            // Check if we're in the safe zone
            if (get().isInSafeZone) {
                return false;
            }
            try {
                // Extract currency and pair from symbol using actual market data
                const currency = extractBaseCurrency(currentSymbol, binaryMarkets);
                const pair = extractQuoteCurrency(currentSymbol, binaryMarkets);
                // Calculate closedAt timestamp from expiryMinutes
                const closedAt = new Date(Date.now() + expiryMinutes * 60 * 1000).toISOString();
                // Call the API to place the order
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/exchange/binary/order",
                    method: "POST",
                    body: {
                        currency,
                        pair,
                        amount,
                        side,
                        closedAt,
                        type: "RISE_FALL",
                        isDemo: tradingMode === "demo"
                    }
                });
                if (!error && data) {
                    // Create order from API response
                    const newOrder = {
                        id: data.order?.id || Math.random().toString(36).substring(2, 15),
                        symbol: data.order?.symbol || currentSymbol,
                        side,
                        amount,
                        entryPrice: data.order?.price || currentPrice,
                        expiryTime: data.order?.closedAt ? new Date(data.order.closedAt).getTime() : Date.now() + expiryMinutes * 60 * 1000,
                        createdAt: data.order?.createdAt ? new Date(data.order.createdAt).getTime() : Date.now(),
                        status: "PENDING",
                        mode: tradingMode
                    };
                    // Update state only if API call was successful
                    set((state)=>({
                            orders: [
                                ...state.orders,
                                newOrder
                            ],
                            balance: balance - amount,
                            ...tradingMode === "demo" ? {
                                demoBalance: state.demoBalance - amount
                            } : {
                                realBalance: (state.realBalance ?? 0) - amount
                            }
                        }));
                    return true;
                } else {
                    console.error("Failed to place order:", error);
                    return false;
                }
            } catch (error) {
                console.error("Error placing order:", error);
                return false;
            }
        },
        fetchWalletData: async (currency)=>{
            try {
                // Check if user is authenticated
                const { user } = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useUserStore"].getState();
                if (!user) {
                    set({
                        isLoadingWallet: false
                    });
                    return;
                }
                // Extract the currency from the symbol if not provided
                const currentSymbol = get().currentSymbol;
                if (!currentSymbol) {
                    console.log(`[Binary Store] No current symbol available, skipping wallet fetch`);
                    set({
                        isLoadingWallet: false
                    });
                    return;
                }
                const { binaryMarkets } = get();
                const currencyToFetch = currency || extractQuoteCurrency(currentSymbol, binaryMarkets);
                // Validate currency
                if (!currencyToFetch || currencyToFetch.length < 2) {
                    console.log(`[Binary Store] Invalid currency "${currencyToFetch}", skipping wallet fetch`);
                    set({
                        isLoadingWallet: false
                    });
                    return;
                }
                // Prevent duplicate calls - check if we're already loading this currency
                const currentState = get();
                if (currentState.isLoadingWallet) {
                    console.log(`[Binary Store] Wallet fetch already in progress for ${currencyToFetch}, skipping duplicate call`);
                    return;
                }
                // Create cache key for this currency
                const cacheKey = `wallet_${currencyToFetch}`;
                const now = Date.now();
                // Check if we have recent cached data (within 30 seconds)
                if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
                ;
                console.log(`[Binary Store] Fetching wallet data for ${currencyToFetch}`);
                set({
                    isLoadingWallet: true
                });
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/finance/wallet/SPOT/${currencyToFetch}`,
                    silentSuccess: true
                });
                if (!error && data?.balance !== undefined) {
                    // Cache the successful response
                    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
                    ;
                    // Update real balance
                    set({
                        realBalance: data.balance,
                        isLoadingWallet: false,
                        // If in real mode, update the displayed balance
                        ...get().tradingMode === "real" ? {
                            balance: data.balance
                        } : {}
                    });
                } else {
                    console.warn(`Wallet not found for ${currencyToFetch}, using default balance`);
                    set({
                        isLoadingWallet: false
                    });
                }
            } catch (error) {
                console.warn("Error fetching wallet data:", error);
                set({
                    isLoadingWallet: false
                });
            }
        },
        // Fetch binary durations with caching
        fetchBinaryDurations: async ()=>{
            try {
                // Prevent duplicate calls if already loading
                if (get().isLoadingDurations) {
                    console.log("Binary durations already loading, skipping duplicate call");
                    return;
                }
                // Check if we already have durations data
                if (get().binaryDurations.length > 0) {
                    console.log("Binary durations already loaded, skipping fetch");
                    return;
                }
                set({
                    isLoadingDurations: true
                });
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/exchange/binary/duration",
                    silentSuccess: true
                });
                if (!error && Array.isArray(data)) {
                    set({
                        binaryDurations: data,
                        isLoadingDurations: false,
                        // Set default expiry to the first active duration
                        ...data.length > 0 ? {
                            selectedExpiryMinutes: data.find((d)=>d.status)?.duration || data[0].duration
                        } : {}
                    });
                } else {
                    console.error("Failed to fetch binary durations:", error);
                    set({
                        isLoadingDurations: false
                    });
                }
            } catch (error) {
                console.error("Failed to fetch binary durations:", error);
                set({
                    isLoadingDurations: false
                });
            }
        },
        // Fetch binary markets with caching
        fetchBinaryMarkets: async ()=>{
            try {
                // Prevent duplicate calls if already loading
                if (get().isLoadingMarkets) {
                    console.log("Binary markets already loading, skipping duplicate call");
                    return;
                }
                // Check if we already have markets data
                if (get().binaryMarkets.length > 0) {
                    console.log("Binary markets already loaded, skipping fetch");
                    return;
                }
                set({
                    isLoadingMarkets: true
                });
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/exchange/binary/market",
                    silentSuccess: true
                });
                if (!error && Array.isArray(data)) {
                    const markets = data;
                    set({
                        binaryMarkets: markets,
                        isLoadingMarkets: false
                    });
                    // Use requestAnimationFrame to defer additional state updates
                    requestAnimationFrame(()=>{
                        // Smart market selection based on priority
                        const { activeMarkets, currentSymbol } = get();
                        // Only auto-select if no symbol is currently set
                        if (markets.length > 0 && (activeMarkets.length === 0 || !currentSymbol)) {
                            // Use smart selection to pick the best market
                            const bestMarket = selectBestMarket(markets);
                            if (bestMarket) {
                                const symbol = bestMarket.symbol || `${bestMarket.currency}/${bestMarket.pair}`;
                                // Use setCurrentSymbol to trigger order fetching
                                get().setCurrentSymbol(symbol);
                            }
                        } else {
                            // Even if we don't auto-select a market, we should fetch wallet data if we have a current symbol
                            if (currentSymbol) {
                                const quoteCurrency = extractQuoteCurrency(currentSymbol, data);
                                get().fetchWalletData(quoteCurrency);
                            }
                        }
                    });
                } else {
                    console.error("Failed to fetch binary markets:", error);
                    set({
                        isLoadingMarkets: false
                    });
                }
            } catch (error) {
                console.error("Failed to fetch binary markets:", error);
                set({
                    isLoadingMarkets: false
                });
            }
        },
        fetchCompletedOrders: async ()=>{
            try {
                const { currentSymbol, tradingMode, binaryMarkets } = get();
                if (!currentSymbol) {
                    return;
                }
                // Extract currency and pair from symbol using actual market data
                const currency = extractBaseCurrency(currentSymbol, binaryMarkets);
                const pair = extractQuoteCurrency(currentSymbol, binaryMarkets);
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/exchange/binary/order?currency=${currency}&pair=${pair}&type=CLOSED`,
                    method: "GET",
                    silentSuccess: true
                });
                if (!error && Array.isArray(data)) {
                    // Filter completed orders and match trading mode
                    const filteredOrders = data.filter((order)=>order.status !== "PENDING" && order.isDemo === (tradingMode === "demo"));
                    // Transform the API response to match our CompletedOrder interface
                    const completedOrders = filteredOrders.map((order)=>({
                            id: order.id,
                            symbol: order.symbol,
                            side: order.side,
                            amount: order.amount,
                            entryPrice: order.price,
                            closePrice: order.closePrice || order.price,
                            entryTime: new Date(order.createdAt),
                            expiryTime: new Date(order.closedAt),
                            status: order.status === "WIN" ? "WIN" : "LOSS",
                            profit: order.profit || 0
                        }));
                    set({
                        completedOrders
                    });
                } else {
                    console.error("Failed to fetch completed orders:", error);
                }
            } catch (error) {
                console.error("Error fetching completed orders:", error);
            }
        },
        fetchActiveOrders: async ()=>{
            try {
                const { currentSymbol, tradingMode, binaryMarkets } = get();
                if (!currentSymbol) {
                    return;
                }
                // Extract currency and pair from symbol using actual market data
                const currency = extractBaseCurrency(currentSymbol, binaryMarkets);
                const pair = extractQuoteCurrency(currentSymbol, binaryMarkets);
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/exchange/binary/order?currency=${currency}&pair=${pair}&type=OPEN`,
                    method: "GET",
                    silentSuccess: true
                });
                if (!error && Array.isArray(data)) {
                    // Transform the API response to match our Order interface
                    const activeOrders = data.map((order)=>({
                            id: order.id,
                            symbol: order.symbol,
                            side: order.side,
                            amount: order.amount,
                            entryPrice: order.price,
                            expiryTime: new Date(order.closedAt).getTime(),
                            createdAt: new Date(order.createdAt).getTime(),
                            status: "PENDING",
                            mode: order.isDemo ? "demo" : "real"
                        }));
                    // Update the orders in state (replace existing ones to avoid duplicates)
                    set((state)=>({
                            orders: [
                                // Keep orders that are not from this symbol or not pending
                                ...state.orders.filter((order)=>order.symbol !== currentSymbol || order.status !== "PENDING"),
                                // Add the fetched active orders
                                ...activeOrders
                            ]
                        }));
                } else {
                    console.error("Failed to fetch active orders:", error);
                }
            } catch (error) {
                console.error("Error fetching active orders:", error);
            }
        },
        updateOrders: ()=>{
            const { orders, currentPrice, tradingMode } = get();
            // Skip if no orders
            if (orders.length === 0) return;
            // Get current time
            const now = Date.now();
            // Update orders with optimized processing
            const updatedOrders = orders.map((order)=>{
                // Skip if already processed
                if (order.status !== "PENDING") return order;
                // Check if expired
                if (now >= order.expiryTime) {
                    const won = order.side === "RISE" && currentPrice > order.entryPrice || order.side === "FALL" && currentPrice < order.entryPrice;
                    const profitAmount = won ? order.amount * 0.88 : -order.amount;
                    // Update balance and P/L only if it matches current trading mode
                    if (order.mode === tradingMode) {
                        set({
                            balance: get().balance + (won ? order.amount * 0.88 : 0),
                            netPL: get().netPL + profitAmount,
                            ...tradingMode === "demo" ? {
                                demoBalance: get().demoBalance + (won ? order.amount * 0.88 : 0)
                            } : {
                                realBalance: (get().realBalance ?? 0) + (won ? order.amount * 0.88 : 0)
                            }
                        });
                    }
                    // Add to completed orders
                    const completedOrder = {
                        id: order.id,
                        symbol: order.symbol,
                        side: order.side,
                        amount: order.amount,
                        entryPrice: order.entryPrice,
                        closePrice: currentPrice,
                        entryTime: new Date(order.createdAt),
                        expiryTime: new Date(order.expiryTime),
                        status: won ? "WIN" : "LOSS",
                        profit: profitAmount
                    };
                    set({
                        completedOrders: [
                            completedOrder,
                            ...get().completedOrders
                        ]
                    });
                    return {
                        ...order,
                        status: won ? "win" : "loss",
                        profit: profitAmount,
                        closePrice: currentPrice
                    };
                }
                // Calculate current profit/loss for active orders
                const currentProfit = order.side === "RISE" ? currentPrice > order.entryPrice ? (currentPrice - order.entryPrice) / order.entryPrice * order.amount : -((order.entryPrice - currentPrice) / order.entryPrice * order.amount) : currentPrice < order.entryPrice ? (order.entryPrice - currentPrice) / order.entryPrice * order.amount : -((currentPrice - order.entryPrice) / order.entryPrice * order.amount);
                return {
                    ...order,
                    profit: currentProfit
                };
            });
            // Filter out completed orders (they've been moved to completedOrders)
            const activeOrders = updatedOrders.filter((order)=>order.status === "PENDING");
            // Check if we're in the safe zone (15 seconds before expiry)
            const nextExpiry = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["calculateNextExpiryTime"])(get().selectedExpiryMinutes);
            const timeToExpiry = nextExpiry.getTime() - (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getChartSynchronizedTime"])().getTime();
            set({
                orders: activeOrders,
                isInSafeZone: timeToExpiry <= 15000
            });
        },
        // Set current price (used by components that read from WebSocket)
        setCurrentPrice: (price)=>{
            set({
                currentPrice: price
            });
        },
        // Set candle data (used by components that read from WebSocket)
        setCandleData: (data)=>{
            set({
                candleData: data
            });
        },
        // Initialize order WebSocket subscription
        initOrderWebSocket: ()=>{
            // This will be implemented when the WebSocket service is properly set up
            console.log("Order WebSocket initialization - to be implemented");
        },
        // Cleanup method to prevent memory leaks
        cleanup: ()=>{
            console.log("Cleaning up binary store...");
            cleanupRegistry.cleanup();
        },
        setIsLoading: (loading)=>set({
                isLoading: loading
            }),
        user: __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useUserStore"].getState().user
    }), {
    name: "binary-trading-store",
    partialize: (state)=>({
            activeMarkets: state.activeMarkets,
            currentSymbol: state.currentSymbol,
            timeFrame: state.timeFrame,
            demoBalance: state.demoBalance,
            tradingMode: state.tradingMode,
            selectedExpiryMinutes: state.selectedExpiryMinutes
        })
})));
const initializeBinaryStore = async ()=>{
    // If already initialized, return immediately
    if (isInitialized) {
        console.log('Binary store already initialized, skipping...');
        return;
    }
    // If currently initializing, return the existing promise
    if (isInitializing && initializationPromise) {
        console.log('Binary store initialization in progress, waiting...');
        return initializationPromise;
    }
    // Set initializing flag and create promise
    isInitializing = true;
    initializationPromise = (async ()=>{
        try {
            console.log('Starting binary store initialization...');
            const store = useBinaryStore.getState();
            // Get user from useUserStore instead of binary store
            const { user } = await __turbopack_context__.A("[project]/frontend/store/user.ts [app-ssr] (ecmascript, async loader)").then((m)=>m.useUserStore.getState());
            const isAuthenticated = !!user?.id;
            // Set loading state
            store.setIsLoading(true);
            // Parallel fetch of essential data
            console.log('Fetching binary markets and durations...');
            await Promise.all([
                store.fetchBinaryMarkets(),
                store.fetchBinaryDurations()
            ]);
            // Only fetch user-specific data if authenticated
            if (isAuthenticated) {
                console.log('User authenticated, fetching user-specific data...');
                // Don't fetch orders here as currentSymbol is not set yet
                // Orders will be fetched when symbol is set
                // Set up interval to update orders with proper cleanup management
                const updateInterval = setInterval(()=>{
                    try {
                        const currentStore = useBinaryStore.getState();
                        // Only update if we have active orders and a symbol
                        if (isInitialized && currentStore.currentSymbol && currentStore.orders.length > 0) {
                            currentStore.updateOrders();
                        }
                    } catch (error) {
                        console.error("Error updating orders:", error);
                    }
                }, 2000); // Increased interval to reduce load
                // Register interval for cleanup
                cleanupRegistry.addInterval(updateInterval);
            } else {
                console.log("User not authenticated, skipping user-specific data fetch");
            }
            // Mark as initialized
            isInitialized = true;
            store.setIsLoading(false);
            console.log("Binary store initialized successfully");
        } catch (error) {
            console.error("Error initializing binary store:", error);
            const store = useBinaryStore.getState();
            store.setIsLoading(false);
            throw error; // Re-throw to allow caller to handle
        } finally{
            isInitializing = false;
        }
    })();
    return initializationPromise;
};
const cleanupBinaryStore = ()=>{
    console.log("Cleaning up binary store on page navigation...");
    cleanupRegistry.cleanup();
    // Reset store state if needed
    const store = useBinaryStore.getState();
    store.cleanup();
    // Reset initialization flags
    isInitializing = false;
    isInitialized = false;
};
;
}),
"[project]/frontend/store/ai/investment/use-ai-investment-store.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "initializeAiInvestmentStore",
    ()=>initializeAiInvestmentStore,
    "useAiInvestmentStore",
    ()=>useAiInvestmentStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/middleware.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-ssr] (ecmascript)");
;
;
;
const useAiInvestmentStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["devtools"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$middleware$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["persist"])((set, get)=>({
        // Data
        investments: [],
        plans: [],
        // UI state
        isLoadingInvestments: false,
        isLoadingPlans: false,
        selectedPlanId: null,
        selectedDurationId: null,
        investmentAmount: 0,
        apiError: null,
        // Actions
        fetchInvestments: async ()=>{
            try {
                set({
                    isLoadingInvestments: true,
                    apiError: null
                });
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/ai/investment/log",
                    silentSuccess: true
                });
                if (!error) {
                    // Ensure data is an array
                    const investments = Array.isArray(data) ? data : [];
                    set({
                        investments
                    });
                } else {
                    console.error("Failed to fetch AI investments:", error);
                    set({
                        apiError: `Failed to fetch investments: ${error}`
                    });
                }
            } catch (error) {
                const errorMessage = error instanceof Error ? error.message : "Unknown error";
                console.error("Error fetching AI investments:", error);
                set({
                    apiError: `Error fetching investments: ${errorMessage}`
                });
            } finally{
                set({
                    isLoadingInvestments: false
                });
            }
        },
        fetchPlans: async ()=>{
            try {
                set({
                    isLoadingPlans: true,
                    apiError: null
                });
                // Fetch from API
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/ai/investment/plan",
                    silentSuccess: true
                });
                if (!error && data) {
                    // Validate the data structure
                    if (Array.isArray(data)) {
                        set({
                            plans: data
                        });
                        // Select first plan if none selected and plans exist
                        if (data.length > 0 && !get().selectedPlanId) {
                            const firstPlan = data[0];
                            set({
                                selectedPlanId: firstPlan.id,
                                selectedDurationId: firstPlan.durations && firstPlan.durations.length > 0 ? firstPlan.durations[0].id : null
                            });
                        }
                    } else if (typeof data === "object" && data !== null) {
                        // Handle case where data might be an object with plans inside
                        const extractedPlans = data.plans || data.data || [];
                        const plansArray = Array.isArray(extractedPlans) ? extractedPlans : [];
                        console.log("Extracted plans from object:", plansArray);
                        set({
                            plans: plansArray
                        });
                        // Select first plan if none selected and plans exist
                        if (plansArray.length > 0 && !get().selectedPlanId) {
                            const firstPlan = plansArray[0];
                            set({
                                selectedPlanId: firstPlan.id,
                                selectedDurationId: firstPlan.durations && firstPlan.durations.length > 0 ? firstPlan.durations[0].id : null
                            });
                        }
                    } else {
                        // Set empty array and show error if data format is invalid
                        console.warn("Invalid data format from API");
                        set({
                            plans: [],
                            apiError: "Invalid data format from API"
                        });
                    }
                } else {
                    // Set empty array and show error if API fails
                    console.warn("API error or no data:", error);
                    set({
                        plans: [],
                        apiError: `API error: ${error || "No data returned"}`
                    });
                }
            } catch (error) {
                const errorMessage = error instanceof Error ? error.message : "Unknown error";
                console.error("Error fetching AI investment plans:", error);
                // Set empty array and show error
                set({
                    plans: [],
                    apiError: `Error fetching plans: ${errorMessage}`
                });
            } finally{
                set({
                    isLoadingPlans: false
                });
            }
        },
        createInvestment: async (data)=>{
            try {
                set({
                    apiError: null
                });
                const { data: responseData, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/ai/investment/log",
                    method: "POST",
                    body: data
                });
                if (!error) {
                    // Add the new investment to the state
                    set({
                        investments: [
                            responseData,
                            ...get().investments
                        ],
                        // Reset form values
                        investmentAmount: 0
                    });
                    return {
                        success: true,
                        data: responseData
                    };
                } else {
                    set({
                        apiError: `Failed to create investment: ${error}`
                    });
                    return {
                        success: false,
                        error
                    };
                }
            } catch (error) {
                const errorMessage = error instanceof Error ? error.message : "Unknown error";
                console.error("Error creating AI investment:", error);
                set({
                    apiError: `Error creating investment: ${errorMessage}`
                });
                return {
                    success: false,
                    error: errorMessage
                };
            }
        },
        cancelInvestment: async (id)=>{
            try {
                set({
                    apiError: null
                });
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: `/api/ai/investment/log/${id}`,
                    method: "DELETE"
                });
                if (!error) {
                    // Update the investment in the state
                    set({
                        investments: get().investments.map((inv)=>inv.id === id ? {
                                ...inv,
                                status: "CANCELLED"
                            } : inv)
                    });
                    return {
                        success: true
                    };
                } else {
                    set({
                        apiError: `Failed to cancel investment: ${error}`
                    });
                    return {
                        success: false,
                        error
                    };
                }
            } catch (error) {
                const errorMessage = error instanceof Error ? error.message : "Unknown error";
                console.error("Error cancelling AI investment:", error);
                set({
                    apiError: `Error cancelling investment: ${errorMessage}`
                });
                return {
                    success: false,
                    error: errorMessage
                };
            }
        },
        setSelectedPlan: (planId)=>{
            set({
                selectedPlanId: planId
            });
            // If we have a new plan selected, also select its first duration
            if (planId) {
                const { plans } = get();
                const selectedPlan = plans.find((plan)=>plan.id === planId);
                if (selectedPlan && selectedPlan.durations && selectedPlan.durations.length > 0) {
                    set({
                        selectedDurationId: selectedPlan.durations[0].id
                    });
                } else {
                    set({
                        selectedDurationId: null
                    });
                }
            } else {
                set({
                    selectedDurationId: null
                });
            }
        },
        setSelectedDuration: (durationId)=>{
            set({
                selectedDurationId: durationId
            });
        },
        setInvestmentAmount: (amount)=>{
            set({
                investmentAmount: amount
            });
        },
        resetApiError: ()=>{
            set({
                apiError: null
            });
        }
    }), {
    name: "ai-investment-store",
    partialize: (state)=>({
            selectedPlanId: state.selectedPlanId,
            selectedDurationId: state.selectedDurationId
        })
})));
const initializeAiInvestmentStore = async ()=>{
    const store = useAiInvestmentStore.getState();
    try {
        // Fetch initial data
        await store.fetchPlans();
        await store.fetchInvestments();
    } catch (error) {
        console.error("Failed to initialize AI investment store:", error);
    }
};
}),
"[project]/frontend/store/websocket-store.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__,
    "useWebSocketStore",
    ()=>useWebSocketStore
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/zustand@5.0.8_@types+react@_bbde82f838e61da0e2a8e352b1972a61/node_modules/zustand/esm/react.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$websocket$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/websocket-manager.ts [app-ssr] (ecmascript)");
;
;
const createWebSocketConnection = ()=>({
        isConnected: false,
        wsManager: null,
        subscriptions: [],
        subscriptionQueue: [],
        isTypeSubscribed: function(type, payload) {
            return this.subscriptions.some((sub)=>sub.type === type && JSON.stringify(sub.payload) === JSON.stringify(payload));
        }
    });
const useWebSocketStore = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$zustand$40$5$2e$0$2e$8_$40$types$2b$react$40$_bbde82f838e61da0e2a8e352b1972a61$2f$node_modules$2f$zustand$2f$esm$2f$react$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["create"])()((set, get)=>({
        connections: {},
        messageHandlers: {},
        createConnection: async (connectionKey, path, options)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (!path) {
                return Promise.reject("Path is invalid");
            }
            if (connection && connection.isConnected) {
                options?.onOpen?.();
                return Promise.resolve();
            }
            const wsManager = new __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$websocket$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"](path);
            set((state)=>({
                    connections: {
                        ...state.connections,
                        [connectionKey]: {
                            isConnected: false,
                            wsManager,
                            subscriptions: [],
                            subscriptionQueue: [],
                            isTypeSubscribed: createWebSocketConnection().isTypeSubscribed
                        }
                    }
                }));
            wsManager.on("open", ()=>{
                console.log("WebSocket Connected to", path);
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                isConnected: true
                            }
                        }
                    }));
                options?.onOpen?.();
                // Process subscription queue
                const connection = get().connections[connectionKey];
                connection.subscriptionQueue.forEach((sub)=>{
                    wsManager.send({
                        action: "SUBSCRIBE",
                        payload: {
                            type: sub.type,
                            ...sub.payload
                        }
                    });
                });
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                subscriptionQueue: []
                            }
                        }
                    }));
            });
            wsManager.on("close", ()=>{
                console.log("WebSocket Disconnected from", path);
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                isConnected: false
                            }
                        }
                    }));
                options?.onClose?.();
            });
            wsManager.on("error", (error)=>{
                console.error("WebSocket error on", path, ":", error);
                options?.onError?.(error);
            });
            wsManager.on("message", (message)=>{
                const handlers = get().messageHandlers[connectionKey] || [];
                handlers.forEach(({ handler, filter })=>{
                    if (filter(message)) {
                        handler(message);
                    }
                });
                options?.onMessage?.(message);
            });
            wsManager.connect();
        },
        removeConnection: (connectionKey)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (connection && connection.isConnected && connection.wsManager) {
                connection.wsManager.disconnect();
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                isConnected: false,
                                wsManager: null
                            }
                        }
                    }));
            }
        },
        send: (connectionKey, message)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (connection && connection.isConnected && connection.wsManager) {
                connection.wsManager.send(message);
            }
        },
        subscribe: (connectionKey, type, payload)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (!connection) return;
            if (!connection.isTypeSubscribed(type, payload)) {
                const newSubscription = {
                    type,
                    payload
                };
                set((state)=>({
                        connections: {
                            ...state.connections,
                            [connectionKey]: {
                                ...state.connections[connectionKey],
                                subscriptions: [
                                    ...state.connections[connectionKey].subscriptions,
                                    newSubscription
                                ]
                            }
                        }
                    }));
                if (connection.wsManager?.isConnected()) {
                    connection.wsManager.send({
                        action: "SUBSCRIBE",
                        payload: {
                            type,
                            ...payload
                        }
                    });
                } else {
                    set((state)=>({
                            connections: {
                                ...state.connections,
                                [connectionKey]: {
                                    ...state.connections[connectionKey],
                                    subscriptionQueue: [
                                        ...state.connections[connectionKey].subscriptionQueue,
                                        newSubscription
                                    ]
                                }
                            }
                        }));
                }
            }
        },
        unsubscribe: (connectionKey, type, payload)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            if (!connection) return;
            set((state)=>({
                    connections: {
                        ...state.connections,
                        [connectionKey]: {
                            ...state.connections[connectionKey],
                            subscriptions: state.connections[connectionKey].subscriptions.filter((sub)=>sub.type !== type || JSON.stringify(sub.payload) !== JSON.stringify(payload))
                        }
                    }
                }));
            if (connection.wsManager?.isConnected()) {
                connection.wsManager.send({
                    action: "UNSUBSCRIBE",
                    payload: {
                        type,
                        ...payload
                    }
                });
            }
        },
        addMessageHandler: (connectionKey, handler, filter = ()=>true)=>{
            set((state)=>({
                    messageHandlers: {
                        ...state.messageHandlers,
                        [connectionKey]: [
                            ...state.messageHandlers[connectionKey] || [],
                            {
                                handler,
                                filter
                            }
                        ]
                    }
                }));
        },
        removeMessageHandler: (connectionKey, handler)=>{
            set((state)=>({
                    messageHandlers: {
                        ...state.messageHandlers,
                        [connectionKey]: (state.messageHandlers[connectionKey] || []).filter((item)=>item.handler !== handler)
                    }
                }));
        },
        isConnectionOpen: (connectionKey)=>{
            const connections = get().connections;
            const connection = connections[connectionKey];
            return connection?.isConnected || false;
        }
    }));
const __TURBOPACK__default__export__ = useWebSocketStore;
}),
"[project]/frontend/lib/precision-utils.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// Precision utilities for formatting numbers based on market metadata
__turbopack_context__.s([
    "countDecimals",
    ()=>countDecimals,
    "formatAmountWithPrecision",
    ()=>formatAmountWithPrecision,
    "formatCostWithPrecision",
    ()=>formatCostWithPrecision,
    "formatLargeNumberWithPrecision",
    ()=>formatLargeNumberWithPrecision,
    "formatPercentageWithPrecision",
    ()=>formatPercentageWithPrecision,
    "formatPriceWithPrecision",
    ()=>formatPriceWithPrecision,
    "formatVolumeWithPrecision",
    ()=>formatVolumeWithPrecision,
    "getCurrencyPrecision",
    ()=>getCurrencyPrecision,
    "getStepSize",
    ()=>getStepSize,
    "getTradingViewPricescale",
    ()=>getTradingViewPricescale,
    "roundToPrecision",
    ()=>roundToPrecision,
    "validateDecimalPrecision",
    ()=>validateDecimalPrecision
]);
function formatPriceWithPrecision(price, metadata) {
    if (typeof price !== "number" || isNaN(price)) return "0";
    const precision = metadata?.precision?.price || 2;
    return price.toFixed(precision);
}
function formatAmountWithPrecision(amount, metadata) {
    if (typeof amount !== "number" || isNaN(amount)) return "0";
    const precision = metadata?.precision?.amount || 8;
    return amount.toFixed(precision);
}
function formatVolumeWithPrecision(volume, metadata) {
    if (typeof volume !== "number" || isNaN(volume)) return "0";
    // For volume, use amount precision as it represents the base currency
    const precision = metadata?.precision?.amount || 8;
    // For large volumes, use fewer decimals
    if (volume >= 1000) {
        return volume.toFixed(Math.max(0, precision - 4));
    } else if (volume >= 100) {
        return volume.toFixed(Math.max(0, precision - 2));
    } else if (volume >= 10) {
        return volume.toFixed(Math.max(0, precision - 1));
    }
    return volume.toFixed(precision);
}
function formatCostWithPrecision(cost, metadata) {
    if (typeof cost !== "number" || isNaN(cost)) return "0";
    // For cost, use price precision as it represents the quote currency
    const precision = metadata?.precision?.price || 2;
    return cost.toFixed(precision);
}
function formatPercentageWithPrecision(percentage, decimals = 2) {
    if (typeof percentage !== "number" || isNaN(percentage)) return "0.00%";
    return `${percentage.toFixed(decimals)}%`;
}
function formatLargeNumberWithPrecision(num, metadata, type = "amount") {
    if (typeof num !== "number" || isNaN(num)) return "0";
    const precision = type === "price" ? metadata?.precision?.price || 2 : metadata?.precision?.amount || 8;
    if (num >= 1000000000) {
        return (num / 1000000000).toFixed(Math.min(precision, 2)) + "B";
    } else if (num >= 1000000) {
        return (num / 1000000).toFixed(Math.min(precision, 2)) + "M";
    } else if (num >= 1000) {
        return (num / 1000).toFixed(Math.min(precision, 2)) + "K";
    } else {
        return num.toFixed(Math.min(precision, 4));
    }
}
function getTradingViewPricescale(metadata) {
    const precision = metadata?.precision?.price || 2;
    return Math.pow(10, precision);
}
function getStepSize(metadata, type = "price") {
    const precision = type === "price" ? metadata?.precision?.price || 2 : metadata?.precision?.amount || 8;
    return Math.pow(10, -precision);
}
function countDecimals(value) {
    const str = value.toString();
    if (Math.floor(Number(str)) === Number(str)) return 0;
    const scientificNotationMatch = /^(\d+\.?\d*|\.\d+)e([+-]\d+)$/.exec(str);
    if (scientificNotationMatch) {
        const decimalStr = scientificNotationMatch[1].split(".")[1] || "";
        let decimalCount = decimalStr.length + parseInt(scientificNotationMatch[2]);
        decimalCount = Math.abs(decimalCount);
        return Math.min(decimalCount, 8);
    } else {
        const decimalStr = str.split(".")[1] || "";
        return Math.min(decimalStr.length, 8);
    }
}
function getCurrencyPrecision(currency, network) {
    // Default to 8 decimal places - should be fetched from token config in practice
    return 8;
}
function validateDecimalPrecision(amount, precision) {
    const actualDecimals = countDecimals(amount);
    return {
        isValid: actualDecimals <= precision,
        actualDecimals,
        maxDecimals: precision
    };
}
function roundToPrecision(value, metadata, type = "price") {
    const precision = type === "price" ? metadata?.precision?.price || 2 : metadata?.precision?.amount || 8;
    return Math.round(value * Math.pow(10, precision)) / Math.pow(10, precision);
}
}),
"[project]/frontend/lib/websocket-manager.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>WebSocketManager
]);
class WebSocketManager {
    url;
    socket = null;
    reconnectAttempts = 0;
    maxReconnectAttempts = 5;
    reconnectTimeout = 1000;
    eventHandlers = {
        open: [],
        close: [],
        error: [],
        message: []
    };
    constructor(url){
        this.url = url;
    }
    connect() {
        if (this.socket && (this.socket.readyState === WebSocket.OPEN || this.socket.readyState === WebSocket.CONNECTING)) {
            return;
        }
        try {
            this.socket = new WebSocket(this.url);
            this.socket.onopen = (event)=>{
                this.reconnectAttempts = 0;
                this.eventHandlers.open.forEach((handler)=>handler(event));
            };
            this.socket.onclose = (event)=>{
                this.eventHandlers.close.forEach((handler)=>handler(event));
                this.attemptReconnect();
            };
            this.socket.onerror = (event)=>{
                this.eventHandlers.error.forEach((handler)=>handler(event));
            };
            this.socket.onmessage = (event)=>{
                try {
                    const data = JSON.parse(event.data);
                    this.eventHandlers.message.forEach((handler)=>handler(data));
                } catch (error) {
                    console.error("Failed to parse WebSocket message:", error);
                }
            };
        } catch (error) {
            console.error("WebSocket connection error:", error);
            this.attemptReconnect();
        }
    }
    attemptReconnect() {
        if (this.reconnectAttempts < this.maxReconnectAttempts) {
            this.reconnectAttempts++;
            setTimeout(()=>{
                this.connect();
            }, this.reconnectTimeout * this.reconnectAttempts);
        }
    }
    disconnect() {
        if (this.socket) {
            this.socket.close();
            this.socket = null;
        }
    }
    isConnected() {
        return this.socket !== null && this.socket.readyState === WebSocket.OPEN;
    }
    send(data) {
        if (this.isConnected() && this.socket) {
            this.socket.send(typeof data === "string" ? data : JSON.stringify(data));
        } else {
            console.warn("Cannot send message, WebSocket is not connected");
        }
    }
    on(event, handler) {
        if (this.eventHandlers[event]) {
            this.eventHandlers[event].push(handler);
        } else {
            this.eventHandlers[event] = [
                handler
            ];
        }
    }
    off(event, handler) {
        if (this.eventHandlers[event]) {
            this.eventHandlers[event] = this.eventHandlers[event].filter((h)=>h !== handler);
        }
    }
}
}),
];

//# sourceMappingURL=frontend_706e8cbf._.js.map