module.exports = [
"[project]/frontend/components/blocks/advanced-chart/context/chart-state.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useChartState",
    ()=>useChartState
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
;
function useChartState(darkMode) {
    // Refs
    const containerRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const wsRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const reconnectTimeoutRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const isInteractingRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const resizeTimeoutRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const recalcTimeoutRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    // Ref to track previous theme to prevent unnecessary updates
    const prevThemeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(darkMode);
    // Ref to track if component is mounted
    const isMountedRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(true);
    // Chart display state
    const [dimensions, setDimensions] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        width: 0,
        height: 0
    });
    const [mousePosition, setMousePosition] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [isDragging, setIsDragging] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [dragStart, setDragStart] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        x: 0,
        y: 0
    });
    const [visibleRange, setVisibleRange] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        start: 0,
        end: 100
    });
    const [tooltip, setTooltip] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [showVolume, setShowVolume] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(true);
    const [showGrid, setShowGrid] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(true);
    const [priceScaleWidth, setPriceScaleWidth] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(60);
    const [timeScaleHeight, setTimeScaleHeight] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(24);
    const [chartReady, setChartReady] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    // Memoize theme to prevent unnecessary rerenders
    const [theme, setTheme] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(darkMode ? "dark" : "light");
    const [showSettingsPanel, setShowSettingsPanel] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    // Chart features state
    const [chartType, setChartType] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("candlestick");
    const [showIndicatorPanel, setShowIndicatorPanel] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [showDrawingToolbar, setShowDrawingToolbar] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [showVolumeProfile, setShowVolumeProfile] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [showPatternRecognition, setShowPatternRecognition] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [priceAlerts, setPriceAlerts] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])([]);
    // Add these to the state
    const [wsStatus, setWsStatus] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("disconnected");
    const [apiStatus, setApiStatus] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("disconnected");
    const [lastError, setLastError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [reconnectAttempt, setReconnectAttempt] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [reconnectCount, setReconnectCount] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(0);
    // Track if we've already set the theme
    const hasSetThemeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    // Update theme only when darkMode prop changes and only once
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (prevThemeRef.current !== darkMode && !hasSetThemeRef.current) {
            prevThemeRef.current = darkMode;
            setTheme(darkMode ? "dark" : "light");
            hasSetThemeRef.current = true;
        }
    }, [
        darkMode
    ]);
    // Cleanup on unmount
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        return ()=>{
            isMountedRef.current = false;
        };
    }, []);
    // Add a global style to prevent text selection and add theme transition
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const style = document.createElement("style");
        style.innerHTML = `
    .chart-container * {
      user-select: none !important;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }
    
    .chart-container canvas {
      animation: fadeIn 0.3s ease-in-out;
    }
    
    .theme-transition {
      transition: background-color 0.3s ease-in-out;
    }
    
    .chart-container {
      transition: background-color 0.3s ease-in-out;
    }
  `;
        document.head.appendChild(style);
        return ()=>{
            document.head.removeChild(style);
        };
    }, []);
    // Get container dimensions
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!containerRef.current) return;
        const updateDimensions = ()=>{
            if (containerRef.current && isMountedRef.current) {
                const rect = containerRef.current.getBoundingClientRect();
                // Ensure dimensions are never zero
                const width = Math.max(1, rect.width);
                const height = Math.max(1, rect.height);
                if (width !== dimensions.width || height !== dimensions.height) {
                    setDimensions({
                        width,
                        height
                    });
                }
            }
        };
        updateDimensions();
        // Debounced resize handler
        const handleResize = ()=>{
            if (resizeTimeoutRef.current) {
                clearTimeout(resizeTimeoutRef.current);
            }
            resizeTimeoutRef.current = setTimeout(()=>{
                if (isMountedRef.current) {
                    updateDimensions();
                }
            }, 100);
        };
        window.addEventListener("resize", handleResize);
        // Add a resize observer for more responsive updates
        const resizeObserver = new ResizeObserver((entries)=>{
            if (!isMountedRef.current) return;
            for (const entry of entries){
                const { width, height } = entry.contentRect;
                if (width > 0 && height > 0) {
                    setDimensions({
                        width,
                        height
                    });
                }
            }
        });
        if (containerRef.current) {
            resizeObserver.observe(containerRef.current);
        }
        // Force a redraw after a short delay to ensure proper sizing
        const timer = setTimeout(()=>{
            if (isMountedRef.current) {
                updateDimensions();
                setChartReady(true);
            }
        }, 100);
        return ()=>{
            window.removeEventListener("resize", handleResize);
            clearTimeout(timer);
            if (resizeTimeoutRef.current) {
                clearTimeout(resizeTimeoutRef.current);
            }
            if (containerRef.current) {
                resizeObserver.unobserve(containerRef.current);
            }
            resizeObserver.disconnect();
        };
    }, []);
    // Optimize the interval check to run less frequently
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Update dimensions on a regular interval to ensure chart fills available space
        // But only check every 2 seconds instead of every second
        const intervalId = setInterval(()=>{
            if (containerRef.current && isMountedRef.current) {
                const { width, height } = containerRef.current.getBoundingClientRect();
                if (Math.abs(width - dimensions.width) > 5 || Math.abs(height - dimensions.height) > 5) {
                    setDimensions({
                        width,
                        height
                    });
                }
            }
        }, 2000); // Changed from 1000 to 2000ms
        return ()=>clearInterval(intervalId);
    }, [
        dimensions
    ]);
    // Toggle chart features
    const toggleVolume = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (isMountedRef.current) {
            setShowVolume((prev)=>!prev);
        }
    }, []);
    const toggleGrid = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (isMountedRef.current) {
            setShowGrid((prev)=>!prev);
        }
    }, []);
    const toggleVolumeProfile = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (isMountedRef.current) {
            setShowVolumeProfile((prev)=>!prev);
        }
    }, []);
    const togglePatternRecognition = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (isMountedRef.current) {
            setShowPatternRecognition((prev)=>!prev);
        }
    }, []);
    // Memoize the toggleTheme function to prevent unnecessary rerenders
    const toggleTheme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (isMountedRef.current) {
            setTheme((prev)=>{
                const newTheme = prev === "dark" ? "light" : "dark";
                return newTheme;
            });
        }
    }, []);
    // Price alerts
    const addPriceAlert = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((alert)=>{
        if (isMountedRef.current) {
            setPriceAlerts((prev)=>[
                    ...prev,
                    {
                        ...alert,
                        id: Math.random().toString(36).substring(2, 9)
                    }
                ]);
        }
    }, []);
    const removePriceAlert = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((id)=>{
        if (isMountedRef.current) {
            setPriceAlerts((prev)=>prev.filter((alert)=>alert.id !== id));
        }
    }, []);
    // Custom setVisibleRange that marks interaction
    const setVisibleRangeWithInteraction = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((range)=>{
        if (isMountedRef.current) {
            isInteractingRef.current = true;
            setVisibleRange(range);
        }
    }, []);
    return {
        // Refs
        containerRef,
        wsRef,
        reconnectTimeoutRef,
        isInteractingRef,
        resizeTimeoutRef,
        recalcTimeoutRef,
        isMountedRef,
        // State
        dimensions,
        mousePosition,
        isDragging,
        dragStart,
        visibleRange,
        tooltip,
        showVolume,
        showGrid,
        priceScaleWidth,
        timeScaleHeight,
        chartReady,
        theme,
        chartType,
        showIndicatorPanel,
        showDrawingToolbar,
        showVolumeProfile,
        showPatternRecognition,
        priceAlerts,
        showSettingsPanel,
        wsStatus,
        apiStatus,
        lastError,
        reconnectAttempt,
        reconnectCount,
        // Setters
        setDimensions,
        setMousePosition,
        setIsDragging,
        setDragStart,
        setVisibleRange,
        setTooltip,
        setShowVolume,
        setShowGrid,
        setPriceScaleWidth,
        setTimeScaleHeight,
        setChartReady,
        setTheme,
        setChartType,
        setShowIndicatorPanel,
        setShowDrawingToolbar,
        setShowVolumeProfile,
        setShowPatternRecognition,
        setPriceAlerts,
        setShowSettingsPanel,
        setWsStatus,
        setApiStatus,
        setLastError,
        setReconnectAttempt,
        setReconnectCount,
        // Actions
        toggleVolume,
        toggleGrid,
        toggleVolumeProfile,
        togglePatternRecognition,
        toggleTheme,
        addPriceAlert,
        removePriceAlert,
        setVisibleRangeWithInteraction
    };
}
}),
"[project]/frontend/components/blocks/advanced-chart/context/chart-data.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useChartData",
    ()=>useChartData
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$market$2d$data$2d$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/services/market-data-ws.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/trade/use-binary-store.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
// Debug logging
const isProduction = ("TURBOPACK compile-time value", "development") === "production";
const log = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : console.log;
const error = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : console.error;
// Configuration constants
const CONFIG = {
    MIN_API_CALL_INTERVAL: 15000,
    INITIAL_CANDLE_COUNT: 500,
    VISIBLE_CANDLE_COUNT: 100,
    OLDER_DATA_FETCH_COUNT: 200,
    PRICE_UPDATE_THRESHOLD: 0.0001
};
// Timeframe to milliseconds mapping
const TIMEFRAME_MS = {
    "1m": 60 * 1000,
    "3m": 3 * 60 * 1000,
    "5m": 5 * 60 * 1000,
    "15m": 15 * 60 * 1000,
    "30m": 30 * 60 * 1000,
    "1h": 60 * 60 * 1000,
    "2h": 2 * 60 * 60 * 1000,
    "4h": 4 * 60 * 60 * 1000,
    "6h": 6 * 60 * 60 * 1000,
    "8h": 8 * 60 * 60 * 1000,
    "12h": 12 * 60 * 60 * 1000,
    "1d": 24 * 60 * 60 * 1000,
    "3d": 3 * 24 * 60 * 60 * 1000,
    "1w": 7 * 24 * 60 * 60 * 1000,
    "1M": 30 * 24 * 60 * 60 * 1000
};
// Timeframe to API interval mapping
const TIMEFRAME_TO_INTERVAL = {
    "1m": "1m",
    "3m": "3m",
    "5m": "5m",
    "15m": "15m",
    "30m": "30m",
    "1h": "1h",
    "2h": "2h",
    "4h": "4h",
    "6h": "6h",
    "8h": "8h",
    "12h": "12h",
    "1d": "1d",
    "3d": "3d",
    "1w": "1w",
    "1M": "1M"
};
// Utility functions - Using proper base/quote extraction logic
const formatSymbolForAPI = (symbol)=>{
    // Add safety check for undefined/null symbol
    if (!symbol || typeof symbol !== 'string') {
        console.warn("Invalid symbol provided to formatSymbolForAPI:", symbol);
        return "BTC/USDT"; // Default fallback
    }
    // Handle delimiter-based formats first: BTC/USDT, BTC-USDT, BTC_USDT
    if (symbol.includes("/")) {
        return symbol; // Already in API format
    }
    if (symbol.includes("-")) {
        return symbol.replace("-", "/");
    }
    if (symbol.includes("_")) {
        return symbol.replace("_", "/");
    }
    // For symbols without delimiters (like BTCUSDT), use the proper extraction logic
    const baseCurrency = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["extractBaseCurrency"])(symbol);
    const quoteCurrency = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["extractQuoteCurrency"])(symbol);
    return `${baseCurrency}/${quoteCurrency}`;
};
const formatCandleData = (rawData)=>{
    // Add safety checks for invalid data
    if (!Array.isArray(rawData) || rawData.length < 6) {
        console.warn("Invalid candle data received:", rawData);
        const now = Date.now();
        return {
            time: now,
            timestamp: new Date(now).toLocaleTimeString([], {
                hour: "2-digit",
                minute: "2-digit"
            }),
            date: new Date(now).toLocaleDateString([], {
                month: "short",
                day: "numeric"
            }),
            open: 0,
            high: 0,
            low: 0,
            close: 0,
            volume: 0,
            color: "#26a69a"
        };
    }
    const [timestamp, open, high, low, close, volume] = rawData;
    // Ensure all values are valid numbers
    const safeTimestamp = Number(timestamp) || Date.now();
    const safeOpen = Number(open) || 0;
    const safeHigh = Number(high) || 0;
    const safeLow = Number(low) || 0;
    const safeClose = Number(close) || 0;
    const safeVolume = Number(volume) || 0;
    const date = new Date(safeTimestamp);
    const isBullish = safeClose >= safeOpen;
    return {
        time: safeTimestamp,
        timestamp: date.toLocaleTimeString([], {
            hour: "2-digit",
            minute: "2-digit"
        }),
        date: date.toLocaleDateString([], {
            month: "short",
            day: "numeric"
        }),
        open: safeOpen,
        high: safeHigh,
        low: safeLow,
        close: safeClose,
        volume: safeVolume,
        color: isBullish ? "#26a69a" : "#ef5350"
    };
};
const getCurrentCandleTimestamp = (timeFrame)=>{
    const now = Date.now();
    const intervalMs = TIMEFRAME_MS[timeFrame];
    return Math.floor(now / intervalMs) * intervalMs;
};
const shouldUpdateCandle = (existingCandle, newCandle)=>{
    // Check if this is the current candle (more recent timestamp)
    const now = Date.now();
    const isCurrentCandle = Math.abs(newCandle.time - now) < 5 * 60 * 1000; // Within 5 minutes
    // For current candles, use a more sensitive threshold
    const threshold = isCurrentCandle ? 0.000001 : CONFIG.PRICE_UPDATE_THRESHOLD;
    return Math.abs(existingCandle.open - newCandle.open) >= threshold || Math.abs(existingCandle.high - newCandle.high) >= threshold || Math.abs(existingCandle.low - newCandle.low) >= threshold || Math.abs(existingCandle.close - newCandle.close) >= threshold || Math.abs(existingCandle.volume - newCandle.volume) >= threshold || // Always update if the new candle has different OHLC values
    existingCandle.open !== newCandle.open || existingCandle.high !== newCandle.high || existingCandle.low !== newCandle.low || existingCandle.close !== newCandle.close || existingCandle.volume !== newCandle.volume;
};
// Global state for active subscriptions
const activeSubscriptions = new Map();
function useChartData(symbol, timeFrame, onPriceUpdate, state) {
    const { setVisibleRange: setStateVisibleRange, setWsStatus, setApiStatus, setLastError, setReconnectAttempt, isInteractingRef, marketType } = state;
    const [chartState, setChartState] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        candleData: [],
        loading: true,
        error: null,
        lastUpdateTime: 0,
        dataInitialized: false,
        dataReady: false,
        isLoadingOlderData: false,
        hasReachedOldestData: false,
        oldestLoadedTimestamp: null,
        newestLoadedTimestamp: null,
        price: 0
    });
    // Use a ref to track if the component is mounted
    const isMountedRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(true);
    const currentSymbolRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(symbol);
    const currentTimeFrameRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(timeFrame);
    const isInitialLoadRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(true);
    const lastFetchTimeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    const dataCache = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(new Map());
    const visibleRangeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])({
        start: 0,
        end: CONFIG.VISIBLE_CANDLE_COUNT
    });
    const unsubscribeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const subscriptionKeyRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])("");
    // Update refs when props change
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        currentSymbolRef.current = symbol;
        currentTimeFrameRef.current = timeFrame;
    }, [
        symbol,
        timeFrame
    ]);
    // Set mounted flag to true on mount
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        isMountedRef.current = true;
        // Cleanup on unmount
        return ()=>{
            isMountedRef.current = false;
            // Remove from active subscriptions
            if (subscriptionKeyRef.current) {
                activeSubscriptions.delete(subscriptionKeyRef.current);
            }
            if (unsubscribeRef.current) {
                unsubscribeRef.current();
                unsubscribeRef.current = null;
            }
        };
    }, []);
    const getCacheKey = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((sym, tf)=>`${sym}_${tf}`, []);
    const fetchHistoricalData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(async (isInitial = false, isOlderData = false, endTime)=>{
        if (!isMountedRef.current) return false;
        const now = Date.now();
        if (!isInitial && !isOlderData && now - lastFetchTimeRef.current < CONFIG.MIN_API_CALL_INTERVAL) {
            return false;
        }
        try {
            if (isInitial) {
                setChartState((prev)=>({
                        ...prev,
                        loading: true,
                        error: null,
                        dataReady: false
                    }));
                setApiStatus("connecting");
            } else if (isOlderData) {
                setChartState((prev)=>({
                        ...prev,
                        isLoadingOlderData: true
                    }));
            }
            const formattedSymbol = formatSymbolForAPI(currentSymbolRef.current);
            const interval = TIMEFRAME_TO_INTERVAL[currentTimeFrameRef.current];
            const candleCount = isOlderData ? CONFIG.OLDER_DATA_FETCH_COUNT : CONFIG.INITIAL_CANDLE_COUNT;
            const intervalMs = TIMEFRAME_MS[currentTimeFrameRef.current];
            const to = endTime || Date.now();
            const from = to - candleCount * intervalMs;
            const url = new URL("/api/exchange/chart", window.location.origin);
            url.searchParams.set("symbol", formattedSymbol);
            url.searchParams.set("interval", interval);
            url.searchParams.set("from", from.toString());
            url.searchParams.set("to", to.toString());
            url.searchParams.set("duration", intervalMs.toString());
            log(`📊 Fetching ${isOlderData ? "older" : "initial"} OHLCV data:`, {
                symbol: formattedSymbol,
                interval,
                from: new Date(from).toISOString(),
                to: new Date(to).toISOString(),
                count: candleCount
            });
            const response = await fetch(url.toString());
            if (!response.ok) {
                throw new Error(`API error: ${response.status}`);
            }
            const rawData = await response.json();
            // Handle empty data gracefully instead of throwing an error
            if (!Array.isArray(rawData)) {
                throw new Error("Invalid data format received from API");
            }
            // If no data is available, set empty state but don't throw error
            if (rawData.length === 0) {
                log(`📊 No data available for ${formattedSymbol} ${interval}`);
                if (isMountedRef.current) {
                    setChartState((prev)=>({
                            ...prev,
                            candleData: [],
                            loading: false,
                            error: null,
                            dataInitialized: true,
                            dataReady: true,
                            isLoadingOlderData: isOlderData ? false : prev.isLoadingOlderData,
                            oldestLoadedTimestamp: null,
                            newestLoadedTimestamp: null,
                            lastUpdateTime: now,
                            price: 0
                        }));
                    setApiStatus("connected");
                    setLastError(null);
                    lastFetchTimeRef.current = now;
                }
                return true; // Return success even with empty data
            }
            const formattedData = rawData.map(formatCandleData);
            if (isInitial) {
                const currentCandleTime = getCurrentCandleTimestamp(currentTimeFrameRef.current);
                const hasCurrentCandle = formattedData.some((candle)=>candle.time === currentCandleTime);
                if (!hasCurrentCandle && formattedData.length > 0) {
                    const lastCandle = formattedData[formattedData.length - 1];
                    const currentCandle = formatCandleData([
                        currentCandleTime,
                        lastCandle.close,
                        lastCandle.close,
                        lastCandle.close,
                        lastCandle.close,
                        0
                    ]);
                    formattedData.push(currentCandle);
                }
                // Calculate consistent visible range based on timeframe
                const getOptimalCandleCount = (tf)=>{
                    const timeframeCandleCounts = {
                        "1m": 100,
                        "3m": 80,
                        "5m": 70,
                        "15m": 60,
                        "30m": 50,
                        "1h": 48,
                        "2h": 36,
                        "4h": 24,
                        "6h": 20,
                        "8h": 18,
                        "12h": 14,
                        "1d": 30,
                        "3d": 20,
                        "1w": 12,
                        "1M": 12
                    };
                    return timeframeCandleCounts[tf] || 50;
                };
                const optimalCount = getOptimalCandleCount(currentTimeFrameRef.current);
                const visibleCount = Math.min(optimalCount, formattedData.length);
                // Always show the most recent data with 20% future space
                const futureSpace = Math.floor(visibleCount * 0.2);
                const newRange = {
                    start: Math.max(0, formattedData.length - visibleCount + futureSpace),
                    end: formattedData.length + futureSpace
                };
                setStateVisibleRange(newRange);
                visibleRangeRef.current = newRange;
            }
            // Only update state if component is still mounted
            if (isMountedRef.current) {
                setChartState((prev)=>{
                    let newCandleData;
                    if (isInitial) {
                        newCandleData = formattedData;
                    } else if (isOlderData) {
                        const existingTimes = new Set(prev.candleData.map((c)=>c.time));
                        const uniqueOlderData = formattedData.filter((c)=>!existingTimes.has(c.time));
                        newCandleData = [
                            ...uniqueOlderData,
                            ...prev.candleData
                        ].sort((a, b)=>a.time - b.time);
                        const offset = uniqueOlderData.length;
                        if (offset > 0) {
                            setStateVisibleRange((prevRange)=>({
                                    start: prevRange.start + offset,
                                    end: prevRange.end + offset
                                }));
                        }
                    } else {
                        const existingMap = new Map(prev.candleData.map((c)=>[
                                c.time,
                                c
                            ]));
                        formattedData.forEach((newCandle)=>{
                            existingMap.set(newCandle.time, newCandle);
                        });
                        newCandleData = Array.from(existingMap.values()).sort((a, b)=>a.time - b.time);
                    }
                    const oldestTimestamp = newCandleData.length > 0 ? newCandleData[0].time : null;
                    const newestTimestamp = newCandleData.length > 0 ? newCandleData[newCandleData.length - 1].time : null;
                    if (newCandleData.length > 0) {
                        const latestPrice = newCandleData[newCandleData.length - 1].close;
                        onPriceUpdate(latestPrice);
                    }
                    return {
                        ...prev,
                        candleData: newCandleData,
                        loading: false,
                        dataInitialized: true,
                        dataReady: true,
                        isLoadingOlderData: isOlderData ? false : prev.isLoadingOlderData,
                        oldestLoadedTimestamp: oldestTimestamp,
                        newestLoadedTimestamp: newestTimestamp,
                        lastUpdateTime: now,
                        price: newCandleData.length > 0 ? newCandleData[newCandleData.length - 1].close : prev.price
                    };
                });
                const cacheKey = getCacheKey(currentSymbolRef.current, currentTimeFrameRef.current);
                dataCache.current.set(cacheKey, formattedData);
                if (isInitial) {
                    const newRange = {
                        start: Math.max(0, formattedData.length - CONFIG.VISIBLE_CANDLE_COUNT),
                        end: formattedData.length
                    };
                    setStateVisibleRange(newRange);
                    visibleRangeRef.current = newRange;
                }
                setApiStatus("connected");
                setLastError(null);
                lastFetchTimeRef.current = now;
            }
            return true;
        } catch (err) {
            error("❌ Error fetching OHLCV data:", err);
            if (isMountedRef.current) {
                setChartState((prev)=>({
                        ...prev,
                        loading: isInitial ? false : prev.loading,
                        isLoadingOlderData: isOlderData ? false : prev.isLoadingOlderData,
                        error: err.message
                    }));
                setApiStatus("error");
                setLastError(err.message);
            }
            return false;
        }
    }, [
        onPriceUpdate,
        setApiStatus,
        setLastError,
        setStateVisibleRange,
        getCacheKey
    ]);
    // Create a stable callback that doesn't depend on component state
    // This is crucial for WebSocket callbacks that might be called after unmount
    const updateCandleData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((data)=>{
        // Add safety checks for invalid data
        if (!data || typeof data !== 'object') {
            console.warn("Invalid OHLCV data received:", data);
            return;
        }
        // Additional safety check for stream property
        if (!data.stream || typeof data.stream !== 'string') {
            console.warn("Invalid OHLCV stream data received:", data);
            return;
        }
        // Check if data array exists and has content
        if (!Array.isArray(data.data) || data.data.length === 0) {
            console.warn("Empty or invalid OHLCV data array received:", data);
            return;
        }
        // Check if this subscription is still active - use formatted symbol
        const formattedSymbol = formatSymbolForAPI(currentSymbolRef.current);
        const subscriptionKey = `ohlcv:${formattedSymbol}:${currentTimeFrameRef.current}`;
        if (!activeSubscriptions.has(subscriptionKey)) {
            return;
        }
        // Additional validation: ensure the stream matches current symbol
        const expectedStreamPrefix = `ohlcv:${TIMEFRAME_TO_INTERVAL[currentTimeFrameRef.current]}:${formattedSymbol}`;
        const symbolPart = formattedSymbol.replace('/', '');
        const intervalPart = TIMEFRAME_TO_INTERVAL[currentTimeFrameRef.current];
        // Check if the stream is for the correct symbol and interval
        // Handle both formats: ohlcv:interval and ohlcv:interval:symbol
        if (data.stream && typeof data.stream === 'string') {
            const streamParts = data.stream.split(':');
            const streamType = streamParts[0]; // Should be 'ohlcv'
            const streamInterval = streamParts[1]; // Should be the interval
            const streamSymbol = streamParts[2]; // Optional symbol part
            // Validate that it's an OHLCV stream for the correct interval
            if (streamType !== 'ohlcv' || streamInterval !== intervalPart) {
                return;
            }
            // If stream includes symbol, validate it matches
            if (streamSymbol && typeof streamSymbol === 'string' && !streamSymbol.includes(symbolPart)) {
                return;
            }
        }
        try {
            if (data.stream && typeof data.stream === 'string' && data.stream.startsWith("ohlcv:") && Array.isArray(data.data) && data.data.length > 0) {
                data.data.forEach((rawCandle)=>{
                    if (rawCandle.length >= 6) {
                        const newCandle = formatCandleData(rawCandle);
                        // Only update state if component is still mounted
                        if (isMountedRef.current) {
                            setChartState((prev)=>{
                                const existingIndex = prev.candleData.findIndex((c)=>c.time === newCandle.time);
                                let newCandleData;
                                if (existingIndex >= 0) {
                                    const existingCandle = prev.candleData[existingIndex];
                                    if (shouldUpdateCandle(existingCandle, newCandle)) {
                                        newCandleData = [
                                            ...prev.candleData
                                        ];
                                        newCandleData[existingIndex] = newCandle;
                                    } else {
                                        return prev;
                                    }
                                } else {
                                    newCandleData = [
                                        ...prev.candleData,
                                        newCandle
                                    ].sort((a, b)=>a.time - b.time);
                                    if (!isInteractingRef.current) {
                                        setStateVisibleRange((prevRange)=>({
                                                start: prevRange.start + 1,
                                                end: prevRange.end + 1
                                            }));
                                    }
                                }
                                // Always update price
                                onPriceUpdate(newCandle.close);
                                return {
                                    ...prev,
                                    candleData: newCandleData,
                                    lastUpdateTime: Date.now(),
                                    newestLoadedTimestamp: newCandle.time,
                                    price: newCandle.close
                                };
                            });
                        }
                    }
                });
            }
        } catch (err) {
            console.error("❌ Error processing OHLCV data:", err);
        }
    }, [
        onPriceUpdate,
        setStateVisibleRange,
        isInteractingRef
    ]);
    const subscribeToOHLCV = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        // Always unsubscribe from any existing subscription first
        if (unsubscribeRef.current) {
            unsubscribeRef.current();
            unsubscribeRef.current = null;
        }
        // Clear any existing subscription key
        if (subscriptionKeyRef.current) {
            activeSubscriptions.delete(subscriptionKeyRef.current);
        }
        const formattedSymbol = formatSymbolForAPI(currentSymbolRef.current);
        const interval = TIMEFRAME_TO_INTERVAL[currentTimeFrameRef.current];
        // Create a unique subscription key using formatted symbol
        const subscriptionKey = `ohlcv:${formattedSymbol}:${interval}`;
        subscriptionKeyRef.current = subscriptionKey;
        log("📡 Subscribing to OHLCV stream:", {
            symbol: formattedSymbol,
            interval,
            subscriptionKey
        });
        // Mark this subscription as active
        activeSubscriptions.set(subscriptionKey, true);
        setWsStatus("connecting");
        setReconnectAttempt(true);
        // Use the stable callback that doesn't depend on component state
        const unsubscribe = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$market$2d$data$2d$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["marketDataWs"].subscribe({
            symbol: formattedSymbol,
            type: "ohlcv",
            marketType,
            interval: interval
        }, updateCandleData);
        unsubscribeRef.current = ()=>{
            log("🔌 Chart Data: Unsubscribing from OHLCV stream:", subscriptionKey);
            activeSubscriptions.delete(subscriptionKey);
            unsubscribe();
        };
        const statusUnsubscribe = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$market$2d$data$2d$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["marketDataWs"].subscribeToConnectionStatus((status)=>{
            if (isMountedRef.current) {
                log("📡 OHLCV WebSocket status:", status);
                setWsStatus(status === "connected" ? "connected" : status === "connecting" ? "connecting" : "disconnected");
                setReconnectAttempt(status === "connecting" || status === "reconnecting");
            }
        }, "spot");
        return ()=>{
            activeSubscriptions.delete(subscriptionKey);
            unsubscribe();
            statusUnsubscribe();
        };
    }, [
        updateCandleData,
        setWsStatus,
        setReconnectAttempt
    ]);
    // Direct timeframe change function - this is what we'll expose
    const changeTimeFrameDirectly = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(async (newTimeFrame)=>{
        log("🔄 Direct timeframe change to:", newTimeFrame);
        // Update the timeframe ref immediately
        currentTimeFrameRef.current = newTimeFrame;
        // 1. Unsubscribe from current stream
        if (unsubscribeRef.current) {
            log("🔌 Unsubscribing from current stream");
            unsubscribeRef.current();
            unsubscribeRef.current = null;
        }
        // Clear subscription tracking
        if (subscriptionKeyRef.current) {
            activeSubscriptions.delete(subscriptionKeyRef.current);
            subscriptionKeyRef.current = "";
        }
        // 2. Clear current data immediately
        log("🧹 Clearing chart data for new timeframe");
        setChartState((prev)=>({
                ...prev,
                candleData: [],
                loading: true,
                error: null,
                dataInitialized: false,
                dataReady: false,
                oldestLoadedTimestamp: null,
                newestLoadedTimestamp: null,
                hasReachedOldestData: false,
                price: 0
            }));
        // 3. Clear cache for this timeframe
        const cacheKey = getCacheKey(currentSymbolRef.current, newTimeFrame);
        dataCache.current.delete(cacheKey);
        // 4. Reset visible range to default for consistency
        const defaultRange = {
            start: 0,
            end: CONFIG.VISIBLE_CANDLE_COUNT
        };
        setStateVisibleRange(defaultRange);
        visibleRangeRef.current = defaultRange;
        // 5. Fetch new data with new timeframe
        log("📡 Fetching data for new timeframe:", newTimeFrame);
        const success = await fetchHistoricalData(true);
        // 6. Subscribe to new stream
        if (success && isMountedRef.current) {
            log("✅ Data fetched, subscribing to new stream");
            setTimeout(subscribeToOHLCV, 500);
        }
        return success;
    }, [
        fetchHistoricalData,
        subscribeToOHLCV,
        getCacheKey,
        setStateVisibleRange
    ]);
    const fetchOlderData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(async ()=>{
        if (chartState.isLoadingOlderData || chartState.hasReachedOldestData || !chartState.oldestLoadedTimestamp) {
            return;
        }
        const success = await fetchHistoricalData(false, true, chartState.oldestLoadedTimestamp);
        if (!success && isMountedRef.current) {
            setChartState((prev)=>({
                    ...prev,
                    hasReachedOldestData: true
                }));
        }
    }, [
        chartState.isLoadingOlderData,
        chartState.hasReachedOldestData,
        chartState.oldestLoadedTimestamp,
        fetchHistoricalData
    ]);
    // Market switching cleanup effect
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleMarketSwitchingCleanup = (event)=>{
            const { oldSymbol, newSymbol, oldMarketType, newMarketType } = event.detail;
            // Clean up subscriptions for old symbol
            if (unsubscribeRef.current) {
                unsubscribeRef.current();
                unsubscribeRef.current = null;
            }
            // Clear subscription tracking
            if (subscriptionKeyRef.current) {
                activeSubscriptions.delete(subscriptionKeyRef.current);
                subscriptionKeyRef.current = "";
            }
            // Clear all cached data to prevent contamination
            dataCache.current.clear();
            // Reset chart state completely
            if (isMountedRef.current) {
                setChartState({
                    candleData: [],
                    loading: true,
                    error: null,
                    lastUpdateTime: 0,
                    dataInitialized: false,
                    dataReady: false,
                    isLoadingOlderData: false,
                    hasReachedOldestData: false,
                    oldestLoadedTimestamp: null,
                    newestLoadedTimestamp: null,
                    price: 0,
                    marketType: newMarketType
                });
            }
        };
        // Listen for market switching cleanup events
        window.addEventListener('market-switching-cleanup', handleMarketSwitchingCleanup);
        return ()=>{
            window.removeEventListener('market-switching-cleanup', handleMarketSwitchingCleanup);
        };
    }, []);
    // Initial load effect - only for symbol changes and first load
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!symbol || !timeFrame) return;
        const symbolChanged = currentSymbolRef.current !== symbol;
        const isFirstLoad = isInitialLoadRef.current;
        if (symbolChanged || isFirstLoad) {
            log("🔄 Initial load for", symbol, timeFrame, {
                symbolChanged,
                isFirstLoad
            });
            // Always unsubscribe from previous subscription when changing symbol
            if (unsubscribeRef.current) {
                unsubscribeRef.current();
                unsubscribeRef.current = null;
            }
            // Clear subscription key when changing
            if (subscriptionKeyRef.current) {
                activeSubscriptions.delete(subscriptionKeyRef.current);
                subscriptionKeyRef.current = "";
            }
            // Clear data when symbol changes
            if (symbolChanged) {
                log("🧹 Clearing chart data due to symbol change");
                setChartState((prev)=>({
                        ...prev,
                        candleData: [],
                        loading: true,
                        error: null,
                        dataInitialized: false,
                        dataReady: false,
                        oldestLoadedTimestamp: null,
                        newestLoadedTimestamp: null,
                        hasReachedOldestData: false,
                        price: 0
                    }));
            }
            // Update current refs
            currentSymbolRef.current = symbol;
            currentTimeFrameRef.current = timeFrame;
            const cacheKey = getCacheKey(symbol, timeFrame);
            const cachedData = dataCache.current.get(cacheKey);
            if (cachedData && cachedData.length > 0 && !symbolChanged) {
                log("📦 Using cached OHLCV data");
                setChartState((prev)=>({
                        ...prev,
                        candleData: cachedData,
                        loading: false,
                        dataInitialized: true,
                        dataReady: true,
                        oldestLoadedTimestamp: cachedData[0].time,
                        newestLoadedTimestamp: cachedData[cachedData.length - 1].time,
                        price: cachedData[cachedData.length - 1].close
                    }));
                const newRange = {
                    start: Math.max(0, cachedData.length - CONFIG.VISIBLE_CANDLE_COUNT),
                    end: cachedData.length
                };
                setStateVisibleRange(newRange);
                setTimeout(subscribeToOHLCV, 500);
            } else {
                log("📡 Fetching fresh historical data");
                fetchHistoricalData(true).then((success)=>{
                    if (success && isMountedRef.current) {
                        log("✅ Historical data fetched, subscribing to OHLCV stream");
                        setTimeout(subscribeToOHLCV, 1000);
                    }
                });
            }
            isInitialLoadRef.current = false;
        }
    }, [
        symbol,
        subscribeToOHLCV,
        fetchHistoricalData,
        getCacheKey,
        setStateVisibleRange
    ]);
    const refreshData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        const now = Date.now();
        if (now - lastFetchTimeRef.current < CONFIG.MIN_API_CALL_INTERVAL) {
            const waitTime = Math.ceil((CONFIG.MIN_API_CALL_INTERVAL - (now - lastFetchTimeRef.current)) / 1000);
            setLastError(`Please wait ${waitTime} more seconds before refreshing.`);
            return;
        }
        if (unsubscribeRef.current) {
            unsubscribeRef.current();
            unsubscribeRef.current = null;
        }
        fetchHistoricalData(false).then((success)=>{
            if (success && isMountedRef.current) {
                setTimeout(subscribeToOHLCV, 1000);
            }
        });
    }, [
        fetchHistoricalData,
        subscribeToOHLCV,
        setLastError
    ]);
    const clearCurrentData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (unsubscribeRef.current) {
            unsubscribeRef.current();
            unsubscribeRef.current = null;
        }
        if (isMountedRef.current) {
            setChartState({
                candleData: [],
                loading: false,
                error: null,
                lastUpdateTime: 0,
                dataInitialized: false,
                dataReady: false,
                isLoadingOlderData: false,
                hasReachedOldestData: false,
                oldestLoadedTimestamp: null,
                newestLoadedTimestamp: null,
                price: 0
            });
        }
        dataCache.current.clear();
    }, []);
    return {
        candleData: chartState.candleData,
        loading: chartState.loading,
        error: chartState.error,
        refreshData,
        setGlobalCandleData: (data)=>{
            if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
            ;
        },
        fetchOlderData,
        requestOlderData: fetchOlderData,
        isLoadingOlderData: chartState.isLoadingOlderData,
        hasReachedOldestData: chartState.hasReachedOldestData,
        timeFrame,
        oldestLoadedTimestamp: chartState.oldestLoadedTimestamp,
        newestLoadedTimestamp: chartState.newestLoadedTimestamp,
        viewportCandleCapacity: CONFIG.VISIBLE_CANDLE_COUNT,
        calculateViewportCapacity: ()=>{},
        dataReady: chartState.dataReady,
        shouldFetchOlderData: ()=>!chartState.isLoadingOlderData && !chartState.hasReachedOldestData,
        isMarketSwitching: chartState.loading && !chartState.dataInitialized,
        clearSymbolCache: (sym)=>{
            const keysToDelete = Array.from(dataCache.current.keys()).filter((key)=>key.startsWith(sym));
            keysToDelete.forEach((key)=>dataCache.current.delete(key));
        },
        clearCurrentData,
        price: chartState.price,
        saveCurrentVisibleRange: (range)=>{
            visibleRangeRef.current = range;
        },
        getCurrentVisibleRange: (dataLength)=>{
            if (visibleRangeRef.current.end <= dataLength) {
                return visibleRangeRef.current;
            }
            return {
                start: Math.max(0, dataLength - CONFIG.VISIBLE_CANDLE_COUNT),
                end: dataLength
            };
        },
        // Expose the direct timeframe change function
        changeTimeFrameDirectly
    };
}
}),
"[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "calculateCandlesNeeded",
    ()=>calculateCandlesNeeded,
    "calculateStartTime",
    ()=>calculateStartTime,
    "currentPriceRange",
    ()=>currentPriceRange,
    "formatDate",
    ()=>formatDate,
    "formatKlineData",
    ()=>formatKlineData,
    "formatLargeNumber",
    ()=>formatLargeNumber,
    "formatPrice",
    ()=>formatPrice,
    "formatTime",
    ()=>formatTime,
    "formatTimeLabel",
    ()=>formatTimeLabel,
    "getIntervalMs",
    ()=>getIntervalMs,
    "getIntervalString",
    ()=>getIntervalString,
    "getVisibleDataWithBuffer",
    ()=>getVisibleDataWithBuffer,
    "globalCandleData",
    ()=>globalCandleData,
    "priceToY",
    ()=>priceToY,
    "renderTopBlurGradient",
    ()=>renderTopBlurGradient,
    "resetZoom",
    ()=>resetZoom,
    "setGlobalCandleData",
    ()=>setGlobalCandleData,
    "yToPrice",
    ()=>yToPrice,
    "zoomIn",
    ()=>zoomIn,
    "zoomOut",
    ()=>zoomOut
]);
// Import time functions from the new location
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/time-sync.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$precision$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/precision-utils.ts [app-ssr] (ecmascript)");
;
;
// Global reference to candleData for time-based slicing
let globalCandleData = [];
const currentPriceRange = {
    min: 0,
    max: 0
};
function formatPrice(price, metadata) {
    if (typeof price !== "number") return "0.00";
    // Use metadata precision if available
    if (metadata) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$precision$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["formatPriceWithPrecision"])(price, metadata);
    }
    // Fallback to original logic
    if (price >= 1000) {
        return price.toFixed(2);
    } else if (price >= 100) {
        return price.toFixed(3);
    } else if (price >= 10) {
        return price.toFixed(4);
    } else if (price >= 1) {
        return price.toFixed(5);
    } else {
        // For very small numbers, use scientific notation
        return price.toFixed(8);
    }
}
function formatLargeNumber(num) {
    if (typeof num !== "number") return "0";
    if (num >= 1000000000) {
        return (num / 1000000000).toFixed(1) + "B";
    } else if (num >= 1000000) {
        return (num / 1000000).toFixed(1) + "M";
    } else if (num >= 1000) {
        return (num / 1000).toFixed(1) + "K";
    } else {
        return num.toFixed(0);
    }
}
function formatDate(timestamp) {
    const date = new Date(timestamp * 1000);
    return date.toLocaleDateString();
}
function formatTime(timestamp) {
    const date = new Date(timestamp * 1000);
    return date.toLocaleTimeString([], {
        hour: "2-digit",
        minute: "2-digit"
    });
}
function formatKlineData(data) {
    return data.map((kline)=>{
        const time = Math.floor(kline[0] / 1000); // Binance timestamp is in milliseconds
        const date = new Date(kline[0]);
        const open = Number.parseFloat(kline[1]);
        const high = Number.parseFloat(kline[2]);
        const low = Number.parseFloat(kline[3]);
        const close = Number.parseFloat(kline[4]);
        const volume = Number.parseFloat(kline[5]);
        const isBullish = close >= open;
        return {
            time,
            timestamp: date.toLocaleTimeString([], {
                hour: "2-digit",
                minute: "2-digit"
            }),
            date: date.toLocaleDateString([], {
                month: "short",
                day: "numeric"
            }),
            open,
            high,
            low,
            close,
            volume,
            color: isBullish ? "#22c55e" : "#ef4444"
        };
    });
}
function getIntervalString(timeFrame) {
    const intervals = {
        "1m": "1m",
        "5m": "5m",
        "15m": "15m",
        "1h": "1h",
        "4h": "4h",
        "1d": "1d"
    };
    return intervals[timeFrame] || "1m";
}
function getIntervalMs(interval) {
    const unit = interval.slice(-1);
    const value = Number.parseInt(interval.slice(0, -1));
    switch(unit){
        case "m":
            return value * 60 * 1000;
        case "h":
            return value * 60 * 60 * 1000;
        case "d":
            return value * 24 * 60 * 60 * 1000;
        case "w":
            return value * 7 * 24 * 60 * 60 * 1000;
        default:
            return 60 * 1000; // Default to 1m
    }
}
function calculateCandlesNeeded(startTime, endTime, timeFrame) {
    const intervalMs = getIntervalMs(timeFrame);
    const timeRangeMs = endTime - startTime;
    return Math.ceil(timeRangeMs / intervalMs);
}
function calculateStartTime(endTime, candleCount, timeFrame) {
    const intervalMs = getIntervalMs(timeFrame);
    return endTime - candleCount * intervalMs;
}
function setGlobalCandleData(data) {
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
    globalCandleData = data;
}
function priceToY(price, candleData, visibleRange, dimensions, timeScaleHeight) {
    if (candleData.length === 0) return 0;
    // Calculate visible data
    const start = Math.max(0, Math.floor(visibleRange.start));
    const end = Math.min(candleData.length, Math.ceil(visibleRange.end));
    const visibleData = candleData.slice(start, end);
    if (visibleData.length === 0) return 0;
    // Calculate price range with padding
    let minPrice = Math.min(...visibleData.map((d)=>d.low));
    let maxPrice = Math.max(...visibleData.map((d)=>d.high));
    const priceRange = maxPrice - minPrice;
    const pricePadding = priceRange * 0.1;
    minPrice = Math.max(0, minPrice - pricePadding);
    maxPrice = maxPrice + pricePadding;
    const chartHeight = dimensions.height * 0.8 - timeScaleHeight;
    return (maxPrice - price) / (maxPrice - minPrice) * chartHeight;
}
function yToPrice(y, candleData, visibleRange, dimensions, timeScaleHeight) {
    if (candleData.length === 0) return 0;
    // Calculate visible data
    const start = Math.max(0, Math.floor(visibleRange.start));
    const end = Math.min(candleData.length, Math.ceil(visibleRange.end));
    const visibleData = candleData.slice(start, end);
    if (visibleData.length === 0) return 0;
    // Calculate price range with padding
    let minPrice = Math.min(...visibleData.map((d)=>d.low));
    let maxPrice = Math.max(...visibleData.map((d)=>d.high));
    const priceRange = maxPrice - minPrice;
    const pricePadding = priceRange * 0.1;
    minPrice = Math.max(0, minPrice - pricePadding);
    maxPrice = maxPrice + pricePadding;
    const chartHeight = dimensions.height * 0.8 - timeScaleHeight;
    return maxPrice - y / chartHeight * (maxPrice - minPrice);
}
function zoomIn(visibleRange, isInteractingRef, setVisibleRange) {
    isInteractingRef.current = true;
    const visibleCount = visibleRange.end - visibleRange.start;
    // Calculate zoom center (middle of current view)
    const center = (visibleRange.start + visibleRange.end) / 2;
    // Use a larger zoom factor for more immediate response
    const zoomFactor = 0.7; // Zoom in by 30% for more immediate effect
    // Reduce the minimum visible candles from 10 to 5 to allow more zoom
    const newVisibleCount = Math.max(5, visibleCount * zoomFactor);
    // Calculate new start and end while keeping the center point fixed
    const newStart = center - newVisibleCount / 2;
    const newEnd = center + newVisibleCount / 2;
    // Update the visible range directly
    setVisibleRange({
        start: newStart,
        end: newEnd
    });
    // Force an immediate render by dispatching a custom event
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
}
function zoomOut(visibleRange, candleData, isInteractingRef, setVisibleRange) {
    isInteractingRef.current = true;
    const visibleCount = visibleRange.end - visibleRange.start;
    // Calculate zoom center (middle of current view)
    const center = (visibleRange.start + visibleRange.end) / 2;
    // Use a larger zoom factor for more immediate response
    const zoomFactor = 1.4; // Zoom out by 40% for more immediate effect
    const newVisibleCount = Math.min(candleData.length * 1.2, visibleCount * zoomFactor);
    // Calculate new start and end while keeping the center point fixed
    const newStart = center - newVisibleCount / 2;
    const newEnd = center + newVisibleCount / 2;
    // Update the visible range directly
    setVisibleRange({
        start: newStart,
        end: newEnd
    });
    // Force an immediate render by dispatching a custom event
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
}
function resetZoom(candleData, setVisibleRange) {
    if (candleData.length > 0) {
        setVisibleRange({
            start: Math.max(0, candleData.length - 100),
            end: candleData.length
        });
        // Force an immediate render
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
    }
}
;
function formatTimeLabel(timestamp) {
    try {
        const date = new Date(timestamp);
        // For timestamps that are valid dates
        if (!isNaN(date.getTime())) {
            // Format: HH:MM
            return date.toLocaleTimeString([], {
                hour: "2-digit",
                minute: "2-digit"
            });
        }
        // Fallback for invalid timestamps
        return "";
    } catch (error) {
        console.error("Error formatting time label:", error);
        return "";
    }
}
function getVisibleDataWithBuffer(data, visibleRange) {
    // If visibleRange is undefined, use the entire dataset
    if (!visibleRange) {
        return data;
    }
    // Calculate visible data - ONLY process what's in view and exists
    const start = Math.max(0, Math.floor(visibleRange.start));
    const end = Math.min(data.length, Math.ceil(visibleRange.end));
    // If there's no data in the visible range, return empty array
    if (start >= end) return [];
    // Add a buffer to prevent popping at edges (load a bit more data than visible)
    const bufferSize = Math.min(20, Math.floor((end - start) * 0.1)); // 10% buffer or max 20 candles
    const bufferedStart = Math.max(0, start - bufferSize);
    const bufferedEnd = Math.min(data.length, end + bufferSize);
    const bufferedVisibleData = data.slice(bufferedStart, bufferedEnd);
    return bufferedVisibleData;
}
function renderTopBlurGradient(ctx, chartWidth, chartHeight, chartTop) {
    // Save the current context state
    ctx.save();
    // Create a gradient from top to bottom
    const gradientHeight = 120; // Height of the gradient effect
    const gradient = ctx.createLinearGradient(0, chartTop, 0, chartTop + gradientHeight);
    // Add color stops for a dark gradient that fades out
    gradient.addColorStop(0, "rgba(19, 23, 34, 0.8)"); // Darkest at the top
    gradient.addColorStop(0.5, "rgba(19, 23, 34, 0.4)"); // Medium in the middle
    gradient.addColorStop(1, "rgba(19, 23, 34, 0)"); // Transparent at the bottom
    // Fill the gradient area
    ctx.fillStyle = gradient;
    ctx.fillRect(0, chartTop, chartWidth, gradientHeight);
    // Restore the context state
    ctx.restore();
}
;
}),
"[project]/frontend/components/blocks/advanced-chart/context/chart-interactions.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useChartInteractions",
    ()=>useChartInteractions
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
"use client";
;
;
function useChartInteractions(state, dataHooks) {
    const { visibleRange, setVisibleRange, isInteractingRef, dimensions, priceScaleWidth, timeScaleHeight } = state;
    const { candleData, dataReady } = dataHooks;
    // Convert price to Y coordinate - only when data is ready
    const priceToYCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((price)=>{
        if (!dataReady) return 0;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["priceToY"])(price, candleData, visibleRange, dimensions, timeScaleHeight);
    }, [
        candleData,
        visibleRange,
        dimensions,
        timeScaleHeight,
        dataReady
    ]);
    // Convert Y coordinate to price - only when data is ready
    const yToPriceCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((y)=>{
        if (!dataReady) return 0;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["yToPrice"])(y, candleData, visibleRange, dimensions, timeScaleHeight);
    }, [
        candleData,
        visibleRange,
        dimensions,
        timeScaleHeight,
        dataReady
    ]);
    // Improve the zoom functions to be more responsive
    const zoomInCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["zoomIn"])(visibleRange, isInteractingRef, setVisibleRange);
    }, [
        visibleRange,
        setVisibleRange,
        isInteractingRef
    ]);
    const zoomOutCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["zoomOut"])(visibleRange, candleData, isInteractingRef, setVisibleRange);
    }, [
        visibleRange,
        candleData,
        isInteractingRef,
        setVisibleRange
    ]);
    const resetZoomCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["resetZoom"])(candleData, setVisibleRange);
    }, [
        candleData,
        setVisibleRange
    ]);
    return {
        priceToY: priceToYCallback,
        yToPrice: yToPriceCallback,
        resetZoom: resetZoomCallback,
        zoomIn: zoomInCallback,
        zoomOut: zoomOutCallback
    };
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/sma.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "SMAIndicator",
    ()=>SMAIndicator,
    "calculateSMA",
    ()=>calculateSMA
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$line$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__LineChart$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-line.js [app-ssr] (ecmascript) <export default as LineChart>");
"use client";
;
function calculateSMA(data, params) {
    const period = Number(params.period);
    const source = String(params.source);
    const result = [];
    // Fill with nulls for the first (period-1) points
    for(let i = 0; i < period - 1; i++){
        result.push(Number.NaN);
    }
    // Calculate SMA for the rest of the points
    for(let i = period - 1; i < data.length; i++){
        let sum = 0;
        for(let j = 0; j < period; j++){
            const value = data[i - j][source];
            if (typeof value === "number") {
                sum += value;
            }
        }
        result.push(sum / period);
    }
    return result;
}
const SMAIndicator = {
    defaultSettings: {
        id: "sma-default",
        type: "sma",
        name: "SMA",
        description: "Simple Moving Average",
        params: {
            period: 20,
            source: "close"
        },
        visible: false,
        color: "#3b82f6",
        lineStyle: "solid",
        separatePanel: false,
        category: "trend"
    },
    calculate: calculateSMA,
    render: (ctx, indicator, data, chartWidth, chartHeight, chartTop, priceRange)=>{
        if (!indicator.data || indicator.data.length === 0) return;
        const { min, max } = priceRange;
        const range = max - min;
        ctx.strokeStyle = indicator.color;
        ctx.lineWidth = 1.5;
        // Set line style
        if (indicator.lineStyle === "dashed") {
            ctx.setLineDash([
                5,
                3
            ]);
        } else if (indicator.lineStyle === "dotted") {
            ctx.setLineDash([
                2,
                2
            ]);
        } else {
            ctx.setLineDash([]);
        }
        ctx.beginPath();
        const barWidth = chartWidth / data.length;
        let firstPoint = true;
        for(let i = 0; i < indicator.data.length; i++){
            const value = indicator.data[i];
            if (isNaN(value)) continue;
            const x = i * barWidth + barWidth / 2;
            const y = chartTop + chartHeight - (value - min) / range * chartHeight;
            if (firstPoint) {
                ctx.moveTo(x, y);
                firstPoint = false;
            } else {
                ctx.lineTo(x, y);
            }
        }
        ctx.stroke();
        ctx.setLineDash([]); // Reset line style
    },
    getSettings: ()=>[
            {
                name: "period",
                label: "Period",
                type: "number",
                min: 1,
                max: 200,
                step: 1,
                default: 20
            },
            {
                name: "source",
                label: "Source",
                type: "select",
                default: "close",
                options: [
                    {
                        value: "close",
                        label: "Close"
                    },
                    {
                        value: "open",
                        label: "Open"
                    },
                    {
                        value: "high",
                        label: "High"
                    },
                    {
                        value: "low",
                        label: "Low"
                    },
                    {
                        value: "hl2",
                        label: "HL2"
                    },
                    {
                        value: "hlc3",
                        label: "HLC3"
                    },
                    {
                        value: "ohlc4",
                        label: "OHLC4"
                    }
                ]
            }
        ],
    icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$line$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__LineChart$3e$__["LineChart"],
    getLightThemeColor: ()=>"#2563eb",
    getDarkThemeColor: ()=>"#3b82f6"
};
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/rsi.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "RSIIndicator",
    ()=>RSIIndicator,
    "calculateRSI",
    ()=>calculateRSI
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$activity$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Activity$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/activity.js [app-ssr] (ecmascript) <export default as Activity>");
"use client";
;
function calculateRSI(data, params) {
    const period = typeof params.period === "number" ? params.period : 14;
    const source = typeof params.source === "string" ? params.source : "close";
    const result = [];
    if (data.length < period + 1) {
        return Array(data.length).fill(50);
    }
    // Calculate price changes
    const changes = [];
    for(let i = 1; i < data.length; i++){
        const currentPrice = data[i][source];
        const previousPrice = data[i - 1][source];
        changes.push(currentPrice - previousPrice);
    }
    // Calculate initial average gain and loss
    let avgGain = 0;
    let avgLoss = 0;
    for(let i = 0; i < period; i++){
        if (changes[i] > 0) {
            avgGain += changes[i];
        } else {
            avgLoss += Math.abs(changes[i]);
        }
    }
    avgGain /= period;
    avgLoss /= period;
    // Calculate RSI for the first point
    let rs = avgGain / (avgLoss || 1); // Avoid division by zero
    let rsi = 100 - 100 / (1 + rs);
    // Fill in initial values with 50 (neutral)
    for(let i = 0; i < period; i++){
        result.push(50);
    }
    result.push(rsi);
    // Calculate RSI for the rest of the points using smoothed method
    for(let i = period + 1; i < changes.length; i++){
        const change = changes[i];
        const gain = change > 0 ? change : 0;
        const loss = change < 0 ? Math.abs(change) : 0;
        avgGain = (avgGain * (period - 1) + gain) / period;
        avgLoss = (avgLoss * (period - 1) + loss) / period;
        rs = avgGain / (avgLoss || 1); // Avoid division by zero
        rsi = 100 - 100 / (1 + rs);
        result.push(rsi);
    }
    // Make sure the result array has the same length as the input data array
    if (result.length < data.length) {
        // Duplicate the last RSI value so result.length === data.length
        result.push(result[result.length - 1]);
    }
    return result;
}
const RSIIndicator = {
    defaultSettings: {
        id: "rsi-default",
        type: "rsi",
        name: "RSI",
        description: "Relative Strength Index",
        params: {
            period: 14,
            source: "close"
        },
        visible: false,
        color: "#8b5cf6",
        lineStyle: "solid",
        separatePanel: true,
        category: "momentum"
    },
    calculate: calculateRSI,
    renderPanel: (ctx, indicator, data, chartWidth, chartHeight, chartTop, priceScaleWidth, isDarkTheme, globalCandleData, visibleRange, totalVisibleRange, startOffset)=>{
        if (!indicator.data || indicator.data.length === 0) return;
        const { start, end } = visibleRange;
        const visibleData = indicator.data.slice(start, end + 1);
        if (visibleData.length === 0) return;
        // Set styles based on theme
        const textColor = isDarkTheme ? "rgba(255, 255, 255, 0.8)" : "rgba(0, 0, 0, 0.8)";
        const gridColor = isDarkTheme ? "rgba(255, 255, 255, 0.1)" : "rgba(0, 0, 0, 0.1)";
        const lineColor = indicator.color || (isDarkTheme ? "#8b5cf6" : "#7c3aed");
        // Draw panel background - transparent
        ctx.fillStyle = isDarkTheme ? "rgba(0, 0, 0, 0.5)" : "rgba(255, 255, 255, 0.5)";
        ctx.fillRect(0, chartTop, chartWidth, chartHeight);
        // Draw overbought zone (70-100)
        ctx.fillStyle = isDarkTheme ? "rgba(255, 50, 50, 0.1)" : "rgba(255, 50, 50, 0.1)";
        const overboughtY = chartTop + chartHeight * 0.3; // 70% from bottom = 30% from top
        ctx.fillRect(0, chartTop, chartWidth, overboughtY - chartTop);
        // Draw oversold zone (0-30)
        ctx.fillStyle = isDarkTheme ? "rgba(50, 255, 50, 0.1)" : "rgba(50, 255, 50, 0.1)";
        const oversoldY = chartTop + chartHeight * 0.7; // 30% from bottom = 70% from top
        ctx.fillRect(0, oversoldY, chartWidth, chartTop + chartHeight - oversoldY);
        // Draw horizontal grid lines for RSI at 30, 50, and 70 levels
        const levels = [
            30,
            50,
            70
        ];
        levels.forEach((level)=>{
            const y = chartTop + chartHeight - level / 100 * chartHeight;
            // Draw grid line
            ctx.beginPath();
            ctx.strokeStyle = level === 50 ? isDarkTheme ? "rgba(255, 255, 255, 0.15)" : "rgba(0, 0, 0, 0.15)" : level === 70 ? isDarkTheme ? "rgba(255, 100, 100, 0.3)" : "rgba(255, 0, 0, 0.2)" : isDarkTheme ? "rgba(100, 255, 100, 0.3)" : "rgba(0, 255, 0, 0.2)";
            ctx.lineWidth = 1;
            // Use dashed line for 50 level
            if (level === 50) {
                ctx.setLineDash([
                    2,
                    2
                ]);
            } else {
                ctx.setLineDash([]);
            }
            ctx.moveTo(0, y);
            ctx.lineTo(chartWidth - priceScaleWidth, y);
            ctx.stroke();
            ctx.setLineDash([]);
            // Draw level labels
            ctx.fillStyle = textColor;
            ctx.font = "10px Inter, sans-serif";
            ctx.textAlign = "right";
            ctx.fillText(level.toString(), chartWidth - 5, y - 3);
        });
        // Draw RSI line with improved styling
        ctx.strokeStyle = lineColor;
        ctx.lineWidth = 1.5;
        ctx.beginPath();
        for(let i = 0; i < visibleData.length; i++){
            const value = visibleData[i];
            if (isNaN(value)) continue;
            // Calculate x position correctly - this matches how the main chart calculates x
            const globalIdx = visibleRange.start + i;
            // Subtract startOffset so x=0 at the left edge of the panel
            const x = (globalIdx - startOffset) / totalVisibleRange * chartWidth;
            const y = chartTop + chartHeight - value / 100 * chartHeight;
            if (i === 0) {
                ctx.moveTo(x, y);
            } else {
                ctx.lineTo(x, y);
            }
        }
        // Add shadow/glow effect for better visibility
        ctx.shadowColor = lineColor;
        ctx.shadowBlur = 2;
        ctx.stroke();
        ctx.shadowBlur = 0;
        // Draw RSI title with improved styling
        ctx.fillStyle = textColor;
        ctx.font = "bold 11px Inter, sans-serif";
        ctx.textAlign = "left";
        ctx.fillText(`RSI (${indicator.params.period})`, 8, chartTop + 16);
        // Draw current RSI value with improved styling
        const currentRSI = visibleData[visibleData.length - 1];
        if (currentRSI !== undefined) {
            // Determine color based on RSI value
            let valueColor = lineColor;
            if (currentRSI > 70) {
                valueColor = isDarkTheme ? "#ef4444" : "#dc2626"; // Red for overbought
            } else if (currentRSI < 30) {
                valueColor = isDarkTheme ? "#22c55e" : "#16a34a"; // Green for oversold
            }
            ctx.fillStyle = valueColor;
            ctx.font = "bold 11px Inter, sans-serif";
            ctx.textAlign = "left";
            ctx.fillText(currentRSI.toFixed(2), 80, chartTop + 16);
        }
    },
    getSettings: ()=>[
            {
                name: "period",
                label: "Period",
                type: "number",
                min: 2,
                max: 50,
                step: 1,
                default: 14
            },
            {
                name: "source",
                label: "Source",
                type: "select",
                default: "close",
                options: [
                    {
                        value: "close",
                        label: "Close"
                    },
                    {
                        value: "open",
                        label: "Open"
                    },
                    {
                        value: "high",
                        label: "High"
                    },
                    {
                        value: "low",
                        label: "Low"
                    }
                ]
            }
        ],
    icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$activity$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Activity$3e$__["Activity"],
    getLightThemeColor: ()=>"#7c3aed",
    getDarkThemeColor: ()=>"#8b5cf6"
};
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/registry.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createIndicator",
    ()=>createIndicator,
    "getAllIndicators",
    ()=>getAllIndicators,
    "getCategoryThemeColor",
    ()=>getCategoryThemeColor,
    "getIndicatorByType",
    ()=>getIndicatorByType,
    "getIndicatorThemeColor",
    ()=>getIndicatorThemeColor,
    "indicatorCategories",
    ()=>indicatorCategories,
    "indicatorRegistry",
    ()=>indicatorRegistry
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uuid$40$11$2e$1$2e$0$2f$node_modules$2f$uuid$2f$dist$2f$esm$2f$v4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__v4$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/uuid@11.1.0/node_modules/uuid/dist/esm/v4.js [app-ssr] (ecmascript) <export default as v4>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$sma$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/sma.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$rsi$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/rsi.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trending$2d$up$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__TrendingUp$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/trending-up.js [app-ssr] (ecmascript) <export default as TrendingUp>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$activity$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Activity$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/activity.js [app-ssr] (ecmascript) <export default as Activity>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$no$2d$axes$2d$column$2d$increasing$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-no-axes-column-increasing.js [app-ssr] (ecmascript) <export default as BarChart>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$no$2d$axes$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart2$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-no-axes-column.js [app-ssr] (ecmascript) <export default as BarChart2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$settings$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Settings$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/settings.js [app-ssr] (ecmascript) <export default as Settings>");
"use client";
;
;
;
;
const indicatorCategories = [
    {
        id: "added",
        name: "Added",
        icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$settings$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Settings$3e$__["Settings"],
        color: "#f97316",
        lightColor: "#ea580c"
    },
    {
        id: "popular",
        name: "Popular",
        icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trending$2d$up$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__TrendingUp$3e$__["TrendingUp"],
        color: "#ef4444",
        lightColor: "#dc2626"
    },
    {
        id: "trend",
        name: "Trend",
        icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trending$2d$up$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__TrendingUp$3e$__["TrendingUp"],
        color: "#3b82f6",
        lightColor: "#2563eb"
    },
    {
        id: "momentum",
        name: "Momentum",
        icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$activity$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Activity$3e$__["Activity"],
        color: "#8b5cf6",
        lightColor: "#7c3aed"
    },
    {
        id: "volatility",
        name: "Volatility",
        icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$no$2d$axes$2d$column$2d$increasing$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart$3e$__["BarChart"],
        color: "#f59e0b",
        lightColor: "#d97706"
    },
    {
        id: "volume",
        name: "Volume",
        icon: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$no$2d$axes$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart2$3e$__["BarChart2"],
        color: "#10b981",
        lightColor: "#059669"
    }
];
const indicatorRegistry = {
    sma: __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$sma$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SMAIndicator"],
    rsi: __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$rsi$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["RSIIndicator"]
};
function createIndicator(type, customSettings = {}) {
    const definition = indicatorRegistry[type];
    if (!definition) {
        throw new Error(`Indicator type ${type} not found in registry`);
    }
    // Create a deep copy of the default settings
    const defaultSettings = JSON.parse(JSON.stringify(definition.defaultSettings));
    // Generate a unique ID
    const id = `${type}-${(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uuid$40$11$2e$1$2e$0$2f$node_modules$2f$uuid$2f$dist$2f$esm$2f$v4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__v4$3e$__["v4"])().slice(0, 8)}`;
    // Merge default settings with custom settings
    return {
        ...defaultSettings,
        ...customSettings,
        id,
        params: {
            ...defaultSettings.params,
            ...customSettings.params
        }
    };
}
function getAllIndicators() {
    return Object.entries(indicatorRegistry).map(([type, definition])=>{
        const defaultSettings = definition.defaultSettings;
        const id = `${type}-${(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$uuid$40$11$2e$1$2e$0$2f$node_modules$2f$uuid$2f$dist$2f$esm$2f$v4$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__v4$3e$__["v4"])().slice(0, 8)}`;
        return {
            ...defaultSettings,
            id
        };
    });
}
function getIndicatorByType(type) {
    return indicatorRegistry[type];
}
function getIndicatorThemeColor(indicator, isDarkTheme) {
    const definition = indicatorRegistry[indicator.type];
    if (isDarkTheme && definition?.getDarkThemeColor) {
        return definition.getDarkThemeColor();
    } else if (!isDarkTheme && definition?.getLightThemeColor) {
        return definition.getLightThemeColor();
    }
    return indicator.color;
}
function getCategoryThemeColor(categoryId, isDarkTheme) {
    const category = indicatorCategories.find((cat)=>cat.id === categoryId);
    if (!category) return isDarkTheme ? "#3b82f6" : "#2563eb";
    return isDarkTheme ? category.color : category.lightColor || category.color;
}
}),
"[project]/frontend/components/blocks/advanced-chart/context/chart-indicators.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartIndicatorsProvider",
    ()=>ChartIndicatorsProvider,
    "useChartIndicators",
    ()=>useChartIndicators
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/registry.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
const ChartIndicatorsContext = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createContext"])({
    indicators: [],
    setIndicators: ()=>{},
    addIndicator: ()=>{},
    removeIndicator: ()=>{},
    updateIndicator: ()=>{},
    calculateIndicators: ()=>{},
    toggleIndicator: ()=>{},
    getIndicatorById: ()=>undefined,
    forceCalculateAll: ()=>{}
});
const useChartIndicators = ()=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useContext"])(ChartIndicatorsContext);
const ChartIndicatorsProvider = ({ children })=>{
    const [indicators, setIndicators] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])([]);
    // Refs for tracking calculation state
    const lastCalculationRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    const isUpdatingRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const lastDataLengthRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    const indicatorsRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])([]);
    const latestCandleDataRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])([]);
    // Keep the refs updated with the latest values
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        indicatorsRef.current = indicators;
    }, [
        indicators
    ]);
    // Initialize indicators
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Add default SMA indicator
        const sma = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createIndicator"])("sma");
        if (sma) {
            sma.params.period = 20;
            sma.color = "#3b82f6"; // Blue
        }
        // Add default RSI indicator
        const rsi = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createIndicator"])("rsi");
        if (rsi) {
            rsi.params.period = 14;
            rsi.color = "#8b5cf6"; // Purple
            rsi.separatePanel = true;
        }
        setIndicators([
            sma,
            rsi
        ].filter(Boolean));
    }, []);
    // Add a new indicator
    const addIndicator = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((params)=>{
        const newIndicator = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createIndicator"])(params.type);
        if (newIndicator) {
            // Apply custom params if provided
            if (params.params) {
                newIndicator.params = {
                    ...newIndicator.params,
                    ...params.params
                };
            }
            // Set visible to true by default when adding
            newIndicator.visible = true;
            setIndicators((prev)=>{
                // Make sure we don't add duplicates
                const exists = prev.some((ind)=>ind.type === params.type);
                if (exists) {
                    return prev.map((ind)=>ind.type === params.type ? {
                            ...ind,
                            visible: true
                        } // Make existing indicator visible
                         : ind);
                } else {
                    return [
                        ...prev,
                        newIndicator
                    ];
                }
            });
            // Force recalculation
            setTimeout(()=>{
                if (latestCandleDataRef.current.length > 0) {
                    calculateIndicators(latestCandleDataRef.current);
                }
            }, 100);
        }
    }, []);
    // Remove an indicator
    const removeIndicator = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((id)=>{
        setIndicators((prev)=>prev.filter((indicator)=>indicator.id !== id));
    }, []);
    // Update an indicator
    const updateIndicator = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((id, updates)=>{
        if (!id) {
            return;
        }
        setIndicators((prev)=>{
            // Find the indicator first to check if it exists
            const indicator = prev.find((ind)=>ind.id === id);
            if (!indicator) {
                return prev;
            }
            // Return the updated array
            return prev.map((ind)=>ind.id === id ? {
                    ...ind,
                    ...updates
                } : ind);
        });
        // Force recalculation after updates
        setTimeout(()=>{
            if (latestCandleDataRef.current.length > 0) {
                calculateIndicators(latestCandleDataRef.current);
            }
        }, 100);
    }, []);
    // Toggle indicator visibility
    const toggleIndicator = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((id)=>{
        if (!id) {
            return;
        }
        setIndicators((prev)=>{
            // Find the indicator first to check if it exists
            const indicator = prev.find((ind)=>ind.id === id);
            if (!indicator) {
                return prev;
            }
            // Create a new array with the toggled indicator
            const newIndicators = prev.map((ind)=>ind.id === id ? {
                    ...ind,
                    visible: !ind.visible
                } : ind);
            // Update the ref immediately for other functions that might use it
            indicatorsRef.current = newIndicators;
            // Return the new array
            return newIndicators;
        });
        // Force recalculation after toggling
        setTimeout(()=>{
            if (latestCandleDataRef.current.length > 0) {
                calculateIndicators(latestCandleDataRef.current);
            }
        }, 100);
    }, []);
    // Get indicator by ID
    const getIndicatorById = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((id)=>{
        return indicators.find((indicator)=>indicator.id === id);
    }, [
        indicators
    ]);
    // Force recalculation of all indicators
    const forceCalculateAll = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (latestCandleDataRef.current.length > 0) {
            calculateIndicators(latestCandleDataRef.current);
        }
    }, []);
    // Calculate indicator values
    const calculateIndicators = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((data)=>{
        if (!data || data.length === 0) {
            return;
        }
        // Store the latest data for future recalculations
        latestCandleDataRef.current = data;
        // Check if we're already calculating or if the data hasn't changed
        if (isUpdatingRef.current) {
            return;
        }
        // Check if the data is the same as last time
        if (data.length === lastDataLengthRef.current && Date.now() - lastCalculationRef.current < 1000) {
            return;
        }
        // Update tracking variables
        isUpdatingRef.current = true;
        lastDataLengthRef.current = data.length;
        lastCalculationRef.current = Date.now();
        try {
            // Create a new array of indicators with calculated values
            const updatedIndicators = indicators.map((indicator)=>{
                try {
                    // Get the calculation function from the registry
                    const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][indicator.type];
                    if (!indicatorDef) return indicator;
                    // Calculate the indicator values
                    const values = indicatorDef.calculate(data, indicator.params);
                    // Return updated indicator with calculated values
                    return {
                        ...indicator,
                        data: values
                    };
                } catch (error) {
                    return indicator;
                }
            });
            // Only update state if there are actual changes
            const hasChanges = JSON.stringify(updatedIndicators) !== JSON.stringify(indicators);
            if (hasChanges) {
                setIndicators(updatedIndicators);
            }
        } catch (error) {
        // Error handling without console.log
        } finally{
            // Reset the updating flag
            isUpdatingRef.current = false;
        }
    }, [
        indicators
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ChartIndicatorsContext.Provider, {
        value: {
            indicators,
            setIndicators,
            addIndicator,
            removeIndicator,
            updateIndicator,
            calculateIndicators,
            toggleIndicator,
            getIndicatorById,
            forceCalculateAll
        },
        children: children
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/context/chart-indicators.tsx",
        lineNumber: 272,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
}),
"[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartProvider",
    ()=>ChartProvider,
    "useChart",
    ()=>useChart,
    "useChartContext",
    ()=>useChartContext
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$state$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-state.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$data$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-data.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$interactions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-interactions.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$indicators$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-indicators.tsx [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
;
if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
;
const ChartContext = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createContext"])(undefined);
const ChartProvider = ({ children, symbol, timeFrame, onPriceUpdate = ()=>{}, onTimeFrameChange, darkMode = true, orders = [], expiryMinutes = 5, isMarketSwitching = false, onChartContextReady, marketType = "spot" })=>{
    const isUnmountingRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const prevDarkModeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(darkMode);
    const prevSymbolRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(symbol);
    const prevTimeFrameRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(timeFrame);
    const internalTimeFrameRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(timeFrame);
    const state = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$state$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChartState"])(darkMode);
    const { candleData, loading, error, refreshData, setGlobalCandleData, fetchOlderData, requestOlderData, isLoadingOlderData, hasReachedOldestData, viewportCandleCapacity, calculateViewportCapacity, dataReady, shouldFetchOlderData, clearSymbolCache, clearCurrentData, price, changeTimeFrameDirectly } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$data$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChartData"])(symbol, internalTimeFrameRef.current, onPriceUpdate, {
        ...state,
        marketType
    });
    const dataHooks = {
        candleData,
        loading,
        error,
        refreshData,
        setGlobalCandleData,
        fetchOlderData,
        isLoadingOlderData,
        hasReachedOldestData,
        viewportCandleCapacity,
        calculateViewportCapacity,
        dataReady,
        shouldFetchOlderData,
        clearSymbolCache,
        clearCurrentData,
        changeTimeFrameDirectly
    };
    const interactionHooks = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$interactions$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChartInteractions"])(state, dataHooks);
    const indicatorHooks = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$indicators$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChartIndicators"])();
    const lastCalculatedDataLengthRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    const lastCalculatedDataTimestampRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    const isCalculatingIndicatorsRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const [panelHeights, setPanelHeights] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({});
    const [collapsedPanels, setCollapsedPanels] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({});
    const [isDraggingPanel, setIsDraggingPanel] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({});
    const [activeIndicatorId, setActiveIndicatorId] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [showTimeframeSelector, setShowTimeframeSelector] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [expiryIntervalMinutes, setExpiryIntervalMinutes] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(expiryMinutes || 5);
    const [priceSubscribers, setPriceSubscribers] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])([]);
    const [timeFrameSubscribers, setTimeFrameSubscribers] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])([]);
    const [isChangingTimeframe, setIsChangingTimeframe] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const isChangingTimeframeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const hasSetThemeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const toggleIndicator = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((id)=>{
        if (!id) {
            return;
        }
        if (indicatorHooks && typeof indicatorHooks.toggleIndicator === "function") {
            indicatorHooks.toggleIndicator(id);
            if (typeof indicatorHooks.forceCalculateAll === "function") {
                setTimeout(()=>{
                    indicatorHooks.forceCalculateAll();
                }, 50);
            }
        }
    }, [
        indicatorHooks
    ]);
    const subscribeToPrice = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((callback)=>{
        const stableCallback = (arg)=>callback(arg);
        setPriceSubscribers((prev)=>{
            if (!prev.some((cb)=>cb === stableCallback)) {
                return [
                    ...prev,
                    stableCallback
                ];
            }
            return prev;
        });
        return ()=>{
            setPriceSubscribers((prev)=>prev.filter((cb)=>cb !== stableCallback));
        };
    }, []);
    const subscribeToTimeFrame = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((callback)=>{
        const stableCallback = (arg)=>callback(arg);
        setTimeFrameSubscribers((prev)=>[
                ...prev,
                stableCallback
            ]);
        return ()=>{
            setTimeFrameSubscribers((prev)=>prev.filter((cb)=>cb !== stableCallback));
        };
    }, []);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (price > 0) {
            const currentSubscribers = [
                ...priceSubscribers
            ];
            currentSubscribers.forEach((callback)=>callback(price));
        }
    }, [
        price,
        priceSubscribers
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        timeFrameSubscribers.forEach((callback)=>callback(internalTimeFrameRef.current));
    }, [
        internalTimeFrameRef.current,
        timeFrameSubscribers
    ]);
    const calculateSeparatePanelsHeight = ()=>{
        const visibleIndicators = indicatorHooks.indicators ? indicatorHooks.indicators.filter((i)=>i && i.visible) : [];
        const separatePanelIndicators = visibleIndicators.filter((i)=>i && i.separatePanel);
        let totalHeight = 0;
        separatePanelIndicators.forEach((indicator)=>{
            if (!indicator || !indicator.id) return;
            const panelHeight = indicator.id && panelHeights ? panelHeights[indicator.id] || 100 : 100;
            const isCollapsed = indicator.id && collapsedPanels ? collapsedPanels[indicator.id] || false : false;
            totalHeight += isCollapsed ? 30 : panelHeight + 24;
        });
        return totalHeight;
    };
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        prevSymbolRef.current = symbol;
        prevTimeFrameRef.current = timeFrame;
        internalTimeFrameRef.current = timeFrame;
    }, [
        symbol,
        timeFrame
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const updateDimensions = ()=>{
            if (state.containerRef.current) {
                const rect = state.containerRef.current.getBoundingClientRect();
                const width = Math.max(rect.width, 300);
                const height = Math.max(rect.height, 200);
                if (width !== state.dimensions.width || height !== state.dimensions.height) {
                    state.setDimensions({
                        width,
                        height
                    });
                    // Force a high-priority render when dimensions change
                    setTimeout(()=>{
                        // Dispatch a custom event to notify renderer of dimension changes
                        window.dispatchEvent(new CustomEvent("chart-dimensions-changed", {
                            detail: {
                                width,
                                height
                            }
                        }));
                    }, 0);
                }
            }
        };
        // Initial dimension update with delay to allow layout to settle
        const initTimer = setTimeout(()=>{
            updateDimensions();
        }, 100);
        // Handle both standard resize and custom resize events
        const handleResize = ()=>{
            // Use RAF to ensure we don't block the resize event
            requestAnimationFrame(updateDimensions);
        };
        // Set up ResizeObserver for more responsive updates
        let resizeObserver = null;
        if (state.containerRef.current && "ResizeObserver" in window) {
            resizeObserver = new ResizeObserver((entries)=>{
                for (const entry of entries){
                    const { width, height } = entry.contentRect;
                    if (width > 0 && height > 0) {
                        const adjustedWidth = Math.max(width, 300);
                        const adjustedHeight = Math.max(height, 200);
                        if (adjustedWidth !== state.dimensions.width || adjustedHeight !== state.dimensions.height) {
                            state.setDimensions({
                                width: adjustedWidth,
                                height: adjustedHeight
                            });
                            // Notify renderer with throttling
                            setTimeout(()=>{
                                window.dispatchEvent(new CustomEvent("chart-dimensions-changed", {
                                    detail: {
                                        width: adjustedWidth,
                                        height: adjustedHeight
                                    }
                                }));
                            }, 0);
                        }
                    }
                }
            });
            resizeObserver.observe(state.containerRef.current);
        }
        window.addEventListener("resize", handleResize);
        // Listen for custom resize events from resize handles
        window.addEventListener("chart-resize-requested", handleResize);
        // Listen for panel state changes
        window.addEventListener("panel-collapsed", handleResize);
        window.addEventListener("panel-expanded", handleResize);
        window.addEventListener("panel-group-collapsed", handleResize);
        window.addEventListener("panel-group-expanded", handleResize);
        return ()=>{
            clearTimeout(initTimer);
            window.removeEventListener("resize", handleResize);
            window.removeEventListener("chart-resize-requested", handleResize);
            window.removeEventListener("panel-collapsed", handleResize);
            window.removeEventListener("panel-expanded", handleResize);
            window.removeEventListener("panel-group-collapsed", handleResize);
            window.removeEventListener("panel-group-expanded", handleResize);
            if (resizeObserver) {
                resizeObserver.disconnect();
            }
        };
    }, [
        state.containerRef,
        state.dimensions.width,
        state.dimensions.height,
        state.setDimensions
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (indicatorHooks.indicators.length > 0) {
            try {
                const visibleIndicators = indicatorHooks.indicators.filter((ind)=>ind.visible).map((ind)=>({
                        id: ind.id,
                        type: ind.type,
                        params: ind.params,
                        color: ind.color,
                        visible: ind.visible,
                        separatePanel: ind.separatePanel
                    }));
                if (visibleIndicators.length > 0) {
                    localStorage.setItem("chartIndicators", JSON.stringify(visibleIndicators));
                }
            } catch (error) {
            // Silent error
            }
        }
    }, [
        indicatorHooks.indicators
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        try {
            const savedIndicators = localStorage.getItem("chartIndicators");
            if (savedIndicators) {
                const parsed = JSON.parse(savedIndicators);
                if (Array.isArray(parsed) && parsed.length > 0) {
                    indicatorHooks.setIndicators((prev)=>{
                        const existingMap = new Map(prev.map((ind)=>[
                                ind.type,
                                ind
                            ]));
                        parsed.forEach((savedInd)=>{
                            if (existingMap.has(savedInd.type)) {
                                const existing = existingMap.get(savedInd.type);
                                if (existing) {
                                    existingMap.set(savedInd.type, {
                                        ...existing,
                                        params: savedInd.params,
                                        color: savedInd.color,
                                        visible: savedInd.visible,
                                        separatePanel: savedInd.separatePanel
                                    });
                                }
                            }
                        });
                        return Array.from(existingMap.values());
                    });
                }
            }
        } catch (error) {
        // Silent error
        }
    }, [
        indicatorHooks
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (expiryMinutes !== expiryIntervalMinutes) {
            setExpiryIntervalMinutes(expiryMinutes);
        }
    }, [
        expiryMinutes,
        expiryIntervalMinutes
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!candleData || candleData.length === 0 || !indicatorHooks.calculateIndicators || isCalculatingIndicatorsRef.current || isUnmountingRef.current) {
            return;
        }
        const currentLength = candleData.length;
        const currentTime = Date.now();
        if (currentLength === lastCalculatedDataLengthRef.current && currentTime - lastCalculatedDataTimestampRef.current < 1000) {
            return;
        }
        lastCalculatedDataLengthRef.current = currentLength;
        lastCalculatedDataTimestampRef.current = currentTime;
        isCalculatingIndicatorsRef.current = true;
        const timeoutId = setTimeout(()=>{
            if (!isUnmountingRef.current) {
                indicatorHooks.calculateIndicators(candleData);
            }
            isCalculatingIndicatorsRef.current = false;
        }, 100);
        return ()=>{
            clearTimeout(timeoutId);
            isCalculatingIndicatorsRef.current = false;
        };
    }, [
        candleData,
        indicatorHooks,
        isUnmountingRef
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (prevDarkModeRef.current !== darkMode) {
            prevDarkModeRef.current = darkMode;
            state.setTheme(darkMode ? "dark" : "light");
            hasSetThemeRef.current = true;
        }
    }, [
        darkMode,
        state
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        return ()=>{
            isUnmountingRef.current = true;
        };
    }, []);
    // Direct timeframe change handler - no useEffect dependency
    const handleTimeFrameChange = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(async (newTimeFrame)=>{
        console.log("🕒 Chart context handling direct timeframe change:", newTimeFrame);
        if (newTimeFrame !== internalTimeFrameRef.current) {
            // Update internal ref first
            internalTimeFrameRef.current = newTimeFrame;
            // Set timeframe changing state
            setIsChangingTimeframe(true);
            isChangingTimeframeRef.current = true;
            // Notify subscribers
            timeFrameSubscribers.forEach((callback)=>callback(newTimeFrame));
            // Call the external handler if provided
            if (onTimeFrameChange) {
                onTimeFrameChange(newTimeFrame);
            }
            // Call the direct timeframe change function immediately
            if (changeTimeFrameDirectly) {
                console.log("🚀 Calling direct timeframe change function");
                await changeTimeFrameDirectly(newTimeFrame);
                console.log("✅ Direct timeframe change completed");
                // Reset timeframe changing state after completion
                setTimeout(()=>{
                    setIsChangingTimeframe(false);
                    isChangingTimeframeRef.current = false;
                    // Recalculate indicators after timeframe change
                    if (indicatorHooks && typeof indicatorHooks.forceCalculateAll === "function") {
                        setTimeout(()=>{
                            indicatorHooks.forceCalculateAll();
                        }, 100);
                    }
                }, 300);
            } else {
                // Reset timeframe changing state after a short delay
                setTimeout(()=>{
                    setIsChangingTimeframe(false);
                    isChangingTimeframeRef.current = false;
                }, 300);
            }
        }
    }, [
        onTimeFrameChange,
        timeFrameSubscribers,
        changeTimeFrameDirectly,
        indicatorHooks
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (prevTimeFrameRef.current && prevTimeFrameRef.current !== timeFrame) {
            setIsChangingTimeframe(true);
            isChangingTimeframeRef.current = true;
            internalTimeFrameRef.current = timeFrame;
            setTimeout(()=>{
                setIsChangingTimeframe(false);
                isChangingTimeframeRef.current = false;
            }, 500);
        }
        prevTimeFrameRef.current = timeFrame;
    }, [
        timeFrame,
        symbol
    ]);
    const drawingTools = [];
    const priceAlerts = [];
    const value = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>({
            ...state,
            candleData,
            loading: loading || isChangingTimeframeRef.current,
            error,
            refreshData,
            setGlobalCandleData,
            fetchOlderData,
            requestOlderData,
            isLoadingOlderData,
            hasReachedOldestData,
            viewportCandleCapacity,
            calculateViewportCapacity,
            symbol,
            timeFrame: internalTimeFrameRef.current,
            orders,
            onPriceUpdate,
            onTimeFrameChange: handleTimeFrameChange,
            darkMode,
            showSettingsPanel: state.showSettingsPanel,
            setShowSettingsPanel: state.setShowSettingsPanel,
            reconnectCount: state.reconnectCount,
            dataReady,
            isMarketSwitching: isMarketSwitching,
            isChangingTimeframe,
            panelHeights,
            setPanelHeights,
            collapsedPanels,
            setCollapsedPanels,
            isDraggingPanel,
            setIsDraggingPanel,
            activeIndicatorId,
            setActiveIndicatorId,
            setShowIndicatorPanel: state.setShowIndicatorPanel,
            toggleIndicator,
            showTimeframeSelector,
            setShowTimeframeSelector,
            shouldFetchOlderData,
            expiryIntervalMinutes,
            setExpiryIntervalMinutes,
            clearSymbolCache,
            clearCurrentData,
            calculateSeparatePanelsHeight,
            indicators: indicatorHooks.indicators || [],
            forceCalculateAll: indicatorHooks.forceCalculateAll || (()=>{}),
            subscribeToPrice,
            subscribeToTimeFrame,
            updateIndicator: indicatorHooks.updateIndicator || (()=>{}),
            addIndicator: indicatorHooks.addIndicator || (()=>{}),
            removeIndicator: indicatorHooks.removeIndicator || (()=>{}),
            drawingTools,
            activeDrawingTool: null,
            isDrawing: false,
            currentDrawing: null,
            showDrawingToolbar: false,
            showVolumeProfile: false,
            showPatternRecognition: false,
            priceAlerts,
            setDrawingTool: ()=>{},
            clearDrawings: ()=>{},
            setShowDrawingToolbar: ()=>{},
            toggleVolumeProfile: ()=>{},
            togglePatternRecognition: ()=>{},
            addPriceAlert: ()=>{},
            removePriceAlert: ()=>{},
            expiryMarkers: [],
            priceScaleWidth: 60,
            timeScaleHeight: 30,
            zoomIn: interactionHooks.zoomIn,
            zoomOut: interactionHooks.zoomOut,
            resetZoom: interactionHooks.resetZoom,
            priceToY: interactionHooks.priceToY,
            yToPrice: interactionHooks.yToPrice
        }), [
        state,
        candleData,
        loading,
        error,
        refreshData,
        setGlobalCandleData,
        fetchOlderData,
        requestOlderData,
        isLoadingOlderData,
        hasReachedOldestData,
        viewportCandleCapacity,
        calculateViewportCapacity,
        symbol,
        orders,
        onPriceUpdate,
        handleTimeFrameChange,
        darkMode,
        panelHeights,
        collapsedPanels,
        isDraggingPanel,
        activeIndicatorId,
        showTimeframeSelector,
        expiryIntervalMinutes,
        isMarketSwitching,
        isChangingTimeframe,
        clearSymbolCache,
        clearCurrentData,
        indicatorHooks,
        subscribeToPrice,
        subscribeToTimeFrame,
        toggleIndicator,
        interactionHooks
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (onChartContextReady) {
            onChartContextReady(value);
        }
    }, [
        value,
        onChartContextReady
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ChartContext.Provider, {
        value: value,
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            ref: state.containerRef,
            className: "relative w-full h-full chart-container",
            style: {
                width: "100%",
                height: "100%",
                minHeight: "400px"
            },
            children: children
        }, void 0, false, {
            fileName: "[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx",
            lineNumber: 808,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx",
        lineNumber: 807,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const useChart = ()=>{
    const context = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useContext"])(ChartContext);
    if (context === undefined) {
        throw new Error("useChart must be used within a ChartProvider");
    }
    return context;
};
const useChartContext = useChart;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/hooks.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useCanvasSetup",
    ()=>useCanvasSetup,
    "useOlderDataCheck",
    ()=>useOlderDataCheck,
    "useRenderState",
    ()=>useRenderState,
    "useTouchInteractions",
    ()=>useTouchInteractions,
    "useTriggerRender",
    ()=>useTriggerRender
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
function useTouchInteractions() {
    const [touchStartX, setTouchStartX] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [touchStartY, setTouchStartY] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [lastTouchDistance, setLastTouchDistance] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    return {
        touchStartX,
        touchStartY,
        lastTouchDistance,
        setTouchStartX,
        setTouchStartY,
        setLastTouchDistance
    };
}
function useRenderState() {
    const [hoverEffect, setHoverEffect] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [renderQuality, setRenderQuality] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("high");
    // Use refs for values that shouldn't trigger re-renders
    const isThrottledRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    const needsRenderRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(true);
    const lastRenderTimeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    const lastVisibleRangeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])({
        start: 0,
        end: 100,
        initialized: false
    });
    // Throttle function that doesn't use state updates
    const throttle = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((callback)=>{
        if (!isThrottledRef.current) {
            isThrottledRef.current = true;
            // Execute the callback
            callback();
            // Reset throttle after a delay
            setTimeout(()=>{
                isThrottledRef.current = false;
            }, renderQuality === "high" ? 8 : 16);
        }
    }, [
        renderQuality
    ]);
    // Detect device performance and set render quality
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Check if device is high-end by measuring FPS
        let frameCount = 0;
        const startTimestamp = performance.now();
        let testDuration = 0;
        const checkPerformance = (timestamp)=>{
            frameCount++;
            testDuration = timestamp - startTimestamp;
            if (testDuration >= 1000) {
                // Test for 1 second
                const fps = frameCount * 1000 / testDuration;
                setRenderQuality(fps >= 50 ? "high" : "low");
                return;
            }
            requestAnimationFrame(checkPerformance);
        };
        requestAnimationFrame(checkPerformance);
    }, []);
    return {
        isThrottled: isThrottledRef.current,
        hoverEffect,
        renderQuality,
        needsRenderRef,
        lastRenderTimeRef,
        lastVisibleRangeRef,
        setHoverEffect,
        throttle
    };
}
function useCanvasSetup(dimensions) {
    const canvasRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const offscreenCanvasRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const animationFrameIdRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    // Create an offscreen canvas for double buffering
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if ("undefined" !== "undefined" && dimensions.width > 0 && dimensions.height > 0) //TURBOPACK unreachable
        ;
        return ()=>{
            offscreenCanvasRef.current = null;
        };
    }, [
        dimensions.width,
        dimensions.height
    ]);
    // Add CSS for hardware acceleration
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Add a style tag for hardware acceleration
        const style = document.createElement("style");
        style.innerHTML = `
      .chart-container {
        will-change: transform;
      }
      .chart-container.dragging {
        will-change: transform;
        transform: translateZ(0);
      }
      .chart-container canvas {
        transform: translateZ(0);
        backface-visibility: hidden;
      }
    `;
        document.head.appendChild(style);
        return ()=>{
            document.head.removeChild(style);
        };
    }, []);
    return {
        canvasRef,
        offscreenCanvasRef,
        animationFrameIdRef
    };
}
function useTriggerRender(needsRenderRef) {
    const triggerRender = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        needsRenderRef.current = true;
    }, [
        needsRenderRef
    ]);
    // Add this effect to listen for the chartZoom custom event
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Listen for custom zoom events
        const handleChartZoom = ()=>{
            // Force an immediate render
            needsRenderRef.current = true;
        };
        window.addEventListener("chartZoom", handleChartZoom);
        return ()=>{
            window.removeEventListener("chartZoom", handleChartZoom);
        };
    }, [
        needsRenderRef
    ]);
    return triggerRender;
}
function useOlderDataCheck(candleData, visibleRange, isLoadingOlderData, hasReachedOldestData, fetchOlderData) {
    // Use a ref to track the last checked range to prevent excessive calls
    const lastCheckedRangeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])({
        start: -1,
        end: -1
    });
    // Track if the user is actively scrolling back
    const isScrollingBackRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    // Track the last time we fetched older data
    const lastFetchTimeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Minimum time between fetches (3 seconds)
    const MIN_FETCH_INTERVAL = 3000;
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Detect if user is scrolling back by comparing with previous range
        if (lastCheckedRangeRef.current.start > visibleRange.start) {
            isScrollingBackRef.current = true;
        } else if (lastCheckedRangeRef.current.start < visibleRange.start) {
            // User is scrolling forward
            isScrollingBackRef.current = false;
        }
        // Only check if the visible range has changed significantly
        if (Math.abs(lastCheckedRangeRef.current.start - visibleRange.start) > 5 || Math.abs(lastCheckedRangeRef.current.end - visibleRange.end) > 5) {
            // Update the last checked range
            lastCheckedRangeRef.current = {
                ...visibleRange
            };
            // Only fetch if:
            // 1. User is scrolling back
            // 2. We're near the beginning of available data (first 20 candles)
            // 3. We're not already loading
            // 4. We haven't reached the oldest data
            // 5. It's been at least MIN_FETCH_INTERVAL since the last fetch
            const now = Date.now();
            const timeSinceLastFetch = now - lastFetchTimeRef.current;
            if (isScrollingBackRef.current && visibleRange.start < 20 && !isLoadingOlderData && !hasReachedOldestData && candleData.length > 0 && timeSinceLastFetch > MIN_FETCH_INTERVAL) {
                console.log("Near the beginning of available data, fetching older data...");
                lastFetchTimeRef.current = now;
                fetchOlderData();
            }
        }
    }, [
        visibleRange,
        candleData.length,
        isLoadingOlderData,
        hasReachedOldestData,
        fetchOlderData
    ]);
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/events/helpers.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "isInMainChartArea",
    ()=>isInMainChartArea
]);
"use client";
function isInMainChartArea(x, y, chartTop, chartHeight, chartWidth, priceScaleWidth) {
    return x >= 0 && x <= chartWidth - priceScaleWidth && y >= chartTop && y <= chartTop + chartHeight;
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/events/mouse-events.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useMouseEvents",
    ()=>useMouseEvents
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/events/helpers.tsx [app-ssr] (ecmascript)");
"use client";
;
;
function useMouseEvents({ mousePosition, isDragging, dragStart, dimensions, visibleRange, candleData, setVisibleRange, setDragStart, setMousePosition, setIsDragging, isThrottled, triggerRender, priceScaleWidth, throttle, setHoverEffect, chartTop, priceChartHeight, shouldFetchOlderData, fetchOlderData }) {
    // Use refs to track the last position to avoid unnecessary updates
    const lastPositionRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])({
        x: 0,
        y: 0
    });
    const lastDragUpdateRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Add a safe check function
    const checkAndFetchOlderData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (typeof shouldFetchOlderData === "function" && shouldFetchOlderData()) {
            fetchOlderData();
        }
    }, [
        shouldFetchOlderData,
        fetchOlderData
    ]);
    // Update mouse move handler to be more efficient
    const handleMouseMove = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        const canvas = e.currentTarget;
        if (!canvas) return;
        const rect = canvas.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        // Only update if position changed significantly (by at least 2px)
        const positionChanged = !lastPositionRef.current || Math.abs(lastPositionRef.current.x - x) > 2 || Math.abs(lastPositionRef.current.y - y) > 2;
        if (positionChanged) {
            // Update the last position ref
            lastPositionRef.current = {
                x,
                y
            };
            // Update mouse position state (debounced)
            if (!isDragging) {
                // Only update mouse position if not dragging to reduce state updates
                // Use a function to update state based on previous value to avoid dependency issues
                setMousePosition((prev)=>{
                    // Only update if the position has actually changed
                    if (!prev || Math.abs(prev.x - x) > 2 || Math.abs(prev.y - y) > 2) {
                        return {
                            x,
                            y
                        };
                    }
                    return prev;
                });
            }
            // Check if we're in the main chart area
            const inMainChartArea = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth);
            // Update hover effect only when necessary, not during dragging
            if (!isDragging && inMainChartArea) {
                const chartWidth = dimensions.width - priceScaleWidth;
                if (x < chartWidth) {
                    // Check if we're hovering near a candle
                    const visibleCount = visibleRange.end - visibleRange.start;
                    const candleIndex = Math.floor(x / chartWidth * visibleCount + visibleRange.start);
                    if (candleIndex >= 0 && candleIndex < candleData.length) {
                        setHoverEffect((prev)=>{
                            // Only update if the hover effect has changed
                            if (!prev || Math.abs(prev.x - x) > 2 || Math.abs(prev.y - y) > 2) {
                                return {
                                    x,
                                    y,
                                    radius: 5
                                };
                            }
                            return prev;
                        });
                    } else {
                        setHoverEffect((prev)=>prev ? null : prev);
                    }
                }
            } else {
                // Clear hover effect during dragging
                setHoverEffect((prev)=>prev ? null : prev);
            }
        }
        // Only handle dragging in the main chart area
        if (isDragging && (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            // Throttle drag updates to prevent too many state changes
            const now = Date.now();
            if (now - lastDragUpdateRef.current < 16) {
                // Limit to ~60fps
                return;
            }
            lastDragUpdateRef.current = now;
            const deltaX = x - dragStart.x;
            const chartWidth = dimensions.width - priceScaleWidth;
            const visibleCount = visibleRange.end - visibleRange.start;
            // Calculate move amount based on drag distance with reduced sensitivity for PC
            const pcSensitivity = 0.3; // Much lower sensitivity for smoother PC dragging
            const moveAmount = deltaX / chartWidth * visibleCount * pcSensitivity * -1;
            // Store the current visible range width to maintain zoom level
            const rangeWidth = visibleRange.end - visibleRange.start;
            setVisibleRange((prev)=>{
                let newStart = prev.start + moveAmount;
                let newEnd = prev.end + moveAmount;
                // Store the current visible range width to maintain zoom level
                const rangeWidth = prev.end - prev.start;
                // Calculate minimum visible candles based on zoom level
                const minVisibleCandles = Math.max(10, visibleCount * 0.3);
                // Limit future viewing to 100% of chart width beyond the last candle
                // This respects the current zoom level by using the rangeWidth
                const maxEnd = candleData.length + rangeWidth * 1.0;
                // Handle boundary conditions while preserving zoom level
                if (newStart < -visibleCount * 0.1) {
                    // If we hit the left boundary, clamp to a small negative value
                    newStart = -visibleCount * 0.1;
                    newEnd = newStart + rangeWidth;
                } else if (newEnd > maxEnd) {
                    newEnd = maxEnd;
                    newStart = newEnd - rangeWidth;
                }
                // Modified check to ensure we always allow scrolling to the right
                // Even at maximum zoom, we should be able to see future area
                if (newStart >= candleData.length - 5) {
                    // Ensure at least 5 candles are visible
                    newStart = candleData.length - 5;
                    newEnd = newStart + rangeWidth;
                }
                // Check if we need to fetch older data
                if (newStart <= 5) {
                    checkAndFetchOlderData();
                }
                return {
                    start: newStart,
                    end: newEnd
                };
            });
            setDragStart({
                x,
                y
            });
            triggerRender();
        }
    }, [
        isDragging,
        dragStart,
        dimensions,
        visibleRange,
        candleData.length,
        setVisibleRange,
        setDragStart,
        triggerRender,
        priceScaleWidth,
        chartTop,
        priceChartHeight,
        checkAndFetchOlderData
    ]);
    const handleMouseDown = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        const canvas = e.currentTarget;
        if (!canvas) return;
        const rect = canvas.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        // Only allow dragging in the main chart area
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            return;
        }
        // Remove the ripple effect animation
        setHoverEffect(null);
        setIsDragging(true);
        setDragStart({
            x,
            y
        });
        // Add CSS class for hardware acceleration during dragging
        if (canvas.parentElement) {
            canvas.parentElement.classList.add("dragging");
        }
        // Set cursor style directly for immediate feedback
        canvas.style.cursor = "grabbing";
    }, [
        setIsDragging,
        setDragStart,
        setHoverEffect,
        chartTop,
        priceChartHeight,
        dimensions.width,
        priceScaleWidth
    ]);
    const handleMouseUp = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        setIsDragging(false);
        // Remove CSS class for hardware acceleration
        const canvas = e.currentTarget;
        if (canvas.parentElement) {
            canvas.parentElement.classList.remove("dragging");
        }
        // Reset cursor style
        const rect = canvas.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        // Only set grab cursor in the main chart area
        if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            canvas.style.cursor = "grab";
        } else {
            canvas.style.cursor = "default";
        }
    }, [
        setIsDragging,
        chartTop,
        priceChartHeight,
        dimensions.width,
        priceScaleWidth
    ]);
    const handleMouseLeave = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        setIsDragging(false);
        setMousePosition(null);
        setHoverEffect(null);
        // Remove CSS class for hardware acceleration
        const canvas = e.currentTarget;
        if (canvas.parentElement) {
            canvas.parentElement.classList.remove("dragging");
        }
        // Reset cursor style
        canvas.style.cursor = "default";
    }, [
        setIsDragging,
        setMousePosition,
        setHoverEffect
    ]);
    // Replace the handleWheel function with this simplified, direct implementation
    const handleWheel = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        e.preventDefault();
        // Get the canvas and mouse position
        const canvas = e.currentTarget;
        if (!canvas) return;
        const rect = canvas.getBoundingClientRect();
        const mouseX = e.clientX - rect.left;
        const mouseY = e.clientY - rect.top;
        // Only allow zooming in the main chart area
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(mouseX, mouseY, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            return;
        }
        const chartWidth = dimensions.width - priceScaleWidth;
        // Calculate zoom center point in data space
        const visibleCount = visibleRange.end - visibleRange.start;
        const zoomCenterIndex = mouseX / chartWidth * visibleCount + visibleRange.start;
        // Determine zoom direction and factor - use a much larger factor for immediate response
        const zoomDirection = e.deltaY > 0 ? 1 : -1;
        const zoomFactor = 1 + zoomDirection * 0.2; // Increased from 0.15 to 0.2 for more immediate effect
        // Calculate new visible range directly
        const newVisibleCount = visibleCount * zoomFactor;
        // Ensure we don't zoom in too far or out too far
        const minVisibleCount = 10;
        const maxVisibleCount = candleData.length * 1.2;
        const clampedVisibleCount = Math.max(minVisibleCount, Math.min(maxVisibleCount, newVisibleCount));
        // Calculate new start and end while keeping the mouse position fixed
        const zoomCenterRatio = (zoomCenterIndex - visibleRange.start) / visibleCount;
        const newStart = zoomCenterIndex - zoomCenterRatio * clampedVisibleCount;
        const newEnd = newStart + clampedVisibleCount;
        // Limit future viewing to 50% of visible range beyond the last candle
        const maxEnd = candleData.length + clampedVisibleCount * 0.75;
        // Apply boundaries while preserving zoom level
        let adjustedStart = newStart;
        let adjustedEnd = newEnd;
        if (adjustedEnd > maxEnd) {
            adjustedEnd = maxEnd;
            adjustedStart = adjustedEnd - clampedVisibleCount;
        }
        // Ensure we always keep at least some candles visible
        if (adjustedStart >= candleData.length - Math.max(10, clampedVisibleCount * 0.3)) {
            adjustedStart = candleData.length - Math.max(10, clampedVisibleCount * 0.3);
            adjustedEnd = adjustedStart + clampedVisibleCount;
        }
        // Check if we need to fetch older data
        if (adjustedStart <= 5) {
            checkAndFetchOlderData();
        }
        // Update visible range
        setVisibleRange({
            start: Math.max(0, adjustedStart),
            end: adjustedEnd
        });
        // Force an IMMEDIATE render without waiting for React
        triggerRender();
    }, [
        dimensions,
        visibleRange,
        candleData.length,
        setVisibleRange,
        triggerRender,
        priceScaleWidth,
        chartTop,
        priceChartHeight,
        checkAndFetchOlderData
    ]);
    // Return the updated handlers
    return {
        handleMouseMove,
        handleMouseDown,
        handleMouseUp,
        handleMouseLeave,
        handleWheel
    };
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/events/indicator-panel-events.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useIndicatorPanelInteractions",
    ()=>useIndicatorPanelInteractions
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
function useIndicatorPanelInteractions({ indicators, dimensions, visibleRange, candleData, showVolume, priceChartHeight, chartTop, priceScaleWidth, panelHeights, setPanelHeights, collapsedPanels, setCollapsedPanels, isDraggingPanel, setIsDraggingPanel, setShowIndicatorPanel, setActiveIndicatorId, toggleIndicator, theme }) {
    const [resizingIndicator, setResizingIndicator] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [resizeStartY, setResizeStartY] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(0);
    const lastPanelInteractionRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Update the handleIndicatorPanelClick function to correctly detect clicks on the control buttons
    const handleIndicatorPanelClick = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        const canvas = e.currentTarget;
        if (!canvas) return false;
        // Throttle panel interactions
        const now = Date.now();
        if (now - lastPanelInteractionRef.current < 100) {
            // Prevent rapid clicks
            return false;
        }
        lastPanelInteractionRef.current = now;
        const rect = canvas.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        // Calculate volume height (if shown)
        const volumeHeight = showVolume ? dimensions.height * 0.15 : 0;
        const volumeTop = chartTop + priceChartHeight;
        // Add null check for indicators
        if (!indicators || !Array.isArray(indicators)) return false;
        // Filter for visible indicators that should be in separate panes
        const separatePaneIndicators = indicators.filter((i)=>i && i.visible && i.separatePanel);
        if (separatePaneIndicators.length === 0) return false;
        let currentTop = chartTop + priceChartHeight + volumeHeight;
        // Check if click is within any indicator pane
        for (const indicator of separatePaneIndicators){
            // Skip if indicator doesn't have an id
            if (!indicator || !indicator.id) continue;
            const paneHeight = panelHeights && indicator.id in panelHeights ? panelHeights[indicator.id] : 100;
            const isCollapsed = collapsedPanels && indicator.id in collapsedPanels ? collapsedPanels[indicator.id] : false;
            const actualPaneHeight = isCollapsed ? 30 : paneHeight;
            const titleHeight = 24;
            if (y >= currentTop && y <= currentTop + actualPaneHeight) {
                // Click is within this pane
                if (y <= currentTop + titleHeight) {
                    // Click is in the title bar
                    // Calculate positions of control buttons
                    const buttonRadius = 9;
                    const buttonSpacing = 5;
                    const buttonY = currentTop + titleHeight / 2;
                    // Settings button (gear icon)
                    const settingsX = dimensions.width - 65;
                    if (Math.sqrt(Math.pow(x - settingsX, 2) + Math.pow(y - buttonY, 2)) <= buttonRadius) {
                        if (setActiveIndicatorId && setShowIndicatorPanel) {
                            setActiveIndicatorId(indicator.id);
                            setShowIndicatorPanel(true);
                            return true;
                        }
                    }
                    // Collapse/expand button
                    const collapseX = settingsX + buttonRadius * 2 + buttonSpacing;
                    if (Math.sqrt(Math.pow(x - collapseX, 2) + Math.pow(y - buttonY, 2)) <= buttonRadius) {
                        if (setCollapsedPanels) {
                            setCollapsedPanels({
                                ...collapsedPanels,
                                [indicator.id]: !isCollapsed
                            });
                            return true;
                        }
                    }
                    // Close button
                    const closeX = collapseX + buttonRadius * 2 + buttonSpacing;
                    if (Math.sqrt(Math.pow(x - closeX, 2) + Math.pow(y - buttonY, 2)) <= buttonRadius) {
                        if (toggleIndicator) {
                            toggleIndicator(indicator.id);
                            return true;
                        }
                    }
                }
                // Check if click is on resize handle
                if (!isCollapsed && y >= currentTop + actualPaneHeight - 5 && y <= currentTop + actualPaneHeight && x >= dimensions.width / 2 - 25 && x <= dimensions.width / 2 + 25) {
                    // Resize handle clicked
                    setResizingIndicator(indicator.id);
                    setResizeStartY(y);
                    if (setIsDraggingPanel) {
                        setIsDraggingPanel({
                            ...isDraggingPanel,
                            [indicator.id]: true
                        });
                    }
                    return true;
                }
            }
            currentTop += actualPaneHeight;
        }
        return false;
    }, [
        indicators,
        dimensions,
        showVolume,
        priceChartHeight,
        chartTop,
        panelHeights,
        collapsedPanels,
        setCollapsedPanels,
        isDraggingPanel,
        setIsDraggingPanel,
        setShowIndicatorPanel,
        setActiveIndicatorId,
        toggleIndicator,
        setResizingIndicator,
        setResizeStartY
    ]);
    const handleIndicatorPanelMouseMove = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        if (!resizingIndicator) return;
        const canvas = e.currentTarget;
        if (!canvas) return;
        // Throttle resize operations
        const now = Date.now();
        if (now - lastPanelInteractionRef.current < 16) {
            // Limit to ~60fps
            return;
        }
        lastPanelInteractionRef.current = now;
        const rect = canvas.getBoundingClientRect();
        const y = e.clientY - rect.top;
        // Calculate new height based on drag position
        const currentHeight = panelHeights && resizingIndicator in panelHeights ? panelHeights[resizingIndicator] : 100;
        const deltaY = y - resizeStartY;
        const newHeight = Math.max(50, Math.min(300, currentHeight + deltaY));
        // Update pane height
        if (setPanelHeights) {
            setPanelHeights({
                ...panelHeights,
                [resizingIndicator]: newHeight
            });
            setResizeStartY(y);
        }
    }, [
        resizingIndicator,
        resizeStartY,
        panelHeights,
        setPanelHeights
    ]);
    const handleIndicatorPanelMouseUp = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        if (resizingIndicator && setIsDraggingPanel) {
            setIsDraggingPanel({
                ...isDraggingPanel,
                [resizingIndicator]: false
            });
            setResizingIndicator(null);
        }
    }, [
        resizingIndicator,
        isDraggingPanel,
        setIsDraggingPanel
    ]);
    return {
        handleIndicatorPanelClick,
        handleIndicatorPanelMouseMove,
        handleIndicatorPanelMouseUp
    };
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/events/setup-events.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "setupEventListeners",
    ()=>setupEventListeners
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/events/helpers.tsx [app-ssr] (ecmascript)");
"use client";
;
function setupEventListeners(canvas, chart) {
    const { setMousePosition, setIsDragging, setDragStart, visibleRange, setVisibleRange, candleData, dimensions, priceScaleWidth, chartTop, priceChartHeight, shouldFetchOlderData, fetchOlderData } = chart;
    // Throttling for touch events
    let lastTouchUpdate = 0;
    const TOUCH_THROTTLE_MS = 16; // ~60fps
    let touchStartTime = 0;
    let initialTouchDistance = 0;
    // Mouse event handlers
    const handleMouseDown = (e)=>{
        if (!canvas) return;
        // Add this line to force a render when dragging starts
        if (typeof chart.needsRenderRef?.current !== "undefined") {
            chart.needsRenderRef.current = true;
        }
        const rect = canvas.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        // Only allow dragging in the main chart area
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            return;
        }
        setIsDragging(true);
        setDragStart({
            x,
            y
        });
        // Set cursor style directly for immediate feedback
        canvas.style.cursor = "grabbing";
    };
    const handleMouseMove = (e)=>{
        if (!canvas) return;
        const rect = canvas.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        setMousePosition({
            x,
            y
        });
        // Only handle dragging in the main chart area
        if (chart.isDragging && (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            const deltaX = x - chart.dragStart.x;
            const chartWidth = dimensions.width - priceScaleWidth;
            const visibleCount = visibleRange.end - visibleRange.start;
            // Calculate move amount based on drag distance with PC-appropriate sensitivity
            const pcSensitivity = 0.3; // Much lower sensitivity for smoother PC dragging
            const moveAmount = deltaX / chartWidth * visibleCount * pcSensitivity * -1;
            // Store the current visible range width to maintain zoom level
            const rangeWidth = visibleRange.end - visibleRange.start;
            setVisibleRange((prev)=>{
                let newStart = prev.start + moveAmount;
                let newEnd = prev.end + moveAmount;
                // Calculate minimum visible candles based on zoom level (at least 5 or 30% of visible range)
                const minVisibleCandles = Math.max(5, visibleCount * 0.3);
                // Limit future viewing to 50% of chart width beyond the last candle
                const maxEnd = candleData.length + rangeWidth * 0.5;
                // Handle boundary conditions while preserving zoom level
                if (newStart < -visibleCount * 0.1) {
                    newStart = -visibleCount * 0.1;
                    newEnd = newStart + rangeWidth;
                } else if (newEnd > maxEnd) {
                    newEnd = maxEnd;
                    newStart = newEnd - rangeWidth;
                }
                // Additional check to ensure we don't lose all candles when dragging into future
                if (newStart >= candleData.length - minVisibleCandles) {
                    newStart = candleData.length - minVisibleCandles;
                    newEnd = newStart + rangeWidth;
                }
                // Check if we need to fetch older data
                if (newStart <= 5) {
                    if (typeof shouldFetchOlderData === "function" && shouldFetchOlderData()) {
                        fetchOlderData();
                    }
                }
                return {
                    start: newStart,
                    end: newEnd
                };
            });
            setDragStart({
                x,
                y
            });
        }
        // Update cursor style based on position
        if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            canvas.style.cursor = chart.isDragging ? "grabbing" : "grab";
        } else {
            canvas.style.cursor = "default";
        }
    };
    const handleMouseUp = (e)=>{
        setIsDragging(false);
        // Add this line to force a render when dragging ends
        if (typeof chart.needsRenderRef?.current !== "undefined") {
            chart.needsRenderRef.current = true;
        }
        // Reset cursor style
        if (canvas) {
            const rect = canvas.getBoundingClientRect();
            const x = e.clientX - rect.left;
            const y = e.clientY - rect.top;
            // Only set grab cursor in the main chart area
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
                canvas.style.cursor = "grab";
            } else {
                canvas.style.cursor = "default";
            }
        }
    };
    const handleMouseLeave = ()=>{
        setIsDragging(false);
        setMousePosition(null);
        // Reset cursor style
        if (canvas) {
            canvas.style.cursor = "default";
        }
    };
    const handleWheel = (e)=>{
        e.preventDefault();
        const rect = canvas.getBoundingClientRect();
        const mouseX = e.clientX - rect.left;
        const mouseY = e.clientY - rect.top;
        // Only handle zoom in the main chart area
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(mouseX, mouseY, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
            return;
        }
        const chartWidth = dimensions.width - priceScaleWidth;
        const visibleCount = visibleRange.end - visibleRange.start;
        // Calculate zoom center in data space
        const zoomCenterIndex = mouseX / chartWidth * visibleCount + visibleRange.start;
        // Determine zoom direction and factor
        const zoomDirection = e.deltaY > 0 ? 1 : -1;
        const zoomFactor = 1 + zoomDirection * 0.2;
        // Calculate new visible range
        const newVisibleCount = visibleCount * zoomFactor;
        // Ensure we don't zoom in too far or out too far
        const minVisibleCount = 10;
        const maxVisibleCount = candleData.length * 1.2;
        const clampedVisibleCount = Math.max(minVisibleCount, Math.min(maxVisibleCount, newVisibleCount));
        // Calculate new start and end while keeping the mouse position fixed
        const zoomCenterRatio = (zoomCenterIndex - visibleRange.start) / visibleCount;
        const newStart = zoomCenterIndex - zoomCenterRatio * clampedVisibleCount;
        const newEnd = newStart + clampedVisibleCount;
        // Limit future viewing to 50% of visible range beyond the last candle
        const maxEnd = candleData.length + clampedVisibleCount * 0.5;
        // Apply boundaries while preserving zoom level
        let adjustedStart = newStart;
        let adjustedEnd = newEnd;
        if (adjustedEnd > maxEnd) {
            adjustedEnd = maxEnd;
            adjustedStart = adjustedEnd - clampedVisibleCount;
        }
        // Ensure we always keep at least some candles visible
        if (adjustedStart >= candleData.length - Math.max(10, clampedVisibleCount * 0.3)) {
            adjustedStart = candleData.length - Math.max(10, clampedVisibleCount * 0.3);
            adjustedEnd = adjustedStart + clampedVisibleCount;
        }
        // Check if we need to fetch older data
        if (adjustedStart <= 5) {
            if (typeof shouldFetchOlderData === "function" && shouldFetchOlderData()) {
                fetchOlderData();
            }
        }
        // Update visible range
        setVisibleRange({
            start: Math.max(0, adjustedStart),
            end: adjustedEnd
        });
    };
    // Improved touch event handlers
    const handleTouchStart = (e)=>{
        touchStartTime = Date.now();
        // Prevent default to avoid scrolling/zooming browser behavior
        if (e.cancelable) {
            e.preventDefault();
        }
        if (e.touches.length === 1) {
            const rect = canvas.getBoundingClientRect();
            const x = e.touches[0].clientX - rect.left;
            const y = e.touches[0].clientY - rect.top;
            // Only allow touch interactions in the main chart area
            if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
                return;
            }
            setIsDragging(true);
            setDragStart({
                x: e.touches[0].clientX,
                y: e.touches[0].clientY
            });
            // Add hardware acceleration class
            canvas.classList.add("touch-dragging");
        } else if (e.touches.length === 2) {
            // Stop any dragging when starting pinch
            setIsDragging(false);
            // Handle pinch zoom initialization
            const distance = Math.hypot(e.touches[0].clientX - e.touches[1].clientX, e.touches[0].clientY - e.touches[1].clientY);
            initialTouchDistance = distance;
            // Add pinch class for visual feedback
            canvas.classList.add("touch-pinching");
        }
    };
    const handleTouchMove = (e)=>{
        // Prevent default to avoid passive listener warning
        if (e.cancelable) {
            e.preventDefault();
        }
        const now = Date.now();
        // Throttle touch move events for better performance
        if (now - lastTouchUpdate < TOUCH_THROTTLE_MS) {
            return;
        }
        lastTouchUpdate = now;
        if (e.touches.length === 1 && chart.isDragging) {
            const rect = canvas.getBoundingClientRect();
            const x = e.touches[0].clientX - rect.left;
            const y = e.touches[0].clientY - rect.top;
            // Only process touch move in the main chart area
            if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$helpers$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isInMainChartArea"])(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
                return;
            }
            const deltaX = e.touches[0].clientX - chart.dragStart.x;
            const chartWidth = dimensions.width - priceScaleWidth;
            const visibleCount = visibleRange.end - visibleRange.start;
            // Improved touch sensitivity for mobile devices
            const touchSensitivity = 0.2; // Balanced sensitivity for mobile touch
            const moveAmount = deltaX / chartWidth * visibleCount * touchSensitivity * -1;
            setVisibleRange((prev)=>{
                let newStart = prev.start + moveAmount;
                let newEnd = prev.end + moveAmount;
                const rangeWidth = visibleRange.end - visibleRange.start;
                const minVisibleCandles = Math.max(5, visibleCount * 0.3);
                const maxEnd = candleData.length + rangeWidth * 0.5;
                // Handle boundary conditions
                if (newStart < -visibleCount * 0.1) {
                    newStart = -visibleCount * 0.1;
                    newEnd = newStart + rangeWidth;
                } else if (newEnd > maxEnd) {
                    newEnd = maxEnd;
                    newStart = newEnd - rangeWidth;
                }
                if (newStart >= candleData.length - minVisibleCandles) {
                    newStart = candleData.length - minVisibleCandles;
                    newEnd = newStart + rangeWidth;
                }
                // Check for older data fetch
                if (newStart <= 5) {
                    if (typeof shouldFetchOlderData === "function" && shouldFetchOlderData()) {
                        fetchOlderData();
                    }
                }
                return {
                    start: newStart,
                    end: newEnd
                };
            });
            // Update drag position for next calculation
            setDragStart({
                x: e.touches[0].clientX,
                y: e.touches[0].clientY
            });
        } else if (e.touches.length === 2 && initialTouchDistance > 0) {
            // Handle pinch zoom
            const currentDistance = Math.hypot(e.touches[0].clientX - e.touches[1].clientX, e.touches[0].clientY - e.touches[1].clientY);
            const scale = currentDistance / initialTouchDistance;
            const visibleCount = visibleRange.end - visibleRange.start;
            // Calculate zoom with improved sensitivity
            // Use scale directly (not inverted) - pinch out to zoom in, pinch in to zoom out
            const zoomSensitivity = 0.5; // Adjust sensitivity for smoother zooming
            const zoomFactor = 1 + (1 - scale) * zoomSensitivity;
            const newVisibleCount = Math.max(10, Math.min(candleData.length * 1.5, visibleCount * zoomFactor));
            // Calculate center point for zoom
            const rect = canvas.getBoundingClientRect();
            const centerX = (e.touches[0].clientX + e.touches[1].clientX) / 2 - rect.left;
            const chartWidth = dimensions.width - priceScaleWidth;
            const centerRatio = centerX / chartWidth;
            const currentCenter = visibleRange.start + visibleCount * centerRatio;
            const newStart = currentCenter - newVisibleCount * centerRatio;
            const newEnd = newStart + newVisibleCount;
            // Ensure we stay within reasonable bounds
            let adjustedStart = Math.max(-visibleCount * 0.1, newStart);
            let adjustedEnd = Math.min(candleData.length * 1.5, newEnd);
            // If we hit a boundary, adjust the other end to maintain the zoom level
            if (adjustedStart <= 0) {
                adjustedEnd = Math.min(candleData.length * 1.5, newVisibleCount);
                adjustedStart = 0;
            }
            setVisibleRange({
                start: adjustedStart,
                end: adjustedEnd
            });
            initialTouchDistance = currentDistance;
        }
    };
    const handleTouchEnd = ()=>{
        setIsDragging(false);
        initialTouchDistance = 0;
        // Remove hardware acceleration classes
        canvas.classList.remove("touch-dragging");
        canvas.classList.remove("touch-pinching");
        // Force a final render to ensure clean state
        if (typeof chart.needsRenderRef?.current !== "undefined") {
            chart.needsRenderRef.current = true;
        }
    };
    // Add event listeners with proper passive flags
    canvas.addEventListener("mousedown", handleMouseDown, {
        passive: true
    });
    window.addEventListener("mousemove", handleMouseMove, {
        passive: true
    });
    window.addEventListener("mouseup", handleMouseUp, {
        passive: true
    });
    canvas.addEventListener("mouseleave", handleMouseLeave, {
        passive: true
    });
    canvas.addEventListener("wheel", handleWheel, {
        passive: false
    });
    // Touch events - use passive: false to allow preventDefault
    canvas.addEventListener("touchstart", handleTouchStart, {
        passive: false
    });
    canvas.addEventListener("touchmove", handleTouchMove, {
        passive: false
    });
    canvas.addEventListener("touchend", handleTouchEnd, {
        passive: false
    });
    canvas.addEventListener("touchcancel", handleTouchEnd, {
        passive: false
    });
    // Return cleanup function
    return ()=>{
        canvas.removeEventListener("mousedown", handleMouseDown);
        window.removeEventListener("mousemove", handleMouseMove);
        window.removeEventListener("mouseup", handleMouseUp);
        canvas.removeEventListener("mouseleave", handleMouseLeave);
        canvas.removeEventListener("wheel", handleWheel);
        canvas.removeEventListener("touchstart", handleTouchStart);
        canvas.removeEventListener("touchmove", handleTouchMove);
        canvas.removeEventListener("touchend", handleTouchEnd);
        canvas.removeEventListener("touchcancel", handleTouchEnd);
    };
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/performance/render-manager.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Performance-optimized render manager for chart rendering
 * Implements efficient rendering using RAF, throttling, and caching
 */ __turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
class RenderManager {
    static instance;
    renderState = {
        lastRenderTime: 0,
        renderQueued: false,
        lastHash: "",
        frameId: null
    };
    THROTTLE_INTERVAL = 16;
    HIGH_PRIORITY_INTERVAL = 8;
    MAX_RENDER_TIME = 100;
    static getInstance() {
        if (!RenderManager.instance) {
            RenderManager.instance = new RenderManager();
        }
        return RenderManager.instance;
    }
    /**
   * Queue a render operation with throttling
   */ queueRender(renderFn, options = {}) {
        const now = performance.now();
        const timeSinceLastRender = now - this.renderState.lastRenderTime;
        // Determine throttle interval based on priority
        const throttleInterval = options.highPriority ? this.HIGH_PRIORITY_INTERVAL : this.THROTTLE_INTERVAL;
        // Force render if enough time has passed or if explicitly requested
        const shouldForceRender = options.forceRender || timeSinceLastRender > this.MAX_RENDER_TIME;
        // Skip if render is already queued and not high priority
        if (this.renderState.renderQueued && !options.highPriority && !shouldForceRender) {
            return;
        }
        // Cancel existing frame if we have a higher priority render
        if (this.renderState.frameId !== null && options.highPriority) {
            cancelAnimationFrame(this.renderState.frameId);
            this.renderState.frameId = null;
        }
        // Throttle non-critical renders
        if (!shouldForceRender && timeSinceLastRender < throttleInterval) {
            if (!this.renderState.renderQueued) {
                this.renderState.renderQueued = true;
                this.renderState.frameId = requestAnimationFrame(()=>{
                    this.executeRender(renderFn, options);
                });
            }
            return;
        }
        // Execute immediately for high priority or overdue renders
        this.executeRender(renderFn, options);
    }
    executeRender(renderFn, options) {
        const startTime = performance.now();
        try {
            renderFn();
            this.renderState.lastRenderTime = performance.now();
        } catch (error) {
            console.error("Render error:", error);
        } finally{
            this.renderState.renderQueued = false;
            this.renderState.frameId = null;
            // Log performance for development
            if ("TURBOPACK compile-time truthy", 1) {
                const renderTime = performance.now() - startTime;
                if (renderTime > 16) {
                    console.warn(`Slow render detected: ${renderTime.toFixed(2)}ms`);
                }
            }
        }
    }
    /**
   * Generate a hash for render data to detect changes
   */ generateRenderHash(data) {
        // Simple hash function for detecting data changes
        return JSON.stringify({
            dataLength: data.candleData?.length || 0,
            visibleStart: data.visibleRange?.start || 0,
            visibleEnd: data.visibleRange?.end || 0,
            mouseX: data.mousePosition?.x || 0,
            mouseY: data.mousePosition?.y || 0,
            chartType: data.chartType,
            indicators: data.indicators?.map((i)=>i.id).join(",") || "",
            theme: data.theme,
            isDragging: data.isDragging
        });
    }
    /**
   * Check if render is needed based on data changes
   */ shouldRender(data, options = {}) {
        if (options.forceRender || options.skipCache) {
            return true;
        }
        const currentHash = this.generateRenderHash(data);
        const hasChanged = currentHash !== this.renderState.lastHash;
        if (hasChanged) {
            this.renderState.lastHash = currentHash;
        }
        return hasChanged;
    }
    /**
   * Force render for resize events
   */ forceRenderForResize(renderFn) {
        // Cancel any existing render
        if (this.renderState.frameId !== null) {
            cancelAnimationFrame(this.renderState.frameId);
            this.renderState.frameId = null;
        }
        // Execute immediately with highest priority
        this.executeRender(renderFn, {
            forceRender: true,
            highPriority: true
        });
    }
    /**
   * Cleanup resources
   */ cleanup() {
        if (this.renderState.frameId !== null) {
            cancelAnimationFrame(this.renderState.frameId);
            this.renderState.frameId = null;
        }
        this.renderState.renderQueued = false;
    }
}
const __TURBOPACK__default__export__ = RenderManager;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/performance/memory-manager.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Memory management utilities for chart performance optimization
 * Handles canvas memory, object pooling, and efficient data structures
 */ __turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
class MemoryManager {
    static instance;
    canvasPool = [];
    objectPools = new Map();
    MAX_POOL_SIZE = 10;
    POOL_CLEANUP_INTERVAL = 30000;
    cleanupInterval = null;
    static getInstance() {
        if (!MemoryManager.instance) {
            MemoryManager.instance = new MemoryManager();
        }
        return MemoryManager.instance;
    }
    constructor(){
        this.startCleanupInterval();
    }
    /**
   * Get or create a canvas from the pool
   */ getCanvas(width, height) {
        // Try to find an unused canvas with matching dimensions
        let pooledCanvas = this.canvasPool.find((pc)=>!pc.inUse && pc.canvas.width === width && pc.canvas.height === height);
        if (!pooledCanvas) {
            // Create new canvas if none available
            const canvas = document.createElement("canvas");
            const ctx = canvas.getContext("2d", {
                alpha: false,
                desynchronized: true
            });
            if (!ctx) {
                throw new Error("Failed to get 2D context");
            }
            canvas.width = width;
            canvas.height = height;
            pooledCanvas = {
                canvas,
                ctx,
                inUse: false,
                lastUsed: Date.now()
            };
            // Add to pool if under limit
            if (this.canvasPool.length < this.MAX_POOL_SIZE) {
                this.canvasPool.push(pooledCanvas);
            }
        }
        pooledCanvas.inUse = true;
        pooledCanvas.lastUsed = Date.now();
        return pooledCanvas;
    }
    /**
   * Return a canvas to the pool
   */ releaseCanvas(pooledCanvas) {
        pooledCanvas.inUse = false;
        pooledCanvas.lastUsed = Date.now();
        // Clear the canvas for reuse
        const { canvas, ctx } = pooledCanvas;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
    /**
   * Get an object from a typed pool
   */ getPooledObject(poolName, factory) {
        let pool = this.objectPools.get(poolName);
        if (!pool) {
            pool = [];
            this.objectPools.set(poolName, pool);
        }
        // Find unused object
        let obj = pool.find((o)=>!o.inUse);
        if (!obj) {
            // Create new object if none available
            obj = factory();
            obj.poolId = poolName;
            // Add to pool if under limit
            if (pool.length < this.MAX_POOL_SIZE) {
                pool.push(obj);
            }
        }
        obj.inUse = true;
        return obj;
    }
    /**
   * Return an object to its pool
   */ releasePooledObject(obj) {
        obj.inUse = false;
        // Reset object properties (except pool metadata)
        Object.keys(obj).forEach((key)=>{
            if (key !== "poolId" && key !== "inUse") {
                delete obj[key];
            }
        });
    }
    /**
   * Optimize canvas for better performance
   */ optimizeCanvas(canvas, ctx) {
        // Set canvas properties for better performance
        ctx.imageSmoothingEnabled = false;
        // Use device pixel ratio for crisp rendering
        const pixelRatio = window.devicePixelRatio || 1;
        if (pixelRatio !== 1) {
            const rect = canvas.getBoundingClientRect();
            canvas.width = rect.width * pixelRatio;
            canvas.height = rect.height * pixelRatio;
            canvas.style.width = rect.width + "px";
            canvas.style.height = rect.height + "px";
            ctx.scale(pixelRatio, pixelRatio);
        }
    }
    /**
   * Efficient array operations for large datasets
   */ sliceDataEfficiently(data, start, end, buffer = 50) {
        // Add buffer to reduce frequent re-slicing
        const bufferedStart = Math.max(0, start - buffer);
        const bufferedEnd = Math.min(data.length, end + buffer);
        return data.slice(bufferedStart, bufferedEnd);
    }
    /**
   * Debounce function for reducing excessive calls
   */ debounce(func, delay) {
        let timeoutId;
        return (...args)=>{
            clearTimeout(timeoutId);
            timeoutId = setTimeout(()=>func(...args), delay);
        };
    }
    /**
   * Throttle function for limiting call frequency
   */ throttle(func, delay) {
        let lastCall = 0;
        return (...args)=>{
            const now = Date.now();
            if (now - lastCall >= delay) {
                lastCall = now;
                func(...args);
            }
        };
    }
    /**
   * Start cleanup interval for unused resources
   */ startCleanupInterval() {
        this.cleanupInterval = setInterval(()=>{
            this.cleanup();
        }, this.POOL_CLEANUP_INTERVAL);
    }
    /**
   * Clean up unused resources
   */ cleanup() {
        const now = Date.now();
        const maxAge = 60000; // 1 minute
        // Clean up canvas pool
        this.canvasPool = this.canvasPool.filter((pc)=>{
            if (!pc.inUse && now - pc.lastUsed > maxAge) {
                // Remove canvas from DOM if needed
                if (pc.canvas.parentNode) {
                    pc.canvas.parentNode.removeChild(pc.canvas);
                }
                return false;
            }
            return true;
        });
        // Clean up object pools
        this.objectPools.forEach((pool, poolName)=>{
            const cleanPool = pool.filter((obj)=>obj.inUse);
            if (cleanPool.length === 0) {
                this.objectPools.delete(poolName);
            } else if (cleanPool.length < pool.length) {
                this.objectPools.set(poolName, cleanPool);
            }
        });
    }
    /**
   * Force cleanup and destroy all resources
   */ destroy() {
        if (this.cleanupInterval) {
            clearInterval(this.cleanupInterval);
            this.cleanupInterval = null;
        }
        // Clean up all canvases
        this.canvasPool.forEach((pc)=>{
            if (pc.canvas.parentNode) {
                pc.canvas.parentNode.removeChild(pc.canvas);
            }
        });
        this.canvasPool = [];
        // Clear all object pools
        this.objectPools.clear();
    }
    /**
   * Get memory usage statistics
   */ getMemoryStats() {
        const totalPooledObjects = Array.from(this.objectPools.values()).reduce((total, pool)=>total + pool.length, 0);
        return {
            canvasPoolSize: this.canvasPool.length,
            activeCanvases: this.canvasPool.filter((pc)=>pc.inUse).length,
            objectPoolsCount: this.objectPools.size,
            totalPooledObjects
        };
    }
    /**
   * Track virtual rendering metrics for memory optimization
   */ virtualRenderingMetrics = {
        renderedCandles: 0,
        totalCandles: 0,
        lastUpdate: 0
    };
    /**
   * Update virtual rendering metrics
   */ updateVirtualRenderingMetrics(renderedCandles, totalCandles) {
        this.virtualRenderingMetrics = {
            renderedCandles,
            totalCandles,
            lastUpdate: performance.now()
        };
    }
    /**
   * Get virtual rendering memory savings
   */ getVirtualRenderingStats() {
        const { renderedCandles, totalCandles } = this.virtualRenderingMetrics;
        const memoryReduction = totalCandles > 0 ? (totalCandles - renderedCandles) / totalCandles * 100 : 0;
        // Estimate memory savings (rough calculation: ~1KB per candle including indicators)
        const savedCandles = totalCandles - renderedCandles;
        const estimatedSavingsMB = savedCandles * 1024 / (1024 * 1024);
        return {
            renderedCandles,
            totalCandles,
            memoryReduction,
            estimatedSavingsMB
        };
    }
}
const __TURBOPACK__default__export__ = MemoryManager;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/performance/data-cache.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Data caching system for chart performance optimization
 * Implements LRU cache, computed value caching, and efficient data structures
 */ __turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
class DataCache {
    static instance;
    cache = new Map();
    computedCache = new Map();
    maxSize = 1000;
    maxAge = 300000;
    cleanupInterval = null;
    static getInstance() {
        if (!DataCache.instance) {
            DataCache.instance = new DataCache();
        }
        return DataCache.instance;
    }
    constructor(){
        this.startCleanupInterval();
    }
    /**
   * Set a value in the cache
   */ set(key, value) {
        const now = Date.now();
        // Remove oldest entries if cache is full
        if (this.cache.size >= this.maxSize) {
            this.evictOldest();
        }
        this.cache.set(key, {
            key,
            value,
            timestamp: now,
            accessCount: 0,
            lastAccess: now
        });
    }
    /**
   * Get a value from the cache
   */ get(key) {
        const entry = this.cache.get(key);
        if (!entry) {
            return null;
        }
        const now = Date.now();
        // Check if entry is expired
        if (now - entry.timestamp > this.maxAge) {
            this.cache.delete(key);
            return null;
        }
        // Update access statistics
        entry.accessCount++;
        entry.lastAccess = now;
        return entry.value;
    }
    /**
   * Check if a key exists in cache
   */ has(key) {
        const entry = this.cache.get(key);
        if (!entry) {
            return false;
        }
        const now = Date.now();
        if (now - entry.timestamp > this.maxAge) {
            this.cache.delete(key);
            return false;
        }
        return true;
    }
    /**
   * Delete a specific key from cache
   */ delete(key) {
        return this.cache.delete(key);
    }
    /**
   * Clear all cache entries
   */ clear() {
        this.cache.clear();
        this.computedCache.clear();
    }
    /**
   * Cache computed values with dependency tracking
   */ setComputed(key, value, dependencies = []) {
        this.computedCache.set(key, {
            value,
            dependencies,
            computed: Date.now(),
            valid: true
        });
    }
    /**
   * Get computed value if still valid
   */ getComputed(key) {
        const computed = this.computedCache.get(key);
        if (!computed || !computed.valid) {
            return null;
        }
        // Check if dependencies are still valid
        for (const dep of computed.dependencies){
            if (!this.has(dep)) {
                computed.valid = false;
                return null;
            }
        }
        return computed.value;
    }
    /**
   * Invalidate computed values that depend on a key
   */ invalidateDependent(key) {
        for (const [computedKey, computed] of this.computedCache.entries()){
            if (computed.dependencies.includes(key)) {
                computed.valid = false;
            }
        }
    }
    /**
   * Memoize expensive calculations
   */ memoize(fn, keyGenerator) {
        const cache = new Map();
        return (...args)=>{
            const key = keyGenerator ? keyGenerator(...args) : JSON.stringify(args);
            if (cache.has(key)) {
                return cache.get(key);
            }
            const result = fn(...args);
            cache.set(key, result);
            // Clean up cache if it gets too large
            if (cache.size > 100) {
                const keys = Array.from(cache.keys());
                const toDelete = keys.slice(0, 50);
                toDelete.forEach((k)=>cache.delete(k));
            }
            return result;
        };
    }
    /**
   * Cache candlestick data with smart invalidation
   */ setCandleData(symbol, timeframe, data) {
        const key = `candles_${symbol}_${timeframe}`;
        this.set(key, data);
        // Invalidate computed values that depend on this data
        this.invalidateDependent(key);
    }
    /**
   * Get cached candlestick data
   */ getCandleData(symbol, timeframe) {
        const key = `candles_${symbol}_${timeframe}`;
        return this.get(key);
    }
    /**
   * Cache indicator calculations
   */ setIndicatorData(symbol, timeframe, indicatorType, params, data) {
        const key = `indicator_${symbol}_${timeframe}_${indicatorType}_${JSON.stringify(params)}`;
        const candleKey = `candles_${symbol}_${timeframe}`;
        this.setComputed(key, data, [
            candleKey
        ]);
    }
    /**
   * Get cached indicator data
   */ getIndicatorData(symbol, timeframe, indicatorType, params) {
        const key = `indicator_${symbol}_${timeframe}_${indicatorType}_${JSON.stringify(params)}`;
        return this.getComputed(key);
    }
    /**
   * Cache rendered frame data
   */ setRenderCache(key, imageData) {
        // Only cache small render artifacts to avoid memory issues
        if (imageData instanceof ImageData && imageData.data.length < 1000000) {
            this.set(`render_${key}`, imageData);
        }
    }
    /**
   * Get cached render data
   */ getRenderCache(key) {
        return this.get(`render_${key}`);
    }
    /**
   * Evict oldest entries based on LRU algorithm
   */ evictOldest() {
        let oldestKey = "";
        let oldestTime = Infinity;
        for (const [key, entry] of this.cache.entries()){
            // Prefer to evict entries with low access count and old last access time
            const score = entry.lastAccess - entry.accessCount * 10000;
            if (score < oldestTime) {
                oldestTime = score;
                oldestKey = key;
            }
        }
        if (oldestKey) {
            this.cache.delete(oldestKey);
        }
    }
    /**
   * Clean up expired entries
   */ cleanup() {
        const now = Date.now();
        // Clean up main cache
        for (const [key, entry] of this.cache.entries()){
            if (now - entry.timestamp > this.maxAge) {
                this.cache.delete(key);
            }
        }
        // Clean up computed cache
        for (const [key, computed] of this.computedCache.entries()){
            if (!computed.valid || now - computed.computed > this.maxAge) {
                this.computedCache.delete(key);
            }
        }
    }
    /**
   * Start cleanup interval
   */ startCleanupInterval() {
        this.cleanupInterval = setInterval(()=>{
            this.cleanup();
        }, 60000); // Clean up every minute
    }
    /**
   * Get cache statistics
   */ getStats() {
        const hits = Array.from(this.cache.values()).reduce((total, entry)=>total + entry.accessCount, 0);
        const misses = this.cache.size; // Approximation
        return {
            size: this.cache.size,
            maxSize: this.maxSize,
            hitRate: hits / (hits + misses) || 0,
            computedSize: this.computedCache.size
        };
    }
    /**
   * Destroy cache and cleanup
   */ destroy() {
        if (this.cleanupInterval) {
            clearInterval(this.cleanupInterval);
            this.cleanupInterval = null;
        }
        this.clear();
    }
}
const __TURBOPACK__default__export__ = DataCache;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/performance/virtual-renderer.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Virtual rendering manager for optimized chart performance
 * Only renders candles and indicators that are visible in the viewport
 */ __turbopack_context__.s([
    "calculateLevelOfDetail",
    ()=>calculateLevelOfDetail,
    "default",
    ()=>__TURBOPACK__default__export__,
    "getVirtualCandles",
    ()=>getVirtualCandles,
    "getVirtualIndicatorData",
    ()=>getVirtualIndicatorData
]);
class VirtualRenderer {
    static instance;
    cache = new Map();
    CACHE_SIZE = 50;
    BUFFER_SIZE = 20;
    MIN_CANDLE_WIDTH = 0.5;
    static getInstance() {
        if (!VirtualRenderer.instance) {
            VirtualRenderer.instance = new VirtualRenderer();
        }
        return VirtualRenderer.instance;
    }
    /**
   * Calculate visible viewport and determine which candles to render
   */ calculateVirtualViewport(candleData, visibleRange, chartWidth) {
        // Generate cache key
        const cacheKey = this.generateCacheKey(candleData, visibleRange, chartWidth);
        // Check cache first
        const cached = this.cache.get(cacheKey);
        if (cached) {
            return cached;
        }
        // Calculate viewport bounds
        const startIndex = Math.max(0, Math.floor(visibleRange.start));
        const endIndex = Math.min(candleData.length, Math.ceil(visibleRange.end));
        // Calculate buffer bounds for smooth scrolling
        const bufferStart = Math.max(0, startIndex - this.BUFFER_SIZE);
        const bufferEnd = Math.min(candleData.length, endIndex + this.BUFFER_SIZE);
        // Calculate candle dimensions
        const visibleCount = visibleRange.end - visibleRange.start;
        const candleWidth = chartWidth / visibleCount;
        const spacing = Math.max(1, candleWidth * 0.1);
        // Skip rendering if candles are too small
        if (candleWidth < this.MIN_CANDLE_WIDTH) {
            const result = {
                candles: [],
                viewport: {
                    startIndex,
                    endIndex,
                    bufferStart,
                    bufferEnd,
                    visibleWidth: chartWidth,
                    candleWidth: 0,
                    spacing: 0
                },
                renderItems: [],
                hash: cacheKey
            };
            this.addToCache(cacheKey, result);
            return result;
        }
        // Get buffered candle data
        const bufferedCandles = candleData.slice(bufferStart, bufferEnd);
        // Calculate render items with positions
        const renderItems = bufferedCandles.map((candle, i)=>{
            const actualIndex = bufferStart + i;
            const x = (actualIndex - visibleRange.start) / visibleCount * chartWidth;
            return {
                candle,
                x,
                index: actualIndex,
                isVisible: x >= -candleWidth && x <= chartWidth + candleWidth
            };
        });
        // Filter to only visible items for performance
        const visibleRenderItems = renderItems.filter((item)=>item.isVisible);
        const result = {
            candles: bufferedCandles,
            viewport: {
                startIndex,
                endIndex,
                bufferStart,
                bufferEnd,
                visibleWidth: chartWidth,
                candleWidth: Math.max(1, candleWidth * 0.8),
                spacing: Math.max(0.5, spacing)
            },
            renderItems: visibleRenderItems,
            hash: cacheKey
        };
        this.addToCache(cacheKey, result);
        return result;
    }
    /**
   * Get virtual candle data for indicators
   */ getVirtualIndicatorData(indicatorData, virtualData) {
        if (!indicatorData || indicatorData.length === 0) {
            return [];
        }
        const { bufferStart, bufferEnd } = virtualData.viewport;
        const start = Math.max(0, bufferStart);
        const end = Math.min(indicatorData.length, bufferEnd);
        return indicatorData.slice(start, end);
    }
    /**
   * Calculate which price levels need grid lines (virtual grid)
   */ calculateVirtualPriceGrid(minPrice, maxPrice, chartHeight, maxGridLines = 10) {
        const priceRange = maxPrice - minPrice;
        const idealStep = priceRange / maxGridLines;
        // Find a nice round number for the step
        const magnitude = Math.pow(10, Math.floor(Math.log10(idealStep)));
        const normalizedStep = idealStep / magnitude;
        let step;
        if (normalizedStep <= 1) {
            step = magnitude;
        } else if (normalizedStep <= 2) {
            step = 2 * magnitude;
        } else if (normalizedStep <= 5) {
            step = 5 * magnitude;
        } else {
            step = 10 * magnitude;
        }
        const gridLines = [];
        const startPrice = Math.ceil(minPrice / step) * step;
        for(let price = startPrice; price <= maxPrice; price += step){
            const y = (maxPrice - price) / priceRange * chartHeight;
            gridLines.push({
                price,
                y
            });
        }
        return gridLines;
    }
    /**
   * Check if we need to recalculate based on scroll/zoom changes
   */ shouldRecalculate(currentRange, cachedHash, candleData, chartWidth) {
        const newHash = this.generateCacheKey(candleData, currentRange, chartWidth);
        return newHash !== cachedHash;
    }
    /**
   * Get performance metrics for development
   */ getPerformanceMetrics() {
        const cacheSize = this.cache.size;
        const memoryUsage = this.estimateMemoryUsage();
        return {
            cacheSize,
            cacheHitRate: 0.85,
            memoryUsage
        };
    }
    /**
   * Clear old cache entries to prevent memory leaks
   */ cleanup() {
        // Keep only the most recent entries
        if (this.cache.size > this.CACHE_SIZE) {
            const entries = Array.from(this.cache.entries());
            // Remove oldest entries (simplified - could use LRU)
            const toRemove = entries.slice(0, entries.length - this.CACHE_SIZE + 10);
            toRemove.forEach(([key])=>this.cache.delete(key));
        }
    }
    generateCacheKey(candleData, visibleRange, chartWidth) {
        return `${candleData.length}_${visibleRange.start.toFixed(2)}_${visibleRange.end.toFixed(2)}_${chartWidth}`;
    }
    addToCache(key, data) {
        this.cache.set(key, data);
        // Cleanup if cache is getting too large
        if (this.cache.size > this.CACHE_SIZE) {
            this.cleanup();
        }
    }
    estimateMemoryUsage() {
        let totalSize = 0;
        this.cache.forEach((data)=>{
            totalSize += data.candles.length * 50; // Rough estimate per candle
            totalSize += data.renderItems.length * 30; // Rough estimate per render item
        });
        return totalSize;
    }
}
const __TURBOPACK__default__export__ = VirtualRenderer;
function getVirtualCandles(candleData, visibleRange, chartWidth) {
    const virtualRenderer = VirtualRenderer.getInstance();
    return virtualRenderer.calculateVirtualViewport(candleData, visibleRange, chartWidth);
}
function getVirtualIndicatorData(indicatorData, virtualData) {
    const virtualRenderer = VirtualRenderer.getInstance();
    return virtualRenderer.getVirtualIndicatorData(indicatorData, virtualData);
}
function calculateLevelOfDetail(visibleRange, chartWidth) {
    const candlesPerPixel = (visibleRange.end - visibleRange.start) / chartWidth;
    if (candlesPerPixel < 0.1) {
        return "high"; // Zoomed in - show full detail
    } else if (candlesPerPixel < 1) {
        return "medium"; // Normal zoom - show simplified details
    } else {
        return "low"; // Zoomed out - show minimal details
    }
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/expiry-marker.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "calculateNextExpiryTime",
    ()=>calculateNextExpiryTime,
    "formatCountdown",
    ()=>formatCountdown,
    "generateExpiryMarkers",
    ()=>generateExpiryMarkers,
    "mapTimestampToIndex",
    ()=>mapTimestampToIndex,
    "renderExpiryMarkers",
    ()=>renderExpiryMarkers
]);
function calculateNextExpiryTime(currentTime, intervalMinutes) {
    // Ensure intervalMinutes is a positive number
    intervalMinutes = Math.max(1, intervalMinutes || 5);
    const minutes = currentTime.getMinutes();
    const remainder = minutes % intervalMinutes;
    const nextExpiryTime = new Date(currentTime);
    if (remainder === 0) {
        // If we're exactly at an interval, use the next one
        nextExpiryTime.setMinutes(minutes + intervalMinutes);
    } else {
        // Otherwise round up to the next interval
        nextExpiryTime.setMinutes(minutes + (intervalMinutes - remainder));
    }
    nextExpiryTime.setSeconds(0);
    nextExpiryTime.setMilliseconds(0);
    return nextExpiryTime;
}
function formatCountdown(timeLeftMs) {
    if (timeLeftMs <= 0) return "00:00";
    const minutes = Math.floor(timeLeftMs / 60000);
    const seconds = Math.floor(timeLeftMs % 60000 / 1000);
    return `${minutes.toString().padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;
}
function generateExpiryMarkers(expiryMinutes = 5, currentTime = new Date()) {
    // Ensure expiryMinutes is a positive number
    expiryMinutes = Math.max(1, expiryMinutes || 5);
    // Calculate the next expiry time based on the selected interval
    const nextExpiryTime = calculateNextExpiryTime(currentTime, expiryMinutes);
    const expiryTimestamp = Math.floor(nextExpiryTime.getTime() / 1000);
    // Create a marker for the next expiry - remove the minutes from the label
    const marker = {
        timestamp: expiryTimestamp,
        label: "",
        color: "#f59e0b"
    };
    return [
        marker
    ];
}
function mapTimestampToIndex(timestamp, candleData) {
    if (!candleData.length) return -1;
    // Find the closest candle to this timestamp
    let closestIndex = -1;
    let minDiff = Number.MAX_SAFE_INTEGER;
    for(let i = 0; i < candleData.length; i++){
        const diff = Math.abs(candleData[i].time - timestamp);
        if (diff < minDiff) {
            minDiff = diff;
            closestIndex = i;
        }
    }
    return closestIndex;
}
// Cache for expiry marker positions to prevent recalculation
const expiryMarkerPositionCache = new Map();
// Calculate X position for a timestamp based on candle positions
function calculateXPosition(timestamp, candleData, chartWidth, visibleRange, currentTime) {
    if (!candleData || candleData.length === 0) {
        return null;
    }
    // Calculate visible data range
    const start = Math.max(0, Math.floor(visibleRange.start));
    const end = Math.min(candleData.length, Math.ceil(visibleRange.end));
    // Convert timestamp to milliseconds for comparison with candle data
    const timestampMs = timestamp * 1000;
    const currentTimeMs = currentTime * 1000;
    // If the timestamp is in the past, find the exact candle it corresponds to
    if (timestampMs <= currentTimeMs) {
        // Find the candle with the closest time to the timestamp
        let closestIndex = -1;
        let minTimeDiff = Number.POSITIVE_INFINITY;
        for(let i = start; i < end; i++){
            const candle = candleData[i];
            const timeDiff = Math.abs(candle.time - timestampMs);
            if (timeDiff < minTimeDiff) {
                minTimeDiff = timeDiff;
                closestIndex = i;
            }
        }
        if (closestIndex !== -1) {
            // Calculate the position based on the index in the visible range
            const position = (closestIndex - visibleRange.start) / (visibleRange.end - visibleRange.start);
            const xPos = Math.floor(position * chartWidth) + 0.5; // Add 0.5 for crisp lines
            return xPos;
        }
    } else {
        // For future timestamps, we need to extrapolate
        // Get the time interval between candles
        if (end - start < 2) {
            return null;
        }
        const timeInterval = (candleData[end - 1].time - candleData[start].time) / (end - start - 1);
        if (timeInterval <= 0) {
            return null;
        }
        // Calculate how many intervals into the future this timestamp is
        const lastCandleTime = candleData[end - 1].time;
        const intervalsIntoFuture = (timestampMs - lastCandleTime) / timeInterval;
        // Calculate the position
        const position = (end - 1 - visibleRange.start + intervalsIntoFuture) / (visibleRange.end - visibleRange.start);
        const xPos = Math.floor(position * chartWidth) + 0.5; // Add 0.5 for crisp lines
        return xPos;
    }
    return null;
}
function renderExpiryMarkers(ctx, expiryMarkers, candleData, chartWidth, chartHeight, chartTop, visibleRange, currentTimeMs, showExpiry = true // Add showExpiry parameter with default value true
) {
    // Add early return if showExpiry is false
    if (!showExpiry || !expiryMarkers || expiryMarkers.length === 0 || !candleData.length) {
        return;
    }
    expiryMarkers.forEach((marker)=>{
        // Rest of the function remains unchanged
        const x = calculateXPosition(marker.timestamp, candleData, chartWidth, visibleRange, Math.floor(currentTimeMs / 1000));
        if (x !== null && x >= 0 && x <= chartWidth) {
            drawMarker(ctx, x, marker, chartHeight, chartTop, Math.floor(currentTimeMs / 1000));
        }
    });
}
// Helper function to draw a marker
function drawMarker(ctx, x, marker, chartHeight, chartTop, currentTimestamp) {
    // Save the current context state
    ctx.save();
    const timeUntilExpiry = marker.timestamp - currentTimestamp;
    const isExpiringSoon = timeUntilExpiry > 0 && timeUntilExpiry <= 60; // 1 minute or less
    // Create a gradient for the vertical line
    const gradient = ctx.createLinearGradient(0, chartTop, 0, chartTop + chartHeight);
    gradient.addColorStop(0, "rgba(245, 158, 11, 0.1)");
    gradient.addColorStop(0.5, "rgba(245, 158, 11, 0.8)");
    gradient.addColorStop(1, "rgba(245, 158, 11, 0.1)");
    // Draw vertical line with gradient and animation
    ctx.beginPath();
    ctx.strokeStyle = isExpiringSoon ? `rgba(239, 68, 68, ${0.7 + 0.3 * Math.sin(Date.now() / 200)})` : gradient;
    ctx.lineWidth = isExpiringSoon ? 2 : 1.5;
    // Use animated dash pattern for expiring soon
    if (isExpiringSoon) {
        const dashOffset = Date.now() / 100 % 16;
        ctx.setLineDash([
            5,
            3
        ]);
        ctx.lineDashOffset = dashOffset;
    } else {
        ctx.setLineDash([
            5,
            3
        ]);
    }
    // Ensure the line is drawn on pixel boundaries for sharpness
    const alignedX = Math.floor(x) + 0.5;
    ctx.moveTo(alignedX, chartTop);
    ctx.lineTo(alignedX, chartTop + chartHeight);
    ctx.stroke();
    ctx.setLineDash([]);
    // Draw countdown at the top position (where the label used to be)
    if (timeUntilExpiry > 0) {
        const minutes = Math.floor(timeUntilExpiry / 60);
        const seconds = timeUntilExpiry % 60;
        const countdownText = `${minutes.toString().padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;
        const labelY = chartTop + 5;
        const countdownWidth = Math.max(ctx.measureText(countdownText).width + 24, 60);
        const countdownHeight = 28;
        // Create a rounded rectangle path for the countdown
        roundRect(ctx, alignedX - countdownWidth / 2, labelY, countdownWidth, countdownHeight, 14);
        // Apply blur effect (simulated with shadow and opacity)
        ctx.shadowColor = "rgba(0, 0, 0, 0.3)";
        ctx.shadowBlur = 10;
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 2;
        // Pulsing effect for countdown when close to expiry
        const pulseIntensity = isExpiringSoon ? 0.8 + 0.2 * Math.sin(Date.now() / 200) : 1;
        // Fill with semi-transparent background
        ctx.fillStyle = isExpiringSoon ? `rgba(239, 68, 68, ${0.85 * pulseIntensity})` : "rgba(245, 158, 11, 0.85)";
        ctx.fill();
        // Add subtle inner glow for countdown
        if (isExpiringSoon) {
            ctx.shadowColor = "rgba(239, 68, 68, 0.7)";
            ctx.shadowBlur = 15;
            ctx.shadowOffsetX = 0;
            ctx.shadowOffsetY = 0;
            ctx.fill();
        }
        // Reset shadow
        ctx.shadowColor = "transparent";
        ctx.shadowBlur = 0;
        // Draw countdown text
        ctx.fillStyle = "#ffffff";
        ctx.font = isExpiringSoon ? "bold 14px Arial" : "bold 13px Arial";
        ctx.textAlign = "center";
        ctx.textBaseline = "middle";
        ctx.fillText(countdownText, alignedX, labelY + countdownHeight / 2);
    }
    // Restore the context state
    ctx.restore();
}
// Helper function to draw rounded rectangles
function roundRect(ctx, x, y, width, height, radius) {
    ctx.beginPath();
    ctx.moveTo(x + radius, y);
    ctx.lineTo(x + width - radius, y);
    ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
    ctx.lineTo(x + width, y + height - radius);
    ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
    ctx.lineTo(x + radius, y + height);
    ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
    ctx.lineTo(x, y + radius);
    ctx.quadraticCurveTo(x, y, x + radius, y);
    ctx.closePath();
}
}),
"[project]/frontend/components/blocks/advanced-chart/utils/animation-utils.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// Animation utility functions
__turbopack_context__.s([
    "countdownAnimation",
    ()=>countdownAnimation,
    "easeInOutQuad",
    ()=>easeInOutQuad,
    "easeOutElastic",
    ()=>easeOutElastic,
    "easeOutQuad",
    ()=>easeOutQuad,
    "flashAnimation",
    ()=>flashAnimation,
    "pulseAnimation",
    ()=>pulseAnimation
]);
function easeOutQuad(t) {
    return t * (2 - t);
}
function easeInOutQuad(t) {
    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
}
function easeOutElastic(t) {
    const p = 0.3;
    return Math.pow(2, -10 * t) * Math.sin((t - p / 4) * (2 * Math.PI) / p) + 1;
}
function pulseAnimation(time, speed = 1, min = 0.6, max = 1) {
    // Creates a pulsing value between min and max
    const normalized = (Math.sin(time * speed) + 1) / 2;
    return min + normalized * (max - min);
}
function flashAnimation(time, flashPoint, duration = 1000) {
    // Creates a flash effect that fades out over duration
    const elapsed = time - flashPoint;
    if (elapsed < 0 || elapsed > duration) return 0;
    return 1 - elapsed / duration;
}
function countdownAnimation(remaining, total) {
    // Animation intensity increases as countdown approaches zero
    const progress = remaining / total;
    return Math.max(0, 1 - Math.pow(progress, 2));
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/position-marker.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "calculateXPosition",
    ()=>calculateXPosition,
    "renderPositionMarkers",
    ()=>renderPositionMarkers
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2f$animation$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils/animation-utils.ts [app-ssr] (ecmascript)");
;
// Animation constants
const ANIMATION_DURATION = 1000; // ms
const PULSE_SPEED = 0.003;
const GLOW_INTENSITY_MIN = 0.3;
const GLOW_INTENSITY_MAX = 0.8;
const EXPIRY_WARNING_THRESHOLD = 30; // seconds
// Helper function to draw rounded rectangles
function roundRect(ctx, x, y, width, height, radius) {
    radius = Math.min(Math.max(0, radius), Math.min(width, height) / 2);
    ctx.beginPath();
    ctx.moveTo(x + radius, y);
    ctx.lineTo(x + width - radius, y);
    ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
    ctx.lineTo(x + width, y + height - radius);
    ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
    ctx.lineTo(x + radius, y + height);
    ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
    ctx.lineTo(x, y + radius);
    ctx.quadraticCurveTo(x, y, x + radius, y);
    ctx.closePath();
}
// Helper function to check if a value is a valid, finite number
function isValidNumber(value) {
    return typeof value === "number" && isFinite(value);
}
function calculateXPosition(timestamp, candleData, chartWidth, visibleRange) {
    if (!candleData.length || visibleRange.start >= visibleRange.end) {
        return null;
    }
    // Get the time range of visible candles
    const visibleStart = Math.max(0, Math.floor(visibleRange.start));
    const visibleEnd = Math.min(candleData.length - 1, Math.ceil(visibleRange.end));
    if (visibleStart >= visibleEnd) return null;
    const firstCandle = candleData[visibleStart];
    const lastCandle = candleData[visibleEnd];
    if (!firstCandle || !lastCandle) return null;
    // Calculate time range
    const startTime = firstCandle.time;
    const endTime = lastCandle.time;
    const timeRange = endTime - startTime;
    if (timeRange <= 0) return null;
    // Calculate position based on time proportion
    const visibleWidth = visibleRange.end - visibleRange.start;
    // For timestamps in the future (beyond the last candle)
    if (timestamp > endTime) {
        // Calculate average time between candles
        const avgCandleTime = timeRange / (visibleEnd - visibleStart);
        // Calculate how many candle widths into the future
        const futureCandles = (timestamp - endTime) / avgCandleTime;
        // Calculate x position
        const x = (visibleEnd + futureCandles - visibleRange.start) / visibleWidth * chartWidth;
        return x;
    }
    // For timestamps in the past (before the first candle)
    if (timestamp < startTime) {
        // Calculate average time between candles
        const avgCandleTime = timeRange / (visibleEnd - visibleStart);
        // Calculate how many candle widths into the past
        const pastCandles = (startTime - timestamp) / avgCandleTime;
        // Calculate x position
        const x = (visibleStart - pastCandles - visibleRange.start) / visibleWidth * chartWidth;
        return x;
    }
    // For timestamps within the visible range
    const position = (timestamp - startTime) / timeRange;
    const relativeIndex = visibleStart + position * (visibleEnd - visibleStart);
    const x = (relativeIndex - visibleRange.start) / visibleWidth * chartWidth;
    return x;
}
// Find the exact X position of an expiry marker
function findExpiryMarkerPosition(expiryTimestamp, candleData, chartWidth, visibleRange) {
    // First try to find an exact match for the expiry timestamp
    for(let i = 0; i < candleData.length; i++){
        const candle = candleData[i];
        // Use a small tolerance (5 seconds) to find matching candles
        if (Math.abs(candle.time - expiryTimestamp) <= 5) {
            // Calculate the X position for this candle
            const relativeIndex = (i - visibleRange.start) / (visibleRange.end - visibleRange.start);
            return relativeIndex * chartWidth;
        }
    }
    // If no exact match, use the standard calculation
    return calculateXPosition(expiryTimestamp, candleData, chartWidth, visibleRange);
}
function renderPositionMarkers(ctx, orders, candleData, chartWidth, chartHeight, chartTop, visibleRange, priceRange, currentTimeMs) {
    if (!orders || orders.length === 0 || !candleData || candleData.length === 0) {
        return;
    }
    // Ensure we have valid price range values
    if (!isValidNumber(priceRange.min) || !isValidNumber(priceRange.max) || priceRange.min >= priceRange.max) {
        console.warn("Invalid price range:", {
            min: priceRange.min,
            max: priceRange.max
        });
        return;
    }
    const minPrice = priceRange.min;
    const maxPrice = priceRange.max;
    const priceChartHeight = chartHeight - chartTop;
    // Convert order format if necessary
    const normalizedOrders = orders.map((order)=>{
        // If the order already has the correct format, return it as is
        if (order.entryTime && order.entryPrice && order.expiryTime && order.type) {
            return order;
        }
        // Otherwise, convert from the binary store format
        const normalizedOrder = {
            id: order.id,
            entryTime: typeof order.entryTime === "number" ? order.entryTime : order.createdAt ? order.createdAt / 1000 : Date.now() / 1000,
            entryPrice: order.entryPrice,
            expiryTime: typeof order.expiryTime === "number" ? order.expiryTime : order.expiryTime ? new Date(order.expiryTime).getTime() / 1000 : Date.now() / 1000 + 300,
            type: order.side === "RISE" ? "CALL" : "PUT",
            amount: order.amount,
            status: order.status,
            createdAt: order.createdAt
        };
        // Determine result based on outcome or other properties
        if (order.outcome) {
            normalizedOrder.result = order.outcome;
        } else if (order.result) {
            normalizedOrder.result = order.result;
        }
        return normalizedOrder;
    });
    // Define price axis width without safety margin
    const priceAxisWidth = 90;
    const effectiveChartWidth = chartWidth - priceAxisWidth;
    // Current time in seconds
    const currentTimeSec = Math.floor(currentTimeMs / 1000);
    // Filter and render orders
    normalizedOrders.forEach((order)=>{
        // Skip invalid orders
        if (!isValidNumber(order.entryPrice) || !isValidNumber(order.entryTime) || !isValidNumber(order.expiryTime)) {
            console.warn("Skipping invalid order:", order);
            return;
        }
        // Determine if the order has expired
        const isExpired = order.expiryTime < currentTimeSec;
        const hasResult = order.status === "COMPLETED" && order.result !== null;
        // Skip orders that are expired and don't have a result
        // For expired orders without results, hide them immediately after expiry
        if (isExpired && !hasResult) {
            return; // Don't render expired orders without results
        }
        // For completed orders with results, show them briefly for the animation
        if (hasResult && isExpired) {
            // Show completed orders for up to 5 seconds after expiry for the result animation
            if (currentTimeSec - order.expiryTime > 5) {
                return;
            }
        }
        // Calculate Y position based on entry price
        // Ensure we have valid price range values
        if (!isValidNumber(minPrice) || !isValidNumber(maxPrice) || minPrice >= maxPrice) {
            console.warn("Invalid price range:", {
                min: minPrice,
                max: maxPrice
            });
            return;
        }
        // Calculate Y position correctly - orders should appear at their entry price level
        // The Y coordinate increases as you go down, so higher prices should have smaller Y values
        const priceRatio = (order.entryPrice - minPrice) / (maxPrice - minPrice);
        // Invert the ratio because canvas Y coordinates are inverted (0 is top)
        const orderY = chartTop + priceChartHeight - priceRatio * priceChartHeight;
        // Ensure Y position is within chart bounds with a small margin
        const margin = 10;
        if (orderY < chartTop - margin || orderY > chartTop + priceChartHeight + margin) {
            return; // Skip orders outside visible price range
        }
        // Skip if Y position is invalid
        if (!isValidNumber(orderY)) {
            console.warn("Invalid orderY position:", orderY);
            return;
        }
        // Set colors based on order type with futuristic palette
        const baseColor = order.type === "CALL" ? "#0078FF" // Pure blue for CALL/RISE
         : "#FF3B30"; // Red for PUT/FALL
        // Secondary colors for effects
        const secondaryColor = order.type === "CALL" ? "#00A3FF" // Light blue for CALL/RISE effects
         : "#FF6B5B"; // Light red for PUT/FALL effects
        // Accent color for highlights
        const accentColor = order.type === "CALL" ? "#00C2FF" // Bright blue accent for CALL/RISE
         : "#FF8F00"; // Orange accent for PUT/FALL
        // Calculate timestamps
        const entryTimestamp = order.entryTime;
        const expiryTimestamp = order.expiryTime;
        // Animation timing
        const creationTime = order.createdAt || Date.now() - 2000; // Default if not provided
        const entryAnimProgress = Math.min(1, (currentTimeMs - creationTime) / ANIMATION_DURATION);
        const entryAnimValue = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2f$animation$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["easeOutElastic"])(entryAnimProgress);
        // Pulse animation based on current time
        const pulseValue = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2f$animation$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["pulseAnimation"])(currentTimeMs, PULSE_SPEED, GLOW_INTENSITY_MIN, GLOW_INTENSITY_MAX);
        // Countdown animation - increases intensity as expiry approaches
        const timeRemaining = expiryTimestamp - currentTimeSec;
        const isNearExpiry = timeRemaining > 0 && timeRemaining < EXPIRY_WARNING_THRESHOLD;
        const countdownIntensity = isNearExpiry ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2f$animation$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["countdownAnimation"])(timeRemaining, EXPIRY_WARNING_THRESHOLD) : 0;
        // Result animation for completed trades
        // Using the hasResult variable defined earlier (line 258)
        const resultFlashIntensity = hasResult ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2f$animation$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["flashAnimation"])(currentTimeMs, typeof order.expiryTime === "number" ? order.expiryTime * 1000 : Date.now(), 2000) : 0;
        // Calculate X positions
        const entryX = calculateXPosition(entryTimestamp, candleData, chartWidth, visibleRange);
        // Use the specialized function to find the exact expiry marker position
        const expiryX = findExpiryMarkerPosition(expiryTimestamp, candleData, chartWidth, visibleRange);
        // Skip if X positions are invalid
        if (entryX === null || expiryX === null || !isValidNumber(entryX) || !isValidNumber(expiryX)) {
            return;
        }
        // Apply color modifications based on animations
        let glowColor = baseColor;
        let glowIntensity = pulseValue;
        // Enhance glow for near-expiry positions
        if (isNearExpiry) {
            glowIntensity = Math.max(glowIntensity, countdownIntensity);
            // Blink effect for last 5 seconds
            if (timeRemaining < 5 && Math.floor(currentTimeMs / 500) % 2 === 0) {
                glowIntensity = 1;
            }
        }
        // Flash effect for completed trades
        if (hasResult) {
            const resultColor = order.result === "WIN" ? "#64FFDA" : "#FF5252";
            glowColor = resultColor;
            glowIntensity = Math.max(glowIntensity, resultFlashIntensity);
        }
        // ===== FUTURISTIC TRADE PATH =====
        // Draw futuristic path with animation
        ctx.beginPath();
        ctx.strokeStyle = baseColor;
        ctx.lineWidth = 2 * entryAnimValue;
        // Create gradient for the line - SAFELY
        try {
            // Ensure all gradient coordinates are valid numbers
            if (isValidNumber(entryX) && isValidNumber(orderY) && isValidNumber(expiryX)) {
                const gradient = ctx.createLinearGradient(entryX, orderY, expiryX, orderY);
                gradient.addColorStop(0, baseColor);
                gradient.addColorStop(1, secondaryColor);
                ctx.strokeStyle = gradient;
            } else {
                // Fallback to solid color if gradient coordinates are invalid
                ctx.strokeStyle = baseColor;
            }
        } catch (error) {
            console.warn("Error creating gradient:", error);
            ctx.strokeStyle = baseColor; // Fallback to solid color
        }
        // Use solid line for completed positions, dashed for active ones
        if (order.status === "COMPLETED") {
            ctx.setLineDash([]); // Solid line for completed positions
        } else {
            // Animated dash pattern
            const dashOffset = currentTimeMs / 100 % 20;
            ctx.setLineDash([
                5,
                4
            ]);
            ctx.lineDashOffset = -dashOffset; // Animate the dash pattern
        }
        // Always draw the line all the way to the expiry point
        // Remove animation for line length - always show full line
        const lineEndX = Math.min(expiryX, effectiveChartWidth);
        // Add glow effect to the line
        ctx.shadowColor = glowColor;
        ctx.shadowBlur = 8 * glowIntensity;
        // Draw the line up to the expiry point or price axis
        if (entryX < effectiveChartWidth) {
            ctx.moveTo(entryX, orderY);
            // Always draw the line all the way to the expiry point, regardless of animation state
            // Make sure we don't exceed the chart width
            const lineEndX = Math.min(expiryX, effectiveChartWidth - 2);
            ctx.lineTo(lineEndX, orderY);
            ctx.stroke();
            // Add vertical line at the end of the position marker (12px height)
            // Only draw the vertical line if we're not at the price axis
            if (lineEndX < effectiveChartWidth - 2) {
                ctx.beginPath();
                ctx.moveTo(lineEndX, orderY - 6);
                ctx.lineTo(lineEndX, orderY + 6);
                ctx.stroke();
            }
        }
        ctx.setLineDash([]);
        ctx.shadowBlur = 0;
        // ===== FUTURISTIC ENTRY POINT MARKER =====
        // Always show entry marker if it's within the chart area
        if (entryX < effectiveChartWidth) {
            // Scale animation for entry point
            const scale = entryAnimValue;
            // Reduced size for the marker
            const markerSize = 8;
            // Draw futuristic entry marker
            // Outer glow
            ctx.shadowColor = glowColor;
            ctx.shadowBlur = 15 * glowIntensity;
            // Hexagonal marker background
            ctx.beginPath();
            drawHexagon(ctx, entryX, orderY, markerSize * scale);
            ctx.fillStyle = "#131722";
            ctx.fill();
            // Hexagonal border with glow
            ctx.beginPath();
            drawHexagon(ctx, entryX, orderY, markerSize * scale);
            ctx.strokeStyle = baseColor;
            ctx.lineWidth = 2 * scale;
            ctx.stroke();
            // Inner hexagon with pulse
            ctx.beginPath();
            drawHexagon(ctx, entryX, orderY, 4 * scale * (1 + pulseValue * 0.3));
            ctx.fillStyle = baseColor;
            ctx.fill();
            // Reset shadow
            ctx.shadowBlur = 0;
            // Draw amount label with holographic effect
            const amountText = `$${order.amount}`;
            ctx.font = "bold 12px Inter, sans-serif";
            const amountW = ctx.measureText(amountText).width + 20;
            const amountSpacing = 20;
            // Only draw amount label if it fits within the chart
            if (entryX - amountW - amountSpacing > 0) {
                // Set opacity based on animation progress
                ctx.globalAlpha = entryAnimValue;
                // Holographic background effect
                ctx.shadowColor = baseColor;
                ctx.shadowBlur = 10 * (0.5 + pulseValue * 0.5);
                // Futuristic background with angled corners - SAFELY
                try {
                    if (isValidNumber(entryX - amountW - amountSpacing) && isValidNumber(orderY - 12) && isValidNumber(amountW) && isValidNumber(24)) {
                        drawFuturisticBox(ctx, entryX - amountW - amountSpacing, orderY - 12, amountW, 24, baseColor, secondaryColor, pulseValue);
                    }
                } catch (error) {
                    console.warn("Error drawing futuristic box:", error);
                }
                // Reset shadow
                ctx.shadowBlur = 0;
                // Amount text with glow
                ctx.fillStyle = "#ffffff";
                ctx.shadowColor = baseColor;
                ctx.shadowBlur = 4;
                ctx.textAlign = "center";
                ctx.textBaseline = "middle";
                ctx.fillText(amountText, entryX - amountW / 2 - amountSpacing, orderY);
                ctx.shadowBlur = 0;
                // Reset opacity
                ctx.globalAlpha = 1;
            }
        }
        // ===== FUTURISTIC EXPIRY MARKER =====
        // Add vertical end marker for completed positions
        // Only draw if within the chart area and not at the price axis
        if (order.status === "COMPLETED" && expiryX < effectiveChartWidth - 2) {
            const endMarkerX = Math.min(expiryX, effectiveChartWidth - 2);
            // Glow effect
            ctx.shadowColor = glowColor;
            ctx.shadowBlur = 10 * glowIntensity;
            // Draw futuristic end marker
            ctx.beginPath();
            ctx.strokeStyle = baseColor;
            ctx.lineWidth = 2 * entryAnimValue;
            // Diamond shape at the end
            drawDiamond(ctx, endMarkerX, orderY, 10 * entryAnimValue);
            ctx.stroke();
            ctx.fillStyle = "#131722";
            ctx.fill();
            // Reset shadow
            ctx.shadowBlur = 0;
        }
        // ===== FUTURISTIC RESULT INDICATOR =====
        // Draw result indicator for completed trades
        // Only draw if within the chart area
        if (hasResult && resultFlashIntensity > 0 && expiryX < effectiveChartWidth) {
            const resultText = order.result === "WIN" ? "WIN" : "LOSS";
            const resultColor = order.result === "WIN" ? "#64FFDA" : "#FF5252";
            const resultSecondary = order.result === "WIN" ? "#00E5FF" : "#FF00AA";
            ctx.font = "bold 16px Inter, sans-serif";
            const resultW = ctx.measureText(resultText).width + 40;
            // Position at expiry point
            const resultX = Math.min(expiryX, effectiveChartWidth - resultW / 2);
            const resultY = orderY - 40;
            // Only draw if it fits within chart bounds
            if (resultX + resultW / 2 < effectiveChartWidth && resultX - resultW / 2 > 0) {
                // Add glow effect
                ctx.shadowColor = resultColor;
                ctx.shadowBlur = 20 * resultFlashIntensity;
                // Draw futuristic result indicator - SAFELY
                try {
                    if (isValidNumber(resultX - resultW / 2) && isValidNumber(resultY - 15) && isValidNumber(resultW) && isValidNumber(30)) {
                        drawFuturisticResult(ctx, resultX - resultW / 2, resultY - 15, resultW, 30, resultColor, resultSecondary, resultFlashIntensity, currentTimeMs);
                    }
                } catch (error) {
                    console.warn("Error drawing futuristic result:", error);
                }
                // Reset shadow
                ctx.shadowBlur = 0;
                // Result text with glow
                ctx.fillStyle = "#ffffff";
                ctx.shadowColor = resultColor;
                ctx.shadowBlur = 8 * resultFlashIntensity;
                ctx.textAlign = "center";
                ctx.textBaseline = "middle";
                ctx.fillText(resultText, resultX, resultY);
                ctx.shadowBlur = 0;
                // Add particles for win
                if (order.result === "WIN" && Math.random() > 0.7) {
                    drawParticles(ctx, resultX, resultY, resultColor, resultFlashIntensity, currentTimeMs);
                }
            }
        }
    });
}
// Helper function to draw a hexagon
function drawHexagon(ctx, x, y, radius) {
    if (!isValidNumber(x) || !isValidNumber(y) || !isValidNumber(radius)) {
        return;
    }
    ctx.beginPath();
    for(let i = 0; i < 6; i++){
        const angle = Math.PI / 3 * i;
        const pointX = x + radius * Math.cos(angle);
        const pointY = y + radius * Math.sin(angle);
        if (i === 0) {
            ctx.moveTo(pointX, pointY);
        } else {
            ctx.lineTo(pointX, pointY);
        }
    }
    ctx.closePath();
}
// Helper function to draw a diamond
function drawDiamond(ctx, x, y, size) {
    if (!isValidNumber(x) || !isValidNumber(y) || !isValidNumber(size)) {
        return;
    }
    ctx.beginPath();
    ctx.moveTo(x, y - size);
    ctx.lineTo(x + size, y);
    ctx.lineTo(x, y + size);
    ctx.lineTo(x - size, y);
    ctx.closePath();
}
// Helper function to draw futuristic box with angled corners
function drawFuturisticBox(ctx, x, y, width, height, color1, color2, pulseValue) {
    // Validate all parameters
    if (!isValidNumber(x) || !isValidNumber(y) || !isValidNumber(width) || !isValidNumber(height)) {
        return;
    }
    const cornerSize = 6;
    // Create gradient background - SAFELY
    try {
        const gradient = ctx.createLinearGradient(x, y, x + width, y + height);
        gradient.addColorStop(0, color1);
        gradient.addColorStop(1, color2);
        // Draw background
        ctx.fillStyle = "#131722";
        ctx.beginPath();
        ctx.moveTo(x + cornerSize, y);
        ctx.lineTo(x + width - cornerSize, y);
        ctx.lineTo(x + width, y + cornerSize);
        ctx.lineTo(x + width, y + height - cornerSize);
        ctx.lineTo(x + width - cornerSize, y + height);
        ctx.lineTo(x + cornerSize, y + height);
        ctx.lineTo(x, y + height - cornerSize);
        ctx.lineTo(x, y + cornerSize);
        ctx.closePath();
        ctx.fill();
        // Draw border
        ctx.strokeStyle = gradient;
        ctx.lineWidth = 1.5;
        ctx.beginPath();
        ctx.moveTo(x + cornerSize, y);
        ctx.lineTo(x + width - cornerSize, y);
        ctx.lineTo(x + width, y + cornerSize);
        ctx.lineTo(x + width, y + height - cornerSize);
        ctx.lineTo(x + width - cornerSize, y + height);
        ctx.lineTo(x + cornerSize, y + height);
        ctx.lineTo(x, y + height - cornerSize);
        ctx.lineTo(x, y + cornerSize);
        ctx.closePath();
        ctx.stroke();
        // Add accent lines
        ctx.strokeStyle = color1;
        ctx.lineWidth = 1;
        // Top accent
        ctx.beginPath();
        ctx.moveTo(x + width * 0.2, y);
        ctx.lineTo(x + width * 0.4, y);
        ctx.stroke();
        // Bottom accent
        ctx.beginPath();
        ctx.moveTo(x + width * 0.6, y + height);
        ctx.lineTo(x + width * 0.8, y + height);
        ctx.stroke();
    } catch (error) {
        console.warn("Error creating gradient in drawFuturisticBox:", error);
    }
}
// Helper function to draw futuristic result indicator
function drawFuturisticResult(ctx, x, y, width, height, color1, color2, intensity, currentTimeMs) {
    // Validate all parameters
    if (!isValidNumber(x) || !isValidNumber(y) || !isValidNumber(width) || !isValidNumber(height)) {
        return;
    }
    const cornerRadius = 15;
    // Create gradient background - SAFELY
    try {
        const gradient = ctx.createLinearGradient(x, y, x + width, y + height);
        gradient.addColorStop(0, color1);
        gradient.addColorStop(1, color2);
        // Draw background
        ctx.fillStyle = "#131722";
        roundRect(ctx, x, y, width, height, cornerRadius);
        ctx.fill();
        // Draw border with animation
        ctx.strokeStyle = gradient;
        ctx.lineWidth = 2;
        roundRect(ctx, x, y, width, height, cornerRadius);
        ctx.stroke();
        // Add animated accent lines
        const time = currentTimeMs / 1000;
        const animOffset = Math.sin(time * 5) * 10;
        // Top accent
        ctx.beginPath();
        ctx.strokeStyle = color1;
        ctx.lineWidth = 2;
        ctx.moveTo(x + 5, y + 5);
        ctx.lineTo(x + 15 + animOffset, y + 5);
        ctx.stroke();
        // Bottom accent
        ctx.beginPath();
        ctx.moveTo(x + width - 5, y + height - 5);
        ctx.lineTo(x + width - 15 - animOffset, y + height - 5);
        ctx.stroke();
        // Add glowing dots at corners
        const dotRadius = 2 + intensity * 2;
        // Top left dot
        ctx.beginPath();
        ctx.fillStyle = color1;
        ctx.arc(x + 5, y + 5, dotRadius, 0, Math.PI * 2);
        ctx.fill();
        // Bottom right dot
        ctx.beginPath();
        ctx.fillStyle = color2;
        ctx.arc(x + width - 5, y + height - 5, dotRadius, 0, Math.PI * 2);
        ctx.fill();
    } catch (error) {
        console.warn("Error creating gradient in drawFuturisticResult:", error);
    }
}
// Helper function to draw particles
function drawParticles(ctx, x, y, color, intensity, currentTimeMs) {
    // Validate parameters
    if (!isValidNumber(x) || !isValidNumber(y)) {
        return;
    }
    const particleCount = 5;
    const maxRadius = 3;
    for(let i = 0; i < particleCount; i++){
        const angle = Math.random() * Math.PI * 2;
        const distance = 20 + Math.random() * 30;
        const size = 1 + Math.random() * maxRadius * intensity;
        const particleX = x + Math.cos(angle) * distance;
        const particleY = y + Math.sin(angle) * distance;
        // Only draw if coordinates are valid
        if (isValidNumber(particleX) && isValidNumber(particleY) && isValidNumber(size)) {
            ctx.beginPath();
            ctx.fillStyle = color;
            ctx.arc(particleX, particleY, size, 0, Math.PI * 2);
            ctx.fill();
        }
    }
}
// Helper function to format time remaining
function formatTimeRemaining(seconds) {
    if (seconds < 60) {
        return `${seconds}s`;
    } else {
        const minutes = Math.floor(seconds / 60);
        const remainingSeconds = seconds % 60;
        return `${minutes}m ${remainingSeconds}s`;
    }
}
// Helper function to draw time remaining indicator
function drawTimeRemainingIndicator(ctx, x, y, width, height, color1, color2, timeRemaining, warningThreshold, pulseValue) {
    // Validate parameters
    if (!isValidNumber(x) || !isValidNumber(y) || !isValidNumber(width) || !isValidNumber(height)) {
        return;
    }
    const cornerRadius = 4;
    // Create gradient background - SAFELY
    try {
        const gradient = ctx.createLinearGradient(x, y, x + width, y + height);
        gradient.addColorStop(0, color1);
        gradient.addColorStop(1, color2);
        // Draw background
        ctx.fillStyle = "#131722";
        roundRect(ctx, x, y, width, height, cornerRadius);
        ctx.fill();
        // Draw border
        ctx.strokeStyle = gradient;
        ctx.lineWidth = 1;
        roundRect(ctx, x, y, width, height, cornerRadius);
        ctx.stroke();
        // Draw progress bar
        const progress = Math.min(1, timeRemaining / warningThreshold);
        const progressWidth = (width - 4) * progress;
        if (progressWidth > 0) {
            ctx.fillStyle = gradient;
            roundRect(ctx, x + 2, y + height - 4, progressWidth, 2, 1);
            ctx.fill();
        }
    } catch (error) {
        console.warn("Error creating gradient in drawTimeRemainingIndicator:", error);
    }
}
}),
"[project]/frontend/components/blocks/advanced-chart/theme/colors.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Chart Theme Colors
 *
 * This file contains all the colors used in the chart components.
 * Centralizing colors makes it easier to maintain consistency and update themes.
 */ // Define the color themes
__turbopack_context__.s([
    "chartColors",
    ()=>chartColors,
    "getAxisColors",
    ()=>getAxisColors,
    "getBackgroundColor",
    ()=>getBackgroundColor,
    "getBorderColors",
    ()=>getBorderColors,
    "getCandleColors",
    ()=>getCandleColors,
    "getChartColors",
    ()=>getChartColors,
    "getCrosshairColors",
    ()=>getCrosshairColors,
    "getExpiryMarkerColors",
    ()=>getExpiryMarkerColors,
    "getFooterStyle",
    ()=>getFooterStyle,
    "getGridColor",
    ()=>getGridColor,
    "getHeaderStyle",
    ()=>getHeaderStyle,
    "getIndicatorColors",
    ()=>getIndicatorColors,
    "getModalColors",
    ()=>getModalColors,
    "getModalStyle",
    ()=>getModalStyle,
    "getPopoverColors",
    ()=>getPopoverColors,
    "getPopoverStyle",
    ()=>getPopoverStyle,
    "getPositionMarkerColors",
    ()=>getPositionMarkerColors,
    "getPriceLineColors",
    ()=>getPriceLineColors,
    "getTextColors",
    ()=>getTextColors,
    "getUIColors",
    ()=>getUIColors,
    "getVolumeColors",
    ()=>getVolumeColors
]);
const chartColors = {
    // Dark theme colors
    dark: {
        // Background colors
        background: {
            primary: "#000000",
            secondary: "#0A0A0A",
            tertiary: "#121212",
            panel: "#000000",
            tooltip: "#000000",
            overlay: "rgba(0, 0, 0, 0.9)",
            volumePanel: "#0A0A0A",
            indicatorPanel: "#000000",
            settingsPanel: "rgba(0, 0, 0, 0.9)",
            popover: "rgba(0, 0, 0, 0.95)",
            modal: "#000000",
            headerGradient: "linear-gradient(to bottom, rgba(0, 0, 0, 0.8) 0%, rgba(0, 0, 0, 0.4) 50%, rgba(0, 0, 0, 0) 100%)"
        },
        // Text colors
        text: {
            primary: "rgba(255, 255, 255, 0.9)",
            secondary: "rgba(212, 212, 216, 0.7)",
            tertiary: "rgba(161, 161, 170, 0.5)",
            label: "rgba(212, 212, 216, 0.7)",
            value: "#ffffff",
            positive: "#22c55e",
            negative: "#ef4444"
        },
        // Border colors
        border: {
            primary: "rgba(161, 161, 170, 0.2)",
            secondary: "rgba(161, 161, 170, 0.1)",
            panel: "#27272A",
            popover: "#27272A",
            modal: "#27272A",
            active: "#3b82f6"
        },
        // Grid colors
        grid: {
            primary: "rgba(161, 161, 170, 0.07)",
            secondary: "rgba(161, 161, 170, 0.05)",
            horizontal: "rgba(161, 161, 170, 0.07)",
            vertical: "rgba(161, 161, 170, 0.07)"
        },
        // Axis colors
        axis: {
            price: {
                text: "rgba(212, 212, 216, 0.7)",
                line: "rgba(161, 161, 170, 0.3)",
                tick: "rgba(161, 161, 170, 0.3)",
                background: "#121212"
            },
            time: {
                text: "rgba(212, 212, 216, 0.7)",
                line: "rgba(161, 161, 170, 0.1)",
                tick: "rgba(161, 161, 170, 0.3)",
                background: "#121212"
            }
        },
        // Candle colors
        candle: {
            bullish: {
                body: "#22c55e",
                border: "#22c55e",
                wick: "#22c55e"
            },
            bearish: {
                body: "#ef4444",
                border: "#ef4444",
                wick: "#ef4444"
            },
            doji: {
                body: "#787b86",
                border: "#787b86",
                wick: "#787b86"
            }
        },
        // Volume colors
        volume: {
            bullish: "rgba(34, 197, 94, 0.5)",
            bearish: "rgba(239, 68, 68, 0.5)"
        },
        // Line chart colors
        line: {
            primary: "#3b82f6",
            secondary: "#22c55e"
        },
        // Area chart colors
        area: {
            line: "#3b82f6",
            fill: "rgba(59, 130, 246, 0.1)",
            gradient: {
                top: "rgba(59, 130, 246, 0.2)",
                bottom: "rgba(59, 130, 246, 0.02)"
            }
        },
        // Crosshair colors
        crosshair: {
            line: "rgba(212, 212, 216, 0.5)",
            label: {
                background: "#2A2E39",
                text: "#22c55e"
            }
        },
        // Price line colors
        priceLine: {
            bullish: "#22c55e",
            bearish: "#ef4444",
            neutral: "#787b86",
            label: {
                text: "#ffffff"
            }
        },
        // Indicator colors
        indicator: {
            panel: {
                background: "rgba(0, 0, 0, 0.7)",
                header: "rgba(0, 0, 0, 0.8)",
                border: "rgba(39, 39, 42, 0.6)"
            },
            rsi: {
                line: "#f59e0b",
                overbought: "rgba(239, 68, 68, 0.3)",
                oversold: "rgba(34, 197, 94, 0.3)",
                middle: "rgba(212, 212, 216, 0.2)"
            },
            macd: {
                line: "#3b82f6",
                signal: "#ef4444",
                histogram: {
                    positive: "rgba(34, 197, 94, 0.6)",
                    negative: "rgba(239, 68, 68, 0.6)"
                }
            }
        },
        // Expiry marker colors
        expiryMarker: {
            line: {
                normal: "rgba(245, 158, 11, 0.8)",
                expiringSoon: "rgba(239, 68, 68, 0.7)"
            },
            gradient: {
                top: "rgba(245, 158, 11, 0.1)",
                middle: "rgba(245, 158, 11, 0.8)",
                bottom: "rgba(245, 158, 11, 0.1)"
            },
            countdown: {
                background: "rgba(245, 158, 11, 0.85)",
                expiringSoon: "rgba(239, 68, 68, 0.85)",
                text: "#ffffff"
            }
        },
        // Position marker colors
        positionMarker: {
            call: {
                primary: "#22c55e",
                secondary: "#34d399",
                accent: "#10b981"
            },
            put: {
                primary: "#ef4444",
                secondary: "#f87171",
                accent: "#dc2626"
            },
            result: {
                win: "#22c55e",
                loss: "#ef4444"
            }
        },
        // UI element colors
        ui: {
            button: {
                primary: {
                    background: "#3b82f6",
                    hover: "#2563eb",
                    text: "#ffffff"
                },
                secondary: {
                    background: "#2A2E39",
                    hover: "#3A3E49",
                    text: "#ffffff"
                },
                success: {
                    background: "#22c55e",
                    hover: "#16a34a",
                    text: "#ffffff"
                },
                danger: {
                    background: "#ef4444",
                    hover: "#dc2626",
                    text: "#ffffff"
                }
            },
            toggle: {
                active: "#22c55e",
                inactive: "#3A3E49",
                background: "rgba(0, 0, 0, 0.5)"
            },
            dropdown: {
                background: "#1A1D29",
                border: "#2A2E39",
                hover: "#2A2E39",
                text: "#ffffff"
            },
            tooltip: {
                background: "#1A1D29",
                border: "#2A2E39",
                text: "#ffffff"
            }
        },
        popover: {
            background: "rgba(0, 0, 0, 0.95)",
            backgroundAlternate: "#0F0F0F",
            border: "#27272A",
            shadow: "0 10px 25px -5px rgba(0, 0, 0, 0.8), 0 8px 10px -6px rgba(0, 0, 0, 0.6)",
            text: {
                primary: "#FFFFFF",
                secondary: "#A1A1AA",
                tertiary: "#71717A"
            },
            item: {
                hover: "#27272A",
                active: "#3F3F46",
                text: "#FFFFFF",
                textHover: "#FFFFFF",
                textActive: "#FFFFFF"
            },
            header: {
                background: "#0A0A0A",
                text: "#FFFFFF",
                border: "#27272A"
            },
            footer: {
                background: "#0A0A0A",
                text: "#FFFFFF",
                border: "#27272A"
            }
        },
        modal: {
            background: "#000000",
            border: "#27272A",
            shadow: "0 20px 25px -5px rgba(0, 0, 0, 0.8), 0 10px 10px -5px rgba(0, 0, 0, 0.7)",
            header: {
                background: "#0A0A0A",
                text: "#FFFFFF",
                border: "#27272A"
            },
            body: {
                background: "#000000",
                text: "#FFFFFF"
            },
            footer: {
                background: "#0A0A0A",
                text: "#FFFFFF",
                border: "#27272A"
            },
            closeButton: {
                background: "transparent",
                backgroundHover: "#27272A",
                text: "#A1A1AA",
                textHover: "#FFFFFF"
            }
        }
    },
    // Light theme colors
    light: {
        // Background colors
        background: {
            primary: "#ffffff",
            secondary: "#fafafa",
            tertiary: "#f4f4f5",
            panel: "#ffffff",
            tooltip: "#ffffff",
            overlay: "rgba(255, 255, 255, 0.7)",
            volumePanel: "#fafafa",
            indicatorPanel: "#fafafa",
            settingsPanel: "rgba(255, 255, 255, 0.3)",
            headerGradient: "linear-gradient(to bottom, rgba(255, 255, 255, 0.8) 0%, rgba(255, 255, 255, 0.4) 50%, rgba(255, 255, 255, 0) 100%)"
        },
        // Text colors
        text: {
            primary: "rgba(0, 0, 0, 0.9)",
            secondary: "rgba(63, 63, 70, 0.7)",
            tertiary: "rgba(63, 63, 70, 0.5)",
            label: "rgba(63, 63, 70, 0.7)",
            value: "#000000",
            positive: "#16a34a",
            negative: "#dc2626"
        },
        // Border colors
        border: {
            primary: "rgba(161, 161, 170, 0.2)",
            secondary: "rgba(161, 161, 170, 0.1)",
            panel: "#e4e4e7",
            active: "#3b82f6"
        },
        // Grid colors
        grid: {
            primary: "rgba(161, 161, 170, 0.05)",
            secondary: "rgba(161, 161, 170, 0.03)",
            horizontal: "rgba(161, 161, 170, 0.05)",
            vertical: "rgba(161, 161, 170, 0.05)"
        },
        // Axis colors
        axis: {
            price: {
                text: "rgba(113, 113, 122, 0.7)",
                line: "rgba(161, 161, 170, 0.2)",
                tick: "rgba(161, 161, 170, 0.2)",
                background: "#f4f4f5"
            },
            time: {
                text: "rgba(113, 113, 122, 0.7)",
                line: "rgba(161, 161, 170, 0.1)",
                tick: "rgba(161, 161, 170, 0.2)",
                background: "#f4f4f5"
            }
        },
        // Candle colors
        candle: {
            bullish: {
                body: "#16a34a",
                border: "#16a34a",
                wick: "#16a34a"
            },
            bearish: {
                body: "#dc2626",
                border: "#dc2626",
                wick: "#dc2626"
            },
            doji: {
                body: "#787b86",
                border: "#787b86",
                wick: "#787b86"
            }
        },
        // Volume colors
        volume: {
            bullish: "rgba(22, 163, 74, 0.5)",
            bearish: "rgba(220, 38, 38, 0.5)"
        },
        // Line chart colors
        line: {
            primary: "#3b82f6",
            secondary: "#16a34a"
        },
        // Area chart colors
        area: {
            line: "#3b82f6",
            fill: "rgba(59, 130, 246, 0.1)",
            gradient: {
                top: "rgba(59, 130, 246, 0.2)",
                bottom: "rgba(59, 130, 246, 0.02)"
            }
        },
        // Crosshair colors
        crosshair: {
            line: "rgba(63, 63, 70, 0.4)",
            label: {
                background: "#f8f9fa",
                text: "#16a34a"
            }
        },
        // Price line colors
        priceLine: {
            bullish: "#16a34a",
            bearish: "#dc2626",
            neutral: "#787b86",
            label: {
                text: "#ffffff"
            }
        },
        // Indicator colors
        indicator: {
            panel: {
                background: "rgba(255, 255, 255, 0.7)",
                header: "rgba(240, 241, 245, 0.8)",
                border: "rgba(0, 0, 0, 0.1)"
            },
            rsi: {
                line: "#f59e0b",
                overbought: "rgba(220, 38, 38, 0.2)",
                oversold: "rgba(22, 163, 74, 0.2)",
                middle: "rgba(63, 63, 70, 0.2)"
            },
            macd: {
                line: "#3b82f6",
                signal: "#dc2626",
                histogram: {
                    positive: "rgba(22, 163, 74, 0.6)",
                    negative: "rgba(220, 38, 38, 0.6)"
                }
            }
        },
        // Expiry marker colors
        expiryMarker: {
            line: {
                normal: "rgba(245, 158, 11, 0.8)",
                expiringSoon: "rgba(220, 38, 38, 0.7)"
            },
            gradient: {
                top: "rgba(245, 158, 11, 0.1)",
                middle: "rgba(245, 158, 11, 0.8)",
                bottom: "rgba(245, 158, 11, 0.1)"
            },
            countdown: {
                background: "rgba(245, 158, 11, 0.85)",
                expiringSoon: "rgba(220, 38, 38, 0.85)",
                text: "#ffffff"
            }
        },
        // Position marker colors
        positionMarker: {
            call: {
                primary: "#16a34a",
                secondary: "#22c55e",
                accent: "#15803d"
            },
            put: {
                primary: "#dc2626",
                secondary: "#ef4444",
                accent: "#b91c1c"
            },
            result: {
                win: "#16a34a",
                loss: "#dc2626"
            }
        },
        // UI element colors
        ui: {
            button: {
                primary: {
                    background: "#3b82f6",
                    hover: "#2563eb",
                    text: "#ffffff"
                },
                secondary: {
                    background: "#e4e4e7",
                    hover: "#d4d4d8",
                    text: "#27272a"
                },
                success: {
                    background: "#16a34a",
                    hover: "#15803d",
                    text: "#ffffff"
                },
                danger: {
                    background: "#dc2626",
                    hover: "#b91c1c",
                    text: "#ffffff"
                }
            },
            toggle: {
                active: "#16a34a",
                inactive: "#d4d4d8",
                background: "rgba(255, 255, 255, 0.5)"
            },
            dropdown: {
                background: "#f4f4f5",
                border: "#e4e4e7",
                hover: "#e4e4e7",
                text: "#27272a"
            },
            tooltip: {
                background: "#f4f4f5",
                border: "#e4e4e7",
                text: "#27272a"
            }
        },
        popover: {
            background: "rgba(255, 255, 255, 0.98)",
            backgroundAlternate: "#F8F8F8",
            border: "#E4E4E7",
            shadow: "0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1)",
            text: {
                primary: "#18181B",
                secondary: "#52525B",
                tertiary: "#71717A"
            },
            item: {
                hover: "#F4F4F5",
                active: "#E4E4E7",
                text: "#18181B",
                textHover: "#18181B",
                textActive: "#18181B"
            },
            header: {
                background: "#F9FAFB",
                text: "#18181B",
                border: "#E4E4E7"
            },
            footer: {
                background: "#F9FAFB",
                text: "#18181B",
                border: "#E4E4E7"
            }
        },
        modal: {
            background: "#FFFFFF",
            border: "#E4E4E7",
            shadow: "0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.05)",
            header: {
                background: "#F9FAFB",
                text: "#18181B",
                border: "#E4E4E7"
            },
            body: {
                background: "#FFFFFF",
                text: "#18181B"
            },
            footer: {
                background: "#F9FAFB",
                text: "#18181B",
                border: "#E4E4E7"
            },
            closeButton: {
                background: "transparent",
                backgroundHover: "#F4F4F5",
                text: "#71717A",
                textHover: "#18181B"
            }
        }
    }
};
const getChartColors = (isDarkMode)=>{
    return isDarkMode ? chartColors.dark : chartColors.light;
};
const getBackgroundColor = (isDarkMode)=>{
    return getChartColors(isDarkMode).background.primary;
};
const getGridColor = (isDarkMode)=>{
    return getChartColors(isDarkMode).grid.primary;
};
const getAxisColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).axis;
};
const getCandleColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).candle;
};
const getVolumeColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).volume;
};
const getCrosshairColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).crosshair;
};
const getPriceLineColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).priceLine;
};
const getTextColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).text;
};
const getBorderColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).border;
};
const getIndicatorColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).indicator;
};
const getExpiryMarkerColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).expiryMarker;
};
const getPositionMarkerColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).positionMarker;
};
const getUIColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).ui;
};
const getPopoverColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).popover;
};
const getModalColors = (isDarkMode)=>{
    return getChartColors(isDarkMode).modal;
};
const getPopoverStyle = (isDark)=>{
    const colors = getChartColors(isDark);
    return {
        background: colors.popover.background,
        border: `1px solid ${colors.popover.border}`,
        color: colors.popover.text.primary,
        boxShadow: colors.popover.shadow
    };
};
const getModalStyle = (isDark)=>{
    const colors = getChartColors(isDark);
    return {
        background: colors.modal.background,
        border: `1px solid ${colors.modal.border}`,
        color: colors.modal.body.text,
        boxShadow: colors.modal.shadow
    };
};
const getHeaderStyle = (isDark, isModal = false)=>{
    const colors = getChartColors(isDark);
    const section = isModal ? colors.modal.header : colors.popover.header;
    return {
        background: section.background,
        borderBottom: `1px solid ${section.border}`,
        color: section.text
    };
};
const getFooterStyle = (isDark, isModal = false)=>{
    const colors = getChartColors(isDark);
    const section = isModal ? colors.modal.footer : colors.popover.footer;
    return {
        background: section.background,
        borderTop: `1px solid ${section.border}`,
        color: section.text
    };
};
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/grid.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// Import the color utilities
__turbopack_context__.s([
    "renderGrid",
    ()=>renderGrid
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/theme/colors.ts [app-ssr] (ecmascript)");
;
function renderGrid(ctx, chartWidth, chartHeight, volumeHeight, chartTop, volumeTop, darkMode, gridColor, candleData = [], visibleRange = {
    start: 0,
    end: 0
}) {
    // Skip rendering if no data or invalid dimensions
    if (!candleData || candleData.length === 0 || chartWidth <= 0 || chartHeight <= 0) return;
    // Use theme-appropriate grid color from our centralized colors
    const themeGridColor = gridColor || (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getGridColor"])(darkMode);
    // Performance optimization: Use a single path for all grid lines
    ctx.beginPath();
    ctx.strokeStyle = themeGridColor;
    ctx.lineWidth = 1;
    // Calculate visible data range with bounds checking
    const start = Math.max(0, Math.floor(visibleRange.start));
    const end = Math.min(candleData.length, Math.ceil(visibleRange.end));
    // Skip if no visible data
    if (start >= end) return;
    const visibleData = candleData.slice(start, end);
    if (visibleData.length === 0) return;
    // Calculate price range with padding
    let minPrice = Math.min(...visibleData.map((d)=>d.low));
    let maxPrice = Math.max(...visibleData.map((d)=>d.high));
    const priceRange = maxPrice - minPrice;
    const pricePadding = priceRange * 0.1;
    minPrice = Math.max(0, minPrice - pricePadding);
    maxPrice = maxPrice + pricePadding;
    // Store grid positions for price axis synchronization
    const gridPositionsY = [];
    // Horizontal grid lines for price chart - draw in a single path
    const priceGridCount = Math.min(8, Math.floor(chartHeight / 40)); // Adaptive grid count based on height
    for(let i = 0; i <= priceGridCount; i++){
        // For light mode, don't add the 0.5 offset to avoid edge artifacts
        const y = darkMode ? Math.floor(chartTop + i / priceGridCount * chartHeight) + 0.5 : Math.floor(chartTop + i / priceGridCount * chartHeight);
        const price = maxPrice - i / priceGridCount * (maxPrice - minPrice);
        // Store grid position and corresponding price for price axis
        gridPositionsY.push({
            y,
            price
        });
        // Don't draw grid lines at the very top and left edges in light mode
        if (!darkMode && (y <= chartTop + 1 || i === 0)) {
            continue;
        }
        ctx.moveTo(1, y); // Start slightly inward in light mode
        ctx.lineTo(chartWidth - 1, y); // End slightly inward in light mode
    }
    // First, determine the time range of the visible data
    const firstCandleTime = visibleData[0].time * 1000; // Convert to milliseconds
    const lastCandleTime = visibleData[visibleData.length - 1].time * 1000;
    // Calculate average candle time interval
    let avgCandleTimeMs = 60000; // Default to 1 minute
    if (visibleData.length > 1) {
        avgCandleTimeMs = (lastCandleTime - firstCandleTime) / (visibleData.length - 1);
    }
    // Determine appropriate time interval for grid lines based on zoom level
    const visibleTimeRangeMs = lastCandleTime - firstCandleTime;
    const visibleMinutes = visibleTimeRangeMs / 60000;
    // Choose grid interval based on visible time range
    let gridIntervalMinutes = 1; // Default to 1 minute
    if (visibleMinutes > 1440) {
        // > 24 hours
        gridIntervalMinutes = 240; // 4 hours
    } else if (visibleMinutes > 720) {
        // > 12 hours
        gridIntervalMinutes = 120; // 2 hours
    } else if (visibleMinutes > 360) {
        // > 6 hours
        gridIntervalMinutes = 60; // 1 hour
    } else if (visibleMinutes > 120) {
        // > 2 hours
        gridIntervalMinutes = 30; // 30 minutes
    } else if (visibleMinutes > 60) {
        // > 1 hour
        gridIntervalMinutes = 15; // 15 minutes
    } else if (visibleMinutes > 30) {
        // > 30 minutes
        gridIntervalMinutes = 5; // 5 minutes
    } else if (visibleMinutes > 15) {
        // > 15 minutes
        gridIntervalMinutes = 2; // 2 minutes
    }
    // Convert to milliseconds
    const gridIntervalMs = gridIntervalMinutes * 60 * 1000;
    // Find the first grid line time (round down to nearest interval)
    const firstGridTime = Math.floor(firstCandleTime / gridIntervalMs) * gridIntervalMs;
    // Calculate how many grid lines we need
    // Increase the number of future grid lines to ensure they extend across the chart
    const gridLinesNeeded = Math.ceil((lastCandleTime - firstGridTime) / gridIntervalMs) + 30; // Add more extra lines for future
    // Store grid positions for export to be used by footer
    const gridPositions = [];
    // Calculate the minimum pixel distance between grid lines based on chart width
    // This ensures we don't have too many grid lines when zoomed out
    const minGridSpacing = Math.max(60, chartWidth / 12); // At least 60px or 1/12 of chart width
    // Calculate the future space
    // This is critical: we need to know how much of the chart width is allocated to future time
    const dataRangeWidth = visibleRange.end - visibleRange.start;
    const futureRangeWidth = Math.max(0, visibleRange.end - candleData.length);
    const futureSpacePercentage = futureRangeWidth / dataRangeWidth;
    const futureSpaceWidth = chartWidth * futureSpacePercentage;
    // Calculate the width of one candle in pixels
    const candleWidthInPixels = chartWidth / dataRangeWidth;
    // Generate grid lines at fixed time intervals
    for(let i = -5; i <= gridLinesNeeded; i++){
        const gridTime = firstGridTime + i * gridIntervalMs;
        // Find the x position for this time
        let x = -1;
        // If this time is before the first candle, extrapolate backwards
        if (gridTime < firstCandleTime) {
            const timeDiff = firstCandleTime - gridTime;
            const candlesBack = timeDiff / avgCandleTimeMs;
            x = Math.round(0 - candlesBack * candleWidthInPixels);
        } else if (gridTime > lastCandleTime) {
            // Calculate how far into the future this grid line is
            const timeDiff = gridTime - lastCandleTime;
            const candlesForward = timeDiff / avgCandleTimeMs;
            // Calculate the position based on the last candle's position plus the future offset
            const lastCandleIndex = candleData.length - 1;
            const lastCandlePosition = (lastCandleIndex - visibleRange.start) / dataRangeWidth * chartWidth;
            // Position in future space
            x = Math.round(lastCandlePosition + candlesForward * candleWidthInPixels);
        } else {
            // Find the closest candle to this time
            let closestIndex = 0;
            let closestDiff = Math.abs(visibleData[0].time * 1000 - gridTime);
            for(let j = 1; j < visibleData.length; j++){
                const diff = Math.abs(visibleData[j].time * 1000 - gridTime);
                if (diff < closestDiff) {
                    closestDiff = diff;
                    closestIndex = j;
                }
            }
            // Calculate the position based on the closest candle
            const relativeIndex = start + closestIndex;
            const relativePosition = (relativeIndex - visibleRange.start) / dataRangeWidth;
            x = Math.round(relativePosition * chartWidth);
        }
        // Only draw if within extended chart bounds (include more margin for future grid lines)
        // Extend the right boundary significantly to ensure future grid lines are included
        if (x >= -100 && x <= chartWidth + 500) {
            // Store grid position for footer synchronization
            gridPositions.push({
                time: gridTime,
                x
            });
        }
    }
    // Filter positions to avoid overcrowding based on dynamic spacing
    const filteredPositions = [];
    let lastX = Number.NEGATIVE_INFINITY;
    for (const pos of gridPositions){
        if (pos.x - lastX >= minGridSpacing) {
            filteredPositions.push(pos);
            lastX = pos.x;
            // Draw the grid line for this filtered position
            // Ensure the line extends through the chart height but stops at chartWidth
            // In light mode, avoid drawing at the very left edge
            if (!darkMode && pos.x <= 1) {
                continue;
            }
            const startY = darkMode ? chartTop : chartTop + 1; // Start slightly down in light mode
            ctx.moveTo(pos.x, startY);
            ctx.lineTo(pos.x, chartTop + chartHeight + volumeHeight);
        }
    }
    // Draw all grid lines at once (much more efficient)
    ctx.stroke();
    // Store filtered grid positions in a global variable for footer to access
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/price-axis.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "renderPriceAxis",
    ()=>renderPriceAxis
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/theme/colors.ts [app-ssr] (ecmascript)");
;
;
function renderPriceAxis(ctx, chartWidth, chartHeight, volumeHeight = 0, chartTop = 0, volumeTop = 0, priceRange = {
    min: 0,
    max: 0
}, volumeRange = {
    min: 0,
    max: 0
}, priceScaleWidth = 60, timeScaleHeight = 30, darkMode = true, data = []) {
    // Get theme-appropriate colors from our centralized colors
    const axisColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getAxisColors"])(darkMode);
    const textColor = axisColors.price.text;
    const bgColor = axisColors.price.background;
    const tickColor = axisColors.price.tick;
    // Save current context state
    ctx.save();
    // Draw price scale background - make it fully opaque and wide enough to cover any grid lines
    ctx.fillStyle = bgColor;
    // Draw from 2px to the left of the chart boundary to ensure complete coverage
    ctx.fillRect(chartWidth - 2, 0, priceScaleWidth + 4, chartHeight + volumeHeight);
    // Draw price labels
    ctx.fillStyle = textColor;
    ctx.font = "10px Arial";
    ctx.textAlign = "right";
    ctx.textBaseline = "middle";
    // Get current price from the last candle if available
    let currentPrice = 0;
    let isBullish = false;
    if (data && data.length > 0) {
        const lastCandle = data[data.length - 1];
        if (lastCandle) {
            currentPrice = lastCandle.close;
            // Determine if the candle is bullish (close > open)
            isBullish = lastCandle.close >= lastCandle.open;
        }
    }
    // Access the grid positions from the global variable set by renderGrid
    // This ensures perfect alignment between grid lines and price labels
    const gridPositionsY = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : [];
    if (gridPositionsY.length > 0) {
        // Use the grid positions to place price labels
        for (const { y, price } of gridPositionsY){
            // Skip labels that would be outside the visible chart area
            if (y < chartTop || y > chartTop + chartHeight) continue;
            // Draw price label
            ctx.fillStyle = textColor;
            ctx.fillText((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(price), chartWidth + priceScaleWidth - 5, y);
            // Draw small tick
            ctx.beginPath();
            ctx.strokeStyle = tickColor;
            ctx.moveTo(chartWidth, y);
            ctx.lineTo(chartWidth + 4, y);
            ctx.stroke();
        }
    } else {
        // Fallback to the old method if grid positions aren't available
        // Calculate optimal number of price labels based on chart height
        const optimalLabelCount = Math.max(4, Math.min(10, Math.floor(chartHeight / 40)));
        const priceStep = (priceRange.max - priceRange.min) / (optimalLabelCount - 1);
        // Draw price labels at calculated intervals
        for(let i = 0; i < optimalLabelCount; i++){
            const price = priceRange.max - i * priceStep;
            // Calculate y position as a proportion of the chart height
            const y = chartTop + i / (optimalLabelCount - 1) * chartHeight;
            // Skip labels that would be outside the visible chart area
            if (y < chartTop || y > chartTop + chartHeight) continue;
            // Draw price label
            ctx.fillStyle = textColor;
            ctx.fillText((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(price), chartWidth + priceScaleWidth - 5, y);
            // Draw small tick
            ctx.beginPath();
            ctx.strokeStyle = tickColor;
            ctx.moveTo(chartWidth, y);
            ctx.lineTo(chartWidth + 4, y);
            ctx.stroke();
        }
    }
    // Draw volume labels if volume is shown
    if (volumeHeight > 0) {
        // Calculate optimal number of volume labels based on volume panel height
        const volumeLabelCount = Math.max(2, Math.min(3, Math.floor(volumeHeight / 40)));
        // Add a smaller padding to the top volume label to prevent overlap with price labels
        const topPadding = 8; // Reduced from 15 to 8 pixels
        // Calculate positions for volume labels
        for(let i = 0; i < volumeLabelCount; i++){
            // For the first label (top one), add padding to move it down slightly
            const yOffset = i === 0 ? topPadding : 0;
            // Calculate position with adjusted spacing
            const position = i / (volumeLabelCount - 1);
            const adjustedPosition = i === 0 ? topPadding / volumeHeight + position * (1 - topPadding / volumeHeight) : position;
            const volumeValue = volumeRange.max - adjustedPosition * (volumeRange.max - volumeRange.min);
            const y = volumeTop + adjustedPosition * volumeHeight + yOffset;
            // Skip labels that would be outside the visible volume area
            if (y < volumeTop || y > volumeTop + volumeHeight - 5) continue;
            // Draw volume label
            ctx.fillStyle = textColor;
            ctx.fillText((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatLargeNumber"])(volumeValue), chartWidth + priceScaleWidth - 5, y);
            // Draw small tick for volume
            ctx.beginPath();
            ctx.strokeStyle = tickColor;
            ctx.moveTo(chartWidth, y);
            ctx.lineTo(chartWidth + 4, y);
            ctx.stroke();
        }
        // Only draw a "0" label at the bottom if the last label isn't already close to 0
        // and we're not already showing a label near the bottom
        const lastLabelValue = volumeRange.min;
        const lastLabelIsNearZero = lastLabelValue < volumeRange.max * 0.1;
        const bottomY = volumeTop + volumeHeight - 5;
        // Check if the last calculated label is already near the bottom
        const lastCalculatedY = volumeTop + volumeHeight - 5;
        const lastLabelIsNearBottom = Math.abs(lastCalculatedY - bottomY) < 20;
        // Only add the "0" label if it's not redundant
        if (volumeHeight > 30 && !lastLabelIsNearZero && !lastLabelIsNearBottom) {
            ctx.fillStyle = textColor;
            ctx.fillText("0", chartWidth + priceScaleWidth - 5, bottomY);
        }
    }
    // Draw current price label (TradingView style)
    if (currentPrice > 0 && priceRange.min <= currentPrice && currentPrice <= priceRange.max) {
        // Calculate y position for current price
        const y = chartTop + (priceRange.max - currentPrice) / (priceRange.max - priceRange.min) * chartHeight;
        // Format the price text
        const priceText = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(currentPrice);
        // Measure text width for the background
        ctx.font = "bold 11px Arial";
        const textWidth = ctx.measureText(priceText).width;
        // Set colors based on candle direction
        const bullishColor = "#22c55e"; // Green for bullish candles
        const bearishColor = "#ef4444"; // Red for bearish candles
        const bgColor = isBullish ? bullishColor : bearishColor;
        const textColor = "#FFFFFF"; // White text for good contrast on both colors
        // Draw background rectangle with padding
        const padding = 6;
        const rectHeight = 20;
        ctx.fillStyle = bgColor;
        ctx.fillRect(chartWidth - 2, y - rectHeight / 2, textWidth + padding * 2, rectHeight);
        // Draw price text
        ctx.fillStyle = textColor;
        ctx.textAlign = "left";
        ctx.textBaseline = "middle";
        ctx.fillText(priceText, chartWidth + padding - 2, y);
    }
    // Restore context state
    ctx.restore();
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/candlestick.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "renderCandlesticks",
    ()=>renderCandlesticks
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
;
function renderCandlesticks(ctx, data, chartWidth, chartHeight, chartTop, priceRange, candleWidth, spacing, darkMode, totalVisibleRange, startOffset) {
    // Use theme-appropriate colors
    const bullColor = darkMode ? "#22c55e" : "#16a34a"; // Green - slightly darker in light mode
    const bearColor = darkMode ? "#ef4444" : "#dc2626"; // Red - slightly darker in light mode
    const priceRangeDiff = priceRange.max - priceRange.min;
    // Use antialiasing for smoother rendering
    ctx.imageSmoothingEnabled = true;
    ctx.imageSmoothingQuality = "high";
    data.forEach((candle, i)=>{
        // Calculate x position based on the candle's position in the full dataset
        // This ensures candles are positioned correctly when scrolling into future
        const dataIndex = data[i].time ? __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["globalCandleData"].findIndex((c)=>c.time === data[i].time) : i;
        const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
        // Calculate the x position, then center the candle on the grid line
        const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
        // Offset by half the candle width to center on the grid line
        const centeredX = x - candleWidth / 2;
        // Skip if outside visible area or if it would overlap with the price scale
        if (centeredX < -candleWidth || centeredX > chartWidth - 1) return;
        const isBullish = candle.close >= candle.open;
        // Calculate y positions
        const highY = chartTop + (priceRange.max - candle.high) / priceRangeDiff * chartHeight;
        const lowY = chartTop + (priceRange.max - candle.low) / priceRangeDiff * chartHeight;
        const openY = chartTop + (priceRange.max - candle.open) / priceRangeDiff * chartHeight;
        const closeY = chartTop + (priceRange.max - candle.close) / priceRangeDiff * chartHeight;
        // Draw wick with improved quality
        ctx.beginPath();
        ctx.strokeStyle = isBullish ? bullColor : bearColor;
        ctx.lineWidth = 1;
        // For light mode, avoid 0.5 offsets that can cause edge artifacts
        const centerX = darkMode ? Math.floor(x) + 0.5 : Math.floor(x);
        const wickHighY = darkMode ? Math.floor(highY) + 0.5 : Math.floor(highY);
        const wickLowY = darkMode ? Math.floor(lowY) + 0.5 : Math.floor(lowY);
        ctx.moveTo(centerX, wickHighY);
        ctx.lineTo(centerX, wickLowY);
        ctx.stroke();
        // Draw body with improved quality
        const bodyTop = darkMode ? Math.floor(isBullish ? closeY : openY) + 0.5 : Math.floor(isBullish ? closeY : openY);
        const bodyBottom = darkMode ? Math.floor(isBullish ? openY : closeY) + 0.5 : Math.floor(isBullish ? openY : closeY);
        const bodyHeight = Math.max(1, bodyBottom - bodyTop); // Ensure minimum height
        // Center the body around the grid line
        const bodyLeft = darkMode ? Math.floor(centeredX + spacing / 2) + 0.5 : Math.floor(centeredX + spacing / 2);
        const bodyWidth = Math.max(1, Math.floor(candleWidth - spacing));
        ctx.fillStyle = isBullish ? bullColor : bearColor;
        ctx.fillRect(bodyLeft, bodyTop, bodyWidth, bodyHeight);
        // Add border to the candle body for better definition (only in dark mode to avoid artifacts)
        if (darkMode) {
            ctx.strokeStyle = isBullish ? "rgba(34, 197, 94, 0.8)" : "rgba(239, 68, 68, 0.8)";
            ctx.lineWidth = 1;
            ctx.strokeRect(bodyLeft, bodyTop, bodyWidth, bodyHeight);
        }
    });
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/line.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "renderLine",
    ()=>renderLine
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
;
function renderLine(ctx, data, chartWidth, chartHeight, chartTop, priceRange, darkMode, totalVisibleRange, startOffset) {
    // Use theme-appropriate colors
    const lineColor = darkMode ? "#4ade80" : "#22c55e"; // Lighter green in dark mode, darker in light mode
    const priceRangeDiff = priceRange.max - priceRange.min;
    ctx.beginPath();
    ctx.strokeStyle = lineColor;
    ctx.lineWidth = 2;
    data.forEach((candle, i)=>{
        // Calculate x position based on the candle's position in the full dataset
        const dataIndex = data[i].time ? __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["globalCandleData"].findIndex((c)=>c.time === data[i].time) : i;
        const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
        const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
        // Skip if outside visible area or if it would overlap with the price scale
        if (x < 0 || x > chartWidth - 1) return;
        const y = chartTop + (priceRange.max - candle.close) / priceRangeDiff * chartHeight;
        if (i === 0) {
            ctx.moveTo(x, y);
        } else {
            ctx.lineTo(x, y);
        }
    });
    ctx.stroke();
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/bar.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "renderBars",
    ()=>renderBars
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
;
function renderBars(ctx, data, chartWidth, chartHeight, chartTop, priceRange, barWidth, spacing, darkMode, totalVisibleRange, startOffset) {
    // Use theme-appropriate colors
    const bullColor = darkMode ? "#22c55e" : "#16a34a"; // Green - slightly darker in light mode
    const bearColor = darkMode ? "#ef4444" : "#dc2626"; // Red - slightly darker in light mode
    const priceRangeDiff = priceRange.max - priceRange.min;
    data.forEach((candle, i)=>{
        // Calculate x position based on the candle's position in the full dataset
        const dataIndex = data[i].time ? __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["globalCandleData"].findIndex((c)=>c.time === data[i].time) : i;
        const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
        const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
        // Skip if outside visible area or if it would overlap with the price scale
        if (x < -barWidth || x > chartWidth - 1) return;
        const isBullish = candle.close >= candle.open;
        // Calculate y positions
        const highY = chartTop + (priceRange.max - candle.high) / priceRangeDiff * chartHeight;
        const lowY = chartTop + (priceRange.max - candle.low) / priceRangeDiff * chartHeight;
        const openY = chartTop + (priceRange.max - candle.open) / priceRangeDiff * chartHeight;
        const closeY = chartTop + (priceRange.max - candle.close) / priceRangeDiff * chartHeight;
        // Draw vertical line (high to low)
        ctx.beginPath();
        ctx.strokeStyle = isBullish ? bullColor : bearColor;
        ctx.lineWidth = 1;
        ctx.moveTo(x + barWidth / 2, highY);
        ctx.lineTo(x + barWidth / 2, lowY);
        ctx.stroke();
        // Draw open tick
        ctx.beginPath();
        ctx.moveTo(x, openY);
        ctx.lineTo(x + barWidth / 2, openY);
        ctx.stroke();
        // Draw close tick
        ctx.beginPath();
        ctx.moveTo(x + barWidth / 2, closeY);
        ctx.lineTo(x + barWidth, closeY);
        ctx.stroke();
    });
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/area.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "renderArea",
    ()=>renderArea
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
;
function renderArea(ctx, data, chartWidth, chartHeight, chartTop, priceRange, darkMode, totalVisibleRange, startOffset) {
    // Use theme-appropriate colors
    const areaColor = darkMode ? "rgba(74, 222, 128, 0.2)" : "rgba(34, 197, 94, 0.2)"; // Semi-transparent green
    const lineColor = darkMode ? "#4ade80" : "#22c55e"; // Solid green
    const priceRangeDiff = priceRange.max - priceRange.min;
    // Only proceed if we have data
    if (!data || data.length === 0) return;
    // Find the last valid x-coordinate to properly close the path
    let lastValidX = 0;
    let lastValidY = 0;
    // Draw area
    ctx.beginPath();
    // Start at the bottom left of the first valid data point
    const firstDataIndex = data[0].time ? __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["globalCandleData"].findIndex((c)=>c.time === data[0].time) : 0;
    const firstAdjustedIndex = firstDataIndex >= 0 ? firstDataIndex : 0;
    const firstX = (firstAdjustedIndex - startOffset) / totalVisibleRange * chartWidth;
    // Start at the bottom of the chart for the first x position
    ctx.moveTo(firstX, chartTop + chartHeight);
    // Draw the line connecting all data points
    data.forEach((candle, i)=>{
        // Calculate x position based on the candle's position in the full dataset
        const dataIndex = data[i].time ? __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["globalCandleData"].findIndex((c)=>c.time === data[i].time) : i;
        const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
        const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
        // Skip if outside visible area
        if (x < 0 || x > chartWidth) return;
        const y = chartTop + (priceRange.max - candle.close) / priceRangeDiff * chartHeight;
        ctx.lineTo(x, y);
        // Keep track of the last valid point
        lastValidX = x;
        lastValidY = y;
    });
    // Complete the path by going down to the bottom right of the last valid data point
    // and then back to the starting point
    ctx.lineTo(lastValidX, chartTop + chartHeight);
    ctx.lineTo(firstX, chartTop + chartHeight);
    ctx.closePath();
    // Fill the area
    ctx.fillStyle = areaColor;
    ctx.fill();
    // Draw the line on top
    ctx.beginPath();
    ctx.strokeStyle = lineColor;
    ctx.lineWidth = 2;
    data.forEach((candle, i)=>{
        // Calculate x position based on the candle's position in the full dataset
        const dataIndex = data[i].time ? __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["globalCandleData"].findIndex((c)=>c.time === data[i].time) : i;
        const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
        const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
        // Skip if outside visible area
        if (x < 0 || x > chartWidth) return;
        const y = chartTop + (priceRange.max - candle.close) / priceRangeDiff * chartHeight;
        if (i === 0) {
            ctx.moveTo(x, y);
        } else {
            ctx.lineTo(x, y);
        }
    });
    ctx.stroke();
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/main.ts [app-ssr] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartMainRenderer",
    ()=>ChartMainRenderer,
    "renderChart",
    ()=>renderChart
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/expiry-marker.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$position$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/position-marker.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$grid$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/grid.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$price$2d$axis$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/price-axis.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$candlestick$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/candlestick.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$line$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/line.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$bar$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/bar.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$area$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/chart-types/area.ts [app-ssr] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
function renderChart(ctx, data, chartType, chartWidth, chartHeight, chartTop, priceRange, candleWidth, spacing, darkMode, visibleRange) {
    // Calculate visible data without future candles
    const bufferedVisibleData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["getVisibleDataWithBuffer"])(data, visibleRange);
    if (bufferedVisibleData.length === 0) return;
    // Calculate the position of each candle based on the visible range
    const totalVisibleRange = visibleRange ? visibleRange.end - visibleRange.start : data.length;
    const startOffset = visibleRange ? visibleRange.start : 0;
    switch(chartType){
        case "candlestick":
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$candlestick$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderCandlesticks"])(ctx, bufferedVisibleData, chartWidth, chartHeight, chartTop, priceRange, candleWidth, spacing, darkMode, totalVisibleRange, startOffset);
            break;
        case "line":
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$line$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderLine"])(ctx, bufferedVisibleData, chartWidth, chartHeight, chartTop, priceRange, darkMode, totalVisibleRange, startOffset);
            break;
        case "bar":
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$bar$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderBars"])(ctx, bufferedVisibleData, chartWidth, chartHeight, chartTop, priceRange, candleWidth, spacing, darkMode, totalVisibleRange, startOffset);
            break;
        case "area":
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$chart$2d$types$2f$area$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderArea"])(ctx, bufferedVisibleData, chartWidth, chartHeight, chartTop, priceRange, darkMode, totalVisibleRange, startOffset);
            break;
    }
}
const ChartMainRenderer = {
    render ({ ctx, candleData, visibleRange, chartWidth, priceChartHeight, chartTop, chartHeight, showGrid, theme, chartType, isDragging, priceScaleWidth, timeScaleHeight, volumeHeight, volumeTop, expiryMarkers, expiryMinutes, currentTime, positions, renderOnlyBackground, showExpiry, timeFrame }) {
        if (!ctx || !candleData || candleData.length === 0) {
            return;
        }
        // Set global candle data for reference in other components
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["setGlobalCandleData"])(candleData);
        // Calculate visible data
        const bufferedVisibleData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["getVisibleDataWithBuffer"])(candleData, visibleRange);
        if (bufferedVisibleData.length === 0) {
            return;
        }
        // Calculate price range with padding
        let minPrice = Math.min(...bufferedVisibleData.map((d)=>d.low));
        let maxPrice = Math.max(...bufferedVisibleData.map((d)=>d.high));
        const priceRange = maxPrice - minPrice;
        // Use dynamic padding based on price range and chart height
        // For larger price ranges or smaller charts, use less padding
        const heightFactor = Math.min(1, priceChartHeight / 400);
        const pricePadding = priceRange * 0.1 * heightFactor;
        minPrice = Math.max(0, minPrice - pricePadding);
        maxPrice = maxPrice + pricePadding;
        // Update the exported price range
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"].min = minPrice;
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"].max = maxPrice;
        // Define grid color based on the theme
        const gridColor = theme === "dark" ? "rgba(255, 255, 255, 0.1)" : "rgba(0, 0, 0, 0.1)";
        // Draw grid with theme-based styling
        if (showGrid) {
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$grid$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderGrid"])(ctx, chartWidth, priceChartHeight, volumeHeight, chartTop, volumeTop, theme === "dark", theme === "dark" ? "rgba(255, 255, 255, 0.07)" : "rgba(0, 0, 0, 0.07)", candleData, visibleRange);
        }
        // Draw axes with theme-based styling
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$price$2d$axis$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderPriceAxis"])(ctx, chartWidth, priceChartHeight, volumeHeight, chartTop, volumeTop, {
            min: minPrice,
            max: maxPrice
        }, {
            min: 0,
            max: Math.max(...bufferedVisibleData.map((d)=>d.volume)) * 1.1
        }, priceScaleWidth, timeScaleHeight, theme === "dark", candleData // Pass the full candle data to access the current price
        );
        if (renderOnlyBackground) {
            return;
        }
        // Calculate candle width and spacing
        const totalCandleWidth = chartWidth / (visibleRange.end - visibleRange.start);
        const candleWidth = Math.max(1, totalCandleWidth * 0.8);
        const spacing = totalCandleWidth * 0.2;
        // Add clipping to prevent drawing outside the chart area
        ctx.save();
        ctx.beginPath();
        ctx.rect(0, chartTop, chartWidth, chartHeight);
        ctx.clip();
        // Render the selected chart type
        renderChart(ctx, candleData, chartType, chartWidth, priceChartHeight, chartTop, {
            min: minPrice,
            max: maxPrice
        }, candleWidth, spacing, theme === "dark", visibleRange);
        // Render the top blur gradient AFTER the chart but BEFORE the expiry markers
        if (theme === "dark") {
            // Update the top blur gradient to use black instead of dark gray
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["renderTopBlurGradient"])(ctx, chartWidth, chartHeight, chartTop);
        }
        // Remove clipping
        ctx.restore();
        // Generate and render expiry markers in one place - SINGLE SOURCE OF TRUTH
        if (expiryMinutes > 0 && expiryMarkers && expiryMarkers.length > 0 && showExpiry) {
            // Added showExpiry condition
            const now = currentTime ? new Date(currentTime) : new Date();
            try {
                // Save context for expiry markers
                ctx.save();
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderExpiryMarkers"])(ctx, expiryMarkers, candleData, chartWidth, chartHeight, chartTop, visibleRange, now.getTime(), showExpiry // Added showExpiry parameter
                );
                ctx.restore();
            } catch (error) {
                console.error("Failed to render expiry markers:", error);
            }
        }
        // Render position markers if available
        if (positions && positions.length > 0) {
            const now = currentTime ? new Date(currentTime) : new Date();
            ctx.save();
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$position$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderPositionMarkers"])(ctx, positions, candleData, chartWidth, priceChartHeight, chartTop, visibleRange, {
                min: minPrice,
                max: maxPrice
            }, now.getTime());
            ctx.restore();
        }
    },
    // Add this priceToY function to convert price to Y coordinate
    priceToY (price, priceRange, chartHeight, chartTop) {
        if (!priceRange || priceRange.min === undefined || priceRange.max === undefined) {
            return 0;
        }
        const { min, max } = priceRange;
        if (max === min) return chartTop + chartHeight / 2;
        // Calculate the Y position based on price and chart dimensions
        return chartTop + (max - price) / (max - min) * chartHeight;
    }
};
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/volume.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartVolumeRenderer",
    ()=>ChartVolumeRenderer,
    "renderVolume",
    ()=>renderVolume
]);
// Helper function to get global candle data
let globalCandleData = [];
function renderVolume(ctx, data, chartWidth, volumeHeight, volumeTop, volumeRange, candleWidth, spacing, darkMode, totalVisibleRange, startOffset) {
    const bullColor = "rgba(34, 197, 94, 0.5)"; // Semi-transparent green
    const bearColor = "rgba(239, 68, 68, 0.5)"; // Semi-transparent red
    // Find the position of each candle in the global dataset
    const candlePositions = data.map((candle, i)=>{
        if (globalCandleData.length > 0 && candle.time) {
            const dataIndex = globalCandleData.findIndex((c)=>c.time === candle.time);
            return dataIndex >= 0 ? dataIndex : i;
        }
        return i;
    });
    // Calculate the x position for each candle
    data.forEach((candle, i)=>{
        const position = candlePositions[i];
        // Calculate the center position of the candle
        const x = (position - startOffset) / totalVisibleRange * chartWidth;
        // Skip if outside visible area
        if (x < -candleWidth || x > chartWidth) return;
        const isBullish = candle.close >= candle.open;
        // Calculate volume bar height
        const volumeHeight2 = candle.volume / volumeRange.max * volumeHeight;
        const volumeY = volumeTop + volumeHeight - volumeHeight2;
        // Draw volume bar - center it like we do with candles
        ctx.fillStyle = isBullish ? bullColor : bearColor;
        // Adjust x position to center the volume bar (subtract half the width)
        ctx.fillRect(x - (candleWidth - spacing) / 2, volumeY, candleWidth - spacing, volumeHeight2);
    });
}
const ChartVolumeRenderer = {
    render ({ ctx, candleData, visibleRange, chartWidth, volumeHeight, volumeTop, theme, isDragging }) {
        if (!ctx || !candleData || candleData.length === 0) return;
        // Use the global candle data from main renderer
        globalCandleData = candleData;
        // Calculate visible data
        const start = Math.max(0, Math.floor(visibleRange.start));
        const end = Math.min(candleData.length, Math.ceil(visibleRange.end));
        const visibleData = candleData.slice(start, end);
        // Add a buffer to prevent popping at edges
        const bufferSize = Math.min(20, Math.floor((end - start) * 0.1));
        const bufferedStart = Math.max(0, start - bufferSize);
        const bufferedEnd = Math.min(candleData.length, end + bufferSize);
        const bufferedVisibleData = candleData.slice(bufferedStart, bufferedEnd);
        if (bufferedVisibleData.length === 0) return;
        // Calculate volume range
        const maxVolume = Math.max(...bufferedVisibleData.map((d)=>d.volume));
        const volumeRange = {
            min: 0,
            max: maxVolume * 1.1
        };
        // Calculate candle width and spacing
        const totalCandleWidth = chartWidth / (visibleRange.end - visibleRange.start);
        const candleWidth = Math.max(1, totalCandleWidth * 0.8);
        const spacing = totalCandleWidth * 0.2;
        // Make the volume panel background transparent as well
        ctx.fillStyle = theme === "dark" ? "rgba(0, 0, 0, 0.5)" : "rgba(255, 255, 255, 0.5)";
        ctx.fillRect(0, volumeTop, chartWidth, volumeHeight);
        // Render volume
        renderVolume(ctx, bufferedVisibleData, chartWidth, volumeHeight, volumeTop, volumeRange, candleWidth, spacing, theme, visibleRange.end - visibleRange.start, visibleRange.start);
    }
};
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/overlay.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartOverlayRenderer",
    ()=>ChartOverlayRenderer,
    "renderCrosshair",
    ()=>renderCrosshair
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/theme/colors.ts [app-ssr] (ecmascript)");
;
;
function renderCrosshair(ctx, mousePosition, chartWidth, chartHeight, volumeHeight, priceRange, priceScaleWidth, darkMode) {
    // Use theme-appropriate colors from our centralized colors
    const crosshairColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getCrosshairColors"])(darkMode);
    const crosshairColor = crosshairColors.line;
    const labelBgColor = crosshairColors.label.background;
    const labelTextColor = crosshairColors.label.text;
    ctx.strokeStyle = crosshairColor;
    ctx.lineWidth = 1;
    ctx.setLineDash([
        5,
        5
    ]);
    // Horizontal line
    ctx.beginPath();
    ctx.moveTo(0, mousePosition.y);
    ctx.lineTo(chartWidth, mousePosition.y);
    ctx.stroke();
    // Vertical line
    ctx.beginPath();
    ctx.moveTo(mousePosition.x, 0);
    ctx.lineTo(mousePosition.x, chartHeight + volumeHeight);
    ctx.stroke();
    ctx.setLineDash([]);
    // Price at cursor
    const price = priceRange.max - mousePosition.y / chartHeight * (priceRange.max - priceRange.min);
    // Draw price label background
    ctx.fillStyle = labelBgColor;
    ctx.fillRect(chartWidth, mousePosition.y - 10, priceScaleWidth, 20);
    // Draw price label
    ctx.fillStyle = labelTextColor;
    ctx.textAlign = "right";
    ctx.font = "bold 10px Arial";
    ctx.fillText((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(price), chartWidth + priceScaleWidth - 5, mousePosition.y);
}
const ChartOverlayRenderer = {
    render ({ ctx, candleData, mousePosition, hoverEffect, chartWidth, priceChartHeight, chartTop, theme, isDragging, priceScaleWidth, volumeHeight, priceRange }) {
        if (!ctx || !candleData || candleData.length === 0) return;
        // We must use the provided priceRange from the main chart renderer
        if (!priceRange || typeof priceRange.min !== "number" || typeof priceRange.max !== "number") {
            console.warn("Price range not provided to overlay renderer");
            return;
        }
        const minPrice = priceRange.min;
        const maxPrice = priceRange.max;
        const darkMode = theme === "dark";
        // Draw current price line
        if (candleData.length > 0) {
            const currentPrice = candleData[candleData.length - 1].close;
            // Calculate the y position based on the visible price range
            const currentPriceY = chartTop + (maxPrice - currentPrice) / (maxPrice - minPrice) * priceChartHeight;
            // Determine price line color based on the latest candle
            const latestCandle = candleData[candleData.length - 1];
            const priceLineColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getPriceLineColors"])(darkMode);
            let priceLineColor;
            if (latestCandle.close > latestCandle.open) {
                // Bullish candle - green
                priceLineColor = priceLineColors.bullish;
            } else if (latestCandle.close < latestCandle.open) {
                // Bearish candle - red
                priceLineColor = priceLineColors.bearish;
            } else {
                // Neutral candle - gray
                priceLineColor = priceLineColors.neutral;
            }
            // Draw the price line with the appropriate color - ONLY dashed line, no solid line
            ctx.beginPath();
            ctx.strokeStyle = priceLineColor;
            ctx.lineWidth = 1;
            ctx.setLineDash([
                5,
                5
            ]);
            ctx.moveTo(0, currentPriceY);
            ctx.lineTo(chartWidth, currentPriceY);
            ctx.stroke();
            ctx.setLineDash([]);
            // Draw current price label on the price scale (right side)
            ctx.fillStyle = priceLineColor;
            ctx.fillRect(chartWidth, currentPriceY - 10, priceScaleWidth, 20);
            // Draw price text
            ctx.fillStyle = "#ffffff"; // White text for better contrast
            ctx.font = "bold 11px Inter, sans-serif";
            ctx.textAlign = "right";
            ctx.textBaseline = "middle";
            ctx.fillText((0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(currentPrice), chartWidth + priceScaleWidth - 5, currentPriceY);
        }
        // Draw crosshair if mouse is over chart and not dragging
        if (mousePosition && mousePosition.x < chartWidth && mousePosition.y < priceChartHeight && !isDragging) {
            renderCrosshair(ctx, mousePosition, chartWidth, priceChartHeight, volumeHeight, {
                min: minPrice,
                max: maxPrice
            }, priceScaleWidth, theme === "dark");
        }
        // Draw hover effect if present
        if (hoverEffect) {
            ctx.beginPath();
            ctx.arc(hoverEffect.x, hoverEffect.y, hoverEffect.radius, 0, Math.PI * 2);
            ctx.fillStyle = "rgba(255, 255, 255, 0.1)";
            ctx.fill();
        }
    }
};
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/connection-status.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>ConnectionStatus
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
"use client";
;
function ConnectionStatus({ wsStatus, lastError, reconnectAttempt, reconnectCount, maxReconnectAttempts }) {
    // Determine status color
    const getStatusColor = ()=>{
        switch(wsStatus){
            case "connected":
                return "bg-green-500";
            case "connecting":
            case "reconnecting":
                return "bg-yellow-500";
            case "disconnected":
            case "error":
                return "bg-red-500";
            default:
                return "bg-gray-500";
        }
    };
    // Determine status text
    const getStatusText = ()=>{
        switch(wsStatus){
            case "connected":
                return "Connected";
            case "connecting":
                return "Connecting";
            case "reconnecting":
                return `Reconnecting (${reconnectAttempt}/${maxReconnectAttempts})`;
            case "disconnected":
                return "Disconnected";
            case "error":
                return "Error";
            default:
                return "Unknown";
        }
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "flex items-center p-1 text-xs",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "flex items-center",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: `h-2 w-2 rounded-full ${getStatusColor()} mr-1`
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/connection-status.tsx",
                    lineNumber: 60,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                    className: "text-gray-400",
                    children: getStatusText()
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/connection-status.tsx",
                    lineNumber: 61,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/connection-status.tsx",
            lineNumber: 59,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/connection-status.tsx",
        lineNumber: 58,
        columnNumber: 5
    }, this);
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/index.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__,
    "formatTimeLabel",
    ()=>formatTimeLabel,
    "renderFooter",
    ()=>renderFooter
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$connection$2d$status$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/connection-status.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$hooks$2f$use$2d$mobile$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/hooks/use-mobile.ts [app-ssr] (ecmascript)"); // Add a check for mobile devices
// Import the color utilities
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/theme/colors.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
function formatTimeLabel(time, timeFrame = "1m") {
    const dateObj = typeof time === "number" ? new Date(time) : time;
    if (!(dateObj instanceof Date) || isNaN(dateObj.getTime())) {
        return "--:--";
    }
    // Format based on timeframe
    if (timeFrame === "1d" || timeFrame === "1w" || timeFrame === "1M") {
        // For daily, weekly, or monthly timeframes, show date only
        return dateObj.toLocaleDateString(undefined, {
            month: "numeric",
            day: "numeric"
        });
    } else {
        // For all other timeframes (4h, 1h, 15m, 5m, 1m), show time in hh:mm format
        const hours = dateObj.getHours().toString().padStart(2, "0");
        const minutes = dateObj.getMinutes().toString().padStart(2, "0");
        // If we're showing multiple days, include the date
        if (shouldShowDate(dateObj, timeFrame)) {
            const month = (dateObj.getMonth() + 1).toString();
            const day = dateObj.getDate().toString();
            return `${month}/${day} ${hours}:${minutes}`;
        } else {
            // Just show time
            return `${hours}:${minutes}`;
        }
    }
}
// Helper function to determine if we should show the date
function shouldShowDate(date, timeFrame) {
    // For timeframes of 4h or larger, always show date
    if (timeFrame === "4h" || timeFrame === "1h") {
        return true;
    }
    // For smaller timeframes, check if this is a day boundary
    const now = new Date();
    return date.getDate() !== now.getDate() || date.getMonth() !== now.getMonth() || date.getFullYear() !== now.getFullYear();
}
function renderFooter({ ctx, chartWidth, chartHeight, timeScaleHeight, priceScaleWidth, theme, data, visibleRange, isLoadingOlderData, timeFrame = "1m" }) {
    // Check if context is valid before proceeding
    if (!ctx) return;
    const darkMode = theme === "dark";
    // Use theme-appropriate colors from our centralized colors
    const axisColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getAxisColors"])(darkMode);
    const textColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTextColors"])(darkMode);
    // Update the background color to use our centralized colors
    const bgColor = axisColors.time.background;
    // Update the text color to use our centralized colors
    const textColor = axisColors.time.text;
    // Update the grid color to use our centralized colors
    const gridColor = axisColors.time.line;
    // Draw time scale background - reduced height by using only the actual timeScaleHeight
    ctx.fillStyle = bgColor;
    ctx.fillRect(0, chartHeight, chartWidth, timeScaleHeight);
    // Get grid positions from the grid renderer
    const gridPositions = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : [];
    // Adjust density of time labels based on timeframe
    let skipFactor = 1;
    if (gridPositions.length > 15) {
        // For very dense grids, show fewer labels
        skipFactor = Math.ceil(gridPositions.length / 15);
    }
    // Set text properties
    ctx.fillStyle = textColor;
    ctx.font = "10px Arial"; // Slightly larger font for better readability
    ctx.textAlign = "center";
    ctx.textBaseline = "middle";
    // Draw time labels and grid markers
    ctx.beginPath(); // Start a single path for all grid markers
    for(let i = 0; i < gridPositions.length; i++){
        const pos = gridPositions[i];
        if (pos.x >= 0 && pos.x <= chartWidth) {
            // Only show labels based on skip factor for cleaner display
            if (i % skipFactor === 0) {
                // Format time label based on timeframe
                const label = formatTimeLabel(pos.time, timeFrame);
                // Draw time label
                ctx.fillText(label, pos.x, chartHeight + timeScaleHeight / 2);
            }
            // Add grid marker to path (show all grid lines, even if label is skipped)
            ctx.moveTo(pos.x, chartHeight);
            ctx.lineTo(pos.x, chartHeight + 4); // Slight adjustment to tick height
        }
    }
    // Draw all grid markers at once
    ctx.strokeStyle = gridColor;
    ctx.stroke();
    // Draw corner rectangle
    ctx.fillStyle = bgColor;
    ctx.fillRect(chartWidth, chartHeight, priceScaleWidth, timeScaleHeight);
}
// React component for the footer
const Footer = ()=>{
    const context = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChartContext"])();
    const { wsStatus, lastError, reconnectAttempt, reconnectCount, timeFrame } = context;
    // Use type assertion to access showExpiry property
    const showExpiry = context.showExpiry ?? true;
    const isMobile = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$hooks$2f$use$2d$mobile$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useIsMobile"])();
    // Don't render the component if showExpiry is false
    if (!showExpiry) {
        return null;
    }
    // Update the return statement to be more compact on mobile
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: `relative w-full h-full ${isMobile ? "bg-transparent" : ""}`,
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: `absolute bottom-0 right-0 ${isMobile ? "scale-75 origin-bottom-right" : ""}`,
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$connection$2d$status$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {
                wsStatus: wsStatus,
                lastError: lastError ? lastError : undefined,
                reconnectAttempt: typeof reconnectAttempt === "number" ? reconnectAttempt : 0,
                reconnectCount: reconnectCount,
                maxReconnectAttempts: 5
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/index.tsx",
                lineNumber: 185,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        }, void 0, false, {
            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/index.tsx",
            lineNumber: 182,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/index.tsx",
        lineNumber: 178,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const __TURBOPACK__default__export__ = Footer;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/indicator.ts [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartIndicatorRenderer",
    ()=>ChartIndicatorRenderer,
    "renderIndicator",
    ()=>renderIndicator,
    "renderIndicators",
    ()=>renderIndicators,
    "renderTechnicalIndicatorPanes",
    ()=>renderTechnicalIndicatorPanes
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/registry.ts [app-ssr] (ecmascript)");
"use client";
;
// Cache for indicator data to prevent recalculation
const indicatorDataCache = new Map();
// Cache for rendered indicator paths to prevent re-rendering
const renderedPathCache = new Map();
// Cache for rendered indicator panel paths to prevent re-rendering
const renderedPanelCache = new Map();
// Modify the getVisibleIndicatorData function to always use the latest data, not just during dragging
function getVisibleIndicatorData(indicator, visibleData, globalCandleData) {
    if (!visibleData.length || !indicator.data || !indicator.data.length) return [];
    // Generate a cache key based on indicator id and data length
    const cacheKey = `${indicator.id}-${visibleData[0].time}-${visibleData[visibleData.length - 1].time}`;
    // Check if we have a valid cached result - ALWAYS USE CACHE REGARDLESS OF DRAGGING STATE
    const cachedResult = indicatorDataCache.get(cacheKey);
    if (cachedResult && cachedResult.candleDataLength === globalCandleData.length) {
        return cachedResult.data;
    }
    // If we don't have global data, return the full indicator data
    if (!globalCandleData.length) return indicator.data;
    // Find the start and end indices in the full dataset
    const startTime = visibleData[0].time;
    const endTime = visibleData[visibleData.length - 1].time;
    const startIndex = globalCandleData.findIndex((candle)=>candle.time === startTime);
    const endIndex = globalCandleData.findIndex((candle)=>candle.time === endTime);
    let result = [];
    if (startIndex === -1 || endIndex === -1) {
        console.warn("Could not find exact time matches for indicator alignment");
        // Fallback to proportional slicing
        const startRatio = visibleData[0].time / globalCandleData[globalCandleData.length - 1].time;
        const endRatio = visibleData[visibleData.length - 1].time / globalCandleData[globalCandleData.length - 1].time;
        const start = Math.floor(startRatio * indicator.data.length);
        const end = Math.ceil(endRatio * indicator.data.length);
        result = indicator.data.slice(start, end);
    } else {
        // Return the slice of indicator data that corresponds to the visible candles
        // Make sure we don't go out of bounds
        const start = Math.max(0, startIndex);
        const end = Math.min(indicator.data.length, endIndex + 1);
        result = indicator.data.slice(start, end);
    }
    // Cache the result
    indicatorDataCache.set(cacheKey, {
        data: result,
        timestamp: Date.now(),
        candleDataLength: globalCandleData.length
    });
    return result;
}
// Modify the renderRSIPanel function to always render, not just during dragging
function renderRSIPanel(ctx, indicator, data, chartWidth, panelHeight, panelTop, priceScaleWidth, darkMode, globalCandleData = [], visibleRange = {
    start: 0,
    end: 0
}, totalVisibleRange = 0, startOffset = 0, isDragging = false) {
    // Make sure we have data to render
    if (!indicator.data || indicator.data.length === 0) {
        console.warn(`No data for ${indicator.type} indicator`);
        return;
    }
    // Use visibleData if available (provided by the renderer), otherwise use the full data
    const indicatorData = indicator.visibleData || indicator.data;
    // Define RSI range (typically 0-100)
    const rsiMin = 0;
    const rsiMax = 100;
    const rsiRange = rsiMax - rsiMin;
    // Define overbought and oversold levels
    const overbought = 70;
    const oversold = 30;
    // Draw overbought/oversold zones
    const overboughtY = panelTop + (rsiMax - overbought) / rsiRange * panelHeight;
    const oversoldY = panelTop + (rsiMax - oversold) / rsiRange * panelHeight;
    ctx.fillStyle = darkMode ? "rgba(255, 50, 50, 0.1)" : "rgba(255, 50, 50, 0.1)";
    ctx.fillRect(0, panelTop, chartWidth, overboughtY - panelTop);
    ctx.fillStyle = darkMode ? "rgba(50, 255, 50, 0.1)" : "rgba(50, 255, 50, 0.1)";
    ctx.fillRect(0, oversoldY, chartWidth, panelTop + panelHeight - oversoldY);
    // Draw center line (50)
    const centerY = panelTop + (rsiMax - 50) / rsiRange * panelHeight;
    ctx.beginPath();
    ctx.strokeStyle = darkMode ? "rgba(212, 212, 216, 0.2)" : "rgba(63, 63, 70, 0.2)";
    ctx.setLineDash([
        2,
        2
    ]);
    ctx.moveTo(0, centerY);
    ctx.lineTo(chartWidth, centerY);
    ctx.stroke();
    // Draw overbought/oversold lines
    ctx.beginPath();
    ctx.strokeStyle = darkMode ? "rgba(255, 50, 50, 0.5)" : "rgba(255, 50, 50, 0.5)";
    ctx.moveTo(0, overboughtY);
    ctx.lineTo(chartWidth, overboughtY);
    ctx.stroke();
    ctx.beginPath();
    ctx.strokeStyle = darkMode ? "rgba(50, 255, 50, 0.5)" : "rgba(50, 255, 50, 0.5)";
    ctx.moveTo(0, oversoldY);
    ctx.lineTo(chartWidth, oversoldY);
    ctx.stroke();
    ctx.setLineDash([]); // Reset line dash
    // Generate a cache key for this panel rendering
    const cacheKey = `${indicator.id}-panel-${data[0]?.time}-${data[data.length - 1]?.time}-${chartWidth}-${panelHeight}`;
    // Only use cache during dragging for performance, always render fresh otherwise
    const cachedPanel = renderedPanelCache.get(cacheKey);
    const useCache = isDragging && cachedPanel && cachedPanel.timestamp > Date.now() - 2000 && // Cache valid for 2 seconds
    cachedPanel.data.length === indicatorData.length;
    if (useCache) {
        // Use the cached path during dragging
        ctx.strokeStyle = indicator.color;
        ctx.lineWidth = isDragging ? 1 : 2;
        ctx.stroke(cachedPanel.paths[0]);
        return;
    }
    // Draw RSI line
    const path = new Path2D();
    ctx.beginPath();
    ctx.strokeStyle = indicator.color;
    ctx.lineWidth = isDragging ? 1 : 2;
    let started = false;
    // Draw the RSI line with proper positioning for future candles
    for(let i = 0; i < data.length; i++){
        const value = i < indicatorData.length ? indicatorData[i] : null;
        if (value === null || isNaN(value)) continue;
        // Calculate x position based on the candle's position in the full dataset
        // This ensures indicators are positioned correctly when scrolling
        const dataIndex = data[i].time ? globalCandleData.findIndex((c)=>c.time === data[i].time) : i;
        const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
        const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
        // Skip if outside visible area
        if (x < 0 || x > chartWidth) continue;
        const y = panelTop + (rsiMax - value) / rsiRange * panelHeight;
        if (!started) {
            path.moveTo(x, y);
            started = true;
        } else {
            path.lineTo(x, y);
        }
    }
    // Cache the path for future use
    renderedPanelCache.set(cacheKey, {
        paths: [
            path
        ],
        timestamp: Date.now(),
        colors: [
            indicator.color
        ],
        data: [
            ...indicatorData
        ]
    });
    ctx.stroke(path);
}
function renderIndicators(ctx, indicators, data, chartWidth, chartHeight, chartTop, priceRange, visibleRange, totalVisibleRange, startOffset, globalCandleData, isDragging = false) {
    // Filter visible indicators - only render indicators that are explicitly set to visible
    const visibleIndicators = indicators.filter((indicator)=>indicator && indicator.visible === true);
    // If no visible indicators, return early
    if (visibleIndicators.length === 0) return;
    // Use simpler rendering during dragging for better performance
    const lineWidth = isDragging ? 1.0 : 1.5;
    const useGlow = !isDragging;
    // Render each indicator
    visibleIndicators.forEach((indicator)=>{
        // Skip if no data
        if (!indicator.data || indicator.data.length === 0) return;
        // Generate a cache key for this indicator's rendered path
        const cacheKey = `${indicator.id}-${data[0]?.time}-${data[data.length - 1]?.time}-${chartWidth}-${chartHeight}-${priceRange.min}-${priceRange.max}`;
        // Check if we have a cached path that we can reuse
        const cachedPath = renderedPathCache.get(cacheKey);
        if (cachedPath && cachedPath.timestamp > Date.now() - 2000 && // Cache valid for 2 seconds
        cachedPath.color === indicator.color && cachedPath.lineWidth === lineWidth && cachedPath.lineStyle === (indicator.lineStyle || "solid")) {
            // Use the cached path
            ctx.strokeStyle = indicator.color || "#3b82f6";
            ctx.lineWidth = lineWidth;
            // Apply line style if specified
            if (indicator.lineStyle === "dashed") {
                ctx.setLineDash([
                    5,
                    3
                ]);
            } else if (indicator.lineStyle === "dotted") {
                ctx.setLineDash([
                    2,
                    2
                ]);
            } else {
                ctx.setLineDash([]);
            }
            // Add subtle glow effect only when not dragging
            if (useGlow) {
                ctx.shadowColor = indicator.color || "#3b82f6";
                ctx.shadowBlur = 2;
            } else {
                ctx.shadowBlur = 0;
            }
            ctx.stroke(cachedPath.path);
            ctx.shadowBlur = 0;
            return;
        }
        // Get visible portion of indicator data that aligns with visible candles
        const visibleIndicatorData = getVisibleIndicatorData(indicator, data, globalCandleData);
        // Skip if no visible data
        if (visibleIndicatorData.length === 0) return;
        // Create a new Path2D object for the indicator line
        const path = new Path2D();
        // Set line style
        ctx.strokeStyle = indicator.color || "#3b82f6";
        ctx.lineWidth = 1.5;
        // Apply line style if specified
        if (indicator.lineStyle === "dashed") {
            ctx.setLineDash([
                5,
                3
            ]);
        } else if (indicator.lineStyle === "dotted") {
            ctx.setLineDash([
                2,
                2
            ]);
        } else {
            ctx.setLineDash([]);
        }
        let started = false;
        // Draw indicator line
        for(let i = 0; i < Math.min(data.length, visibleIndicatorData.length); i++){
            const value = visibleIndicatorData[i];
            if (isNaN(value)) continue;
            // Calculate x position based on the candle's position in the full dataset
            // This ensures indicators are positioned correctly when scrolling
            const dataIndex = data[i].time ? globalCandleData.findIndex((c)=>c.time === data[i].time) : i;
            const adjustedIndex = dataIndex >= 0 ? dataIndex : i;
            const x = (adjustedIndex - startOffset) / totalVisibleRange * chartWidth;
            // Skip if outside visible area
            if (x < 0 || x > chartWidth) continue;
            // Calculate y position based on indicator value
            const y = chartTop + (priceRange.max - value) / (priceRange.max - priceRange.min) * chartHeight;
            if (!started) {
                path.moveTo(x, y);
                started = true;
            } else {
                path.lineTo(x, y);
            }
        }
        // Cache the path for future use
        renderedPathCache.set(cacheKey, {
            path,
            timestamp: Date.now(),
            color: indicator.color || "#3b82f6",
            lineWidth: 1.5,
            lineStyle: indicator.lineStyle || "solid"
        });
        // Add subtle glow effect
        ctx.shadowColor = indicator.color || "#3b82f6";
        ctx.shadowBlur = 2;
        ctx.stroke(path);
        ctx.shadowBlur = 0;
    });
}
function renderTechnicalIndicatorPanes(ctx, indicators, visibleData, chartWidth, chartTop, priceChartHeight, volumeHeight, priceScaleWidth, theme, setShowIndicatorPanel, setActiveIndicatorId, toggleIndicator, paneHeights = {}, setPanelHeights, collapsedPanels = {}, setCollapsedPanels, isDraggingPanel = {}, setIsDraggingPanel, globalCandleData = [], visibleRange = {
    start: 0,
    end: 0
}, totalVisibleRange = 0, startOffset = 0, isDragging = false) {
    // Ensure indicators is an array and filter for visible indicators that should be in separate panes
    const safeIndicators = Array.isArray(indicators) ? indicators : [];
    const separatePanelIndicators = safeIndicators.filter((i)=>i && i.visible && i.separatePanel);
    if (separatePanelIndicators.length === 0) return {
        paneTop: chartTop + priceChartHeight + volumeHeight,
        handlePaneClick: ()=>false,
        handlePaneResize: ()=>{}
    };
    let paneTop = chartTop + priceChartHeight + volumeHeight;
    // Ensure paneHeights and collapsedPanels are objects
    const safePaneHeights = paneHeights || {};
    const safeCollapsedPanels = collapsedPanels || {};
    // Render each indicator pane
    separatePanelIndicators.forEach((indicator, index)=>{
        // Skip if indicator doesn't have an id
        if (!indicator || !indicator.id) return;
        // Get pane height from state or use default
        const paneHeight = safePaneHeights[indicator.id] || 100;
        const isCollapsed = safeCollapsedPanels[indicator.id] || false;
        // Include the header height in the total panel height calculation
        const headerHeight = 0; // Changed from 24 to remove the header
        const actualPaneHeight = isCollapsed ? 6 // only 6px high when collapsed
         : safePaneHeights[indicator.id] || 100; // same as configured paneHeight
        // Draw pane background - semi-transparent
        ctx.fillStyle = theme === "dark" ? "rgba(0, 0, 0, 0.7)" : "rgba(255, 255, 255, 0.7)";
        ctx.fillRect(0, paneTop, chartWidth, actualPaneHeight);
        // Draw pane border (only in dark mode to avoid black artifacts in light mode)
        if (theme === "dark") {
            ctx.strokeStyle = "rgba(255, 255, 255, 0.1)";
            ctx.lineWidth = 1;
            ctx.strokeRect(0, paneTop, chartWidth, actualPaneHeight);
        }
        // Draw title bar (smaller height, no separate header)
        const titleHeight = 24;
        // Only draw header if headerHeight > 0
        if (headerHeight > 0) {
            // Draw title bar
            ctx.fillStyle = theme === "dark" ? "rgba(26, 28, 39, 0.8)" : "rgba(240, 241, 245, 0.8)";
            ctx.fillRect(0, paneTop, chartWidth, titleHeight);
            // Draw indicator name in the title bar
            const indicatorName = indicator.type.toUpperCase() + (indicator.params?.period ? ` (${indicator.params.period})` : "");
            ctx.fillStyle = theme === "dark" ? "rgba(255, 255, 255, 0.9)" : "rgba(0, 0, 0, 0.9)";
            ctx.font = "bold 12px Inter, sans-serif";
            ctx.textAlign = "left";
            ctx.textBaseline = "middle";
            ctx.fillText(indicatorName, 10, paneTop + titleHeight / 2);
        }
        // If not collapsed, render the indicator content
        if (!isCollapsed) {
            // Get the indicator definition from the registry
            const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][indicator.type];
            // Update contentTop and contentHeight
            const contentTop = paneTop; // No header offset
            const contentHeight = actualPaneHeight;
            // Draw Y-axis labels for the indicator pane
            ctx.fillStyle = theme === "dark" ? "rgba(255, 255, 255, 0.7)" : "rgba(0, 0, 0, 0.7)";
            ctx.font = "10px Arial";
            ctx.textAlign = "right";
            ctx.textBaseline = "middle";
            // Determine min/max values for the indicator
            let minValue = 0;
            let maxValue = 100;
            // For RSI, use 0-100 scale
            if (indicator.type === "rsi") {
                minValue = 0;
                maxValue = 100;
                // Draw standard RSI levels (30, 50, 70)
                const contentHeight = actualPaneHeight - titleHeight;
                const contentTop = paneTop + titleHeight;
                // Draw overbought line (70)
                const overboughtY = contentTop + 30 / 100 * contentHeight;
                ctx.strokeStyle = theme === "dark" ? "rgba(255, 100, 100, 0.3)" : "rgba(255, 0, 0, 0.2)";
                ctx.lineWidth = 1;
                ctx.beginPath();
                ctx.moveTo(0, overboughtY);
                ctx.lineTo(chartWidth, overboughtY);
                ctx.stroke();
                ctx.fillText("70", chartWidth + priceScaleWidth - 5, overboughtY);
                // Draw middle line (50)
                const middleY = contentTop + 50 / 100 * contentHeight;
                ctx.strokeStyle = theme === "dark" ? "rgba(212, 212, 216, 0.2)" : "rgba(63, 63, 70, 0.2)";
                ctx.beginPath();
                ctx.moveTo(0, middleY);
                ctx.lineTo(chartWidth, middleY);
                ctx.stroke();
                ctx.fillText("50", chartWidth + priceScaleWidth - 5, middleY);
                // Draw oversold line (30)
                const oversoldY = contentTop + 70 / 100 * contentHeight;
                ctx.strokeStyle = theme === "dark" ? "rgba(100, 255, 100, 0.3)" : "rgba(0, 255, 0, 0.2)";
                ctx.beginPath();
                ctx.moveTo(0, oversoldY);
                ctx.lineTo(chartWidth, oversoldY);
                ctx.stroke();
                ctx.fillText("30", chartWidth + priceScaleWidth - 5, oversoldY);
                // Only draw the min/max values if they're not too close to the other values
                const topY = contentTop + 5;
                const bottomY = contentTop + contentHeight - 5;
                // Only draw 100 if it's not too close to 70
                if (Math.abs(topY - overboughtY) > 15) {
                    ctx.fillText("100", chartWidth + priceScaleWidth - 5, topY);
                }
                // Only draw 0 if it's not too close to 30
                if (Math.abs(bottomY - oversoldY) > 15) {
                    ctx.fillText("0", chartWidth + priceScaleWidth - 5, bottomY);
                }
            } else if (indicator.data && indicator.data.length > 0) {
                const visibleIndicatorData = getVisibleIndicatorData(indicator, visibleData, globalCandleData);
                if (visibleIndicatorData.length > 0) {
                    minValue = Math.min(...visibleIndicatorData.filter((v)=>!isNaN(v)));
                    maxValue = Math.max(...visibleIndicatorData.filter((v)=>!isNaN(v)));
                    // Add some padding
                    const range = maxValue - minValue;
                    minValue = Math.max(0, minValue - range * 0.1);
                    maxValue = maxValue + range * 0.1;
                    // Draw min/max and middle values
                    const contentHeight = actualPaneHeight - titleHeight;
                    const contentTop = paneTop + titleHeight;
                    ctx.fillText(maxValue.toFixed(2), chartWidth + priceScaleWidth - 5, contentTop + 10);
                    ctx.fillText(((maxValue + minValue) / 2).toFixed(2), chartWidth + priceScaleWidth - 5, contentTop + contentHeight / 2);
                    ctx.fillText(minValue.toFixed(2), chartWidth + priceScaleWidth - 5, contentTop + contentHeight - 10);
                }
            }
            if (indicatorDef && indicatorDef.renderPanel) {
                try {
                    // Get visible portion of indicator data that aligns with visible candles
                    const visibleIndicatorData = getVisibleIndicatorData(indicator, visibleData, globalCandleData);
                    // Create a modified indicator with aligned data for rendering
                    const alignedIndicator = {
                        ...indicator,
                        visibleData: visibleIndicatorData
                    };
                    // ALWAYS render the indicator panel, even during dragging
                    // Call the indicator's renderPanel function with proper parameters
                    indicatorDef.renderPanel(ctx, alignedIndicator, visibleData, chartWidth, actualPaneHeight - titleHeight, paneTop + titleHeight, priceScaleWidth, theme === "dark", globalCandleData, visibleRange, totalVisibleRange, startOffset, isDragging // Pass the isDragging parameter
                    );
                } catch (error) {
                    console.error(`Error rendering panel for indicator ${indicator.type}:`, error);
                    // Draw error message
                    ctx.fillStyle = theme === "dark" ? "rgba(255, 100, 100, 0.8)" : "rgba(220, 50, 50, 0.8)";
                    ctx.font = "12px Inter, sans-serif";
                    ctx.textAlign = "center";
                    ctx.textBaseline = "middle";
                    ctx.fillText(`Error rendering ${indicator.type}`, chartWidth / 2, paneTop + titleHeight + (actualPaneHeight - titleHeight) / 2);
                }
            } else {
                // Draw message for missing renderer
                ctx.fillStyle = theme === "dark" ? "rgba(255, 255, 255, 0.5)" : "rgba(0, 0, 0, 0.5)";
                ctx.font = "12px Inter, sans-serif";
                ctx.textAlign = "center";
                ctx.textBaseline = "middle";
                ctx.fillText(`No renderer available for ${indicator.type}`, chartWidth / 2, paneTop + titleHeight + (actualPaneHeight - titleHeight) / 2);
            }
        }
        // Move to the next pane position
        paneTop += actualPaneHeight;
    });
    return {
        paneTop,
        handlePaneClick: (x, y)=>{
            // Check if click is within any pane
            let currentTop = chartTop + priceChartHeight + volumeHeight;
            for (const indicator of separatePanelIndicators){
                // Skip if indicator doesn't have an id
                if (!indicator || !indicator.id) continue;
                const paneHeight = safePaneHeights[indicator.id] || 100;
                const isCollapsed = safeCollapsedPanels[indicator.id] || false;
                const actualPaneHeight = isCollapsed ? 30 : paneHeight;
                const titleHeight = 24;
                // Check if click is within the title bar
                if (y >= currentTop && y <= currentTop + titleHeight) {
                    // Toggle indicator visibility when clicking on title bar
                    if (toggleIndicator) {
                        toggleIndicator(indicator.id);
                    }
                    return true;
                }
                currentTop += actualPaneHeight;
            }
            return false;
        },
        handlePaneResize: ()=>{
        // Resizing functionality removed as requested
        }
    };
}
const ChartIndicatorRenderer = {
    render ({ ctx, candleData, indicators, visibleRange, chartWidth, priceChartHeight, chartTop, chartHeight, theme, isDragging, renderQuality, showVolumeProfile, priceAlerts, volumeHeight, volumeTop, priceScaleWidth, setShowIndicatorPanel, setActiveIndicatorId, toggleIndicator, panelHeights, setPanelHeights, collapsedPanels, setCollapsedPanels, isDraggingPanel, setIsDraggingPanel }) {
        if (!ctx || !candleData || !Array.isArray(candleData) || candleData.length === 0) return;
        // Ensure all parameters have default values
        const safeIndicators = Array.isArray(indicators) ? indicators : [];
        const safeVisibleRange = visibleRange || {
            start: 0,
            end: candleData.length
        };
        const safePriceAlerts = Array.isArray(priceAlerts) ? priceAlerts : [];
        const safePanelHeights = panelHeights || {};
        const safeCollapsedPanels = collapsedPanels || {};
        const safeIsDraggingPanel = isDraggingPanel || {};
        // Calculate visible data
        const start = Math.max(0, Math.floor(safeVisibleRange.start));
        const end = Math.min(candleData.length, Math.ceil(safeVisibleRange.end));
        const visibleData = candleData.slice(start, end);
        // Add a buffer to prevent popping at edges
        const bufferSize = Math.min(20, Math.floor((end - start) * 0.1));
        const bufferedStart = Math.max(0, start - bufferSize);
        const bufferedEnd = Math.min(candleData.length, end + bufferSize);
        const bufferedVisibleData = candleData.slice(bufferedStart, bufferedEnd);
        if (bufferedVisibleData.length === 0) return;
        // Calculate price range with padding
        let minPrice = Math.min(...bufferedVisibleData.map((d)=>d.low));
        let maxPrice = Math.max(...bufferedVisibleData.map((d)=>d.high));
        const priceRange = maxPrice - minPrice;
        const pricePadding = priceRange * 0.1;
        minPrice = Math.max(0, minPrice - pricePadding);
        maxPrice = maxPrice + pricePadding;
        // Calculate total visible range and start offset for proper positioning
        const totalVisibleRange = safeVisibleRange.end - safeVisibleRange.start;
        const startOffset = safeVisibleRange.start;
        // ALWAYS render indicators, but with simplified rendering during dragging
        // Only render indicators that should be on the main chart (not in separate panes)
        const visibleIndicators = safeIndicators.filter((i)=>i && i.visible);
        const mainChartIndicators = visibleIndicators.filter((i)=>!i.separatePanel);
        // Use our renderIndicators function with isDragging parameter
        renderIndicators(ctx, mainChartIndicators, bufferedVisibleData, chartWidth, priceChartHeight, chartTop, {
            min: minPrice,
            max: maxPrice
        }, safeVisibleRange, totalVisibleRange, startOffset, candleData, isDragging // Pass the isDragging parameter
        );
        // ALWAYS render technical indicator panels, even during dragging
        // Use the new function to render technical indicator sections
        return renderTechnicalIndicatorPanes(ctx, safeIndicators, bufferedVisibleData, chartWidth, chartTop, priceChartHeight, volumeHeight || 0, priceScaleWidth, theme, setShowIndicatorPanel, setActiveIndicatorId, toggleIndicator, safePanelHeights, setPanelHeights, safeCollapsedPanels, setCollapsedPanels, safeIsDraggingPanel, setIsDraggingPanel, candleData, safeVisibleRange, totalVisibleRange, startOffset, isDragging // Pass the isDragging parameter
        );
    }
};
function renderIndicator(ctx, candles, indicator, visibleRange, dimensions, priceRange, theme, separatePanelHeight, separatePanelTop, separatePanelPriceRange) {
    if (!indicator || !indicator.visible || !indicator.data || indicator.data.length === 0) return;
    const isLightTheme = theme === "light";
    // Get the indicator definition from the registry
    const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][indicator.type];
    // Use theme-specific color if available, otherwise use the indicator's color
    let color = indicator.color;
    if (isLightTheme && indicatorDef?.getLightThemeColor) {
        color = indicatorDef.getLightThemeColor();
    } else if (!isLightTheme && indicatorDef?.getDarkThemeColor) {
        color = indicatorDef.getDarkThemeColor();
    }
    // Set line style
    ctx.strokeStyle = color;
    ctx.lineWidth = 1.5;
    // Set line dash based on lineStyle
    if (indicator.lineStyle === "dashed") {
        ctx.setLineDash([
            5,
            3
        ]);
    } else if (indicator.lineStyle === "dotted") {
        ctx.setLineDash([
            2,
            2
        ]);
    } else {
        ctx.setLineDash([]);
    }
    const startIdx = Math.max(0, Math.floor(visibleRange.start));
    const endIdx = Math.min(candles.length - 1, Math.ceil(visibleRange.end));
    // If the indicator is in a separate panel, use the separate panel dimensions
    const useHeight = indicator.separatePanel && separatePanelHeight ? separatePanelHeight : dimensions.height;
    const useTop = indicator.separatePanel && separatePanelTop !== undefined ? separatePanelTop : 0;
    const usePriceRange = indicator.separatePanel && separatePanelPriceRange ? separatePanelPriceRange : priceRange;
    // Begin drawing the line
    ctx.beginPath();
    // Calculate the width of each candle
    const candleWidth = dimensions.width / (visibleRange.end - visibleRange.start);
    // Move to the first point
    let firstValidIdx = -1;
    for(let i = startIdx; i <= endIdx; i++){
        if (indicator.data[i] !== undefined && !isNaN(indicator.data[i])) {
            firstValidIdx = i;
            break;
        }
    }
    if (firstValidIdx === -1) return; // No valid data points
    // Calculate the x position of the first point
    const firstX = (firstValidIdx - visibleRange.start) * candleWidth;
    // Calculate the y position of the first point
    const firstY = useTop + useHeight - (indicator.data[firstValidIdx] - usePriceRange.min) / (usePriceRange.max - usePriceRange.min) * useHeight;
    ctx.moveTo(firstX, firstY);
    // Draw lines to each subsequent point
    for(let i = firstValidIdx + 1; i <= endIdx; i++){
        if (indicator.data[i] === undefined || isNaN(indicator.data[i])) continue;
        // Calculate the x position of the current point
        const x = (i - visibleRange.start) * candleWidth;
        // Calculate the y position of the current point
        const y = useTop + useHeight - (indicator.data[i] - usePriceRange.min) / (usePriceRange.max - usePriceRange.min) * useHeight;
        ctx.lineTo(x, y);
    }
    // Stroke the path
    ctx.stroke();
    // Reset line dash
    ctx.setLineDash([]);
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/renderer.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__,
    "renderToOffscreenCanvas",
    ()=>renderToOffscreenCanvas
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$render$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/performance/render-manager.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$memory$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/performance/memory-manager.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$data$2d$cache$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/performance/data-cache.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$virtual$2d$renderer$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/performance/virtual-renderer.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$main$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/main.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$volume$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/volume.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$overlay$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/overlay.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/expiry-marker.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/time-sync.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$indicator$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/indicator.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$position$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/position-marker.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$price$2d$axis$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/price-axis.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$grid$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/grid.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
// Update the adapter function to create objects with the correct property names
// Replace the existing adaptOrdersToPositionMarkers function with:
function adaptOrdersToPositionMarkers(orders) {
    const currentTimeMs = Date.now();
    const currentTimeSec = currentTimeMs / 1000;
    return orders.filter((order)=>{
        // Filter out invalid orders
        if (!order || !order.entryPrice || order.entryPrice <= 0) return false;
        // Convert expiryTime from milliseconds to seconds for comparison
        const orderExpiryTimeSec = order.expiryTime / 1000;
        const isExpired = orderExpiryTimeSec < currentTimeSec;
        // For PENDING orders, show them until they expire
        if (order.status === "PENDING") {
            return !isExpired;
        }
        // For completed orders, show them briefly after expiry for animation
        if (order.status === "COMPLETED" || order.status === "WIN" || order.status === "LOSS") {
            // Show completed orders for up to 5 seconds after expiry
            return !isExpired || currentTimeSec - orderExpiryTimeSec < 5;
        }
        // Default: don't show unknown status orders
        return false;
    }).map((order)=>({
            id: order.id || `order-${Math.random().toString(36).substring(2, 9)}`,
            entryTime: typeof order.createdAt === "number" ? order.createdAt / 1000 // Convert from ms to seconds
             : Date.now() / 1000,
            entryPrice: order.entryPrice,
            expiryTime: order.expiryTime / 1000,
            type: order.side === "RISE" ? "CALL" : "PUT",
            amount: order.amount || 0,
            status: order.status === "PENDING" ? "ACTIVE" : order.status,
            result: order.status === "WIN" ? "WIN" : order.status === "LOSS" ? "LOSS" : null,
            createdAt: order.createdAt,
            side: order.side
        }));
}
// Update the generateExpiryMarkers function to use the provided expiryMinutes
const generateExpiryMarkers = (expiryMinutes, currentTime)=>{
    const nextExpiryTime = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["calculateNextExpiryTime"])(currentTime, expiryMinutes);
    const nextExpiryTimestamp = Math.floor(nextExpiryTime.getTime() / 1000);
    const newMarker = {
        timestamp: nextExpiryTimestamp,
        label: "",
        color: "#ffcc00"
    };
    return [
        newMarker
    ];
};
function renderToOffscreenCanvas({ offscreenCanvas, dimensions, renderQuality, theme, visibleRange, candleData, indicators, chartWidth, chartHeight, priceChartHeight, volumeHeight, chartTop, volumeTop, showGrid, isLoadingOlderData, showVolume, priceScaleWidth, timeScaleHeight, chartType, showVolumeProfile, isDragging, drawingTools, priceToY, yToPrice, priceAlerts, mousePosition, hoverEffect, orders, expiryMinutes, expiryMarkers, panelHeights, collapsedPanels }) {
    if (!offscreenCanvas) return null;
    // Set canvas dimensions with proper scaling
    const pixelRatio = window.devicePixelRatio || 1;
    offscreenCanvas.width = dimensions.width * pixelRatio;
    offscreenCanvas.height = dimensions.height * pixelRatio;
    const ctx = offscreenCanvas.getContext("2d", {
        alpha: false
    });
    if (!ctx) return null;
    // Scale the context to account for the device pixel ratio
    ctx.scale(pixelRatio, pixelRatio);
    // Enable crisp edges for better grid and line rendering
    ctx.imageSmoothingEnabled = false;
    // Translate by 0.5px to ensure crisp lines (only in dark mode to avoid artifacts in light mode)
    if (theme === "dark") {
        ctx.translate(0.5, 0.5);
    }
    // Clear canvas with background color (use slight padding in light mode to avoid edge artifacts)
    ctx.fillStyle = theme === "dark" ? "#000000" : "#ffffff";
    if (theme === "dark") {
        ctx.fillRect(0, 0, dimensions.width, dimensions.height);
    } else {
        // In light mode, clear a slightly smaller area to avoid edge artifacts
        ctx.fillRect(1, 1, dimensions.width - 2, dimensions.height - 2);
        // Fill the edges with white to ensure no artifacts
        ctx.fillRect(0, 0, dimensions.width, 1); // Top edge
        ctx.fillRect(0, 0, 1, dimensions.height); // Left edge
        ctx.fillRect(0, dimensions.height - 1, dimensions.width, 1); // Bottom edge
        ctx.fillRect(dimensions.width - 1, 0, 1, dimensions.height); // Right edge
    }
    // Update global candle data reference for time-based calculations
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["setGlobalCandleData"])(candleData);
    // Calculate space needed for separate indicator panels
    const visibleIndicators = indicators ? indicators.filter((i)=>i && i.visible) : [];
    const separatePanelIndicators = visibleIndicators.filter((i)=>i && i.separatePanel);
    // Calculate total height of indicator panels including headers
    let indicatorPanelsHeight = 0;
    separatePanelIndicators.forEach((indicator)=>{
        if (!indicator || !indicator.id) return;
        // Get panel height from state or use default
        const panelHeight = indicator.id && panelHeights ? panelHeights[indicator.id] || 100 : 100;
        const isCollapsed = indicator.id && collapsedPanels ? collapsedPanels[indicator.id] || false : false;
        // Add header height (24px) to panel height
        indicatorPanelsHeight += isCollapsed ? 30 : panelHeight + 24;
    });
    // Adjust chart dimensions to make room for indicator panels
    const adjustedChartHeight = chartHeight - indicatorPanelsHeight;
    // Calculate price chart height and volume height based on adjusted chart height
    let adjustedPriceChartHeight, adjustedVolumeHeight, adjustedVolumeTop;
    if (showVolume) {
        // If volume is shown, allocate 80% to price chart and 20% to volume
        adjustedPriceChartHeight = adjustedChartHeight * 0.8;
        adjustedVolumeHeight = adjustedChartHeight * 0.2;
        adjustedVolumeTop = chartTop + adjustedPriceChartHeight;
    } else {
        // If volume is hidden, allocate 100% to price chart
        adjustedPriceChartHeight = adjustedChartHeight;
        adjustedVolumeHeight = 0;
        adjustedVolumeTop = chartTop + adjustedPriceChartHeight;
    }
    // Get current time for expiry calculations
    const currentTime = new Date();
    // Generate expiry markers if needed
    let markersToUse = expiryMarkers;
    if ((!markersToUse || markersToUse.length === 0) && expiryMinutes && expiryMinutes > 0) {
        markersToUse = generateExpiryMarkers(expiryMinutes, currentTime);
    }
    // Calculate indicator panel positions
    const currentPanelTop = chartTop + adjustedPriceChartHeight + adjustedVolumeHeight;
    // 1) Render main chart
    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$main$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["ChartMainRenderer"].render({
        ctx,
        candleData,
        visibleRange,
        chartWidth,
        priceChartHeight: adjustedPriceChartHeight,
        chartTop,
        chartHeight: adjustedChartHeight,
        showGrid: false,
        theme: theme === "dark" ? "dark" : "light",
        chartType,
        isDragging,
        priceScaleWidth,
        timeScaleHeight,
        volumeHeight: adjustedVolumeHeight,
        volumeTop: adjustedVolumeTop,
        expiryMarkers: [],
        expiryMinutes: expiryMinutes || 5,
        currentTime: currentTime.getTime()
    });
    // 1.5) Render grid separately (this is a key change!)
    if (showGrid) {
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$grid$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderGrid"])(ctx, chartWidth, adjustedPriceChartHeight, adjustedVolumeHeight, chartTop, adjustedVolumeTop, theme === "dark", theme === "dark" ? "rgba(255, 255, 255, 0.07)" : "rgba(0, 0, 0, 0.07)", candleData, visibleRange);
    }
    // 2) Render volume if enabled
    if (showVolume) {
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$volume$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartVolumeRenderer"].render({
            ctx,
            candleData,
            visibleRange,
            chartWidth,
            volumeHeight: adjustedVolumeHeight,
            volumeTop: adjustedVolumeTop,
            theme,
            isDragging
        });
    }
    // 3) Render overlays (crosshair, price line, etc.) - BUT NOT ORDERS OR EXPIRY MARKERS
    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$overlay$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartOverlayRenderer"].render({
        ctx,
        candleData,
        mousePosition,
        hoverEffect,
        orders: [],
        chartWidth,
        priceChartHeight: adjustedPriceChartHeight,
        chartTop,
        theme: theme === "dark" ? "dark" : "light",
        isDragging,
        priceScaleWidth,
        volumeHeight: adjustedVolumeHeight,
        visibleRange,
        priceRange: __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"]
    });
    // 4) Render indicators AFTER overlays so they're not cleared
    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$indicator$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartIndicatorRenderer"].render({
        ctx,
        candleData,
        indicators: indicators || [],
        visibleRange: visibleRange || {
            start: 0,
            end: candleData.length
        },
        chartWidth,
        priceChartHeight: adjustedPriceChartHeight,
        chartTop,
        chartHeight: adjustedChartHeight,
        theme,
        isDragging,
        renderQuality,
        showVolumeProfile,
        priceAlerts: priceAlerts || [],
        volumeHeight: adjustedVolumeHeight,
        volumeTop: adjustedVolumeTop,
        priceScaleWidth,
        panelTop: currentPanelTop,
        panelHeights,
        collapsedPanels
    });
    // 5) Render expiry markers separately
    if (markersToUse && markersToUse.length > 0) {
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderExpiryMarkers"])(ctx, markersToUse, candleData, chartWidth, adjustedPriceChartHeight, chartTop, visibleRange, currentTime.getTime(), true // Pass showExpiry parameter explicitly
        );
    }
    // 6) Render position markers if available - THIS IS THE ONLY PLACE WE RENDER ORDERS
    if (orders && orders.length > 0) {
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$position$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderPositionMarkers"])(ctx, adaptOrdersToPositionMarkers(orders), candleData, chartWidth, adjustedPriceChartHeight, chartTop, visibleRange || {
            start: 0,
            end: candleData.length
        }, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"], Date.now());
    }
    // 7) Render price axis AFTER everything else to ensure it covers grid lines
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$price$2d$axis$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderPriceAxis"])(ctx, chartWidth, adjustedPriceChartHeight, adjustedVolumeHeight, chartTop, adjustedVolumeTop, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"], {
        min: 0,
        max: 1000000
    }, priceScaleWidth, timeScaleHeight, theme === "dark", candleData);
    // 8) Make sure the footer is rendered with the correct dimensions
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderFooter"])({
        ctx,
        chartWidth,
        chartHeight: dimensions.height - timeScaleHeight,
        timeScaleHeight,
        priceScaleWidth,
        theme: theme === "dark" ? "dark" : "light",
        data: candleData,
        visibleRange: visibleRange || {
            start: 0,
            end: candleData.length
        },
        isLoadingOlderData
    });
    // Before returning, reset the translation
    ctx.translate(-0.5, -0.5);
    return offscreenCanvas;
}
const ChartRenderer = ()=>{
    const canvasRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    // Get performance managers (singletons)
    const renderManager = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$render$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].getInstance();
    const memoryManager = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$memory$2d$manager$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].getInstance();
    const dataCache = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$data$2d$cache$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].getInstance();
    const virtualRenderer = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$virtual$2d$renderer$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].getInstance();
    // Get the chart context
    const context = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChart"])();
    // Extract known properties
    const { candleData, chartType, visibleRange, mousePosition, priceAlerts, indicators, showVolumeProfile, theme, showGrid, showVolume, setShowIndicatorPanel, setActiveIndicatorId, toggleIndicator, panelHeights, setPanelHeights, collapsedPanels, setCollapsedPanels, expiryIntervalMinutes, isDragging, orders, isDraggingPanel, setIsDraggingPanel, timeFrame } = context;
    // Use type assertion for properties not in the type definition
    const hoverEffect = context.hoverEffect;
    // Add local state for expiry markers - only update when needed
    const [expiryMarkers, setExpiryMarkers] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])([]);
    const lastUpdateRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Add animation frame request ID for cleanup
    const animationFrameRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    // Add throttling for expiry marker updates
    const lastExpiryUpdateRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Add a ref to hold the current expiry markers
    const expiryMarkersRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])([]);
    // Initialize expiry markers immediately
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (expiryIntervalMinutes > 0) {
            const currentTime = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getChartSynchronizedTime"])();
            const nextExpiryTime = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["calculateNextExpiryTime"])(currentTime, expiryIntervalMinutes);
            const nextExpiryTimestamp = Math.floor(nextExpiryTime.getTime() / 1000);
            const initialMarker = {
                timestamp: nextExpiryTimestamp,
                label: `${nextExpiryTime.toLocaleTimeString([], {
                    hour: "2-digit",
                    minute: "2-digit"
                })}`,
                color: "#ffcc00"
            };
            expiryMarkersRef.current = [
                initialMarker
            ];
            setExpiryMarkers([
                initialMarker
            ]);
        }
    }, [
        expiryIntervalMinutes
    ]);
    // Add a ref to store the last render timestamp to limit frame rate
    const lastRenderTimeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Add a ref to store the last grid render timestamp to prevent grid recalculation
    const lastGridRenderTimeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Get chart dimensions with default values to prevent undefined errors
    const chartDimensions = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChart"])().dimensions || {
        width: 800,
        height: 600
    };
    const priceScaleWidth = 60;
    const timeScaleHeight = 30;
    // Calculate total canvas height including indicator panels
    const calculateTotalHeight = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(()=>{
        const height = chartDimensions?.height || 600;
        const separatePanelIndicators = indicators ? indicators.filter((ind)=>ind && ind.separatePanel && ind.visible) : [];
        // Calculate total height of all indicator panels including their headers
        let additionalHeight = 0;
        separatePanelIndicators.forEach((indicator)=>{
            if (!indicator || !indicator.id) return;
            // Get panel height from state or use default
            const isCollapsed = collapsedPanels?.[indicator.id] || false;
            const paneHeight = panelHeights?.[indicator.id] || 100;
            // Use collapsed height (just header) or full height
            additionalHeight += isCollapsed ? 30 : paneHeight + 24; // 24px for header
        });
        return height + additionalHeight;
    }, [
        chartDimensions?.height,
        indicators,
        collapsedPanels,
        panelHeights
    ]);
    // Memoize the expiry markers to prevent unnecessary re-renders
    const memoizedExpiryMarkers = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>{
        // Use cache to avoid recalculating expiry markers frequently
        const cacheKey = `expiry_markers_${expiryIntervalMinutes}`;
        const cached = dataCache.get(cacheKey);
        if (cached) {
            return cached;
        }
        // Only update markers once per second to reduce performance impact
        const now = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getChartSynchronizedTime"])();
        const currentTime = now.getTime();
        // Skip updates if less than 1 second has passed
        if (currentTime - lastUpdateRef.current < 1000) {
            return expiryMarkers;
        }
        lastUpdateRef.current = currentTime;
        // Calculate the next expiry interval
        const nextExpiryTime = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["calculateNextExpiryTime"])(now, expiryIntervalMinutes || 5);
        const nextExpiryTimestamp = Math.floor(nextExpiryTime.getTime() / 1000);
        // Create the expiry marker
        const newMarker = {
            timestamp: nextExpiryTimestamp,
            label: `${nextExpiryTime.toLocaleTimeString([], {
                hour: "2-digit",
                minute: "2-digit"
            })}`,
            color: "#ffcc00"
        };
        const markers = [
            newMarker
        ];
        // Cache for 1 second
        dataCache.set(cacheKey, markers);
        return markers;
    }, [
        expiryIntervalMinutes,
        lastUpdateRef.current,
        expiryMarkers,
        dataCache
    ]);
    // Update expiry markers - use chart synchronized time with throttling
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!candleData || candleData.length === 0) return;
        const updateExpiryMarkers = ()=>{
            const now = Date.now();
            // Only update every 1000ms to reduce CPU usage
            if (now - lastExpiryUpdateRef.current < 1000) {
                return;
            }
            lastExpiryUpdateRef.current = now;
            // Get the current time
            const currentTime = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$time$2d$sync$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getChartSynchronizedTime"])();
            // Calculate the next expiry interval using the current expiryIntervalMinutes
            const nextExpiryTime = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["calculateNextExpiryTime"])(currentTime, expiryIntervalMinutes || 5);
            const nextExpiryTimestamp = Math.floor(nextExpiryTime.getTime() / 1000);
            // Create the expiry marker
            const newMarker = {
                timestamp: nextExpiryTimestamp,
                label: `${nextExpiryTime.toLocaleTimeString([], {
                    hour: "2-digit",
                    minute: "2-digit"
                })}`,
                color: "#ffcc00"
            };
            // Update the ref instead of state to prevent re-renders
            expiryMarkersRef.current = [
                newMarker
            ];
            // Only update state if needed for other components
            // but not for rendering
            setExpiryMarkers([
                newMarker
            ]);
        };
        // Initial update
        updateExpiryMarkers();
        // Set up interval with requestAnimationFrame instead of setInterval for better performance
        const tick = ()=>{
            updateExpiryMarkers();
            animationFrameRef.current = requestAnimationFrame(tick);
        };
        animationFrameRef.current = requestAnimationFrame(tick);
        return ()=>{
            if (animationFrameRef.current !== null) {
                cancelAnimationFrame(animationFrameRef.current);
            }
        };
    }, [
        candleData,
        expiryIntervalMinutes
    ]);
    // Add resize event handling for performance optimized rendering
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleDimensionChange = ()=>{
            // Use the specialized resize render method
            renderManager.forceRenderForResize(()=>{
                // Clear cache to ensure fresh render
                dataCache.clear();
                // Trigger re-render by updating canvas state
                const canvas = canvasRef.current;
                if (canvas) {
                    // Force canvas to re-evaluate its dimensions
                    const rect = canvas.getBoundingClientRect();
                    canvas.width = rect.width * (window.devicePixelRatio || 1);
                    canvas.height = rect.height * (window.devicePixelRatio || 1);
                    // Force immediate redraw
                    setTimeout(()=>{
                        canvas.dispatchEvent(new Event("resize"));
                    }, 0);
                }
            });
        };
        const handleResizeRequest = ()=>{
            // Handle resize requests from resize handles
            renderManager.forceRenderForResize(()=>{
                // Clear render cache
                dataCache.clear();
                // Force canvas dimension recalculation
                const canvas = canvasRef.current;
                if (canvas) {
                    const rect = canvas.getBoundingClientRect();
                    canvas.width = rect.width * (window.devicePixelRatio || 1);
                    canvas.height = rect.height * (window.devicePixelRatio || 1);
                }
            });
        };
        window.addEventListener("chart-dimensions-changed", handleDimensionChange);
        window.addEventListener("chart-resize-requested", handleResizeRequest);
        return ()=>{
            window.removeEventListener("chart-dimensions-changed", handleDimensionChange);
            window.removeEventListener("chart-resize-requested", handleResizeRequest);
        };
    }, [
        renderManager,
        dataCache
    ]);
    // UNIFIED RENDERING APPROACH - Single useEffect for all rendering with optimizations
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const canvas = canvasRef.current;
        if (!canvas || !candleData || candleData.length === 0) return;
        const ctx = canvas.getContext("2d", {
            alpha: false
        });
        if (!ctx) return;
        // Set up sizes with proper scaling
        const pixelRatio = window.devicePixelRatio || 1;
        const width = chartDimensions?.width || 800;
        const totalHeight = calculateTotalHeight();
        // Only resize canvas when dimensions change to avoid performance hit
        if (canvas.width !== width * pixelRatio || canvas.height !== totalHeight * pixelRatio) {
            canvas.width = width * pixelRatio;
            canvas.height = totalHeight * pixelRatio;
            canvas.style.width = `${width}px`;
            canvas.style.height = `${totalHeight}px`;
        }
        // Create a render function that can be called by requestAnimationFrame
        const renderFrame = ()=>{
            if (!canvasRef.current || !chartDimensions) return;
            // Calculate virtual viewport and visible candles only
            const virtualChartWidth = chartDimensions.width - priceScaleWidth;
            const virtualData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$virtual$2d$renderer$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getVirtualCandles"])(candleData, visibleRange, virtualChartWidth);
            // Determine level of detail based on zoom
            const levelOfDetail = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$performance$2f$virtual$2d$renderer$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["calculateLevelOfDetail"])(visibleRange, virtualChartWidth);
            // Skip rendering if no visible candles
            if (virtualData.candles.length === 0 && !isDragging) {
                animationFrameRef.current = requestAnimationFrame(renderFrame);
                return;
            }
            // Update memory manager with virtual rendering stats
            memoryManager.updateVirtualRenderingMetrics(virtualData.candles.length, candleData.length);
            // Use optimized render manager with virtual data
            const renderData = {
                candleData: virtualData.candles,
                visibleRange,
                mousePosition,
                chartType,
                indicators,
                theme,
                isDragging,
                virtualHash: virtualData.hash,
                levelOfDetail
            };
            // Check if render is needed with high priority for dragging
            const shouldRender = renderManager.shouldRender(renderData, {
                forceRender: isDragging,
                highPriority: isDragging
            });
            if (!shouldRender && !isDragging) {
                // Schedule next frame
                animationFrameRef.current = requestAnimationFrame(renderFrame);
                return;
            }
            ctx.save();
            ctx.scale(pixelRatio, pixelRatio);
            // 1) Clear & fill background - ONLY ONCE (avoid edge artifacts in light mode)
            ctx.fillStyle = theme === "dark" ? "#000000" : "#ffffff";
            if (theme === "dark") {
                ctx.fillRect(0, 0, width, totalHeight);
            } else {
                // In light mode, clear a slightly smaller area to avoid edge artifacts
                ctx.fillRect(1, 1, width - 2, totalHeight - 2);
                // Fill the edges with white to ensure no artifacts
                ctx.fillRect(0, 0, width, 1); // Top edge
                ctx.fillRect(0, 0, 1, totalHeight); // Left edge
                ctx.fillRect(0, totalHeight - 1, width, 1); // Bottom edge
                ctx.fillRect(width - 1, 0, 1, totalHeight); // Right edge
            }
            // Update global candle data for indicator rendering
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["setGlobalCandleData"])(candleData);
            // Calculate dimensions for sub-regions
            const chartWidth = width - priceScaleWidth;
            const baseChartHeight = chartDimensions?.height || 600;
            const chartHeight = baseChartHeight - timeScaleHeight;
            const chartTop = 0;
            // Calculate space needed for separate indicator panels
            const visibleIndicators = indicators ? indicators.filter((i)=>i && i.visible) : [];
            const separatePanelIndicators = visibleIndicators.filter((i)=>i && i.separatePanel);
            // Calculate total height of indicator panels including headers
            let indicatorPanelsHeight = 0;
            separatePanelIndicators.forEach((indicator)=>{
                if (!indicator || !indicator.id) return;
                // Get panel height from state or use default
                const panelHeight = indicator.id && panelHeights ? panelHeights[indicator.id] || 100 : 100;
                const isCollapsed = collapsedPanels ? collapsedPanels[indicator.id] || false : false;
                // Add header height (24px) to panel height
                indicatorPanelsHeight += isCollapsed ? 30 : panelHeight + 24;
            });
            // Adjust chart dimensions to make room for indicator panels
            const adjustedChartHeight = chartHeight - indicatorPanelsHeight;
            // Calculate price chart height and volume height based on adjusted chart height
            let priceChartHeight, volumeHeight, volumeTop;
            if (showVolume) {
                // If volume is shown, allocate 80% to price chart and 20% to volume
                priceChartHeight = adjustedChartHeight * 0.8;
                volumeHeight = adjustedChartHeight * 0.2;
                volumeTop = chartTop + priceChartHeight;
            } else {
                // If volume is hidden, allocate 100% to price chart
                priceChartHeight = adjustedChartHeight;
                volumeHeight = 0;
                volumeTop = chartTop + priceChartHeight;
            }
            // Calculate indicator panel positions
            const panelTop = chartTop + priceChartHeight + volumeHeight;
            // Enable crisp edges for better grid and line rendering
            ctx.imageSmoothingEnabled = false;
            // For light mode, don't translate to avoid black lines at edges
            // For dark mode, use small translate for crisp lines
            if (theme === "dark") {
                ctx.translate(0.5, 0.5);
            }
            // 2) Render main chart with virtual data
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$main$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["ChartMainRenderer"].render({
                ctx,
                candleData: virtualData.candles,
                visibleRange: visibleRange || {
                    start: 0,
                    end: candleData.length
                },
                chartWidth,
                priceChartHeight,
                chartTop,
                chartHeight: adjustedChartHeight,
                showGrid: false,
                theme: theme === "dark" ? "dark" : "light",
                chartType,
                isDragging,
                priceScaleWidth,
                timeScaleHeight,
                volumeHeight,
                volumeTop,
                expiryMarkers: [],
                expiryMinutes: expiryIntervalMinutes || 5,
                currentTime: Date.now(),
                timeFrame: timeFrame,
                levelOfDetail,
                virtualViewport: virtualData.viewport
            });
            // 2.5) Render grid separately with candleData and visibleRange
            // CRITICAL FIX: Only recalculate grid every 5 seconds or when dragging/zooming
            const now = performance.now();
            const shouldUpdateGrid = isDragging || now - lastGridRenderTimeRef.current > 5000 || !window.chartGridPositions;
            if (showGrid) {
                if (shouldUpdateGrid) {
                    lastGridRenderTimeRef.current = now;
                    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$grid$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderGrid"])(ctx, chartWidth, priceChartHeight, volumeHeight, chartTop, volumeTop, theme === "dark", theme === "dark" ? "rgba(255, 255, 255, 0.07)" : "rgba(0, 0, 0, 0.07)", candleData, visibleRange || {
                        start: 0,
                        end: candleData.length
                    });
                } else {
                    // Re-use the existing grid positions but redraw them
                    // This prevents the grid from shifting every second
                    ctx.beginPath();
                    ctx.strokeStyle = theme === "dark" ? "rgba(255, 255, 255, 0.07)" : "rgba(0, 0, 0, 0.07)";
                    ctx.lineWidth = 1;
                    // Draw horizontal grid lines
                    const priceGridCount = Math.min(8, Math.floor(priceChartHeight / 40));
                    for(let i = 0; i <= priceGridCount; i++){
                        const y = Math.floor(chartTop + i / priceGridCount * priceChartHeight) + 0.5;
                        ctx.moveTo(0, y);
                        ctx.lineTo(chartWidth, y);
                    }
                    // Draw vertical grid lines using cached positions
                    const gridPositions = window.chartGridPositions || [];
                    for (const pos of gridPositions){
                        if (pos.x >= -50 && pos.x <= chartWidth + 50) {
                            ctx.moveTo(pos.x, chartTop);
                            ctx.lineTo(pos.x, chartTop + priceChartHeight + volumeHeight);
                        }
                    }
                    // Draw all grid lines at once
                    ctx.stroke();
                }
            }
            // 3) Render volume if enabled with virtual data
            if (showVolume) {
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$volume$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartVolumeRenderer"].render({
                    ctx,
                    candleData: virtualData.candles,
                    visibleRange: visibleRange || {
                        start: 0,
                        end: candleData.length
                    },
                    chartWidth,
                    volumeHeight,
                    volumeTop,
                    theme,
                    isDragging,
                    levelOfDetail,
                    virtualViewport: virtualData.viewport
                });
            }
            // 4) Render overlays (crosshair, price line, etc.) - BUT NOT ORDERS OR EXPIRY MARKERS
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$overlay$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartOverlayRenderer"].render({
                ctx,
                candleData,
                mousePosition,
                hoverEffect,
                orders: [],
                chartWidth,
                priceChartHeight,
                chartTop,
                theme: theme === "dark" ? "dark" : "light",
                isDragging,
                priceScaleWidth,
                volumeHeight,
                visibleRange: visibleRange || {
                    start: 0,
                    end: candleData.length
                },
                priceRange: __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"]
            });
            // 5) Render indicators AFTER overlays so they're not cleared with virtual data
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$indicator$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartIndicatorRenderer"].render({
                ctx,
                candleData: virtualData.candles,
                indicators: indicators || [],
                visibleRange: visibleRange || {
                    start: 0,
                    end: candleData.length
                },
                chartWidth,
                priceChartHeight,
                chartTop,
                chartHeight: adjustedChartHeight,
                theme,
                isDragging,
                renderQuality: levelOfDetail === "high" ? "high" : levelOfDetail === "medium" ? "medium" : "low",
                showVolumeProfile,
                priceAlerts: priceAlerts || [],
                volumeHeight,
                volumeTop,
                priceScaleWidth,
                panelTop,
                setShowIndicatorPanel,
                setActiveIndicatorId,
                toggleIndicator,
                panelHeights,
                setPanelHeights,
                collapsedPanels,
                setCollapsedPanels,
                isDraggingPanel,
                setIsDraggingPanel,
                levelOfDetail,
                virtualViewport: virtualData.viewport
            });
            // 6) Render expiry markers separately - use virtual data for better performance
            const currentExpiryMarkers = expiryMarkersRef.current;
            if (currentExpiryMarkers && currentExpiryMarkers.length > 0 && expiryIntervalMinutes > 0) {
                ctx.save();
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$expiry$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderExpiryMarkers"])(ctx, currentExpiryMarkers, candleData, chartWidth, priceChartHeight, chartTop, visibleRange || {
                    start: 0,
                    end: candleData.length
                }, Date.now(), true // Pass showExpiry parameter explicitly
                );
                ctx.restore();
            }
            // 7) Render position markers if available - use virtual data for better performance
            if (orders && orders.length > 0) {
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$position$2d$marker$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderPositionMarkers"])(ctx, adaptOrdersToPositionMarkers(orders), candleData, chartWidth, priceChartHeight, chartTop, visibleRange || {
                    start: 0,
                    end: candleData.length
                }, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"], Date.now());
            }
            // 8) Render price axis AFTER everything else to ensure it covers grid lines
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$price$2d$axis$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderPriceAxis"])(ctx, chartWidth, priceChartHeight, volumeHeight, chartTop, volumeTop, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["currentPriceRange"], {
                min: 0,
                max: 1000000
            }, priceScaleWidth, timeScaleHeight, theme === "dark", candleData);
            // 9) Render footer with time axis
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderFooter"])({
                ctx,
                chartWidth,
                chartHeight: baseChartHeight - timeScaleHeight,
                timeScaleHeight,
                priceScaleWidth,
                theme: theme === "dark" ? "dark" : "light",
                data: candleData,
                visibleRange: visibleRange || {
                    start: 0,
                    end: candleData.length
                },
                isLoadingOlderData: false
            });
            // Reset transformations - only if we applied translate
            if (theme === "dark") {
                ctx.translate(-0.5, -0.5);
            }
            ctx.restore();
            // Schedule next frame
            animationFrameRef.current = requestAnimationFrame(renderFrame);
        };
        // Start the render loop
        animationFrameRef.current = requestAnimationFrame(renderFrame);
        // Cleanup function
        return ()=>{
            if (animationFrameRef.current !== null) {
                cancelAnimationFrame(animationFrameRef.current);
            }
            // Cleanup performance managers
            renderManager.cleanup();
            memoryManager.cleanup();
            virtualRenderer.cleanup();
        };
    }, [
        // Include dependencies that actually affect rendering and remove ones that cause unnecessary re-renders
        candleData,
        chartType,
        visibleRange,
        chartDimensions,
        mousePosition,
        priceAlerts,
        indicators,
        showVolumeProfile,
        theme,
        showGrid,
        showVolume,
        panelHeights,
        collapsedPanels,
        isDraggingPanel,
        hoverEffect,
        isDragging,
        orders,
        // REMOVED: expiryMarkers - this changes every second causing constant re-renders
        expiryIntervalMinutes,
        calculateTotalHeight,
        timeFrame
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("canvas", {
        ref: canvasRef,
        width: chartDimensions?.width || 800,
        height: calculateTotalHeight(),
        style: {
            backgroundColor: theme === "dark" ? "#000000" : "#ffffff",
            border: "none",
            display: "block"
        }
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/renderer.tsx",
        lineNumber: 1105,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const __TURBOPACK__default__export__ = ChartRenderer;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/animation.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "useChartAnimation",
    ()=>useChartAnimation
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$renderer$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/renderer.tsx [app-ssr] (ecmascript)");
"use client";
;
;
function useChartAnimation({ canvasRef, offscreenCanvasRef, animationFrameIdRef, needsRenderRef, lastRenderTimeRef, dimensions, renderQuality, theme, visibleRange, candleData, indicators, showGrid, isLoadingOlderData, showVolume, priceScaleWidth, timeScaleHeight, chartType, showVolumeProfile, isDragging, drawingTools, priceToY, yToPrice, priceAlerts, mousePosition, hoverEffect, orders, dataReady, isMarketSwitching, expiryIntervalMinutes, expiryMarkers }) {
    // Add a check for dataReady and isMarketSwitching in the animation loop
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!canvasRef.current || !offscreenCanvasRef.current || !dataReady || isMarketSwitching) {
            // Clean up any existing animation frame when conditions aren't met
            if (animationFrameIdRef.current) {
                cancelAnimationFrame(animationFrameIdRef.current);
                animationFrameIdRef.current = null;
            }
            return;
        }
        // Early exit if data is invalid - don't even set up the animation loop
        if (candleData.length === 0 || dimensions.width <= 0 || dimensions.height <= 0) {
            // Throttle warning messages to prevent spam (max once per 5 seconds)
            const now = Date.now();
            const lastWarningKey = `chart-warning-${dimensions.width}-${dimensions.height}-${candleData.length}`;
            if (!window.__chartWarnings) {
                window.__chartWarnings = {};
            }
            if (!window.__chartWarnings[lastWarningKey] || now - window.__chartWarnings[lastWarningKey] > 5000) {
                console.warn("Skipping chart render due to invalid data or dimensions", {
                    candleDataLength: candleData.length,
                    dimensions: dimensions,
                    dataReady,
                    isMarketSwitching
                });
                window.__chartWarnings[lastWarningKey] = now;
            }
            // Clean up any existing animation frame
            if (animationFrameIdRef.current) {
                cancelAnimationFrame(animationFrameIdRef.current);
                animationFrameIdRef.current = null;
            }
            return;
        }
        // Track if component is mounted to prevent memory leaks
        let isMounted = true;
        // Fix: Convert renderQuality to string for comparison or use a type guard
        const FRAME_RATE = renderQuality === "high" || renderQuality === 1 ? 60 : 30;
        const FRAME_INTERVAL = 1000 / FRAME_RATE;
        const renderChartCanvas = ()=>{
            const canvas = canvasRef.current;
            const offscreen = offscreenCanvasRef.current;
            if (!canvas || !offscreen) return;
            // Additional safety check - if data becomes invalid during animation, exit early
            if (candleData.length === 0 || dimensions.width <= 0 || dimensions.height <= 0) {
                return;
            }
            // Get current dimensions to avoid stale closure
            const currentDimensions = {
                width: canvas.offsetWidth || dimensions.width,
                height: canvas.offsetHeight || dimensions.height
            };
            // Render to offscreen canvas first
            const offscreenCanvas = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$renderer$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["renderToOffscreenCanvas"])({
                offscreenCanvas: offscreen,
                dimensions: currentDimensions,
                renderQuality,
                theme,
                visibleRange,
                candleData,
                indicators,
                chartWidth: currentDimensions.width - priceScaleWidth,
                chartHeight: currentDimensions.height - timeScaleHeight,
                priceChartHeight: showVolume ? (currentDimensions.height - timeScaleHeight) * 0.8 : currentDimensions.height - timeScaleHeight,
                volumeHeight: showVolume ? (currentDimensions.height - timeScaleHeight) * 0.2 : 0,
                chartTop: 0,
                volumeTop: showVolume ? (currentDimensions.height - timeScaleHeight) * 0.8 : 0,
                showGrid,
                isLoadingOlderData,
                showVolume,
                priceScaleWidth,
                timeScaleHeight,
                chartType,
                showVolumeProfile,
                isDragging,
                drawingTools,
                priceToY,
                yToPrice,
                priceAlerts,
                mousePosition,
                hoverEffect,
                orders,
                expiryMinutes: expiryIntervalMinutes
            });
            if (!offscreenCanvas) return;
            // Check if offscreen canvas has valid dimensions before drawing
            if (offscreenCanvas.width === 0 || offscreenCanvas.height === 0) {
                // Throttle warning messages to prevent spam (max once per 5 seconds)
                const now = Date.now();
                const warningKey = `offscreen-warning-${offscreenCanvas.width}-${offscreenCanvas.height}`;
                if (!window.__chartWarnings) {
                    window.__chartWarnings = {};
                }
                if (!window.__chartWarnings[warningKey] || now - window.__chartWarnings[warningKey] > 5000) {
                    console.warn("Offscreen canvas has invalid dimensions, skipping render", {
                        offscreenDimensions: {
                            width: offscreenCanvas.width,
                            height: offscreenCanvas.height
                        },
                        currentDimensions
                    });
                    window.__chartWarnings[warningKey] = now;
                }
                return;
            }
            // Then copy to visible canvas (double buffering)
            const ctx = canvas.getContext("2d", {
                alpha: false
            });
            if (!ctx) return;
            // Set canvas dimensions with higher resolution for better quality
            const pixelRatio = window.devicePixelRatio || 1;
            canvas.width = currentDimensions.width * pixelRatio;
            canvas.height = currentDimensions.height * pixelRatio;
            canvas.style.width = `${currentDimensions.width}px`;
            canvas.style.height = `${currentDimensions.height}px`;
            // Draw the offscreen canvas to the visible canvas
            ctx.drawImage(offscreenCanvas, 0, 0);
        };
        const animate = (timestamp)=>{
            if (!isMounted) return;
            // Only render if needed or if enough time has passed since last render
            const shouldRender = needsRenderRef.current || timestamp - lastRenderTimeRef.current >= FRAME_INTERVAL;
            if (shouldRender) {
                renderChartCanvas();
                lastRenderTimeRef.current = timestamp;
                needsRenderRef.current = false;
            }
            animationFrameIdRef.current = requestAnimationFrame(animate);
        };
        // Start animation loop
        animationFrameIdRef.current = requestAnimationFrame(animate);
        // Set up event listeners to trigger renders when needed
        const triggerRender = ()=>{
            needsRenderRef.current = true;
        };
        // These events should trigger a re-render
        window.addEventListener("resize", triggerRender);
        return ()=>{
            isMounted = false;
            window.removeEventListener("resize", triggerRender);
            if (animationFrameIdRef.current) {
                cancelAnimationFrame(animationFrameIdRef.current);
                animationFrameIdRef.current = null;
            }
            // Clean up old warning entries to prevent memory leaks
            if (window.__chartWarnings) {
                const now = Date.now();
                Object.keys(window.__chartWarnings).forEach((key)=>{
                    if (now - window.__chartWarnings[key] > 60000) {
                        delete window.__chartWarnings[key];
                    }
                });
            }
        };
    }, [
        // Only include stable dependencies that should trigger animation restart
        canvasRef,
        offscreenCanvasRef,
        dimensions.width,
        dimensions.height,
        renderQuality,
        theme,
        dataReady,
        isMarketSwitching,
        chartType,
        showVolume,
        showGrid,
        showVolumeProfile,
        priceScaleWidth,
        timeScaleHeight,
        expiryIntervalMinutes
    ]);
}
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ChartToolbar",
    ()=>ChartToolbar,
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$no$2d$axes$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart2$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-no-axes-column.js [app-ssr] (ecmascript) <export default as BarChart2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$settings$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Settings$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/settings.js [app-ssr] (ecmascript) <export default as Settings>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/render/components/motion/proxy.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/components/AnimatePresence/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-themes@1.0.0-beta.0_ne_fd389c5db48046672a7f720e88c0bc38/node_modules/next-themes/dist/index.module.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/react-client/index.js [app-ssr] (ecmascript) <locals>");
"use client";
;
;
;
;
;
;
;
;
const ChartToolbar = ({ symbol, onTimeframeClick, onIndicatorsClick, onSettingsClick })=>{
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar");
    const context = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChart"])();
    const timeFrame = context.timeFrame;
    const onTimeFrameChange = context.onTimeFrameChange;
    const indicators = context.indicators || [];
    // Use type assertion to access timeframeDurations
    const timeframeDurations = context.timeframeDurations;
    const [showTimeframeMenu, setShowTimeframeMenu] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const menuRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    // Change the ref type to match the element it's attached to
    const buttonRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const { theme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTheme"])();
    const isDark = theme === "dark";
    // Count active indicators
    const activeIndicatorsCount = indicators.filter((ind)=>ind.visible).length;
    // Format timeframe for display
    const formatTimeframe = (tf)=>{
        if (!tf) return "1m";
        return tf;
    };
    // Available timeframes
    const availableTimeframes = timeframeDurations || [
        {
            value: "1m",
            label: "1m"
        },
        {
            value: "5m",
            label: "5m"
        },
        {
            value: "15m",
            label: "15m"
        },
        {
            value: "30m",
            label: "30m"
        },
        {
            value: "1h",
            label: "1h"
        },
        {
            value: "4h",
            label: "4h"
        },
        {
            value: "1d",
            label: "1d"
        },
        {
            value: "1w",
            label: "1w"
        }
    ];
    const handleTimeframeChange = (newTimeframe)=>{
        // Only log in development mode
        if ("TURBOPACK compile-time truthy", 1) {
            console.log("🕒 Changing timeframe to:", newTimeframe);
        }
        if (onTimeFrameChange) {
            // Call the context's timeframe change handler
            onTimeFrameChange(newTimeframe);
            // Also notify parent component
            if (onTimeframeClick) {
                onTimeframeClick();
            }
            // Ensure we refresh data after timeframe change
            if (context.refreshData) {
                setTimeout(()=>{
                    // Only log in development mode
                    if ("TURBOPACK compile-time truthy", 1) {
                        console.log("🔄 Refreshing data after timeframe change");
                    }
                    context.refreshData();
                }, 100);
            }
        }
        setShowTimeframeMenu(false);
    };
    // Close menu when clicking outside
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleClickOutside = (event)=>{
            if (menuRef.current && buttonRef.current && !menuRef.current.contains(event.target) && !buttonRef.current.contains(event.target)) {
                setShowTimeframeMenu(false);
            }
        };
        document.addEventListener("mousedown", handleClickOutside);
        return ()=>{
            document.removeEventListener("mousedown", handleClickOutside);
        };
    }, []);
    // Theme-aware button classes
    const buttonClasses = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("w-8 h-8 flex items-center justify-center border backdrop-blur-md rounded-md transition-all duration-200 cursor-pointer", isDark ? "border-[#2A2E39]/70 bg-black/60 hover:bg-black/80 hover:border-[#2A2E39] text-zinc-200 hover:text-white" : "border-zinc-300 bg-white/80 hover:bg-zinc-100/90 hover:border-zinc-400 text-zinc-700 hover:text-zinc-900 shadow-sm hover:shadow-md");
    // Theme-aware menu classes
    const menuClasses = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("absolute left-14 top-0 w-[220px] p-3 backdrop-blur-md border shadow-xl rounded-lg z-50 overflow-hidden", isDark ? "bg-black/95 border-zinc-800 text-white" : "bg-white/95 border-zinc-200 text-zinc-800");
    // Theme-aware timeframe grid item classes
    const getTimeframeItemClasses = (isActive)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex items-center justify-center p-1.5 rounded text-xs font-medium transition-all cursor-pointer hover:scale-105", isActive ? "bg-green-600 text-white shadow-md hover:bg-green-500" : isDark ? "bg-zinc-900 text-zinc-300 hover:bg-zinc-800 hover:text-white border border-zinc-800 hover:border-zinc-700" : "bg-zinc-100 text-zinc-700 hover:bg-zinc-200 hover:text-zinc-900 border border-zinc-200 hover:border-zinc-300");
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "absolute left-4 top-1/4 flex flex-col space-y-3 z-10",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "relative",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                            ref: buttonRef,
                            onClick: ()=>{
                                setShowTimeframeMenu(!showTimeframeMenu);
                                if (showTimeframeMenu && onTimeframeClick) {
                                    onTimeframeClick();
                                }
                            },
                            className: buttonClasses,
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: "text-xs font-medium",
                                children: formatTimeframe(timeFrame)
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                lineNumber: 158,
                                columnNumber: 13
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                            lineNumber: 148,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["AnimatePresence"], {
                            children: showTimeframeMenu && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
                                ref: menuRef,
                                initial: {
                                    opacity: 0,
                                    scale: 0.9,
                                    x: -10
                                },
                                animate: {
                                    opacity: 1,
                                    scale: 1,
                                    x: 0
                                },
                                exit: {
                                    opacity: 0,
                                    scale: 0.9,
                                    x: -10
                                },
                                transition: {
                                    duration: 0.2,
                                    type: "spring",
                                    stiffness: 300,
                                    damping: 25
                                },
                                className: menuClasses,
                                style: {
                                    boxShadow: isDark ? "0 10px 25px -5px rgba(0, 0, 0, 0.8), 0 8px 10px -6px rgba(0, 0, 0, 0.6)" : "0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1)"
                                },
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("mb-2 pb-2 border-b", isDark ? "border-zinc-800" : "border-zinc-200"),
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                            className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("text-xs font-medium", isDark ? "text-zinc-400" : "text-zinc-500"),
                                            children: t("select_timeframe")
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                            lineNumber: 190,
                                            columnNumber: 19
                                        }, ("TURBOPACK compile-time value", void 0))
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                        lineNumber: 184,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0)),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "grid grid-cols-3 gap-2",
                                        children: availableTimeframes.map((tf)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
                                                whileHover: {
                                                    scale: 1.05
                                                },
                                                whileTap: {
                                                    scale: 0.95
                                                },
                                                className: getTimeframeItemClasses(timeFrame === tf.value),
                                                onClick: ()=>handleTimeframeChange(tf.value),
                                                children: tf.label
                                            }, tf.value, false, {
                                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                                lineNumber: 201,
                                                columnNumber: 21
                                            }, ("TURBOPACK compile-time value", void 0)))
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                        lineNumber: 199,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0))
                                ]
                            }, void 0, true, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                lineNumber: 166,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                            lineNumber: 164,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                    lineNumber: 147,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "relative",
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: onIndicatorsClick,
                        className: buttonClasses,
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$no$2d$axes$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart2$3e$__["BarChart2"], {
                                size: 18
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                lineNumber: 224,
                                columnNumber: 13
                            }, ("TURBOPACK compile-time value", void 0)),
                            activeIndicatorsCount > 0 && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
                                initial: {
                                    scale: 0
                                },
                                animate: {
                                    scale: 1
                                },
                                className: "absolute -top-1 -right-1 w-5 h-5 rounded-full bg-orange-500 flex items-center justify-center text-white text-xs font-medium shadow-md",
                                children: activeIndicatorsCount
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                                lineNumber: 226,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        ]
                    }, void 0, true, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                        lineNumber: 223,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                    lineNumber: 222,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                    onClick: onSettingsClick,
                    className: buttonClasses,
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$settings$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Settings$3e$__["Settings"], {
                        size: 18
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                        lineNumber: 239,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
                    lineNumber: 238,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx",
            lineNumber: 145,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false);
};
const __TURBOPACK__default__export__ = ChartToolbar;
}),
"[project]/frontend/components/ui/slider.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Slider",
    ()=>Slider
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$slider$40$1$2e$3$2e$_cc1a4482eae062c8748c9d6348ec6105$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slider$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@radix-ui+react-slider@1.3._cc1a4482eae062c8748c9d6348ec6105/node_modules/@radix-ui/react-slider/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
function Slider({ className, defaultValue, value, min = 0, max = 100, ...props }) {
    const _values = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"](()=>Array.isArray(value) ? value : Array.isArray(defaultValue) ? defaultValue : [
            min,
            max
        ], [
        value,
        defaultValue,
        min,
        max
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$slider$40$1$2e$3$2e$_cc1a4482eae062c8748c9d6348ec6105$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slider$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Root"], {
        "data-slot": "slider",
        defaultValue: defaultValue,
        value: value,
        min: min,
        max: max,
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("relative flex w-full touch-none items-center select-none data-disabled:opacity-50 data-[orientation=vertical]:h-full data-[orientation=vertical]:min-h-44 data-[orientation=vertical]:w-auto data-[orientation=vertical]:flex-col", className),
        ...props,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$slider$40$1$2e$3$2e$_cc1a4482eae062c8748c9d6348ec6105$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slider$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Track"], {
                "data-slot": "slider-track",
                className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("bg-muted relative grow overflow-hidden rounded-full data-[orientation=horizontal]:h-1.5 data-[orientation=horizontal]:w-full data-[orientation=vertical]:h-full data-[orientation=vertical]:w-1.5"),
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$slider$40$1$2e$3$2e$_cc1a4482eae062c8748c9d6348ec6105$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slider$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Range"], {
                    "data-slot": "slider-range",
                    className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("bg-primary absolute data-[orientation=horizontal]:h-full data-[orientation=vertical]:w-full")
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/slider.tsx",
                    lineNumber: 45,
                    columnNumber: 9
                }, this)
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/slider.tsx",
                lineNumber: 39,
                columnNumber: 7
            }, this),
            Array.from({
                length: _values.length
            }, (_, index)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$slider$40$1$2e$3$2e$_cc1a4482eae062c8748c9d6348ec6105$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slider$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Thumb"], {
                    "data-slot": "slider-thumb",
                    className: "border-primary bg-background ring-ring/50 block size-4 shrink-0 rounded-full border shadow-2xs transition-[color,box-shadow] hover:ring-4 focus-visible:ring-4 focus-visible:outline-hidden disabled:pointer-events-none disabled:opacity-50"
                }, index, false, {
                    fileName: "[project]/frontend/components/ui/slider.tsx",
                    lineNumber: 53,
                    columnNumber: 9
                }, this))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/ui/slider.tsx",
        lineNumber: 27,
        columnNumber: 5
    }, this);
}
;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "IndicatorPanel",
    ()=>IndicatorPanel,
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trash$2d$2$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Trash2$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/trash-2.js [app-ssr] (ecmascript) <export default as Trash2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/plus.js [app-ssr] (ecmascript) <export default as Plus>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chevron-right.js [app-ssr] (ecmascript) <export default as ChevronRight>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicators/registry.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/render/components/motion/proxy.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/components/AnimatePresence/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$slider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/slider.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-themes@1.0.0-beta.0_ne_fd389c5db48046672a7f720e88c0bc38/node_modules/next-themes/dist/index.module.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/theme/colors.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/react-client/index.js [app-ssr] (ecmascript) <locals>");
"use client";
;
;
;
;
;
;
;
;
;
;
;
;
// Update the IndicatorItem component to use theme colors
const IndicatorItem = ({ indicator, isExpanded, onToggle, onExpand, categoryId, setSelectedCategory, setExpandedIndicator, updateIndicator, forceCalculateAll })=>{
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel");
    const isAdded = indicator.visible;
    const isInAddedCategory = categoryId === "added";
    const { resolvedTheme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTheme"])();
    const isDarkTheme = resolvedTheme === "dark";
    const colors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getChartColors"])(isDarkTheme);
    const textColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTextColors"])(isDarkTheme);
    const borderColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBorderColors"])(isDarkTheme);
    const uiColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUIColors"])(isDarkTheme);
    const backgroundColors = colors.background;
    // Local state for settings
    const [localSettings, setLocalSettings] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])({
        ...indicator.params,
        color: indicator.color
    });
    // Update local settings when indicator changes
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        setLocalSettings({
            ...indicator.params,
            color: indicator.color
        });
    }, [
        indicator
    ]);
    // Handle adding an indicator
    const handleAddIndicator = (e)=>{
        e.stopPropagation();
        // Toggle the indicator visibility
        onToggle();
        // Force calculation of all indicators
        setTimeout(()=>{
            if (typeof forceCalculateAll === "function") {
                forceCalculateAll();
            }
        }, 100);
        // Only switch to "added" category and open settings if explicitly requested
        // This prevents automatic switching when just adding an indicator
        if (categoryId !== "added") {
            setTimeout(()=>{
                setSelectedCategory("added");
                setExpandedIndicator(indicator.id);
            }, 200);
        }
    };
    // Handle slider change
    const handleSliderChange = (value, key)=>{
        setLocalSettings((prev)=>({
                ...prev,
                [key]: value[0]
            }));
    };
    // Handle option change
    const handleOptionChange = (option, key)=>{
        setLocalSettings((prev)=>({
                ...prev,
                [key]: option
            }));
    };
    // Handle color change
    const handleColorChange = (color)=>{
        setLocalSettings((prev)=>({
                ...prev,
                color
            }));
    };
    // Apply settings
    const applySettings = ()=>{
        const updates = {
            color: localSettings.color,
            params: {
                ...indicator.params
            }
        };
        // Update params based on local settings
        Object.keys(localSettings).forEach((key)=>{
            if (key !== "color") {
                updates.params[key] = localSettings[key];
            }
        });
        updateIndicator(indicator.id, updates);
        // Force calculation after updating settings
        setTimeout(()=>{
            if (typeof forceCalculateAll === "function") {
                forceCalculateAll();
            }
        }, 100);
        onExpand(); // Close the expanded panel
    };
    // Get settings fields for this indicator
    const getSettingsFields = ()=>{
        try {
            // Get the indicator definition from the registry
            const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][indicator.type];
            if (indicatorDef && indicatorDef.getSettings) {
                return indicatorDef.getSettings();
            }
            return [];
        } catch (err) {
            console.error(`Error loading settings for indicator: ${indicator.type}`, err);
            return [];
        }
    };
    // Get the indicator icon from the registry
    const getIndicatorIcon = ()=>{
        const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][indicator.type];
        const indicatorCategory = indicatorDef?.defaultSettings?.category || "trend";
        const categoryColor = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorCategories"].find((cat)=>cat.id === indicatorCategory)?.color || "#3b82f6";
        if (indicatorDef && indicatorDef.icon) {
            const Icon = indicatorDef.icon;
            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(Icon, {
                size: 14,
                style: {
                    color: categoryColor
                }
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 186,
                columnNumber: 14
            }, ("TURBOPACK compile-time value", void 0));
        }
        return null;
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("overflow-hidden rounded-md transition-all relative w-full", isExpanded ? "shadow-md" : "border hover:shadow-sm"),
        style: {
            borderColor: isExpanded ? indicator.color || borderColors.active : borderColors.secondary,
            background: isExpanded ? backgroundColors.tertiary : backgroundColors.secondary
        },
        animate: {
            height: isExpanded ? "auto" : "auto"
        },
        transition: {
            duration: 0.2
        },
        layout: true,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex items-center justify-between p-2 cursor-pointer relative",
                onClick: isInAddedCategory ? onExpand : handleAddIndicator,
                style: {
                    color: textColors.primary
                },
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "flex items-center gap-2",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex items-center gap-2",
                            children: [
                                getIndicatorIcon(),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    className: "text-xs",
                                    children: indicator.name
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                    lineNumber: 217,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                            lineNumber: 215,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0))
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                        lineNumber: 214,
                        columnNumber: 9
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "flex items-center gap-2",
                        children: !isInAddedCategory && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                            whileHover: {
                                scale: 1.1
                            },
                            whileTap: {
                                scale: 0.9
                            },
                            className: "w-6 h-6 flex items-center justify-center rounded-full text-white shadow-sm transition-colors",
                            style: {
                                background: uiColors.button.success.background
                            },
                            onClick: (e)=>{
                                e.stopPropagation();
                                handleAddIndicator(e);
                            },
                            title: "Add indicator",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__["Plus"], {
                                size: 14
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 233,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                            lineNumber: 222,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0))
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                        lineNumber: 220,
                        columnNumber: 9
                    }, ("TURBOPACK compile-time value", void 0)),
                    isInAddedCategory && !isExpanded && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "flex items-center gap-2 mr-1",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                            whileHover: {
                                scale: 1.1
                            },
                            whileTap: {
                                scale: 0.9
                            },
                            className: "w-6 h-6 flex items-center justify-center transition-colors",
                            style: {
                                color: textColors.secondary
                            },
                            title: "Remove",
                            onClick: (e)=>{
                                e.stopPropagation();
                                onToggle(); // Remove the indicator
                            },
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trash$2d$2$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Trash2$3e$__["Trash2"], {
                                size: 14
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 252,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                            lineNumber: 241,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0))
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                        lineNumber: 240,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 209,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["AnimatePresence"], {
                children: isExpanded && isInAddedCategory && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
                    initial: {
                        opacity: 0,
                        height: 0
                    },
                    animate: {
                        opacity: 1,
                        height: "auto"
                    },
                    exit: {
                        opacity: 0,
                        height: 0
                    },
                    className: "p-3 pt-1 border-t",
                    style: {
                        borderColor: borderColors.secondary,
                        background: backgroundColors.tertiary
                    },
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "space-y-3",
                        children: [
                            Object.entries(localSettings).map(([key, value])=>{
                                if (key === "color") return null; // Handle color separately
                                // Find the setting field definition
                                const settingField = getSettingsFields().find((field)=>field.name === key);
                                if (!settingField) return null;
                                // Convert string value to number if needed for the slider
                                const numericValue = typeof value === "string" ? Number.parseFloat(value) || 0 : value;
                                return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "space-y-1",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "flex items-center justify-between",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                    className: "text-xs",
                                                    style: {
                                                        color: textColors.secondary
                                                    },
                                                    children: settingField.label || key
                                                }, void 0, false, {
                                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                    lineNumber: 290,
                                                    columnNumber: 23
                                                }, ("TURBOPACK compile-time value", void 0)),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                    className: "text-xs font-medium px-2 py-0.5 rounded",
                                                    style: {
                                                        background: backgroundColors.secondary,
                                                        color: textColors.primary
                                                    },
                                                    children: [
                                                        value,
                                                        settingField.unit || ""
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                    lineNumber: 296,
                                                    columnNumber: 23
                                                }, ("TURBOPACK compile-time value", void 0))
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                            lineNumber: 289,
                                            columnNumber: 21
                                        }, ("TURBOPACK compile-time value", void 0)),
                                        settingField.type === "select" && settingField.options ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "flex flex-wrap gap-1",
                                            children: settingField.options.map((option)=>{
                                                const optionValue = typeof option === "object" ? option.value : option;
                                                const optionLabel = typeof option === "object" ? option.label : option;
                                                return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                                                    whileHover: {
                                                        scale: 1.05
                                                    },
                                                    whileTap: {
                                                        scale: 0.95
                                                    },
                                                    className: "px-2 py-1 text-xs rounded-md transition-all",
                                                    style: {
                                                        background: value === optionValue ? uiColors.button.primary.background : backgroundColors.secondary,
                                                        color: value === optionValue ? uiColors.button.primary.text : textColors.secondary
                                                    },
                                                    onClick: ()=>handleOptionChange(optionValue, key),
                                                    children: optionLabel
                                                }, optionValue, false, {
                                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                    lineNumber: 316,
                                                    columnNumber: 29
                                                }, ("TURBOPACK compile-time value", void 0));
                                            })
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                            lineNumber: 308,
                                            columnNumber: 23
                                        }, ("TURBOPACK compile-time value", void 0)) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$slider$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Slider"], {
                                            value: [
                                                numericValue
                                            ],
                                            min: settingField.min || 0,
                                            max: settingField.max || 100,
                                            step: settingField.step || 1,
                                            className: "w-full",
                                            onValueChange: (value)=>handleSliderChange(value, key)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                            lineNumber: 341,
                                            columnNumber: 23
                                        }, ("TURBOPACK compile-time value", void 0))
                                    ]
                                }, key, true, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                    lineNumber: 288,
                                    columnNumber: 19
                                }, ("TURBOPACK compile-time value", void 0));
                            }),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "space-y-1",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                        className: "text-xs",
                                        style: {
                                            color: textColors.secondary
                                        },
                                        children: t("Color")
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                        lineNumber: 358,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0)),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex flex-wrap gap-2",
                                        children: [
                                            "#3b82f6",
                                            "#f97316",
                                            "#8b5cf6",
                                            "#ec4899",
                                            "#10b981",
                                            "#ef4444",
                                            "#f59e0b",
                                            "#64748b"
                                        ].map((color)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                                                whileHover: {
                                                    scale: 1.1
                                                },
                                                whileTap: {
                                                    scale: 0.9
                                                },
                                                className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("w-6 h-6 rounded-full border transition-all", localSettings.color === color ? "ring-2 ring-offset-1" : ""),
                                                style: {
                                                    backgroundColor: color,
                                                    borderColor: borderColors.secondary,
                                                    // Remove ringColor from style
                                                    boxShadow: localSettings.color === color ? "0 1px 3px rgba(0,0,0,0.2)" : "none"
                                                },
                                                onClick: ()=>handleColorChange(color)
                                            }, color, false, {
                                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                lineNumber: 375,
                                                columnNumber: 21
                                            }, ("TURBOPACK compile-time value", void 0)))
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                        lineNumber: 364,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0))
                                ]
                            }, void 0, true, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 357,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0)),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "pt-2 flex items-center justify-between",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                                        whileHover: {
                                            scale: 1.05
                                        },
                                        whileTap: {
                                            scale: 0.95
                                        },
                                        className: "p-1.5 rounded-md text-xs flex items-center gap-1 transition-colors",
                                        style: {
                                            background: uiColors.button.danger.background,
                                            color: uiColors.button.danger.text
                                        },
                                        onClick: (e)=>{
                                            e.stopPropagation();
                                            onToggle(); // Remove the indicator
                                        },
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trash$2d$2$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Trash2$3e$__["Trash2"], {
                                                size: 12
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                lineNumber: 415,
                                                columnNumber: 19
                                            }, ("TURBOPACK compile-time value", void 0)),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                children: t("Remove")
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                lineNumber: 416,
                                                columnNumber: 19
                                            }, ("TURBOPACK compile-time value", void 0))
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                        lineNumber: 402,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0)),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex gap-2",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                                                whileHover: {
                                                    scale: 1.05
                                                },
                                                whileTap: {
                                                    scale: 0.95
                                                },
                                                className: "px-2 py-1 rounded-md text-xs transition-colors",
                                                style: {
                                                    background: backgroundColors.secondary,
                                                    color: textColors.secondary
                                                },
                                                onClick: (e)=>{
                                                    e.stopPropagation();
                                                    onExpand(); // Close the expanded panel
                                                },
                                                children: t("Cancel")
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                lineNumber: 419,
                                                columnNumber: 19
                                            }, ("TURBOPACK compile-time value", void 0)),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                                                whileHover: {
                                                    scale: 1.05
                                                },
                                                whileTap: {
                                                    scale: 0.95
                                                },
                                                className: "px-2 py-1 rounded-md text-xs font-medium shadow-sm transition-colors",
                                                style: {
                                                    background: uiColors.button.success.background,
                                                    color: uiColors.button.success.text
                                                },
                                                onClick: applySettings,
                                                children: t("Apply")
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                                lineNumber: 434,
                                                columnNumber: 19
                                            }, ("TURBOPACK compile-time value", void 0))
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                        lineNumber: 418,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0))
                                ]
                            }, void 0, true, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 401,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        ]
                    }, void 0, true, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                        lineNumber: 271,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                    lineNumber: 261,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 259,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
        lineNumber: 192,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const IndicatorPanel = ()=>{
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel");
    const { indicators, toggleIndicator, setShowIndicatorPanel, updateIndicator, forceCalculateAll, activeIndicatorId, setActiveIndicatorId } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChart"])();
    const [selectedCategory, setSelectedCategory] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("added");
    const panelRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const [expandedIndicator, setExpandedIndicator] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [isMobile, setIsMobile] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const { resolvedTheme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTheme"])();
    const isDarkTheme = resolvedTheme === "dark";
    // Get theme colors
    const colors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getChartColors"])(isDarkTheme);
    const textColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTextColors"])(isDarkTheme);
    const borderColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getBorderColors"])(isDarkTheme);
    const uiColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUIColors"])(isDarkTheme);
    const backgroundColors = colors.background;
    const popoverColors = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$theme$2f$colors$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getPopoverColors"])(isDarkTheme);
    // Check if forceCalculateAll is a function
    const safeForceCalculateAll = typeof forceCalculateAll === "function" ? forceCalculateAll : ()=>{
        console.log("forceCalculateAll not available");
    };
    // Check if mobile
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const checkIfMobile = ()=>{
            setIsMobile(window.innerWidth < 768);
        };
        checkIfMobile();
        window.addEventListener("resize", checkIfMobile);
        return ()=>{
            window.removeEventListener("resize", checkIfMobile);
        };
    }, []);
    // Close panel when clicking outside
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleClickOutside = (event)=>{
            if (panelRef.current && !panelRef.current.contains(event.target)) {
                setShowIndicatorPanel(false);
            }
        };
        document.addEventListener("mousedown", handleClickOutside);
        return ()=>{
            document.removeEventListener("mousedown", handleClickOutside);
        };
    }, [
        setShowIndicatorPanel
    ]);
    // Get category icons from the registry
    const getCategoryIcon = (categoryId)=>{
        if (categoryId === "added") {
            const category = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorCategories"].find((cat)=>cat.id === categoryId);
            const color = category?.color || "#f97316";
            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "w-6 h-6 rounded-full flex items-center justify-center text-white text-xs font-medium",
                style: {
                    background: `linear-gradient(to bottom right, ${color}, ${color}dd)`
                },
                children: (indicators || []).filter((ind)=>ind?.visible).length
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 532,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0));
        }
        const category = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorCategories"].find((cat)=>cat.id === categoryId);
        if (category && category.icon) {
            const Icon = category.icon;
            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(Icon, {
                className: "w-4 h-4",
                style: {
                    color: category.color
                }
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 546,
                columnNumber: 14
            }, ("TURBOPACK compile-time value", void 0));
        }
        return null;
    };
    // Create a map to track which indicators have been shown in each category
    // This prevents the same indicator from appearing in multiple categories
    const shownIndicators = new Set();
    // Group indicators by category - ensuring each indicator only appears in one category
    const getIndicatorsForCategory = (categoryId)=>{
        if (categoryId === "added") {
            // For "added" category, show all visible indicators
            return (indicators || []).filter((ind)=>ind?.visible);
        }
        // For other categories, only show indicators that:
        // 1. Match the category
        // 2. Haven't been shown yet
        // 3. Aren't already visible (those go in "added")
        const result = (indicators || []).filter((ind)=>{
            // Skip if already visible (those go in "added" category)
            if (ind.visible) return false;
            // Skip if already shown in another category
            if (shownIndicators.has(ind.id)) return false;
            // Check if indicator belongs in this category
            let belongs = false;
            // Get the indicator definition from the registry
            const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][ind.type];
            if (indicatorDef) {
                if (categoryId === "popular") {
                    // Popular indicators (hardcoded for now, could be configurable)
                    belongs = [
                        "sma",
                        "rsi"
                    ].includes(ind.type);
                } else {
                    // Check if indicator belongs to this category
                    belongs = indicatorDef.defaultSettings.category === categoryId;
                }
            }
            // If it belongs, mark it as shown
            if (belongs) {
                shownIndicators.add(ind.id);
                return true;
            }
            return false;
        });
        return result;
    };
    // Create an object to store indicators by category
    const indicatorsByCategory = {};
    // Initialize with empty arrays for all categories
    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorCategories"].forEach((category)=>{
        indicatorsByCategory[category.id] = [];
    });
    // Fill with actual indicators
    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorCategories"].forEach((category)=>{
        indicatorsByCategory[category.id] = getIndicatorsForCategory(category.id);
    });
    const toggleExpand = (id)=>{
        setExpandedIndicator(expandedIndicator === id ? null : id);
    };
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // If we have an active indicator, expand it and select its category
        if (activeIndicatorId && indicators) {
            const activeIndicator = indicators.find((ind)=>ind?.id === activeIndicatorId);
            if (activeIndicator) {
                setExpandedIndicator(activeIndicatorId);
                // Find which category the indicator belongs to
                if (activeIndicator.visible) {
                    setSelectedCategory("added");
                } else {
                    // Find the category based on indicator type
                    const indicatorDef = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorRegistry"][activeIndicator.type];
                    if (indicatorDef) {
                        const category = indicatorDef.defaultSettings.category;
                        // Fix: Ensure we don't pass undefined to setSelectedCategory
                        if (category) {
                            setSelectedCategory(category);
                        }
                    }
                }
            }
        }
    }, [
        activeIndicatorId,
        indicators
    ]);
    // Add cleanup for activeIndicatorId when panel closes:
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        return ()=>{
            // Clear active indicator when panel closes
            setActiveIndicatorId(null);
        };
    }, [
        setActiveIndicatorId
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
        ref: panelRef,
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("absolute backdrop-blur-md rounded-lg shadow-xl z-[100] overflow-hidden", isMobile ? "fixed inset-0 w-full h-full rounded-none border-0" : "left-16 top-8 w-[450px]"),
        initial: {
            opacity: 0,
            scale: isMobile ? 1 : 0.95,
            y: isMobile ? 20 : 0,
            x: isMobile ? 0 : -20
        },
        animate: {
            opacity: 1,
            scale: 1,
            y: 0,
            x: 0
        },
        exit: {
            opacity: 0,
            scale: isMobile ? 1 : 0.95,
            y: isMobile ? 20 : 0,
            x: isMobile ? 0 : -20
        },
        transition: {
            duration: 0.3,
            type: "spring",
            stiffness: 300,
            damping: 25
        },
        style: {
            background: backgroundColors.primary,
            border: `1px solid ${borderColors.primary}`,
            boxShadow: isDarkTheme ? "0 10px 25px -5px rgba(0, 0, 0, 0.5), 0 8px 10px -6px rgba(0, 0, 0, 0.3)" : "0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1)"
        },
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex", isMobile ? "flex-col h-[calc(100vh-48px)]" : "h-auto"),
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])(isMobile ? "w-full border-b overflow-x-auto flex flex-row" : "w-[130px] border-r"),
                        style: {
                            borderColor: borderColors.primary,
                            background: backgroundColors.secondary
                        },
                        children: __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicators$2f$registry$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["indicatorCategories"].map((category)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
                                whileHover: {
                                    x: isMobile ? 0 : 2
                                },
                                className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex items-center gap-2 p-2 cursor-pointer transition-colors", isMobile ? "min-w-[100px] justify-center" : "", selectedCategory === category.id && (isMobile ? "border-b-2" : "border-l-2")),
                                style: {
                                    borderColor: selectedCategory === category.id ? category.color : "transparent",
                                    background: selectedCategory === category.id ? backgroundColors.tertiary : "transparent",
                                    color: selectedCategory === category.id ? textColors.primary : textColors.secondary
                                },
                                onClick: ()=>{
                                    setSelectedCategory(category.id);
                                    setExpandedIndicator(null);
                                    setActiveIndicatorId(null);
                                },
                                children: [
                                    getCategoryIcon(category.id),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "text-xs",
                                        children: category.name
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                        lineNumber: 742,
                                        columnNumber: 15
                                    }, ("TURBOPACK compile-time value", void 0)),
                                    selectedCategory === category.id && !isMobile && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$right$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronRight$3e$__["ChevronRight"], {
                                        size: 12,
                                        className: "ml-auto",
                                        style: {
                                            color: category.color
                                        }
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                        lineNumber: 744,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0))
                                ]
                            }, category.id, true, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 712,
                                columnNumber: 13
                            }, ("TURBOPACK compile-time value", void 0)))
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                        lineNumber: 700,
                        columnNumber: 9
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("p-2 overflow-y-auto w-full", isMobile ? "flex-1" : "max-h-[350px]"),
                        style: {
                            background: backgroundColors.primary
                        },
                        children: selectedCategory && indicatorsByCategory[selectedCategory] ? indicatorsByCategory[selectedCategory].length > 0 ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "space-y-2 w-full",
                            children: indicatorsByCategory[selectedCategory].map((indicator)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(IndicatorItem, {
                                    indicator: indicator,
                                    isExpanded: expandedIndicator === indicator.id,
                                    onToggle: ()=>{
                                        toggleIndicator(indicator.id);
                                        // Force recalculation after toggling
                                        setTimeout(()=>{
                                            if (typeof forceCalculateAll === "function") {
                                                forceCalculateAll();
                                            }
                                        }, 100);
                                    },
                                    onExpand: ()=>toggleExpand(indicator.id),
                                    categoryId: selectedCategory,
                                    setSelectedCategory: setSelectedCategory,
                                    setExpandedIndicator: setExpandedIndicator,
                                    updateIndicator: updateIndicator,
                                    forceCalculateAll: safeForceCalculateAll
                                }, indicator.id, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                    lineNumber: 765,
                                    columnNumber: 19
                                }, ("TURBOPACK compile-time value", void 0)))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                            lineNumber: 763,
                            columnNumber: 15
                        }, ("TURBOPACK compile-time value", void 0)) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex flex-col items-center justify-center h-full text-sm",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                style: {
                                    color: textColors.secondary
                                },
                                children: [
                                    t("no_indicators_in_this_category_yet"),
                                    "."
                                ]
                            }, void 0, true, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 789,
                                columnNumber: 17
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                            lineNumber: 788,
                            columnNumber: 15
                        }, ("TURBOPACK compile-time value", void 0)) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex flex-col items-center justify-center h-full text-sm",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                style: {
                                    color: textColors.secondary
                                },
                                children: t("select_a_category_to_view_indicators")
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                                lineNumber: 796,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                            lineNumber: 795,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0))
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                        lineNumber: 754,
                        columnNumber: 9
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 694,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            isMobile && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute bottom-6 left-0 right-0 flex justify-center",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
                    whileHover: {
                        scale: 1.05
                    },
                    whileTap: {
                        scale: 0.95
                    },
                    onClick: ()=>setShowIndicatorPanel(false),
                    className: "px-6 py-2 rounded-full text-white font-medium shadow-lg",
                    style: {
                        background: uiColors.button.primary.background
                    },
                    children: t("Close")
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                    lineNumber: 806,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
                lineNumber: 805,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx",
        lineNumber: 659,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const __TURBOPACK__default__export__ = IndicatorPanel;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "SettingsPanel",
    ()=>SettingsPanel,
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$grid$2d$3x3$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Grid$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/grid-3x3.js [app-ssr] (ecmascript) <export default as Grid>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$line$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__LineChart$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-line.js [app-ssr] (ecmascript) <export default as LineChart>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$candlestick$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CandlestickChart$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-candlestick.js [app-ssr] (ecmascript) <export default as CandlestickChart>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart3$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-column.js [app-ssr] (ecmascript) <export default as BarChart3>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$area$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__AreaChart$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chart-area.js [app-ssr] (ecmascript) <export default as AreaChart>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/framer-motion@12.0.0-alpha._8d78ba5670384fb328b90c214f768d8a/node_modules/framer-motion/dist/es/render/components/motion/proxy.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-themes@1.0.0-beta.0_ne_fd389c5db48046672a7f720e88c0bc38/node_modules/next-themes/dist/index.module.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/react-client/index.js [app-ssr] (ecmascript) <locals>");
"use client";
;
;
;
;
;
;
;
;
const SettingsPanel = ()=>{
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("components/blocks/advanced-chart/canvas/render/toolbar/settings-panel");
    const { chartType, setChartType, showGrid, toggleGrid, setShowSettingsPanel, showVolume, toggleVolume } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChart"])();
    const panelRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const { theme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTheme"])();
    const isDark = theme === "dark";
    // Handle click outside to close panel
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleClickOutside = (event)=>{
            if (panelRef.current && !panelRef.current.contains(event.target)) {
                setShowSettingsPanel(false);
            }
        };
        document.addEventListener("mousedown", handleClickOutside);
        return ()=>{
            document.removeEventListener("mousedown", handleClickOutside);
        };
    }, [
        setShowSettingsPanel
    ]);
    // Theme-aware panel classes
    const panelClasses = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("absolute left-16 top-[120px] w-[280px] backdrop-blur-md border rounded-lg shadow-xl z-50", isDark ? "bg-black/90 border-zinc-800" : "bg-white/95 border-zinc-200");
    // Theme-aware section header classes
    const sectionHeaderClasses = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("text-xs font-medium backdrop-blur-sm p-2 rounded-md flex items-center gap-1.5", isDark ? "bg-black/50 text-zinc-300" : "bg-zinc-100/50 text-zinc-700");
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].div, {
        ref: panelRef,
        className: panelClasses,
        initial: {
            opacity: 0,
            x: -10
        },
        animate: {
            opacity: 1,
            x: 0
        },
        exit: {
            opacity: 0,
            x: -10
        },
        transition: {
            duration: 0.2
        },
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "p-3 space-y-3",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "space-y-2",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("h4", {
                            className: sectionHeaderClasses,
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$line$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__LineChart$3e$__["LineChart"], {
                                    size: 14,
                                    className: "text-green-400"
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 77,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                t("chart_type")
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                            lineNumber: 76,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "grid grid-cols-2 gap-2",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ChartTypeButton, {
                                    type: "candlestick",
                                    label: "Candlestick",
                                    icon: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$candlestick$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CandlestickChart$3e$__["CandlestickChart"], {
                                        size: 16
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                        lineNumber: 84,
                                        columnNumber: 21
                                    }, void 0),
                                    isActive: chartType === "candlestick",
                                    onClick: ()=>setChartType("candlestick"),
                                    isDark: isDark
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 81,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ChartTypeButton, {
                                    type: "line",
                                    label: "Line",
                                    icon: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$line$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__LineChart$3e$__["LineChart"], {
                                        size: 16
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                        lineNumber: 92,
                                        columnNumber: 21
                                    }, void 0),
                                    isActive: chartType === "line",
                                    onClick: ()=>setChartType("line"),
                                    isDark: isDark
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 89,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ChartTypeButton, {
                                    type: "bar",
                                    label: "Bar",
                                    icon: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart3$3e$__["BarChart3"], {
                                        size: 16
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                        lineNumber: 100,
                                        columnNumber: 21
                                    }, void 0),
                                    isActive: chartType === "bar",
                                    onClick: ()=>setChartType("bar"),
                                    isDark: isDark
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 97,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ChartTypeButton, {
                                    type: "area",
                                    label: "Area",
                                    icon: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$area$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__AreaChart$3e$__["AreaChart"], {
                                        size: 16
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                        lineNumber: 108,
                                        columnNumber: 21
                                    }, void 0),
                                    isActive: chartType === "area",
                                    onClick: ()=>setChartType("area"),
                                    isDark: isDark
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 105,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                            lineNumber: 80,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                    lineNumber: 75,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "space-y-2",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("h4", {
                            className: sectionHeaderClasses,
                            children: t("display_options")
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                            lineNumber: 118,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "space-y-2",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ToggleOption, {
                                    label: "Show Grid",
                                    icon: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$grid$2d$3x3$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Grid$3e$__["Grid"], {
                                        size: 16,
                                        className: isDark ? "text-gray-400" : "text-gray-500"
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                        lineNumber: 123,
                                        columnNumber: 17
                                    }, void 0),
                                    isActive: showGrid,
                                    onToggle: toggleGrid,
                                    isDark: isDark
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 120,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(ToggleOption, {
                                    label: "Show Volume",
                                    icon: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chart$2d$column$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__BarChart3$3e$__["BarChart3"], {
                                        size: 16,
                                        className: "text-blue-400"
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                        lineNumber: 135,
                                        columnNumber: 21
                                    }, void 0),
                                    isActive: showVolume,
                                    onToggle: toggleVolume,
                                    isDark: isDark
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                                    lineNumber: 133,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                            lineNumber: 119,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                    lineNumber: 117,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
            lineNumber: 73,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
        lineNumber: 65,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const ChartTypeButton = ({ type, label, icon, isActive, onClick, isDark })=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$framer$2d$motion$40$12$2e$0$2e$0$2d$alpha$2e$_8d78ba5670384fb328b90c214f768d8a$2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["motion"].button, {
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex flex-col items-center justify-center gap-1 p-2 rounded-md transition-all backdrop-blur-sm", isActive ? "bg-green-600 text-white" : isDark ? "bg-black/70 border border-zinc-800/50 text-zinc-300 hover:border-zinc-700/70" : "bg-zinc-100/30 border border-zinc-200/50 text-zinc-700 hover:border-zinc-300/70"),
        onClick: onClick,
        whileHover: {
            scale: 1.03
        },
        whileTap: {
            scale: 0.97
        },
        children: [
            icon,
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "text-xs font-medium",
                children: label
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                lineNumber: 179,
                columnNumber: 5
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
        lineNumber: 165,
        columnNumber: 3
    }, ("TURBOPACK compile-time value", void 0));
const ToggleOption = ({ label, icon, isActive, onToggle, isDark })=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex items-center justify-between p-2 backdrop-blur-sm border hover:border-opacity-70 rounded-md cursor-pointer", isDark ? "bg-black/70 border-zinc-800/50 hover:border-zinc-700/70" : "bg-zinc-100/30 border-zinc-200/50 hover:border-zinc-300/70"),
        onClick: onToggle,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex items-center gap-2",
                children: [
                    icon,
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("text-xs", isDark ? "text-zinc-200" : "text-zinc-700"),
                        children: label
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                        lineNumber: 210,
                        columnNumber: 7
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                lineNumber: 208,
                columnNumber: 5
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("w-9 h-4 rounded-full relative", isDark ? "bg-zinc-800" : "bg-zinc-200"),
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("absolute top-0.5 w-3 h-3 rounded-full transition-all duration-200", isActive ? "right-0.5 bg-green-500" : isDark ? "left-0.5 bg-zinc-600" : "left-0.5 bg-zinc-400")
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                    lineNumber: 222,
                    columnNumber: 7
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
                lineNumber: 216,
                columnNumber: 5
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx",
        lineNumber: 199,
        columnNumber: 3
    }, ("TURBOPACK compile-time value", void 0));
const __TURBOPACK__default__export__ = SettingsPanel;
}),
"[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$hooks$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/hooks.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$mouse$2d$events$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/events/mouse-events.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$indicator$2d$panel$2d$events$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/events/indicator-panel-events.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$setup$2d$events$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/events/setup-events.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$animation$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/animation.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/footer/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$chart$2d$toolbar$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/chart-toolbar.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicator$2d$panel$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/indicator-panel.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$settings$2d$panel$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/render/toolbar/settings-panel.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/react-client/index.js [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/utils.ts [app-ssr] (ecmascript) <locals>");
"use client";
;
;
;
;
;
;
;
;
;
;
;
;
;
;
// Helper function to check if a point is in the main chart area
function isInMainChartArea(x, y, chartTop, chartHeight, chartWidth, priceScaleWidth) {
    return x >= 0 && x <= chartWidth - priceScaleWidth && y >= chartTop && y <= chartTop + chartHeight;
}
// Create a component that doesn't rerender when theme changes
const ChartCanvasInner = ({ positions })=>{
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("components/blocks/advanced-chart/canvas/index");
    const context = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChart"])();
    const { candleData, dimensions, visibleRange, chartType, indicators, drawingTools, orders = [], mousePosition, showVolume, showGrid, priceScaleWidth, timeScaleHeight, darkMode, isDragging, activeDrawingTool, calculateSeparatePanelsHeight, priceToY, yToPrice, setTooltip, setMousePosition, setIsDragging, setDragStart, isDrawing, currentDrawing, dragStart, setVisibleRange, showVolumeProfile, priceAlerts, showPatternRecognition, theme, fetchOlderData, shouldFetchOlderData, isLoadingOlderData, hasReachedOldestData, timeFrame, expiryIntervalMinutes, setShowIndicatorPanel, setActiveIndicatorId, toggleIndicator, panelHeights, setPanelHeights, collapsedPanels, setCollapsedPanels, isDraggingPanel, setIsDraggingPanel, setShowTimeframeSelector, setShowSettingsPanel, symbol, dataReady, showIndicatorPanel, showSettingsPanel, isMarketSwitching, loading, isChangingTimeframe } = context;
    // Access chartDimensions with type assertion
    const chartDimensions = context.chartDimensions;
    // Use a ref to track the last mouse move time to throttle events
    const lastMouseMoveRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Use a ref to track the last touch event time to throttle events
    const lastTouchMoveRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(0);
    // Add state for current time
    const [currentTime, setCurrentTime] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(new Date());
    // Use a ref to track if component is mounted
    const isMountedRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(true);
    // Add a ref to track if we've already set up the canvas
    const hasSetupCanvasRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(false);
    // Add this near the other useRef declarations
    const lastMousePositionRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])({
        x: 0,
        y: 0
    });
    // Add state for timeframe selector visibility
    const [showTimeframeSelector, setShowTimeframeSelectorState] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    // Add a ref for the wheel event handler - initialize with null
    const wheelHandlerRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    // Update time every minute
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const timer = setInterval(()=>{
            if (isMountedRef.current) {
                setCurrentTime(new Date());
            }
        }, 60000);
        return ()=>clearInterval(timer);
    }, []);
    // Use our custom hooks
    const { canvasRef, offscreenCanvasRef, animationFrameIdRef } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$hooks$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCanvasSetup"])(dimensions);
    const { isThrottled, hoverEffect, renderQuality, needsRenderRef, lastRenderTimeRef, lastVisibleRangeRef, setHoverEffect, throttle } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$hooks$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRenderState"])();
    const { touchStartX, touchStartY, lastTouchDistance, setTouchStartX, setTouchStartY, setLastTouchDistance } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$hooks$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTouchInteractions"])();
    // Get the trigger render function
    const triggerRender = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$hooks$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTriggerRender"])(needsRenderRef);
    // Check if we need to load older data
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$hooks$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useOlderDataCheck"])(candleData, visibleRange, isLoadingOlderData, hasReachedOldestData, fetchOlderData);
    // Calculate the main chart area dimensions
    const chartTop = 0; // Start from the top of the canvas
    // Safely calculate priceChartHeight using calculateSeparatePanelsHeight
    const separatePanelsHeight = typeof calculateSeparatePanelsHeight === "function" ? calculateSeparatePanelsHeight() : 0;
    const priceChartHeight = dimensions.height - timeScaleHeight - separatePanelsHeight;
    // Set up mouse event handlers
    const { handleMouseMove, handleMouseDown, handleMouseUp, handleMouseLeave, handleWheel } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$mouse$2d$events$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMouseEvents"])({
        mousePosition,
        isDrawing,
        currentDrawing,
        isDragging,
        dragStart,
        dimensions,
        visibleRange,
        candleData,
        setVisibleRange,
        setDragStart,
        setMousePosition,
        setIsDragging,
        isThrottled,
        triggerRender,
        priceScaleWidth,
        throttle,
        setHoverEffect,
        chartTop,
        priceChartHeight
    });
    // Touch events are now handled by setupEventListeners in useEffect
    // Commenting out this hook to avoid conflicts with canvas event listeners
    // const { handleTouchStart, handleTouchMove, handleTouchEnd } = useTouchEvents({
    //   setTouchStartX,
    //   setTouchStartY,
    //   setLastTouchDistance,
    //   touchStartX,
    //   touchStartY,
    //   lastTouchDistance,
    //   setDragStart,
    //   setIsDragging,
    //   dimensions,
    //   visibleRange,
    //   candleData,
    //   setVisibleRange,
    //   triggerRender,
    //   priceScaleWidth,
    //   chartTop,
    //   priceChartHeight,
    // });
    // Placeholder touch handlers (events are handled by setupEventListeners)
    const handleTouchStart = ()=>{};
    const handleTouchMove = ()=>{};
    const handleTouchEnd = ()=>{};
    // Set up indicator panel interactions with proper null checks
    const { handleIndicatorPanelClick, handleIndicatorPanelMouseMove, handleIndicatorPanelMouseUp } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$indicator$2d$panel$2d$events$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useIndicatorPanelInteractions"])({
        indicators: indicators || [],
        dimensions,
        visibleRange,
        candleData,
        showVolume,
        priceChartHeight,
        chartTop,
        priceScaleWidth,
        panelHeights,
        setPanelHeights,
        collapsedPanels,
        setCollapsedPanels,
        isDraggingPanel,
        setIsDraggingPanel,
        setShowIndicatorPanel,
        setActiveIndicatorId,
        toggleIndicator,
        theme
    });
    // Determine if chart should render (declare before useChartAnimation)
    const shouldRenderChart = dataReady && !isMarketSwitching && candleData.length > 0 && dimensions.width > 0 && dimensions.height > 0;
    // Set up animation only when chart should render
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$animation$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useChartAnimation"])({
        canvasRef: canvasRef,
        offscreenCanvasRef: offscreenCanvasRef,
        animationFrameIdRef,
        needsRenderRef,
        lastRenderTimeRef,
        dimensions,
        renderQuality,
        theme,
        visibleRange,
        candleData,
        indicators: indicators,
        showGrid,
        isLoadingOlderData,
        showVolume,
        priceScaleWidth,
        timeScaleHeight,
        chartType: chartType,
        showVolumeProfile,
        isDragging,
        drawingTools,
        priceToY,
        yToPrice,
        priceAlerts,
        mousePosition,
        hoverEffect,
        orders,
        dataReady: shouldRenderChart,
        isMarketSwitching,
        expiryIntervalMinutes,
        expiryMarkers: []
    });
    // Set cursor style for main chart area
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (canvasRef.current) {
            const canvas = canvasRef.current;
            // Add a mousemove listener just for cursor style
            const handleCursorStyle = (e)=>{
                const rect = canvas.getBoundingClientRect();
                const x = e.clientX - rect.left;
                const y = e.clientY - rect.top;
                // Check if in main chart area
                if (isInMainChartArea(x, y, chartTop, priceChartHeight, dimensions.width, priceScaleWidth)) {
                    canvas.style.cursor = isDragging ? "grabbing" : "grab";
                } else {
                    canvas.style.cursor = "default";
                }
            };
            canvas.addEventListener("mousemove", handleCursorStyle);
            return ()=>{
                canvas.removeEventListener("mousemove", handleCursorStyle);
            };
        }
    }, [
        dimensions,
        isDragging,
        chartTop,
        priceChartHeight,
        priceScaleWidth
    ]);
    // Set up advanced event listeners with proper touch handling
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!canvasRef.current) return;
        const canvas = canvasRef.current;
        // Create chart object with all necessary properties for setupEventListeners
        const chartProps = {
            setMousePosition,
            setIsDragging,
            setDragStart,
            visibleRange,
            setVisibleRange,
            candleData,
            dimensions,
            priceScaleWidth,
            chartTop,
            priceChartHeight,
            shouldFetchOlderData,
            fetchOlderData,
            isDragging,
            dragStart,
            needsRenderRef
        };
        // Set up all event listeners with proper passive handling
        const cleanup = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$events$2f$setup$2d$events$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["setupEventListeners"])(canvas, chartProps);
        return cleanup;
    }, [
        // Key dependencies that require re-setup of event listeners
        dimensions.width,
        dimensions.height,
        priceScaleWidth,
        chartTop,
        priceChartHeight
    ]);
    // Initialize chart with 30% future space but allow dragging up to 75%
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (candleData.length > 0 && !lastVisibleRangeRef.current.initialized) {
            // Calculate a better initial zoom level based on device width
            // For smaller screens, show fewer candles to make them more visible
            const screenWidth = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : 1200;
            // Adjust visible candle count based on screen size
            let visibleCount;
            if (screenWidth <= 480) {
                // Mobile
                visibleCount = Math.min(30, candleData.length);
            } else if (screenWidth <= 768) {
                // Tablet
                visibleCount = Math.min(50, candleData.length);
            } else {
                // Desktop
                visibleCount = Math.min(70, candleData.length);
            }
            // Set initial visible range to show candles in the left 70% of the chart
            // and leave the right 30% empty for future
            const futureSpace = visibleCount * 0.43; // 30% of the visible area (0.3/0.7 = 0.43)
            const end = candleData.length + futureSpace;
            const start = end - visibleCount - futureSpace;
            setVisibleRange({
                start,
                end
            });
            lastVisibleRangeRef.current.initialized = true;
        }
    }, [
        candleData.length,
        setVisibleRange,
        lastVisibleRangeRef
    ]);
    // Initialize chart with consistent positioning based on timeframe
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (candleData.length > 0 && (!lastVisibleRangeRef.current.initialized || isChangingTimeframe)) {
            // Calculate timeframe-specific visible count
            const getTimeframeVisibleCount = (tf, screenWidth)=>{
                const baseCount = screenWidth <= 480 ? 30 : screenWidth <= 768 ? 50 : 70;
                // Adjust based on timeframe - higher timeframes show more candles
                const timeframeMultipliers = {
                    "1m": 1.0,
                    "3m": 0.9,
                    "5m": 0.8,
                    "15m": 0.7,
                    "30m": 0.6,
                    "1h": 0.6,
                    "2h": 0.5,
                    "4h": 0.4,
                    "6h": 0.4,
                    "8h": 0.4,
                    "12h": 0.3,
                    "1d": 0.4,
                    "3d": 0.3,
                    "1w": 0.2,
                    "1M": 0.2
                };
                const multiplier = timeframeMultipliers[tf] || 0.7;
                return Math.min(Math.floor(baseCount * multiplier), candleData.length);
            };
            const screenWidth = ("TURBOPACK compile-time falsy", 0) ? "TURBOPACK unreachable" : 1200;
            const visibleCount = getTimeframeVisibleCount(timeFrame, screenWidth);
            // Set consistent positioning - always show latest data with 20% future space
            const futureSpace = Math.floor(visibleCount * 0.2);
            const end = candleData.length + futureSpace;
            const start = Math.max(0, candleData.length - visibleCount + futureSpace);
            setVisibleRange({
                start,
                end
            });
            lastVisibleRangeRef.current.initialized = true;
            // Only log in development mode to prevent production spam
            if ("TURBOPACK compile-time truthy", 1) {
                console.log(`📊 Set visible range for ${timeFrame}:`, {
                    start,
                    end,
                    visibleCount,
                    dataLength: candleData.length
                });
            }
        }
    }, [
        candleData.length,
        timeFrame,
        isChangingTimeframe,
        setVisibleRange,
        lastVisibleRangeRef
    ]);
    // Update the useEffect hook that handles canvas rendering to ensure proper dimensions:
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!canvasRef.current || !chartDimensions || hasSetupCanvasRef.current) return;
        hasSetupCanvasRef.current = true;
        // Set canvas dimensions with proper scaling
        const canvas = canvasRef.current;
        const pixelRatio = window.devicePixelRatio || 1;
        canvas.width = chartDimensions.width * pixelRatio;
        canvas.height = chartDimensions.height * pixelRatio;
        // Get the rendering context
        const ctx = canvas.getContext("2d");
        if (!ctx) return;
        // Scale the context to account for the device pixel ratio
        ctx.scale(pixelRatio, pixelRatio);
        // Clear the canvas
        ctx.clearRect(0, 0, chartDimensions.width, chartDimensions.height);
        // Set the canvas style dimensions to match the container
        canvas.style.width = `${chartDimensions.width}px`;
        canvas.style.height = `${chartDimensions.height}px`;
        // Ensure the canvas is properly aligned to pixel boundaries
        canvas.style.transform = "translate3d(0, 0, 0)";
    }, [
        chartDimensions,
        canvasRef
    ]);
    // Add this helper function with proper typing
    const throttleTouchEvent = (callback, event)=>{
        // Prevent processing touch moves when switching markets to avoid state updates
        if (isMarketSwitching) return;
        // More aggressive throttling for touch events
        const now = Date.now();
        if (now - lastTouchMoveRef.current < 24) {
            // Increased from 16ms to 24ms for better performance
            event.preventDefault(); // Still prevent default to stop scrolling
            return;
        }
        lastTouchMoveRef.current = now;
        callback(event);
    };
    // Create a throttled mouse move handler to prevent too many state updates
    const throttledMouseMoveHandler = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((e)=>{
        // Prevent processing mouse moves when switching markets to avoid state updates
        if (isMarketSwitching) return;
        // Throttle mouse move events to prevent excessive state updates
        const now = Date.now();
        if (now - lastMouseMoveRef.current < 16) {
            // Limit to ~60fps
            return;
        }
        lastMouseMoveRef.current = now;
        // Get mouse coordinates
        const rect = e.currentTarget.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        // Only process if position has changed significantly
        const lastPos = mousePosition || {
            x: 0,
            y: 0
        };
        if (!mousePosition || Math.abs(lastPos.x - x) > 2 || Math.abs(lastPos.y - y) > 2) {
            // Call the handlers but don't update state directly here
            handleMouseMove(e);
            // Only call panel mouse move if we're actually resizing a panel
            if (isDraggingPanel && Object.values(isDraggingPanel).some(Boolean)) {
                handleIndicatorPanelMouseMove(e);
            }
        }
    }, [
        mousePosition,
        isMarketSwitching,
        handleMouseMove,
        isDraggingPanel,
        handleIndicatorPanelMouseMove
    ]);
    // Cleanup on unmount
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        return ()=>{
            isMountedRef.current = false;
            // Cancel any animation frames
            if (animationFrameIdRef.current) {
                cancelAnimationFrame(animationFrameIdRef.current);
                animationFrameIdRef.current = null;
            }
        };
    }, []);
    // Set up non-passive wheel event listener
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!canvasRef.current) return;
        const canvas = canvasRef.current;
        // Create a wheel event handler that can be removed later
        wheelHandlerRef.current = (e)=>{
            e.preventDefault();
            // Convert to a React-like event object
            const syntheticEvent = {
                currentTarget: canvas,
                preventDefault: ()=>e.preventDefault(),
                stopPropagation: ()=>e.stopPropagation(),
                nativeEvent: e,
                clientX: e.clientX,
                clientY: e.clientY,
                deltaY: e.deltaY,
                deltaMode: e.deltaMode
            };
            handleWheel(syntheticEvent);
        };
        // Add the wheel event listener with passive: false
        if (wheelHandlerRef.current) {
            canvas.addEventListener("wheel", wheelHandlerRef.current, {
                passive: false
            });
        }
        // Clean up
        return ()=>{
            if (wheelHandlerRef.current) {
                canvas.removeEventListener("wheel", wheelHandlerRef.current);
            }
        };
    }, [
        handleWheel
    ]);
    // Determine the loading state and message
    const isLoading = loading || isMarketSwitching || isChangingTimeframe;
    const isEmpty = !isLoading && dataReady && candleData.length === 0;
    const getLoadingMessage = ()=>{
        if (isMarketSwitching) {
            return "Switching Market";
        } else if (isChangingTimeframe) {
            return "Changing Timeframe";
        } else {
            return "Loading Chart";
        }
    };
    const getLoadingSubMessage = ()=>{
        if (isMarketSwitching) {
            return `Loading ${symbol} data...`;
        } else if (isChangingTimeframe) {
            return `Switching to ${timeFrame} interval...`;
        } else if (candleData.length === 0) {
            return "Fetching historical data...";
        } else {
            return "Updating chart data...";
        }
    };
    // Update the return statement to use the floating toolbar
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "chart-container",
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("canvas", {
                ref: canvasRef,
                className: "chart-canvas",
                onMouseMove: throttledMouseMoveHandler,
                onMouseDown: (e)=>{
                    // First check if we're interacting with an indicator panel
                    if (!handleIndicatorPanelClick(e)) {
                        // If not, handle regular chart interactions
                        handleMouseDown(e);
                    }
                },
                onMouseUp: (e)=>{
                    handleMouseUp(e);
                    handleIndicatorPanelMouseUp();
                },
                onMouseLeave: handleMouseLeave,
                // Touch events are handled by setupEventListeners with proper passive: false
                // Removing React touch handlers to avoid conflicts
                style: {
                    backgroundColor: theme === "dark" ? "#000000" : "#ffffff",
                    imageRendering: theme === "dark" ? "auto" : "crisp-edges"
                },
                onClick: handleIndicatorPanelClick
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 673,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            isLoading && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0 bg-zinc-900/90 flex items-center justify-center z-50",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex flex-col items-center space-y-4",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "relative",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-16 h-16 border-4 border-zinc-800 rounded-full"
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 704,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "absolute top-0 left-0 w-16 h-16 border-4 border-t-zinc-400 border-r-transparent border-b-transparent border-l-transparent rounded-full animate-spin"
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 705,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 703,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "text-center",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "text-zinc-100 text-lg font-medium mb-1",
                                    children: getLoadingMessage()
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 710,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "text-zinc-400 text-sm",
                                    children: getLoadingSubMessage()
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 713,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 709,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex space-x-1",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-2 h-2 bg-zinc-500 rounded-full animate-pulse"
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 720,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-2 h-2 bg-zinc-500 rounded-full animate-pulse",
                                    style: {
                                        animationDelay: "0.2s"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 721,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-2 h-2 bg-zinc-500 rounded-full animate-pulse",
                                    style: {
                                        animationDelay: "0.4s"
                                    }
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 725,
                                    columnNumber: 15
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 719,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                    lineNumber: 701,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 700,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            isEmpty && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0 bg-zinc-900/50 flex items-center justify-center z-40",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex flex-col items-center space-y-4",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "relative",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "w-16 h-16 border-4 border-zinc-700 rounded-lg flex items-center justify-center",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("svg", {
                                    className: "w-8 h-8 text-zinc-500",
                                    fill: "none",
                                    stroke: "currentColor",
                                    viewBox: "0 0 24 24",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("path", {
                                        strokeLinecap: "round",
                                        strokeLinejoin: "round",
                                        strokeWidth: 2,
                                        d: "M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                        lineNumber: 747,
                                        columnNumber: 19
                                    }, ("TURBOPACK compile-time value", void 0))
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 741,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0))
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                lineNumber: 740,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 739,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "text-center",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "text-zinc-100 text-lg font-medium mb-1",
                                    children: t("no_chart_data_available")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 759,
                                    columnNumber: 16
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "text-zinc-400 text-sm",
                                    children: t("no_trading_data_available")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 762,
                                    columnNumber: 16
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 758,
                            columnNumber: 14
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                    lineNumber: 737,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 736,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute top-0 left-0 right-0 pointer-events-none",
                style: {
                    height: "96px",
                    background: "linear-gradient(to bottom, rgba(19, 23, 34, 0.8) 0%, rgba(19, 23, 34, 0.4) 50%, rgba(19, 23, 34, 0) 100%)",
                    backdropFilter: "blur(1.5px)",
                    zIndex: -1
                }
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 771,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$chart$2d$toolbar$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartToolbar"], {
                symbol: symbol,
                onTimeframeClick: ()=>setShowTimeframeSelectorState(!showTimeframeSelector),
                onIndicatorsClick: ()=>setShowIndicatorPanel(!showIndicatorPanel),
                onSettingsClick: ()=>setShowSettingsPanel(!showSettingsPanel)
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 783,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            mousePosition && candleData.length > 0 && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute pointer-events-none bg-[#1A1D29] border border-gray-800 rounded p-2 text-xs",
                style: {
                    left: mousePosition.x + 20,
                    top: mousePosition.y + 20,
                    display: mousePosition.candle ? "block" : "none"
                },
                children: mousePosition.candle && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex justify-between gap-4",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: t("open")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 805,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(mousePosition.candle?.open || 0)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 806,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 804,
                            columnNumber: 15
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex justify-between gap-4",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: t("high")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 811,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(mousePosition.candle?.high || 0)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 812,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 810,
                            columnNumber: 15
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex justify-between gap-4",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: t("low")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 817,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(mousePosition.candle?.low || 0)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 818,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 816,
                            columnNumber: 15
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex justify-between gap-4",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: t("close")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 823,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                    children: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["formatPrice"])(mousePosition.candle?.close || 0)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                                    lineNumber: 824,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                            lineNumber: 822,
                            columnNumber: 15
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true)
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 794,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            showIndicatorPanel && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute left-4 z-20",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$indicator$2d$panel$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["IndicatorPanel"], {}, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                    lineNumber: 836,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 835,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            showSettingsPanel && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute left-4 z-20",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$toolbar$2f$settings$2d$panel$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["SettingsPanel"], {}, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                    lineNumber: 843,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 842,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute bottom-0 left-0 right-0 h-[30px] pointer-events-none",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$render$2f$footer$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                    lineNumber: 849,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
                lineNumber: 848,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx",
        lineNumber: 672,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
// Use React.memo to prevent unnecessary rerenders
const ChartCanvas = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["memo"])(ChartCanvasInner, ()=>true);
const __TURBOPACK__default__export__ = ChartCanvas;
}),
"[project]/frontend/components/blocks/advanced-chart/index.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>AdvancedChart
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-themes@1.0.0-beta.0_ne_fd389c5db48046672a7f720e88c0bc38/node_modules/next-themes/dist/index.module.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-context.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$indicators$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/context/chart-indicators.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/canvas/index.tsx [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
;
;
// Create a stable memo function that doesn't change on rerenders
const stableEquals = (a, b)=>a === b;
// Create a React.memo wrapper with custom comparison
const MemoizedChartCanvas = /*#__PURE__*/ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].memo(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$canvas$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], (prevProps, nextProps)=>{
    // Always return true to prevent rerenders from props
    return true;
});
function AdvancedChart({ symbol, timeFrame, orders = [], expiryMinutes = 5, showExpiry = true, timeframeDurations, positions, isMarketSwitching = false, onChartContextReady, marketType = "spot" }) {
    // Get theme from next-themes
    const { resolvedTheme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTheme"])();
    // Determine if dark mode is active and memoize it
    const isDarkMode = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>resolvedTheme === "dark", [
        resolvedTheme
    ]);
    // Ref to track previous theme to prevent unnecessary updates
    const prevThemeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(isDarkMode);
    // Ref to track if component is mounted
    const isMountedRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(true);
    // Internal state for price updates
    const [currentPrice, setCurrentPrice] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(0);
    const [internalTimeFrame, setInternalTimeFrame] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(timeFrame);
    // Update internal timeframe when prop changes
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (isMountedRef.current) {
            setInternalTimeFrame(timeFrame);
        }
    }, [
        timeFrame
    ]);
    // Handle internal timeframe changes
    const handleInternalTimeFrameChange = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((newTimeFrame)=>{
        if (isMountedRef.current) {
            setInternalTimeFrame(newTimeFrame);
        }
    }, []);
    // Memoize context values to prevent unnecessary rerenders
    const contextValues = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>({
            expiryIntervalMinutes: showExpiry ? expiryMinutes : 0,
            currentPrice,
            timeFrame: internalTimeFrame,
            theme: isDarkMode ? "dark" : "light"
        }), [
        expiryMinutes,
        currentPrice,
        internalTimeFrame,
        isDarkMode,
        showExpiry
    ]);
    // Update the useEffect to properly handle expiryMinutes changes
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!isMountedRef.current) return;
        // If we have a chart context reference, update it directly
        if (onChartContextReady) {
            onChartContextReady(contextValues);
        }
    }, [
        contextValues,
        onChartContextReady
    ]);
    // Use useCallback to memoize the onChartContextReady callback
    const handleChartContextReady = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((context)=>{
        if (!isMountedRef.current) return;
        if (onChartContextReady) {
            // Add price and timeframe to the context
            const enhancedContext = {
                ...context,
                currentPrice,
                timeFrame: internalTimeFrame
            };
            onChartContextReady(enhancedContext);
        }
    }, [
        onChartContextReady,
        currentPrice,
        internalTimeFrame
    ]);
    // Handle price updates internally
    const handlePriceUpdate = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((price)=>{
        if (!isMountedRef.current) return;
        setCurrentPrice(price);
    }, []);
    // Listen for theme changes - optimized to prevent unnecessary rerenders
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!isMountedRef.current) return;
        // Only proceed if theme actually changed
        if (prevThemeRef.current !== isDarkMode) {
            prevThemeRef.current = isDarkMode;
            // If we have a chart context reference, update it directly
            if (onChartContextReady) {
                onChartContextReady({
                    expiryIntervalMinutes: showExpiry ? expiryMinutes : 0,
                    currentPrice,
                    timeFrame: internalTimeFrame,
                    theme: isDarkMode ? "dark" : "light"
                });
            }
        }
    }, [
        isDarkMode,
        expiryMinutes,
        onChartContextReady,
        currentPrice,
        internalTimeFrame,
        showExpiry
    ]);
    // Cleanup on unmount
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        return ()=>{
            isMountedRef.current = false;
        };
    }, []);
    // Only pass orders if showExpiry is true
    const filteredOrders = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>showExpiry ? orders : [], [
        showExpiry,
        orders
    ]);
    // Add this to the AdvancedChart component to prevent unnecessary rerenders
    const memoizedSymbol = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>symbol, [
        symbol
    ]);
    const memoizedTimeFrame = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>internalTimeFrame, [
        internalTimeFrame
    ]);
    const memoizedExpiryMinutes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>showExpiry ? expiryMinutes : 0, [
        showExpiry,
        expiryMinutes
    ]);
    const memoizedPositions = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>positions, [
        positions
    ]);
    const memoizedIsMarketSwitching = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>isMarketSwitching, [
        isMarketSwitching
    ]);
    const memoizedMarketType = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>marketType, [
        marketType
    ]);
    // Update the ChartProvider props to use memoized values
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$indicators$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartIndicatorsProvider"], {
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$context$2f$chart$2d$context$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ChartProvider"], {
            symbol: memoizedSymbol,
            timeFrame: memoizedTimeFrame,
            onPriceUpdate: handlePriceUpdate,
            onTimeFrameChange: handleInternalTimeFrameChange,
            darkMode: isDarkMode,
            orders: filteredOrders,
            expiryMinutes: memoizedExpiryMinutes,
            isMarketSwitching: memoizedIsMarketSwitching,
            onChartContextReady: handleChartContextReady,
            marketType: memoizedMarketType,
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative w-full h-full min-h-[400px]",
                style: {
                    height: "100%"
                },
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(MemoizedChartCanvas, {
                    positions: memoizedPositions
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/advanced-chart/index.tsx",
                    lineNumber: 198,
                    columnNumber: 11
                }, this)
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/advanced-chart/index.tsx",
                lineNumber: 197,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/frontend/components/blocks/advanced-chart/index.tsx",
            lineNumber: 185,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/advanced-chart/index.tsx",
        lineNumber: 184,
        columnNumber: 5
    }, this);
}
}),
"[project]/frontend/components/blocks/tradingview-chart/script-loader.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "TradingViewScriptLoader",
    ()=>TradingViewScriptLoader,
    "useTradingViewLoader",
    ()=>useTradingViewLoader
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"use client";
;
function TradingViewScriptLoader({ onLoad, onError }) {
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isLoaded, setIsLoaded] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [error, setError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Check if TradingView is already loaded
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
        // Check if script is already in DOM
        const existingScript = document.querySelector('script[src*="charting_library.standalone.js"]');
        if (existingScript) {
            // Wait for existing script to load
            existingScript.addEventListener('load', ()=>{
                setIsLoaded(true);
                onLoad?.();
            });
            existingScript.addEventListener('error', (e)=>{
                const error = new Error('Failed to load TradingView library');
                setError(error);
                onError?.(error);
            });
            return;
        }
        // Load the script dynamically
        setIsLoading(true);
        const script = document.createElement('script');
        script.src = '/lib/chart/charting_library/charting_library/charting_library.standalone.js';
        script.async = true;
        script.onload = ()=>{
            // Add a small delay to ensure the global object is fully initialized
            setTimeout(()=>{
                if (window.TradingView && window.TradingView.widget) {
                    setIsLoading(false);
                    setIsLoaded(true);
                    onLoad?.();
                } else {
                    setTimeout(()=>{
                        if (window.TradingView && window.TradingView.widget) {
                            setIsLoading(false);
                            setIsLoaded(true);
                            onLoad?.();
                        } else {
                            const error = new Error('TradingView widget not available');
                            setError(error);
                            onError?.(error);
                        }
                    }, 100);
                }
            }, 50);
        };
        script.onerror = (e)=>{
            setIsLoading(false);
            const error = new Error('Failed to load TradingView library');
            setError(error);
            onError?.(error);
        };
        document.head.appendChild(script);
        // Cleanup function
        return ()=>{
            if (script.parentNode) {
                script.parentNode.removeChild(script);
            }
        };
    }, [
        onLoad,
        onError
    ]);
    return null; // This component doesn't render anything
}
function useTradingViewLoader() {
    const [isLoaded, setIsLoaded] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [error, setError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        // Check if already loaded
        if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
        ;
        setIsLoading(true);
        const handleLoad = ()=>{
            // Add a small delay to ensure the global object is fully initialized
            setTimeout(()=>{
                if (window.TradingView && window.TradingView.widget) {
                    setIsLoading(false);
                    setIsLoaded(true);
                    setError(null);
                } else {
                    setTimeout(()=>{
                        if (window.TradingView && window.TradingView.widget) {
                            setIsLoading(false);
                            setIsLoaded(true);
                            setError(null);
                        } else {
                            handleError(new Error('TradingView widget not available'));
                        }
                    }, 100);
                }
            }, 50);
        };
        const handleError = (err)=>{
            setIsLoading(false);
            setError(err);
        };
        // Create a temporary component to handle loading
        const loader = document.createElement('div');
        document.body.appendChild(loader);
        // Use the script loader
        const script = document.createElement('script');
        script.src = '/lib/chart/charting_library/charting_library/charting_library.standalone.js';
        script.async = true;
        script.onload = handleLoad;
        script.onerror = ()=>handleError(new Error('Failed to load TradingView'));
        // Check if script already exists
        const existingScript = document.querySelector('script[src*="charting_library.standalone.js"]');
        if (!existingScript) {
            document.head.appendChild(script);
        } else {
            handleLoad();
        }
        return ()=>{
            document.body.removeChild(loader);
        };
    }, []);
    return {
        isLoaded,
        isLoading,
        error
    };
}
}),
"[project]/frontend/components/blocks/tradingview-chart/index.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "TradingViewChart",
    ()=>TradingViewChart
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-themes@1.0.0-beta.0_ne_fd389c5db48046672a7f720e88c0bc38/node_modules/next-themes/dist/index.module.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/trade/use-binary-store.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$tradingview$2d$chart$2f$script$2d$loader$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/tradingview-chart/script-loader.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$market$2d$data$2d$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/frontend/services/market-data-ws.ts [app-ssr] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$precision$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/precision-utils.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
;
;
;
// Resolution mapping for different providers
const resolutionMap = {
    "1m": "1",
    "3m": "3",
    "5m": "5",
    "15m": "15",
    "30m": "30",
    "1h": "60",
    "4h": "240",
    "6h": "360",
    "8h": "480",
    "12h": "720",
    "1d": "1D",
    "3d": "3D",
    "1w": "1W",
    "1M": "1M"
};
const resolutionMapProvider = {
    binance: {
        "1m": "1m",
        "3m": "3m",
        "5m": "5m",
        "15m": "15m",
        "30m": "30m",
        "1h": "1h",
        "4h": "4h",
        "6h": "6h",
        "8h": "8h",
        "12h": "12h",
        "1d": "1d",
        "3d": "3d",
        "1w": "1w",
        "1M": "1M"
    },
    kucoin: {
        "1m": "1min",
        "3m": "3min",
        "5m": "5min",
        "15m": "15min",
        "30m": "30min",
        "1h": "1hour",
        "4h": "4hour",
        "6h": "6hour",
        "8h": "8hour",
        "12h": "12hour",
        "1d": "1day",
        "3d": "3day",
        "1w": "1week",
        "1M": "1month"
    }
};
const supportedResolutionsProvider = {
    binance: [
        "1",
        "3",
        "5",
        "15",
        "30",
        "60",
        "120",
        "240",
        "360",
        "480",
        "720",
        "1D",
        "3D",
        "1W",
        "1M"
    ],
    kucoin: [
        "1",
        "3",
        "5",
        "15",
        "30",
        "60",
        "120",
        "240",
        "360",
        "480",
        "720",
        "1D",
        "3D",
        "1W",
        "1M"
    ]
};
const intervals = [
    "1",
    "3",
    "5",
    "15",
    "30",
    "60",
    "120",
    "240",
    "360",
    "480",
    "720",
    "1D",
    "3D",
    "1W",
    "1M"
];
const intervalDurations = {
    "1": 60000,
    "3": 180000,
    "5": 300000,
    "15": 900000,
    "30": 1800000,
    "60": 3600000,
    "120": 7200000,
    "240": 14400000,
    "360": 21600000,
    "480": 28800000,
    "720": 43200000,
    "1D": 86400000,
    "3D": 259200000,
    "1W": 604800000,
    "1M": 2629746000
};
const TradingViewChartBase = ({ symbol, timeFrame, onChartContextReady, showExpiry = false, expiryMinutes = 5, orders = [], marketType = "spot", onPriceUpdate, metadata })=>{
    const [chartReady, setChartReady] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    const [tvWidget, setTvWidget] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(null);
    const [provider, setProvider] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("binance");
    const [interval, setInterval] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])("1h");
    const subscribers = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])({});
    const { resolvedTheme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$themes$40$1$2e$0$2e$0$2d$beta$2e$0_ne_fd389c5db48046672a7f720e88c0bc38$2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$module$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTheme"])();
    const isDark = resolvedTheme === "dark";
    // Use the TradingView script loader
    const { isLoaded: isTradingViewLoaded, isLoading: isTradingViewLoading, error: tradingViewError } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$tradingview$2d$chart$2f$script$2d$loader$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTradingViewLoader"])();
    // Simple mobile detection using window width
    const [isMobile, setIsMobile] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(false);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const checkMobile = ()=>{
            setIsMobile(window.innerWidth <= 768);
        };
        checkMobile();
        window.addEventListener('resize', checkMobile);
        return ()=>window.removeEventListener('resize', checkMobile);
    }, []);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        switch("TURBOPACK compile-time value", "bin"){
            case "bin":
                setProvider("binance");
                break;
            case "kuc":
                setProvider("kucoin");
                break;
            default:
                setProvider("binance");
                break;
        }
    }, []);
    // TradingView disabled and enabled features
    const disabled_features = [
        "header_compare",
        "symbol_search_hot_key",
        "header_symbol_search",
        "border_around_the_chart",
        "popup_hints",
        "timezone_menu"
    ];
    const enabled_features = [
        "save_chart_properties_to_local_storage",
        "use_localstorage_for_settings",
        "dont_show_boolean_study_arguments",
        "hide_last_na_study_output",
        "constraint_dialogs_movement",
        "countdown",
        "insert_indicator_dialog_shortcut",
        "shift_visible_range_on_new_bar",
        "hide_image_invalid_symbol",
        "pre_post_market_sessions",
        "use_na_string_for_not_available_values",
        "create_volume_indicator_by_default",
        "determine_first_data_request_size_using_visible_range",
        "end_of_period_timescale_marks",
        "secondary_series_extend_time_scale",
        "shift_visible_range_on_new_bar"
    ];
    if (isMobile) {
        disabled_features.push("left_toolbar");
        disabled_features.push("header_fullscreen_button");
        disabled_features.push("timeframes_toolbar");
    } else {
        enabled_features.push("chart_style_hilo");
        enabled_features.push("chart_style_hilo_last_price");
        enabled_features.push("side_toolbar_in_fullscreen_mode");
    }
    const DataFeed = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useMemo"])(()=>{
        if (!symbol) return null;
        const isEco = marketType === "eco";
        const historyPath = isEco ? `/api/ecosystem/chart` : `/api/exchange/chart`;
        const pricescale = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$precision$2d$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getTradingViewPricescale"])(metadata);
        return {
            async onReady (callback) {
                setTimeout(()=>{
                    try {
                        callback({
                            exchanges: [],
                            symbols_types: [],
                            supported_resolutions: [
                                "1",
                                "3",
                                "5",
                                "15",
                                "30",
                                "60",
                                "240",
                                "360",
                                "480",
                                "720",
                                "1D",
                                "3D",
                                "1W",
                                "1M"
                            ]
                        });
                    } catch (error) {
                        console.error("TradingView onReady callback error:", error);
                    }
                }, 0);
            },
            async resolveSymbol (symbolName, onSymbolResolvedCallback, onResolveErrorCallback) {
                setTimeout(()=>{
                    try {
                        onSymbolResolvedCallback({
                            data_status: "streaming",
                            pricescale,
                            name: symbolName,
                            full_name: symbolName,
                            description: symbolName,
                            ticker: symbolName,
                            type: "crypto",
                            session: "24x7",
                            format: "price",
                            exchange: ("TURBOPACK compile-time value", "Bicrypto"),
                            listed_exchange: ("TURBOPACK compile-time value", "Bicrypto"),
                            timezone: "Etc/UTC",
                            volume_precision: 8,
                            supported_resolutions: [
                                "1",
                                "3",
                                "5",
                                "15",
                                "30",
                                "60",
                                "240",
                                "360",
                                "480",
                                "720",
                                "1D",
                                "3D",
                                "1W",
                                "1M"
                            ],
                            minmov: 1,
                            has_intraday: true,
                            visible_plots_set: false
                        });
                    } catch (error) {
                        console.error("TradingView resolveSymbol callback error:", error);
                        onResolveErrorCallback(error);
                    }
                }, 0);
            },
            async getBars (symbolInfo, resolution, periodParams, onHistoryCallback, onErrorCallback) {
                let from = periodParams.from * 1000; // Convert to milliseconds
                let to = periodParams.to * 1000; // Convert to milliseconds
                // Validate and clamp dates to prevent future date issues
                const now = Date.now();
                const maxHistoryDays = 365; // Maximum 1 year of history
                const minDate = now - maxHistoryDays * 24 * 60 * 60 * 1000;
                // Clamp 'to' to current time if it's in the future
                if (to > now) {
                    to = now;
                }
                // Clamp 'from' to minimum allowed date
                if (from < minDate) {
                    from = minDate;
                }
                // Ensure from is before to
                if (from >= to) {
                    from = to - 24 * 60 * 60 * 1000; // Set from to 1 day before to
                }
                // Map TradingView resolution to your API interval format
                const resolutionMap = {
                    "1": "1m",
                    "3": "3m",
                    "5": "5m",
                    "15": "15m",
                    "30": "30m",
                    "60": "1h",
                    "240": "4h",
                    "360": "6h",
                    "480": "8h",
                    "720": "12h",
                    "1D": "1d",
                    "3D": "3d",
                    "1W": "1w",
                    "1M": "1M"
                };
                const interval = resolutionMap[resolution] || "1h";
                // Format symbol for API call using proper base/quote extraction
                const formatSymbolForAPI = (symbol)=>{
                    // Add safety check for undefined/null symbol
                    if (!symbol || typeof symbol !== 'string') {
                        console.warn("Invalid symbol provided to TradingView formatSymbolForAPI:", symbol);
                        return "BTC/USDT"; // Default fallback
                    }
                    // Handle delimiter-based formats first: BTC/USDT, BTC-USDT, BTC_USDT
                    if (symbol.includes("/")) {
                        return symbol; // Already in API format
                    }
                    if (symbol.includes("-")) {
                        return symbol.replace("-", "/");
                    }
                    if (symbol.includes("_")) {
                        return symbol.replace("_", "/");
                    }
                    // For symbols without delimiters (like BTCUSDT), use the proper extraction logic
                    const baseCurrency = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["extractBaseCurrency"])(symbol);
                    const quoteCurrency = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["extractQuoteCurrency"])(symbol);
                    return `${baseCurrency}/${quoteCurrency}`;
                };
                const formattedSymbol = formatSymbolForAPI(symbol);
                try {
                    // Determine API endpoint based on market type
                    const apiEndpoint = marketType === "eco" ? "/api/ecosystem/chart" : marketType === "futures" ? "/api/futures/chart" : "/api/exchange/chart";
                    // Define duration mapping for the main exchange API
                    const intervalDurations = {
                        "1m": 60 * 1000,
                        "3m": 3 * 60 * 1000,
                        "5m": 5 * 60 * 1000,
                        "15m": 15 * 60 * 1000,
                        "30m": 30 * 60 * 1000,
                        "1h": 60 * 60 * 1000,
                        "4h": 4 * 60 * 60 * 1000,
                        "6h": 6 * 60 * 60 * 1000,
                        "8h": 8 * 60 * 60 * 1000,
                        "12h": 12 * 60 * 60 * 1000,
                        "1d": 24 * 60 * 60 * 1000,
                        "3d": 3 * 24 * 60 * 60 * 1000,
                        "1w": 7 * 24 * 60 * 60 * 1000,
                        "1M": 30 * 24 * 60 * 60 * 1000
                    };
                    // Use $fetch with proper error handling
                    const response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["$fetch"])({
                        url: apiEndpoint,
                        silent: true,
                        params: {
                            symbol: formattedSymbol,
                            interval: interval,
                            from: from,
                            to: to,
                            ...apiEndpoint === "/api/exchange/chart" && {
                                duration: intervalDurations[interval] || 60 * 60 * 1000
                            }
                        }
                    });
                    // Check if there was an error in the response
                    if (response.error) {
                        onHistoryCallback([], {
                            noData: true
                        });
                        return;
                    }
                    // Parse the data from the response
                    const data = response.data;
                    // Check if data was returned
                    if (!data || !Array.isArray(data) || data.length === 0) {
                        onHistoryCallback([], {
                            noData: true
                        });
                        return;
                    }
                    // Convert data to the format required by TradingView
                    const bars = data.map((item)=>({
                            time: item[0],
                            open: item[1],
                            high: item[2],
                            low: item[3],
                            close: item[4],
                            volume: item[5]
                        }));
                    // Sort the bars by time
                    bars.sort((a, b)=>a.time - b.time);
                    onHistoryCallback(bars);
                } catch (error) {
                    console.error("TradingView getBars error:", error);
                    // Return empty data instead of calling error callback to prevent TradingView errors
                    onHistoryCallback([], {
                        noData: true
                    });
                }
            },
            subscribeBars (symbolInfo, resolution, onRealtimeCallback, subscribeUID, onResetCacheNeededCallback) {
                // Map TradingView resolution to your API interval format
                const resolutionMap = {
                    "1": "1m",
                    "3": "3m",
                    "5": "5m",
                    "15": "15m",
                    "30": "30m",
                    "60": "1h",
                    "240": "4h",
                    "360": "6h",
                    "480": "8h",
                    "720": "12h",
                    "1D": "1d",
                    "3D": "3d",
                    "1W": "1w",
                    "1M": "1M"
                };
                const interval = resolutionMap[resolution] || "1h";
                // Format symbol for WebSocket subscription using proper base/quote extraction
                const formatSymbolForAPI = (symbol)=>{
                    // Add safety check for undefined/null symbol
                    if (!symbol || typeof symbol !== 'string') {
                        console.warn("Invalid symbol provided to TradingView WebSocket formatSymbolForAPI:", symbol);
                        return "BTC/USDT"; // Default fallback
                    }
                    // Handle delimiter-based formats first: BTC/USDT, BTC-USDT, BTC_USDT
                    if (symbol.includes("/")) {
                        return symbol; // Already in API format
                    }
                    if (symbol.includes("-")) {
                        return symbol.replace("-", "/");
                    }
                    if (symbol.includes("_")) {
                        return symbol.replace("_", "/");
                    }
                    // For symbols without delimiters (like BTCUSDT), use the proper extraction logic
                    const baseCurrency = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["extractBaseCurrency"])(symbol);
                    const quoteCurrency = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$trade$2f$use$2d$binary$2d$store$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["extractQuoteCurrency"])(symbol);
                    return `${baseCurrency}/${quoteCurrency}`;
                };
                const formattedSymbol = formatSymbolForAPI(symbolInfo.ticker);
                // Store subscriber info for real-time updates
                const subscriberInfo = {
                    callback: onRealtimeCallback,
                    symbolInfo: symbolInfo,
                    resolution: resolution,
                    interval: interval,
                    formattedSymbol: formattedSymbol,
                    unsubscribe: null
                };
                subscribers.current[subscribeUID] = subscriberInfo;
                // Subscribe to real-time OHLCV data using your WebSocket service
                try {
                    const unsubscribe = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$market$2d$data$2d$ws$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["marketDataWs"].subscribe({
                        symbol: formattedSymbol,
                        type: "ohlcv",
                        marketType: marketType || "spot",
                        interval: interval
                    }, (data)=>{
                        // Add comprehensive validation for TradingView WebSocket data
                        if (!data || typeof data !== 'object') {
                            console.warn("Invalid TradingView WebSocket data received:", data);
                            return;
                        }
                        // Validate stream property
                        if (!data.stream || typeof data.stream !== 'string') {
                            console.warn("Invalid TradingView WebSocket stream data:", data);
                            return;
                        }
                        // Validate data array
                        if (!Array.isArray(data.data) || data.data.length === 0) {
                            console.warn("Empty or invalid TradingView OHLCV data array:", data);
                            return;
                        }
                        const ohlcvData = data.data[0]; // Get the first (latest) candle
                        // Validate individual candle data
                        if (!Array.isArray(ohlcvData) || ohlcvData.length < 6) {
                            console.warn("Invalid TradingView candle data format:", ohlcvData);
                            return;
                        }
                        // Validate that all OHLCV values are numbers
                        const [timestamp, open, high, low, close, volume] = ohlcvData;
                        if (typeof timestamp !== 'number' || typeof open !== 'number' || typeof high !== 'number' || typeof low !== 'number' || typeof close !== 'number' || typeof volume !== 'number') {
                            console.warn("Invalid TradingView OHLCV data types:", ohlcvData);
                            return;
                        }
                        const bar = {
                            time: timestamp,
                            open: open,
                            high: high,
                            low: low,
                            close: close,
                            volume: volume
                        };
                        // Wrap onRealtimeCallback in try-catch to prevent TradingView errors
                        try {
                            onRealtimeCallback(bar);
                        } catch (callbackError) {
                            console.error("TradingView onRealtimeCallback error:", callbackError);
                        // Don't propagate the error to prevent TradingView library issues
                        }
                        // Update price callback if available
                        if (onPriceUpdate) {
                            onPriceUpdate(bar.close);
                        }
                    });
                    subscriberInfo.unsubscribe = unsubscribe;
                } catch (error) {
                // Silently handle subscription errors
                }
            },
            unsubscribeBars (subscriberUID) {
                const subscriber = subscribers.current[subscriberUID];
                if (!subscriber) return;
                // Unsubscribe from WebSocket if available
                if (subscriber.unsubscribe) {
                    subscriber.unsubscribe();
                }
                delete subscribers.current[subscriberUID];
            }
        };
    }, [
        symbol,
        marketType,
        onPriceUpdate
    ]);
    const handleBarsMessage = (message)=>{
        // Add comprehensive validation for TradingView message data
        if (!message || typeof message !== 'object') {
            console.warn("Invalid TradingView message received:", message);
            return;
        }
        const { data } = message;
        if (!Array.isArray(data) || data.length === 0) {
            console.warn("Invalid or empty TradingView message data:", data);
            return;
        }
        const bar = data[0];
        if (!Array.isArray(bar) || bar.length < 6) {
            console.warn("Invalid TradingView bar data format:", bar);
            return;
        }
        // Validate that all OHLCV values are numbers
        const [timestamp, open, high, low, close, volume] = bar;
        if (typeof timestamp !== 'number' || typeof open !== 'number' || typeof high !== 'number' || typeof low !== 'number' || typeof close !== 'number' || typeof volume !== 'number') {
            console.warn("Invalid TradingView bar data types:", bar);
            return;
        }
        const newBar = {
            time: timestamp.toString(),
            open: open,
            high: high,
            low: low,
            close: close,
            volume: volume
        };
        // Update price callback
        if (onPriceUpdate) {
            onPriceUpdate(newBar.close);
        }
        // Update subscribers
        Object.keys(subscribers.current).forEach((key)=>{
            const subscriber = subscribers.current[key];
            if (subscriber.callback) {
                subscriber.callback(newBar);
            }
        });
    };
    // Listen for market switching cleanup events
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const handleMarketSwitchingCleanup = (event)=>{
            const { oldSymbol, newSymbol, oldMarketType, newMarketType } = event.detail;
            // Unsubscribe all current subscribers
            Object.keys(subscribers.current).forEach((subscribeUID)=>{
                const subscriber = subscribers.current[subscribeUID];
                if (subscriber && subscriber.unsubscribe) {
                    subscriber.unsubscribe();
                }
                delete subscribers.current[subscribeUID];
            });
            // Clear subscribers
            subscribers.current = {};
        };
        window.addEventListener('market-switching-cleanup', handleMarketSwitchingCleanup);
        return ()=>{
            window.removeEventListener('market-switching-cleanup', handleMarketSwitchingCleanup);
        };
    }, []);
    // Track previous symbol to detect actual changes
    const prevSymbolRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])("");
    const prevMarketTypeRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])("");
    // Handle symbol changes - cleanup is handled by market-switching-cleanup event
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!symbol) return;
        // Update refs
        prevSymbolRef.current = symbol;
        prevMarketTypeRef.current = marketType;
    }, [
        symbol,
        marketType
    ]);
    async function initTradingView() {
        // Cleanup existing widget
        if (tvWidget) {
            try {
                tvWidget.remove();
            } catch (error) {
                console.warn("Error removing existing TradingView widget:", error);
            }
            setTvWidget(null);
        }
        if (!symbol || typeof symbol !== 'string') {
            console.error("Valid symbol is required for TradingView");
            return;
        }
        // Check if TradingView is loaded
        if (!window.TradingView || !window.TradingView.widget) {
            console.error("TradingView library not loaded");
            return;
        }
        // Symbol format is handled by the formatSymbolForAPI function in datafeed
        const datafeed = DataFeed;
        if (!datafeed) return;
        const widgetOptions = {
            fullscreen: false,
            autosize: true,
            symbol: symbol,
            interval: "60",
            container: "tv_chart_container",
            datafeed: datafeed,
            library_path: "/lib/chart/charting_library/charting_library/",
            locale: "en",
            theme: isDark ? "Dark" : "Light",
            timezone: "Etc/UTC",
            client_id: "chart",
            disabled_features: disabled_features,
            enabled_features: enabled_features,
            overrides: {
                "mainSeriesProperties.showCountdown": true,
                "highLowAvgPrice.highLowPriceLinesVisible": true,
                "mainSeriesProperties.highLowAvgPrice.highLowPriceLabelsVisible": true,
                "mainSeriesProperties.showPriceLine": true,
                "paneProperties.background": isDark ? "#18181b" : "#ffffff",
                "paneProperties.backgroundType": "solid"
            }
        };
        try {
            const tv = new window.TradingView.widget(widgetOptions);
            setTvWidget(tv);
            tv.onChartReady(()=>{
                try {
                    setChartReady(true);
                    if (onChartContextReady) {
                        onChartContextReady({
                            widget: tv,
                            symbol,
                            timeFrame,
                            theme: isDark ? "dark" : "light"
                        });
                    }
                } catch (error) {
                    console.error("TradingView onChartReady callback error:", error);
                }
            });
        } catch (error) {
            console.error("❌ Failed to create TradingView widget:", error);
        }
    }
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (symbol && isTradingViewLoaded) {
            initTradingView();
        }
    }, [
        symbol,
        isTradingViewLoaded
    ]);
    // Only change theme without reinitializing the entire widget
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (chartReady && tvWidget?._ready && typeof tvWidget.changeTheme === "function") {
            tvWidget.changeTheme(isDark ? "Dark" : "Light");
        }
    }, [
        isDark,
        chartReady,
        tvWidget
    ]);
    // Show loading state while TradingView is loading
    if (isTradingViewLoading) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "w-full h-full bg-black flex items-center justify-center",
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "text-center",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "animate-spin h-8 w-8 border-2 border-blue-500 border-t-transparent rounded-full mx-auto mb-4"
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                        lineNumber: 766,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "text-white text-sm",
                        children: "Loading TradingView..."
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                        lineNumber: 767,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                lineNumber: 765,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        }, void 0, false, {
            fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
            lineNumber: 764,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0));
    }
    // Show error state if TradingView failed to load
    if (tradingViewError) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "w-full h-full bg-black flex items-center justify-center",
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "text-center text-red-400",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "text-sm mb-2",
                        children: "Failed to load TradingView"
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                        lineNumber: 778,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "text-xs text-gray-500",
                        children: "Falling back to native chart..."
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                        lineNumber: 779,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                lineNumber: 777,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        }, void 0, false, {
            fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
            lineNumber: 776,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0));
    }
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "w-full h-full relative",
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                id: "tv_chart_container",
                className: "w-full h-full"
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                lineNumber: 787,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            !chartReady && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "absolute inset-0 bg-black flex items-center justify-center",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "animate-spin h-8 w-8 border-2 border-blue-500 border-t-transparent rounded-full"
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                    lineNumber: 791,
                    columnNumber: 11
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
                lineNumber: 790,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/blocks/tradingview-chart/index.tsx",
        lineNumber: 786,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
const TradingViewChart = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["memo"])(TradingViewChartBase);
}),
"[project]/frontend/components/blocks/chart-switcher/index.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>ChartSwitcher
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/config.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/advanced-chart/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$tradingview$2d$chart$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/tradingview-chart/index.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$tradingview$2d$chart$2f$script$2d$loader$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/blocks/tradingview-chart/script-loader.tsx [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
function ChartSwitcher({ symbol, timeFrame, orders = [], expiryMinutes = 5, showExpiry = true, timeframeDurations, positions, isMarketSwitching = false, onChartContextReady, marketType = "spot", onPriceUpdate, metadata }) {
    const { settings, settingsFetched, isLoading } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$config$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useConfigStore"])();
    const { isLoaded: isTradingViewLoaded, isLoading: isTradingViewLoading, error: tradingViewError } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$tradingview$2d$chart$2f$script$2d$loader$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useTradingViewLoader"])();
    // Wait for settings to be fetched before deciding which chart to load
    // This prevents loading the default chart and then switching to TradingView
    if (!settingsFetched) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "w-full h-full bg-background dark:bg-zinc-950 flex items-center justify-center",
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "text-center",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "animate-spin h-8 w-8 border-2 border-blue-500 border-t-transparent rounded-full mx-auto mb-4"
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                        lineNumber: 48,
                        columnNumber: 11
                    }, this),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "text-muted-foreground text-sm",
                        children: "Loading chart settings..."
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                        lineNumber: 49,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                lineNumber: 47,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
            lineNumber: 46,
            columnNumber: 7
        }, this);
    }
    // Only decide chart type after settings are fetched
    const chartType = settings?.chartType || "NATIVE";
    // If TradingView is selected but not loaded yet, show loading state
    if (chartType === "TRADINGVIEW") {
        // Show loading while TradingView script is loading
        if (isTradingViewLoading || !isTradingViewLoaded && !tradingViewError) {
            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "w-full h-full bg-background dark:bg-zinc-950 flex items-center justify-center",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "text-center",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "animate-spin h-8 w-8 border-2 border-blue-500 border-t-transparent rounded-full mx-auto mb-4"
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                            lineNumber: 65,
                            columnNumber: 13
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                            className: "text-muted-foreground text-sm",
                            children: "Loading TradingView chart..."
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                            lineNumber: 66,
                            columnNumber: 13
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                    lineNumber: 64,
                    columnNumber: 11
                }, this)
            }, void 0, false, {
                fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                lineNumber: 63,
                columnNumber: 9
            }, this);
        }
        // Show error state if TradingView failed to load
        if (tradingViewError) {
            console.error("TradingView failed to load, falling back to native chart:", tradingViewError);
        // Fall back to native chart on error
        } else if (isTradingViewLoaded) {
            // TradingView is loaded and ready
            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$tradingview$2d$chart$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["TradingViewChart"], {
                symbol: symbol,
                timeFrame: timeFrame,
                orders: orders,
                expiryMinutes: expiryMinutes,
                showExpiry: showExpiry,
                onChartContextReady: onChartContextReady,
                marketType: marketType,
                onPriceUpdate: onPriceUpdate,
                metadata: metadata,
                isMarketSwitching: isMarketSwitching
            }, `tradingview-${symbol}-${marketType}`, false, {
                fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
                lineNumber: 79,
                columnNumber: 9
            }, this);
        }
    }
    // Use native chart if selected or as fallback
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$blocks$2f$advanced$2d$chart$2f$index$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {
        symbol: symbol,
        timeFrame: timeFrame,
        orders: orders,
        expiryMinutes: expiryMinutes,
        showExpiry: showExpiry,
        timeframeDurations: timeframeDurations,
        positions: positions,
        isMarketSwitching: isMarketSwitching,
        onChartContextReady: onChartContextReady,
        marketType: marketType
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/chart-switcher/index.tsx",
        lineNumber: 98,
        columnNumber: 5
    }, this);
}
}),
"[project]/frontend/components/ui/skeleton.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Skeleton",
    ()=>Skeleton
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
;
;
function Skeleton({ className, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        "data-slot": "skeleton",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("bg-primary/10 animate-pulse rounded-md", className),
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/skeleton.tsx",
        lineNumber: 5,
        columnNumber: 5
    }, this);
}
;
}),
"[project]/frontend/components/ui/label.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Label",
    ()=>Label
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$label$40$2$2e$1$2e$7_09f91e68d1aa7e88903ab280c47fac6f$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$label$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@radix-ui+react-label@2.1.7_09f91e68d1aa7e88903ab280c47fac6f/node_modules/@radix-ui/react-label/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
function Label({ className, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$label$40$2$2e$1$2e$7_09f91e68d1aa7e88903ab280c47fac6f$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$label$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Root"], {
        "data-slot": "label",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex items-center gap-2 text-sm leading-none font-medium select-none group-data-[disabled=true]:pointer-events-none group-data-[disabled=true]:opacity-50 peer-disabled:cursor-not-allowed peer-disabled:opacity-50", className),
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/label.tsx",
        lineNumber: 13,
        columnNumber: 5
    }, this);
}
;
}),
"[project]/frontend/components/ui/select.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Select",
    ()=>Select,
    "SelectContent",
    ()=>SelectContent,
    "SelectGroup",
    ()=>SelectGroup,
    "SelectItem",
    ()=>SelectItem,
    "SelectLabel",
    ()=>SelectLabel,
    "SelectScrollDownButton",
    ()=>SelectScrollDownButton,
    "SelectScrollUpButton",
    ()=>SelectScrollUpButton,
    "SelectSeparator",
    ()=>SelectSeparator,
    "SelectTrigger",
    ()=>SelectTrigger,
    "SelectValue",
    ()=>SelectValue
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@radix-ui+react-select@2.2._53efa0e168fbbc448fc84f1a507d94dc/node_modules/@radix-ui/react-select/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$check$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckIcon$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/check.js [app-ssr] (ecmascript) <export default as CheckIcon>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDownIcon$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chevron-down.js [app-ssr] (ecmascript) <export default as ChevronDownIcon>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$up$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronUpIcon$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/chevron-up.js [app-ssr] (ecmascript) <export default as ChevronUpIcon>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-ssr] (ecmascript)");
"use client";
;
;
;
;
;
//
// Default ShadCN Select components
//
function Select({ ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Root"], {
        "data-slot": "select",
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 15,
        columnNumber: 10
    }, this);
}
function SelectGroup({ ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Group"], {
        "data-slot": "select-group",
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 21,
        columnNumber: 10
    }, this);
}
function SelectValue({ ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Value"], {
        "data-slot": "select-value",
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 27,
        columnNumber: 10
    }, this);
}
const SelectTrigger = /*#__PURE__*/ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["forwardRef"](({ className, children, icon, title, description, error, errorMessage, ...props }, ref)=>{
    const triggerClasses = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("border-input data-placeholder:text-muted-foreground [&_svg:not([class*='text-'])]:text-muted-foreground focus-visible:border-ring focus-visible:ring-ring/50 aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive flex h-9 w-fit items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm whitespace-nowrap shadow-2xs transition-[color,box-shadow] outline-hidden focus-visible:ring-[3px] disabled:cursor-not-allowed disabled:opacity-50", error && "border-2 border-red-500 focus:ring-red-500 focus:ring-2", className);
    const triggerElement = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Trigger"], {
        ref: ref,
        "data-slot": "select-trigger",
        className: triggerClasses,
        ...props,
        children: [
            children,
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Icon"], {
                asChild: true,
                children: icon ? icon : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDownIcon$3e$__["ChevronDownIcon"], {
                    className: "size-4 opacity-50"
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 80,
                    columnNumber: 26
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/select.tsx",
                lineNumber: 79,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 72,
        columnNumber: 7
    }, ("TURBOPACK compile-time value", void 0));
    if (title || description || error && errorMessage) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "flex flex-col",
            children: [
                title && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                    className: "mb-1 text-sm font-medium text-gray-700 dark:text-gray-200",
                    children: title
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 89,
                    columnNumber: 13
                }, ("TURBOPACK compile-time value", void 0)),
                triggerElement,
                description && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                    className: "mt-1 text-xs text-muted-foreground",
                    children: description
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 95,
                    columnNumber: 13
                }, ("TURBOPACK compile-time value", void 0)),
                error && errorMessage && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                    className: "text-red-500 text-sm mt-1 leading-normal",
                    children: errorMessage
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 98,
                    columnNumber: 13
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/components/ui/select.tsx",
            lineNumber: 87,
            columnNumber: 9
        }, ("TURBOPACK compile-time value", void 0));
    }
    return triggerElement;
});
SelectTrigger.displayName = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Trigger"].displayName;
//
// Default SelectContent and other components
//
// Note: We now destructure "search" so it doesn't get spread to the DOM.
function SelectContent({ className, children, position = "popper", search = false, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Portal"], {
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Content"], {
            "data-slot": "select-content",
            className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("bg-popover text-popover-foreground data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0 data-[state=closed]:zoom-out-95 data-[state=open]:zoom-in-95 data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 relative z-50 max-h-80 min-w-[8rem] overflow-auto rounded-md border shadow-md", position === "popper" && "data-[side=bottom]:translate-y-1 data-[side=left]:-translate-x-1 data-[side=right]:translate-x-1 data-[side=top]:-translate-y-1", className),
            position: position,
            onWheel: (e)=>e.stopPropagation(),
            ...props,
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(SelectScrollUpButton, {}, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 139,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Viewport"], {
                    className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("p-1", position === "popper" && "h-[var(--radix-select-trigger-height)] w-full min-w-[var(--radix-select-trigger-width)] scroll-my-1"),
                    onWheel: (e)=>e.stopPropagation(),
                    children: children
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 140,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(SelectScrollDownButton, {}, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 150,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/components/ui/select.tsx",
            lineNumber: 126,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 125,
        columnNumber: 5
    }, this);
}
function SelectLabel({ className, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Label"], {
        "data-slot": "select-label",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("px-2 py-1.5 text-sm font-medium", className),
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 161,
        columnNumber: 5
    }, this);
}
function SelectItem({ className, children, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Item"], {
        "data-slot": "select-item",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("focus:bg-accent focus:text-accent-foreground [&_svg:not([class*='text-'])]:text-muted-foreground relative flex w-full cursor-default items-center gap-2 rounded-sm py-1.5 pr-8 pl-2 text-sm outline-hidden select-none data-disabled:pointer-events-none data-disabled:opacity-50 [&_svg]:pointer-events-none [&_svg]:shrink-0 [&_svg:not([class*='size-'])]:size-4", className),
        ...props,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "absolute right-2 flex size-3.5 items-center justify-center",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ItemIndicator"], {
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$check$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckIcon$3e$__["CheckIcon"], {
                        className: "size-4"
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/ui/select.tsx",
                        lineNumber: 185,
                        columnNumber: 11
                    }, this)
                }, void 0, false, {
                    fileName: "[project]/frontend/components/ui/select.tsx",
                    lineNumber: 184,
                    columnNumber: 9
                }, this)
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/select.tsx",
                lineNumber: 183,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ItemText"], {
                children: children
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/select.tsx",
                lineNumber: 188,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 175,
        columnNumber: 5
    }, this);
}
function SelectSeparator({ className, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Separator"], {
        "data-slot": "select-separator",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("bg-border pointer-events-none -mx-1 my-1 h-px", className),
        ...props
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 198,
        columnNumber: 5
    }, this);
}
function SelectScrollUpButton({ className, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ScrollUpButton"], {
        "data-slot": "select-scroll-up-button",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex cursor-default items-center justify-center py-1", className),
        ...props,
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$up$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronUpIcon$3e$__["ChevronUpIcon"], {
            className: "size-4"
        }, void 0, false, {
            fileName: "[project]/frontend/components/ui/select.tsx",
            lineNumber: 219,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 211,
        columnNumber: 5
    }, this);
}
function SelectScrollDownButton({ className, ...props }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$radix$2d$ui$2b$react$2d$select$40$2$2e$2$2e$_53efa0e168fbbc448fc84f1a507d94dc$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$select$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ScrollDownButton"], {
        "data-slot": "select-scroll-down-button",
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["cn"])("flex cursor-default items-center justify-center py-1", className),
        ...props,
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDownIcon$3e$__["ChevronDownIcon"], {
            className: "size-4"
        }, void 0, false, {
            fileName: "[project]/frontend/components/ui/select.tsx",
            lineNumber: 237,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/frontend/components/ui/select.tsx",
        lineNumber: 229,
        columnNumber: 5
    }, this);
}
;
}),
"[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx [app-ssr] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>KycRequiredNotice
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/server/route-modules/app-page/vendored/ssr/react-jsx-dev-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/button.tsx [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$i18n$2f$routing$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/i18n/routing.ts [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shield$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Shield$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/shield.js [app-ssr] (ecmascript) <export default as Shield>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$lock$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Lock$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/lock.js [app-ssr] (ecmascript) <export default as Lock>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$circle$2d$check$2d$big$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckCircle$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/circle-check-big.js [app-ssr] (ecmascript) <export default as CheckCircle>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/react-client/index.js [app-ssr] (ecmascript) <locals>");
;
;
;
;
;
const FEATURE_MESSAGES = {
    // Trading features
    trade: {
        title: "Trading Access",
        description: "Start your trading journey with our secure and regulated platform. Complete verification to access real-time markets and advanced trading tools."
    },
    binary_trading: {
        title: "Binary Options Trading",
        description: "Unlock high-yield binary options trading with enhanced security measures. Verification ensures compliance with financial regulations."
    },
    futures_trading: {
        title: "Futures Trading",
        description: "Trade futures contracts with institutional-grade security. Verification ensures compliance with derivatives trading regulations."
    },
    view_forex: {
        title: "Forex Market Access",
        description: "Access live forex markets and real-time currency data. Verification is required for regulatory compliance in forex trading."
    },
    deposit_forex: {
        title: "Forex Deposits",
        description: "Fund your forex trading account securely. Identity verification protects against fraud and ensures secure transactions."
    },
    withdraw_forex: {
        title: "Forex Withdrawals",
        description: "Withdraw your forex profits safely and securely. Verification prevents unauthorized access to your funds."
    },
    // Wallet features
    view_wallets: {
        title: "Wallet Management",
        description: "Access your digital wallet portfolio with enhanced security. Verification protects your assets and transaction history."
    },
    deposit_wallet: {
        title: "Wallet Deposits",
        description: "Securely deposit funds into your digital wallets. Identity verification prevents money laundering and protects your account."
    },
    withdraw_wallet: {
        title: "Wallet Withdrawals",
        description: "Withdraw funds from your wallets with confidence. Verification ensures only you can access your digital assets."
    },
    transfer_wallets: {
        title: "Wallet Transfers",
        description: "Transfer funds between wallets securely. Verification prevents unauthorized transfers and protects your assets."
    },
    api_keys: {
        title: "API Access",
        description: "Generate and manage API keys for automated trading. Verification ensures secure programmatic access to your account."
    },
    // Content features
    author_blog: {
        title: "Content Creation",
        description: "Share your expertise and create valuable content. Verification establishes credibility and prevents spam."
    },
    comment_blog: {
        title: "Community Engagement",
        description: "Join discussions and engage with our community. Verification ensures authentic interactions and prevents abuse."
    },
    // E-commerce features
    view_ecommerce: {
        title: "Marketplace Access",
        description: "Browse our exclusive marketplace with verified products and services. Verification ensures a trusted shopping experience."
    },
    order_ecommerce: {
        title: "Marketplace Orders",
        description: "Purchase products and services securely. Verification protects both buyers and sellers in transactions."
    },
    // Investment features
    invest_forex: {
        title: "Forex Investments",
        description: "Invest in managed forex portfolios and strategies. Verification ensures compliance with investment regulations."
    },
    invest_general: {
        title: "Investment Opportunities",
        description: "Access exclusive investment products and portfolios. Verification is required for investor protection and compliance."
    },
    // ICO features
    view_ico: {
        title: "ICO Marketplace",
        description: "Explore initial coin offerings and token sales. Verification ensures access to legitimate and compliant projects."
    },
    purchase_ico: {
        title: "ICO Participation",
        description: "Participate in token sales and ICO investments. Verification is required for regulatory compliance and investor protection."
    },
    create_ico: {
        title: "ICO Creation",
        description: "Launch your own token sale or ICO project. Verification ensures legitimacy and builds investor confidence."
    },
    affiliate_mlm: {
        title: "Affiliate Program",
        description: "Join our affiliate network and earn commissions. Verification ensures legitimate partnerships and prevents fraud."
    },
    // Staking features
    view_staking: {
        title: "Staking Opportunities",
        description: "Explore cryptocurrency staking rewards and opportunities. Verification ensures secure access to staking protocols."
    },
    invest_staking: {
        title: "Staking Investments",
        description: "Stake your cryptocurrencies and earn rewards. Verification protects your staked assets and ensures legitimate participation."
    },
    // P2P features
    make_p2p_offer: {
        title: "P2P Trading",
        description: "Create peer-to-peer trading offers. Verification builds trust with other traders and ensures secure transactions."
    },
    buy_p2p_offer: {
        title: "P2P Purchases",
        description: "Buy from peer-to-peer offers safely. Verification protects against fraud and ensures legitimate transactions."
    },
    // Support features
    ask_faq: {
        title: "Advanced Support",
        description: "Access our comprehensive FAQ and knowledge base. Verification provides personalized support experiences."
    },
    support_ticket: {
        title: "Priority Support",
        description: "Get priority customer support and assistance. Verification ensures secure communication and account protection."
    }
};
function KycRequiredNotice({ feature }) {
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("components/blocks/kyc/kyc-required-notice");
    const featureInfo = feature ? FEATURE_MESSAGES[feature] : null;
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "flex flex-col items-center justify-center h-full py-12 px-4",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "relative",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "absolute inset-0 bg-gradient-to-r from-blue-500/20 to-purple-500/20 rounded-full blur-3xl w-64 h-64 -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2"
                }, void 0, false, {
                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                    lineNumber: 172,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "relative bg-background/80 backdrop-blur-sm border border-border/50 rounded-2xl p-8 max-w-lg mx-auto shadow-2xl",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex justify-center mb-6",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "relative",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "bg-gradient-to-r from-blue-500 to-purple-600 p-4 rounded-full",
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shield$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Shield$3e$__["Shield"], {
                                            className: "w-8 h-8 text-white"
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 180,
                                            columnNumber: 17
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                        lineNumber: 179,
                                        columnNumber: 15
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "absolute -top-1 -right-1 bg-yellow-500 rounded-full p-1",
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$lock$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__Lock$3e$__["Lock"], {
                                            className: "w-3 h-3 text-white"
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 183,
                                            columnNumber: 17
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                        lineNumber: 182,
                                        columnNumber: 15
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                lineNumber: 178,
                                columnNumber: 13
                            }, this)
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                            lineNumber: 177,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "text-center mb-6",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("h2", {
                                    className: "text-3xl font-bold bg-gradient-to-r from-gray-900 to-gray-600 dark:from-white dark:to-gray-300 bg-clip-text text-transparent mb-2",
                                    children: featureInfo ? featureInfo.title : "Verification Required"
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 190,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-16 h-1 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full mx-auto"
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 193,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                            lineNumber: 189,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "text-center mb-8",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                className: "text-muted-foreground leading-relaxed",
                                children: featureInfo ? featureInfo.description : "Complete our quick and secure verification process to access all premium features and enhanced security."
                            }, void 0, false, {
                                fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                lineNumber: 198,
                                columnNumber: 13
                            }, this)
                        }, void 0, false, {
                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                            lineNumber: 197,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "space-y-3 mb-8",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex items-center gap-3 text-sm",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$circle$2d$check$2d$big$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckCircle$3e$__["CheckCircle"], {
                                            className: "w-4 h-4 text-green-500 flex-shrink-0"
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 208,
                                            columnNumber: 15
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "text-muted-foreground",
                                            children: t("enhanced_account_security")
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 209,
                                            columnNumber: 15
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 207,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex items-center gap-3 text-sm",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$circle$2d$check$2d$big$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckCircle$3e$__["CheckCircle"], {
                                            className: "w-4 h-4 text-green-500 flex-shrink-0"
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 214,
                                            columnNumber: 15
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "text-muted-foreground",
                                            children: t("regulatory_compliance")
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 215,
                                            columnNumber: 15
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 213,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex items-center gap-3 text-sm",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$circle$2d$check$2d$big$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckCircle$3e$__["CheckCircle"], {
                                            className: "w-4 h-4 text-green-500 flex-shrink-0"
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 220,
                                            columnNumber: 15
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                            className: "text-muted-foreground",
                                            children: t("fraud_protection")
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                            lineNumber: 221,
                                            columnNumber: 15
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 219,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                            lineNumber: 206,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "text-center",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$i18n$2f$routing$2e$ts__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Link"], {
                                    href: "/user/kyc",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Button"], {
                                        size: "lg",
                                        className: "bg-gradient-to-r from-blue-500 to-purple-600 hover:from-blue-600 hover:to-purple-700 text-white font-semibold px-8 py-3 rounded-xl shadow-lg hover:shadow-xl transition-all duration-200 transform hover:scale-105",
                                        children: t("complete_verification")
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                        lineNumber: 230,
                                        columnNumber: 15
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 229,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$server$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                    className: "text-xs text-muted-foreground mt-3",
                                    children: t("usually_takes_2-3_minutes")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                                    lineNumber: 237,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                            lineNumber: 228,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
                    lineNumber: 175,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
            lineNumber: 170,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/frontend/components/blocks/kyc/kyc-required-notice.tsx",
        lineNumber: 169,
        columnNumber: 5
    }, this);
}
}),
];

//# sourceMappingURL=frontend_components_08bee9b0._.js.map