(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getAction = getAction;
function getAction(client, actionFn, name) {
    const action_implicit = client[actionFn.name];
    if (typeof action_implicit === 'function') return action_implicit;
    const action_explicit = client[name];
    if (typeof action_explicit === 'function') return action_explicit;
    return (params)=>actionFn(client, params);
} //# sourceMappingURL=getAction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatAbiItem = formatAbiItem;
exports.formatAbiParams = formatAbiParams;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
function formatAbiItem(abiItem) {
    let { includeName = false } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (abiItem.type !== 'function' && abiItem.type !== 'event' && abiItem.type !== 'error') throw new abi_js_1.InvalidDefinitionTypeError(abiItem.type);
    return "".concat(abiItem.name, "(").concat(formatAbiParams(abiItem.inputs, {
        includeName
    }), ")");
}
function formatAbiParams(params) {
    let { includeName = false } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (!params) return '';
    return params.map((param)=>formatAbiParam(param, {
            includeName
        })).join(includeName ? ', ' : ',');
}
function formatAbiParam(param, param1) {
    let { includeName } = param1;
    if (param.type.startsWith('tuple')) {
        return "(".concat(formatAbiParams(param.components, {
            includeName
        }), ")").concat(param.type.slice('tuple'.length));
    }
    return param.type + (includeName && param.name ? " ".concat(param.name) : '');
} //# sourceMappingURL=formatAbiItem.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isHex = isHex;
function isHex(value) {
    let { strict = true } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (!value) return false;
    if (typeof value !== 'string') return false;
    return strict ? /^0x[0-9a-fA-F]*$/.test(value) : value.startsWith('0x');
} //# sourceMappingURL=isHex.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.size = size;
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
function size(value) {
    if ((0, isHex_js_1.isHex)(value, {
        strict: false
    })) return Math.ceil((value.length - 2) / 2);
    return value.length;
} //# sourceMappingURL=size.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/version.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.version = void 0;
exports.version = '2.38.6'; //# sourceMappingURL=version.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BaseError = void 0;
exports.setErrorConfig = setErrorConfig;
const version_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/version.js [app-client] (ecmascript)");
let errorConfig = {
    getDocsUrl: (param)=>{
        let { docsBaseUrl, docsPath = '', docsSlug } = param;
        return docsPath ? "".concat(docsBaseUrl !== null && docsBaseUrl !== void 0 ? docsBaseUrl : 'https://viem.sh').concat(docsPath).concat(docsSlug ? "#".concat(docsSlug) : '') : undefined;
    },
    version: "viem@".concat(version_js_1.version)
};
function setErrorConfig(config) {
    errorConfig = config;
}
class BaseError extends Error {
    walk(fn) {
        return walk(this, fn);
    }
    constructor(shortMessage, args = {}){
        var _errorConfig_getDocsUrl;
        const details = (()=>{
            var _args_cause;
            if (args.cause instanceof BaseError) return args.cause.details;
            if ((_args_cause = args.cause) === null || _args_cause === void 0 ? void 0 : _args_cause.message) return args.cause.message;
            return args.details;
        })();
        const docsPath = (()=>{
            if (args.cause instanceof BaseError) return args.cause.docsPath || args.docsPath;
            return args.docsPath;
        })();
        const docsUrl = (_errorConfig_getDocsUrl = errorConfig.getDocsUrl) === null || _errorConfig_getDocsUrl === void 0 ? void 0 : _errorConfig_getDocsUrl.call(errorConfig, {
            ...args,
            docsPath
        });
        const message = [
            shortMessage || 'An error occurred.',
            '',
            ...args.metaMessages ? [
                ...args.metaMessages,
                ''
            ] : [],
            ...docsUrl ? [
                "Docs: ".concat(docsUrl)
            ] : [],
            ...details ? [
                "Details: ".concat(details)
            ] : [],
            ...errorConfig.version ? [
                "Version: ".concat(errorConfig.version)
            ] : []
        ].join('\n');
        super(message, args.cause ? {
            cause: args.cause
        } : undefined);
        Object.defineProperty(this, "details", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "docsPath", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "metaMessages", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "shortMessage", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "version", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'BaseError'
        });
        this.details = details;
        this.docsPath = docsPath;
        this.metaMessages = args.metaMessages;
        var _args_name;
        this.name = (_args_name = args.name) !== null && _args_name !== void 0 ? _args_name : this.name;
        this.shortMessage = shortMessage;
        this.version = version_js_1.version;
    }
}
exports.BaseError = BaseError;
function walk(err, fn) {
    if (fn === null || fn === void 0 ? void 0 : fn(err)) return err;
    if (err && typeof err === 'object' && 'cause' in err && err.cause !== undefined) return walk(err.cause, fn);
    return fn ? null : err;
} //# sourceMappingURL=base.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.UnsupportedPackedAbiType = exports.InvalidDefinitionTypeError = exports.InvalidArrayError = exports.InvalidAbiDecodingTypeError = exports.InvalidAbiEncodingTypeError = exports.DecodeLogTopicsMismatch = exports.DecodeLogDataMismatch = exports.BytesSizeMismatchError = exports.AbiItemAmbiguityError = exports.AbiFunctionSignatureNotFoundError = exports.AbiFunctionOutputsNotFoundError = exports.AbiFunctionNotFoundError = exports.AbiEventNotFoundError = exports.AbiEventSignatureNotFoundError = exports.AbiEventSignatureEmptyTopicsError = exports.AbiErrorSignatureNotFoundError = exports.AbiErrorNotFoundError = exports.AbiErrorInputsNotFoundError = exports.AbiEncodingLengthMismatchError = exports.AbiEncodingBytesSizeMismatchError = exports.AbiEncodingArrayLengthMismatchError = exports.AbiDecodingZeroDataError = exports.AbiDecodingDataSizeTooSmallError = exports.AbiDecodingDataSizeInvalidError = exports.AbiConstructorParamsNotFoundError = exports.AbiConstructorNotFoundError = void 0;
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class AbiConstructorNotFoundError extends base_js_1.BaseError {
    constructor({ docsPath }){
        super([
            'A constructor was not found on the ABI.',
            'Make sure you are using the correct ABI and that the constructor exists on it.'
        ].join('\n'), {
            docsPath,
            name: 'AbiConstructorNotFoundError'
        });
    }
}
exports.AbiConstructorNotFoundError = AbiConstructorNotFoundError;
class AbiConstructorParamsNotFoundError extends base_js_1.BaseError {
    constructor({ docsPath }){
        super([
            'Constructor arguments were provided (`args`), but a constructor parameters (`inputs`) were not found on the ABI.',
            'Make sure you are using the correct ABI, and that the `inputs` attribute on the constructor exists.'
        ].join('\n'), {
            docsPath,
            name: 'AbiConstructorParamsNotFoundError'
        });
    }
}
exports.AbiConstructorParamsNotFoundError = AbiConstructorParamsNotFoundError;
class AbiDecodingDataSizeInvalidError extends base_js_1.BaseError {
    constructor({ data, size }){
        super([
            "Data size of ".concat(size, " bytes is invalid."),
            'Size must be in increments of 32 bytes (size % 32 === 0).'
        ].join('\n'), {
            metaMessages: [
                "Data: ".concat(data, " (").concat(size, " bytes)")
            ],
            name: 'AbiDecodingDataSizeInvalidError'
        });
    }
}
exports.AbiDecodingDataSizeInvalidError = AbiDecodingDataSizeInvalidError;
class AbiDecodingDataSizeTooSmallError extends base_js_1.BaseError {
    constructor({ data, params, size }){
        super([
            "Data size of ".concat(size, " bytes is too small for given parameters.")
        ].join('\n'), {
            metaMessages: [
                "Params: (".concat((0, formatAbiItem_js_1.formatAbiParams)(params, {
                    includeName: true
                }), ")"),
                "Data:   ".concat(data, " (").concat(size, " bytes)")
            ],
            name: 'AbiDecodingDataSizeTooSmallError'
        });
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "params", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "size", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.data = data;
        this.params = params;
        this.size = size;
    }
}
exports.AbiDecodingDataSizeTooSmallError = AbiDecodingDataSizeTooSmallError;
class AbiDecodingZeroDataError extends base_js_1.BaseError {
    constructor(){
        super('Cannot decode zero data ("0x") with ABI parameters.', {
            name: 'AbiDecodingZeroDataError'
        });
    }
}
exports.AbiDecodingZeroDataError = AbiDecodingZeroDataError;
class AbiEncodingArrayLengthMismatchError extends base_js_1.BaseError {
    constructor({ expectedLength, givenLength, type }){
        super([
            "ABI encoding array length mismatch for type ".concat(type, "."),
            "Expected length: ".concat(expectedLength),
            "Given length: ".concat(givenLength)
        ].join('\n'), {
            name: 'AbiEncodingArrayLengthMismatchError'
        });
    }
}
exports.AbiEncodingArrayLengthMismatchError = AbiEncodingArrayLengthMismatchError;
class AbiEncodingBytesSizeMismatchError extends base_js_1.BaseError {
    constructor({ expectedSize, value }){
        super('Size of bytes "'.concat(value, '" (bytes').concat((0, size_js_1.size)(value), ") does not match expected size (bytes").concat(expectedSize, ")."), {
            name: 'AbiEncodingBytesSizeMismatchError'
        });
    }
}
exports.AbiEncodingBytesSizeMismatchError = AbiEncodingBytesSizeMismatchError;
class AbiEncodingLengthMismatchError extends base_js_1.BaseError {
    constructor({ expectedLength, givenLength }){
        super([
            'ABI encoding params/values length mismatch.',
            "Expected length (params): ".concat(expectedLength),
            "Given length (values): ".concat(givenLength)
        ].join('\n'), {
            name: 'AbiEncodingLengthMismatchError'
        });
    }
}
exports.AbiEncodingLengthMismatchError = AbiEncodingLengthMismatchError;
class AbiErrorInputsNotFoundError extends base_js_1.BaseError {
    constructor(errorName, { docsPath }){
        super([
            'Arguments (`args`) were provided to "'.concat(errorName, '", but "').concat(errorName, '" on the ABI does not contain any parameters (`inputs`).'),
            'Cannot encode error result without knowing what the parameter types are.',
            'Make sure you are using the correct ABI and that the inputs exist on it.'
        ].join('\n'), {
            docsPath,
            name: 'AbiErrorInputsNotFoundError'
        });
    }
}
exports.AbiErrorInputsNotFoundError = AbiErrorInputsNotFoundError;
class AbiErrorNotFoundError extends base_js_1.BaseError {
    constructor(errorName, { docsPath } = {}){
        super([
            "Error ".concat(errorName ? '"'.concat(errorName, '" ') : '', "not found on ABI."),
            'Make sure you are using the correct ABI and that the error exists on it.'
        ].join('\n'), {
            docsPath,
            name: 'AbiErrorNotFoundError'
        });
    }
}
exports.AbiErrorNotFoundError = AbiErrorNotFoundError;
class AbiErrorSignatureNotFoundError extends base_js_1.BaseError {
    constructor(signature, { docsPath }){
        super([
            'Encoded error signature "'.concat(signature, '" not found on ABI.'),
            'Make sure you are using the correct ABI and that the error exists on it.',
            "You can look up the decoded signature here: https://openchain.xyz/signatures?query=".concat(signature, ".")
        ].join('\n'), {
            docsPath,
            name: 'AbiErrorSignatureNotFoundError'
        });
        Object.defineProperty(this, "signature", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.signature = signature;
    }
}
exports.AbiErrorSignatureNotFoundError = AbiErrorSignatureNotFoundError;
class AbiEventSignatureEmptyTopicsError extends base_js_1.BaseError {
    constructor({ docsPath }){
        super('Cannot extract event signature from empty topics.', {
            docsPath,
            name: 'AbiEventSignatureEmptyTopicsError'
        });
    }
}
exports.AbiEventSignatureEmptyTopicsError = AbiEventSignatureEmptyTopicsError;
class AbiEventSignatureNotFoundError extends base_js_1.BaseError {
    constructor(signature, { docsPath }){
        super([
            'Encoded event signature "'.concat(signature, '" not found on ABI.'),
            'Make sure you are using the correct ABI and that the event exists on it.',
            "You can look up the signature here: https://openchain.xyz/signatures?query=".concat(signature, ".")
        ].join('\n'), {
            docsPath,
            name: 'AbiEventSignatureNotFoundError'
        });
    }
}
exports.AbiEventSignatureNotFoundError = AbiEventSignatureNotFoundError;
class AbiEventNotFoundError extends base_js_1.BaseError {
    constructor(eventName, { docsPath } = {}){
        super([
            "Event ".concat(eventName ? '"'.concat(eventName, '" ') : '', "not found on ABI."),
            'Make sure you are using the correct ABI and that the event exists on it.'
        ].join('\n'), {
            docsPath,
            name: 'AbiEventNotFoundError'
        });
    }
}
exports.AbiEventNotFoundError = AbiEventNotFoundError;
class AbiFunctionNotFoundError extends base_js_1.BaseError {
    constructor(functionName, { docsPath } = {}){
        super([
            "Function ".concat(functionName ? '"'.concat(functionName, '" ') : '', "not found on ABI."),
            'Make sure you are using the correct ABI and that the function exists on it.'
        ].join('\n'), {
            docsPath,
            name: 'AbiFunctionNotFoundError'
        });
    }
}
exports.AbiFunctionNotFoundError = AbiFunctionNotFoundError;
class AbiFunctionOutputsNotFoundError extends base_js_1.BaseError {
    constructor(functionName, { docsPath }){
        super([
            'Function "'.concat(functionName, '" does not contain any `outputs` on ABI.'),
            'Cannot decode function result without knowing what the parameter types are.',
            'Make sure you are using the correct ABI and that the function exists on it.'
        ].join('\n'), {
            docsPath,
            name: 'AbiFunctionOutputsNotFoundError'
        });
    }
}
exports.AbiFunctionOutputsNotFoundError = AbiFunctionOutputsNotFoundError;
class AbiFunctionSignatureNotFoundError extends base_js_1.BaseError {
    constructor(signature, { docsPath }){
        super([
            'Encoded function signature "'.concat(signature, '" not found on ABI.'),
            'Make sure you are using the correct ABI and that the function exists on it.',
            "You can look up the signature here: https://openchain.xyz/signatures?query=".concat(signature, ".")
        ].join('\n'), {
            docsPath,
            name: 'AbiFunctionSignatureNotFoundError'
        });
    }
}
exports.AbiFunctionSignatureNotFoundError = AbiFunctionSignatureNotFoundError;
class AbiItemAmbiguityError extends base_js_1.BaseError {
    constructor(x, y){
        super('Found ambiguous types in overloaded ABI items.', {
            metaMessages: [
                "`".concat(x.type, "` in `").concat((0, formatAbiItem_js_1.formatAbiItem)(x.abiItem), "`, and"),
                "`".concat(y.type, "` in `").concat((0, formatAbiItem_js_1.formatAbiItem)(y.abiItem), "`"),
                '',
                'These types encode differently and cannot be distinguished at runtime.',
                'Remove one of the ambiguous items in the ABI.'
            ],
            name: 'AbiItemAmbiguityError'
        });
    }
}
exports.AbiItemAmbiguityError = AbiItemAmbiguityError;
class BytesSizeMismatchError extends base_js_1.BaseError {
    constructor({ expectedSize, givenSize }){
        super("Expected bytes".concat(expectedSize, ", got bytes").concat(givenSize, "."), {
            name: 'BytesSizeMismatchError'
        });
    }
}
exports.BytesSizeMismatchError = BytesSizeMismatchError;
class DecodeLogDataMismatch extends base_js_1.BaseError {
    constructor({ abiItem, data, params, size }){
        super([
            "Data size of ".concat(size, " bytes is too small for non-indexed event parameters.")
        ].join('\n'), {
            metaMessages: [
                "Params: (".concat((0, formatAbiItem_js_1.formatAbiParams)(params, {
                    includeName: true
                }), ")"),
                "Data:   ".concat(data, " (").concat(size, " bytes)")
            ],
            name: 'DecodeLogDataMismatch'
        });
        Object.defineProperty(this, "abiItem", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "params", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "size", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.abiItem = abiItem;
        this.data = data;
        this.params = params;
        this.size = size;
    }
}
exports.DecodeLogDataMismatch = DecodeLogDataMismatch;
class DecodeLogTopicsMismatch extends base_js_1.BaseError {
    constructor({ abiItem, param }){
        super([
            "Expected a topic for indexed event parameter".concat(param.name ? ' "'.concat(param.name, '"') : '', ' on event "').concat((0, formatAbiItem_js_1.formatAbiItem)(abiItem, {
                includeName: true
            }), '".')
        ].join('\n'), {
            name: 'DecodeLogTopicsMismatch'
        });
        Object.defineProperty(this, "abiItem", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.abiItem = abiItem;
    }
}
exports.DecodeLogTopicsMismatch = DecodeLogTopicsMismatch;
class InvalidAbiEncodingTypeError extends base_js_1.BaseError {
    constructor(type, { docsPath }){
        super([
            'Type "'.concat(type, '" is not a valid encoding type.'),
            'Please provide a valid ABI type.'
        ].join('\n'), {
            docsPath,
            name: 'InvalidAbiEncodingType'
        });
    }
}
exports.InvalidAbiEncodingTypeError = InvalidAbiEncodingTypeError;
class InvalidAbiDecodingTypeError extends base_js_1.BaseError {
    constructor(type, { docsPath }){
        super([
            'Type "'.concat(type, '" is not a valid decoding type.'),
            'Please provide a valid ABI type.'
        ].join('\n'), {
            docsPath,
            name: 'InvalidAbiDecodingType'
        });
    }
}
exports.InvalidAbiDecodingTypeError = InvalidAbiDecodingTypeError;
class InvalidArrayError extends base_js_1.BaseError {
    constructor(value){
        super([
            'Value "'.concat(value, '" is not a valid array.')
        ].join('\n'), {
            name: 'InvalidArrayError'
        });
    }
}
exports.InvalidArrayError = InvalidArrayError;
class InvalidDefinitionTypeError extends base_js_1.BaseError {
    constructor(type){
        super([
            '"'.concat(type, '" is not a valid definition type.'),
            'Valid types: "function", "event", "error"'
        ].join('\n'), {
            name: 'InvalidDefinitionTypeError'
        });
    }
}
exports.InvalidDefinitionTypeError = InvalidDefinitionTypeError;
class UnsupportedPackedAbiType extends base_js_1.BaseError {
    constructor(type){
        super('Type "'.concat(type, '" is not supported for packed encoding.'), {
            name: 'UnsupportedPackedAbiType'
        });
    }
}
exports.UnsupportedPackedAbiType = UnsupportedPackedAbiType; //# sourceMappingURL=abi.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/log.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FilterTypeNotSupportedError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class FilterTypeNotSupportedError extends base_js_1.BaseError {
    constructor(type){
        super('Filter type "'.concat(type, '" is not supported.'), {
            name: 'FilterTypeNotSupportedError'
        });
    }
}
exports.FilterTypeNotSupportedError = FilterTypeNotSupportedError; //# sourceMappingURL=log.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/data.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InvalidBytesLengthError = exports.SizeExceedsPaddingSizeError = exports.SliceOffsetOutOfBoundsError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class SliceOffsetOutOfBoundsError extends base_js_1.BaseError {
    constructor({ offset, position, size }){
        super("Slice ".concat(position === 'start' ? 'starting' : 'ending', ' at offset "').concat(offset, '" is out-of-bounds (size: ').concat(size, ")."), {
            name: 'SliceOffsetOutOfBoundsError'
        });
    }
}
exports.SliceOffsetOutOfBoundsError = SliceOffsetOutOfBoundsError;
class SizeExceedsPaddingSizeError extends base_js_1.BaseError {
    constructor({ size, targetSize, type }){
        super("".concat(type.charAt(0).toUpperCase()).concat(type.slice(1).toLowerCase(), " size (").concat(size, ") exceeds padding size (").concat(targetSize, ")."), {
            name: 'SizeExceedsPaddingSizeError'
        });
    }
}
exports.SizeExceedsPaddingSizeError = SizeExceedsPaddingSizeError;
class InvalidBytesLengthError extends base_js_1.BaseError {
    constructor({ size, targetSize, type }){
        super("".concat(type.charAt(0).toUpperCase()).concat(type.slice(1).toLowerCase(), " is expected to be ").concat(targetSize, " ").concat(type, " long, but is ").concat(size, " ").concat(type, " long."), {
            name: 'InvalidBytesLengthError'
        });
    }
}
exports.InvalidBytesLengthError = InvalidBytesLengthError; //# sourceMappingURL=data.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.pad = pad;
exports.padHex = padHex;
exports.padBytes = padBytes;
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/data.js [app-client] (ecmascript)");
function pad(hexOrBytes) {
    let { dir, size = 32 } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof hexOrBytes === 'string') return padHex(hexOrBytes, {
        dir,
        size
    });
    return padBytes(hexOrBytes, {
        dir,
        size
    });
}
function padHex(hex_) {
    let { dir, size = 32 } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (size === null) return hex_;
    const hex = hex_.replace('0x', '');
    if (hex.length > size * 2) throw new data_js_1.SizeExceedsPaddingSizeError({
        size: Math.ceil(hex.length / 2),
        targetSize: size,
        type: 'hex'
    });
    return "0x".concat(hex[dir === 'right' ? 'padEnd' : 'padStart'](size * 2, '0'));
}
function padBytes(bytes) {
    let { dir, size = 32 } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (size === null) return bytes;
    if (bytes.length > size) throw new data_js_1.SizeExceedsPaddingSizeError({
        size: bytes.length,
        targetSize: size,
        type: 'bytes'
    });
    const paddedBytes = new Uint8Array(size);
    for(let i = 0; i < size; i++){
        const padEnd = dir === 'right';
        paddedBytes[padEnd ? i : size - i - 1] = bytes[padEnd ? i : bytes.length - i - 1];
    }
    return paddedBytes;
} //# sourceMappingURL=pad.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/encoding.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SizeOverflowError = exports.InvalidHexValueError = exports.InvalidHexBooleanError = exports.InvalidBytesBooleanError = exports.IntegerOutOfRangeError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class IntegerOutOfRangeError extends base_js_1.BaseError {
    constructor({ max, min, signed, size, value }){
        super('Number "'.concat(value, '" is not in safe ').concat(size ? "".concat(size * 8, "-bit ").concat(signed ? 'signed' : 'unsigned', " ") : '', "integer range ").concat(max ? "(".concat(min, " to ").concat(max, ")") : "(above ".concat(min, ")")), {
            name: 'IntegerOutOfRangeError'
        });
    }
}
exports.IntegerOutOfRangeError = IntegerOutOfRangeError;
class InvalidBytesBooleanError extends base_js_1.BaseError {
    constructor(bytes){
        super('Bytes value "'.concat(bytes, '" is not a valid boolean. The bytes array must contain a single byte of either a 0 or 1 value.'), {
            name: 'InvalidBytesBooleanError'
        });
    }
}
exports.InvalidBytesBooleanError = InvalidBytesBooleanError;
class InvalidHexBooleanError extends base_js_1.BaseError {
    constructor(hex){
        super('Hex value "'.concat(hex, '" is not a valid boolean. The hex value must be "0x0" (false) or "0x1" (true).'), {
            name: 'InvalidHexBooleanError'
        });
    }
}
exports.InvalidHexBooleanError = InvalidHexBooleanError;
class InvalidHexValueError extends base_js_1.BaseError {
    constructor(value){
        super('Hex value "'.concat(value, '" is an odd length (').concat(value.length, "). It must be an even length."), {
            name: 'InvalidHexValueError'
        });
    }
}
exports.InvalidHexValueError = InvalidHexValueError;
class SizeOverflowError extends base_js_1.BaseError {
    constructor({ givenSize, maxSize }){
        super("Size cannot exceed ".concat(maxSize, " bytes. Given size: ").concat(givenSize, " bytes."), {
            name: 'SizeOverflowError'
        });
    }
}
exports.SizeOverflowError = SizeOverflowError; //# sourceMappingURL=encoding.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.trim = trim;
function trim(hexOrBytes) {
    let { dir = 'left' } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let data = typeof hexOrBytes === 'string' ? hexOrBytes.replace('0x', '') : hexOrBytes;
    let sliceLength = 0;
    for(let i = 0; i < data.length - 1; i++){
        if (data[dir === 'left' ? i : data.length - i - 1].toString() === '0') sliceLength++;
        else break;
    }
    data = dir === 'left' ? data.slice(sliceLength) : data.slice(0, data.length - sliceLength);
    if (typeof hexOrBytes === 'string') {
        if (data.length === 1 && dir === 'right') data = "".concat(data, "0");
        return "0x".concat(data.length % 2 === 1 ? "0".concat(data) : data);
    }
    return data;
} //# sourceMappingURL=trim.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.assertSize = assertSize;
exports.fromHex = fromHex;
exports.hexToBigInt = hexToBigInt;
exports.hexToBool = hexToBool;
exports.hexToNumber = hexToNumber;
exports.hexToString = hexToString;
const encoding_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/encoding.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
function assertSize(hexOrBytes, param) {
    let { size } = param;
    if ((0, size_js_1.size)(hexOrBytes) > size) throw new encoding_js_1.SizeOverflowError({
        givenSize: (0, size_js_1.size)(hexOrBytes),
        maxSize: size
    });
}
function fromHex(hex, toOrOpts) {
    const opts = typeof toOrOpts === 'string' ? {
        to: toOrOpts
    } : toOrOpts;
    const to = opts.to;
    if (to === 'number') return hexToNumber(hex, opts);
    if (to === 'bigint') return hexToBigInt(hex, opts);
    if (to === 'string') return hexToString(hex, opts);
    if (to === 'boolean') return hexToBool(hex, opts);
    return (0, toBytes_js_1.hexToBytes)(hex, opts);
}
function hexToBigInt(hex) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { signed } = opts;
    if (opts.size) assertSize(hex, {
        size: opts.size
    });
    const value = BigInt(hex);
    if (!signed) return value;
    const size = (hex.length - 2) / 2;
    const max = (1n << BigInt(size) * 8n - 1n) - 1n;
    if (value <= max) return value;
    return value - BigInt("0x".concat('f'.padStart(size * 2, 'f'))) - 1n;
}
function hexToBool(hex_) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let hex = hex_;
    if (opts.size) {
        assertSize(hex, {
            size: opts.size
        });
        hex = (0, trim_js_1.trim)(hex);
    }
    if ((0, trim_js_1.trim)(hex) === '0x00') return false;
    if ((0, trim_js_1.trim)(hex) === '0x01') return true;
    throw new encoding_js_1.InvalidHexBooleanError(hex);
}
function hexToNumber(hex) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return Number(hexToBigInt(hex, opts));
}
function hexToString(hex) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let bytes = (0, toBytes_js_1.hexToBytes)(hex);
    if (opts.size) {
        assertSize(bytes, {
            size: opts.size
        });
        bytes = (0, trim_js_1.trim)(bytes, {
            dir: 'right'
        });
    }
    return new TextDecoder().decode(bytes);
} //# sourceMappingURL=fromHex.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toHex = toHex;
exports.boolToHex = boolToHex;
exports.bytesToHex = bytesToHex;
exports.numberToHex = numberToHex;
exports.stringToHex = stringToHex;
const encoding_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/encoding.js [app-client] (ecmascript)");
const pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const hexes = Array.from({
    length: 256
}, (_v, i)=>i.toString(16).padStart(2, '0'));
function toHex(value) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof value === 'number' || typeof value === 'bigint') return numberToHex(value, opts);
    if (typeof value === 'string') {
        return stringToHex(value, opts);
    }
    if (typeof value === 'boolean') return boolToHex(value, opts);
    return bytesToHex(value, opts);
}
function boolToHex(value) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const hex = "0x".concat(Number(value));
    if (typeof opts.size === 'number') {
        (0, fromHex_js_1.assertSize)(hex, {
            size: opts.size
        });
        return (0, pad_js_1.pad)(hex, {
            size: opts.size
        });
    }
    return hex;
}
function bytesToHex(value) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let string = '';
    for(let i = 0; i < value.length; i++){
        string += hexes[value[i]];
    }
    const hex = "0x".concat(string);
    if (typeof opts.size === 'number') {
        (0, fromHex_js_1.assertSize)(hex, {
            size: opts.size
        });
        return (0, pad_js_1.pad)(hex, {
            dir: 'right',
            size: opts.size
        });
    }
    return hex;
}
function numberToHex(value_) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { signed, size } = opts;
    const value = BigInt(value_);
    let maxValue;
    if (size) {
        if (signed) maxValue = (1n << BigInt(size) * 8n - 1n) - 1n;
        else maxValue = 2n ** (BigInt(size) * 8n) - 1n;
    } else if (typeof value_ === 'number') {
        maxValue = BigInt(Number.MAX_SAFE_INTEGER);
    }
    const minValue = typeof maxValue === 'bigint' && signed ? -maxValue - 1n : 0;
    if (maxValue && value > maxValue || value < minValue) {
        const suffix = typeof value_ === 'bigint' ? 'n' : '';
        throw new encoding_js_1.IntegerOutOfRangeError({
            max: maxValue ? "".concat(maxValue).concat(suffix) : undefined,
            min: "".concat(minValue).concat(suffix),
            signed,
            size,
            value: "".concat(value_).concat(suffix)
        });
    }
    const hex = "0x".concat((signed && value < 0 ? (1n << BigInt(size * 8)) + BigInt(value) : value).toString(16));
    if (size) return (0, pad_js_1.pad)(hex, {
        size
    });
    return hex;
}
const encoder = new TextEncoder();
function stringToHex(value_) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const value = encoder.encode(value_);
    return bytesToHex(value, opts);
} //# sourceMappingURL=toHex.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toBytes = toBytes;
exports.boolToBytes = boolToBytes;
exports.hexToBytes = hexToBytes;
exports.numberToBytes = numberToBytes;
exports.stringToBytes = stringToBytes;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const encoder = new TextEncoder();
function toBytes(value) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof value === 'number' || typeof value === 'bigint') return numberToBytes(value, opts);
    if (typeof value === 'boolean') return boolToBytes(value, opts);
    if ((0, isHex_js_1.isHex)(value)) return hexToBytes(value, opts);
    return stringToBytes(value, opts);
}
function boolToBytes(value) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const bytes = new Uint8Array(1);
    bytes[0] = Number(value);
    if (typeof opts.size === 'number') {
        (0, fromHex_js_1.assertSize)(bytes, {
            size: opts.size
        });
        return (0, pad_js_1.pad)(bytes, {
            size: opts.size
        });
    }
    return bytes;
}
const charCodeMap = {
    zero: 48,
    nine: 57,
    A: 65,
    F: 70,
    a: 97,
    f: 102
};
function charCodeToBase16(char) {
    if (char >= charCodeMap.zero && char <= charCodeMap.nine) return char - charCodeMap.zero;
    if (char >= charCodeMap.A && char <= charCodeMap.F) return char - (charCodeMap.A - 10);
    if (char >= charCodeMap.a && char <= charCodeMap.f) return char - (charCodeMap.a - 10);
    return undefined;
}
function hexToBytes(hex_) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let hex = hex_;
    if (opts.size) {
        (0, fromHex_js_1.assertSize)(hex, {
            size: opts.size
        });
        hex = (0, pad_js_1.pad)(hex, {
            dir: 'right',
            size: opts.size
        });
    }
    let hexString = hex.slice(2);
    if (hexString.length % 2) hexString = "0".concat(hexString);
    const length = hexString.length / 2;
    const bytes = new Uint8Array(length);
    for(let index = 0, j = 0; index < length; index++){
        const nibbleLeft = charCodeToBase16(hexString.charCodeAt(j++));
        const nibbleRight = charCodeToBase16(hexString.charCodeAt(j++));
        if (nibbleLeft === undefined || nibbleRight === undefined) {
            throw new base_js_1.BaseError('Invalid byte sequence ("'.concat(hexString[j - 2]).concat(hexString[j - 1], '" in "').concat(hexString, '").'));
        }
        bytes[index] = nibbleLeft * 16 + nibbleRight;
    }
    return bytes;
}
function numberToBytes(value, opts) {
    const hex = (0, toHex_js_1.numberToHex)(value, opts);
    return hexToBytes(hex);
}
function stringToBytes(value) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const bytes = encoder.encode(value);
    if (typeof opts.size === 'number') {
        (0, fromHex_js_1.assertSize)(bytes, {
            size: opts.size
        });
        return (0, pad_js_1.pad)(bytes, {
            dir: 'right',
            size: opts.size
        });
    }
    return bytes;
} //# sourceMappingURL=toBytes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.keccak256 = keccak256;
const sha3_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/sha3.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function keccak256(value, to_) {
    const to = to_ || 'hex';
    const bytes = (0, sha3_1.keccak_256)((0, isHex_js_1.isHex)(value, {
        strict: false
    }) ? (0, toBytes_js_1.toBytes)(value) : value);
    if (to === 'bytes') return bytes;
    return (0, toHex_js_1.toHex)(bytes);
} //# sourceMappingURL=keccak256.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/hashSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.hashSignature = hashSignature;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const hash = (value)=>(0, keccak256_js_1.keccak256)((0, toBytes_js_1.toBytes)(value));
function hashSignature(sig) {
    return hash(sig);
} //# sourceMappingURL=hashSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/normalizeSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.normalizeSignature = normalizeSignature;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
function normalizeSignature(signature) {
    let active = true;
    let current = '';
    let level = 0;
    let result = '';
    let valid = false;
    for(let i = 0; i < signature.length; i++){
        const char = signature[i];
        if ([
            '(',
            ')',
            ','
        ].includes(char)) active = true;
        if (char === '(') level++;
        if (char === ')') level--;
        if (!active) continue;
        if (level === 0) {
            if (char === ' ' && [
                'event',
                'function',
                ''
            ].includes(result)) result = '';
            else {
                result += char;
                if (char === ')') {
                    valid = true;
                    break;
                }
            }
            continue;
        }
        if (char === ' ') {
            if (signature[i - 1] !== ',' && current !== ',' && current !== ',(') {
                current = '';
                active = false;
            }
            continue;
        }
        result += char;
        current += char;
    }
    if (!valid) throw new base_js_1.BaseError('Unable to normalize signature.');
    return result;
} //# sourceMappingURL=normalizeSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toSignature = void 0;
const abitype_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/cjs/exports/index.js [app-client] (ecmascript)");
const normalizeSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/normalizeSignature.js [app-client] (ecmascript)");
const toSignature = (def)=>{
    const def_ = (()=>{
        if (typeof def === 'string') return def;
        return (0, abitype_1.formatAbiItem)(def);
    })();
    return (0, normalizeSignature_js_1.normalizeSignature)(def_);
};
exports.toSignature = toSignature; //# sourceMappingURL=toSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignatureHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toSignatureHash = toSignatureHash;
const hashSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/hashSignature.js [app-client] (ecmascript)");
const toSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignature.js [app-client] (ecmascript)");
function toSignatureHash(fn) {
    return (0, hashSignature_js_1.hashSignature)((0, toSignature_js_1.toSignature)(fn));
} //# sourceMappingURL=toSignatureHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSelector.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toEventSelector = void 0;
const toSignatureHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignatureHash.js [app-client] (ecmascript)");
exports.toEventSelector = toSignatureHash_js_1.toSignatureHash; //# sourceMappingURL=toEventSelector.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InvalidAddressError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class InvalidAddressError extends base_js_1.BaseError {
    constructor({ address }){
        super('Address "'.concat(address, '" is invalid.'), {
            metaMessages: [
                '- Address must be a hex value of 20 bytes (40 hex characters).',
                '- Address must match its checksum counterpart.'
            ],
            name: 'InvalidAddressError'
        });
    }
}
exports.InvalidAddressError = InvalidAddressError; //# sourceMappingURL=address.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LruMap = void 0;
class LruMap extends Map {
    get(key) {
        const value = super.get(key);
        if (super.has(key) && value !== undefined) {
            this.delete(key);
            super.set(key, value);
        }
        return value;
    }
    set(key, value) {
        super.set(key, value);
        if (this.maxSize && this.size > this.maxSize) {
            const firstKey = this.keys().next().value;
            if (firstKey) this.delete(firstKey);
        }
        return this;
    }
    constructor(size){
        super();
        Object.defineProperty(this, "maxSize", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.maxSize = size;
    }
}
exports.LruMap = LruMap; //# sourceMappingURL=lru.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.checksumAddress = checksumAddress;
exports.getAddress = getAddress;
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const lru_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const checksumAddressCache = new lru_js_1.LruMap(8192);
function checksumAddress(address_, chainId) {
    if (checksumAddressCache.has("".concat(address_, ".").concat(chainId))) return checksumAddressCache.get("".concat(address_, ".").concat(chainId));
    const hexAddress = chainId ? "".concat(chainId).concat(address_.toLowerCase()) : address_.substring(2).toLowerCase();
    const hash = (0, keccak256_js_1.keccak256)((0, toBytes_js_1.stringToBytes)(hexAddress), 'bytes');
    const address = (chainId ? hexAddress.substring("".concat(chainId, "0x").length) : hexAddress).split('');
    for(let i = 0; i < 40; i += 2){
        if (hash[i >> 1] >> 4 >= 8 && address[i]) {
            address[i] = address[i].toUpperCase();
        }
        if ((hash[i >> 1] & 0x0f) >= 8 && address[i + 1]) {
            address[i + 1] = address[i + 1].toUpperCase();
        }
    }
    const result = "0x".concat(address.join(''));
    checksumAddressCache.set("".concat(address_, ".").concat(chainId), result);
    return result;
}
function getAddress(address, chainId) {
    if (!(0, isAddress_js_1.isAddress)(address, {
        strict: false
    })) throw new address_js_1.InvalidAddressError({
        address
    });
    return checksumAddress(address, chainId);
} //# sourceMappingURL=getAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isAddressCache = void 0;
exports.isAddress = isAddress;
const lru_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)");
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const addressRegex = /^0x[a-fA-F0-9]{40}$/;
exports.isAddressCache = new lru_js_1.LruMap(8192);
function isAddress(address, options) {
    const { strict = true } = options !== null && options !== void 0 ? options : {};
    const cacheKey = "".concat(address, ".").concat(strict);
    if (exports.isAddressCache.has(cacheKey)) return exports.isAddressCache.get(cacheKey);
    const result = (()=>{
        if (!addressRegex.test(address)) return false;
        if (address.toLowerCase() === address) return true;
        if (strict) return (0, getAddress_js_1.checksumAddress)(address) === address;
        return true;
    })();
    exports.isAddressCache.set(cacheKey, result);
    return result;
} //# sourceMappingURL=isAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.concat = concat;
exports.concatBytes = concatBytes;
exports.concatHex = concatHex;
function concat(values) {
    if (typeof values[0] === 'string') return concatHex(values);
    return concatBytes(values);
}
function concatBytes(values) {
    let length = 0;
    for (const arr of values){
        length += arr.length;
    }
    const result = new Uint8Array(length);
    let offset = 0;
    for (const arr of values){
        result.set(arr, offset);
        offset += arr.length;
    }
    return result;
}
function concatHex(values) {
    return "0x".concat(values.reduce((acc, x)=>acc + x.replace('0x', ''), ''));
} //# sourceMappingURL=concat.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.slice = slice;
exports.sliceBytes = sliceBytes;
exports.sliceHex = sliceHex;
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/data.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
function slice(value, start, end) {
    let { strict } = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : {};
    if ((0, isHex_js_1.isHex)(value, {
        strict: false
    })) return sliceHex(value, start, end, {
        strict
    });
    return sliceBytes(value, start, end, {
        strict
    });
}
function assertStartOffset(value, start) {
    if (typeof start === 'number' && start > 0 && start > (0, size_js_1.size)(value) - 1) throw new data_js_1.SliceOffsetOutOfBoundsError({
        offset: start,
        position: 'start',
        size: (0, size_js_1.size)(value)
    });
}
function assertEndOffset(value, start, end) {
    if (typeof start === 'number' && typeof end === 'number' && (0, size_js_1.size)(value) !== end - start) {
        throw new data_js_1.SliceOffsetOutOfBoundsError({
            offset: end,
            position: 'end',
            size: (0, size_js_1.size)(value)
        });
    }
}
function sliceBytes(value_, start, end) {
    let { strict } = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : {};
    assertStartOffset(value_, start);
    const value = value_.slice(start, end);
    if (strict) assertEndOffset(value, start, end);
    return value;
}
function sliceHex(value_, start, end) {
    let { strict } = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : {};
    assertStartOffset(value_, start);
    const value = "0x".concat(value_.replace('0x', '').slice((start !== null && start !== void 0 ? start : 0) * 2, (end !== null && end !== void 0 ? end : value_.length) * 2));
    if (strict) assertEndOffset(value, start, end);
    return value;
} //# sourceMappingURL=slice.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/regex.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.integerRegex = exports.bytesRegex = exports.arrayRegex = void 0;
exports.arrayRegex = /^(.*)\[([0-9]*)\]$/;
exports.bytesRegex = /^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/;
exports.integerRegex = /^(u?int)(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/; //# sourceMappingURL=regex.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeAbiParameters = encodeAbiParameters;
exports.getArrayComponents = getArrayComponents;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const encoding_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/encoding.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const regex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/regex.js [app-client] (ecmascript)");
function encodeAbiParameters(params, values) {
    if (params.length !== values.length) throw new abi_js_1.AbiEncodingLengthMismatchError({
        expectedLength: params.length,
        givenLength: values.length
    });
    const preparedParams = prepareParams({
        params: params,
        values: values
    });
    const data = encodeParams(preparedParams);
    if (data.length === 0) return '0x';
    return data;
}
function prepareParams(param) {
    let { params, values } = param;
    const preparedParams = [];
    for(let i = 0; i < params.length; i++){
        preparedParams.push(prepareParam({
            param: params[i],
            value: values[i]
        }));
    }
    return preparedParams;
}
function prepareParam(param) {
    let { param: param1, value } = param;
    const arrayComponents = getArrayComponents(param1.type);
    if (arrayComponents) {
        const [length, type] = arrayComponents;
        return encodeArray(value, {
            length,
            param: {
                ...param1,
                type
            }
        });
    }
    if (param1.type === 'tuple') {
        return encodeTuple(value, {
            param: param1
        });
    }
    if (param1.type === 'address') {
        return encodeAddress(value);
    }
    if (param1.type === 'bool') {
        return encodeBool(value);
    }
    if (param1.type.startsWith('uint') || param1.type.startsWith('int')) {
        const signed = param1.type.startsWith('int');
        var _regex_js_1_integerRegex_exec;
        const [, , size = '256'] = (_regex_js_1_integerRegex_exec = regex_js_1.integerRegex.exec(param1.type)) !== null && _regex_js_1_integerRegex_exec !== void 0 ? _regex_js_1_integerRegex_exec : [];
        return encodeNumber(value, {
            signed,
            size: Number(size)
        });
    }
    if (param1.type.startsWith('bytes')) {
        return encodeBytes(value, {
            param: param1
        });
    }
    if (param1.type === 'string') {
        return encodeString(value);
    }
    throw new abi_js_1.InvalidAbiEncodingTypeError(param1.type, {
        docsPath: '/docs/contract/encodeAbiParameters'
    });
}
function encodeParams(preparedParams) {
    let staticSize = 0;
    for(let i = 0; i < preparedParams.length; i++){
        const { dynamic, encoded } = preparedParams[i];
        if (dynamic) staticSize += 32;
        else staticSize += (0, size_js_1.size)(encoded);
    }
    const staticParams = [];
    const dynamicParams = [];
    let dynamicSize = 0;
    for(let i = 0; i < preparedParams.length; i++){
        const { dynamic, encoded } = preparedParams[i];
        if (dynamic) {
            staticParams.push((0, toHex_js_1.numberToHex)(staticSize + dynamicSize, {
                size: 32
            }));
            dynamicParams.push(encoded);
            dynamicSize += (0, size_js_1.size)(encoded);
        } else {
            staticParams.push(encoded);
        }
    }
    return (0, concat_js_1.concat)([
        ...staticParams,
        ...dynamicParams
    ]);
}
function encodeAddress(value) {
    if (!(0, isAddress_js_1.isAddress)(value)) throw new address_js_1.InvalidAddressError({
        address: value
    });
    return {
        dynamic: false,
        encoded: (0, pad_js_1.padHex)(value.toLowerCase())
    };
}
function encodeArray(value, param) {
    let { length, param: param1 } = param;
    const dynamic = length === null;
    if (!Array.isArray(value)) throw new abi_js_1.InvalidArrayError(value);
    if (!dynamic && value.length !== length) throw new abi_js_1.AbiEncodingArrayLengthMismatchError({
        expectedLength: length,
        givenLength: value.length,
        type: "".concat(param1.type, "[").concat(length, "]")
    });
    let dynamicChild = false;
    const preparedParams = [];
    for(let i = 0; i < value.length; i++){
        const preparedParam = prepareParam({
            param: param1,
            value: value[i]
        });
        if (preparedParam.dynamic) dynamicChild = true;
        preparedParams.push(preparedParam);
    }
    if (dynamic || dynamicChild) {
        const data = encodeParams(preparedParams);
        if (dynamic) {
            const length = (0, toHex_js_1.numberToHex)(preparedParams.length, {
                size: 32
            });
            return {
                dynamic: true,
                encoded: preparedParams.length > 0 ? (0, concat_js_1.concat)([
                    length,
                    data
                ]) : length
            };
        }
        if (dynamicChild) return {
            dynamic: true,
            encoded: data
        };
    }
    return {
        dynamic: false,
        encoded: (0, concat_js_1.concat)(preparedParams.map((param)=>{
            let { encoded } = param;
            return encoded;
        }))
    };
}
function encodeBytes(value, param) {
    let { param: param1 } = param;
    const [, paramSize] = param1.type.split('bytes');
    const bytesSize = (0, size_js_1.size)(value);
    if (!paramSize) {
        let value_ = value;
        if (bytesSize % 32 !== 0) value_ = (0, pad_js_1.padHex)(value_, {
            dir: 'right',
            size: Math.ceil((value.length - 2) / 2 / 32) * 32
        });
        return {
            dynamic: true,
            encoded: (0, concat_js_1.concat)([
                (0, pad_js_1.padHex)((0, toHex_js_1.numberToHex)(bytesSize, {
                    size: 32
                })),
                value_
            ])
        };
    }
    if (bytesSize !== Number.parseInt(paramSize, 10)) throw new abi_js_1.AbiEncodingBytesSizeMismatchError({
        expectedSize: Number.parseInt(paramSize, 10),
        value
    });
    return {
        dynamic: false,
        encoded: (0, pad_js_1.padHex)(value, {
            dir: 'right'
        })
    };
}
function encodeBool(value) {
    if (typeof value !== 'boolean') throw new base_js_1.BaseError('Invalid boolean value: "'.concat(value, '" (type: ').concat(typeof value, "). Expected: `true` or `false`."));
    return {
        dynamic: false,
        encoded: (0, pad_js_1.padHex)((0, toHex_js_1.boolToHex)(value))
    };
}
function encodeNumber(value, param) {
    let { signed, size = 256 } = param;
    if (typeof size === 'number') {
        const max = 2n ** (BigInt(size) - (signed ? 1n : 0n)) - 1n;
        const min = signed ? -max - 1n : 0n;
        if (value > max || value < min) throw new encoding_js_1.IntegerOutOfRangeError({
            max: max.toString(),
            min: min.toString(),
            signed,
            size: size / 8,
            value: value.toString()
        });
    }
    return {
        dynamic: false,
        encoded: (0, toHex_js_1.numberToHex)(value, {
            size: 32,
            signed
        })
    };
}
function encodeString(value) {
    const hexValue = (0, toHex_js_1.stringToHex)(value);
    const partsLength = Math.ceil((0, size_js_1.size)(hexValue) / 32);
    const parts = [];
    for(let i = 0; i < partsLength; i++){
        parts.push((0, pad_js_1.padHex)((0, slice_js_1.slice)(hexValue, i * 32, (i + 1) * 32), {
            dir: 'right'
        }));
    }
    return {
        dynamic: true,
        encoded: (0, concat_js_1.concat)([
            (0, pad_js_1.padHex)((0, toHex_js_1.numberToHex)((0, size_js_1.size)(hexValue), {
                size: 32
            })),
            ...parts
        ])
    };
}
function encodeTuple(value, param) {
    let { param: param1 } = param;
    let dynamic = false;
    const preparedParams = [];
    for(let i = 0; i < param1.components.length; i++){
        const param_ = param1.components[i];
        const index = Array.isArray(value) ? i : param_.name;
        const preparedParam = prepareParam({
            param: param_,
            value: value[index]
        });
        preparedParams.push(preparedParam);
        if (preparedParam.dynamic) dynamic = true;
    }
    return {
        dynamic,
        encoded: dynamic ? encodeParams(preparedParams) : (0, concat_js_1.concat)(preparedParams.map((param)=>{
            let { encoded } = param;
            return encoded;
        }))
    };
}
function getArrayComponents(type) {
    const matches = type.match(/^(.*)\[(\d+)?\]$/);
    return matches ? [
        matches[2] ? Number(matches[2]) : null,
        matches[1]
    ] : undefined;
} //# sourceMappingURL=encodeAbiParameters.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toFunctionSelector = void 0;
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const toSignatureHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignatureHash.js [app-client] (ecmascript)");
const toFunctionSelector = (fn)=>(0, slice_js_1.slice)((0, toSignatureHash_js_1.toSignatureHash)(fn), 0, 4);
exports.toFunctionSelector = toFunctionSelector; //# sourceMappingURL=toFunctionSelector.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getAbiItem = getAbiItem;
exports.isArgOfType = isArgOfType;
exports.getAmbiguousTypes = getAmbiguousTypes;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const toEventSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSelector.js [app-client] (ecmascript)");
const toFunctionSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)");
function getAbiItem(parameters) {
    const { abi, args = [], name } = parameters;
    const isSelector = (0, isHex_js_1.isHex)(name, {
        strict: false
    });
    const abiItems = abi.filter((abiItem)=>{
        if (isSelector) {
            if (abiItem.type === 'function') return (0, toFunctionSelector_js_1.toFunctionSelector)(abiItem) === name;
            if (abiItem.type === 'event') return (0, toEventSelector_js_1.toEventSelector)(abiItem) === name;
            return false;
        }
        return 'name' in abiItem && abiItem.name === name;
    });
    if (abiItems.length === 0) return undefined;
    if (abiItems.length === 1) return abiItems[0];
    let matchedAbiItem;
    for (const abiItem of abiItems){
        if (!('inputs' in abiItem)) continue;
        if (!args || args.length === 0) {
            if (!abiItem.inputs || abiItem.inputs.length === 0) return abiItem;
            continue;
        }
        if (!abiItem.inputs) continue;
        if (abiItem.inputs.length === 0) continue;
        if (abiItem.inputs.length !== args.length) continue;
        const matched = args.every((arg, index)=>{
            const abiParameter = 'inputs' in abiItem && abiItem.inputs[index];
            if (!abiParameter) return false;
            return isArgOfType(arg, abiParameter);
        });
        if (matched) {
            if (matchedAbiItem && 'inputs' in matchedAbiItem && matchedAbiItem.inputs) {
                const ambiguousTypes = getAmbiguousTypes(abiItem.inputs, matchedAbiItem.inputs, args);
                if (ambiguousTypes) throw new abi_js_1.AbiItemAmbiguityError({
                    abiItem,
                    type: ambiguousTypes[0]
                }, {
                    abiItem: matchedAbiItem,
                    type: ambiguousTypes[1]
                });
            }
            matchedAbiItem = abiItem;
        }
    }
    if (matchedAbiItem) return matchedAbiItem;
    return abiItems[0];
}
function isArgOfType(arg, abiParameter) {
    const argType = typeof arg;
    const abiParameterType = abiParameter.type;
    switch(abiParameterType){
        case 'address':
            return (0, isAddress_js_1.isAddress)(arg, {
                strict: false
            });
        case 'bool':
            return argType === 'boolean';
        case 'function':
            return argType === 'string';
        case 'string':
            return argType === 'string';
        default:
            {
                if (abiParameterType === 'tuple' && 'components' in abiParameter) return Object.values(abiParameter.components).every((component, index)=>{
                    return isArgOfType(Object.values(arg)[index], component);
                });
                if (/^u?int(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/.test(abiParameterType)) return argType === 'number' || argType === 'bigint';
                if (/^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/.test(abiParameterType)) return argType === 'string' || arg instanceof Uint8Array;
                if (/[a-z]+[1-9]{0,3}(\[[0-9]{0,}\])+$/.test(abiParameterType)) {
                    return Array.isArray(arg) && arg.every((x)=>isArgOfType(x, {
                            ...abiParameter,
                            type: abiParameterType.replace(/(\[[0-9]{0,}\])$/, '')
                        }));
                }
                return false;
            }
    }
}
function getAmbiguousTypes(sourceParameters, targetParameters, args) {
    for(const parameterIndex in sourceParameters){
        const sourceParameter = sourceParameters[parameterIndex];
        const targetParameter = targetParameters[parameterIndex];
        if (sourceParameter.type === 'tuple' && targetParameter.type === 'tuple' && 'components' in sourceParameter && 'components' in targetParameter) return getAmbiguousTypes(sourceParameter.components, targetParameter.components, args[parameterIndex]);
        const types = [
            sourceParameter.type,
            targetParameter.type
        ];
        const ambiguous = (()=>{
            if (types.includes('address') && types.includes('bytes20')) return true;
            if (types.includes('address') && types.includes('string')) return (0, isAddress_js_1.isAddress)(args[parameterIndex], {
                strict: false
            });
            if (types.includes('address') && types.includes('bytes')) return (0, isAddress_js_1.isAddress)(args[parameterIndex], {
                strict: false
            });
            return false;
        })();
        if (ambiguous) return types;
    }
    return;
} //# sourceMappingURL=getAbiItem.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeEventTopics = encodeEventTopics;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/log.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const toEventSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSelector.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/encodeEventTopics';
function encodeEventTopics(parameters) {
    const { abi, eventName, args } = parameters;
    let abiItem = abi[0];
    if (eventName) {
        const item = (0, getAbiItem_js_1.getAbiItem)({
            abi,
            name: eventName
        });
        if (!item) throw new abi_js_1.AbiEventNotFoundError(eventName, {
            docsPath
        });
        abiItem = item;
    }
    if (abiItem.type !== 'event') throw new abi_js_1.AbiEventNotFoundError(undefined, {
        docsPath
    });
    const definition = (0, formatAbiItem_js_1.formatAbiItem)(abiItem);
    const signature = (0, toEventSelector_js_1.toEventSelector)(definition);
    let topics = [];
    if (args && 'inputs' in abiItem) {
        var _abiItem_inputs;
        const indexedInputs = (_abiItem_inputs = abiItem.inputs) === null || _abiItem_inputs === void 0 ? void 0 : _abiItem_inputs.filter((param)=>'indexed' in param && param.indexed);
        var _indexedInputs_map;
        const args_ = Array.isArray(args) ? args : Object.values(args).length > 0 ? (_indexedInputs_map = indexedInputs === null || indexedInputs === void 0 ? void 0 : indexedInputs.map((x)=>args[x.name])) !== null && _indexedInputs_map !== void 0 ? _indexedInputs_map : [] : [];
        if (args_.length > 0) {
            var _indexedInputs_map1;
            topics = (_indexedInputs_map1 = indexedInputs === null || indexedInputs === void 0 ? void 0 : indexedInputs.map((param, i)=>{
                if (Array.isArray(args_[i])) return args_[i].map((_, j)=>encodeArg({
                        param,
                        value: args_[i][j]
                    }));
                return typeof args_[i] !== 'undefined' && args_[i] !== null ? encodeArg({
                    param,
                    value: args_[i]
                }) : null;
            })) !== null && _indexedInputs_map1 !== void 0 ? _indexedInputs_map1 : [];
        }
    }
    return [
        signature,
        ...topics
    ];
}
function encodeArg(param) {
    let { param: param1, value } = param;
    if (param1.type === 'string' || param1.type === 'bytes') return (0, keccak256_js_1.keccak256)((0, toBytes_js_1.toBytes)(value));
    if (param1.type === 'tuple' || param1.type.match(/^(.*)\[(\d+)?\]$/)) throw new log_js_1.FilterTypeNotSupportedError(param1.type);
    return (0, encodeAbiParameters_js_1.encodeAbiParameters)([
        param1
    ], [
        value
    ]);
} //# sourceMappingURL=encodeEventTopics.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/filters/createFilterRequestScope.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createFilterRequestScope = createFilterRequestScope;
function createFilterRequestScope(client, param) {
    let { method } = param;
    var _client_transport_onResponse, _client_transport;
    const requestMap = {};
    if (client.transport.type === 'fallback') (_client_transport_onResponse = (_client_transport = client.transport).onResponse) === null || _client_transport_onResponse === void 0 ? void 0 : _client_transport_onResponse.call(_client_transport, (param)=>{
        let { method: method_, response: id, status, transport } = param;
        if (status === 'success' && method === method_) requestMap[id] = transport.request;
    });
    return (id)=>requestMap[id] || client.request;
} //# sourceMappingURL=createFilterRequestScope.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createContractEventFilter.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createContractEventFilter = createContractEventFilter;
const encodeEventTopics_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const createFilterRequestScope_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/filters/createFilterRequestScope.js [app-client] (ecmascript)");
async function createContractEventFilter(client, parameters) {
    const { address, abi, args, eventName, fromBlock, strict, toBlock } = parameters;
    const getRequest = (0, createFilterRequestScope_js_1.createFilterRequestScope)(client, {
        method: 'eth_newFilter'
    });
    const topics = eventName ? (0, encodeEventTopics_js_1.encodeEventTopics)({
        abi,
        args,
        eventName
    }) : undefined;
    const id = await client.request({
        method: 'eth_newFilter',
        params: [
            {
                address,
                fromBlock: typeof fromBlock === 'bigint' ? (0, toHex_js_1.numberToHex)(fromBlock) : fromBlock,
                toBlock: typeof toBlock === 'bigint' ? (0, toHex_js_1.numberToHex)(toBlock) : toBlock,
                topics
            }
        ]
    });
    return {
        abi,
        args,
        eventName,
        id,
        request: getRequest(id),
        strict: Boolean(strict),
        type: 'event'
    };
} //# sourceMappingURL=createContractEventFilter.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseAccount = parseAccount;
function parseAccount(account) {
    if (typeof account === 'string') return {
        address: account,
        type: 'json-rpc'
    };
    return account;
} //# sourceMappingURL=parseAccount.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/prepareEncodeFunctionData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.prepareEncodeFunctionData = prepareEncodeFunctionData;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const toFunctionSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/encodeFunctionData';
function prepareEncodeFunctionData(parameters) {
    const { abi, args, functionName } = parameters;
    let abiItem = abi[0];
    if (functionName) {
        const item = (0, getAbiItem_js_1.getAbiItem)({
            abi,
            args,
            name: functionName
        });
        if (!item) throw new abi_js_1.AbiFunctionNotFoundError(functionName, {
            docsPath
        });
        abiItem = item;
    }
    if (abiItem.type !== 'function') throw new abi_js_1.AbiFunctionNotFoundError(undefined, {
        docsPath
    });
    return {
        abi: [
            abiItem
        ],
        functionName: (0, toFunctionSelector_js_1.toFunctionSelector)((0, formatAbiItem_js_1.formatAbiItem)(abiItem))
    };
} //# sourceMappingURL=prepareEncodeFunctionData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeFunctionData = encodeFunctionData;
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const prepareEncodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/prepareEncodeFunctionData.js [app-client] (ecmascript)");
function encodeFunctionData(parameters) {
    const { args } = parameters;
    const { abi, functionName } = (()=>{
        var _parameters_functionName;
        if (parameters.abi.length === 1 && ((_parameters_functionName = parameters.functionName) === null || _parameters_functionName === void 0 ? void 0 : _parameters_functionName.startsWith('0x'))) return parameters;
        return (0, prepareEncodeFunctionData_js_1.prepareEncodeFunctionData)(parameters);
    })();
    const abiItem = abi[0];
    const signature = functionName;
    const data = 'inputs' in abiItem && abiItem.inputs ? (0, encodeAbiParameters_js_1.encodeAbiParameters)(abiItem.inputs, args !== null && args !== void 0 ? args : []) : undefined;
    return (0, concat_js_1.concatHex)([
        signature,
        data !== null && data !== void 0 ? data : '0x'
    ]);
} //# sourceMappingURL=encodeFunctionData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/solidity.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.solidityPanic = exports.solidityError = exports.panicReasons = void 0;
exports.panicReasons = {
    1: 'An `assert` condition failed.',
    17: 'Arithmetic operation resulted in underflow or overflow.',
    18: 'Division or modulo by zero (e.g. `5 / 0` or `23 % 0`).',
    33: 'Attempted to convert to an invalid type.',
    34: 'Attempted to access a storage byte array that is incorrectly encoded.',
    49: 'Performed `.pop()` on an empty array',
    50: 'Array index is out of bounds.',
    65: 'Allocated too much memory or created an array which is too large.',
    81: 'Attempted to call a zero-initialized variable of internal function type.'
};
exports.solidityError = {
    inputs: [
        {
            name: 'message',
            type: 'string'
        }
    ],
    name: 'Error',
    type: 'error'
};
exports.solidityPanic = {
    inputs: [
        {
            name: 'reason',
            type: 'uint256'
        }
    ],
    name: 'Panic',
    type: 'error'
}; //# sourceMappingURL=solidity.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/cursor.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RecursiveReadLimitExceededError = exports.PositionOutOfBoundsError = exports.NegativeOffsetError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class NegativeOffsetError extends base_js_1.BaseError {
    constructor({ offset }){
        super("Offset `".concat(offset, "` cannot be negative."), {
            name: 'NegativeOffsetError'
        });
    }
}
exports.NegativeOffsetError = NegativeOffsetError;
class PositionOutOfBoundsError extends base_js_1.BaseError {
    constructor({ length, position }){
        super("Position `".concat(position, "` is out of bounds (`0 < position < ").concat(length, "`)."), {
            name: 'PositionOutOfBoundsError'
        });
    }
}
exports.PositionOutOfBoundsError = PositionOutOfBoundsError;
class RecursiveReadLimitExceededError extends base_js_1.BaseError {
    constructor({ count, limit }){
        super("Recursive read limit of `".concat(limit, "` exceeded (recursive read count: `").concat(count, "`)."), {
            name: 'RecursiveReadLimitExceededError'
        });
    }
}
exports.RecursiveReadLimitExceededError = RecursiveReadLimitExceededError; //# sourceMappingURL=cursor.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/cursor.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createCursor = createCursor;
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/cursor.js [app-client] (ecmascript)");
const staticCursor = {
    bytes: new Uint8Array(),
    dataView: new DataView(new ArrayBuffer(0)),
    position: 0,
    positionReadCount: new Map(),
    recursiveReadCount: 0,
    recursiveReadLimit: Number.POSITIVE_INFINITY,
    assertReadLimit () {
        if (this.recursiveReadCount >= this.recursiveReadLimit) throw new cursor_js_1.RecursiveReadLimitExceededError({
            count: this.recursiveReadCount + 1,
            limit: this.recursiveReadLimit
        });
    },
    assertPosition (position) {
        if (position < 0 || position > this.bytes.length - 1) throw new cursor_js_1.PositionOutOfBoundsError({
            length: this.bytes.length,
            position
        });
    },
    decrementPosition (offset) {
        if (offset < 0) throw new cursor_js_1.NegativeOffsetError({
            offset
        });
        const position = this.position - offset;
        this.assertPosition(position);
        this.position = position;
    },
    getReadCount (position) {
        return this.positionReadCount.get(position || this.position) || 0;
    },
    incrementPosition (offset) {
        if (offset < 0) throw new cursor_js_1.NegativeOffsetError({
            offset
        });
        const position = this.position + offset;
        this.assertPosition(position);
        this.position = position;
    },
    inspectByte (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position);
        return this.bytes[position];
    },
    inspectBytes (length, position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + length - 1);
        return this.bytes.subarray(position, position + length);
    },
    inspectUint8 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position);
        return this.bytes[position];
    },
    inspectUint16 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 1);
        return this.dataView.getUint16(position);
    },
    inspectUint24 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 2);
        return (this.dataView.getUint16(position) << 8) + this.dataView.getUint8(position + 2);
    },
    inspectUint32 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 3);
        return this.dataView.getUint32(position);
    },
    pushByte (byte) {
        this.assertPosition(this.position);
        this.bytes[this.position] = byte;
        this.position++;
    },
    pushBytes (bytes) {
        this.assertPosition(this.position + bytes.length - 1);
        this.bytes.set(bytes, this.position);
        this.position += bytes.length;
    },
    pushUint8 (value) {
        this.assertPosition(this.position);
        this.bytes[this.position] = value;
        this.position++;
    },
    pushUint16 (value) {
        this.assertPosition(this.position + 1);
        this.dataView.setUint16(this.position, value);
        this.position += 2;
    },
    pushUint24 (value) {
        this.assertPosition(this.position + 2);
        this.dataView.setUint16(this.position, value >> 8);
        this.dataView.setUint8(this.position + 2, value & ~4294967040);
        this.position += 3;
    },
    pushUint32 (value) {
        this.assertPosition(this.position + 3);
        this.dataView.setUint32(this.position, value);
        this.position += 4;
    },
    readByte () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectByte();
        this.position++;
        return value;
    },
    readBytes (length, size) {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectBytes(length);
        this.position += size !== null && size !== void 0 ? size : length;
        return value;
    },
    readUint8 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint8();
        this.position += 1;
        return value;
    },
    readUint16 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint16();
        this.position += 2;
        return value;
    },
    readUint24 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint24();
        this.position += 3;
        return value;
    },
    readUint32 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint32();
        this.position += 4;
        return value;
    },
    get remaining () {
        return this.bytes.length - this.position;
    },
    setPosition (position) {
        const oldPosition = this.position;
        this.assertPosition(position);
        this.position = position;
        return ()=>this.position = oldPosition;
    },
    _touch () {
        if (this.recursiveReadLimit === Number.POSITIVE_INFINITY) return;
        const count = this.getReadCount();
        this.positionReadCount.set(this.position, count + 1);
        if (count > 0) this.recursiveReadCount++;
    }
};
function createCursor(bytes) {
    let { recursiveReadLimit = 8_192 } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const cursor = Object.create(staticCursor);
    cursor.bytes = bytes;
    cursor.dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
    cursor.positionReadCount = new Map();
    cursor.recursiveReadLimit = recursiveReadLimit;
    return cursor;
} //# sourceMappingURL=cursor.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromBytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fromBytes = fromBytes;
exports.bytesToBigInt = bytesToBigInt;
exports.bytesToBool = bytesToBool;
exports.bytesToNumber = bytesToNumber;
exports.bytesToString = bytesToString;
const encoding_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/encoding.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function fromBytes(bytes, toOrOpts) {
    const opts = typeof toOrOpts === 'string' ? {
        to: toOrOpts
    } : toOrOpts;
    const to = opts.to;
    if (to === 'number') return bytesToNumber(bytes, opts);
    if (to === 'bigint') return bytesToBigInt(bytes, opts);
    if (to === 'boolean') return bytesToBool(bytes, opts);
    if (to === 'string') return bytesToString(bytes, opts);
    return (0, toHex_js_1.bytesToHex)(bytes, opts);
}
function bytesToBigInt(bytes) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof opts.size !== 'undefined') (0, fromHex_js_1.assertSize)(bytes, {
        size: opts.size
    });
    const hex = (0, toHex_js_1.bytesToHex)(bytes, opts);
    return (0, fromHex_js_1.hexToBigInt)(hex, opts);
}
function bytesToBool(bytes_) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let bytes = bytes_;
    if (typeof opts.size !== 'undefined') {
        (0, fromHex_js_1.assertSize)(bytes, {
            size: opts.size
        });
        bytes = (0, trim_js_1.trim)(bytes);
    }
    if (bytes.length > 1 || bytes[0] > 1) throw new encoding_js_1.InvalidBytesBooleanError(bytes);
    return Boolean(bytes[0]);
}
function bytesToNumber(bytes) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof opts.size !== 'undefined') (0, fromHex_js_1.assertSize)(bytes, {
        size: opts.size
    });
    const hex = (0, toHex_js_1.bytesToHex)(bytes, opts);
    return (0, fromHex_js_1.hexToNumber)(hex, opts);
}
function bytesToString(bytes_) {
    let opts = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let bytes = bytes_;
    if (typeof opts.size !== 'undefined') {
        (0, fromHex_js_1.assertSize)(bytes, {
            size: opts.size
        });
        bytes = (0, trim_js_1.trim)(bytes, {
            dir: 'right'
        });
    }
    return new TextDecoder().decode(bytes);
} //# sourceMappingURL=fromBytes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeAbiParameters = decodeAbiParameters;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/cursor.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const fromBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromBytes.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
function decodeAbiParameters(params, data) {
    const bytes = typeof data === 'string' ? (0, toBytes_js_1.hexToBytes)(data) : data;
    const cursor = (0, cursor_js_1.createCursor)(bytes);
    if ((0, size_js_1.size)(bytes) === 0 && params.length > 0) throw new abi_js_1.AbiDecodingZeroDataError();
    if ((0, size_js_1.size)(data) && (0, size_js_1.size)(data) < 32) throw new abi_js_1.AbiDecodingDataSizeTooSmallError({
        data: typeof data === 'string' ? data : (0, toHex_js_1.bytesToHex)(data),
        params: params,
        size: (0, size_js_1.size)(data)
    });
    let consumed = 0;
    const values = [];
    for(let i = 0; i < params.length; ++i){
        const param = params[i];
        cursor.setPosition(consumed);
        const [data, consumed_] = decodeParameter(cursor, param, {
            staticPosition: 0
        });
        consumed += consumed_;
        values.push(data);
    }
    return values;
}
function decodeParameter(cursor, param, param1) {
    let { staticPosition } = param1;
    const arrayComponents = (0, encodeAbiParameters_js_1.getArrayComponents)(param.type);
    if (arrayComponents) {
        const [length, type] = arrayComponents;
        return decodeArray(cursor, {
            ...param,
            type
        }, {
            length,
            staticPosition
        });
    }
    if (param.type === 'tuple') return decodeTuple(cursor, param, {
        staticPosition
    });
    if (param.type === 'address') return decodeAddress(cursor);
    if (param.type === 'bool') return decodeBool(cursor);
    if (param.type.startsWith('bytes')) return decodeBytes(cursor, param, {
        staticPosition
    });
    if (param.type.startsWith('uint') || param.type.startsWith('int')) return decodeNumber(cursor, param);
    if (param.type === 'string') return decodeString(cursor, {
        staticPosition
    });
    throw new abi_js_1.InvalidAbiDecodingTypeError(param.type, {
        docsPath: '/docs/contract/decodeAbiParameters'
    });
}
const sizeOfLength = 32;
const sizeOfOffset = 32;
function decodeAddress(cursor) {
    const value = cursor.readBytes(32);
    return [
        (0, getAddress_js_1.checksumAddress)((0, toHex_js_1.bytesToHex)((0, slice_js_1.sliceBytes)(value, -20))),
        32
    ];
}
function decodeArray(cursor, param, param1) {
    let { length, staticPosition } = param1;
    if (!length) {
        const offset = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(sizeOfOffset));
        const start = staticPosition + offset;
        const startOfData = start + sizeOfLength;
        cursor.setPosition(start);
        const length = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(sizeOfLength));
        const dynamicChild = hasDynamicChild(param);
        let consumed = 0;
        const value = [];
        for(let i = 0; i < length; ++i){
            cursor.setPosition(startOfData + (dynamicChild ? i * 32 : consumed));
            const [data, consumed_] = decodeParameter(cursor, param, {
                staticPosition: startOfData
            });
            consumed += consumed_;
            value.push(data);
        }
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    if (hasDynamicChild(param)) {
        const offset = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(sizeOfOffset));
        const start = staticPosition + offset;
        const value = [];
        for(let i = 0; i < length; ++i){
            cursor.setPosition(start + i * 32);
            const [data] = decodeParameter(cursor, param, {
                staticPosition: start
            });
            value.push(data);
        }
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    let consumed = 0;
    const value = [];
    for(let i = 0; i < length; ++i){
        const [data, consumed_] = decodeParameter(cursor, param, {
            staticPosition: staticPosition + consumed
        });
        consumed += consumed_;
        value.push(data);
    }
    return [
        value,
        consumed
    ];
}
function decodeBool(cursor) {
    return [
        (0, fromBytes_js_1.bytesToBool)(cursor.readBytes(32), {
            size: 32
        }),
        32
    ];
}
function decodeBytes(cursor, param, param1) {
    let { staticPosition } = param1;
    const [_, size] = param.type.split('bytes');
    if (!size) {
        const offset = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(32));
        cursor.setPosition(staticPosition + offset);
        const length = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(32));
        if (length === 0) {
            cursor.setPosition(staticPosition + 32);
            return [
                '0x',
                32
            ];
        }
        const data = cursor.readBytes(length);
        cursor.setPosition(staticPosition + 32);
        return [
            (0, toHex_js_1.bytesToHex)(data),
            32
        ];
    }
    const value = (0, toHex_js_1.bytesToHex)(cursor.readBytes(Number.parseInt(size, 10), 32));
    return [
        value,
        32
    ];
}
function decodeNumber(cursor, param) {
    const signed = param.type.startsWith('int');
    const size = Number.parseInt(param.type.split('int')[1] || '256', 10);
    const value = cursor.readBytes(32);
    return [
        size > 48 ? (0, fromBytes_js_1.bytesToBigInt)(value, {
            signed
        }) : (0, fromBytes_js_1.bytesToNumber)(value, {
            signed
        }),
        32
    ];
}
function decodeTuple(cursor, param, param1) {
    let { staticPosition } = param1;
    const hasUnnamedChild = param.components.length === 0 || param.components.some((param)=>{
        let { name } = param;
        return !name;
    });
    const value = hasUnnamedChild ? [] : {};
    let consumed = 0;
    if (hasDynamicChild(param)) {
        const offset = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(sizeOfOffset));
        const start = staticPosition + offset;
        for(let i = 0; i < param.components.length; ++i){
            const component = param.components[i];
            cursor.setPosition(start + consumed);
            const [data, consumed_] = decodeParameter(cursor, component, {
                staticPosition: start
            });
            consumed += consumed_;
            value[hasUnnamedChild ? i : component === null || component === void 0 ? void 0 : component.name] = data;
        }
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    for(let i = 0; i < param.components.length; ++i){
        const component = param.components[i];
        const [data, consumed_] = decodeParameter(cursor, component, {
            staticPosition
        });
        value[hasUnnamedChild ? i : component === null || component === void 0 ? void 0 : component.name] = data;
        consumed += consumed_;
    }
    return [
        value,
        consumed
    ];
}
function decodeString(cursor, param) {
    let { staticPosition } = param;
    const offset = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(32));
    const start = staticPosition + offset;
    cursor.setPosition(start);
    const length = (0, fromBytes_js_1.bytesToNumber)(cursor.readBytes(32));
    if (length === 0) {
        cursor.setPosition(staticPosition + 32);
        return [
            '',
            32
        ];
    }
    const data = cursor.readBytes(length, 32);
    const value = (0, fromBytes_js_1.bytesToString)((0, trim_js_1.trim)(data));
    cursor.setPosition(staticPosition + 32);
    return [
        value,
        32
    ];
}
function hasDynamicChild(param) {
    var _param_components;
    const { type } = param;
    if (type === 'string') return true;
    if (type === 'bytes') return true;
    if (type.endsWith('[]')) return true;
    if (type === 'tuple') return (_param_components = param.components) === null || _param_components === void 0 ? void 0 : _param_components.some(hasDynamicChild);
    const arrayComponents = (0, encodeAbiParameters_js_1.getArrayComponents)(param.type);
    if (arrayComponents && hasDynamicChild({
        ...param,
        type: arrayComponents[1]
    })) return true;
    return false;
} //# sourceMappingURL=decodeAbiParameters.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeErrorResult.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeErrorResult = decodeErrorResult;
const solidity_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/solidity.js [app-client] (ecmascript)");
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const toFunctionSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)");
const decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
function decodeErrorResult(parameters) {
    const { abi, data } = parameters;
    const signature = (0, slice_js_1.slice)(data, 0, 4);
    if (signature === '0x') throw new abi_js_1.AbiDecodingZeroDataError();
    const abi_ = [
        ...abi || [],
        solidity_js_1.solidityError,
        solidity_js_1.solidityPanic
    ];
    const abiItem = abi_.find((x)=>x.type === 'error' && signature === (0, toFunctionSelector_js_1.toFunctionSelector)((0, formatAbiItem_js_1.formatAbiItem)(x)));
    if (!abiItem) throw new abi_js_1.AbiErrorSignatureNotFoundError(signature, {
        docsPath: '/docs/contract/decodeErrorResult'
    });
    return {
        abiItem,
        args: 'inputs' in abiItem && abiItem.inputs && abiItem.inputs.length > 0 ? (0, decodeAbiParameters_js_1.decodeAbiParameters)(abiItem.inputs, (0, slice_js_1.slice)(data, 4)) : undefined,
        errorName: abiItem.name
    };
} //# sourceMappingURL=decodeErrorResult.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.stringify = void 0;
const stringify = (value, replacer, space)=>JSON.stringify(value, (key, value_)=>{
        const value = typeof value_ === 'bigint' ? value_.toString() : value_;
        return typeof replacer === 'function' ? replacer(key, value) : value;
    }, space);
exports.stringify = stringify; //# sourceMappingURL=stringify.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItemWithArgs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatAbiItemWithArgs = formatAbiItemWithArgs;
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
function formatAbiItemWithArgs(param) {
    let { abiItem, args, includeFunctionName = true, includeName = false } = param;
    if (!('name' in abiItem)) return;
    if (!('inputs' in abiItem)) return;
    if (!abiItem.inputs) return;
    return "".concat(includeFunctionName ? abiItem.name : '', "(").concat(abiItem.inputs.map((input, i)=>"".concat(includeName && input.name ? "".concat(input.name, ": ") : '').concat(typeof args[i] === 'object' ? (0, stringify_js_1.stringify)(args[i]) : args[i])).join(', '), ")");
} //# sourceMappingURL=formatAbiItemWithArgs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/unit.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.weiUnits = exports.gweiUnits = exports.etherUnits = void 0;
exports.etherUnits = {
    gwei: 9,
    wei: 18
};
exports.gweiUnits = {
    ether: -9,
    wei: 9
};
exports.weiUnits = {
    ether: -18,
    gwei: -9
}; //# sourceMappingURL=unit.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatUnits.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatUnits = formatUnits;
function formatUnits(value, decimals) {
    let display = value.toString();
    const negative = display.startsWith('-');
    if (negative) display = display.slice(1);
    display = display.padStart(decimals, '0');
    let [integer, fraction] = [
        display.slice(0, display.length - decimals),
        display.slice(display.length - decimals)
    ];
    fraction = fraction.replace(/(0+)$/, '');
    return "".concat(negative ? '-' : '').concat(integer || '0').concat(fraction ? ".".concat(fraction) : '');
} //# sourceMappingURL=formatUnits.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatEther.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatEther = formatEther;
const unit_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/unit.js [app-client] (ecmascript)");
const formatUnits_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatUnits.js [app-client] (ecmascript)");
function formatEther(wei) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return (0, formatUnits_js_1.formatUnits)(wei, unit_js_1.etherUnits[unit]);
} //# sourceMappingURL=formatEther.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatGwei = formatGwei;
const unit_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/unit.js [app-client] (ecmascript)");
const formatUnits_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatUnits.js [app-client] (ecmascript)");
function formatGwei(wei) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return (0, formatUnits_js_1.formatUnits)(wei, unit_js_1.gweiUnits[unit]);
} //# sourceMappingURL=formatGwei.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/stateOverride.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.StateAssignmentConflictError = exports.AccountStateConflictError = void 0;
exports.prettyStateMapping = prettyStateMapping;
exports.prettyStateOverride = prettyStateOverride;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class AccountStateConflictError extends base_js_1.BaseError {
    constructor({ address }){
        super('State for account "'.concat(address, '" is set multiple times.'), {
            name: 'AccountStateConflictError'
        });
    }
}
exports.AccountStateConflictError = AccountStateConflictError;
class StateAssignmentConflictError extends base_js_1.BaseError {
    constructor(){
        super('state and stateDiff are set on the same account.', {
            name: 'StateAssignmentConflictError'
        });
    }
}
exports.StateAssignmentConflictError = StateAssignmentConflictError;
function prettyStateMapping(stateMapping) {
    return stateMapping.reduce((pretty, param)=>{
        let { slot, value } = param;
        return "".concat(pretty, "        ").concat(slot, ": ").concat(value, "\n");
    }, '');
}
function prettyStateOverride(stateOverride) {
    return stateOverride.reduce((pretty, param)=>{
        let { address, ...state } = param;
        let val = "".concat(pretty, "    ").concat(address, ":\n");
        if (state.nonce) val += "      nonce: ".concat(state.nonce, "\n");
        if (state.balance) val += "      balance: ".concat(state.balance, "\n");
        if (state.code) val += "      code: ".concat(state.code, "\n");
        if (state.state) {
            val += '      state:\n';
            val += prettyStateMapping(state.state);
        }
        if (state.stateDiff) {
            val += '      stateDiff:\n';
            val += prettyStateMapping(state.stateDiff);
        }
        return val;
    }, '  State Override:\n').slice(0, -1);
} //# sourceMappingURL=stateOverride.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WaitForTransactionReceiptTimeoutError = exports.TransactionReceiptRevertedError = exports.TransactionReceiptNotFoundError = exports.TransactionNotFoundError = exports.TransactionExecutionError = exports.InvalidStorageKeySizeError = exports.InvalidSerializedTransactionError = exports.InvalidSerializedTransactionTypeError = exports.InvalidSerializableTransactionError = exports.InvalidLegacyVError = exports.FeeConflictError = void 0;
exports.prettyPrint = prettyPrint;
const formatEther_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatEther.js [app-client] (ecmascript)");
const formatGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
function prettyPrint(args) {
    const entries = Object.entries(args).map((param)=>{
        let [key, value] = param;
        if (value === undefined || value === false) return null;
        return [
            key,
            value
        ];
    }).filter(Boolean);
    const maxLength = entries.reduce((acc, param)=>{
        let [key] = param;
        return Math.max(acc, key.length);
    }, 0);
    return entries.map((param)=>{
        let [key, value] = param;
        return "  ".concat("".concat(key, ":").padEnd(maxLength + 1), "  ").concat(value);
    }).join('\n');
}
class FeeConflictError extends base_js_1.BaseError {
    constructor(){
        super([
            'Cannot specify both a `gasPrice` and a `maxFeePerGas`/`maxPriorityFeePerGas`.',
            'Use `maxFeePerGas`/`maxPriorityFeePerGas` for EIP-1559 compatible networks, and `gasPrice` for others.'
        ].join('\n'), {
            name: 'FeeConflictError'
        });
    }
}
exports.FeeConflictError = FeeConflictError;
class InvalidLegacyVError extends base_js_1.BaseError {
    constructor({ v }){
        super('Invalid `v` value "'.concat(v, '". Expected 27 or 28.'), {
            name: 'InvalidLegacyVError'
        });
    }
}
exports.InvalidLegacyVError = InvalidLegacyVError;
class InvalidSerializableTransactionError extends base_js_1.BaseError {
    constructor({ transaction }){
        super('Cannot infer a transaction type from provided transaction.', {
            metaMessages: [
                'Provided Transaction:',
                '{',
                prettyPrint(transaction),
                '}',
                '',
                'To infer the type, either provide:',
                '- a `type` to the Transaction, or',
                '- an EIP-1559 Transaction with `maxFeePerGas`, or',
                '- an EIP-2930 Transaction with `gasPrice` & `accessList`, or',
                '- an EIP-4844 Transaction with `blobs`, `blobVersionedHashes`, `sidecars`, or',
                '- an EIP-7702 Transaction with `authorizationList`, or',
                '- a Legacy Transaction with `gasPrice`'
            ],
            name: 'InvalidSerializableTransactionError'
        });
    }
}
exports.InvalidSerializableTransactionError = InvalidSerializableTransactionError;
class InvalidSerializedTransactionTypeError extends base_js_1.BaseError {
    constructor({ serializedType }){
        super('Serialized transaction type "'.concat(serializedType, '" is invalid.'), {
            name: 'InvalidSerializedTransactionType'
        });
        Object.defineProperty(this, "serializedType", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.serializedType = serializedType;
    }
}
exports.InvalidSerializedTransactionTypeError = InvalidSerializedTransactionTypeError;
class InvalidSerializedTransactionError extends base_js_1.BaseError {
    constructor({ attributes, serializedTransaction, type }){
        const missing = Object.entries(attributes).map((param)=>{
            let [key, value] = param;
            return typeof value === 'undefined' ? key : undefined;
        }).filter(Boolean);
        super('Invalid serialized transaction of type "'.concat(type, '" was provided.'), {
            metaMessages: [
                'Serialized Transaction: "'.concat(serializedTransaction, '"'),
                missing.length > 0 ? "Missing Attributes: ".concat(missing.join(', ')) : ''
            ].filter(Boolean),
            name: 'InvalidSerializedTransactionError'
        });
        Object.defineProperty(this, "serializedTransaction", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "type", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.serializedTransaction = serializedTransaction;
        this.type = type;
    }
}
exports.InvalidSerializedTransactionError = InvalidSerializedTransactionError;
class InvalidStorageKeySizeError extends base_js_1.BaseError {
    constructor({ storageKey }){
        super('Size for storage key "'.concat(storageKey, '" is invalid. Expected 32 bytes. Got ').concat(Math.floor((storageKey.length - 2) / 2), " bytes."), {
            name: 'InvalidStorageKeySizeError'
        });
    }
}
exports.InvalidStorageKeySizeError = InvalidStorageKeySizeError;
class TransactionExecutionError extends base_js_1.BaseError {
    constructor(cause, { account, docsPath, chain, data, gas, gasPrice, maxFeePerGas, maxPriorityFeePerGas, nonce, to, value }){
        var _chain_nativeCurrency;
        const prettyArgs = prettyPrint({
            chain: chain && "".concat(chain === null || chain === void 0 ? void 0 : chain.name, " (id: ").concat(chain === null || chain === void 0 ? void 0 : chain.id, ")"),
            from: account === null || account === void 0 ? void 0 : account.address,
            to,
            value: typeof value !== 'undefined' && "".concat((0, formatEther_js_1.formatEther)(value), " ").concat((chain === null || chain === void 0 ? void 0 : (_chain_nativeCurrency = chain.nativeCurrency) === null || _chain_nativeCurrency === void 0 ? void 0 : _chain_nativeCurrency.symbol) || 'ETH'),
            data,
            gas,
            gasPrice: typeof gasPrice !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(gasPrice), " gwei"),
            maxFeePerGas: typeof maxFeePerGas !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(maxFeePerGas), " gwei"),
            maxPriorityFeePerGas: typeof maxPriorityFeePerGas !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(maxPriorityFeePerGas), " gwei"),
            nonce
        });
        super(cause.shortMessage, {
            cause,
            docsPath,
            metaMessages: [
                ...cause.metaMessages ? [
                    ...cause.metaMessages,
                    ' '
                ] : [],
                'Request Arguments:',
                prettyArgs
            ].filter(Boolean),
            name: 'TransactionExecutionError'
        });
        Object.defineProperty(this, "cause", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.cause = cause;
    }
}
exports.TransactionExecutionError = TransactionExecutionError;
class TransactionNotFoundError extends base_js_1.BaseError {
    constructor({ blockHash, blockNumber, blockTag, hash, index }){
        let identifier = 'Transaction';
        if (blockTag && index !== undefined) identifier = 'Transaction at block time "'.concat(blockTag, '" at index "').concat(index, '"');
        if (blockHash && index !== undefined) identifier = 'Transaction at block hash "'.concat(blockHash, '" at index "').concat(index, '"');
        if (blockNumber && index !== undefined) identifier = 'Transaction at block number "'.concat(blockNumber, '" at index "').concat(index, '"');
        if (hash) identifier = 'Transaction with hash "'.concat(hash, '"');
        super("".concat(identifier, " could not be found."), {
            name: 'TransactionNotFoundError'
        });
    }
}
exports.TransactionNotFoundError = TransactionNotFoundError;
class TransactionReceiptNotFoundError extends base_js_1.BaseError {
    constructor({ hash }){
        super('Transaction receipt with hash "'.concat(hash, '" could not be found. The Transaction may not be processed on a block yet.'), {
            name: 'TransactionReceiptNotFoundError'
        });
    }
}
exports.TransactionReceiptNotFoundError = TransactionReceiptNotFoundError;
class TransactionReceiptRevertedError extends base_js_1.BaseError {
    constructor({ receipt }){
        super('Transaction with hash "'.concat(receipt.transactionHash, '" reverted.'), {
            metaMessages: [
                'The receipt marked the transaction as "reverted". This could mean that the function on the contract you are trying to call threw an error.',
                ' ',
                'You can attempt to extract the revert reason by:',
                '- calling the `simulateContract` or `simulateCalls` Action with the `abi` and `functionName` of the contract',
                '- using the `call` Action with raw `data`'
            ],
            name: 'TransactionReceiptRevertedError'
        });
        Object.defineProperty(this, "receipt", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.receipt = receipt;
    }
}
exports.TransactionReceiptRevertedError = TransactionReceiptRevertedError;
class WaitForTransactionReceiptTimeoutError extends base_js_1.BaseError {
    constructor({ hash }){
        super('Timed out while waiting for transaction with hash "'.concat(hash, '" to be confirmed.'), {
            name: 'WaitForTransactionReceiptTimeoutError'
        });
    }
}
exports.WaitForTransactionReceiptTimeoutError = WaitForTransactionReceiptTimeoutError; //# sourceMappingURL=transaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/utils.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getUrl = exports.getContractAddress = void 0;
const getContractAddress = (address)=>address;
exports.getContractAddress = getContractAddress;
const getUrl = (url)=>url;
exports.getUrl = getUrl; //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RawContractError = exports.CounterfactualDeploymentFailedError = exports.ContractFunctionZeroDataError = exports.ContractFunctionRevertedError = exports.ContractFunctionExecutionError = exports.CallExecutionError = void 0;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const solidity_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/solidity.js [app-client] (ecmascript)");
const decodeErrorResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeErrorResult.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
const formatAbiItemWithArgs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItemWithArgs.js [app-client] (ecmascript)");
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const formatEther_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatEther.js [app-client] (ecmascript)");
const formatGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)");
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const stateOverride_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/stateOverride.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const utils_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/utils.js [app-client] (ecmascript)");
class CallExecutionError extends base_js_1.BaseError {
    constructor(cause, { account: account_, docsPath, chain, data, gas, gasPrice, maxFeePerGas, maxPriorityFeePerGas, nonce, to, value, stateOverride }){
        var _chain_nativeCurrency;
        const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : undefined;
        let prettyArgs = (0, transaction_js_1.prettyPrint)({
            from: account === null || account === void 0 ? void 0 : account.address,
            to,
            value: typeof value !== 'undefined' && "".concat((0, formatEther_js_1.formatEther)(value), " ").concat((chain === null || chain === void 0 ? void 0 : (_chain_nativeCurrency = chain.nativeCurrency) === null || _chain_nativeCurrency === void 0 ? void 0 : _chain_nativeCurrency.symbol) || 'ETH'),
            data,
            gas,
            gasPrice: typeof gasPrice !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(gasPrice), " gwei"),
            maxFeePerGas: typeof maxFeePerGas !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(maxFeePerGas), " gwei"),
            maxPriorityFeePerGas: typeof maxPriorityFeePerGas !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(maxPriorityFeePerGas), " gwei"),
            nonce
        });
        if (stateOverride) {
            prettyArgs += "\n".concat((0, stateOverride_js_1.prettyStateOverride)(stateOverride));
        }
        super(cause.shortMessage, {
            cause,
            docsPath,
            metaMessages: [
                ...cause.metaMessages ? [
                    ...cause.metaMessages,
                    ' '
                ] : [],
                'Raw Call Arguments:',
                prettyArgs
            ].filter(Boolean),
            name: 'CallExecutionError'
        });
        Object.defineProperty(this, "cause", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.cause = cause;
    }
}
exports.CallExecutionError = CallExecutionError;
class ContractFunctionExecutionError extends base_js_1.BaseError {
    constructor(cause, { abi, args, contractAddress, docsPath, functionName, sender }){
        const abiItem = (0, getAbiItem_js_1.getAbiItem)({
            abi,
            args,
            name: functionName
        });
        const formattedArgs = abiItem ? (0, formatAbiItemWithArgs_js_1.formatAbiItemWithArgs)({
            abiItem,
            args,
            includeFunctionName: false,
            includeName: false
        }) : undefined;
        const functionWithParams = abiItem ? (0, formatAbiItem_js_1.formatAbiItem)(abiItem, {
            includeName: true
        }) : undefined;
        var _functionName_length;
        const prettyArgs = (0, transaction_js_1.prettyPrint)({
            address: contractAddress && (0, utils_js_1.getContractAddress)(contractAddress),
            function: functionWithParams,
            args: formattedArgs && formattedArgs !== '()' && "".concat([
                ...Array((_functionName_length = functionName === null || functionName === void 0 ? void 0 : functionName.length) !== null && _functionName_length !== void 0 ? _functionName_length : 0).keys()
            ].map(()=>' ').join('')).concat(formattedArgs),
            sender
        });
        super(cause.shortMessage || 'An unknown error occurred while executing the contract function "'.concat(functionName, '".'), {
            cause,
            docsPath,
            metaMessages: [
                ...cause.metaMessages ? [
                    ...cause.metaMessages,
                    ' '
                ] : [],
                prettyArgs && 'Contract Call:',
                prettyArgs
            ].filter(Boolean),
            name: 'ContractFunctionExecutionError'
        });
        Object.defineProperty(this, "abi", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "args", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "cause", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "contractAddress", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "formattedArgs", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "functionName", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "sender", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.abi = abi;
        this.args = args;
        this.cause = cause;
        this.contractAddress = contractAddress;
        this.functionName = functionName;
        this.sender = sender;
    }
}
exports.ContractFunctionExecutionError = ContractFunctionExecutionError;
class ContractFunctionRevertedError extends base_js_1.BaseError {
    constructor({ abi, data, functionName, message }){
        let cause;
        let decodedData;
        let metaMessages;
        let reason;
        if (data && data !== '0x') {
            try {
                decodedData = (0, decodeErrorResult_js_1.decodeErrorResult)({
                    abi,
                    data
                });
                const { abiItem, errorName, args: errorArgs } = decodedData;
                if (errorName === 'Error') {
                    reason = errorArgs[0];
                } else if (errorName === 'Panic') {
                    const [firstArg] = errorArgs;
                    reason = solidity_js_1.panicReasons[firstArg];
                } else {
                    const errorWithParams = abiItem ? (0, formatAbiItem_js_1.formatAbiItem)(abiItem, {
                        includeName: true
                    }) : undefined;
                    const formattedArgs = abiItem && errorArgs ? (0, formatAbiItemWithArgs_js_1.formatAbiItemWithArgs)({
                        abiItem,
                        args: errorArgs,
                        includeFunctionName: false,
                        includeName: false
                    }) : undefined;
                    var _errorName_length;
                    metaMessages = [
                        errorWithParams ? "Error: ".concat(errorWithParams) : '',
                        formattedArgs && formattedArgs !== '()' ? "       ".concat([
                            ...Array((_errorName_length = errorName === null || errorName === void 0 ? void 0 : errorName.length) !== null && _errorName_length !== void 0 ? _errorName_length : 0).keys()
                        ].map(()=>' ').join('')).concat(formattedArgs) : ''
                    ];
                }
            } catch (err) {
                cause = err;
            }
        } else if (message) reason = message;
        let signature;
        if (cause instanceof abi_js_1.AbiErrorSignatureNotFoundError) {
            signature = cause.signature;
            metaMessages = [
                'Unable to decode signature "'.concat(signature, '" as it was not found on the provided ABI.'),
                'Make sure you are using the correct ABI and that the error exists on it.',
                "You can look up the decoded signature here: https://openchain.xyz/signatures?query=".concat(signature, ".")
            ];
        }
        super(reason && reason !== 'execution reverted' || signature ? [
            'The contract function "'.concat(functionName, '" reverted with the following ').concat(signature ? 'signature' : 'reason', ":"),
            reason || signature
        ].join('\n') : 'The contract function "'.concat(functionName, '" reverted.'), {
            cause,
            metaMessages,
            name: 'ContractFunctionRevertedError'
        });
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "raw", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "reason", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "signature", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.data = decodedData;
        this.raw = data;
        this.reason = reason;
        this.signature = signature;
    }
}
exports.ContractFunctionRevertedError = ContractFunctionRevertedError;
class ContractFunctionZeroDataError extends base_js_1.BaseError {
    constructor({ functionName }){
        super('The contract function "'.concat(functionName, '" returned no data ("0x").'), {
            metaMessages: [
                'This could be due to any of the following:',
                '  - The contract does not have the function "'.concat(functionName, '",'),
                '  - The parameters passed to the contract function may be invalid, or',
                '  - The address is not a contract.'
            ],
            name: 'ContractFunctionZeroDataError'
        });
    }
}
exports.ContractFunctionZeroDataError = ContractFunctionZeroDataError;
class CounterfactualDeploymentFailedError extends base_js_1.BaseError {
    constructor({ factory }){
        super("Deployment for counterfactual contract call failed".concat(factory ? ' for factory "'.concat(factory, '".') : ''), {
            metaMessages: [
                'Please ensure:',
                '- The `factory` is a valid contract deployment factory (ie. Create2 Factory, ERC-4337 Factory, etc).',
                '- The `factoryData` is a valid encoded function call for contract deployment function on the factory.'
            ],
            name: 'CounterfactualDeploymentFailedError'
        });
    }
}
exports.CounterfactualDeploymentFailedError = CounterfactualDeploymentFailedError;
class RawContractError extends base_js_1.BaseError {
    constructor({ data, message }){
        super(message || '', {
            name: 'RawContractError'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 3
        });
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.data = data;
    }
}
exports.RawContractError = RawContractError; //# sourceMappingURL=contract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TimeoutError = exports.SocketClosedError = exports.RpcRequestError = exports.WebSocketRequestError = exports.HttpRequestError = void 0;
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const utils_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/utils.js [app-client] (ecmascript)");
class HttpRequestError extends base_js_1.BaseError {
    constructor({ body, cause, details, headers, status, url }){
        super('HTTP request failed.', {
            cause,
            details,
            metaMessages: [
                status && "Status: ".concat(status),
                "URL: ".concat((0, utils_js_1.getUrl)(url)),
                body && "Request body: ".concat((0, stringify_js_1.stringify)(body))
            ].filter(Boolean),
            name: 'HttpRequestError'
        });
        Object.defineProperty(this, "body", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "headers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "status", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "url", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.body = body;
        this.headers = headers;
        this.status = status;
        this.url = url;
    }
}
exports.HttpRequestError = HttpRequestError;
class WebSocketRequestError extends base_js_1.BaseError {
    constructor({ body, cause, details, url }){
        super('WebSocket request failed.', {
            cause,
            details,
            metaMessages: [
                "URL: ".concat((0, utils_js_1.getUrl)(url)),
                body && "Request body: ".concat((0, stringify_js_1.stringify)(body))
            ].filter(Boolean),
            name: 'WebSocketRequestError'
        });
    }
}
exports.WebSocketRequestError = WebSocketRequestError;
class RpcRequestError extends base_js_1.BaseError {
    constructor({ body, error, url }){
        super('RPC Request failed.', {
            cause: error,
            details: error.message,
            metaMessages: [
                "URL: ".concat((0, utils_js_1.getUrl)(url)),
                "Request body: ".concat((0, stringify_js_1.stringify)(body))
            ],
            name: 'RpcRequestError'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.code = error.code;
        this.data = error.data;
    }
}
exports.RpcRequestError = RpcRequestError;
class SocketClosedError extends base_js_1.BaseError {
    constructor({ url } = {}){
        super('The socket has been closed.', {
            metaMessages: [
                url && "URL: ".concat((0, utils_js_1.getUrl)(url))
            ].filter(Boolean),
            name: 'SocketClosedError'
        });
    }
}
exports.SocketClosedError = SocketClosedError;
class TimeoutError extends base_js_1.BaseError {
    constructor({ body, url }){
        super('The request took too long to respond.', {
            details: 'The request timed out.',
            metaMessages: [
                "URL: ".concat((0, utils_js_1.getUrl)(url)),
                "Request body: ".concat((0, stringify_js_1.stringify)(body))
            ],
            name: 'TimeoutError'
        });
    }
}
exports.TimeoutError = TimeoutError; //# sourceMappingURL=request.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.UnknownRpcError = exports.AtomicityNotSupportedError = exports.AtomicReadyWalletRejectedUpgradeError = exports.BundleTooLargeError = exports.UnknownBundleIdError = exports.DuplicateIdError = exports.UnsupportedChainIdError = exports.UnsupportedNonOptionalCapabilityError = exports.SwitchChainError = exports.ChainDisconnectedError = exports.ProviderDisconnectedError = exports.UnsupportedProviderMethodError = exports.UnauthorizedProviderError = exports.UserRejectedRequestError = exports.JsonRpcVersionUnsupportedError = exports.LimitExceededRpcError = exports.MethodNotSupportedRpcError = exports.TransactionRejectedRpcError = exports.ResourceUnavailableRpcError = exports.ResourceNotFoundRpcError = exports.InvalidInputRpcError = exports.InternalRpcError = exports.InvalidParamsRpcError = exports.MethodNotFoundRpcError = exports.InvalidRequestRpcError = exports.ParseRpcError = exports.ProviderRpcError = exports.RpcError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const unknownErrorCode = -1;
class RpcError extends base_js_1.BaseError {
    constructor(cause, { code, docsPath, metaMessages, name, shortMessage }){
        super(shortMessage, {
            cause,
            docsPath,
            metaMessages: metaMessages || (cause === null || cause === void 0 ? void 0 : cause.metaMessages),
            name: name || 'RpcError'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.name = name || cause.name;
        this.code = cause instanceof request_js_1.RpcRequestError ? cause.code : code !== null && code !== void 0 ? code : unknownErrorCode;
    }
}
exports.RpcError = RpcError;
class ProviderRpcError extends RpcError {
    constructor(cause, options){
        super(cause, options);
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.data = options.data;
    }
}
exports.ProviderRpcError = ProviderRpcError;
class ParseRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: ParseRpcError.code,
            name: 'ParseRpcError',
            shortMessage: 'Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text.'
        });
    }
}
exports.ParseRpcError = ParseRpcError;
Object.defineProperty(ParseRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32700
});
class InvalidRequestRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: InvalidRequestRpcError.code,
            name: 'InvalidRequestRpcError',
            shortMessage: 'JSON is not a valid request object.'
        });
    }
}
exports.InvalidRequestRpcError = InvalidRequestRpcError;
Object.defineProperty(InvalidRequestRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32600
});
class MethodNotFoundRpcError extends RpcError {
    constructor(cause, { method } = {}){
        super(cause, {
            code: MethodNotFoundRpcError.code,
            name: 'MethodNotFoundRpcError',
            shortMessage: "The method".concat(method ? ' "'.concat(method, '"') : '', " does not exist / is not available.")
        });
    }
}
exports.MethodNotFoundRpcError = MethodNotFoundRpcError;
Object.defineProperty(MethodNotFoundRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32601
});
class InvalidParamsRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: InvalidParamsRpcError.code,
            name: 'InvalidParamsRpcError',
            shortMessage: [
                'Invalid parameters were provided to the RPC method.',
                'Double check you have provided the correct parameters.'
            ].join('\n')
        });
    }
}
exports.InvalidParamsRpcError = InvalidParamsRpcError;
Object.defineProperty(InvalidParamsRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32602
});
class InternalRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: InternalRpcError.code,
            name: 'InternalRpcError',
            shortMessage: 'An internal error was received.'
        });
    }
}
exports.InternalRpcError = InternalRpcError;
Object.defineProperty(InternalRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32603
});
class InvalidInputRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: InvalidInputRpcError.code,
            name: 'InvalidInputRpcError',
            shortMessage: [
                'Missing or invalid parameters.',
                'Double check you have provided the correct parameters.'
            ].join('\n')
        });
    }
}
exports.InvalidInputRpcError = InvalidInputRpcError;
Object.defineProperty(InvalidInputRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32000
});
class ResourceNotFoundRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: ResourceNotFoundRpcError.code,
            name: 'ResourceNotFoundRpcError',
            shortMessage: 'Requested resource not found.'
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'ResourceNotFoundRpcError'
        });
    }
}
exports.ResourceNotFoundRpcError = ResourceNotFoundRpcError;
Object.defineProperty(ResourceNotFoundRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32001
});
class ResourceUnavailableRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: ResourceUnavailableRpcError.code,
            name: 'ResourceUnavailableRpcError',
            shortMessage: 'Requested resource not available.'
        });
    }
}
exports.ResourceUnavailableRpcError = ResourceUnavailableRpcError;
Object.defineProperty(ResourceUnavailableRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32002
});
class TransactionRejectedRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: TransactionRejectedRpcError.code,
            name: 'TransactionRejectedRpcError',
            shortMessage: 'Transaction creation failed.'
        });
    }
}
exports.TransactionRejectedRpcError = TransactionRejectedRpcError;
Object.defineProperty(TransactionRejectedRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32003
});
class MethodNotSupportedRpcError extends RpcError {
    constructor(cause, { method } = {}){
        super(cause, {
            code: MethodNotSupportedRpcError.code,
            name: 'MethodNotSupportedRpcError',
            shortMessage: "Method".concat(method ? ' "'.concat(method, '"') : '', " is not supported.")
        });
    }
}
exports.MethodNotSupportedRpcError = MethodNotSupportedRpcError;
Object.defineProperty(MethodNotSupportedRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32004
});
class LimitExceededRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            code: LimitExceededRpcError.code,
            name: 'LimitExceededRpcError',
            shortMessage: 'Request exceeds defined limit.'
        });
    }
}
exports.LimitExceededRpcError = LimitExceededRpcError;
Object.defineProperty(LimitExceededRpcError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32005
});
class JsonRpcVersionUnsupportedError extends RpcError {
    constructor(cause){
        super(cause, {
            code: JsonRpcVersionUnsupportedError.code,
            name: 'JsonRpcVersionUnsupportedError',
            shortMessage: 'Version of JSON-RPC protocol is not supported.'
        });
    }
}
exports.JsonRpcVersionUnsupportedError = JsonRpcVersionUnsupportedError;
Object.defineProperty(JsonRpcVersionUnsupportedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32006
});
class UserRejectedRequestError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: UserRejectedRequestError.code,
            name: 'UserRejectedRequestError',
            shortMessage: 'User rejected the request.'
        });
    }
}
exports.UserRejectedRequestError = UserRejectedRequestError;
Object.defineProperty(UserRejectedRequestError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4001
});
class UnauthorizedProviderError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: UnauthorizedProviderError.code,
            name: 'UnauthorizedProviderError',
            shortMessage: 'The requested method and/or account has not been authorized by the user.'
        });
    }
}
exports.UnauthorizedProviderError = UnauthorizedProviderError;
Object.defineProperty(UnauthorizedProviderError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4100
});
class UnsupportedProviderMethodError extends ProviderRpcError {
    constructor(cause, { method } = {}){
        super(cause, {
            code: UnsupportedProviderMethodError.code,
            name: 'UnsupportedProviderMethodError',
            shortMessage: "The Provider does not support the requested method".concat(method ? ' " '.concat(method, '"') : '', ".")
        });
    }
}
exports.UnsupportedProviderMethodError = UnsupportedProviderMethodError;
Object.defineProperty(UnsupportedProviderMethodError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4200
});
class ProviderDisconnectedError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: ProviderDisconnectedError.code,
            name: 'ProviderDisconnectedError',
            shortMessage: 'The Provider is disconnected from all chains.'
        });
    }
}
exports.ProviderDisconnectedError = ProviderDisconnectedError;
Object.defineProperty(ProviderDisconnectedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4900
});
class ChainDisconnectedError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: ChainDisconnectedError.code,
            name: 'ChainDisconnectedError',
            shortMessage: 'The Provider is not connected to the requested chain.'
        });
    }
}
exports.ChainDisconnectedError = ChainDisconnectedError;
Object.defineProperty(ChainDisconnectedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4901
});
class SwitchChainError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: SwitchChainError.code,
            name: 'SwitchChainError',
            shortMessage: 'An error occurred when attempting to switch chain.'
        });
    }
}
exports.SwitchChainError = SwitchChainError;
Object.defineProperty(SwitchChainError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4902
});
class UnsupportedNonOptionalCapabilityError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: UnsupportedNonOptionalCapabilityError.code,
            name: 'UnsupportedNonOptionalCapabilityError',
            shortMessage: 'This Wallet does not support a capability that was not marked as optional.'
        });
    }
}
exports.UnsupportedNonOptionalCapabilityError = UnsupportedNonOptionalCapabilityError;
Object.defineProperty(UnsupportedNonOptionalCapabilityError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5700
});
class UnsupportedChainIdError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: UnsupportedChainIdError.code,
            name: 'UnsupportedChainIdError',
            shortMessage: 'This Wallet does not support the requested chain ID.'
        });
    }
}
exports.UnsupportedChainIdError = UnsupportedChainIdError;
Object.defineProperty(UnsupportedChainIdError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5710
});
class DuplicateIdError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: DuplicateIdError.code,
            name: 'DuplicateIdError',
            shortMessage: 'There is already a bundle submitted with this ID.'
        });
    }
}
exports.DuplicateIdError = DuplicateIdError;
Object.defineProperty(DuplicateIdError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5720
});
class UnknownBundleIdError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: UnknownBundleIdError.code,
            name: 'UnknownBundleIdError',
            shortMessage: 'This bundle id is unknown / has not been submitted'
        });
    }
}
exports.UnknownBundleIdError = UnknownBundleIdError;
Object.defineProperty(UnknownBundleIdError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5730
});
class BundleTooLargeError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: BundleTooLargeError.code,
            name: 'BundleTooLargeError',
            shortMessage: 'The call bundle is too large for the Wallet to process.'
        });
    }
}
exports.BundleTooLargeError = BundleTooLargeError;
Object.defineProperty(BundleTooLargeError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5740
});
class AtomicReadyWalletRejectedUpgradeError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: AtomicReadyWalletRejectedUpgradeError.code,
            name: 'AtomicReadyWalletRejectedUpgradeError',
            shortMessage: 'The Wallet can support atomicity after an upgrade, but the user rejected the upgrade.'
        });
    }
}
exports.AtomicReadyWalletRejectedUpgradeError = AtomicReadyWalletRejectedUpgradeError;
Object.defineProperty(AtomicReadyWalletRejectedUpgradeError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5750
});
class AtomicityNotSupportedError extends ProviderRpcError {
    constructor(cause){
        super(cause, {
            code: AtomicityNotSupportedError.code,
            name: 'AtomicityNotSupportedError',
            shortMessage: 'The wallet does not support atomic execution but the request requires it.'
        });
    }
}
exports.AtomicityNotSupportedError = AtomicityNotSupportedError;
Object.defineProperty(AtomicityNotSupportedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5760
});
class UnknownRpcError extends RpcError {
    constructor(cause){
        super(cause, {
            name: 'UnknownRpcError',
            shortMessage: 'An unknown RPC error occurred.'
        });
    }
}
exports.UnknownRpcError = UnknownRpcError; //# sourceMappingURL=rpc.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getContractError = getContractError;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
const EXECUTION_REVERTED_ERROR_CODE = 3;
function getContractError(err, param) {
    let { abi, address, args, docsPath, functionName, sender } = param;
    const error = err instanceof contract_js_1.RawContractError ? err : err instanceof base_js_1.BaseError ? err.walk((err)=>'data' in err) || err.walk() : {};
    const { code, data, details, message, shortMessage } = error;
    const cause = (()=>{
        if (err instanceof abi_js_1.AbiDecodingZeroDataError) return new contract_js_1.ContractFunctionZeroDataError({
            functionName
        });
        if ([
            EXECUTION_REVERTED_ERROR_CODE,
            rpc_js_1.InternalRpcError.code
        ].includes(code) && (data || details || message || shortMessage)) {
            return new contract_js_1.ContractFunctionRevertedError({
                abi,
                data: typeof data === 'object' ? data.data : data,
                functionName,
                message: error instanceof request_js_1.RpcRequestError ? details : shortMessage !== null && shortMessage !== void 0 ? shortMessage : message
            });
        }
        return err;
    })();
    return new contract_js_1.ContractFunctionExecutionError(cause, {
        abi,
        args,
        contractAddress: address,
        docsPath,
        functionName,
        sender
    });
} //# sourceMappingURL=getContractError.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/publicKeyToAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.publicKeyToAddress = publicKeyToAddress;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
function publicKeyToAddress(publicKey) {
    const address = (0, keccak256_js_1.keccak256)("0x".concat(publicKey.substring(4))).substring(26);
    return (0, getAddress_js_1.checksumAddress)("0x".concat(address));
} //# sourceMappingURL=publicKeyToAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverPublicKey.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverPublicKey = recoverPublicKey;
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function recoverPublicKey(param) {
    let { hash, signature } = param;
    const hashHex = (0, isHex_js_1.isHex)(hash) ? hash : (0, toHex_js_1.toHex)(hash);
    const { secp256k1 } = await Promise.resolve().then(()=>__turbopack_context__.r("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/secp256k1.js [app-client] (ecmascript)"));
    const signature_ = (()=>{
        if (typeof signature === 'object' && 'r' in signature && 's' in signature) {
            const { r, s, v, yParity } = signature;
            const yParityOrV = Number(yParity !== null && yParity !== void 0 ? yParity : v);
            const recoveryBit = toRecoveryBit(yParityOrV);
            return new secp256k1.Signature((0, fromHex_js_1.hexToBigInt)(r), (0, fromHex_js_1.hexToBigInt)(s)).addRecoveryBit(recoveryBit);
        }
        const signatureHex = (0, isHex_js_1.isHex)(signature) ? signature : (0, toHex_js_1.toHex)(signature);
        if ((0, size_js_1.size)(signatureHex) !== 65) throw new Error('invalid signature length');
        const yParityOrV = (0, fromHex_js_1.hexToNumber)("0x".concat(signatureHex.slice(130)));
        const recoveryBit = toRecoveryBit(yParityOrV);
        return secp256k1.Signature.fromCompact(signatureHex.substring(2, 130)).addRecoveryBit(recoveryBit);
    })();
    const publicKey = signature_.recoverPublicKey(hashHex.substring(2)).toHex(false);
    return "0x".concat(publicKey);
}
function toRecoveryBit(yParityOrV) {
    if (yParityOrV === 0 || yParityOrV === 1) return yParityOrV;
    if (yParityOrV === 27) return 0;
    if (yParityOrV === 28) return 1;
    throw new Error('Invalid yParityOrV value');
} //# sourceMappingURL=recoverPublicKey.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverAddress = recoverAddress;
const publicKeyToAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/publicKeyToAddress.js [app-client] (ecmascript)");
const recoverPublicKey_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverPublicKey.js [app-client] (ecmascript)");
async function recoverAddress(param) {
    let { hash, signature } = param;
    return (0, publicKeyToAddress_js_1.publicKeyToAddress)(await (0, recoverPublicKey_js_1.recoverPublicKey)({
        hash,
        signature
    }));
} //# sourceMappingURL=recoverAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toRlp.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toRlp = toRlp;
exports.bytesToRlp = bytesToRlp;
exports.hexToRlp = hexToRlp;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/cursor.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function toRlp(bytes) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'hex';
    const encodable = getEncodable(bytes);
    const cursor = (0, cursor_js_1.createCursor)(new Uint8Array(encodable.length));
    encodable.encode(cursor);
    if (to === 'hex') return (0, toHex_js_1.bytesToHex)(cursor.bytes);
    return cursor.bytes;
}
function bytesToRlp(bytes) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'bytes';
    return toRlp(bytes, to);
}
function hexToRlp(hex) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'hex';
    return toRlp(hex, to);
}
function getEncodable(bytes) {
    if (Array.isArray(bytes)) return getEncodableList(bytes.map((x)=>getEncodable(x)));
    return getEncodableBytes(bytes);
}
function getEncodableList(list) {
    const bodyLength = list.reduce((acc, x)=>acc + x.length, 0);
    const sizeOfBodyLength = getSizeOfLength(bodyLength);
    const length = (()=>{
        if (bodyLength <= 55) return 1 + bodyLength;
        return 1 + sizeOfBodyLength + bodyLength;
    })();
    return {
        length,
        encode (cursor) {
            if (bodyLength <= 55) {
                cursor.pushByte(0xc0 + bodyLength);
            } else {
                cursor.pushByte(0xc0 + 55 + sizeOfBodyLength);
                if (sizeOfBodyLength === 1) cursor.pushUint8(bodyLength);
                else if (sizeOfBodyLength === 2) cursor.pushUint16(bodyLength);
                else if (sizeOfBodyLength === 3) cursor.pushUint24(bodyLength);
                else cursor.pushUint32(bodyLength);
            }
            for (const { encode } of list){
                encode(cursor);
            }
        }
    };
}
function getEncodableBytes(bytesOrHex) {
    const bytes = typeof bytesOrHex === 'string' ? (0, toBytes_js_1.hexToBytes)(bytesOrHex) : bytesOrHex;
    const sizeOfBytesLength = getSizeOfLength(bytes.length);
    const length = (()=>{
        if (bytes.length === 1 && bytes[0] < 0x80) return 1;
        if (bytes.length <= 55) return 1 + bytes.length;
        return 1 + sizeOfBytesLength + bytes.length;
    })();
    return {
        length,
        encode (cursor) {
            if (bytes.length === 1 && bytes[0] < 0x80) {
                cursor.pushBytes(bytes);
            } else if (bytes.length <= 55) {
                cursor.pushByte(0x80 + bytes.length);
                cursor.pushBytes(bytes);
            } else {
                cursor.pushByte(0x80 + 55 + sizeOfBytesLength);
                if (sizeOfBytesLength === 1) cursor.pushUint8(bytes.length);
                else if (sizeOfBytesLength === 2) cursor.pushUint16(bytes.length);
                else if (sizeOfBytesLength === 3) cursor.pushUint24(bytes.length);
                else cursor.pushUint32(bytes.length);
                cursor.pushBytes(bytes);
            }
        }
    };
}
function getSizeOfLength(length) {
    if (length < 2 ** 8) return 1;
    if (length < 2 ** 16) return 2;
    if (length < 2 ** 24) return 3;
    if (length < 2 ** 32) return 4;
    throw new base_js_1.BaseError('Length is too large.');
} //# sourceMappingURL=toRlp.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/hashAuthorization.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.hashAuthorization = hashAuthorization;
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const toRlp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toRlp.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
function hashAuthorization(parameters) {
    const { chainId, nonce, to } = parameters;
    var _parameters_contractAddress;
    const address = (_parameters_contractAddress = parameters.contractAddress) !== null && _parameters_contractAddress !== void 0 ? _parameters_contractAddress : parameters.address;
    const hash = (0, keccak256_js_1.keccak256)((0, concat_js_1.concatHex)([
        '0x05',
        (0, toRlp_js_1.toRlp)([
            chainId ? (0, toHex_js_1.numberToHex)(chainId) : '0x',
            address,
            nonce ? (0, toHex_js_1.numberToHex)(nonce) : '0x'
        ])
    ]));
    if (to === 'bytes') return (0, toBytes_js_1.hexToBytes)(hash);
    return hash;
} //# sourceMappingURL=hashAuthorization.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/recoverAuthorizationAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverAuthorizationAddress = recoverAuthorizationAddress;
const recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
const hashAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/hashAuthorization.js [app-client] (ecmascript)");
async function recoverAuthorizationAddress(parameters) {
    const { authorization, signature } = parameters;
    return (0, recoverAddress_js_1.recoverAddress)({
        hash: (0, hashAuthorization_js_1.hashAuthorization)(authorization),
        signature: signature !== null && signature !== void 0 ? signature : authorization
    });
} //# sourceMappingURL=recoverAuthorizationAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/estimateGas.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.EstimateGasExecutionError = void 0;
const formatEther_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatEther.js [app-client] (ecmascript)");
const formatGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
class EstimateGasExecutionError extends base_js_1.BaseError {
    constructor(cause, { account, docsPath, chain, data, gas, gasPrice, maxFeePerGas, maxPriorityFeePerGas, nonce, to, value }){
        var _chain_nativeCurrency;
        const prettyArgs = (0, transaction_js_1.prettyPrint)({
            from: account === null || account === void 0 ? void 0 : account.address,
            to,
            value: typeof value !== 'undefined' && "".concat((0, formatEther_js_1.formatEther)(value), " ").concat((chain === null || chain === void 0 ? void 0 : (_chain_nativeCurrency = chain.nativeCurrency) === null || _chain_nativeCurrency === void 0 ? void 0 : _chain_nativeCurrency.symbol) || 'ETH'),
            data,
            gas,
            gasPrice: typeof gasPrice !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(gasPrice), " gwei"),
            maxFeePerGas: typeof maxFeePerGas !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(maxFeePerGas), " gwei"),
            maxPriorityFeePerGas: typeof maxPriorityFeePerGas !== 'undefined' && "".concat((0, formatGwei_js_1.formatGwei)(maxPriorityFeePerGas), " gwei"),
            nonce
        });
        super(cause.shortMessage, {
            cause,
            docsPath,
            metaMessages: [
                ...cause.metaMessages ? [
                    ...cause.metaMessages,
                    ' '
                ] : [],
                'Estimate Gas Arguments:',
                prettyArgs
            ].filter(Boolean),
            name: 'EstimateGasExecutionError'
        });
        Object.defineProperty(this, "cause", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.cause = cause;
    }
}
exports.EstimateGasExecutionError = EstimateGasExecutionError; //# sourceMappingURL=estimateGas.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.UnknownNodeError = exports.TipAboveFeeCapError = exports.TransactionTypeNotSupportedError = exports.IntrinsicGasTooLowError = exports.IntrinsicGasTooHighError = exports.InsufficientFundsError = exports.NonceMaxValueError = exports.NonceTooLowError = exports.NonceTooHighError = exports.FeeCapTooLowError = exports.FeeCapTooHighError = exports.ExecutionRevertedError = void 0;
const formatGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class ExecutionRevertedError extends base_js_1.BaseError {
    constructor({ cause, message } = {}){
        var _message_replace;
        const reason = message === null || message === void 0 ? void 0 : (_message_replace = message.replace('execution reverted: ', '')) === null || _message_replace === void 0 ? void 0 : _message_replace.replace('execution reverted', '');
        super("Execution reverted ".concat(reason ? "with reason: ".concat(reason) : 'for an unknown reason', "."), {
            cause,
            name: 'ExecutionRevertedError'
        });
    }
}
exports.ExecutionRevertedError = ExecutionRevertedError;
Object.defineProperty(ExecutionRevertedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 3
});
Object.defineProperty(ExecutionRevertedError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /execution reverted/
});
class FeeCapTooHighError extends base_js_1.BaseError {
    constructor({ cause, maxFeePerGas } = {}){
        super("The fee cap (`maxFeePerGas`".concat(maxFeePerGas ? " = ".concat((0, formatGwei_js_1.formatGwei)(maxFeePerGas), " gwei") : '', ") cannot be higher than the maximum allowed value (2^256-1)."), {
            cause,
            name: 'FeeCapTooHighError'
        });
    }
}
exports.FeeCapTooHighError = FeeCapTooHighError;
Object.defineProperty(FeeCapTooHighError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /max fee per gas higher than 2\^256-1|fee cap higher than 2\^256-1/
});
class FeeCapTooLowError extends base_js_1.BaseError {
    constructor({ cause, maxFeePerGas } = {}){
        super("The fee cap (`maxFeePerGas`".concat(maxFeePerGas ? " = ".concat((0, formatGwei_js_1.formatGwei)(maxFeePerGas)) : '', " gwei) cannot be lower than the block base fee."), {
            cause,
            name: 'FeeCapTooLowError'
        });
    }
}
exports.FeeCapTooLowError = FeeCapTooLowError;
Object.defineProperty(FeeCapTooLowError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /max fee per gas less than block base fee|fee cap less than block base fee|transaction is outdated/
});
class NonceTooHighError extends base_js_1.BaseError {
    constructor({ cause, nonce } = {}){
        super("Nonce provided for the transaction ".concat(nonce ? "(".concat(nonce, ") ") : '', "is higher than the next one expected."), {
            cause,
            name: 'NonceTooHighError'
        });
    }
}
exports.NonceTooHighError = NonceTooHighError;
Object.defineProperty(NonceTooHighError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /nonce too high/
});
class NonceTooLowError extends base_js_1.BaseError {
    constructor({ cause, nonce } = {}){
        super([
            "Nonce provided for the transaction ".concat(nonce ? "(".concat(nonce, ") ") : '', "is lower than the current nonce of the account."),
            'Try increasing the nonce or find the latest nonce with `getTransactionCount`.'
        ].join('\n'), {
            cause,
            name: 'NonceTooLowError'
        });
    }
}
exports.NonceTooLowError = NonceTooLowError;
Object.defineProperty(NonceTooLowError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /nonce too low|transaction already imported|already known/
});
class NonceMaxValueError extends base_js_1.BaseError {
    constructor({ cause, nonce } = {}){
        super("Nonce provided for the transaction ".concat(nonce ? "(".concat(nonce, ") ") : '', "exceeds the maximum allowed nonce."), {
            cause,
            name: 'NonceMaxValueError'
        });
    }
}
exports.NonceMaxValueError = NonceMaxValueError;
Object.defineProperty(NonceMaxValueError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /nonce has max value/
});
class InsufficientFundsError extends base_js_1.BaseError {
    constructor({ cause } = {}){
        super([
            'The total cost (gas * gas fee + value) of executing this transaction exceeds the balance of the account.'
        ].join('\n'), {
            cause,
            metaMessages: [
                'This error could arise when the account does not have enough funds to:',
                ' - pay for the total gas fee,',
                ' - pay for the value to send.',
                ' ',
                'The cost of the transaction is calculated as `gas * gas fee + value`, where:',
                ' - `gas` is the amount of gas needed for transaction to execute,',
                ' - `gas fee` is the gas fee,',
                ' - `value` is the amount of ether to send to the recipient.'
            ],
            name: 'InsufficientFundsError'
        });
    }
}
exports.InsufficientFundsError = InsufficientFundsError;
Object.defineProperty(InsufficientFundsError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /insufficient funds|exceeds transaction sender account balance/
});
class IntrinsicGasTooHighError extends base_js_1.BaseError {
    constructor({ cause, gas } = {}){
        super("The amount of gas ".concat(gas ? "(".concat(gas, ") ") : '', "provided for the transaction exceeds the limit allowed for the block."), {
            cause,
            name: 'IntrinsicGasTooHighError'
        });
    }
}
exports.IntrinsicGasTooHighError = IntrinsicGasTooHighError;
Object.defineProperty(IntrinsicGasTooHighError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /intrinsic gas too high|gas limit reached/
});
class IntrinsicGasTooLowError extends base_js_1.BaseError {
    constructor({ cause, gas } = {}){
        super("The amount of gas ".concat(gas ? "(".concat(gas, ") ") : '', "provided for the transaction is too low."), {
            cause,
            name: 'IntrinsicGasTooLowError'
        });
    }
}
exports.IntrinsicGasTooLowError = IntrinsicGasTooLowError;
Object.defineProperty(IntrinsicGasTooLowError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /intrinsic gas too low/
});
class TransactionTypeNotSupportedError extends base_js_1.BaseError {
    constructor({ cause }){
        super('The transaction type is not supported for this chain.', {
            cause,
            name: 'TransactionTypeNotSupportedError'
        });
    }
}
exports.TransactionTypeNotSupportedError = TransactionTypeNotSupportedError;
Object.defineProperty(TransactionTypeNotSupportedError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /transaction type not valid/
});
class TipAboveFeeCapError extends base_js_1.BaseError {
    constructor({ cause, maxPriorityFeePerGas, maxFeePerGas } = {}){
        super([
            "The provided tip (`maxPriorityFeePerGas`".concat(maxPriorityFeePerGas ? " = ".concat((0, formatGwei_js_1.formatGwei)(maxPriorityFeePerGas), " gwei") : '', ") cannot be higher than the fee cap (`maxFeePerGas`").concat(maxFeePerGas ? " = ".concat((0, formatGwei_js_1.formatGwei)(maxFeePerGas), " gwei") : '', ").")
        ].join('\n'), {
            cause,
            name: 'TipAboveFeeCapError'
        });
    }
}
exports.TipAboveFeeCapError = TipAboveFeeCapError;
Object.defineProperty(TipAboveFeeCapError, "nodeMessage", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: /max priority fee per gas higher than max fee per gas|tip higher than fee cap/
});
class UnknownNodeError extends base_js_1.BaseError {
    constructor({ cause }){
        super("An error occurred while executing: ".concat(cause === null || cause === void 0 ? void 0 : cause.shortMessage), {
            cause,
            name: 'UnknownNodeError'
        });
    }
}
exports.UnknownNodeError = UnknownNodeError; //# sourceMappingURL=node.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getNodeError.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.containsNodeError = containsNodeError;
exports.getNodeError = getNodeError;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
function containsNodeError(err) {
    return err instanceof rpc_js_1.TransactionRejectedRpcError || err instanceof rpc_js_1.InvalidInputRpcError || err instanceof request_js_1.RpcRequestError && err.code === node_js_1.ExecutionRevertedError.code;
}
function getNodeError(err, args) {
    const message = (err.details || '').toLowerCase();
    const executionRevertedError = err instanceof base_js_1.BaseError ? err.walk((e)=>(e === null || e === void 0 ? void 0 : e.code) === node_js_1.ExecutionRevertedError.code) : err;
    if (executionRevertedError instanceof base_js_1.BaseError) return new node_js_1.ExecutionRevertedError({
        cause: err,
        message: executionRevertedError.details
    });
    if (node_js_1.ExecutionRevertedError.nodeMessage.test(message)) return new node_js_1.ExecutionRevertedError({
        cause: err,
        message: err.details
    });
    if (node_js_1.FeeCapTooHighError.nodeMessage.test(message)) return new node_js_1.FeeCapTooHighError({
        cause: err,
        maxFeePerGas: args === null || args === void 0 ? void 0 : args.maxFeePerGas
    });
    if (node_js_1.FeeCapTooLowError.nodeMessage.test(message)) return new node_js_1.FeeCapTooLowError({
        cause: err,
        maxFeePerGas: args === null || args === void 0 ? void 0 : args.maxFeePerGas
    });
    if (node_js_1.NonceTooHighError.nodeMessage.test(message)) return new node_js_1.NonceTooHighError({
        cause: err,
        nonce: args === null || args === void 0 ? void 0 : args.nonce
    });
    if (node_js_1.NonceTooLowError.nodeMessage.test(message)) return new node_js_1.NonceTooLowError({
        cause: err,
        nonce: args === null || args === void 0 ? void 0 : args.nonce
    });
    if (node_js_1.NonceMaxValueError.nodeMessage.test(message)) return new node_js_1.NonceMaxValueError({
        cause: err,
        nonce: args === null || args === void 0 ? void 0 : args.nonce
    });
    if (node_js_1.InsufficientFundsError.nodeMessage.test(message)) return new node_js_1.InsufficientFundsError({
        cause: err
    });
    if (node_js_1.IntrinsicGasTooHighError.nodeMessage.test(message)) return new node_js_1.IntrinsicGasTooHighError({
        cause: err,
        gas: args === null || args === void 0 ? void 0 : args.gas
    });
    if (node_js_1.IntrinsicGasTooLowError.nodeMessage.test(message)) return new node_js_1.IntrinsicGasTooLowError({
        cause: err,
        gas: args === null || args === void 0 ? void 0 : args.gas
    });
    if (node_js_1.TransactionTypeNotSupportedError.nodeMessage.test(message)) return new node_js_1.TransactionTypeNotSupportedError({
        cause: err
    });
    if (node_js_1.TipAboveFeeCapError.nodeMessage.test(message)) return new node_js_1.TipAboveFeeCapError({
        cause: err,
        maxFeePerGas: args === null || args === void 0 ? void 0 : args.maxFeePerGas,
        maxPriorityFeePerGas: args === null || args === void 0 ? void 0 : args.maxPriorityFeePerGas
    });
    return new node_js_1.UnknownNodeError({
        cause: err
    });
} //# sourceMappingURL=getNodeError.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getEstimateGasError.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEstimateGasError = getEstimateGasError;
const estimateGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/estimateGas.js [app-client] (ecmascript)");
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const getNodeError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getNodeError.js [app-client] (ecmascript)");
function getEstimateGasError(err, param) {
    let { docsPath, ...args } = param;
    const cause = (()=>{
        const cause = (0, getNodeError_js_1.getNodeError)(err, args);
        if (cause instanceof node_js_1.UnknownNodeError) return err;
        return cause;
    })();
    return new estimateGas_js_1.EstimateGasExecutionError(cause, {
        docsPath,
        ...args
    });
} //# sourceMappingURL=getEstimateGasError.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.extract = extract;
function extract(value_, param) {
    let { format } = param;
    if (!format) return {};
    const value = {};
    function extract_(formatted) {
        const keys = Object.keys(formatted);
        for (const key of keys){
            if (key in value_) value[key] = value_[key];
            if (formatted[key] && typeof formatted[key] === 'object' && !Array.isArray(formatted[key])) extract_(formatted[key]);
        }
    }
    const formatted = format(value_ || {});
    extract_(formatted);
    return value;
} //# sourceMappingURL=extract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/formatter.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineFormatter = defineFormatter;
function defineFormatter(type, format) {
    return (param)=>{
        let { exclude, format: overrides } = param;
        return {
            exclude,
            format: (args, action)=>{
                const formatted = format(args, action);
                if (exclude) {
                    for (const key of exclude){
                        delete formatted[key];
                    }
                }
                return {
                    ...formatted,
                    ...overrides(args, action)
                };
            },
            type
        };
    };
} //# sourceMappingURL=formatter.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineTransactionRequest = exports.rpcTransactionType = void 0;
exports.formatTransactionRequest = formatTransactionRequest;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const formatter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/formatter.js [app-client] (ecmascript)");
exports.rpcTransactionType = {
    legacy: '0x0',
    eip2930: '0x1',
    eip1559: '0x2',
    eip4844: '0x3',
    eip7702: '0x4'
};
function formatTransactionRequest(request, _) {
    const rpcRequest = {};
    if (typeof request.authorizationList !== 'undefined') rpcRequest.authorizationList = formatAuthorizationList(request.authorizationList);
    if (typeof request.accessList !== 'undefined') rpcRequest.accessList = request.accessList;
    if (typeof request.blobVersionedHashes !== 'undefined') rpcRequest.blobVersionedHashes = request.blobVersionedHashes;
    if (typeof request.blobs !== 'undefined') {
        if (typeof request.blobs[0] !== 'string') rpcRequest.blobs = request.blobs.map((x)=>(0, toHex_js_1.bytesToHex)(x));
        else rpcRequest.blobs = request.blobs;
    }
    if (typeof request.data !== 'undefined') rpcRequest.data = request.data;
    if (request.account) rpcRequest.from = request.account.address;
    if (typeof request.from !== 'undefined') rpcRequest.from = request.from;
    if (typeof request.gas !== 'undefined') rpcRequest.gas = (0, toHex_js_1.numberToHex)(request.gas);
    if (typeof request.gasPrice !== 'undefined') rpcRequest.gasPrice = (0, toHex_js_1.numberToHex)(request.gasPrice);
    if (typeof request.maxFeePerBlobGas !== 'undefined') rpcRequest.maxFeePerBlobGas = (0, toHex_js_1.numberToHex)(request.maxFeePerBlobGas);
    if (typeof request.maxFeePerGas !== 'undefined') rpcRequest.maxFeePerGas = (0, toHex_js_1.numberToHex)(request.maxFeePerGas);
    if (typeof request.maxPriorityFeePerGas !== 'undefined') rpcRequest.maxPriorityFeePerGas = (0, toHex_js_1.numberToHex)(request.maxPriorityFeePerGas);
    if (typeof request.nonce !== 'undefined') rpcRequest.nonce = (0, toHex_js_1.numberToHex)(request.nonce);
    if (typeof request.to !== 'undefined') rpcRequest.to = request.to;
    if (typeof request.type !== 'undefined') rpcRequest.type = exports.rpcTransactionType[request.type];
    if (typeof request.value !== 'undefined') rpcRequest.value = (0, toHex_js_1.numberToHex)(request.value);
    return rpcRequest;
}
exports.defineTransactionRequest = (0, formatter_js_1.defineFormatter)('transactionRequest', formatTransactionRequest);
function formatAuthorizationList(authorizationList) {
    return authorizationList.map((authorization)=>({
            address: authorization.address,
            r: authorization.r ? (0, toHex_js_1.numberToHex)(BigInt(authorization.r)) : authorization.r,
            s: authorization.s ? (0, toHex_js_1.numberToHex)(BigInt(authorization.s)) : authorization.s,
            chainId: (0, toHex_js_1.numberToHex)(authorization.chainId),
            nonce: (0, toHex_js_1.numberToHex)(authorization.nonce),
            ...typeof authorization.yParity !== 'undefined' ? {
                yParity: (0, toHex_js_1.numberToHex)(authorization.yParity)
            } : {},
            ...typeof authorization.v !== 'undefined' && typeof authorization.yParity === 'undefined' ? {
                v: (0, toHex_js_1.numberToHex)(authorization.v)
            } : {}
        }));
} //# sourceMappingURL=transactionRequest.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stateOverride.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeStateMapping = serializeStateMapping;
exports.serializeAccountStateOverride = serializeAccountStateOverride;
exports.serializeStateOverride = serializeStateOverride;
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/data.js [app-client] (ecmascript)");
const stateOverride_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/stateOverride.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function serializeStateMapping(stateMapping) {
    if (!stateMapping || stateMapping.length === 0) return undefined;
    return stateMapping.reduce((acc, param)=>{
        let { slot, value } = param;
        if (slot.length !== 66) throw new data_js_1.InvalidBytesLengthError({
            size: slot.length,
            targetSize: 66,
            type: 'hex'
        });
        if (value.length !== 66) throw new data_js_1.InvalidBytesLengthError({
            size: value.length,
            targetSize: 66,
            type: 'hex'
        });
        acc[slot] = value;
        return acc;
    }, {});
}
function serializeAccountStateOverride(parameters) {
    const { balance, nonce, state, stateDiff, code } = parameters;
    const rpcAccountStateOverride = {};
    if (code !== undefined) rpcAccountStateOverride.code = code;
    if (balance !== undefined) rpcAccountStateOverride.balance = (0, toHex_js_1.numberToHex)(balance);
    if (nonce !== undefined) rpcAccountStateOverride.nonce = (0, toHex_js_1.numberToHex)(nonce);
    if (state !== undefined) rpcAccountStateOverride.state = serializeStateMapping(state);
    if (stateDiff !== undefined) {
        if (rpcAccountStateOverride.state) throw new stateOverride_js_1.StateAssignmentConflictError();
        rpcAccountStateOverride.stateDiff = serializeStateMapping(stateDiff);
    }
    return rpcAccountStateOverride;
}
function serializeStateOverride(parameters) {
    if (!parameters) return undefined;
    const rpcStateOverride = {};
    for (const { address, ...accountState } of parameters){
        if (!(0, isAddress_js_1.isAddress)(address, {
            strict: false
        })) throw new address_js_1.InvalidAddressError({
            address
        });
        if (rpcStateOverride[address]) throw new stateOverride_js_1.AccountStateConflictError({
            address: address
        });
        rpcStateOverride[address] = serializeAccountStateOverride(accountState);
    }
    return rpcStateOverride;
} //# sourceMappingURL=stateOverride.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/number.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.minInt144 = exports.minInt136 = exports.minInt128 = exports.minInt120 = exports.minInt112 = exports.minInt104 = exports.minInt96 = exports.minInt88 = exports.minInt80 = exports.minInt72 = exports.minInt64 = exports.minInt56 = exports.minInt48 = exports.minInt40 = exports.minInt32 = exports.minInt24 = exports.minInt16 = exports.minInt8 = exports.maxInt256 = exports.maxInt248 = exports.maxInt240 = exports.maxInt232 = exports.maxInt224 = exports.maxInt216 = exports.maxInt208 = exports.maxInt200 = exports.maxInt192 = exports.maxInt184 = exports.maxInt176 = exports.maxInt168 = exports.maxInt160 = exports.maxInt152 = exports.maxInt144 = exports.maxInt136 = exports.maxInt128 = exports.maxInt120 = exports.maxInt112 = exports.maxInt104 = exports.maxInt96 = exports.maxInt88 = exports.maxInt80 = exports.maxInt72 = exports.maxInt64 = exports.maxInt56 = exports.maxInt48 = exports.maxInt40 = exports.maxInt32 = exports.maxInt24 = exports.maxInt16 = exports.maxInt8 = void 0;
exports.maxUint256 = exports.maxUint248 = exports.maxUint240 = exports.maxUint232 = exports.maxUint224 = exports.maxUint216 = exports.maxUint208 = exports.maxUint200 = exports.maxUint192 = exports.maxUint184 = exports.maxUint176 = exports.maxUint168 = exports.maxUint160 = exports.maxUint152 = exports.maxUint144 = exports.maxUint136 = exports.maxUint128 = exports.maxUint120 = exports.maxUint112 = exports.maxUint104 = exports.maxUint96 = exports.maxUint88 = exports.maxUint80 = exports.maxUint72 = exports.maxUint64 = exports.maxUint56 = exports.maxUint48 = exports.maxUint40 = exports.maxUint32 = exports.maxUint24 = exports.maxUint16 = exports.maxUint8 = exports.minInt256 = exports.minInt248 = exports.minInt240 = exports.minInt232 = exports.minInt224 = exports.minInt216 = exports.minInt208 = exports.minInt200 = exports.minInt192 = exports.minInt184 = exports.minInt176 = exports.minInt168 = exports.minInt160 = exports.minInt152 = void 0;
exports.maxInt8 = 2n ** (8n - 1n) - 1n;
exports.maxInt16 = 2n ** (16n - 1n) - 1n;
exports.maxInt24 = 2n ** (24n - 1n) - 1n;
exports.maxInt32 = 2n ** (32n - 1n) - 1n;
exports.maxInt40 = 2n ** (40n - 1n) - 1n;
exports.maxInt48 = 2n ** (48n - 1n) - 1n;
exports.maxInt56 = 2n ** (56n - 1n) - 1n;
exports.maxInt64 = 2n ** (64n - 1n) - 1n;
exports.maxInt72 = 2n ** (72n - 1n) - 1n;
exports.maxInt80 = 2n ** (80n - 1n) - 1n;
exports.maxInt88 = 2n ** (88n - 1n) - 1n;
exports.maxInt96 = 2n ** (96n - 1n) - 1n;
exports.maxInt104 = 2n ** (104n - 1n) - 1n;
exports.maxInt112 = 2n ** (112n - 1n) - 1n;
exports.maxInt120 = 2n ** (120n - 1n) - 1n;
exports.maxInt128 = 2n ** (128n - 1n) - 1n;
exports.maxInt136 = 2n ** (136n - 1n) - 1n;
exports.maxInt144 = 2n ** (144n - 1n) - 1n;
exports.maxInt152 = 2n ** (152n - 1n) - 1n;
exports.maxInt160 = 2n ** (160n - 1n) - 1n;
exports.maxInt168 = 2n ** (168n - 1n) - 1n;
exports.maxInt176 = 2n ** (176n - 1n) - 1n;
exports.maxInt184 = 2n ** (184n - 1n) - 1n;
exports.maxInt192 = 2n ** (192n - 1n) - 1n;
exports.maxInt200 = 2n ** (200n - 1n) - 1n;
exports.maxInt208 = 2n ** (208n - 1n) - 1n;
exports.maxInt216 = 2n ** (216n - 1n) - 1n;
exports.maxInt224 = 2n ** (224n - 1n) - 1n;
exports.maxInt232 = 2n ** (232n - 1n) - 1n;
exports.maxInt240 = 2n ** (240n - 1n) - 1n;
exports.maxInt248 = 2n ** (248n - 1n) - 1n;
exports.maxInt256 = 2n ** (256n - 1n) - 1n;
exports.minInt8 = -(2n ** (8n - 1n));
exports.minInt16 = -(2n ** (16n - 1n));
exports.minInt24 = -(2n ** (24n - 1n));
exports.minInt32 = -(2n ** (32n - 1n));
exports.minInt40 = -(2n ** (40n - 1n));
exports.minInt48 = -(2n ** (48n - 1n));
exports.minInt56 = -(2n ** (56n - 1n));
exports.minInt64 = -(2n ** (64n - 1n));
exports.minInt72 = -(2n ** (72n - 1n));
exports.minInt80 = -(2n ** (80n - 1n));
exports.minInt88 = -(2n ** (88n - 1n));
exports.minInt96 = -(2n ** (96n - 1n));
exports.minInt104 = -(2n ** (104n - 1n));
exports.minInt112 = -(2n ** (112n - 1n));
exports.minInt120 = -(2n ** (120n - 1n));
exports.minInt128 = -(2n ** (128n - 1n));
exports.minInt136 = -(2n ** (136n - 1n));
exports.minInt144 = -(2n ** (144n - 1n));
exports.minInt152 = -(2n ** (152n - 1n));
exports.minInt160 = -(2n ** (160n - 1n));
exports.minInt168 = -(2n ** (168n - 1n));
exports.minInt176 = -(2n ** (176n - 1n));
exports.minInt184 = -(2n ** (184n - 1n));
exports.minInt192 = -(2n ** (192n - 1n));
exports.minInt200 = -(2n ** (200n - 1n));
exports.minInt208 = -(2n ** (208n - 1n));
exports.minInt216 = -(2n ** (216n - 1n));
exports.minInt224 = -(2n ** (224n - 1n));
exports.minInt232 = -(2n ** (232n - 1n));
exports.minInt240 = -(2n ** (240n - 1n));
exports.minInt248 = -(2n ** (248n - 1n));
exports.minInt256 = -(2n ** (256n - 1n));
exports.maxUint8 = 2n ** 8n - 1n;
exports.maxUint16 = 2n ** 16n - 1n;
exports.maxUint24 = 2n ** 24n - 1n;
exports.maxUint32 = 2n ** 32n - 1n;
exports.maxUint40 = 2n ** 40n - 1n;
exports.maxUint48 = 2n ** 48n - 1n;
exports.maxUint56 = 2n ** 56n - 1n;
exports.maxUint64 = 2n ** 64n - 1n;
exports.maxUint72 = 2n ** 72n - 1n;
exports.maxUint80 = 2n ** 80n - 1n;
exports.maxUint88 = 2n ** 88n - 1n;
exports.maxUint96 = 2n ** 96n - 1n;
exports.maxUint104 = 2n ** 104n - 1n;
exports.maxUint112 = 2n ** 112n - 1n;
exports.maxUint120 = 2n ** 120n - 1n;
exports.maxUint128 = 2n ** 128n - 1n;
exports.maxUint136 = 2n ** 136n - 1n;
exports.maxUint144 = 2n ** 144n - 1n;
exports.maxUint152 = 2n ** 152n - 1n;
exports.maxUint160 = 2n ** 160n - 1n;
exports.maxUint168 = 2n ** 168n - 1n;
exports.maxUint176 = 2n ** 176n - 1n;
exports.maxUint184 = 2n ** 184n - 1n;
exports.maxUint192 = 2n ** 192n - 1n;
exports.maxUint200 = 2n ** 200n - 1n;
exports.maxUint208 = 2n ** 208n - 1n;
exports.maxUint216 = 2n ** 216n - 1n;
exports.maxUint224 = 2n ** 224n - 1n;
exports.maxUint232 = 2n ** 232n - 1n;
exports.maxUint240 = 2n ** 240n - 1n;
exports.maxUint248 = 2n ** 248n - 1n;
exports.maxUint256 = 2n ** 256n - 1n; //# sourceMappingURL=number.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.assertRequest = assertRequest;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const number_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/number.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
function assertRequest(args) {
    const { account: account_, gasPrice, maxFeePerGas, maxPriorityFeePerGas, to } = args;
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : undefined;
    if (account && !(0, isAddress_js_1.isAddress)(account.address)) throw new address_js_1.InvalidAddressError({
        address: account.address
    });
    if (to && !(0, isAddress_js_1.isAddress)(to)) throw new address_js_1.InvalidAddressError({
        address: to
    });
    if (typeof gasPrice !== 'undefined' && (typeof maxFeePerGas !== 'undefined' || typeof maxPriorityFeePerGas !== 'undefined')) throw new transaction_js_1.FeeConflictError();
    if (maxFeePerGas && maxFeePerGas > number_js_1.maxUint256) throw new node_js_1.FeeCapTooHighError({
        maxFeePerGas
    });
    if (maxPriorityFeePerGas && maxFeePerGas && maxPriorityFeePerGas > maxFeePerGas) throw new node_js_1.TipAboveFeeCapError({
        maxFeePerGas,
        maxPriorityFeePerGas
    });
} //# sourceMappingURL=assertRequest.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/fee.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.MaxFeePerGasTooLowError = exports.Eip1559FeesNotSupportedError = exports.BaseFeeScalarError = void 0;
const formatGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class BaseFeeScalarError extends base_js_1.BaseError {
    constructor(){
        super('`baseFeeMultiplier` must be greater than 1.', {
            name: 'BaseFeeScalarError'
        });
    }
}
exports.BaseFeeScalarError = BaseFeeScalarError;
class Eip1559FeesNotSupportedError extends base_js_1.BaseError {
    constructor(){
        super('Chain does not support EIP-1559 fees.', {
            name: 'Eip1559FeesNotSupportedError'
        });
    }
}
exports.Eip1559FeesNotSupportedError = Eip1559FeesNotSupportedError;
class MaxFeePerGasTooLowError extends base_js_1.BaseError {
    constructor({ maxPriorityFeePerGas }){
        super("`maxFeePerGas` cannot be less than the `maxPriorityFeePerGas` (".concat((0, formatGwei_js_1.formatGwei)(maxPriorityFeePerGas), " gwei)."), {
            name: 'MaxFeePerGasTooLowError'
        });
    }
}
exports.MaxFeePerGasTooLowError = MaxFeePerGasTooLowError; //# sourceMappingURL=fee.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/block.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BlockNotFoundError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class BlockNotFoundError extends base_js_1.BaseError {
    constructor({ blockHash, blockNumber }){
        let identifier = 'Block';
        if (blockHash) identifier = 'Block at hash "'.concat(blockHash, '"');
        if (blockNumber) identifier = 'Block at number "'.concat(blockNumber, '"');
        super("".concat(identifier, " could not be found."), {
            name: 'BlockNotFoundError'
        });
    }
}
exports.BlockNotFoundError = BlockNotFoundError; //# sourceMappingURL=block.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineTransaction = exports.transactionType = void 0;
exports.formatTransaction = formatTransaction;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const formatter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/formatter.js [app-client] (ecmascript)");
exports.transactionType = {
    '0x0': 'legacy',
    '0x1': 'eip2930',
    '0x2': 'eip1559',
    '0x3': 'eip4844',
    '0x4': 'eip7702'
};
function formatTransaction(transaction, _) {
    const transaction_ = {
        ...transaction,
        blockHash: transaction.blockHash ? transaction.blockHash : null,
        blockNumber: transaction.blockNumber ? BigInt(transaction.blockNumber) : null,
        chainId: transaction.chainId ? (0, fromHex_js_1.hexToNumber)(transaction.chainId) : undefined,
        gas: transaction.gas ? BigInt(transaction.gas) : undefined,
        gasPrice: transaction.gasPrice ? BigInt(transaction.gasPrice) : undefined,
        maxFeePerBlobGas: transaction.maxFeePerBlobGas ? BigInt(transaction.maxFeePerBlobGas) : undefined,
        maxFeePerGas: transaction.maxFeePerGas ? BigInt(transaction.maxFeePerGas) : undefined,
        maxPriorityFeePerGas: transaction.maxPriorityFeePerGas ? BigInt(transaction.maxPriorityFeePerGas) : undefined,
        nonce: transaction.nonce ? (0, fromHex_js_1.hexToNumber)(transaction.nonce) : undefined,
        to: transaction.to ? transaction.to : null,
        transactionIndex: transaction.transactionIndex ? Number(transaction.transactionIndex) : null,
        type: transaction.type ? exports.transactionType[transaction.type] : undefined,
        typeHex: transaction.type ? transaction.type : undefined,
        value: transaction.value ? BigInt(transaction.value) : undefined,
        v: transaction.v ? BigInt(transaction.v) : undefined
    };
    if (transaction.authorizationList) transaction_.authorizationList = formatAuthorizationList(transaction.authorizationList);
    transaction_.yParity = (()=>{
        if (transaction.yParity) return Number(transaction.yParity);
        if (typeof transaction_.v === 'bigint') {
            if (transaction_.v === 0n || transaction_.v === 27n) return 0;
            if (transaction_.v === 1n || transaction_.v === 28n) return 1;
            if (transaction_.v >= 35n) return transaction_.v % 2n === 0n ? 1 : 0;
        }
        return undefined;
    })();
    if (transaction_.type === 'legacy') {
        delete transaction_.accessList;
        delete transaction_.maxFeePerBlobGas;
        delete transaction_.maxFeePerGas;
        delete transaction_.maxPriorityFeePerGas;
        delete transaction_.yParity;
    }
    if (transaction_.type === 'eip2930') {
        delete transaction_.maxFeePerBlobGas;
        delete transaction_.maxFeePerGas;
        delete transaction_.maxPriorityFeePerGas;
    }
    if (transaction_.type === 'eip1559') {
        delete transaction_.maxFeePerBlobGas;
    }
    return transaction_;
}
exports.defineTransaction = (0, formatter_js_1.defineFormatter)('transaction', formatTransaction);
function formatAuthorizationList(authorizationList) {
    return authorizationList.map((authorization)=>({
            address: authorization.address,
            chainId: Number(authorization.chainId),
            nonce: Number(authorization.nonce),
            r: authorization.r,
            s: authorization.s,
            yParity: Number(authorization.yParity)
        }));
} //# sourceMappingURL=transaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/block.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineBlock = void 0;
exports.formatBlock = formatBlock;
const formatter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/formatter.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transaction.js [app-client] (ecmascript)");
function formatBlock(block, _) {
    var _block_transactions;
    const transactions = ((_block_transactions = block.transactions) !== null && _block_transactions !== void 0 ? _block_transactions : []).map((transaction)=>{
        if (typeof transaction === 'string') return transaction;
        return (0, transaction_js_1.formatTransaction)(transaction);
    });
    return {
        ...block,
        baseFeePerGas: block.baseFeePerGas ? BigInt(block.baseFeePerGas) : null,
        blobGasUsed: block.blobGasUsed ? BigInt(block.blobGasUsed) : undefined,
        difficulty: block.difficulty ? BigInt(block.difficulty) : undefined,
        excessBlobGas: block.excessBlobGas ? BigInt(block.excessBlobGas) : undefined,
        gasLimit: block.gasLimit ? BigInt(block.gasLimit) : undefined,
        gasUsed: block.gasUsed ? BigInt(block.gasUsed) : undefined,
        hash: block.hash ? block.hash : null,
        logsBloom: block.logsBloom ? block.logsBloom : null,
        nonce: block.nonce ? block.nonce : null,
        number: block.number ? BigInt(block.number) : null,
        size: block.size ? BigInt(block.size) : undefined,
        timestamp: block.timestamp ? BigInt(block.timestamp) : undefined,
        transactions,
        totalDifficulty: block.totalDifficulty ? BigInt(block.totalDifficulty) : null
    };
}
exports.defineBlock = (0, formatter_js_1.defineFormatter)('block', formatBlock); //# sourceMappingURL=block.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getBlock = getBlock;
const block_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/block.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const block_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/block.js [app-client] (ecmascript)");
var _client_experimental_blockTag;
async function getBlock(client) {
    let { blockHash, blockNumber, blockTag = (_client_experimental_blockTag = client.experimental_blockTag) !== null && _client_experimental_blockTag !== void 0 ? _client_experimental_blockTag : 'latest', includeTransactions: includeTransactions_ } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _client_chain_formatters_block, _client_chain_formatters, _client_chain;
    const includeTransactions = includeTransactions_ !== null && includeTransactions_ !== void 0 ? includeTransactions_ : false;
    const blockNumberHex = blockNumber !== undefined ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    let block = null;
    if (blockHash) {
        block = await client.request({
            method: 'eth_getBlockByHash',
            params: [
                blockHash,
                includeTransactions
            ]
        }, {
            dedupe: true
        });
    } else {
        block = await client.request({
            method: 'eth_getBlockByNumber',
            params: [
                blockNumberHex || blockTag,
                includeTransactions
            ]
        }, {
            dedupe: Boolean(blockNumberHex)
        });
    }
    if (!block) throw new block_js_1.BlockNotFoundError({
        blockHash,
        blockNumber
    });
    const format = ((_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_block = _client_chain_formatters.block) === null || _client_chain_formatters_block === void 0 ? void 0 : _client_chain_formatters_block.format) || block_js_2.formatBlock;
    return format(block, 'getBlock');
} //# sourceMappingURL=getBlock.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getGasPrice.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getGasPrice = getGasPrice;
async function getGasPrice(client) {
    const gasPrice = await client.request({
        method: 'eth_gasPrice'
    });
    return BigInt(gasPrice);
} //# sourceMappingURL=getGasPrice.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateMaxPriorityFeePerGas.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.estimateMaxPriorityFeePerGas = estimateMaxPriorityFeePerGas;
exports.internal_estimateMaxPriorityFeePerGas = internal_estimateMaxPriorityFeePerGas;
const fee_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/fee.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const getBlock_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)");
const getGasPrice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getGasPrice.js [app-client] (ecmascript)");
async function estimateMaxPriorityFeePerGas(client, args) {
    return internal_estimateMaxPriorityFeePerGas(client, args);
}
async function internal_estimateMaxPriorityFeePerGas(client, args) {
    const { block: block_, chain = client.chain, request } = args || {};
    try {
        var _chain_fees, _chain_fees1;
        var _chain_fees_maxPriorityFeePerGas;
        const maxPriorityFeePerGas = (_chain_fees_maxPriorityFeePerGas = chain === null || chain === void 0 ? void 0 : (_chain_fees = chain.fees) === null || _chain_fees === void 0 ? void 0 : _chain_fees.maxPriorityFeePerGas) !== null && _chain_fees_maxPriorityFeePerGas !== void 0 ? _chain_fees_maxPriorityFeePerGas : chain === null || chain === void 0 ? void 0 : (_chain_fees1 = chain.fees) === null || _chain_fees1 === void 0 ? void 0 : _chain_fees1.defaultPriorityFee;
        if (typeof maxPriorityFeePerGas === 'function') {
            const block = block_ || await (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({});
            const maxPriorityFeePerGas_ = await maxPriorityFeePerGas({
                block,
                client,
                request
            });
            if (maxPriorityFeePerGas_ === null) throw new Error();
            return maxPriorityFeePerGas_;
        }
        if (typeof maxPriorityFeePerGas !== 'undefined') return maxPriorityFeePerGas;
        const maxPriorityFeePerGasHex = await client.request({
            method: 'eth_maxPriorityFeePerGas'
        });
        return (0, fromHex_js_1.hexToBigInt)(maxPriorityFeePerGasHex);
    } catch (e) {
        const [block, gasPrice] = await Promise.all([
            block_ ? Promise.resolve(block_) : (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({}),
            (0, getAction_js_1.getAction)(client, getGasPrice_js_1.getGasPrice, 'getGasPrice')({})
        ]);
        if (typeof block.baseFeePerGas !== 'bigint') throw new fee_js_1.Eip1559FeesNotSupportedError();
        const maxPriorityFeePerGas = gasPrice - block.baseFeePerGas;
        if (maxPriorityFeePerGas < 0n) return 0n;
        return maxPriorityFeePerGas;
    }
} //# sourceMappingURL=estimateMaxPriorityFeePerGas.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateFeesPerGas.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.estimateFeesPerGas = estimateFeesPerGas;
exports.internal_estimateFeesPerGas = internal_estimateFeesPerGas;
const fee_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/fee.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const estimateMaxPriorityFeePerGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateMaxPriorityFeePerGas.js [app-client] (ecmascript)");
const getBlock_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)");
const getGasPrice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getGasPrice.js [app-client] (ecmascript)");
async function estimateFeesPerGas(client, args) {
    return internal_estimateFeesPerGas(client, args);
}
async function internal_estimateFeesPerGas(client, args) {
    var _baseFeeMultiplier_toString_split_, _chain_fees;
    const { block: block_, chain = client.chain, request, type = 'eip1559' } = args || {};
    const baseFeeMultiplier = await (async ()=>{
        var _chain_fees, _chain_fees1;
        if (typeof (chain === null || chain === void 0 ? void 0 : (_chain_fees = chain.fees) === null || _chain_fees === void 0 ? void 0 : _chain_fees.baseFeeMultiplier) === 'function') return chain.fees.baseFeeMultiplier({
            block: block_,
            client,
            request
        });
        var _chain_fees_baseFeeMultiplier;
        return (_chain_fees_baseFeeMultiplier = chain === null || chain === void 0 ? void 0 : (_chain_fees1 = chain.fees) === null || _chain_fees1 === void 0 ? void 0 : _chain_fees1.baseFeeMultiplier) !== null && _chain_fees_baseFeeMultiplier !== void 0 ? _chain_fees_baseFeeMultiplier : 1.2;
    })();
    if (baseFeeMultiplier < 1) throw new fee_js_1.BaseFeeScalarError();
    var _baseFeeMultiplier_toString_split__length;
    const decimals = (_baseFeeMultiplier_toString_split__length = (_baseFeeMultiplier_toString_split_ = baseFeeMultiplier.toString().split('.')[1]) === null || _baseFeeMultiplier_toString_split_ === void 0 ? void 0 : _baseFeeMultiplier_toString_split_.length) !== null && _baseFeeMultiplier_toString_split__length !== void 0 ? _baseFeeMultiplier_toString_split__length : 0;
    const denominator = 10 ** decimals;
    const multiply = (base)=>base * BigInt(Math.ceil(baseFeeMultiplier * denominator)) / BigInt(denominator);
    const block = block_ ? block_ : await (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({});
    if (typeof (chain === null || chain === void 0 ? void 0 : (_chain_fees = chain.fees) === null || _chain_fees === void 0 ? void 0 : _chain_fees.estimateFeesPerGas) === 'function') {
        const fees = await chain.fees.estimateFeesPerGas({
            block: block_,
            client,
            multiply,
            request,
            type
        });
        if (fees !== null) return fees;
    }
    if (type === 'eip1559') {
        if (typeof block.baseFeePerGas !== 'bigint') throw new fee_js_1.Eip1559FeesNotSupportedError();
        const maxPriorityFeePerGas = typeof (request === null || request === void 0 ? void 0 : request.maxPriorityFeePerGas) === 'bigint' ? request.maxPriorityFeePerGas : await (0, estimateMaxPriorityFeePerGas_js_1.internal_estimateMaxPriorityFeePerGas)(client, {
            block: block,
            chain,
            request
        });
        const baseFeePerGas = multiply(block.baseFeePerGas);
        var _request_maxFeePerGas;
        const maxFeePerGas = (_request_maxFeePerGas = request === null || request === void 0 ? void 0 : request.maxFeePerGas) !== null && _request_maxFeePerGas !== void 0 ? _request_maxFeePerGas : baseFeePerGas + maxPriorityFeePerGas;
        return {
            maxFeePerGas,
            maxPriorityFeePerGas
        };
    }
    var _request_gasPrice;
    const gasPrice = (_request_gasPrice = request === null || request === void 0 ? void 0 : request.gasPrice) !== null && _request_gasPrice !== void 0 ? _request_gasPrice : multiply(await (0, getAction_js_1.getAction)(client, getGasPrice_js_1.getGasPrice, 'getGasPrice')({}));
    return {
        gasPrice
    };
} //# sourceMappingURL=estimateFeesPerGas.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionCount.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTransactionCount = getTransactionCount;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function getTransactionCount(client, param) {
    let { address, blockTag = 'latest', blockNumber } = param;
    const count = await client.request({
        method: 'eth_getTransactionCount',
        params: [
            address,
            typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : blockTag
        ]
    }, {
        dedupe: Boolean(blockNumber)
    });
    return (0, fromHex_js_1.hexToNumber)(count);
} //# sourceMappingURL=getTransactionCount.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToCommitments.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.blobsToCommitments = blobsToCommitments;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function blobsToCommitments(parameters) {
    const { kzg } = parameters;
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof parameters.blobs[0] === 'string' ? 'hex' : 'bytes';
    const blobs = typeof parameters.blobs[0] === 'string' ? parameters.blobs.map((x)=>(0, toBytes_js_1.hexToBytes)(x)) : parameters.blobs;
    const commitments = [];
    for (const blob of blobs)commitments.push(Uint8Array.from(kzg.blobToKzgCommitment(blob)));
    return to === 'bytes' ? commitments : commitments.map((x)=>(0, toHex_js_1.bytesToHex)(x));
} //# sourceMappingURL=blobsToCommitments.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToProofs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.blobsToProofs = blobsToProofs;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function blobsToProofs(parameters) {
    const { kzg } = parameters;
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof parameters.blobs[0] === 'string' ? 'hex' : 'bytes';
    const blobs = typeof parameters.blobs[0] === 'string' ? parameters.blobs.map((x)=>(0, toBytes_js_1.hexToBytes)(x)) : parameters.blobs;
    const commitments = typeof parameters.commitments[0] === 'string' ? parameters.commitments.map((x)=>(0, toBytes_js_1.hexToBytes)(x)) : parameters.commitments;
    const proofs = [];
    for(let i = 0; i < blobs.length; i++){
        const blob = blobs[i];
        const commitment = commitments[i];
        proofs.push(Uint8Array.from(kzg.computeBlobKzgProof(blob, commitment)));
    }
    return to === 'bytes' ? proofs : proofs.map((x)=>(0, toHex_js_1.bytesToHex)(x));
} //# sourceMappingURL=blobsToProofs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/sha256.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sha256 = sha256;
const sha256_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/sha256.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function sha256(value, to_) {
    const to = to_ || 'hex';
    const bytes = (0, sha256_1.sha256)((0, isHex_js_1.isHex)(value, {
        strict: false
    }) ? (0, toBytes_js_1.toBytes)(value) : value);
    if (to === 'bytes') return bytes;
    return (0, toHex_js_1.toHex)(bytes);
} //# sourceMappingURL=sha256.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/commitmentToVersionedHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.commitmentToVersionedHash = commitmentToVersionedHash;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const sha256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/sha256.js [app-client] (ecmascript)");
function commitmentToVersionedHash(parameters) {
    const { commitment, version = 1 } = parameters;
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof commitment === 'string' ? 'hex' : 'bytes';
    const versionedHash = (0, sha256_js_1.sha256)(commitment, 'bytes');
    versionedHash.set([
        version
    ], 0);
    return to === 'bytes' ? versionedHash : (0, toHex_js_1.bytesToHex)(versionedHash);
} //# sourceMappingURL=commitmentToVersionedHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/commitmentsToVersionedHashes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.commitmentsToVersionedHashes = commitmentsToVersionedHashes;
const commitmentToVersionedHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/commitmentToVersionedHash.js [app-client] (ecmascript)");
function commitmentsToVersionedHashes(parameters) {
    const { commitments, version } = parameters;
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof commitments[0] === 'string' ? 'hex' : 'bytes';
    const hashes = [];
    for (const commitment of commitments){
        hashes.push((0, commitmentToVersionedHash_js_1.commitmentToVersionedHash)({
            commitment,
            to,
            version
        }));
    }
    return hashes;
} //# sourceMappingURL=commitmentsToVersionedHashes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/blob.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.maxBytesPerTransaction = exports.bytesPerBlob = exports.fieldElementsPerBlob = exports.bytesPerFieldElement = void 0;
const blobsPerTransaction = 6;
exports.bytesPerFieldElement = 32;
exports.fieldElementsPerBlob = 4096;
exports.bytesPerBlob = exports.bytesPerFieldElement * exports.fieldElementsPerBlob;
exports.maxBytesPerTransaction = exports.bytesPerBlob * blobsPerTransaction - 1 - 1 * exports.fieldElementsPerBlob * blobsPerTransaction; //# sourceMappingURL=blob.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/kzg.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.versionedHashVersionKzg = void 0;
exports.versionedHashVersionKzg = 1; //# sourceMappingURL=kzg.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/blob.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InvalidVersionedHashVersionError = exports.InvalidVersionedHashSizeError = exports.EmptyBlobError = exports.BlobSizeTooLargeError = void 0;
const kzg_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/kzg.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class BlobSizeTooLargeError extends base_js_1.BaseError {
    constructor({ maxSize, size }){
        super('Blob size is too large.', {
            metaMessages: [
                "Max: ".concat(maxSize, " bytes"),
                "Given: ".concat(size, " bytes")
            ],
            name: 'BlobSizeTooLargeError'
        });
    }
}
exports.BlobSizeTooLargeError = BlobSizeTooLargeError;
class EmptyBlobError extends base_js_1.BaseError {
    constructor(){
        super('Blob data must not be empty.', {
            name: 'EmptyBlobError'
        });
    }
}
exports.EmptyBlobError = EmptyBlobError;
class InvalidVersionedHashSizeError extends base_js_1.BaseError {
    constructor({ hash, size }){
        super('Versioned hash "'.concat(hash, '" size is invalid.'), {
            metaMessages: [
                'Expected: 32',
                "Received: ".concat(size)
            ],
            name: 'InvalidVersionedHashSizeError'
        });
    }
}
exports.InvalidVersionedHashSizeError = InvalidVersionedHashSizeError;
class InvalidVersionedHashVersionError extends base_js_1.BaseError {
    constructor({ hash, version }){
        super('Versioned hash "'.concat(hash, '" version is invalid.'), {
            metaMessages: [
                "Expected: ".concat(kzg_js_1.versionedHashVersionKzg),
                "Received: ".concat(version)
            ],
            name: 'InvalidVersionedHashVersionError'
        });
    }
}
exports.InvalidVersionedHashVersionError = InvalidVersionedHashVersionError; //# sourceMappingURL=blob.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/toBlobs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toBlobs = toBlobs;
const blob_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/blob.js [app-client] (ecmascript)");
const blob_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/blob.js [app-client] (ecmascript)");
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/cursor.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function toBlobs(parameters) {
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof parameters.data === 'string' ? 'hex' : 'bytes';
    const data = typeof parameters.data === 'string' ? (0, toBytes_js_1.hexToBytes)(parameters.data) : parameters.data;
    const size_ = (0, size_js_1.size)(data);
    if (!size_) throw new blob_js_2.EmptyBlobError();
    if (size_ > blob_js_1.maxBytesPerTransaction) throw new blob_js_2.BlobSizeTooLargeError({
        maxSize: blob_js_1.maxBytesPerTransaction,
        size: size_
    });
    const blobs = [];
    let active = true;
    let position = 0;
    while(active){
        const blob = (0, cursor_js_1.createCursor)(new Uint8Array(blob_js_1.bytesPerBlob));
        let size = 0;
        while(size < blob_js_1.fieldElementsPerBlob){
            const bytes = data.slice(position, position + (blob_js_1.bytesPerFieldElement - 1));
            blob.pushByte(0x00);
            blob.pushBytes(bytes);
            if (bytes.length < 31) {
                blob.pushByte(0x80);
                active = false;
                break;
            }
            size++;
            position += 31;
        }
        blobs.push(blob);
    }
    return to === 'bytes' ? blobs.map((x)=>x.bytes) : blobs.map((x)=>(0, toHex_js_1.bytesToHex)(x.bytes));
} //# sourceMappingURL=toBlobs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/toBlobSidecars.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toBlobSidecars = toBlobSidecars;
const blobsToCommitments_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToCommitments.js [app-client] (ecmascript)");
const blobsToProofs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToProofs.js [app-client] (ecmascript)");
const toBlobs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/toBlobs.js [app-client] (ecmascript)");
function toBlobSidecars(parameters) {
    const { data, kzg, to } = parameters;
    var _parameters_blobs;
    const blobs = (_parameters_blobs = parameters.blobs) !== null && _parameters_blobs !== void 0 ? _parameters_blobs : (0, toBlobs_js_1.toBlobs)({
        data: data,
        to
    });
    var _parameters_commitments;
    const commitments = (_parameters_commitments = parameters.commitments) !== null && _parameters_commitments !== void 0 ? _parameters_commitments : (0, blobsToCommitments_js_1.blobsToCommitments)({
        blobs,
        kzg: kzg,
        to
    });
    var _parameters_proofs;
    const proofs = (_parameters_proofs = parameters.proofs) !== null && _parameters_proofs !== void 0 ? _parameters_proofs : (0, blobsToProofs_js_1.blobsToProofs)({
        blobs,
        commitments,
        kzg: kzg,
        to
    });
    const sidecars = [];
    for(let i = 0; i < blobs.length; i++)sidecars.push({
        blob: blobs[i],
        commitment: commitments[i],
        proof: proofs[i]
    });
    return sidecars;
} //# sourceMappingURL=toBlobSidecars.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getTransactionType.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTransactionType = getTransactionType;
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
function getTransactionType(transaction) {
    if (transaction.type) return transaction.type;
    if (typeof transaction.authorizationList !== 'undefined') return 'eip7702';
    if (typeof transaction.blobs !== 'undefined' || typeof transaction.blobVersionedHashes !== 'undefined' || typeof transaction.maxFeePerBlobGas !== 'undefined' || typeof transaction.sidecars !== 'undefined') return 'eip4844';
    if (typeof transaction.maxFeePerGas !== 'undefined' || typeof transaction.maxPriorityFeePerGas !== 'undefined') {
        return 'eip1559';
    }
    if (typeof transaction.gasPrice !== 'undefined') {
        if (typeof transaction.accessList !== 'undefined') return 'eip2930';
        return 'legacy';
    }
    throw new transaction_js_1.InvalidSerializableTransactionError({
        transaction
    });
} //# sourceMappingURL=getTransactionType.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getChainId = getChainId;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
async function getChainId(client) {
    const chainIdHex = await client.request({
        method: 'eth_chainId'
    }, {
        dedupe: true
    });
    return (0, fromHex_js_1.hexToNumber)(chainIdHex);
} //# sourceMappingURL=getChainId.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareTransactionRequest.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.eip1559NetworkCache = exports.defaultParameters = void 0;
exports.prepareTransactionRequest = prepareTransactionRequest;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const estimateFeesPerGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateFeesPerGas.js [app-client] (ecmascript)");
const estimateGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateGas.js [app-client] (ecmascript)");
const getBlock_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)");
const getTransactionCount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionCount.js [app-client] (ecmascript)");
const fee_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/fee.js [app-client] (ecmascript)");
const blobsToCommitments_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToCommitments.js [app-client] (ecmascript)");
const blobsToProofs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToProofs.js [app-client] (ecmascript)");
const commitmentsToVersionedHashes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/commitmentsToVersionedHashes.js [app-client] (ecmascript)");
const toBlobSidecars_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/toBlobSidecars.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
const getTransactionType_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getTransactionType.js [app-client] (ecmascript)");
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
exports.defaultParameters = [
    'blobVersionedHashes',
    'chainId',
    'fees',
    'gas',
    'nonce',
    'type'
];
exports.eip1559NetworkCache = new Map();
async function prepareTransactionRequest(client, args) {
    const { account: account_ = client.account, blobs, chain, gas, kzg, nonce, nonceManager, parameters = exports.defaultParameters, type } = args;
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : account_;
    const request = {
        ...args,
        ...account ? {
            from: account === null || account === void 0 ? void 0 : account.address
        } : {}
    };
    let block;
    async function getBlock() {
        if (block) return block;
        block = await (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({
            blockTag: 'latest'
        });
        return block;
    }
    let chainId;
    async function getChainId() {
        if (chainId) return chainId;
        if (chain) return chain.id;
        if (typeof args.chainId !== 'undefined') return args.chainId;
        const chainId_ = await (0, getAction_js_1.getAction)(client, getChainId_js_1.getChainId, 'getChainId')({});
        chainId = chainId_;
        return chainId;
    }
    if (parameters.includes('nonce') && typeof nonce === 'undefined' && account) {
        if (nonceManager) {
            const chainId = await getChainId();
            request.nonce = await nonceManager.consume({
                address: account.address,
                chainId,
                client
            });
        } else {
            request.nonce = await (0, getAction_js_1.getAction)(client, getTransactionCount_js_1.getTransactionCount, 'getTransactionCount')({
                address: account.address,
                blockTag: 'pending'
            });
        }
    }
    if ((parameters.includes('blobVersionedHashes') || parameters.includes('sidecars')) && blobs && kzg) {
        const commitments = (0, blobsToCommitments_js_1.blobsToCommitments)({
            blobs,
            kzg
        });
        if (parameters.includes('blobVersionedHashes')) {
            const versionedHashes = (0, commitmentsToVersionedHashes_js_1.commitmentsToVersionedHashes)({
                commitments,
                to: 'hex'
            });
            request.blobVersionedHashes = versionedHashes;
        }
        if (parameters.includes('sidecars')) {
            const proofs = (0, blobsToProofs_js_1.blobsToProofs)({
                blobs,
                commitments,
                kzg
            });
            const sidecars = (0, toBlobSidecars_js_1.toBlobSidecars)({
                blobs,
                commitments,
                proofs,
                to: 'hex'
            });
            request.sidecars = sidecars;
        }
    }
    if (parameters.includes('chainId')) request.chainId = await getChainId();
    if ((parameters.includes('fees') || parameters.includes('type')) && typeof type === 'undefined') {
        try {
            request.type = (0, getTransactionType_js_1.getTransactionType)(request);
        } catch (e) {
            let isEip1559Network = exports.eip1559NetworkCache.get(client.uid);
            if (typeof isEip1559Network === 'undefined') {
                const block = await getBlock();
                isEip1559Network = typeof (block === null || block === void 0 ? void 0 : block.baseFeePerGas) === 'bigint';
                exports.eip1559NetworkCache.set(client.uid, isEip1559Network);
            }
            request.type = isEip1559Network ? 'eip1559' : 'legacy';
        }
    }
    if (parameters.includes('fees')) {
        if (request.type !== 'legacy' && request.type !== 'eip2930') {
            if (typeof request.maxFeePerGas === 'undefined' || typeof request.maxPriorityFeePerGas === 'undefined') {
                const block = await getBlock();
                const { maxFeePerGas, maxPriorityFeePerGas } = await (0, estimateFeesPerGas_js_1.internal_estimateFeesPerGas)(client, {
                    block: block,
                    chain,
                    request: request
                });
                if (typeof args.maxPriorityFeePerGas === 'undefined' && args.maxFeePerGas && args.maxFeePerGas < maxPriorityFeePerGas) throw new fee_js_1.MaxFeePerGasTooLowError({
                    maxPriorityFeePerGas
                });
                request.maxPriorityFeePerGas = maxPriorityFeePerGas;
                request.maxFeePerGas = maxFeePerGas;
            }
        } else {
            if (typeof args.maxFeePerGas !== 'undefined' || typeof args.maxPriorityFeePerGas !== 'undefined') throw new fee_js_1.Eip1559FeesNotSupportedError();
            if (typeof args.gasPrice === 'undefined') {
                const block = await getBlock();
                const { gasPrice: gasPrice_ } = await (0, estimateFeesPerGas_js_1.internal_estimateFeesPerGas)(client, {
                    block: block,
                    chain,
                    request: request,
                    type: 'legacy'
                });
                request.gasPrice = gasPrice_;
            }
        }
    }
    if (parameters.includes('gas') && typeof gas === 'undefined') request.gas = await (0, getAction_js_1.getAction)(client, estimateGas_js_1.estimateGas, 'estimateGas')({
        ...request,
        account,
        prepare: (account === null || account === void 0 ? void 0 : account.type) === 'local' ? [] : [
            'blobVersionedHashes'
        ]
    });
    (0, assertRequest_js_1.assertRequest)(request);
    delete request.parameters;
    return request;
} //# sourceMappingURL=prepareTransactionRequest.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateGas.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.estimateGas = estimateGas;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const recoverAuthorizationAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/recoverAuthorizationAddress.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const getEstimateGasError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getEstimateGasError.js [app-client] (ecmascript)");
const extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const stateOverride_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stateOverride.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
const prepareTransactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareTransactionRequest.js [app-client] (ecmascript)");
async function estimateGas(client, args) {
    const { account: account_ = client.account, prepare = true } = args;
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : undefined;
    const parameters = (()=>{
        if (Array.isArray(prepare)) return prepare;
        if ((account === null || account === void 0 ? void 0 : account.type) !== 'local') return [
            'blobVersionedHashes'
        ];
        return undefined;
    })();
    try {
        var _client_chain_formatters_transactionRequest, _client_chain_formatters, _client_chain;
        const { accessList, authorizationList, blobs, blobVersionedHashes, blockNumber, blockTag, data, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce, value, stateOverride, ...rest } = prepare ? await (0, prepareTransactionRequest_js_1.prepareTransactionRequest)(client, {
            ...args,
            parameters
        }) : args;
        const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
        const block = blockNumberHex || blockTag;
        const rpcStateOverride = (0, stateOverride_js_1.serializeStateOverride)(stateOverride);
        const to = await (async ()=>{
            if (rest.to) return rest.to;
            if (authorizationList && authorizationList.length > 0) return await (0, recoverAuthorizationAddress_js_1.recoverAuthorizationAddress)({
                authorization: authorizationList[0]
            }).catch(()=>{
                throw new base_js_1.BaseError('`to` is required. Could not infer from `authorizationList`');
            });
            return undefined;
        })();
        (0, assertRequest_js_1.assertRequest)(args);
        const chainFormat = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionRequest = _client_chain_formatters.transactionRequest) === null || _client_chain_formatters_transactionRequest === void 0 ? void 0 : _client_chain_formatters_transactionRequest.format;
        const format = chainFormat || transactionRequest_js_1.formatTransactionRequest;
        const request = format({
            ...(0, extract_js_1.extract)(rest, {
                format: chainFormat
            }),
            account,
            accessList,
            authorizationList,
            blobs,
            blobVersionedHashes,
            data,
            gas,
            gasPrice,
            maxFeePerBlobGas,
            maxFeePerGas,
            maxPriorityFeePerGas,
            nonce,
            to,
            value
        }, 'estimateGas');
        var _ref;
        return BigInt(await client.request({
            method: 'eth_estimateGas',
            params: rpcStateOverride ? [
                request,
                (_ref = block !== null && block !== void 0 ? block : client.experimental_blockTag) !== null && _ref !== void 0 ? _ref : 'latest',
                rpcStateOverride
            ] : block ? [
                request,
                block
            ] : [
                request
            ]
        }));
    } catch (err) {
        throw (0, getEstimateGasError_js_1.getEstimateGasError)(err, {
            ...args,
            account,
            chain: client.chain
        });
    }
} //# sourceMappingURL=estimateGas.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateContractGas.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.estimateContractGas = estimateContractGas;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const estimateGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateGas.js [app-client] (ecmascript)");
async function estimateContractGas(client, parameters) {
    const { abi, address, args, functionName, dataSuffix, ...request } = parameters;
    const data = (0, encodeFunctionData_js_1.encodeFunctionData)({
        abi,
        args,
        functionName
    });
    try {
        const gas = await (0, getAction_js_1.getAction)(client, estimateGas_js_1.estimateGas, 'estimateGas')({
            data: "".concat(data).concat(dataSuffix ? dataSuffix.replace('0x', '') : ''),
            to: address,
            ...request
        });
        return gas;
    } catch (error) {
        const account = request.account ? (0, parseAccount_js_1.parseAccount)(request.account) : undefined;
        throw (0, getContractError_js_1.getContractError)(error, {
            abi,
            address,
            args,
            docsPath: '/docs/contract/estimateContractGas',
            functionName,
            sender: account === null || account === void 0 ? void 0 : account.address
        });
    }
} //# sourceMappingURL=estimateContractGas.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isAddressEqual = isAddressEqual;
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
function isAddressEqual(a, b) {
    if (!(0, isAddress_js_1.isAddress)(a, {
        strict: false
    })) throw new address_js_1.InvalidAddressError({
        address: a
    });
    if (!(0, isAddress_js_1.isAddress)(b, {
        strict: false
    })) throw new address_js_1.InvalidAddressError({
        address: b
    });
    return a.toLowerCase() === b.toLowerCase();
} //# sourceMappingURL=isAddressEqual.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeEventLog.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeEventLog = decodeEventLog;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/cursor.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const toEventSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSelector.js [app-client] (ecmascript)");
const decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/decodeEventLog';
function decodeEventLog(parameters) {
    const { abi, data, strict: strict_, topics } = parameters;
    const strict = strict_ !== null && strict_ !== void 0 ? strict_ : true;
    const [signature, ...argTopics] = topics;
    if (!signature) throw new abi_js_1.AbiEventSignatureEmptyTopicsError({
        docsPath
    });
    const abiItem = abi.find((x)=>x.type === 'event' && signature === (0, toEventSelector_js_1.toEventSelector)((0, formatAbiItem_js_1.formatAbiItem)(x)));
    if (!(abiItem && 'name' in abiItem) || abiItem.type !== 'event') throw new abi_js_1.AbiEventSignatureNotFoundError(signature, {
        docsPath
    });
    const { name, inputs } = abiItem;
    const isUnnamed = inputs === null || inputs === void 0 ? void 0 : inputs.some((x)=>!('name' in x && x.name));
    const args = isUnnamed ? [] : {};
    const indexedInputs = inputs.map((x, i)=>[
            x,
            i
        ]).filter((param)=>{
        let [x] = param;
        return 'indexed' in x && x.indexed;
    });
    for(let i = 0; i < indexedInputs.length; i++){
        const [param, argIndex] = indexedInputs[i];
        const topic = argTopics[i];
        if (!topic) throw new abi_js_1.DecodeLogTopicsMismatch({
            abiItem,
            param: param
        });
        args[isUnnamed ? argIndex : param.name || argIndex] = decodeTopic({
            param,
            value: topic
        });
    }
    const nonIndexedInputs = inputs.filter((x)=>!('indexed' in x && x.indexed));
    if (nonIndexedInputs.length > 0) {
        if (data && data !== '0x') {
            try {
                const decodedData = (0, decodeAbiParameters_js_1.decodeAbiParameters)(nonIndexedInputs, data);
                if (decodedData) {
                    var _args_i;
                    if (isUnnamed) for(let i = 0; i < inputs.length; i++)args[i] = (_args_i = args[i]) !== null && _args_i !== void 0 ? _args_i : decodedData.shift();
                    else for(let i = 0; i < nonIndexedInputs.length; i++)args[nonIndexedInputs[i].name] = decodedData[i];
                }
            } catch (err) {
                if (strict) {
                    if (err instanceof abi_js_1.AbiDecodingDataSizeTooSmallError || err instanceof cursor_js_1.PositionOutOfBoundsError) throw new abi_js_1.DecodeLogDataMismatch({
                        abiItem,
                        data: data,
                        params: nonIndexedInputs,
                        size: (0, size_js_1.size)(data)
                    });
                    throw err;
                }
            }
        } else if (strict) {
            throw new abi_js_1.DecodeLogDataMismatch({
                abiItem,
                data: '0x',
                params: nonIndexedInputs,
                size: 0
            });
        }
    }
    return {
        eventName: name,
        args: Object.values(args).length > 0 ? args : undefined
    };
}
function decodeTopic(param) {
    let { param: param1, value } = param;
    if (param1.type === 'string' || param1.type === 'bytes' || param1.type === 'tuple' || param1.type.match(/^(.*)\[(\d+)?\]$/)) return value;
    const decodedArg = (0, decodeAbiParameters_js_1.decodeAbiParameters)([
        param1
    ], value) || [];
    return decodedArg[0];
} //# sourceMappingURL=decodeEventLog.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/parseEventLogs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseEventLogs = parseEventLogs;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const toEventSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSelector.js [app-client] (ecmascript)");
const decodeEventLog_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeEventLog.js [app-client] (ecmascript)");
function parseEventLogs(parameters) {
    const { abi, args, logs, strict = true } = parameters;
    const eventName = (()=>{
        if (!parameters.eventName) return undefined;
        if (Array.isArray(parameters.eventName)) return parameters.eventName;
        return [
            parameters.eventName
        ];
    })();
    return logs.map((log)=>{
        try {
            const abiItem = abi.find((abiItem)=>abiItem.type === 'event' && log.topics[0] === (0, toEventSelector_js_1.toEventSelector)(abiItem));
            if (!abiItem) return null;
            const event = (0, decodeEventLog_js_1.decodeEventLog)({
                ...log,
                abi: [
                    abiItem
                ],
                strict
            });
            if (eventName && !eventName.includes(event.eventName)) return null;
            if (!includesArgs({
                args: event.args,
                inputs: abiItem.inputs,
                matchArgs: args
            })) return null;
            return {
                ...event,
                ...log
            };
        } catch (err) {
            let eventName;
            let isUnnamed;
            if (err instanceof abi_js_1.AbiEventSignatureNotFoundError) return null;
            if (err instanceof abi_js_1.DecodeLogDataMismatch || err instanceof abi_js_1.DecodeLogTopicsMismatch) {
                var _err_abiItem_inputs;
                if (strict) return null;
                eventName = err.abiItem.name;
                isUnnamed = (_err_abiItem_inputs = err.abiItem.inputs) === null || _err_abiItem_inputs === void 0 ? void 0 : _err_abiItem_inputs.some((x)=>!('name' in x && x.name));
            }
            return {
                ...log,
                args: isUnnamed ? [] : {},
                eventName
            };
        }
    }).filter(Boolean);
}
function includesArgs(parameters) {
    const { args, inputs, matchArgs } = parameters;
    if (!matchArgs) return true;
    if (!args) return false;
    function isEqual(input, value, arg) {
        try {
            if (input.type === 'address') return (0, isAddressEqual_js_1.isAddressEqual)(value, arg);
            if (input.type === 'string' || input.type === 'bytes') return (0, keccak256_js_1.keccak256)((0, toBytes_js_1.toBytes)(value)) === arg;
            return value === arg;
        } catch (e) {
            return false;
        }
    }
    if (Array.isArray(args) && Array.isArray(matchArgs)) {
        return matchArgs.every((value, index)=>{
            if (value === null || value === undefined) return true;
            const input = inputs[index];
            if (!input) return false;
            const value_ = Array.isArray(value) ? value : [
                value
            ];
            return value_.some((value)=>isEqual(input, value, args[index]));
        });
    }
    if (typeof args === 'object' && !Array.isArray(args) && typeof matchArgs === 'object' && !Array.isArray(matchArgs)) return Object.entries(matchArgs).every((param)=>{
        let [key, value] = param;
        if (value === null || value === undefined) return true;
        const input = inputs.find((input)=>input.name === key);
        if (!input) return false;
        const value_ = Array.isArray(value) ? value : [
            value
        ];
        return value_.some((value)=>isEqual(input, value, args[key]));
    });
    return false;
} //# sourceMappingURL=parseEventLogs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatLog = formatLog;
function formatLog(log) {
    let { args, eventName } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return {
        ...log,
        blockHash: log.blockHash ? log.blockHash : null,
        blockNumber: log.blockNumber ? BigInt(log.blockNumber) : null,
        logIndex: log.logIndex ? Number(log.logIndex) : null,
        transactionHash: log.transactionHash ? log.transactionHash : null,
        transactionIndex: log.transactionIndex ? Number(log.transactionIndex) : null,
        ...eventName ? {
            args,
            eventName
        } : {}
    };
} //# sourceMappingURL=log.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getLogs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getLogs = getLogs;
const encodeEventTopics_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)");
const parseEventLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/parseEventLogs.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
async function getLogs(client) {
    let { address, blockHash, fromBlock, toBlock, event, events: events_, args, strict: strict_ } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const strict = strict_ !== null && strict_ !== void 0 ? strict_ : false;
    const events = events_ !== null && events_ !== void 0 ? events_ : event ? [
        event
    ] : undefined;
    let topics = [];
    if (events) {
        const encoded = events.flatMap((event)=>(0, encodeEventTopics_js_1.encodeEventTopics)({
                abi: [
                    event
                ],
                eventName: event.name,
                args: events_ ? undefined : args
            }));
        topics = [
            encoded
        ];
        if (event) topics = topics[0];
    }
    let logs;
    if (blockHash) {
        logs = await client.request({
            method: 'eth_getLogs',
            params: [
                {
                    address,
                    topics,
                    blockHash
                }
            ]
        });
    } else {
        logs = await client.request({
            method: 'eth_getLogs',
            params: [
                {
                    address,
                    topics,
                    fromBlock: typeof fromBlock === 'bigint' ? (0, toHex_js_1.numberToHex)(fromBlock) : fromBlock,
                    toBlock: typeof toBlock === 'bigint' ? (0, toHex_js_1.numberToHex)(toBlock) : toBlock
                }
            ]
        });
    }
    const formattedLogs = logs.map((log)=>(0, log_js_1.formatLog)(log));
    if (!events) return formattedLogs;
    return (0, parseEventLogs_js_1.parseEventLogs)({
        abi: events,
        args: args,
        logs: formattedLogs,
        strict
    });
} //# sourceMappingURL=getLogs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getContractEvents.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getContractEvents = getContractEvents;
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const getLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getLogs.js [app-client] (ecmascript)");
async function getContractEvents(client, parameters) {
    const { abi, address, args, blockHash, eventName, fromBlock, toBlock, strict } = parameters;
    const event = eventName ? (0, getAbiItem_js_1.getAbiItem)({
        abi,
        name: eventName
    }) : undefined;
    const events = !event ? abi.filter((x)=>x.type === 'event') : undefined;
    return (0, getAction_js_1.getAction)(client, getLogs_js_1.getLogs, 'getLogs')({
        address,
        args,
        blockHash,
        event,
        events,
        fromBlock,
        toBlock,
        strict
    });
} //# sourceMappingURL=getContractEvents.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeFunctionResult = decodeFunctionResult;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/decodeFunctionResult';
function decodeFunctionResult(parameters) {
    const { abi, args, functionName, data } = parameters;
    let abiItem = abi[0];
    if (functionName) {
        const item = (0, getAbiItem_js_1.getAbiItem)({
            abi,
            args,
            name: functionName
        });
        if (!item) throw new abi_js_1.AbiFunctionNotFoundError(functionName, {
            docsPath
        });
        abiItem = item;
    }
    if (abiItem.type !== 'function') throw new abi_js_1.AbiFunctionNotFoundError(undefined, {
        docsPath
    });
    if (!abiItem.outputs) throw new abi_js_1.AbiFunctionOutputsNotFoundError(abiItem.name, {
        docsPath
    });
    const values = (0, decodeAbiParameters_js_1.decodeAbiParameters)(abiItem.outputs, data);
    if (values && values.length > 1) return values;
    if (values && values.length === 1) return values[0];
    return undefined;
} //# sourceMappingURL=decodeFunctionResult.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.erc4626Abi = exports.erc721Abi = exports.erc1155Abi = exports.erc20Abi_bytes32 = exports.erc20Abi = exports.erc6492SignatureValidatorAbi = exports.erc1271Abi = exports.addressResolverAbi = exports.textResolverAbi = exports.universalResolverReverseAbi = exports.universalResolverResolveAbi = exports.batchGatewayAbi = exports.multicall3Abi = void 0;
exports.multicall3Abi = [
    {
        inputs: [
            {
                components: [
                    {
                        name: 'target',
                        type: 'address'
                    },
                    {
                        name: 'allowFailure',
                        type: 'bool'
                    },
                    {
                        name: 'callData',
                        type: 'bytes'
                    }
                ],
                name: 'calls',
                type: 'tuple[]'
            }
        ],
        name: 'aggregate3',
        outputs: [
            {
                components: [
                    {
                        name: 'success',
                        type: 'bool'
                    },
                    {
                        name: 'returnData',
                        type: 'bytes'
                    }
                ],
                name: 'returnData',
                type: 'tuple[]'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [],
        name: 'getCurrentBlockTimestamp',
        outputs: [
            {
                internalType: 'uint256',
                name: 'timestamp',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    }
];
exports.batchGatewayAbi = [
    {
        name: 'query',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                type: 'tuple[]',
                name: 'queries',
                components: [
                    {
                        type: 'address',
                        name: 'sender'
                    },
                    {
                        type: 'string[]',
                        name: 'urls'
                    },
                    {
                        type: 'bytes',
                        name: 'data'
                    }
                ]
            }
        ],
        outputs: [
            {
                type: 'bool[]',
                name: 'failures'
            },
            {
                type: 'bytes[]',
                name: 'responses'
            }
        ]
    },
    {
        name: 'HttpError',
        type: 'error',
        inputs: [
            {
                type: 'uint16',
                name: 'status'
            },
            {
                type: 'string',
                name: 'message'
            }
        ]
    }
];
const universalResolverErrors = [
    {
        inputs: [
            {
                name: 'dns',
                type: 'bytes'
            }
        ],
        name: 'DNSDecodingFailed',
        type: 'error'
    },
    {
        inputs: [
            {
                name: 'ens',
                type: 'string'
            }
        ],
        name: 'DNSEncodingFailed',
        type: 'error'
    },
    {
        inputs: [],
        name: 'EmptyAddress',
        type: 'error'
    },
    {
        inputs: [
            {
                name: 'status',
                type: 'uint16'
            },
            {
                name: 'message',
                type: 'string'
            }
        ],
        name: 'HttpError',
        type: 'error'
    },
    {
        inputs: [],
        name: 'InvalidBatchGatewayResponse',
        type: 'error'
    },
    {
        inputs: [
            {
                name: 'errorData',
                type: 'bytes'
            }
        ],
        name: 'ResolverError',
        type: 'error'
    },
    {
        inputs: [
            {
                name: 'name',
                type: 'bytes'
            },
            {
                name: 'resolver',
                type: 'address'
            }
        ],
        name: 'ResolverNotContract',
        type: 'error'
    },
    {
        inputs: [
            {
                name: 'name',
                type: 'bytes'
            }
        ],
        name: 'ResolverNotFound',
        type: 'error'
    },
    {
        inputs: [
            {
                name: 'primary',
                type: 'string'
            },
            {
                name: 'primaryAddress',
                type: 'bytes'
            }
        ],
        name: 'ReverseAddressMismatch',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'bytes4',
                name: 'selector',
                type: 'bytes4'
            }
        ],
        name: 'UnsupportedResolverProfile',
        type: 'error'
    }
];
exports.universalResolverResolveAbi = [
    ...universalResolverErrors,
    {
        name: 'resolveWithGateways',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                name: 'name',
                type: 'bytes'
            },
            {
                name: 'data',
                type: 'bytes'
            },
            {
                name: 'gateways',
                type: 'string[]'
            }
        ],
        outputs: [
            {
                name: '',
                type: 'bytes'
            },
            {
                name: 'address',
                type: 'address'
            }
        ]
    }
];
exports.universalResolverReverseAbi = [
    ...universalResolverErrors,
    {
        name: 'reverseWithGateways',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                type: 'bytes',
                name: 'reverseName'
            },
            {
                type: 'uint256',
                name: 'coinType'
            },
            {
                type: 'string[]',
                name: 'gateways'
            }
        ],
        outputs: [
            {
                type: 'string',
                name: 'resolvedName'
            },
            {
                type: 'address',
                name: 'resolver'
            },
            {
                type: 'address',
                name: 'reverseResolver'
            }
        ]
    }
];
exports.textResolverAbi = [
    {
        name: 'text',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                name: 'name',
                type: 'bytes32'
            },
            {
                name: 'key',
                type: 'string'
            }
        ],
        outputs: [
            {
                name: '',
                type: 'string'
            }
        ]
    }
];
exports.addressResolverAbi = [
    {
        name: 'addr',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                name: 'name',
                type: 'bytes32'
            }
        ],
        outputs: [
            {
                name: '',
                type: 'address'
            }
        ]
    },
    {
        name: 'addr',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                name: 'name',
                type: 'bytes32'
            },
            {
                name: 'coinType',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                name: '',
                type: 'bytes'
            }
        ]
    }
];
exports.erc1271Abi = [
    {
        name: 'isValidSignature',
        type: 'function',
        stateMutability: 'view',
        inputs: [
            {
                name: 'hash',
                type: 'bytes32'
            },
            {
                name: 'signature',
                type: 'bytes'
            }
        ],
        outputs: [
            {
                name: '',
                type: 'bytes4'
            }
        ]
    }
];
exports.erc6492SignatureValidatorAbi = [
    {
        inputs: [
            {
                name: '_signer',
                type: 'address'
            },
            {
                name: '_hash',
                type: 'bytes32'
            },
            {
                name: '_signature',
                type: 'bytes'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'constructor'
    },
    {
        inputs: [
            {
                name: '_signer',
                type: 'address'
            },
            {
                name: '_hash',
                type: 'bytes32'
            },
            {
                name: '_signature',
                type: 'bytes'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function',
        name: 'isValidSig'
    }
];
exports.erc20Abi = [
    {
        type: 'event',
        name: 'Approval',
        inputs: [
            {
                indexed: true,
                name: 'owner',
                type: 'address'
            },
            {
                indexed: true,
                name: 'spender',
                type: 'address'
            },
            {
                indexed: false,
                name: 'value',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'event',
        name: 'Transfer',
        inputs: [
            {
                indexed: true,
                name: 'from',
                type: 'address'
            },
            {
                indexed: true,
                name: 'to',
                type: 'address'
            },
            {
                indexed: false,
                name: 'value',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'allowance',
        stateMutability: 'view',
        inputs: [
            {
                name: 'owner',
                type: 'address'
            },
            {
                name: 'spender',
                type: 'address'
            }
        ],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'approve',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'spender',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    },
    {
        type: 'function',
        name: 'balanceOf',
        stateMutability: 'view',
        inputs: [
            {
                name: 'account',
                type: 'address'
            }
        ],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'decimals',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'uint8'
            }
        ]
    },
    {
        type: 'function',
        name: 'name',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'string'
            }
        ]
    },
    {
        type: 'function',
        name: 'symbol',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'string'
            }
        ]
    },
    {
        type: 'function',
        name: 'totalSupply',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'transfer',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'recipient',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    },
    {
        type: 'function',
        name: 'transferFrom',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'sender',
                type: 'address'
            },
            {
                name: 'recipient',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    }
];
exports.erc20Abi_bytes32 = [
    {
        type: 'event',
        name: 'Approval',
        inputs: [
            {
                indexed: true,
                name: 'owner',
                type: 'address'
            },
            {
                indexed: true,
                name: 'spender',
                type: 'address'
            },
            {
                indexed: false,
                name: 'value',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'event',
        name: 'Transfer',
        inputs: [
            {
                indexed: true,
                name: 'from',
                type: 'address'
            },
            {
                indexed: true,
                name: 'to',
                type: 'address'
            },
            {
                indexed: false,
                name: 'value',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'allowance',
        stateMutability: 'view',
        inputs: [
            {
                name: 'owner',
                type: 'address'
            },
            {
                name: 'spender',
                type: 'address'
            }
        ],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'approve',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'spender',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    },
    {
        type: 'function',
        name: 'balanceOf',
        stateMutability: 'view',
        inputs: [
            {
                name: 'account',
                type: 'address'
            }
        ],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'decimals',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'uint8'
            }
        ]
    },
    {
        type: 'function',
        name: 'name',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'bytes32'
            }
        ]
    },
    {
        type: 'function',
        name: 'symbol',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'bytes32'
            }
        ]
    },
    {
        type: 'function',
        name: 'totalSupply',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'transfer',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'recipient',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    },
    {
        type: 'function',
        name: 'transferFrom',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'sender',
                type: 'address'
            },
            {
                name: 'recipient',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    }
];
exports.erc1155Abi = [
    {
        inputs: [
            {
                internalType: 'address',
                name: 'sender',
                type: 'address'
            },
            {
                internalType: 'uint256',
                name: 'balance',
                type: 'uint256'
            },
            {
                internalType: 'uint256',
                name: 'needed',
                type: 'uint256'
            },
            {
                internalType: 'uint256',
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        name: 'ERC1155InsufficientBalance',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'approver',
                type: 'address'
            }
        ],
        name: 'ERC1155InvalidApprover',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: 'idsLength',
                type: 'uint256'
            },
            {
                internalType: 'uint256',
                name: 'valuesLength',
                type: 'uint256'
            }
        ],
        name: 'ERC1155InvalidArrayLength',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'operator',
                type: 'address'
            }
        ],
        name: 'ERC1155InvalidOperator',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'receiver',
                type: 'address'
            }
        ],
        name: 'ERC1155InvalidReceiver',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'sender',
                type: 'address'
            }
        ],
        name: 'ERC1155InvalidSender',
        type: 'error'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'operator',
                type: 'address'
            },
            {
                internalType: 'address',
                name: 'owner',
                type: 'address'
            }
        ],
        name: 'ERC1155MissingApprovalForAll',
        type: 'error'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'account',
                type: 'address'
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'operator',
                type: 'address'
            },
            {
                indexed: false,
                internalType: 'bool',
                name: 'approved',
                type: 'bool'
            }
        ],
        name: 'ApprovalForAll',
        type: 'event'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'operator',
                type: 'address'
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'from',
                type: 'address'
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'to',
                type: 'address'
            },
            {
                indexed: false,
                internalType: 'uint256[]',
                name: 'ids',
                type: 'uint256[]'
            },
            {
                indexed: false,
                internalType: 'uint256[]',
                name: 'values',
                type: 'uint256[]'
            }
        ],
        name: 'TransferBatch',
        type: 'event'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'operator',
                type: 'address'
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'from',
                type: 'address'
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'to',
                type: 'address'
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'id',
                type: 'uint256'
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'value',
                type: 'uint256'
            }
        ],
        name: 'TransferSingle',
        type: 'event'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: false,
                internalType: 'string',
                name: 'value',
                type: 'string'
            },
            {
                indexed: true,
                internalType: 'uint256',
                name: 'id',
                type: 'uint256'
            }
        ],
        name: 'URI',
        type: 'event'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'account',
                type: 'address'
            },
            {
                internalType: 'uint256',
                name: 'id',
                type: 'uint256'
            }
        ],
        name: 'balanceOf',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'address[]',
                name: 'accounts',
                type: 'address[]'
            },
            {
                internalType: 'uint256[]',
                name: 'ids',
                type: 'uint256[]'
            }
        ],
        name: 'balanceOfBatch',
        outputs: [
            {
                internalType: 'uint256[]',
                name: '',
                type: 'uint256[]'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'account',
                type: 'address'
            },
            {
                internalType: 'address',
                name: 'operator',
                type: 'address'
            }
        ],
        name: 'isApprovedForAll',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'from',
                type: 'address'
            },
            {
                internalType: 'address',
                name: 'to',
                type: 'address'
            },
            {
                internalType: 'uint256[]',
                name: 'ids',
                type: 'uint256[]'
            },
            {
                internalType: 'uint256[]',
                name: 'values',
                type: 'uint256[]'
            },
            {
                internalType: 'bytes',
                name: 'data',
                type: 'bytes'
            }
        ],
        name: 'safeBatchTransferFrom',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'from',
                type: 'address'
            },
            {
                internalType: 'address',
                name: 'to',
                type: 'address'
            },
            {
                internalType: 'uint256',
                name: 'id',
                type: 'uint256'
            },
            {
                internalType: 'uint256',
                name: 'value',
                type: 'uint256'
            },
            {
                internalType: 'bytes',
                name: 'data',
                type: 'bytes'
            }
        ],
        name: 'safeTransferFrom',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'operator',
                type: 'address'
            },
            {
                internalType: 'bool',
                name: 'approved',
                type: 'bool'
            }
        ],
        name: 'setApprovalForAll',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'bytes4',
                name: 'interfaceId',
                type: 'bytes4'
            }
        ],
        name: 'supportsInterface',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256'
            }
        ],
        name: 'uri',
        outputs: [
            {
                internalType: 'string',
                name: '',
                type: 'string'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    }
];
exports.erc721Abi = [
    {
        type: 'event',
        name: 'Approval',
        inputs: [
            {
                indexed: true,
                name: 'owner',
                type: 'address'
            },
            {
                indexed: true,
                name: 'spender',
                type: 'address'
            },
            {
                indexed: true,
                name: 'tokenId',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'event',
        name: 'ApprovalForAll',
        inputs: [
            {
                indexed: true,
                name: 'owner',
                type: 'address'
            },
            {
                indexed: true,
                name: 'operator',
                type: 'address'
            },
            {
                indexed: false,
                name: 'approved',
                type: 'bool'
            }
        ]
    },
    {
        type: 'event',
        name: 'Transfer',
        inputs: [
            {
                indexed: true,
                name: 'from',
                type: 'address'
            },
            {
                indexed: true,
                name: 'to',
                type: 'address'
            },
            {
                indexed: true,
                name: 'tokenId',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'approve',
        stateMutability: 'payable',
        inputs: [
            {
                name: 'spender',
                type: 'address'
            },
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        outputs: []
    },
    {
        type: 'function',
        name: 'balanceOf',
        stateMutability: 'view',
        inputs: [
            {
                name: 'account',
                type: 'address'
            }
        ],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'getApproved',
        stateMutability: 'view',
        inputs: [
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'address'
            }
        ]
    },
    {
        type: 'function',
        name: 'isApprovedForAll',
        stateMutability: 'view',
        inputs: [
            {
                name: 'owner',
                type: 'address'
            },
            {
                name: 'operator',
                type: 'address'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ]
    },
    {
        type: 'function',
        name: 'name',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'string'
            }
        ]
    },
    {
        type: 'function',
        name: 'ownerOf',
        stateMutability: 'view',
        inputs: [
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                name: 'owner',
                type: 'address'
            }
        ]
    },
    {
        type: 'function',
        name: 'safeTransferFrom',
        stateMutability: 'payable',
        inputs: [
            {
                name: 'from',
                type: 'address'
            },
            {
                name: 'to',
                type: 'address'
            },
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        outputs: []
    },
    {
        type: 'function',
        name: 'safeTransferFrom',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'from',
                type: 'address'
            },
            {
                name: 'to',
                type: 'address'
            },
            {
                name: 'id',
                type: 'uint256'
            },
            {
                name: 'data',
                type: 'bytes'
            }
        ],
        outputs: []
    },
    {
        type: 'function',
        name: 'setApprovalForAll',
        stateMutability: 'nonpayable',
        inputs: [
            {
                name: 'operator',
                type: 'address'
            },
            {
                name: 'approved',
                type: 'bool'
            }
        ],
        outputs: []
    },
    {
        type: 'function',
        name: 'symbol',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'string'
            }
        ]
    },
    {
        type: 'function',
        name: 'tokenByIndex',
        stateMutability: 'view',
        inputs: [
            {
                name: 'index',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'tokenByIndex',
        stateMutability: 'view',
        inputs: [
            {
                name: 'owner',
                type: 'address'
            },
            {
                name: 'index',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'tokenURI',
        stateMutability: 'view',
        inputs: [
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        outputs: [
            {
                type: 'string'
            }
        ]
    },
    {
        type: 'function',
        name: 'totalSupply',
        stateMutability: 'view',
        inputs: [],
        outputs: [
            {
                type: 'uint256'
            }
        ]
    },
    {
        type: 'function',
        name: 'transferFrom',
        stateMutability: 'payable',
        inputs: [
            {
                name: 'sender',
                type: 'address'
            },
            {
                name: 'recipient',
                type: 'address'
            },
            {
                name: 'tokenId',
                type: 'uint256'
            }
        ],
        outputs: []
    }
];
exports.erc4626Abi = [
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: 'owner',
                type: 'address'
            },
            {
                indexed: true,
                name: 'spender',
                type: 'address'
            },
            {
                indexed: false,
                name: 'value',
                type: 'uint256'
            }
        ],
        name: 'Approval',
        type: 'event'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: 'sender',
                type: 'address'
            },
            {
                indexed: true,
                name: 'receiver',
                type: 'address'
            },
            {
                indexed: false,
                name: 'assets',
                type: 'uint256'
            },
            {
                indexed: false,
                name: 'shares',
                type: 'uint256'
            }
        ],
        name: 'Deposit',
        type: 'event'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: 'from',
                type: 'address'
            },
            {
                indexed: true,
                name: 'to',
                type: 'address'
            },
            {
                indexed: false,
                name: 'value',
                type: 'uint256'
            }
        ],
        name: 'Transfer',
        type: 'event'
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: 'sender',
                type: 'address'
            },
            {
                indexed: true,
                name: 'receiver',
                type: 'address'
            },
            {
                indexed: true,
                name: 'owner',
                type: 'address'
            },
            {
                indexed: false,
                name: 'assets',
                type: 'uint256'
            },
            {
                indexed: false,
                name: 'shares',
                type: 'uint256'
            }
        ],
        name: 'Withdraw',
        type: 'event'
    },
    {
        inputs: [
            {
                name: 'owner',
                type: 'address'
            },
            {
                name: 'spender',
                type: 'address'
            }
        ],
        name: 'allowance',
        outputs: [
            {
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'spender',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        name: 'approve',
        outputs: [
            {
                type: 'bool'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [],
        name: 'asset',
        outputs: [
            {
                name: 'assetTokenAddress',
                type: 'address'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'account',
                type: 'address'
            }
        ],
        name: 'balanceOf',
        outputs: [
            {
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        name: 'convertToAssets',
        outputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        name: 'convertToShares',
        outputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'assets',
                type: 'uint256'
            },
            {
                name: 'receiver',
                type: 'address'
            }
        ],
        name: 'deposit',
        outputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'caller',
                type: 'address'
            }
        ],
        name: 'maxDeposit',
        outputs: [
            {
                name: 'maxAssets',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'caller',
                type: 'address'
            }
        ],
        name: 'maxMint',
        outputs: [
            {
                name: 'maxShares',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'owner',
                type: 'address'
            }
        ],
        name: 'maxRedeem',
        outputs: [
            {
                name: 'maxShares',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'owner',
                type: 'address'
            }
        ],
        name: 'maxWithdraw',
        outputs: [
            {
                name: 'maxAssets',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'shares',
                type: 'uint256'
            },
            {
                name: 'receiver',
                type: 'address'
            }
        ],
        name: 'mint',
        outputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        name: 'previewDeposit',
        outputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        name: 'previewMint',
        outputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        name: 'previewRedeem',
        outputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        name: 'previewWithdraw',
        outputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'shares',
                type: 'uint256'
            },
            {
                name: 'receiver',
                type: 'address'
            },
            {
                name: 'owner',
                type: 'address'
            }
        ],
        name: 'redeem',
        outputs: [
            {
                name: 'assets',
                type: 'uint256'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [],
        name: 'totalAssets',
        outputs: [
            {
                name: 'totalManagedAssets',
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [],
        name: 'totalSupply',
        outputs: [
            {
                type: 'uint256'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'to',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        name: 'transfer',
        outputs: [
            {
                type: 'bool'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'from',
                type: 'address'
            },
            {
                name: 'to',
                type: 'address'
            },
            {
                name: 'amount',
                type: 'uint256'
            }
        ],
        name: 'transferFrom',
        outputs: [
            {
                type: 'bool'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    },
    {
        inputs: [
            {
                name: 'assets',
                type: 'uint256'
            },
            {
                name: 'receiver',
                type: 'address'
            },
            {
                name: 'owner',
                type: 'address'
            }
        ],
        name: 'withdraw',
        outputs: [
            {
                name: 'shares',
                type: 'uint256'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function'
    }
]; //# sourceMappingURL=abis.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.aggregate3Signature = void 0;
exports.aggregate3Signature = '0x82ad56cb'; //# sourceMappingURL=contract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contracts.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.multicall3Bytecode = exports.erc6492SignatureValidatorByteCode = exports.deploylessCallViaFactoryBytecode = exports.deploylessCallViaBytecodeBytecode = void 0;
exports.deploylessCallViaBytecodeBytecode = '0x608060405234801561001057600080fd5b5060405161018e38038061018e83398101604081905261002f91610124565b6000808351602085016000f59050803b61004857600080fd5b6000808351602085016000855af16040513d6000823e81610067573d81fd5b3d81f35b634e487b7160e01b600052604160045260246000fd5b600082601f83011261009257600080fd5b81516001600160401b038111156100ab576100ab61006b565b604051601f8201601f19908116603f011681016001600160401b03811182821017156100d9576100d961006b565b6040528181528382016020018510156100f157600080fd5b60005b82811015610110576020818601810151838301820152016100f4565b506000918101602001919091529392505050565b6000806040838503121561013757600080fd5b82516001600160401b0381111561014d57600080fd5b61015985828601610081565b602085015190935090506001600160401b0381111561017757600080fd5b61018385828601610081565b915050925092905056fe';
exports.deploylessCallViaFactoryBytecode = '0x608060405234801561001057600080fd5b506040516102c03803806102c083398101604081905261002f916101e6565b836001600160a01b03163b6000036100e457600080836001600160a01b03168360405161005c9190610270565b6000604051808303816000865af19150503d8060008114610099576040519150601f19603f3d011682016040523d82523d6000602084013e61009e565b606091505b50915091508115806100b857506001600160a01b0386163b155b156100e1578060405163101bb98d60e01b81526004016100d8919061028c565b60405180910390fd5b50505b6000808451602086016000885af16040513d6000823e81610103573d81fd5b3d81f35b80516001600160a01b038116811461011e57600080fd5b919050565b634e487b7160e01b600052604160045260246000fd5b60005b8381101561015457818101518382015260200161013c565b50506000910152565b600082601f83011261016e57600080fd5b81516001600160401b0381111561018757610187610123565b604051601f8201601f19908116603f011681016001600160401b03811182821017156101b5576101b5610123565b6040528181528382016020018510156101cd57600080fd5b6101de826020830160208701610139565b949350505050565b600080600080608085870312156101fc57600080fd5b61020585610107565b60208601519094506001600160401b0381111561022157600080fd5b61022d8782880161015d565b93505061023c60408601610107565b60608601519092506001600160401b0381111561025857600080fd5b6102648782880161015d565b91505092959194509250565b60008251610282818460208701610139565b9190910192915050565b60208152600082518060208401526102ab816040850160208701610139565b601f01601f1916919091016040019291505056fe';
exports.erc6492SignatureValidatorByteCode = '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';
exports.multicall3Bytecode = '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'; //# sourceMappingURL=contracts.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/chain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InvalidChainIdError = exports.ClientChainNotConfiguredError = exports.ChainNotFoundError = exports.ChainMismatchError = exports.ChainDoesNotSupportContract = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class ChainDoesNotSupportContract extends base_js_1.BaseError {
    constructor({ blockNumber, chain, contract }){
        super('Chain "'.concat(chain.name, '" does not support contract "').concat(contract.name, '".'), {
            metaMessages: [
                'This could be due to any of the following:',
                ...blockNumber && contract.blockCreated && contract.blockCreated > blockNumber ? [
                    '- The contract "'.concat(contract.name, '" was not deployed until block ').concat(contract.blockCreated, " (current block ").concat(blockNumber, ").")
                ] : [
                    '- The chain does not have the contract "'.concat(contract.name, '" configured.')
                ]
            ],
            name: 'ChainDoesNotSupportContract'
        });
    }
}
exports.ChainDoesNotSupportContract = ChainDoesNotSupportContract;
class ChainMismatchError extends base_js_1.BaseError {
    constructor({ chain, currentChainId }){
        super("The current chain of the wallet (id: ".concat(currentChainId, ") does not match the target chain for the transaction (id: ").concat(chain.id, " – ").concat(chain.name, ")."), {
            metaMessages: [
                "Current Chain ID:  ".concat(currentChainId),
                "Expected Chain ID: ".concat(chain.id, " – ").concat(chain.name)
            ],
            name: 'ChainMismatchError'
        });
    }
}
exports.ChainMismatchError = ChainMismatchError;
class ChainNotFoundError extends base_js_1.BaseError {
    constructor(){
        super([
            'No chain was provided to the request.',
            'Please provide a chain with the `chain` argument on the Action, or by supplying a `chain` to WalletClient.'
        ].join('\n'), {
            name: 'ChainNotFoundError'
        });
    }
}
exports.ChainNotFoundError = ChainNotFoundError;
class ClientChainNotConfiguredError extends base_js_1.BaseError {
    constructor(){
        super('No chain was provided to the Client.', {
            name: 'ClientChainNotConfiguredError'
        });
    }
}
exports.ClientChainNotConfiguredError = ClientChainNotConfiguredError;
class InvalidChainIdError extends base_js_1.BaseError {
    constructor({ chainId }){
        super(typeof chainId === 'number' ? 'Chain ID "'.concat(chainId, '" is invalid.') : 'Chain ID is invalid.', {
            name: 'InvalidChainIdError'
        });
    }
}
exports.InvalidChainIdError = InvalidChainIdError; //# sourceMappingURL=chain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeDeployData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeDeployData = encodeDeployData;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/encodeDeployData';
function encodeDeployData(parameters) {
    const { abi, args, bytecode } = parameters;
    if (!args || args.length === 0) return bytecode;
    const description = abi.find((x)=>'type' in x && x.type === 'constructor');
    if (!description) throw new abi_js_1.AbiConstructorNotFoundError({
        docsPath
    });
    if (!('inputs' in description)) throw new abi_js_1.AbiConstructorParamsNotFoundError({
        docsPath
    });
    if (!description.inputs || description.inputs.length === 0) throw new abi_js_1.AbiConstructorParamsNotFoundError({
        docsPath
    });
    const data = (0, encodeAbiParameters_js_1.encodeAbiParameters)(description.inputs, args);
    return (0, concat_js_1.concatHex)([
        bytecode,
        data
    ]);
} //# sourceMappingURL=encodeDeployData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getChainContractAddress = getChainContractAddress;
const chain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/chain.js [app-client] (ecmascript)");
function getChainContractAddress(param) {
    let { blockNumber, chain, contract: name } = param;
    var _chain_contracts;
    const contract = chain === null || chain === void 0 ? void 0 : (_chain_contracts = chain.contracts) === null || _chain_contracts === void 0 ? void 0 : _chain_contracts[name];
    if (!contract) throw new chain_js_1.ChainDoesNotSupportContract({
        chain,
        contract: {
            name
        }
    });
    if (blockNumber && contract.blockCreated && contract.blockCreated > blockNumber) throw new chain_js_1.ChainDoesNotSupportContract({
        blockNumber,
        chain,
        contract: {
            name,
            blockCreated: contract.blockCreated
        }
    });
    return contract.address;
} //# sourceMappingURL=getChainContractAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getCallError.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getCallError = getCallError;
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const getNodeError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getNodeError.js [app-client] (ecmascript)");
function getCallError(err, param) {
    let { docsPath, ...args } = param;
    const cause = (()=>{
        const cause = (0, getNodeError_js_1.getNodeError)(err, args);
        if (cause instanceof node_js_1.UnknownNodeError) return err;
        return cause;
    })();
    return new contract_js_1.CallExecutionError(cause, {
        docsPath,
        ...args
    });
} //# sourceMappingURL=getCallError.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withResolvers.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.withResolvers = withResolvers;
function withResolvers() {
    let resolve = ()=>undefined;
    let reject = ()=>undefined;
    const promise = new Promise((resolve_, reject_)=>{
        resolve = resolve_;
        reject = reject_;
    });
    return {
        promise,
        resolve,
        reject
    };
} //# sourceMappingURL=withResolvers.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/createBatchScheduler.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createBatchScheduler = createBatchScheduler;
const withResolvers_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withResolvers.js [app-client] (ecmascript)");
const schedulerCache = new Map();
function createBatchScheduler(param) {
    let { fn, id, shouldSplitBatch, wait = 0, sort } = param;
    const exec = async ()=>{
        const scheduler = getScheduler();
        flush();
        const args = scheduler.map((param)=>{
            let { args } = param;
            return args;
        });
        if (args.length === 0) return;
        fn(args).then((data)=>{
            if (sort && Array.isArray(data)) data.sort(sort);
            for(let i = 0; i < scheduler.length; i++){
                const { resolve } = scheduler[i];
                resolve === null || resolve === void 0 ? void 0 : resolve([
                    data[i],
                    data
                ]);
            }
        }).catch((err)=>{
            for(let i = 0; i < scheduler.length; i++){
                const { reject } = scheduler[i];
                reject === null || reject === void 0 ? void 0 : reject(err);
            }
        });
    };
    const flush = ()=>schedulerCache.delete(id);
    const getBatchedArgs = ()=>getScheduler().map((param)=>{
            let { args } = param;
            return args;
        });
    const getScheduler = ()=>schedulerCache.get(id) || [];
    const setScheduler = (item)=>schedulerCache.set(id, [
            ...getScheduler(),
            item
        ]);
    return {
        flush,
        async schedule (args) {
            const { promise, resolve, reject } = (0, withResolvers_js_1.withResolvers)();
            const split = shouldSplitBatch === null || shouldSplitBatch === void 0 ? void 0 : shouldSplitBatch([
                ...getBatchedArgs(),
                args
            ]);
            if (split) exec();
            const hasActiveScheduler = getScheduler().length > 0;
            if (hasActiveScheduler) {
                setScheduler({
                    args,
                    resolve,
                    reject
                });
                return promise;
            }
            setScheduler({
                args,
                resolve,
                reject
            });
            setTimeout(exec, wait);
            return promise;
        }
    };
} //# sourceMappingURL=createBatchScheduler.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/ccip.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.OffchainLookupSenderMismatchError = exports.OffchainLookupResponseMalformedError = exports.OffchainLookupError = void 0;
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const utils_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/utils.js [app-client] (ecmascript)");
class OffchainLookupError extends base_js_1.BaseError {
    constructor({ callbackSelector, cause, data, extraData, sender, urls }){
        var _cause_metaMessages;
        super(cause.shortMessage || 'An error occurred while fetching for an offchain result.', {
            cause,
            metaMessages: [
                ...cause.metaMessages || [],
                ((_cause_metaMessages = cause.metaMessages) === null || _cause_metaMessages === void 0 ? void 0 : _cause_metaMessages.length) ? '' : [],
                'Offchain Gateway Call:',
                urls && [
                    '  Gateway URL(s):',
                    ...urls.map((url)=>"    ".concat((0, utils_js_1.getUrl)(url)))
                ],
                "  Sender: ".concat(sender),
                "  Data: ".concat(data),
                "  Callback selector: ".concat(callbackSelector),
                "  Extra data: ".concat(extraData)
            ].flat(),
            name: 'OffchainLookupError'
        });
    }
}
exports.OffchainLookupError = OffchainLookupError;
class OffchainLookupResponseMalformedError extends base_js_1.BaseError {
    constructor({ result, url }){
        super('Offchain gateway response is malformed. Response data must be a hex value.', {
            metaMessages: [
                "Gateway URL: ".concat((0, utils_js_1.getUrl)(url)),
                "Response: ".concat((0, stringify_js_1.stringify)(result))
            ],
            name: 'OffchainLookupResponseMalformedError'
        });
    }
}
exports.OffchainLookupResponseMalformedError = OffchainLookupResponseMalformedError;
class OffchainLookupSenderMismatchError extends base_js_1.BaseError {
    constructor({ sender, to }){
        super('Reverted sender address does not match target contract address (`to`).', {
            metaMessages: [
                "Contract address: ".concat(to),
                "OffchainLookup sender address: ".concat(sender)
            ],
            name: 'OffchainLookupSenderMismatchError'
        });
    }
}
exports.OffchainLookupSenderMismatchError = OffchainLookupSenderMismatchError; //# sourceMappingURL=ccip.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeFunctionData = decodeFunctionData;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const toFunctionSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)");
const decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
function decodeFunctionData(parameters) {
    const { abi, data } = parameters;
    const signature = (0, slice_js_1.slice)(data, 0, 4);
    const description = abi.find((x)=>x.type === 'function' && signature === (0, toFunctionSelector_js_1.toFunctionSelector)((0, formatAbiItem_js_1.formatAbiItem)(x)));
    if (!description) throw new abi_js_1.AbiFunctionSignatureNotFoundError(signature, {
        docsPath: '/docs/contract/decodeFunctionData'
    });
    return {
        functionName: description.name,
        args: 'inputs' in description && description.inputs && description.inputs.length > 0 ? (0, decodeAbiParameters_js_1.decodeAbiParameters)(description.inputs, (0, slice_js_1.slice)(data, 4)) : undefined
    };
} //# sourceMappingURL=decodeFunctionData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeErrorResult.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeErrorResult = encodeErrorResult;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const toFunctionSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/encodeErrorResult';
function encodeErrorResult(parameters) {
    const { abi, errorName, args } = parameters;
    let abiItem = abi[0];
    if (errorName) {
        const item = (0, getAbiItem_js_1.getAbiItem)({
            abi,
            args,
            name: errorName
        });
        if (!item) throw new abi_js_1.AbiErrorNotFoundError(errorName, {
            docsPath
        });
        abiItem = item;
    }
    if (abiItem.type !== 'error') throw new abi_js_1.AbiErrorNotFoundError(undefined, {
        docsPath
    });
    const definition = (0, formatAbiItem_js_1.formatAbiItem)(abiItem);
    const signature = (0, toFunctionSelector_js_1.toFunctionSelector)(definition);
    let data = '0x';
    if (args && args.length > 0) {
        if (!abiItem.inputs) throw new abi_js_1.AbiErrorInputsNotFoundError(abiItem.name, {
            docsPath
        });
        data = (0, encodeAbiParameters_js_1.encodeAbiParameters)(abiItem.inputs, args);
    }
    return (0, concat_js_1.concatHex)([
        signature,
        data
    ]);
} //# sourceMappingURL=encodeErrorResult.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionResult.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeFunctionResult = encodeFunctionResult;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/encodeFunctionResult';
function encodeFunctionResult(parameters) {
    const { abi, functionName, result } = parameters;
    let abiItem = abi[0];
    if (functionName) {
        const item = (0, getAbiItem_js_1.getAbiItem)({
            abi,
            name: functionName
        });
        if (!item) throw new abi_js_1.AbiFunctionNotFoundError(functionName, {
            docsPath
        });
        abiItem = item;
    }
    if (abiItem.type !== 'function') throw new abi_js_1.AbiFunctionNotFoundError(undefined, {
        docsPath
    });
    if (!abiItem.outputs) throw new abi_js_1.AbiFunctionOutputsNotFoundError(abiItem.name, {
        docsPath
    });
    const values = (()=>{
        if (abiItem.outputs.length === 0) return [];
        if (abiItem.outputs.length === 1) return [
            result
        ];
        if (Array.isArray(result)) return result;
        throw new abi_js_1.InvalidArrayError(result);
    })();
    return (0, encodeAbiParameters_js_1.encodeAbiParameters)(abiItem.outputs, values);
} //# sourceMappingURL=encodeFunctionResult.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/localBatchGatewayRequest.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.localBatchGatewayUrl = void 0;
exports.localBatchGatewayRequest = localBatchGatewayRequest;
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const solidity_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/solidity.js [app-client] (ecmascript)");
const decodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionData.js [app-client] (ecmascript)");
const encodeErrorResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeErrorResult.js [app-client] (ecmascript)");
const encodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionResult.js [app-client] (ecmascript)");
exports.localBatchGatewayUrl = 'x-batch-gateway:true';
async function localBatchGatewayRequest(parameters) {
    const { data, ccipRequest } = parameters;
    const { args: [queries] } = (0, decodeFunctionData_js_1.decodeFunctionData)({
        abi: abis_js_1.batchGatewayAbi,
        data
    });
    const failures = [];
    const responses = [];
    await Promise.all(queries.map(async (query, i)=>{
        try {
            responses[i] = query.urls.includes(exports.localBatchGatewayUrl) ? await localBatchGatewayRequest({
                data: query.data,
                ccipRequest
            }) : await ccipRequest(query);
            failures[i] = false;
        } catch (err) {
            failures[i] = true;
            responses[i] = encodeError(err);
        }
    }));
    return (0, encodeFunctionResult_js_1.encodeFunctionResult)({
        abi: abis_js_1.batchGatewayAbi,
        functionName: 'query',
        result: [
            failures,
            responses
        ]
    });
}
function encodeError(error) {
    if (error.name === 'HttpRequestError' && error.status) return (0, encodeErrorResult_js_1.encodeErrorResult)({
        abi: abis_js_1.batchGatewayAbi,
        errorName: 'HttpError',
        args: [
            error.status,
            error.shortMessage
        ]
    });
    return (0, encodeErrorResult_js_1.encodeErrorResult)({
        abi: [
            solidity_js_1.solidityError
        ],
        errorName: 'Error',
        args: [
            'shortMessage' in error ? error.shortMessage : error.message
        ]
    });
} //# sourceMappingURL=localBatchGatewayRequest.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ccip.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.offchainLookupAbiItem = exports.offchainLookupSignature = void 0;
exports.offchainLookup = offchainLookup;
exports.ccipRequest = ccipRequest;
const call_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/call.js [app-client] (ecmascript)");
const ccip_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/ccip.js [app-client] (ecmascript)");
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const decodeErrorResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeErrorResult.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const localBatchGatewayRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/localBatchGatewayRequest.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
exports.offchainLookupSignature = '0x556f1830';
exports.offchainLookupAbiItem = {
    name: 'OffchainLookup',
    type: 'error',
    inputs: [
        {
            name: 'sender',
            type: 'address'
        },
        {
            name: 'urls',
            type: 'string[]'
        },
        {
            name: 'callData',
            type: 'bytes'
        },
        {
            name: 'callbackFunction',
            type: 'bytes4'
        },
        {
            name: 'extraData',
            type: 'bytes'
        }
    ]
};
async function offchainLookup(client, param) {
    let { blockNumber, blockTag, data, to } = param;
    const { args } = (0, decodeErrorResult_js_1.decodeErrorResult)({
        data,
        abi: [
            exports.offchainLookupAbiItem
        ]
    });
    const [sender, urls, callData, callbackSelector, extraData] = args;
    const { ccipRead } = client;
    const ccipRequest_ = ccipRead && typeof (ccipRead === null || ccipRead === void 0 ? void 0 : ccipRead.request) === 'function' ? ccipRead.request : ccipRequest;
    try {
        if (!(0, isAddressEqual_js_1.isAddressEqual)(to, sender)) throw new ccip_js_1.OffchainLookupSenderMismatchError({
            sender,
            to
        });
        const result = urls.includes(localBatchGatewayRequest_js_1.localBatchGatewayUrl) ? await (0, localBatchGatewayRequest_js_1.localBatchGatewayRequest)({
            data: callData,
            ccipRequest: ccipRequest_
        }) : await ccipRequest_({
            data: callData,
            sender,
            urls
        });
        const { data: data_ } = await (0, call_js_1.call)(client, {
            blockNumber,
            blockTag,
            data: (0, concat_js_1.concat)([
                callbackSelector,
                (0, encodeAbiParameters_js_1.encodeAbiParameters)([
                    {
                        type: 'bytes'
                    },
                    {
                        type: 'bytes'
                    }
                ], [
                    result,
                    extraData
                ])
            ]),
            to
        });
        return data_;
    } catch (err) {
        throw new ccip_js_1.OffchainLookupError({
            callbackSelector,
            cause: err,
            data,
            extraData,
            sender,
            urls
        });
    }
}
async function ccipRequest(param) {
    let { data, sender, urls } = param;
    let error = new Error('An unknown error occurred.');
    for(let i = 0; i < urls.length; i++){
        const url = urls[i];
        const method = url.includes('{data}') ? 'GET' : 'POST';
        const body = method === 'POST' ? {
            data,
            sender
        } : undefined;
        const headers = method === 'POST' ? {
            'Content-Type': 'application/json'
        } : {};
        try {
            var _response_headers_get;
            const response = await fetch(url.replace('{sender}', sender.toLowerCase()).replace('{data}', data), {
                body: JSON.stringify(body),
                headers,
                method
            });
            let result;
            if ((_response_headers_get = response.headers.get('Content-Type')) === null || _response_headers_get === void 0 ? void 0 : _response_headers_get.startsWith('application/json')) {
                result = (await response.json()).data;
            } else {
                result = await response.text();
            }
            if (!response.ok) {
                error = new request_js_1.HttpRequestError({
                    body,
                    details: (result === null || result === void 0 ? void 0 : result.error) ? (0, stringify_js_1.stringify)(result.error) : response.statusText,
                    headers: response.headers,
                    status: response.status,
                    url
                });
                continue;
            }
            if (!(0, isHex_js_1.isHex)(result)) {
                error = new ccip_js_1.OffchainLookupResponseMalformedError({
                    result,
                    url
                });
                continue;
            }
            return result;
        } catch (err) {
            error = new request_js_1.HttpRequestError({
                body,
                details: err.message,
                url
            });
        }
    }
    throw error;
} //# sourceMappingURL=ccip.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/call.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.call = call;
exports.getRevertErrorData = getRevertErrorData;
const abitype_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/cjs/exports/index.js [app-client] (ecmascript)");
const BlockOverrides = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/core/BlockOverrides.js [app-client] (ecmascript)");
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contract.js [app-client] (ecmascript)");
const contracts_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contracts.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const chain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/chain.js [app-client] (ecmascript)");
const contract_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeDeployData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeDeployData.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const getCallError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getCallError.js [app-client] (ecmascript)");
const extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const createBatchScheduler_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/createBatchScheduler.js [app-client] (ecmascript)");
const stateOverride_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stateOverride.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
async function call(client, args) {
    var _client_batch;
    var _client_experimental_blockTag;
    const { account: account_ = client.account, authorizationList, batch = Boolean((_client_batch = client.batch) === null || _client_batch === void 0 ? void 0 : _client_batch.multicall), blockNumber, blockTag = (_client_experimental_blockTag = client.experimental_blockTag) !== null && _client_experimental_blockTag !== void 0 ? _client_experimental_blockTag : 'latest', accessList, blobs, blockOverrides, code, data: data_, factory, factoryData, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce, to, value, stateOverride, ...rest } = args;
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : undefined;
    if (code && (factory || factoryData)) throw new base_js_1.BaseError('Cannot provide both `code` & `factory`/`factoryData` as parameters.');
    if (code && to) throw new base_js_1.BaseError('Cannot provide both `code` & `to` as parameters.');
    const deploylessCallViaBytecode = code && data_;
    const deploylessCallViaFactory = factory && factoryData && to && data_;
    const deploylessCall = deploylessCallViaBytecode || deploylessCallViaFactory;
    const data = (()=>{
        if (deploylessCallViaBytecode) return toDeploylessCallViaBytecodeData({
            code,
            data: data_
        });
        if (deploylessCallViaFactory) return toDeploylessCallViaFactoryData({
            data: data_,
            factory,
            factoryData,
            to
        });
        return data_;
    })();
    try {
        var _client_chain_formatters_transactionRequest, _client_chain_formatters, _client_chain;
        (0, assertRequest_js_1.assertRequest)(args);
        const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
        const block = blockNumberHex || blockTag;
        const rpcBlockOverrides = blockOverrides ? BlockOverrides.toRpc(blockOverrides) : undefined;
        const rpcStateOverride = (0, stateOverride_js_1.serializeStateOverride)(stateOverride);
        const chainFormat = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionRequest = _client_chain_formatters.transactionRequest) === null || _client_chain_formatters_transactionRequest === void 0 ? void 0 : _client_chain_formatters_transactionRequest.format;
        const format = chainFormat || transactionRequest_js_1.formatTransactionRequest;
        const request = format({
            ...(0, extract_js_1.extract)(rest, {
                format: chainFormat
            }),
            accessList,
            account,
            authorizationList,
            blobs,
            data,
            gas,
            gasPrice,
            maxFeePerBlobGas,
            maxFeePerGas,
            maxPriorityFeePerGas,
            nonce,
            to: deploylessCall ? undefined : to,
            value
        }, 'call');
        if (batch && shouldPerformMulticall({
            request
        }) && !rpcStateOverride && !rpcBlockOverrides) {
            try {
                return await scheduleMulticall(client, {
                    ...request,
                    blockNumber,
                    blockTag
                });
            } catch (err) {
                if (!(err instanceof chain_js_1.ClientChainNotConfiguredError) && !(err instanceof chain_js_1.ChainDoesNotSupportContract)) throw err;
            }
        }
        const params = (()=>{
            const base = [
                request,
                block
            ];
            if (rpcStateOverride && rpcBlockOverrides) return [
                ...base,
                rpcStateOverride,
                rpcBlockOverrides
            ];
            if (rpcStateOverride) return [
                ...base,
                rpcStateOverride
            ];
            if (rpcBlockOverrides) return [
                ...base,
                {},
                rpcBlockOverrides
            ];
            return base;
        })();
        const response = await client.request({
            method: 'eth_call',
            params
        });
        if (response === '0x') return {
            data: undefined
        };
        return {
            data: response
        };
    } catch (err) {
        const data = getRevertErrorData(err);
        const { offchainLookup, offchainLookupSignature } = await Promise.resolve().then(()=>__turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ccip.js [app-client] (ecmascript)"));
        if (client.ccipRead !== false && (data === null || data === void 0 ? void 0 : data.slice(0, 10)) === offchainLookupSignature && to) return {
            data: await offchainLookup(client, {
                data,
                to
            })
        };
        if (deploylessCall && (data === null || data === void 0 ? void 0 : data.slice(0, 10)) === '0x101bb98d') throw new contract_js_2.CounterfactualDeploymentFailedError({
            factory
        });
        throw (0, getCallError_js_1.getCallError)(err, {
            ...args,
            account,
            chain: client.chain
        });
    }
}
function shouldPerformMulticall(param) {
    let { request } = param;
    const { data, to, ...request_ } = request;
    if (!data) return false;
    if (data.startsWith(contract_js_1.aggregate3Signature)) return false;
    if (!to) return false;
    if (Object.values(request_).filter((x)=>typeof x !== 'undefined').length > 0) return false;
    return true;
}
async function scheduleMulticall(client, args) {
    var _client_batch;
    const { batchSize = 1024, deployless = false, wait = 0 } = typeof ((_client_batch = client.batch) === null || _client_batch === void 0 ? void 0 : _client_batch.multicall) === 'object' ? client.batch.multicall : {};
    var _client_experimental_blockTag;
    const { blockNumber, blockTag = (_client_experimental_blockTag = client.experimental_blockTag) !== null && _client_experimental_blockTag !== void 0 ? _client_experimental_blockTag : 'latest', data, to } = args;
    const multicallAddress = (()=>{
        if (deployless) return null;
        if (args.multicallAddress) return args.multicallAddress;
        if (client.chain) {
            return (0, getChainContractAddress_js_1.getChainContractAddress)({
                blockNumber,
                chain: client.chain,
                contract: 'multicall3'
            });
        }
        throw new chain_js_1.ClientChainNotConfiguredError();
    })();
    const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    const block = blockNumberHex || blockTag;
    const { schedule } = (0, createBatchScheduler_js_1.createBatchScheduler)({
        id: "".concat(client.uid, ".").concat(block),
        wait,
        shouldSplitBatch (args) {
            const size = args.reduce((size, param)=>{
                let { data } = param;
                return size + (data.length - 2);
            }, 0);
            return size > batchSize * 2;
        },
        fn: async (requests)=>{
            const calls = requests.map((request)=>({
                    allowFailure: true,
                    callData: request.data,
                    target: request.to
                }));
            const calldata = (0, encodeFunctionData_js_1.encodeFunctionData)({
                abi: abis_js_1.multicall3Abi,
                args: [
                    calls
                ],
                functionName: 'aggregate3'
            });
            const data = await client.request({
                method: 'eth_call',
                params: [
                    {
                        ...multicallAddress === null ? {
                            data: toDeploylessCallViaBytecodeData({
                                code: contracts_js_1.multicall3Bytecode,
                                data: calldata
                            })
                        } : {
                            to: multicallAddress,
                            data: calldata
                        }
                    },
                    block
                ]
            });
            return (0, decodeFunctionResult_js_1.decodeFunctionResult)({
                abi: abis_js_1.multicall3Abi,
                args: [
                    calls
                ],
                functionName: 'aggregate3',
                data: data || '0x'
            });
        }
    });
    const [{ returnData, success }] = await schedule({
        data,
        to
    });
    if (!success) throw new contract_js_2.RawContractError({
        data: returnData
    });
    if (returnData === '0x') return {
        data: undefined
    };
    return {
        data: returnData
    };
}
function toDeploylessCallViaBytecodeData(parameters) {
    const { code, data } = parameters;
    return (0, encodeDeployData_js_1.encodeDeployData)({
        abi: (0, abitype_1.parseAbi)([
            'constructor(bytes, bytes)'
        ]),
        bytecode: contracts_js_1.deploylessCallViaBytecodeBytecode,
        args: [
            code,
            data
        ]
    });
}
function toDeploylessCallViaFactoryData(parameters) {
    const { data, factory, factoryData, to } = parameters;
    return (0, encodeDeployData_js_1.encodeDeployData)({
        abi: (0, abitype_1.parseAbi)([
            'constructor(address, bytes, address, bytes)'
        ]),
        bytecode: contracts_js_1.deploylessCallViaFactoryBytecode,
        args: [
            to,
            data,
            factory,
            factoryData
        ]
    });
}
function getRevertErrorData(err) {
    var _error_data;
    if (!(err instanceof base_js_1.BaseError)) return undefined;
    const error = err.walk();
    return typeof (error === null || error === void 0 ? void 0 : error.data) === 'object' ? (_error_data = error.data) === null || _error_data === void 0 ? void 0 : _error_data.data : error.data;
} //# sourceMappingURL=call.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.readContract = readContract;
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const call_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/call.js [app-client] (ecmascript)");
async function readContract(client, parameters) {
    const { abi, address, args, functionName, ...rest } = parameters;
    const calldata = (0, encodeFunctionData_js_1.encodeFunctionData)({
        abi,
        args,
        functionName
    });
    try {
        const { data } = await (0, getAction_js_1.getAction)(client, call_js_1.call, 'call')({
            ...rest,
            data: calldata,
            to: address
        });
        return (0, decodeFunctionResult_js_1.decodeFunctionResult)({
            abi,
            args,
            functionName,
            data: data || '0x'
        });
    } catch (error) {
        throw (0, getContractError_js_1.getContractError)(error, {
            abi,
            address,
            args,
            docsPath: '/docs/contract/readContract',
            functionName
        });
    }
} //# sourceMappingURL=readContract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateContract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.simulateContract = simulateContract;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const call_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/call.js [app-client] (ecmascript)");
async function simulateContract(client, parameters) {
    const { abi, address, args, dataSuffix, functionName, ...callRequest } = parameters;
    const account = callRequest.account ? (0, parseAccount_js_1.parseAccount)(callRequest.account) : client.account;
    const calldata = (0, encodeFunctionData_js_1.encodeFunctionData)({
        abi,
        args,
        functionName
    });
    try {
        const { data } = await (0, getAction_js_1.getAction)(client, call_js_1.call, 'call')({
            batch: false,
            data: "".concat(calldata).concat(dataSuffix ? dataSuffix.replace('0x', '') : ''),
            to: address,
            ...callRequest,
            account
        });
        const result = (0, decodeFunctionResult_js_1.decodeFunctionResult)({
            abi,
            args,
            functionName,
            data: data || '0x'
        });
        const minimizedAbi = abi.filter((abiItem)=>'name' in abiItem && abiItem.name === parameters.functionName);
        return {
            result,
            request: {
                abi: minimizedAbi,
                address,
                args,
                dataSuffix,
                functionName,
                ...callRequest,
                account
            }
        };
    } catch (error) {
        throw (0, getContractError_js_1.getContractError)(error, {
            abi,
            address,
            args,
            docsPath: '/docs/contract/simulateContract',
            functionName,
            sender: account === null || account === void 0 ? void 0 : account.address
        });
    }
} //# sourceMappingURL=simulateContract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.cleanupCache = exports.listenersCache = void 0;
exports.observe = observe;
exports.listenersCache = new Map();
exports.cleanupCache = new Map();
let callbackCount = 0;
function observe(observerId, callbacks, fn) {
    const callbackId = ++callbackCount;
    const getListeners = ()=>exports.listenersCache.get(observerId) || [];
    const unsubscribe = ()=>{
        const listeners = getListeners();
        exports.listenersCache.set(observerId, listeners.filter((cb)=>cb.id !== callbackId));
    };
    const unwatch = ()=>{
        const listeners = getListeners();
        if (!listeners.some((cb)=>cb.id === callbackId)) return;
        const cleanup = exports.cleanupCache.get(observerId);
        if (listeners.length === 1 && cleanup) {
            const p = cleanup();
            if (p instanceof Promise) p.catch(()=>{});
        }
        unsubscribe();
    };
    const listeners = getListeners();
    exports.listenersCache.set(observerId, [
        ...listeners,
        {
            id: callbackId,
            fns: callbacks
        }
    ]);
    if (listeners && listeners.length > 0) return unwatch;
    const emit = {};
    for(const key in callbacks){
        emit[key] = function() {
            for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
                args[_key] = arguments[_key];
            }
            var _listener_fns_key, _listener_fns;
            const listeners = getListeners();
            if (listeners.length === 0) return;
            for (const listener of listeners)(_listener_fns_key = (_listener_fns = listener.fns)[key]) === null || _listener_fns_key === void 0 ? void 0 : _listener_fns_key.call(_listener_fns, ...args);
        };
    }
    const cleanup = fn(emit);
    if (typeof cleanup === 'function') exports.cleanupCache.set(observerId, cleanup);
    return unwatch;
} //# sourceMappingURL=observe.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/wait.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.wait = wait;
async function wait(time) {
    return new Promise((res)=>setTimeout(res, time));
} //# sourceMappingURL=wait.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.poll = poll;
const wait_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/wait.js [app-client] (ecmascript)");
function poll(fn, param) {
    let { emitOnBegin, initialWaitTime, interval } = param;
    let active = true;
    const unwatch = ()=>active = false;
    const watch = async ()=>{
        let data;
        if (emitOnBegin) data = await fn({
            unpoll: unwatch
        });
        var _ref;
        const initialWait = (_ref = await (initialWaitTime === null || initialWaitTime === void 0 ? void 0 : initialWaitTime(data))) !== null && _ref !== void 0 ? _ref : interval;
        await (0, wait_js_1.wait)(initialWait);
        const poll = async ()=>{
            if (!active) return;
            await fn({
                unpoll: unwatch
            });
            await (0, wait_js_1.wait)(interval);
            poll();
        };
        poll();
    };
    watch();
    return unwatch;
} //# sourceMappingURL=poll.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withCache.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.responseCache = exports.promiseCache = void 0;
exports.getCache = getCache;
exports.withCache = withCache;
exports.promiseCache = new Map();
exports.responseCache = new Map();
function getCache(cacheKey) {
    const buildCache = (cacheKey, cache)=>({
            clear: ()=>cache.delete(cacheKey),
            get: ()=>cache.get(cacheKey),
            set: (data)=>cache.set(cacheKey, data)
        });
    const promise = buildCache(cacheKey, exports.promiseCache);
    const response = buildCache(cacheKey, exports.responseCache);
    return {
        clear: ()=>{
            promise.clear();
            response.clear();
        },
        promise,
        response
    };
}
async function withCache(fn, param) {
    let { cacheKey, cacheTime = Number.POSITIVE_INFINITY } = param;
    const cache = getCache(cacheKey);
    const response = cache.response.get();
    if (response && cacheTime > 0) {
        const age = Date.now() - response.created.getTime();
        if (age < cacheTime) return response.data;
    }
    let promise = cache.promise.get();
    if (!promise) {
        promise = fn();
        cache.promise.set(promise);
    }
    try {
        const data = await promise;
        cache.response.set({
            created: new Date(),
            data
        });
        return data;
    } finally{
        cache.promise.clear();
    }
} //# sourceMappingURL=withCache.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockNumber.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getBlockNumberCache = getBlockNumberCache;
exports.getBlockNumber = getBlockNumber;
const withCache_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withCache.js [app-client] (ecmascript)");
const cacheKey = (id)=>"blockNumber.".concat(id);
function getBlockNumberCache(id) {
    return (0, withCache_js_1.getCache)(cacheKey(id));
}
async function getBlockNumber(client) {
    let { cacheTime = client.cacheTime } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const blockNumberHex = await (0, withCache_js_1.withCache)(()=>client.request({
            method: 'eth_blockNumber'
        }), {
        cacheKey: cacheKey(client.uid),
        cacheTime
    });
    return BigInt(blockNumberHex);
} //# sourceMappingURL=getBlockNumber.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterChanges.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFilterChanges = getFilterChanges;
const parseEventLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/parseEventLogs.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
async function getFilterChanges(_client, param) {
    let { filter } = param;
    const strict = 'strict' in filter && filter.strict;
    const logs = await filter.request({
        method: 'eth_getFilterChanges',
        params: [
            filter.id
        ]
    });
    if (typeof logs[0] === 'string') return logs;
    const formattedLogs = logs.map((log)=>(0, log_js_1.formatLog)(log));
    if (!('abi' in filter) || !filter.abi) return formattedLogs;
    return (0, parseEventLogs_js_1.parseEventLogs)({
        abi: filter.abi,
        logs: formattedLogs,
        strict
    });
} //# sourceMappingURL=getFilterChanges.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/uninstallFilter.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.uninstallFilter = uninstallFilter;
async function uninstallFilter(_client, param) {
    let { filter } = param;
    return filter.request({
        method: 'eth_uninstallFilter',
        params: [
            filter.id
        ]
    });
} //# sourceMappingURL=uninstallFilter.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchContractEvent.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.watchContractEvent = watchContractEvent;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
const decodeEventLog_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeEventLog.js [app-client] (ecmascript)");
const encodeEventTopics_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const poll_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const createContractEventFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createContractEventFilter.js [app-client] (ecmascript)");
const getBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockNumber.js [app-client] (ecmascript)");
const getContractEvents_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getContractEvents.js [app-client] (ecmascript)");
const getFilterChanges_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterChanges.js [app-client] (ecmascript)");
const uninstallFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/uninstallFilter.js [app-client] (ecmascript)");
function watchContractEvent(client, parameters) {
    const { abi, address, args, batch = true, eventName, fromBlock, onError, onLogs, poll: poll_, pollingInterval = client.pollingInterval, strict: strict_ } = parameters;
    const enablePolling = (()=>{
        if (typeof poll_ !== 'undefined') return poll_;
        if (typeof fromBlock === 'bigint') return true;
        if (client.transport.type === 'webSocket' || client.transport.type === 'ipc') return false;
        if (client.transport.type === 'fallback' && (client.transport.transports[0].config.type === 'webSocket' || client.transport.transports[0].config.type === 'ipc')) return false;
        return true;
    })();
    const pollContractEvent = ()=>{
        const strict = strict_ !== null && strict_ !== void 0 ? strict_ : false;
        const observerId = (0, stringify_js_1.stringify)([
            'watchContractEvent',
            address,
            args,
            batch,
            client.uid,
            eventName,
            pollingInterval,
            strict,
            fromBlock
        ]);
        return (0, observe_js_1.observe)(observerId, {
            onLogs,
            onError
        }, (emit)=>{
            let previousBlockNumber;
            if (fromBlock !== undefined) previousBlockNumber = fromBlock - 1n;
            let filter;
            let initialized = false;
            const unwatch = (0, poll_js_1.poll)(async ()=>{
                if (!initialized) {
                    try {
                        filter = await (0, getAction_js_1.getAction)(client, createContractEventFilter_js_1.createContractEventFilter, 'createContractEventFilter')({
                            abi,
                            address,
                            args: args,
                            eventName: eventName,
                            strict: strict,
                            fromBlock
                        });
                    } catch (e) {}
                    initialized = true;
                    return;
                }
                try {
                    let logs;
                    if (filter) {
                        logs = await (0, getAction_js_1.getAction)(client, getFilterChanges_js_1.getFilterChanges, 'getFilterChanges')({
                            filter
                        });
                    } else {
                        const blockNumber = await (0, getAction_js_1.getAction)(client, getBlockNumber_js_1.getBlockNumber, 'getBlockNumber')({});
                        if (previousBlockNumber && previousBlockNumber < blockNumber) {
                            logs = await (0, getAction_js_1.getAction)(client, getContractEvents_js_1.getContractEvents, 'getContractEvents')({
                                abi,
                                address,
                                args,
                                eventName,
                                fromBlock: previousBlockNumber + 1n,
                                toBlock: blockNumber,
                                strict
                            });
                        } else {
                            logs = [];
                        }
                        previousBlockNumber = blockNumber;
                    }
                    if (logs.length === 0) return;
                    if (batch) emit.onLogs(logs);
                    else for (const log of logs)emit.onLogs([
                        log
                    ]);
                } catch (err) {
                    var _emit_onError;
                    if (filter && err instanceof rpc_js_1.InvalidInputRpcError) initialized = false;
                    (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, err);
                }
            }, {
                emitOnBegin: true,
                interval: pollingInterval
            });
            return async ()=>{
                if (filter) await (0, getAction_js_1.getAction)(client, uninstallFilter_js_1.uninstallFilter, 'uninstallFilter')({
                    filter
                });
                unwatch();
            };
        });
    };
    const subscribeContractEvent = ()=>{
        const strict = strict_ !== null && strict_ !== void 0 ? strict_ : false;
        const observerId = (0, stringify_js_1.stringify)([
            'watchContractEvent',
            address,
            args,
            batch,
            client.uid,
            eventName,
            pollingInterval,
            strict
        ]);
        let active = true;
        let unsubscribe = ()=>active = false;
        return (0, observe_js_1.observe)(observerId, {
            onLogs,
            onError
        }, (emit)=>{
            ;
            (async ()=>{
                try {
                    const transport = (()=>{
                        if (client.transport.type === 'fallback') {
                            const transport = client.transport.transports.find((transport)=>transport.config.type === 'webSocket' || transport.config.type === 'ipc');
                            if (!transport) return client.transport;
                            return transport.value;
                        }
                        return client.transport;
                    })();
                    const topics = eventName ? (0, encodeEventTopics_js_1.encodeEventTopics)({
                        abi: abi,
                        eventName: eventName,
                        args
                    }) : [];
                    const { unsubscribe: unsubscribe_ } = await transport.subscribe({
                        params: [
                            'logs',
                            {
                                address,
                                topics
                            }
                        ],
                        onData (data) {
                            if (!active) return;
                            const log = data.result;
                            try {
                                const { eventName, args } = (0, decodeEventLog_js_1.decodeEventLog)({
                                    abi: abi,
                                    data: log.data,
                                    topics: log.topics,
                                    strict: strict_
                                });
                                const formatted = (0, log_js_1.formatLog)(log, {
                                    args,
                                    eventName: eventName
                                });
                                emit.onLogs([
                                    formatted
                                ]);
                            } catch (err) {
                                let eventName;
                                let isUnnamed;
                                if (err instanceof abi_js_1.DecodeLogDataMismatch || err instanceof abi_js_1.DecodeLogTopicsMismatch) {
                                    var _err_abiItem_inputs;
                                    if (strict_) return;
                                    eventName = err.abiItem.name;
                                    isUnnamed = (_err_abiItem_inputs = err.abiItem.inputs) === null || _err_abiItem_inputs === void 0 ? void 0 : _err_abiItem_inputs.some((x)=>!('name' in x && x.name));
                                }
                                const formatted = (0, log_js_1.formatLog)(log, {
                                    args: isUnnamed ? [] : {},
                                    eventName
                                });
                                emit.onLogs([
                                    formatted
                                ]);
                            }
                        },
                        onError (error) {
                            var _emit_onError;
                            (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, error);
                        }
                    });
                    unsubscribe = unsubscribe_;
                    if (!active) unsubscribe();
                } catch (err) {
                    onError === null || onError === void 0 ? void 0 : onError(err);
                }
            })();
            return ()=>unsubscribe();
        });
    };
    return enablePolling ? pollContractEvent() : subscribeContractEvent();
} //# sourceMappingURL=watchContractEvent.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AccountTypeNotSupportedError = exports.AccountNotFoundError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class AccountNotFoundError extends base_js_1.BaseError {
    constructor({ docsPath } = {}){
        super([
            'Could not find an Account to execute with this Action.',
            'Please provide an Account with the `account` argument on the Action, or by supplying an `account` to the Client.'
        ].join('\n'), {
            docsPath,
            docsSlug: 'account',
            name: 'AccountNotFoundError'
        });
    }
}
exports.AccountNotFoundError = AccountNotFoundError;
class AccountTypeNotSupportedError extends base_js_1.BaseError {
    constructor({ docsPath, metaMessages, type }){
        super('Account type "'.concat(type, '" is not supported.'), {
            docsPath,
            metaMessages,
            name: 'AccountTypeNotSupportedError'
        });
    }
}
exports.AccountTypeNotSupportedError = AccountTypeNotSupportedError; //# sourceMappingURL=account.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/assertCurrentChain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.assertCurrentChain = assertCurrentChain;
const chain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/chain.js [app-client] (ecmascript)");
function assertCurrentChain(param) {
    let { chain, currentChainId } = param;
    if (!chain) throw new chain_js_1.ChainNotFoundError();
    if (currentChainId !== chain.id) throw new chain_js_1.ChainMismatchError({
        chain,
        currentChainId
    });
} //# sourceMappingURL=assertCurrentChain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getTransactionError.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTransactionError = getTransactionError;
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const getNodeError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getNodeError.js [app-client] (ecmascript)");
function getTransactionError(err, param) {
    let { docsPath, ...args } = param;
    const cause = (()=>{
        const cause = (0, getNodeError_js_1.getNodeError)(err, args);
        if (cause instanceof node_js_1.UnknownNodeError) return err;
        return cause;
    })();
    return new transaction_js_1.TransactionExecutionError(cause, {
        docsPath,
        ...args
    });
} //# sourceMappingURL=getTransactionError.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sendRawTransaction = sendRawTransaction;
async function sendRawTransaction(client, param) {
    let { serializedTransaction } = param;
    return client.request({
        method: 'eth_sendRawTransaction',
        params: [
            serializedTransaction
        ]
    }, {
        retryCount: 0
    });
} //# sourceMappingURL=sendRawTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sendTransaction = sendTransaction;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const recoverAuthorizationAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/recoverAuthorizationAddress.js [app-client] (ecmascript)");
const assertCurrentChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/assertCurrentChain.js [app-client] (ecmascript)");
const getTransactionError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getTransactionError.js [app-client] (ecmascript)");
const extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const lru_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
const prepareTransactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareTransactionRequest.js [app-client] (ecmascript)");
const sendRawTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransaction.js [app-client] (ecmascript)");
const supportsWalletNamespace = new lru_js_1.LruMap(128);
async function sendTransaction(client, parameters) {
    const { account: account_ = client.account, chain = client.chain, accessList, authorizationList, blobs, data, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce, type, value, ...rest } = parameters;
    if (typeof account_ === 'undefined') throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/actions/wallet/sendTransaction'
    });
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : null;
    try {
        (0, assertRequest_js_1.assertRequest)(parameters);
        const to = await (async ()=>{
            if (parameters.to) return parameters.to;
            if (parameters.to === null) return undefined;
            if (authorizationList && authorizationList.length > 0) return await (0, recoverAuthorizationAddress_js_1.recoverAuthorizationAddress)({
                authorization: authorizationList[0]
            }).catch(()=>{
                throw new base_js_1.BaseError('`to` is required. Could not infer from `authorizationList`.');
            });
            return undefined;
        })();
        if ((account === null || account === void 0 ? void 0 : account.type) === 'json-rpc' || account === null) {
            var _client_chain_formatters_transactionRequest, _client_chain_formatters, _client_chain;
            let chainId;
            if (chain !== null) {
                chainId = await (0, getAction_js_1.getAction)(client, getChainId_js_1.getChainId, 'getChainId')({});
                (0, assertCurrentChain_js_1.assertCurrentChain)({
                    currentChainId: chainId,
                    chain
                });
            }
            const chainFormat = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionRequest = _client_chain_formatters.transactionRequest) === null || _client_chain_formatters_transactionRequest === void 0 ? void 0 : _client_chain_formatters_transactionRequest.format;
            const format = chainFormat || transactionRequest_js_1.formatTransactionRequest;
            const request = format({
                ...(0, extract_js_1.extract)(rest, {
                    format: chainFormat
                }),
                accessList,
                account,
                authorizationList,
                blobs,
                chainId,
                data,
                gas,
                gasPrice,
                maxFeePerBlobGas,
                maxFeePerGas,
                maxPriorityFeePerGas,
                nonce,
                to,
                type,
                value
            }, 'sendTransaction');
            const isWalletNamespaceSupported = supportsWalletNamespace.get(client.uid);
            const method = isWalletNamespaceSupported ? 'wallet_sendTransaction' : 'eth_sendTransaction';
            try {
                return await client.request({
                    method,
                    params: [
                        request
                    ]
                }, {
                    retryCount: 0
                });
            } catch (e) {
                if (isWalletNamespaceSupported === false) throw e;
                const error = e;
                if (error.name === 'InvalidInputRpcError' || error.name === 'InvalidParamsRpcError' || error.name === 'MethodNotFoundRpcError' || error.name === 'MethodNotSupportedRpcError') {
                    return await client.request({
                        method: 'wallet_sendTransaction',
                        params: [
                            request
                        ]
                    }, {
                        retryCount: 0
                    }).then((hash)=>{
                        supportsWalletNamespace.set(client.uid, true);
                        return hash;
                    }).catch((e)=>{
                        const walletNamespaceError = e;
                        if (walletNamespaceError.name === 'MethodNotFoundRpcError' || walletNamespaceError.name === 'MethodNotSupportedRpcError') {
                            supportsWalletNamespace.set(client.uid, false);
                            throw error;
                        }
                        throw walletNamespaceError;
                    });
                }
                throw error;
            }
        }
        if ((account === null || account === void 0 ? void 0 : account.type) === 'local') {
            var _chain_serializers;
            const request = await (0, getAction_js_1.getAction)(client, prepareTransactionRequest_js_1.prepareTransactionRequest, 'prepareTransactionRequest')({
                account,
                accessList,
                authorizationList,
                blobs,
                chain,
                data,
                gas,
                gasPrice,
                maxFeePerBlobGas,
                maxFeePerGas,
                maxPriorityFeePerGas,
                nonce,
                nonceManager: account.nonceManager,
                parameters: [
                    ...prepareTransactionRequest_js_1.defaultParameters,
                    'sidecars'
                ],
                type,
                value,
                ...rest,
                to
            });
            const serializer = chain === null || chain === void 0 ? void 0 : (_chain_serializers = chain.serializers) === null || _chain_serializers === void 0 ? void 0 : _chain_serializers.transaction;
            const serializedTransaction = await account.signTransaction(request, {
                serializer
            });
            return await (0, getAction_js_1.getAction)(client, sendRawTransaction_js_1.sendRawTransaction, 'sendRawTransaction')({
                serializedTransaction
            });
        }
        if ((account === null || account === void 0 ? void 0 : account.type) === 'smart') throw new account_js_1.AccountTypeNotSupportedError({
            metaMessages: [
                'Consider using the `sendUserOperation` Action instead.'
            ],
            docsPath: '/docs/actions/bundler/sendUserOperation',
            type: 'smart'
        });
        throw new account_js_1.AccountTypeNotSupportedError({
            docsPath: '/docs/actions/wallet/sendTransaction',
            type: account === null || account === void 0 ? void 0 : account.type
        });
    } catch (err) {
        if (err instanceof account_js_1.AccountTypeNotSupportedError) throw err;
        throw (0, getTransactionError_js_1.getTransactionError)(err, {
            ...parameters,
            account,
            chain: parameters.chain || undefined
        });
    }
} //# sourceMappingURL=sendTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/writeContract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.writeContract = writeContract;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const sendTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransaction.js [app-client] (ecmascript)");
async function writeContract(client, parameters) {
    return writeContract.internal(client, sendTransaction_js_1.sendTransaction, 'sendTransaction', parameters);
}
(function(writeContract) {
    async function internal(client, actionFn, name, parameters) {
        const { abi, account: account_ = client.account, address, args, dataSuffix, functionName, ...request } = parameters;
        if (typeof account_ === 'undefined') throw new account_js_1.AccountNotFoundError({
            docsPath: '/docs/contract/writeContract'
        });
        const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : null;
        const data = (0, encodeFunctionData_js_1.encodeFunctionData)({
            abi,
            args,
            functionName
        });
        try {
            return await (0, getAction_js_1.getAction)(client, actionFn, name)({
                data: "".concat(data).concat(dataSuffix ? dataSuffix.replace('0x', '') : ''),
                to: address,
                account,
                ...request
            });
        } catch (error) {
            throw (0, getContractError_js_1.getContractError)(error, {
                abi,
                address,
                args,
                docsPath: '/docs/contract/writeContract',
                functionName,
                sender: account === null || account === void 0 ? void 0 : account.address
            });
        }
    }
    writeContract.internal = internal;
})(writeContract || (exports.writeContract = writeContract = {})); //# sourceMappingURL=writeContract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/getContract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getContract = getContract;
exports.getFunctionParameters = getFunctionParameters;
exports.getEventParameters = getEventParameters;
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const createContractEventFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createContractEventFilter.js [app-client] (ecmascript)");
const estimateContractGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateContractGas.js [app-client] (ecmascript)");
const getContractEvents_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getContractEvents.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
const simulateContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateContract.js [app-client] (ecmascript)");
const watchContractEvent_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchContractEvent.js [app-client] (ecmascript)");
const writeContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/writeContract.js [app-client] (ecmascript)");
function getContract(param) {
    let { abi, address, client: client_ } = param;
    const client = client_;
    const [publicClient, walletClient] = (()=>{
        if (!client) return [
            undefined,
            undefined
        ];
        if ('public' in client && 'wallet' in client) return [
            client.public,
            client.wallet
        ];
        if ('public' in client) return [
            client.public,
            undefined
        ];
        if ('wallet' in client) return [
            undefined,
            client.wallet
        ];
        return [
            client,
            client
        ];
    })();
    const hasPublicClient = publicClient !== undefined && publicClient !== null;
    const hasWalletClient = walletClient !== undefined && walletClient !== null;
    const contract = {};
    let hasReadFunction = false;
    let hasWriteFunction = false;
    let hasEvent = false;
    for (const item of abi){
        if (item.type === 'function') if (item.stateMutability === 'view' || item.stateMutability === 'pure') hasReadFunction = true;
        else hasWriteFunction = true;
        else if (item.type === 'event') hasEvent = true;
        if (hasReadFunction && hasWriteFunction && hasEvent) break;
    }
    if (hasPublicClient) {
        if (hasReadFunction) contract.read = new Proxy({}, {
            get (_, functionName) {
                return function() {
                    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                        parameters[_key] = arguments[_key];
                    }
                    const { args, options } = getFunctionParameters(parameters);
                    return (0, getAction_js_1.getAction)(publicClient, readContract_js_1.readContract, 'readContract')({
                        abi,
                        address,
                        functionName,
                        args,
                        ...options
                    });
                };
            }
        });
        if (hasWriteFunction) contract.simulate = new Proxy({}, {
            get (_, functionName) {
                return function() {
                    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                        parameters[_key] = arguments[_key];
                    }
                    const { args, options } = getFunctionParameters(parameters);
                    return (0, getAction_js_1.getAction)(publicClient, simulateContract_js_1.simulateContract, 'simulateContract')({
                        abi,
                        address,
                        functionName,
                        args,
                        ...options
                    });
                };
            }
        });
        if (hasEvent) {
            contract.createEventFilter = new Proxy({}, {
                get (_, eventName) {
                    return function() {
                        for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                            parameters[_key] = arguments[_key];
                        }
                        const abiEvent = abi.find((x)=>x.type === 'event' && x.name === eventName);
                        const { args, options } = getEventParameters(parameters, abiEvent);
                        return (0, getAction_js_1.getAction)(publicClient, createContractEventFilter_js_1.createContractEventFilter, 'createContractEventFilter')({
                            abi,
                            address,
                            eventName,
                            args,
                            ...options
                        });
                    };
                }
            });
            contract.getEvents = new Proxy({}, {
                get (_, eventName) {
                    return function() {
                        for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                            parameters[_key] = arguments[_key];
                        }
                        const abiEvent = abi.find((x)=>x.type === 'event' && x.name === eventName);
                        const { args, options } = getEventParameters(parameters, abiEvent);
                        return (0, getAction_js_1.getAction)(publicClient, getContractEvents_js_1.getContractEvents, 'getContractEvents')({
                            abi,
                            address,
                            eventName,
                            args,
                            ...options
                        });
                    };
                }
            });
            contract.watchEvent = new Proxy({}, {
                get (_, eventName) {
                    return function() {
                        for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                            parameters[_key] = arguments[_key];
                        }
                        const abiEvent = abi.find((x)=>x.type === 'event' && x.name === eventName);
                        const { args, options } = getEventParameters(parameters, abiEvent);
                        return (0, getAction_js_1.getAction)(publicClient, watchContractEvent_js_1.watchContractEvent, 'watchContractEvent')({
                            abi,
                            address,
                            eventName,
                            args,
                            ...options
                        });
                    };
                }
            });
        }
    }
    if (hasWalletClient) {
        if (hasWriteFunction) contract.write = new Proxy({}, {
            get (_, functionName) {
                return function() {
                    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                        parameters[_key] = arguments[_key];
                    }
                    const { args, options } = getFunctionParameters(parameters);
                    return (0, getAction_js_1.getAction)(walletClient, writeContract_js_1.writeContract, 'writeContract')({
                        abi,
                        address,
                        functionName,
                        args,
                        ...options
                    });
                };
            }
        });
    }
    if (hasPublicClient || hasWalletClient) {
        if (hasWriteFunction) contract.estimateGas = new Proxy({}, {
            get (_, functionName) {
                return function() {
                    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
                        parameters[_key] = arguments[_key];
                    }
                    const { args, options } = getFunctionParameters(parameters);
                    const client = publicClient !== null && publicClient !== void 0 ? publicClient : walletClient;
                    var _options_account;
                    return (0, getAction_js_1.getAction)(client, estimateContractGas_js_1.estimateContractGas, 'estimateContractGas')({
                        abi,
                        address,
                        functionName,
                        args,
                        ...options,
                        account: (_options_account = options.account) !== null && _options_account !== void 0 ? _options_account : walletClient.account
                    });
                };
            }
        });
    }
    contract.address = address;
    contract.abi = abi;
    return contract;
}
function getFunctionParameters(values) {
    const hasArgs = values.length && Array.isArray(values[0]);
    const args = hasArgs ? values[0] : [];
    var _ref;
    const options = (_ref = hasArgs ? values[1] : values[0]) !== null && _ref !== void 0 ? _ref : {};
    return {
        args,
        options
    };
}
function getEventParameters(values, abiEvent) {
    let hasArgs = false;
    if (Array.isArray(values[0])) hasArgs = true;
    else if (values.length === 1) {
        hasArgs = abiEvent.inputs.some((x)=>x.indexed);
    } else if (values.length === 2) {
        hasArgs = true;
    }
    const args = hasArgs ? values[0] : undefined;
    var _ref;
    const options = (_ref = hasArgs ? values[1] : values[0]) !== null && _ref !== void 0 ? _ref : {};
    return {
        args,
        options
    };
} //# sourceMappingURL=getContract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/calls.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BundleFailedError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class BundleFailedError extends base_js_1.BaseError {
    constructor(result){
        super("Call bundle failed with status: ".concat(result.statusCode), {
            name: 'BundleFailedError'
        });
        Object.defineProperty(this, "result", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.result = result;
    }
}
exports.BundleFailedError = BundleFailedError; //# sourceMappingURL=calls.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withRetry.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.withRetry = withRetry;
const wait_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/wait.js [app-client] (ecmascript)");
function withRetry(fn) {
    let { delay: delay_ = 100, retryCount = 2, shouldRetry = ()=>true } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return new Promise((resolve, reject)=>{
        const attemptRetry = async function() {
            let { count = 0 } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
            const retry = async (param)=>{
                let { error } = param;
                const delay = typeof delay_ === 'function' ? delay_({
                    count,
                    error
                }) : delay_;
                if (delay) await (0, wait_js_1.wait)(delay);
                attemptRetry({
                    count: count + 1
                });
            };
            try {
                const data = await fn();
                resolve(data);
            } catch (err) {
                if (count < retryCount && await shouldRetry({
                    count,
                    error: err
                })) return retry({
                    error: err
                });
                reject(err);
            }
        };
        attemptRetry();
    });
} //# sourceMappingURL=withRetry.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionReceipt.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineTransactionReceipt = exports.receiptStatuses = void 0;
exports.formatTransactionReceipt = formatTransactionReceipt;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const formatter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/formatter.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transaction.js [app-client] (ecmascript)");
exports.receiptStatuses = {
    '0x0': 'reverted',
    '0x1': 'success'
};
function formatTransactionReceipt(transactionReceipt, _) {
    const receipt = {
        ...transactionReceipt,
        blockNumber: transactionReceipt.blockNumber ? BigInt(transactionReceipt.blockNumber) : null,
        contractAddress: transactionReceipt.contractAddress ? transactionReceipt.contractAddress : null,
        cumulativeGasUsed: transactionReceipt.cumulativeGasUsed ? BigInt(transactionReceipt.cumulativeGasUsed) : null,
        effectiveGasPrice: transactionReceipt.effectiveGasPrice ? BigInt(transactionReceipt.effectiveGasPrice) : null,
        gasUsed: transactionReceipt.gasUsed ? BigInt(transactionReceipt.gasUsed) : null,
        logs: transactionReceipt.logs ? transactionReceipt.logs.map((log)=>(0, log_js_1.formatLog)(log)) : null,
        to: transactionReceipt.to ? transactionReceipt.to : null,
        transactionIndex: transactionReceipt.transactionIndex ? (0, fromHex_js_1.hexToNumber)(transactionReceipt.transactionIndex) : null,
        status: transactionReceipt.status ? exports.receiptStatuses[transactionReceipt.status] : null,
        type: transactionReceipt.type ? transaction_js_1.transactionType[transactionReceipt.type] || transactionReceipt.type : null
    };
    if (transactionReceipt.blobGasPrice) receipt.blobGasPrice = BigInt(transactionReceipt.blobGasPrice);
    if (transactionReceipt.blobGasUsed) receipt.blobGasUsed = BigInt(transactionReceipt.blobGasUsed);
    return receipt;
}
exports.defineTransactionReceipt = (0, formatter_js_1.defineFormatter)('transactionReceipt', formatTransactionReceipt); //# sourceMappingURL=transactionReceipt.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendCalls.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fallbackTransactionErrorMagicIdentifier = exports.fallbackMagicIdentifier = void 0;
exports.sendCalls = sendCalls;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const getTransactionError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getTransactionError.js [app-client] (ecmascript)");
const sendTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransaction.js [app-client] (ecmascript)");
exports.fallbackMagicIdentifier = '0x5792579257925792579257925792579257925792579257925792579257925792';
exports.fallbackTransactionErrorMagicIdentifier = (0, toHex_js_1.numberToHex)(0, {
    size: 32
});
async function sendCalls(client, parameters) {
    const { account: account_ = client.account, capabilities, chain = client.chain, experimental_fallback, experimental_fallbackDelay = 32, forceAtomic = false, id, version = '2.0.0' } = parameters;
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : null;
    const calls = parameters.calls.map((call_)=>{
        const call = call_;
        const data = call.abi ? (0, encodeFunctionData_js_1.encodeFunctionData)({
            abi: call.abi,
            functionName: call.functionName,
            args: call.args
        }) : call.data;
        return {
            data: call.dataSuffix && data ? (0, concat_js_1.concat)([
                data,
                call.dataSuffix
            ]) : data,
            to: call.to,
            value: call.value ? (0, toHex_js_1.numberToHex)(call.value) : undefined
        };
    });
    try {
        const response = await client.request({
            method: 'wallet_sendCalls',
            params: [
                {
                    atomicRequired: forceAtomic,
                    calls,
                    capabilities,
                    chainId: (0, toHex_js_1.numberToHex)(chain.id),
                    from: account === null || account === void 0 ? void 0 : account.address,
                    id,
                    version
                }
            ]
        }, {
            retryCount: 0
        });
        if (typeof response === 'string') return {
            id: response
        };
        return response;
    } catch (err) {
        const error = err;
        if (experimental_fallback && (error.name === 'MethodNotFoundRpcError' || error.name === 'MethodNotSupportedRpcError' || error.name === 'UnknownRpcError' || error.details.toLowerCase().includes('does not exist / is not available') || error.details.toLowerCase().includes('missing or invalid. request()') || error.details.toLowerCase().includes('did not match any variant of untagged enum') || error.details.toLowerCase().includes('account upgraded to unsupported contract') || error.details.toLowerCase().includes('eip-7702 not supported') || error.details.toLowerCase().includes('unsupported wc_ method') || error.details.toLowerCase().includes('feature toggled misconfigured') || error.details.toLowerCase().includes('jsonrpcengine: response has no error or result for request'))) {
            if (capabilities) {
                const hasNonOptionalCapability = Object.values(capabilities).some((capability)=>!capability.optional);
                if (hasNonOptionalCapability) {
                    const message = 'non-optional `capabilities` are not supported on fallback to `eth_sendTransaction`.';
                    throw new rpc_js_1.UnsupportedNonOptionalCapabilityError(new base_js_1.BaseError(message, {
                        details: message
                    }));
                }
            }
            if (forceAtomic && calls.length > 1) {
                const message = '`forceAtomic` is not supported on fallback to `eth_sendTransaction`.';
                throw new rpc_js_1.AtomicityNotSupportedError(new base_js_1.BaseError(message, {
                    details: message
                }));
            }
            const promises = [];
            for (const call of calls){
                const promise = (0, sendTransaction_js_1.sendTransaction)(client, {
                    account,
                    chain,
                    data: call.data,
                    to: call.to,
                    value: call.value ? (0, fromHex_js_1.hexToBigInt)(call.value) : undefined
                });
                promises.push(promise);
                if (experimental_fallbackDelay > 0) await new Promise((resolve)=>setTimeout(resolve, experimental_fallbackDelay));
            }
            const results = await Promise.allSettled(promises);
            if (results.every((r)=>r.status === 'rejected')) throw results[0].reason;
            const hashes = results.map((result)=>{
                if (result.status === 'fulfilled') return result.value;
                return exports.fallbackTransactionErrorMagicIdentifier;
            });
            return {
                id: (0, concat_js_1.concat)([
                    ...hashes,
                    (0, toHex_js_1.numberToHex)(chain.id, {
                        size: 32
                    }),
                    exports.fallbackMagicIdentifier
                ])
            };
        }
        throw (0, getTransactionError_js_1.getTransactionError)(err, {
            ...parameters,
            account,
            chain: parameters.chain
        });
    }
} //# sourceMappingURL=sendCalls.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getCallsStatus.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getCallsStatus = getCallsStatus;
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const transactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionReceipt.js [app-client] (ecmascript)");
const sendCalls_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendCalls.js [app-client] (ecmascript)");
async function getCallsStatus(client, parameters) {
    async function getStatus(id) {
        const isTransactions = id.endsWith(sendCalls_js_1.fallbackMagicIdentifier.slice(2));
        if (isTransactions) {
            const chainId = (0, trim_js_1.trim)((0, slice_js_1.sliceHex)(id, -64, -32));
            const hashes = (0, slice_js_1.sliceHex)(id, 0, -64).slice(2).match(/.{1,64}/g);
            const receipts = await Promise.all(hashes.map((hash)=>sendCalls_js_1.fallbackTransactionErrorMagicIdentifier.slice(2) !== hash ? client.request({
                    method: 'eth_getTransactionReceipt',
                    params: [
                        "0x".concat(hash)
                    ]
                }, {
                    dedupe: true
                }) : undefined));
            const status = (()=>{
                if (receipts.some((r)=>r === null)) return 100;
                if (receipts.every((r)=>(r === null || r === void 0 ? void 0 : r.status) === '0x1')) return 200;
                if (receipts.every((r)=>(r === null || r === void 0 ? void 0 : r.status) === '0x0')) return 500;
                return 600;
            })();
            return {
                atomic: false,
                chainId: (0, fromHex_js_1.hexToNumber)(chainId),
                receipts: receipts.filter(Boolean),
                status,
                version: '2.0.0'
            };
        }
        return client.request({
            method: 'wallet_getCallsStatus',
            params: [
                id
            ]
        });
    }
    const { atomic = false, chainId, receipts, version = '2.0.0', ...response } = await getStatus(parameters.id);
    const [status, statusCode] = (()=>{
        const statusCode = response.status;
        if (statusCode >= 100 && statusCode < 200) return [
            'pending',
            statusCode
        ];
        if (statusCode >= 200 && statusCode < 300) return [
            'success',
            statusCode
        ];
        if (statusCode >= 300 && statusCode < 700) return [
            'failure',
            statusCode
        ];
        if (statusCode === 'CONFIRMED') return [
            'success',
            200
        ];
        if (statusCode === 'PENDING') return [
            'pending',
            100
        ];
        return [
            undefined,
            statusCode
        ];
    })();
    var _receipts_map;
    return {
        ...response,
        atomic,
        chainId: chainId ? (0, fromHex_js_1.hexToNumber)(chainId) : undefined,
        receipts: (_receipts_map = receipts === null || receipts === void 0 ? void 0 : receipts.map((receipt)=>({
                ...receipt,
                blockNumber: (0, fromHex_js_1.hexToBigInt)(receipt.blockNumber),
                gasUsed: (0, fromHex_js_1.hexToBigInt)(receipt.gasUsed),
                status: transactionReceipt_js_1.receiptStatuses[receipt.status]
            }))) !== null && _receipts_map !== void 0 ? _receipts_map : [],
        statusCode,
        status,
        version
    };
} //# sourceMappingURL=getCallsStatus.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/waitForCallsStatus.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WaitForCallsStatusTimeoutError = void 0;
exports.waitForCallsStatus = waitForCallsStatus;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const calls_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/calls.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const poll_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)");
const withResolvers_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withResolvers.js [app-client] (ecmascript)");
const withRetry_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withRetry.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const getCallsStatus_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getCallsStatus.js [app-client] (ecmascript)");
async function waitForCallsStatus(client, parameters) {
    const { id, pollingInterval = client.pollingInterval, status = (param)=>{
        let { statusCode } = param;
        return statusCode === 200 || statusCode >= 300;
    }, retryCount = 4, retryDelay = (param)=>{
        let { count } = param;
        return ~~(1 << count) * 200;
    }, timeout = 60_000, throwOnFailure = false } = parameters;
    const observerId = (0, stringify_js_1.stringify)([
        'waitForCallsStatus',
        client.uid,
        id
    ]);
    const { promise, resolve, reject } = (0, withResolvers_js_1.withResolvers)();
    let timer;
    const unobserve = (0, observe_js_1.observe)(observerId, {
        resolve,
        reject
    }, (emit)=>{
        const unpoll = (0, poll_js_1.poll)(async ()=>{
            const done = (fn)=>{
                clearTimeout(timer);
                unpoll();
                fn();
                unobserve();
            };
            try {
                const result = await (0, withRetry_js_1.withRetry)(async ()=>{
                    const result = await (0, getAction_js_1.getAction)(client, getCallsStatus_js_1.getCallsStatus, 'getCallsStatus')({
                        id
                    });
                    if (throwOnFailure && result.status === 'failure') throw new calls_js_1.BundleFailedError(result);
                    return result;
                }, {
                    retryCount,
                    delay: retryDelay
                });
                if (!status(result)) return;
                done(()=>emit.resolve(result));
            } catch (error) {
                done(()=>emit.reject(error));
            }
        }, {
            interval: pollingInterval,
            emitOnBegin: true
        });
        return unpoll;
    });
    timer = timeout ? setTimeout(()=>{
        unobserve();
        clearTimeout(timer);
        reject(new WaitForCallsStatusTimeoutError({
            id
        }));
    }, timeout) : undefined;
    return await promise;
}
class WaitForCallsStatusTimeoutError extends base_js_1.BaseError {
    constructor({ id }){
        super('Timed out while waiting for call bundle with id "'.concat(id, '" to be confirmed.'), {
            name: 'WaitForCallsStatusTimeoutError'
        });
    }
}
exports.WaitForCallsStatusTimeoutError = WaitForCallsStatusTimeoutError; //# sourceMappingURL=waitForCallsStatus.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/uid.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.uid = uid;
const size = 256;
let index = size;
let buffer;
function uid() {
    let length = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 11;
    if (!buffer || index + length > size * 2) {
        buffer = '';
        index = 0;
        for(let i = 0; i < size; i++){
            buffer += (256 + Math.random() * 256 | 0).toString(16).substring(1);
        }
    }
    return buffer.substring(index, index++ + length);
} //# sourceMappingURL=uid.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createClient.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createClient = createClient;
exports.rpcSchema = rpcSchema;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const uid_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/uid.js [app-client] (ecmascript)");
function createClient(parameters) {
    const { batch, chain, ccipRead, key = 'base', name = 'Base Client', type = 'base' } = parameters;
    var _parameters_experimental_blockTag;
    const experimental_blockTag = (_parameters_experimental_blockTag = parameters.experimental_blockTag) !== null && _parameters_experimental_blockTag !== void 0 ? _parameters_experimental_blockTag : typeof (chain === null || chain === void 0 ? void 0 : chain.experimental_preconfirmationTime) === 'number' ? 'pending' : undefined;
    var _chain_blockTime;
    const blockTime = (_chain_blockTime = chain === null || chain === void 0 ? void 0 : chain.blockTime) !== null && _chain_blockTime !== void 0 ? _chain_blockTime : 12_000;
    const defaultPollingInterval = Math.min(Math.max(Math.floor(blockTime / 2), 500), 4_000);
    var _parameters_pollingInterval;
    const pollingInterval = (_parameters_pollingInterval = parameters.pollingInterval) !== null && _parameters_pollingInterval !== void 0 ? _parameters_pollingInterval : defaultPollingInterval;
    var _parameters_cacheTime;
    const cacheTime = (_parameters_cacheTime = parameters.cacheTime) !== null && _parameters_cacheTime !== void 0 ? _parameters_cacheTime : pollingInterval;
    const account = parameters.account ? (0, parseAccount_js_1.parseAccount)(parameters.account) : undefined;
    const { config, request, value } = parameters.transport({
        chain,
        pollingInterval
    });
    const transport = {
        ...config,
        ...value
    };
    const client = {
        account,
        batch,
        cacheTime,
        ccipRead,
        chain,
        key,
        name,
        pollingInterval,
        request,
        transport,
        type,
        uid: (0, uid_js_1.uid)(),
        ...experimental_blockTag ? {
            experimental_blockTag
        } : {}
    };
    function extend(base) {
        return (extendFn)=>{
            const extended = extendFn(base);
            for(const key in client)delete extended[key];
            const combined = {
                ...base,
                ...extended
            };
            return Object.assign(combined, {
                extend: extend(combined)
            });
        };
    }
    return Object.assign(client, {
        extend: extend(client)
    });
}
function rpcSchema() {
    return null;
} //# sourceMappingURL=createClient.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/errors.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isNullUniversalResolverError = isNullUniversalResolverError;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
function isNullUniversalResolverError(err) {
    var _cause_data, _cause_data1, _cause_data2, _cause_data3, _cause_data4, _cause_data5;
    if (!(err instanceof base_js_1.BaseError)) return false;
    const cause = err.walk((e)=>e instanceof contract_js_1.ContractFunctionRevertedError);
    if (!(cause instanceof contract_js_1.ContractFunctionRevertedError)) return false;
    if (((_cause_data = cause.data) === null || _cause_data === void 0 ? void 0 : _cause_data.errorName) === 'HttpError') return true;
    if (((_cause_data1 = cause.data) === null || _cause_data1 === void 0 ? void 0 : _cause_data1.errorName) === 'ResolverError') return true;
    if (((_cause_data2 = cause.data) === null || _cause_data2 === void 0 ? void 0 : _cause_data2.errorName) === 'ResolverNotContract') return true;
    if (((_cause_data3 = cause.data) === null || _cause_data3 === void 0 ? void 0 : _cause_data3.errorName) === 'ResolverNotFound') return true;
    if (((_cause_data4 = cause.data) === null || _cause_data4 === void 0 ? void 0 : _cause_data4.errorName) === 'ReverseAddressMismatch') return true;
    if (((_cause_data5 = cause.data) === null || _cause_data5 === void 0 ? void 0 : _cause_data5.errorName) === 'UnsupportedResolverProfile') return true;
    return false;
} //# sourceMappingURL=errors.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/encodedLabelToLabelhash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodedLabelToLabelhash = encodedLabelToLabelhash;
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
function encodedLabelToLabelhash(label) {
    if (label.length !== 66) return null;
    if (label.indexOf('[') !== 0) return null;
    if (label.indexOf(']') !== 65) return null;
    const hash = "0x".concat(label.slice(1, 65));
    if (!(0, isHex_js_1.isHex)(hash)) return null;
    return hash;
} //# sourceMappingURL=encodedLabelToLabelhash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/namehash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.namehash = namehash;
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const encodedLabelToLabelhash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/encodedLabelToLabelhash.js [app-client] (ecmascript)");
function namehash(name) {
    let result = new Uint8Array(32).fill(0);
    if (!name) return (0, toHex_js_1.bytesToHex)(result);
    const labels = name.split('.');
    for(let i = labels.length - 1; i >= 0; i -= 1){
        const hashFromEncodedLabel = (0, encodedLabelToLabelhash_js_1.encodedLabelToLabelhash)(labels[i]);
        const hashed = hashFromEncodedLabel ? (0, toBytes_js_1.toBytes)(hashFromEncodedLabel) : (0, keccak256_js_1.keccak256)((0, toBytes_js_1.stringToBytes)(labels[i]), 'bytes');
        result = (0, keccak256_js_1.keccak256)((0, concat_js_1.concat)([
            result,
            hashed
        ]), 'bytes');
    }
    return (0, toHex_js_1.bytesToHex)(result);
} //# sourceMappingURL=namehash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/encodeLabelhash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeLabelhash = encodeLabelhash;
function encodeLabelhash(hash) {
    return "[".concat(hash.slice(2), "]");
} //# sourceMappingURL=encodeLabelhash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/labelhash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.labelhash = labelhash;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const encodedLabelToLabelhash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/encodedLabelToLabelhash.js [app-client] (ecmascript)");
function labelhash(label) {
    const result = new Uint8Array(32).fill(0);
    if (!label) return (0, toHex_js_1.bytesToHex)(result);
    return (0, encodedLabelToLabelhash_js_1.encodedLabelToLabelhash)(label) || (0, keccak256_js_1.keccak256)((0, toBytes_js_1.stringToBytes)(label));
} //# sourceMappingURL=labelhash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/packetToBytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.packetToBytes = packetToBytes;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const encodeLabelhash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/encodeLabelhash.js [app-client] (ecmascript)");
const labelhash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/labelhash.js [app-client] (ecmascript)");
function packetToBytes(packet) {
    const value = packet.replace(/^\.|\.$/gm, '');
    if (value.length === 0) return new Uint8Array(1);
    const bytes = new Uint8Array((0, toBytes_js_1.stringToBytes)(value).byteLength + 2);
    let offset = 0;
    const list = value.split('.');
    for(let i = 0; i < list.length; i++){
        let encoded = (0, toBytes_js_1.stringToBytes)(list[i]);
        if (encoded.byteLength > 255) encoded = (0, toBytes_js_1.stringToBytes)((0, encodeLabelhash_js_1.encodeLabelhash)((0, labelhash_js_1.labelhash)(list[i])));
        bytes[offset] = encoded.length;
        bytes.set(encoded, offset + 1);
        offset += encoded.length + 1;
    }
    if (bytes.byteLength !== offset + 1) return bytes.slice(0, offset + 1);
    return bytes;
} //# sourceMappingURL=packetToBytes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEnsAddress = getEnsAddress;
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/errors.js [app-client] (ecmascript)");
const localBatchGatewayRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/localBatchGatewayRequest.js [app-client] (ecmascript)");
const namehash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/namehash.js [app-client] (ecmascript)");
const packetToBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/packetToBytes.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function getEnsAddress(client, parameters) {
    const { blockNumber, blockTag, coinType, name, gatewayUrls, strict } = parameters;
    const { chain } = client;
    const universalResolverAddress = (()=>{
        if (parameters.universalResolverAddress) return parameters.universalResolverAddress;
        if (!chain) throw new Error('client chain not configured. universalResolverAddress is required.');
        return (0, getChainContractAddress_js_1.getChainContractAddress)({
            blockNumber,
            chain,
            contract: 'ensUniversalResolver'
        });
    })();
    const tlds = chain === null || chain === void 0 ? void 0 : chain.ensTlds;
    if (tlds && !tlds.some((tld)=>name.endsWith(tld))) return null;
    const args = (()=>{
        if (coinType != null) return [
            (0, namehash_js_1.namehash)(name),
            BigInt(coinType)
        ];
        return [
            (0, namehash_js_1.namehash)(name)
        ];
    })();
    try {
        const functionData = (0, encodeFunctionData_js_1.encodeFunctionData)({
            abi: abis_js_1.addressResolverAbi,
            functionName: 'addr',
            args
        });
        const readContractParameters = {
            address: universalResolverAddress,
            abi: abis_js_1.universalResolverResolveAbi,
            functionName: 'resolveWithGateways',
            args: [
                (0, toHex_js_1.toHex)((0, packetToBytes_js_1.packetToBytes)(name)),
                functionData,
                gatewayUrls !== null && gatewayUrls !== void 0 ? gatewayUrls : [
                    localBatchGatewayRequest_js_1.localBatchGatewayUrl
                ]
            ],
            blockNumber,
            blockTag
        };
        const readContractAction = (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract');
        const res = await readContractAction(readContractParameters);
        if (res[0] === '0x') return null;
        const address = (0, decodeFunctionResult_js_1.decodeFunctionResult)({
            abi: abis_js_1.addressResolverAbi,
            args,
            functionName: 'addr',
            data: res[0]
        });
        if (address === '0x') return null;
        if ((0, trim_js_1.trim)(address) === '0x00') return null;
        return address;
    } catch (err) {
        if (strict) throw err;
        if ((0, errors_js_1.isNullUniversalResolverError)(err)) return null;
        throw err;
    }
} //# sourceMappingURL=getEnsAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/ens.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.EnsInvalidChainIdError = exports.EnsAvatarUnsupportedNamespaceError = exports.EnsAvatarUriResolutionError = exports.EnsAvatarInvalidNftUriError = exports.EnsAvatarInvalidMetadataError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class EnsAvatarInvalidMetadataError extends base_js_1.BaseError {
    constructor({ data }){
        super('Unable to extract image from metadata. The metadata may be malformed or invalid.', {
            metaMessages: [
                '- Metadata must be a JSON object with at least an `image`, `image_url` or `image_data` property.',
                '',
                "Provided data: ".concat(JSON.stringify(data))
            ],
            name: 'EnsAvatarInvalidMetadataError'
        });
    }
}
exports.EnsAvatarInvalidMetadataError = EnsAvatarInvalidMetadataError;
class EnsAvatarInvalidNftUriError extends base_js_1.BaseError {
    constructor({ reason }){
        super("ENS NFT avatar URI is invalid. ".concat(reason), {
            name: 'EnsAvatarInvalidNftUriError'
        });
    }
}
exports.EnsAvatarInvalidNftUriError = EnsAvatarInvalidNftUriError;
class EnsAvatarUriResolutionError extends base_js_1.BaseError {
    constructor({ uri }){
        super('Unable to resolve ENS avatar URI "'.concat(uri, '". The URI may be malformed, invalid, or does not respond with a valid image.'), {
            name: 'EnsAvatarUriResolutionError'
        });
    }
}
exports.EnsAvatarUriResolutionError = EnsAvatarUriResolutionError;
class EnsAvatarUnsupportedNamespaceError extends base_js_1.BaseError {
    constructor({ namespace }){
        super('ENS NFT avatar namespace "'.concat(namespace, '" is not supported. Must be "erc721" or "erc1155".'), {
            name: 'EnsAvatarUnsupportedNamespaceError'
        });
    }
}
exports.EnsAvatarUnsupportedNamespaceError = EnsAvatarUnsupportedNamespaceError;
class EnsInvalidChainIdError extends base_js_1.BaseError {
    constructor({ chainId }){
        super("Invalid ENSIP-11 chainId: ".concat(chainId, ". Must be between 0 and 0x7fffffff, or 1."), {
            name: 'EnsInvalidChainIdError'
        });
    }
}
exports.EnsInvalidChainIdError = EnsInvalidChainIdError; //# sourceMappingURL=ens.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/avatar/utils.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isImageUri = isImageUri;
exports.getGateway = getGateway;
exports.resolveAvatarUri = resolveAvatarUri;
exports.getJsonImage = getJsonImage;
exports.getMetadataAvatarUri = getMetadataAvatarUri;
exports.parseAvatarUri = parseAvatarUri;
exports.parseNftUri = parseNftUri;
exports.getNftTokenUri = getNftTokenUri;
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
const ens_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/ens.js [app-client] (ecmascript)");
const networkRegex = RegExp("(?<protocol>https?:\\/\\/[^/]*|ipfs:\\/|ipns:\\/|ar:\\/)?(?<root>\\/)?(?<subpath>ipfs\\/|ipns\\/)?(?<target>[\\w\\-.]+)(?<subtarget>\\/.*)?");
const ipfsHashRegex = RegExp("^(Qm[1-9A-HJ-NP-Za-km-z]{44,}|b[A-Za-z2-7]{58,}|B[A-Z2-7]{58,}|z[1-9A-HJ-NP-Za-km-z]{48,}|F[0-9A-F]{50,})(\\/(?<target>[\\w\\-.]+))?(?<subtarget>\\/.*)?$");
const base64Regex = /^data:([a-zA-Z\-/+]*);base64,([^"].*)/;
const dataURIRegex = /^data:([a-zA-Z\-/+]*)?(;[a-zA-Z0-9].*?)?(,)/;
async function isImageUri(uri) {
    try {
        const res = await fetch(uri, {
            method: 'HEAD'
        });
        if (res.status === 200) {
            const contentType = res.headers.get('content-type');
            return contentType === null || contentType === void 0 ? void 0 : contentType.startsWith('image/');
        }
        return false;
    } catch (error) {
        if (typeof error === 'object' && typeof error.response !== 'undefined') {
            return false;
        }
        if (!Object.hasOwn(globalThis, 'Image')) return false;
        return new Promise((resolve)=>{
            const img = new Image();
            img.onload = ()=>{
                resolve(true);
            };
            img.onerror = ()=>{
                resolve(false);
            };
            img.src = uri;
        });
    }
}
function getGateway(custom, defaultGateway) {
    if (!custom) return defaultGateway;
    if (custom.endsWith('/')) return custom.slice(0, -1);
    return custom;
}
function resolveAvatarUri(param) {
    let { uri, gatewayUrls } = param;
    const isEncoded = base64Regex.test(uri);
    if (isEncoded) return {
        uri,
        isOnChain: true,
        isEncoded
    };
    const ipfsGateway = getGateway(gatewayUrls === null || gatewayUrls === void 0 ? void 0 : gatewayUrls.ipfs, 'https://ipfs.io');
    const arweaveGateway = getGateway(gatewayUrls === null || gatewayUrls === void 0 ? void 0 : gatewayUrls.arweave, 'https://arweave.net');
    const networkRegexMatch = uri.match(networkRegex);
    const { protocol, subpath, target, subtarget = '' } = (networkRegexMatch === null || networkRegexMatch === void 0 ? void 0 : networkRegexMatch.groups) || {};
    const isIPNS = protocol === 'ipns:/' || subpath === 'ipns/';
    const isIPFS = protocol === 'ipfs:/' || subpath === 'ipfs/' || ipfsHashRegex.test(uri);
    if (uri.startsWith('http') && !isIPNS && !isIPFS) {
        let replacedUri = uri;
        if (gatewayUrls === null || gatewayUrls === void 0 ? void 0 : gatewayUrls.arweave) replacedUri = uri.replace(/https:\/\/arweave.net/g, gatewayUrls === null || gatewayUrls === void 0 ? void 0 : gatewayUrls.arweave);
        return {
            uri: replacedUri,
            isOnChain: false,
            isEncoded: false
        };
    }
    if ((isIPNS || isIPFS) && target) {
        return {
            uri: "".concat(ipfsGateway, "/").concat(isIPNS ? 'ipns' : 'ipfs', "/").concat(target).concat(subtarget),
            isOnChain: false,
            isEncoded: false
        };
    }
    if (protocol === 'ar:/' && target) {
        return {
            uri: "".concat(arweaveGateway, "/").concat(target).concat(subtarget || ''),
            isOnChain: false,
            isEncoded: false
        };
    }
    let parsedUri = uri.replace(dataURIRegex, '');
    if (parsedUri.startsWith('<svg')) {
        parsedUri = "data:image/svg+xml;base64,".concat(btoa(parsedUri));
    }
    if (parsedUri.startsWith('data:') || parsedUri.startsWith('{')) {
        return {
            uri: parsedUri,
            isOnChain: true,
            isEncoded: false
        };
    }
    throw new ens_js_1.EnsAvatarUriResolutionError({
        uri
    });
}
function getJsonImage(data) {
    if (typeof data !== 'object' || !('image' in data) && !('image_url' in data) && !('image_data' in data)) {
        throw new ens_js_1.EnsAvatarInvalidMetadataError({
            data
        });
    }
    return data.image || data.image_url || data.image_data;
}
async function getMetadataAvatarUri(param) {
    let { gatewayUrls, uri } = param;
    try {
        const res = await fetch(uri).then((res)=>res.json());
        const image = await parseAvatarUri({
            gatewayUrls,
            uri: getJsonImage(res)
        });
        return image;
    } catch (e) {
        throw new ens_js_1.EnsAvatarUriResolutionError({
            uri
        });
    }
}
async function parseAvatarUri(param) {
    let { gatewayUrls, uri } = param;
    const { uri: resolvedURI, isOnChain } = resolveAvatarUri({
        uri,
        gatewayUrls
    });
    if (isOnChain) return resolvedURI;
    const isImage = await isImageUri(resolvedURI);
    if (isImage) return resolvedURI;
    throw new ens_js_1.EnsAvatarUriResolutionError({
        uri
    });
}
function parseNftUri(uri_) {
    let uri = uri_;
    if (uri.startsWith('did:nft:')) {
        uri = uri.replace('did:nft:', '').replace(/_/g, '/');
    }
    const [reference, asset_namespace, tokenID] = uri.split('/');
    const [eip_namespace, chainID] = reference.split(':');
    const [erc_namespace, contractAddress] = asset_namespace.split(':');
    if (!eip_namespace || eip_namespace.toLowerCase() !== 'eip155') throw new ens_js_1.EnsAvatarInvalidNftUriError({
        reason: 'Only EIP-155 supported'
    });
    if (!chainID) throw new ens_js_1.EnsAvatarInvalidNftUriError({
        reason: 'Chain ID not found'
    });
    if (!contractAddress) throw new ens_js_1.EnsAvatarInvalidNftUriError({
        reason: 'Contract address not found'
    });
    if (!tokenID) throw new ens_js_1.EnsAvatarInvalidNftUriError({
        reason: 'Token ID not found'
    });
    if (!erc_namespace) throw new ens_js_1.EnsAvatarInvalidNftUriError({
        reason: 'ERC namespace not found'
    });
    return {
        chainID: Number.parseInt(chainID, 10),
        namespace: erc_namespace.toLowerCase(),
        contractAddress: contractAddress,
        tokenID
    };
}
async function getNftTokenUri(client, param) {
    let { nft } = param;
    if (nft.namespace === 'erc721') {
        return (0, readContract_js_1.readContract)(client, {
            address: nft.contractAddress,
            abi: [
                {
                    name: 'tokenURI',
                    type: 'function',
                    stateMutability: 'view',
                    inputs: [
                        {
                            name: 'tokenId',
                            type: 'uint256'
                        }
                    ],
                    outputs: [
                        {
                            name: '',
                            type: 'string'
                        }
                    ]
                }
            ],
            functionName: 'tokenURI',
            args: [
                BigInt(nft.tokenID)
            ]
        });
    }
    if (nft.namespace === 'erc1155') {
        return (0, readContract_js_1.readContract)(client, {
            address: nft.contractAddress,
            abi: [
                {
                    name: 'uri',
                    type: 'function',
                    stateMutability: 'view',
                    inputs: [
                        {
                            name: '_id',
                            type: 'uint256'
                        }
                    ],
                    outputs: [
                        {
                            name: '',
                            type: 'string'
                        }
                    ]
                }
            ],
            functionName: 'uri',
            args: [
                BigInt(nft.tokenID)
            ]
        });
    }
    throw new ens_js_1.EnsAvatarUnsupportedNamespaceError({
        namespace: nft.namespace
    });
} //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/avatar/parseAvatarRecord.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseAvatarRecord = parseAvatarRecord;
const utils_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/avatar/utils.js [app-client] (ecmascript)");
async function parseAvatarRecord(client, param) {
    let { gatewayUrls, record } = param;
    if (/eip155:/i.test(record)) return parseNftAvatarUri(client, {
        gatewayUrls,
        record
    });
    return (0, utils_js_1.parseAvatarUri)({
        uri: record,
        gatewayUrls
    });
}
async function parseNftAvatarUri(client, param) {
    let { gatewayUrls, record } = param;
    const nft = (0, utils_js_1.parseNftUri)(record);
    const nftUri = await (0, utils_js_1.getNftTokenUri)(client, {
        nft
    });
    const { uri: resolvedNftUri, isOnChain, isEncoded } = (0, utils_js_1.resolveAvatarUri)({
        uri: nftUri,
        gatewayUrls
    });
    if (isOnChain && (resolvedNftUri.includes('data:application/json;base64,') || resolvedNftUri.startsWith('{'))) {
        const encodedJson = isEncoded ? atob(resolvedNftUri.replace('data:application/json;base64,', '')) : resolvedNftUri;
        const decoded = JSON.parse(encodedJson);
        return (0, utils_js_1.parseAvatarUri)({
            uri: (0, utils_js_1.getJsonImage)(decoded),
            gatewayUrls
        });
    }
    let uriTokenId = nft.tokenID;
    if (nft.namespace === 'erc1155') uriTokenId = uriTokenId.replace('0x', '').padStart(64, '0');
    return (0, utils_js_1.getMetadataAvatarUri)({
        gatewayUrls,
        uri: resolvedNftUri.replace(/(?:0x)?{id}/, uriTokenId)
    });
} //# sourceMappingURL=parseAvatarRecord.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsText.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEnsText = getEnsText;
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/errors.js [app-client] (ecmascript)");
const localBatchGatewayRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/localBatchGatewayRequest.js [app-client] (ecmascript)");
const namehash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/namehash.js [app-client] (ecmascript)");
const packetToBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/packetToBytes.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function getEnsText(client, parameters) {
    const { blockNumber, blockTag, key, name, gatewayUrls, strict } = parameters;
    const { chain } = client;
    const universalResolverAddress = (()=>{
        if (parameters.universalResolverAddress) return parameters.universalResolverAddress;
        if (!chain) throw new Error('client chain not configured. universalResolverAddress is required.');
        return (0, getChainContractAddress_js_1.getChainContractAddress)({
            blockNumber,
            chain,
            contract: 'ensUniversalResolver'
        });
    })();
    const tlds = chain === null || chain === void 0 ? void 0 : chain.ensTlds;
    if (tlds && !tlds.some((tld)=>name.endsWith(tld))) return null;
    try {
        const readContractParameters = {
            address: universalResolverAddress,
            abi: abis_js_1.universalResolverResolveAbi,
            args: [
                (0, toHex_js_1.toHex)((0, packetToBytes_js_1.packetToBytes)(name)),
                (0, encodeFunctionData_js_1.encodeFunctionData)({
                    abi: abis_js_1.textResolverAbi,
                    functionName: 'text',
                    args: [
                        (0, namehash_js_1.namehash)(name),
                        key
                    ]
                }),
                gatewayUrls !== null && gatewayUrls !== void 0 ? gatewayUrls : [
                    localBatchGatewayRequest_js_1.localBatchGatewayUrl
                ]
            ],
            functionName: 'resolveWithGateways',
            blockNumber,
            blockTag
        };
        const readContractAction = (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract');
        const res = await readContractAction(readContractParameters);
        if (res[0] === '0x') return null;
        const record = (0, decodeFunctionResult_js_1.decodeFunctionResult)({
            abi: abis_js_1.textResolverAbi,
            functionName: 'text',
            data: res[0]
        });
        return record === '' ? null : record;
    } catch (err) {
        if (strict) throw err;
        if ((0, errors_js_1.isNullUniversalResolverError)(err)) return null;
        throw err;
    }
} //# sourceMappingURL=getEnsText.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsAvatar.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEnsAvatar = getEnsAvatar;
const parseAvatarRecord_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/avatar/parseAvatarRecord.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const getEnsText_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsText.js [app-client] (ecmascript)");
async function getEnsAvatar(client, param) {
    let { blockNumber, blockTag, assetGatewayUrls, name, gatewayUrls, strict, universalResolverAddress } = param;
    const record = await (0, getAction_js_1.getAction)(client, getEnsText_js_1.getEnsText, 'getEnsText')({
        blockNumber,
        blockTag,
        key: 'avatar',
        name,
        universalResolverAddress,
        gatewayUrls,
        strict
    });
    if (!record) return null;
    try {
        return await (0, parseAvatarRecord_js_1.parseAvatarRecord)(client, {
            record,
            gatewayUrls: assetGatewayUrls
        });
    } catch (e) {
        return null;
    }
} //# sourceMappingURL=getEnsAvatar.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsName.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEnsName = getEnsName;
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/errors.js [app-client] (ecmascript)");
const localBatchGatewayRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/localBatchGatewayRequest.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function getEnsName(client, parameters) {
    const { address, blockNumber, blockTag, coinType = 60n, gatewayUrls, strict } = parameters;
    const { chain } = client;
    const universalResolverAddress = (()=>{
        if (parameters.universalResolverAddress) return parameters.universalResolverAddress;
        if (!chain) throw new Error('client chain not configured. universalResolverAddress is required.');
        return (0, getChainContractAddress_js_1.getChainContractAddress)({
            blockNumber,
            chain,
            contract: 'ensUniversalResolver'
        });
    })();
    try {
        const readContractParameters = {
            address: universalResolverAddress,
            abi: abis_js_1.universalResolverReverseAbi,
            args: [
                address,
                coinType,
                gatewayUrls !== null && gatewayUrls !== void 0 ? gatewayUrls : [
                    localBatchGatewayRequest_js_1.localBatchGatewayUrl
                ]
            ],
            functionName: 'reverseWithGateways',
            blockNumber,
            blockTag
        };
        const readContractAction = (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract');
        const [name] = await readContractAction(readContractParameters);
        return name || null;
    } catch (err) {
        if (strict) throw err;
        if ((0, errors_js_1.isNullUniversalResolverError)(err)) return null;
        throw err;
    }
} //# sourceMappingURL=getEnsName.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsResolver.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEnsResolver = getEnsResolver;
const getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const packetToBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/packetToBytes.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function getEnsResolver(client, parameters) {
    const { blockNumber, blockTag, name } = parameters;
    const { chain } = client;
    const universalResolverAddress = (()=>{
        if (parameters.universalResolverAddress) return parameters.universalResolverAddress;
        if (!chain) throw new Error('client chain not configured. universalResolverAddress is required.');
        return (0, getChainContractAddress_js_1.getChainContractAddress)({
            blockNumber,
            chain,
            contract: 'ensUniversalResolver'
        });
    })();
    const tlds = chain === null || chain === void 0 ? void 0 : chain.ensTlds;
    if (tlds && !tlds.some((tld)=>name.endsWith(tld))) throw new Error("".concat(name, " is not a valid ENS TLD (").concat(tlds === null || tlds === void 0 ? void 0 : tlds.join(', '), ') for chain "').concat(chain.name, '" (id: ').concat(chain.id, ")."));
    const [resolverAddress] = await (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract')({
        address: universalResolverAddress,
        abi: [
            {
                inputs: [
                    {
                        type: 'bytes'
                    }
                ],
                name: 'findResolver',
                outputs: [
                    {
                        type: 'address'
                    },
                    {
                        type: 'bytes32'
                    },
                    {
                        type: 'uint256'
                    }
                ],
                stateMutability: 'view',
                type: 'function'
            }
        ],
        functionName: 'findResolver',
        args: [
            (0, toHex_js_1.toHex)((0, packetToBytes_js_1.packetToBytes)(name))
        ],
        blockNumber,
        blockTag
    });
    return resolverAddress;
} //# sourceMappingURL=getEnsResolver.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createAccessList.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createAccessList = createAccessList;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const getCallError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getCallError.js [app-client] (ecmascript)");
const extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
async function createAccessList(client, args) {
    const { account: account_ = client.account, blockNumber, blockTag = 'latest', blobs, data, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, to, value, ...rest } = args;
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : undefined;
    try {
        var _client_chain_formatters_transactionRequest, _client_chain_formatters, _client_chain;
        (0, assertRequest_js_1.assertRequest)(args);
        const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
        const block = blockNumberHex || blockTag;
        const chainFormat = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionRequest = _client_chain_formatters.transactionRequest) === null || _client_chain_formatters_transactionRequest === void 0 ? void 0 : _client_chain_formatters_transactionRequest.format;
        const format = chainFormat || transactionRequest_js_1.formatTransactionRequest;
        const request = format({
            ...(0, extract_js_1.extract)(rest, {
                format: chainFormat
            }),
            account,
            blobs,
            data,
            gas,
            gasPrice,
            maxFeePerBlobGas,
            maxFeePerGas,
            maxPriorityFeePerGas,
            to,
            value
        }, 'createAccessList');
        const response = await client.request({
            method: 'eth_createAccessList',
            params: [
                request,
                block
            ]
        });
        return {
            accessList: response.accessList,
            gasUsed: BigInt(response.gasUsed)
        };
    } catch (err) {
        throw (0, getCallError_js_1.getCallError)(err, {
            ...args,
            account,
            chain: client.chain
        });
    }
} //# sourceMappingURL=createAccessList.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createBlockFilter.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createBlockFilter = createBlockFilter;
const createFilterRequestScope_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/filters/createFilterRequestScope.js [app-client] (ecmascript)");
async function createBlockFilter(client) {
    const getRequest = (0, createFilterRequestScope_js_1.createFilterRequestScope)(client, {
        method: 'eth_newBlockFilter'
    });
    const id = await client.request({
        method: 'eth_newBlockFilter'
    });
    return {
        id,
        request: getRequest(id),
        type: 'block'
    };
} //# sourceMappingURL=createBlockFilter.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createEventFilter.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createEventFilter = createEventFilter;
const encodeEventTopics_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const createFilterRequestScope_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/filters/createFilterRequestScope.js [app-client] (ecmascript)");
async function createEventFilter(client) {
    let { address, args, event, events: events_, fromBlock, strict, toBlock } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const events = events_ !== null && events_ !== void 0 ? events_ : event ? [
        event
    ] : undefined;
    const getRequest = (0, createFilterRequestScope_js_1.createFilterRequestScope)(client, {
        method: 'eth_newFilter'
    });
    let topics = [];
    if (events) {
        const encoded = events.flatMap((event)=>(0, encodeEventTopics_js_1.encodeEventTopics)({
                abi: [
                    event
                ],
                eventName: event.name,
                args
            }));
        topics = [
            encoded
        ];
        if (event) topics = topics[0];
    }
    const id = await client.request({
        method: 'eth_newFilter',
        params: [
            {
                address,
                fromBlock: typeof fromBlock === 'bigint' ? (0, toHex_js_1.numberToHex)(fromBlock) : fromBlock,
                toBlock: typeof toBlock === 'bigint' ? (0, toHex_js_1.numberToHex)(toBlock) : toBlock,
                ...topics.length ? {
                    topics
                } : {}
            }
        ]
    });
    return {
        abi: events,
        args,
        eventName: event ? event.name : undefined,
        fromBlock,
        id,
        request: getRequest(id),
        strict: Boolean(strict),
        toBlock,
        type: 'event'
    };
} //# sourceMappingURL=createEventFilter.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createPendingTransactionFilter.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createPendingTransactionFilter = createPendingTransactionFilter;
const createFilterRequestScope_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/filters/createFilterRequestScope.js [app-client] (ecmascript)");
async function createPendingTransactionFilter(client) {
    const getRequest = (0, createFilterRequestScope_js_1.createFilterRequestScope)(client, {
        method: 'eth_newPendingTransactionFilter'
    });
    const id = await client.request({
        method: 'eth_newPendingTransactionFilter'
    });
    return {
        id,
        request: getRequest(id),
        type: 'transaction'
    };
} //# sourceMappingURL=createPendingTransactionFilter.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBalance.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getBalance = getBalance;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
var _client_experimental_blockTag;
async function getBalance(client, param) {
    let { address, blockNumber, blockTag = (_client_experimental_blockTag = client.experimental_blockTag) !== null && _client_experimental_blockTag !== void 0 ? _client_experimental_blockTag : 'latest' } = param;
    const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    const balance = await client.request({
        method: 'eth_getBalance',
        params: [
            address,
            blockNumberHex || blockTag
        ]
    });
    return BigInt(balance);
} //# sourceMappingURL=getBalance.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlobBaseFee.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getBlobBaseFee = getBlobBaseFee;
async function getBlobBaseFee(client) {
    const baseFee = await client.request({
        method: 'eth_blobBaseFee'
    });
    return BigInt(baseFee);
} //# sourceMappingURL=getBlobBaseFee.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockTransactionCount.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getBlockTransactionCount = getBlockTransactionCount;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function getBlockTransactionCount(client) {
    let { blockHash, blockNumber, blockTag = 'latest' } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const blockNumberHex = blockNumber !== undefined ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    let count;
    if (blockHash) {
        count = await client.request({
            method: 'eth_getBlockTransactionCountByHash',
            params: [
                blockHash
            ]
        }, {
            dedupe: true
        });
    } else {
        count = await client.request({
            method: 'eth_getBlockTransactionCountByNumber',
            params: [
                blockNumberHex || blockTag
            ]
        }, {
            dedupe: Boolean(blockNumberHex)
        });
    }
    return (0, fromHex_js_1.hexToNumber)(count);
} //# sourceMappingURL=getBlockTransactionCount.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getCode.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getCode = getCode;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function getCode(client, param) {
    let { address, blockNumber, blockTag = 'latest' } = param;
    const blockNumberHex = blockNumber !== undefined ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    const hex = await client.request({
        method: 'eth_getCode',
        params: [
            address,
            blockNumberHex || blockTag
        ]
    }, {
        dedupe: Boolean(blockNumberHex)
    });
    if (hex === '0x') return undefined;
    return hex;
} //# sourceMappingURL=getCode.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/eip712.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Eip712DomainNotFoundError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class Eip712DomainNotFoundError extends base_js_1.BaseError {
    constructor({ address }){
        super('No EIP-712 domain found on contract "'.concat(address, '".'), {
            metaMessages: [
                'Ensure that:',
                '- The contract is deployed at the address "'.concat(address, '".'),
                '- `eip712Domain()` function exists on the contract.',
                '- `eip712Domain()` function matches signature to ERC-5267 specification.'
            ],
            name: 'Eip712DomainNotFoundError'
        });
    }
}
exports.Eip712DomainNotFoundError = Eip712DomainNotFoundError; //# sourceMappingURL=eip712.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getEip712Domain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getEip712Domain = getEip712Domain;
const eip712_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/eip712.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function getEip712Domain(client, parameters) {
    const { address, factory, factoryData } = parameters;
    try {
        const [fields, name, version, chainId, verifyingContract, salt, extensions] = await (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract')({
            abi,
            address,
            functionName: 'eip712Domain',
            factory,
            factoryData
        });
        return {
            domain: {
                name,
                version,
                chainId: Number(chainId),
                verifyingContract,
                salt
            },
            extensions,
            fields
        };
    } catch (e) {
        const error = e;
        if (error.name === 'ContractFunctionExecutionError' && error.cause.name === 'ContractFunctionZeroDataError') {
            throw new eip712_js_1.Eip712DomainNotFoundError({
                address
            });
        }
        throw error;
    }
}
const abi = [
    {
        inputs: [],
        name: 'eip712Domain',
        outputs: [
            {
                name: 'fields',
                type: 'bytes1'
            },
            {
                name: 'name',
                type: 'string'
            },
            {
                name: 'version',
                type: 'string'
            },
            {
                name: 'chainId',
                type: 'uint256'
            },
            {
                name: 'verifyingContract',
                type: 'address'
            },
            {
                name: 'salt',
                type: 'bytes32'
            },
            {
                name: 'extensions',
                type: 'uint256[]'
            }
        ],
        stateMutability: 'view',
        type: 'function'
    }
]; //# sourceMappingURL=getEip712Domain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/feeHistory.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatFeeHistory = formatFeeHistory;
function formatFeeHistory(feeHistory) {
    var _feeHistory_reward;
    return {
        baseFeePerGas: feeHistory.baseFeePerGas.map((value)=>BigInt(value)),
        gasUsedRatio: feeHistory.gasUsedRatio,
        oldestBlock: BigInt(feeHistory.oldestBlock),
        reward: (_feeHistory_reward = feeHistory.reward) === null || _feeHistory_reward === void 0 ? void 0 : _feeHistory_reward.map((reward)=>reward.map((value)=>BigInt(value)))
    };
} //# sourceMappingURL=feeHistory.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFeeHistory.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFeeHistory = getFeeHistory;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const feeHistory_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/feeHistory.js [app-client] (ecmascript)");
async function getFeeHistory(client, param) {
    let { blockCount, blockNumber, blockTag = 'latest', rewardPercentiles } = param;
    const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    const feeHistory = await client.request({
        method: 'eth_feeHistory',
        params: [
            (0, toHex_js_1.numberToHex)(blockCount),
            blockNumberHex || blockTag,
            rewardPercentiles
        ]
    }, {
        dedupe: Boolean(blockNumberHex)
    });
    return (0, feeHistory_js_1.formatFeeHistory)(feeHistory);
} //# sourceMappingURL=getFeeHistory.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterLogs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFilterLogs = getFilterLogs;
const parseEventLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/parseEventLogs.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
async function getFilterLogs(_client, param) {
    let { filter } = param;
    var _filter_strict;
    const strict = (_filter_strict = filter.strict) !== null && _filter_strict !== void 0 ? _filter_strict : false;
    const logs = await filter.request({
        method: 'eth_getFilterLogs',
        params: [
            filter.id
        ]
    });
    const formattedLogs = logs.map((log)=>(0, log_js_1.formatLog)(log));
    if (!filter.abi) return formattedLogs;
    return (0, parseEventLogs_js_1.parseEventLogs)({
        abi: filter.abi,
        logs: formattedLogs,
        strict
    });
} //# sourceMappingURL=getFilterLogs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodePacked.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodePacked = encodePacked;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const regex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/regex.js [app-client] (ecmascript)");
function encodePacked(types, values) {
    if (types.length !== values.length) throw new abi_js_1.AbiEncodingLengthMismatchError({
        expectedLength: types.length,
        givenLength: values.length
    });
    const data = [];
    for(let i = 0; i < types.length; i++){
        const type = types[i];
        const value = values[i];
        data.push(encode(type, value));
    }
    return (0, concat_js_1.concatHex)(data);
}
function encode(type, value) {
    let isArray = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
    if (type === 'address') {
        const address = value;
        if (!(0, isAddress_js_1.isAddress)(address)) throw new address_js_1.InvalidAddressError({
            address
        });
        return (0, pad_js_1.pad)(address.toLowerCase(), {
            size: isArray ? 32 : null
        });
    }
    if (type === 'string') return (0, toHex_js_1.stringToHex)(value);
    if (type === 'bytes') return value;
    if (type === 'bool') return (0, pad_js_1.pad)((0, toHex_js_1.boolToHex)(value), {
        size: isArray ? 32 : 1
    });
    const intMatch = type.match(regex_js_1.integerRegex);
    if (intMatch) {
        const [_type, baseType, bits = '256'] = intMatch;
        const size = Number.parseInt(bits, 10) / 8;
        return (0, toHex_js_1.numberToHex)(value, {
            size: isArray ? 32 : size,
            signed: baseType === 'int'
        });
    }
    const bytesMatch = type.match(regex_js_1.bytesRegex);
    if (bytesMatch) {
        const [_type, size] = bytesMatch;
        if (Number.parseInt(size, 10) !== (value.length - 2) / 2) throw new abi_js_1.BytesSizeMismatchError({
            expectedSize: Number.parseInt(size, 10),
            givenSize: (value.length - 2) / 2
        });
        return (0, pad_js_1.pad)(value, {
            dir: 'right',
            size: isArray ? 32 : null
        });
    }
    const arrayMatch = type.match(regex_js_1.arrayRegex);
    if (arrayMatch && Array.isArray(value)) {
        const [_type, childType] = arrayMatch;
        const data = [];
        for(let i = 0; i < value.length; i++){
            data.push(encode(childType, value[i], true));
        }
        if (data.length === 0) return '0x';
        return (0, concat_js_1.concatHex)(data);
    }
    throw new abi_js_1.UnsupportedPackedAbiType(type);
} //# sourceMappingURL=encodePacked.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isBytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isBytes = isBytes;
function isBytes(value) {
    if (!value) return false;
    if (typeof value !== 'object') return false;
    if (!('BYTES_PER_ELEMENT' in value)) return false;
    return value.BYTES_PER_ELEMENT === 1 && value.constructor.name === 'Uint8Array';
} //# sourceMappingURL=isBytes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getContractAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getContractAddress = getContractAddress;
exports.getCreateAddress = getCreateAddress;
exports.getCreate2Address = getCreate2Address;
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const isBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isBytes.js [app-client] (ecmascript)");
const pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toRlp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toRlp.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
function getContractAddress(opts) {
    if (opts.opcode === 'CREATE2') return getCreate2Address(opts);
    return getCreateAddress(opts);
}
function getCreateAddress(opts) {
    const from = (0, toBytes_js_1.toBytes)((0, getAddress_js_1.getAddress)(opts.from));
    let nonce = (0, toBytes_js_1.toBytes)(opts.nonce);
    if (nonce[0] === 0) nonce = new Uint8Array([]);
    return (0, getAddress_js_1.getAddress)("0x".concat((0, keccak256_js_1.keccak256)((0, toRlp_js_1.toRlp)([
        from,
        nonce
    ], 'bytes')).slice(26)));
}
function getCreate2Address(opts) {
    const from = (0, toBytes_js_1.toBytes)((0, getAddress_js_1.getAddress)(opts.from));
    const salt = (0, pad_js_1.pad)((0, isBytes_js_1.isBytes)(opts.salt) ? opts.salt : (0, toBytes_js_1.toBytes)(opts.salt), {
        size: 32
    });
    const bytecodeHash = (()=>{
        if ('bytecodeHash' in opts) {
            if ((0, isBytes_js_1.isBytes)(opts.bytecodeHash)) return opts.bytecodeHash;
            return (0, toBytes_js_1.toBytes)(opts.bytecodeHash);
        }
        return (0, keccak256_js_1.keccak256)(opts.bytecode, 'bytes');
    })();
    return (0, getAddress_js_1.getAddress)((0, slice_js_1.slice)((0, keccak256_js_1.keccak256)((0, concat_js_1.concat)([
        (0, toBytes_js_1.toBytes)('0xff'),
        from,
        salt,
        bytecodeHash
    ])), 12));
} //# sourceMappingURL=getContractAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.assertTransactionEIP7702 = assertTransactionEIP7702;
exports.assertTransactionEIP4844 = assertTransactionEIP4844;
exports.assertTransactionEIP1559 = assertTransactionEIP1559;
exports.assertTransactionEIP2930 = assertTransactionEIP2930;
exports.assertTransactionLegacy = assertTransactionLegacy;
const kzg_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/kzg.js [app-client] (ecmascript)");
const number_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/number.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const blob_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/blob.js [app-client] (ecmascript)");
const chain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/chain.js [app-client] (ecmascript)");
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
function assertTransactionEIP7702(transaction) {
    const { authorizationList } = transaction;
    if (authorizationList) {
        for (const authorization of authorizationList){
            const { chainId } = authorization;
            const address = authorization.address;
            if (!(0, isAddress_js_1.isAddress)(address)) throw new address_js_1.InvalidAddressError({
                address
            });
            if (chainId < 0) throw new chain_js_1.InvalidChainIdError({
                chainId
            });
        }
    }
    assertTransactionEIP1559(transaction);
}
function assertTransactionEIP4844(transaction) {
    const { blobVersionedHashes } = transaction;
    if (blobVersionedHashes) {
        if (blobVersionedHashes.length === 0) throw new blob_js_1.EmptyBlobError();
        for (const hash of blobVersionedHashes){
            const size_ = (0, size_js_1.size)(hash);
            const version = (0, fromHex_js_1.hexToNumber)((0, slice_js_1.slice)(hash, 0, 1));
            if (size_ !== 32) throw new blob_js_1.InvalidVersionedHashSizeError({
                hash,
                size: size_
            });
            if (version !== kzg_js_1.versionedHashVersionKzg) throw new blob_js_1.InvalidVersionedHashVersionError({
                hash,
                version
            });
        }
    }
    assertTransactionEIP1559(transaction);
}
function assertTransactionEIP1559(transaction) {
    const { chainId, maxPriorityFeePerGas, maxFeePerGas, to } = transaction;
    if (chainId <= 0) throw new chain_js_1.InvalidChainIdError({
        chainId
    });
    if (to && !(0, isAddress_js_1.isAddress)(to)) throw new address_js_1.InvalidAddressError({
        address: to
    });
    if (maxFeePerGas && maxFeePerGas > number_js_1.maxUint256) throw new node_js_1.FeeCapTooHighError({
        maxFeePerGas
    });
    if (maxPriorityFeePerGas && maxFeePerGas && maxPriorityFeePerGas > maxFeePerGas) throw new node_js_1.TipAboveFeeCapError({
        maxFeePerGas,
        maxPriorityFeePerGas
    });
}
function assertTransactionEIP2930(transaction) {
    const { chainId, maxPriorityFeePerGas, gasPrice, maxFeePerGas, to } = transaction;
    if (chainId <= 0) throw new chain_js_1.InvalidChainIdError({
        chainId
    });
    if (to && !(0, isAddress_js_1.isAddress)(to)) throw new address_js_1.InvalidAddressError({
        address: to
    });
    if (maxPriorityFeePerGas || maxFeePerGas) throw new base_js_1.BaseError('`maxFeePerGas`/`maxPriorityFeePerGas` is not a valid EIP-2930 Transaction attribute.');
    if (gasPrice && gasPrice > number_js_1.maxUint256) throw new node_js_1.FeeCapTooHighError({
        maxFeePerGas: gasPrice
    });
}
function assertTransactionLegacy(transaction) {
    const { chainId, maxPriorityFeePerGas, gasPrice, maxFeePerGas, to } = transaction;
    if (to && !(0, isAddress_js_1.isAddress)(to)) throw new address_js_1.InvalidAddressError({
        address: to
    });
    if (typeof chainId !== 'undefined' && chainId <= 0) throw new chain_js_1.InvalidChainIdError({
        chainId
    });
    if (maxPriorityFeePerGas || maxFeePerGas) throw new base_js_1.BaseError('`maxFeePerGas`/`maxPriorityFeePerGas` is not a valid Legacy Transaction attribute.');
    if (gasPrice && gasPrice > number_js_1.maxUint256) throw new node_js_1.FeeCapTooHighError({
        maxFeePerGas: gasPrice
    });
} //# sourceMappingURL=assertTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeAccessList.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeAccessList = serializeAccessList;
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
function serializeAccessList(accessList) {
    if (!accessList || accessList.length === 0) return [];
    const serializedAccessList = [];
    for(let i = 0; i < accessList.length; i++){
        const { address, storageKeys } = accessList[i];
        for(let j = 0; j < storageKeys.length; j++){
            if (storageKeys[j].length - 2 !== 64) {
                throw new transaction_js_1.InvalidStorageKeySizeError({
                    storageKey: storageKeys[j]
                });
            }
        }
        if (!(0, isAddress_js_1.isAddress)(address, {
            strict: false
        })) {
            throw new address_js_1.InvalidAddressError({
                address
            });
        }
        serializedAccessList.push([
            address,
            storageKeys
        ]);
    }
    return serializedAccessList;
} //# sourceMappingURL=serializeAccessList.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeTransaction = serializeTransaction;
exports.toYParitySignatureArray = toYParitySignatureArray;
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const serializeAuthorizationList_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/serializeAuthorizationList.js [app-client] (ecmascript)");
const blobsToCommitments_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToCommitments.js [app-client] (ecmascript)");
const blobsToProofs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/blobsToProofs.js [app-client] (ecmascript)");
const commitmentsToVersionedHashes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/commitmentsToVersionedHashes.js [app-client] (ecmascript)");
const toBlobSidecars_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/toBlobSidecars.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const toRlp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toRlp.js [app-client] (ecmascript)");
const assertTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertTransaction.js [app-client] (ecmascript)");
const getTransactionType_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getTransactionType.js [app-client] (ecmascript)");
const serializeAccessList_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeAccessList.js [app-client] (ecmascript)");
function serializeTransaction(transaction, signature) {
    const type = (0, getTransactionType_js_1.getTransactionType)(transaction);
    if (type === 'eip1559') return serializeTransactionEIP1559(transaction, signature);
    if (type === 'eip2930') return serializeTransactionEIP2930(transaction, signature);
    if (type === 'eip4844') return serializeTransactionEIP4844(transaction, signature);
    if (type === 'eip7702') return serializeTransactionEIP7702(transaction, signature);
    return serializeTransactionLegacy(transaction, signature);
}
function serializeTransactionEIP7702(transaction, signature) {
    const { authorizationList, chainId, gas, nonce, to, value, maxFeePerGas, maxPriorityFeePerGas, accessList, data } = transaction;
    (0, assertTransaction_js_1.assertTransactionEIP7702)(transaction);
    const serializedAccessList = (0, serializeAccessList_js_1.serializeAccessList)(accessList);
    const serializedAuthorizationList = (0, serializeAuthorizationList_js_1.serializeAuthorizationList)(authorizationList);
    return (0, concat_js_1.concatHex)([
        '0x04',
        (0, toRlp_js_1.toRlp)([
            (0, toHex_js_1.numberToHex)(chainId),
            nonce ? (0, toHex_js_1.numberToHex)(nonce) : '0x',
            maxPriorityFeePerGas ? (0, toHex_js_1.numberToHex)(maxPriorityFeePerGas) : '0x',
            maxFeePerGas ? (0, toHex_js_1.numberToHex)(maxFeePerGas) : '0x',
            gas ? (0, toHex_js_1.numberToHex)(gas) : '0x',
            to !== null && to !== void 0 ? to : '0x',
            value ? (0, toHex_js_1.numberToHex)(value) : '0x',
            data !== null && data !== void 0 ? data : '0x',
            serializedAccessList,
            serializedAuthorizationList,
            ...toYParitySignatureArray(transaction, signature)
        ])
    ]);
}
function serializeTransactionEIP4844(transaction, signature) {
    const { chainId, gas, nonce, to, value, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, accessList, data } = transaction;
    (0, assertTransaction_js_1.assertTransactionEIP4844)(transaction);
    let blobVersionedHashes = transaction.blobVersionedHashes;
    let sidecars = transaction.sidecars;
    if (transaction.blobs && (typeof blobVersionedHashes === 'undefined' || typeof sidecars === 'undefined')) {
        const blobs = typeof transaction.blobs[0] === 'string' ? transaction.blobs : transaction.blobs.map((x)=>(0, toHex_js_1.bytesToHex)(x));
        const kzg = transaction.kzg;
        const commitments = (0, blobsToCommitments_js_1.blobsToCommitments)({
            blobs,
            kzg
        });
        if (typeof blobVersionedHashes === 'undefined') blobVersionedHashes = (0, commitmentsToVersionedHashes_js_1.commitmentsToVersionedHashes)({
            commitments
        });
        if (typeof sidecars === 'undefined') {
            const proofs = (0, blobsToProofs_js_1.blobsToProofs)({
                blobs,
                commitments,
                kzg
            });
            sidecars = (0, toBlobSidecars_js_1.toBlobSidecars)({
                blobs,
                commitments,
                proofs
            });
        }
    }
    const serializedAccessList = (0, serializeAccessList_js_1.serializeAccessList)(accessList);
    const serializedTransaction = [
        (0, toHex_js_1.numberToHex)(chainId),
        nonce ? (0, toHex_js_1.numberToHex)(nonce) : '0x',
        maxPriorityFeePerGas ? (0, toHex_js_1.numberToHex)(maxPriorityFeePerGas) : '0x',
        maxFeePerGas ? (0, toHex_js_1.numberToHex)(maxFeePerGas) : '0x',
        gas ? (0, toHex_js_1.numberToHex)(gas) : '0x',
        to !== null && to !== void 0 ? to : '0x',
        value ? (0, toHex_js_1.numberToHex)(value) : '0x',
        data !== null && data !== void 0 ? data : '0x',
        serializedAccessList,
        maxFeePerBlobGas ? (0, toHex_js_1.numberToHex)(maxFeePerBlobGas) : '0x',
        blobVersionedHashes !== null && blobVersionedHashes !== void 0 ? blobVersionedHashes : [],
        ...toYParitySignatureArray(transaction, signature)
    ];
    const blobs = [];
    const commitments = [];
    const proofs = [];
    if (sidecars) for(let i = 0; i < sidecars.length; i++){
        const { blob, commitment, proof } = sidecars[i];
        blobs.push(blob);
        commitments.push(commitment);
        proofs.push(proof);
    }
    return (0, concat_js_1.concatHex)([
        '0x03',
        sidecars ? (0, toRlp_js_1.toRlp)([
            serializedTransaction,
            blobs,
            commitments,
            proofs
        ]) : (0, toRlp_js_1.toRlp)(serializedTransaction)
    ]);
}
function serializeTransactionEIP1559(transaction, signature) {
    const { chainId, gas, nonce, to, value, maxFeePerGas, maxPriorityFeePerGas, accessList, data } = transaction;
    (0, assertTransaction_js_1.assertTransactionEIP1559)(transaction);
    const serializedAccessList = (0, serializeAccessList_js_1.serializeAccessList)(accessList);
    const serializedTransaction = [
        (0, toHex_js_1.numberToHex)(chainId),
        nonce ? (0, toHex_js_1.numberToHex)(nonce) : '0x',
        maxPriorityFeePerGas ? (0, toHex_js_1.numberToHex)(maxPriorityFeePerGas) : '0x',
        maxFeePerGas ? (0, toHex_js_1.numberToHex)(maxFeePerGas) : '0x',
        gas ? (0, toHex_js_1.numberToHex)(gas) : '0x',
        to !== null && to !== void 0 ? to : '0x',
        value ? (0, toHex_js_1.numberToHex)(value) : '0x',
        data !== null && data !== void 0 ? data : '0x',
        serializedAccessList,
        ...toYParitySignatureArray(transaction, signature)
    ];
    return (0, concat_js_1.concatHex)([
        '0x02',
        (0, toRlp_js_1.toRlp)(serializedTransaction)
    ]);
}
function serializeTransactionEIP2930(transaction, signature) {
    const { chainId, gas, data, nonce, to, value, accessList, gasPrice } = transaction;
    (0, assertTransaction_js_1.assertTransactionEIP2930)(transaction);
    const serializedAccessList = (0, serializeAccessList_js_1.serializeAccessList)(accessList);
    const serializedTransaction = [
        (0, toHex_js_1.numberToHex)(chainId),
        nonce ? (0, toHex_js_1.numberToHex)(nonce) : '0x',
        gasPrice ? (0, toHex_js_1.numberToHex)(gasPrice) : '0x',
        gas ? (0, toHex_js_1.numberToHex)(gas) : '0x',
        to !== null && to !== void 0 ? to : '0x',
        value ? (0, toHex_js_1.numberToHex)(value) : '0x',
        data !== null && data !== void 0 ? data : '0x',
        serializedAccessList,
        ...toYParitySignatureArray(transaction, signature)
    ];
    return (0, concat_js_1.concatHex)([
        '0x01',
        (0, toRlp_js_1.toRlp)(serializedTransaction)
    ]);
}
function serializeTransactionLegacy(transaction, signature) {
    const { chainId = 0, gas, data, nonce, to, value, gasPrice } = transaction;
    (0, assertTransaction_js_1.assertTransactionLegacy)(transaction);
    let serializedTransaction = [
        nonce ? (0, toHex_js_1.numberToHex)(nonce) : '0x',
        gasPrice ? (0, toHex_js_1.numberToHex)(gasPrice) : '0x',
        gas ? (0, toHex_js_1.numberToHex)(gas) : '0x',
        to !== null && to !== void 0 ? to : '0x',
        value ? (0, toHex_js_1.numberToHex)(value) : '0x',
        data !== null && data !== void 0 ? data : '0x'
    ];
    if (signature) {
        const v = (()=>{
            if (signature.v >= 35n) {
                const inferredChainId = (signature.v - 35n) / 2n;
                if (inferredChainId > 0) return signature.v;
                return 27n + (signature.v === 35n ? 0n : 1n);
            }
            if (chainId > 0) return BigInt(chainId * 2) + BigInt(35n + signature.v - 27n);
            const v = 27n + (signature.v === 27n ? 0n : 1n);
            if (signature.v !== v) throw new transaction_js_1.InvalidLegacyVError({
                v: signature.v
            });
            return v;
        })();
        const r = (0, trim_js_1.trim)(signature.r);
        const s = (0, trim_js_1.trim)(signature.s);
        serializedTransaction = [
            ...serializedTransaction,
            (0, toHex_js_1.numberToHex)(v),
            r === '0x00' ? '0x' : r,
            s === '0x00' ? '0x' : s
        ];
    } else if (chainId > 0) {
        serializedTransaction = [
            ...serializedTransaction,
            (0, toHex_js_1.numberToHex)(chainId),
            '0x',
            '0x'
        ];
    }
    return (0, toRlp_js_1.toRlp)(serializedTransaction);
}
function toYParitySignatureArray(transaction, signature_) {
    const signature = signature_ !== null && signature_ !== void 0 ? signature_ : transaction;
    const { v, yParity } = signature;
    if (typeof signature.r === 'undefined') return [];
    if (typeof signature.s === 'undefined') return [];
    if (typeof v === 'undefined' && typeof yParity === 'undefined') return [];
    const r = (0, trim_js_1.trim)(signature.r);
    const s = (0, trim_js_1.trim)(signature.s);
    const yParity_ = (()=>{
        if (typeof yParity === 'number') return yParity ? (0, toHex_js_1.numberToHex)(1) : '0x';
        if (v === 0n) return '0x';
        if (v === 1n) return (0, toHex_js_1.numberToHex)(1);
        return v === 27n ? '0x' : (0, toHex_js_1.numberToHex)(1);
    })();
    return [
        yParity_,
        r === '0x00' ? '0x' : r,
        s === '0x00' ? '0x' : s
    ];
} //# sourceMappingURL=serializeTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/serializeAuthorizationList.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeAuthorizationList = serializeAuthorizationList;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const serializeTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeTransaction.js [app-client] (ecmascript)");
function serializeAuthorizationList(authorizationList) {
    if (!authorizationList || authorizationList.length === 0) return [];
    const serializedAuthorizationList = [];
    for (const authorization of authorizationList){
        const { chainId, nonce, ...signature } = authorization;
        const contractAddress = authorization.address;
        serializedAuthorizationList.push([
            chainId ? (0, toHex_js_1.toHex)(chainId) : '0x',
            contractAddress,
            nonce ? (0, toHex_js_1.toHex)(nonce) : '0x',
            ...(0, serializeTransaction_js_1.toYParitySignatureArray)({}, signature)
        ]);
    }
    return serializedAuthorizationList;
} //# sourceMappingURL=serializeAuthorizationList.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/verifyAuthorization.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyAuthorization = verifyAuthorization;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const recoverAuthorizationAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/recoverAuthorizationAddress.js [app-client] (ecmascript)");
async function verifyAuthorization(param) {
    let { address, authorization, signature } = param;
    return (0, isAddressEqual_js_1.isAddressEqual)((0, getAddress_js_1.getAddress)(address), await (0, recoverAuthorizationAddress_js_1.recoverAuthorizationAddress)({
        authorization,
        signature
    }));
} //# sourceMappingURL=verifyAuthorization.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withDedupe.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.promiseCache = void 0;
exports.withDedupe = withDedupe;
const lru_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)");
exports.promiseCache = new lru_js_1.LruMap(8192);
function withDedupe(fn, param) {
    let { enabled = true, id } = param;
    if (!enabled || !id) return fn();
    if (exports.promiseCache.get(id)) return exports.promiseCache.get(id);
    const promise = fn().finally(()=>exports.promiseCache.delete(id));
    exports.promiseCache.set(id, promise);
    return promise;
} //# sourceMappingURL=withDedupe.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/buildRequest.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.buildRequest = buildRequest;
exports.shouldRetry = shouldRetry;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const withDedupe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withDedupe.js [app-client] (ecmascript)");
const withRetry_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withRetry.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
function buildRequest(request) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return async function(args) {
        let overrideOptions = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var _methods_exclude;
        const { dedupe = false, methods, retryDelay = 150, retryCount = 3, uid } = {
            ...options,
            ...overrideOptions
        };
        const { method } = args;
        if (methods === null || methods === void 0 ? void 0 : (_methods_exclude = methods.exclude) === null || _methods_exclude === void 0 ? void 0 : _methods_exclude.includes(method)) throw new rpc_js_1.MethodNotSupportedRpcError(new Error('method not supported'), {
            method
        });
        if ((methods === null || methods === void 0 ? void 0 : methods.include) && !methods.include.includes(method)) throw new rpc_js_1.MethodNotSupportedRpcError(new Error('method not supported'), {
            method
        });
        const requestId = dedupe ? (0, toHex_js_1.stringToHex)("".concat(uid, ".").concat((0, stringify_js_1.stringify)(args))) : undefined;
        return (0, withDedupe_js_1.withDedupe)(()=>(0, withRetry_js_1.withRetry)(async ()=>{
                try {
                    return await request(args);
                } catch (err_) {
                    const err = err_;
                    switch(err.code){
                        case rpc_js_1.ParseRpcError.code:
                            throw new rpc_js_1.ParseRpcError(err);
                        case rpc_js_1.InvalidRequestRpcError.code:
                            throw new rpc_js_1.InvalidRequestRpcError(err);
                        case rpc_js_1.MethodNotFoundRpcError.code:
                            throw new rpc_js_1.MethodNotFoundRpcError(err, {
                                method: args.method
                            });
                        case rpc_js_1.InvalidParamsRpcError.code:
                            throw new rpc_js_1.InvalidParamsRpcError(err);
                        case rpc_js_1.InternalRpcError.code:
                            throw new rpc_js_1.InternalRpcError(err);
                        case rpc_js_1.InvalidInputRpcError.code:
                            throw new rpc_js_1.InvalidInputRpcError(err);
                        case rpc_js_1.ResourceNotFoundRpcError.code:
                            throw new rpc_js_1.ResourceNotFoundRpcError(err);
                        case rpc_js_1.ResourceUnavailableRpcError.code:
                            throw new rpc_js_1.ResourceUnavailableRpcError(err);
                        case rpc_js_1.TransactionRejectedRpcError.code:
                            throw new rpc_js_1.TransactionRejectedRpcError(err);
                        case rpc_js_1.MethodNotSupportedRpcError.code:
                            throw new rpc_js_1.MethodNotSupportedRpcError(err, {
                                method: args.method
                            });
                        case rpc_js_1.LimitExceededRpcError.code:
                            throw new rpc_js_1.LimitExceededRpcError(err);
                        case rpc_js_1.JsonRpcVersionUnsupportedError.code:
                            throw new rpc_js_1.JsonRpcVersionUnsupportedError(err);
                        case rpc_js_1.UserRejectedRequestError.code:
                            throw new rpc_js_1.UserRejectedRequestError(err);
                        case rpc_js_1.UnauthorizedProviderError.code:
                            throw new rpc_js_1.UnauthorizedProviderError(err);
                        case rpc_js_1.UnsupportedProviderMethodError.code:
                            throw new rpc_js_1.UnsupportedProviderMethodError(err);
                        case rpc_js_1.ProviderDisconnectedError.code:
                            throw new rpc_js_1.ProviderDisconnectedError(err);
                        case rpc_js_1.ChainDisconnectedError.code:
                            throw new rpc_js_1.ChainDisconnectedError(err);
                        case rpc_js_1.SwitchChainError.code:
                            throw new rpc_js_1.SwitchChainError(err);
                        case rpc_js_1.UnsupportedNonOptionalCapabilityError.code:
                            throw new rpc_js_1.UnsupportedNonOptionalCapabilityError(err);
                        case rpc_js_1.UnsupportedChainIdError.code:
                            throw new rpc_js_1.UnsupportedChainIdError(err);
                        case rpc_js_1.DuplicateIdError.code:
                            throw new rpc_js_1.DuplicateIdError(err);
                        case rpc_js_1.UnknownBundleIdError.code:
                            throw new rpc_js_1.UnknownBundleIdError(err);
                        case rpc_js_1.BundleTooLargeError.code:
                            throw new rpc_js_1.BundleTooLargeError(err);
                        case rpc_js_1.AtomicReadyWalletRejectedUpgradeError.code:
                            throw new rpc_js_1.AtomicReadyWalletRejectedUpgradeError(err);
                        case rpc_js_1.AtomicityNotSupportedError.code:
                            throw new rpc_js_1.AtomicityNotSupportedError(err);
                        case 5000:
                            throw new rpc_js_1.UserRejectedRequestError(err);
                        default:
                            if (err_ instanceof base_js_1.BaseError) throw err_;
                            throw new rpc_js_1.UnknownRpcError(err);
                    }
                }
            }, {
                delay: (param)=>{
                    let { count, error } = param;
                    if (error && error instanceof request_js_1.HttpRequestError) {
                        var _error_headers;
                        const retryAfter = error === null || error === void 0 ? void 0 : (_error_headers = error.headers) === null || _error_headers === void 0 ? void 0 : _error_headers.get('Retry-After');
                        if (retryAfter === null || retryAfter === void 0 ? void 0 : retryAfter.match(/\d/)) return Number.parseInt(retryAfter, 10) * 1000;
                    }
                    return ~~(1 << count) * retryDelay;
                },
                retryCount,
                shouldRetry: (param)=>{
                    let { error } = param;
                    return shouldRetry(error);
                }
            }), {
            enabled: dedupe,
            id: requestId
        });
    };
}
function shouldRetry(error) {
    if ('code' in error && typeof error.code === 'number') {
        if (error.code === -1) return true;
        if (error.code === rpc_js_1.LimitExceededRpcError.code) return true;
        if (error.code === rpc_js_1.InternalRpcError.code) return true;
        return false;
    }
    if (error instanceof request_js_1.HttpRequestError && error.status) {
        if (error.status === 403) return true;
        if (error.status === 408) return true;
        if (error.status === 413) return true;
        if (error.status === 429) return true;
        if (error.status === 500) return true;
        if (error.status === 502) return true;
        if (error.status === 503) return true;
        if (error.status === 504) return true;
        return false;
    }
    return true;
} //# sourceMappingURL=buildRequest.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/defineChain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineChain = defineChain;
function defineChain(chain) {
    return {
        formatters: undefined,
        fees: undefined,
        serializers: undefined,
        ...chain
    };
} //# sourceMappingURL=defineChain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/extractChain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.extractChain = extractChain;
function extractChain(param) {
    let { chains, id } = param;
    return chains.find((chain)=>chain.id === id);
} //# sourceMappingURL=extractChain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromRlp.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fromRlp = fromRlp;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const encoding_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/encoding.js [app-client] (ecmascript)");
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/cursor.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function fromRlp(value) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'hex';
    const bytes = (()=>{
        if (typeof value === 'string') {
            if (value.length > 3 && value.length % 2 !== 0) throw new encoding_js_1.InvalidHexValueError(value);
            return (0, toBytes_js_1.hexToBytes)(value);
        }
        return value;
    })();
    const cursor = (0, cursor_js_1.createCursor)(bytes, {
        recursiveReadLimit: Number.POSITIVE_INFINITY
    });
    const result = fromRlpCursor(cursor, to);
    return result;
}
function fromRlpCursor(cursor) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'hex';
    if (cursor.bytes.length === 0) return to === 'hex' ? (0, toHex_js_1.bytesToHex)(cursor.bytes) : cursor.bytes;
    const prefix = cursor.readByte();
    if (prefix < 0x80) cursor.decrementPosition(1);
    if (prefix < 0xc0) {
        const length = readLength(cursor, prefix, 0x80);
        const bytes = cursor.readBytes(length);
        return to === 'hex' ? (0, toHex_js_1.bytesToHex)(bytes) : bytes;
    }
    const length = readLength(cursor, prefix, 0xc0);
    return readList(cursor, length, to);
}
function readLength(cursor, prefix, offset) {
    if (offset === 0x80 && prefix < 0x80) return 1;
    if (prefix <= offset + 55) return prefix - offset;
    if (prefix === offset + 55 + 1) return cursor.readUint8();
    if (prefix === offset + 55 + 2) return cursor.readUint16();
    if (prefix === offset + 55 + 3) return cursor.readUint24();
    if (prefix === offset + 55 + 4) return cursor.readUint32();
    throw new base_js_1.BaseError('Invalid RLP prefix');
}
function readList(cursor, length, to) {
    const position = cursor.position;
    const value = [];
    while(cursor.position - position < length)value.push(fromRlpCursor(cursor, to));
    return value;
} //# sourceMappingURL=fromRlp.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/isHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isHash = isHash;
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
function isHash(hash) {
    return (0, isHex_js_1.isHex)(hash) && (0, size_js_1.size)(hash) === 32;
} //# sourceMappingURL=isHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/ripemd160.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ripemd160 = ripemd160;
const ripemd160_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/ripemd160.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function ripemd160(value, to_) {
    const to = to_ || 'hex';
    const bytes = (0, ripemd160_1.ripemd160)((0, isHex_js_1.isHex)(value, {
        strict: false
    }) ? (0, toBytes_js_1.toBytes)(value) : value);
    if (to === 'bytes') return bytes;
    return (0, toHex_js_1.toHex)(bytes);
} //# sourceMappingURL=ripemd160.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toEventHash = void 0;
var toSignatureHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignatureHash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toEventHash", {
    enumerable: true,
    get: function() {
        return toSignatureHash_js_1.toSignatureHash;
    }
}); //# sourceMappingURL=toEventHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toEventSignature = void 0;
var toSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toEventSignature", {
    enumerable: true,
    get: function() {
        return toSignature_js_1.toSignature;
    }
}); //# sourceMappingURL=toEventSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toFunctionHash = void 0;
var toSignatureHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignatureHash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toFunctionHash", {
    enumerable: true,
    get: function() {
        return toSignatureHash_js_1.toSignatureHash;
    }
}); //# sourceMappingURL=toFunctionHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toFunctionSignature = void 0;
var toSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toSignature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toFunctionSignature", {
    enumerable: true,
    get: function() {
        return toSignature_js_1.toSignature;
    }
}); //# sourceMappingURL=toFunctionSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/nonceManager.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.nonceManager = void 0;
exports.createNonceManager = createNonceManager;
exports.jsonRpc = jsonRpc;
const getTransactionCount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionCount.js [app-client] (ecmascript)");
const lru_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)");
function createNonceManager(parameters) {
    const { source } = parameters;
    const deltaMap = new Map();
    const nonceMap = new lru_js_1.LruMap(8192);
    const promiseMap = new Map();
    const getKey = (param)=>{
        let { address, chainId } = param;
        return "".concat(address, ".").concat(chainId);
    };
    return {
        async consume (param) {
            let { address, chainId, client } = param;
            const key = getKey({
                address,
                chainId
            });
            const promise = this.get({
                address,
                chainId,
                client
            });
            this.increment({
                address,
                chainId
            });
            const nonce = await promise;
            await source.set({
                address,
                chainId
            }, nonce);
            nonceMap.set(key, nonce);
            return nonce;
        },
        async increment (param) {
            let { address, chainId } = param;
            const key = getKey({
                address,
                chainId
            });
            var _deltaMap_get;
            const delta = (_deltaMap_get = deltaMap.get(key)) !== null && _deltaMap_get !== void 0 ? _deltaMap_get : 0;
            deltaMap.set(key, delta + 1);
        },
        async get (param) {
            let { address, chainId, client } = param;
            const key = getKey({
                address,
                chainId
            });
            let promise = promiseMap.get(key);
            if (!promise) {
                promise = (async ()=>{
                    try {
                        const nonce = await source.get({
                            address,
                            chainId,
                            client
                        });
                        var _nonceMap_get;
                        const previousNonce = (_nonceMap_get = nonceMap.get(key)) !== null && _nonceMap_get !== void 0 ? _nonceMap_get : 0;
                        if (previousNonce > 0 && nonce <= previousNonce) return previousNonce + 1;
                        nonceMap.delete(key);
                        return nonce;
                    } finally{
                        this.reset({
                            address,
                            chainId
                        });
                    }
                })();
                promiseMap.set(key, promise);
            }
            var _deltaMap_get;
            const delta = (_deltaMap_get = deltaMap.get(key)) !== null && _deltaMap_get !== void 0 ? _deltaMap_get : 0;
            return delta + await promise;
        },
        reset (param) {
            let { address, chainId } = param;
            const key = getKey({
                address,
                chainId
            });
            deltaMap.delete(key);
            promiseMap.delete(key);
        }
    };
}
function jsonRpc() {
    return {
        async get (parameters) {
            const { address, client } = parameters;
            return (0, getTransactionCount_js_1.getTransactionCount)(client, {
                address,
                blockTag: 'pending'
            });
        },
        set () {}
    };
}
exports.nonceManager = createNonceManager({
    source: jsonRpc()
}); //# sourceMappingURL=nonceManager.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withTimeout.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.withTimeout = withTimeout;
function withTimeout(fn, param) {
    let { errorInstance = new Error('timed out'), timeout, signal } = param;
    return new Promise((resolve, reject)=>{
        ;
        (async ()=>{
            let timeoutId;
            try {
                const controller = new AbortController();
                if (timeout > 0) {
                    timeoutId = setTimeout(()=>{
                        if (signal) {
                            controller.abort();
                        } else {
                            reject(errorInstance);
                        }
                    }, timeout);
                }
                resolve(await fn({
                    signal: (controller === null || controller === void 0 ? void 0 : controller.signal) || null
                }));
            } catch (err) {
                if ((err === null || err === void 0 ? void 0 : err.name) === 'AbortError') reject(errorInstance);
                reject(err);
            } finally{
                clearTimeout(timeoutId);
            }
        })();
    });
} //# sourceMappingURL=withTimeout.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/id.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.idCache = void 0;
function createIdStore() {
    return {
        current: 0,
        take () {
            return this.current++;
        },
        reset () {
            this.current = 0;
        }
    };
}
exports.idCache = createIdStore(); //# sourceMappingURL=id.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/http.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getHttpRpcClient = getHttpRpcClient;
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const withTimeout_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withTimeout.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const id_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/id.js [app-client] (ecmascript)");
function getHttpRpcClient(url) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return {
        async request (params) {
            var _options_fetchFn, _options_timeout;
            const { body, fetchFn = (_options_fetchFn = options.fetchFn) !== null && _options_fetchFn !== void 0 ? _options_fetchFn : fetch, onRequest = options.onRequest, onResponse = options.onResponse, timeout = (_options_timeout = options.timeout) !== null && _options_timeout !== void 0 ? _options_timeout : 10_000 } = params;
            var _options_fetchOptions, _params_fetchOptions;
            const fetchOptions = {
                ...(_options_fetchOptions = options.fetchOptions) !== null && _options_fetchOptions !== void 0 ? _options_fetchOptions : {},
                ...(_params_fetchOptions = params.fetchOptions) !== null && _params_fetchOptions !== void 0 ? _params_fetchOptions : {}
            };
            const { headers, method, signal: signal_ } = fetchOptions;
            try {
                var _response_headers_get;
                const response = await (0, withTimeout_js_1.withTimeout)(async (param)=>{
                    let { signal } = param;
                    var _body_id;
                    const init = {
                        ...fetchOptions,
                        body: Array.isArray(body) ? (0, stringify_js_1.stringify)(body.map((body)=>{
                            var _body_id;
                            return {
                                jsonrpc: '2.0',
                                id: (_body_id = body.id) !== null && _body_id !== void 0 ? _body_id : id_js_1.idCache.take(),
                                ...body
                            };
                        })) : (0, stringify_js_1.stringify)({
                            jsonrpc: '2.0',
                            id: (_body_id = body.id) !== null && _body_id !== void 0 ? _body_id : id_js_1.idCache.take(),
                            ...body
                        }),
                        headers: {
                            'Content-Type': 'application/json',
                            ...headers
                        },
                        method: method || 'POST',
                        signal: signal_ || (timeout > 0 ? signal : null)
                    };
                    const request = new Request(url, init);
                    var _ref;
                    const args = (_ref = await (onRequest === null || onRequest === void 0 ? void 0 : onRequest(request, init))) !== null && _ref !== void 0 ? _ref : {
                        ...init,
                        url
                    };
                    var _args_url;
                    const response = await fetchFn((_args_url = args.url) !== null && _args_url !== void 0 ? _args_url : url, args);
                    return response;
                }, {
                    errorInstance: new request_js_1.TimeoutError({
                        body,
                        url
                    }),
                    timeout,
                    signal: true
                });
                if (onResponse) await onResponse(response);
                let data;
                if ((_response_headers_get = response.headers.get('Content-Type')) === null || _response_headers_get === void 0 ? void 0 : _response_headers_get.startsWith('application/json')) data = await response.json();
                else {
                    data = await response.text();
                    try {
                        data = JSON.parse(data || '{}');
                    } catch (err) {
                        if (response.ok) throw err;
                        data = {
                            error: data
                        };
                    }
                }
                if (!response.ok) {
                    throw new request_js_1.HttpRequestError({
                        body,
                        details: (0, stringify_js_1.stringify)(data.error) || response.statusText,
                        headers: response.headers,
                        status: response.status,
                        url
                    });
                }
                return data;
            } catch (err) {
                if (err instanceof request_js_1.HttpRequestError) throw err;
                if (err instanceof request_js_1.TimeoutError) throw err;
                throw new request_js_1.HttpRequestError({
                    body,
                    cause: err,
                    url
                });
            }
        }
    };
} //# sourceMappingURL=http.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/socket.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.socketClientCache = void 0;
exports.getSocketRpcClient = getSocketRpcClient;
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const createBatchScheduler_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/createBatchScheduler.js [app-client] (ecmascript)");
const withTimeout_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withTimeout.js [app-client] (ecmascript)");
const id_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/id.js [app-client] (ecmascript)");
exports.socketClientCache = new Map();
async function getSocketRpcClient(parameters) {
    const { getSocket, keepAlive = true, key = 'socket', reconnect = true, url } = parameters;
    const { interval: keepAliveInterval = 30_000 } = typeof keepAlive === 'object' ? keepAlive : {};
    const { attempts = 5, delay = 2_000 } = typeof reconnect === 'object' ? reconnect : {};
    const id = JSON.stringify({
        keepAlive,
        key,
        url,
        reconnect
    });
    let socketClient = exports.socketClientCache.get(id);
    if (socketClient) return socketClient;
    let reconnectCount = 0;
    const { schedule } = (0, createBatchScheduler_js_1.createBatchScheduler)({
        id,
        fn: async ()=>{
            const requests = new Map();
            const subscriptions = new Map();
            let error;
            let socket;
            let keepAliveTimer;
            let reconnectInProgress = false;
            function attemptReconnect() {
                if (reconnect && reconnectCount < attempts) {
                    if (reconnectInProgress) return;
                    reconnectInProgress = true;
                    reconnectCount++;
                    socket === null || socket === void 0 ? void 0 : socket.close();
                    setTimeout(async ()=>{
                        await setup().catch(console.error);
                        reconnectInProgress = false;
                    }, delay);
                } else {
                    requests.clear();
                    subscriptions.clear();
                }
            }
            async function setup() {
                const result = await getSocket({
                    onClose () {
                        var _request_onError, _subscription_onError;
                        for (const request of requests.values())(_request_onError = request.onError) === null || _request_onError === void 0 ? void 0 : _request_onError.call(request, new request_js_1.SocketClosedError({
                            url
                        }));
                        for (const subscription of subscriptions.values())(_subscription_onError = subscription.onError) === null || _subscription_onError === void 0 ? void 0 : _subscription_onError.call(subscription, new request_js_1.SocketClosedError({
                            url
                        }));
                        attemptReconnect();
                    },
                    onError (error_) {
                        var _request_onError, _subscription_onError;
                        error = error_;
                        for (const request of requests.values())(_request_onError = request.onError) === null || _request_onError === void 0 ? void 0 : _request_onError.call(request, error);
                        for (const subscription of subscriptions.values())(_subscription_onError = subscription.onError) === null || _subscription_onError === void 0 ? void 0 : _subscription_onError.call(subscription, error);
                        attemptReconnect();
                    },
                    onOpen () {
                        error = undefined;
                        reconnectCount = 0;
                    },
                    onResponse (data) {
                        const isSubscription = data.method === 'eth_subscription';
                        const id = isSubscription ? data.params.subscription : data.id;
                        const cache = isSubscription ? subscriptions : requests;
                        const callback = cache.get(id);
                        if (callback) callback.onResponse(data);
                        if (!isSubscription) cache.delete(id);
                    }
                });
                socket = result;
                if (keepAlive) {
                    if (keepAliveTimer) clearInterval(keepAliveTimer);
                    keepAliveTimer = setInterval(()=>{
                        var _socket_ping;
                        return (_socket_ping = socket.ping) === null || _socket_ping === void 0 ? void 0 : _socket_ping.call(socket);
                    }, keepAliveInterval);
                }
                if (reconnect && subscriptions.size > 0) {
                    const subscriptionEntries = subscriptions.entries();
                    for (const [key, { onResponse, body, onError }] of subscriptionEntries){
                        if (!body) continue;
                        subscriptions.delete(key);
                        socketClient === null || socketClient === void 0 ? void 0 : socketClient.request({
                            body,
                            onResponse,
                            onError
                        });
                    }
                }
                return result;
            }
            await setup();
            error = undefined;
            socketClient = {
                close () {
                    keepAliveTimer && clearInterval(keepAliveTimer);
                    socket.close();
                    exports.socketClientCache.delete(id);
                },
                get socket () {
                    return socket;
                },
                request (param) {
                    let { body, onError, onResponse } = param;
                    if (error && onError) onError(error);
                    var _body_id;
                    const id = (_body_id = body.id) !== null && _body_id !== void 0 ? _body_id : id_js_1.idCache.take();
                    const callback = (response)=>{
                        var _body_params;
                        if (typeof response.id === 'number' && id !== response.id) return;
                        if (body.method === 'eth_subscribe' && typeof response.result === 'string') subscriptions.set(response.result, {
                            onResponse: callback,
                            onError,
                            body
                        });
                        if (body.method === 'eth_unsubscribe') subscriptions.delete((_body_params = body.params) === null || _body_params === void 0 ? void 0 : _body_params[0]);
                        onResponse(response);
                    };
                    requests.set(id, {
                        onResponse: callback,
                        onError
                    });
                    try {
                        socket.request({
                            body: {
                                jsonrpc: '2.0',
                                id,
                                ...body
                            }
                        });
                    } catch (error) {
                        onError === null || onError === void 0 ? void 0 : onError(error);
                    }
                },
                requestAsync (param) {
                    let { body, timeout = 10_000 } = param;
                    return (0, withTimeout_js_1.withTimeout)(()=>new Promise((onResponse, onError)=>this.request({
                                body,
                                onError,
                                onResponse
                            })), {
                        errorInstance: new request_js_1.TimeoutError({
                            body,
                            url
                        }),
                        timeout
                    });
                },
                requests,
                subscriptions,
                url
            };
            exports.socketClientCache.set(id, socketClient);
            return [
                socketClient
            ];
        }
    });
    const [_, [socketClient_]] = await schedule();
    return socketClient_;
} //# sourceMappingURL=socket.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/webSocket.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getWebSocketRpcClient = getWebSocketRpcClient;
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const socket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/socket.js [app-client] (ecmascript)");
async function getWebSocketRpcClient(url) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { keepAlive, reconnect } = options;
    return (0, socket_js_1.getSocketRpcClient)({
        async getSocket (param) {
            let { onClose, onError, onOpen, onResponse } = param;
            const WebSocket = await Promise.resolve().then(()=>__turbopack_context__.r("[project]/node_modules/.pnpm/isows@1.0.7_ws@8.18.3_buffe_82b1f2f4f4867a5d127bd94621a34eb0/node_modules/isows/_esm/native.js [app-client] (ecmascript)")).then((module)=>module.WebSocket);
            const socket = new WebSocket(url);
            function onClose_() {
                socket.removeEventListener('close', onClose_);
                socket.removeEventListener('message', onMessage);
                socket.removeEventListener('error', onError);
                socket.removeEventListener('open', onOpen);
                onClose();
            }
            function onMessage(param) {
                let { data } = param;
                if (typeof data === 'string' && data.trim().length === 0) return;
                try {
                    const _data = JSON.parse(data);
                    onResponse(_data);
                } catch (error) {
                    onError(error);
                }
            }
            socket.addEventListener('close', onClose_);
            socket.addEventListener('message', onMessage);
            socket.addEventListener('error', onError);
            socket.addEventListener('open', onOpen);
            if (socket.readyState === WebSocket.CONNECTING) {
                await new Promise((resolve, reject)=>{
                    if (!socket) return;
                    socket.onopen = resolve;
                    socket.onerror = reject;
                });
            }
            const { close: close_ } = socket;
            return Object.assign(socket, {
                close () {
                    close_.bind(socket)();
                    onClose_();
                },
                ping () {
                    try {
                        if (socket.readyState === socket.CLOSED || socket.readyState === socket.CLOSING) throw new request_js_1.WebSocketRequestError({
                            url: socket.url,
                            cause: new request_js_1.SocketClosedError({
                                url: socket.url
                            })
                        });
                        const body = {
                            jsonrpc: '2.0',
                            id: null,
                            method: 'net_version',
                            params: []
                        };
                        socket.send(JSON.stringify(body));
                    } catch (error) {
                        onError(error);
                    }
                },
                request (param) {
                    let { body } = param;
                    if (socket.readyState === socket.CLOSED || socket.readyState === socket.CLOSING) throw new request_js_1.WebSocketRequestError({
                        body,
                        url: socket.url,
                        cause: new request_js_1.SocketClosedError({
                            url: socket.url
                        })
                    });
                    return socket.send(JSON.stringify(body));
                }
            });
        },
        keepAlive,
        reconnect,
        url
    });
} //# sourceMappingURL=webSocket.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/compat.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.rpc = void 0;
exports.getSocket = getSocket;
const http_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/http.js [app-client] (ecmascript)");
const webSocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/webSocket.js [app-client] (ecmascript)");
function webSocket(socketClient, param) {
    let { body, onError, onResponse } = param;
    socketClient.request({
        body,
        onError,
        onResponse
    });
    return socketClient;
}
async function webSocketAsync(socketClient, param) {
    let { body, timeout = 10_000 } = param;
    return socketClient.requestAsync({
        body,
        timeout
    });
}
async function getSocket(url) {
    const client = await (0, webSocket_js_1.getWebSocketRpcClient)(url);
    return Object.assign(client.socket, {
        requests: client.requests,
        subscriptions: client.subscriptions
    });
}
exports.rpc = {
    http (url, params) {
        return (0, http_js_1.getHttpRpcClient)(url).request(params);
    },
    webSocket,
    webSocketAsync
}; //# sourceMappingURL=compat.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/strings.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.presignMessagePrefix = void 0;
exports.presignMessagePrefix = '\x19Ethereum Signed Message:\n'; //# sourceMappingURL=strings.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/toPrefixedMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toPrefixedMessage = toPrefixedMessage;
const strings_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/strings.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function toPrefixedMessage(message_) {
    const message = (()=>{
        if (typeof message_ === 'string') return (0, toHex_js_1.stringToHex)(message_);
        if (typeof message_.raw === 'string') return message_.raw;
        return (0, toHex_js_1.bytesToHex)(message_.raw);
    })();
    const prefix = (0, toHex_js_1.stringToHex)("".concat(strings_js_1.presignMessagePrefix).concat((0, size_js_1.size)(message)));
    return (0, concat_js_1.concat)([
        prefix,
        message
    ]);
} //# sourceMappingURL=toPrefixedMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.hashMessage = hashMessage;
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const toPrefixedMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/toPrefixedMessage.js [app-client] (ecmascript)");
function hashMessage(message, to_) {
    return (0, keccak256_js_1.keccak256)((0, toPrefixedMessage_js_1.toPrefixedMessage)(message), to_);
} //# sourceMappingURL=hashMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/typedData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InvalidStructTypeError = exports.InvalidPrimaryTypeError = exports.InvalidDomainError = void 0;
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class InvalidDomainError extends base_js_1.BaseError {
    constructor({ domain }){
        super('Invalid domain "'.concat((0, stringify_js_1.stringify)(domain), '".'), {
            metaMessages: [
                'Must be a valid EIP-712 domain.'
            ]
        });
    }
}
exports.InvalidDomainError = InvalidDomainError;
class InvalidPrimaryTypeError extends base_js_1.BaseError {
    constructor({ primaryType, types }){
        super("Invalid primary type `".concat(primaryType, "` must be one of `").concat(JSON.stringify(Object.keys(types)), "`."), {
            docsPath: '/api/glossary/Errors#typeddatainvalidprimarytypeerror',
            metaMessages: [
                'Check that the primary type is a key in `types`.'
            ]
        });
    }
}
exports.InvalidPrimaryTypeError = InvalidPrimaryTypeError;
class InvalidStructTypeError extends base_js_1.BaseError {
    constructor({ type }){
        super('Struct type "'.concat(type, '" is invalid.'), {
            metaMessages: [
                'Struct type must not be a Solidity type.'
            ],
            name: 'InvalidStructTypeError'
        });
    }
}
exports.InvalidStructTypeError = InvalidStructTypeError; //# sourceMappingURL=typedData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/typedData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeTypedData = serializeTypedData;
exports.validateTypedData = validateTypedData;
exports.getTypesForEIP712Domain = getTypesForEIP712Domain;
exports.domainSeparator = domainSeparator;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const typedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/typedData.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const regex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/regex.js [app-client] (ecmascript)");
const hashTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashTypedData.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
function serializeTypedData(parameters) {
    const { domain: domain_, message: message_, primaryType, types } = parameters;
    const normalizeData = (struct, data_)=>{
        const data = {
            ...data_
        };
        for (const param of struct){
            const { name, type } = param;
            if (type === 'address') data[name] = data[name].toLowerCase();
        }
        return data;
    };
    const domain = (()=>{
        if (!types.EIP712Domain) return {};
        if (!domain_) return {};
        return normalizeData(types.EIP712Domain, domain_);
    })();
    const message = (()=>{
        if (primaryType === 'EIP712Domain') return undefined;
        return normalizeData(types[primaryType], message_);
    })();
    return (0, stringify_js_1.stringify)({
        domain,
        message,
        primaryType,
        types
    });
}
function validateTypedData(parameters) {
    const { domain, message, primaryType, types } = parameters;
    const validateData = (struct, data)=>{
        for (const param of struct){
            const { name, type } = param;
            const value = data[name];
            const integerMatch = type.match(regex_js_1.integerRegex);
            if (integerMatch && (typeof value === 'number' || typeof value === 'bigint')) {
                const [_type, base, size_] = integerMatch;
                (0, toHex_js_1.numberToHex)(value, {
                    signed: base === 'int',
                    size: Number.parseInt(size_, 10) / 8
                });
            }
            if (type === 'address' && typeof value === 'string' && !(0, isAddress_js_1.isAddress)(value)) throw new address_js_1.InvalidAddressError({
                address: value
            });
            const bytesMatch = type.match(regex_js_1.bytesRegex);
            if (bytesMatch) {
                const [_type, size_] = bytesMatch;
                if (size_ && (0, size_js_1.size)(value) !== Number.parseInt(size_, 10)) throw new abi_js_1.BytesSizeMismatchError({
                    expectedSize: Number.parseInt(size_, 10),
                    givenSize: (0, size_js_1.size)(value)
                });
            }
            const struct = types[type];
            if (struct) {
                validateReference(type);
                validateData(struct, value);
            }
        }
    };
    if (types.EIP712Domain && domain) {
        if (typeof domain !== 'object') throw new typedData_js_1.InvalidDomainError({
            domain
        });
        validateData(types.EIP712Domain, domain);
    }
    if (primaryType !== 'EIP712Domain') {
        if (types[primaryType]) validateData(types[primaryType], message);
        else throw new typedData_js_1.InvalidPrimaryTypeError({
            primaryType,
            types
        });
    }
}
function getTypesForEIP712Domain(param) {
    let { domain } = param;
    return [
        typeof (domain === null || domain === void 0 ? void 0 : domain.name) === 'string' && {
            name: 'name',
            type: 'string'
        },
        (domain === null || domain === void 0 ? void 0 : domain.version) && {
            name: 'version',
            type: 'string'
        },
        (typeof (domain === null || domain === void 0 ? void 0 : domain.chainId) === 'number' || typeof (domain === null || domain === void 0 ? void 0 : domain.chainId) === 'bigint') && {
            name: 'chainId',
            type: 'uint256'
        },
        (domain === null || domain === void 0 ? void 0 : domain.verifyingContract) && {
            name: 'verifyingContract',
            type: 'address'
        },
        (domain === null || domain === void 0 ? void 0 : domain.salt) && {
            name: 'salt',
            type: 'bytes32'
        }
    ].filter(Boolean);
}
function domainSeparator(param) {
    let { domain } = param;
    return (0, hashTypedData_js_1.hashDomain)({
        domain,
        types: {
            EIP712Domain: getTypesForEIP712Domain({
                domain
            })
        }
    });
}
function validateReference(type) {
    if (type === 'address' || type === 'bool' || type === 'string' || type.startsWith('bytes') || type.startsWith('uint') || type.startsWith('int')) throw new typedData_js_1.InvalidStructTypeError({
        type
    });
} //# sourceMappingURL=typedData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashTypedData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.hashTypedData = hashTypedData;
exports.hashDomain = hashDomain;
exports.hashStruct = hashStruct;
exports.encodeType = encodeType;
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const typedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/typedData.js [app-client] (ecmascript)");
function hashTypedData(parameters) {
    const { domain = {}, message, primaryType } = parameters;
    const types = {
        EIP712Domain: (0, typedData_js_1.getTypesForEIP712Domain)({
            domain
        }),
        ...parameters.types
    };
    (0, typedData_js_1.validateTypedData)({
        domain,
        message,
        primaryType,
        types
    });
    const parts = [
        '0x1901'
    ];
    if (domain) parts.push(hashDomain({
        domain,
        types: types
    }));
    if (primaryType !== 'EIP712Domain') parts.push(hashStruct({
        data: message,
        primaryType,
        types: types
    }));
    return (0, keccak256_js_1.keccak256)((0, concat_js_1.concat)(parts));
}
function hashDomain(param) {
    let { domain, types } = param;
    return hashStruct({
        data: domain,
        primaryType: 'EIP712Domain',
        types
    });
}
function hashStruct(param) {
    let { data, primaryType, types } = param;
    const encoded = encodeData({
        data,
        primaryType,
        types
    });
    return (0, keccak256_js_1.keccak256)(encoded);
}
function encodeData(param) {
    let { data, primaryType, types } = param;
    const encodedTypes = [
        {
            type: 'bytes32'
        }
    ];
    const encodedValues = [
        hashType({
            primaryType,
            types
        })
    ];
    for (const field of types[primaryType]){
        const [type, value] = encodeField({
            types,
            name: field.name,
            type: field.type,
            value: data[field.name]
        });
        encodedTypes.push(type);
        encodedValues.push(value);
    }
    return (0, encodeAbiParameters_js_1.encodeAbiParameters)(encodedTypes, encodedValues);
}
function hashType(param) {
    let { primaryType, types } = param;
    const encodedHashType = (0, toHex_js_1.toHex)(encodeType({
        primaryType,
        types
    }));
    return (0, keccak256_js_1.keccak256)(encodedHashType);
}
function encodeType(param) {
    let { primaryType, types } = param;
    let result = '';
    const unsortedDeps = findTypeDependencies({
        primaryType,
        types
    });
    unsortedDeps.delete(primaryType);
    const deps = [
        primaryType,
        ...Array.from(unsortedDeps).sort()
    ];
    for (const type of deps){
        result += "".concat(type, "(").concat(types[type].map((param)=>{
            let { name, type: t } = param;
            return "".concat(t, " ").concat(name);
        }).join(','), ")");
    }
    return result;
}
function findTypeDependencies(param) {
    let { primaryType: primaryType_, types } = param, results = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : new Set();
    const match = primaryType_.match(/^\w*/u);
    const primaryType = match === null || match === void 0 ? void 0 : match[0];
    if (results.has(primaryType) || types[primaryType] === undefined) {
        return results;
    }
    results.add(primaryType);
    for (const field of types[primaryType]){
        findTypeDependencies({
            primaryType: field.type,
            types
        }, results);
    }
    return results;
}
function encodeField(param) {
    let { types, name, type, value } = param;
    if (types[type] !== undefined) {
        return [
            {
                type: 'bytes32'
            },
            (0, keccak256_js_1.keccak256)(encodeData({
                data: value,
                primaryType: type,
                types
            }))
        ];
    }
    if (type === 'bytes') {
        const prepend = value.length % 2 ? '0' : '';
        value = "0x".concat(prepend + value.slice(2));
        return [
            {
                type: 'bytes32'
            },
            (0, keccak256_js_1.keccak256)(value)
        ];
    }
    if (type === 'string') return [
        {
            type: 'bytes32'
        },
        (0, keccak256_js_1.keccak256)((0, toHex_js_1.toHex)(value))
    ];
    if (type.lastIndexOf(']') === type.length - 1) {
        const parsedType = type.slice(0, type.lastIndexOf('['));
        const typeValuePairs = value.map((item)=>encodeField({
                name,
                type: parsedType,
                types,
                value: item
            }));
        return [
            {
                type: 'bytes32'
            },
            (0, keccak256_js_1.keccak256)((0, encodeAbiParameters_js_1.encodeAbiParameters)(typeValuePairs.map((param)=>{
                let [t] = param;
                return t;
            }), typeValuePairs.map((param)=>{
                let [, v] = param;
                return v;
            })))
        ];
    }
    return [
        {
            type
        },
        value
    ];
} //# sourceMappingURL=hashTypedData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/bytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.zeroHash = exports.erc6492MagicBytes = void 0;
exports.erc6492MagicBytes = '0x6492649264926492649264926492649264926492649264926492649264926492';
exports.zeroHash = '0x0000000000000000000000000000000000000000000000000000000000000000'; //# sourceMappingURL=bytes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/isErc6492Signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isErc6492Signature = isErc6492Signature;
const bytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/bytes.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
function isErc6492Signature(signature) {
    return (0, slice_js_1.sliceHex)(signature, -32) === bytes_js_1.erc6492MagicBytes;
} //# sourceMappingURL=isErc6492Signature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/isErc8010Signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isErc8010Signature = isErc8010Signature;
const erc8010_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/erc8010/index.js [app-client] (ecmascript)");
function isErc8010Signature(signature) {
    return erc8010_1.SignatureErc8010.validate(signature);
} //# sourceMappingURL=isErc8010Signature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/parseErc6492Signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseErc6492Signature = parseErc6492Signature;
const decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
const isErc6492Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/isErc6492Signature.js [app-client] (ecmascript)");
function parseErc6492Signature(signature) {
    if (!(0, isErc6492Signature_js_1.isErc6492Signature)(signature)) return {
        signature
    };
    const [address, data, signature_] = (0, decodeAbiParameters_js_1.decodeAbiParameters)([
        {
            type: 'address'
        },
        {
            type: 'bytes'
        },
        {
            type: 'bytes'
        }
    ], signature);
    return {
        address,
        data,
        signature: signature_
    };
} //# sourceMappingURL=parseErc6492Signature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/parseErc8010Signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseErc8010Signature = parseErc8010Signature;
const erc8010_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/erc8010/index.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const isErc8010Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/isErc8010Signature.js [app-client] (ecmascript)");
function parseErc8010Signature(signature) {
    if (!(0, isErc8010Signature_js_1.isErc8010Signature)(signature)) return {
        signature
    };
    const { authorization: authorization_ox, to, ...rest } = erc8010_1.SignatureErc8010.unwrap(signature);
    return {
        authorization: {
            address: authorization_ox.address,
            chainId: authorization_ox.chainId,
            nonce: Number(authorization_ox.nonce),
            r: (0, toHex_js_1.numberToHex)(authorization_ox.r, {
                size: 32
            }),
            s: (0, toHex_js_1.numberToHex)(authorization_ox.s, {
                size: 32
            }),
            yParity: authorization_ox.yParity
        },
        ...to ? {
            address: to
        } : {},
        ...rest
    };
} //# sourceMappingURL=parseErc8010Signature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverMessageAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverMessageAddress = recoverMessageAddress;
const hashMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashMessage.js [app-client] (ecmascript)");
const recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
async function recoverMessageAddress(param) {
    let { message, signature } = param;
    return (0, recoverAddress_js_1.recoverAddress)({
        hash: (0, hashMessage_js_1.hashMessage)(message),
        signature
    });
} //# sourceMappingURL=recoverMessageAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverTypedDataAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverTypedDataAddress = recoverTypedDataAddress;
const hashTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashTypedData.js [app-client] (ecmascript)");
const recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
async function recoverTypedDataAddress(parameters) {
    const { domain, message, primaryType, signature, types } = parameters;
    return (0, recoverAddress_js_1.recoverAddress)({
        hash: (0, hashTypedData_js_1.hashTypedData)({
            domain,
            message,
            primaryType,
            types
        }),
        signature
    });
} //# sourceMappingURL=recoverTypedDataAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeErc6492Signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeErc6492Signature = serializeErc6492Signature;
const bytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/bytes.js [app-client] (ecmascript)");
const encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
function serializeErc6492Signature(parameters) {
    const { address, data, signature, to = 'hex' } = parameters;
    const signature_ = (0, concat_js_1.concatHex)([
        (0, encodeAbiParameters_js_1.encodeAbiParameters)([
            {
                type: 'address'
            },
            {
                type: 'bytes'
            },
            {
                type: 'bytes'
            }
        ], [
            address,
            data,
            signature
        ]),
        bytes_js_1.erc6492MagicBytes
    ]);
    if (to === 'hex') return signature_;
    return (0, toBytes_js_1.hexToBytes)(signature_);
} //# sourceMappingURL=serializeErc6492Signature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeErc8010Signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeErc8010Signature = serializeErc8010Signature;
const erc8010_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/erc8010/index.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
function serializeErc8010Signature(parameters) {
    const { address, data, signature, to = 'hex' } = parameters;
    const signature_ = erc8010_1.SignatureErc8010.wrap({
        authorization: {
            address: parameters.authorization.address,
            chainId: parameters.authorization.chainId,
            nonce: BigInt(parameters.authorization.nonce),
            r: BigInt(parameters.authorization.r),
            s: BigInt(parameters.authorization.s),
            yParity: parameters.authorization.yParity
        },
        data,
        signature,
        to: address
    });
    if (to === 'hex') return signature_;
    return (0, toBytes_js_1.hexToBytes)(signature_);
} //# sourceMappingURL=serializeErc8010Signature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/verifyHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyHash = verifyHash;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
async function verifyHash(param) {
    let { address, hash, signature } = param;
    return (0, isAddressEqual_js_1.isAddressEqual)((0, getAddress_js_1.getAddress)(address), await (0, recoverAddress_js_1.recoverAddress)({
        hash,
        signature
    }));
} //# sourceMappingURL=verifyHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/verifyMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyMessage = verifyMessage;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const recoverMessageAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverMessageAddress.js [app-client] (ecmascript)");
async function verifyMessage(param) {
    let { address, message, signature } = param;
    return (0, isAddressEqual_js_1.isAddressEqual)((0, getAddress_js_1.getAddress)(address), await (0, recoverMessageAddress_js_1.recoverMessageAddress)({
        message,
        signature
    }));
} //# sourceMappingURL=verifyMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/verifyTypedData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyTypedData = verifyTypedData;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const recoverTypedDataAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverTypedDataAddress.js [app-client] (ecmascript)");
async function verifyTypedData(parameters) {
    const { address, domain, message, primaryType, signature, types } = parameters;
    return (0, isAddressEqual_js_1.isAddressEqual)((0, getAddress_js_1.getAddress)(address), await (0, recoverTypedDataAddress_js_1.recoverTypedDataAddress)({
        domain,
        message,
        primaryType,
        signature,
        types
    }));
} //# sourceMappingURL=verifyTypedData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getSerializedTransactionType.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getSerializedTransactionType = getSerializedTransactionType;
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
function getSerializedTransactionType(serializedTransaction) {
    const serializedType = (0, slice_js_1.sliceHex)(serializedTransaction, 0, 1);
    if (serializedType === '0x04') return 'eip7702';
    if (serializedType === '0x03') return 'eip4844';
    if (serializedType === '0x02') return 'eip1559';
    if (serializedType === '0x01') return 'eip2930';
    if (serializedType !== '0x' && (0, fromHex_js_1.hexToNumber)(serializedType) >= 0xc0) return 'legacy';
    throw new transaction_js_1.InvalidSerializedTransactionTypeError({
        serializedType
    });
} //# sourceMappingURL=getSerializedTransactionType.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/parseTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseTransaction = parseTransaction;
exports.toTransactionArray = toTransactionArray;
exports.parseAccessList = parseAccessList;
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/address.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const toBlobSidecars_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/toBlobSidecars.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
const trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const fromRlp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromRlp.js [app-client] (ecmascript)");
const isHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/isHash.js [app-client] (ecmascript)");
const assertTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertTransaction.js [app-client] (ecmascript)");
const getSerializedTransactionType_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getSerializedTransactionType.js [app-client] (ecmascript)");
function parseTransaction(serializedTransaction) {
    const type = (0, getSerializedTransactionType_js_1.getSerializedTransactionType)(serializedTransaction);
    if (type === 'eip1559') return parseTransactionEIP1559(serializedTransaction);
    if (type === 'eip2930') return parseTransactionEIP2930(serializedTransaction);
    if (type === 'eip4844') return parseTransactionEIP4844(serializedTransaction);
    if (type === 'eip7702') return parseTransactionEIP7702(serializedTransaction);
    return parseTransactionLegacy(serializedTransaction);
}
function parseTransactionEIP7702(serializedTransaction) {
    const transactionArray = toTransactionArray(serializedTransaction);
    const [chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gas, to, value, data, accessList, authorizationList, v, r, s] = transactionArray;
    if (transactionArray.length !== 10 && transactionArray.length !== 13) throw new transaction_js_1.InvalidSerializedTransactionError({
        attributes: {
            chainId,
            nonce,
            maxPriorityFeePerGas,
            maxFeePerGas,
            gas,
            to,
            value,
            data,
            accessList,
            authorizationList,
            ...transactionArray.length > 9 ? {
                v,
                r,
                s
            } : {}
        },
        serializedTransaction,
        type: 'eip7702'
    });
    const transaction = {
        chainId: (0, fromHex_js_1.hexToNumber)(chainId),
        type: 'eip7702'
    };
    if ((0, isHex_js_1.isHex)(to) && to !== '0x') transaction.to = to;
    if ((0, isHex_js_1.isHex)(gas) && gas !== '0x') transaction.gas = (0, fromHex_js_1.hexToBigInt)(gas);
    if ((0, isHex_js_1.isHex)(data) && data !== '0x') transaction.data = data;
    if ((0, isHex_js_1.isHex)(nonce)) transaction.nonce = nonce === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(nonce);
    if ((0, isHex_js_1.isHex)(value) && value !== '0x') transaction.value = (0, fromHex_js_1.hexToBigInt)(value);
    if ((0, isHex_js_1.isHex)(maxFeePerGas) && maxFeePerGas !== '0x') transaction.maxFeePerGas = (0, fromHex_js_1.hexToBigInt)(maxFeePerGas);
    if ((0, isHex_js_1.isHex)(maxPriorityFeePerGas) && maxPriorityFeePerGas !== '0x') transaction.maxPriorityFeePerGas = (0, fromHex_js_1.hexToBigInt)(maxPriorityFeePerGas);
    if (accessList.length !== 0 && accessList !== '0x') transaction.accessList = parseAccessList(accessList);
    if (authorizationList.length !== 0 && authorizationList !== '0x') transaction.authorizationList = parseAuthorizationList(authorizationList);
    (0, assertTransaction_js_1.assertTransactionEIP7702)(transaction);
    const signature = transactionArray.length === 13 ? parseEIP155Signature(transactionArray) : undefined;
    return {
        ...signature,
        ...transaction
    };
}
function parseTransactionEIP4844(serializedTransaction) {
    const transactionOrWrapperArray = toTransactionArray(serializedTransaction);
    const hasNetworkWrapper = transactionOrWrapperArray.length === 4;
    const transactionArray = hasNetworkWrapper ? transactionOrWrapperArray[0] : transactionOrWrapperArray;
    const wrapperArray = hasNetworkWrapper ? transactionOrWrapperArray.slice(1) : [];
    const [chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gas, to, value, data, accessList, maxFeePerBlobGas, blobVersionedHashes, v, r, s] = transactionArray;
    const [blobs, commitments, proofs] = wrapperArray;
    if (!(transactionArray.length === 11 || transactionArray.length === 14)) throw new transaction_js_1.InvalidSerializedTransactionError({
        attributes: {
            chainId,
            nonce,
            maxPriorityFeePerGas,
            maxFeePerGas,
            gas,
            to,
            value,
            data,
            accessList,
            ...transactionArray.length > 9 ? {
                v,
                r,
                s
            } : {}
        },
        serializedTransaction,
        type: 'eip4844'
    });
    const transaction = {
        blobVersionedHashes: blobVersionedHashes,
        chainId: (0, fromHex_js_1.hexToNumber)(chainId),
        to,
        type: 'eip4844'
    };
    if ((0, isHex_js_1.isHex)(gas) && gas !== '0x') transaction.gas = (0, fromHex_js_1.hexToBigInt)(gas);
    if ((0, isHex_js_1.isHex)(data) && data !== '0x') transaction.data = data;
    if ((0, isHex_js_1.isHex)(nonce)) transaction.nonce = nonce === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(nonce);
    if ((0, isHex_js_1.isHex)(value) && value !== '0x') transaction.value = (0, fromHex_js_1.hexToBigInt)(value);
    if ((0, isHex_js_1.isHex)(maxFeePerBlobGas) && maxFeePerBlobGas !== '0x') transaction.maxFeePerBlobGas = (0, fromHex_js_1.hexToBigInt)(maxFeePerBlobGas);
    if ((0, isHex_js_1.isHex)(maxFeePerGas) && maxFeePerGas !== '0x') transaction.maxFeePerGas = (0, fromHex_js_1.hexToBigInt)(maxFeePerGas);
    if ((0, isHex_js_1.isHex)(maxPriorityFeePerGas) && maxPriorityFeePerGas !== '0x') transaction.maxPriorityFeePerGas = (0, fromHex_js_1.hexToBigInt)(maxPriorityFeePerGas);
    if (accessList.length !== 0 && accessList !== '0x') transaction.accessList = parseAccessList(accessList);
    if (blobs && commitments && proofs) transaction.sidecars = (0, toBlobSidecars_js_1.toBlobSidecars)({
        blobs: blobs,
        commitments: commitments,
        proofs: proofs
    });
    (0, assertTransaction_js_1.assertTransactionEIP4844)(transaction);
    const signature = transactionArray.length === 14 ? parseEIP155Signature(transactionArray) : undefined;
    return {
        ...signature,
        ...transaction
    };
}
function parseTransactionEIP1559(serializedTransaction) {
    const transactionArray = toTransactionArray(serializedTransaction);
    const [chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gas, to, value, data, accessList, v, r, s] = transactionArray;
    if (!(transactionArray.length === 9 || transactionArray.length === 12)) throw new transaction_js_1.InvalidSerializedTransactionError({
        attributes: {
            chainId,
            nonce,
            maxPriorityFeePerGas,
            maxFeePerGas,
            gas,
            to,
            value,
            data,
            accessList,
            ...transactionArray.length > 9 ? {
                v,
                r,
                s
            } : {}
        },
        serializedTransaction,
        type: 'eip1559'
    });
    const transaction = {
        chainId: (0, fromHex_js_1.hexToNumber)(chainId),
        type: 'eip1559'
    };
    if ((0, isHex_js_1.isHex)(to) && to !== '0x') transaction.to = to;
    if ((0, isHex_js_1.isHex)(gas) && gas !== '0x') transaction.gas = (0, fromHex_js_1.hexToBigInt)(gas);
    if ((0, isHex_js_1.isHex)(data) && data !== '0x') transaction.data = data;
    if ((0, isHex_js_1.isHex)(nonce)) transaction.nonce = nonce === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(nonce);
    if ((0, isHex_js_1.isHex)(value) && value !== '0x') transaction.value = (0, fromHex_js_1.hexToBigInt)(value);
    if ((0, isHex_js_1.isHex)(maxFeePerGas) && maxFeePerGas !== '0x') transaction.maxFeePerGas = (0, fromHex_js_1.hexToBigInt)(maxFeePerGas);
    if ((0, isHex_js_1.isHex)(maxPriorityFeePerGas) && maxPriorityFeePerGas !== '0x') transaction.maxPriorityFeePerGas = (0, fromHex_js_1.hexToBigInt)(maxPriorityFeePerGas);
    if (accessList.length !== 0 && accessList !== '0x') transaction.accessList = parseAccessList(accessList);
    (0, assertTransaction_js_1.assertTransactionEIP1559)(transaction);
    const signature = transactionArray.length === 12 ? parseEIP155Signature(transactionArray) : undefined;
    return {
        ...signature,
        ...transaction
    };
}
function parseTransactionEIP2930(serializedTransaction) {
    const transactionArray = toTransactionArray(serializedTransaction);
    const [chainId, nonce, gasPrice, gas, to, value, data, accessList, v, r, s] = transactionArray;
    if (!(transactionArray.length === 8 || transactionArray.length === 11)) throw new transaction_js_1.InvalidSerializedTransactionError({
        attributes: {
            chainId,
            nonce,
            gasPrice,
            gas,
            to,
            value,
            data,
            accessList,
            ...transactionArray.length > 8 ? {
                v,
                r,
                s
            } : {}
        },
        serializedTransaction,
        type: 'eip2930'
    });
    const transaction = {
        chainId: (0, fromHex_js_1.hexToNumber)(chainId),
        type: 'eip2930'
    };
    if ((0, isHex_js_1.isHex)(to) && to !== '0x') transaction.to = to;
    if ((0, isHex_js_1.isHex)(gas) && gas !== '0x') transaction.gas = (0, fromHex_js_1.hexToBigInt)(gas);
    if ((0, isHex_js_1.isHex)(data) && data !== '0x') transaction.data = data;
    if ((0, isHex_js_1.isHex)(nonce)) transaction.nonce = nonce === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(nonce);
    if ((0, isHex_js_1.isHex)(value) && value !== '0x') transaction.value = (0, fromHex_js_1.hexToBigInt)(value);
    if ((0, isHex_js_1.isHex)(gasPrice) && gasPrice !== '0x') transaction.gasPrice = (0, fromHex_js_1.hexToBigInt)(gasPrice);
    if (accessList.length !== 0 && accessList !== '0x') transaction.accessList = parseAccessList(accessList);
    (0, assertTransaction_js_1.assertTransactionEIP2930)(transaction);
    const signature = transactionArray.length === 11 ? parseEIP155Signature(transactionArray) : undefined;
    return {
        ...signature,
        ...transaction
    };
}
function parseTransactionLegacy(serializedTransaction) {
    const transactionArray = (0, fromRlp_js_1.fromRlp)(serializedTransaction, 'hex');
    const [nonce, gasPrice, gas, to, value, data, chainIdOrV_, r, s] = transactionArray;
    if (!(transactionArray.length === 6 || transactionArray.length === 9)) throw new transaction_js_1.InvalidSerializedTransactionError({
        attributes: {
            nonce,
            gasPrice,
            gas,
            to,
            value,
            data,
            ...transactionArray.length > 6 ? {
                v: chainIdOrV_,
                r,
                s
            } : {}
        },
        serializedTransaction,
        type: 'legacy'
    });
    const transaction = {
        type: 'legacy'
    };
    if ((0, isHex_js_1.isHex)(to) && to !== '0x') transaction.to = to;
    if ((0, isHex_js_1.isHex)(gas) && gas !== '0x') transaction.gas = (0, fromHex_js_1.hexToBigInt)(gas);
    if ((0, isHex_js_1.isHex)(data) && data !== '0x') transaction.data = data;
    if ((0, isHex_js_1.isHex)(nonce)) transaction.nonce = nonce === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(nonce);
    if ((0, isHex_js_1.isHex)(value) && value !== '0x') transaction.value = (0, fromHex_js_1.hexToBigInt)(value);
    if ((0, isHex_js_1.isHex)(gasPrice) && gasPrice !== '0x') transaction.gasPrice = (0, fromHex_js_1.hexToBigInt)(gasPrice);
    (0, assertTransaction_js_1.assertTransactionLegacy)(transaction);
    if (transactionArray.length === 6) return transaction;
    const chainIdOrV = (0, isHex_js_1.isHex)(chainIdOrV_) && chainIdOrV_ !== '0x' ? (0, fromHex_js_1.hexToBigInt)(chainIdOrV_) : 0n;
    if (s === '0x' && r === '0x') {
        if (chainIdOrV > 0) transaction.chainId = Number(chainIdOrV);
        return transaction;
    }
    const v = chainIdOrV;
    const chainId = Number((v - 35n) / 2n);
    if (chainId > 0) transaction.chainId = chainId;
    else if (v !== 27n && v !== 28n) throw new transaction_js_1.InvalidLegacyVError({
        v
    });
    transaction.v = v;
    transaction.s = s;
    transaction.r = r;
    transaction.yParity = v % 2n === 0n ? 1 : 0;
    return transaction;
}
function toTransactionArray(serializedTransaction) {
    return (0, fromRlp_js_1.fromRlp)("0x".concat(serializedTransaction.slice(4)), 'hex');
}
function parseAccessList(accessList_) {
    const accessList = [];
    for(let i = 0; i < accessList_.length; i++){
        const [address, storageKeys] = accessList_[i];
        if (!(0, isAddress_js_1.isAddress)(address, {
            strict: false
        })) throw new address_js_1.InvalidAddressError({
            address
        });
        accessList.push({
            address: address,
            storageKeys: storageKeys.map((key)=>(0, isHash_js_1.isHash)(key) ? key : (0, trim_js_1.trim)(key))
        });
    }
    return accessList;
}
function parseAuthorizationList(serializedAuthorizationList) {
    const authorizationList = [];
    for(let i = 0; i < serializedAuthorizationList.length; i++){
        const [chainId, address, nonce, yParity, r, s] = serializedAuthorizationList[i];
        authorizationList.push({
            address,
            chainId: chainId === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(chainId),
            nonce: nonce === '0x' ? 0 : (0, fromHex_js_1.hexToNumber)(nonce),
            ...parseEIP155Signature([
                yParity,
                r,
                s
            ])
        });
    }
    return authorizationList;
}
function parseEIP155Signature(transactionArray) {
    const signature = transactionArray.slice(-3);
    const v = signature[0] === '0x' || (0, fromHex_js_1.hexToBigInt)(signature[0]) === 0n ? 27n : 28n;
    return {
        r: (0, pad_js_1.padHex)(signature[1], {
            size: 32
        }),
        s: (0, pad_js_1.padHex)(signature[2], {
            size: 32
        }),
        v,
        yParity: v === 27n ? 0 : 1
    };
} //# sourceMappingURL=parseTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/unit.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InvalidDecimalNumberError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class InvalidDecimalNumberError extends base_js_1.BaseError {
    constructor({ value }){
        super("Number `".concat(value, "` is not a valid decimal number."), {
            name: 'InvalidDecimalNumberError'
        });
    }
}
exports.InvalidDecimalNumberError = InvalidDecimalNumberError; //# sourceMappingURL=unit.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseUnits.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseUnits = parseUnits;
const unit_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/unit.js [app-client] (ecmascript)");
function parseUnits(value, decimals) {
    if (!/^(-?)([0-9]*)\.?([0-9]*)$/.test(value)) throw new unit_js_1.InvalidDecimalNumberError({
        value
    });
    let [integer, fraction = '0'] = value.split('.');
    const negative = integer.startsWith('-');
    if (negative) integer = integer.slice(1);
    fraction = fraction.replace(/(0+)$/, '');
    if (decimals === 0) {
        if (Math.round(Number(".".concat(fraction))) === 1) integer = "".concat(BigInt(integer) + 1n);
        fraction = '';
    } else if (fraction.length > decimals) {
        const [left, unit, right] = [
            fraction.slice(0, decimals - 1),
            fraction.slice(decimals - 1, decimals),
            fraction.slice(decimals)
        ];
        const rounded = Math.round(Number("".concat(unit, ".").concat(right)));
        if (rounded > 9) fraction = "".concat(BigInt(left) + BigInt(1), "0").padStart(left.length + 1, '0');
        else fraction = "".concat(left).concat(rounded);
        if (fraction.length > decimals) {
            fraction = fraction.slice(1);
            integer = "".concat(BigInt(integer) + 1n);
        }
        fraction = fraction.slice(0, decimals);
    } else {
        fraction = fraction.padEnd(decimals, '0');
    }
    return BigInt("".concat(negative ? '-' : '').concat(integer).concat(fraction));
} //# sourceMappingURL=parseUnits.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseEther.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseEther = parseEther;
const unit_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/unit.js [app-client] (ecmascript)");
const parseUnits_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseUnits.js [app-client] (ecmascript)");
function parseEther(ether) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return (0, parseUnits_js_1.parseUnits)(ether, unit_js_1.etherUnits[unit]);
} //# sourceMappingURL=parseEther.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseGwei.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseGwei = parseGwei;
const unit_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/unit.js [app-client] (ecmascript)");
const parseUnits_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseUnits.js [app-client] (ecmascript)");
function parseGwei(ether) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return (0, parseUnits_js_1.parseUnits)(ether, unit_js_1.gweiUnits[unit]);
} //# sourceMappingURL=parseGwei.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.padBytes = exports.pad = exports.isHex = exports.isBytes = exports.concatHex = exports.concatBytes = exports.concat = exports.getChainContractAddress = exports.extractChain = exports.defineChain = exports.assertCurrentChain = exports.offchainLookupSignature = exports.offchainLookupAbiItem = exports.offchainLookup = exports.ccipFetch = exports.ccipRequest = exports.buildRequest = exports.verifyAuthorization = exports.serializeAuthorizationList = exports.recoverAuthorizationAddress = exports.hashAuthorization = exports.isAddressEqual = exports.isAddress = exports.getCreateAddress = exports.getCreate2Address = exports.getContractAddress = exports.getAddress = exports.parseEventLogs = exports.getAbiItem = exports.formatAbiItemWithArgs = exports.formatAbiParams = exports.formatAbiItem = exports.encodePacked = exports.encodeFunctionResult = exports.encodeFunctionData = exports.encodeEventTopics = exports.encodeErrorResult = exports.encodeDeployData = exports.encodeAbiParameters = exports.decodeFunctionResult = exports.decodeFunctionData = exports.decodeEventLog = exports.decodeErrorResult = exports.decodeAbiParameters = exports.publicKeyToAddress = exports.parseAccount = exports.parseAbiParameters = exports.parseAbiParameter = exports.parseAbiItem = exports.parseAbi = void 0;
exports.ripemd160 = exports.keccak256 = exports.isHash = exports.getAction = exports.formatTransactionRequest = exports.defineTransactionRequest = exports.defineTransactionReceipt = exports.transactionType = exports.formatTransaction = exports.defineTransaction = exports.formatLog = exports.defineFormatter = exports.extract = exports.formatBlock = exports.defineBlock = exports.getTransactionError = exports.getNodeError = exports.containsNodeError = exports.getEstimateGasError = exports.getContractError = exports.getCallError = exports.toRlp = exports.toHex = exports.stringToHex = exports.numberToHex = exports.bytesToHex = exports.boolToHex = exports.toBytes = exports.stringToBytes = exports.numberToBytes = exports.hexToBytes = exports.boolToBytes = exports.fromRlp = exports.hexToString = exports.hexToNumber = exports.hexToBool = exports.hexToBigInt = exports.fromHex = exports.fromBytes = exports.bytesToString = exports.bytesToNumber = exports.bytesToBool = exports.bytesToBigint = exports.bytesToBigInt = exports.trim = exports.sliceHex = exports.sliceBytes = exports.slice = exports.size = exports.padHex = void 0;
exports.validateTypedData = exports.serializeTypedData = exports.serializeTransaction = exports.serializeAccessList = exports.parseTransaction = exports.getTransactionType = exports.getSerializedTransactionType = exports.assertTransactionLegacy = exports.assertTransactionEIP2930 = exports.assertTransactionEIP1559 = exports.assertRequest = exports.stringify = exports.verifyTypedData = exports.verifyMessage = exports.verifyHash = exports.serializeErc8010Signature = exports.serializeErc6492Signature = exports.recoverTypedDataAddress = exports.recoverPublicKey = exports.recoverMessageAddress = exports.recoverAddress = exports.parseErc8010Signature = exports.parseErc6492Signature = exports.isErc8010Signature = exports.isErc6492Signature = exports.hashTypedData = exports.hashStruct = exports.hashMessage = exports.getWebSocketRpcClient = exports.socketClientCache = exports.getSocketRpcClient = exports.getHttpRpcClient = exports.rpc = exports.getSocket = exports.integerRegex = exports.bytesRegex = exports.arrayRegex = exports.nonceManager = exports.createNonceManager = exports.getFunctionSignature = exports.toFunctionSignature = exports.getFunctionSelector = exports.toFunctionSelector = exports.toFunctionHash = exports.getEventSignature = exports.toEventSignature = exports.getEventSelector = exports.toEventSelector = exports.toEventHash = exports.sha256 = void 0;
exports.parseUnits = exports.parseGwei = exports.parseEther = exports.formatUnits = exports.formatGwei = exports.formatEther = void 0;
var abitype_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/cjs/exports/index.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseAbi", {
    enumerable: true,
    get: function() {
        return abitype_1.parseAbi;
    }
});
Object.defineProperty(exports, "parseAbiItem", {
    enumerable: true,
    get: function() {
        return abitype_1.parseAbiItem;
    }
});
Object.defineProperty(exports, "parseAbiParameter", {
    enumerable: true,
    get: function() {
        return abitype_1.parseAbiParameter;
    }
});
Object.defineProperty(exports, "parseAbiParameters", {
    enumerable: true,
    get: function() {
        return abitype_1.parseAbiParameters;
    }
});
var parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseAccount", {
    enumerable: true,
    get: function() {
        return parseAccount_js_1.parseAccount;
    }
});
var publicKeyToAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/publicKeyToAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "publicKeyToAddress", {
    enumerable: true,
    get: function() {
        return publicKeyToAddress_js_1.publicKeyToAddress;
    }
});
var decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeAbiParameters", {
    enumerable: true,
    get: function() {
        return decodeAbiParameters_js_1.decodeAbiParameters;
    }
});
var decodeErrorResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeErrorResult.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeErrorResult", {
    enumerable: true,
    get: function() {
        return decodeErrorResult_js_1.decodeErrorResult;
    }
});
var decodeEventLog_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeEventLog.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeEventLog", {
    enumerable: true,
    get: function() {
        return decodeEventLog_js_1.decodeEventLog;
    }
});
var decodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionData.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeFunctionData", {
    enumerable: true,
    get: function() {
        return decodeFunctionData_js_1.decodeFunctionData;
    }
});
var decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeFunctionResult", {
    enumerable: true,
    get: function() {
        return decodeFunctionResult_js_1.decodeFunctionResult;
    }
});
var encodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeAbiParameters", {
    enumerable: true,
    get: function() {
        return encodeAbiParameters_js_1.encodeAbiParameters;
    }
});
var encodeDeployData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeDeployData.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeDeployData", {
    enumerable: true,
    get: function() {
        return encodeDeployData_js_1.encodeDeployData;
    }
});
var encodeErrorResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeErrorResult.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeErrorResult", {
    enumerable: true,
    get: function() {
        return encodeErrorResult_js_1.encodeErrorResult;
    }
});
var encodeEventTopics_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeEventTopics", {
    enumerable: true,
    get: function() {
        return encodeEventTopics_js_1.encodeEventTopics;
    }
});
var encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeFunctionData", {
    enumerable: true,
    get: function() {
        return encodeFunctionData_js_1.encodeFunctionData;
    }
});
var encodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionResult.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeFunctionResult", {
    enumerable: true,
    get: function() {
        return encodeFunctionResult_js_1.encodeFunctionResult;
    }
});
var encodePacked_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodePacked.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodePacked", {
    enumerable: true,
    get: function() {
        return encodePacked_js_1.encodePacked;
    }
});
var formatAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItem.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatAbiItem", {
    enumerable: true,
    get: function() {
        return formatAbiItem_js_1.formatAbiItem;
    }
});
Object.defineProperty(exports, "formatAbiParams", {
    enumerable: true,
    get: function() {
        return formatAbiItem_js_1.formatAbiParams;
    }
});
var formatAbiItemWithArgs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/formatAbiItemWithArgs.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatAbiItemWithArgs", {
    enumerable: true,
    get: function() {
        return formatAbiItemWithArgs_js_1.formatAbiItemWithArgs;
    }
});
var getAbiItem_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/getAbiItem.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getAbiItem", {
    enumerable: true,
    get: function() {
        return getAbiItem_js_1.getAbiItem;
    }
});
var parseEventLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/parseEventLogs.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseEventLogs", {
    enumerable: true,
    get: function() {
        return parseEventLogs_js_1.parseEventLogs;
    }
});
var getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getAddress", {
    enumerable: true,
    get: function() {
        return getAddress_js_1.getAddress;
    }
});
var getContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getContractAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getContractAddress", {
    enumerable: true,
    get: function() {
        return getContractAddress_js_1.getContractAddress;
    }
});
Object.defineProperty(exports, "getCreate2Address", {
    enumerable: true,
    get: function() {
        return getContractAddress_js_1.getCreate2Address;
    }
});
Object.defineProperty(exports, "getCreateAddress", {
    enumerable: true,
    get: function() {
        return getContractAddress_js_1.getCreateAddress;
    }
});
var isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isAddress", {
    enumerable: true,
    get: function() {
        return isAddress_js_1.isAddress;
    }
});
var isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isAddressEqual", {
    enumerable: true,
    get: function() {
        return isAddressEqual_js_1.isAddressEqual;
    }
});
var hashAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/hashAuthorization.js [app-client] (ecmascript)");
Object.defineProperty(exports, "hashAuthorization", {
    enumerable: true,
    get: function() {
        return hashAuthorization_js_1.hashAuthorization;
    }
});
var recoverAuthorizationAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/recoverAuthorizationAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "recoverAuthorizationAddress", {
    enumerable: true,
    get: function() {
        return recoverAuthorizationAddress_js_1.recoverAuthorizationAddress;
    }
});
var serializeAuthorizationList_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/serializeAuthorizationList.js [app-client] (ecmascript)");
Object.defineProperty(exports, "serializeAuthorizationList", {
    enumerable: true,
    get: function() {
        return serializeAuthorizationList_js_1.serializeAuthorizationList;
    }
});
var verifyAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/verifyAuthorization.js [app-client] (ecmascript)");
Object.defineProperty(exports, "verifyAuthorization", {
    enumerable: true,
    get: function() {
        return verifyAuthorization_js_1.verifyAuthorization;
    }
});
var buildRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/buildRequest.js [app-client] (ecmascript)");
Object.defineProperty(exports, "buildRequest", {
    enumerable: true,
    get: function() {
        return buildRequest_js_1.buildRequest;
    }
});
var ccip_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ccip.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ccipRequest", {
    enumerable: true,
    get: function() {
        return ccip_js_1.ccipRequest;
    }
});
Object.defineProperty(exports, "ccipFetch", {
    enumerable: true,
    get: function() {
        return ccip_js_1.ccipRequest;
    }
});
Object.defineProperty(exports, "offchainLookup", {
    enumerable: true,
    get: function() {
        return ccip_js_1.offchainLookup;
    }
});
Object.defineProperty(exports, "offchainLookupAbiItem", {
    enumerable: true,
    get: function() {
        return ccip_js_1.offchainLookupAbiItem;
    }
});
Object.defineProperty(exports, "offchainLookupSignature", {
    enumerable: true,
    get: function() {
        return ccip_js_1.offchainLookupSignature;
    }
});
var assertCurrentChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/assertCurrentChain.js [app-client] (ecmascript)");
Object.defineProperty(exports, "assertCurrentChain", {
    enumerable: true,
    get: function() {
        return assertCurrentChain_js_1.assertCurrentChain;
    }
});
var defineChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/defineChain.js [app-client] (ecmascript)");
Object.defineProperty(exports, "defineChain", {
    enumerable: true,
    get: function() {
        return defineChain_js_1.defineChain;
    }
});
var extractChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/extractChain.js [app-client] (ecmascript)");
Object.defineProperty(exports, "extractChain", {
    enumerable: true,
    get: function() {
        return extractChain_js_1.extractChain;
    }
});
var getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getChainContractAddress", {
    enumerable: true,
    get: function() {
        return getChainContractAddress_js_1.getChainContractAddress;
    }
});
var concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
Object.defineProperty(exports, "concat", {
    enumerable: true,
    get: function() {
        return concat_js_1.concat;
    }
});
Object.defineProperty(exports, "concatBytes", {
    enumerable: true,
    get: function() {
        return concat_js_1.concatBytes;
    }
});
Object.defineProperty(exports, "concatHex", {
    enumerable: true,
    get: function() {
        return concat_js_1.concatHex;
    }
});
var isBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isBytes.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isBytes", {
    enumerable: true,
    get: function() {
        return isBytes_js_1.isBytes;
    }
});
var isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isHex", {
    enumerable: true,
    get: function() {
        return isHex_js_1.isHex;
    }
});
var pad_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/pad.js [app-client] (ecmascript)");
Object.defineProperty(exports, "pad", {
    enumerable: true,
    get: function() {
        return pad_js_1.pad;
    }
});
Object.defineProperty(exports, "padBytes", {
    enumerable: true,
    get: function() {
        return pad_js_1.padBytes;
    }
});
Object.defineProperty(exports, "padHex", {
    enumerable: true,
    get: function() {
        return pad_js_1.padHex;
    }
});
var size_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/size.js [app-client] (ecmascript)");
Object.defineProperty(exports, "size", {
    enumerable: true,
    get: function() {
        return size_js_1.size;
    }
});
var slice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/slice.js [app-client] (ecmascript)");
Object.defineProperty(exports, "slice", {
    enumerable: true,
    get: function() {
        return slice_js_1.slice;
    }
});
Object.defineProperty(exports, "sliceBytes", {
    enumerable: true,
    get: function() {
        return slice_js_1.sliceBytes;
    }
});
Object.defineProperty(exports, "sliceHex", {
    enumerable: true,
    get: function() {
        return slice_js_1.sliceHex;
    }
});
var trim_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/trim.js [app-client] (ecmascript)");
Object.defineProperty(exports, "trim", {
    enumerable: true,
    get: function() {
        return trim_js_1.trim;
    }
});
var fromBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromBytes.js [app-client] (ecmascript)");
Object.defineProperty(exports, "bytesToBigInt", {
    enumerable: true,
    get: function() {
        return fromBytes_js_1.bytesToBigInt;
    }
});
Object.defineProperty(exports, "bytesToBigint", {
    enumerable: true,
    get: function() {
        return fromBytes_js_1.bytesToBigInt;
    }
});
Object.defineProperty(exports, "bytesToBool", {
    enumerable: true,
    get: function() {
        return fromBytes_js_1.bytesToBool;
    }
});
Object.defineProperty(exports, "bytesToNumber", {
    enumerable: true,
    get: function() {
        return fromBytes_js_1.bytesToNumber;
    }
});
Object.defineProperty(exports, "bytesToString", {
    enumerable: true,
    get: function() {
        return fromBytes_js_1.bytesToString;
    }
});
Object.defineProperty(exports, "fromBytes", {
    enumerable: true,
    get: function() {
        return fromBytes_js_1.fromBytes;
    }
});
var fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
Object.defineProperty(exports, "fromHex", {
    enumerable: true,
    get: function() {
        return fromHex_js_1.fromHex;
    }
});
Object.defineProperty(exports, "hexToBigInt", {
    enumerable: true,
    get: function() {
        return fromHex_js_1.hexToBigInt;
    }
});
Object.defineProperty(exports, "hexToBool", {
    enumerable: true,
    get: function() {
        return fromHex_js_1.hexToBool;
    }
});
Object.defineProperty(exports, "hexToNumber", {
    enumerable: true,
    get: function() {
        return fromHex_js_1.hexToNumber;
    }
});
Object.defineProperty(exports, "hexToString", {
    enumerable: true,
    get: function() {
        return fromHex_js_1.hexToString;
    }
});
var fromRlp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromRlp.js [app-client] (ecmascript)");
Object.defineProperty(exports, "fromRlp", {
    enumerable: true,
    get: function() {
        return fromRlp_js_1.fromRlp;
    }
});
var toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
Object.defineProperty(exports, "boolToBytes", {
    enumerable: true,
    get: function() {
        return toBytes_js_1.boolToBytes;
    }
});
Object.defineProperty(exports, "hexToBytes", {
    enumerable: true,
    get: function() {
        return toBytes_js_1.hexToBytes;
    }
});
Object.defineProperty(exports, "numberToBytes", {
    enumerable: true,
    get: function() {
        return toBytes_js_1.numberToBytes;
    }
});
Object.defineProperty(exports, "stringToBytes", {
    enumerable: true,
    get: function() {
        return toBytes_js_1.stringToBytes;
    }
});
Object.defineProperty(exports, "toBytes", {
    enumerable: true,
    get: function() {
        return toBytes_js_1.toBytes;
    }
});
var toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
Object.defineProperty(exports, "boolToHex", {
    enumerable: true,
    get: function() {
        return toHex_js_1.boolToHex;
    }
});
Object.defineProperty(exports, "bytesToHex", {
    enumerable: true,
    get: function() {
        return toHex_js_1.bytesToHex;
    }
});
Object.defineProperty(exports, "numberToHex", {
    enumerable: true,
    get: function() {
        return toHex_js_1.numberToHex;
    }
});
Object.defineProperty(exports, "stringToHex", {
    enumerable: true,
    get: function() {
        return toHex_js_1.stringToHex;
    }
});
Object.defineProperty(exports, "toHex", {
    enumerable: true,
    get: function() {
        return toHex_js_1.toHex;
    }
});
var toRlp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toRlp.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toRlp", {
    enumerable: true,
    get: function() {
        return toRlp_js_1.toRlp;
    }
});
var getCallError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getCallError.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getCallError", {
    enumerable: true,
    get: function() {
        return getCallError_js_1.getCallError;
    }
});
var getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getContractError", {
    enumerable: true,
    get: function() {
        return getContractError_js_1.getContractError;
    }
});
var getEstimateGasError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getEstimateGasError.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getEstimateGasError", {
    enumerable: true,
    get: function() {
        return getEstimateGasError_js_1.getEstimateGasError;
    }
});
var getNodeError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getNodeError.js [app-client] (ecmascript)");
Object.defineProperty(exports, "containsNodeError", {
    enumerable: true,
    get: function() {
        return getNodeError_js_1.containsNodeError;
    }
});
Object.defineProperty(exports, "getNodeError", {
    enumerable: true,
    get: function() {
        return getNodeError_js_1.getNodeError;
    }
});
var getTransactionError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getTransactionError.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getTransactionError", {
    enumerable: true,
    get: function() {
        return getTransactionError_js_1.getTransactionError;
    }
});
var block_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/block.js [app-client] (ecmascript)");
Object.defineProperty(exports, "defineBlock", {
    enumerable: true,
    get: function() {
        return block_js_1.defineBlock;
    }
});
Object.defineProperty(exports, "formatBlock", {
    enumerable: true,
    get: function() {
        return block_js_1.formatBlock;
    }
});
var extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
Object.defineProperty(exports, "extract", {
    enumerable: true,
    get: function() {
        return extract_js_1.extract;
    }
});
var formatter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/formatter.js [app-client] (ecmascript)");
Object.defineProperty(exports, "defineFormatter", {
    enumerable: true,
    get: function() {
        return formatter_js_1.defineFormatter;
    }
});
var log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatLog", {
    enumerable: true,
    get: function() {
        return log_js_1.formatLog;
    }
});
var transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transaction.js [app-client] (ecmascript)");
Object.defineProperty(exports, "defineTransaction", {
    enumerable: true,
    get: function() {
        return transaction_js_1.defineTransaction;
    }
});
Object.defineProperty(exports, "formatTransaction", {
    enumerable: true,
    get: function() {
        return transaction_js_1.formatTransaction;
    }
});
Object.defineProperty(exports, "transactionType", {
    enumerable: true,
    get: function() {
        return transaction_js_1.transactionType;
    }
});
var transactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionReceipt.js [app-client] (ecmascript)");
Object.defineProperty(exports, "defineTransactionReceipt", {
    enumerable: true,
    get: function() {
        return transactionReceipt_js_1.defineTransactionReceipt;
    }
});
var transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
Object.defineProperty(exports, "defineTransactionRequest", {
    enumerable: true,
    get: function() {
        return transactionRequest_js_1.defineTransactionRequest;
    }
});
Object.defineProperty(exports, "formatTransactionRequest", {
    enumerable: true,
    get: function() {
        return transactionRequest_js_1.formatTransactionRequest;
    }
});
var getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getAction", {
    enumerable: true,
    get: function() {
        return getAction_js_1.getAction;
    }
});
var isHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/isHash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isHash", {
    enumerable: true,
    get: function() {
        return isHash_js_1.isHash;
    }
});
var keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
Object.defineProperty(exports, "keccak256", {
    enumerable: true,
    get: function() {
        return keccak256_js_1.keccak256;
    }
});
var ripemd160_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/ripemd160.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ripemd160", {
    enumerable: true,
    get: function() {
        return ripemd160_js_1.ripemd160;
    }
});
var sha256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/sha256.js [app-client] (ecmascript)");
Object.defineProperty(exports, "sha256", {
    enumerable: true,
    get: function() {
        return sha256_js_1.sha256;
    }
});
var toEventHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventHash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toEventHash", {
    enumerable: true,
    get: function() {
        return toEventHash_js_1.toEventHash;
    }
});
var toEventSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSelector.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toEventSelector", {
    enumerable: true,
    get: function() {
        return toEventSelector_js_1.toEventSelector;
    }
});
Object.defineProperty(exports, "getEventSelector", {
    enumerable: true,
    get: function() {
        return toEventSelector_js_1.toEventSelector;
    }
});
var toEventSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toEventSignature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toEventSignature", {
    enumerable: true,
    get: function() {
        return toEventSignature_js_1.toEventSignature;
    }
});
Object.defineProperty(exports, "getEventSignature", {
    enumerable: true,
    get: function() {
        return toEventSignature_js_1.toEventSignature;
    }
});
var toFunctionHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionHash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toFunctionHash", {
    enumerable: true,
    get: function() {
        return toFunctionHash_js_1.toFunctionHash;
    }
});
var toFunctionSelector_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSelector.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toFunctionSelector", {
    enumerable: true,
    get: function() {
        return toFunctionSelector_js_1.toFunctionSelector;
    }
});
Object.defineProperty(exports, "getFunctionSelector", {
    enumerable: true,
    get: function() {
        return toFunctionSelector_js_1.toFunctionSelector;
    }
});
var toFunctionSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/toFunctionSignature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toFunctionSignature", {
    enumerable: true,
    get: function() {
        return toFunctionSignature_js_1.toFunctionSignature;
    }
});
Object.defineProperty(exports, "getFunctionSignature", {
    enumerable: true,
    get: function() {
        return toFunctionSignature_js_1.toFunctionSignature;
    }
});
var nonceManager_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/nonceManager.js [app-client] (ecmascript)");
Object.defineProperty(exports, "createNonceManager", {
    enumerable: true,
    get: function() {
        return nonceManager_js_1.createNonceManager;
    }
});
Object.defineProperty(exports, "nonceManager", {
    enumerable: true,
    get: function() {
        return nonceManager_js_1.nonceManager;
    }
});
var regex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/regex.js [app-client] (ecmascript)");
Object.defineProperty(exports, "arrayRegex", {
    enumerable: true,
    get: function() {
        return regex_js_1.arrayRegex;
    }
});
Object.defineProperty(exports, "bytesRegex", {
    enumerable: true,
    get: function() {
        return regex_js_1.bytesRegex;
    }
});
Object.defineProperty(exports, "integerRegex", {
    enumerable: true,
    get: function() {
        return regex_js_1.integerRegex;
    }
});
var compat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/compat.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getSocket", {
    enumerable: true,
    get: function() {
        return compat_js_1.getSocket;
    }
});
Object.defineProperty(exports, "rpc", {
    enumerable: true,
    get: function() {
        return compat_js_1.rpc;
    }
});
var http_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/http.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getHttpRpcClient", {
    enumerable: true,
    get: function() {
        return http_js_1.getHttpRpcClient;
    }
});
var socket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/socket.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getSocketRpcClient", {
    enumerable: true,
    get: function() {
        return socket_js_1.getSocketRpcClient;
    }
});
Object.defineProperty(exports, "socketClientCache", {
    enumerable: true,
    get: function() {
        return socket_js_1.socketClientCache;
    }
});
var webSocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/webSocket.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getWebSocketRpcClient", {
    enumerable: true,
    get: function() {
        return webSocket_js_1.getWebSocketRpcClient;
    }
});
var hashMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashMessage.js [app-client] (ecmascript)");
Object.defineProperty(exports, "hashMessage", {
    enumerable: true,
    get: function() {
        return hashMessage_js_1.hashMessage;
    }
});
var hashTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashTypedData.js [app-client] (ecmascript)");
Object.defineProperty(exports, "hashStruct", {
    enumerable: true,
    get: function() {
        return hashTypedData_js_1.hashStruct;
    }
});
Object.defineProperty(exports, "hashTypedData", {
    enumerable: true,
    get: function() {
        return hashTypedData_js_1.hashTypedData;
    }
});
var isErc6492Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/isErc6492Signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isErc6492Signature", {
    enumerable: true,
    get: function() {
        return isErc6492Signature_js_1.isErc6492Signature;
    }
});
var isErc8010Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/isErc8010Signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isErc8010Signature", {
    enumerable: true,
    get: function() {
        return isErc8010Signature_js_1.isErc8010Signature;
    }
});
var parseErc6492Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/parseErc6492Signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseErc6492Signature", {
    enumerable: true,
    get: function() {
        return parseErc6492Signature_js_1.parseErc6492Signature;
    }
});
var parseErc8010Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/parseErc8010Signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseErc8010Signature", {
    enumerable: true,
    get: function() {
        return parseErc8010Signature_js_1.parseErc8010Signature;
    }
});
var recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "recoverAddress", {
    enumerable: true,
    get: function() {
        return recoverAddress_js_1.recoverAddress;
    }
});
var recoverMessageAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverMessageAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "recoverMessageAddress", {
    enumerable: true,
    get: function() {
        return recoverMessageAddress_js_1.recoverMessageAddress;
    }
});
var recoverPublicKey_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverPublicKey.js [app-client] (ecmascript)");
Object.defineProperty(exports, "recoverPublicKey", {
    enumerable: true,
    get: function() {
        return recoverPublicKey_js_1.recoverPublicKey;
    }
});
var recoverTypedDataAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverTypedDataAddress.js [app-client] (ecmascript)");
Object.defineProperty(exports, "recoverTypedDataAddress", {
    enumerable: true,
    get: function() {
        return recoverTypedDataAddress_js_1.recoverTypedDataAddress;
    }
});
var serializeErc6492Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeErc6492Signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "serializeErc6492Signature", {
    enumerable: true,
    get: function() {
        return serializeErc6492Signature_js_1.serializeErc6492Signature;
    }
});
var serializeErc8010Signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeErc8010Signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "serializeErc8010Signature", {
    enumerable: true,
    get: function() {
        return serializeErc8010Signature_js_1.serializeErc8010Signature;
    }
});
var verifyHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/verifyHash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "verifyHash", {
    enumerable: true,
    get: function() {
        return verifyHash_js_1.verifyHash;
    }
});
var verifyMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/verifyMessage.js [app-client] (ecmascript)");
Object.defineProperty(exports, "verifyMessage", {
    enumerable: true,
    get: function() {
        return verifyMessage_js_1.verifyMessage;
    }
});
var verifyTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/verifyTypedData.js [app-client] (ecmascript)");
Object.defineProperty(exports, "verifyTypedData", {
    enumerable: true,
    get: function() {
        return verifyTypedData_js_1.verifyTypedData;
    }
});
var stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
Object.defineProperty(exports, "stringify", {
    enumerable: true,
    get: function() {
        return stringify_js_1.stringify;
    }
});
var assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
Object.defineProperty(exports, "assertRequest", {
    enumerable: true,
    get: function() {
        return assertRequest_js_1.assertRequest;
    }
});
var assertTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertTransaction.js [app-client] (ecmascript)");
Object.defineProperty(exports, "assertTransactionEIP1559", {
    enumerable: true,
    get: function() {
        return assertTransaction_js_1.assertTransactionEIP1559;
    }
});
Object.defineProperty(exports, "assertTransactionEIP2930", {
    enumerable: true,
    get: function() {
        return assertTransaction_js_1.assertTransactionEIP2930;
    }
});
Object.defineProperty(exports, "assertTransactionLegacy", {
    enumerable: true,
    get: function() {
        return assertTransaction_js_1.assertTransactionLegacy;
    }
});
var getSerializedTransactionType_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getSerializedTransactionType.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getSerializedTransactionType", {
    enumerable: true,
    get: function() {
        return getSerializedTransactionType_js_1.getSerializedTransactionType;
    }
});
var getTransactionType_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/getTransactionType.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getTransactionType", {
    enumerable: true,
    get: function() {
        return getTransactionType_js_1.getTransactionType;
    }
});
var parseTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/parseTransaction.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseTransaction", {
    enumerable: true,
    get: function() {
        return parseTransaction_js_1.parseTransaction;
    }
});
var serializeAccessList_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeAccessList.js [app-client] (ecmascript)");
Object.defineProperty(exports, "serializeAccessList", {
    enumerable: true,
    get: function() {
        return serializeAccessList_js_1.serializeAccessList;
    }
});
var serializeTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeTransaction.js [app-client] (ecmascript)");
Object.defineProperty(exports, "serializeTransaction", {
    enumerable: true,
    get: function() {
        return serializeTransaction_js_1.serializeTransaction;
    }
});
var typedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/typedData.js [app-client] (ecmascript)");
Object.defineProperty(exports, "serializeTypedData", {
    enumerable: true,
    get: function() {
        return typedData_js_1.serializeTypedData;
    }
});
Object.defineProperty(exports, "validateTypedData", {
    enumerable: true,
    get: function() {
        return typedData_js_1.validateTypedData;
    }
});
var formatEther_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatEther.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatEther", {
    enumerable: true,
    get: function() {
        return formatEther_js_1.formatEther;
    }
});
var formatGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatGwei.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatGwei", {
    enumerable: true,
    get: function() {
        return formatGwei_js_1.formatGwei;
    }
});
var formatUnits_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/formatUnits.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatUnits", {
    enumerable: true,
    get: function() {
        return formatUnits_js_1.formatUnits;
    }
});
var parseEther_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseEther.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseEther", {
    enumerable: true,
    get: function() {
        return parseEther_js_1.parseEther;
    }
});
var parseGwei_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseGwei.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseGwei", {
    enumerable: true,
    get: function() {
        return parseGwei_js_1.parseGwei;
    }
});
var parseUnits_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/unit/parseUnits.js [app-client] (ecmascript)");
Object.defineProperty(exports, "parseUnits", {
    enumerable: true,
    get: function() {
        return parseUnits_js_1.parseUnits;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/proof.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatProof = formatProof;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/index.js [app-client] (ecmascript)");
function formatStorageProof(storageProof) {
    return storageProof.map((proof)=>({
            ...proof,
            value: BigInt(proof.value)
        }));
}
function formatProof(proof) {
    return {
        ...proof,
        balance: proof.balance ? BigInt(proof.balance) : undefined,
        nonce: proof.nonce ? (0, index_js_1.hexToNumber)(proof.nonce) : undefined,
        storageProof: proof.storageProof ? formatStorageProof(proof.storageProof) : undefined
    };
} //# sourceMappingURL=proof.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getProof.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getProof = getProof;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const proof_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/proof.js [app-client] (ecmascript)");
async function getProof(client, param) {
    let { address, blockNumber, blockTag: blockTag_, storageKeys } = param;
    const blockTag = blockTag_ !== null && blockTag_ !== void 0 ? blockTag_ : 'latest';
    const blockNumberHex = blockNumber !== undefined ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    const proof = await client.request({
        method: 'eth_getProof',
        params: [
            address,
            storageKeys,
            blockNumberHex || blockTag
        ]
    });
    return (0, proof_js_1.formatProof)(proof);
} //# sourceMappingURL=getProof.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getStorageAt.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getStorageAt = getStorageAt;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function getStorageAt(client, param) {
    let { address, blockNumber, blockTag = 'latest', slot } = param;
    const blockNumberHex = blockNumber !== undefined ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    const data = await client.request({
        method: 'eth_getStorageAt',
        params: [
            address,
            slot,
            blockNumberHex || blockTag
        ]
    });
    return data;
} //# sourceMappingURL=getStorageAt.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTransaction = getTransaction;
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const transaction_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transaction.js [app-client] (ecmascript)");
async function getTransaction(client, param) {
    let { blockHash, blockNumber, blockTag: blockTag_, hash, index } = param;
    var _client_chain_formatters_transaction, _client_chain_formatters, _client_chain;
    const blockTag = blockTag_ || 'latest';
    const blockNumberHex = blockNumber !== undefined ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
    let transaction = null;
    if (hash) {
        transaction = await client.request({
            method: 'eth_getTransactionByHash',
            params: [
                hash
            ]
        }, {
            dedupe: true
        });
    } else if (blockHash) {
        transaction = await client.request({
            method: 'eth_getTransactionByBlockHashAndIndex',
            params: [
                blockHash,
                (0, toHex_js_1.numberToHex)(index)
            ]
        }, {
            dedupe: true
        });
    } else if ("TURBOPACK compile-time truthy", 1) {
        transaction = await client.request({
            method: 'eth_getTransactionByBlockNumberAndIndex',
            params: [
                blockNumberHex || blockTag,
                (0, toHex_js_1.numberToHex)(index)
            ]
        }, {
            dedupe: Boolean(blockNumberHex)
        });
    }
    if (!transaction) throw new transaction_js_1.TransactionNotFoundError({
        blockHash,
        blockNumber,
        blockTag,
        hash,
        index
    });
    const format = ((_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transaction = _client_chain_formatters.transaction) === null || _client_chain_formatters_transaction === void 0 ? void 0 : _client_chain_formatters_transaction.format) || transaction_js_2.formatTransaction;
    return format(transaction, 'getTransaction');
} //# sourceMappingURL=getTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionConfirmations.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTransactionConfirmations = getTransactionConfirmations;
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const getBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockNumber.js [app-client] (ecmascript)");
const getTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransaction.js [app-client] (ecmascript)");
async function getTransactionConfirmations(client, param) {
    let { hash, transactionReceipt } = param;
    const [blockNumber, transaction] = await Promise.all([
        (0, getAction_js_1.getAction)(client, getBlockNumber_js_1.getBlockNumber, 'getBlockNumber')({}),
        hash ? (0, getAction_js_1.getAction)(client, getTransaction_js_1.getTransaction, 'getTransaction')({
            hash
        }) : undefined
    ]);
    const transactionBlockNumber = (transactionReceipt === null || transactionReceipt === void 0 ? void 0 : transactionReceipt.blockNumber) || (transaction === null || transaction === void 0 ? void 0 : transaction.blockNumber);
    if (!transactionBlockNumber) return 0n;
    return blockNumber - transactionBlockNumber + 1n;
} //# sourceMappingURL=getTransactionConfirmations.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionReceipt.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTransactionReceipt = getTransactionReceipt;
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const transactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionReceipt.js [app-client] (ecmascript)");
async function getTransactionReceipt(client, param) {
    let { hash } = param;
    var _client_chain_formatters_transactionReceipt, _client_chain_formatters, _client_chain;
    const receipt = await client.request({
        method: 'eth_getTransactionReceipt',
        params: [
            hash
        ]
    }, {
        dedupe: true
    });
    if (!receipt) throw new transaction_js_1.TransactionReceiptNotFoundError({
        hash
    });
    const format = ((_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionReceipt = _client_chain_formatters.transactionReceipt) === null || _client_chain_formatters_transactionReceipt === void 0 ? void 0 : _client_chain_formatters_transactionReceipt.format) || transactionReceipt_js_1.formatTransactionReceipt;
    return format(receipt, 'getTransactionReceipt');
} //# sourceMappingURL=getTransactionReceipt.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/multicall.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.multicall = multicall;
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const contracts_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contracts.js [app-client] (ecmascript)");
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getChainContractAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/getChainContractAddress.js [app-client] (ecmascript)");
const getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function multicall(client, parameters) {
    var _client_batch;
    const { account, authorizationList, allowFailure = true, blockNumber, blockOverrides, blockTag, stateOverride } = parameters;
    const contracts = parameters.contracts;
    var _parameters_batchSize, _parameters_deployless;
    const { batchSize = (_parameters_batchSize = parameters.batchSize) !== null && _parameters_batchSize !== void 0 ? _parameters_batchSize : 1024, deployless = (_parameters_deployless = parameters.deployless) !== null && _parameters_deployless !== void 0 ? _parameters_deployless : false } = typeof ((_client_batch = client.batch) === null || _client_batch === void 0 ? void 0 : _client_batch.multicall) === 'object' ? client.batch.multicall : {};
    const multicallAddress = (()=>{
        if (parameters.multicallAddress) return parameters.multicallAddress;
        if (deployless) return null;
        if (client.chain) {
            return (0, getChainContractAddress_js_1.getChainContractAddress)({
                blockNumber,
                chain: client.chain,
                contract: 'multicall3'
            });
        }
        throw new Error('client chain not configured. multicallAddress is required.');
    })();
    const chunkedCalls = [
        []
    ];
    let currentChunk = 0;
    let currentChunkSize = 0;
    for(let i = 0; i < contracts.length; i++){
        const { abi, address, args, functionName } = contracts[i];
        try {
            const callData = (0, encodeFunctionData_js_1.encodeFunctionData)({
                abi,
                args,
                functionName
            });
            currentChunkSize += (callData.length - 2) / 2;
            if (batchSize > 0 && currentChunkSize > batchSize && chunkedCalls[currentChunk].length > 0) {
                currentChunk++;
                currentChunkSize = (callData.length - 2) / 2;
                chunkedCalls[currentChunk] = [];
            }
            chunkedCalls[currentChunk] = [
                ...chunkedCalls[currentChunk],
                {
                    allowFailure: true,
                    callData,
                    target: address
                }
            ];
        } catch (err) {
            const error = (0, getContractError_js_1.getContractError)(err, {
                abi,
                address,
                args,
                docsPath: '/docs/contract/multicall',
                functionName,
                sender: account
            });
            if (!allowFailure) throw error;
            chunkedCalls[currentChunk] = [
                ...chunkedCalls[currentChunk],
                {
                    allowFailure: true,
                    callData: '0x',
                    target: address
                }
            ];
        }
    }
    const aggregate3Results = await Promise.allSettled(chunkedCalls.map((calls)=>(0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract')({
            ...multicallAddress === null ? {
                code: contracts_js_1.multicall3Bytecode
            } : {
                address: multicallAddress
            },
            abi: abis_js_1.multicall3Abi,
            account,
            args: [
                calls
            ],
            authorizationList,
            blockNumber,
            blockOverrides,
            blockTag,
            functionName: 'aggregate3',
            stateOverride
        })));
    const results = [];
    for(let i = 0; i < aggregate3Results.length; i++){
        const result = aggregate3Results[i];
        if (result.status === 'rejected') {
            if (!allowFailure) throw result.reason;
            for(let j = 0; j < chunkedCalls[i].length; j++){
                results.push({
                    status: 'failure',
                    error: result.reason,
                    result: undefined
                });
            }
            continue;
        }
        const aggregate3Result = result.value;
        for(let j = 0; j < aggregate3Result.length; j++){
            const { returnData, success } = aggregate3Result[j];
            const { callData } = chunkedCalls[i][j];
            const { abi, address, functionName, args } = contracts[results.length];
            try {
                if (callData === '0x') throw new abi_js_1.AbiDecodingZeroDataError();
                if (!success) throw new contract_js_1.RawContractError({
                    data: returnData
                });
                const result = (0, decodeFunctionResult_js_1.decodeFunctionResult)({
                    abi,
                    args,
                    data: returnData,
                    functionName
                });
                results.push(allowFailure ? {
                    result,
                    status: 'success'
                } : result);
            } catch (err) {
                const error = (0, getContractError_js_1.getContractError)(err, {
                    abi,
                    address,
                    args,
                    docsPath: '/docs/contract/multicall',
                    functionName
                });
                if (!allowFailure) throw error;
                results.push({
                    error,
                    result: undefined,
                    status: 'failure'
                });
            }
        }
    }
    if (results.length !== contracts.length) throw new base_js_1.BaseError('multicall results mismatch');
    return results;
} //# sourceMappingURL=multicall.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateBlocks.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.simulateBlocks = simulateBlocks;
const BlockOverrides = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/core/BlockOverrides.js [app-client] (ecmascript)");
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const decodeFunctionResult_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeFunctionResult.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const getContractError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getContractError.js [app-client] (ecmascript)");
const getNodeError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getNodeError.js [app-client] (ecmascript)");
const block_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/block.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const stateOverride_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stateOverride.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
async function simulateBlocks(client, parameters) {
    var _client_experimental_blockTag;
    const { blockNumber, blockTag = (_client_experimental_blockTag = client.experimental_blockTag) !== null && _client_experimental_blockTag !== void 0 ? _client_experimental_blockTag : 'latest', blocks, returnFullTransactions, traceTransfers, validation } = parameters;
    try {
        const blockStateCalls = [];
        for (const block of blocks){
            const blockOverrides = block.blockOverrides ? BlockOverrides.toRpc(block.blockOverrides) : undefined;
            const calls = block.calls.map((call_)=>{
                const call = call_;
                const account = call.account ? (0, parseAccount_js_1.parseAccount)(call.account) : undefined;
                const data = call.abi ? (0, encodeFunctionData_js_1.encodeFunctionData)(call) : call.data;
                var _call_from;
                const request = {
                    ...call,
                    account,
                    data: call.dataSuffix ? (0, concat_js_1.concat)([
                        data || '0x',
                        call.dataSuffix
                    ]) : data,
                    from: (_call_from = call.from) !== null && _call_from !== void 0 ? _call_from : account === null || account === void 0 ? void 0 : account.address
                };
                (0, assertRequest_js_1.assertRequest)(request);
                return (0, transactionRequest_js_1.formatTransactionRequest)(request);
            });
            const stateOverrides = block.stateOverrides ? (0, stateOverride_js_1.serializeStateOverride)(block.stateOverrides) : undefined;
            blockStateCalls.push({
                blockOverrides,
                calls,
                stateOverrides
            });
        }
        const blockNumberHex = typeof blockNumber === 'bigint' ? (0, toHex_js_1.numberToHex)(blockNumber) : undefined;
        const block = blockNumberHex || blockTag;
        const result = await client.request({
            method: 'eth_simulateV1',
            params: [
                {
                    blockStateCalls,
                    returnFullTransactions,
                    traceTransfers,
                    validation
                },
                block
            ]
        });
        return result.map((block, i)=>({
                ...(0, block_js_1.formatBlock)(block),
                calls: block.calls.map((call, j)=>{
                    var _call_error, _call_logs;
                    const { abi, args, functionName, to } = blocks[i].calls[j];
                    var _call_error_data;
                    const data = (_call_error_data = (_call_error = call.error) === null || _call_error === void 0 ? void 0 : _call_error.data) !== null && _call_error_data !== void 0 ? _call_error_data : call.returnData;
                    const gasUsed = BigInt(call.gasUsed);
                    const logs = (_call_logs = call.logs) === null || _call_logs === void 0 ? void 0 : _call_logs.map((log)=>(0, log_js_1.formatLog)(log));
                    const status = call.status === '0x1' ? 'success' : 'failure';
                    const result = abi && status === 'success' && data !== '0x' ? (0, decodeFunctionResult_js_1.decodeFunctionResult)({
                        abi,
                        data,
                        functionName
                    }) : null;
                    const error = (()=>{
                        var _call_error;
                        if (status === 'success') return undefined;
                        let error;
                        if (((_call_error = call.error) === null || _call_error === void 0 ? void 0 : _call_error.data) === '0x') error = new abi_js_1.AbiDecodingZeroDataError();
                        else if (call.error) error = new contract_js_1.RawContractError(call.error);
                        if (!error) return undefined;
                        return (0, getContractError_js_1.getContractError)(error, {
                            abi: abi !== null && abi !== void 0 ? abi : [],
                            address: to !== null && to !== void 0 ? to : '0x',
                            args,
                            functionName: functionName !== null && functionName !== void 0 ? functionName : '<unknown>'
                        });
                    })();
                    return {
                        data,
                        gasUsed,
                        logs,
                        status,
                        ...status === 'success' ? {
                            result
                        } : {
                            error
                        }
                    };
                })
            }));
    } catch (e) {
        const cause = e;
        const error = (0, getNodeError_js_1.getNodeError)(cause, {});
        if (error instanceof node_js_1.UnknownNodeError) throw cause;
        throw error;
    }
} //# sourceMappingURL=simulateBlocks.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/address.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.zeroAddress = exports.ethAddress = exports.entryPoint08Address = exports.entryPoint07Address = exports.entryPoint06Address = void 0;
exports.entryPoint06Address = '0x5FF137D4b0FDCD49DcA30c7CF57E578a026d2789';
exports.entryPoint07Address = '0x0000000071727De22E5E9d8BAf0edAc6f37da032';
exports.entryPoint08Address = '0x4337084D9E255Ff0702461CF8895CE9E3b5Ff108';
exports.ethAddress = '0xeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee';
exports.zeroAddress = '0x0000000000000000000000000000000000000000'; //# sourceMappingURL=address.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateCalls.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.simulateCalls = simulateCalls;
const AbiConstructor = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/core/AbiConstructor.js [app-client] (ecmascript)");
const AbiFunction = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/core/AbiFunction.js [app-client] (ecmascript)");
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/address.js [app-client] (ecmascript)");
const contracts_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contracts.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/index.js [app-client] (ecmascript)");
const createAccessList_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createAccessList.js [app-client] (ecmascript)");
const simulateBlocks_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateBlocks.js [app-client] (ecmascript)");
const getBalanceCode = '0x6080604052348015600e575f80fd5b5061016d8061001c5f395ff3fe608060405234801561000f575f80fd5b5060043610610029575f3560e01c8063f8b2cb4f1461002d575b5f80fd5b610047600480360381019061004291906100db565b61005d565b604051610054919061011e565b60405180910390f35b5f8173ffffffffffffffffffffffffffffffffffffffff16319050919050565b5f80fd5b5f73ffffffffffffffffffffffffffffffffffffffff82169050919050565b5f6100aa82610081565b9050919050565b6100ba816100a0565b81146100c4575f80fd5b50565b5f813590506100d5816100b1565b92915050565b5f602082840312156100f0576100ef61007d565b5b5f6100fd848285016100c7565b91505092915050565b5f819050919050565b61011881610106565b82525050565b5f6020820190506101315f83018461010f565b9291505056fea26469706673582212203b9fe929fe995c7cf9887f0bdba8a36dd78e8b73f149b17d2d9ad7cd09d2dc6264736f6c634300081a0033';
async function simulateCalls(client, parameters) {
    const { blockNumber, blockTag, calls, stateOverrides, traceAssetChanges, traceTransfers, validation } = parameters;
    const account = parameters.account ? (0, parseAccount_js_1.parseAccount)(parameters.account) : undefined;
    if (traceAssetChanges && !account) throw new base_js_1.BaseError('`account` is required when `traceAssetChanges` is true');
    const getBalanceData = account ? AbiConstructor.encode(AbiConstructor.from('constructor(bytes, bytes)'), {
        bytecode: contracts_js_1.deploylessCallViaBytecodeBytecode,
        args: [
            getBalanceCode,
            AbiFunction.encodeData(AbiFunction.from('function getBalance(address)'), [
                account.address
            ])
        ]
    }) : undefined;
    const assetAddresses = traceAssetChanges ? await Promise.all(parameters.calls.map(async (call)=>{
        if (!call.data && !call.abi) return;
        const { accessList } = await (0, createAccessList_js_1.createAccessList)(client, {
            account: account.address,
            ...call,
            data: call.abi ? (0, encodeFunctionData_js_1.encodeFunctionData)(call) : call.data
        });
        return accessList.map((param)=>{
            let { address, storageKeys } = param;
            return storageKeys.length > 0 ? address : null;
        });
    })).then((x)=>x.flat().filter(Boolean)) : [];
    const blocks = await (0, simulateBlocks_js_1.simulateBlocks)(client, {
        blockNumber,
        blockTag: blockTag,
        blocks: [
            ...traceAssetChanges ? [
                {
                    calls: [
                        {
                            data: getBalanceData
                        }
                    ],
                    stateOverrides
                },
                {
                    calls: assetAddresses.map((address, i)=>({
                            abi: [
                                AbiFunction.from('function balanceOf(address) returns (uint256)')
                            ],
                            functionName: 'balanceOf',
                            args: [
                                account.address
                            ],
                            to: address,
                            from: address_js_1.zeroAddress,
                            nonce: i
                        })),
                    stateOverrides: [
                        {
                            address: address_js_1.zeroAddress,
                            nonce: 0
                        }
                    ]
                }
            ] : [],
            {
                calls: [
                    ...calls,
                    {}
                ].map((call)=>({
                        ...call,
                        from: account === null || account === void 0 ? void 0 : account.address
                    })),
                stateOverrides
            },
            ...traceAssetChanges ? [
                {
                    calls: [
                        {
                            data: getBalanceData
                        }
                    ]
                },
                {
                    calls: assetAddresses.map((address, i)=>({
                            abi: [
                                AbiFunction.from('function balanceOf(address) returns (uint256)')
                            ],
                            functionName: 'balanceOf',
                            args: [
                                account.address
                            ],
                            to: address,
                            from: address_js_1.zeroAddress,
                            nonce: i
                        })),
                    stateOverrides: [
                        {
                            address: address_js_1.zeroAddress,
                            nonce: 0
                        }
                    ]
                },
                {
                    calls: assetAddresses.map((address, i)=>({
                            to: address,
                            abi: [
                                AbiFunction.from('function decimals() returns (uint256)')
                            ],
                            functionName: 'decimals',
                            from: address_js_1.zeroAddress,
                            nonce: i
                        })),
                    stateOverrides: [
                        {
                            address: address_js_1.zeroAddress,
                            nonce: 0
                        }
                    ]
                },
                {
                    calls: assetAddresses.map((address, i)=>({
                            to: address,
                            abi: [
                                AbiFunction.from('function tokenURI(uint256) returns (string)')
                            ],
                            functionName: 'tokenURI',
                            args: [
                                0n
                            ],
                            from: address_js_1.zeroAddress,
                            nonce: i
                        })),
                    stateOverrides: [
                        {
                            address: address_js_1.zeroAddress,
                            nonce: 0
                        }
                    ]
                },
                {
                    calls: assetAddresses.map((address, i)=>({
                            to: address,
                            abi: [
                                AbiFunction.from('function symbol() returns (string)')
                            ],
                            functionName: 'symbol',
                            from: address_js_1.zeroAddress,
                            nonce: i
                        })),
                    stateOverrides: [
                        {
                            address: address_js_1.zeroAddress,
                            nonce: 0
                        }
                    ]
                }
            ] : []
        ],
        traceTransfers,
        validation
    });
    const block_results = traceAssetChanges ? blocks[2] : blocks[0];
    const [block_ethPre, block_assetsPre, , block_ethPost, block_assetsPost, block_decimals, block_tokenURI, block_symbols] = traceAssetChanges ? blocks : [];
    const { calls: block_calls, ...block } = block_results;
    var _block_calls_slice;
    const results = (_block_calls_slice = block_calls.slice(0, -1)) !== null && _block_calls_slice !== void 0 ? _block_calls_slice : [];
    var _block_ethPre_calls;
    const ethPre = (_block_ethPre_calls = block_ethPre === null || block_ethPre === void 0 ? void 0 : block_ethPre.calls) !== null && _block_ethPre_calls !== void 0 ? _block_ethPre_calls : [];
    var _block_assetsPre_calls;
    const assetsPre = (_block_assetsPre_calls = block_assetsPre === null || block_assetsPre === void 0 ? void 0 : block_assetsPre.calls) !== null && _block_assetsPre_calls !== void 0 ? _block_assetsPre_calls : [];
    const balancesPre = [
        ...ethPre,
        ...assetsPre
    ].map((call)=>call.status === 'success' ? (0, index_js_1.hexToBigInt)(call.data) : null);
    var _block_ethPost_calls;
    const ethPost = (_block_ethPost_calls = block_ethPost === null || block_ethPost === void 0 ? void 0 : block_ethPost.calls) !== null && _block_ethPost_calls !== void 0 ? _block_ethPost_calls : [];
    var _block_assetsPost_calls;
    const assetsPost = (_block_assetsPost_calls = block_assetsPost === null || block_assetsPost === void 0 ? void 0 : block_assetsPost.calls) !== null && _block_assetsPost_calls !== void 0 ? _block_assetsPost_calls : [];
    const balancesPost = [
        ...ethPost,
        ...assetsPost
    ].map((call)=>call.status === 'success' ? (0, index_js_1.hexToBigInt)(call.data) : null);
    var _block_decimals_calls;
    const decimals = ((_block_decimals_calls = block_decimals === null || block_decimals === void 0 ? void 0 : block_decimals.calls) !== null && _block_decimals_calls !== void 0 ? _block_decimals_calls : []).map((x)=>x.status === 'success' ? x.result : null);
    var _block_symbols_calls;
    const symbols = ((_block_symbols_calls = block_symbols === null || block_symbols === void 0 ? void 0 : block_symbols.calls) !== null && _block_symbols_calls !== void 0 ? _block_symbols_calls : []).map((x)=>x.status === 'success' ? x.result : null);
    var _block_tokenURI_calls;
    const tokenURI = ((_block_tokenURI_calls = block_tokenURI === null || block_tokenURI === void 0 ? void 0 : block_tokenURI.calls) !== null && _block_tokenURI_calls !== void 0 ? _block_tokenURI_calls : []).map((x)=>x.status === 'success' ? x.result : null);
    const changes = [];
    for (const [i, balancePost] of balancesPost.entries()){
        const balancePre = balancesPre[i];
        if (typeof balancePost !== 'bigint') continue;
        if (typeof balancePre !== 'bigint') continue;
        const decimals_ = decimals[i - 1];
        const symbol_ = symbols[i - 1];
        const tokenURI_ = tokenURI[i - 1];
        const token = (()=>{
            if (i === 0) return {
                address: address_js_1.ethAddress,
                decimals: 18,
                symbol: 'ETH'
            };
            return {
                address: assetAddresses[i - 1],
                decimals: tokenURI_ || decimals_ ? Number(decimals_ !== null && decimals_ !== void 0 ? decimals_ : 1) : undefined,
                symbol: symbol_ !== null && symbol_ !== void 0 ? symbol_ : undefined
            };
        })();
        if (changes.some((change)=>change.token.address === token.address)) continue;
        changes.push({
            token,
            value: {
                pre: balancePre,
                post: balancePost,
                diff: balancePost - balancePre
            }
        });
    }
    return {
        assetChanges: changes,
        block,
        results
    };
} //# sourceMappingURL=simulateCalls.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeSignature = serializeSignature;
const secp256k1_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/secp256k1.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
function serializeSignature(param) {
    let { r, s, to = 'hex', v, yParity } = param;
    const yParity_ = (()=>{
        if (yParity === 0 || yParity === 1) return yParity;
        if (v && (v === 27n || v === 28n || v >= 35n)) return v % 2n === 0n ? 1 : 0;
        throw new Error('Invalid `v` or `yParity` value');
    })();
    const signature = "0x".concat(new secp256k1_1.secp256k1.Signature((0, fromHex_js_1.hexToBigInt)(r), (0, fromHex_js_1.hexToBigInt)(s)).toCompactHex()).concat(yParity_ === 0 ? '1b' : '1c');
    if (to === 'hex') return signature;
    return (0, toBytes_js_1.hexToBytes)(signature);
} //# sourceMappingURL=serializeSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyHash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyHash = verifyHash;
exports.verifyErc8010 = verifyErc8010;
exports.verifyErc1271 = verifyErc1271;
const erc6492_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/erc6492/index.js [app-client] (ecmascript)");
const erc8010_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_cjs/erc8010/index.js [app-client] (ecmascript)");
const abis_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/abis.js [app-client] (ecmascript)");
const contracts_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/constants/contracts.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/contract.js [app-client] (ecmascript)");
const encodeDeployData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeDeployData.js [app-client] (ecmascript)");
const encodeFunctionData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const verifyAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/verifyAuthorization.js [app-client] (ecmascript)");
const concat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/concat.js [app-client] (ecmascript)");
const isHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/data/isHex.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
const serializeSignature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeSignature.js [app-client] (ecmascript)");
const call_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/call.js [app-client] (ecmascript)");
const getCode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getCode.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
async function verifyHash(client, parameters) {
    var _client_chain_contracts_multicall3, _client_chain_contracts, _client_chain;
    var _parameters_universalSignatureVerifierAddress, _parameters_multicallAddress;
    const { address, hash, erc6492VerifierAddress: verifierAddress = (()=>{
        var _client_chain_contracts_erc6492Verifier, _client_chain_contracts, _client_chain;
        return (_parameters_universalSignatureVerifierAddress = parameters.universalSignatureVerifierAddress) !== null && _parameters_universalSignatureVerifierAddress !== void 0 ? _parameters_universalSignatureVerifierAddress : (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_contracts = _client_chain.contracts) === null || _client_chain_contracts === void 0 ? void 0 : (_client_chain_contracts_erc6492Verifier = _client_chain_contracts.erc6492Verifier) === null || _client_chain_contracts_erc6492Verifier === void 0 ? void 0 : _client_chain_contracts_erc6492Verifier.address;
    })(), multicallAddress = (_parameters_multicallAddress = parameters.multicallAddress) !== null && _parameters_multicallAddress !== void 0 ? _parameters_multicallAddress : (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_contracts = _client_chain.contracts) === null || _client_chain_contracts === void 0 ? void 0 : (_client_chain_contracts_multicall3 = _client_chain_contracts.multicall3) === null || _client_chain_contracts_multicall3 === void 0 ? void 0 : _client_chain_contracts_multicall3.address } = parameters;
    const signature = (()=>{
        const signature = parameters.signature;
        if ((0, isHex_js_1.isHex)(signature)) return signature;
        if (typeof signature === 'object' && 'r' in signature && 's' in signature) return (0, serializeSignature_js_1.serializeSignature)(signature);
        return (0, toHex_js_1.bytesToHex)(signature);
    })();
    try {
        if (erc8010_1.SignatureErc8010.validate(signature)) return await verifyErc8010(client, {
            ...parameters,
            multicallAddress,
            signature
        });
        return await verifyErc6492(client, {
            ...parameters,
            verifierAddress,
            signature
        });
    } catch (error) {
        try {
            const verified = (0, isAddressEqual_js_1.isAddressEqual)((0, getAddress_js_1.getAddress)(address), await (0, recoverAddress_js_1.recoverAddress)({
                hash,
                signature
            }));
            if (verified) return true;
        } catch (e) {}
        if (error instanceof VerificationError) {
            return false;
        }
        throw error;
    }
}
async function verifyErc8010(client, parameters) {
    var _results_;
    const { address, blockNumber, blockTag, hash, multicallAddress } = parameters;
    const { authorization: authorization_ox, data: initData, signature, to } = erc8010_1.SignatureErc8010.unwrap(parameters.signature);
    const code = await (0, getCode_js_1.getCode)(client, {
        address,
        blockNumber,
        blockTag
    });
    if (code === (0, concat_js_1.concatHex)([
        '0xef0100',
        authorization_ox.address
    ])) return await verifyErc1271(client, {
        address,
        blockNumber,
        blockTag,
        hash,
        signature
    });
    const authorization = {
        address: authorization_ox.address,
        chainId: Number(authorization_ox.chainId),
        nonce: Number(authorization_ox.nonce),
        r: (0, toHex_js_1.numberToHex)(authorization_ox.r, {
            size: 32
        }),
        s: (0, toHex_js_1.numberToHex)(authorization_ox.s, {
            size: 32
        }),
        yParity: authorization_ox.yParity
    };
    const valid = await (0, verifyAuthorization_js_1.verifyAuthorization)({
        address,
        authorization
    });
    if (!valid) throw new VerificationError();
    const results = await (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract')({
        ...multicallAddress ? {
            address: multicallAddress
        } : {
            code: contracts_js_1.multicall3Bytecode
        },
        authorizationList: [
            authorization
        ],
        abi: abis_js_1.multicall3Abi,
        blockNumber,
        blockTag: 'pending',
        functionName: 'aggregate3',
        args: [
            [
                ...initData ? [
                    {
                        allowFailure: true,
                        target: to !== null && to !== void 0 ? to : address,
                        callData: initData
                    }
                ] : [],
                {
                    allowFailure: true,
                    target: address,
                    callData: (0, encodeFunctionData_js_1.encodeFunctionData)({
                        abi: abis_js_1.erc1271Abi,
                        functionName: 'isValidSignature',
                        args: [
                            hash,
                            signature
                        ]
                    })
                }
            ]
        ]
    });
    const data = (_results_ = results[results.length - 1]) === null || _results_ === void 0 ? void 0 : _results_.returnData;
    if (data === null || data === void 0 ? void 0 : data.startsWith('0x1626ba7e')) return true;
    throw new VerificationError();
}
async function verifyErc6492(client, parameters) {
    const { address, factory, factoryData, hash, signature, verifierAddress, ...rest } = parameters;
    const wrappedSignature = await (async ()=>{
        if (!factory && !factoryData) return signature;
        if (erc6492_1.SignatureErc6492.validate(signature)) return signature;
        return erc6492_1.SignatureErc6492.wrap({
            data: factoryData,
            signature,
            to: factory
        });
    })();
    const args = verifierAddress ? {
        to: verifierAddress,
        data: (0, encodeFunctionData_js_1.encodeFunctionData)({
            abi: abis_js_1.erc6492SignatureValidatorAbi,
            functionName: 'isValidSig',
            args: [
                address,
                hash,
                wrappedSignature
            ]
        }),
        ...rest
    } : {
        data: (0, encodeDeployData_js_1.encodeDeployData)({
            abi: abis_js_1.erc6492SignatureValidatorAbi,
            args: [
                address,
                hash,
                wrappedSignature
            ],
            bytecode: contracts_js_1.erc6492SignatureValidatorByteCode
        }),
        ...rest
    };
    const { data } = await (0, getAction_js_1.getAction)(client, call_js_1.call, 'call')(args).catch((error)=>{
        if (error instanceof contract_js_1.CallExecutionError) throw new VerificationError();
        throw error;
    });
    if ((0, fromHex_js_1.hexToBool)(data !== null && data !== void 0 ? data : '0x0')) return true;
    throw new VerificationError();
}
async function verifyErc1271(client, parameters) {
    const { address, blockNumber, blockTag, hash, signature } = parameters;
    const result = await (0, getAction_js_1.getAction)(client, readContract_js_1.readContract, 'readContract')({
        address,
        abi: abis_js_1.erc1271Abi,
        args: [
            hash,
            signature
        ],
        blockNumber,
        blockTag,
        functionName: 'isValidSignature'
    }).catch((error)=>{
        if (error instanceof contract_js_1.ContractFunctionExecutionError) throw new VerificationError();
        throw error;
    });
    if (result.startsWith('0x1626ba7e')) return true;
    throw new VerificationError();
}
class VerificationError extends Error {
} //# sourceMappingURL=verifyHash.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyMessage = verifyMessage;
const hashMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashMessage.js [app-client] (ecmascript)");
const verifyHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyHash.js [app-client] (ecmascript)");
async function verifyMessage(client, param) {
    let { address, message, factory, factoryData, signature, ...callRequest } = param;
    const hash = (0, hashMessage_js_1.hashMessage)(message);
    return (0, verifyHash_js_1.verifyHash)(client, {
        address,
        factory: factory,
        factoryData: factoryData,
        hash,
        signature,
        ...callRequest
    });
} //# sourceMappingURL=verifyMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyTypedData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyTypedData = verifyTypedData;
const hashTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashTypedData.js [app-client] (ecmascript)");
const verifyHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyHash.js [app-client] (ecmascript)");
async function verifyTypedData(client, parameters) {
    const { address, factory, factoryData, signature, message, primaryType, types, domain, ...callRequest } = parameters;
    const hash = (0, hashTypedData_js_1.hashTypedData)({
        message,
        primaryType,
        types,
        domain
    });
    return (0, verifyHash_js_1.verifyHash)(client, {
        address,
        factory: factory,
        factoryData: factoryData,
        hash,
        signature,
        ...callRequest
    });
} //# sourceMappingURL=verifyTypedData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchBlockNumber.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.watchBlockNumber = watchBlockNumber;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const poll_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const getBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockNumber.js [app-client] (ecmascript)");
function watchBlockNumber(client, param) {
    let { emitOnBegin = false, emitMissed = false, onBlockNumber, onError, poll: poll_, pollingInterval = client.pollingInterval } = param;
    const enablePolling = (()=>{
        if (typeof poll_ !== 'undefined') return poll_;
        if (client.transport.type === 'webSocket' || client.transport.type === 'ipc') return false;
        if (client.transport.type === 'fallback' && (client.transport.transports[0].config.type === 'webSocket' || client.transport.transports[0].config.type === 'ipc')) return false;
        return true;
    })();
    let prevBlockNumber;
    const pollBlockNumber = ()=>{
        const observerId = (0, stringify_js_1.stringify)([
            'watchBlockNumber',
            client.uid,
            emitOnBegin,
            emitMissed,
            pollingInterval
        ]);
        return (0, observe_js_1.observe)(observerId, {
            onBlockNumber,
            onError
        }, (emit)=>(0, poll_js_1.poll)(async ()=>{
                try {
                    const blockNumber = await (0, getAction_js_1.getAction)(client, getBlockNumber_js_1.getBlockNumber, 'getBlockNumber')({
                        cacheTime: 0
                    });
                    if (prevBlockNumber !== undefined) {
                        if (blockNumber === prevBlockNumber) return;
                        if (blockNumber - prevBlockNumber > 1 && emitMissed) {
                            for(let i = prevBlockNumber + 1n; i < blockNumber; i++){
                                emit.onBlockNumber(i, prevBlockNumber);
                                prevBlockNumber = i;
                            }
                        }
                    }
                    if (prevBlockNumber === undefined || blockNumber > prevBlockNumber) {
                        emit.onBlockNumber(blockNumber, prevBlockNumber);
                        prevBlockNumber = blockNumber;
                    }
                } catch (err) {
                    var _emit_onError;
                    (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, err);
                }
            }, {
                emitOnBegin,
                interval: pollingInterval
            }));
    };
    const subscribeBlockNumber = ()=>{
        const observerId = (0, stringify_js_1.stringify)([
            'watchBlockNumber',
            client.uid,
            emitOnBegin,
            emitMissed
        ]);
        return (0, observe_js_1.observe)(observerId, {
            onBlockNumber,
            onError
        }, (emit)=>{
            let active = true;
            let unsubscribe = ()=>active = false;
            (async ()=>{
                try {
                    const transport = (()=>{
                        if (client.transport.type === 'fallback') {
                            const transport = client.transport.transports.find((transport)=>transport.config.type === 'webSocket' || transport.config.type === 'ipc');
                            if (!transport) return client.transport;
                            return transport.value;
                        }
                        return client.transport;
                    })();
                    const { unsubscribe: unsubscribe_ } = await transport.subscribe({
                        params: [
                            'newHeads'
                        ],
                        onData (data) {
                            var _data_result;
                            if (!active) return;
                            const blockNumber = (0, fromHex_js_1.hexToBigInt)((_data_result = data.result) === null || _data_result === void 0 ? void 0 : _data_result.number);
                            emit.onBlockNumber(blockNumber, prevBlockNumber);
                            prevBlockNumber = blockNumber;
                        },
                        onError (error) {
                            var _emit_onError;
                            (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, error);
                        }
                    });
                    unsubscribe = unsubscribe_;
                    if (!active) unsubscribe();
                } catch (err) {
                    onError === null || onError === void 0 ? void 0 : onError(err);
                }
            })();
            return ()=>unsubscribe();
        });
    };
    return enablePolling ? pollBlockNumber() : subscribeBlockNumber();
} //# sourceMappingURL=watchBlockNumber.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/waitForTransactionReceipt.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.waitForTransactionReceipt = waitForTransactionReceipt;
const block_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/block.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const withResolvers_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withResolvers.js [app-client] (ecmascript)");
const withRetry_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/withRetry.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const getBlock_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)");
const getTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransaction.js [app-client] (ecmascript)");
const getTransactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionReceipt.js [app-client] (ecmascript)");
const watchBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchBlockNumber.js [app-client] (ecmascript)");
async function waitForTransactionReceipt(client, parameters) {
    const { checkReplacement = true, confirmations = 1, hash, onReplaced, retryCount = 6, retryDelay = (param)=>{
        let { count } = param;
        return ~~(1 << count) * 200;
    }, timeout = 180_000 } = parameters;
    const observerId = (0, stringify_js_1.stringify)([
        'waitForTransactionReceipt',
        client.uid,
        hash
    ]);
    const pollingInterval = (()=>{
        var _client_chain;
        if (parameters.pollingInterval) return parameters.pollingInterval;
        if ((_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : _client_chain.experimental_preconfirmationTime) return client.chain.experimental_preconfirmationTime;
        return client.pollingInterval;
    })();
    let transaction;
    let replacedTransaction;
    let receipt;
    let retrying = false;
    let _unobserve;
    let _unwatch;
    const { promise, resolve, reject } = (0, withResolvers_js_1.withResolvers)();
    const timer = timeout ? setTimeout(()=>{
        _unwatch === null || _unwatch === void 0 ? void 0 : _unwatch();
        _unobserve === null || _unobserve === void 0 ? void 0 : _unobserve();
        reject(new transaction_js_1.WaitForTransactionReceiptTimeoutError({
            hash
        }));
    }, timeout) : undefined;
    _unobserve = (0, observe_js_1.observe)(observerId, {
        onReplaced,
        resolve,
        reject
    }, async (emit)=>{
        receipt = await (0, getAction_js_1.getAction)(client, getTransactionReceipt_js_1.getTransactionReceipt, 'getTransactionReceipt')({
            hash
        }).catch(()=>undefined);
        if (receipt && confirmations <= 1) {
            clearTimeout(timer);
            emit.resolve(receipt);
            _unobserve === null || _unobserve === void 0 ? void 0 : _unobserve();
            return;
        }
        _unwatch = (0, getAction_js_1.getAction)(client, watchBlockNumber_js_1.watchBlockNumber, 'watchBlockNumber')({
            emitMissed: true,
            emitOnBegin: true,
            poll: true,
            pollingInterval,
            async onBlockNumber (blockNumber_) {
                const done = (fn)=>{
                    clearTimeout(timer);
                    _unwatch === null || _unwatch === void 0 ? void 0 : _unwatch();
                    fn();
                    _unobserve === null || _unobserve === void 0 ? void 0 : _unobserve();
                };
                let blockNumber = blockNumber_;
                if (retrying) return;
                try {
                    if (receipt) {
                        if (confirmations > 1 && (!receipt.blockNumber || blockNumber - receipt.blockNumber + 1n < confirmations)) return;
                        done(()=>emit.resolve(receipt));
                        return;
                    }
                    if (checkReplacement && !transaction) {
                        retrying = true;
                        await (0, withRetry_js_1.withRetry)(async ()=>{
                            transaction = await (0, getAction_js_1.getAction)(client, getTransaction_js_1.getTransaction, 'getTransaction')({
                                hash
                            });
                            if (transaction.blockNumber) blockNumber = transaction.blockNumber;
                        }, {
                            delay: retryDelay,
                            retryCount
                        });
                        retrying = false;
                    }
                    receipt = await (0, getAction_js_1.getAction)(client, getTransactionReceipt_js_1.getTransactionReceipt, 'getTransactionReceipt')({
                        hash
                    });
                    if (confirmations > 1 && (!receipt.blockNumber || blockNumber - receipt.blockNumber + 1n < confirmations)) return;
                    done(()=>emit.resolve(receipt));
                } catch (err) {
                    if (err instanceof transaction_js_1.TransactionNotFoundError || err instanceof transaction_js_1.TransactionReceiptNotFoundError) {
                        if (!transaction) {
                            retrying = false;
                            return;
                        }
                        try {
                            replacedTransaction = transaction;
                            retrying = true;
                            const block = await (0, withRetry_js_1.withRetry)(()=>(0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({
                                    blockNumber,
                                    includeTransactions: true
                                }), {
                                delay: retryDelay,
                                retryCount,
                                shouldRetry: (param)=>{
                                    let { error } = param;
                                    return error instanceof block_js_1.BlockNotFoundError;
                                }
                            });
                            retrying = false;
                            const replacementTransaction = block.transactions.find((param)=>{
                                let { from, nonce } = param;
                                return from === replacedTransaction.from && nonce === replacedTransaction.nonce;
                            });
                            if (!replacementTransaction) return;
                            receipt = await (0, getAction_js_1.getAction)(client, getTransactionReceipt_js_1.getTransactionReceipt, 'getTransactionReceipt')({
                                hash: replacementTransaction.hash
                            });
                            if (confirmations > 1 && (!receipt.blockNumber || blockNumber - receipt.blockNumber + 1n < confirmations)) return;
                            let reason = 'replaced';
                            if (replacementTransaction.to === replacedTransaction.to && replacementTransaction.value === replacedTransaction.value && replacementTransaction.input === replacedTransaction.input) {
                                reason = 'repriced';
                            } else if (replacementTransaction.from === replacementTransaction.to && replacementTransaction.value === 0n) {
                                reason = 'cancelled';
                            }
                            done(()=>{
                                var _emit_onReplaced;
                                (_emit_onReplaced = emit.onReplaced) === null || _emit_onReplaced === void 0 ? void 0 : _emit_onReplaced.call(emit, {
                                    reason,
                                    replacedTransaction: replacedTransaction,
                                    transaction: replacementTransaction,
                                    transactionReceipt: receipt
                                });
                                emit.resolve(receipt);
                            });
                        } catch (err_) {
                            done(()=>emit.reject(err_));
                        }
                    } else {
                        done(()=>emit.reject(err));
                    }
                }
            }
        });
    });
    return promise;
} //# sourceMappingURL=waitForTransactionReceipt.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchBlocks.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.watchBlocks = watchBlocks;
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const poll_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const getBlock_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)");
var _client_experimental_blockTag;
function watchBlocks(client, param) {
    let { blockTag = (_client_experimental_blockTag = client.experimental_blockTag) !== null && _client_experimental_blockTag !== void 0 ? _client_experimental_blockTag : 'latest', emitMissed = false, emitOnBegin = false, onBlock, onError, includeTransactions: includeTransactions_, poll: poll_, pollingInterval = client.pollingInterval } = param;
    const enablePolling = (()=>{
        if (typeof poll_ !== 'undefined') return poll_;
        if (client.transport.type === 'webSocket' || client.transport.type === 'ipc') return false;
        if (client.transport.type === 'fallback' && (client.transport.transports[0].config.type === 'webSocket' || client.transport.transports[0].config.type === 'ipc')) return false;
        return true;
    })();
    const includeTransactions = includeTransactions_ !== null && includeTransactions_ !== void 0 ? includeTransactions_ : false;
    let prevBlock;
    const pollBlocks = ()=>{
        const observerId = (0, stringify_js_1.stringify)([
            'watchBlocks',
            client.uid,
            blockTag,
            emitMissed,
            emitOnBegin,
            includeTransactions,
            pollingInterval
        ]);
        return (0, observe_js_1.observe)(observerId, {
            onBlock,
            onError
        }, (emit)=>(0, poll_js_1.poll)(async ()=>{
                try {
                    const block = await (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({
                        blockTag,
                        includeTransactions
                    });
                    if (block.number !== null && (prevBlock === null || prevBlock === void 0 ? void 0 : prevBlock.number) != null) {
                        if (block.number === prevBlock.number) return;
                        if (block.number - prevBlock.number > 1 && emitMissed) {
                            for(let i = (prevBlock === null || prevBlock === void 0 ? void 0 : prevBlock.number) + 1n; i < block.number; i++){
                                const block = await (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({
                                    blockNumber: i,
                                    includeTransactions
                                });
                                emit.onBlock(block, prevBlock);
                                prevBlock = block;
                            }
                        }
                    }
                    if ((prevBlock === null || prevBlock === void 0 ? void 0 : prevBlock.number) == null || blockTag === 'pending' && (block === null || block === void 0 ? void 0 : block.number) == null || block.number !== null && block.number > prevBlock.number) {
                        emit.onBlock(block, prevBlock);
                        prevBlock = block;
                    }
                } catch (err) {
                    var _emit_onError;
                    (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, err);
                }
            }, {
                emitOnBegin,
                interval: pollingInterval
            }));
    };
    const subscribeBlocks = ()=>{
        let active = true;
        let emitFetched = true;
        let unsubscribe = ()=>active = false;
        (async ()=>{
            try {
                if (emitOnBegin) {
                    (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({
                        blockTag,
                        includeTransactions
                    }).then((block)=>{
                        if (!active) return;
                        if (!emitFetched) return;
                        onBlock(block, undefined);
                        emitFetched = false;
                    }).catch(onError);
                }
                const transport = (()=>{
                    if (client.transport.type === 'fallback') {
                        const transport = client.transport.transports.find((transport)=>transport.config.type === 'webSocket' || transport.config.type === 'ipc');
                        if (!transport) return client.transport;
                        return transport.value;
                    }
                    return client.transport;
                })();
                const { unsubscribe: unsubscribe_ } = await transport.subscribe({
                    params: [
                        'newHeads'
                    ],
                    async onData (data) {
                        var _data_result;
                        if (!active) return;
                        const block = await (0, getAction_js_1.getAction)(client, getBlock_js_1.getBlock, 'getBlock')({
                            blockNumber: (_data_result = data.result) === null || _data_result === void 0 ? void 0 : _data_result.number,
                            includeTransactions
                        }).catch(()=>{});
                        if (!active) return;
                        onBlock(block, prevBlock);
                        emitFetched = false;
                        prevBlock = block;
                    },
                    onError (error) {
                        onError === null || onError === void 0 ? void 0 : onError(error);
                    }
                });
                unsubscribe = unsubscribe_;
                if (!active) unsubscribe();
            } catch (err) {
                onError === null || onError === void 0 ? void 0 : onError(err);
            }
        })();
        return ()=>unsubscribe();
    };
    return enablePolling ? pollBlocks() : subscribeBlocks();
} //# sourceMappingURL=watchBlocks.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchEvent.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.watchEvent = watchEvent;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
const decodeEventLog_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeEventLog.js [app-client] (ecmascript)");
const encodeEventTopics_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeEventTopics.js [app-client] (ecmascript)");
const log_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/log.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const poll_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const createEventFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createEventFilter.js [app-client] (ecmascript)");
const getBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockNumber.js [app-client] (ecmascript)");
const getFilterChanges_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterChanges.js [app-client] (ecmascript)");
const getLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getLogs.js [app-client] (ecmascript)");
const uninstallFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/uninstallFilter.js [app-client] (ecmascript)");
function watchEvent(client, param) {
    let { address, args, batch = true, event, events, fromBlock, onError, onLogs, poll: poll_, pollingInterval = client.pollingInterval, strict: strict_ } = param;
    const enablePolling = (()=>{
        if (typeof poll_ !== 'undefined') return poll_;
        if (typeof fromBlock === 'bigint') return true;
        if (client.transport.type === 'webSocket' || client.transport.type === 'ipc') return false;
        if (client.transport.type === 'fallback' && (client.transport.transports[0].config.type === 'webSocket' || client.transport.transports[0].config.type === 'ipc')) return false;
        return true;
    })();
    const strict = strict_ !== null && strict_ !== void 0 ? strict_ : false;
    const pollEvent = ()=>{
        const observerId = (0, stringify_js_1.stringify)([
            'watchEvent',
            address,
            args,
            batch,
            client.uid,
            event,
            pollingInterval,
            fromBlock
        ]);
        return (0, observe_js_1.observe)(observerId, {
            onLogs,
            onError
        }, (emit)=>{
            let previousBlockNumber;
            if (fromBlock !== undefined) previousBlockNumber = fromBlock - 1n;
            let filter;
            let initialized = false;
            const unwatch = (0, poll_js_1.poll)(async ()=>{
                if (!initialized) {
                    try {
                        filter = await (0, getAction_js_1.getAction)(client, createEventFilter_js_1.createEventFilter, 'createEventFilter')({
                            address,
                            args,
                            event: event,
                            events,
                            strict,
                            fromBlock
                        });
                    } catch (e) {}
                    initialized = true;
                    return;
                }
                try {
                    let logs;
                    if (filter) {
                        logs = await (0, getAction_js_1.getAction)(client, getFilterChanges_js_1.getFilterChanges, 'getFilterChanges')({
                            filter
                        });
                    } else {
                        const blockNumber = await (0, getAction_js_1.getAction)(client, getBlockNumber_js_1.getBlockNumber, 'getBlockNumber')({});
                        if (previousBlockNumber && previousBlockNumber !== blockNumber) {
                            logs = await (0, getAction_js_1.getAction)(client, getLogs_js_1.getLogs, 'getLogs')({
                                address,
                                args,
                                event: event,
                                events,
                                fromBlock: previousBlockNumber + 1n,
                                toBlock: blockNumber
                            });
                        } else {
                            logs = [];
                        }
                        previousBlockNumber = blockNumber;
                    }
                    if (logs.length === 0) return;
                    if (batch) emit.onLogs(logs);
                    else for (const log of logs)emit.onLogs([
                        log
                    ]);
                } catch (err) {
                    var _emit_onError;
                    if (filter && err instanceof rpc_js_1.InvalidInputRpcError) initialized = false;
                    (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, err);
                }
            }, {
                emitOnBegin: true,
                interval: pollingInterval
            });
            return async ()=>{
                if (filter) await (0, getAction_js_1.getAction)(client, uninstallFilter_js_1.uninstallFilter, 'uninstallFilter')({
                    filter
                });
                unwatch();
            };
        });
    };
    const subscribeEvent = ()=>{
        let active = true;
        let unsubscribe = ()=>active = false;
        (async ()=>{
            try {
                const transport = (()=>{
                    if (client.transport.type === 'fallback') {
                        const transport = client.transport.transports.find((transport)=>transport.config.type === 'webSocket' || transport.config.type === 'ipc');
                        if (!transport) return client.transport;
                        return transport.value;
                    }
                    return client.transport;
                })();
                const events_ = events !== null && events !== void 0 ? events : event ? [
                    event
                ] : undefined;
                let topics = [];
                if (events_) {
                    const encoded = events_.flatMap((event)=>(0, encodeEventTopics_js_1.encodeEventTopics)({
                            abi: [
                                event
                            ],
                            eventName: event.name,
                            args
                        }));
                    topics = [
                        encoded
                    ];
                    if (event) topics = topics[0];
                }
                const { unsubscribe: unsubscribe_ } = await transport.subscribe({
                    params: [
                        'logs',
                        {
                            address,
                            topics
                        }
                    ],
                    onData (data) {
                        if (!active) return;
                        const log = data.result;
                        try {
                            const { eventName, args } = (0, decodeEventLog_js_1.decodeEventLog)({
                                abi: events_ !== null && events_ !== void 0 ? events_ : [],
                                data: log.data,
                                topics: log.topics,
                                strict
                            });
                            const formatted = (0, log_js_1.formatLog)(log, {
                                args,
                                eventName
                            });
                            onLogs([
                                formatted
                            ]);
                        } catch (err) {
                            let eventName;
                            let isUnnamed;
                            if (err instanceof abi_js_1.DecodeLogDataMismatch || err instanceof abi_js_1.DecodeLogTopicsMismatch) {
                                var _err_abiItem_inputs;
                                if (strict_) return;
                                eventName = err.abiItem.name;
                                isUnnamed = (_err_abiItem_inputs = err.abiItem.inputs) === null || _err_abiItem_inputs === void 0 ? void 0 : _err_abiItem_inputs.some((x)=>!('name' in x && x.name));
                            }
                            const formatted = (0, log_js_1.formatLog)(log, {
                                args: isUnnamed ? [] : {},
                                eventName
                            });
                            onLogs([
                                formatted
                            ]);
                        }
                    },
                    onError (error) {
                        onError === null || onError === void 0 ? void 0 : onError(error);
                    }
                });
                unsubscribe = unsubscribe_;
                if (!active) unsubscribe();
            } catch (err) {
                onError === null || onError === void 0 ? void 0 : onError(err);
            }
        })();
        return ()=>unsubscribe();
    };
    return enablePolling ? pollEvent() : subscribeEvent();
} //# sourceMappingURL=watchEvent.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchPendingTransactions.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.watchPendingTransactions = watchPendingTransactions;
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const observe_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/observe.js [app-client] (ecmascript)");
const poll_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/poll.js [app-client] (ecmascript)");
const stringify_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/stringify.js [app-client] (ecmascript)");
const createPendingTransactionFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createPendingTransactionFilter.js [app-client] (ecmascript)");
const getFilterChanges_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterChanges.js [app-client] (ecmascript)");
const uninstallFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/uninstallFilter.js [app-client] (ecmascript)");
function watchPendingTransactions(client, param) {
    let { batch = true, onError, onTransactions, poll: poll_, pollingInterval = client.pollingInterval } = param;
    const enablePolling = typeof poll_ !== 'undefined' ? poll_ : client.transport.type !== 'webSocket' && client.transport.type !== 'ipc';
    const pollPendingTransactions = ()=>{
        const observerId = (0, stringify_js_1.stringify)([
            'watchPendingTransactions',
            client.uid,
            batch,
            pollingInterval
        ]);
        return (0, observe_js_1.observe)(observerId, {
            onTransactions,
            onError
        }, (emit)=>{
            let filter;
            const unwatch = (0, poll_js_1.poll)(async ()=>{
                try {
                    if (!filter) {
                        try {
                            filter = await (0, getAction_js_1.getAction)(client, createPendingTransactionFilter_js_1.createPendingTransactionFilter, 'createPendingTransactionFilter')({});
                            return;
                        } catch (err) {
                            unwatch();
                            throw err;
                        }
                    }
                    const hashes = await (0, getAction_js_1.getAction)(client, getFilterChanges_js_1.getFilterChanges, 'getFilterChanges')({
                        filter
                    });
                    if (hashes.length === 0) return;
                    if (batch) emit.onTransactions(hashes);
                    else for (const hash of hashes)emit.onTransactions([
                        hash
                    ]);
                } catch (err) {
                    var _emit_onError;
                    (_emit_onError = emit.onError) === null || _emit_onError === void 0 ? void 0 : _emit_onError.call(emit, err);
                }
            }, {
                emitOnBegin: true,
                interval: pollingInterval
            });
            return async ()=>{
                if (filter) await (0, getAction_js_1.getAction)(client, uninstallFilter_js_1.uninstallFilter, 'uninstallFilter')({
                    filter
                });
                unwatch();
            };
        });
    };
    const subscribePendingTransactions = ()=>{
        let active = true;
        let unsubscribe = ()=>active = false;
        (async ()=>{
            try {
                const { unsubscribe: unsubscribe_ } = await client.transport.subscribe({
                    params: [
                        'newPendingTransactions'
                    ],
                    onData (data) {
                        if (!active) return;
                        const transaction = data.result;
                        onTransactions([
                            transaction
                        ]);
                    },
                    onError (error) {
                        onError === null || onError === void 0 ? void 0 : onError(error);
                    }
                });
                unsubscribe = unsubscribe_;
                if (!active) unsubscribe();
            } catch (err) {
                onError === null || onError === void 0 ? void 0 : onError(err);
            }
        })();
        return ()=>unsubscribe();
    };
    return enablePolling ? pollPendingTransactions() : subscribePendingTransactions();
} //# sourceMappingURL=watchPendingTransactions.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/siwe/parseSiweMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseSiweMessage = parseSiweMessage;
function parseSiweMessage(message) {
    var _message_match, _message_match1, _message_split_;
    var _message_match_groups;
    const { scheme, statement, ...prefix } = (_message_match_groups = (_message_match = message.match(prefixRegex)) === null || _message_match === void 0 ? void 0 : _message_match.groups) !== null && _message_match_groups !== void 0 ? _message_match_groups : {};
    var _message_match_groups1;
    const { chainId, expirationTime, issuedAt, notBefore, requestId, ...suffix } = (_message_match_groups1 = (_message_match1 = message.match(suffixRegex)) === null || _message_match1 === void 0 ? void 0 : _message_match1.groups) !== null && _message_match_groups1 !== void 0 ? _message_match_groups1 : {};
    const resources = (_message_split_ = message.split('Resources:')[1]) === null || _message_split_ === void 0 ? void 0 : _message_split_.split('\n- ').slice(1);
    return {
        ...prefix,
        ...suffix,
        ...chainId ? {
            chainId: Number(chainId)
        } : {},
        ...expirationTime ? {
            expirationTime: new Date(expirationTime)
        } : {},
        ...issuedAt ? {
            issuedAt: new Date(issuedAt)
        } : {},
        ...notBefore ? {
            notBefore: new Date(notBefore)
        } : {},
        ...requestId ? {
            requestId
        } : {},
        ...resources ? {
            resources
        } : {},
        ...scheme ? {
            scheme
        } : {},
        ...statement ? {
            statement
        } : {}
    };
}
const prefixRegex = RegExp("^(?:(?<scheme>[a-zA-Z][a-zA-Z0-9+-.]*):\\/\\/)?(?<domain>[a-zA-Z0-9+-.]*(?::[0-9]{1,5})?) (?:wants you to sign in with your Ethereum account:\\n)(?<address>0x[a-fA-F0-9]{40})\\n\\n(?:(?<statement>.*)\\n\\n)?");
const suffixRegex = RegExp("(?:URI: (?<uri>.+))\\n(?:Version: (?<version>.+))\\n(?:Chain ID: (?<chainId>\\d+))\\n(?:Nonce: (?<nonce>[a-zA-Z0-9]+))\\n(?:Issued At: (?<issuedAt>.+))(?:\\nExpiration Time: (?<expirationTime>.+))?(?:\\nNot Before: (?<notBefore>.+))?(?:\\nRequest ID: (?<requestId>.+))?"); //# sourceMappingURL=parseSiweMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/siwe/validateSiweMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.validateSiweMessage = validateSiweMessage;
const isAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddress.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
function validateSiweMessage(parameters) {
    const { address, domain, message, nonce, scheme, time = new Date() } = parameters;
    if (domain && message.domain !== domain) return false;
    if (nonce && message.nonce !== nonce) return false;
    if (scheme && message.scheme !== scheme) return false;
    if (message.expirationTime && time >= message.expirationTime) return false;
    if (message.notBefore && time < message.notBefore) return false;
    try {
        if (!message.address) return false;
        if (!(0, isAddress_js_1.isAddress)(message.address, {
            strict: false
        })) return false;
        if (address && !(0, isAddressEqual_js_1.isAddressEqual)(message.address, address)) return false;
    } catch (e) {
        return false;
    }
    return true;
} //# sourceMappingURL=validateSiweMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/siwe/verifySiweMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifySiweMessage = verifySiweMessage;
const hashMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/hashMessage.js [app-client] (ecmascript)");
const parseSiweMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/siwe/parseSiweMessage.js [app-client] (ecmascript)");
const validateSiweMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/siwe/validateSiweMessage.js [app-client] (ecmascript)");
const verifyHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyHash.js [app-client] (ecmascript)");
async function verifySiweMessage(client, parameters) {
    const { address, domain, message, nonce, scheme, signature, time = new Date(), ...callRequest } = parameters;
    const parsed = (0, parseSiweMessage_js_1.parseSiweMessage)(message);
    if (!parsed.address) return false;
    const isValid = (0, validateSiweMessage_js_1.validateSiweMessage)({
        address,
        domain,
        message: parsed,
        nonce,
        scheme,
        time
    });
    if (!isValid) return false;
    const hash = (0, hashMessage_js_1.hashMessage)(message);
    return (0, verifyHash_js_1.verifyHash)(client, {
        address: parsed.address,
        hash,
        signature,
        ...callRequest
    });
} //# sourceMappingURL=verifySiweMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransactionSync.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sendRawTransactionSync = sendRawTransactionSync;
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const transactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionReceipt.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/index.js [app-client] (ecmascript)");
async function sendRawTransactionSync(client, param) {
    let { serializedTransaction, throwOnReceiptRevert, timeout } = param;
    var _client_chain_formatters_transactionReceipt, _client_chain_formatters, _client_chain;
    const receipt = await client.request({
        method: 'eth_sendRawTransactionSync',
        params: timeout ? [
            serializedTransaction,
            (0, index_js_1.numberToHex)(timeout)
        ] : [
            serializedTransaction
        ]
    }, {
        retryCount: 0
    });
    const format = ((_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionReceipt = _client_chain_formatters.transactionReceipt) === null || _client_chain_formatters_transactionReceipt === void 0 ? void 0 : _client_chain_formatters_transactionReceipt.format) || transactionReceipt_js_1.formatTransactionReceipt;
    const formatted = format(receipt);
    if (formatted.status === 'reverted' && throwOnReceiptRevert) throw new transaction_js_1.TransactionReceiptRevertedError({
        receipt: formatted
    });
    return formatted;
} //# sourceMappingURL=sendRawTransactionSync.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/decorators/public.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.publicActions = publicActions;
const getEnsAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsAddress.js [app-client] (ecmascript)");
const getEnsAvatar_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsAvatar.js [app-client] (ecmascript)");
const getEnsName_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsName.js [app-client] (ecmascript)");
const getEnsResolver_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsResolver.js [app-client] (ecmascript)");
const getEnsText_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/ens/getEnsText.js [app-client] (ecmascript)");
const call_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/call.js [app-client] (ecmascript)");
const createAccessList_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createAccessList.js [app-client] (ecmascript)");
const createBlockFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createBlockFilter.js [app-client] (ecmascript)");
const createContractEventFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createContractEventFilter.js [app-client] (ecmascript)");
const createEventFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createEventFilter.js [app-client] (ecmascript)");
const createPendingTransactionFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/createPendingTransactionFilter.js [app-client] (ecmascript)");
const estimateContractGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateContractGas.js [app-client] (ecmascript)");
const estimateFeesPerGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateFeesPerGas.js [app-client] (ecmascript)");
const estimateGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateGas.js [app-client] (ecmascript)");
const estimateMaxPriorityFeePerGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/estimateMaxPriorityFeePerGas.js [app-client] (ecmascript)");
const getBalance_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBalance.js [app-client] (ecmascript)");
const getBlobBaseFee_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlobBaseFee.js [app-client] (ecmascript)");
const getBlock_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlock.js [app-client] (ecmascript)");
const getBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockNumber.js [app-client] (ecmascript)");
const getBlockTransactionCount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getBlockTransactionCount.js [app-client] (ecmascript)");
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
const getCode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getCode.js [app-client] (ecmascript)");
const getContractEvents_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getContractEvents.js [app-client] (ecmascript)");
const getEip712Domain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getEip712Domain.js [app-client] (ecmascript)");
const getFeeHistory_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFeeHistory.js [app-client] (ecmascript)");
const getFilterChanges_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterChanges.js [app-client] (ecmascript)");
const getFilterLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getFilterLogs.js [app-client] (ecmascript)");
const getGasPrice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getGasPrice.js [app-client] (ecmascript)");
const getLogs_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getLogs.js [app-client] (ecmascript)");
const getProof_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getProof.js [app-client] (ecmascript)");
const getStorageAt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getStorageAt.js [app-client] (ecmascript)");
const getTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransaction.js [app-client] (ecmascript)");
const getTransactionConfirmations_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionConfirmations.js [app-client] (ecmascript)");
const getTransactionCount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionCount.js [app-client] (ecmascript)");
const getTransactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionReceipt.js [app-client] (ecmascript)");
const multicall_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/multicall.js [app-client] (ecmascript)");
const readContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/readContract.js [app-client] (ecmascript)");
const simulateBlocks_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateBlocks.js [app-client] (ecmascript)");
const simulateCalls_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateCalls.js [app-client] (ecmascript)");
const simulateContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/simulateContract.js [app-client] (ecmascript)");
const uninstallFilter_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/uninstallFilter.js [app-client] (ecmascript)");
const verifyHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyHash.js [app-client] (ecmascript)");
const verifyMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyMessage.js [app-client] (ecmascript)");
const verifyTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/verifyTypedData.js [app-client] (ecmascript)");
const waitForTransactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/waitForTransactionReceipt.js [app-client] (ecmascript)");
const watchBlockNumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchBlockNumber.js [app-client] (ecmascript)");
const watchBlocks_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchBlocks.js [app-client] (ecmascript)");
const watchContractEvent_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchContractEvent.js [app-client] (ecmascript)");
const watchEvent_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchEvent.js [app-client] (ecmascript)");
const watchPendingTransactions_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/watchPendingTransactions.js [app-client] (ecmascript)");
const verifySiweMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/siwe/verifySiweMessage.js [app-client] (ecmascript)");
const prepareTransactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareTransactionRequest.js [app-client] (ecmascript)");
const sendRawTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransaction.js [app-client] (ecmascript)");
const sendRawTransactionSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransactionSync.js [app-client] (ecmascript)");
function publicActions(client) {
    return {
        call: (args)=>(0, call_js_1.call)(client, args),
        createAccessList: (args)=>(0, createAccessList_js_1.createAccessList)(client, args),
        createBlockFilter: ()=>(0, createBlockFilter_js_1.createBlockFilter)(client),
        createContractEventFilter: (args)=>(0, createContractEventFilter_js_1.createContractEventFilter)(client, args),
        createEventFilter: (args)=>(0, createEventFilter_js_1.createEventFilter)(client, args),
        createPendingTransactionFilter: ()=>(0, createPendingTransactionFilter_js_1.createPendingTransactionFilter)(client),
        estimateContractGas: (args)=>(0, estimateContractGas_js_1.estimateContractGas)(client, args),
        estimateGas: (args)=>(0, estimateGas_js_1.estimateGas)(client, args),
        getBalance: (args)=>(0, getBalance_js_1.getBalance)(client, args),
        getBlobBaseFee: ()=>(0, getBlobBaseFee_js_1.getBlobBaseFee)(client),
        getBlock: (args)=>(0, getBlock_js_1.getBlock)(client, args),
        getBlockNumber: (args)=>(0, getBlockNumber_js_1.getBlockNumber)(client, args),
        getBlockTransactionCount: (args)=>(0, getBlockTransactionCount_js_1.getBlockTransactionCount)(client, args),
        getBytecode: (args)=>(0, getCode_js_1.getCode)(client, args),
        getChainId: ()=>(0, getChainId_js_1.getChainId)(client),
        getCode: (args)=>(0, getCode_js_1.getCode)(client, args),
        getContractEvents: (args)=>(0, getContractEvents_js_1.getContractEvents)(client, args),
        getEip712Domain: (args)=>(0, getEip712Domain_js_1.getEip712Domain)(client, args),
        getEnsAddress: (args)=>(0, getEnsAddress_js_1.getEnsAddress)(client, args),
        getEnsAvatar: (args)=>(0, getEnsAvatar_js_1.getEnsAvatar)(client, args),
        getEnsName: (args)=>(0, getEnsName_js_1.getEnsName)(client, args),
        getEnsResolver: (args)=>(0, getEnsResolver_js_1.getEnsResolver)(client, args),
        getEnsText: (args)=>(0, getEnsText_js_1.getEnsText)(client, args),
        getFeeHistory: (args)=>(0, getFeeHistory_js_1.getFeeHistory)(client, args),
        estimateFeesPerGas: (args)=>(0, estimateFeesPerGas_js_1.estimateFeesPerGas)(client, args),
        getFilterChanges: (args)=>(0, getFilterChanges_js_1.getFilterChanges)(client, args),
        getFilterLogs: (args)=>(0, getFilterLogs_js_1.getFilterLogs)(client, args),
        getGasPrice: ()=>(0, getGasPrice_js_1.getGasPrice)(client),
        getLogs: (args)=>(0, getLogs_js_1.getLogs)(client, args),
        getProof: (args)=>(0, getProof_js_1.getProof)(client, args),
        estimateMaxPriorityFeePerGas: (args)=>(0, estimateMaxPriorityFeePerGas_js_1.estimateMaxPriorityFeePerGas)(client, args),
        getStorageAt: (args)=>(0, getStorageAt_js_1.getStorageAt)(client, args),
        getTransaction: (args)=>(0, getTransaction_js_1.getTransaction)(client, args),
        getTransactionConfirmations: (args)=>(0, getTransactionConfirmations_js_1.getTransactionConfirmations)(client, args),
        getTransactionCount: (args)=>(0, getTransactionCount_js_1.getTransactionCount)(client, args),
        getTransactionReceipt: (args)=>(0, getTransactionReceipt_js_1.getTransactionReceipt)(client, args),
        multicall: (args)=>(0, multicall_js_1.multicall)(client, args),
        prepareTransactionRequest: (args)=>(0, prepareTransactionRequest_js_1.prepareTransactionRequest)(client, args),
        readContract: (args)=>(0, readContract_js_1.readContract)(client, args),
        sendRawTransaction: (args)=>(0, sendRawTransaction_js_1.sendRawTransaction)(client, args),
        sendRawTransactionSync: (args)=>(0, sendRawTransactionSync_js_1.sendRawTransactionSync)(client, args),
        simulate: (args)=>(0, simulateBlocks_js_1.simulateBlocks)(client, args),
        simulateBlocks: (args)=>(0, simulateBlocks_js_1.simulateBlocks)(client, args),
        simulateCalls: (args)=>(0, simulateCalls_js_1.simulateCalls)(client, args),
        simulateContract: (args)=>(0, simulateContract_js_1.simulateContract)(client, args),
        verifyHash: (args)=>(0, verifyHash_js_1.verifyHash)(client, args),
        verifyMessage: (args)=>(0, verifyMessage_js_1.verifyMessage)(client, args),
        verifySiweMessage: (args)=>(0, verifySiweMessage_js_1.verifySiweMessage)(client, args),
        verifyTypedData: (args)=>(0, verifyTypedData_js_1.verifyTypedData)(client, args),
        uninstallFilter: (args)=>(0, uninstallFilter_js_1.uninstallFilter)(client, args),
        waitForTransactionReceipt: (args)=>(0, waitForTransactionReceipt_js_1.waitForTransactionReceipt)(client, args),
        watchBlocks: (args)=>(0, watchBlocks_js_1.watchBlocks)(client, args),
        watchBlockNumber: (args)=>(0, watchBlockNumber_js_1.watchBlockNumber)(client, args),
        watchContractEvent: (args)=>(0, watchContractEvent_js_1.watchContractEvent)(client, args),
        watchEvent: (args)=>(0, watchEvent_js_1.watchEvent)(client, args),
        watchPendingTransactions: (args)=>(0, watchPendingTransactions_js_1.watchPendingTransactions)(client, args)
    };
} //# sourceMappingURL=public.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createPublicClient.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createPublicClient = createPublicClient;
const createClient_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createClient.js [app-client] (ecmascript)");
const public_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/decorators/public.js [app-client] (ecmascript)");
function createPublicClient(parameters) {
    const { key = 'public', name = 'Public Client' } = parameters;
    const client = (0, createClient_js_1.createClient)({
        ...parameters,
        key,
        name,
        type: 'publicClient'
    });
    return client.extend(public_js_1.publicActions);
} //# sourceMappingURL=createPublicClient.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/dropTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dropTransaction = dropTransaction;
async function dropTransaction(client, param) {
    let { hash } = param;
    await client.request({
        method: "".concat(client.mode, "_dropTransaction"),
        params: [
            hash
        ]
    });
} //# sourceMappingURL=dropTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/dumpState.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dumpState = dumpState;
async function dumpState(client) {
    return client.request({
        method: "".concat(client.mode, "_dumpState")
    });
} //# sourceMappingURL=dumpState.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/getAutomine.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getAutomine = getAutomine;
async function getAutomine(client) {
    if (client.mode === 'ganache') return await client.request({
        method: 'eth_mining'
    });
    return await client.request({
        method: "".concat(client.mode, "_getAutomine")
    });
} //# sourceMappingURL=getAutomine.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/getTxpoolContent.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTxpoolContent = getTxpoolContent;
async function getTxpoolContent(client) {
    return await client.request({
        method: 'txpool_content'
    });
} //# sourceMappingURL=getTxpoolContent.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/getTxpoolStatus.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTxpoolStatus = getTxpoolStatus;
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
async function getTxpoolStatus(client) {
    const { pending, queued } = await client.request({
        method: 'txpool_status'
    });
    return {
        pending: (0, fromHex_js_1.hexToNumber)(pending),
        queued: (0, fromHex_js_1.hexToNumber)(queued)
    };
} //# sourceMappingURL=getTxpoolStatus.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/impersonateAccount.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.impersonateAccount = impersonateAccount;
async function impersonateAccount(client, param) {
    let { address } = param;
    await client.request({
        method: "".concat(client.mode, "_impersonateAccount"),
        params: [
            address
        ]
    });
} //# sourceMappingURL=impersonateAccount.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/increaseTime.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.increaseTime = increaseTime;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function increaseTime(client, param) {
    let { seconds } = param;
    return await client.request({
        method: 'evm_increaseTime',
        params: [
            (0, toHex_js_1.numberToHex)(seconds)
        ]
    });
} //# sourceMappingURL=increaseTime.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/inspectTxpool.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.inspectTxpool = inspectTxpool;
async function inspectTxpool(client) {
    return await client.request({
        method: 'txpool_inspect'
    });
} //# sourceMappingURL=inspectTxpool.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/loadState.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.loadState = loadState;
async function loadState(client, param) {
    let { state } = param;
    await client.request({
        method: "".concat(client.mode, "_loadState"),
        params: [
            state
        ]
    });
} //# sourceMappingURL=loadState.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/mine.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.mine = mine;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function mine(client, param) {
    let { blocks, interval } = param;
    if (client.mode === 'ganache') await client.request({
        method: 'evm_mine',
        params: [
            {
                blocks: (0, toHex_js_1.numberToHex)(blocks)
            }
        ]
    });
    else await client.request({
        method: "".concat(client.mode, "_mine"),
        params: [
            (0, toHex_js_1.numberToHex)(blocks),
            (0, toHex_js_1.numberToHex)(interval || 0)
        ]
    });
} //# sourceMappingURL=mine.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/removeBlockTimestampInterval.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.removeBlockTimestampInterval = removeBlockTimestampInterval;
async function removeBlockTimestampInterval(client) {
    await client.request({
        method: "".concat(client.mode, "_removeBlockTimestampInterval")
    });
} //# sourceMappingURL=removeBlockTimestampInterval.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/reset.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reset = reset;
async function reset(client) {
    let { blockNumber, jsonRpcUrl } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    await client.request({
        method: "".concat(client.mode, "_reset"),
        params: [
            {
                forking: {
                    blockNumber: Number(blockNumber),
                    jsonRpcUrl
                }
            }
        ]
    });
} //# sourceMappingURL=reset.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/revert.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.revert = revert;
async function revert(client, param) {
    let { id } = param;
    await client.request({
        method: 'evm_revert',
        params: [
            id
        ]
    });
} //# sourceMappingURL=revert.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/sendUnsignedTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sendUnsignedTransaction = sendUnsignedTransaction;
const extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
async function sendUnsignedTransaction(client, args) {
    var _client_chain_formatters_transactionRequest, _client_chain_formatters, _client_chain;
    const { accessList, data, from, gas, gasPrice, maxFeePerGas, maxPriorityFeePerGas, nonce, to, value, ...rest } = args;
    const chainFormat = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionRequest = _client_chain_formatters.transactionRequest) === null || _client_chain_formatters_transactionRequest === void 0 ? void 0 : _client_chain_formatters_transactionRequest.format;
    const format = chainFormat || transactionRequest_js_1.formatTransactionRequest;
    const request = format({
        ...(0, extract_js_1.extract)(rest, {
            format: chainFormat
        }),
        accessList,
        data,
        from,
        gas,
        gasPrice,
        maxFeePerGas,
        maxPriorityFeePerGas,
        nonce,
        to,
        value
    }, 'sendUnsignedTransaction');
    const hash = await client.request({
        method: 'eth_sendUnsignedTransaction',
        params: [
            request
        ]
    });
    return hash;
} //# sourceMappingURL=sendUnsignedTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setAutomine.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setAutomine = setAutomine;
async function setAutomine(client, enabled) {
    if (client.mode === 'ganache') {
        if (enabled) await client.request({
            method: 'miner_start'
        });
        else await client.request({
            method: 'miner_stop'
        });
    } else await client.request({
        method: 'evm_setAutomine',
        params: [
            enabled
        ]
    });
} //# sourceMappingURL=setAutomine.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setBalance.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setBalance = setBalance;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setBalance(client, param) {
    let { address, value } = param;
    if (client.mode === 'ganache') await client.request({
        method: 'evm_setAccountBalance',
        params: [
            address,
            (0, toHex_js_1.numberToHex)(value)
        ]
    });
    else await client.request({
        method: "".concat(client.mode, "_setBalance"),
        params: [
            address,
            (0, toHex_js_1.numberToHex)(value)
        ]
    });
} //# sourceMappingURL=setBalance.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setBlockGasLimit.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setBlockGasLimit = setBlockGasLimit;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setBlockGasLimit(client, param) {
    let { gasLimit } = param;
    await client.request({
        method: 'evm_setBlockGasLimit',
        params: [
            (0, toHex_js_1.numberToHex)(gasLimit)
        ]
    });
} //# sourceMappingURL=setBlockGasLimit.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setBlockTimestampInterval.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setBlockTimestampInterval = setBlockTimestampInterval;
async function setBlockTimestampInterval(client, param) {
    let { interval } = param;
    const interval_ = (()=>{
        if (client.mode === 'hardhat') return interval * 1000;
        return interval;
    })();
    await client.request({
        method: "".concat(client.mode, "_setBlockTimestampInterval"),
        params: [
            interval_
        ]
    });
} //# sourceMappingURL=setBlockTimestampInterval.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setCode.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setCode = setCode;
async function setCode(client, param) {
    let { address, bytecode } = param;
    if (client.mode === 'ganache') await client.request({
        method: 'evm_setAccountCode',
        params: [
            address,
            bytecode
        ]
    });
    else await client.request({
        method: "".concat(client.mode, "_setCode"),
        params: [
            address,
            bytecode
        ]
    });
} //# sourceMappingURL=setCode.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setCoinbase.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setCoinbase = setCoinbase;
async function setCoinbase(client, param) {
    let { address } = param;
    await client.request({
        method: "".concat(client.mode, "_setCoinbase"),
        params: [
            address
        ]
    });
} //# sourceMappingURL=setCoinbase.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setIntervalMining.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setIntervalMining = setIntervalMining;
async function setIntervalMining(client, param) {
    let { interval } = param;
    const interval_ = (()=>{
        if (client.mode === 'hardhat') return interval * 1000;
        return interval;
    })();
    await client.request({
        method: 'evm_setIntervalMining',
        params: [
            interval_
        ]
    });
} //# sourceMappingURL=setIntervalMining.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setLoggingEnabled.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setLoggingEnabled = setLoggingEnabled;
async function setLoggingEnabled(client, enabled) {
    await client.request({
        method: "".concat(client.mode, "_setLoggingEnabled"),
        params: [
            enabled
        ]
    });
} //# sourceMappingURL=setLoggingEnabled.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setMinGasPrice.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setMinGasPrice = setMinGasPrice;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setMinGasPrice(client, param) {
    let { gasPrice } = param;
    await client.request({
        method: "".concat(client.mode, "_setMinGasPrice"),
        params: [
            (0, toHex_js_1.numberToHex)(gasPrice)
        ]
    });
} //# sourceMappingURL=setMinGasPrice.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setNextBlockBaseFeePerGas.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setNextBlockBaseFeePerGas = setNextBlockBaseFeePerGas;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setNextBlockBaseFeePerGas(client, param) {
    let { baseFeePerGas } = param;
    await client.request({
        method: "".concat(client.mode, "_setNextBlockBaseFeePerGas"),
        params: [
            (0, toHex_js_1.numberToHex)(baseFeePerGas)
        ]
    });
} //# sourceMappingURL=setNextBlockBaseFeePerGas.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setNextBlockTimestamp.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setNextBlockTimestamp = setNextBlockTimestamp;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setNextBlockTimestamp(client, param) {
    let { timestamp } = param;
    await client.request({
        method: 'evm_setNextBlockTimestamp',
        params: [
            (0, toHex_js_1.numberToHex)(timestamp)
        ]
    });
} //# sourceMappingURL=setNextBlockTimestamp.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setNonce.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setNonce = setNonce;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setNonce(client, param) {
    let { address, nonce } = param;
    await client.request({
        method: "".concat(client.mode, "_setNonce"),
        params: [
            address,
            (0, toHex_js_1.numberToHex)(nonce)
        ]
    });
} //# sourceMappingURL=setNonce.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setRpcUrl.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setRpcUrl = setRpcUrl;
async function setRpcUrl(client, jsonRpcUrl) {
    await client.request({
        method: "".concat(client.mode, "_setRpcUrl"),
        params: [
            jsonRpcUrl
        ]
    });
} //# sourceMappingURL=setRpcUrl.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setStorageAt.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setStorageAt = setStorageAt;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function setStorageAt(client, param) {
    let { address, index, value } = param;
    await client.request({
        method: "".concat(client.mode, "_setStorageAt"),
        params: [
            address,
            typeof index === 'number' ? (0, toHex_js_1.numberToHex)(index) : index,
            value
        ]
    });
} //# sourceMappingURL=setStorageAt.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/snapshot.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.snapshot = snapshot;
async function snapshot(client) {
    return await client.request({
        method: 'evm_snapshot'
    });
} //# sourceMappingURL=snapshot.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/stopImpersonatingAccount.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.stopImpersonatingAccount = stopImpersonatingAccount;
async function stopImpersonatingAccount(client, param) {
    let { address } = param;
    await client.request({
        method: "".concat(client.mode, "_stopImpersonatingAccount"),
        params: [
            address
        ]
    });
} //# sourceMappingURL=stopImpersonatingAccount.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/decorators/test.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.testActions = testActions;
const dropTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/dropTransaction.js [app-client] (ecmascript)");
const dumpState_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/dumpState.js [app-client] (ecmascript)");
const getAutomine_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/getAutomine.js [app-client] (ecmascript)");
const getTxpoolContent_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/getTxpoolContent.js [app-client] (ecmascript)");
const getTxpoolStatus_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/getTxpoolStatus.js [app-client] (ecmascript)");
const impersonateAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/impersonateAccount.js [app-client] (ecmascript)");
const increaseTime_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/increaseTime.js [app-client] (ecmascript)");
const inspectTxpool_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/inspectTxpool.js [app-client] (ecmascript)");
const loadState_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/loadState.js [app-client] (ecmascript)");
const mine_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/mine.js [app-client] (ecmascript)");
const removeBlockTimestampInterval_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/removeBlockTimestampInterval.js [app-client] (ecmascript)");
const reset_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/reset.js [app-client] (ecmascript)");
const revert_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/revert.js [app-client] (ecmascript)");
const sendUnsignedTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/sendUnsignedTransaction.js [app-client] (ecmascript)");
const setAutomine_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setAutomine.js [app-client] (ecmascript)");
const setBalance_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setBalance.js [app-client] (ecmascript)");
const setBlockGasLimit_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setBlockGasLimit.js [app-client] (ecmascript)");
const setBlockTimestampInterval_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setBlockTimestampInterval.js [app-client] (ecmascript)");
const setCode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setCode.js [app-client] (ecmascript)");
const setCoinbase_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setCoinbase.js [app-client] (ecmascript)");
const setIntervalMining_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setIntervalMining.js [app-client] (ecmascript)");
const setLoggingEnabled_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setLoggingEnabled.js [app-client] (ecmascript)");
const setMinGasPrice_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setMinGasPrice.js [app-client] (ecmascript)");
const setNextBlockBaseFeePerGas_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setNextBlockBaseFeePerGas.js [app-client] (ecmascript)");
const setNextBlockTimestamp_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setNextBlockTimestamp.js [app-client] (ecmascript)");
const setNonce_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setNonce.js [app-client] (ecmascript)");
const setRpcUrl_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setRpcUrl.js [app-client] (ecmascript)");
const setStorageAt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/setStorageAt.js [app-client] (ecmascript)");
const snapshot_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/snapshot.js [app-client] (ecmascript)");
const stopImpersonatingAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/test/stopImpersonatingAccount.js [app-client] (ecmascript)");
function testActions(param) {
    let { mode } = param;
    return (client_)=>{
        const client = client_.extend(()=>({
                mode
            }));
        return {
            dropTransaction: (args)=>(0, dropTransaction_js_1.dropTransaction)(client, args),
            dumpState: ()=>(0, dumpState_js_1.dumpState)(client),
            getAutomine: ()=>(0, getAutomine_js_1.getAutomine)(client),
            getTxpoolContent: ()=>(0, getTxpoolContent_js_1.getTxpoolContent)(client),
            getTxpoolStatus: ()=>(0, getTxpoolStatus_js_1.getTxpoolStatus)(client),
            impersonateAccount: (args)=>(0, impersonateAccount_js_1.impersonateAccount)(client, args),
            increaseTime: (args)=>(0, increaseTime_js_1.increaseTime)(client, args),
            inspectTxpool: ()=>(0, inspectTxpool_js_1.inspectTxpool)(client),
            loadState: (args)=>(0, loadState_js_1.loadState)(client, args),
            mine: (args)=>(0, mine_js_1.mine)(client, args),
            removeBlockTimestampInterval: ()=>(0, removeBlockTimestampInterval_js_1.removeBlockTimestampInterval)(client),
            reset: (args)=>(0, reset_js_1.reset)(client, args),
            revert: (args)=>(0, revert_js_1.revert)(client, args),
            sendUnsignedTransaction: (args)=>(0, sendUnsignedTransaction_js_1.sendUnsignedTransaction)(client, args),
            setAutomine: (args)=>(0, setAutomine_js_1.setAutomine)(client, args),
            setBalance: (args)=>(0, setBalance_js_1.setBalance)(client, args),
            setBlockGasLimit: (args)=>(0, setBlockGasLimit_js_1.setBlockGasLimit)(client, args),
            setBlockTimestampInterval: (args)=>(0, setBlockTimestampInterval_js_1.setBlockTimestampInterval)(client, args),
            setCode: (args)=>(0, setCode_js_1.setCode)(client, args),
            setCoinbase: (args)=>(0, setCoinbase_js_1.setCoinbase)(client, args),
            setIntervalMining: (args)=>(0, setIntervalMining_js_1.setIntervalMining)(client, args),
            setLoggingEnabled: (args)=>(0, setLoggingEnabled_js_1.setLoggingEnabled)(client, args),
            setMinGasPrice: (args)=>(0, setMinGasPrice_js_1.setMinGasPrice)(client, args),
            setNextBlockBaseFeePerGas: (args)=>(0, setNextBlockBaseFeePerGas_js_1.setNextBlockBaseFeePerGas)(client, args),
            setNextBlockTimestamp: (args)=>(0, setNextBlockTimestamp_js_1.setNextBlockTimestamp)(client, args),
            setNonce: (args)=>(0, setNonce_js_1.setNonce)(client, args),
            setRpcUrl: (args)=>(0, setRpcUrl_js_1.setRpcUrl)(client, args),
            setStorageAt: (args)=>(0, setStorageAt_js_1.setStorageAt)(client, args),
            snapshot: ()=>(0, snapshot_js_1.snapshot)(client),
            stopImpersonatingAccount: (args)=>(0, stopImpersonatingAccount_js_1.stopImpersonatingAccount)(client, args)
        };
    };
} //# sourceMappingURL=test.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createTestClient.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createTestClient = createTestClient;
const createClient_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createClient.js [app-client] (ecmascript)");
const test_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/decorators/test.js [app-client] (ecmascript)");
function createTestClient(parameters) {
    const { key = 'test', name = 'Test Client', mode } = parameters;
    const client = (0, createClient_js_1.createClient)({
        ...parameters,
        key,
        name,
        type: 'testClient'
    });
    return client.extend((config)=>({
            mode,
            ...(0, test_js_1.testActions)({
                mode
            })(config)
        }));
} //# sourceMappingURL=createTestClient.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/addChain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.addChain = addChain;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function addChain(client, param) {
    let { chain } = param;
    const { id, name, nativeCurrency, rpcUrls, blockExplorers } = chain;
    await client.request({
        method: 'wallet_addEthereumChain',
        params: [
            {
                chainId: (0, toHex_js_1.numberToHex)(id),
                chainName: name,
                nativeCurrency,
                rpcUrls: rpcUrls.default.http,
                blockExplorerUrls: blockExplorers ? Object.values(blockExplorers).map((param)=>{
                    let { url } = param;
                    return url;
                }) : undefined
            }
        ]
    }, {
        dedupe: true,
        retryCount: 0
    });
} //# sourceMappingURL=addChain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/deployContract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deployContract = deployContract;
const encodeDeployData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/encodeDeployData.js [app-client] (ecmascript)");
const sendTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransaction.js [app-client] (ecmascript)");
function deployContract(walletClient, parameters) {
    const { abi, args, bytecode, ...request } = parameters;
    const calldata = (0, encodeDeployData_js_1.encodeDeployData)({
        abi,
        args,
        bytecode
    });
    return (0, sendTransaction_js_1.sendTransaction)(walletClient, {
        ...request,
        ...request.authorizationList ? {
            to: null
        } : {},
        data: calldata
    });
} //# sourceMappingURL=deployContract.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getAddresses.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getAddresses = getAddresses;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
async function getAddresses(client) {
    var _client_account;
    if (((_client_account = client.account) === null || _client_account === void 0 ? void 0 : _client_account.type) === 'local') return [
        client.account.address
    ];
    const addresses = await client.request({
        method: 'eth_accounts'
    }, {
        dedupe: true
    });
    return addresses.map((address)=>(0, getAddress_js_1.checksumAddress)(address));
} //# sourceMappingURL=getAddresses.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getCapabilities.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getCapabilities = getCapabilities;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function getCapabilities(client) {
    let parameters = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { account = client.account, chainId } = parameters;
    const account_ = account ? (0, parseAccount_js_1.parseAccount)(account) : undefined;
    const params = chainId ? [
        account_ === null || account_ === void 0 ? void 0 : account_.address,
        [
            (0, toHex_js_1.numberToHex)(chainId)
        ]
    ] : [
        account_ === null || account_ === void 0 ? void 0 : account_.address
    ];
    const capabilities_raw = await client.request({
        method: 'wallet_getCapabilities',
        params
    });
    const capabilities = {};
    for (const [chainId, capabilities_] of Object.entries(capabilities_raw)){
        capabilities[Number(chainId)] = {};
        for (let [key, value] of Object.entries(capabilities_)){
            if (key === 'addSubAccount') key = 'unstable_addSubAccount';
            capabilities[Number(chainId)][key] = value;
        }
    }
    return typeof chainId === 'number' ? capabilities[chainId] : capabilities;
} //# sourceMappingURL=getCapabilities.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getPermissions.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getPermissions = getPermissions;
async function getPermissions(client) {
    const permissions = await client.request({
        method: 'wallet_getPermissions'
    }, {
        dedupe: true
    });
    return permissions;
} //# sourceMappingURL=getPermissions.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareAuthorization.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.prepareAuthorization = prepareAuthorization;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const isAddressEqual_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/isAddressEqual.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
const getTransactionCount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getTransactionCount.js [app-client] (ecmascript)");
async function prepareAuthorization(client, parameters) {
    var _client_chain;
    const { account: account_ = client.account, chainId, nonce } = parameters;
    if (!account_) throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/eip7702/prepareAuthorization'
    });
    const account = (0, parseAccount_js_1.parseAccount)(account_);
    const executor = (()=>{
        if (!parameters.executor) return undefined;
        if (parameters.executor === 'self') return parameters.executor;
        return (0, parseAccount_js_1.parseAccount)(parameters.executor);
    })();
    var _parameters_contractAddress;
    const authorization = {
        address: (_parameters_contractAddress = parameters.contractAddress) !== null && _parameters_contractAddress !== void 0 ? _parameters_contractAddress : parameters.address,
        chainId,
        nonce
    };
    var _client_chain_id;
    if (typeof authorization.chainId === 'undefined') authorization.chainId = (_client_chain_id = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : _client_chain.id) !== null && _client_chain_id !== void 0 ? _client_chain_id : await (0, getAction_js_1.getAction)(client, getChainId_js_1.getChainId, 'getChainId')({});
    if (typeof authorization.nonce === 'undefined') {
        authorization.nonce = await (0, getAction_js_1.getAction)(client, getTransactionCount_js_1.getTransactionCount, 'getTransactionCount')({
            address: account.address,
            blockTag: 'pending'
        });
        if (executor === 'self' || (executor === null || executor === void 0 ? void 0 : executor.address) && (0, isAddressEqual_js_1.isAddressEqual)(executor.address, account.address)) authorization.nonce += 1;
    }
    return authorization;
} //# sourceMappingURL=prepareAuthorization.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/requestAddresses.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.requestAddresses = requestAddresses;
const getAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/address/getAddress.js [app-client] (ecmascript)");
async function requestAddresses(client) {
    const addresses = await client.request({
        method: 'eth_requestAccounts'
    }, {
        dedupe: true,
        retryCount: 0
    });
    return addresses.map((address)=>(0, getAddress_js_1.getAddress)(address));
} //# sourceMappingURL=requestAddresses.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/requestPermissions.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.requestPermissions = requestPermissions;
async function requestPermissions(client, permissions) {
    return client.request({
        method: 'wallet_requestPermissions',
        params: [
            permissions
        ]
    }, {
        retryCount: 0
    });
} //# sourceMappingURL=requestPermissions.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendCallsSync.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sendCallsSync = sendCallsSync;
const sendCalls_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendCalls.js [app-client] (ecmascript)");
const waitForCallsStatus_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/waitForCallsStatus.js [app-client] (ecmascript)");
async function sendCallsSync(client, parameters) {
    const { chain = client.chain } = parameters;
    var _chain_blockTime, _parameters_timeout;
    const timeout = (_parameters_timeout = parameters.timeout) !== null && _parameters_timeout !== void 0 ? _parameters_timeout : Math.max(((_chain_blockTime = chain === null || chain === void 0 ? void 0 : chain.blockTime) !== null && _chain_blockTime !== void 0 ? _chain_blockTime : 0) * 3, 5_000);
    const result = await (0, sendCalls_js_1.sendCalls)(client, parameters);
    const status = await (0, waitForCallsStatus_js_1.waitForCallsStatus)(client, {
        ...parameters,
        id: result.id,
        timeout
    });
    return status;
} //# sourceMappingURL=sendCallsSync.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransactionSync.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sendTransactionSync = sendTransactionSync;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
const transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transaction.js [app-client] (ecmascript)");
const recoverAuthorizationAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/authorization/recoverAuthorizationAddress.js [app-client] (ecmascript)");
const assertCurrentChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/assertCurrentChain.js [app-client] (ecmascript)");
const getTransactionError_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/errors/getTransactionError.js [app-client] (ecmascript)");
const extract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/extract.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const lru_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/lru.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
const waitForTransactionReceipt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/waitForTransactionReceipt.js [app-client] (ecmascript)");
const prepareTransactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareTransactionRequest.js [app-client] (ecmascript)");
const sendRawTransactionSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransactionSync.js [app-client] (ecmascript)");
const supportsWalletNamespace = new lru_js_1.LruMap(128);
async function sendTransactionSync(client, parameters) {
    const { account: account_ = client.account, chain = client.chain, accessList, authorizationList, blobs, data, gas, gasPrice, maxFeePerBlobGas, maxFeePerGas, maxPriorityFeePerGas, nonce, pollingInterval, throwOnReceiptRevert, type, value, ...rest } = parameters;
    var _chain_blockTime, _parameters_timeout;
    const timeout = (_parameters_timeout = parameters.timeout) !== null && _parameters_timeout !== void 0 ? _parameters_timeout : Math.max(((_chain_blockTime = chain === null || chain === void 0 ? void 0 : chain.blockTime) !== null && _chain_blockTime !== void 0 ? _chain_blockTime : 0) * 3, 5_000);
    if (typeof account_ === 'undefined') throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/actions/wallet/sendTransactionSync'
    });
    const account = account_ ? (0, parseAccount_js_1.parseAccount)(account_) : null;
    try {
        (0, assertRequest_js_1.assertRequest)(parameters);
        const to = await (async ()=>{
            if (parameters.to) return parameters.to;
            if (parameters.to === null) return undefined;
            if (authorizationList && authorizationList.length > 0) return await (0, recoverAuthorizationAddress_js_1.recoverAuthorizationAddress)({
                authorization: authorizationList[0]
            }).catch(()=>{
                throw new base_js_1.BaseError('`to` is required. Could not infer from `authorizationList`.');
            });
            return undefined;
        })();
        if ((account === null || account === void 0 ? void 0 : account.type) === 'json-rpc' || account === null) {
            var _client_chain_formatters_transactionRequest, _client_chain_formatters, _client_chain;
            let chainId;
            if (chain !== null) {
                chainId = await (0, getAction_js_1.getAction)(client, getChainId_js_1.getChainId, 'getChainId')({});
                (0, assertCurrentChain_js_1.assertCurrentChain)({
                    currentChainId: chainId,
                    chain
                });
            }
            const chainFormat = (_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : (_client_chain_formatters = _client_chain.formatters) === null || _client_chain_formatters === void 0 ? void 0 : (_client_chain_formatters_transactionRequest = _client_chain_formatters.transactionRequest) === null || _client_chain_formatters_transactionRequest === void 0 ? void 0 : _client_chain_formatters_transactionRequest.format;
            const format = chainFormat || transactionRequest_js_1.formatTransactionRequest;
            const request = format({
                ...(0, extract_js_1.extract)(rest, {
                    format: chainFormat
                }),
                accessList,
                account,
                authorizationList,
                blobs,
                chainId,
                data,
                gas,
                gasPrice,
                maxFeePerBlobGas,
                maxFeePerGas,
                maxPriorityFeePerGas,
                nonce,
                to,
                type,
                value
            }, 'sendTransaction');
            const isWalletNamespaceSupported = supportsWalletNamespace.get(client.uid);
            const method = isWalletNamespaceSupported ? 'wallet_sendTransaction' : 'eth_sendTransaction';
            const hash = await (async ()=>{
                try {
                    return await client.request({
                        method,
                        params: [
                            request
                        ]
                    }, {
                        retryCount: 0
                    });
                } catch (e) {
                    if (isWalletNamespaceSupported === false) throw e;
                    const error = e;
                    if (error.name === 'InvalidInputRpcError' || error.name === 'InvalidParamsRpcError' || error.name === 'MethodNotFoundRpcError' || error.name === 'MethodNotSupportedRpcError') {
                        return await client.request({
                            method: 'wallet_sendTransaction',
                            params: [
                                request
                            ]
                        }, {
                            retryCount: 0
                        }).then((hash)=>{
                            supportsWalletNamespace.set(client.uid, true);
                            return hash;
                        }).catch((e)=>{
                            const walletNamespaceError = e;
                            if (walletNamespaceError.name === 'MethodNotFoundRpcError' || walletNamespaceError.name === 'MethodNotSupportedRpcError') {
                                supportsWalletNamespace.set(client.uid, false);
                                throw error;
                            }
                            throw walletNamespaceError;
                        });
                    }
                    throw error;
                }
            })();
            const receipt = await (0, getAction_js_1.getAction)(client, waitForTransactionReceipt_js_1.waitForTransactionReceipt, 'waitForTransactionReceipt')({
                checkReplacement: false,
                hash,
                pollingInterval,
                timeout
            });
            if (throwOnReceiptRevert && receipt.status === 'reverted') throw new transaction_js_1.TransactionReceiptRevertedError({
                receipt
            });
            return receipt;
        }
        if ((account === null || account === void 0 ? void 0 : account.type) === 'local') {
            var _chain_serializers;
            const request = await (0, getAction_js_1.getAction)(client, prepareTransactionRequest_js_1.prepareTransactionRequest, 'prepareTransactionRequest')({
                account,
                accessList,
                authorizationList,
                blobs,
                chain,
                data,
                gas,
                gasPrice,
                maxFeePerBlobGas,
                maxFeePerGas,
                maxPriorityFeePerGas,
                nonce,
                nonceManager: account.nonceManager,
                parameters: [
                    ...prepareTransactionRequest_js_1.defaultParameters,
                    'sidecars'
                ],
                type,
                value,
                ...rest,
                to
            });
            const serializer = chain === null || chain === void 0 ? void 0 : (_chain_serializers = chain.serializers) === null || _chain_serializers === void 0 ? void 0 : _chain_serializers.transaction;
            const serializedTransaction = await account.signTransaction(request, {
                serializer
            });
            return await (0, getAction_js_1.getAction)(client, sendRawTransactionSync_js_1.sendRawTransactionSync, 'sendRawTransactionSync')({
                serializedTransaction,
                throwOnReceiptRevert
            });
        }
        if ((account === null || account === void 0 ? void 0 : account.type) === 'smart') throw new account_js_1.AccountTypeNotSupportedError({
            metaMessages: [
                'Consider using the `sendUserOperation` Action instead.'
            ],
            docsPath: '/docs/actions/bundler/sendUserOperation',
            type: 'smart'
        });
        throw new account_js_1.AccountTypeNotSupportedError({
            docsPath: '/docs/actions/wallet/sendTransactionSync',
            type: account === null || account === void 0 ? void 0 : account.type
        });
    } catch (err) {
        if (err instanceof account_js_1.AccountTypeNotSupportedError) throw err;
        throw (0, getTransactionError_js_1.getTransactionError)(err, {
            ...parameters,
            account,
            chain: parameters.chain || undefined
        });
    }
} //# sourceMappingURL=sendTransactionSync.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/showCallsStatus.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.showCallsStatus = showCallsStatus;
async function showCallsStatus(client, parameters) {
    const { id } = parameters;
    await client.request({
        method: 'wallet_showCallsStatus',
        params: [
            id
        ]
    });
    return;
} //# sourceMappingURL=showCallsStatus.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signAuthorization.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.signAuthorization = signAuthorization;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const prepareAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareAuthorization.js [app-client] (ecmascript)");
async function signAuthorization(client, parameters) {
    const { account: account_ = client.account } = parameters;
    if (!account_) throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/eip7702/signAuthorization'
    });
    const account = (0, parseAccount_js_1.parseAccount)(account_);
    if (!account.signAuthorization) throw new account_js_1.AccountTypeNotSupportedError({
        docsPath: '/docs/eip7702/signAuthorization',
        metaMessages: [
            'The `signAuthorization` Action does not support JSON-RPC Accounts.'
        ],
        type: account.type
    });
    const authorization = await (0, prepareAuthorization_js_1.prepareAuthorization)(client, parameters);
    return account.signAuthorization(authorization);
} //# sourceMappingURL=signAuthorization.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signMessage.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.signMessage = signMessage;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function signMessage(client, param) {
    let { account: account_ = client.account, message } = param;
    if (!account_) throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/actions/wallet/signMessage'
    });
    const account = (0, parseAccount_js_1.parseAccount)(account_);
    if (account.signMessage) return account.signMessage({
        message
    });
    const message_ = (()=>{
        if (typeof message === 'string') return (0, toHex_js_1.stringToHex)(message);
        if (message.raw instanceof Uint8Array) return (0, toHex_js_1.toHex)(message.raw);
        return message.raw;
    })();
    return client.request({
        method: 'personal_sign',
        params: [
            message_,
            account.address
        ]
    }, {
        retryCount: 0
    });
} //# sourceMappingURL=signMessage.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signTransaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.signTransaction = signTransaction;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const assertCurrentChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/chain/assertCurrentChain.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
const transactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/formatters/transactionRequest.js [app-client] (ecmascript)");
const getAction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/getAction.js [app-client] (ecmascript)");
const assertRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/assertRequest.js [app-client] (ecmascript)");
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
async function signTransaction(client, parameters) {
    var _client_chain, _formatters_transactionRequest, _client_chain_serializers, _client_chain1;
    const { account: account_ = client.account, chain = client.chain, ...transaction } = parameters;
    if (!account_) throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/actions/wallet/signTransaction'
    });
    const account = (0, parseAccount_js_1.parseAccount)(account_);
    (0, assertRequest_js_1.assertRequest)({
        account,
        ...parameters
    });
    const chainId = await (0, getAction_js_1.getAction)(client, getChainId_js_1.getChainId, 'getChainId')({});
    if (chain !== null) (0, assertCurrentChain_js_1.assertCurrentChain)({
        currentChainId: chainId,
        chain
    });
    const formatters = (chain === null || chain === void 0 ? void 0 : chain.formatters) || ((_client_chain = client.chain) === null || _client_chain === void 0 ? void 0 : _client_chain.formatters);
    const format = (formatters === null || formatters === void 0 ? void 0 : (_formatters_transactionRequest = formatters.transactionRequest) === null || _formatters_transactionRequest === void 0 ? void 0 : _formatters_transactionRequest.format) || transactionRequest_js_1.formatTransactionRequest;
    if (account.signTransaction) return account.signTransaction({
        ...transaction,
        chainId
    }, {
        serializer: (_client_chain1 = client.chain) === null || _client_chain1 === void 0 ? void 0 : (_client_chain_serializers = _client_chain1.serializers) === null || _client_chain_serializers === void 0 ? void 0 : _client_chain_serializers.transaction
    });
    return await client.request({
        method: 'eth_signTransaction',
        params: [
            {
                ...format({
                    ...transaction,
                    account
                }, 'signTransaction'),
                chainId: (0, toHex_js_1.numberToHex)(chainId),
                from: account.address
            }
        ]
    }, {
        retryCount: 0
    });
} //# sourceMappingURL=signTransaction.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signTypedData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.signTypedData = signTypedData;
const parseAccount_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/accounts/utils/parseAccount.js [app-client] (ecmascript)");
const account_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/account.js [app-client] (ecmascript)");
const typedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/typedData.js [app-client] (ecmascript)");
async function signTypedData(client, parameters) {
    const { account: account_ = client.account, domain, message, primaryType } = parameters;
    if (!account_) throw new account_js_1.AccountNotFoundError({
        docsPath: '/docs/actions/wallet/signTypedData'
    });
    const account = (0, parseAccount_js_1.parseAccount)(account_);
    const types = {
        EIP712Domain: (0, typedData_js_1.getTypesForEIP712Domain)({
            domain
        }),
        ...parameters.types
    };
    (0, typedData_js_1.validateTypedData)({
        domain,
        message,
        primaryType,
        types
    });
    if (account.signTypedData) return account.signTypedData({
        domain,
        message,
        primaryType,
        types
    });
    const typedData = (0, typedData_js_1.serializeTypedData)({
        domain,
        message,
        primaryType,
        types
    });
    return client.request({
        method: 'eth_signTypedData_v4',
        params: [
            account.address,
            typedData
        ]
    }, {
        retryCount: 0
    });
} //# sourceMappingURL=signTypedData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/switchChain.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.switchChain = switchChain;
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
async function switchChain(client, param) {
    let { id } = param;
    await client.request({
        method: 'wallet_switchEthereumChain',
        params: [
            {
                chainId: (0, toHex_js_1.numberToHex)(id)
            }
        ]
    }, {
        retryCount: 0
    });
} //# sourceMappingURL=switchChain.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/watchAsset.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.watchAsset = watchAsset;
async function watchAsset(client, params) {
    const added = await client.request({
        method: 'wallet_watchAsset',
        params
    }, {
        retryCount: 0
    });
    return added;
} //# sourceMappingURL=watchAsset.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/writeContractSync.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.writeContractSync = writeContractSync;
const sendTransactionSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransactionSync.js [app-client] (ecmascript)");
const writeContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/writeContract.js [app-client] (ecmascript)");
async function writeContractSync(client, parameters) {
    return writeContract_js_1.writeContract.internal(client, sendTransactionSync_js_1.sendTransactionSync, 'sendTransactionSync', parameters);
} //# sourceMappingURL=writeContractSync.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/decorators/wallet.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.walletActions = walletActions;
const getChainId_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/public/getChainId.js [app-client] (ecmascript)");
const addChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/addChain.js [app-client] (ecmascript)");
const deployContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/deployContract.js [app-client] (ecmascript)");
const getAddresses_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getAddresses.js [app-client] (ecmascript)");
const getCallsStatus_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getCallsStatus.js [app-client] (ecmascript)");
const getCapabilities_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getCapabilities.js [app-client] (ecmascript)");
const getPermissions_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/getPermissions.js [app-client] (ecmascript)");
const prepareAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareAuthorization.js [app-client] (ecmascript)");
const prepareTransactionRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/prepareTransactionRequest.js [app-client] (ecmascript)");
const requestAddresses_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/requestAddresses.js [app-client] (ecmascript)");
const requestPermissions_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/requestPermissions.js [app-client] (ecmascript)");
const sendCalls_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendCalls.js [app-client] (ecmascript)");
const sendCallsSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendCallsSync.js [app-client] (ecmascript)");
const sendRawTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransaction.js [app-client] (ecmascript)");
const sendRawTransactionSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendRawTransactionSync.js [app-client] (ecmascript)");
const sendTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransaction.js [app-client] (ecmascript)");
const sendTransactionSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/sendTransactionSync.js [app-client] (ecmascript)");
const showCallsStatus_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/showCallsStatus.js [app-client] (ecmascript)");
const signAuthorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signAuthorization.js [app-client] (ecmascript)");
const signMessage_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signMessage.js [app-client] (ecmascript)");
const signTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signTransaction.js [app-client] (ecmascript)");
const signTypedData_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/signTypedData.js [app-client] (ecmascript)");
const switchChain_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/switchChain.js [app-client] (ecmascript)");
const waitForCallsStatus_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/waitForCallsStatus.js [app-client] (ecmascript)");
const watchAsset_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/watchAsset.js [app-client] (ecmascript)");
const writeContract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/writeContract.js [app-client] (ecmascript)");
const writeContractSync_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/actions/wallet/writeContractSync.js [app-client] (ecmascript)");
function walletActions(client) {
    return {
        addChain: (args)=>(0, addChain_js_1.addChain)(client, args),
        deployContract: (args)=>(0, deployContract_js_1.deployContract)(client, args),
        getAddresses: ()=>(0, getAddresses_js_1.getAddresses)(client),
        getCallsStatus: (args)=>(0, getCallsStatus_js_1.getCallsStatus)(client, args),
        getCapabilities: (args)=>(0, getCapabilities_js_1.getCapabilities)(client, args),
        getChainId: ()=>(0, getChainId_js_1.getChainId)(client),
        getPermissions: ()=>(0, getPermissions_js_1.getPermissions)(client),
        prepareAuthorization: (args)=>(0, prepareAuthorization_js_1.prepareAuthorization)(client, args),
        prepareTransactionRequest: (args)=>(0, prepareTransactionRequest_js_1.prepareTransactionRequest)(client, args),
        requestAddresses: ()=>(0, requestAddresses_js_1.requestAddresses)(client),
        requestPermissions: (args)=>(0, requestPermissions_js_1.requestPermissions)(client, args),
        sendCalls: (args)=>(0, sendCalls_js_1.sendCalls)(client, args),
        sendCallsSync: (args)=>(0, sendCallsSync_js_1.sendCallsSync)(client, args),
        sendRawTransaction: (args)=>(0, sendRawTransaction_js_1.sendRawTransaction)(client, args),
        sendRawTransactionSync: (args)=>(0, sendRawTransactionSync_js_1.sendRawTransactionSync)(client, args),
        sendTransaction: (args)=>(0, sendTransaction_js_1.sendTransaction)(client, args),
        sendTransactionSync: (args)=>(0, sendTransactionSync_js_1.sendTransactionSync)(client, args),
        showCallsStatus: (args)=>(0, showCallsStatus_js_1.showCallsStatus)(client, args),
        signAuthorization: (args)=>(0, signAuthorization_js_1.signAuthorization)(client, args),
        signMessage: (args)=>(0, signMessage_js_1.signMessage)(client, args),
        signTransaction: (args)=>(0, signTransaction_js_1.signTransaction)(client, args),
        signTypedData: (args)=>(0, signTypedData_js_1.signTypedData)(client, args),
        switchChain: (args)=>(0, switchChain_js_1.switchChain)(client, args),
        waitForCallsStatus: (args)=>(0, waitForCallsStatus_js_1.waitForCallsStatus)(client, args),
        watchAsset: (args)=>(0, watchAsset_js_1.watchAsset)(client, args),
        writeContract: (args)=>(0, writeContract_js_1.writeContract)(client, args),
        writeContractSync: (args)=>(0, writeContractSync_js_1.writeContractSync)(client, args)
    };
} //# sourceMappingURL=wallet.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createWalletClient.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createWalletClient = createWalletClient;
const createClient_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/createClient.js [app-client] (ecmascript)");
const wallet_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/decorators/wallet.js [app-client] (ecmascript)");
function createWalletClient(parameters) {
    const { key = 'wallet', name = 'Wallet Client', transport } = parameters;
    const client = (0, createClient_js_1.createClient)({
        ...parameters,
        key,
        name,
        transport,
        type: 'walletClient'
    });
    return client.extend(wallet_js_1.walletActions);
} //# sourceMappingURL=createWalletClient.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/createTransport.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createTransport = createTransport;
const buildRequest_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/buildRequest.js [app-client] (ecmascript)");
const uid_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/uid.js [app-client] (ecmascript)");
function createTransport(param, value) {
    let { key, methods, name, request, retryCount = 3, retryDelay = 150, timeout, type } = param;
    const uid = (0, uid_js_1.uid)();
    return {
        config: {
            key,
            methods,
            name,
            request,
            retryCount,
            retryDelay,
            timeout,
            type
        },
        request: (0, buildRequest_js_1.buildRequest)(request, {
            methods,
            retryCount,
            retryDelay,
            uid
        }),
        value
    };
} //# sourceMappingURL=createTransport.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/custom.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.custom = custom;
const createTransport_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/createTransport.js [app-client] (ecmascript)");
function custom(provider) {
    let config = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { key = 'custom', methods, name = 'Custom Provider', retryDelay } = config;
    return (param)=>{
        let { retryCount: defaultRetryCount } = param;
        var _config_retryCount;
        return (0, createTransport_js_1.createTransport)({
            key,
            methods,
            name,
            request: provider.request.bind(provider),
            retryCount: (_config_retryCount = config.retryCount) !== null && _config_retryCount !== void 0 ? _config_retryCount : defaultRetryCount,
            retryDelay,
            type: 'custom'
        });
    };
} //# sourceMappingURL=custom.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/fallback.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fallback = fallback;
exports.shouldThrow = shouldThrow;
exports.rankTransports = rankTransports;
const node_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/node.js [app-client] (ecmascript)");
const rpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/rpc.js [app-client] (ecmascript)");
const wait_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/wait.js [app-client] (ecmascript)");
const createTransport_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/createTransport.js [app-client] (ecmascript)");
function fallback(transports_) {
    let config = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { key = 'fallback', name = 'Fallback', rank = false, shouldThrow: shouldThrow_ = shouldThrow, retryCount, retryDelay } = config;
    return (param)=>{
        let { chain, pollingInterval = 4_000, timeout, ...rest } = param;
        let transports = transports_;
        let onResponse = ()=>{};
        const transport = (0, createTransport_js_1.createTransport)({
            key,
            name,
            async request (param) {
                let { method, params } = param;
                let includes;
                const fetch = async function() {
                    let i = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 0;
                    const transport = transports[i]({
                        ...rest,
                        chain,
                        retryCount: 0,
                        timeout
                    });
                    try {
                        const response = await transport.request({
                            method,
                            params
                        });
                        onResponse({
                            method,
                            params: params,
                            response,
                            transport,
                            status: 'success'
                        });
                        return response;
                    } catch (err) {
                        onResponse({
                            error: err,
                            method,
                            params: params,
                            transport,
                            status: 'error'
                        });
                        if (shouldThrow_(err)) throw err;
                        if (i === transports.length - 1) throw err;
                        includes !== null && includes !== void 0 ? includes : includes = transports.slice(i + 1).some((transport)=>{
                            const { include, exclude } = transport({
                                chain
                            }).config.methods || {};
                            if (include) return include.includes(method);
                            if (exclude) return !exclude.includes(method);
                            return true;
                        });
                        if (!includes) throw err;
                        return fetch(i + 1);
                    }
                };
                return fetch();
            },
            retryCount,
            retryDelay,
            type: 'fallback'
        }, {
            onResponse: (fn)=>onResponse = fn,
            transports: transports.map((fn)=>fn({
                    chain,
                    retryCount: 0
                }))
        });
        if (rank) {
            const rankOptions = typeof rank === 'object' ? rank : {};
            var _rankOptions_interval;
            rankTransports({
                chain,
                interval: (_rankOptions_interval = rankOptions.interval) !== null && _rankOptions_interval !== void 0 ? _rankOptions_interval : pollingInterval,
                onTransports: (transports_)=>transports = transports_,
                ping: rankOptions.ping,
                sampleCount: rankOptions.sampleCount,
                timeout: rankOptions.timeout,
                transports,
                weights: rankOptions.weights
            });
        }
        return transport;
    };
}
function shouldThrow(error) {
    if ('code' in error && typeof error.code === 'number') {
        if (error.code === rpc_js_1.TransactionRejectedRpcError.code || error.code === rpc_js_1.UserRejectedRequestError.code || node_js_1.ExecutionRevertedError.nodeMessage.test(error.message) || error.code === 5000) return true;
    }
    return false;
}
function rankTransports(param) {
    let { chain, interval = 4_000, onTransports, ping, sampleCount = 10, timeout = 1_000, transports, weights = {} } = param;
    const { stability: stabilityWeight = 0.7, latency: latencyWeight = 0.3 } = weights;
    const samples = [];
    const rankTransports_ = async ()=>{
        const sample = await Promise.all(transports.map(async (transport)=>{
            const transport_ = transport({
                chain,
                retryCount: 0,
                timeout
            });
            const start = Date.now();
            let end;
            let success;
            try {
                await (ping ? ping({
                    transport: transport_
                }) : transport_.request({
                    method: 'net_listening'
                }));
                success = 1;
            } catch (e) {
                success = 0;
            } finally{
                end = Date.now();
            }
            const latency = end - start;
            return {
                latency,
                success
            };
        }));
        samples.push(sample);
        if (samples.length > sampleCount) samples.shift();
        const maxLatency = Math.max(...samples.map((sample)=>Math.max(...sample.map((param)=>{
                let { latency } = param;
                return latency;
            }))));
        const scores = transports.map((_, i)=>{
            const latencies = samples.map((sample)=>sample[i].latency);
            const meanLatency = latencies.reduce((acc, latency)=>acc + latency, 0) / latencies.length;
            const latencyScore = 1 - meanLatency / maxLatency;
            const successes = samples.map((sample)=>sample[i].success);
            const stabilityScore = successes.reduce((acc, success)=>acc + success, 0) / successes.length;
            if (stabilityScore === 0) return [
                0,
                i
            ];
            return [
                latencyWeight * latencyScore + stabilityWeight * stabilityScore,
                i
            ];
        }).sort((a, b)=>b[0] - a[0]);
        onTransports(scores.map((param)=>{
            let [, i] = param;
            return transports[i];
        }));
        await (0, wait_js_1.wait)(interval);
        rankTransports_();
    };
    rankTransports_();
} //# sourceMappingURL=fallback.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transport.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.UrlRequiredError = void 0;
const base_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/base.js [app-client] (ecmascript)");
class UrlRequiredError extends base_js_1.BaseError {
    constructor(){
        super('No URL was provided to the Transport. Please provide a valid RPC URL to the Transport.', {
            docsPath: '/docs/clients/intro',
            name: 'UrlRequiredError'
        });
    }
}
exports.UrlRequiredError = UrlRequiredError; //# sourceMappingURL=transport.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/http.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.http = http;
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const transport_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transport.js [app-client] (ecmascript)");
const createBatchScheduler_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/promise/createBatchScheduler.js [app-client] (ecmascript)");
const http_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/http.js [app-client] (ecmascript)");
const createTransport_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/createTransport.js [app-client] (ecmascript)");
function http(url) {
    let config = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { batch, fetchFn, fetchOptions, key = 'http', methods, name = 'HTTP JSON-RPC', onFetchRequest, onFetchResponse, retryDelay, raw } = config;
    return (param)=>{
        let { chain, retryCount: retryCount_, timeout: timeout_ } = param;
        const { batchSize = 1000, wait = 0 } = typeof batch === 'object' ? batch : {};
        var _config_retryCount;
        const retryCount = (_config_retryCount = config.retryCount) !== null && _config_retryCount !== void 0 ? _config_retryCount : retryCount_;
        var _ref;
        const timeout = (_ref = timeout_ !== null && timeout_ !== void 0 ? timeout_ : config.timeout) !== null && _ref !== void 0 ? _ref : 10_000;
        const url_ = url || (chain === null || chain === void 0 ? void 0 : chain.rpcUrls.default.http[0]);
        if (!url_) throw new transport_js_1.UrlRequiredError();
        const rpcClient = (0, http_js_1.getHttpRpcClient)(url_, {
            fetchFn,
            fetchOptions,
            onRequest: onFetchRequest,
            onResponse: onFetchResponse,
            timeout
        });
        return (0, createTransport_js_1.createTransport)({
            key,
            methods,
            name,
            async request (param) {
                let { method, params } = param;
                const body = {
                    method,
                    params
                };
                const { schedule } = (0, createBatchScheduler_js_1.createBatchScheduler)({
                    id: url_,
                    wait,
                    shouldSplitBatch (requests) {
                        return requests.length > batchSize;
                    },
                    fn: (body)=>rpcClient.request({
                            body
                        }),
                    sort: (a, b)=>a.id - b.id
                });
                const fn = async (body)=>batch ? schedule(body) : [
                        await rpcClient.request({
                            body
                        })
                    ];
                const [{ error, result }] = await fn(body);
                if (raw) return {
                    error,
                    result
                };
                if (error) throw new request_js_1.RpcRequestError({
                    body,
                    error,
                    url: url_
                });
                return result;
            },
            retryCount,
            retryDelay,
            timeout,
            type: 'http'
        }, {
            fetchOptions,
            url: url_
        });
    };
} //# sourceMappingURL=http.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/webSocket.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.webSocket = webSocket;
const request_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/request.js [app-client] (ecmascript)");
const transport_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/transport.js [app-client] (ecmascript)");
const compat_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/compat.js [app-client] (ecmascript)");
const webSocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/rpc/webSocket.js [app-client] (ecmascript)");
const createTransport_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/clients/transports/createTransport.js [app-client] (ecmascript)");
function webSocket(url) {
    let config = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { keepAlive, key = 'webSocket', methods, name = 'WebSocket JSON-RPC', reconnect, retryDelay } = config;
    return (param)=>{
        let { chain, retryCount: retryCount_, timeout: timeout_ } = param;
        var _chain_rpcUrls_default_webSocket;
        var _config_retryCount;
        const retryCount = (_config_retryCount = config.retryCount) !== null && _config_retryCount !== void 0 ? _config_retryCount : retryCount_;
        var _ref;
        const timeout = (_ref = timeout_ !== null && timeout_ !== void 0 ? timeout_ : config.timeout) !== null && _ref !== void 0 ? _ref : 10_000;
        const url_ = url || (chain === null || chain === void 0 ? void 0 : (_chain_rpcUrls_default_webSocket = chain.rpcUrls.default.webSocket) === null || _chain_rpcUrls_default_webSocket === void 0 ? void 0 : _chain_rpcUrls_default_webSocket[0]);
        const wsRpcClientOpts = {
            keepAlive,
            reconnect
        };
        if (!url_) throw new transport_js_1.UrlRequiredError();
        return (0, createTransport_js_1.createTransport)({
            key,
            methods,
            name,
            async request (param) {
                let { method, params } = param;
                const body = {
                    method,
                    params
                };
                const rpcClient = await (0, webSocket_js_1.getWebSocketRpcClient)(url_, wsRpcClientOpts);
                const { error, result } = await rpcClient.requestAsync({
                    body,
                    timeout
                });
                if (error) throw new request_js_1.RpcRequestError({
                    body,
                    error,
                    url: url_
                });
                return result;
            },
            retryCount,
            retryDelay,
            timeout,
            type: 'webSocket'
        }, {
            getSocket () {
                return (0, compat_js_1.getSocket)(url_);
            },
            getRpcClient () {
                return (0, webSocket_js_1.getWebSocketRpcClient)(url_, wsRpcClientOpts);
            },
            async subscribe (param) {
                let { params, onData, onError } = param;
                const rpcClient = await (0, webSocket_js_1.getWebSocketRpcClient)(url_, wsRpcClientOpts);
                const { result: subscriptionId } = await new Promise((resolve, reject)=>rpcClient.request({
                        body: {
                            method: 'eth_subscribe',
                            params
                        },
                        onError (error) {
                            reject(error);
                            onError === null || onError === void 0 ? void 0 : onError(error);
                            return;
                        },
                        onResponse (response) {
                            if (response.error) {
                                reject(response.error);
                                onError === null || onError === void 0 ? void 0 : onError(response.error);
                                return;
                            }
                            if (typeof response.id === 'number') {
                                resolve(response);
                                return;
                            }
                            if (response.method !== 'eth_subscription') return;
                            onData(response.params);
                        }
                    }));
                return {
                    subscriptionId,
                    async unsubscribe () {
                        return new Promise((resolve)=>rpcClient.request({
                                body: {
                                    method: 'eth_unsubscribe',
                                    params: [
                                        subscriptionId
                                    ]
                                },
                                onResponse: resolve
                            }));
                    }
                };
            }
        });
    };
} //# sourceMappingURL=webSocket.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/types/eip1193.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ProviderRpcError = void 0;
class ProviderRpcError extends Error {
    constructor(code, message){
        super(message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "details", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.code = code;
        this.details = message;
    }
}
exports.ProviderRpcError = ProviderRpcError; //# sourceMappingURL=eip1193.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeDeployData.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeDeployData = decodeDeployData;
const abi_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/abi.js [app-client] (ecmascript)");
const decodeAbiParameters_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/abi/decodeAbiParameters.js [app-client] (ecmascript)");
const docsPath = '/docs/contract/decodeDeployData';
function decodeDeployData(parameters) {
    const { abi, bytecode, data } = parameters;
    if (data === bytecode) return {
        bytecode
    };
    const description = abi.find((x)=>'type' in x && x.type === 'constructor');
    if (!description) throw new abi_js_1.AbiConstructorNotFoundError({
        docsPath
    });
    if (!('inputs' in description)) throw new abi_js_1.AbiConstructorParamsNotFoundError({
        docsPath
    });
    if (!description.inputs || description.inputs.length === 0) throw new abi_js_1.AbiConstructorParamsNotFoundError({
        docsPath
    });
    const args = (0, decodeAbiParameters_js_1.decodeAbiParameters)(description.inputs, "0x".concat(data.replace(bytecode, '')));
    return {
        args,
        bytecode
    };
} //# sourceMappingURL=decodeDeployData.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/fromBlobs.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fromBlobs = fromBlobs;
const cursor_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/cursor.js [app-client] (ecmascript)");
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function fromBlobs(parameters) {
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof parameters.blobs[0] === 'string' ? 'hex' : 'bytes';
    const blobs = typeof parameters.blobs[0] === 'string' ? parameters.blobs.map((x)=>(0, toBytes_js_1.hexToBytes)(x)) : parameters.blobs;
    const length = blobs.reduce((length, blob)=>length + blob.length, 0);
    const data = (0, cursor_js_1.createCursor)(new Uint8Array(length));
    let active = true;
    for (const blob of blobs){
        const cursor = (0, cursor_js_1.createCursor)(blob);
        while(active && cursor.position < blob.length){
            cursor.incrementPosition(1);
            let consume = 31;
            if (blob.length - cursor.position < 31) consume = blob.length - cursor.position;
            for(const _ in Array.from({
                length: consume
            })){
                const byte = cursor.readByte();
                const isTerminator = byte === 0x80 && !cursor.inspectBytes(cursor.remaining).includes(0x80);
                if (isTerminator) {
                    active = false;
                    break;
                }
                data.pushByte(byte);
            }
        }
    }
    const trimmedData = data.bytes.slice(0, data.position);
    return to === 'hex' ? (0, toHex_js_1.bytesToHex)(trimmedData) : trimmedData;
} //# sourceMappingURL=fromBlobs.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/sidecarsToVersionedHashes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sidecarsToVersionedHashes = sidecarsToVersionedHashes;
const commitmentToVersionedHash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/blob/commitmentToVersionedHash.js [app-client] (ecmascript)");
function sidecarsToVersionedHashes(parameters) {
    const { sidecars, version } = parameters;
    var _parameters_to;
    const to = (_parameters_to = parameters.to) !== null && _parameters_to !== void 0 ? _parameters_to : typeof sidecars[0].blob === 'string' ? 'hex' : 'bytes';
    const hashes = [];
    for (const { commitment } of sidecars){
        hashes.push((0, commitmentToVersionedHash_js_1.commitmentToVersionedHash)({
            commitment,
            to,
            version
        }));
    }
    return hashes;
} //# sourceMappingURL=sidecarsToVersionedHashes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/ens/toCoinType.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toCoinType = toCoinType;
const ens_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/errors/ens.js [app-client] (ecmascript)");
const SLIP44_MSB = 0x80000000;
function toCoinType(chainId) {
    if (chainId === 1) return 60n;
    if (chainId >= SLIP44_MSB || chainId < 0) throw new ens_js_1.EnsInvalidChainIdError({
        chainId
    });
    return BigInt((0x80000000 | chainId) >>> 0);
} //# sourceMappingURL=toCoinType.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/kzg/defineKzg.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineKzg = defineKzg;
function defineKzg(param) {
    let { blobToKzgCommitment, computeBlobKzgProof } = param;
    return {
        blobToKzgCommitment,
        computeBlobKzgProof
    };
} //# sourceMappingURL=defineKzg.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/kzg/setupKzg.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.setupKzg = setupKzg;
const defineKzg_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/kzg/defineKzg.js [app-client] (ecmascript)");
function setupKzg(parameters, path) {
    try {
        parameters.loadTrustedSetup(path);
    } catch (e) {
        const error = e;
        if (!error.message.includes('trusted setup is already loaded')) throw error;
    }
    return (0, defineKzg_js_1.defineKzg)(parameters);
} //# sourceMappingURL=setupKzg.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/compactSignatureToSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.compactSignatureToSignature = compactSignatureToSignature;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function compactSignatureToSignature(param) {
    let { r, yParityAndS } = param;
    const yParityAndS_bytes = (0, toBytes_js_1.hexToBytes)(yParityAndS);
    const yParity = yParityAndS_bytes[0] & 0x80 ? 1 : 0;
    const s = yParityAndS_bytes;
    if (yParity === 1) s[0] &= 0x7f;
    return {
        r,
        s: (0, toHex_js_1.bytesToHex)(s),
        yParity
    };
} //# sourceMappingURL=compactSignatureToSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/parseCompactSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseCompactSignature = parseCompactSignature;
const secp256k1_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/secp256k1.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function parseCompactSignature(signatureHex) {
    const { r, s } = secp256k1_1.secp256k1.Signature.fromCompact(signatureHex.slice(2, 130));
    return {
        r: (0, toHex_js_1.numberToHex)(r, {
            size: 32
        }),
        yParityAndS: (0, toHex_js_1.numberToHex)(s, {
            size: 32
        })
    };
} //# sourceMappingURL=parseCompactSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/parseSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseSignature = parseSignature;
const secp256k1_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/secp256k1.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function parseSignature(signatureHex) {
    const { r, s } = secp256k1_1.secp256k1.Signature.fromCompact(signatureHex.slice(2, 130));
    const yParityOrV = Number("0x".concat(signatureHex.slice(130)));
    const [v, yParity] = (()=>{
        if (yParityOrV === 0 || yParityOrV === 1) return [
            undefined,
            yParityOrV
        ];
        if (yParityOrV === 27) return [
            BigInt(yParityOrV),
            0
        ];
        if (yParityOrV === 28) return [
            BigInt(yParityOrV),
            1
        ];
        throw new Error('Invalid yParityOrV value');
    })();
    if (typeof v !== 'undefined') return {
        r: (0, toHex_js_1.numberToHex)(r, {
            size: 32
        }),
        s: (0, toHex_js_1.numberToHex)(s, {
            size: 32
        }),
        v,
        yParity
    };
    return {
        r: (0, toHex_js_1.numberToHex)(r, {
            size: 32
        }),
        s: (0, toHex_js_1.numberToHex)(s, {
            size: 32
        }),
        yParity
    };
} //# sourceMappingURL=parseSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverTransactionAddress.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverTransactionAddress = recoverTransactionAddress;
const keccak256_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/hash/keccak256.js [app-client] (ecmascript)");
const parseTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/parseTransaction.js [app-client] (ecmascript)");
const serializeTransaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/transaction/serializeTransaction.js [app-client] (ecmascript)");
const recoverAddress_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/recoverAddress.js [app-client] (ecmascript)");
async function recoverTransactionAddress(parameters) {
    const { serializedTransaction, signature: signature_ } = parameters;
    const transaction = (0, parseTransaction_js_1.parseTransaction)(serializedTransaction);
    const signature = signature_ !== null && signature_ !== void 0 ? signature_ : {
        r: transaction.r,
        s: transaction.s,
        v: transaction.v,
        yParity: transaction.yParity
    };
    const serialized = (0, serializeTransaction_js_1.serializeTransaction)({
        ...transaction,
        r: undefined,
        s: undefined,
        v: undefined,
        yParity: undefined,
        sidecars: undefined
    });
    return await (0, recoverAddress_js_1.recoverAddress)({
        hash: (0, keccak256_js_1.keccak256)(serialized),
        signature
    });
} //# sourceMappingURL=recoverTransactionAddress.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/serializeCompactSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.serializeCompactSignature = serializeCompactSignature;
const secp256k1_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/secp256k1.js [app-client] (ecmascript)");
const fromHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/fromHex.js [app-client] (ecmascript)");
function serializeCompactSignature(param) {
    let { r, yParityAndS } = param;
    return "0x".concat(new secp256k1_1.secp256k1.Signature((0, fromHex_js_1.hexToBigInt)(r), (0, fromHex_js_1.hexToBigInt)(yParityAndS)).toCompactHex());
} //# sourceMappingURL=serializeCompactSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/signature/signatureToCompactSignature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.signatureToCompactSignature = signatureToCompactSignature;
const toBytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toBytes.js [app-client] (ecmascript)");
const toHex_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/utils/encoding/toHex.js [app-client] (ecmascript)");
function signatureToCompactSignature(signature) {
    const { r, s, v, yParity } = signature;
    const yParity_ = Number(yParity !== null && yParity !== void 0 ? yParity : v - 27n);
    let yParityAndS = s;
    if (yParity_ === 1) {
        const bytes = (0, toBytes_js_1.hexToBytes)(s);
        bytes[0] |= 0x80;
        yParityAndS = (0, toHex_js_1.bytesToHex)(bytes);
    }
    return {
        r,
        yParityAndS
    };
} //# sourceMappingURL=signatureToCompactSignature.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_cjs/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.maxInt8 = exports.universalSignatureValidatorByteCode = exports.erc6492SignatureValidatorByteCode = exports.deploylessCallViaFactoryBytecode = exports.deploylessCallViaBytecodeBytecode = exports.zeroHash = exports.zeroAddress = exports.ethAddress = exports.multicall3Abi = exports.universalSignatureValidatorAbi = exports.erc6492SignatureValidatorAbi = exports.erc4626Abi = exports.erc1155Abi = exports.erc721Abi = exports.erc20Abi_bytes32 = exports.erc20Abi = exports.webSocket = exports.http = exports.shouldThrow = exports.fallback = exports.custom = exports.createTransport = exports.walletActions = exports.testActions = exports.publicActions = exports.createWalletClient = exports.createTestClient = exports.createPublicClient = exports.rpcSchema = exports.createClient = exports.WaitForCallsStatusTimeoutError = exports.getContract = exports.UnknownTypeError = exports.UnknownSignatureError = exports.SolidityProtectedKeywordError = exports.parseAbiParameters = exports.parseAbiParameter = exports.parseAbiItem = exports.parseAbi = exports.InvalidStructSignatureError = exports.InvalidSignatureError = exports.InvalidParenthesisError = exports.InvalidParameterError = exports.InvalidModifierError = exports.InvalidFunctionModifierError = exports.InvalidAbiTypeParameterError = exports.InvalidAbiParametersError = exports.InvalidAbiParameterError = exports.InvalidAbiItemError = exports.CircularReferenceError = void 0;
exports.maxUint152 = exports.maxUint144 = exports.maxUint136 = exports.maxUint128 = exports.maxUint120 = exports.maxUint112 = exports.maxUint104 = exports.maxUint96 = exports.maxUint88 = exports.maxUint80 = exports.maxUint72 = exports.maxUint64 = exports.maxUint56 = exports.maxUint48 = exports.maxUint40 = exports.maxUint32 = exports.maxUint24 = exports.maxUint16 = exports.maxUint8 = exports.maxInt256 = exports.maxInt248 = exports.maxInt240 = exports.maxInt232 = exports.maxInt224 = exports.maxInt216 = exports.maxInt208 = exports.maxInt200 = exports.maxInt192 = exports.maxInt184 = exports.maxInt176 = exports.maxInt168 = exports.maxInt160 = exports.maxInt152 = exports.maxInt144 = exports.maxInt136 = exports.maxInt128 = exports.maxInt120 = exports.maxInt112 = exports.maxInt104 = exports.maxInt96 = exports.maxInt88 = exports.maxInt80 = exports.maxInt72 = exports.maxInt64 = exports.maxInt56 = exports.maxInt48 = exports.maxInt40 = exports.maxInt32 = exports.maxInt24 = exports.maxInt16 = void 0;
exports.AbiConstructorNotFoundError = exports.weiUnits = exports.gweiUnits = exports.etherUnits = exports.presignMessagePrefix = exports.minInt256 = exports.minInt248 = exports.minInt240 = exports.minInt232 = exports.minInt224 = exports.minInt216 = exports.minInt208 = exports.minInt200 = exports.minInt192 = exports.minInt184 = exports.minInt176 = exports.minInt168 = exports.minInt160 = exports.minInt152 = exports.minInt144 = exports.minInt136 = exports.minInt128 = exports.minInt120 = exports.minInt112 = exports.minInt104 = exports.minInt96 = exports.minInt88 = exports.minInt80 = exports.minInt72 = exports.minInt64 = exports.minInt56 = exports.minInt48 = exports.minInt40 = exports.minInt32 = exports.minInt24 = exports.minInt16 = exports.minInt8 = exports.maxUint256 = exports.maxUint248 = exports.maxUint240 = exports.maxUint232 = exports.maxUint224 = exports.maxUint216 = exports.maxUint208 = exports.maxUint200 = exports.maxUint192 = exports.maxUint184 = exports.maxUint176 = exports.maxUint168 = exports.maxUint160 = void 0;
exports.EnsAvatarUriResolutionError = exports.EnsAvatarUnsupportedNamespaceError = exports.EnsAvatarInvalidNftUriError = exports.SizeOverflowError = exports.InvalidHexValueError = exports.InvalidHexBooleanError = exports.InvalidBytesBooleanError = exports.IntegerOutOfRangeError = exports.SliceOffsetOutOfBoundsError = exports.SizeExceedsPaddingSizeError = exports.RawContractError = exports.CounterfactualDeploymentFailedError = exports.ContractFunctionZeroDataError = exports.ContractFunctionRevertedError = exports.ContractFunctionExecutionError = exports.CallExecutionError = exports.InvalidChainIdError = exports.ClientChainNotConfiguredError = exports.ChainNotFoundError = exports.ChainMismatchError = exports.ChainDoesNotSupportContract = exports.BundleFailedError = exports.BlockNotFoundError = exports.setErrorConfig = exports.BaseError = exports.InvalidAddressError = exports.UnsupportedPackedAbiType = exports.InvalidDefinitionTypeError = exports.InvalidArrayError = exports.InvalidAbiEncodingTypeError = exports.InvalidAbiDecodingTypeError = exports.DecodeLogTopicsMismatch = exports.DecodeLogDataMismatch = exports.BytesSizeMismatchError = exports.AbiFunctionSignatureNotFoundError = exports.AbiFunctionOutputsNotFoundError = exports.AbiFunctionNotFoundError = exports.AbiEventSignatureNotFoundError = exports.AbiEventSignatureEmptyTopicsError = exports.AbiEventNotFoundError = exports.AbiErrorSignatureNotFoundError = exports.AbiErrorNotFoundError = exports.AbiErrorInputsNotFoundError = exports.AbiEncodingLengthMismatchError = exports.AbiEncodingBytesSizeMismatchError = exports.AbiEncodingArrayLengthMismatchError = exports.AbiDecodingZeroDataError = exports.AbiDecodingDataSizeTooSmallError = exports.AbiDecodingDataSizeInvalidError = exports.AbiConstructorParamsNotFoundError = void 0;
exports.UnsupportedProviderMethodError = exports.UnsupportedNonOptionalCapabilityError = exports.UnsupportedChainIdError = exports.UnknownRpcError = exports.UnknownBundleIdError = exports.UnauthorizedProviderError = exports.TransactionRejectedRpcError = exports.SwitchChainError = exports.RpcError = exports.ResourceUnavailableRpcError = exports.ResourceNotFoundRpcError = exports.ProviderRpcError = exports.ProviderDisconnectedError = exports.ParseRpcError = exports.MethodNotSupportedRpcError = exports.MethodNotFoundRpcError = exports.LimitExceededRpcError = exports.JsonRpcVersionUnsupportedError = exports.InvalidRequestRpcError = exports.InvalidParamsRpcError = exports.InvalidInputRpcError = exports.InternalRpcError = exports.DuplicateIdError = exports.ChainDisconnectedError = exports.BundleTooLargeError = exports.AtomicReadyWalletRejectedUpgradeError = exports.AtomicityNotSupportedError = exports.WebSocketRequestError = exports.TimeoutError = exports.SocketClosedError = exports.RpcRequestError = exports.HttpRequestError = exports.UnknownNodeError = exports.TransactionTypeNotSupportedError = exports.TipAboveFeeCapError = exports.NonceTooLowError = exports.NonceTooHighError = exports.NonceMaxValueError = exports.IntrinsicGasTooLowError = exports.IntrinsicGasTooHighError = exports.InsufficientFundsError = exports.FeeCapTooLowError = exports.FeeCapTooHighError = exports.ExecutionRevertedError = exports.FilterTypeNotSupportedError = exports.MaxFeePerGasTooLowError = exports.Eip1559FeesNotSupportedError = exports.BaseFeeScalarError = exports.EstimateGasExecutionError = exports.EnsInvalidChainIdError = void 0;
exports.toBlobs = exports.toBlobSidecars = exports.sidecarsToVersionedHashes = exports.fromBlobs = exports.commitmentToVersionedHash = exports.commitmentsToVersionedHashes = exports.blobsToProofs = exports.blobsToCommitments = exports.isAddressEqual = exports.isAddress = exports.getCreateAddress = exports.getCreate2Address = exports.getContractAddress = exports.getAddress = exports.checksumAddress = exports.prepareEncodeFunctionData = exports.parseEventLogs = exports.getAbiItem = exports.encodePacked = exports.encodeFunctionResult = exports.encodeFunctionData = exports.encodeEventTopics = exports.encodeErrorResult = exports.encodeDeployData = exports.encodeAbiParameters = exports.decodeFunctionResult = exports.decodeFunctionData = exports.decodeEventLog = exports.decodeErrorResult = exports.decodeDeployData = exports.decodeAbiParameters = exports.EIP1193ProviderRpcError = exports.InvalidDecimalNumberError = exports.InvalidStructTypeError = exports.InvalidPrimaryTypeError = exports.InvalidDomainError = exports.UrlRequiredError = exports.WaitForTransactionReceiptTimeoutError = exports.TransactionReceiptNotFoundError = exports.TransactionNotFoundError = exports.TransactionExecutionError = exports.InvalidStorageKeySizeError = exports.InvalidSerializedTransactionTypeError = exports.InvalidSerializedTransactionError = exports.InvalidSerializableTransactionError = exports.InvalidLegacyVError = exports.FeeConflictError = exports.StateAssignmentConflictError = exports.AccountStateConflictError = exports.UserRejectedRequestError = void 0;
exports.getContractError = exports.toCoinType = exports.namehash = exports.labelhash = exports.toRlp = exports.hexToRlp = exports.bytesToRlp = exports.toHex = exports.stringToHex = exports.numberToHex = exports.bytesToHex = exports.boolToHex = exports.toBytes = exports.stringToBytes = exports.numberToBytes = exports.hexToBytes = exports.boolToBytes = exports.fromRlp = exports.hexToString = exports.hexToNumber = exports.hexToBool = exports.hexToBigInt = exports.fromHex = exports.fromBytes = exports.bytesToString = exports.bytesToNumber = exports.bytesToBool = exports.bytesToBigInt = exports.trim = exports.sliceHex = exports.sliceBytes = exports.slice = exports.size = exports.padHex = exports.padBytes = exports.pad = exports.isHex = exports.isBytes = exports.concatHex = exports.concatBytes = exports.concat = exports.getChainContractAddress = exports.extractChain = exports.defineChain = exports.assertCurrentChain = exports.offchainLookupSignature = exports.offchainLookupAbiItem = exports.offchainLookup = exports.ccipFetch = exports.ccipRequest = void 0;
exports.recoverTypedDataAddress = exports.recoverTransactionAddress = exports.recoverPublicKey = exports.recoverMessageAddress = exports.recoverAddress = exports.parseSignature = exports.hexToSignature = exports.parseErc8010Signature = exports.parseErc6492Signature = exports.parseCompactSignature = exports.hexToCompactSignature = exports.isErc8010Signature = exports.isErc6492Signature = exports.hashTypedData = exports.hashStruct = exports.hashDomain = exports.hashMessage = exports.compactSignatureToSignature = exports.withTimeout = exports.withRetry = exports.withCache = exports.nonceManager = exports.createNonceManager = exports.setupKzg = exports.defineKzg = exports.getFunctionSignature = exports.toFunctionSignature = exports.getFunctionSelector = exports.toFunctionSelector = exports.toFunctionHash = exports.getEventSignature = exports.toEventSignature = exports.getEventSelector = exports.toEventSelector = exports.toEventHash = exports.sha256 = exports.ripemd160 = exports.keccak256 = exports.isHash = exports.rpcTransactionType = exports.formatTransactionRequest = exports.defineTransactionRequest = exports.formatTransactionReceipt = exports.defineTransactionReceipt = exports.transactionType = exports.formatTransaction = exports.defineTransaction = exports.formatLog = exports.formatBlock = exports.defineBlock = void 0;
exports.parseUnits = exports.parseGwei = exports.parseEther = exports.formatUnits = exports.formatGwei = exports.formatEther = exports.validateTypedData = exports.serializeTypedData = exports.getTypesForEIP712Domain = exports.domainSeparator = exports.serializeTransaction = exports.serializeAccessList = exports.parseTransaction = exports.getTransactionType = exports.getSerializedTransactionType = exports.assertTransactionLegacy = exports.assertTransactionEIP2930 = exports.assertTransactionEIP1559 = exports.assertRequest = exports.stringify = exports.verifyTypedData = exports.verifyMessage = exports.verifyHash = exports.toPrefixedMessage = exports.signatureToCompactSignature = exports.serializeSignature = exports.signatureToHex = exports.serializeErc8010Signature = exports.serializeErc6492Signature = exports.serializeCompactSignature = exports.compactSignatureToHex = void 0;
var abitype_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/cjs/exports/i