(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/_version.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/* Do NOT modify this file; see /src.ts/_admin/update-version.ts */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.version = void 0;
/**
 *  The current version of Ethers.
 */ exports.version = "6.15.0"; //# sourceMappingURL=_version.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  Property helper functions.
 *
 *  @_subsection api/utils:Properties  [about-properties]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defineProperties = exports.resolveProperties = void 0;
function checkType(value, type, name) {
    const types = type.split("|").map((t)=>t.trim());
    for(let i = 0; i < types.length; i++){
        switch(type){
            case "any":
                return;
            case "bigint":
            case "boolean":
            case "number":
            case "string":
                if (typeof value === type) {
                    return;
                }
        }
    }
    const error = new Error("invalid value for type ".concat(type));
    error.code = "INVALID_ARGUMENT";
    error.argument = "value.".concat(name);
    error.value = value;
    throw error;
}
/**
 *  Resolves to a new object that is a copy of %%value%%, but with all
 *  values resolved.
 */ async function resolveProperties(value) {
    const keys = Object.keys(value);
    const results = await Promise.all(keys.map((k)=>Promise.resolve(value[k])));
    return results.reduce((accum, v, index)=>{
        accum[keys[index]] = v;
        return accum;
    }, {});
}
exports.resolveProperties = resolveProperties;
/**
 *  Assigns the %%values%% to %%target%% as read-only values.
 *
 *  It %%types%% is specified, the values are checked.
 */ function defineProperties(target, values, types) {
    for(let key in values){
        let value = values[key];
        const type = types ? types[key] : null;
        if (type) {
            checkType(value, type, key);
        }
        Object.defineProperty(target, key, {
            enumerable: true,
            value,
            writable: false
        });
    }
}
exports.defineProperties = defineProperties; //# sourceMappingURL=properties.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  All errors in ethers include properties to ensure they are both
 *  human-readable (i.e. ``.message``) and machine-readable (i.e. ``.code``).
 *
 *  The [[isError]] function can be used to check the error ``code`` and
 *  provide a type guard for the properties present on that error interface.
 *
 *  @_section: api/utils/errors:Errors  [about-errors]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.assertPrivate = exports.assertNormalize = exports.assertArgumentCount = exports.assertArgument = exports.assert = exports.makeError = exports.isCallException = exports.isError = void 0;
const _version_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/_version.js [app-client] (ecmascript)");
const properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
function stringify(value, seen) {
    if (value == null) {
        return "null";
    }
    if (seen == null) {
        seen = new Set();
    }
    if (typeof value === "object") {
        if (seen.has(value)) {
            return "[Circular]";
        }
        seen.add(value);
    }
    if (Array.isArray(value)) {
        return "[ " + value.map((v)=>stringify(v, seen)).join(", ") + " ]";
    }
    if (value instanceof Uint8Array) {
        const HEX = "0123456789abcdef";
        let result = "0x";
        for(let i = 0; i < value.length; i++){
            result += HEX[value[i] >> 4];
            result += HEX[value[i] & 0xf];
        }
        return result;
    }
    if (typeof value === "object" && typeof value.toJSON === "function") {
        return stringify(value.toJSON(), seen);
    }
    switch(typeof value){
        case "boolean":
        case "number":
        case "symbol":
            return value.toString();
        case "bigint":
            return BigInt(value).toString();
        case "string":
            return JSON.stringify(value);
        case "object":
            {
                const keys = Object.keys(value);
                keys.sort();
                return "{ " + keys.map((k)=>"".concat(stringify(k, seen), ": ").concat(stringify(value[k], seen))).join(", ") + " }";
            }
    }
    return "[ COULD NOT SERIALIZE ]";
}
/**
 *  Returns true if the %%error%% matches an error thrown by ethers
 *  that matches the error %%code%%.
 *
 *  In TypeScript environments, this can be used to check that %%error%%
 *  matches an EthersError type, which means the expected properties will
 *  be set.
 *
 *  @See [ErrorCodes](api:ErrorCode)
 *  @example
 *    try {
 *      // code....
 *    } catch (e) {
 *      if (isError(e, "CALL_EXCEPTION")) {
 *          // The Type Guard has validated this object
 *          console.log(e.data);
 *      }
 *    }
 */ function isError(error, code) {
    return error && error.code === code;
}
exports.isError = isError;
/**
 *  Returns true if %%error%% is a [[CallExceptionError].
 */ function isCallException(error) {
    return isError(error, "CALL_EXCEPTION");
}
exports.isCallException = isCallException;
/**
 *  Returns a new Error configured to the format ethers emits errors, with
 *  the %%message%%, [[api:ErrorCode]] %%code%% and additional properties
 *  for the corresponding EthersError.
 *
 *  Each error in ethers includes the version of ethers, a
 *  machine-readable [[ErrorCode]], and depending on %%code%%, additional
 *  required properties. The error message will also include the %%message%%,
 *  ethers version, %%code%% and all additional properties, serialized.
 */ function makeError(message, code, info) {
    let shortMessage = message;
    {
        const details = [];
        if (info) {
            if ("message" in info || "code" in info || "name" in info) {
                throw new Error("value will overwrite populated values: ".concat(stringify(info)));
            }
            for(const key in info){
                if (key === "shortMessage") {
                    continue;
                }
                const value = info[key];
                //                try {
                details.push(key + "=" + stringify(value));
            //                } catch (error: any) {
            //                console.log("MMM", error.message);
            //                    details.push(key + "=[could not serialize object]");
            //                }
            }
        }
        details.push("code=".concat(code));
        details.push("version=".concat(_version_js_1.version));
        if (details.length) {
            message += " (" + details.join(", ") + ")";
        }
    }
    let error;
    switch(code){
        case "INVALID_ARGUMENT":
            error = new TypeError(message);
            break;
        case "NUMERIC_FAULT":
        case "BUFFER_OVERRUN":
            error = new RangeError(message);
            break;
        default:
            error = new Error(message);
    }
    (0, properties_js_1.defineProperties)(error, {
        code
    });
    if (info) {
        Object.assign(error, info);
    }
    if (error.shortMessage == null) {
        (0, properties_js_1.defineProperties)(error, {
            shortMessage
        });
    }
    return error;
}
exports.makeError = makeError;
/**
 *  Throws an EthersError with %%message%%, %%code%% and additional error
 *  %%info%% when %%check%% is falsish..
 *
 *  @see [[api:makeError]]
 */ function assert(check, message, code, info) {
    if (!check) {
        throw makeError(message, code, info);
    }
}
exports.assert = assert;
/**
 *  A simple helper to simply ensuring provided arguments match expected
 *  constraints, throwing if not.
 *
 *  In TypeScript environments, the %%check%% has been asserted true, so
 *  any further code does not need additional compile-time checks.
 */ function assertArgument(check, message, name, value) {
    assert(check, message, "INVALID_ARGUMENT", {
        argument: name,
        value: value
    });
}
exports.assertArgument = assertArgument;
function assertArgumentCount(count, expectedCount, message) {
    if (message == null) {
        message = "";
    }
    if (message) {
        message = ": " + message;
    }
    assert(count >= expectedCount, "missing argument" + message, "MISSING_ARGUMENT", {
        count: count,
        expectedCount: expectedCount
    });
    assert(count <= expectedCount, "too many arguments" + message, "UNEXPECTED_ARGUMENT", {
        count: count,
        expectedCount: expectedCount
    });
}
exports.assertArgumentCount = assertArgumentCount;
const _normalizeForms = [
    "NFD",
    "NFC",
    "NFKD",
    "NFKC"
].reduce((accum, form)=>{
    try {
        // General test for normalize
        /* c8 ignore start */ if ("test".normalize(form) !== "test") {
            throw new Error("bad");
        }
        ;
        /* c8 ignore stop */ if (form === "NFD") {
            const check = String.fromCharCode(0xe9).normalize("NFD");
            const expected = String.fromCharCode(0x65, 0x0301);
            /* c8 ignore start */ if (check !== expected) {
                throw new Error("broken");
            }
        /* c8 ignore stop */ }
        accum.push(form);
    } catch (error) {}
    return accum;
}, []);
/**
 *  Throws if the normalization %%form%% is not supported.
 */ function assertNormalize(form) {
    assert(_normalizeForms.indexOf(form) >= 0, "platform missing String.prototype.normalize", "UNSUPPORTED_OPERATION", {
        operation: "String.prototype.normalize",
        info: {
            form
        }
    });
}
exports.assertNormalize = assertNormalize;
/**
 *  Many classes use file-scoped values to guard the constructor,
 *  making it effectively private. This facilitates that pattern
 *  by ensuring the %%givenGaurd%% matches the file-scoped %%guard%%,
 *  throwing if not, indicating the %%className%% if provided.
 */ function assertPrivate(givenGuard, guard, className) {
    if (className == null) {
        className = "";
    }
    if (givenGuard !== guard) {
        let method = className, operation = "new";
        if (className) {
            method += ".";
            operation += " " + className;
        }
        assert(false, "private constructor; use ".concat(method, "from* methods"), "UNSUPPORTED_OPERATION", {
            operation
        });
    }
}
exports.assertPrivate = assertPrivate; //# sourceMappingURL=errors.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.zeroPadBytes = exports.zeroPadValue = exports.stripZerosLeft = exports.dataSlice = exports.dataLength = exports.concat = exports.hexlify = exports.isBytesLike = exports.isHexString = exports.getBytesCopy = exports.getBytes = void 0;
/**
 *  Some data helpers.
 *
 *
 *  @_subsection api/utils:Data Helpers  [about-data]
 */ const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
function _getBytes(value, name, copy) {
    if (value instanceof Uint8Array) {
        if (copy) {
            return new Uint8Array(value);
        }
        return value;
    }
    if (typeof value === "string" && value.match(/^0x(?:[0-9a-f][0-9a-f])*$/i)) {
        const result = new Uint8Array((value.length - 2) / 2);
        let offset = 2;
        for(let i = 0; i < result.length; i++){
            result[i] = parseInt(value.substring(offset, offset + 2), 16);
            offset += 2;
        }
        return result;
    }
    (0, errors_js_1.assertArgument)(false, "invalid BytesLike value", name || "value", value);
}
/**
 *  Get a typed Uint8Array for %%value%%. If already a Uint8Array
 *  the original %%value%% is returned; if a copy is required use
 *  [[getBytesCopy]].
 *
 *  @see: getBytesCopy
 */ function getBytes(value, name) {
    return _getBytes(value, name, false);
}
exports.getBytes = getBytes;
/**
 *  Get a typed Uint8Array for %%value%%, creating a copy if necessary
 *  to prevent any modifications of the returned value from being
 *  reflected elsewhere.
 *
 *  @see: getBytes
 */ function getBytesCopy(value, name) {
    return _getBytes(value, name, true);
}
exports.getBytesCopy = getBytesCopy;
/**
 *  Returns true if %%value%% is a valid [[HexString]].
 *
 *  If %%length%% is ``true`` or a //number//, it also checks that
 *  %%value%% is a valid [[DataHexString]] of %%length%% (if a //number//)
 *  bytes of data (e.g. ``0x1234`` is 2 bytes).
 */ function isHexString(value, length) {
    if (typeof value !== "string" || !value.match(/^0x[0-9A-Fa-f]*$/)) {
        return false;
    }
    if (typeof length === "number" && value.length !== 2 + 2 * length) {
        return false;
    }
    if (length === true && value.length % 2 !== 0) {
        return false;
    }
    return true;
}
exports.isHexString = isHexString;
/**
 *  Returns true if %%value%% is a valid representation of arbitrary
 *  data (i.e. a valid [[DataHexString]] or a Uint8Array).
 */ function isBytesLike(value) {
    return isHexString(value, true) || value instanceof Uint8Array;
}
exports.isBytesLike = isBytesLike;
const HexCharacters = "0123456789abcdef";
/**
 *  Returns a [[DataHexString]] representation of %%data%%.
 */ function hexlify(data) {
    const bytes = getBytes(data);
    let result = "0x";
    for(let i = 0; i < bytes.length; i++){
        const v = bytes[i];
        result += HexCharacters[(v & 0xf0) >> 4] + HexCharacters[v & 0x0f];
    }
    return result;
}
exports.hexlify = hexlify;
/**
 *  Returns a [[DataHexString]] by concatenating all values
 *  within %%data%%.
 */ function concat(datas) {
    return "0x" + datas.map((d)=>hexlify(d).substring(2)).join("");
}
exports.concat = concat;
/**
 *  Returns the length of %%data%%, in bytes.
 */ function dataLength(data) {
    if (isHexString(data, true)) {
        return (data.length - 2) / 2;
    }
    return getBytes(data).length;
}
exports.dataLength = dataLength;
/**
 *  Returns a [[DataHexString]] by slicing %%data%% from the %%start%%
 *  offset to the %%end%% offset.
 *
 *  By default %%start%% is 0 and %%end%% is the length of %%data%%.
 */ function dataSlice(data, start, end) {
    const bytes = getBytes(data);
    if (end != null && end > bytes.length) {
        (0, errors_js_1.assert)(false, "cannot slice beyond data bounds", "BUFFER_OVERRUN", {
            buffer: bytes,
            length: bytes.length,
            offset: end
        });
    }
    return hexlify(bytes.slice(start == null ? 0 : start, end == null ? bytes.length : end));
}
exports.dataSlice = dataSlice;
/**
 *  Return the [[DataHexString]] result by stripping all **leading**
 ** zero bytes from %%data%%.
 */ function stripZerosLeft(data) {
    let bytes = hexlify(data).substring(2);
    while(bytes.startsWith("00")){
        bytes = bytes.substring(2);
    }
    return "0x" + bytes;
}
exports.stripZerosLeft = stripZerosLeft;
function zeroPad(data, length, left) {
    const bytes = getBytes(data);
    (0, errors_js_1.assert)(length >= bytes.length, "padding exceeds data length", "BUFFER_OVERRUN", {
        buffer: new Uint8Array(bytes),
        length: length,
        offset: length + 1
    });
    const result = new Uint8Array(length);
    result.fill(0);
    if (left) {
        result.set(bytes, length - bytes.length);
    } else {
        result.set(bytes, 0);
    }
    return hexlify(result);
}
/**
 *  Return the [[DataHexString]] of %%data%% padded on the **left**
 *  to %%length%% bytes.
 *
 *  If %%data%% already exceeds %%length%%, a [[BufferOverrunError]] is
 *  thrown.
 *
 *  This pads data the same as **values** are in Solidity
 *  (e.g. ``uint128``).
 */ function zeroPadValue(data, length) {
    return zeroPad(data, length, true);
}
exports.zeroPadValue = zeroPadValue;
/**
 *  Return the [[DataHexString]] of %%data%% padded on the **right**
 *  to %%length%% bytes.
 *
 *  If %%data%% already exceeds %%length%%, a [[BufferOverrunError]] is
 *  thrown.
 *
 *  This pads data the same as **bytes** are in Solidity
 *  (e.g. ``bytes16``).
 */ function zeroPadBytes(data, length) {
    return zeroPad(data, length, false);
}
exports.zeroPadBytes = zeroPadBytes; //# sourceMappingURL=data.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/maths.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toQuantity = exports.toBeArray = exports.toBeHex = exports.toNumber = exports.getNumber = exports.toBigInt = exports.getUint = exports.getBigInt = exports.mask = exports.toTwos = exports.fromTwos = void 0;
/**
 *  Some mathematic operations.
 *
 *  @_subsection: api/utils:Math Helpers  [about-maths]
 */ const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
const BN_1 = BigInt(1);
//const BN_Max256 = (BN_1 << BigInt(256)) - BN_1;
// IEEE 754 support 53-bits of mantissa
const maxValue = 0x1fffffffffffff;
/**
 *  Convert %%value%% from a twos-compliment representation of %%width%%
 *  bits to its value.
 *
 *  If the highest bit is ``1``, the result will be negative.
 */ function fromTwos(_value, _width) {
    const value = getUint(_value, "value");
    const width = BigInt(getNumber(_width, "width"));
    (0, errors_js_1.assert)(value >> width === BN_0, "overflow", "NUMERIC_FAULT", {
        operation: "fromTwos",
        fault: "overflow",
        value: _value
    });
    // Top bit set; treat as a negative value
    if (value >> width - BN_1) {
        const mask = (BN_1 << width) - BN_1;
        return -((~value & mask) + BN_1);
    }
    return value;
}
exports.fromTwos = fromTwos;
/**
 *  Convert %%value%% to a twos-compliment representation of
 *  %%width%% bits.
 *
 *  The result will always be positive.
 */ function toTwos(_value, _width) {
    let value = getBigInt(_value, "value");
    const width = BigInt(getNumber(_width, "width"));
    const limit = BN_1 << width - BN_1;
    if (value < BN_0) {
        value = -value;
        (0, errors_js_1.assert)(value <= limit, "too low", "NUMERIC_FAULT", {
            operation: "toTwos",
            fault: "overflow",
            value: _value
        });
        const mask = (BN_1 << width) - BN_1;
        return (~value & mask) + BN_1;
    } else {
        (0, errors_js_1.assert)(value < limit, "too high", "NUMERIC_FAULT", {
            operation: "toTwos",
            fault: "overflow",
            value: _value
        });
    }
    return value;
}
exports.toTwos = toTwos;
/**
 *  Mask %%value%% with a bitmask of %%bits%% ones.
 */ function mask(_value, _bits) {
    const value = getUint(_value, "value");
    const bits = BigInt(getNumber(_bits, "bits"));
    return value & (BN_1 << bits) - BN_1;
}
exports.mask = mask;
/**
 *  Gets a BigInt from %%value%%. If it is an invalid value for
 *  a BigInt, then an ArgumentError will be thrown for %%name%%.
 */ function getBigInt(value, name) {
    switch(typeof value){
        case "bigint":
            return value;
        case "number":
            (0, errors_js_1.assertArgument)(Number.isInteger(value), "underflow", name || "value", value);
            (0, errors_js_1.assertArgument)(value >= -maxValue && value <= maxValue, "overflow", name || "value", value);
            return BigInt(value);
        case "string":
            try {
                if (value === "") {
                    throw new Error("empty string");
                }
                if (value[0] === "-" && value[1] !== "-") {
                    return -BigInt(value.substring(1));
                }
                return BigInt(value);
            } catch (e) {
                (0, errors_js_1.assertArgument)(false, "invalid BigNumberish string: ".concat(e.message), name || "value", value);
            }
    }
    (0, errors_js_1.assertArgument)(false, "invalid BigNumberish value", name || "value", value);
}
exports.getBigInt = getBigInt;
/**
 *  Returns %%value%% as a bigint, validating it is valid as a bigint
 *  value and that it is positive.
 */ function getUint(value, name) {
    const result = getBigInt(value, name);
    (0, errors_js_1.assert)(result >= BN_0, "unsigned value cannot be negative", "NUMERIC_FAULT", {
        fault: "overflow",
        operation: "getUint",
        value
    });
    return result;
}
exports.getUint = getUint;
const Nibbles = "0123456789abcdef";
/*
 * Converts %%value%% to a BigInt. If %%value%% is a Uint8Array, it
 * is treated as Big Endian data.
 */ function toBigInt(value) {
    if (value instanceof Uint8Array) {
        let result = "0x0";
        for (const v of value){
            result += Nibbles[v >> 4];
            result += Nibbles[v & 0x0f];
        }
        return BigInt(result);
    }
    return getBigInt(value);
}
exports.toBigInt = toBigInt;
/**
 *  Gets a //number// from %%value%%. If it is an invalid value for
 *  a //number//, then an ArgumentError will be thrown for %%name%%.
 */ function getNumber(value, name) {
    switch(typeof value){
        case "bigint":
            (0, errors_js_1.assertArgument)(value >= -maxValue && value <= maxValue, "overflow", name || "value", value);
            return Number(value);
        case "number":
            (0, errors_js_1.assertArgument)(Number.isInteger(value), "underflow", name || "value", value);
            (0, errors_js_1.assertArgument)(value >= -maxValue && value <= maxValue, "overflow", name || "value", value);
            return value;
        case "string":
            try {
                if (value === "") {
                    throw new Error("empty string");
                }
                return getNumber(BigInt(value), name);
            } catch (e) {
                (0, errors_js_1.assertArgument)(false, "invalid numeric string: ".concat(e.message), name || "value", value);
            }
    }
    (0, errors_js_1.assertArgument)(false, "invalid numeric value", name || "value", value);
}
exports.getNumber = getNumber;
/**
 *  Converts %%value%% to a number. If %%value%% is a Uint8Array, it
 *  is treated as Big Endian data. Throws if the value is not safe.
 */ function toNumber(value) {
    return getNumber(toBigInt(value));
}
exports.toNumber = toNumber;
/**
 *  Converts %%value%% to a Big Endian hexstring, optionally padded to
 *  %%width%% bytes.
 */ function toBeHex(_value, _width) {
    const value = getUint(_value, "value");
    let result = value.toString(16);
    if (_width == null) {
        // Ensure the value is of even length
        if (result.length % 2) {
            result = "0" + result;
        }
    } else {
        const width = getNumber(_width, "width");
        (0, errors_js_1.assert)(width * 2 >= result.length, "value exceeds width (".concat(width, " bytes)"), "NUMERIC_FAULT", {
            operation: "toBeHex",
            fault: "overflow",
            value: _value
        });
        // Pad the value to the required width
        while(result.length < width * 2){
            result = "0" + result;
        }
    }
    return "0x" + result;
}
exports.toBeHex = toBeHex;
/**
 *  Converts %%value%% to a Big Endian Uint8Array.
 */ function toBeArray(_value) {
    const value = getUint(_value, "value");
    if (value === BN_0) {
        return new Uint8Array([]);
    }
    let hex = value.toString(16);
    if (hex.length % 2) {
        hex = "0" + hex;
    }
    const result = new Uint8Array(hex.length / 2);
    for(let i = 0; i < result.length; i++){
        const offset = i * 2;
        result[i] = parseInt(hex.substring(offset, offset + 2), 16);
    }
    return result;
}
exports.toBeArray = toBeArray;
/**
 *  Returns a [[HexString]] for %%value%% safe to use as a //Quantity//.
 *
 *  A //Quantity// does not have and leading 0 values unless the value is
 *  the literal value `0x0`. This is most commonly used for JSSON-RPC
 *  numeric values.
 */ function toQuantity(value) {
    let result = (0, data_js_1.hexlify)((0, data_js_1.isBytesLike)(value) ? value : toBeArray(value)).substring(2);
    while(result.startsWith("0")){
        result = result.substring(1);
    }
    if (result === "") {
        result = "0";
    }
    return "0x" + result;
}
exports.toQuantity = toQuantity; //# sourceMappingURL=maths.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/base58.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  The [Base58 Encoding](link-base58) scheme allows a **numeric** value
 *  to be encoded as a compact string using a radix of 58 using only
 *  alpha-numeric characters. Confusingly similar characters are omitted
 *  (i.e. ``"l0O"``).
 *
 *  Note that Base58 encodes a **numeric** value, not arbitrary bytes,
 *  since any zero-bytes on the left would get removed. To mitigate this
 *  issue most schemes that use Base58 choose specific high-order values
 *  to ensure non-zero prefixes.
 *
 *  @_subsection: api/utils:Base58 Encoding [about-base58]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeBase58 = exports.encodeBase58 = void 0;
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
const maths_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/maths.js [app-client] (ecmascript)");
const Alphabet = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
let Lookup = null;
function getAlpha(letter) {
    if (Lookup == null) {
        Lookup = {};
        for(let i = 0; i < Alphabet.length; i++){
            Lookup[Alphabet[i]] = BigInt(i);
        }
    }
    const result = Lookup[letter];
    (0, errors_js_1.assertArgument)(result != null, "invalid base58 value", "letter", letter);
    return result;
}
const BN_0 = BigInt(0);
const BN_58 = BigInt(58);
/**
 *  Encode %%value%% as a Base58-encoded string.
 */ function encodeBase58(_value) {
    const bytes = (0, data_js_1.getBytes)(_value);
    let value = (0, maths_js_1.toBigInt)(bytes);
    let result = "";
    while(value){
        result = Alphabet[Number(value % BN_58)] + result;
        value /= BN_58;
    }
    // Account for leading padding zeros
    for(let i = 0; i < bytes.length; i++){
        if (bytes[i]) {
            break;
        }
        result = Alphabet[0] + result;
    }
    return result;
}
exports.encodeBase58 = encodeBase58;
/**
 *  Decode the Base58-encoded %%value%%.
 */ function decodeBase58(value) {
    let result = BN_0;
    for(let i = 0; i < value.length; i++){
        result *= BN_58;
        result += getAlpha(value[i]);
    }
    return result;
}
exports.decodeBase58 = decodeBase58; //# sourceMappingURL=base58.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/base64-browser.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

// utils/base64-browser
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeBase64 = exports.decodeBase64 = void 0;
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
function decodeBase64(textData) {
    textData = atob(textData);
    const data = new Uint8Array(textData.length);
    for(let i = 0; i < textData.length; i++){
        data[i] = textData.charCodeAt(i);
    }
    return (0, data_js_1.getBytes)(data);
}
exports.decodeBase64 = decodeBase64;
function encodeBase64(_data) {
    const data = (0, data_js_1.getBytes)(_data);
    let textData = "";
    for(let i = 0; i < data.length; i++){
        textData += String.fromCharCode(data[i]);
    }
    return btoa(textData);
}
exports.encodeBase64 = encodeBase64; //# sourceMappingURL=base64-browser.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/events.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.EventPayload = void 0;
/**
 *  Events allow for applications to use the observer pattern, which
 *  allows subscribing and publishing events, outside the normal
 *  execution paths.
 *
 *  @_section api/utils/events:Events  [about-events]
 */ const properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
var _listener = /*#__PURE__*/ new WeakMap();
/**
 *  When an [[EventEmitterable]] triggers a [[Listener]], the
 *  callback always ahas one additional argument passed, which is
 *  an **EventPayload**.
 */ class EventPayload {
    /**
     *  Unregister the triggered listener for future events.
     */ async removeListener() {
        if (_class_private_field_get._(this, _listener) == null) {
            return;
        }
        await this.emitter.off(this.filter, _class_private_field_get._(this, _listener));
    }
    /**
     *  Create a new **EventPayload** for %%emitter%% with
     *  the %%listener%% and for %%filter%%.
     */ constructor(emitter, listener, filter){
        /**
     *  The event filter.
     */ _define_property._(this, "filter", void 0);
        /**
     *  The **EventEmitterable**.
     */ _define_property._(this, "emitter", void 0);
        _class_private_field_init._(this, _listener, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _listener, listener);
        (0, properties_js_1.defineProperties)(this, {
            emitter,
            filter
        });
    }
}
exports.EventPayload = EventPayload; //# sourceMappingURL=events.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/utf8.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toUtf8CodePoints = exports.toUtf8String = exports.toUtf8Bytes = exports.Utf8ErrorFuncs = void 0;
/**
 *  Using strings in Ethereum (or any security-basd system) requires
 *  additional care. These utilities attempt to mitigate some of the
 *  safety issues as well as provide the ability to recover and analyse
 *  strings.
 *
 *  @_subsection api/utils:Strings and UTF-8  [about-strings]
 */ const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
function errorFunc(reason, offset, bytes, output, badCodepoint) {
    (0, errors_js_1.assertArgument)(false, "invalid codepoint at offset ".concat(offset, "; ").concat(reason), "bytes", bytes);
}
function ignoreFunc(reason, offset, bytes, output, badCodepoint) {
    // If there is an invalid prefix (including stray continuation), skip any additional continuation bytes
    if (reason === "BAD_PREFIX" || reason === "UNEXPECTED_CONTINUE") {
        let i = 0;
        for(let o = offset + 1; o < bytes.length; o++){
            if (bytes[o] >> 6 !== 0x02) {
                break;
            }
            i++;
        }
        return i;
    }
    // This byte runs us past the end of the string, so just jump to the end
    // (but the first byte was read already read and therefore skipped)
    if (reason === "OVERRUN") {
        return bytes.length - offset - 1;
    }
    // Nothing to skip
    return 0;
}
function replaceFunc(reason, offset, bytes, output, badCodepoint) {
    // Overlong representations are otherwise "valid" code points; just non-deistingtished
    if (reason === "OVERLONG") {
        (0, errors_js_1.assertArgument)(typeof badCodepoint === "number", "invalid bad code point for replacement", "badCodepoint", badCodepoint);
        output.push(badCodepoint);
        return 0;
    }
    // Put the replacement character into the output
    output.push(0xfffd);
    // Otherwise, process as if ignoring errors
    return ignoreFunc(reason, offset, bytes, output, badCodepoint);
}
/**
 *  A handful of popular, built-in UTF-8 error handling strategies.
 *
 *  **``"error"``** - throws on ANY illegal UTF-8 sequence or
 *  non-canonical (overlong) codepoints (this is the default)
 *
 *  **``"ignore"``** - silently drops any illegal UTF-8 sequence
 *  and accepts non-canonical (overlong) codepoints
 *
 *  **``"replace"``** - replace any illegal UTF-8 sequence with the
 *  UTF-8 replacement character (i.e. ``"\\ufffd"``) and accepts
 *  non-canonical (overlong) codepoints
 *
 *  @returns: Record<"error" | "ignore" | "replace", Utf8ErrorFunc>
 */ exports.Utf8ErrorFuncs = Object.freeze({
    error: errorFunc,
    ignore: ignoreFunc,
    replace: replaceFunc
});
// http://stackoverflow.com/questions/13356493/decode-utf-8-with-javascript#13691499
function getUtf8CodePoints(_bytes, onError) {
    if (onError == null) {
        onError = exports.Utf8ErrorFuncs.error;
    }
    const bytes = (0, data_js_1.getBytes)(_bytes, "bytes");
    const result = [];
    let i = 0;
    // Invalid bytes are ignored
    while(i < bytes.length){
        const c = bytes[i++];
        // 0xxx xxxx
        if (c >> 7 === 0) {
            result.push(c);
            continue;
        }
        // Multibyte; how many bytes left for this character?
        let extraLength = null;
        let overlongMask = null;
        // 110x xxxx 10xx xxxx
        if ((c & 0xe0) === 0xc0) {
            extraLength = 1;
            overlongMask = 0x7f;
        // 1110 xxxx 10xx xxxx 10xx xxxx
        } else if ((c & 0xf0) === 0xe0) {
            extraLength = 2;
            overlongMask = 0x7ff;
        // 1111 0xxx 10xx xxxx 10xx xxxx 10xx xxxx
        } else if ((c & 0xf8) === 0xf0) {
            extraLength = 3;
            overlongMask = 0xffff;
        } else {
            if ((c & 0xc0) === 0x80) {
                i += onError("UNEXPECTED_CONTINUE", i - 1, bytes, result);
            } else {
                i += onError("BAD_PREFIX", i - 1, bytes, result);
            }
            continue;
        }
        // Do we have enough bytes in our data?
        if (i - 1 + extraLength >= bytes.length) {
            i += onError("OVERRUN", i - 1, bytes, result);
            continue;
        }
        // Remove the length prefix from the char
        let res = c & (1 << 8 - extraLength - 1) - 1;
        for(let j = 0; j < extraLength; j++){
            let nextChar = bytes[i];
            // Invalid continuation byte
            if ((nextChar & 0xc0) != 0x80) {
                i += onError("MISSING_CONTINUE", i, bytes, result);
                res = null;
                break;
            }
            ;
            res = res << 6 | nextChar & 0x3f;
            i++;
        }
        // See above loop for invalid continuation byte
        if (res === null) {
            continue;
        }
        // Maximum code point
        if (res > 0x10ffff) {
            i += onError("OUT_OF_RANGE", i - 1 - extraLength, bytes, result, res);
            continue;
        }
        // Reserved for UTF-16 surrogate halves
        if (res >= 0xd800 && res <= 0xdfff) {
            i += onError("UTF16_SURROGATE", i - 1 - extraLength, bytes, result, res);
            continue;
        }
        // Check for overlong sequences (more bytes than needed)
        if (res <= overlongMask) {
            i += onError("OVERLONG", i - 1 - extraLength, bytes, result, res);
            continue;
        }
        result.push(res);
    }
    return result;
}
// http://stackoverflow.com/questions/18729405/how-to-convert-utf8-string-to-byte-array
/**
 *  Returns the UTF-8 byte representation of %%str%%.
 *
 *  If %%form%% is specified, the string is normalized.
 */ function toUtf8Bytes(str, form) {
    (0, errors_js_1.assertArgument)(typeof str === "string", "invalid string value", "str", str);
    if (form != null) {
        (0, errors_js_1.assertNormalize)(form);
        str = str.normalize(form);
    }
    let result = [];
    for(let i = 0; i < str.length; i++){
        const c = str.charCodeAt(i);
        if (c < 0x80) {
            result.push(c);
        } else if (c < 0x800) {
            result.push(c >> 6 | 0xc0);
            result.push(c & 0x3f | 0x80);
        } else if ((c & 0xfc00) == 0xd800) {
            i++;
            const c2 = str.charCodeAt(i);
            (0, errors_js_1.assertArgument)(i < str.length && (c2 & 0xfc00) === 0xdc00, "invalid surrogate pair", "str", str);
            // Surrogate Pair
            const pair = 0x10000 + ((c & 0x03ff) << 10) + (c2 & 0x03ff);
            result.push(pair >> 18 | 0xf0);
            result.push(pair >> 12 & 0x3f | 0x80);
            result.push(pair >> 6 & 0x3f | 0x80);
            result.push(pair & 0x3f | 0x80);
        } else {
            result.push(c >> 12 | 0xe0);
            result.push(c >> 6 & 0x3f | 0x80);
            result.push(c & 0x3f | 0x80);
        }
    }
    return new Uint8Array(result);
}
exports.toUtf8Bytes = toUtf8Bytes;
;
//export 
function _toUtf8String(codePoints) {
    return codePoints.map((codePoint)=>{
        if (codePoint <= 0xffff) {
            return String.fromCharCode(codePoint);
        }
        codePoint -= 0x10000;
        return String.fromCharCode((codePoint >> 10 & 0x3ff) + 0xd800, (codePoint & 0x3ff) + 0xdc00);
    }).join("");
}
/**
 *  Returns the string represented by the UTF-8 data %%bytes%%.
 *
 *  When %%onError%% function is specified, it is called on UTF-8
 *  errors allowing recovery using the [[Utf8ErrorFunc]] API.
 *  (default: [error](Utf8ErrorFuncs))
 */ function toUtf8String(bytes, onError) {
    return _toUtf8String(getUtf8CodePoints(bytes, onError));
}
exports.toUtf8String = toUtf8String;
/**
 *  Returns the UTF-8 code-points for %%str%%.
 *
 *  If %%form%% is specified, the string is normalized.
 */ function toUtf8CodePoints(str, form) {
    return getUtf8CodePoints(toUtf8Bytes(str, form));
}
exports.toUtf8CodePoints = toUtf8CodePoints; //# sourceMappingURL=utf8.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/geturl-browser.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getUrl = exports.createGetUrl = void 0;
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
function createGetUrl(options) {
    async function getUrl(req, _signal) {
        (0, errors_js_1.assert)(_signal == null || !_signal.cancelled, "request cancelled before sending", "CANCELLED");
        const protocol = req.url.split(":")[0].toLowerCase();
        (0, errors_js_1.assert)(protocol === "http" || protocol === "https", "unsupported protocol ".concat(protocol), "UNSUPPORTED_OPERATION", {
            info: {
                protocol
            },
            operation: "request"
        });
        (0, errors_js_1.assert)(protocol === "https" || !req.credentials || req.allowInsecureAuthentication, "insecure authorized connections unsupported", "UNSUPPORTED_OPERATION", {
            operation: "request"
        });
        let error = null;
        const controller = new AbortController();
        const timer = setTimeout(()=>{
            error = (0, errors_js_1.makeError)("request timeout", "TIMEOUT");
            controller.abort();
        }, req.timeout);
        if (_signal) {
            _signal.addListener(()=>{
                error = (0, errors_js_1.makeError)("request cancelled", "CANCELLED");
                controller.abort();
            });
        }
        const init = Object.assign({}, options, {
            method: req.method,
            headers: new Headers(Array.from(req)),
            body: req.body || undefined,
            signal: controller.signal
        });
        let resp;
        try {
            resp = await fetch(req.url, init);
        } catch (_error) {
            clearTimeout(timer);
            if (error) {
                throw error;
            }
            throw _error;
        }
        clearTimeout(timer);
        const headers = {};
        resp.headers.forEach((value, key)=>{
            headers[key.toLowerCase()] = value;
        });
        const respBody = await resp.arrayBuffer();
        const body = respBody == null ? null : new Uint8Array(respBody);
        return {
            statusCode: resp.status,
            statusMessage: resp.statusText,
            headers,
            body
        };
    }
    return getUrl;
}
exports.createGetUrl = createGetUrl;
// @TODO: remove in v7; provided for backwards compat
const defaultGetUrl = createGetUrl({});
async function getUrl(req, _signal) {
    return defaultGetUrl(req, _signal);
}
exports.getUrl = getUrl; //# sourceMappingURL=geturl-browser.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/fetch.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FetchResponse = exports.FetchRequest = exports.FetchCancelSignal = void 0;
/**
 *  Fetching content from the web is environment-specific, so Ethers
 *  provides an abstraction that each environment can implement to provide
 *  this service.
 *
 *  On [Node.js](link-node), the ``http`` and ``https`` libs are used to
 *  create a request object, register event listeners and process data
 *  and populate the [[FetchResponse]].
 *
 *  In a browser, the [DOM fetch](link-js-fetch) is used, and the resulting
 *  ``Promise`` is waited on to retrieve the payload.
 *
 *  The [[FetchRequest]] is responsible for handling many common situations,
 *  such as redirects, server throttling, authentication, etc.
 *
 *  It also handles common gateways, such as IPFS and data URIs.
 *
 *  @_section api/utils/fetching:Fetching Web Content  [about-fetch]
 */ const base64_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/base64-browser.js [app-client] (ecmascript)");
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
const properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
const utf8_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/utf8.js [app-client] (ecmascript)");
const geturl_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/geturl-browser.js [app-client] (ecmascript)");
const MAX_ATTEMPTS = 12;
const SLOT_INTERVAL = 250;
// The global FetchGetUrlFunc implementation.
let defaultGetUrlFunc = (0, geturl_js_1.createGetUrl)();
const reData = new RegExp("^data:([^;:]*)?(;base64)?,(.*)$", "i");
const reIpfs = new RegExp("^ipfs:/\/(ipfs/)?(.*)$", "i");
// If locked, new Gateways cannot be added
let locked = false;
// https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URLs
async function dataGatewayFunc(url, signal) {
    try {
        const match = url.match(reData);
        if (!match) {
            throw new Error("invalid data");
        }
        return new FetchResponse(200, "OK", {
            "content-type": match[1] || "text/plain"
        }, match[2] ? (0, base64_js_1.decodeBase64)(match[3]) : unpercent(match[3]));
    } catch (error) {
        return new FetchResponse(599, "BAD REQUEST (invalid data: URI)", {}, null, new FetchRequest(url));
    }
}
/**
 *  Returns a [[FetchGatewayFunc]] for fetching content from a standard
 *  IPFS gateway hosted at %%baseUrl%%.
 */ function getIpfsGatewayFunc(baseUrl) {
    async function gatewayIpfs(url, signal) {
        try {
            const match = url.match(reIpfs);
            if (!match) {
                throw new Error("invalid link");
            }
            return new FetchRequest("".concat(baseUrl).concat(match[2]));
        } catch (error) {
            return new FetchResponse(599, "BAD REQUEST (invalid IPFS URI)", {}, null, new FetchRequest(url));
        }
    }
    return gatewayIpfs;
}
const Gateways = {
    "data": dataGatewayFunc,
    "ipfs": getIpfsGatewayFunc("https:/\/gateway.ipfs.io/ipfs/")
};
const fetchSignals = new WeakMap();
var _listeners = /*#__PURE__*/ new WeakMap(), _cancelled = /*#__PURE__*/ new WeakMap();
/**
 *  @_ignore
 */ class FetchCancelSignal {
    addListener(listener) {
        (0, errors_js_1.assert)(!_class_private_field_get._(this, _cancelled), "singal already cancelled", "UNSUPPORTED_OPERATION", {
            operation: "fetchCancelSignal.addCancelListener"
        });
        _class_private_field_get._(this, _listeners).push(listener);
    }
    get cancelled() {
        return _class_private_field_get._(this, _cancelled);
    }
    checkSignal() {
        (0, errors_js_1.assert)(!this.cancelled, "cancelled", "CANCELLED", {});
    }
    constructor(request){
        _class_private_field_init._(this, _listeners, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _cancelled, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _listeners, []);
        _class_private_field_set._(this, _cancelled, false);
        fetchSignals.set(request, ()=>{
            if (_class_private_field_get._(this, _cancelled)) {
                return;
            }
            _class_private_field_set._(this, _cancelled, true);
            for (const listener of _class_private_field_get._(this, _listeners)){
                setTimeout(()=>{
                    listener();
                }, 0);
            }
            _class_private_field_set._(this, _listeners, []);
        });
    }
}
exports.FetchCancelSignal = FetchCancelSignal;
// Check the signal, throwing if it is cancelled
function checkSignal(signal) {
    if (signal == null) {
        throw new Error("missing signal; should not happen");
    }
    signal.checkSignal();
    return signal;
}
var _allowInsecure = /*#__PURE__*/ new WeakMap(), _gzip = /*#__PURE__*/ new WeakMap(), _headers = /*#__PURE__*/ new WeakMap(), _method = /*#__PURE__*/ new WeakMap(), _timeout = /*#__PURE__*/ new WeakMap(), _url = /*#__PURE__*/ new WeakMap(), _body = /*#__PURE__*/ new WeakMap(), _bodyType = /*#__PURE__*/ new WeakMap(), _creds = /*#__PURE__*/ new WeakMap(), // Hooks
_preflight = /*#__PURE__*/ new WeakMap(), _process = /*#__PURE__*/ new WeakMap(), _retry = /*#__PURE__*/ new WeakMap(), _signal = /*#__PURE__*/ new WeakMap(), _throttle = /*#__PURE__*/ new WeakMap(), _getUrlFunc = /*#__PURE__*/ new WeakMap(), _send = /*#__PURE__*/ new WeakSet();
/**
 *  Represents a request for a resource using a URI.
 *
 *  By default, the supported schemes are ``HTTP``, ``HTTPS``, ``data:``,
 *  and ``IPFS:``.
 *
 *  Additional schemes can be added globally using [[registerGateway]].
 *
 *  @example:
 *    req = new FetchRequest("https://www.ricmoo.com")
 *    resp = await req.send()
 *    resp.body.length
 *    //_result:
 */ class FetchRequest {
    /**
     *  The fetch URL to request.
     */ get url() {
        return _class_private_field_get._(this, _url);
    }
    set url(url) {
        _class_private_field_set._(this, _url, String(url));
    }
    /**
     *  The fetch body, if any, to send as the request body. //(default: null)//
     *
     *  When setting a body, the intrinsic ``Content-Type`` is automatically
     *  set and will be used if **not overridden** by setting a custom
     *  header.
     *
     *  If %%body%% is null, the body is cleared (along with the
     *  intrinsic ``Content-Type``).
     *
     *  If %%body%% is a string, the intrinsic ``Content-Type`` is set to
     *  ``text/plain``.
     *
     *  If %%body%% is a Uint8Array, the intrinsic ``Content-Type`` is set to
     *  ``application/octet-stream``.
     *
     *  If %%body%% is any other object, the intrinsic ``Content-Type`` is
     *  set to ``application/json``.
     */ get body() {
        if (_class_private_field_get._(this, _body) == null) {
            return null;
        }
        return new Uint8Array(_class_private_field_get._(this, _body));
    }
    set body(body) {
        if (body == null) {
            _class_private_field_set._(this, _body, undefined);
            _class_private_field_set._(this, _bodyType, undefined);
        } else if (typeof body === "string") {
            _class_private_field_set._(this, _body, (0, utf8_js_1.toUtf8Bytes)(body));
            _class_private_field_set._(this, _bodyType, "text/plain");
        } else if (body instanceof Uint8Array) {
            _class_private_field_set._(this, _body, body);
            _class_private_field_set._(this, _bodyType, "application/octet-stream");
        } else if (typeof body === "object") {
            _class_private_field_set._(this, _body, (0, utf8_js_1.toUtf8Bytes)(JSON.stringify(body)));
            _class_private_field_set._(this, _bodyType, "application/json");
        } else {
            throw new Error("invalid body");
        }
    }
    /**
     *  Returns true if the request has a body.
     */ hasBody() {
        return _class_private_field_get._(this, _body) != null;
    }
    /**
     *  The HTTP method to use when requesting the URI. If no method
     *  has been explicitly set, then ``GET`` is used if the body is
     *  null and ``POST`` otherwise.
     */ get method() {
        if (_class_private_field_get._(this, _method)) {
            return _class_private_field_get._(this, _method);
        }
        if (this.hasBody()) {
            return "POST";
        }
        return "GET";
    }
    set method(method) {
        if (method == null) {
            method = "";
        }
        _class_private_field_set._(this, _method, String(method).toUpperCase());
    }
    /**
     *  The headers that will be used when requesting the URI. All
     *  keys are lower-case.
     *
     *  This object is a copy, so any changes will **NOT** be reflected
     *  in the ``FetchRequest``.
     *
     *  To set a header entry, use the ``setHeader`` method.
     */ get headers() {
        const headers = Object.assign({}, _class_private_field_get._(this, _headers));
        if (_class_private_field_get._(this, _creds)) {
            headers["authorization"] = "Basic ".concat((0, base64_js_1.encodeBase64)((0, utf8_js_1.toUtf8Bytes)(_class_private_field_get._(this, _creds))));
        }
        ;
        if (this.allowGzip) {
            headers["accept-encoding"] = "gzip";
        }
        if (headers["content-type"] == null && _class_private_field_get._(this, _bodyType)) {
            headers["content-type"] = _class_private_field_get._(this, _bodyType);
        }
        if (this.body) {
            headers["content-length"] = String(this.body.length);
        }
        return headers;
    }
    /**
     *  Get the header for %%key%%, ignoring case.
     */ getHeader(key) {
        return this.headers[key.toLowerCase()];
    }
    /**
     *  Set the header for %%key%% to %%value%%. All values are coerced
     *  to a string.
     */ setHeader(key, value) {
        _class_private_field_get._(this, _headers)[String(key).toLowerCase()] = String(value);
    }
    /**
     *  Clear all headers, resetting all intrinsic headers.
     */ clearHeaders() {
        _class_private_field_set._(this, _headers, {});
    }
    [Symbol.iterator]() {
        const headers = this.headers;
        const keys = Object.keys(headers);
        let index = 0;
        return {
            next: ()=>{
                if (index < keys.length) {
                    const key = keys[index++];
                    return {
                        value: [
                            key,
                            headers[key]
                        ],
                        done: false
                    };
                }
                return {
                    value: undefined,
                    done: true
                };
            }
        };
    }
    /**
     *  The value that will be sent for the ``Authorization`` header.
     *
     *  To set the credentials, use the ``setCredentials`` method.
     */ get credentials() {
        return _class_private_field_get._(this, _creds) || null;
    }
    /**
     *  Sets an ``Authorization`` for %%username%% with %%password%%.
     */ setCredentials(username, password) {
        (0, errors_js_1.assertArgument)(!username.match(/:/), "invalid basic authentication username", "username", "[REDACTED]");
        _class_private_field_set._(this, _creds, "".concat(username, ":").concat(password));
    }
    /**
     *  Enable and request gzip-encoded responses. The response will
     *  automatically be decompressed. //(default: true)//
     */ get allowGzip() {
        return _class_private_field_get._(this, _gzip);
    }
    set allowGzip(value) {
        _class_private_field_set._(this, _gzip, !!value);
    }
    /**
     *  Allow ``Authentication`` credentials to be sent over insecure
     *  channels. //(default: false)//
     */ get allowInsecureAuthentication() {
        return !!_class_private_field_get._(this, _allowInsecure);
    }
    set allowInsecureAuthentication(value) {
        _class_private_field_set._(this, _allowInsecure, !!value);
    }
    /**
     *  The timeout (in milliseconds) to wait for a complete response.
     *  //(default: 5 minutes)//
     */ get timeout() {
        return _class_private_field_get._(this, _timeout);
    }
    set timeout(timeout) {
        (0, errors_js_1.assertArgument)(timeout >= 0, "timeout must be non-zero", "timeout", timeout);
        _class_private_field_set._(this, _timeout, timeout);
    }
    /**
     *  This function is called prior to each request, for example
     *  during a redirection or retry in case of server throttling.
     *
     *  This offers an opportunity to populate headers or update
     *  content before sending a request.
     */ get preflightFunc() {
        return _class_private_field_get._(this, _preflight) || null;
    }
    set preflightFunc(preflight) {
        _class_private_field_set._(this, _preflight, preflight);
    }
    /**
     *  This function is called after each response, offering an
     *  opportunity to provide client-level throttling or updating
     *  response data.
     *
     *  Any error thrown in this causes the ``send()`` to throw.
     *
     *  To schedule a retry attempt (assuming the maximum retry limit
     *  has not been reached), use [[response.throwThrottleError]].
     */ get processFunc() {
        return _class_private_field_get._(this, _process) || null;
    }
    set processFunc(process) {
        _class_private_field_set._(this, _process, process);
    }
    /**
     *  This function is called on each retry attempt.
     */ get retryFunc() {
        return _class_private_field_get._(this, _retry) || null;
    }
    set retryFunc(retry) {
        _class_private_field_set._(this, _retry, retry);
    }
    /**
     *  This function is called to fetch content from HTTP and
     *  HTTPS URLs and is platform specific (e.g. nodejs vs
     *  browsers).
     *
     *  This is by default the currently registered global getUrl
     *  function, which can be changed using [[registerGetUrl]].
     *  If this has been set, setting is to ``null`` will cause
     *  this FetchRequest (and any future clones) to revert back to
     *  using the currently registered global getUrl function.
     *
     *  Setting this is generally not necessary, but may be useful
     *  for developers that wish to intercept requests or to
     *  configurege a proxy or other agent.
     */ get getUrlFunc() {
        return _class_private_field_get._(this, _getUrlFunc) || defaultGetUrlFunc;
    }
    set getUrlFunc(value) {
        _class_private_field_set._(this, _getUrlFunc, value);
    }
    toString() {
        return "<FetchRequest method=".concat(JSON.stringify(this.method), " url=").concat(JSON.stringify(this.url), " headers=").concat(JSON.stringify(this.headers), " body=").concat(_class_private_field_get._(this, _body) ? (0, data_js_1.hexlify)(_class_private_field_get._(this, _body)) : "null", ">");
    }
    /**
     *  Update the throttle parameters used to determine maximum
     *  attempts and exponential-backoff properties.
     */ setThrottleParams(params) {
        if (params.slotInterval != null) {
            _class_private_field_get._(this, _throttle).slotInterval = params.slotInterval;
        }
        if (params.maxAttempts != null) {
            _class_private_field_get._(this, _throttle).maxAttempts = params.maxAttempts;
        }
    }
    /**
     *  Resolves to the response by sending the request.
     */ send() {
        (0, errors_js_1.assert)(_class_private_field_get._(this, _signal) == null, "request already sent", "UNSUPPORTED_OPERATION", {
            operation: "fetchRequest.send"
        });
        _class_private_field_set._(this, _signal, new FetchCancelSignal(this));
        return _class_private_method_get._(this, _send, send).call(this, 0, getTime() + this.timeout, 0, this, new FetchResponse(0, "", {}, null, this));
    }
    /**
     *  Cancels the inflight response, causing a ``CANCELLED``
     *  error to be rejected from the [[send]].
     */ cancel() {
        (0, errors_js_1.assert)(_class_private_field_get._(this, _signal) != null, "request has not been sent", "UNSUPPORTED_OPERATION", {
            operation: "fetchRequest.cancel"
        });
        const signal = fetchSignals.get(this);
        if (!signal) {
            throw new Error("missing signal; should not happen");
        }
        signal();
    }
    /**
     *  Returns a new [[FetchRequest]] that represents the redirection
     *  to %%location%%.
     */ redirect(location) {
        // Redirection; for now we only support absolute locations
        const current = this.url.split(":")[0].toLowerCase();
        const target = location.split(":")[0].toLowerCase();
        // Don't allow redirecting:
        // - non-GET requests
        // - downgrading the security (e.g. https => http)
        // - to non-HTTP (or non-HTTPS) protocols [this could be relaxed?]
        (0, errors_js_1.assert)(this.method === "GET" && (current !== "https" || target !== "http") && location.match(/^https?:/), "unsupported redirect", "UNSUPPORTED_OPERATION", {
            operation: "redirect(".concat(this.method, " ").concat(JSON.stringify(this.url), " => ").concat(JSON.stringify(location), ")")
        });
        // Create a copy of this request, with a new URL
        const req = new FetchRequest(location);
        req.method = "GET";
        req.allowGzip = this.allowGzip;
        req.timeout = this.timeout;
        _class_private_field_set._(req, _headers, Object.assign({}, _class_private_field_get._(this, _headers)));
        if (_class_private_field_get._(this, _body)) {
            _class_private_field_set._(req, _body, new Uint8Array(_class_private_field_get._(this, _body)));
        }
        _class_private_field_set._(req, _bodyType, _class_private_field_get._(this, _bodyType));
        // Do not forward credentials unless on the same domain; only absolute
        //req.allowInsecure = false;
        // paths are currently supported; may want a way to specify to forward?
        //setStore(req.#props, "creds", getStore(this.#pros, "creds"));
        return req;
    }
    /**
     *  Create a new copy of this request.
     */ clone() {
        const clone = new FetchRequest(this.url);
        // Preserve "default method" (i.e. null)
        _class_private_field_set._(clone, _method, _class_private_field_get._(this, _method));
        // Preserve "default body" with type, copying the Uint8Array is present
        if (_class_private_field_get._(this, _body)) {
            _class_private_field_set._(clone, _body, _class_private_field_get._(this, _body));
        }
        _class_private_field_set._(clone, _bodyType, _class_private_field_get._(this, _bodyType));
        // Preserve "default headers"
        _class_private_field_set._(clone, _headers, Object.assign({}, _class_private_field_get._(this, _headers)));
        // Credentials is readonly, so we copy internally
        _class_private_field_set._(clone, _creds, _class_private_field_get._(this, _creds));
        if (this.allowGzip) {
            clone.allowGzip = true;
        }
        clone.timeout = this.timeout;
        if (this.allowInsecureAuthentication) {
            clone.allowInsecureAuthentication = true;
        }
        _class_private_field_set._(clone, _preflight, _class_private_field_get._(this, _preflight));
        _class_private_field_set._(clone, _process, _class_private_field_get._(this, _process));
        _class_private_field_set._(clone, _retry, _class_private_field_get._(this, _retry));
        _class_private_field_set._(clone, _throttle, Object.assign({}, _class_private_field_get._(this, _throttle)));
        _class_private_field_set._(clone, _getUrlFunc, _class_private_field_get._(this, _getUrlFunc));
        return clone;
    }
    /**
     *  Locks all static configuration for gateways and FetchGetUrlFunc
     *  registration.
     */ static lockConfig() {
        locked = true;
    }
    /**
     *  Get the current Gateway function for %%scheme%%.
     */ static getGateway(scheme) {
        return Gateways[scheme.toLowerCase()] || null;
    }
    /**
     *  Use the %%func%% when fetching URIs using %%scheme%%.
     *
     *  This method affects all requests globally.
     *
     *  If [[lockConfig]] has been called, no change is made and this
     *  throws.
     */ static registerGateway(scheme, func) {
        scheme = scheme.toLowerCase();
        if (scheme === "http" || scheme === "https") {
            throw new Error("cannot intercept ".concat(scheme, "; use registerGetUrl"));
        }
        if (locked) {
            throw new Error("gateways locked");
        }
        Gateways[scheme] = func;
    }
    /**
     *  Use %%getUrl%% when fetching URIs over HTTP and HTTPS requests.
     *
     *  This method affects all requests globally.
     *
     *  If [[lockConfig]] has been called, no change is made and this
     *  throws.
     */ static registerGetUrl(getUrl) {
        if (locked) {
            throw new Error("gateways locked");
        }
        defaultGetUrlFunc = getUrl;
    }
    /**
     *  Creates a getUrl function that fetches content from HTTP and
     *  HTTPS URLs.
     *
     *  The available %%options%% are dependent on the platform
     *  implementation of the default getUrl function.
     *
     *  This is not generally something that is needed, but is useful
     *  when trying to customize simple behaviour when fetching HTTP
     *  content.
     */ static createGetUrlFunc(options) {
        return (0, geturl_js_1.createGetUrl)(options);
    }
    /**
     *  Creates a function that can "fetch" data URIs.
     *
     *  Note that this is automatically done internally to support
     *  data URIs, so it is not necessary to register it.
     *
     *  This is not generally something that is needed, but may
     *  be useful in a wrapper to perfom custom data URI functionality.
     */ static createDataGateway() {
        return dataGatewayFunc;
    }
    /**
     *  Creates a function that will fetch IPFS (unvalidated) from
     *  a custom gateway baseUrl.
     *
     *  The default IPFS gateway used internally is
     *  ``"https:/\/gateway.ipfs.io/ipfs/"``.
     */ static createIpfsGatewayFunc(baseUrl) {
        return getIpfsGatewayFunc(baseUrl);
    }
    /**
     *  Create a new FetchRequest instance with default values.
     *
     *  Once created, each property may be set before issuing a
     *  ``.send()`` to make the request.
     */ constructor(url){
        _class_private_method_init._(this, _send);
        _class_private_field_init._(this, _allowInsecure, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _gzip, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _headers, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _method, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _timeout, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _url, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _body, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _bodyType, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _creds, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _preflight, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _process, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _retry, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _signal, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _throttle, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _getUrlFunc, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _url, String(url));
        _class_private_field_set._(this, _allowInsecure, false);
        _class_private_field_set._(this, _gzip, true);
        _class_private_field_set._(this, _headers, {});
        _class_private_field_set._(this, _method, "");
        _class_private_field_set._(this, _timeout, 300000);
        _class_private_field_set._(this, _throttle, {
            slotInterval: SLOT_INTERVAL,
            maxAttempts: MAX_ATTEMPTS
        });
        _class_private_field_set._(this, _getUrlFunc, null);
    }
}
async function send(attempt, expires, delay, _request, _response) {
    var _req_redirect, _req_clone, _req_clone1;
    if (attempt >= _class_private_field_get._(this, _throttle).maxAttempts) {
        return _response.makeServerError("exceeded maximum retry limit");
    }
    (0, errors_js_1.assert)(getTime() <= expires, "timeout", "TIMEOUT", {
        operation: "request.send",
        reason: "timeout",
        request: _request
    });
    if (delay > 0) {
        await wait(delay);
    }
    let req = this.clone();
    const scheme = (req.url.split(":")[0] || "").toLowerCase();
    // Process any Gateways
    if (scheme in Gateways) {
        const result = await Gateways[scheme](req.url, checkSignal(_class_private_field_get._(_request, _signal)));
        if (result instanceof FetchResponse) {
            let response = result;
            if (this.processFunc) {
                checkSignal(_class_private_field_get._(_request, _signal));
                try {
                    response = await this.processFunc(req, response);
                } catch (error) {
                    // Something went wrong during processing; throw a 5xx server error
                    if (error.throttle == null || typeof error.stall !== "number") {
                        response.makeServerError("error in post-processing function", error).assertOk();
                    }
                // Ignore throttling
                }
            }
            return response;
        }
        req = result;
    }
    // We have a preflight function; update the request
    if (this.preflightFunc) {
        req = await this.preflightFunc(req);
    }
    const resp = await this.getUrlFunc(req, checkSignal(_class_private_field_get._(_request, _signal)));
    let response = new FetchResponse(resp.statusCode, resp.statusMessage, resp.headers, resp.body, _request);
    if (response.statusCode === 301 || response.statusCode === 302) {
        // Redirect
        try {
            const location = response.headers.location || "";
            return _class_private_method_get._(_req_redirect = req.redirect(location), _send, send).call(_req_redirect, attempt + 1, expires, 0, _request, response);
        } catch (error) {}
        // Things won't get any better on another attempt; abort
        return response;
    } else if (response.statusCode === 429) {
        // Throttle
        if (this.retryFunc == null || await this.retryFunc(req, response, attempt)) {
            const retryAfter = response.headers["retry-after"];
            let delay = _class_private_field_get._(this, _throttle).slotInterval * Math.trunc(Math.random() * Math.pow(2, attempt));
            if (typeof retryAfter === "string" && retryAfter.match(/^[1-9][0-9]*$/)) {
                delay = parseInt(retryAfter);
            }
            return _class_private_method_get._(_req_clone = req.clone(), _send, send).call(_req_clone, attempt + 1, expires, delay, _request, response);
        }
    }
    if (this.processFunc) {
        checkSignal(_class_private_field_get._(_request, _signal));
        try {
            response = await this.processFunc(req, response);
        } catch (error) {
            // Something went wrong during processing; throw a 5xx server error
            if (error.throttle == null || typeof error.stall !== "number") {
                response.makeServerError("error in post-processing function", error).assertOk();
            }
            // Throttle
            let delay = _class_private_field_get._(this, _throttle).slotInterval * Math.trunc(Math.random() * Math.pow(2, attempt));
            ;
            if (error.stall >= 0) {
                delay = error.stall;
            }
            return _class_private_method_get._(_req_clone1 = req.clone(), _send, send).call(_req_clone1, attempt + 1, expires, delay, _request, response);
        }
    }
    return response;
}
exports.FetchRequest = FetchRequest;
;
var _statusCode = /*#__PURE__*/ new WeakMap(), _statusMessage = /*#__PURE__*/ new WeakMap(), _headers1 = /*#__PURE__*/ new WeakMap(), _body1 = /*#__PURE__*/ new WeakMap(), _request = /*#__PURE__*/ new WeakMap(), _error = /*#__PURE__*/ new WeakMap();
/**
 *  The response for a FetchRequest.
 */ class FetchResponse {
    toString() {
        return "<FetchResponse status=".concat(this.statusCode, " body=").concat(_class_private_field_get._(this, _body1) ? (0, data_js_1.hexlify)(_class_private_field_get._(this, _body1)) : "null", ">");
    }
    /**
     *  The response status code.
     */ get statusCode() {
        return _class_private_field_get._(this, _statusCode);
    }
    /**
     *  The response status message.
     */ get statusMessage() {
        return _class_private_field_get._(this, _statusMessage);
    }
    /**
     *  The response headers. All keys are lower-case.
     */ get headers() {
        return Object.assign({}, _class_private_field_get._(this, _headers1));
    }
    /**
     *  The response body, or ``null`` if there was no body.
     */ get body() {
        return _class_private_field_get._(this, _body1) == null ? null : new Uint8Array(_class_private_field_get._(this, _body1));
    }
    /**
     *  The response body as a UTF-8 encoded string, or the empty
     *  string (i.e. ``""``) if there was no body.
     *
     *  An error is thrown if the body is invalid UTF-8 data.
     */ get bodyText() {
        try {
            return _class_private_field_get._(this, _body1) == null ? "" : (0, utf8_js_1.toUtf8String)(_class_private_field_get._(this, _body1));
        } catch (error) {
            (0, errors_js_1.assert)(false, "response body is not valid UTF-8 data", "UNSUPPORTED_OPERATION", {
                operation: "bodyText",
                info: {
                    response: this
                }
            });
        }
    }
    /**
     *  The response body, decoded as JSON.
     *
     *  An error is thrown if the body is invalid JSON-encoded data
     *  or if there was no body.
     */ get bodyJson() {
        try {
            return JSON.parse(this.bodyText);
        } catch (error) {
            (0, errors_js_1.assert)(false, "response body is not valid JSON", "UNSUPPORTED_OPERATION", {
                operation: "bodyJson",
                info: {
                    response: this
                }
            });
        }
    }
    [Symbol.iterator]() {
        const headers = this.headers;
        const keys = Object.keys(headers);
        let index = 0;
        return {
            next: ()=>{
                if (index < keys.length) {
                    const key = keys[index++];
                    return {
                        value: [
                            key,
                            headers[key]
                        ],
                        done: false
                    };
                }
                return {
                    value: undefined,
                    done: true
                };
            }
        };
    }
    /**
     *  Return a Response with matching headers and body, but with
     *  an error status code (i.e. 599) and %%message%% with an
     *  optional %%error%%.
     */ makeServerError(message, error) {
        let statusMessage;
        if (!message) {
            message = "".concat(this.statusCode, " ").concat(this.statusMessage);
            statusMessage = "CLIENT ESCALATED SERVER ERROR (".concat(message, ")");
        } else {
            statusMessage = "CLIENT ESCALATED SERVER ERROR (".concat(this.statusCode, " ").concat(this.statusMessage, "; ").concat(message, ")");
        }
        const response = new FetchResponse(599, statusMessage, this.headers, this.body, _class_private_field_get._(this, _request) || undefined);
        _class_private_field_set._(response, _error, {
            message,
            error
        });
        return response;
    }
    /**
     *  If called within a [request.processFunc](FetchRequest-processFunc)
     *  call, causes the request to retry as if throttled for %%stall%%
     *  milliseconds.
     */ throwThrottleError(message, stall) {
        if (stall == null) {
            stall = -1;
        } else {
            (0, errors_js_1.assertArgument)(Number.isInteger(stall) && stall >= 0, "invalid stall timeout", "stall", stall);
        }
        const error = new Error(message || "throttling requests");
        (0, properties_js_1.defineProperties)(error, {
            stall,
            throttle: true
        });
        throw error;
    }
    /**
     *  Get the header value for %%key%%, ignoring case.
     */ getHeader(key) {
        return this.headers[key.toLowerCase()];
    }
    /**
     *  Returns true if the response has a body.
     */ hasBody() {
        return _class_private_field_get._(this, _body1) != null;
    }
    /**
     *  The request made for this response.
     */ get request() {
        return _class_private_field_get._(this, _request);
    }
    /**
     *  Returns true if this response was a success statusCode.
     */ ok() {
        return _class_private_field_get._(this, _error).message === "" && this.statusCode >= 200 && this.statusCode < 300;
    }
    /**
     *  Throws a ``SERVER_ERROR`` if this response is not ok.
     */ assertOk() {
        if (this.ok()) {
            return;
        }
        let { message, error } = _class_private_field_get._(this, _error);
        if (message === "") {
            message = "server response ".concat(this.statusCode, " ").concat(this.statusMessage);
        }
        let requestUrl = null;
        if (this.request) {
            requestUrl = this.request.url;
        }
        let responseBody = null;
        try {
            if (_class_private_field_get._(this, _body1)) {
                responseBody = (0, utf8_js_1.toUtf8String)(_class_private_field_get._(this, _body1));
            }
        } catch (e) {}
        (0, errors_js_1.assert)(false, message, "SERVER_ERROR", {
            request: this.request || "unknown request",
            response: this,
            error,
            info: {
                requestUrl,
                responseBody,
                responseStatus: "".concat(this.statusCode, " ").concat(this.statusMessage)
            }
        });
    }
    constructor(statusCode, statusMessage, headers, body, request){
        _class_private_field_init._(this, _statusCode, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _statusMessage, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _headers1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _body1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _request, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _error, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _statusCode, statusCode);
        _class_private_field_set._(this, _statusMessage, statusMessage);
        _class_private_field_set._(this, _headers1, Object.keys(headers).reduce((accum, k)=>{
            accum[k.toLowerCase()] = String(headers[k]);
            return accum;
        }, {}));
        _class_private_field_set._(this, _body1, body == null ? null : new Uint8Array(body));
        _class_private_field_set._(this, _request, request || null);
        _class_private_field_set._(this, _error, {
            message: ""
        });
    }
}
exports.FetchResponse = FetchResponse;
function getTime() {
    return new Date().getTime();
}
function unpercent(value) {
    return (0, utf8_js_1.toUtf8Bytes)(value.replace(/%([0-9a-f][0-9a-f])/gi, (all, code)=>{
        return String.fromCharCode(parseInt(code, 16));
    }));
}
function wait(delay) {
    return new Promise((resolve)=>setTimeout(resolve, delay));
} //# sourceMappingURL=fetch.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/fixednumber.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FixedNumber = void 0;
/**
 *  The **FixedNumber** class permits using values with decimal places,
 *  using fixed-pont math.
 *
 *  Fixed-point math is still based on integers under-the-hood, but uses an
 *  internal offset to store fractional components below, and each operation
 *  corrects for this after each operation.
 *
 *  @_section: api/utils/fixed-point-math:Fixed-Point Maths  [about-fixed-point-math]
 */ const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
const maths_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/maths.js [app-client] (ecmascript)");
const properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
const BN_N1 = BigInt(-1);
const BN_0 = BigInt(0);
const BN_1 = BigInt(1);
const BN_5 = BigInt(5);
const _guard = {};
// Constant to pull zeros from for multipliers
let Zeros = "0000";
while(Zeros.length < 80){
    Zeros += Zeros;
}
// Returns a string "1" followed by decimal "0"s
function getTens(decimals) {
    let result = Zeros;
    while(result.length < decimals){
        result += result;
    }
    return BigInt("1" + result.substring(0, decimals));
}
function checkValue(val, format, safeOp) {
    const width = BigInt(format.width);
    if (format.signed) {
        const limit = BN_1 << width - BN_1;
        (0, errors_js_1.assert)(safeOp == null || val >= -limit && val < limit, "overflow", "NUMERIC_FAULT", {
            operation: safeOp,
            fault: "overflow",
            value: val
        });
        if (val > BN_0) {
            val = (0, maths_js_1.fromTwos)((0, maths_js_1.mask)(val, width), width);
        } else {
            val = -(0, maths_js_1.fromTwos)((0, maths_js_1.mask)(-val, width), width);
        }
    } else {
        const limit = BN_1 << width;
        (0, errors_js_1.assert)(safeOp == null || val >= 0 && val < limit, "overflow", "NUMERIC_FAULT", {
            operation: safeOp,
            fault: "overflow",
            value: val
        });
        val = (val % limit + limit) % limit & limit - BN_1;
    }
    return val;
}
function getFormat(value) {
    if (typeof value === "number") {
        value = "fixed128x".concat(value);
    }
    let signed = true;
    let width = 128;
    let decimals = 18;
    if (typeof value === "string") {
        // Parse the format string
        if (value === "fixed") {
        // defaults...
        } else if (value === "ufixed") {
            signed = false;
        } else {
            const match = value.match(/^(u?)fixed([0-9]+)x([0-9]+)$/);
            (0, errors_js_1.assertArgument)(match, "invalid fixed format", "format", value);
            signed = match[1] !== "u";
            width = parseInt(match[2]);
            decimals = parseInt(match[3]);
        }
    } else if (value) {
        // Extract the values from the object
        const v = value;
        const check = (key, type, defaultValue)=>{
            if (v[key] == null) {
                return defaultValue;
            }
            (0, errors_js_1.assertArgument)(typeof v[key] === type, "invalid fixed format (" + key + " not " + type + ")", "format." + key, v[key]);
            return v[key];
        };
        signed = check("signed", "boolean", signed);
        width = check("width", "number", width);
        decimals = check("decimals", "number", decimals);
    }
    (0, errors_js_1.assertArgument)(width % 8 === 0, "invalid FixedNumber width (not byte aligned)", "format.width", width);
    (0, errors_js_1.assertArgument)(decimals <= 80, "invalid FixedNumber decimals (too large)", "format.decimals", decimals);
    const name = (signed ? "" : "u") + "fixed" + String(width) + "x" + String(decimals);
    return {
        signed,
        width,
        decimals,
        name
    };
}
function toString(val, decimals) {
    let negative = "";
    if (val < BN_0) {
        negative = "-";
        val *= BN_N1;
    }
    let str = val.toString();
    // No decimal point for whole values
    if (decimals === 0) {
        return negative + str;
    }
    // Pad out to the whole component (including a whole digit)
    while(str.length <= decimals){
        str = Zeros + str;
    }
    // Insert the decimal point
    const index = str.length - decimals;
    str = str.substring(0, index) + "." + str.substring(index);
    // Trim the whole component (leaving at least one 0)
    while(str[0] === "0" && str[1] !== "."){
        str = str.substring(1);
    }
    // Trim the decimal component (leaving at least one 0)
    while(str[str.length - 1] === "0" && str[str.length - 2] !== "."){
        str = str.substring(0, str.length - 1);
    }
    return negative + str;
}
var _format = /*#__PURE__*/ new WeakMap(), // The actual value (accounting for decimals)
_val = /*#__PURE__*/ new WeakMap(), // A base-10 value to multiple values by to maintain the magnitude
_tens = /*#__PURE__*/ new WeakMap(), _checkFormat = /*#__PURE__*/ new WeakSet(), _checkValue = /*#__PURE__*/ new WeakSet(), _add = /*#__PURE__*/ new WeakSet(), _sub = /*#__PURE__*/ new WeakSet(), _mul = /*#__PURE__*/ new WeakSet(), _div = /*#__PURE__*/ new WeakSet();
/**
 *  A FixedNumber represents a value over its [[FixedFormat]]
 *  arithmetic field.
 *
 *  A FixedNumber can be used to perform math, losslessly, on
 *  values which have decmial places.
 *
 *  A FixedNumber has a fixed bit-width to store values in, and stores all
 *  values internally by multiplying the value by 10 raised to the power of
 *  %%decimals%%.
 *
 *  If operations are performed that cause a value to grow too high (close to
 *  positive infinity) or too low (close to negative infinity), the value
 *  is said to //overflow//.
 *
 *  For example, an 8-bit signed value, with 0 decimals may only be within
 *  the range ``-128`` to ``127``; so ``-128 - 1`` will overflow and become
 *  ``127``. Likewise, ``127 + 1`` will overflow and become ``-127``.
 *
 *  Many operation have a normal and //unsafe// variant. The normal variant
 *  will throw a [[NumericFaultError]] on any overflow, while the //unsafe//
 *  variant will silently allow overflow, corrupting its value value.
 *
 *  If operations are performed that cause a value to become too small
 *  (close to zero), the value loses precison and is said to //underflow//.
 *
 *  For example, a value with 1 decimal place may store a number as small
 *  as ``0.1``, but the value of ``0.1 / 2`` is ``0.05``, which cannot fit
 *  into 1 decimal place, so underflow occurs which means precision is lost
 *  and the value becomes ``0``.
 *
 *  Some operations have a normal and //signalling// variant. The normal
 *  variant will silently ignore underflow, while the //signalling// variant
 *  will thow a [[NumericFaultError]] on underflow.
 */ class FixedNumber {
    /**
     *  If true, negative values are permitted, otherwise only
     *  positive values and zero are allowed.
     */ get signed() {
        return _class_private_field_get._(this, _format).signed;
    }
    /**
     *  The number of bits available to store the value.
     */ get width() {
        return _class_private_field_get._(this, _format).width;
    }
    /**
     *  The number of decimal places in the fixed-point arithment field.
     */ get decimals() {
        return _class_private_field_get._(this, _format).decimals;
    }
    /**
     *  The value as an integer, based on the smallest unit the
     *  [[decimals]] allow.
     */ get value() {
        return _class_private_field_get._(this, _val);
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% added
     *  to %%other%%, ignoring overflow.
     */ addUnsafe(other) {
        return _class_private_method_get._(this, _add, add).call(this, other);
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% added
     *  to %%other%%. A [[NumericFaultError]] is thrown if overflow
     *  occurs.
     */ add(other) {
        return _class_private_method_get._(this, _add, add).call(this, other, "add");
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%other%% subtracted
     *  from %%this%%, ignoring overflow.
     */ subUnsafe(other) {
        return _class_private_method_get._(this, _sub, sub).call(this, other);
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%other%% subtracted
     *  from %%this%%. A [[NumericFaultError]] is thrown if overflow
     *  occurs.
     */ sub(other) {
        return _class_private_method_get._(this, _sub, sub).call(this, other, "sub");
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% multiplied
     *  by %%other%%, ignoring overflow and underflow (precision loss).
     */ mulUnsafe(other) {
        return _class_private_method_get._(this, _mul, mul).call(this, other);
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% multiplied
     *  by %%other%%. A [[NumericFaultError]] is thrown if overflow
     *  occurs.
     */ mul(other) {
        return _class_private_method_get._(this, _mul, mul).call(this, other, "mul");
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% multiplied
     *  by %%other%%. A [[NumericFaultError]] is thrown if overflow
     *  occurs or if underflow (precision loss) occurs.
     */ mulSignal(other) {
        _class_private_method_get._(this, _checkFormat, checkFormat).call(this, other);
        const value = _class_private_field_get._(this, _val) * _class_private_field_get._(other, _val);
        (0, errors_js_1.assert)(value % _class_private_field_get._(this, _tens) === BN_0, "precision lost during signalling mul", "NUMERIC_FAULT", {
            operation: "mulSignal",
            fault: "underflow",
            value: this
        });
        return _class_private_method_get._(this, _checkValue, checkValue1).call(this, value / _class_private_field_get._(this, _tens), "mulSignal");
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% divided
     *  by %%other%%, ignoring underflow (precision loss). A
     *  [[NumericFaultError]] is thrown if overflow occurs.
     */ divUnsafe(other) {
        return _class_private_method_get._(this, _div, div).call(this, other);
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% divided
     *  by %%other%%, ignoring underflow (precision loss). A
     *  [[NumericFaultError]] is thrown if overflow occurs.
     */ div(other) {
        return _class_private_method_get._(this, _div, div).call(this, other, "div");
    }
    /**
     *  Returns a new [[FixedNumber]] with the result of %%this%% divided
     *  by %%other%%. A [[NumericFaultError]] is thrown if underflow
     *  (precision loss) occurs.
     */ divSignal(other) {
        (0, errors_js_1.assert)(_class_private_field_get._(other, _val) !== BN_0, "division by zero", "NUMERIC_FAULT", {
            operation: "div",
            fault: "divide-by-zero",
            value: this
        });
        _class_private_method_get._(this, _checkFormat, checkFormat).call(this, other);
        const value = _class_private_field_get._(this, _val) * _class_private_field_get._(this, _tens);
        (0, errors_js_1.assert)(value % _class_private_field_get._(other, _val) === BN_0, "precision lost during signalling div", "NUMERIC_FAULT", {
            operation: "divSignal",
            fault: "underflow",
            value: this
        });
        return _class_private_method_get._(this, _checkValue, checkValue1).call(this, value / _class_private_field_get._(other, _val), "divSignal");
    }
    /**
     *  Returns a comparison result between %%this%% and %%other%%.
     *
     *  This is suitable for use in sorting, where ``-1`` implies %%this%%
     *  is smaller, ``1`` implies %%this%% is larger and ``0`` implies
     *  both are equal.
     */ cmp(other) {
        let a = this.value, b = other.value;
        // Coerce a and b to the same magnitude
        const delta = this.decimals - other.decimals;
        if (delta > 0) {
            b *= getTens(delta);
        } else if (delta < 0) {
            a *= getTens(-delta);
        }
        // Comnpare
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }
    /**
     *  Returns true if %%other%% is equal to %%this%%.
     */ eq(other) {
        return this.cmp(other) === 0;
    }
    /**
     *  Returns true if %%other%% is less than to %%this%%.
     */ lt(other) {
        return this.cmp(other) < 0;
    }
    /**
     *  Returns true if %%other%% is less than or equal to %%this%%.
     */ lte(other) {
        return this.cmp(other) <= 0;
    }
    /**
     *  Returns true if %%other%% is greater than to %%this%%.
     */ gt(other) {
        return this.cmp(other) > 0;
    }
    /**
     *  Returns true if %%other%% is greater than or equal to %%this%%.
     */ gte(other) {
        return this.cmp(other) >= 0;
    }
    /**
     *  Returns a new [[FixedNumber]] which is the largest **integer**
     *  that is less than or equal to %%this%%.
     *
     *  The decimal component of the result will always be ``0``.
     */ floor() {
        let val = _class_private_field_get._(this, _val);
        if (_class_private_field_get._(this, _val) < BN_0) {
            val -= _class_private_field_get._(this, _tens) - BN_1;
        }
        val = _class_private_field_get._(this, _val) / _class_private_field_get._(this, _tens) * _class_private_field_get._(this, _tens);
        return _class_private_method_get._(this, _checkValue, checkValue1).call(this, val, "floor");
    }
    /**
     *  Returns a new [[FixedNumber]] which is the smallest **integer**
     *  that is greater than or equal to %%this%%.
     *
     *  The decimal component of the result will always be ``0``.
     */ ceiling() {
        let val = _class_private_field_get._(this, _val);
        if (_class_private_field_get._(this, _val) > BN_0) {
            val += _class_private_field_get._(this, _tens) - BN_1;
        }
        val = _class_private_field_get._(this, _val) / _class_private_field_get._(this, _tens) * _class_private_field_get._(this, _tens);
        return _class_private_method_get._(this, _checkValue, checkValue1).call(this, val, "ceiling");
    }
    /**
     *  Returns a new [[FixedNumber]] with the decimal component
     *  rounded up on ties at %%decimals%% places.
     */ round(decimals) {
        if (decimals == null) {
            decimals = 0;
        }
        // Not enough precision to not already be rounded
        if (decimals >= this.decimals) {
            return this;
        }
        const delta = this.decimals - decimals;
        const bump = BN_5 * getTens(delta - 1);
        let value = this.value + bump;
        const tens = getTens(delta);
        value = value / tens * tens;
        checkValue(value, _class_private_field_get._(this, _format), "round");
        return new FixedNumber(_guard, value, _class_private_field_get._(this, _format));
    }
    /**
     *  Returns true if %%this%% is equal to ``0``.
     */ isZero() {
        return _class_private_field_get._(this, _val) === BN_0;
    }
    /**
     *  Returns true if %%this%% is less than ``0``.
     */ isNegative() {
        return _class_private_field_get._(this, _val) < BN_0;
    }
    /**
     *  Returns the string representation of %%this%%.
     */ toString() {
        return this._value;
    }
    /**
     *  Returns a float approximation.
     *
     *  Due to IEEE 754 precission (or lack thereof), this function
     *  can only return an approximation and most values will contain
     *  rounding errors.
     */ toUnsafeFloat() {
        return parseFloat(this.toString());
    }
    /**
     *  Return a new [[FixedNumber]] with the same value but has had
     *  its field set to %%format%%.
     *
     *  This will throw if the value cannot fit into %%format%%.
     */ toFormat(format) {
        return FixedNumber.fromString(this.toString(), format);
    }
    /**
     *  Creates a new [[FixedNumber]] for %%value%% divided by
     *  %%decimal%% places with %%format%%.
     *
     *  This will throw a [[NumericFaultError]] if %%value%% (once adjusted
     *  for %%decimals%%) cannot fit in %%format%%, either due to overflow
     *  or underflow (precision loss).
     */ static fromValue(_value, _decimals, _format) {
        const decimals = _decimals == null ? 0 : (0, maths_js_1.getNumber)(_decimals);
        const format = getFormat(_format);
        let value = (0, maths_js_1.getBigInt)(_value, "value");
        const delta = decimals - format.decimals;
        if (delta > 0) {
            const tens = getTens(delta);
            (0, errors_js_1.assert)(value % tens === BN_0, "value loses precision for format", "NUMERIC_FAULT", {
                operation: "fromValue",
                fault: "underflow",
                value: _value
            });
            value /= tens;
        } else if (delta < 0) {
            value *= getTens(-delta);
        }
        checkValue(value, format, "fromValue");
        return new FixedNumber(_guard, value, format);
    }
    /**
     *  Creates a new [[FixedNumber]] for %%value%% with %%format%%.
     *
     *  This will throw a [[NumericFaultError]] if %%value%% cannot fit
     *  in %%format%%, either due to overflow or underflow (precision loss).
     */ static fromString(_value, _format) {
        const match = _value.match(/^(-?)([0-9]*)\.?([0-9]*)$/);
        (0, errors_js_1.assertArgument)(match && match[2].length + match[3].length > 0, "invalid FixedNumber string value", "value", _value);
        const format = getFormat(_format);
        let whole = match[2] || "0", decimal = match[3] || "";
        // Pad out the decimals
        while(decimal.length < format.decimals){
            decimal += Zeros;
        }
        // Check precision is safe
        (0, errors_js_1.assert)(decimal.substring(format.decimals).match(/^0*$/), "too many decimals for format", "NUMERIC_FAULT", {
            operation: "fromString",
            fault: "underflow",
            value: _value
        });
        // Remove extra padding
        decimal = decimal.substring(0, format.decimals);
        const value = BigInt(match[1] + whole + decimal);
        checkValue(value, format, "fromString");
        return new FixedNumber(_guard, value, format);
    }
    /**
     *  Creates a new [[FixedNumber]] with the big-endian representation
     *  %%value%% with %%format%%.
     *
     *  This will throw a [[NumericFaultError]] if %%value%% cannot fit
     *  in %%format%% due to overflow.
     */ static fromBytes(_value, _format) {
        let value = (0, maths_js_1.toBigInt)((0, data_js_1.getBytes)(_value, "value"));
        const format = getFormat(_format);
        if (format.signed) {
            value = (0, maths_js_1.fromTwos)(value, format.width);
        }
        checkValue(value, format, "fromBytes");
        return new FixedNumber(_guard, value, format);
    }
    // Use this when changing this file to get some typing info,
    // but then switch to any to mask the internal type
    //constructor(guard: any, value: bigint, format: _FixedFormat) {
    /**
     *  @private
     */ constructor(guard, value, format){
        _class_private_method_init._(this, _checkFormat);
        _class_private_method_init._(this, _checkValue);
        _class_private_method_init._(this, _add);
        _class_private_method_init._(this, _sub);
        _class_private_method_init._(this, _mul);
        _class_private_method_init._(this, _div);
        /**
     *  The specific fixed-point arithmetic field for this value.
     */ _define_property._(this, "format", void 0);
        _class_private_field_init._(this, _format, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _val, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _tens, {
            writable: true,
            value: void 0
        });
        /**
     *  This is a property so console.log shows a human-meaningful value.
     *
     *  @private
     */ _define_property._(this, "_value", void 0);
        (0, errors_js_1.assertPrivate)(guard, _guard, "FixedNumber");
        _class_private_field_set._(this, _val, value);
        _class_private_field_set._(this, _format, format);
        const _value = toString(value, format.decimals);
        (0, properties_js_1.defineProperties)(this, {
            format: format.name,
            _value
        });
        _class_private_field_set._(this, _tens, getTens(format.decimals));
    }
}
function checkFormat(other) {
    (0, errors_js_1.assertArgument)(this.format === other.format, "incompatible format; use fixedNumber.toFormat", "other", other);
}
function checkValue1(val, safeOp) {
    /*
                const width = BigInt(this.width);
                if (this.signed) {
                    const limit = (BN_1 << (width - BN_1));
                    assert(safeOp == null || (val >= -limit  && val < limit), "overflow", "NUMERIC_FAULT", {
                        operation: <string>safeOp, fault: "overflow", value: val
                    });
        
                    if (val > BN_0) {
                        val = fromTwos(mask(val, width), width);
                    } else {
                        val = -fromTwos(mask(-val, width), width);
                    }
        
                } else {
                    const masked = mask(val, width);
                    assert(safeOp == null || (val >= 0 && val === masked), "overflow", "NUMERIC_FAULT", {
                        operation: <string>safeOp, fault: "overflow", value: val
                    });
                    val = masked;
                }
        */ val = checkValue(val, _class_private_field_get._(this, _format), safeOp);
    return new FixedNumber(_guard, val, _class_private_field_get._(this, _format));
}
function add(o, safeOp) {
    _class_private_method_get._(this, _checkFormat, checkFormat).call(this, o);
    return _class_private_method_get._(this, _checkValue, checkValue1).call(this, _class_private_field_get._(this, _val) + _class_private_field_get._(o, _val), safeOp);
}
function sub(o, safeOp) {
    _class_private_method_get._(this, _checkFormat, checkFormat).call(this, o);
    return _class_private_method_get._(this, _checkValue, checkValue1).call(this, _class_private_field_get._(this, _val) - _class_private_field_get._(o, _val), safeOp);
}
function mul(o, safeOp) {
    _class_private_method_get._(this, _checkFormat, checkFormat).call(this, o);
    return _class_private_method_get._(this, _checkValue, checkValue1).call(this, _class_private_field_get._(this, _val) * _class_private_field_get._(o, _val) / _class_private_field_get._(this, _tens), safeOp);
}
function div(o, safeOp) {
    (0, errors_js_1.assert)(_class_private_field_get._(o, _val) !== BN_0, "division by zero", "NUMERIC_FAULT", {
        operation: "div",
        fault: "divide-by-zero",
        value: this
    });
    _class_private_method_get._(this, _checkFormat, checkFormat).call(this, o);
    return _class_private_method_get._(this, _checkValue, checkValue1).call(this, _class_private_field_get._(this, _val) * _class_private_field_get._(this, _tens) / _class_private_field_get._(o, _val), safeOp);
}
exports.FixedNumber = FixedNumber; //const f1 = FixedNumber.fromString("12.56", "fixed16x2");
 //const f2 = FixedNumber.fromString("0.3", "fixed16x2");
 //console.log(f1.divSignal(f2));
 //const BUMP = FixedNumber.from("0.5");
 //# sourceMappingURL=fixednumber.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/rlp-decode.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

//See: https://github.com/ethereum/wiki/wiki/RLP
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeRlp = void 0;
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
const data_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
function hexlifyByte(value) {
    let result = value.toString(16);
    while(result.length < 2){
        result = "0" + result;
    }
    return "0x" + result;
}
function unarrayifyInteger(data, offset, length) {
    let result = 0;
    for(let i = 0; i < length; i++){
        result = result * 256 + data[offset + i];
    }
    return result;
}
function _decodeChildren(data, offset, childOffset, length) {
    const result = [];
    while(childOffset < offset + 1 + length){
        const decoded = _decode(data, childOffset);
        result.push(decoded.result);
        childOffset += decoded.consumed;
        (0, errors_js_1.assert)(childOffset <= offset + 1 + length, "child data too short", "BUFFER_OVERRUN", {
            buffer: data,
            length,
            offset
        });
    }
    return {
        consumed: 1 + length,
        result: result
    };
}
// returns { consumed: number, result: Object }
function _decode(data, offset) {
    (0, errors_js_1.assert)(data.length !== 0, "data too short", "BUFFER_OVERRUN", {
        buffer: data,
        length: 0,
        offset: 1
    });
    const checkOffset = (offset)=>{
        (0, errors_js_1.assert)(offset <= data.length, "data short segment too short", "BUFFER_OVERRUN", {
            buffer: data,
            length: data.length,
            offset
        });
    };
    // Array with extra length prefix
    if (data[offset] >= 0xf8) {
        const lengthLength = data[offset] - 0xf7;
        checkOffset(offset + 1 + lengthLength);
        const length = unarrayifyInteger(data, offset + 1, lengthLength);
        checkOffset(offset + 1 + lengthLength + length);
        return _decodeChildren(data, offset, offset + 1 + lengthLength, lengthLength + length);
    } else if (data[offset] >= 0xc0) {
        const length = data[offset] - 0xc0;
        checkOffset(offset + 1 + length);
        return _decodeChildren(data, offset, offset + 1, length);
    } else if (data[offset] >= 0xb8) {
        const lengthLength = data[offset] - 0xb7;
        checkOffset(offset + 1 + lengthLength);
        const length = unarrayifyInteger(data, offset + 1, lengthLength);
        checkOffset(offset + 1 + lengthLength + length);
        const result = (0, data_js_1.hexlify)(data.slice(offset + 1 + lengthLength, offset + 1 + lengthLength + length));
        return {
            consumed: 1 + lengthLength + length,
            result: result
        };
    } else if (data[offset] >= 0x80) {
        const length = data[offset] - 0x80;
        checkOffset(offset + 1 + length);
        const result = (0, data_js_1.hexlify)(data.slice(offset + 1, offset + 1 + length));
        return {
            consumed: 1 + length,
            result: result
        };
    }
    return {
        consumed: 1,
        result: hexlifyByte(data[offset])
    };
}
/**
 *  Decodes %%data%% into the structured data it represents.
 */ function decodeRlp(_data) {
    const data = (0, data_js_2.getBytes)(_data, "data");
    const decoded = _decode(data, 0);
    (0, errors_js_1.assertArgument)(decoded.consumed === data.length, "unexpected junk after rlp payload", "data", _data);
    return decoded.result;
}
exports.decodeRlp = decodeRlp; //# sourceMappingURL=rlp-decode.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/rlp-encode.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

//See: https://github.com/ethereum/wiki/wiki/RLP
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.encodeRlp = void 0;
const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
function arrayifyInteger(value) {
    const result = [];
    while(value){
        result.unshift(value & 0xff);
        value >>= 8;
    }
    return result;
}
function _encode(object) {
    if (Array.isArray(object)) {
        let payload = [];
        object.forEach(function(child) {
            payload = payload.concat(_encode(child));
        });
        if (payload.length <= 55) {
            payload.unshift(0xc0 + payload.length);
            return payload;
        }
        const length = arrayifyInteger(payload.length);
        length.unshift(0xf7 + length.length);
        return length.concat(payload);
    }
    const data = Array.prototype.slice.call((0, data_js_1.getBytes)(object, "object"));
    if (data.length === 1 && data[0] <= 0x7f) {
        return data;
    } else if (data.length <= 55) {
        data.unshift(0x80 + data.length);
        return data;
    }
    const length = arrayifyInteger(data.length);
    length.unshift(0xb7 + length.length);
    return length.concat(data);
}
const nibbles = "0123456789abcdef";
/**
 *  Encodes %%object%% as an RLP-encoded [[DataHexString]].
 */ function encodeRlp(object) {
    let result = "0x";
    for (const v of _encode(object)){
        result += nibbles[v >> 4];
        result += nibbles[v & 0xf];
    }
    return result;
}
exports.encodeRlp = encodeRlp; //# sourceMappingURL=rlp-encode.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/units.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseEther = exports.formatEther = exports.parseUnits = exports.formatUnits = void 0;
/**
 *  Most interactions with Ethereum requires integer values, which use
 *  the smallest magnitude unit.
 *
 *  For example, imagine dealing with dollars and cents. Since dollars
 *  are divisible, non-integer values are possible, such as ``$10.77``.
 *  By using the smallest indivisible unit (i.e. cents), the value can
 *  be kept as the integer ``1077``.
 *
 *  When receiving decimal input from the user (as a decimal string),
 *  the value should be converted to an integer and when showing a user
 *  a value, the integer value should be converted to a decimal string.
 *
 *  This creates a clear distinction, between values to be used by code
 *  (integers) and values used for display logic to users (decimals).
 *
 *  The native unit in Ethereum, //ether// is divisible to 18 decimal places,
 *  where each individual unit is called a //wei//.
 *
 *  @_subsection api/utils:Unit Conversion  [about-units]
 */ const errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
const fixednumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/fixednumber.js [app-client] (ecmascript)");
const maths_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/maths.js [app-client] (ecmascript)");
const names = [
    "wei",
    "kwei",
    "mwei",
    "gwei",
    "szabo",
    "finney",
    "ether"
];
/**
 *  Converts %%value%% into a //decimal string//, assuming %%unit%% decimal
 *  places. The %%unit%% may be the number of decimal places or the name of
 *  a unit (e.g. ``"gwei"`` for 9 decimal places).
 *
 */ function formatUnits(value, unit) {
    let decimals = 18;
    if (typeof unit === "string") {
        const index = names.indexOf(unit);
        (0, errors_js_1.assertArgument)(index >= 0, "invalid unit", "unit", unit);
        decimals = 3 * index;
    } else if (unit != null) {
        decimals = (0, maths_js_1.getNumber)(unit, "unit");
    }
    return fixednumber_js_1.FixedNumber.fromValue(value, decimals, {
        decimals,
        width: 512
    }).toString();
}
exports.formatUnits = formatUnits;
/**
 *  Converts the //decimal string// %%value%% to a BigInt, assuming
 *  %%unit%% decimal places. The %%unit%% may the number of decimal places
 *  or the name of a unit (e.g. ``"gwei"`` for 9 decimal places).
 */ function parseUnits(value, unit) {
    (0, errors_js_1.assertArgument)(typeof value === "string", "value must be a string", "value", value);
    let decimals = 18;
    if (typeof unit === "string") {
        const index = names.indexOf(unit);
        (0, errors_js_1.assertArgument)(index >= 0, "invalid unit", "unit", unit);
        decimals = 3 * index;
    } else if (unit != null) {
        decimals = (0, maths_js_1.getNumber)(unit, "unit");
    }
    return fixednumber_js_1.FixedNumber.fromString(value, {
        decimals,
        width: 512
    }).value;
}
exports.parseUnits = parseUnits;
/**
 *  Converts %%value%% into a //decimal string// using 18 decimal places.
 */ function formatEther(wei) {
    return formatUnits(wei, 18);
}
exports.formatEther = formatEther;
/**
 *  Converts the //decimal string// %%ether%% to a BigInt, using 18
 *  decimal places.
 */ function parseEther(ether) {
    return parseUnits(ether, 18);
}
exports.parseEther = parseEther; //# sourceMappingURL=units.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/uuid.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.uuidV4 = void 0;
/**
 *  Explain UUID and link to RFC here.
 *
 *  @_subsection: api/utils:UUID  [about-uuid]
 */ const data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
/**
 *  Returns the version 4 [[link-uuid]] for the %%randomBytes%%.
 *
 *  @see: https://www.ietf.org/rfc/rfc4122.txt (Section 4.4)
 */ function uuidV4(randomBytes) {
    const bytes = (0, data_js_1.getBytes)(randomBytes, "randomBytes");
    // Section: 4.1.3:
    // - time_hi_and_version[12:16] = 0b0100
    bytes[6] = bytes[6] & 0x0f | 0x40;
    // Section 4.4
    // - clock_seq_hi_and_reserved[6] = 0b0
    // - clock_seq_hi_and_reserved[7] = 0b1
    bytes[8] = bytes[8] & 0x3f | 0x80;
    const value = (0, data_js_1.hexlify)(bytes);
    return [
        value.substring(2, 10),
        value.substring(10, 14),
        value.substring(14, 18),
        value.substring(18, 22),
        value.substring(22, 34)
    ].join("-");
}
exports.uuidV4 = uuidV4; //# sourceMappingURL=uuid.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  There are many simple utilities required to interact with
 *  Ethereum and to simplify the library, without increasing
 *  the library dependencies for simple functions.
 *
 *  @_section api/utils:Utilities  [about-utils]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toUtf8String = exports.toUtf8CodePoints = exports.toUtf8Bytes = exports.parseUnits = exports.formatUnits = exports.parseEther = exports.formatEther = exports.encodeRlp = exports.decodeRlp = exports.defineProperties = exports.resolveProperties = exports.toQuantity = exports.toBeArray = exports.toBeHex = exports.toNumber = exports.toBigInt = exports.getUint = exports.getNumber = exports.getBigInt = exports.mask = exports.toTwos = exports.fromTwos = exports.FixedNumber = exports.FetchCancelSignal = exports.FetchResponse = exports.FetchRequest = exports.EventPayload = exports.makeError = exports.assertNormalize = exports.assertPrivate = exports.assertArgumentCount = exports.assertArgument = exports.assert = exports.isError = exports.isCallException = exports.zeroPadBytes = exports.zeroPadValue = exports.stripZerosLeft = exports.dataSlice = exports.dataLength = exports.concat = exports.hexlify = exports.isBytesLike = exports.isHexString = exports.getBytesCopy = exports.getBytes = exports.encodeBase64 = exports.decodeBase64 = exports.encodeBase58 = exports.decodeBase58 = void 0;
exports.uuidV4 = exports.Utf8ErrorFuncs = void 0;
var base58_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/base58.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeBase58", {
    enumerable: true,
    get: function() {
        return base58_js_1.decodeBase58;
    }
});
Object.defineProperty(exports, "encodeBase58", {
    enumerable: true,
    get: function() {
        return base58_js_1.encodeBase58;
    }
});
var base64_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/base64-browser.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeBase64", {
    enumerable: true,
    get: function() {
        return base64_js_1.decodeBase64;
    }
});
Object.defineProperty(exports, "encodeBase64", {
    enumerable: true,
    get: function() {
        return base64_js_1.encodeBase64;
    }
});
var data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/data.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getBytes", {
    enumerable: true,
    get: function() {
        return data_js_1.getBytes;
    }
});
Object.defineProperty(exports, "getBytesCopy", {
    enumerable: true,
    get: function() {
        return data_js_1.getBytesCopy;
    }
});
Object.defineProperty(exports, "isHexString", {
    enumerable: true,
    get: function() {
        return data_js_1.isHexString;
    }
});
Object.defineProperty(exports, "isBytesLike", {
    enumerable: true,
    get: function() {
        return data_js_1.isBytesLike;
    }
});
Object.defineProperty(exports, "hexlify", {
    enumerable: true,
    get: function() {
        return data_js_1.hexlify;
    }
});
Object.defineProperty(exports, "concat", {
    enumerable: true,
    get: function() {
        return data_js_1.concat;
    }
});
Object.defineProperty(exports, "dataLength", {
    enumerable: true,
    get: function() {
        return data_js_1.dataLength;
    }
});
Object.defineProperty(exports, "dataSlice", {
    enumerable: true,
    get: function() {
        return data_js_1.dataSlice;
    }
});
Object.defineProperty(exports, "stripZerosLeft", {
    enumerable: true,
    get: function() {
        return data_js_1.stripZerosLeft;
    }
});
Object.defineProperty(exports, "zeroPadValue", {
    enumerable: true,
    get: function() {
        return data_js_1.zeroPadValue;
    }
});
Object.defineProperty(exports, "zeroPadBytes", {
    enumerable: true,
    get: function() {
        return data_js_1.zeroPadBytes;
    }
});
var errors_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/errors.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isCallException", {
    enumerable: true,
    get: function() {
        return errors_js_1.isCallException;
    }
});
Object.defineProperty(exports, "isError", {
    enumerable: true,
    get: function() {
        return errors_js_1.isError;
    }
});
Object.defineProperty(exports, "assert", {
    enumerable: true,
    get: function() {
        return errors_js_1.assert;
    }
});
Object.defineProperty(exports, "assertArgument", {
    enumerable: true,
    get: function() {
        return errors_js_1.assertArgument;
    }
});
Object.defineProperty(exports, "assertArgumentCount", {
    enumerable: true,
    get: function() {
        return errors_js_1.assertArgumentCount;
    }
});
Object.defineProperty(exports, "assertPrivate", {
    enumerable: true,
    get: function() {
        return errors_js_1.assertPrivate;
    }
});
Object.defineProperty(exports, "assertNormalize", {
    enumerable: true,
    get: function() {
        return errors_js_1.assertNormalize;
    }
});
Object.defineProperty(exports, "makeError", {
    enumerable: true,
    get: function() {
        return errors_js_1.makeError;
    }
});
var events_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/events.js [app-client] (ecmascript)");
Object.defineProperty(exports, "EventPayload", {
    enumerable: true,
    get: function() {
        return events_js_1.EventPayload;
    }
});
var fetch_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/fetch.js [app-client] (ecmascript)");
Object.defineProperty(exports, "FetchRequest", {
    enumerable: true,
    get: function() {
        return fetch_js_1.FetchRequest;
    }
});
Object.defineProperty(exports, "FetchResponse", {
    enumerable: true,
    get: function() {
        return fetch_js_1.FetchResponse;
    }
});
Object.defineProperty(exports, "FetchCancelSignal", {
    enumerable: true,
    get: function() {
        return fetch_js_1.FetchCancelSignal;
    }
});
var fixednumber_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/fixednumber.js [app-client] (ecmascript)");
Object.defineProperty(exports, "FixedNumber", {
    enumerable: true,
    get: function() {
        return fixednumber_js_1.FixedNumber;
    }
});
var maths_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/maths.js [app-client] (ecmascript)");
Object.defineProperty(exports, "fromTwos", {
    enumerable: true,
    get: function() {
        return maths_js_1.fromTwos;
    }
});
Object.defineProperty(exports, "toTwos", {
    enumerable: true,
    get: function() {
        return maths_js_1.toTwos;
    }
});
Object.defineProperty(exports, "mask", {
    enumerable: true,
    get: function() {
        return maths_js_1.mask;
    }
});
Object.defineProperty(exports, "getBigInt", {
    enumerable: true,
    get: function() {
        return maths_js_1.getBigInt;
    }
});
Object.defineProperty(exports, "getNumber", {
    enumerable: true,
    get: function() {
        return maths_js_1.getNumber;
    }
});
Object.defineProperty(exports, "getUint", {
    enumerable: true,
    get: function() {
        return maths_js_1.getUint;
    }
});
Object.defineProperty(exports, "toBigInt", {
    enumerable: true,
    get: function() {
        return maths_js_1.toBigInt;
    }
});
Object.defineProperty(exports, "toNumber", {
    enumerable: true,
    get: function() {
        return maths_js_1.toNumber;
    }
});
Object.defineProperty(exports, "toBeHex", {
    enumerable: true,
    get: function() {
        return maths_js_1.toBeHex;
    }
});
Object.defineProperty(exports, "toBeArray", {
    enumerable: true,
    get: function() {
        return maths_js_1.toBeArray;
    }
});
Object.defineProperty(exports, "toQuantity", {
    enumerable: true,
    get: function() {
        return maths_js_1.toQuantity;
    }
});
var properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
Object.defineProperty(exports, "resolveProperties", {
    enumerable: true,
    get: function() {
        return properties_js_1.resolveProperties;
    }
});
Object.defineProperty(exports, "defineProperties", {
    enumerable: true,
    get: function() {
        return properties_js_1.defineProperties;
    }
});
var rlp_decode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/rlp-decode.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeRlp", {
    enumerable: true,
    get: function() {
        return rlp_decode_js_1.decodeRlp;
    }
});
var rlp_encode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/rlp-encode.js [app-client] (ecmascript)");
Object.defineProperty(exports, "encodeRlp", {
    enumerable: true,
    get: function() {
        return rlp_encode_js_1.encodeRlp;
    }
});
var units_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/units.js [app-client] (ecmascript)");
Object.defineProperty(exports, "formatEther", {
    enumerable: true,
    get: function() {
        return units_js_1.formatEther;
    }
});
Object.defineProperty(exports, "parseEther", {
    enumerable: true,
    get: function() {
        return units_js_1.parseEther;
    }
});
Object.defineProperty(exports, "formatUnits", {
    enumerable: true,
    get: function() {
        return units_js_1.formatUnits;
    }
});
Object.defineProperty(exports, "parseUnits", {
    enumerable: true,
    get: function() {
        return units_js_1.parseUnits;
    }
});
var utf8_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/utf8.js [app-client] (ecmascript)");
Object.defineProperty(exports, "toUtf8Bytes", {
    enumerable: true,
    get: function() {
        return utf8_js_1.toUtf8Bytes;
    }
});
Object.defineProperty(exports, "toUtf8CodePoints", {
    enumerable: true,
    get: function() {
        return utf8_js_1.toUtf8CodePoints;
    }
});
Object.defineProperty(exports, "toUtf8String", {
    enumerable: true,
    get: function() {
        return utf8_js_1.toUtf8String;
    }
});
Object.defineProperty(exports, "Utf8ErrorFuncs", {
    enumerable: true,
    get: function() {
        return utf8_js_1.Utf8ErrorFuncs;
    }
});
var uuid_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/uuid.js [app-client] (ecmascript)");
Object.defineProperty(exports, "uuidV4", {
    enumerable: true,
    get: function() {
        return uuid_js_1.uuidV4;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Reader = exports.Writer = exports.Coder = exports.checkResultErrors = exports.Result = exports.WordSize = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 * @_ignore:
 */ exports.WordSize = 32;
const Padding = new Uint8Array(exports.WordSize);
// Properties used to immediate pass through to the underlying object
// - `then` is used to detect if an object is a Promise for await
const passProperties = [
    "then"
];
const _guard = {};
const resultNames = new WeakMap();
function getNames(result) {
    return resultNames.get(result);
}
function setNames(result, names) {
    resultNames.set(result, names);
}
function throwError(name, error) {
    const wrapped = new Error("deferred error during ABI decoding triggered accessing ".concat(name));
    wrapped.error = error;
    throw wrapped;
}
function toObject(names, items, deep) {
    if (names.indexOf(null) >= 0) {
        return items.map((item, index)=>{
            if (item instanceof Result) {
                return toObject(getNames(item), item, deep);
            }
            return item;
        });
    }
    return names.reduce((accum, name, index)=>{
        let item = items.getValue(name);
        if (!(name in accum)) {
            if (deep && item instanceof Result) {
                item = toObject(getNames(item), item, deep);
            }
            accum[name] = item;
        }
        return accum;
    }, {});
}
var // No longer used; but cannot be removed as it will remove the
// #private field from the .d.ts which may break backwards
// compatibility
_names = /*#__PURE__*/ new WeakMap();
/**
 *  A [[Result]] is a sub-class of Array, which allows accessing any
 *  of its values either positionally by its index or, if keys are
 *  provided by its name.
 *
 *  @_docloc: api/abi
 */ class Result extends Array {
    /**
     *  Returns the Result as a normal Array. If %%deep%%, any children
     *  which are Result objects are also converted to a normal Array.
     *
     *  This will throw if there are any outstanding deferred
     *  errors.
     */ toArray(deep) {
        const result = [];
        this.forEach((item, index)=>{
            if (item instanceof Error) {
                throwError("index ".concat(index), item);
            }
            if (deep && item instanceof Result) {
                item = item.toArray(deep);
            }
            result.push(item);
        });
        return result;
    }
    /**
     *  Returns the Result as an Object with each name-value pair. If
     *  %%deep%%, any children which are Result objects are also
     *  converted to an Object.
     *
     *  This will throw if any value is unnamed, or if there are
     *  any outstanding deferred errors.
     */ toObject(deep) {
        const names = getNames(this);
        return names.reduce((accum, name, index)=>{
            (0, index_js_1.assert)(name != null, "value at index ".concat(index, " unnamed"), "UNSUPPORTED_OPERATION", {
                operation: "toObject()"
            });
            return toObject(names, this, deep);
        }, {});
    }
    /**
     *  @_ignore
     */ slice(start, end) {
        if (start == null) {
            start = 0;
        }
        if (start < 0) {
            start += this.length;
            if (start < 0) {
                start = 0;
            }
        }
        if (end == null) {
            end = this.length;
        }
        if (end < 0) {
            end += this.length;
            if (end < 0) {
                end = 0;
            }
        }
        if (end > this.length) {
            end = this.length;
        }
        const _names = getNames(this);
        const result = [], names = [];
        for(let i = start; i < end; i++){
            result.push(this[i]);
            names.push(_names[i]);
        }
        return new Result(_guard, result, names);
    }
    /**
     *  @_ignore
     */ filter(callback, thisArg) {
        const _names = getNames(this);
        const result = [], names = [];
        for(let i = 0; i < this.length; i++){
            const item = this[i];
            if (item instanceof Error) {
                throwError("index ".concat(i), item);
            }
            if (callback.call(thisArg, item, i, this)) {
                result.push(item);
                names.push(_names[i]);
            }
        }
        return new Result(_guard, result, names);
    }
    /**
     *  @_ignore
     */ map(callback, thisArg) {
        const result = [];
        for(let i = 0; i < this.length; i++){
            const item = this[i];
            if (item instanceof Error) {
                throwError("index ".concat(i), item);
            }
            result.push(callback.call(thisArg, item, i, this));
        }
        return result;
    }
    /**
     *  Returns the value for %%name%%.
     *
     *  Since it is possible to have a key whose name conflicts with
     *  a method on a [[Result]] or its superclass Array, or any
     *  JavaScript keyword, this ensures all named values are still
     *  accessible by name.
     */ getValue(name) {
        const index = getNames(this).indexOf(name);
        if (index === -1) {
            return undefined;
        }
        const value = this[index];
        if (value instanceof Error) {
            throwError("property ".concat(JSON.stringify(name)), value.error);
        }
        return value;
    }
    /**
     *  Creates a new [[Result]] for %%items%% with each entry
     *  also accessible by its corresponding name in %%keys%%.
     */ static fromItems(items, keys) {
        return new Result(_guard, items, keys);
    }
    /**
     *  @private
     */ constructor(...args){
        // To properly sub-class Array so the other built-in
        // functions work, the constructor has to behave fairly
        // well. So, in the event we are created via fromItems()
        // we build the read-only Result object we want, but on
        // any other input, we use the default constructor
        // constructor(guard: any, items: Array<any>, keys?: Array<null | string>);
        const guard = args[0];
        let items = args[1];
        let names = (args[2] || []).slice();
        let wrap = true;
        if (guard !== _guard) {
            items = args;
            names = [];
            wrap = false;
        }
        // Can't just pass in ...items since an array of length 1
        // is a special case in the super.
        super(items.length), _class_private_field_init._(this, _names, {
            writable: true,
            value: void 0
        });
        items.forEach((item, index)=>{
            this[index] = item;
        });
        // Find all unique keys
        const nameCounts = names.reduce((accum, name)=>{
            if (typeof name === "string") {
                accum.set(name, (accum.get(name) || 0) + 1);
            }
            return accum;
        }, new Map());
        // Remove any key thats not unique
        setNames(this, Object.freeze(items.map((item, index)=>{
            const name = names[index];
            if (name != null && nameCounts.get(name) === 1) {
                return name;
            }
            return null;
        })));
        // Dummy operations to prevent TypeScript from complaining
        _class_private_field_set._(this, _names, []);
        if (_class_private_field_get._(this, _names) == null) {
            void _class_private_field_get._(this, _names);
        }
        if (!wrap) {
            return;
        }
        // A wrapped Result is immutable
        Object.freeze(this);
        // Proxy indices and names so we can trap deferred errors
        const proxy = new Proxy(this, {
            get: (target, prop, receiver)=>{
                if (typeof prop === "string") {
                    // Index accessor
                    if (prop.match(/^[0-9]+$/)) {
                        const index = (0, index_js_1.getNumber)(prop, "%index");
                        if (index < 0 || index >= this.length) {
                            throw new RangeError("out of result range");
                        }
                        const item = target[index];
                        if (item instanceof Error) {
                            throwError("index ".concat(index), item);
                        }
                        return item;
                    }
                    // Pass important checks (like `then` for Promise) through
                    if (passProperties.indexOf(prop) >= 0) {
                        return Reflect.get(target, prop, receiver);
                    }
                    const value = target[prop];
                    if (value instanceof Function) {
                        // Make sure functions work with private variables
                        // See: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy#no_private_property_forwarding
                        return function() {
                            for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
                                args[_key] = arguments[_key];
                            }
                            return value.apply(this === receiver ? target : this, args);
                        };
                    } else if (!(prop in target)) {
                        // Possible name accessor
                        return target.getValue.apply(this === receiver ? target : this, [
                            prop
                        ]);
                    }
                }
                return Reflect.get(target, prop, receiver);
            }
        });
        setNames(proxy, getNames(this));
        return proxy;
    }
}
exports.Result = Result;
/**
 *  Returns all errors found in a [[Result]].
 *
 *  Since certain errors encountered when creating a [[Result]] do
 *  not impact the ability to continue parsing data, they are
 *  deferred until they are actually accessed. Hence a faulty string
 *  in an Event that is never used does not impact the program flow.
 *
 *  However, sometimes it may be useful to access, identify or
 *  validate correctness of a [[Result]].
 *
 *  @_docloc api/abi
 */ function checkResultErrors(result) {
    // Find the first error (if any)
    const errors = [];
    const checkErrors = function(path, object) {
        if (!Array.isArray(object)) {
            return;
        }
        for(let key in object){
            const childPath = path.slice();
            childPath.push(key);
            try {
                checkErrors(childPath, object[key]);
            } catch (error) {
                errors.push({
                    path: childPath,
                    error: error
                });
            }
        }
    };
    checkErrors([], result);
    return errors;
}
exports.checkResultErrors = checkResultErrors;
function getValue(value) {
    let bytes = (0, index_js_1.toBeArray)(value);
    (0, index_js_1.assert)(bytes.length <= exports.WordSize, "value out-of-bounds", "BUFFER_OVERRUN", {
        buffer: bytes,
        length: exports.WordSize,
        offset: bytes.length
    });
    if (bytes.length !== exports.WordSize) {
        bytes = (0, index_js_1.getBytesCopy)((0, index_js_1.concat)([
            Padding.slice(bytes.length % exports.WordSize),
            bytes
        ]));
    }
    return bytes;
}
/**
 *  @_ignore
 */ class Coder {
    _throwError(message, value) {
        (0, index_js_1.assertArgument)(false, message, this.localName, value);
    }
    constructor(name, type, localName, dynamic){
        // The coder name:
        //   - address, uint256, tuple, array, etc.
        _define_property._(this, "name", void 0);
        // The fully expanded type, including composite types:
        //   - address, uint256, tuple(address,bytes), uint256[3][4][],  etc.
        _define_property._(this, "type", void 0);
        // The localName bound in the signature, in this example it is "baz":
        //   - tuple(address foo, uint bar) baz
        _define_property._(this, "localName", void 0);
        // Whether this type is dynamic:
        //  - Dynamic: bytes, string, address[], tuple(boolean[]), etc.
        //  - Not Dynamic: address, uint256, boolean[3], tuple(address, uint8)
        _define_property._(this, "dynamic", void 0);
        (0, index_js_1.defineProperties)(this, {
            name,
            type,
            localName,
            dynamic
        }, {
            name: "string",
            type: "string",
            localName: "string",
            dynamic: "boolean"
        });
    }
}
exports.Coder = Coder;
var // An array of WordSize lengthed objects to concatenation
_data = /*#__PURE__*/ new WeakMap(), _dataLength = /*#__PURE__*/ new WeakMap(), _writeData = /*#__PURE__*/ new WeakSet();
/**
 *  @_ignore
 */ class Writer {
    get data() {
        return (0, index_js_1.concat)(_class_private_field_get._(this, _data));
    }
    get length() {
        return _class_private_field_get._(this, _dataLength);
    }
    appendWriter(writer) {
        return _class_private_method_get._(this, _writeData, writeData).call(this, (0, index_js_1.getBytesCopy)(writer.data));
    }
    // Arrayish item; pad on the right to *nearest* WordSize
    writeBytes(value) {
        let bytes = (0, index_js_1.getBytesCopy)(value);
        const paddingOffset = bytes.length % exports.WordSize;
        if (paddingOffset) {
            bytes = (0, index_js_1.getBytesCopy)((0, index_js_1.concat)([
                bytes,
                Padding.slice(paddingOffset)
            ]));
        }
        return _class_private_method_get._(this, _writeData, writeData).call(this, bytes);
    }
    // Numeric item; pad on the left *to* WordSize
    writeValue(value) {
        return _class_private_method_get._(this, _writeData, writeData).call(this, getValue(value));
    }
    // Inserts a numeric place-holder, returning a callback that can
    // be used to asjust the value later
    writeUpdatableValue() {
        const offset = _class_private_field_get._(this, _data).length;
        _class_private_field_get._(this, _data).push(Padding);
        _class_private_field_set._(this, _dataLength, _class_private_field_get._(this, _dataLength) + exports.WordSize);
        return (value)=>{
            _class_private_field_get._(this, _data)[offset] = getValue(value);
        };
    }
    constructor(){
        _class_private_method_init._(this, _writeData);
        _class_private_field_init._(this, _data, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _dataLength, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _data, []);
        _class_private_field_set._(this, _dataLength, 0);
    }
}
function writeData(data) {
    _class_private_field_get._(this, _data).push(data);
    _class_private_field_set._(this, _dataLength, _class_private_field_get._(this, _dataLength) + data.length);
    return data.length;
}
exports.Writer = Writer;
var _data1 = /*#__PURE__*/ new WeakMap(), _offset = /*#__PURE__*/ new WeakMap(), _bytesRead = /*#__PURE__*/ new WeakMap(), _parent = /*#__PURE__*/ new WeakMap(), _maxInflation = /*#__PURE__*/ new WeakMap(), _incrementBytesRead = /*#__PURE__*/ new WeakSet(), _peekBytes = /*#__PURE__*/ new WeakSet();
/**
 *  @_ignore
 */ class Reader {
    get data() {
        return (0, index_js_1.hexlify)(_class_private_field_get._(this, _data1));
    }
    get dataLength() {
        return _class_private_field_get._(this, _data1).length;
    }
    get consumed() {
        return _class_private_field_get._(this, _offset);
    }
    get bytes() {
        return new Uint8Array(_class_private_field_get._(this, _data1));
    }
    // Create a sub-reader with the same underlying data, but offset
    subReader(offset) {
        const reader = new Reader(_class_private_field_get._(this, _data1).slice(_class_private_field_get._(this, _offset) + offset), this.allowLoose, _class_private_field_get._(this, _maxInflation));
        _class_private_field_set._(reader, _parent, this);
        return reader;
    }
    // Read bytes
    readBytes(length, loose) {
        let bytes = _class_private_method_get._(this, _peekBytes, peekBytes).call(this, 0, length, !!loose);
        _class_private_method_get._(this, _incrementBytesRead, incrementBytesRead).call(this, length);
        _class_private_field_set._(this, _offset, _class_private_field_get._(this, _offset) + bytes.length);
        // @TODO: Make sure the length..end bytes are all 0?
        return bytes.slice(0, length);
    }
    // Read a numeric values
    readValue() {
        return (0, index_js_1.toBigInt)(this.readBytes(exports.WordSize));
    }
    readIndex() {
        return (0, index_js_1.toNumber)(this.readBytes(exports.WordSize));
    }
    constructor(data, allowLoose, maxInflation){
        _class_private_method_init._(this, _incrementBytesRead);
        _class_private_method_init._(this, _peekBytes);
        // Allows incomplete unpadded data to be read; otherwise an error
        // is raised if attempting to overrun the buffer. This is required
        // to deal with an old Solidity bug, in which event data for
        // external (not public thoguh) was tightly packed.
        _define_property._(this, "allowLoose", void 0);
        _class_private_field_init._(this, _data1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _offset, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _bytesRead, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _parent, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _maxInflation, {
            writable: true,
            value: void 0
        });
        (0, index_js_1.defineProperties)(this, {
            allowLoose: !!allowLoose
        });
        _class_private_field_set._(this, _data1, (0, index_js_1.getBytesCopy)(data));
        _class_private_field_set._(this, _bytesRead, 0);
        _class_private_field_set._(this, _parent, null);
        _class_private_field_set._(this, _maxInflation, maxInflation != null ? maxInflation : 1024);
        _class_private_field_set._(this, _offset, 0);
    }
}
function incrementBytesRead(count) {
    var _class_private_field_get1;
    if (_class_private_field_get._(this, _parent)) {
        return _class_private_method_get._(_class_private_field_get1 = _class_private_field_get._(this, _parent), _incrementBytesRead, incrementBytesRead).call(_class_private_field_get1, count);
    }
    _class_private_field_set._(this, _bytesRead, _class_private_field_get._(this, _bytesRead) + count);
    // Check for excessive inflation (see: #4537)
    (0, index_js_1.assert)(_class_private_field_get._(this, _maxInflation) < 1 || _class_private_field_get._(this, _bytesRead) <= _class_private_field_get._(this, _maxInflation) * this.dataLength, "compressed ABI data exceeds inflation ratio of ".concat(_class_private_field_get._(this, _maxInflation), " ( see: https://github.com/ethers-io/ethers.js/issues/4537 )"), "BUFFER_OVERRUN", {
        buffer: (0, index_js_1.getBytesCopy)(_class_private_field_get._(this, _data1)),
        offset: _class_private_field_get._(this, _offset),
        length: count,
        info: {
            bytesRead: _class_private_field_get._(this, _bytesRead),
            dataLength: this.dataLength
        }
    });
}
function peekBytes(offset, length, loose) {
    let alignedLength = Math.ceil(length / exports.WordSize) * exports.WordSize;
    if (_class_private_field_get._(this, _offset) + alignedLength > _class_private_field_get._(this, _data1).length) {
        if (this.allowLoose && loose && _class_private_field_get._(this, _offset) + length <= _class_private_field_get._(this, _data1).length) {
            alignedLength = length;
        } else {
            (0, index_js_1.assert)(false, "data out-of-bounds", "BUFFER_OVERRUN", {
                buffer: (0, index_js_1.getBytesCopy)(_class_private_field_get._(this, _data1)),
                length: _class_private_field_get._(this, _data1).length,
                offset: _class_private_field_get._(this, _offset) + alignedLength
            });
        }
    }
    return _class_private_field_get._(this, _data1).slice(_class_private_field_get._(this, _offset), _class_private_field_get._(this, _offset) + alignedLength);
}
exports.Reader = Reader; //# sourceMappingURL=abstract-coder.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/crypto-browser.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/* Browser Crypto Shims */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.randomBytes = exports.pbkdf2Sync = exports.createHmac = exports.createHash = void 0;
const hmac_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/hmac.js [app-client] (ecmascript)");
const pbkdf2_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/pbkdf2.js [app-client] (ecmascript)");
const sha256_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/sha256.js [app-client] (ecmascript)");
const sha512_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/sha512.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
function getGlobal() {
    if (typeof self !== 'undefined') {
        return self;
    }
    if (typeof window !== 'undefined') {
        return window;
    }
    if ("TURBOPACK compile-time truthy", 1) {
        return /*TURBOPACK member replacement*/ __turbopack_context__.g;
    }
    //TURBOPACK unreachable
    ;
}
;
const anyGlobal = getGlobal();
const crypto = anyGlobal.crypto || anyGlobal.msCrypto;
function createHash(algo) {
    switch(algo){
        case "sha256":
            return sha256_1.sha256.create();
        case "sha512":
            return sha512_1.sha512.create();
    }
    (0, index_js_1.assertArgument)(false, "invalid hashing algorithm name", "algorithm", algo);
}
exports.createHash = createHash;
function createHmac(_algo, key) {
    const algo = {
        sha256: sha256_1.sha256,
        sha512: sha512_1.sha512
    }[_algo];
    (0, index_js_1.assertArgument)(algo != null, "invalid hmac algorithm", "algorithm", _algo);
    return hmac_1.hmac.create(algo, key);
}
exports.createHmac = createHmac;
function pbkdf2Sync(password, salt, iterations, keylen, _algo) {
    const algo = {
        sha256: sha256_1.sha256,
        sha512: sha512_1.sha512
    }[_algo];
    (0, index_js_1.assertArgument)(algo != null, "invalid pbkdf2 algorithm", "algorithm", _algo);
    return (0, pbkdf2_1.pbkdf2)(algo, password, salt, {
        c: iterations,
        dkLen: keylen
    });
}
exports.pbkdf2Sync = pbkdf2Sync;
function randomBytes(length) {
    (0, index_js_1.assert)(crypto != null, "platform does not support secure random numbers", "UNSUPPORTED_OPERATION", {
        operation: "randomBytes"
    });
    (0, index_js_1.assertArgument)(Number.isInteger(length) && length > 0 && length <= 1024, "invalid length", "length", length);
    const result = new Uint8Array(length);
    crypto.getRandomValues(result);
    return result;
}
exports.randomBytes = randomBytes; //# sourceMappingURL=crypto-browser.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/hmac.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.computeHmac = void 0;
/**
 *  An **HMAC** enables verification that a given key was used
 *  to authenticate a payload.
 *
 *  See: [[link-wiki-hmac]]
 *
 *  @_subsection: api/crypto:HMAC  [about-hmac]
 */ const crypto_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/crypto-browser.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
let locked = false;
const _computeHmac = function(algorithm, key, data) {
    return (0, crypto_js_1.createHmac)(algorithm, key).update(data).digest();
};
let __computeHmac = _computeHmac;
/**
 *  Return the HMAC for %%data%% using the %%key%% key with the underlying
 *  %%algo%% used for compression.
 *
 *  @example:
 *    key = id("some-secret")
 *
 *    // Compute the HMAC
 *    computeHmac("sha256", key, "0x1337")
 *    //_result:
 *
 *    // To compute the HMAC of UTF-8 data, the data must be
 *    // converted to UTF-8 bytes
 *    computeHmac("sha256", key, toUtf8Bytes("Hello World"))
 *    //_result:
 *
 */ function computeHmac(algorithm, _key, _data) {
    const key = (0, index_js_1.getBytes)(_key, "key");
    const data = (0, index_js_1.getBytes)(_data, "data");
    return (0, index_js_1.hexlify)(__computeHmac(algorithm, key, data));
}
exports.computeHmac = computeHmac;
computeHmac._ = _computeHmac;
computeHmac.lock = function() {
    locked = true;
};
computeHmac.register = function(func) {
    if (locked) {
        throw new Error("computeHmac is locked");
    }
    __computeHmac = func;
};
Object.freeze(computeHmac); //# sourceMappingURL=hmac.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/keccak.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  Cryptographic hashing functions
 *
 *  @_subsection: api/crypto:Hash Functions [about-crypto-hashing]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.keccak256 = void 0;
const sha3_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/sha3.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
let locked = false;
const _keccak256 = function(data) {
    return (0, sha3_1.keccak_256)(data);
};
let __keccak256 = _keccak256;
/**
 *  Compute the cryptographic KECCAK256 hash of %%data%%.
 *
 *  The %%data%% **must** be a data representation, to compute the
 *  hash of UTF-8 data use the [[id]] function.
 *
 *  @returns DataHexstring
 *  @example:
 *    keccak256("0x")
 *    //_result:
 *
 *    keccak256("0x1337")
 *    //_result:
 *
 *    keccak256(new Uint8Array([ 0x13, 0x37 ]))
 *    //_result:
 *
 *    // Strings are assumed to be DataHexString, otherwise it will
 *    // throw. To hash UTF-8 data, see the note above.
 *    keccak256("Hello World")
 *    //_error:
 */ function keccak256(_data) {
    const data = (0, index_js_1.getBytes)(_data, "data");
    return (0, index_js_1.hexlify)(__keccak256(data));
}
exports.keccak256 = keccak256;
keccak256._ = _keccak256;
keccak256.lock = function() {
    locked = true;
};
keccak256.register = function(func) {
    if (locked) {
        throw new TypeError("keccak256 is locked");
    }
    __keccak256 = func;
};
Object.freeze(keccak256); //# sourceMappingURL=keccak.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/ripemd160.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ripemd160 = void 0;
const ripemd160_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/ripemd160.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
let locked = false;
const _ripemd160 = function(data) {
    return (0, ripemd160_1.ripemd160)(data);
};
let __ripemd160 = _ripemd160;
/**
 *  Compute the cryptographic RIPEMD-160 hash of %%data%%.
 *
 *  @_docloc: api/crypto:Hash Functions
 *  @returns DataHexstring
 *
 *  @example:
 *    ripemd160("0x")
 *    //_result:
 *
 *    ripemd160("0x1337")
 *    //_result:
 *
 *    ripemd160(new Uint8Array([ 0x13, 0x37 ]))
 *    //_result:
 *
 */ function ripemd160(_data) {
    const data = (0, index_js_1.getBytes)(_data, "data");
    return (0, index_js_1.hexlify)(__ripemd160(data));
}
exports.ripemd160 = ripemd160;
ripemd160._ = _ripemd160;
ripemd160.lock = function() {
    locked = true;
};
ripemd160.register = function(func) {
    if (locked) {
        throw new TypeError("ripemd160 is locked");
    }
    __ripemd160 = func;
};
Object.freeze(ripemd160); //# sourceMappingURL=ripemd160.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/pbkdf2.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  A **Password-Based Key-Derivation Function** is designed to create
 *  a sequence of bytes suitible as a **key** from a human-rememberable
 *  password.
 *
 *  @_subsection: api/crypto:Passwords  [about-pbkdf]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.pbkdf2 = void 0;
const crypto_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/crypto-browser.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
let locked = false;
const _pbkdf2 = function(password, salt, iterations, keylen, algo) {
    return (0, crypto_js_1.pbkdf2Sync)(password, salt, iterations, keylen, algo);
};
let __pbkdf2 = _pbkdf2;
/**
 *  Return the [[link-pbkdf2]] for %%keylen%% bytes for %%password%% using
 *  the %%salt%% and using %%iterations%% of %%algo%%.
 *
 *  This PBKDF is outdated and should not be used in new projects, but is
 *  required to decrypt older files.
 *
 *  @example:
 *    // The password must be converted to bytes, and it is generally
 *    // best practices to ensure the string has been normalized. Many
 *    // formats explicitly indicate the normalization form to use.
 *    password = "hello"
 *    passwordBytes = toUtf8Bytes(password, "NFKC")
 *
 *    salt = id("some-salt")
 *
 *    // Compute the PBKDF2
 *    pbkdf2(passwordBytes, salt, 1024, 16, "sha256")
 *    //_result:
 */ function pbkdf2(_password, _salt, iterations, keylen, algo) {
    const password = (0, index_js_1.getBytes)(_password, "password");
    const salt = (0, index_js_1.getBytes)(_salt, "salt");
    return (0, index_js_1.hexlify)(__pbkdf2(password, salt, iterations, keylen, algo));
}
exports.pbkdf2 = pbkdf2;
pbkdf2._ = _pbkdf2;
pbkdf2.lock = function() {
    locked = true;
};
pbkdf2.register = function(func) {
    if (locked) {
        throw new Error("pbkdf2 is locked");
    }
    __pbkdf2 = func;
};
Object.freeze(pbkdf2); //# sourceMappingURL=pbkdf2.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/random.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.randomBytes = void 0;
/**
 *  A **Cryptographically Secure Random Value** is one that has been
 *  generated with additional care take to prevent side-channels
 *  from allowing others to detect it and prevent others from through
 *  coincidence generate the same values.
 *
 *  @_subsection: api/crypto:Random Values  [about-crypto-random]
 */ const crypto_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/crypto-browser.js [app-client] (ecmascript)");
let locked = false;
const _randomBytes = function(length) {
    return new Uint8Array((0, crypto_js_1.randomBytes)(length));
};
let __randomBytes = _randomBytes;
/**
 *  Return %%length%% bytes of cryptographically secure random data.
 *
 *  @example:
 *    randomBytes(8)
 *    //_result:
 */ function randomBytes(length) {
    return __randomBytes(length);
}
exports.randomBytes = randomBytes;
randomBytes._ = _randomBytes;
randomBytes.lock = function() {
    locked = true;
};
randomBytes.register = function(func) {
    if (locked) {
        throw new Error("randomBytes is locked");
    }
    __randomBytes = func;
};
Object.freeze(randomBytes); //# sourceMappingURL=random.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/scrypt.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.scryptSync = exports.scrypt = void 0;
const scrypt_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+hashes@1.3.2/node_modules/@noble/hashes/scrypt.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
let lockedSync = false, lockedAsync = false;
const _scryptAsync = async function(passwd, salt, N, r, p, dkLen, onProgress) {
    return await (0, scrypt_1.scryptAsync)(passwd, salt, {
        N,
        r,
        p,
        dkLen,
        onProgress
    });
};
const _scryptSync = function(passwd, salt, N, r, p, dkLen) {
    return (0, scrypt_1.scrypt)(passwd, salt, {
        N,
        r,
        p,
        dkLen
    });
};
let __scryptAsync = _scryptAsync;
let __scryptSync = _scryptSync;
/**
 *  The [[link-wiki-scrypt]] uses a memory and cpu hard method of
 *  derivation to increase the resource cost to brute-force a password
 *  for a given key.
 *
 *  This means this algorithm is intentionally slow, and can be tuned to
 *  become slower. As computation and memory speed improve over time,
 *  increasing the difficulty maintains the cost of an attacker.
 *
 *  For example, if a target time of 5 seconds is used, a legitimate user
 *  which knows their password requires only 5 seconds to unlock their
 *  account. A 6 character password has 68 billion possibilities, which
 *  would require an attacker to invest over 10,000 years of CPU time. This
 *  is of course a crude example (as password generally aren't random),
 *  but demonstrates to value of imposing large costs to decryption.
 *
 *  For this reason, if building a UI which involved decrypting or
 *  encrypting datsa using scrypt, it is recommended to use a
 *  [[ProgressCallback]] (as event short periods can seem lik an eternity
 *  if the UI freezes). Including the phrase //"decrypting"// in the UI
 *  can also help, assuring the user their waiting is for a good reason.
 *
 *  @_docloc: api/crypto:Passwords
 *
 *  @example:
 *    // The password must be converted to bytes, and it is generally
 *    // best practices to ensure the string has been normalized. Many
 *    // formats explicitly indicate the normalization form to use.
 *    password = "hello"
 *    passwordBytes = toUtf8Bytes(password, "NFKC")
 *
 *    salt = id("some-salt")
 *
 *    // Compute the scrypt
 *    scrypt(passwordBytes, salt, 1024, 8, 1, 16)
 *    //_result:
 */ async function scrypt(_passwd, _salt, N, r, p, dkLen, progress) {
    const passwd = (0, index_js_1.getBytes)(_passwd, "passwd");
    const salt = (0, index_js_1.getBytes)(_salt, "salt");
    return (0, index_js_1.hexlify)(await __scryptAsync(passwd, salt, N, r, p, dkLen, progress));
}
exports.scrypt = scrypt;
scrypt._ = _scryptAsync;
scrypt.lock = function() {
    lockedAsync = true;
};
scrypt.register = function(func) {
    if (lockedAsync) {
        throw new Error("scrypt is locked");
    }
    __scryptAsync = func;
};
Object.freeze(scrypt);
/**
 *  Provides a synchronous variant of [[scrypt]].
 *
 *  This will completely lock up and freeze the UI in a browser and will
 *  prevent any event loop from progressing. For this reason, it is
 *  preferred to use the [async variant](scrypt).
 *
 *  @_docloc: api/crypto:Passwords
 *
 *  @example:
 *    // The password must be converted to bytes, and it is generally
 *    // best practices to ensure the string has been normalized. Many
 *    // formats explicitly indicate the normalization form to use.
 *    password = "hello"
 *    passwordBytes = toUtf8Bytes(password, "NFKC")
 *
 *    salt = id("some-salt")
 *
 *    // Compute the scrypt
 *    scryptSync(passwordBytes, salt, 1024, 8, 1, 16)
 *    //_result:
 */ function scryptSync(_passwd, _salt, N, r, p, dkLen) {
    const passwd = (0, index_js_1.getBytes)(_passwd, "passwd");
    const salt = (0, index_js_1.getBytes)(_salt, "salt");
    return (0, index_js_1.hexlify)(__scryptSync(passwd, salt, N, r, p, dkLen));
}
exports.scryptSync = scryptSync;
scryptSync._ = _scryptSync;
scryptSync.lock = function() {
    lockedSync = true;
};
scryptSync.register = function(func) {
    if (lockedSync) {
        throw new Error("scryptSync is locked");
    }
    __scryptSync = func;
};
Object.freeze(scryptSync); //# sourceMappingURL=scrypt.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/sha2.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.sha512 = exports.sha256 = void 0;
const crypto_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/crypto-browser.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const _sha256 = function(data) {
    return (0, crypto_js_1.createHash)("sha256").update(data).digest();
};
const _sha512 = function(data) {
    return (0, crypto_js_1.createHash)("sha512").update(data).digest();
};
let __sha256 = _sha256;
let __sha512 = _sha512;
let locked256 = false, locked512 = false;
/**
 *  Compute the cryptographic SHA2-256 hash of %%data%%.
 *
 *  @_docloc: api/crypto:Hash Functions
 *  @returns DataHexstring
 *
 *  @example:
 *    sha256("0x")
 *    //_result:
 *
 *    sha256("0x1337")
 *    //_result:
 *
 *    sha256(new Uint8Array([ 0x13, 0x37 ]))
 *    //_result:
 *
 */ function sha256(_data) {
    const data = (0, index_js_1.getBytes)(_data, "data");
    return (0, index_js_1.hexlify)(__sha256(data));
}
exports.sha256 = sha256;
sha256._ = _sha256;
sha256.lock = function() {
    locked256 = true;
};
sha256.register = function(func) {
    if (locked256) {
        throw new Error("sha256 is locked");
    }
    __sha256 = func;
};
Object.freeze(sha256);
/**
 *  Compute the cryptographic SHA2-512 hash of %%data%%.
 *
 *  @_docloc: api/crypto:Hash Functions
 *  @returns DataHexstring
 *
 *  @example:
 *    sha512("0x")
 *    //_result:
 *
 *    sha512("0x1337")
 *    //_result:
 *
 *    sha512(new Uint8Array([ 0x13, 0x37 ]))
 *    //_result:
 */ function sha512(_data) {
    const data = (0, index_js_1.getBytes)(_data, "data");
    return (0, index_js_1.hexlify)(__sha512(data));
}
exports.sha512 = sha512;
sha512._ = _sha512;
sha512.lock = function() {
    locked512 = true;
};
sha512.register = function(func) {
    if (locked512) {
        throw new Error("sha512 is locked");
    }
    __sha512 = func;
};
Object.freeze(sha256); //# sourceMappingURL=sha2.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/addresses.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ZeroAddress = void 0;
/**
 *  A constant for the zero address.
 *
 *  (**i.e.** ``"0x0000000000000000000000000000000000000000"``)
 */ exports.ZeroAddress = "0x0000000000000000000000000000000000000000"; //# sourceMappingURL=addresses.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/hashes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ZeroHash = void 0;
/**
 *  A constant for the zero hash.
 *
 *  (**i.e.** ``"0x0000000000000000000000000000000000000000000000000000000000000000"``)
 */ exports.ZeroHash = "0x0000000000000000000000000000000000000000000000000000000000000000"; //# sourceMappingURL=hashes.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/numbers.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.MaxInt256 = exports.MinInt256 = exports.MaxUint256 = exports.WeiPerEther = exports.N = void 0;
/**
 *  A constant for the order N for the secp256k1 curve.
 *
 *  (**i.e.** ``0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141n``)
 */ exports.N = BigInt("0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141");
/**
 *  A constant for the number of wei in a single ether.
 *
 *  (**i.e.** ``1000000000000000000n``)
 */ exports.WeiPerEther = BigInt("1000000000000000000");
/**
 *  A constant for the maximum value for a ``uint256``.
 *
 *  (**i.e.** ``0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffn``)
 */ exports.MaxUint256 = BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
/**
 *  A constant for the minimum value for an ``int256``.
 *
 *  (**i.e.** ``-8000000000000000000000000000000000000000000000000000000000000000n``)
 */ exports.MinInt256 = BigInt("0x8000000000000000000000000000000000000000000000000000000000000000") * BigInt(-1);
/**
 *  A constant for the maximum value for an ``int256``.
 *
 *  (**i.e.** ``0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffn``)
 */ exports.MaxInt256 = BigInt("0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"); //# sourceMappingURL=numbers.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/strings.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

// NFKC (composed)             // (decomposed)
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.MessagePrefix = exports.EtherSymbol = void 0;
/**
 *  A constant for the ether symbol (normalized using NFKC).
 *
 *  (**i.e.** ``"\\u039e"``)
 */ exports.EtherSymbol = "\u039e"; // "\uD835\uDF63";
/**
 *  A constant for the [[link-eip-191]] personal message prefix.
 *
 *  (**i.e.** ``"\\x19Ethereum Signed Message:\\n"``)
 */ exports.MessagePrefix = "\x19Ethereum Signed Message:\n"; //# sourceMappingURL=strings.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  Some common constants useful for Ethereum.
 *
 *  @_section: api/constants: Constants  [about-constants]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.MessagePrefix = exports.EtherSymbol = exports.MaxInt256 = exports.MinInt256 = exports.MaxUint256 = exports.WeiPerEther = exports.N = exports.ZeroHash = exports.ZeroAddress = void 0;
var addresses_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/addresses.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ZeroAddress", {
    enumerable: true,
    get: function() {
        return addresses_js_1.ZeroAddress;
    }
});
var hashes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/hashes.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ZeroHash", {
    enumerable: true,
    get: function() {
        return hashes_js_1.ZeroHash;
    }
});
var numbers_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/numbers.js [app-client] (ecmascript)");
Object.defineProperty(exports, "N", {
    enumerable: true,
    get: function() {
        return numbers_js_1.N;
    }
});
Object.defineProperty(exports, "WeiPerEther", {
    enumerable: true,
    get: function() {
        return numbers_js_1.WeiPerEther;
    }
});
Object.defineProperty(exports, "MaxUint256", {
    enumerable: true,
    get: function() {
        return numbers_js_1.MaxUint256;
    }
});
Object.defineProperty(exports, "MinInt256", {
    enumerable: true,
    get: function() {
        return numbers_js_1.MinInt256;
    }
});
Object.defineProperty(exports, "MaxInt256", {
    enumerable: true,
    get: function() {
        return numbers_js_1.MaxInt256;
    }
});
var strings_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/strings.js [app-client] (ecmascript)");
Object.defineProperty(exports, "EtherSymbol", {
    enumerable: true,
    get: function() {
        return strings_js_1.EtherSymbol;
    }
});
Object.defineProperty(exports, "MessagePrefix", {
    enumerable: true,
    get: function() {
        return strings_js_1.MessagePrefix;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/signature.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Signature = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
// Constants
const BN_0 = BigInt(0);
const BN_1 = BigInt(1);
const BN_2 = BigInt(2);
const BN_27 = BigInt(27);
const BN_28 = BigInt(28);
const BN_35 = BigInt(35);
const _guard = {};
function toUint256(value) {
    return (0, index_js_2.zeroPadValue)((0, index_js_2.toBeArray)(value), 32);
}
var _r = /*#__PURE__*/ new WeakMap(), _s = /*#__PURE__*/ new WeakMap(), _v = /*#__PURE__*/ new WeakMap(), _networkV = /*#__PURE__*/ new WeakMap();
let _Symbol_for = Symbol.for('nodejs.util.inspect.custom');
/**
 *  A Signature  @TODO
 *
 *
 *  @_docloc: api/crypto:Signing
 */ class Signature {
    /**
     *  The ``r`` value for a signature.
     *
     *  This represents the ``x`` coordinate of a "reference" or
     *  challenge point, from which the ``y`` can be computed.
     */ get r() {
        return _class_private_field_get._(this, _r);
    }
    set r(value) {
        (0, index_js_2.assertArgument)((0, index_js_2.dataLength)(value) === 32, "invalid r", "value", value);
        _class_private_field_set._(this, _r, (0, index_js_2.hexlify)(value));
    }
    /**
     *  The ``s`` value for a signature.
     */ get s() {
        (0, index_js_2.assertArgument)(parseInt(_class_private_field_get._(this, _s).substring(0, 3)) < 8, "non-canonical s; use ._s", "s", _class_private_field_get._(this, _s));
        return _class_private_field_get._(this, _s);
    }
    set s(_value) {
        (0, index_js_2.assertArgument)((0, index_js_2.dataLength)(_value) === 32, "invalid s", "value", _value);
        _class_private_field_set._(this, _s, (0, index_js_2.hexlify)(_value));
    }
    /**
     *  Return the s value, unchecked for EIP-2 compliance.
     *
     *  This should generally not be used and is for situations where
     *  a non-canonical S value might be relevant, such as Frontier blocks
     *  that were mined prior to EIP-2 or invalid Authorization List
     *  signatures.
     */ get _s() {
        return _class_private_field_get._(this, _s);
    }
    /**
     *  Returns true if the Signature is valid for [[link-eip-2]] signatures.
     */ isValid() {
        return parseInt(_class_private_field_get._(this, _s).substring(0, 3)) < 8;
    }
    /**
     *  The ``v`` value for a signature.
     *
     *  Since a given ``x`` value for ``r`` has two possible values for
     *  its correspondin ``y``, the ``v`` indicates which of the two ``y``
     *  values to use.
     *
     *  It is normalized to the values ``27`` or ``28`` for legacy
     *  purposes.
     */ get v() {
        return _class_private_field_get._(this, _v);
    }
    set v(value) {
        const v = (0, index_js_2.getNumber)(value, "value");
        (0, index_js_2.assertArgument)(v === 27 || v === 28, "invalid v", "v", value);
        _class_private_field_set._(this, _v, v);
    }
    /**
     *  The EIP-155 ``v`` for legacy transactions. For non-legacy
     *  transactions, this value is ``null``.
     */ get networkV() {
        return _class_private_field_get._(this, _networkV);
    }
    /**
     *  The chain ID for EIP-155 legacy transactions. For non-legacy
     *  transactions, this value is ``null``.
     */ get legacyChainId() {
        const v = this.networkV;
        if (v == null) {
            return null;
        }
        return Signature.getChainId(v);
    }
    /**
     *  The ``yParity`` for the signature.
     *
     *  See ``v`` for more details on how this value is used.
     */ get yParity() {
        return this.v === 27 ? 0 : 1;
    }
    /**
     *  The [[link-eip-2098]] compact representation of the ``yParity``
     *  and ``s`` compacted into a single ``bytes32``.
     */ get yParityAndS() {
        // The EIP-2098 compact representation
        const yParityAndS = (0, index_js_2.getBytes)(this.s);
        if (this.yParity) {
            yParityAndS[0] |= 0x80;
        }
        return (0, index_js_2.hexlify)(yParityAndS);
    }
    /**
     *  The [[link-eip-2098]] compact representation.
     */ get compactSerialized() {
        return (0, index_js_2.concat)([
            this.r,
            this.yParityAndS
        ]);
    }
    /**
     *  The serialized representation.
     */ get serialized() {
        return (0, index_js_2.concat)([
            this.r,
            this.s,
            this.yParity ? "0x1c" : "0x1b"
        ]);
    }
    [_Symbol_for]() {
        return 'Signature { r: "'.concat(this.r, '", s: "').concat(this._s, '"').concat(this.isValid() ? "" : ', valid: "false"', ", yParity: ").concat(this.yParity, ", networkV: ").concat(this.networkV, " }");
    }
    /**
     *  Returns a new identical [[Signature]].
     */ clone() {
        const clone = new Signature(_guard, this.r, this._s, this.v);
        if (this.networkV) {
            _class_private_field_set._(clone, _networkV, this.networkV);
        }
        return clone;
    }
    /**
     *  Returns a representation that is compatible with ``JSON.stringify``.
     */ toJSON() {
        const networkV = this.networkV;
        return {
            _type: "signature",
            networkV: networkV != null ? networkV.toString() : null,
            r: this.r,
            s: this._s,
            v: this.v
        };
    }
    /**
     *  Compute the chain ID from the ``v`` in a legacy EIP-155 transactions.
     *
     *  @example:
     *    Signature.getChainId(45)
     *    //_result:
     *
     *    Signature.getChainId(46)
     *    //_result:
     */ static getChainId(v) {
        const bv = (0, index_js_2.getBigInt)(v, "v");
        // The v is not an EIP-155 v, so it is the unspecified chain ID
        if (bv == BN_27 || bv == BN_28) {
            return BN_0;
        }
        // Bad value for an EIP-155 v
        (0, index_js_2.assertArgument)(bv >= BN_35, "invalid EIP-155 v", "v", v);
        return (bv - BN_35) / BN_2;
    }
    /**
     *  Compute the ``v`` for a chain ID for a legacy EIP-155 transactions.
     *
     *  Legacy transactions which use [[link-eip-155]] hijack the ``v``
     *  property to include the chain ID.
     *
     *  @example:
     *    Signature.getChainIdV(5, 27)
     *    //_result:
     *
     *    Signature.getChainIdV(5, 28)
     *    //_result:
     *
     */ static getChainIdV(chainId, v) {
        return (0, index_js_2.getBigInt)(chainId) * BN_2 + BigInt(35 + v - 27);
    }
    /**
     *  Compute the normalized legacy transaction ``v`` from a ``yParirty``,
     *  a legacy transaction ``v`` or a legacy [[link-eip-155]] transaction.
     *
     *  @example:
     *    // The values 0 and 1 imply v is actually yParity
     *    Signature.getNormalizedV(0)
     *    //_result:
     *
     *    // Legacy non-EIP-1559 transaction (i.e. 27 or 28)
     *    Signature.getNormalizedV(27)
     *    //_result:
     *
     *    // Legacy EIP-155 transaction (i.e. >= 35)
     *    Signature.getNormalizedV(46)
     *    //_result:
     *
     *    // Invalid values throw
     *    Signature.getNormalizedV(5)
     *    //_error:
     */ static getNormalizedV(v) {
        const bv = (0, index_js_2.getBigInt)(v);
        if (bv === BN_0 || bv === BN_27) {
            return 27;
        }
        if (bv === BN_1 || bv === BN_28) {
            return 28;
        }
        (0, index_js_2.assertArgument)(bv >= BN_35, "invalid v", "v", v);
        // Otherwise, EIP-155 v means odd is 27 and even is 28
        return bv & BN_1 ? 27 : 28;
    }
    /**
     *  Creates a new [[Signature]].
     *
     *  If no %%sig%% is provided, a new [[Signature]] is created
     *  with default values.
     *
     *  If %%sig%% is a string, it is parsed.
     */ static from(sig) {
        function assertError(check, message) {
            (0, index_js_2.assertArgument)(check, message, "signature", sig);
        }
        ;
        if (sig == null) {
            return new Signature(_guard, index_js_1.ZeroHash, index_js_1.ZeroHash, 27);
        }
        if (typeof sig === "string") {
            const bytes = (0, index_js_2.getBytes)(sig, "signature");
            if (bytes.length === 64) {
                const r = (0, index_js_2.hexlify)(bytes.slice(0, 32));
                const s = bytes.slice(32, 64);
                const v = s[0] & 0x80 ? 28 : 27;
                s[0] &= 0x7f;
                return new Signature(_guard, r, (0, index_js_2.hexlify)(s), v);
            }
            if (bytes.length === 65) {
                const r = (0, index_js_2.hexlify)(bytes.slice(0, 32));
                const s = (0, index_js_2.hexlify)(bytes.slice(32, 64));
                const v = Signature.getNormalizedV(bytes[64]);
                return new Signature(_guard, r, s, v);
            }
            assertError(false, "invalid raw signature length");
        }
        if (sig instanceof Signature) {
            return sig.clone();
        }
        // Get r
        const _r = sig.r;
        assertError(_r != null, "missing r");
        const r = toUint256(_r);
        // Get s; by any means necessary (we check consistency below)
        const s = function(s, yParityAndS) {
            if (s != null) {
                return toUint256(s);
            }
            if (yParityAndS != null) {
                assertError((0, index_js_2.isHexString)(yParityAndS, 32), "invalid yParityAndS");
                const bytes = (0, index_js_2.getBytes)(yParityAndS);
                bytes[0] &= 0x7f;
                return (0, index_js_2.hexlify)(bytes);
            }
            assertError(false, "missing s");
        }(sig.s, sig.yParityAndS);
        // Get v; by any means necessary (we check consistency below)
        const { networkV, v } = function(_v, yParityAndS, yParity) {
            if (_v != null) {
                const v = (0, index_js_2.getBigInt)(_v);
                return {
                    networkV: v >= BN_35 ? v : undefined,
                    v: Signature.getNormalizedV(v)
                };
            }
            if (yParityAndS != null) {
                assertError((0, index_js_2.isHexString)(yParityAndS, 32), "invalid yParityAndS");
                return {
                    v: (0, index_js_2.getBytes)(yParityAndS)[0] & 0x80 ? 28 : 27
                };
            }
            if (yParity != null) {
                switch((0, index_js_2.getNumber)(yParity, "sig.yParity")){
                    case 0:
                        return {
                            v: 27
                        };
                    case 1:
                        return {
                            v: 28
                        };
                }
                assertError(false, "invalid yParity");
            }
            assertError(false, "missing v");
        }(sig.v, sig.yParityAndS, sig.yParity);
        const result = new Signature(_guard, r, s, v);
        if (networkV) {
            _class_private_field_set._(result, _networkV, networkV);
        }
        // If multiple of v, yParity, yParityAndS we given, check they match
        assertError(sig.yParity == null || (0, index_js_2.getNumber)(sig.yParity, "sig.yParity") === result.yParity, "yParity mismatch");
        assertError(sig.yParityAndS == null || sig.yParityAndS === result.yParityAndS, "yParityAndS mismatch");
        return result;
    }
    /**
     *  @private
     */ constructor(guard, r, s, v){
        _class_private_field_init._(this, _r, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _s, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _v, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _networkV, {
            writable: true,
            value: void 0
        });
        (0, index_js_2.assertPrivate)(guard, _guard, "Signature");
        _class_private_field_set._(this, _r, r);
        _class_private_field_set._(this, _s, s);
        _class_private_field_set._(this, _v, v);
        _class_private_field_set._(this, _networkV, null);
    }
}
exports.Signature = Signature; //# sourceMappingURL=signature.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/signing-key.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
/**
 *  Add details about signing here.
 *
 *  @_subsection: api/crypto:Signing  [about-signing]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SigningKey = void 0;
const secp256k1_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@noble+curves@1.2.0/node_modules/@noble/curves/secp256k1.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/signature.js [app-client] (ecmascript)");
var _privateKey = /*#__PURE__*/ new WeakMap();
/**
 *  A **SigningKey** provides high-level access to the elliptic curve
 *  cryptography (ECC) operations and key management.
 */ class SigningKey {
    /**
     *  The private key.
     */ get privateKey() {
        return _class_private_field_get._(this, _privateKey);
    }
    /**
     *  The uncompressed public key.
     *
     * This will always begin with the prefix ``0x04`` and be 132
     * characters long (the ``0x`` prefix and 130 hexadecimal nibbles).
     */ get publicKey() {
        return SigningKey.computePublicKey(_class_private_field_get._(this, _privateKey));
    }
    /**
     *  The compressed public key.
     *
     *  This will always begin with either the prefix ``0x02`` or ``0x03``
     *  and be 68 characters long (the ``0x`` prefix and 33 hexadecimal
     *  nibbles)
     */ get compressedPublicKey() {
        return SigningKey.computePublicKey(_class_private_field_get._(this, _privateKey), true);
    }
    /**
     *  Return the signature of the signed %%digest%%.
     */ sign(digest) {
        (0, index_js_1.assertArgument)((0, index_js_1.dataLength)(digest) === 32, "invalid digest length", "digest", digest);
        const sig = secp256k1_1.secp256k1.sign((0, index_js_1.getBytesCopy)(digest), (0, index_js_1.getBytesCopy)(_class_private_field_get._(this, _privateKey)), {
            lowS: true
        });
        return signature_js_1.Signature.from({
            r: (0, index_js_1.toBeHex)(sig.r, 32),
            s: (0, index_js_1.toBeHex)(sig.s, 32),
            v: sig.recovery ? 0x1c : 0x1b
        });
    }
    /**
     *  Returns the [[link-wiki-ecdh]] shared secret between this
     *  private key and the %%other%% key.
     *
     *  The %%other%% key may be any type of key, a raw public key,
     *  a compressed/uncompressed pubic key or aprivate key.
     *
     *  Best practice is usually to use a cryptographic hash on the
     *  returned value before using it as a symetric secret.
     *
     *  @example:
     *    sign1 = new SigningKey(id("some-secret-1"))
     *    sign2 = new SigningKey(id("some-secret-2"))
     *
     *    // Notice that privA.computeSharedSecret(pubB)...
     *    sign1.computeSharedSecret(sign2.publicKey)
     *    //_result:
     *
     *    // ...is equal to privB.computeSharedSecret(pubA).
     *    sign2.computeSharedSecret(sign1.publicKey)
     *    //_result:
     */ computeSharedSecret(other) {
        const pubKey = SigningKey.computePublicKey(other);
        return (0, index_js_1.hexlify)(secp256k1_1.secp256k1.getSharedSecret((0, index_js_1.getBytesCopy)(_class_private_field_get._(this, _privateKey)), (0, index_js_1.getBytes)(pubKey), false));
    }
    /**
     *  Compute the public key for %%key%%, optionally %%compressed%%.
     *
     *  The %%key%% may be any type of key, a raw public key, a
     *  compressed/uncompressed public key or private key.
     *
     *  @example:
     *    sign = new SigningKey(id("some-secret"));
     *
     *    // Compute the uncompressed public key for a private key
     *    SigningKey.computePublicKey(sign.privateKey)
     *    //_result:
     *
     *    // Compute the compressed public key for a private key
     *    SigningKey.computePublicKey(sign.privateKey, true)
     *    //_result:
     *
     *    // Compute the uncompressed public key
     *    SigningKey.computePublicKey(sign.publicKey, false);
     *    //_result:
     *
     *    // Compute the Compressed a public key
     *    SigningKey.computePublicKey(sign.publicKey, true);
     *    //_result:
     */ static computePublicKey(key, compressed) {
        let bytes = (0, index_js_1.getBytes)(key, "key");
        // private key
        if (bytes.length === 32) {
            const pubKey = secp256k1_1.secp256k1.getPublicKey(bytes, !!compressed);
            return (0, index_js_1.hexlify)(pubKey);
        }
        // raw public key; use uncompressed key with 0x04 prefix
        if (bytes.length === 64) {
            const pub = new Uint8Array(65);
            pub[0] = 0x04;
            pub.set(bytes, 1);
            bytes = pub;
        }
        const point = secp256k1_1.secp256k1.ProjectivePoint.fromHex(bytes);
        return (0, index_js_1.hexlify)(point.toRawBytes(compressed));
    }
    /**
     *  Returns the public key for the private key which produced the
     *  %%signature%% for the given %%digest%%.
     *
     *  @example:
     *    key = new SigningKey(id("some-secret"))
     *    digest = id("hello world")
     *    sig = key.sign(digest)
     *
     *    // Notice the signer public key...
     *    key.publicKey
     *    //_result:
     *
     *    // ...is equal to the recovered public key
     *    SigningKey.recoverPublicKey(digest, sig)
     *    //_result:
     *
     */ static recoverPublicKey(digest, signature) {
        (0, index_js_1.assertArgument)((0, index_js_1.dataLength)(digest) === 32, "invalid digest length", "digest", digest);
        const sig = signature_js_1.Signature.from(signature);
        let secpSig = secp256k1_1.secp256k1.Signature.fromCompact((0, index_js_1.getBytesCopy)((0, index_js_1.concat)([
            sig.r,
            sig.s
        ])));
        secpSig = secpSig.addRecoveryBit(sig.yParity);
        const pubKey = secpSig.recoverPublicKey((0, index_js_1.getBytesCopy)(digest));
        (0, index_js_1.assertArgument)(pubKey != null, "invalid signature for digest", "signature", signature);
        return "0x" + pubKey.toHex(false);
    }
    /**
     *  Returns the point resulting from adding the ellipic curve points
     *  %%p0%% and %%p1%%.
     *
     *  This is not a common function most developers should require, but
     *  can be useful for certain privacy-specific techniques.
     *
     *  For example, it is used by [[HDNodeWallet]] to compute child
     *  addresses from parent public keys and chain codes.
     */ static addPoints(p0, p1, compressed) {
        const pub0 = secp256k1_1.secp256k1.ProjectivePoint.fromHex(SigningKey.computePublicKey(p0).substring(2));
        const pub1 = secp256k1_1.secp256k1.ProjectivePoint.fromHex(SigningKey.computePublicKey(p1).substring(2));
        return "0x" + pub0.add(pub1).toHex(!!compressed);
    }
    /**
     *  Creates a new **SigningKey** for %%privateKey%%.
     */ constructor(privateKey){
        _class_private_field_init._(this, _privateKey, {
            writable: true,
            value: void 0
        });
        (0, index_js_1.assertArgument)((0, index_js_1.dataLength)(privateKey) === 32, "invalid private key", "privateKey", "[REDACTED]");
        _class_private_field_set._(this, _privateKey, (0, index_js_1.hexlify)(privateKey));
    }
}
exports.SigningKey = SigningKey; //# sourceMappingURL=signing-key.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  A fundamental building block of Ethereum is the underlying
 *  cryptographic primitives.
 *
 *  @_section: api/crypto:Cryptographic Functions   [about-crypto]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.lock = exports.Signature = exports.SigningKey = exports.scryptSync = exports.scrypt = exports.pbkdf2 = exports.sha512 = exports.sha256 = exports.ripemd160 = exports.keccak256 = exports.randomBytes = exports.computeHmac = void 0;
null;
// We import all these so we can export lock()
const hmac_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/hmac.js [app-client] (ecmascript)");
Object.defineProperty(exports, "computeHmac", {
    enumerable: true,
    get: function() {
        return hmac_js_1.computeHmac;
    }
});
const keccak_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/keccak.js [app-client] (ecmascript)");
Object.defineProperty(exports, "keccak256", {
    enumerable: true,
    get: function() {
        return keccak_js_1.keccak256;
    }
});
const ripemd160_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/ripemd160.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ripemd160", {
    enumerable: true,
    get: function() {
        return ripemd160_js_1.ripemd160;
    }
});
const pbkdf2_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/pbkdf2.js [app-client] (ecmascript)");
Object.defineProperty(exports, "pbkdf2", {
    enumerable: true,
    get: function() {
        return pbkdf2_js_1.pbkdf2;
    }
});
const random_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/random.js [app-client] (ecmascript)");
Object.defineProperty(exports, "randomBytes", {
    enumerable: true,
    get: function() {
        return random_js_1.randomBytes;
    }
});
const scrypt_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/scrypt.js [app-client] (ecmascript)");
Object.defineProperty(exports, "scrypt", {
    enumerable: true,
    get: function() {
        return scrypt_js_1.scrypt;
    }
});
Object.defineProperty(exports, "scryptSync", {
    enumerable: true,
    get: function() {
        return scrypt_js_1.scryptSync;
    }
});
const sha2_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/sha2.js [app-client] (ecmascript)");
Object.defineProperty(exports, "sha256", {
    enumerable: true,
    get: function() {
        return sha2_js_1.sha256;
    }
});
Object.defineProperty(exports, "sha512", {
    enumerable: true,
    get: function() {
        return sha2_js_1.sha512;
    }
});
var signing_key_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/signing-key.js [app-client] (ecmascript)");
Object.defineProperty(exports, "SigningKey", {
    enumerable: true,
    get: function() {
        return signing_key_js_1.SigningKey;
    }
});
var signature_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/signature.js [app-client] (ecmascript)");
Object.defineProperty(exports, "Signature", {
    enumerable: true,
    get: function() {
        return signature_js_1.Signature;
    }
});
/**
 *  Once called, prevents any future change to the underlying cryptographic
 *  primitives using the ``.register`` feature for hooks.
 */ function lock() {
    hmac_js_1.computeHmac.lock();
    keccak_js_1.keccak256.lock();
    pbkdf2_js_1.pbkdf2.lock();
    random_js_1.randomBytes.lock();
    ripemd160_js_1.ripemd160.lock();
    scrypt_js_1.scrypt.lock();
    scrypt_js_1.scryptSync.lock();
    sha2_js_1.sha256.lock();
    sha2_js_1.sha512.lock();
    random_js_1.randomBytes.lock();
}
exports.lock = lock; //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/address.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getIcapAddress = exports.getAddress = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
const BN_36 = BigInt(36);
function getChecksumAddress(address) {
    //    if (!isHexString(address, 20)) {
    //        logger.throwArgumentError("invalid address", "address", address);
    //    }
    address = address.toLowerCase();
    const chars = address.substring(2).split("");
    const expanded = new Uint8Array(40);
    for(let i = 0; i < 40; i++){
        expanded[i] = chars[i].charCodeAt(0);
    }
    const hashed = (0, index_js_2.getBytes)((0, index_js_1.keccak256)(expanded));
    for(let i = 0; i < 40; i += 2){
        if (hashed[i >> 1] >> 4 >= 8) {
            chars[i] = chars[i].toUpperCase();
        }
        if ((hashed[i >> 1] & 0x0f) >= 8) {
            chars[i + 1] = chars[i + 1].toUpperCase();
        }
    }
    return "0x" + chars.join("");
}
// See: https://en.wikipedia.org/wiki/International_Bank_Account_Number
// Create lookup table
const ibanLookup = {};
for(let i = 0; i < 10; i++){
    ibanLookup[String(i)] = String(i);
}
for(let i = 0; i < 26; i++){
    ibanLookup[String.fromCharCode(65 + i)] = String(10 + i);
}
// How many decimal digits can we process? (for 64-bit float, this is 15)
// i.e. Math.floor(Math.log10(Number.MAX_SAFE_INTEGER));
const safeDigits = 15;
function ibanChecksum(address) {
    address = address.toUpperCase();
    address = address.substring(4) + address.substring(0, 2) + "00";
    let expanded = address.split("").map((c)=>{
        return ibanLookup[c];
    }).join("");
    // Javascript can handle integers safely up to 15 (decimal) digits
    while(expanded.length >= safeDigits){
        let block = expanded.substring(0, safeDigits);
        expanded = parseInt(block, 10) % 97 + expanded.substring(block.length);
    }
    let checksum = String(98 - parseInt(expanded, 10) % 97);
    while(checksum.length < 2){
        checksum = "0" + checksum;
    }
    return checksum;
}
;
const Base36 = function() {
    ;
    const result = {};
    for(let i = 0; i < 36; i++){
        const key = "0123456789abcdefghijklmnopqrstuvwxyz"[i];
        result[key] = BigInt(i);
    }
    return result;
}();
function fromBase36(value) {
    value = value.toLowerCase();
    let result = BN_0;
    for(let i = 0; i < value.length; i++){
        result = result * BN_36 + Base36[value[i]];
    }
    return result;
}
/**
 *  Returns a normalized and checksumed address for %%address%%.
 *  This accepts non-checksum addresses, checksum addresses and
 *  [[getIcapAddress]] formats.
 *
 *  The checksum in Ethereum uses the capitalization (upper-case
 *  vs lower-case) of the characters within an address to encode
 *  its checksum, which offers, on average, a checksum of 15-bits.
 *
 *  If %%address%% contains both upper-case and lower-case, it is
 *  assumed to already be a checksum address and its checksum is
 *  validated, and if the address fails its expected checksum an
 *  error is thrown.
 *
 *  If you wish the checksum of %%address%% to be ignore, it should
 *  be converted to lower-case (i.e. ``.toLowercase()``) before
 *  being passed in. This should be a very rare situation though,
 *  that you wish to bypass the safegaurds in place to protect
 *  against an address that has been incorrectly copied from another
 *  source.
 *
 *  @example:
 *    // Adds the checksum (via upper-casing specific letters)
 *    getAddress("0x8ba1f109551bd432803012645ac136ddd64dba72")
 *    //_result:
 *
 *    // Converts ICAP address and adds checksum
 *    getAddress("XE65GB6LDNXYOFTX0NSV3FUWKOWIXAMJK36");
 *    //_result:
 *
 *    // Throws an error if an address contains mixed case,
 *    // but the checksum fails
 *    getAddress("0x8Ba1f109551bD432803012645Ac136ddd64DBA72")
 *    //_error:
 */ function getAddress(address) {
    (0, index_js_2.assertArgument)(typeof address === "string", "invalid address", "address", address);
    if (address.match(/^(0x)?[0-9a-fA-F]{40}$/)) {
        // Missing the 0x prefix
        if (!address.startsWith("0x")) {
            address = "0x" + address;
        }
        const result = getChecksumAddress(address);
        // It is a checksummed address with a bad checksum
        (0, index_js_2.assertArgument)(!address.match(/([A-F].*[a-f])|([a-f].*[A-F])/) || result === address, "bad address checksum", "address", address);
        return result;
    }
    // Maybe ICAP? (we only support direct mode)
    if (address.match(/^XE[0-9]{2}[0-9A-Za-z]{30,31}$/)) {
        // It is an ICAP address with a bad checksum
        (0, index_js_2.assertArgument)(address.substring(2, 4) === ibanChecksum(address), "bad icap checksum", "address", address);
        let result = fromBase36(address.substring(4)).toString(16);
        while(result.length < 40){
            result = "0" + result;
        }
        return getChecksumAddress("0x" + result);
    }
    (0, index_js_2.assertArgument)(false, "invalid address", "address", address);
}
exports.getAddress = getAddress;
/**
 *  The [ICAP Address format](link-icap) format is an early checksum
 *  format which attempts to be compatible with the banking
 *  industry [IBAN format](link-wiki-iban) for bank accounts.
 *
 *  It is no longer common or a recommended format.
 *
 *  @example:
 *    getIcapAddress("0x8ba1f109551bd432803012645ac136ddd64dba72");
 *    //_result:
 *
 *    getIcapAddress("XE65GB6LDNXYOFTX0NSV3FUWKOWIXAMJK36");
 *    //_result:
 *
 *    // Throws an error if the ICAP checksum is wrong
 *    getIcapAddress("XE65GB6LDNXYOFTX0NSV3FUWKOWIXAMJK37");
 *    //_error:
 */ function getIcapAddress(address) {
    //let base36 = _base16To36(getAddress(address).substring(2)).toUpperCase();
    let base36 = BigInt(getAddress(address)).toString(36).toUpperCase();
    while(base36.length < 30){
        base36 = "0" + base36;
    }
    return "XE" + ibanChecksum("XE00" + base36) + base36;
}
exports.getIcapAddress = getIcapAddress; //# sourceMappingURL=address.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/contract-address.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getCreate2Address = exports.getCreateAddress = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/address.js [app-client] (ecmascript)");
// http://ethereum.stackexchange.com/questions/760/how-is-the-address-of-an-ethereum-contract-computed
/**
 *  Returns the address that would result from a ``CREATE`` for %%tx%%.
 *
 *  This can be used to compute the address a contract will be
 *  deployed to by an EOA when sending a deployment transaction (i.e.
 *  when the ``to`` address is ``null``).
 *
 *  This can also be used to compute the address a contract will be
 *  deployed to by a contract, by using the contract's address as the
 *  ``to`` and the contract's nonce.
 *
 *  @example
 *    from = "0x8ba1f109551bD432803012645Ac136ddd64DBA72";
 *    nonce = 5;
 *
 *    getCreateAddress({ from, nonce });
 *    //_result:
 */ function getCreateAddress(tx) {
    const from = (0, address_js_1.getAddress)(tx.from);
    const nonce = (0, index_js_2.getBigInt)(tx.nonce, "tx.nonce");
    let nonceHex = nonce.toString(16);
    if (nonceHex === "0") {
        nonceHex = "0x";
    } else if (nonceHex.length % 2) {
        nonceHex = "0x0" + nonceHex;
    } else {
        nonceHex = "0x" + nonceHex;
    }
    return (0, address_js_1.getAddress)((0, index_js_2.dataSlice)((0, index_js_1.keccak256)((0, index_js_2.encodeRlp)([
        from,
        nonceHex
    ])), 12));
}
exports.getCreateAddress = getCreateAddress;
/**
 *  Returns the address that would result from a ``CREATE2`` operation
 *  with the given %%from%%, %%salt%% and %%initCodeHash%%.
 *
 *  To compute the %%initCodeHash%% from a contract's init code, use
 *  the [[keccak256]] function.
 *
 *  For a quick overview and example of ``CREATE2``, see [[link-ricmoo-wisps]].
 *
 *  @example
 *    // The address of the contract
 *    from = "0x8ba1f109551bD432803012645Ac136ddd64DBA72"
 *
 *    // The salt
 *    salt = id("HelloWorld")
 *
 *    // The hash of the initCode
 *    initCode = "0x6394198df16000526103ff60206004601c335afa6040516060f3";
 *    initCodeHash = keccak256(initCode)
 *
 *    getCreate2Address(from, salt, initCodeHash)
 *    //_result:
 */ function getCreate2Address(_from, _salt, _initCodeHash) {
    const from = (0, address_js_1.getAddress)(_from);
    const salt = (0, index_js_2.getBytes)(_salt, "salt");
    const initCodeHash = (0, index_js_2.getBytes)(_initCodeHash, "initCodeHash");
    (0, index_js_2.assertArgument)(salt.length === 32, "salt must be 32 bytes", "salt", _salt);
    (0, index_js_2.assertArgument)(initCodeHash.length === 32, "initCodeHash must be 32 bytes", "initCodeHash", _initCodeHash);
    return (0, address_js_1.getAddress)((0, index_js_2.dataSlice)((0, index_js_1.keccak256)((0, index_js_2.concat)([
        "0xff",
        from,
        salt,
        initCodeHash
    ])), 12));
}
exports.getCreate2Address = getCreate2Address; //# sourceMappingURL=contract-address.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/checks.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.resolveAddress = exports.isAddress = exports.isAddressable = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/address.js [app-client] (ecmascript)");
/**
 *  Returns true if %%value%% is an object which implements the
 *  [[Addressable]] interface.
 *
 *  @example:
 *    // Wallets and AbstractSigner sub-classes
 *    isAddressable(Wallet.createRandom())
 *    //_result:
 *
 *    // Contracts
 *    contract = new Contract("dai.tokens.ethers.eth", [ ], provider)
 *    isAddressable(contract)
 *    //_result:
 */ function isAddressable(value) {
    return value && typeof value.getAddress === "function";
}
exports.isAddressable = isAddressable;
/**
 *  Returns true if %%value%% is a valid address.
 *
 *  @example:
 *    // Valid address
 *    isAddress("0x8ba1f109551bD432803012645Ac136ddd64DBA72")
 *    //_result:
 *
 *    // Valid ICAP address
 *    isAddress("XE65GB6LDNXYOFTX0NSV3FUWKOWIXAMJK36")
 *    //_result:
 *
 *    // Invalid checksum
 *    isAddress("0x8Ba1f109551bD432803012645Ac136ddd64DBa72")
 *    //_result:
 *
 *    // Invalid ICAP checksum
 *    isAddress("0x8Ba1f109551bD432803012645Ac136ddd64DBA72")
 *    //_result:
 *
 *    // Not an address (an ENS name requires a provided and an
 *    // asynchronous API to access)
 *    isAddress("ricmoo.eth")
 *    //_result:
 */ function isAddress(value) {
    try {
        (0, address_js_1.getAddress)(value);
        return true;
    } catch (error) {}
    return false;
}
exports.isAddress = isAddress;
async function checkAddress(target, promise) {
    const result = await promise;
    if (result == null || result === "0x0000000000000000000000000000000000000000") {
        (0, index_js_1.assert)(typeof target !== "string", "unconfigured name", "UNCONFIGURED_NAME", {
            value: target
        });
        (0, index_js_1.assertArgument)(false, "invalid AddressLike value; did not resolve to a value address", "target", target);
    }
    return (0, address_js_1.getAddress)(result);
}
/**
 *  Resolves to an address for the %%target%%, which may be any
 *  supported address type, an [[Addressable]] or a Promise which
 *  resolves to an address.
 *
 *  If an ENS name is provided, but that name has not been correctly
 *  configured a [[UnconfiguredNameError]] is thrown.
 *
 *  @example:
 *    addr = "0x6B175474E89094C44Da98b954EedeAC495271d0F"
 *
 *    // Addresses are return synchronously
 *    resolveAddress(addr, provider)
 *    //_result:
 *
 *    // Address promises are resolved asynchronously
 *    resolveAddress(Promise.resolve(addr))
 *    //_result:
 *
 *    // ENS names are resolved asynchronously
 *    resolveAddress("dai.tokens.ethers.eth", provider)
 *    //_result:
 *
 *    // Addressable objects are resolved asynchronously
 *    contract = new Contract(addr, [ ])
 *    resolveAddress(contract, provider)
 *    //_result:
 *
 *    // Unconfigured ENS names reject
 *    resolveAddress("nothing-here.ricmoo.eth", provider)
 *    //_error:
 *
 *    // ENS names require a NameResolver object passed in
 *    // (notice the provider was omitted)
 *    resolveAddress("nothing-here.ricmoo.eth")
 *    //_error:
 */ function resolveAddress(target, resolver) {
    if (typeof target === "string") {
        if (target.match(/^0x[0-9a-f]{40}$/i)) {
            return (0, address_js_1.getAddress)(target);
        }
        (0, index_js_1.assert)(resolver != null, "ENS resolution requires a provider", "UNSUPPORTED_OPERATION", {
            operation: "resolveName"
        });
        return checkAddress(target, resolver.resolveName(target));
    } else if (isAddressable(target)) {
        return checkAddress(target, target.getAddress());
    } else if (target && typeof target.then === "function") {
        return checkAddress(target, target);
    }
    (0, index_js_1.assertArgument)(false, "unsupported addressable value", "target", target);
}
exports.resolveAddress = resolveAddress; //# sourceMappingURL=checks.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  Addresses are a fundamental part of interacting with Ethereum. They
 *  represent the global identity of Externally Owned Accounts (accounts
 *  backed by a private key) and contracts.
 *
 *  The Ethereum Naming Service (ENS) provides an interconnected ecosystem
 *  of contracts, standards and libraries which enable looking up an
 *  address for an ENS name.
 *
 *  These functions help convert between various formats, validate
 *  addresses and safely resolve ENS names.
 *
 *  @_section: api/address:Addresses  [about-addresses]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.resolveAddress = exports.isAddress = exports.isAddressable = exports.getCreate2Address = exports.getCreateAddress = exports.getIcapAddress = exports.getAddress = void 0;
null;
var address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/address.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getAddress", {
    enumerable: true,
    get: function() {
        return address_js_1.getAddress;
    }
});
Object.defineProperty(exports, "getIcapAddress", {
    enumerable: true,
    get: function() {
        return address_js_1.getIcapAddress;
    }
});
var contract_address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/contract-address.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getCreateAddress", {
    enumerable: true,
    get: function() {
        return contract_address_js_1.getCreateAddress;
    }
});
Object.defineProperty(exports, "getCreate2Address", {
    enumerable: true,
    get: function() {
        return contract_address_js_1.getCreate2Address;
    }
});
var checks_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/checks.js [app-client] (ecmascript)");
Object.defineProperty(exports, "isAddressable", {
    enumerable: true,
    get: function() {
        return checks_js_1.isAddressable;
    }
});
Object.defineProperty(exports, "isAddress", {
    enumerable: true,
    get: function() {
        return checks_js_1.isAddress;
    }
});
Object.defineProperty(exports, "resolveAddress", {
    enumerable: true,
    get: function() {
        return checks_js_1.resolveAddress;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  A Typed object allows a value to have its type explicitly
 *  specified.
 *
 *  For example, in Solidity, the value ``45`` could represent a
 *  ``uint8`` or a ``uint256``. The value ``0x1234`` could represent
 *  a ``bytes2`` or ``bytes``.
 *
 *  Since JavaScript has no meaningful way to explicitly inform any
 *  APIs which what the type is, this allows transparent interoperation
 *  with Soldity.
 *
 *  @_subsection: api/abi:Typed Values
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Typed = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const _gaurd = {};
function n(value, width) {
    let signed = false;
    if (width < 0) {
        signed = true;
        width *= -1;
    }
    // @TODO: Check range is valid for value
    return new Typed(_gaurd, "".concat(signed ? "" : "u", "int").concat(width), value, {
        signed,
        width
    });
}
function b(value, size) {
    // @TODO: Check range is valid for value
    return new Typed(_gaurd, "bytes".concat(size ? size : ""), value, {
        size
    });
}
const _typedSymbol = Symbol.for("_ethers_typed");
var _options = /*#__PURE__*/ new WeakMap();
/**
 *  The **Typed** class to wrap values providing explicit type information.
 */ class Typed {
    /**
     *  Format the type as a Human-Readable type.
     */ format() {
        if (this.type === "array") {
            throw new Error("");
        } else if (this.type === "dynamicArray") {
            throw new Error("");
        } else if (this.type === "tuple") {
            return "tuple(".concat(this.value.map((v)=>v.format()).join(","), ")");
        }
        return this.type;
    }
    /**
     *  The default value returned by this type.
     */ defaultValue() {
        return 0;
    }
    /**
     *  The minimum value for numeric types.
     */ minValue() {
        return 0;
    }
    /**
     *  The maximum value for numeric types.
     */ maxValue() {
        return 0;
    }
    /**
     *  Returns ``true`` and provides a type guard is this is a [[TypedBigInt]].
     */ isBigInt() {
        return !!this.type.match(/^u?int[0-9]+$/);
    }
    /**
     *  Returns ``true`` and provides a type guard is this is a [[TypedData]].
     */ isData() {
        return this.type.startsWith("bytes");
    }
    /**
     *  Returns ``true`` and provides a type guard is this is a [[TypedString]].
     */ isString() {
        return this.type === "string";
    }
    /**
     *  Returns the tuple name, if this is a tuple. Throws otherwise.
     */ get tupleName() {
        if (this.type !== "tuple") {
            throw TypeError("not a tuple");
        }
        return _class_private_field_get._(this, _options);
    }
    // Returns the length of this type as an array
    // - `null` indicates the length is unforced, it could be dynamic
    // - `-1` indicates the length is dynamic
    // - any other value indicates it is a static array and is its length
    /**
     *  Returns the length of the array type or ``-1`` if it is dynamic.
     *
     *  Throws if the type is not an array.
     */ get arrayLength() {
        if (this.type !== "array") {
            throw TypeError("not an array");
        }
        if (_class_private_field_get._(this, _options) === true) {
            return -1;
        }
        if (_class_private_field_get._(this, _options) === false) {
            return this.value.length;
        }
        return null;
    }
    /**
     *  Returns a new **Typed** of %%type%% with the %%value%%.
     */ static from(type, value) {
        return new Typed(_gaurd, type, value);
    }
    /**
     *  Return a new ``uint8`` type for %%v%%.
     */ static uint8(v) {
        return n(v, 8);
    }
    /**
     *  Return a new ``uint16`` type for %%v%%.
     */ static uint16(v) {
        return n(v, 16);
    }
    /**
     *  Return a new ``uint24`` type for %%v%%.
     */ static uint24(v) {
        return n(v, 24);
    }
    /**
     *  Return a new ``uint32`` type for %%v%%.
     */ static uint32(v) {
        return n(v, 32);
    }
    /**
     *  Return a new ``uint40`` type for %%v%%.
     */ static uint40(v) {
        return n(v, 40);
    }
    /**
     *  Return a new ``uint48`` type for %%v%%.
     */ static uint48(v) {
        return n(v, 48);
    }
    /**
     *  Return a new ``uint56`` type for %%v%%.
     */ static uint56(v) {
        return n(v, 56);
    }
    /**
     *  Return a new ``uint64`` type for %%v%%.
     */ static uint64(v) {
        return n(v, 64);
    }
    /**
     *  Return a new ``uint72`` type for %%v%%.
     */ static uint72(v) {
        return n(v, 72);
    }
    /**
     *  Return a new ``uint80`` type for %%v%%.
     */ static uint80(v) {
        return n(v, 80);
    }
    /**
     *  Return a new ``uint88`` type for %%v%%.
     */ static uint88(v) {
        return n(v, 88);
    }
    /**
     *  Return a new ``uint96`` type for %%v%%.
     */ static uint96(v) {
        return n(v, 96);
    }
    /**
     *  Return a new ``uint104`` type for %%v%%.
     */ static uint104(v) {
        return n(v, 104);
    }
    /**
     *  Return a new ``uint112`` type for %%v%%.
     */ static uint112(v) {
        return n(v, 112);
    }
    /**
     *  Return a new ``uint120`` type for %%v%%.
     */ static uint120(v) {
        return n(v, 120);
    }
    /**
     *  Return a new ``uint128`` type for %%v%%.
     */ static uint128(v) {
        return n(v, 128);
    }
    /**
     *  Return a new ``uint136`` type for %%v%%.
     */ static uint136(v) {
        return n(v, 136);
    }
    /**
     *  Return a new ``uint144`` type for %%v%%.
     */ static uint144(v) {
        return n(v, 144);
    }
    /**
     *  Return a new ``uint152`` type for %%v%%.
     */ static uint152(v) {
        return n(v, 152);
    }
    /**
     *  Return a new ``uint160`` type for %%v%%.
     */ static uint160(v) {
        return n(v, 160);
    }
    /**
     *  Return a new ``uint168`` type for %%v%%.
     */ static uint168(v) {
        return n(v, 168);
    }
    /**
     *  Return a new ``uint176`` type for %%v%%.
     */ static uint176(v) {
        return n(v, 176);
    }
    /**
     *  Return a new ``uint184`` type for %%v%%.
     */ static uint184(v) {
        return n(v, 184);
    }
    /**
     *  Return a new ``uint192`` type for %%v%%.
     */ static uint192(v) {
        return n(v, 192);
    }
    /**
     *  Return a new ``uint200`` type for %%v%%.
     */ static uint200(v) {
        return n(v, 200);
    }
    /**
     *  Return a new ``uint208`` type for %%v%%.
     */ static uint208(v) {
        return n(v, 208);
    }
    /**
     *  Return a new ``uint216`` type for %%v%%.
     */ static uint216(v) {
        return n(v, 216);
    }
    /**
     *  Return a new ``uint224`` type for %%v%%.
     */ static uint224(v) {
        return n(v, 224);
    }
    /**
     *  Return a new ``uint232`` type for %%v%%.
     */ static uint232(v) {
        return n(v, 232);
    }
    /**
     *  Return a new ``uint240`` type for %%v%%.
     */ static uint240(v) {
        return n(v, 240);
    }
    /**
     *  Return a new ``uint248`` type for %%v%%.
     */ static uint248(v) {
        return n(v, 248);
    }
    /**
     *  Return a new ``uint256`` type for %%v%%.
     */ static uint256(v) {
        return n(v, 256);
    }
    /**
     *  Return a new ``uint256`` type for %%v%%.
     */ static uint(v) {
        return n(v, 256);
    }
    /**
     *  Return a new ``int8`` type for %%v%%.
     */ static int8(v) {
        return n(v, -8);
    }
    /**
     *  Return a new ``int16`` type for %%v%%.
     */ static int16(v) {
        return n(v, -16);
    }
    /**
     *  Return a new ``int24`` type for %%v%%.
     */ static int24(v) {
        return n(v, -24);
    }
    /**
     *  Return a new ``int32`` type for %%v%%.
     */ static int32(v) {
        return n(v, -32);
    }
    /**
     *  Return a new ``int40`` type for %%v%%.
     */ static int40(v) {
        return n(v, -40);
    }
    /**
     *  Return a new ``int48`` type for %%v%%.
     */ static int48(v) {
        return n(v, -48);
    }
    /**
     *  Return a new ``int56`` type for %%v%%.
     */ static int56(v) {
        return n(v, -56);
    }
    /**
     *  Return a new ``int64`` type for %%v%%.
     */ static int64(v) {
        return n(v, -64);
    }
    /**
     *  Return a new ``int72`` type for %%v%%.
     */ static int72(v) {
        return n(v, -72);
    }
    /**
     *  Return a new ``int80`` type for %%v%%.
     */ static int80(v) {
        return n(v, -80);
    }
    /**
     *  Return a new ``int88`` type for %%v%%.
     */ static int88(v) {
        return n(v, -88);
    }
    /**
     *  Return a new ``int96`` type for %%v%%.
     */ static int96(v) {
        return n(v, -96);
    }
    /**
     *  Return a new ``int104`` type for %%v%%.
     */ static int104(v) {
        return n(v, -104);
    }
    /**
     *  Return a new ``int112`` type for %%v%%.
     */ static int112(v) {
        return n(v, -112);
    }
    /**
     *  Return a new ``int120`` type for %%v%%.
     */ static int120(v) {
        return n(v, -120);
    }
    /**
     *  Return a new ``int128`` type for %%v%%.
     */ static int128(v) {
        return n(v, -128);
    }
    /**
     *  Return a new ``int136`` type for %%v%%.
     */ static int136(v) {
        return n(v, -136);
    }
    /**
     *  Return a new ``int144`` type for %%v%%.
     */ static int144(v) {
        return n(v, -144);
    }
    /**
     *  Return a new ``int52`` type for %%v%%.
     */ static int152(v) {
        return n(v, -152);
    }
    /**
     *  Return a new ``int160`` type for %%v%%.
     */ static int160(v) {
        return n(v, -160);
    }
    /**
     *  Return a new ``int168`` type for %%v%%.
     */ static int168(v) {
        return n(v, -168);
    }
    /**
     *  Return a new ``int176`` type for %%v%%.
     */ static int176(v) {
        return n(v, -176);
    }
    /**
     *  Return a new ``int184`` type for %%v%%.
     */ static int184(v) {
        return n(v, -184);
    }
    /**
     *  Return a new ``int92`` type for %%v%%.
     */ static int192(v) {
        return n(v, -192);
    }
    /**
     *  Return a new ``int200`` type for %%v%%.
     */ static int200(v) {
        return n(v, -200);
    }
    /**
     *  Return a new ``int208`` type for %%v%%.
     */ static int208(v) {
        return n(v, -208);
    }
    /**
     *  Return a new ``int216`` type for %%v%%.
     */ static int216(v) {
        return n(v, -216);
    }
    /**
     *  Return a new ``int224`` type for %%v%%.
     */ static int224(v) {
        return n(v, -224);
    }
    /**
     *  Return a new ``int232`` type for %%v%%.
     */ static int232(v) {
        return n(v, -232);
    }
    /**
     *  Return a new ``int240`` type for %%v%%.
     */ static int240(v) {
        return n(v, -240);
    }
    /**
     *  Return a new ``int248`` type for %%v%%.
     */ static int248(v) {
        return n(v, -248);
    }
    /**
     *  Return a new ``int256`` type for %%v%%.
     */ static int256(v) {
        return n(v, -256);
    }
    /**
     *  Return a new ``int256`` type for %%v%%.
     */ static int(v) {
        return n(v, -256);
    }
    /**
     *  Return a new ``bytes1`` type for %%v%%.
     */ static bytes1(v) {
        return b(v, 1);
    }
    /**
     *  Return a new ``bytes2`` type for %%v%%.
     */ static bytes2(v) {
        return b(v, 2);
    }
    /**
     *  Return a new ``bytes3`` type for %%v%%.
     */ static bytes3(v) {
        return b(v, 3);
    }
    /**
     *  Return a new ``bytes4`` type for %%v%%.
     */ static bytes4(v) {
        return b(v, 4);
    }
    /**
     *  Return a new ``bytes5`` type for %%v%%.
     */ static bytes5(v) {
        return b(v, 5);
    }
    /**
     *  Return a new ``bytes6`` type for %%v%%.
     */ static bytes6(v) {
        return b(v, 6);
    }
    /**
     *  Return a new ``bytes7`` type for %%v%%.
     */ static bytes7(v) {
        return b(v, 7);
    }
    /**
     *  Return a new ``bytes8`` type for %%v%%.
     */ static bytes8(v) {
        return b(v, 8);
    }
    /**
     *  Return a new ``bytes9`` type for %%v%%.
     */ static bytes9(v) {
        return b(v, 9);
    }
    /**
     *  Return a new ``bytes10`` type for %%v%%.
     */ static bytes10(v) {
        return b(v, 10);
    }
    /**
     *  Return a new ``bytes11`` type for %%v%%.
     */ static bytes11(v) {
        return b(v, 11);
    }
    /**
     *  Return a new ``bytes12`` type for %%v%%.
     */ static bytes12(v) {
        return b(v, 12);
    }
    /**
     *  Return a new ``bytes13`` type for %%v%%.
     */ static bytes13(v) {
        return b(v, 13);
    }
    /**
     *  Return a new ``bytes14`` type for %%v%%.
     */ static bytes14(v) {
        return b(v, 14);
    }
    /**
     *  Return a new ``bytes15`` type for %%v%%.
     */ static bytes15(v) {
        return b(v, 15);
    }
    /**
     *  Return a new ``bytes16`` type for %%v%%.
     */ static bytes16(v) {
        return b(v, 16);
    }
    /**
     *  Return a new ``bytes17`` type for %%v%%.
     */ static bytes17(v) {
        return b(v, 17);
    }
    /**
     *  Return a new ``bytes18`` type for %%v%%.
     */ static bytes18(v) {
        return b(v, 18);
    }
    /**
     *  Return a new ``bytes19`` type for %%v%%.
     */ static bytes19(v) {
        return b(v, 19);
    }
    /**
     *  Return a new ``bytes20`` type for %%v%%.
     */ static bytes20(v) {
        return b(v, 20);
    }
    /**
     *  Return a new ``bytes21`` type for %%v%%.
     */ static bytes21(v) {
        return b(v, 21);
    }
    /**
     *  Return a new ``bytes22`` type for %%v%%.
     */ static bytes22(v) {
        return b(v, 22);
    }
    /**
     *  Return a new ``bytes23`` type for %%v%%.
     */ static bytes23(v) {
        return b(v, 23);
    }
    /**
     *  Return a new ``bytes24`` type for %%v%%.
     */ static bytes24(v) {
        return b(v, 24);
    }
    /**
     *  Return a new ``bytes25`` type for %%v%%.
     */ static bytes25(v) {
        return b(v, 25);
    }
    /**
     *  Return a new ``bytes26`` type for %%v%%.
     */ static bytes26(v) {
        return b(v, 26);
    }
    /**
     *  Return a new ``bytes27`` type for %%v%%.
     */ static bytes27(v) {
        return b(v, 27);
    }
    /**
     *  Return a new ``bytes28`` type for %%v%%.
     */ static bytes28(v) {
        return b(v, 28);
    }
    /**
     *  Return a new ``bytes29`` type for %%v%%.
     */ static bytes29(v) {
        return b(v, 29);
    }
    /**
     *  Return a new ``bytes30`` type for %%v%%.
     */ static bytes30(v) {
        return b(v, 30);
    }
    /**
     *  Return a new ``bytes31`` type for %%v%%.
     */ static bytes31(v) {
        return b(v, 31);
    }
    /**
     *  Return a new ``bytes32`` type for %%v%%.
     */ static bytes32(v) {
        return b(v, 32);
    }
    /**
     *  Return a new ``address`` type for %%v%%.
     */ static address(v) {
        return new Typed(_gaurd, "address", v);
    }
    /**
     *  Return a new ``bool`` type for %%v%%.
     */ static bool(v) {
        return new Typed(_gaurd, "bool", !!v);
    }
    /**
     *  Return a new ``bytes`` type for %%v%%.
     */ static bytes(v) {
        return new Typed(_gaurd, "bytes", v);
    }
    /**
     *  Return a new ``string`` type for %%v%%.
     */ static string(v) {
        return new Typed(_gaurd, "string", v);
    }
    /**
     *  Return a new ``array`` type for %%v%%, allowing %%dynamic%% length.
     */ static array(v, dynamic) {
        throw new Error("not implemented yet");
        return new Typed(_gaurd, "array", v, dynamic);
    }
    /**
     *  Return a new ``tuple`` type for %%v%%, with the optional %%name%%.
     */ static tuple(v, name) {
        throw new Error("not implemented yet");
        return new Typed(_gaurd, "tuple", v, name);
    }
    /**
     *  Return a new ``uint8`` type for %%v%%.
     */ static overrides(v) {
        return new Typed(_gaurd, "overrides", Object.assign({}, v));
    }
    /**
     *  Returns true only if %%value%% is a [[Typed]] instance.
     */ static isTyped(value) {
        return value && typeof value === "object" && "_typedSymbol" in value && value._typedSymbol === _typedSymbol;
    }
    /**
     *  If the value is a [[Typed]] instance, validates the underlying value
     *  and returns it, otherwise returns value directly.
     *
     *  This is useful for functions that with to accept either a [[Typed]]
     *  object or values.
     */ static dereference(value, type) {
        if (Typed.isTyped(value)) {
            if (value.type !== type) {
                throw new Error("invalid type: expecetd ".concat(type, ", got ").concat(value.type));
            }
            return value.value;
        }
        return value;
    }
    /**
     *  @_ignore:
     */ constructor(gaurd, type, value, options){
        /**
     *  The type, as a Solidity-compatible type.
     */ _define_property._(this, "type", void 0);
        /**
     *  The actual value.
     */ _define_property._(this, "value", void 0);
        _class_private_field_init._(this, _options, {
            writable: true,
            value: void 0
        });
        /**
     *  @_ignore:
     */ _define_property._(this, "_typedSymbol", void 0);
        if (options == null) {
            options = null;
        }
        (0, index_js_1.assertPrivate)(_gaurd, gaurd, "Typed");
        (0, index_js_1.defineProperties)(this, {
            _typedSymbol,
            type,
            value
        });
        _class_private_field_set._(this, _options, options);
        // Check the value is valid
        this.format();
    }
}
exports.Typed = Typed; //# sourceMappingURL=typed.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/address.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AddressCoder = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const maths_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/maths.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ class AddressCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return "0x0000000000000000000000000000000000000000";
    }
    encode(writer, _value) {
        let value = typed_js_1.Typed.dereference(_value, "string");
        try {
            value = (0, index_js_1.getAddress)(value);
        } catch (error) {
            return this._throwError(error.message, _value);
        }
        return writer.writeValue(value);
    }
    decode(reader) {
        return (0, index_js_1.getAddress)((0, maths_js_1.toBeHex)(reader.readValue(), 20));
    }
    constructor(localName){
        super("address", "address", localName, false);
    }
}
exports.AddressCoder = AddressCoder; //# sourceMappingURL=address.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/anonymous.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AnonymousCoder = void 0;
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
/**
 *  Clones the functionality of an existing Coder, but without a localName
 *
 *  @_ignore
 */ class AnonymousCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return this.coder.defaultValue();
    }
    encode(writer, value) {
        return this.coder.encode(writer, value);
    }
    decode(reader) {
        return this.coder.decode(reader);
    }
    constructor(coder){
        super(coder.name, coder.type, "_", coder.dynamic), _define_property._(this, "coder", void 0);
        this.coder = coder;
    }
}
exports.AnonymousCoder = AnonymousCoder; //# sourceMappingURL=anonymous.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/array.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ArrayCoder = exports.unpack = exports.pack = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
const anonymous_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/anonymous.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ function pack(writer, coders, values) {
    let arrayValues = [];
    if (Array.isArray(values)) {
        arrayValues = values;
    } else if (values && typeof values === "object") {
        let unique = {};
        arrayValues = coders.map((coder)=>{
            const name = coder.localName;
            (0, index_js_1.assert)(name, "cannot encode object for signature with missing names", "INVALID_ARGUMENT", {
                argument: "values",
                info: {
                    coder
                },
                value: values
            });
            (0, index_js_1.assert)(!unique[name], "cannot encode object for signature with duplicate names", "INVALID_ARGUMENT", {
                argument: "values",
                info: {
                    coder
                },
                value: values
            });
            unique[name] = true;
            return values[name];
        });
    } else {
        (0, index_js_1.assertArgument)(false, "invalid tuple value", "tuple", values);
    }
    (0, index_js_1.assertArgument)(coders.length === arrayValues.length, "types/value length mismatch", "tuple", values);
    let staticWriter = new abstract_coder_js_1.Writer();
    let dynamicWriter = new abstract_coder_js_1.Writer();
    let updateFuncs = [];
    coders.forEach((coder, index)=>{
        let value = arrayValues[index];
        if (coder.dynamic) {
            // Get current dynamic offset (for the future pointer)
            let dynamicOffset = dynamicWriter.length;
            // Encode the dynamic value into the dynamicWriter
            coder.encode(dynamicWriter, value);
            // Prepare to populate the correct offset once we are done
            let updateFunc = staticWriter.writeUpdatableValue();
            updateFuncs.push((baseOffset)=>{
                updateFunc(baseOffset + dynamicOffset);
            });
        } else {
            coder.encode(staticWriter, value);
        }
    });
    // Backfill all the dynamic offsets, now that we know the static length
    updateFuncs.forEach((func)=>{
        func(staticWriter.length);
    });
    let length = writer.appendWriter(staticWriter);
    length += writer.appendWriter(dynamicWriter);
    return length;
}
exports.pack = pack;
/**
 *  @_ignore
 */ function unpack(reader, coders) {
    let values = [];
    let keys = [];
    // A reader anchored to this base
    let baseReader = reader.subReader(0);
    coders.forEach((coder)=>{
        let value = null;
        if (coder.dynamic) {
            let offset = reader.readIndex();
            let offsetReader = baseReader.subReader(offset);
            try {
                value = coder.decode(offsetReader);
            } catch (error) {
                // Cannot recover from this
                if ((0, index_js_1.isError)(error, "BUFFER_OVERRUN")) {
                    throw error;
                }
                value = error;
                value.baseType = coder.name;
                value.name = coder.localName;
                value.type = coder.type;
            }
        } else {
            try {
                value = coder.decode(reader);
            } catch (error) {
                // Cannot recover from this
                if ((0, index_js_1.isError)(error, "BUFFER_OVERRUN")) {
                    throw error;
                }
                value = error;
                value.baseType = coder.name;
                value.name = coder.localName;
                value.type = coder.type;
            }
        }
        if (value == undefined) {
            throw new Error("investigate");
        }
        values.push(value);
        keys.push(coder.localName || null);
    });
    return abstract_coder_js_1.Result.fromItems(values, keys);
}
exports.unpack = unpack;
/**
 *  @_ignore
 */ class ArrayCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        // Verifies the child coder is valid (even if the array is dynamic or 0-length)
        const defaultChild = this.coder.defaultValue();
        const result = [];
        for(let i = 0; i < this.length; i++){
            result.push(defaultChild);
        }
        return result;
    }
    encode(writer, _value) {
        const value = typed_js_1.Typed.dereference(_value, "array");
        if (!Array.isArray(value)) {
            this._throwError("expected array value", value);
        }
        let count = this.length;
        if (count === -1) {
            count = value.length;
            writer.writeValue(value.length);
        }
        (0, index_js_1.assertArgumentCount)(value.length, count, "coder array" + (this.localName ? " " + this.localName : ""));
        let coders = [];
        for(let i = 0; i < value.length; i++){
            coders.push(this.coder);
        }
        return pack(writer, coders, value);
    }
    decode(reader) {
        let count = this.length;
        if (count === -1) {
            count = reader.readIndex();
            // Check that there is *roughly* enough data to ensure
            // stray random data is not being read as a length. Each
            // slot requires at least 32 bytes for their value (or 32
            // bytes as a link to the data). This could use a much
            // tighter bound, but we are erroring on the side of safety.
            (0, index_js_1.assert)(count * abstract_coder_js_1.WordSize <= reader.dataLength, "insufficient data length", "BUFFER_OVERRUN", {
                buffer: reader.bytes,
                offset: count * abstract_coder_js_1.WordSize,
                length: reader.dataLength
            });
        }
        let coders = [];
        for(let i = 0; i < count; i++){
            coders.push(new anonymous_js_1.AnonymousCoder(this.coder));
        }
        return unpack(reader, coders);
    }
    constructor(coder, length, localName){
        const type = coder.type + "[" + (length >= 0 ? length : "") + "]";
        const dynamic = length === -1 || coder.dynamic;
        super("array", type, localName, dynamic), _define_property._(this, "coder", void 0), _define_property._(this, "length", void 0);
        (0, index_js_1.defineProperties)(this, {
            coder,
            length
        });
    }
}
exports.ArrayCoder = ArrayCoder; //# sourceMappingURL=array.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/boolean.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BooleanCoder = void 0;
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ class BooleanCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return false;
    }
    encode(writer, _value) {
        const value = typed_js_1.Typed.dereference(_value, "bool");
        return writer.writeValue(value ? 1 : 0);
    }
    decode(reader) {
        return !!reader.readValue();
    }
    constructor(localName){
        super("bool", "bool", localName, false);
    }
}
exports.BooleanCoder = BooleanCoder; //# sourceMappingURL=boolean.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/bytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BytesCoder = exports.DynamicBytesCoder = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ class DynamicBytesCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return "0x";
    }
    encode(writer, value) {
        value = (0, index_js_1.getBytesCopy)(value);
        let length = writer.writeValue(value.length);
        length += writer.writeBytes(value);
        return length;
    }
    decode(reader) {
        return reader.readBytes(reader.readIndex(), true);
    }
    constructor(type, localName){
        super(type, type, localName, true);
    }
}
exports.DynamicBytesCoder = DynamicBytesCoder;
/**
 *  @_ignore
 */ class BytesCoder extends DynamicBytesCoder {
    decode(reader) {
        return (0, index_js_1.hexlify)(super.decode(reader));
    }
    constructor(localName){
        super("bytes", localName);
    }
}
exports.BytesCoder = BytesCoder; //# sourceMappingURL=bytes.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/fixed-bytes.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FixedBytesCoder = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ class FixedBytesCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return "0x0000000000000000000000000000000000000000000000000000000000000000".substring(0, 2 + this.size * 2);
    }
    encode(writer, _value) {
        let data = (0, index_js_1.getBytesCopy)(typed_js_1.Typed.dereference(_value, this.type));
        if (data.length !== this.size) {
            this._throwError("incorrect data length", _value);
        }
        return writer.writeBytes(data);
    }
    decode(reader) {
        return (0, index_js_1.hexlify)(reader.readBytes(this.size));
    }
    constructor(size, localName){
        let name = "bytes" + String(size);
        super(name, name, localName, false), _define_property._(this, "size", void 0);
        (0, index_js_1.defineProperties)(this, {
            size
        }, {
            size: "number"
        });
    }
}
exports.FixedBytesCoder = FixedBytesCoder; //# sourceMappingURL=fixed-bytes.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/null.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NullCoder = void 0;
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
const Empty = new Uint8Array([]);
/**
 *  @_ignore
 */ class NullCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return null;
    }
    encode(writer, value) {
        if (value != null) {
            this._throwError("not null", value);
        }
        return writer.writeBytes(Empty);
    }
    decode(reader) {
        reader.readBytes(0);
        return null;
    }
    constructor(localName){
        super("null", "", localName, false);
    }
}
exports.NullCoder = NullCoder; //# sourceMappingURL=null.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/number.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NumberCoder = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
const BN_1 = BigInt(1);
const BN_MAX_UINT256 = BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
/**
 *  @_ignore
 */ class NumberCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        return 0;
    }
    encode(writer, _value) {
        let value = (0, index_js_1.getBigInt)(typed_js_1.Typed.dereference(_value, this.type));
        // Check bounds are safe for encoding
        let maxUintValue = (0, index_js_1.mask)(BN_MAX_UINT256, abstract_coder_js_1.WordSize * 8);
        if (this.signed) {
            let bounds = (0, index_js_1.mask)(maxUintValue, this.size * 8 - 1);
            if (value > bounds || value < -(bounds + BN_1)) {
                this._throwError("value out-of-bounds", _value);
            }
            value = (0, index_js_1.toTwos)(value, 8 * abstract_coder_js_1.WordSize);
        } else if (value < BN_0 || value > (0, index_js_1.mask)(maxUintValue, this.size * 8)) {
            this._throwError("value out-of-bounds", _value);
        }
        return writer.writeValue(value);
    }
    decode(reader) {
        let value = (0, index_js_1.mask)(reader.readValue(), this.size * 8);
        if (this.signed) {
            value = (0, index_js_1.fromTwos)(value, this.size * 8);
        }
        return value;
    }
    constructor(size, signed, localName){
        const name = (signed ? "int" : "uint") + size * 8;
        super(name, name, localName, false), _define_property._(this, "size", void 0), _define_property._(this, "signed", void 0);
        (0, index_js_1.defineProperties)(this, {
            size,
            signed
        }, {
            size: "number",
            signed: "boolean"
        });
    }
}
exports.NumberCoder = NumberCoder; //# sourceMappingURL=number.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/string.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.StringCoder = void 0;
const utf8_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/utf8.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const bytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/bytes.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ class StringCoder extends bytes_js_1.DynamicBytesCoder {
    defaultValue() {
        return "";
    }
    encode(writer, _value) {
        return super.encode(writer, (0, utf8_js_1.toUtf8Bytes)(typed_js_1.Typed.dereference(_value, "string")));
    }
    decode(reader) {
        return (0, utf8_js_1.toUtf8String)(super.decode(reader));
    }
    constructor(localName){
        super("string", localName);
    }
}
exports.StringCoder = StringCoder; //# sourceMappingURL=string.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/tuple.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TupleCoder = void 0;
const properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
const array_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/array.js [app-client] (ecmascript)");
/**
 *  @_ignore
 */ class TupleCoder extends abstract_coder_js_1.Coder {
    defaultValue() {
        const values = [];
        this.coders.forEach((coder)=>{
            values.push(coder.defaultValue());
        });
        // We only output named properties for uniquely named coders
        const uniqueNames = this.coders.reduce((accum, coder)=>{
            const name = coder.localName;
            if (name) {
                if (!accum[name]) {
                    accum[name] = 0;
                }
                accum[name]++;
            }
            return accum;
        }, {});
        // Add named values
        this.coders.forEach((coder, index)=>{
            let name = coder.localName;
            if (!name || uniqueNames[name] !== 1) {
                return;
            }
            if (name === "length") {
                name = "_length";
            }
            if (values[name] != null) {
                return;
            }
            values[name] = values[index];
        });
        return Object.freeze(values);
    }
    encode(writer, _value) {
        const value = typed_js_1.Typed.dereference(_value, "tuple");
        return (0, array_js_1.pack)(writer, this.coders, value);
    }
    decode(reader) {
        return (0, array_js_1.unpack)(reader, this.coders);
    }
    constructor(coders, localName){
        let dynamic = false;
        const types = [];
        coders.forEach((coder)=>{
            if (coder.dynamic) {
                dynamic = true;
            }
            types.push(coder.type);
        });
        const type = "tuple(" + types.join(",") + ")";
        super("tuple", type, localName, dynamic), _define_property._(this, "coders", void 0);
        (0, properties_js_1.defineProperties)(this, {
            coders: Object.freeze(coders.slice())
        });
    }
}
exports.TupleCoder = TupleCoder; //# sourceMappingURL=tuple.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/accesslist.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.accessListify = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
function accessSetify(addr, storageKeys) {
    return {
        address: (0, index_js_1.getAddress)(addr),
        storageKeys: storageKeys.map((storageKey, index)=>{
            (0, index_js_2.assertArgument)((0, index_js_2.isHexString)(storageKey, 32), "invalid slot", "storageKeys[".concat(index, "]"), storageKey);
            return storageKey.toLowerCase();
        })
    };
}
/**
 *  Returns a [[AccessList]] from any ethers-supported access-list structure.
 */ function accessListify(value) {
    if (Array.isArray(value)) {
        return value.map((set, index)=>{
            if (Array.isArray(set)) {
                (0, index_js_2.assertArgument)(set.length === 2, "invalid slot set", "value[".concat(index, "]"), set);
                return accessSetify(set[0], set[1]);
            }
            (0, index_js_2.assertArgument)(set != null && typeof set === "object", "invalid address-slot set", "value", value);
            return accessSetify(set.address, set.storageKeys);
        });
    }
    (0, index_js_2.assertArgument)(value != null && typeof value === "object", "invalid access list", "value", value);
    const result = Object.keys(value).map((addr)=>{
        const storageKeys = value[addr].reduce((accum, storageKey)=>{
            accum[storageKey] = true;
            return accum;
        }, {});
        return accessSetify(addr, Object.keys(storageKeys).sort());
    });
    result.sort((a, b)=>a.address.localeCompare(b.address));
    return result;
}
exports.accessListify = accessListify; //# sourceMappingURL=accesslist.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/authorization.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.authorizationify = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
function authorizationify(auth) {
    return {
        address: (0, index_js_1.getAddress)(auth.address),
        nonce: (0, index_js_3.getBigInt)(auth.nonce != null ? auth.nonce : 0),
        chainId: (0, index_js_3.getBigInt)(auth.chainId != null ? auth.chainId : 0),
        signature: index_js_2.Signature.from(auth.signature)
    };
}
exports.authorizationify = authorizationify; //# sourceMappingURL=authorization.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/address.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.recoverAddress = exports.computeAddress = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
/**
 *  Returns the address for the %%key%%.
 *
 *  The key may be any standard form of public key or a private key.
 */ function computeAddress(key) {
    let pubkey;
    if (typeof key === "string") {
        pubkey = index_js_2.SigningKey.computePublicKey(key, false);
    } else {
        pubkey = key.publicKey;
    }
    return (0, index_js_1.getAddress)((0, index_js_2.keccak256)("0x" + pubkey.substring(4)).substring(26));
}
exports.computeAddress = computeAddress;
/**
 *  Returns the recovered address for the private key that was
 *  used to sign %%digest%% that resulted in %%signature%%.
 */ function recoverAddress(digest, signature) {
    return computeAddress(index_js_2.SigningKey.recoverPublicKey(digest, signature));
}
exports.recoverAddress = recoverAddress; //# sourceMappingURL=address.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/transaction.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Transaction = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const addresses_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/addresses.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const accesslist_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/accesslist.js [app-client] (ecmascript)");
const authorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/authorization.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/address.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
const BN_2 = BigInt(2);
const BN_27 = BigInt(27);
const BN_28 = BigInt(28);
const BN_35 = BigInt(35);
const BN_MAX_UINT = BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
const BLOB_SIZE = 4096 * 32;
function getKzgLibrary(kzg) {
    const blobToKzgCommitment = (blob)=>{
        if ("computeBlobProof" in kzg) {
            // micro-ecc-signer; check for computeBlobProof since this API
            // expects a string while the kzg-wasm below expects a Unit8Array
            if ("blobToKzgCommitment" in kzg && typeof kzg.blobToKzgCommitment === "function") {
                return (0, index_js_3.getBytes)(kzg.blobToKzgCommitment((0, index_js_3.hexlify)(blob)));
            }
        } else if ("blobToKzgCommitment" in kzg && typeof kzg.blobToKzgCommitment === "function") {
            // kzg-wasm <0.5.0; blobToKzgCommitment(Uint8Array) => Uint8Array
            return (0, index_js_3.getBytes)(kzg.blobToKzgCommitment(blob));
        }
        // kzg-wasm >= 0.5.0; blobToKZGCommitment(string) => string
        if ("blobToKZGCommitment" in kzg && typeof kzg.blobToKZGCommitment === "function") {
            return (0, index_js_3.getBytes)(kzg.blobToKZGCommitment((0, index_js_3.hexlify)(blob)));
        }
        (0, index_js_3.assertArgument)(false, "unsupported KZG library", "kzg", kzg);
    };
    const computeBlobKzgProof = (blob, commitment)=>{
        // micro-ecc-signer
        if ("computeBlobProof" in kzg && typeof kzg.computeBlobProof === "function") {
            return (0, index_js_3.getBytes)(kzg.computeBlobProof((0, index_js_3.hexlify)(blob), (0, index_js_3.hexlify)(commitment)));
        }
        // kzg-wasm <0.5.0; computeBlobKzgProof(Uint8Array, Uint8Array) => Uint8Array
        if ("computeBlobKzgProof" in kzg && typeof kzg.computeBlobKzgProof === "function") {
            return kzg.computeBlobKzgProof(blob, commitment);
        }
        // kzg-wasm >= 0.5.0; computeBlobKZGProof(string, string) => string
        if ("computeBlobKZGProof" in kzg && typeof kzg.computeBlobKZGProof === "function") {
            return (0, index_js_3.getBytes)(kzg.computeBlobKZGProof((0, index_js_3.hexlify)(blob), (0, index_js_3.hexlify)(commitment)));
        }
        (0, index_js_3.assertArgument)(false, "unsupported KZG library", "kzg", kzg);
    };
    return {
        blobToKzgCommitment,
        computeBlobKzgProof
    };
}
function getVersionedHash(version, hash) {
    let versioned = version.toString(16);
    while(versioned.length < 2){
        versioned = "0" + versioned;
    }
    versioned += (0, index_js_2.sha256)(hash).substring(4);
    return "0x" + versioned;
}
function handleAddress(value) {
    if (value === "0x") {
        return null;
    }
    return (0, index_js_1.getAddress)(value);
}
function handleAccessList(value, param) {
    try {
        return (0, accesslist_js_1.accessListify)(value);
    } catch (error) {
        (0, index_js_3.assertArgument)(false, error.message, param, value);
    }
}
function handleAuthorizationList(value, param) {
    try {
        if (!Array.isArray(value)) {
            throw new Error("authorizationList: invalid array");
        }
        const result = [];
        for(let i = 0; i < value.length; i++){
            const auth = value[i];
            if (!Array.isArray(auth)) {
                throw new Error("authorization[".concat(i, "]: invalid array"));
            }
            if (auth.length !== 6) {
                throw new Error("authorization[".concat(i, "]: wrong length"));
            }
            if (!auth[1]) {
                throw new Error("authorization[".concat(i, "]: null address"));
            }
            result.push({
                address: handleAddress(auth[1]),
                nonce: handleUint(auth[2], "nonce"),
                chainId: handleUint(auth[0], "chainId"),
                signature: index_js_2.Signature.from({
                    yParity: handleNumber(auth[3], "yParity"),
                    r: (0, index_js_3.zeroPadValue)(auth[4], 32),
                    s: (0, index_js_3.zeroPadValue)(auth[5], 32)
                })
            });
        }
        return result;
    } catch (error) {
        (0, index_js_3.assertArgument)(false, error.message, param, value);
    }
}
function handleNumber(_value, param) {
    if (_value === "0x") {
        return 0;
    }
    return (0, index_js_3.getNumber)(_value, param);
}
function handleUint(_value, param) {
    if (_value === "0x") {
        return BN_0;
    }
    const value = (0, index_js_3.getBigInt)(_value, param);
    (0, index_js_3.assertArgument)(value <= BN_MAX_UINT, "value exceeds uint size", param, value);
    return value;
}
function formatNumber(_value, name) {
    const value = (0, index_js_3.getBigInt)(_value, "value");
    const result = (0, index_js_3.toBeArray)(value);
    (0, index_js_3.assertArgument)(result.length <= 32, "value too large", "tx.".concat(name), value);
    return result;
}
function formatAccessList(value) {
    return (0, accesslist_js_1.accessListify)(value).map((set)=>[
            set.address,
            set.storageKeys
        ]);
}
function formatAuthorizationList(value) {
    return value.map((a)=>{
        return [
            formatNumber(a.chainId, "chainId"),
            a.address,
            formatNumber(a.nonce, "nonce"),
            formatNumber(a.signature.yParity, "yParity"),
            (0, index_js_3.toBeArray)(a.signature.r),
            (0, index_js_3.toBeArray)(a.signature.s)
        ];
    });
}
function formatHashes(value, param) {
    (0, index_js_3.assertArgument)(Array.isArray(value), "invalid ".concat(param), "value", value);
    for(let i = 0; i < value.length; i++){
        (0, index_js_3.assertArgument)((0, index_js_3.isHexString)(value[i], 32), "invalid ${ param } hash", "value[".concat(i, "]"), value[i]);
    }
    return value;
}
function _parseLegacy(data) {
    const fields = (0, index_js_3.decodeRlp)(data);
    (0, index_js_3.assertArgument)(Array.isArray(fields) && (fields.length === 9 || fields.length === 6), "invalid field count for legacy transaction", "data", data);
    const tx = {
        type: 0,
        nonce: handleNumber(fields[0], "nonce"),
        gasPrice: handleUint(fields[1], "gasPrice"),
        gasLimit: handleUint(fields[2], "gasLimit"),
        to: handleAddress(fields[3]),
        value: handleUint(fields[4], "value"),
        data: (0, index_js_3.hexlify)(fields[5]),
        chainId: BN_0
    };
    // Legacy unsigned transaction
    if (fields.length === 6) {
        return tx;
    }
    const v = handleUint(fields[6], "v");
    const r = handleUint(fields[7], "r");
    const s = handleUint(fields[8], "s");
    if (r === BN_0 && s === BN_0) {
        // EIP-155 unsigned transaction
        tx.chainId = v;
    } else {
        // Compute the EIP-155 chain ID (or 0 for legacy)
        let chainId = (v - BN_35) / BN_2;
        if (chainId < BN_0) {
            chainId = BN_0;
        }
        tx.chainId = chainId;
        // Signed Legacy Transaction
        (0, index_js_3.assertArgument)(chainId !== BN_0 || v === BN_27 || v === BN_28, "non-canonical legacy v", "v", fields[6]);
        tx.signature = index_js_2.Signature.from({
            r: (0, index_js_3.zeroPadValue)(fields[7], 32),
            s: (0, index_js_3.zeroPadValue)(fields[8], 32),
            v
        });
    //tx.hash = keccak256(data);
    }
    return tx;
}
function _serializeLegacy(tx, sig) {
    const fields = [
        formatNumber(tx.nonce, "nonce"),
        formatNumber(tx.gasPrice || 0, "gasPrice"),
        formatNumber(tx.gasLimit, "gasLimit"),
        tx.to || "0x",
        formatNumber(tx.value, "value"),
        tx.data
    ];
    let chainId = BN_0;
    if (tx.chainId != BN_0) {
        // A chainId was provided; if non-zero we'll use EIP-155
        chainId = (0, index_js_3.getBigInt)(tx.chainId, "tx.chainId");
        // We have a chainId in the tx and an EIP-155 v in the signature,
        // make sure they agree with each other
        (0, index_js_3.assertArgument)(!sig || sig.networkV == null || sig.legacyChainId === chainId, "tx.chainId/sig.v mismatch", "sig", sig);
    } else if (tx.signature) {
        // No explicit chainId, but EIP-155 have a derived implicit chainId
        const legacy = tx.signature.legacyChainId;
        if (legacy != null) {
            chainId = legacy;
        }
    }
    // Requesting an unsigned transaction
    if (!sig) {
        // We have an EIP-155 transaction (chainId was specified and non-zero)
        if (chainId !== BN_0) {
            fields.push((0, index_js_3.toBeArray)(chainId));
            fields.push("0x");
            fields.push("0x");
        }
        return (0, index_js_3.encodeRlp)(fields);
    }
    // @TODO: We should probably check that tx.signature, chainId, and sig
    //        match but that logic could break existing code, so schedule
    //        this for the next major bump.
    // Compute the EIP-155 v
    let v = BigInt(27 + sig.yParity);
    if (chainId !== BN_0) {
        v = index_js_2.Signature.getChainIdV(chainId, sig.v);
    } else if (BigInt(sig.v) !== v) {
        (0, index_js_3.assertArgument)(false, "tx.chainId/sig.v mismatch", "sig", sig);
    }
    // Add the signature
    fields.push((0, index_js_3.toBeArray)(v));
    fields.push((0, index_js_3.toBeArray)(sig.r));
    fields.push((0, index_js_3.toBeArray)(sig.s));
    return (0, index_js_3.encodeRlp)(fields);
}
function _parseEipSignature(tx, fields) {
    let yParity;
    try {
        yParity = handleNumber(fields[0], "yParity");
        if (yParity !== 0 && yParity !== 1) {
            throw new Error("bad yParity");
        }
    } catch (error) {
        (0, index_js_3.assertArgument)(false, "invalid yParity", "yParity", fields[0]);
    }
    const r = (0, index_js_3.zeroPadValue)(fields[1], 32);
    const s = (0, index_js_3.zeroPadValue)(fields[2], 32);
    const signature = index_js_2.Signature.from({
        r,
        s,
        yParity
    });
    tx.signature = signature;
}
function _parseEip1559(data) {
    const fields = (0, index_js_3.decodeRlp)((0, index_js_3.getBytes)(data).slice(1));
    (0, index_js_3.assertArgument)(Array.isArray(fields) && (fields.length === 9 || fields.length === 12), "invalid field count for transaction type: 2", "data", (0, index_js_3.hexlify)(data));
    const tx = {
        type: 2,
        chainId: handleUint(fields[0], "chainId"),
        nonce: handleNumber(fields[1], "nonce"),
        maxPriorityFeePerGas: handleUint(fields[2], "maxPriorityFeePerGas"),
        maxFeePerGas: handleUint(fields[3], "maxFeePerGas"),
        gasPrice: null,
        gasLimit: handleUint(fields[4], "gasLimit"),
        to: handleAddress(fields[5]),
        value: handleUint(fields[6], "value"),
        data: (0, index_js_3.hexlify)(fields[7]),
        accessList: handleAccessList(fields[8], "accessList")
    };
    // Unsigned EIP-1559 Transaction
    if (fields.length === 9) {
        return tx;
    }
    //tx.hash = keccak256(data);
    _parseEipSignature(tx, fields.slice(9));
    return tx;
}
function _serializeEip1559(tx, sig) {
    const fields = [
        formatNumber(tx.chainId, "chainId"),
        formatNumber(tx.nonce, "nonce"),
        formatNumber(tx.maxPriorityFeePerGas || 0, "maxPriorityFeePerGas"),
        formatNumber(tx.maxFeePerGas || 0, "maxFeePerGas"),
        formatNumber(tx.gasLimit, "gasLimit"),
        tx.to || "0x",
        formatNumber(tx.value, "value"),
        tx.data,
        formatAccessList(tx.accessList || [])
    ];
    if (sig) {
        fields.push(formatNumber(sig.yParity, "yParity"));
        fields.push((0, index_js_3.toBeArray)(sig.r));
        fields.push((0, index_js_3.toBeArray)(sig.s));
    }
    return (0, index_js_3.concat)([
        "0x02",
        (0, index_js_3.encodeRlp)(fields)
    ]);
}
function _parseEip2930(data) {
    const fields = (0, index_js_3.decodeRlp)((0, index_js_3.getBytes)(data).slice(1));
    (0, index_js_3.assertArgument)(Array.isArray(fields) && (fields.length === 8 || fields.length === 11), "invalid field count for transaction type: 1", "data", (0, index_js_3.hexlify)(data));
    const tx = {
        type: 1,
        chainId: handleUint(fields[0], "chainId"),
        nonce: handleNumber(fields[1], "nonce"),
        gasPrice: handleUint(fields[2], "gasPrice"),
        gasLimit: handleUint(fields[3], "gasLimit"),
        to: handleAddress(fields[4]),
        value: handleUint(fields[5], "value"),
        data: (0, index_js_3.hexlify)(fields[6]),
        accessList: handleAccessList(fields[7], "accessList")
    };
    // Unsigned EIP-2930 Transaction
    if (fields.length === 8) {
        return tx;
    }
    //tx.hash = keccak256(data);
    _parseEipSignature(tx, fields.slice(8));
    return tx;
}
function _serializeEip2930(tx, sig) {
    const fields = [
        formatNumber(tx.chainId, "chainId"),
        formatNumber(tx.nonce, "nonce"),
        formatNumber(tx.gasPrice || 0, "gasPrice"),
        formatNumber(tx.gasLimit, "gasLimit"),
        tx.to || "0x",
        formatNumber(tx.value, "value"),
        tx.data,
        formatAccessList(tx.accessList || [])
    ];
    if (sig) {
        fields.push(formatNumber(sig.yParity, "recoveryParam"));
        fields.push((0, index_js_3.toBeArray)(sig.r));
        fields.push((0, index_js_3.toBeArray)(sig.s));
    }
    return (0, index_js_3.concat)([
        "0x01",
        (0, index_js_3.encodeRlp)(fields)
    ]);
}
function _parseEip4844(data) {
    let fields = (0, index_js_3.decodeRlp)((0, index_js_3.getBytes)(data).slice(1));
    let typeName = "3";
    let blobs = null;
    // Parse the network format
    if (fields.length === 4 && Array.isArray(fields[0])) {
        typeName = "3 (network format)";
        const fBlobs = fields[1], fCommits = fields[2], fProofs = fields[3];
        (0, index_js_3.assertArgument)(Array.isArray(fBlobs), "invalid network format: blobs not an array", "fields[1]", fBlobs);
        (0, index_js_3.assertArgument)(Array.isArray(fCommits), "invalid network format: commitments not an array", "fields[2]", fCommits);
        (0, index_js_3.assertArgument)(Array.isArray(fProofs), "invalid network format: proofs not an array", "fields[3]", fProofs);
        (0, index_js_3.assertArgument)(fBlobs.length === fCommits.length, "invalid network format: blobs/commitments length mismatch", "fields", fields);
        (0, index_js_3.assertArgument)(fBlobs.length === fProofs.length, "invalid network format: blobs/proofs length mismatch", "fields", fields);
        blobs = [];
        for(let i = 0; i < fields[1].length; i++){
            blobs.push({
                data: fBlobs[i],
                commitment: fCommits[i],
                proof: fProofs[i]
            });
        }
        fields = fields[0];
    }
    (0, index_js_3.assertArgument)(Array.isArray(fields) && (fields.length === 11 || fields.length === 14), "invalid field count for transaction type: ".concat(typeName), "data", (0, index_js_3.hexlify)(data));
    const tx = {
        type: 3,
        chainId: handleUint(fields[0], "chainId"),
        nonce: handleNumber(fields[1], "nonce"),
        maxPriorityFeePerGas: handleUint(fields[2], "maxPriorityFeePerGas"),
        maxFeePerGas: handleUint(fields[3], "maxFeePerGas"),
        gasPrice: null,
        gasLimit: handleUint(fields[4], "gasLimit"),
        to: handleAddress(fields[5]),
        value: handleUint(fields[6], "value"),
        data: (0, index_js_3.hexlify)(fields[7]),
        accessList: handleAccessList(fields[8], "accessList"),
        maxFeePerBlobGas: handleUint(fields[9], "maxFeePerBlobGas"),
        blobVersionedHashes: fields[10]
    };
    if (blobs) {
        tx.blobs = blobs;
    }
    (0, index_js_3.assertArgument)(tx.to != null, "invalid address for transaction type: ".concat(typeName), "data", data);
    (0, index_js_3.assertArgument)(Array.isArray(tx.blobVersionedHashes), "invalid blobVersionedHashes: must be an array", "data", data);
    for(let i = 0; i < tx.blobVersionedHashes.length; i++){
        (0, index_js_3.assertArgument)((0, index_js_3.isHexString)(tx.blobVersionedHashes[i], 32), "invalid blobVersionedHash at index ".concat(i, ": must be length 32"), "data", data);
    }
    // Unsigned EIP-4844 Transaction
    if (fields.length === 11) {
        return tx;
    }
    // @TODO: Do we need to do this? This is only called internally
    // and used to verify hashes; it might save time to not do this
    //tx.hash = keccak256(concat([ "0x03", encodeRlp(fields) ]));
    _parseEipSignature(tx, fields.slice(11));
    return tx;
}
function _serializeEip4844(tx, sig, blobs) {
    const fields = [
        formatNumber(tx.chainId, "chainId"),
        formatNumber(tx.nonce, "nonce"),
        formatNumber(tx.maxPriorityFeePerGas || 0, "maxPriorityFeePerGas"),
        formatNumber(tx.maxFeePerGas || 0, "maxFeePerGas"),
        formatNumber(tx.gasLimit, "gasLimit"),
        tx.to || addresses_js_1.ZeroAddress,
        formatNumber(tx.value, "value"),
        tx.data,
        formatAccessList(tx.accessList || []),
        formatNumber(tx.maxFeePerBlobGas || 0, "maxFeePerBlobGas"),
        formatHashes(tx.blobVersionedHashes || [], "blobVersionedHashes")
    ];
    if (sig) {
        fields.push(formatNumber(sig.yParity, "yParity"));
        fields.push((0, index_js_3.toBeArray)(sig.r));
        fields.push((0, index_js_3.toBeArray)(sig.s));
        // We have blobs; return the network wrapped format
        if (blobs) {
            return (0, index_js_3.concat)([
                "0x03",
                (0, index_js_3.encodeRlp)([
                    fields,
                    blobs.map((b)=>b.data),
                    blobs.map((b)=>b.commitment),
                    blobs.map((b)=>b.proof)
                ])
            ]);
        }
    }
    return (0, index_js_3.concat)([
        "0x03",
        (0, index_js_3.encodeRlp)(fields)
    ]);
}
function _parseEip7702(data) {
    const fields = (0, index_js_3.decodeRlp)((0, index_js_3.getBytes)(data).slice(1));
    (0, index_js_3.assertArgument)(Array.isArray(fields) && (fields.length === 10 || fields.length === 13), "invalid field count for transaction type: 4", "data", (0, index_js_3.hexlify)(data));
    const tx = {
        type: 4,
        chainId: handleUint(fields[0], "chainId"),
        nonce: handleNumber(fields[1], "nonce"),
        maxPriorityFeePerGas: handleUint(fields[2], "maxPriorityFeePerGas"),
        maxFeePerGas: handleUint(fields[3], "maxFeePerGas"),
        gasPrice: null,
        gasLimit: handleUint(fields[4], "gasLimit"),
        to: handleAddress(fields[5]),
        value: handleUint(fields[6], "value"),
        data: (0, index_js_3.hexlify)(fields[7]),
        accessList: handleAccessList(fields[8], "accessList"),
        authorizationList: handleAuthorizationList(fields[9], "authorizationList")
    };
    // Unsigned EIP-7702 Transaction
    if (fields.length === 10) {
        return tx;
    }
    _parseEipSignature(tx, fields.slice(10));
    return tx;
}
function _serializeEip7702(tx, sig) {
    const fields = [
        formatNumber(tx.chainId, "chainId"),
        formatNumber(tx.nonce, "nonce"),
        formatNumber(tx.maxPriorityFeePerGas || 0, "maxPriorityFeePerGas"),
        formatNumber(tx.maxFeePerGas || 0, "maxFeePerGas"),
        formatNumber(tx.gasLimit, "gasLimit"),
        tx.to || "0x",
        formatNumber(tx.value, "value"),
        tx.data,
        formatAccessList(tx.accessList || []),
        formatAuthorizationList(tx.authorizationList || [])
    ];
    if (sig) {
        fields.push(formatNumber(sig.yParity, "yParity"));
        fields.push((0, index_js_3.toBeArray)(sig.r));
        fields.push((0, index_js_3.toBeArray)(sig.s));
    }
    return (0, index_js_3.concat)([
        "0x04",
        (0, index_js_3.encodeRlp)(fields)
    ]);
}
var _type = /*#__PURE__*/ new WeakMap(), _to = /*#__PURE__*/ new WeakMap(), _data = /*#__PURE__*/ new WeakMap(), _nonce = /*#__PURE__*/ new WeakMap(), _gasLimit = /*#__PURE__*/ new WeakMap(), _gasPrice = /*#__PURE__*/ new WeakMap(), _maxPriorityFeePerGas = /*#__PURE__*/ new WeakMap(), _maxFeePerGas = /*#__PURE__*/ new WeakMap(), _value = /*#__PURE__*/ new WeakMap(), _chainId = /*#__PURE__*/ new WeakMap(), _sig = /*#__PURE__*/ new WeakMap(), _accessList = /*#__PURE__*/ new WeakMap(), _maxFeePerBlobGas = /*#__PURE__*/ new WeakMap(), _blobVersionedHashes = /*#__PURE__*/ new WeakMap(), _kzg = /*#__PURE__*/ new WeakMap(), _blobs = /*#__PURE__*/ new WeakMap(), _auths = /*#__PURE__*/ new WeakMap(), _getSerialized = /*#__PURE__*/ new WeakSet();
/**
 *  A **Transaction** describes an operation to be executed on
 *  Ethereum by an Externally Owned Account (EOA). It includes
 *  who (the [[to]] address), what (the [[data]]) and how much (the
 *  [[value]] in ether) the operation should entail.
 *
 *  @example:
 *    tx = new Transaction()
 *    //_result:
 *
 *    tx.data = "0x1234";
 *    //_result:
 */ class Transaction {
    /**
     *  The transaction type.
     *
     *  If null, the type will be automatically inferred based on
     *  explicit properties.
     */ get type() {
        return _class_private_field_get._(this, _type);
    }
    set type(value) {
        switch(value){
            case null:
                _class_private_field_set._(this, _type, null);
                break;
            case 0:
            case "legacy":
                _class_private_field_set._(this, _type, 0);
                break;
            case 1:
            case "berlin":
            case "eip-2930":
                _class_private_field_set._(this, _type, 1);
                break;
            case 2:
            case "london":
            case "eip-1559":
                _class_private_field_set._(this, _type, 2);
                break;
            case 3:
            case "cancun":
            case "eip-4844":
                _class_private_field_set._(this, _type, 3);
                break;
            case 4:
            case "pectra":
            case "eip-7702":
                _class_private_field_set._(this, _type, 4);
                break;
            default:
                (0, index_js_3.assertArgument)(false, "unsupported transaction type", "type", value);
        }
    }
    /**
     *  The name of the transaction type.
     */ get typeName() {
        switch(this.type){
            case 0:
                return "legacy";
            case 1:
                return "eip-2930";
            case 2:
                return "eip-1559";
            case 3:
                return "eip-4844";
            case 4:
                return "eip-7702";
        }
        return null;
    }
    /**
     *  The ``to`` address for the transaction or ``null`` if the
     *  transaction is an ``init`` transaction.
     */ get to() {
        const value = _class_private_field_get._(this, _to);
        if (value == null && this.type === 3) {
            return addresses_js_1.ZeroAddress;
        }
        return value;
    }
    set to(value) {
        _class_private_field_set._(this, _to, value == null ? null : (0, index_js_1.getAddress)(value));
    }
    /**
     *  The transaction nonce.
     */ get nonce() {
        return _class_private_field_get._(this, _nonce);
    }
    set nonce(value) {
        _class_private_field_set._(this, _nonce, (0, index_js_3.getNumber)(value, "value"));
    }
    /**
     *  The gas limit.
     */ get gasLimit() {
        return _class_private_field_get._(this, _gasLimit);
    }
    set gasLimit(value) {
        _class_private_field_set._(this, _gasLimit, (0, index_js_3.getBigInt)(value));
    }
    /**
     *  The gas price.
     *
     *  On legacy networks this defines the fee that will be paid. On
     *  EIP-1559 networks, this should be ``null``.
     */ get gasPrice() {
        const value = _class_private_field_get._(this, _gasPrice);
        if (value == null && (this.type === 0 || this.type === 1)) {
            return BN_0;
        }
        return value;
    }
    set gasPrice(value) {
        _class_private_field_set._(this, _gasPrice, value == null ? null : (0, index_js_3.getBigInt)(value, "gasPrice"));
    }
    /**
     *  The maximum priority fee per unit of gas to pay. On legacy
     *  networks this should be ``null``.
     */ get maxPriorityFeePerGas() {
        const value = _class_private_field_get._(this, _maxPriorityFeePerGas);
        if (value == null) {
            if (this.type === 2 || this.type === 3) {
                return BN_0;
            }
            return null;
        }
        return value;
    }
    set maxPriorityFeePerGas(value) {
        _class_private_field_set._(this, _maxPriorityFeePerGas, value == null ? null : (0, index_js_3.getBigInt)(value, "maxPriorityFeePerGas"));
    }
    /**
     *  The maximum total fee per unit of gas to pay. On legacy
     *  networks this should be ``null``.
     */ get maxFeePerGas() {
        const value = _class_private_field_get._(this, _maxFeePerGas);
        if (value == null) {
            if (this.type === 2 || this.type === 3) {
                return BN_0;
            }
            return null;
        }
        return value;
    }
    set maxFeePerGas(value) {
        _class_private_field_set._(this, _maxFeePerGas, value == null ? null : (0, index_js_3.getBigInt)(value, "maxFeePerGas"));
    }
    /**
     *  The transaction data. For ``init`` transactions this is the
     *  deployment code.
     */ get data() {
        return _class_private_field_get._(this, _data);
    }
    set data(value) {
        _class_private_field_set._(this, _data, (0, index_js_3.hexlify)(value));
    }
    /**
     *  The amount of ether (in wei) to send in this transactions.
     */ get value() {
        return _class_private_field_get._(this, _value);
    }
    set value(value) {
        _class_private_field_set._(this, _value, (0, index_js_3.getBigInt)(value, "value"));
    }
    /**
     *  The chain ID this transaction is valid on.
     */ get chainId() {
        return _class_private_field_get._(this, _chainId);
    }
    set chainId(value) {
        _class_private_field_set._(this, _chainId, (0, index_js_3.getBigInt)(value));
    }
    /**
     *  If signed, the signature for this transaction.
     */ get signature() {
        return _class_private_field_get._(this, _sig) || null;
    }
    set signature(value) {
        _class_private_field_set._(this, _sig, value == null ? null : index_js_2.Signature.from(value));
    }
    /**
     *  The access list.
     *
     *  An access list permits discounted (but pre-paid) access to
     *  bytecode and state variable access within contract execution.
     */ get accessList() {
        const value = _class_private_field_get._(this, _accessList) || null;
        if (value == null) {
            if (this.type === 1 || this.type === 2 || this.type === 3) {
                // @TODO: in v7, this should assign the value or become
                // a live object itself, otherwise mutation is inconsistent
                return [];
            }
            return null;
        }
        return value;
    }
    set accessList(value) {
        _class_private_field_set._(this, _accessList, value == null ? null : (0, accesslist_js_1.accessListify)(value));
    }
    get authorizationList() {
        const value = _class_private_field_get._(this, _auths) || null;
        if (value == null) {
            if (this.type === 4) {
                // @TODO: in v7, this should become a live object itself,
                // otherwise mutation is inconsistent
                return [];
            }
        }
        return value;
    }
    set authorizationList(auths) {
        _class_private_field_set._(this, _auths, auths == null ? null : auths.map((a)=>(0, authorization_js_1.authorizationify)(a)));
    }
    /**
     *  The max fee per blob gas for Cancun transactions.
     */ get maxFeePerBlobGas() {
        const value = _class_private_field_get._(this, _maxFeePerBlobGas);
        if (value == null && this.type === 3) {
            return BN_0;
        }
        return value;
    }
    set maxFeePerBlobGas(value) {
        _class_private_field_set._(this, _maxFeePerBlobGas, value == null ? null : (0, index_js_3.getBigInt)(value, "maxFeePerBlobGas"));
    }
    /**
     *  The BLOb versioned hashes for Cancun transactions.
     */ get blobVersionedHashes() {
        // @TODO: Mutation is inconsistent; if unset, the returned value
        // cannot mutate the object, if set it can
        let value = _class_private_field_get._(this, _blobVersionedHashes);
        if (value == null && this.type === 3) {
            return [];
        }
        return value;
    }
    set blobVersionedHashes(value) {
        if (value != null) {
            (0, index_js_3.assertArgument)(Array.isArray(value), "blobVersionedHashes must be an Array", "value", value);
            value = value.slice();
            for(let i = 0; i < value.length; i++){
                (0, index_js_3.assertArgument)((0, index_js_3.isHexString)(value[i], 32), "invalid blobVersionedHash", "value[".concat(i, "]"), value[i]);
            }
        }
        _class_private_field_set._(this, _blobVersionedHashes, value);
    }
    /**
     *  The BLObs for the Transaction, if any.
     *
     *  If ``blobs`` is non-``null``, then the [[seriailized]]
     *  will return the network formatted sidecar, otherwise it
     *  will return the standard [[link-eip-2718]] payload. The
     *  [[unsignedSerialized]] is unaffected regardless.
     *
     *  When setting ``blobs``, either fully valid [[Blob]] objects
     *  may be specified (i.e. correctly padded, with correct
     *  committments and proofs) or a raw [[BytesLike]] may
     *  be provided.
     *
     *  If raw [[BytesLike]] are provided, the [[kzg]] property **must**
     *  be already set. The blob will be correctly padded and the
     *  [[KzgLibrary]] will be used to compute the committment and
     *  proof for the blob.
     *
     *  A BLOb is a sequence of field elements, each of which must
     *  be within the BLS field modulo, so some additional processing
     *  may be required to encode arbitrary data to ensure each 32 byte
     *  field is within the valid range.
     *
     *  Setting this automatically populates [[blobVersionedHashes]],
     *  overwriting any existing values. Setting this to ``null``
     *  does **not** remove the [[blobVersionedHashes]], leaving them
     *  present.
     */ get blobs() {
        if (_class_private_field_get._(this, _blobs) == null) {
            return null;
        }
        return _class_private_field_get._(this, _blobs).map((b)=>Object.assign({}, b));
    }
    set blobs(_blobs1) {
        if (_blobs1 == null) {
            _class_private_field_set._(this, _blobs, null);
            return;
        }
        const blobs = [];
        const versionedHashes = [];
        for(let i = 0; i < _blobs1.length; i++){
            const blob = _blobs1[i];
            if ((0, index_js_3.isBytesLike)(blob)) {
                (0, index_js_3.assert)(_class_private_field_get._(this, _kzg), "adding a raw blob requires a KZG library", "UNSUPPORTED_OPERATION", {
                    operation: "set blobs()"
                });
                let data = (0, index_js_3.getBytes)(blob);
                (0, index_js_3.assertArgument)(data.length <= BLOB_SIZE, "blob is too large", "blobs[".concat(i, "]"), blob);
                // Pad blob if necessary
                if (data.length !== BLOB_SIZE) {
                    const padded = new Uint8Array(BLOB_SIZE);
                    padded.set(data);
                    data = padded;
                }
                const commit = _class_private_field_get._(this, _kzg).blobToKzgCommitment(data);
                const proof = (0, index_js_3.hexlify)(_class_private_field_get._(this, _kzg).computeBlobKzgProof(data, commit));
                blobs.push({
                    data: (0, index_js_3.hexlify)(data),
                    commitment: (0, index_js_3.hexlify)(commit),
                    proof
                });
                versionedHashes.push(getVersionedHash(1, commit));
            } else {
                const commit = (0, index_js_3.hexlify)(blob.commitment);
                blobs.push({
                    data: (0, index_js_3.hexlify)(blob.data),
                    commitment: commit,
                    proof: (0, index_js_3.hexlify)(blob.proof)
                });
                versionedHashes.push(getVersionedHash(1, commit));
            }
        }
        _class_private_field_set._(this, _blobs, blobs);
        _class_private_field_set._(this, _blobVersionedHashes, versionedHashes);
    }
    get kzg() {
        return _class_private_field_get._(this, _kzg);
    }
    set kzg(kzg) {
        if (kzg == null) {
            _class_private_field_set._(this, _kzg, null);
        } else {
            _class_private_field_set._(this, _kzg, getKzgLibrary(kzg));
        }
    }
    /**
     *  The transaction hash, if signed. Otherwise, ``null``.
     */ get hash() {
        if (this.signature == null) {
            return null;
        }
        return (0, index_js_2.keccak256)(_class_private_method_get._(this, _getSerialized, getSerialized).call(this, true, false));
    }
    /**
     *  The pre-image hash of this transaction.
     *
     *  This is the digest that a [[Signer]] must sign to authorize
     *  this transaction.
     */ get unsignedHash() {
        return (0, index_js_2.keccak256)(this.unsignedSerialized);
    }
    /**
     *  The sending address, if signed. Otherwise, ``null``.
     */ get from() {
        if (this.signature == null) {
            return null;
        }
        return (0, address_js_1.recoverAddress)(this.unsignedHash, this.signature);
    }
    /**
     *  The public key of the sender, if signed. Otherwise, ``null``.
     */ get fromPublicKey() {
        if (this.signature == null) {
            return null;
        }
        return index_js_2.SigningKey.recoverPublicKey(this.unsignedHash, this.signature);
    }
    /**
     *  Returns true if signed.
     *
     *  This provides a Type Guard that properties requiring a signed
     *  transaction are non-null.
     */ isSigned() {
        return this.signature != null;
    }
    /**
     *  The serialized transaction.
     *
     *  This throws if the transaction is unsigned. For the pre-image,
     *  use [[unsignedSerialized]].
     */ get serialized() {
        return _class_private_method_get._(this, _getSerialized, getSerialized).call(this, true, true);
    }
    /**
     *  The transaction pre-image.
     *
     *  The hash of this is the digest which needs to be signed to
     *  authorize this transaction.
     */ get unsignedSerialized() {
        return _class_private_method_get._(this, _getSerialized, getSerialized).call(this, false, false);
    }
    /**
     *  Return the most "likely" type; currently the highest
     *  supported transaction type.
     */ inferType() {
        const types = this.inferTypes();
        // Prefer London (EIP-1559) over Cancun (BLOb)
        if (types.indexOf(2) >= 0) {
            return 2;
        }
        // Return the highest inferred type
        return types.pop();
    }
    /**
     *  Validates the explicit properties and returns a list of compatible
     *  transaction types.
     */ inferTypes() {
        // Checks that there are no conflicting properties set
        const hasGasPrice = this.gasPrice != null;
        const hasFee = this.maxFeePerGas != null || this.maxPriorityFeePerGas != null;
        const hasAccessList = this.accessList != null;
        const hasBlob = _class_private_field_get._(this, _maxFeePerBlobGas) != null || _class_private_field_get._(this, _blobVersionedHashes);
        //if (hasGasPrice && hasFee) {
        //    throw new Error("transaction cannot have gasPrice and maxFeePerGas");
        //}
        if (this.maxFeePerGas != null && this.maxPriorityFeePerGas != null) {
            (0, index_js_3.assert)(this.maxFeePerGas >= this.maxPriorityFeePerGas, "priorityFee cannot be more than maxFee", "BAD_DATA", {
                value: this
            });
        }
        //if (this.type === 2 && hasGasPrice) {
        //    throw new Error("eip-1559 transaction cannot have gasPrice");
        //}
        (0, index_js_3.assert)(!hasFee || this.type !== 0 && this.type !== 1, "transaction type cannot have maxFeePerGas or maxPriorityFeePerGas", "BAD_DATA", {
            value: this
        });
        (0, index_js_3.assert)(this.type !== 0 || !hasAccessList, "legacy transaction cannot have accessList", "BAD_DATA", {
            value: this
        });
        const types = [];
        // Explicit type
        if (this.type != null) {
            types.push(this.type);
        } else {
            if (this.authorizationList && this.authorizationList.length) {
                types.push(4);
            } else if (hasFee) {
                types.push(2);
            } else if (hasGasPrice) {
                types.push(1);
                if (!hasAccessList) {
                    types.push(0);
                }
            } else if (hasAccessList) {
                types.push(1);
                types.push(2);
            } else if (hasBlob && this.to) {
                types.push(3);
            } else {
                types.push(0);
                types.push(1);
                types.push(2);
                types.push(3);
            }
        }
        types.sort();
        return types;
    }
    /**
     *  Returns true if this transaction is a legacy transaction (i.e.
     *  ``type === 0``).
     *
     *  This provides a Type Guard that the related properties are
     *  non-null.
     */ isLegacy() {
        return this.type === 0;
    }
    /**
     *  Returns true if this transaction is berlin hardform transaction (i.e.
     *  ``type === 1``).
     *
     *  This provides a Type Guard that the related properties are
     *  non-null.
     */ isBerlin() {
        return this.type === 1;
    }
    /**
     *  Returns true if this transaction is london hardform transaction (i.e.
     *  ``type === 2``).
     *
     *  This provides a Type Guard that the related properties are
     *  non-null.
     */ isLondon() {
        return this.type === 2;
    }
    /**
     *  Returns true if this transaction is an [[link-eip-4844]] BLOB
     *  transaction.
     *
     *  This provides a Type Guard that the related properties are
     *  non-null.
     */ isCancun() {
        return this.type === 3;
    }
    /**
     *  Create a copy of this transaciton.
     */ clone() {
        return Transaction.from(this);
    }
    /**
     *  Return a JSON-friendly object.
     */ toJSON() {
        const s = (v)=>{
            if (v == null) {
                return null;
            }
            return v.toString();
        };
        return {
            type: this.type,
            to: this.to,
            //            from: this.from,
            data: this.data,
            nonce: this.nonce,
            gasLimit: s(this.gasLimit),
            gasPrice: s(this.gasPrice),
            maxPriorityFeePerGas: s(this.maxPriorityFeePerGas),
            maxFeePerGas: s(this.maxFeePerGas),
            value: s(this.value),
            chainId: s(this.chainId),
            sig: this.signature ? this.signature.toJSON() : null,
            accessList: this.accessList
        };
    }
    /**
     *  Create a **Transaction** from a serialized transaction or a
     *  Transaction-like object.
     */ static from(tx) {
        if (tx == null) {
            return new Transaction();
        }
        if (typeof tx === "string") {
            const payload = (0, index_js_3.getBytes)(tx);
            if (payload[0] >= 0x7f) {
                return Transaction.from(_parseLegacy(payload));
            }
            switch(payload[0]){
                case 1:
                    return Transaction.from(_parseEip2930(payload));
                case 2:
                    return Transaction.from(_parseEip1559(payload));
                case 3:
                    return Transaction.from(_parseEip4844(payload));
                case 4:
                    return Transaction.from(_parseEip7702(payload));
            }
            (0, index_js_3.assert)(false, "unsupported transaction type", "UNSUPPORTED_OPERATION", {
                operation: "from"
            });
        }
        const result = new Transaction();
        if (tx.type != null) {
            result.type = tx.type;
        }
        if (tx.to != null) {
            result.to = tx.to;
        }
        if (tx.nonce != null) {
            result.nonce = tx.nonce;
        }
        if (tx.gasLimit != null) {
            result.gasLimit = tx.gasLimit;
        }
        if (tx.gasPrice != null) {
            result.gasPrice = tx.gasPrice;
        }
        if (tx.maxPriorityFeePerGas != null) {
            result.maxPriorityFeePerGas = tx.maxPriorityFeePerGas;
        }
        if (tx.maxFeePerGas != null) {
            result.maxFeePerGas = tx.maxFeePerGas;
        }
        if (tx.maxFeePerBlobGas != null) {
            result.maxFeePerBlobGas = tx.maxFeePerBlobGas;
        }
        if (tx.data != null) {
            result.data = tx.data;
        }
        if (tx.value != null) {
            result.value = tx.value;
        }
        if (tx.chainId != null) {
            result.chainId = tx.chainId;
        }
        if (tx.signature != null) {
            result.signature = index_js_2.Signature.from(tx.signature);
        }
        if (tx.accessList != null) {
            result.accessList = tx.accessList;
        }
        if (tx.authorizationList != null) {
            result.authorizationList = tx.authorizationList;
        }
        // This will get overwritten by blobs, if present
        if (tx.blobVersionedHashes != null) {
            result.blobVersionedHashes = tx.blobVersionedHashes;
        }
        // Make sure we assign the kzg before assigning blobs, which
        // require the library in the event raw blob data is provided.
        if (tx.kzg != null) {
            result.kzg = tx.kzg;
        }
        if (tx.blobs != null) {
            result.blobs = tx.blobs;
        }
        if (tx.hash != null) {
            (0, index_js_3.assertArgument)(result.isSigned(), "unsigned transaction cannot define '.hash'", "tx", tx);
            (0, index_js_3.assertArgument)(result.hash === tx.hash, "hash mismatch", "tx", tx);
        }
        if (tx.from != null) {
            (0, index_js_3.assertArgument)(result.isSigned(), "unsigned transaction cannot define '.from'", "tx", tx);
            (0, index_js_3.assertArgument)(result.from.toLowerCase() === (tx.from || "").toLowerCase(), "from mismatch", "tx", tx);
        }
        return result;
    }
    /**
     *  Creates a new Transaction with default values.
     */ constructor(){
        _class_private_method_init._(this, _getSerialized);
        _class_private_field_init._(this, _type, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _to, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _data, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _nonce, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _gasLimit, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _gasPrice, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _maxPriorityFeePerGas, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _maxFeePerGas, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _value, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _chainId, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _sig, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _accessList, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _maxFeePerBlobGas, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _blobVersionedHashes, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _kzg, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _blobs, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _auths, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _type, null);
        _class_private_field_set._(this, _to, null);
        _class_private_field_set._(this, _nonce, 0);
        _class_private_field_set._(this, _gasLimit, BN_0);
        _class_private_field_set._(this, _gasPrice, null);
        _class_private_field_set._(this, _maxPriorityFeePerGas, null);
        _class_private_field_set._(this, _maxFeePerGas, null);
        _class_private_field_set._(this, _data, "0x");
        _class_private_field_set._(this, _value, BN_0);
        _class_private_field_set._(this, _chainId, BN_0);
        _class_private_field_set._(this, _sig, null);
        _class_private_field_set._(this, _accessList, null);
        _class_private_field_set._(this, _maxFeePerBlobGas, null);
        _class_private_field_set._(this, _blobVersionedHashes, null);
        _class_private_field_set._(this, _kzg, null);
        _class_private_field_set._(this, _blobs, null);
        _class_private_field_set._(this, _auths, null);
    }
}
function getSerialized(signed, sidecar) {
    (0, index_js_3.assert)(!signed || this.signature != null, "cannot serialize unsigned transaction; maybe you meant .unsignedSerialized", "UNSUPPORTED_OPERATION", {
        operation: ".serialized"
    });
    const sig = signed ? this.signature : null;
    switch(this.inferType()){
        case 0:
            return _serializeLegacy(this, sig);
        case 1:
            return _serializeEip2930(this, sig);
        case 2:
            return _serializeEip1559(this, sig);
        case 3:
            return _serializeEip4844(this, sig, sidecar ? this.blobs : null);
        case 4:
            return _serializeEip7702(this, sig);
    }
    (0, index_js_3.assert)(false, "unsupported transaction type", "UNSUPPORTED_OPERATION", {
        operation: ".serialized"
    });
}
exports.Transaction = Transaction; //# sourceMappingURL=transaction.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  Each state-changing operation on Ethereum requires a transaction.
 *
 *  @_section api/transaction:Transactions  [about-transactions]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Transaction = exports.recoverAddress = exports.computeAddress = exports.authorizationify = exports.accessListify = void 0;
null;
var accesslist_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/accesslist.js [app-client] (ecmascript)");
Object.defineProperty(exports, "accessListify", {
    enumerable: true,
    get: function() {
        return accesslist_js_1.accessListify;
    }
});
var authorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/authorization.js [app-client] (ecmascript)");
Object.defineProperty(exports, "authorizationify", {
    enumerable: true,
    get: function() {
        return authorization_js_1.authorizationify;
    }
});
var address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/address.js [app-client] (ecmascript)");
Object.defineProperty(exports, "computeAddress", {
    enumerable: true,
    get: function() {
        return address_js_1.computeAddress;
    }
});
Object.defineProperty(exports, "recoverAddress", {
    enumerable: true,
    get: function() {
        return address_js_1.recoverAddress;
    }
});
var transaction_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/transaction.js [app-client] (ecmascript)");
Object.defineProperty(exports, "Transaction", {
    enumerable: true,
    get: function() {
        return transaction_js_1.Transaction;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/authorization.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyAuthorization = exports.hashAuthorization = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 *  Computes the [[link-eip-7702]] authorization digest to sign.
 */ function hashAuthorization(auth) {
    (0, index_js_4.assertArgument)(typeof auth.address === "string", "invalid address for hashAuthorization", "auth.address", auth);
    return (0, index_js_2.keccak256)((0, index_js_4.concat)([
        "0x05",
        (0, index_js_4.encodeRlp)([
            auth.chainId != null ? (0, index_js_4.toBeArray)(auth.chainId) : "0x",
            (0, index_js_1.getAddress)(auth.address),
            auth.nonce != null ? (0, index_js_4.toBeArray)(auth.nonce) : "0x"
        ])
    ]));
}
exports.hashAuthorization = hashAuthorization;
/**
 *  Return the address of the private key that produced
 *  the signature %%sig%% during signing for %%message%%.
 */ function verifyAuthorization(auth, sig) {
    return (0, index_js_3.recoverAddress)(hashAuthorization(auth), sig);
}
exports.verifyAuthorization = verifyAuthorization; //# sourceMappingURL=authorization.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/id.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.id = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 *  A simple hashing function which operates on UTF-8 strings to
 *  compute an 32-byte identifier.
 *
 *  This simply computes the [UTF-8 bytes](toUtf8Bytes) and computes
 *  the [[keccak256]].
 *
 *  @example:
 *    id("hello world")
 *    //_result:
 */ function id(value) {
    return (0, index_js_1.keccak256)((0, index_js_2.toUtf8Bytes)(value));
}
exports.id = id; //# sourceMappingURL=id.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/namehash.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dnsEncode = exports.namehash = exports.isValidName = exports.ensNormalize = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const ens_normalize_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/@adraffy+ens-normalize@1.10.1/node_modules/@adraffy/ens-normalize/dist/index.cjs [app-client] (ecmascript)");
const Zeros = new Uint8Array(32);
Zeros.fill(0);
function checkComponent(comp) {
    (0, index_js_2.assertArgument)(comp.length !== 0, "invalid ENS name; empty component", "comp", comp);
    return comp;
}
function ensNameSplit(name) {
    const bytes = (0, index_js_2.toUtf8Bytes)(ensNormalize(name));
    const comps = [];
    if (name.length === 0) {
        return comps;
    }
    let last = 0;
    for(let i = 0; i < bytes.length; i++){
        const d = bytes[i];
        // A separator (i.e. "."); copy this component
        if (d === 0x2e) {
            comps.push(checkComponent(bytes.slice(last, i)));
            last = i + 1;
        }
    }
    // There was a stray separator at the end of the name
    (0, index_js_2.assertArgument)(last < bytes.length, "invalid ENS name; empty component", "name", name);
    comps.push(checkComponent(bytes.slice(last)));
    return comps;
}
/**
 *  Returns the ENS %%name%% normalized.
 */ function ensNormalize(name) {
    try {
        if (name.length === 0) {
            throw new Error("empty label");
        }
        return (0, ens_normalize_1.ens_normalize)(name);
    } catch (error) {
        (0, index_js_2.assertArgument)(false, "invalid ENS name (".concat(error.message, ")"), "name", name);
    }
}
exports.ensNormalize = ensNormalize;
/**
 *  Returns ``true`` if %%name%% is a valid ENS name.
 */ function isValidName(name) {
    try {
        return ensNameSplit(name).length !== 0;
    } catch (error) {}
    return false;
}
exports.isValidName = isValidName;
/**
 *  Returns the [[link-namehash]] for %%name%%.
 */ function namehash(name) {
    (0, index_js_2.assertArgument)(typeof name === "string", "invalid ENS name; not a string", "name", name);
    (0, index_js_2.assertArgument)(name.length, "invalid ENS name (empty label)", "name", name);
    let result = Zeros;
    const comps = ensNameSplit(name);
    while(comps.length){
        result = (0, index_js_1.keccak256)((0, index_js_2.concat)([
            result,
            (0, index_js_1.keccak256)(comps.pop())
        ]));
    }
    return (0, index_js_2.hexlify)(result);
}
exports.namehash = namehash;
/**
 *  Returns the DNS encoded %%name%%.
 *
 *  This is used for various parts of ENS name resolution, such
 *  as the wildcard resolution.
 */ function dnsEncode(name, _maxLength) {
    const length = _maxLength != null ? _maxLength : 63;
    (0, index_js_2.assertArgument)(length <= 255, "DNS encoded label cannot exceed 255", "length", length);
    return (0, index_js_2.hexlify)((0, index_js_2.concat)(ensNameSplit(name).map((comp)=>{
        (0, index_js_2.assertArgument)(comp.length <= length, "label ".concat(JSON.stringify(name), " exceeds ").concat(length, " bytes"), "name", name);
        const bytes = new Uint8Array(comp.length + 1);
        bytes.set(comp, 1);
        bytes[0] = bytes.length - 1;
        return bytes;
    }))) + "00";
}
exports.dnsEncode = dnsEncode; //# sourceMappingURL=namehash.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/message.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyMessage = exports.hashMessage = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 *  Computes the [[link-eip-191]] personal-sign message digest to sign.
 *
 *  This prefixes the message with [[MessagePrefix]] and the decimal length
 *  of %%message%% and computes the [[keccak256]] digest.
 *
 *  If %%message%% is a string, it is converted to its UTF-8 bytes
 *  first. To compute the digest of a [[DataHexString]], it must be converted
 *  to [bytes](getBytes).
 *
 *  @example:
 *    hashMessage("Hello World")
 *    //_result:
 *
 *    // Hashes the SIX (6) string characters, i.e.
 *    // [ "0", "x", "4", "2", "4", "3" ]
 *    hashMessage("0x4243")
 *    //_result:
 *
 *    // Hashes the TWO (2) bytes [ 0x42, 0x43 ]...
 *    hashMessage(getBytes("0x4243"))
 *    //_result:
 *
 *    // ...which is equal to using data
 *    hashMessage(new Uint8Array([ 0x42, 0x43 ]))
 *    //_result:
 *
 */ function hashMessage(message) {
    if (typeof message === "string") {
        message = (0, index_js_4.toUtf8Bytes)(message);
    }
    return (0, index_js_1.keccak256)((0, index_js_4.concat)([
        (0, index_js_4.toUtf8Bytes)(index_js_2.MessagePrefix),
        (0, index_js_4.toUtf8Bytes)(String(message.length)),
        message
    ]));
}
exports.hashMessage = hashMessage;
/**
 *  Return the address of the private key that produced
 *  the signature %%sig%% during signing for %%message%%.
 */ function verifyMessage(message, sig) {
    const digest = hashMessage(message);
    return (0, index_js_3.recoverAddress)(digest, sig);
}
exports.verifyMessage = verifyMessage; //# sourceMappingURL=message.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/solidity.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.solidityPackedSha256 = exports.solidityPackedKeccak256 = exports.solidityPacked = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const regexBytes = new RegExp("^bytes([0-9]+)$");
const regexNumber = new RegExp("^(u?int)([0-9]*)$");
const regexArray = new RegExp("^(.*)\\[([0-9]*)\\]$");
function _pack(type, value, isArray) {
    switch(type){
        case "address":
            if (isArray) {
                return (0, index_js_3.getBytes)((0, index_js_3.zeroPadValue)(value, 32));
            }
            return (0, index_js_3.getBytes)((0, index_js_1.getAddress)(value));
        case "string":
            return (0, index_js_3.toUtf8Bytes)(value);
        case "bytes":
            return (0, index_js_3.getBytes)(value);
        case "bool":
            value = !!value ? "0x01" : "0x00";
            if (isArray) {
                return (0, index_js_3.getBytes)((0, index_js_3.zeroPadValue)(value, 32));
            }
            return (0, index_js_3.getBytes)(value);
    }
    let match = type.match(regexNumber);
    if (match) {
        let signed = match[1] === "int";
        let size = parseInt(match[2] || "256");
        (0, index_js_3.assertArgument)((!match[2] || match[2] === String(size)) && size % 8 === 0 && size !== 0 && size <= 256, "invalid number type", "type", type);
        if (isArray) {
            size = 256;
        }
        if (signed) {
            value = (0, index_js_3.toTwos)(value, size);
        }
        return (0, index_js_3.getBytes)((0, index_js_3.zeroPadValue)((0, index_js_3.toBeArray)(value), size / 8));
    }
    match = type.match(regexBytes);
    if (match) {
        const size = parseInt(match[1]);
        (0, index_js_3.assertArgument)(String(size) === match[1] && size !== 0 && size <= 32, "invalid bytes type", "type", type);
        (0, index_js_3.assertArgument)((0, index_js_3.dataLength)(value) === size, "invalid value for ".concat(type), "value", value);
        if (isArray) {
            return (0, index_js_3.getBytes)((0, index_js_3.zeroPadBytes)(value, 32));
        }
        return value;
    }
    match = type.match(regexArray);
    if (match && Array.isArray(value)) {
        const baseType = match[1];
        const count = parseInt(match[2] || String(value.length));
        (0, index_js_3.assertArgument)(count === value.length, "invalid array length for ".concat(type), "value", value);
        const result = [];
        value.forEach(function(value) {
            result.push(_pack(baseType, value, true));
        });
        return (0, index_js_3.getBytes)((0, index_js_3.concat)(result));
    }
    (0, index_js_3.assertArgument)(false, "invalid type", "type", type);
}
// @TODO: Array Enum
/**
 *   Computes the [[link-solc-packed]] representation of %%values%%
 *   respectively to their %%types%%.
 *
 *   @example:
 *       addr = "0x8ba1f109551bd432803012645ac136ddd64dba72"
 *       solidityPacked([ "address", "uint" ], [ addr, 45 ]);
 *       //_result:
 */ function solidityPacked(types, values) {
    (0, index_js_3.assertArgument)(types.length === values.length, "wrong number of values; expected ${ types.length }", "values", values);
    const tight = [];
    types.forEach(function(type, index) {
        tight.push(_pack(type, values[index]));
    });
    return (0, index_js_3.hexlify)((0, index_js_3.concat)(tight));
}
exports.solidityPacked = solidityPacked;
/**
 *   Computes the [[link-solc-packed]] [[keccak256]] hash of %%values%%
 *   respectively to their %%types%%.
 *
 *   @example:
 *       addr = "0x8ba1f109551bd432803012645ac136ddd64dba72"
 *       solidityPackedKeccak256([ "address", "uint" ], [ addr, 45 ]);
 *       //_result:
 */ function solidityPackedKeccak256(types, values) {
    return (0, index_js_2.keccak256)(solidityPacked(types, values));
}
exports.solidityPackedKeccak256 = solidityPackedKeccak256;
/**
 *   Computes the [[link-solc-packed]] [[sha256]] hash of %%values%%
 *   respectively to their %%types%%.
 *
 *   @example:
 *       addr = "0x8ba1f109551bd432803012645ac136ddd64dba72"
 *       solidityPackedSha256([ "address", "uint" ], [ addr, 45 ]);
 *       //_result:
 */ function solidityPackedSha256(types, values) {
    return (0, index_js_2.sha256)(solidityPacked(types, values));
}
exports.solidityPackedSha256 = solidityPackedSha256; //# sourceMappingURL=solidity.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/typed-data.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyTypedData = exports.TypedDataEncoder = void 0;
//import { TypedDataDomain, TypedDataField } from "@ethersproject/providerabstract-signer";
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const id_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/id.js [app-client] (ecmascript)");
const padding = new Uint8Array(32);
padding.fill(0);
const BN__1 = BigInt(-1);
const BN_0 = BigInt(0);
const BN_1 = BigInt(1);
const BN_MAX_UINT256 = BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
;
;
function hexPadRight(value) {
    const bytes = (0, index_js_4.getBytes)(value);
    const padOffset = bytes.length % 32;
    if (padOffset) {
        return (0, index_js_4.concat)([
            bytes,
            padding.slice(padOffset)
        ]);
    }
    return (0, index_js_4.hexlify)(bytes);
}
const hexTrue = (0, index_js_4.toBeHex)(BN_1, 32);
const hexFalse = (0, index_js_4.toBeHex)(BN_0, 32);
const domainFieldTypes = {
    name: "string",
    version: "string",
    chainId: "uint256",
    verifyingContract: "address",
    salt: "bytes32"
};
const domainFieldNames = [
    "name",
    "version",
    "chainId",
    "verifyingContract",
    "salt"
];
function checkString(key) {
    return function(value) {
        (0, index_js_4.assertArgument)(typeof value === "string", "invalid domain value for ".concat(JSON.stringify(key)), "domain.".concat(key), value);
        return value;
    };
}
const domainChecks = {
    name: checkString("name"),
    version: checkString("version"),
    chainId: function(_value) {
        const value = (0, index_js_4.getBigInt)(_value, "domain.chainId");
        (0, index_js_4.assertArgument)(value >= 0, "invalid chain ID", "domain.chainId", _value);
        if (Number.isSafeInteger(value)) {
            return Number(value);
        }
        return (0, index_js_4.toQuantity)(value);
    },
    verifyingContract: function(value) {
        try {
            return (0, index_js_1.getAddress)(value).toLowerCase();
        } catch (error) {}
        (0, index_js_4.assertArgument)(false, 'invalid domain value "verifyingContract"', "domain.verifyingContract", value);
    },
    salt: function(value) {
        const bytes = (0, index_js_4.getBytes)(value, "domain.salt");
        (0, index_js_4.assertArgument)(bytes.length === 32, 'invalid domain value "salt"', "domain.salt", value);
        return (0, index_js_4.hexlify)(bytes);
    }
};
function getBaseEncoder(type) {
    // intXX and uintXX
    {
        const match = type.match(/^(u?)int(\d+)$/);
        if (match) {
            const signed = match[1] === "";
            const width = parseInt(match[2]);
            (0, index_js_4.assertArgument)(width % 8 === 0 && width !== 0 && width <= 256 && match[2] === String(width), "invalid numeric width", "type", type);
            const boundsUpper = (0, index_js_4.mask)(BN_MAX_UINT256, signed ? width - 1 : width);
            const boundsLower = signed ? (boundsUpper + BN_1) * BN__1 : BN_0;
            return function(_value) {
                const value = (0, index_js_4.getBigInt)(_value, "value");
                (0, index_js_4.assertArgument)(value >= boundsLower && value <= boundsUpper, "value out-of-bounds for ".concat(type), "value", value);
                return (0, index_js_4.toBeHex)(signed ? (0, index_js_4.toTwos)(value, 256) : value, 32);
            };
        }
    }
    // bytesXX
    {
        const match = type.match(/^bytes(\d+)$/);
        if (match) {
            const width = parseInt(match[1]);
            (0, index_js_4.assertArgument)(width !== 0 && width <= 32 && match[1] === String(width), "invalid bytes width", "type", type);
            return function(value) {
                const bytes = (0, index_js_4.getBytes)(value);
                (0, index_js_4.assertArgument)(bytes.length === width, "invalid length for ".concat(type), "value", value);
                return hexPadRight(value);
            };
        }
    }
    switch(type){
        case "address":
            return function(value) {
                return (0, index_js_4.zeroPadValue)((0, index_js_1.getAddress)(value), 32);
            };
        case "bool":
            return function(value) {
                return !value ? hexFalse : hexTrue;
            };
        case "bytes":
            return function(value) {
                return (0, index_js_2.keccak256)(value);
            };
        case "string":
            return function(value) {
                return (0, id_js_1.id)(value);
            };
    }
    return null;
}
function encodeType(name, fields) {
    return "".concat(name, "(").concat(fields.map((param)=>{
        let { name, type } = param;
        return type + " " + name;
    }).join(","), ")");
}
// foo[][3] => { base: "foo", index: "[][3]", array: {
//     base: "foo", prefix: "foo[]", count: 3 } }
function splitArray(type) {
    const match = type.match(/^([^\x5b]*)((\x5b\d*\x5d)*)(\x5b(\d*)\x5d)$/);
    if (match) {
        return {
            base: match[1],
            index: match[2] + match[4],
            array: {
                base: match[1],
                prefix: match[1] + match[2],
                count: match[5] ? parseInt(match[5]) : -1
            }
        };
    }
    return {
        base: type
    };
}
var _types = /*#__PURE__*/ new WeakMap(), _fullTypes = /*#__PURE__*/ new WeakMap(), _encoderCache = /*#__PURE__*/ new WeakMap(), _getEncoder = /*#__PURE__*/ new WeakSet();
/**
 *  A **TypedDataEncode** prepares and encodes [[link-eip-712]] payloads
 *  for signed typed data.
 *
 *  This is useful for those that wish to compute various components of a
 *  typed data hash, primary types, or sub-components, but generally the
 *  higher level [[Signer-signTypedData]] is more useful.
 */ class TypedDataEncoder {
    /**
     *  The types.
     */ get types() {
        return JSON.parse(_class_private_field_get._(this, _types));
    }
    /**
     *  Returnthe encoder for the specific %%type%%.
     */ getEncoder(type) {
        let encoder = _class_private_field_get._(this, _encoderCache).get(type);
        if (!encoder) {
            encoder = _class_private_method_get._(this, _getEncoder, getEncoder).call(this, type);
            _class_private_field_get._(this, _encoderCache).set(type, encoder);
        }
        return encoder;
    }
    /**
     *  Return the full type for %%name%%.
     */ encodeType(name) {
        const result = _class_private_field_get._(this, _fullTypes).get(name);
        (0, index_js_4.assertArgument)(result, "unknown type: ".concat(JSON.stringify(name)), "name", name);
        return result;
    }
    /**
     *  Return the encoded %%value%% for the %%type%%.
     */ encodeData(type, value) {
        return this.getEncoder(type)(value);
    }
    /**
     *  Returns the hash of %%value%% for the type of %%name%%.
     */ hashStruct(name, value) {
        return (0, index_js_2.keccak256)(this.encodeData(name, value));
    }
    /**
     *  Return the fulled encoded %%value%% for the [[types]].
     */ encode(value) {
        return this.encodeData(this.primaryType, value);
    }
    /**
     *  Return the hash of the fully encoded %%value%% for the [[types]].
     */ hash(value) {
        return this.hashStruct(this.primaryType, value);
    }
    /**
     *  @_ignore:
     */ _visit(type, value, callback) {
        // Basic encoder type (address, bool, uint256, etc)
        {
            const encoder = getBaseEncoder(type);
            if (encoder) {
                return callback(type, value);
            }
        }
        // Array
        const array = splitArray(type).array;
        if (array) {
            (0, index_js_4.assertArgument)(array.count === -1 || array.count === value.length, "array length mismatch; expected length ".concat(array.count), "value", value);
            return value.map((v)=>this._visit(array.prefix, v, callback));
        }
        // Struct
        const fields = this.types[type];
        if (fields) {
            return fields.reduce((accum, param)=>{
                let { name, type } = param;
                accum[name] = this._visit(type, value[name], callback);
                return accum;
            }, {});
        }
        (0, index_js_4.assertArgument)(false, "unknown type: ".concat(type), "type", type);
    }
    /**
     *  Call %%calback%% for each value in %%value%%, passing the type and
     *  component within %%value%%.
     *
     *  This is useful for replacing addresses or other transformation that
     *  may be desired on each component, based on its type.
     */ visit(value, callback) {
        return this._visit(this.primaryType, value, callback);
    }
    /**
     *  Create a new **TypedDataEncoder** for %%types%%.
     */ static from(types) {
        return new TypedDataEncoder(types);
    }
    /**
     *  Return the primary type for %%types%%.
     */ static getPrimaryType(types) {
        return TypedDataEncoder.from(types).primaryType;
    }
    /**
     *  Return the hashed struct for %%value%% using %%types%% and %%name%%.
     */ static hashStruct(name, types, value) {
        return TypedDataEncoder.from(types).hashStruct(name, value);
    }
    /**
     *  Return the domain hash for %%domain%%.
     */ static hashDomain(domain) {
        const domainFields = [];
        for(const name in domain){
            if (domain[name] == null) {
                continue;
            }
            const type = domainFieldTypes[name];
            (0, index_js_4.assertArgument)(type, "invalid typed-data domain key: ".concat(JSON.stringify(name)), "domain", domain);
            domainFields.push({
                name,
                type
            });
        }
        domainFields.sort((a, b)=>{
            return domainFieldNames.indexOf(a.name) - domainFieldNames.indexOf(b.name);
        });
        return TypedDataEncoder.hashStruct("EIP712Domain", {
            EIP712Domain: domainFields
        }, domain);
    }
    /**
     *  Return the fully encoded [[link-eip-712]] %%value%% for %%types%% with %%domain%%.
     */ static encode(domain, types, value) {
        return (0, index_js_4.concat)([
            "0x1901",
            TypedDataEncoder.hashDomain(domain),
            TypedDataEncoder.from(types).hash(value)
        ]);
    }
    /**
     *  Return the hash of the fully encoded [[link-eip-712]] %%value%% for %%types%% with %%domain%%.
     */ static hash(domain, types, value) {
        return (0, index_js_2.keccak256)(TypedDataEncoder.encode(domain, types, value));
    }
    // Replaces all address types with ENS names with their looked up address
    /**
     * Resolves to the value from resolving all addresses in %%value%% for
     * %%types%% and the %%domain%%.
     */ static async resolveNames(domain, types, value, resolveName) {
        // Make a copy to isolate it from the object passed in
        domain = Object.assign({}, domain);
        // Allow passing null to ignore value
        for(const key in domain){
            if (domain[key] == null) {
                delete domain[key];
            }
        }
        // Look up all ENS names
        const ensCache = {};
        // Do we need to look up the domain's verifyingContract?
        if (domain.verifyingContract && !(0, index_js_4.isHexString)(domain.verifyingContract, 20)) {
            ensCache[domain.verifyingContract] = "0x";
        }
        // We are going to use the encoder to visit all the base values
        const encoder = TypedDataEncoder.from(types);
        // Get a list of all the addresses
        encoder.visit(value, (type, value)=>{
            if (type === "address" && !(0, index_js_4.isHexString)(value, 20)) {
                ensCache[value] = "0x";
            }
            return value;
        });
        // Lookup each name
        for(const name in ensCache){
            ensCache[name] = await resolveName(name);
        }
        // Replace the domain verifyingContract if needed
        if (domain.verifyingContract && ensCache[domain.verifyingContract]) {
            domain.verifyingContract = ensCache[domain.verifyingContract];
        }
        // Replace all ENS names with their address
        value = encoder.visit(value, (type, value)=>{
            if (type === "address" && ensCache[value]) {
                return ensCache[value];
            }
            return value;
        });
        return {
            domain,
            value
        };
    }
    /**
     *  Returns the JSON-encoded payload expected by nodes which implement
     *  the JSON-RPC [[link-eip-712]] method.
     */ static getPayload(domain, types, value) {
        // Validate the domain fields
        TypedDataEncoder.hashDomain(domain);
        // Derive the EIP712Domain Struct reference type
        const domainValues = {};
        const domainTypes = [];
        domainFieldNames.forEach((name)=>{
            const value = domain[name];
            if (value == null) {
                return;
            }
            domainValues[name] = domainChecks[name](value);
            domainTypes.push({
                name,
                type: domainFieldTypes[name]
            });
        });
        const encoder = TypedDataEncoder.from(types);
        // Get the normalized types
        types = encoder.types;
        const typesWithDomain = Object.assign({}, types);
        (0, index_js_4.assertArgument)(typesWithDomain.EIP712Domain == null, "types must not contain EIP712Domain type", "types.EIP712Domain", types);
        typesWithDomain.EIP712Domain = domainTypes;
        // Validate the data structures and types
        encoder.encode(value);
        return {
            types: typesWithDomain,
            domain: domainValues,
            primaryType: encoder.primaryType,
            message: encoder.visit(value, (type, value)=>{
                // bytes
                if (type.match(/^bytes(\d*)/)) {
                    return (0, index_js_4.hexlify)((0, index_js_4.getBytes)(value));
                }
                // uint or int
                if (type.match(/^u?int/)) {
                    return (0, index_js_4.getBigInt)(value).toString();
                }
                switch(type){
                    case "address":
                        return value.toLowerCase();
                    case "bool":
                        return !!value;
                    case "string":
                        (0, index_js_4.assertArgument)(typeof value === "string", "invalid string", "value", value);
                        return value;
                }
                (0, index_js_4.assertArgument)(false, "unsupported type", "type", type);
            })
        };
    }
    /**
     *  Create a new **TypedDataEncoder** for %%types%%.
     *
     *  This performs all necessary checking that types are valid and
     *  do not violate the [[link-eip-712]] structural constraints as
     *  well as computes the [[primaryType]].
     */ constructor(_types1){
        _class_private_method_init._(this, _getEncoder);
        /**
     *  The primary type for the structured [[types]].
     *
     *  This is derived automatically from the [[types]], since no
     *  recursion is possible, once the DAG for the types is consturcted
     *  internally, the primary type must be the only remaining type with
     *  no parent nodes.
     */ _define_property._(this, "primaryType", void 0);
        _class_private_field_init._(this, _types, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _fullTypes, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _encoderCache, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _fullTypes, new Map());
        _class_private_field_set._(this, _encoderCache, new Map());
        // Link struct types to their direct child structs
        const links = new Map();
        // Link structs to structs which contain them as a child
        const parents = new Map();
        // Link all subtypes within a given struct
        const subtypes = new Map();
        const types = {};
        Object.keys(_types1).forEach((type)=>{
            types[type] = _types1[type].map((param)=>{
                let { name, type } = param;
                // Normalize the base type (unless name conflict)
                let { base, index } = splitArray(type);
                if (base === "int" && !_types1["int"]) {
                    base = "int256";
                }
                if (base === "uint" && !_types1["uint"]) {
                    base = "uint256";
                }
                return {
                    name,
                    type: base + (index || "")
                };
            });
            links.set(type, new Set());
            parents.set(type, []);
            subtypes.set(type, new Set());
        });
        _class_private_field_set._(this, _types, JSON.stringify(types));
        for(const name in types){
            const uniqueNames = new Set();
            for (const field of types[name]){
                // Check each field has a unique name
                (0, index_js_4.assertArgument)(!uniqueNames.has(field.name), "duplicate variable name ".concat(JSON.stringify(field.name), " in ").concat(JSON.stringify(name)), "types", _types1);
                uniqueNames.add(field.name);
                // Get the base type (drop any array specifiers)
                const baseType = splitArray(field.type).base;
                (0, index_js_4.assertArgument)(baseType !== name, "circular type reference to ".concat(JSON.stringify(baseType)), "types", _types1);
                // Is this a base encoding type?
                const encoder = getBaseEncoder(baseType);
                if (encoder) {
                    continue;
                }
                (0, index_js_4.assertArgument)(parents.has(baseType), "unknown type ".concat(JSON.stringify(baseType)), "types", _types1);
                // Add linkage
                parents.get(baseType).push(name);
                links.get(name).add(baseType);
            }
        }
        // Deduce the primary type
        const primaryTypes = Array.from(parents.keys()).filter((n)=>parents.get(n).length === 0);
        (0, index_js_4.assertArgument)(primaryTypes.length !== 0, "missing primary type", "types", _types1);
        (0, index_js_4.assertArgument)(primaryTypes.length === 1, "ambiguous primary types or unused types: ".concat(primaryTypes.map((t)=>JSON.stringify(t)).join(", ")), "types", _types1);
        (0, index_js_4.defineProperties)(this, {
            primaryType: primaryTypes[0]
        });
        // Check for circular type references
        function checkCircular(type, found) {
            (0, index_js_4.assertArgument)(!found.has(type), "circular type reference to ".concat(JSON.stringify(type)), "types", _types1);
            found.add(type);
            for (const child of links.get(type)){
                if (!parents.has(child)) {
                    continue;
                }
                // Recursively check children
                checkCircular(child, found);
                // Mark all ancestors as having this decendant
                for (const subtype of found){
                    subtypes.get(subtype).add(child);
                }
            }
            found.delete(type);
        }
        checkCircular(this.primaryType, new Set());
        // Compute each fully describe type
        for (const [name, set] of subtypes){
            const st = Array.from(set);
            st.sort();
            _class_private_field_get._(this, _fullTypes).set(name, encodeType(name, types[name]) + st.map((t)=>encodeType(t, types[t])).join(""));
        }
    }
}
function getEncoder(type) {
    // Basic encoder type (address, bool, uint256, etc)
    {
        const encoder = getBaseEncoder(type);
        if (encoder) {
            return encoder;
        }
    }
    // Array
    const array = splitArray(type).array;
    if (array) {
        const subtype = array.prefix;
        const subEncoder = this.getEncoder(subtype);
        return (value)=>{
            (0, index_js_4.assertArgument)(array.count === -1 || array.count === value.length, "array length mismatch; expected length ".concat(array.count), "value", value);
            let result = value.map(subEncoder);
            if (_class_private_field_get._(this, _fullTypes).has(subtype)) {
                result = result.map(index_js_2.keccak256);
            }
            return (0, index_js_2.keccak256)((0, index_js_4.concat)(result));
        };
    }
    // Struct
    const fields = this.types[type];
    if (fields) {
        const encodedType = (0, id_js_1.id)(_class_private_field_get._(this, _fullTypes).get(type));
        return (value)=>{
            const values = fields.map((param)=>{
                let { name, type } = param;
                const result = this.getEncoder(type)(value[name]);
                if (_class_private_field_get._(this, _fullTypes).has(type)) {
                    return (0, index_js_2.keccak256)(result);
                }
                return result;
            });
            values.unshift(encodedType);
            return (0, index_js_4.concat)(values);
        };
    }
    (0, index_js_4.assertArgument)(false, "unknown type: ".concat(type), "type", type);
}
exports.TypedDataEncoder = TypedDataEncoder;
/**
 *  Compute the address used to sign the typed data for the %%signature%%.
 */ function verifyTypedData(domain, types, value, signature) {
    return (0, index_js_3.recoverAddress)(TypedDataEncoder.hash(domain, types, value), signature);
}
exports.verifyTypedData = verifyTypedData; //# sourceMappingURL=typed-data.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  Utilities for common tasks involving hashing. Also see
 *  [cryptographic hashing](about-crypto-hashing).
 *
 *  @_section: api/hashing:Hashing Utilities  [about-hashing]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.verifyTypedData = exports.TypedDataEncoder = exports.solidityPackedSha256 = exports.solidityPackedKeccak256 = exports.solidityPacked = exports.verifyMessage = exports.hashMessage = exports.dnsEncode = exports.namehash = exports.isValidName = exports.ensNormalize = exports.id = exports.verifyAuthorization = exports.hashAuthorization = void 0;
var authorization_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/authorization.js [app-client] (ecmascript)");
Object.defineProperty(exports, "hashAuthorization", {
    enumerable: true,
    get: function() {
        return authorization_js_1.hashAuthorization;
    }
});
Object.defineProperty(exports, "verifyAuthorization", {
    enumerable: true,
    get: function() {
        return authorization_js_1.verifyAuthorization;
    }
});
var id_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/id.js [app-client] (ecmascript)");
Object.defineProperty(exports, "id", {
    enumerable: true,
    get: function() {
        return id_js_1.id;
    }
});
var namehash_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/namehash.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ensNormalize", {
    enumerable: true,
    get: function() {
        return namehash_js_1.ensNormalize;
    }
});
Object.defineProperty(exports, "isValidName", {
    enumerable: true,
    get: function() {
        return namehash_js_1.isValidName;
    }
});
Object.defineProperty(exports, "namehash", {
    enumerable: true,
    get: function() {
        return namehash_js_1.namehash;
    }
});
Object.defineProperty(exports, "dnsEncode", {
    enumerable: true,
    get: function() {
        return namehash_js_1.dnsEncode;
    }
});
var message_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/message.js [app-client] (ecmascript)");
Object.defineProperty(exports, "hashMessage", {
    enumerable: true,
    get: function() {
        return message_js_1.hashMessage;
    }
});
Object.defineProperty(exports, "verifyMessage", {
    enumerable: true,
    get: function() {
        return message_js_1.verifyMessage;
    }
});
var solidity_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/solidity.js [app-client] (ecmascript)");
Object.defineProperty(exports, "solidityPacked", {
    enumerable: true,
    get: function() {
        return solidity_js_1.solidityPacked;
    }
});
Object.defineProperty(exports, "solidityPackedKeccak256", {
    enumerable: true,
    get: function() {
        return solidity_js_1.solidityPackedKeccak256;
    }
});
Object.defineProperty(exports, "solidityPackedSha256", {
    enumerable: true,
    get: function() {
        return solidity_js_1.solidityPackedSha256;
    }
});
var typed_data_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/typed-data.js [app-client] (ecmascript)");
Object.defineProperty(exports, "TypedDataEncoder", {
    enumerable: true,
    get: function() {
        return typed_data_js_1.TypedDataEncoder;
    }
});
Object.defineProperty(exports, "verifyTypedData", {
    enumerable: true,
    get: function() {
        return typed_data_js_1.verifyTypedData;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/fragments.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_field_update = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_update.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  A fragment is a single item from an ABI, which may represent any of:
 *
 *  - [Functions](FunctionFragment)
 *  - [Events](EventFragment)
 *  - [Constructors](ConstructorFragment)
 *  - Custom [Errors](ErrorFragment)
 *  - [Fallback or Receive](FallbackFragment) functions
 *
 *  @_subsection api/abi/abi-coder:Fragments  [about-fragments]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.StructFragment = exports.FunctionFragment = exports.FallbackFragment = exports.ConstructorFragment = exports.EventFragment = exports.ErrorFragment = exports.NamedFragment = exports.Fragment = exports.ParamType = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
;
// [ "a", "b" ] => { "a": 1, "b": 1 }
function setify(items) {
    const result = new Set();
    items.forEach((k)=>result.add(k));
    return Object.freeze(result);
}
const _kwVisibDeploy = "external public payable override";
const KwVisibDeploy = setify(_kwVisibDeploy.split(" "));
// Visibility Keywords
const _kwVisib = "constant external internal payable private public pure view override";
const KwVisib = setify(_kwVisib.split(" "));
const _kwTypes = "constructor error event fallback function receive struct";
const KwTypes = setify(_kwTypes.split(" "));
const _kwModifiers = "calldata memory storage payable indexed";
const KwModifiers = setify(_kwModifiers.split(" "));
const _kwOther = "tuple returns";
// All Keywords
const _keywords = [
    _kwTypes,
    _kwModifiers,
    _kwOther,
    _kwVisib
].join(" ");
const Keywords = setify(_keywords.split(" "));
// Single character tokens
const SimpleTokens = {
    "(": "OPEN_PAREN",
    ")": "CLOSE_PAREN",
    "[": "OPEN_BRACKET",
    "]": "CLOSE_BRACKET",
    ",": "COMMA",
    "@": "AT"
};
// Parser regexes to consume the next token
const regexWhitespacePrefix = new RegExp("^(\\s*)");
const regexNumberPrefix = new RegExp("^([0-9]+)");
const regexIdPrefix = new RegExp("^([a-zA-Z$_][a-zA-Z0-9$_]*)");
// Parser regexs to check validity
const regexId = new RegExp("^([a-zA-Z$_][a-zA-Z0-9$_]*)$");
const regexType = new RegExp("^(address|bool|bytes([0-9]*)|string|u?int([0-9]*))$");
var _offset = /*#__PURE__*/ new WeakMap(), _tokens = /*#__PURE__*/ new WeakMap(), _subTokenString = /*#__PURE__*/ new WeakSet();
class TokenString {
    get offset() {
        return _class_private_field_get._(this, _offset);
    }
    get length() {
        return _class_private_field_get._(this, _tokens).length - _class_private_field_get._(this, _offset);
    }
    clone() {
        return new TokenString(_class_private_field_get._(this, _tokens));
    }
    reset() {
        _class_private_field_set._(this, _offset, 0);
    }
    // Pops and returns the value of the next token, if it is a keyword in allowed; throws if out of tokens
    popKeyword(allowed) {
        const top = this.peek();
        if (top.type !== "KEYWORD" || !allowed.has(top.text)) {
            throw new Error("expected keyword ".concat(top.text));
        }
        return this.pop().text;
    }
    // Pops and returns the value of the next token if it is `type`; throws if out of tokens
    popType(type) {
        if (this.peek().type !== type) {
            const top = this.peek();
            throw new Error("expected ".concat(type, "; got ").concat(top.type, " ").concat(JSON.stringify(top.text)));
        }
        return this.pop().text;
    }
    // Pops and returns a "(" TOKENS ")"
    popParen() {
        const top = this.peek();
        if (top.type !== "OPEN_PAREN") {
            throw new Error("bad start");
        }
        const result = _class_private_method_get._(this, _subTokenString, subTokenString).call(this, _class_private_field_get._(this, _offset) + 1, top.match + 1);
        _class_private_field_set._(this, _offset, top.match + 1);
        return result;
    }
    // Pops and returns the items within "(" ITEM1 "," ITEM2 "," ... ")"
    popParams() {
        const top = this.peek();
        if (top.type !== "OPEN_PAREN") {
            throw new Error("bad start");
        }
        const result = [];
        while(_class_private_field_get._(this, _offset) < top.match - 1){
            const link = this.peek().linkNext;
            result.push(_class_private_method_get._(this, _subTokenString, subTokenString).call(this, _class_private_field_get._(this, _offset) + 1, link));
            _class_private_field_set._(this, _offset, link);
        }
        _class_private_field_set._(this, _offset, top.match + 1);
        return result;
    }
    // Returns the top Token, throwing if out of tokens
    peek() {
        if (_class_private_field_get._(this, _offset) >= _class_private_field_get._(this, _tokens).length) {
            throw new Error("out-of-bounds");
        }
        return _class_private_field_get._(this, _tokens)[_class_private_field_get._(this, _offset)];
    }
    // Returns the next value, if it is a keyword in `allowed`
    peekKeyword(allowed) {
        const top = this.peekType("KEYWORD");
        return top != null && allowed.has(top) ? top : null;
    }
    // Returns the value of the next token if it is `type`
    peekType(type) {
        if (this.length === 0) {
            return null;
        }
        const top = this.peek();
        return top.type === type ? top.text : null;
    }
    // Returns the next token; throws if out of tokens
    pop() {
        const result = this.peek();
        _class_private_field_update._(this, _offset).value++;
        return result;
    }
    toString() {
        const tokens = [];
        for(let i = _class_private_field_get._(this, _offset); i < _class_private_field_get._(this, _tokens).length; i++){
            const token = _class_private_field_get._(this, _tokens)[i];
            tokens.push("".concat(token.type, ":").concat(token.text));
        }
        return "<TokenString ".concat(tokens.join(" "), ">");
    }
    constructor(tokens){
        _class_private_method_init._(this, _subTokenString);
        _class_private_field_init._(this, _offset, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _tokens, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _offset, 0);
        _class_private_field_set._(this, _tokens, tokens.slice());
    }
}
function subTokenString() {
    let from = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 0, to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0;
    return new TokenString(_class_private_field_get._(this, _tokens).slice(from, to).map((t)=>{
        return Object.freeze(Object.assign({}, t, {
            match: t.match - from,
            linkBack: t.linkBack - from,
            linkNext: t.linkNext - from
        }));
    }));
}
function lex(text) {
    const tokens = [];
    const throwError = (message)=>{
        const token = offset < text.length ? JSON.stringify(text[offset]) : "$EOI";
        throw new Error("invalid token ".concat(token, " at ").concat(offset, ": ").concat(message));
    };
    let brackets = [];
    let commas = [];
    let offset = 0;
    while(offset < text.length){
        // Strip off any leading whitespace
        let cur = text.substring(offset);
        let match = cur.match(regexWhitespacePrefix);
        if (match) {
            offset += match[1].length;
            cur = text.substring(offset);
        }
        const token = {
            depth: brackets.length,
            linkBack: -1,
            linkNext: -1,
            match: -1,
            type: "",
            text: "",
            offset,
            value: -1
        };
        tokens.push(token);
        let type = SimpleTokens[cur[0]] || "";
        if (type) {
            token.type = type;
            token.text = cur[0];
            offset++;
            if (type === "OPEN_PAREN") {
                brackets.push(tokens.length - 1);
                commas.push(tokens.length - 1);
            } else if (type == "CLOSE_PAREN") {
                if (brackets.length === 0) {
                    throwError("no matching open bracket");
                }
                token.match = brackets.pop();
                tokens[token.match].match = tokens.length - 1;
                token.depth--;
                token.linkBack = commas.pop();
                tokens[token.linkBack].linkNext = tokens.length - 1;
            } else if (type === "COMMA") {
                token.linkBack = commas.pop();
                tokens[token.linkBack].linkNext = tokens.length - 1;
                commas.push(tokens.length - 1);
            } else if (type === "OPEN_BRACKET") {
                token.type = "BRACKET";
            } else if (type === "CLOSE_BRACKET") {
                // Remove the CLOSE_BRACKET
                let suffix = tokens.pop().text;
                if (tokens.length > 0 && tokens[tokens.length - 1].type === "NUMBER") {
                    const value = tokens.pop().text;
                    suffix = value + suffix;
                    tokens[tokens.length - 1].value = (0, index_js_1.getNumber)(value);
                }
                if (tokens.length === 0 || tokens[tokens.length - 1].type !== "BRACKET") {
                    throw new Error("missing opening bracket");
                }
                tokens[tokens.length - 1].text += suffix;
            }
            continue;
        }
        match = cur.match(regexIdPrefix);
        if (match) {
            token.text = match[1];
            offset += token.text.length;
            if (Keywords.has(token.text)) {
                token.type = "KEYWORD";
                continue;
            }
            if (token.text.match(regexType)) {
                token.type = "TYPE";
                continue;
            }
            token.type = "ID";
            continue;
        }
        match = cur.match(regexNumberPrefix);
        if (match) {
            token.text = match[1];
            token.type = "NUMBER";
            offset += token.text.length;
            continue;
        }
        throw new Error("unexpected token ".concat(JSON.stringify(cur[0]), " at position ").concat(offset));
    }
    return new TokenString(tokens.map((t)=>Object.freeze(t)));
}
// Check only one of `allowed` is in `set`
function allowSingle(set, allowed) {
    let included = [];
    for(const key in allowed.keys()){
        if (set.has(key)) {
            included.push(key);
        }
    }
    if (included.length > 1) {
        throw new Error("conflicting types: ".concat(included.join(", ")));
    }
}
// Functions to process a Solidity Signature TokenString from left-to-right for...
// ...the name with an optional type, returning the name
function consumeName(type, tokens) {
    if (tokens.peekKeyword(KwTypes)) {
        const keyword = tokens.pop().text;
        if (keyword !== type) {
            throw new Error("expected ".concat(type, ", got ").concat(keyword));
        }
    }
    return tokens.popType("ID");
}
// ...all keywords matching allowed, returning the keywords
function consumeKeywords(tokens, allowed) {
    const keywords = new Set();
    while(true){
        const keyword = tokens.peekType("KEYWORD");
        if (keyword == null || allowed && !allowed.has(keyword)) {
            break;
        }
        tokens.pop();
        if (keywords.has(keyword)) {
            throw new Error("duplicate keywords: ".concat(JSON.stringify(keyword)));
        }
        keywords.add(keyword);
    }
    return Object.freeze(keywords);
}
// ...all visibility keywords, returning the coalesced mutability
function consumeMutability(tokens) {
    let modifiers = consumeKeywords(tokens, KwVisib);
    // Detect conflicting modifiers
    allowSingle(modifiers, setify("constant payable nonpayable".split(" ")));
    allowSingle(modifiers, setify("pure view payable nonpayable".split(" ")));
    // Process mutability states
    if (modifiers.has("view")) {
        return "view";
    }
    if (modifiers.has("pure")) {
        return "pure";
    }
    if (modifiers.has("payable")) {
        return "payable";
    }
    if (modifiers.has("nonpayable")) {
        return "nonpayable";
    }
    // Process legacy `constant` last
    if (modifiers.has("constant")) {
        return "view";
    }
    return "nonpayable";
}
// ...a parameter list, returning the ParamType list
function consumeParams(tokens, allowIndexed) {
    return tokens.popParams().map((t)=>ParamType.from(t, allowIndexed));
}
// ...a gas limit, returning a BigNumber or null if none
function consumeGas(tokens) {
    if (tokens.peekType("AT")) {
        tokens.pop();
        if (tokens.peekType("NUMBER")) {
            return (0, index_js_1.getBigInt)(tokens.pop().text);
        }
        throw new Error("invalid gas");
    }
    return null;
}
function consumeEoi(tokens) {
    if (tokens.length) {
        throw new Error("unexpected tokens at offset ".concat(tokens.offset, ": ").concat(tokens.toString()));
    }
}
const regexArrayType = new RegExp(/^(.*)\[([0-9]*)\]$/);
function verifyBasicType(type) {
    const match = type.match(regexType);
    (0, index_js_1.assertArgument)(match, "invalid type", "type", type);
    if (type === "uint") {
        return "uint256";
    }
    if (type === "int") {
        return "int256";
    }
    if (match[2]) {
        // bytesXX
        const length = parseInt(match[2]);
        (0, index_js_1.assertArgument)(length !== 0 && length <= 32, "invalid bytes length", "type", type);
    } else if (match[3]) {
        // intXX or uintXX
        const size = parseInt(match[3]);
        (0, index_js_1.assertArgument)(size !== 0 && size <= 256 && size % 8 === 0, "invalid numeric width", "type", type);
    }
    return type;
}
// Make the Fragment constructors effectively private
const _guard = {};
const internal = Symbol.for("_ethers_internal");
const ParamTypeInternal = "_ParamTypeInternal";
const ErrorFragmentInternal = "_ErrorInternal";
const EventFragmentInternal = "_EventInternal";
const ConstructorFragmentInternal = "_ConstructorInternal";
const FallbackFragmentInternal = "_FallbackInternal";
const FunctionFragmentInternal = "_FunctionInternal";
const StructFragmentInternal = "_StructInternal";
var _walkAsync = /*#__PURE__*/ new WeakSet();
/**
 *  Each input and output of a [[Fragment]] is an Array of **ParamType**.
 */ class ParamType {
    /**
     *  Return a string representation of this type.
     *
     *  For example,
     *
     *  ``sighash" => "(uint256,address)"``
     *
     *  ``"minimal" => "tuple(uint256,address) indexed"``
     *
     *  ``"full" => "tuple(uint256 foo, address bar) indexed baz"``
     */ format(format) {
        if (format == null) {
            format = "sighash";
        }
        if (format === "json") {
            const name = this.name || "";
            if (this.isArray()) {
                const result = JSON.parse(this.arrayChildren.format("json"));
                result.name = name;
                result.type += "[".concat(this.arrayLength < 0 ? "" : String(this.arrayLength), "]");
                return JSON.stringify(result);
            }
            const result = {
                type: this.baseType === "tuple" ? "tuple" : this.type,
                name
            };
            if (typeof this.indexed === "boolean") {
                result.indexed = this.indexed;
            }
            if (this.isTuple()) {
                result.components = this.components.map((c)=>JSON.parse(c.format(format)));
            }
            return JSON.stringify(result);
        }
        let result = "";
        // Array
        if (this.isArray()) {
            result += this.arrayChildren.format(format);
            result += "[".concat(this.arrayLength < 0 ? "" : String(this.arrayLength), "]");
        } else {
            if (this.isTuple()) {
                result += "(" + this.components.map((comp)=>comp.format(format)).join(format === "full" ? ", " : ",") + ")";
            } else {
                result += this.type;
            }
        }
        if (format !== "sighash") {
            if (this.indexed === true) {
                result += " indexed";
            }
            if (format === "full" && this.name) {
                result += " " + this.name;
            }
        }
        return result;
    }
    /**
     *  Returns true if %%this%% is an Array type.
     *
     *  This provides a type gaurd ensuring that [[arrayChildren]]
     *  and [[arrayLength]] are non-null.
     */ isArray() {
        return this.baseType === "array";
    }
    /**
     *  Returns true if %%this%% is a Tuple type.
     *
     *  This provides a type gaurd ensuring that [[components]]
     *  is non-null.
     */ isTuple() {
        return this.baseType === "tuple";
    }
    /**
     *  Returns true if %%this%% is an Indexable type.
     *
     *  This provides a type gaurd ensuring that [[indexed]]
     *  is non-null.
     */ isIndexable() {
        return this.indexed != null;
    }
    /**
     *  Walks the **ParamType** with %%value%%, calling %%process%%
     *  on each type, destructing the %%value%% recursively.
     */ walk(value, process) {
        if (this.isArray()) {
            if (!Array.isArray(value)) {
                throw new Error("invalid array value");
            }
            if (this.arrayLength !== -1 && value.length !== this.arrayLength) {
                throw new Error("array is wrong length");
            }
            const _this = this;
            return value.map((v)=>_this.arrayChildren.walk(v, process));
        }
        if (this.isTuple()) {
            if (!Array.isArray(value)) {
                throw new Error("invalid tuple value");
            }
            if (value.length !== this.components.length) {
                throw new Error("array is wrong length");
            }
            const _this = this;
            return value.map((v, i)=>_this.components[i].walk(v, process));
        }
        return process(this.type, value);
    }
    /**
     *  Walks the **ParamType** with %%value%%, asynchronously calling
     *  %%process%% on each type, destructing the %%value%% recursively.
     *
     *  This can be used to resolve ENS names by walking and resolving each
     *  ``"address"`` type.
     */ async walkAsync(value, process) {
        const promises = [];
        const result = [
            value
        ];
        _class_private_method_get._(this, _walkAsync, walkAsync).call(this, promises, value, process, (value)=>{
            result[0] = value;
        });
        if (promises.length) {
            await Promise.all(promises);
        }
        return result[0];
    }
    /**
     *  Creates a new **ParamType** for %%obj%%.
     *
     *  If %%allowIndexed%% then the ``indexed`` keyword is permitted,
     *  otherwise the ``indexed`` keyword will throw an error.
     */ static from(obj, allowIndexed) {
        if (ParamType.isParamType(obj)) {
            return obj;
        }
        if (typeof obj === "string") {
            try {
                return ParamType.from(lex(obj), allowIndexed);
            } catch (error) {
                (0, index_js_1.assertArgument)(false, "invalid param type", "obj", obj);
            }
        } else if (obj instanceof TokenString) {
            let type = "", baseType = "";
            let comps = null;
            if (consumeKeywords(obj, setify([
                "tuple"
            ])).has("tuple") || obj.peekType("OPEN_PAREN")) {
                // Tuple
                baseType = "tuple";
                comps = obj.popParams().map((t)=>ParamType.from(t));
                type = "tuple(".concat(comps.map((c)=>c.format()).join(","), ")");
            } else {
                // Normal
                type = verifyBasicType(obj.popType("TYPE"));
                baseType = type;
            }
            // Check for Array
            let arrayChildren = null;
            let arrayLength = null;
            while(obj.length && obj.peekType("BRACKET")){
                const bracket = obj.pop(); //arrays[i];
                arrayChildren = new ParamType(_guard, "", type, baseType, null, comps, arrayLength, arrayChildren);
                arrayLength = bracket.value;
                type += bracket.text;
                baseType = "array";
                comps = null;
            }
            let indexed = null;
            const keywords = consumeKeywords(obj, KwModifiers);
            if (keywords.has("indexed")) {
                if (!allowIndexed) {
                    throw new Error("");
                }
                indexed = true;
            }
            const name = obj.peekType("ID") ? obj.pop().text : "";
            if (obj.length) {
                throw new Error("leftover tokens");
            }
            return new ParamType(_guard, name, type, baseType, indexed, comps, arrayLength, arrayChildren);
        }
        const name = obj.name;
        (0, index_js_1.assertArgument)(!name || typeof name === "string" && name.match(regexId), "invalid name", "obj.name", name);
        let indexed = obj.indexed;
        if (indexed != null) {
            (0, index_js_1.assertArgument)(allowIndexed, "parameter cannot be indexed", "obj.indexed", obj.indexed);
            indexed = !!indexed;
        }
        let type = obj.type;
        let arrayMatch = type.match(regexArrayType);
        if (arrayMatch) {
            const arrayLength = parseInt(arrayMatch[2] || "-1");
            const arrayChildren = ParamType.from({
                type: arrayMatch[1],
                components: obj.components
            });
            return new ParamType(_guard, name || "", type, "array", indexed, null, arrayLength, arrayChildren);
        }
        if (type === "tuple" || type.startsWith("tuple(" /* fix: ) */ ) || type.startsWith("(" /* fix: ) */ )) {
            const comps = obj.components != null ? obj.components.map((c)=>ParamType.from(c)) : null;
            const tuple = new ParamType(_guard, name || "", type, "tuple", indexed, comps, null, null);
            // @TODO: use lexer to validate and normalize type
            return tuple;
        }
        type = verifyBasicType(obj.type);
        return new ParamType(_guard, name || "", type, type, indexed, null, null, null);
    }
    /**
     *  Returns true if %%value%% is a **ParamType**.
     */ static isParamType(value) {
        return value && value[internal] === ParamTypeInternal;
    }
    /**
     *  @private
     */ constructor(guard, name, type, baseType, indexed, components, arrayLength, arrayChildren){
        _class_private_method_init._(this, _walkAsync);
        /**
     *  The local name of the parameter (or ``""`` if unbound)
     */ _define_property._(this, "name", void 0);
        /**
     *  The fully qualified type (e.g. ``"address"``, ``"tuple(address)"``,
     *  ``"uint256[3][]"``)
     */ _define_property._(this, "type", void 0);
        /**
     *  The base type (e.g. ``"address"``, ``"tuple"``, ``"array"``)
     */ _define_property._(this, "baseType", void 0);
        /**
     *  True if the parameters is indexed.
     *
     *  For non-indexable types this is ``null``.
     */ _define_property._(this, "indexed", void 0);
        /**
     *  The components for the tuple.
     *
     *  For non-tuple types this is ``null``.
     */ _define_property._(this, "components", void 0);
        /**
     *  The array length, or ``-1`` for dynamic-lengthed arrays.
     *
     *  For non-array types this is ``null``.
     */ _define_property._(this, "arrayLength", void 0);
        /**
     *  The type of each child in the array.
     *
     *  For non-array types this is ``null``.
     */ _define_property._(this, "arrayChildren", void 0);
        (0, index_js_1.assertPrivate)(guard, _guard, "ParamType");
        Object.defineProperty(this, internal, {
            value: ParamTypeInternal
        });
        if (components) {
            components = Object.freeze(components.slice());
        }
        if (baseType === "array") {
            if (arrayLength == null || arrayChildren == null) {
                throw new Error("");
            }
        } else if (arrayLength != null || arrayChildren != null) {
            throw new Error("");
        }
        if (baseType === "tuple") {
            if (components == null) {
                throw new Error("");
            }
        } else if (components != null) {
            throw new Error("");
        }
        (0, index_js_1.defineProperties)(this, {
            name,
            type,
            baseType,
            indexed,
            components,
            arrayLength,
            arrayChildren
        });
    }
}
function walkAsync(promises, value, process, setValue) {
    var _components_index;
    if (this.isArray()) {
        if (!Array.isArray(value)) {
            throw new Error("invalid array value");
        }
        if (this.arrayLength !== -1 && value.length !== this.arrayLength) {
            throw new Error("array is wrong length");
        }
        const childType = this.arrayChildren;
        const result = value.slice();
        result.forEach((value, index)=>{
            _class_private_method_get._(childType, _walkAsync, walkAsync).call(childType, promises, value, process, (value)=>{
                result[index] = value;
            });
        });
        setValue(result);
        return;
    }
    if (this.isTuple()) {
        const components = this.components;
        // Convert the object into an array
        let result;
        if (Array.isArray(value)) {
            result = value.slice();
        } else {
            if (value == null || typeof value !== "object") {
                throw new Error("invalid tuple value");
            }
            result = components.map((param)=>{
                if (!param.name) {
                    throw new Error("cannot use object value with unnamed components");
                }
                if (!(param.name in value)) {
                    throw new Error("missing value for component ".concat(param.name));
                }
                return value[param.name];
            });
        }
        if (result.length !== this.components.length) {
            throw new Error("array is wrong length");
        }
        result.forEach((value, index)=>{
            _class_private_method_get._(_components_index = components[index], _walkAsync, walkAsync).call(_components_index, promises, value, process, (value)=>{
                result[index] = value;
            });
        });
        setValue(result);
        return;
    }
    const result = process(this.type, value);
    if (result.then) {
        promises.push(async function() {
            setValue(await result);
        }());
    } else {
        setValue(result);
    }
}
exports.ParamType = ParamType;
/**
 *  An abstract class to represent An individual fragment from a parse ABI.
 */ class Fragment {
    /**
     *  Creates a new **Fragment** for %%obj%%, wich can be any supported
     *  ABI frgament type.
     */ static from(obj) {
        if (typeof obj === "string") {
            // Try parsing JSON...
            try {
                Fragment.from(JSON.parse(obj));
            } catch (e) {}
            // ...otherwise, use the human-readable lexer
            return Fragment.from(lex(obj));
        }
        if (obj instanceof TokenString) {
            // Human-readable ABI (already lexed)
            const type = obj.peekKeyword(KwTypes);
            switch(type){
                case "constructor":
                    return ConstructorFragment.from(obj);
                case "error":
                    return ErrorFragment.from(obj);
                case "event":
                    return EventFragment.from(obj);
                case "fallback":
                case "receive":
                    return FallbackFragment.from(obj);
                case "function":
                    return FunctionFragment.from(obj);
                case "struct":
                    return StructFragment.from(obj);
            }
        } else if (typeof obj === "object") {
            // JSON ABI
            switch(obj.type){
                case "constructor":
                    return ConstructorFragment.from(obj);
                case "error":
                    return ErrorFragment.from(obj);
                case "event":
                    return EventFragment.from(obj);
                case "fallback":
                case "receive":
                    return FallbackFragment.from(obj);
                case "function":
                    return FunctionFragment.from(obj);
                case "struct":
                    return StructFragment.from(obj);
            }
            (0, index_js_1.assert)(false, "unsupported type: ".concat(obj.type), "UNSUPPORTED_OPERATION", {
                operation: "Fragment.from"
            });
        }
        (0, index_js_1.assertArgument)(false, "unsupported frgament object", "obj", obj);
    }
    /**
     *  Returns true if %%value%% is a [[ConstructorFragment]].
     */ static isConstructor(value) {
        return ConstructorFragment.isFragment(value);
    }
    /**
     *  Returns true if %%value%% is an [[ErrorFragment]].
     */ static isError(value) {
        return ErrorFragment.isFragment(value);
    }
    /**
     *  Returns true if %%value%% is an [[EventFragment]].
     */ static isEvent(value) {
        return EventFragment.isFragment(value);
    }
    /**
     *  Returns true if %%value%% is a [[FunctionFragment]].
     */ static isFunction(value) {
        return FunctionFragment.isFragment(value);
    }
    /**
     *  Returns true if %%value%% is a [[StructFragment]].
     */ static isStruct(value) {
        return StructFragment.isFragment(value);
    }
    /**
     *  @private
     */ constructor(guard, type, inputs){
        /**
     *  The type of the fragment.
     */ _define_property._(this, "type", void 0);
        /**
     *  The inputs for the fragment.
     */ _define_property._(this, "inputs", void 0);
        (0, index_js_1.assertPrivate)(guard, _guard, "Fragment");
        inputs = Object.freeze(inputs.slice());
        (0, index_js_1.defineProperties)(this, {
            type,
            inputs
        });
    }
}
exports.Fragment = Fragment;
/**
 *  An abstract class to represent An individual fragment
 *  which has a name from a parse ABI.
 */ class NamedFragment extends Fragment {
    /**
     *  @private
     */ constructor(guard, type, name, inputs){
        super(guard, type, inputs), /**
     *  The name of the fragment.
     */ _define_property._(this, "name", void 0);
        (0, index_js_1.assertArgument)(typeof name === "string" && name.match(regexId), "invalid identifier", "name", name);
        inputs = Object.freeze(inputs.slice());
        (0, index_js_1.defineProperties)(this, {
            name
        });
    }
}
exports.NamedFragment = NamedFragment;
function joinParams(format, params) {
    return "(" + params.map((p)=>p.format(format)).join(format === "full" ? ", " : ",") + ")";
}
/**
 *  A Fragment which represents a //Custom Error//.
 */ class ErrorFragment extends NamedFragment {
    /**
     *  The Custom Error selector.
     */ get selector() {
        return (0, index_js_2.id)(this.format("sighash")).substring(0, 10);
    }
    /**
     *  Returns a string representation of this fragment as %%format%%.
     */ format(format) {
        if (format == null) {
            format = "sighash";
        }
        if (format === "json") {
            return JSON.stringify({
                type: "error",
                name: this.name,
                inputs: this.inputs.map((input)=>JSON.parse(input.format(format)))
            });
        }
        const result = [];
        if (format !== "sighash") {
            result.push("error");
        }
        result.push(this.name + joinParams(format, this.inputs));
        return result.join(" ");
    }
    /**
     *  Returns a new **ErrorFragment** for %%obj%%.
     */ static from(obj) {
        if (ErrorFragment.isFragment(obj)) {
            return obj;
        }
        if (typeof obj === "string") {
            return ErrorFragment.from(lex(obj));
        } else if (obj instanceof TokenString) {
            const name = consumeName("error", obj);
            const inputs = consumeParams(obj);
            consumeEoi(obj);
            return new ErrorFragment(_guard, name, inputs);
        }
        return new ErrorFragment(_guard, obj.name, obj.inputs ? obj.inputs.map(ParamType.from) : []);
    }
    /**
     *  Returns ``true`` and provides a type guard if %%value%% is an
     *  **ErrorFragment**.
     */ static isFragment(value) {
        return value && value[internal] === ErrorFragmentInternal;
    }
    /**
     *  @private
     */ constructor(guard, name, inputs){
        super(guard, "error", name, inputs);
        Object.defineProperty(this, internal, {
            value: ErrorFragmentInternal
        });
    }
}
exports.ErrorFragment = ErrorFragment;
/**
 *  A Fragment which represents an Event.
 */ class EventFragment extends NamedFragment {
    /**
     *  The Event topic hash.
     */ get topicHash() {
        return (0, index_js_2.id)(this.format("sighash"));
    }
    /**
     *  Returns a string representation of this event as %%format%%.
     */ format(format) {
        if (format == null) {
            format = "sighash";
        }
        if (format === "json") {
            return JSON.stringify({
                type: "event",
                anonymous: this.anonymous,
                name: this.name,
                inputs: this.inputs.map((i)=>JSON.parse(i.format(format)))
            });
        }
        const result = [];
        if (format !== "sighash") {
            result.push("event");
        }
        result.push(this.name + joinParams(format, this.inputs));
        if (format !== "sighash" && this.anonymous) {
            result.push("anonymous");
        }
        return result.join(" ");
    }
    /**
     *  Return the topic hash for an event with %%name%% and %%params%%.
     */ static getTopicHash(name, params) {
        params = (params || []).map((p)=>ParamType.from(p));
        const fragment = new EventFragment(_guard, name, params, false);
        return fragment.topicHash;
    }
    /**
     *  Returns a new **EventFragment** for %%obj%%.
     */ static from(obj) {
        if (EventFragment.isFragment(obj)) {
            return obj;
        }
        if (typeof obj === "string") {
            try {
                return EventFragment.from(lex(obj));
            } catch (error) {
                (0, index_js_1.assertArgument)(false, "invalid event fragment", "obj", obj);
            }
        } else if (obj instanceof TokenString) {
            const name = consumeName("event", obj);
            const inputs = consumeParams(obj, true);
            const anonymous = !!consumeKeywords(obj, setify([
                "anonymous"
            ])).has("anonymous");
            consumeEoi(obj);
            return new EventFragment(_guard, name, inputs, anonymous);
        }
        return new EventFragment(_guard, obj.name, obj.inputs ? obj.inputs.map((p)=>ParamType.from(p, true)) : [], !!obj.anonymous);
    }
    /**
     *  Returns ``true`` and provides a type guard if %%value%% is an
     *  **EventFragment**.
     */ static isFragment(value) {
        return value && value[internal] === EventFragmentInternal;
    }
    /**
     *  @private
     */ constructor(guard, name, inputs, anonymous){
        super(guard, "event", name, inputs), /**
     *  Whether this event is anonymous.
     */ _define_property._(this, "anonymous", void 0);
        Object.defineProperty(this, internal, {
            value: EventFragmentInternal
        });
        (0, index_js_1.defineProperties)(this, {
            anonymous
        });
    }
}
exports.EventFragment = EventFragment;
/**
 *  A Fragment which represents a constructor.
 */ class ConstructorFragment extends Fragment {
    /**
     *  Returns a string representation of this constructor as %%format%%.
     */ format(format) {
        (0, index_js_1.assert)(format != null && format !== "sighash", "cannot format a constructor for sighash", "UNSUPPORTED_OPERATION", {
            operation: "format(sighash)"
        });
        if (format === "json") {
            return JSON.stringify({
                type: "constructor",
                stateMutability: this.payable ? "payable" : "undefined",
                payable: this.payable,
                gas: this.gas != null ? this.gas : undefined,
                inputs: this.inputs.map((i)=>JSON.parse(i.format(format)))
            });
        }
        const result = [
            "constructor".concat(joinParams(format, this.inputs))
        ];
        if (this.payable) {
            result.push("payable");
        }
        if (this.gas != null) {
            result.push("@".concat(this.gas.toString()));
        }
        return result.join(" ");
    }
    /**
     *  Returns a new **ConstructorFragment** for %%obj%%.
     */ static from(obj) {
        if (ConstructorFragment.isFragment(obj)) {
            return obj;
        }
        if (typeof obj === "string") {
            try {
                return ConstructorFragment.from(lex(obj));
            } catch (error) {
                (0, index_js_1.assertArgument)(false, "invalid constuctor fragment", "obj", obj);
            }
        } else if (obj instanceof TokenString) {
            consumeKeywords(obj, setify([
                "constructor"
            ]));
            const inputs = consumeParams(obj);
            const payable = !!consumeKeywords(obj, KwVisibDeploy).has("payable");
            const gas = consumeGas(obj);
            consumeEoi(obj);
            return new ConstructorFragment(_guard, "constructor", inputs, payable, gas);
        }
        return new ConstructorFragment(_guard, "constructor", obj.inputs ? obj.inputs.map(ParamType.from) : [], !!obj.payable, obj.gas != null ? obj.gas : null);
    }
    /**
     *  Returns ``true`` and provides a type guard if %%value%% is a
     *  **ConstructorFragment**.
     */ static isFragment(value) {
        return value && value[internal] === ConstructorFragmentInternal;
    }
    /**
     *  @private
     */ constructor(guard, type, inputs, payable, gas){
        super(guard, type, inputs), /**
     *  Whether the constructor can receive an endowment.
     */ _define_property._(this, "payable", void 0), /**
     *  The recommended gas limit for deployment or ``null``.
     */ _define_property._(this, "gas", void 0);
        Object.defineProperty(this, internal, {
            value: ConstructorFragmentInternal
        });
        (0, index_js_1.defineProperties)(this, {
            payable,
            gas
        });
    }
}
exports.ConstructorFragment = ConstructorFragment;
/**
 *  A Fragment which represents a method.
 */ class FallbackFragment extends Fragment {
    /**
     *  Returns a string representation of this fallback as %%format%%.
     */ format(format) {
        const type = this.inputs.length === 0 ? "receive" : "fallback";
        if (format === "json") {
            const stateMutability = this.payable ? "payable" : "nonpayable";
            return JSON.stringify({
                type,
                stateMutability
            });
        }
        return "".concat(type, "()").concat(this.payable ? " payable" : "");
    }
    /**
     *  Returns a new **FallbackFragment** for %%obj%%.
     */ static from(obj) {
        if (FallbackFragment.isFragment(obj)) {
            return obj;
        }
        if (typeof obj === "string") {
            try {
                return FallbackFragment.from(lex(obj));
            } catch (error) {
                (0, index_js_1.assertArgument)(false, "invalid fallback fragment", "obj", obj);
            }
        } else if (obj instanceof TokenString) {
            const errorObj = obj.toString();
            const topIsValid = obj.peekKeyword(setify([
                "fallback",
                "receive"
            ]));
            (0, index_js_1.assertArgument)(topIsValid, "type must be fallback or receive", "obj", errorObj);
            const type = obj.popKeyword(setify([
                "fallback",
                "receive"
            ]));
            // receive()
            if (type === "receive") {
                const inputs = consumeParams(obj);
                (0, index_js_1.assertArgument)(inputs.length === 0, "receive cannot have arguments", "obj.inputs", inputs);
                consumeKeywords(obj, setify([
                    "payable"
                ]));
                consumeEoi(obj);
                return new FallbackFragment(_guard, [], true);
            }
            // fallback() [payable]
            // fallback(bytes) [payable] returns (bytes)
            let inputs = consumeParams(obj);
            if (inputs.length) {
                (0, index_js_1.assertArgument)(inputs.length === 1 && inputs[0].type === "bytes", "invalid fallback inputs", "obj.inputs", inputs.map((i)=>i.format("minimal")).join(", "));
            } else {
                inputs = [
                    ParamType.from("bytes")
                ];
            }
            const mutability = consumeMutability(obj);
            (0, index_js_1.assertArgument)(mutability === "nonpayable" || mutability === "payable", "fallback cannot be constants", "obj.stateMutability", mutability);
            if (consumeKeywords(obj, setify([
                "returns"
            ])).has("returns")) {
                const outputs = consumeParams(obj);
                (0, index_js_1.assertArgument)(outputs.length === 1 && outputs[0].type === "bytes", "invalid fallback outputs", "obj.outputs", outputs.map((i)=>i.format("minimal")).join(", "));
            }
            consumeEoi(obj);
            return new FallbackFragment(_guard, inputs, mutability === "payable");
        }
        if (obj.type === "receive") {
            return new FallbackFragment(_guard, [], true);
        }
        if (obj.type === "fallback") {
            const inputs = [
                ParamType.from("bytes")
            ];
            const payable = obj.stateMutability === "payable";
            return new FallbackFragment(_guard, inputs, payable);
        }
        (0, index_js_1.assertArgument)(false, "invalid fallback description", "obj", obj);
    }
    /**
     *  Returns ``true`` and provides a type guard if %%value%% is a
     *  **FallbackFragment**.
     */ static isFragment(value) {
        return value && value[internal] === FallbackFragmentInternal;
    }
    constructor(guard, inputs, payable){
        super(guard, "fallback", inputs), /**
     *  If the function can be sent value during invocation.
     */ _define_property._(this, "payable", void 0);
        Object.defineProperty(this, internal, {
            value: FallbackFragmentInternal
        });
        (0, index_js_1.defineProperties)(this, {
            payable
        });
    }
}
exports.FallbackFragment = FallbackFragment;
/**
 *  A Fragment which represents a method.
 */ class FunctionFragment extends NamedFragment {
    /**
     *  The Function selector.
     */ get selector() {
        return (0, index_js_2.id)(this.format("sighash")).substring(0, 10);
    }
    /**
     *  Returns a string representation of this function as %%format%%.
     */ format(format) {
        if (format == null) {
            format = "sighash";
        }
        if (format === "json") {
            return JSON.stringify({
                type: "function",
                name: this.name,
                constant: this.constant,
                stateMutability: this.stateMutability !== "nonpayable" ? this.stateMutability : undefined,
                payable: this.payable,
                gas: this.gas != null ? this.gas : undefined,
                inputs: this.inputs.map((i)=>JSON.parse(i.format(format))),
                outputs: this.outputs.map((o)=>JSON.parse(o.format(format)))
            });
        }
        const result = [];
        if (format !== "sighash") {
            result.push("function");
        }
        result.push(this.name + joinParams(format, this.inputs));
        if (format !== "sighash") {
            if (this.stateMutability !== "nonpayable") {
                result.push(this.stateMutability);
            }
            if (this.outputs && this.outputs.length) {
                result.push("returns");
                result.push(joinParams(format, this.outputs));
            }
            if (this.gas != null) {
                result.push("@".concat(this.gas.toString()));
            }
        }
        return result.join(" ");
    }
    /**
     *  Return the selector for a function with %%name%% and %%params%%.
     */ static getSelector(name, params) {
        params = (params || []).map((p)=>ParamType.from(p));
        const fragment = new FunctionFragment(_guard, name, "view", params, [], null);
        return fragment.selector;
    }
    /**
     *  Returns a new **FunctionFragment** for %%obj%%.
     */ static from(obj) {
        if (FunctionFragment.isFragment(obj)) {
            return obj;
        }
        if (typeof obj === "string") {
            try {
                return FunctionFragment.from(lex(obj));
            } catch (error) {
                (0, index_js_1.assertArgument)(false, "invalid function fragment", "obj", obj);
            }
        } else if (obj instanceof TokenString) {
            const name = consumeName("function", obj);
            const inputs = consumeParams(obj);
            const mutability = consumeMutability(obj);
            let outputs = [];
            if (consumeKeywords(obj, setify([
                "returns"
            ])).has("returns")) {
                outputs = consumeParams(obj);
            }
            const gas = consumeGas(obj);
            consumeEoi(obj);
            return new FunctionFragment(_guard, name, mutability, inputs, outputs, gas);
        }
        let stateMutability = obj.stateMutability;
        // Use legacy Solidity ABI logic if stateMutability is missing
        if (stateMutability == null) {
            stateMutability = "payable";
            if (typeof obj.constant === "boolean") {
                stateMutability = "view";
                if (!obj.constant) {
                    stateMutability = "payable";
                    if (typeof obj.payable === "boolean" && !obj.payable) {
                        stateMutability = "nonpayable";
                    }
                }
            } else if (typeof obj.payable === "boolean" && !obj.payable) {
                stateMutability = "nonpayable";
            }
        }
        // @TODO: verifyState for stateMutability (e.g. throw if
        //        payable: false but stateMutability is "nonpayable")
        return new FunctionFragment(_guard, obj.name, stateMutability, obj.inputs ? obj.inputs.map(ParamType.from) : [], obj.outputs ? obj.outputs.map(ParamType.from) : [], obj.gas != null ? obj.gas : null);
    }
    /**
     *  Returns ``true`` and provides a type guard if %%value%% is a
     *  **FunctionFragment**.
     */ static isFragment(value) {
        return value && value[internal] === FunctionFragmentInternal;
    }
    /**
     *  @private
     */ constructor(guard, name, stateMutability, inputs, outputs, gas){
        super(guard, "function", name, inputs), /**
     *  If the function is constant (e.g. ``pure`` or ``view`` functions).
     */ _define_property._(this, "constant", void 0), /**
     *  The returned types for the result of calling this function.
     */ _define_property._(this, "outputs", void 0), /**
     *  The state mutability (e.g. ``payable``, ``nonpayable``, ``view``
     *  or ``pure``)
     */ _define_property._(this, "stateMutability", void 0), /**
     *  If the function can be sent value during invocation.
     */ _define_property._(this, "payable", void 0), /**
     *  The recommended gas limit to send when calling this function.
     */ _define_property._(this, "gas", void 0);
        Object.defineProperty(this, internal, {
            value: FunctionFragmentInternal
        });
        outputs = Object.freeze(outputs.slice());
        const constant = stateMutability === "view" || stateMutability === "pure";
        const payable = stateMutability === "payable";
        (0, index_js_1.defineProperties)(this, {
            constant,
            gas,
            outputs,
            payable,
            stateMutability
        });
    }
}
exports.FunctionFragment = FunctionFragment;
/**
 *  A Fragment which represents a structure.
 */ class StructFragment extends NamedFragment {
    /**
     *  Returns a string representation of this struct as %%format%%.
     */ format() {
        throw new Error("@TODO");
    }
    /**
     *  Returns a new **StructFragment** for %%obj%%.
     */ static from(obj) {
        if (typeof obj === "string") {
            try {
                return StructFragment.from(lex(obj));
            } catch (error) {
                (0, index_js_1.assertArgument)(false, "invalid struct fragment", "obj", obj);
            }
        } else if (obj instanceof TokenString) {
            const name = consumeName("struct", obj);
            const inputs = consumeParams(obj);
            consumeEoi(obj);
            return new StructFragment(_guard, name, inputs);
        }
        return new StructFragment(_guard, obj.name, obj.inputs ? obj.inputs.map(ParamType.from) : []);
    }
    // @TODO: fix this return type
    /**
     *  Returns ``true`` and provides a type guard if %%value%% is a
     *  **StructFragment**.
     */ static isFragment(value) {
        return value && value[internal] === StructFragmentInternal;
    }
    /**
     *  @private
     */ constructor(guard, name, inputs){
        super(guard, "struct", name, inputs);
        Object.defineProperty(this, internal, {
            value: StructFragmentInternal
        });
    }
}
exports.StructFragment = StructFragment; //# sourceMappingURL=fragments.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/abi-coder.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
/**
 *  When sending values to or receiving values from a [[Contract]], the
 *  data is generally encoded using the [ABI standard](link-solc-abi).
 *
 *  The AbiCoder provides a utility to encode values to ABI data and
 *  decode values from ABI data.
 *
 *  Most of the time, developers should favour the [[Contract]] class,
 *  which further abstracts a lot of the finer details of ABI data.
 *
 *  @_section api/abi/abi-coder:ABI Encoding
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AbiCoder = void 0;
// See: https://github.com/ethereum/wiki/wiki/Ethereum-Contract-ABI
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
const address_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/address.js [app-client] (ecmascript)");
const array_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/array.js [app-client] (ecmascript)");
const boolean_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/boolean.js [app-client] (ecmascript)");
const bytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/bytes.js [app-client] (ecmascript)");
const fixed_bytes_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/fixed-bytes.js [app-client] (ecmascript)");
const null_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/null.js [app-client] (ecmascript)");
const number_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/number.js [app-client] (ecmascript)");
const string_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/string.js [app-client] (ecmascript)");
const tuple_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/tuple.js [app-client] (ecmascript)");
const fragments_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/fragments.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
// https://docs.soliditylang.org/en/v0.8.17/control-structures.html
const PanicReasons = new Map();
PanicReasons.set(0x00, "GENERIC_PANIC");
PanicReasons.set(0x01, "ASSERT_FALSE");
PanicReasons.set(0x11, "OVERFLOW");
PanicReasons.set(0x12, "DIVIDE_BY_ZERO");
PanicReasons.set(0x21, "ENUM_RANGE_ERROR");
PanicReasons.set(0x22, "BAD_STORAGE_DATA");
PanicReasons.set(0x31, "STACK_UNDERFLOW");
PanicReasons.set(0x32, "ARRAY_RANGE_ERROR");
PanicReasons.set(0x41, "OUT_OF_MEMORY");
PanicReasons.set(0x51, "UNINITIALIZED_FUNCTION_CALL");
const paramTypeBytes = new RegExp(/^bytes([0-9]*)$/);
const paramTypeNumber = new RegExp(/^(u?int)([0-9]*)$/);
let defaultCoder = null;
let defaultMaxInflation = 1024;
function getBuiltinCallException(action, tx, data, abiCoder) {
    let message = "missing revert data";
    let reason = null;
    const invocation = null;
    let revert = null;
    if (data) {
        message = "execution reverted";
        const bytes = (0, index_js_3.getBytes)(data);
        data = (0, index_js_3.hexlify)(data);
        if (bytes.length === 0) {
            message += " (no data present; likely require(false) occurred";
            reason = "require(false)";
        } else if (bytes.length % 32 !== 4) {
            message += " (could not decode reason; invalid data length)";
        } else if ((0, index_js_3.hexlify)(bytes.slice(0, 4)) === "0x08c379a0") {
            // Error(string)
            try {
                reason = abiCoder.decode([
                    "string"
                ], bytes.slice(4))[0];
                revert = {
                    signature: "Error(string)",
                    name: "Error",
                    args: [
                        reason
                    ]
                };
                message += ": ".concat(JSON.stringify(reason));
            } catch (error) {
                message += " (could not decode reason; invalid string data)";
            }
        } else if ((0, index_js_3.hexlify)(bytes.slice(0, 4)) === "0x4e487b71") {
            // Panic(uint256)
            try {
                const code = Number(abiCoder.decode([
                    "uint256"
                ], bytes.slice(4))[0]);
                revert = {
                    signature: "Panic(uint256)",
                    name: "Panic",
                    args: [
                        code
                    ]
                };
                reason = "Panic due to ".concat(PanicReasons.get(code) || "UNKNOWN", "(").concat(code, ")");
                message += ": ".concat(reason);
            } catch (error) {
                message += " (could not decode panic code)";
            }
        } else {
            message += " (unknown custom error)";
        }
    }
    const transaction = {
        to: tx.to ? (0, index_js_2.getAddress)(tx.to) : null,
        data: tx.data || "0x"
    };
    if (tx.from) {
        transaction.from = (0, index_js_2.getAddress)(tx.from);
    }
    return (0, index_js_3.makeError)(message, "CALL_EXCEPTION", {
        action,
        data,
        reason,
        transaction,
        invocation,
        revert
    });
}
var _getCoder = /*#__PURE__*/ new WeakSet();
/**
 *  The **AbiCoder** is a low-level class responsible for encoding JavaScript
 *  values into binary data and decoding binary data into JavaScript values.
 */ class AbiCoder {
    /**
     *  Get the default values for the given %%types%%.
     *
     *  For example, a ``uint`` is by default ``0`` and ``bool``
     *  is by default ``false``.
     */ getDefaultValue(types) {
        const coders = types.map((type)=>_class_private_method_get._(this, _getCoder, getCoder).call(this, fragments_js_1.ParamType.from(type)));
        const coder = new tuple_js_1.TupleCoder(coders, "_");
        return coder.defaultValue();
    }
    /**
     *  Encode the %%values%% as the %%types%% into ABI data.
     *
     *  @returns DataHexstring
     */ encode(types, values) {
        (0, index_js_1.assertArgumentCount)(values.length, types.length, "types/values length mismatch");
        const coders = types.map((type)=>_class_private_method_get._(this, _getCoder, getCoder).call(this, fragments_js_1.ParamType.from(type)));
        const coder = new tuple_js_1.TupleCoder(coders, "_");
        const writer = new abstract_coder_js_1.Writer();
        coder.encode(writer, values);
        return writer.data;
    }
    /**
     *  Decode the ABI %%data%% as the %%types%% into values.
     *
     *  If %%loose%% decoding is enabled, then strict padding is
     *  not enforced. Some older versions of Solidity incorrectly
     *  padded event data emitted from ``external`` functions.
     */ decode(types, data, loose) {
        const coders = types.map((type)=>_class_private_method_get._(this, _getCoder, getCoder).call(this, fragments_js_1.ParamType.from(type)));
        const coder = new tuple_js_1.TupleCoder(coders, "_");
        return coder.decode(new abstract_coder_js_1.Reader(data, loose, defaultMaxInflation));
    }
    static _setDefaultMaxInflation(value) {
        (0, index_js_1.assertArgument)(typeof value === "number" && Number.isInteger(value), "invalid defaultMaxInflation factor", "value", value);
        defaultMaxInflation = value;
    }
    /**
     *  Returns the shared singleton instance of a default [[AbiCoder]].
     *
     *  On the first call, the instance is created internally.
     */ static defaultAbiCoder() {
        if (defaultCoder == null) {
            defaultCoder = new AbiCoder();
        }
        return defaultCoder;
    }
    /**
     *  Returns an ethers-compatible [[CallExceptionError]] Error for the given
     *  result %%data%% for the [[CallExceptionAction]] %%action%% against
     *  the Transaction %%tx%%.
     */ static getBuiltinCallException(action, tx, data) {
        return getBuiltinCallException(action, tx, data, AbiCoder.defaultAbiCoder());
    }
    constructor(){
        _class_private_method_init._(this, _getCoder);
    }
}
function getCoder(param) {
    if (param.isArray()) {
        return new array_js_1.ArrayCoder(_class_private_method_get._(this, _getCoder, getCoder).call(this, param.arrayChildren), param.arrayLength, param.name);
    }
    if (param.isTuple()) {
        return new tuple_js_1.TupleCoder(param.components.map((c)=>_class_private_method_get._(this, _getCoder, getCoder).call(this, c)), param.name);
    }
    switch(param.baseType){
        case "address":
            return new address_js_1.AddressCoder(param.name);
        case "bool":
            return new boolean_js_1.BooleanCoder(param.name);
        case "string":
            return new string_js_1.StringCoder(param.name);
        case "bytes":
            return new bytes_js_1.BytesCoder(param.name);
        case "":
            return new null_js_1.NullCoder(param.name);
    }
    // u?int[0-9]*
    let match = param.type.match(paramTypeNumber);
    if (match) {
        let size = parseInt(match[2] || "256");
        (0, index_js_1.assertArgument)(size !== 0 && size <= 256 && size % 8 === 0, "invalid " + match[1] + " bit length", "param", param);
        return new number_js_1.NumberCoder(size / 8, match[1] === "int", param.name);
    }
    // bytes[0-9]+
    match = param.type.match(paramTypeBytes);
    if (match) {
        let size = parseInt(match[1]);
        (0, index_js_1.assertArgument)(size !== 0 && size <= 32, "invalid bytes length", "param", param);
        return new fixed_bytes_js_1.FixedBytesCoder(size, param.name);
    }
    (0, index_js_1.assertArgument)(false, "invalid type", "type", param.type);
}
exports.AbiCoder = AbiCoder; //# sourceMappingURL=abi-coder.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/bytes32.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  About bytes32 strings...
 *
 *  @_docloc: api/utils:Bytes32 Strings
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeBytes32String = exports.encodeBytes32String = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 *  Encodes %%text%% as a Bytes32 string.
 */ function encodeBytes32String(text) {
    // Get the bytes
    const bytes = (0, index_js_1.toUtf8Bytes)(text);
    // Check we have room for null-termination
    if (bytes.length > 31) {
        throw new Error("bytes32 string must be less than 32 bytes");
    }
    // Zero-pad (implicitly null-terminates)
    return (0, index_js_1.zeroPadBytes)(bytes, 32);
}
exports.encodeBytes32String = encodeBytes32String;
/**
 *  Encodes the Bytes32-encoded %%bytes%% into a string.
 */ function decodeBytes32String(_bytes) {
    const data = (0, index_js_1.getBytes)(_bytes, "bytes");
    // Must be 32 bytes with a null-termination
    if (data.length !== 32) {
        throw new Error("invalid bytes32 - not 32 bytes long");
    }
    if (data[31] !== 0) {
        throw new Error("invalid bytes32 string - no null terminator");
    }
    // Find the null termination
    let length = 31;
    while(data[length - 1] === 0){
        length--;
    }
    // Determine the string value
    return (0, index_js_1.toUtf8String)(data.slice(0, length));
}
exports.decodeBytes32String = decodeBytes32String; //# sourceMappingURL=bytes32.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/interface.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  The Interface class is a low-level class that accepts an
 *  ABI and provides all the necessary functionality to encode
 *  and decode paramaters to and results from methods, events
 *  and errors.
 *
 *  It also provides several convenience methods to automatically
 *  search and find matching transactions and events to parse them.
 *
 *  @_subsection api/abi:Interfaces  [interfaces]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Interface = exports.Indexed = exports.ErrorDescription = exports.TransactionDescription = exports.LogDescription = exports.Result = exports.checkResultErrors = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abi_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/abi-coder.js [app-client] (ecmascript)");
const abstract_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/coders/abstract-coder.js [app-client] (ecmascript)");
Object.defineProperty(exports, "checkResultErrors", {
    enumerable: true,
    get: function() {
        return abstract_coder_js_1.checkResultErrors;
    }
});
Object.defineProperty(exports, "Result", {
    enumerable: true,
    get: function() {
        return abstract_coder_js_1.Result;
    }
});
const fragments_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/fragments.js [app-client] (ecmascript)");
const typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
/**
 *  When using the [[Interface-parseLog]] to automatically match a Log to its event
 *  for parsing, a **LogDescription** is returned.
 */ class LogDescription {
    /**
     *  @_ignore:
     */ constructor(fragment, topic, args){
        /**
     *  The matching fragment for the ``topic0``.
     */ _define_property._(this, "fragment", void 0);
        /**
     *  The name of the Event.
     */ _define_property._(this, "name", void 0);
        /**
     *  The full Event signature.
     */ _define_property._(this, "signature", void 0);
        /**
     *  The topic hash for the Event.
     */ _define_property._(this, "topic", void 0);
        /**
     *  The arguments passed into the Event with ``emit``.
     */ _define_property._(this, "args", void 0);
        const name = fragment.name, signature = fragment.format();
        (0, index_js_3.defineProperties)(this, {
            fragment,
            name,
            signature,
            topic,
            args
        });
    }
}
exports.LogDescription = LogDescription;
/**
 *  When using the [[Interface-parseTransaction]] to automatically match
 *  a transaction data to its function for parsing,
 *  a **TransactionDescription** is returned.
 */ class TransactionDescription {
    /**
     *  @_ignore:
     */ constructor(fragment, selector, args, value){
        /**
     *  The matching fragment from the transaction ``data``.
     */ _define_property._(this, "fragment", void 0);
        /**
     *  The name of the Function from the transaction ``data``.
     */ _define_property._(this, "name", void 0);
        /**
     *  The arguments passed to the Function from the transaction ``data``.
     */ _define_property._(this, "args", void 0);
        /**
     *  The full Function signature from the transaction ``data``.
     */ _define_property._(this, "signature", void 0);
        /**
     *  The selector for the Function from the transaction ``data``.
     */ _define_property._(this, "selector", void 0);
        /**
     *  The ``value`` (in wei) from the transaction.
     */ _define_property._(this, "value", void 0);
        const name = fragment.name, signature = fragment.format();
        (0, index_js_3.defineProperties)(this, {
            fragment,
            name,
            args,
            signature,
            selector,
            value
        });
    }
}
exports.TransactionDescription = TransactionDescription;
/**
 *  When using the [[Interface-parseError]] to automatically match an
 *  error for a call result for parsing, an **ErrorDescription** is returned.
 */ class ErrorDescription {
    /**
     *  @_ignore:
     */ constructor(fragment, selector, args){
        /**
     *  The matching fragment.
     */ _define_property._(this, "fragment", void 0);
        /**
     *  The name of the Error.
     */ _define_property._(this, "name", void 0);
        /**
     *  The arguments passed to the Error with ``revert``.
     */ _define_property._(this, "args", void 0);
        /**
     *  The full Error signature.
     */ _define_property._(this, "signature", void 0);
        /**
     *  The selector for the Error.
     */ _define_property._(this, "selector", void 0);
        const name = fragment.name, signature = fragment.format();
        (0, index_js_3.defineProperties)(this, {
            fragment,
            name,
            args,
            signature,
            selector
        });
    }
}
exports.ErrorDescription = ErrorDescription;
/**
 *  An **Indexed** is used as a value when a value that does not
 *  fit within a topic (i.e. not a fixed-length, 32-byte type). It
 *  is the ``keccak256`` of the value, and used for types such as
 *  arrays, tuples, bytes and strings.
 */ class Indexed {
    /**
     *  Returns ``true`` if %%value%% is an **Indexed**.
     *
     *  This provides a Type Guard for property access.
     */ static isIndexed(value) {
        return !!(value && value._isIndexed);
    }
    /**
     *  @_ignore:
     */ constructor(hash){
        /**
     *  The ``keccak256`` of the value logged.
     */ _define_property._(this, "hash", void 0);
        /**
     *  @_ignore:
     */ _define_property._(this, "_isIndexed", void 0);
        (0, index_js_3.defineProperties)(this, {
            hash,
            _isIndexed: true
        });
    }
}
exports.Indexed = Indexed;
// https://docs.soliditylang.org/en/v0.8.13/control-structures.html?highlight=panic#panic-via-assert-and-error-via-require
const PanicReasons = {
    "0": "generic panic",
    "1": "assert(false)",
    "17": "arithmetic overflow",
    "18": "division or modulo by zero",
    "33": "enum overflow",
    "34": "invalid encoded storage byte array accessed",
    "49": "out-of-bounds array access; popping on an empty array",
    "50": "out-of-bounds access of an array or bytesN",
    "65": "out of memory",
    "81": "uninitialized function"
};
const BuiltinErrors = {
    "0x08c379a0": {
        signature: "Error(string)",
        name: "Error",
        inputs: [
            "string"
        ],
        reason: (message)=>{
            return "reverted with reason string ".concat(JSON.stringify(message));
        }
    },
    "0x4e487b71": {
        signature: "Panic(uint256)",
        name: "Panic",
        inputs: [
            "uint256"
        ],
        reason: (code)=>{
            let reason = "unknown panic code";
            if (code >= 0 && code <= 0xff && PanicReasons[code.toString()]) {
                reason = PanicReasons[code.toString()];
            }
            return "reverted with panic code 0x".concat(code.toString(16), " (").concat(reason, ")");
        }
    }
};
var _errors = /*#__PURE__*/ new WeakMap(), _events = /*#__PURE__*/ new WeakMap(), _functions = /*#__PURE__*/ new WeakMap(), //    #structs: Map<string, StructFragment>;
_abiCoder = /*#__PURE__*/ new WeakMap(), // Find a function definition by any means necessary (unless it is ambiguous)
_getFunction = /*#__PURE__*/ new WeakSet(), // Find an event definition by any means necessary (unless it is ambiguous)
_getEvent = /*#__PURE__*/ new WeakSet();
/**
 *  An Interface abstracts many of the low-level details for
 *  encoding and decoding the data on the blockchain.
 *
 *  An ABI provides information on how to encode data to send to
 *  a Contract, how to decode the results and events and how to
 *  interpret revert errors.
 *
 *  The ABI can be specified by [any supported format](InterfaceAbi).
 */ class Interface {
    /**
     *  Returns the entire Human-Readable ABI, as an array of
     *  signatures, optionally as %%minimal%% strings, which
     *  removes parameter names and unneceesary spaces.
     */ format(minimal) {
        const format = minimal ? "minimal" : "full";
        const abi = this.fragments.map((f)=>f.format(format));
        return abi;
    }
    /**
     *  Return the JSON-encoded ABI. This is the format Solidiy
     *  returns.
     */ formatJson() {
        const abi = this.fragments.map((f)=>f.format("json"));
        // We need to re-bundle the JSON fragments a bit
        return JSON.stringify(abi.map((j)=>JSON.parse(j)));
    }
    /**
     *  The ABI coder that will be used to encode and decode binary
     *  data.
     */ getAbiCoder() {
        return abi_coder_js_1.AbiCoder.defaultAbiCoder();
    }
    /**
     *  Get the function name for %%key%%, which may be a function selector,
     *  function name or function signature that belongs to the ABI.
     */ getFunctionName(key) {
        const fragment = _class_private_method_get._(this, _getFunction, getFunction).call(this, key, null, false);
        (0, index_js_3.assertArgument)(fragment, "no matching function", "key", key);
        return fragment.name;
    }
    /**
     *  Returns true if %%key%% (a function selector, function name or
     *  function signature) is present in the ABI.
     *
     *  In the case of a function name, the name may be ambiguous, so
     *  accessing the [[FunctionFragment]] may require refinement.
     */ hasFunction(key) {
        return !!_class_private_method_get._(this, _getFunction, getFunction).call(this, key, null, false);
    }
    /**
     *  Get the [[FunctionFragment]] for %%key%%, which may be a function
     *  selector, function name or function signature that belongs to the ABI.
     *
     *  If %%values%% is provided, it will use the Typed API to handle
     *  ambiguous cases where multiple functions match by name.
     *
     *  If the %%key%% and %%values%% do not refine to a single function in
     *  the ABI, this will throw.
     */ getFunction(key, values) {
        return _class_private_method_get._(this, _getFunction, getFunction).call(this, key, values || null, true);
    }
    /**
     *  Iterate over all functions, calling %%callback%%, sorted by their name.
     */ forEachFunction(callback) {
        const names = Array.from(_class_private_field_get._(this, _functions).keys());
        names.sort((a, b)=>a.localeCompare(b));
        for(let i = 0; i < names.length; i++){
            const name = names[i];
            callback(_class_private_field_get._(this, _functions).get(name), i);
        }
    }
    /**
     *  Get the event name for %%key%%, which may be a topic hash,
     *  event name or event signature that belongs to the ABI.
     */ getEventName(key) {
        const fragment = _class_private_method_get._(this, _getEvent, getEvent).call(this, key, null, false);
        (0, index_js_3.assertArgument)(fragment, "no matching event", "key", key);
        return fragment.name;
    }
    /**
     *  Returns true if %%key%% (an event topic hash, event name or
     *  event signature) is present in the ABI.
     *
     *  In the case of an event name, the name may be ambiguous, so
     *  accessing the [[EventFragment]] may require refinement.
     */ hasEvent(key) {
        return !!_class_private_method_get._(this, _getEvent, getEvent).call(this, key, null, false);
    }
    /**
     *  Get the [[EventFragment]] for %%key%%, which may be a topic hash,
     *  event name or event signature that belongs to the ABI.
     *
     *  If %%values%% is provided, it will use the Typed API to handle
     *  ambiguous cases where multiple events match by name.
     *
     *  If the %%key%% and %%values%% do not refine to a single event in
     *  the ABI, this will throw.
     */ getEvent(key, values) {
        return _class_private_method_get._(this, _getEvent, getEvent).call(this, key, values || null, true);
    }
    /**
     *  Iterate over all events, calling %%callback%%, sorted by their name.
     */ forEachEvent(callback) {
        const names = Array.from(_class_private_field_get._(this, _events).keys());
        names.sort((a, b)=>a.localeCompare(b));
        for(let i = 0; i < names.length; i++){
            const name = names[i];
            callback(_class_private_field_get._(this, _events).get(name), i);
        }
    }
    /**
     *  Get the [[ErrorFragment]] for %%key%%, which may be an error
     *  selector, error name or error signature that belongs to the ABI.
     *
     *  If %%values%% is provided, it will use the Typed API to handle
     *  ambiguous cases where multiple errors match by name.
     *
     *  If the %%key%% and %%values%% do not refine to a single error in
     *  the ABI, this will throw.
     */ getError(key, values) {
        if ((0, index_js_3.isHexString)(key)) {
            const selector = key.toLowerCase();
            if (BuiltinErrors[selector]) {
                return fragments_js_1.ErrorFragment.from(BuiltinErrors[selector].signature);
            }
            for (const fragment of _class_private_field_get._(this, _errors).values()){
                if (selector === fragment.selector) {
                    return fragment;
                }
            }
            return null;
        }
        // It is a bare name, look up the function (will return null if ambiguous)
        if (key.indexOf("(") === -1) {
            const matching = [];
            for (const [name, fragment] of _class_private_field_get._(this, _errors)){
                if (name.split("(" /* fix:) */ )[0] === key) {
                    matching.push(fragment);
                }
            }
            if (matching.length === 0) {
                if (key === "Error") {
                    return fragments_js_1.ErrorFragment.from("error Error(string)");
                }
                if (key === "Panic") {
                    return fragments_js_1.ErrorFragment.from("error Panic(uint256)");
                }
                return null;
            } else if (matching.length > 1) {
                const matchStr = matching.map((m)=>JSON.stringify(m.format())).join(", ");
                (0, index_js_3.assertArgument)(false, "ambiguous error description (i.e. ".concat(matchStr, ")"), "name", key);
            }
            return matching[0];
        }
        // Normalize the signature and lookup the function
        key = fragments_js_1.ErrorFragment.from(key).format();
        if (key === "Error(string)") {
            return fragments_js_1.ErrorFragment.from("error Error(string)");
        }
        if (key === "Panic(uint256)") {
            return fragments_js_1.ErrorFragment.from("error Panic(uint256)");
        }
        const result = _class_private_field_get._(this, _errors).get(key);
        if (result) {
            return result;
        }
        return null;
    }
    /**
     *  Iterate over all errors, calling %%callback%%, sorted by their name.
     */ forEachError(callback) {
        const names = Array.from(_class_private_field_get._(this, _errors).keys());
        names.sort((a, b)=>a.localeCompare(b));
        for(let i = 0; i < names.length; i++){
            const name = names[i];
            callback(_class_private_field_get._(this, _errors).get(name), i);
        }
    }
    // Get the 4-byte selector used by Solidity to identify a function
    /*
getSelector(fragment: ErrorFragment | FunctionFragment): string {
    if (typeof(fragment) === "string") {
        const matches: Array<Fragment> = [ ];

        try { matches.push(this.getFunction(fragment)); } catch (error) { }
        try { matches.push(this.getError(<string>fragment)); } catch (_) { }

        if (matches.length === 0) {
            logger.throwArgumentError("unknown fragment", "key", fragment);
        } else if (matches.length > 1) {
            logger.throwArgumentError("ambiguous fragment matches function and error", "key", fragment);
        }

        fragment = matches[0];
    }

    return dataSlice(id(fragment.format()), 0, 4);
}
    */ // Get the 32-byte topic hash used by Solidity to identify an event
    /*
    getEventTopic(fragment: EventFragment): string {
        //if (typeof(fragment) === "string") { fragment = this.getEvent(eventFragment); }
        return id(fragment.format());
    }
    */ _decodeParams(params, data) {
        return _class_private_field_get._(this, _abiCoder).decode(params, data);
    }
    _encodeParams(params, values) {
        return _class_private_field_get._(this, _abiCoder).encode(params, values);
    }
    /**
     *  Encodes a ``tx.data`` object for deploying the Contract with
     *  the %%values%% as the constructor arguments.
     */ encodeDeploy(values) {
        return this._encodeParams(this.deploy.inputs, values || []);
    }
    /**
     *  Decodes the result %%data%% (e.g. from an ``eth_call``) for the
     *  specified error (see [[getError]] for valid values for
     *  %%key%%).
     *
     *  Most developers should prefer the [[parseCallResult]] method instead,
     *  which will automatically detect a ``CALL_EXCEPTION`` and throw the
     *  corresponding error.
     */ decodeErrorResult(fragment, data) {
        if (typeof fragment === "string") {
            const f = this.getError(fragment);
            (0, index_js_3.assertArgument)(f, "unknown error", "fragment", fragment);
            fragment = f;
        }
        (0, index_js_3.assertArgument)((0, index_js_3.dataSlice)(data, 0, 4) === fragment.selector, "data signature does not match error ".concat(fragment.name, "."), "data", data);
        return this._decodeParams(fragment.inputs, (0, index_js_3.dataSlice)(data, 4));
    }
    /**
     *  Encodes the transaction revert data for a call result that
     *  reverted from the the Contract with the sepcified %%error%%
     *  (see [[getError]] for valid values for %%fragment%%) with the %%values%%.
     *
     *  This is generally not used by most developers, unless trying to mock
     *  a result from a Contract.
     */ encodeErrorResult(fragment, values) {
        if (typeof fragment === "string") {
            const f = this.getError(fragment);
            (0, index_js_3.assertArgument)(f, "unknown error", "fragment", fragment);
            fragment = f;
        }
        return (0, index_js_3.concat)([
            fragment.selector,
            this._encodeParams(fragment.inputs, values || [])
        ]);
    }
    /**
     *  Decodes the %%data%% from a transaction ``tx.data`` for
     *  the function specified (see [[getFunction]] for valid values
     *  for %%fragment%%).
     *
     *  Most developers should prefer the [[parseTransaction]] method
     *  instead, which will automatically detect the fragment.
     */ decodeFunctionData(fragment, data) {
        if (typeof fragment === "string") {
            const f = this.getFunction(fragment);
            (0, index_js_3.assertArgument)(f, "unknown function", "fragment", fragment);
            fragment = f;
        }
        (0, index_js_3.assertArgument)((0, index_js_3.dataSlice)(data, 0, 4) === fragment.selector, "data signature does not match function ".concat(fragment.name, "."), "data", data);
        return this._decodeParams(fragment.inputs, (0, index_js_3.dataSlice)(data, 4));
    }
    /**
     *  Encodes the ``tx.data`` for a transaction that calls the function
     *  specified (see [[getFunction]] for valid values for %%fragment%%) with
     *  the %%values%%.
     */ encodeFunctionData(fragment, values) {
        if (typeof fragment === "string") {
            const f = this.getFunction(fragment);
            (0, index_js_3.assertArgument)(f, "unknown function", "fragment", fragment);
            fragment = f;
        }
        return (0, index_js_3.concat)([
            fragment.selector,
            this._encodeParams(fragment.inputs, values || [])
        ]);
    }
    /**
     *  Decodes the result %%data%% (e.g. from an ``eth_call``) for the
     *  specified function (see [[getFunction]] for valid values for
     *  %%key%%).
     *
     *  Most developers should prefer the [[parseCallResult]] method instead,
     *  which will automatically detect a ``CALL_EXCEPTION`` and throw the
     *  corresponding error.
     */ decodeFunctionResult(fragment, data) {
        if (typeof fragment === "string") {
            const f = this.getFunction(fragment);
            (0, index_js_3.assertArgument)(f, "unknown function", "fragment", fragment);
            fragment = f;
        }
        let message = "invalid length for result data";
        const bytes = (0, index_js_3.getBytesCopy)(data);
        if (bytes.length % 32 === 0) {
            try {
                return _class_private_field_get._(this, _abiCoder).decode(fragment.outputs, bytes);
            } catch (error) {
                message = "could not decode result data";
            }
        }
        // Call returned data with no error, but the data is junk
        (0, index_js_3.assert)(false, message, "BAD_DATA", {
            value: (0, index_js_3.hexlify)(bytes),
            info: {
                method: fragment.name,
                signature: fragment.format()
            }
        });
    }
    makeError(_data, tx) {
        const data = (0, index_js_3.getBytes)(_data, "data");
        const error = abi_coder_js_1.AbiCoder.getBuiltinCallException("call", tx, data);
        // Not a built-in error; try finding a custom error
        const customPrefix = "execution reverted (unknown custom error)";
        if (error.message.startsWith(customPrefix)) {
            const selector = (0, index_js_3.hexlify)(data.slice(0, 4));
            const ef = this.getError(selector);
            if (ef) {
                try {
                    const args = _class_private_field_get._(this, _abiCoder).decode(ef.inputs, data.slice(4));
                    error.revert = {
                        name: ef.name,
                        signature: ef.format(),
                        args
                    };
                    error.reason = error.revert.signature;
                    error.message = "execution reverted: ".concat(error.reason);
                } catch (e) {
                    error.message = "execution reverted (coult not decode custom error)";
                }
            }
        }
        // Add the invocation, if available
        const parsed = this.parseTransaction(tx);
        if (parsed) {
            error.invocation = {
                method: parsed.name,
                signature: parsed.signature,
                args: parsed.args
            };
        }
        return error;
    }
    /**
     *  Encodes the result data (e.g. from an ``eth_call``) for the
     *  specified function (see [[getFunction]] for valid values
     *  for %%fragment%%) with %%values%%.
     *
     *  This is generally not used by most developers, unless trying to mock
     *  a result from a Contract.
     */ encodeFunctionResult(fragment, values) {
        if (typeof fragment === "string") {
            const f = this.getFunction(fragment);
            (0, index_js_3.assertArgument)(f, "unknown function", "fragment", fragment);
            fragment = f;
        }
        return (0, index_js_3.hexlify)(_class_private_field_get._(this, _abiCoder).encode(fragment.outputs, values || []));
    }
    /*
        spelunk(inputs: Array<ParamType>, values: ReadonlyArray<any>, processfunc: (type: string, value: any) => Promise<any>): Promise<Array<any>> {
            const promises: Array<Promise<>> = [ ];
            const process = function(type: ParamType, value: any): any {
                if (type.baseType === "array") {
                    return descend(type.child
                }
                if (type. === "address") {
                }
            };
    
            const descend = function (inputs: Array<ParamType>, values: ReadonlyArray<any>) {
                if (inputs.length !== values.length) { throw new Error("length mismatch"); }
                
            };
    
            const result: Array<any> = [ ];
            values.forEach((value, index) => {
                if (value == null) {
                    topics.push(null);
                } else if (param.baseType === "array" || param.baseType === "tuple") {
                    logger.throwArgumentError("filtering with tuples or arrays not supported", ("contract." + param.name), value);
                } else if (Array.isArray(value)) {
                    topics.push(value.map((value) => encodeTopic(param, value)));
                } else {
                    topics.push(encodeTopic(param, value));
                }
            });
        }
    */ // Create the filter for the event with search criteria (e.g. for eth_filterLog)
    encodeFilterTopics(fragment, values) {
        if (typeof fragment === "string") {
            const f = this.getEvent(fragment);
            (0, index_js_3.assertArgument)(f, "unknown event", "eventFragment", fragment);
            fragment = f;
        }
        (0, index_js_3.assert)(values.length <= fragment.inputs.length, "too many arguments for ".concat(fragment.format()), "UNEXPECTED_ARGUMENT", {
            count: values.length,
            expectedCount: fragment.inputs.length
        });
        const topics = [];
        if (!fragment.anonymous) {
            topics.push(fragment.topicHash);
        }
        // @TODO: Use the coders for this; to properly support tuples, etc.
        const encodeTopic = (param, value)=>{
            if (param.type === "string") {
                return (0, index_js_2.id)(value);
            } else if (param.type === "bytes") {
                return (0, index_js_1.keccak256)((0, index_js_3.hexlify)(value));
            }
            if (param.type === "bool" && typeof value === "boolean") {
                value = value ? "0x01" : "0x00";
            } else if (param.type.match(/^u?int/)) {
                value = (0, index_js_3.toBeHex)(value); // @TODO: Should this toTwos??
            } else if (param.type.match(/^bytes/)) {
                value = (0, index_js_3.zeroPadBytes)(value, 32);
            } else if (param.type === "address") {
                // Check addresses are valid
                _class_private_field_get._(this, _abiCoder).encode([
                    "address"
                ], [
                    value
                ]);
            }
            return (0, index_js_3.zeroPadValue)((0, index_js_3.hexlify)(value), 32);
        };
        values.forEach((value, index)=>{
            const param = fragment.inputs[index];
            if (!param.indexed) {
                (0, index_js_3.assertArgument)(value == null, "cannot filter non-indexed parameters; must be null", "contract." + param.name, value);
                return;
            }
            if (value == null) {
                topics.push(null);
            } else if (param.baseType === "array" || param.baseType === "tuple") {
                (0, index_js_3.assertArgument)(false, "filtering with tuples or arrays not supported", "contract." + param.name, value);
            } else if (Array.isArray(value)) {
                topics.push(value.map((value)=>encodeTopic(param, value)));
            } else {
                topics.push(encodeTopic(param, value));
            }
        });
        // Trim off trailing nulls
        while(topics.length && topics[topics.length - 1] === null){
            topics.pop();
        }
        return topics;
    }
    encodeEventLog(fragment, values) {
        if (typeof fragment === "string") {
            const f = this.getEvent(fragment);
            (0, index_js_3.assertArgument)(f, "unknown event", "eventFragment", fragment);
            fragment = f;
        }
        const topics = [];
        const dataTypes = [];
        const dataValues = [];
        if (!fragment.anonymous) {
            topics.push(fragment.topicHash);
        }
        (0, index_js_3.assertArgument)(values.length === fragment.inputs.length, "event arguments/values mismatch", "values", values);
        fragment.inputs.forEach((param, index)=>{
            const value = values[index];
            if (param.indexed) {
                if (param.type === "string") {
                    topics.push((0, index_js_2.id)(value));
                } else if (param.type === "bytes") {
                    topics.push((0, index_js_1.keccak256)(value));
                } else if (param.baseType === "tuple" || param.baseType === "array") {
                    // @TODO
                    throw new Error("not implemented");
                } else {
                    topics.push(_class_private_field_get._(this, _abiCoder).encode([
                        param.type
                    ], [
                        value
                    ]));
                }
            } else {
                dataTypes.push(param);
                dataValues.push(value);
            }
        });
        return {
            data: _class_private_field_get._(this, _abiCoder).encode(dataTypes, dataValues),
            topics: topics
        };
    }
    // Decode a filter for the event and the search criteria
    decodeEventLog(fragment, data, topics) {
        if (typeof fragment === "string") {
            const f = this.getEvent(fragment);
            (0, index_js_3.assertArgument)(f, "unknown event", "eventFragment", fragment);
            fragment = f;
        }
        if (topics != null && !fragment.anonymous) {
            const eventTopic = fragment.topicHash;
            (0, index_js_3.assertArgument)((0, index_js_3.isHexString)(topics[0], 32) && topics[0].toLowerCase() === eventTopic, "fragment/topic mismatch", "topics[0]", topics[0]);
            topics = topics.slice(1);
        }
        const indexed = [];
        const nonIndexed = [];
        const dynamic = [];
        fragment.inputs.forEach((param, index)=>{
            if (param.indexed) {
                if (param.type === "string" || param.type === "bytes" || param.baseType === "tuple" || param.baseType === "array") {
                    indexed.push(fragments_js_1.ParamType.from({
                        type: "bytes32",
                        name: param.name
                    }));
                    dynamic.push(true);
                } else {
                    indexed.push(param);
                    dynamic.push(false);
                }
            } else {
                nonIndexed.push(param);
                dynamic.push(false);
            }
        });
        const resultIndexed = topics != null ? _class_private_field_get._(this, _abiCoder).decode(indexed, (0, index_js_3.concat)(topics)) : null;
        const resultNonIndexed = _class_private_field_get._(this, _abiCoder).decode(nonIndexed, data, true);
        //const result: (Array<any> & { [ key: string ]: any }) = [ ];
        const values = [];
        const keys = [];
        let nonIndexedIndex = 0, indexedIndex = 0;
        fragment.inputs.forEach((param, index)=>{
            let value = null;
            if (param.indexed) {
                if (resultIndexed == null) {
                    value = new Indexed(null);
                } else if (dynamic[index]) {
                    value = new Indexed(resultIndexed[indexedIndex++]);
                } else {
                    try {
                        value = resultIndexed[indexedIndex++];
                    } catch (error) {
                        value = error;
                    }
                }
            } else {
                try {
                    value = resultNonIndexed[nonIndexedIndex++];
                } catch (error) {
                    value = error;
                }
            }
            values.push(value);
            keys.push(param.name || null);
        });
        return abstract_coder_js_1.Result.fromItems(values, keys);
    }
    /**
     *  Parses a transaction, finding the matching function and extracts
     *  the parameter values along with other useful function details.
     *
     *  If the matching function cannot be found, return null.
     */ parseTransaction(tx) {
        const data = (0, index_js_3.getBytes)(tx.data, "tx.data");
        const value = (0, index_js_3.getBigInt)(tx.value != null ? tx.value : 0, "tx.value");
        const fragment = this.getFunction((0, index_js_3.hexlify)(data.slice(0, 4)));
        if (!fragment) {
            return null;
        }
        const args = _class_private_field_get._(this, _abiCoder).decode(fragment.inputs, data.slice(4));
        return new TransactionDescription(fragment, fragment.selector, args, value);
    }
    parseCallResult(data) {
        throw new Error("@TODO");
    }
    /**
     *  Parses a receipt log, finding the matching event and extracts
     *  the parameter values along with other useful event details.
     *
     *  If the matching event cannot be found, returns null.
     */ parseLog(log) {
        const fragment = this.getEvent(log.topics[0]);
        if (!fragment || fragment.anonymous) {
            return null;
        }
        // @TODO: If anonymous, and the only method, and the input count matches, should we parse?
        //        Probably not, because just because it is the only event in the ABI does
        //        not mean we have the full ABI; maybe just a fragment?
        return new LogDescription(fragment, fragment.topicHash, this.decodeEventLog(fragment, log.data, log.topics));
    }
    /**
     *  Parses a revert data, finding the matching error and extracts
     *  the parameter values along with other useful error details.
     *
     *  If the matching error cannot be found, returns null.
     */ parseError(data) {
        const hexData = (0, index_js_3.hexlify)(data);
        const fragment = this.getError((0, index_js_3.dataSlice)(hexData, 0, 4));
        if (!fragment) {
            return null;
        }
        const args = _class_private_field_get._(this, _abiCoder).decode(fragment.inputs, (0, index_js_3.dataSlice)(hexData, 4));
        return new ErrorDescription(fragment, fragment.selector, args);
    }
    /**
     *  Creates a new [[Interface]] from the ABI %%value%%.
     *
     *  The %%value%% may be provided as an existing [[Interface]] object,
     *  a JSON-encoded ABI or any Human-Readable ABI format.
     */ static from(value) {
        // Already an Interface, which is immutable
        if (value instanceof Interface) {
            return value;
        }
        // JSON
        if (typeof value === "string") {
            return new Interface(JSON.parse(value));
        }
        // An Interface; possibly from another v6 instance
        if (typeof value.formatJson === "function") {
            return new Interface(value.formatJson());
        }
        // A legacy Interface; from an older version
        if (typeof value.format === "function") {
            return new Interface(value.format("json"));
        }
        // Array of fragments
        return new Interface(value);
    }
    /**
     *  Create a new Interface for the %%fragments%%.
     */ constructor(fragments){
        _class_private_method_init._(this, _getFunction);
        _class_private_method_init._(this, _getEvent);
        /**
     *  All the Contract ABI members (i.e. methods, events, errors, etc).
     */ _define_property._(this, "fragments", void 0);
        /**
     *  The Contract constructor.
     */ _define_property._(this, "deploy", void 0);
        /**
     *  The Fallback method, if any.
     */ _define_property._(this, "fallback", void 0);
        /**
     *  If receiving ether is supported.
     */ _define_property._(this, "receive", void 0);
        _class_private_field_init._(this, _errors, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _events, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _functions, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _abiCoder, {
            writable: true,
            value: void 0
        });
        let abi = [];
        if (typeof fragments === "string") {
            abi = JSON.parse(fragments);
        } else {
            abi = fragments;
        }
        _class_private_field_set._(this, _functions, new Map());
        _class_private_field_set._(this, _errors, new Map());
        _class_private_field_set._(this, _events, new Map());
        //        this.#structs = new Map();
        const frags = [];
        for (const a of abi){
            try {
                frags.push(fragments_js_1.Fragment.from(a));
            } catch (error) {
                console.log("[Warning] Invalid Fragment ".concat(JSON.stringify(a), ":"), error.message);
            }
        }
        (0, index_js_3.defineProperties)(this, {
            fragments: Object.freeze(frags)
        });
        let fallback = null;
        let receive = false;
        _class_private_field_set._(this, _abiCoder, this.getAbiCoder());
        // Add all fragments by their signature
        this.fragments.forEach((fragment, index)=>{
            let bucket;
            switch(fragment.type){
                case "constructor":
                    if (this.deploy) {
                        console.log("duplicate definition - constructor");
                        return;
                    }
                    //checkNames(fragment, "input", fragment.inputs);
                    (0, index_js_3.defineProperties)(this, {
                        deploy: fragment
                    });
                    return;
                case "fallback":
                    if (fragment.inputs.length === 0) {
                        receive = true;
                    } else {
                        (0, index_js_3.assertArgument)(!fallback || fragment.payable !== fallback.payable, "conflicting fallback fragments", "fragments[".concat(index, "]"), fragment);
                        fallback = fragment;
                        receive = fallback.payable;
                    }
                    return;
                case "function":
                    //checkNames(fragment, "input", fragment.inputs);
                    //checkNames(fragment, "output", (<FunctionFragment>fragment).outputs);
                    bucket = _class_private_field_get._(this, _functions);
                    break;
                case "event":
                    //checkNames(fragment, "input", fragment.inputs);
                    bucket = _class_private_field_get._(this, _events);
                    break;
                case "error":
                    bucket = _class_private_field_get._(this, _errors);
                    break;
                default:
                    return;
            }
            // Two identical entries; ignore it
            const signature = fragment.format();
            if (bucket.has(signature)) {
                return;
            }
            bucket.set(signature, fragment);
        });
        // If we do not have a constructor add a default
        if (!this.deploy) {
            (0, index_js_3.defineProperties)(this, {
                deploy: fragments_js_1.ConstructorFragment.from("constructor()")
            });
        }
        (0, index_js_3.defineProperties)(this, {
            fallback,
            receive
        });
    }
}
function getFunction(key, values, forceUnique) {
    // Selector
    if ((0, index_js_3.isHexString)(key)) {
        const selector = key.toLowerCase();
        for (const fragment of _class_private_field_get._(this, _functions).values()){
            if (selector === fragment.selector) {
                return fragment;
            }
        }
        return null;
    }
    // It is a bare name, look up the function (will return null if ambiguous)
    if (key.indexOf("(") === -1) {
        const matching = [];
        for (const [name, fragment] of _class_private_field_get._(this, _functions)){
            if (name.split("(" /* fix:) */ )[0] === key) {
                matching.push(fragment);
            }
        }
        if (values) {
            const lastValue = values.length > 0 ? values[values.length - 1] : null;
            let valueLength = values.length;
            let allowOptions = true;
            if (typed_js_1.Typed.isTyped(lastValue) && lastValue.type === "overrides") {
                allowOptions = false;
                valueLength--;
            }
            // Remove all matches that don't have a compatible length. The args
            // may contain an overrides, so the match may have n or n - 1 parameters
            for(let i = matching.length - 1; i >= 0; i--){
                const inputs = matching[i].inputs.length;
                if (inputs !== valueLength && (!allowOptions || inputs !== valueLength - 1)) {
                    matching.splice(i, 1);
                }
            }
            // Remove all matches that don't match the Typed signature
            for(let i = matching.length - 1; i >= 0; i--){
                const inputs = matching[i].inputs;
                for(let j = 0; j < values.length; j++){
                    // Not a typed value
                    if (!typed_js_1.Typed.isTyped(values[j])) {
                        continue;
                    }
                    // We are past the inputs
                    if (j >= inputs.length) {
                        if (values[j].type === "overrides") {
                            continue;
                        }
                        matching.splice(i, 1);
                        break;
                    }
                    // Make sure the value type matches the input type
                    if (values[j].type !== inputs[j].baseType) {
                        matching.splice(i, 1);
                        break;
                    }
                }
            }
        }
        // We found a single matching signature with an overrides, but the
        // last value is something that cannot possibly be an options
        if (matching.length === 1 && values && values.length !== matching[0].inputs.length) {
            const lastArg = values[values.length - 1];
            if (lastArg == null || Array.isArray(lastArg) || typeof lastArg !== "object") {
                matching.splice(0, 1);
            }
        }
        if (matching.length === 0) {
            return null;
        }
        if (matching.length > 1 && forceUnique) {
            const matchStr = matching.map((m)=>JSON.stringify(m.format())).join(", ");
            (0, index_js_3.assertArgument)(false, "ambiguous function description (i.e. matches ".concat(matchStr, ")"), "key", key);
        }
        return matching[0];
    }
    // Normalize the signature and lookup the function
    const result = _class_private_field_get._(this, _functions).get(fragments_js_1.FunctionFragment.from(key).format());
    if (result) {
        return result;
    }
    return null;
}
function getEvent(key, values, forceUnique) {
    // EventTopic
    if ((0, index_js_3.isHexString)(key)) {
        const eventTopic = key.toLowerCase();
        for (const fragment of _class_private_field_get._(this, _events).values()){
            if (eventTopic === fragment.topicHash) {
                return fragment;
            }
        }
        return null;
    }
    // It is a bare name, look up the function (will return null if ambiguous)
    if (key.indexOf("(") === -1) {
        const matching = [];
        for (const [name, fragment] of _class_private_field_get._(this, _events)){
            if (name.split("(" /* fix:) */ )[0] === key) {
                matching.push(fragment);
            }
        }
        if (values) {
            // Remove all matches that don't have a compatible length.
            for(let i = matching.length - 1; i >= 0; i--){
                if (matching[i].inputs.length < values.length) {
                    matching.splice(i, 1);
                }
            }
            // Remove all matches that don't match the Typed signature
            for(let i = matching.length - 1; i >= 0; i--){
                const inputs = matching[i].inputs;
                for(let j = 0; j < values.length; j++){
                    // Not a typed value
                    if (!typed_js_1.Typed.isTyped(values[j])) {
                        continue;
                    }
                    // Make sure the value type matches the input type
                    if (values[j].type !== inputs[j].baseType) {
                        matching.splice(i, 1);
                        break;
                    }
                }
            }
        }
        if (matching.length === 0) {
            return null;
        }
        if (matching.length > 1 && forceUnique) {
            const matchStr = matching.map((m)=>JSON.stringify(m.format())).join(", ");
            (0, index_js_3.assertArgument)(false, "ambiguous event description (i.e. matches ".concat(matchStr, ")"), "key", key);
        }
        return matching[0];
    }
    // Normalize the signature and lookup the function
    const result = _class_private_field_get._(this, _events).get(fragments_js_1.EventFragment.from(key).format());
    if (result) {
        return result;
    }
    return null;
}
exports.Interface = Interface; //# sourceMappingURL=interface.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  The Application Binary Interface (ABI) describes how method input
 *  parameters should be encoded, their results decoded, and how to
 *  decode events and errors.
 *
 *  See [About ABIs](docs-abi) for more details how they are used.
 *
 *  @_section api/abi:Application Binary Interface  [about-abi]
 *  @_navTitle: ABI
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Typed = exports.Result = exports.TransactionDescription = exports.LogDescription = exports.ErrorDescription = exports.Interface = exports.Indexed = exports.checkResultErrors = exports.StructFragment = exports.ParamType = exports.NamedFragment = exports.FunctionFragment = exports.Fragment = exports.FallbackFragment = exports.EventFragment = exports.ErrorFragment = exports.ConstructorFragment = exports.encodeBytes32String = exports.decodeBytes32String = exports.AbiCoder = void 0;
//////
var abi_coder_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/abi-coder.js [app-client] (ecmascript)");
Object.defineProperty(exports, "AbiCoder", {
    enumerable: true,
    get: function() {
        return abi_coder_js_1.AbiCoder;
    }
});
var bytes32_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/bytes32.js [app-client] (ecmascript)");
Object.defineProperty(exports, "decodeBytes32String", {
    enumerable: true,
    get: function() {
        return bytes32_js_1.decodeBytes32String;
    }
});
Object.defineProperty(exports, "encodeBytes32String", {
    enumerable: true,
    get: function() {
        return bytes32_js_1.encodeBytes32String;
    }
});
var fragments_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/fragments.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ConstructorFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.ConstructorFragment;
    }
});
Object.defineProperty(exports, "ErrorFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.ErrorFragment;
    }
});
Object.defineProperty(exports, "EventFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.EventFragment;
    }
});
Object.defineProperty(exports, "FallbackFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.FallbackFragment;
    }
});
Object.defineProperty(exports, "Fragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.Fragment;
    }
});
Object.defineProperty(exports, "FunctionFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.FunctionFragment;
    }
});
Object.defineProperty(exports, "NamedFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.NamedFragment;
    }
});
Object.defineProperty(exports, "ParamType", {
    enumerable: true,
    get: function() {
        return fragments_js_1.ParamType;
    }
});
Object.defineProperty(exports, "StructFragment", {
    enumerable: true,
    get: function() {
        return fragments_js_1.StructFragment;
    }
});
var interface_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/interface.js [app-client] (ecmascript)");
Object.defineProperty(exports, "checkResultErrors", {
    enumerable: true,
    get: function() {
        return interface_js_1.checkResultErrors;
    }
});
Object.defineProperty(exports, "Indexed", {
    enumerable: true,
    get: function() {
        return interface_js_1.Indexed;
    }
});
Object.defineProperty(exports, "Interface", {
    enumerable: true,
    get: function() {
        return interface_js_1.Interface;
    }
});
Object.defineProperty(exports, "ErrorDescription", {
    enumerable: true,
    get: function() {
        return interface_js_1.ErrorDescription;
    }
});
Object.defineProperty(exports, "LogDescription", {
    enumerable: true,
    get: function() {
        return interface_js_1.LogDescription;
    }
});
Object.defineProperty(exports, "TransactionDescription", {
    enumerable: true,
    get: function() {
        return interface_js_1.TransactionDescription;
    }
});
Object.defineProperty(exports, "Result", {
    enumerable: true,
    get: function() {
        return interface_js_1.Result;
    }
});
var typed_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/typed.js [app-client] (ecmascript)");
Object.defineProperty(exports, "Typed", {
    enumerable: true,
    get: function() {
        return typed_js_1.Typed;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TransactionResponse = exports.TransactionReceipt = exports.Log = exports.Block = exports.copyRequest = exports.FeeData = void 0;
//import { resolveAddress } from "@ethersproject/address";
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
// -----------------------
function getValue(value) {
    if (value == null) {
        return null;
    }
    return value;
}
function toJson(value) {
    if (value == null) {
        return null;
    }
    return value.toString();
}
// @TODO? <T extends FeeData = { }> implements Required<T>
/**
 *  A **FeeData** wraps all the fee-related values associated with
 *  the network.
 */ class FeeData {
    /**
     *  Returns a JSON-friendly value.
     */ toJSON() {
        const { gasPrice, maxFeePerGas, maxPriorityFeePerGas } = this;
        return {
            _type: "FeeData",
            gasPrice: toJson(gasPrice),
            maxFeePerGas: toJson(maxFeePerGas),
            maxPriorityFeePerGas: toJson(maxPriorityFeePerGas)
        };
    }
    /**
     *  Creates a new FeeData for %%gasPrice%%, %%maxFeePerGas%% and
     *  %%maxPriorityFeePerGas%%.
     */ constructor(gasPrice, maxFeePerGas, maxPriorityFeePerGas){
        /**
     *  The gas price for legacy networks.
     */ _define_property._(this, "gasPrice", void 0);
        /**
     *  The maximum fee to pay per gas.
     *
     *  The base fee per gas is defined by the network and based on
     *  congestion, increasing the cost during times of heavy load
     *  and lowering when less busy.
     *
     *  The actual fee per gas will be the base fee for the block
     *  and the priority fee, up to the max fee per gas.
     *
     *  This will be ``null`` on legacy networks (i.e. [pre-EIP-1559](link-eip-1559))
     */ _define_property._(this, "maxFeePerGas", void 0);
        /**
     *  The additional amout to pay per gas to encourage a validator
     *  to include the transaction.
     *
     *  The purpose of this is to compensate the validator for the
     *  adjusted risk for including a given transaction.
     *
     *  This will be ``null`` on legacy networks (i.e. [pre-EIP-1559](link-eip-1559))
     */ _define_property._(this, "maxPriorityFeePerGas", void 0);
        (0, index_js_1.defineProperties)(this, {
            gasPrice: getValue(gasPrice),
            maxFeePerGas: getValue(maxFeePerGas),
            maxPriorityFeePerGas: getValue(maxPriorityFeePerGas)
        });
    }
}
exports.FeeData = FeeData;
;
/**
 *  Returns a copy of %%req%% with all properties coerced to their strict
 *  types.
 */ function copyRequest(req) {
    const result = {};
    // These could be addresses, ENS names or Addressables
    if (req.to) {
        result.to = req.to;
    }
    if (req.from) {
        result.from = req.from;
    }
    if (req.data) {
        result.data = (0, index_js_1.hexlify)(req.data);
    }
    const bigIntKeys = "chainId,gasLimit,gasPrice,maxFeePerBlobGas,maxFeePerGas,maxPriorityFeePerGas,value".split(/,/);
    for (const key of bigIntKeys){
        if (!(key in req) || req[key] == null) {
            continue;
        }
        result[key] = (0, index_js_1.getBigInt)(req[key], "request.".concat(key));
    }
    const numberKeys = "type,nonce".split(/,/);
    for (const key of numberKeys){
        if (!(key in req) || req[key] == null) {
            continue;
        }
        result[key] = (0, index_js_1.getNumber)(req[key], "request.".concat(key));
    }
    if (req.accessList) {
        result.accessList = (0, index_js_2.accessListify)(req.accessList);
    }
    if (req.authorizationList) {
        result.authorizationList = req.authorizationList.slice();
    }
    if ("blockTag" in req) {
        result.blockTag = req.blockTag;
    }
    if ("enableCcipRead" in req) {
        result.enableCcipRead = !!req.enableCcipRead;
    }
    if ("customData" in req) {
        result.customData = req.customData;
    }
    if ("blobVersionedHashes" in req && req.blobVersionedHashes) {
        result.blobVersionedHashes = req.blobVersionedHashes.slice();
    }
    if ("kzg" in req) {
        result.kzg = req.kzg;
    }
    if ("blobs" in req && req.blobs) {
        result.blobs = req.blobs.map((b)=>{
            if ((0, index_js_1.isBytesLike)(b)) {
                return (0, index_js_1.hexlify)(b);
            }
            return Object.assign({}, b);
        });
    }
    return result;
}
exports.copyRequest = copyRequest;
var _transactions = /*#__PURE__*/ new WeakMap();
/**
 *  A **Block** represents the data associated with a full block on
 *  Ethereum.
 */ class Block {
    /**
     *  Returns the list of transaction hashes, in the order
     *  they were executed within the block.
     */ get transactions() {
        return _class_private_field_get._(this, _transactions).map((tx)=>{
            if (typeof tx === "string") {
                return tx;
            }
            return tx.hash;
        });
    }
    /**
     *  Returns the complete transactions, in the order they
     *  were executed within the block.
     *
     *  This is only available for blocks which prefetched
     *  transactions, by passing ``true`` to %%prefetchTxs%%
     *  into [[Provider-getBlock]].
     */ get prefetchedTransactions() {
        const txs = _class_private_field_get._(this, _transactions).slice();
        // Doesn't matter...
        if (txs.length === 0) {
            return [];
        }
        // Make sure we prefetched the transactions
        (0, index_js_1.assert)(typeof txs[0] === "object", "transactions were not prefetched with block request", "UNSUPPORTED_OPERATION", {
            operation: "transactionResponses()"
        });
        return txs;
    }
    /**
     *  Returns a JSON-friendly value.
     */ toJSON() {
        const { baseFeePerGas, difficulty, extraData, gasLimit, gasUsed, hash, miner, prevRandao, nonce, number, parentHash, parentBeaconBlockRoot, stateRoot, receiptsRoot, timestamp, transactions } = this;
        return {
            _type: "Block",
            baseFeePerGas: toJson(baseFeePerGas),
            difficulty: toJson(difficulty),
            extraData,
            gasLimit: toJson(gasLimit),
            gasUsed: toJson(gasUsed),
            blobGasUsed: toJson(this.blobGasUsed),
            excessBlobGas: toJson(this.excessBlobGas),
            hash,
            miner,
            prevRandao,
            nonce,
            number,
            parentHash,
            timestamp,
            parentBeaconBlockRoot,
            stateRoot,
            receiptsRoot,
            transactions
        };
    }
    [Symbol.iterator]() {
        let index = 0;
        const txs = this.transactions;
        return {
            next: ()=>{
                if (index < this.length) {
                    return {
                        value: txs[index++],
                        done: false
                    };
                }
                return {
                    value: undefined,
                    done: true
                };
            }
        };
    }
    /**
     *  The number of transactions in this block.
     */ get length() {
        return _class_private_field_get._(this, _transactions).length;
    }
    /**
     *  The [[link-js-date]] this block was included at.
     */ get date() {
        if (this.timestamp == null) {
            return null;
        }
        return new Date(this.timestamp * 1000);
    }
    /**
     *  Get the transaction at %%indexe%% within this block.
     */ async getTransaction(indexOrHash) {
        // Find the internal value by its index or hash
        let tx = undefined;
        if (typeof indexOrHash === "number") {
            tx = _class_private_field_get._(this, _transactions)[indexOrHash];
        } else {
            const hash = indexOrHash.toLowerCase();
            for (const v of _class_private_field_get._(this, _transactions)){
                if (typeof v === "string") {
                    if (v !== hash) {
                        continue;
                    }
                    tx = v;
                    break;
                } else {
                    if (v.hash !== hash) {
                        continue;
                    }
                    tx = v;
                    break;
                }
            }
        }
        if (tx == null) {
            throw new Error("no such tx");
        }
        if (typeof tx === "string") {
            return await this.provider.getTransaction(tx);
        } else {
            return tx;
        }
    }
    /**
     *  If a **Block** was fetched with a request to include the transactions
     *  this will allow synchronous access to those transactions.
     *
     *  If the transactions were not prefetched, this will throw.
     */ getPrefetchedTransaction(indexOrHash) {
        const txs = this.prefetchedTransactions;
        if (typeof indexOrHash === "number") {
            return txs[indexOrHash];
        }
        indexOrHash = indexOrHash.toLowerCase();
        for (const tx of txs){
            if (tx.hash === indexOrHash) {
                return tx;
            }
        }
        (0, index_js_1.assertArgument)(false, "no matching transaction", "indexOrHash", indexOrHash);
    }
    /**
     *  Returns true if this block been mined. This provides a type guard
     *  for all properties on a [[MinedBlock]].
     */ isMined() {
        return !!this.hash;
    }
    /**
     *  Returns true if this block is an [[link-eip-2930]] block.
     */ isLondon() {
        return !!this.baseFeePerGas;
    }
    /**
     *  @_ignore:
     */ orphanedEvent() {
        if (!this.isMined()) {
            throw new Error("");
        }
        return createOrphanedBlockFilter(this);
    }
    /**
     *  Create a new **Block** object.
     *
     *  This should generally not be necessary as the unless implementing a
     *  low-level library.
     */ constructor(block, provider){
        /**
     *  The provider connected to the block used to fetch additional details
     *  if necessary.
     */ _define_property._(this, "provider", void 0);
        /**
     *  The block number, sometimes called the block height. This is a
     *  sequential number that is one higher than the parent block.
     */ _define_property._(this, "number", void 0);
        /**
     *  The block hash.
     *
     *  This hash includes all properties, so can be safely used to identify
     *  an exact set of block properties.
     */ _define_property._(this, "hash", void 0);
        /**
     *  The timestamp for this block, which is the number of seconds since
     *  epoch that this block was included.
     */ _define_property._(this, "timestamp", void 0);
        /**
     *  The block hash of the parent block.
     */ _define_property._(this, "parentHash", void 0);
        /**
     *  The hash tree root of the parent beacon block for the given
     *  execution block. See [[link-eip-4788]].
     */ _define_property._(this, "parentBeaconBlockRoot", void 0);
        /**
     *  The nonce.
     *
     *  On legacy networks, this is the random number inserted which
     *  permitted the difficulty target to be reached.
     */ _define_property._(this, "nonce", void 0);
        /**
     *  The difficulty target.
     *
     *  On legacy networks, this is the proof-of-work target required
     *  for a block to meet the protocol rules to be included.
     *
     *  On modern networks, this is a random number arrived at using
     *  randao.  @TODO: Find links?
     */ _define_property._(this, "difficulty", void 0);
        /**
     *  The total gas limit for this block.
     */ _define_property._(this, "gasLimit", void 0);
        /**
     *  The total gas used in this block.
     */ _define_property._(this, "gasUsed", void 0);
        /**
     *  The root hash for the global state after applying changes
     *  in this block.
     */ _define_property._(this, "stateRoot", void 0);
        /**
     *  The hash of the transaction receipts trie.
     */ _define_property._(this, "receiptsRoot", void 0);
        /**
     *  The total amount of blob gas consumed by the transactions
     *  within the block. See [[link-eip-4844]].
     */ _define_property._(this, "blobGasUsed", void 0);
        /**
     *  The running total of blob gas consumed in excess of the
     *  target, prior to the block. See [[link-eip-4844]].
     */ _define_property._(this, "excessBlobGas", void 0);
        /**
     *  The miner coinbase address, wihch receives any subsidies for
     *  including this block.
     */ _define_property._(this, "miner", void 0);
        /**
     *  The latest RANDAO mix of the post beacon state of
     *  the previous block.
     */ _define_property._(this, "prevRandao", void 0);
        /**
     *  Any extra data the validator wished to include.
     */ _define_property._(this, "extraData", void 0);
        /**
     *  The base fee per gas that all transactions in this block were
     *  charged.
     *
     *  This adjusts after each block, depending on how congested the network
     *  is.
     */ _define_property._(this, "baseFeePerGas", void 0);
        _class_private_field_init._(this, _transactions, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _transactions, block.transactions.map((tx)=>{
            if (typeof tx !== "string") {
                return new TransactionResponse(tx, provider);
            }
            return tx;
        }));
        (0, index_js_1.defineProperties)(this, {
            provider,
            hash: getValue(block.hash),
            number: block.number,
            timestamp: block.timestamp,
            parentHash: block.parentHash,
            parentBeaconBlockRoot: block.parentBeaconBlockRoot,
            nonce: block.nonce,
            difficulty: block.difficulty,
            gasLimit: block.gasLimit,
            gasUsed: block.gasUsed,
            blobGasUsed: block.blobGasUsed,
            excessBlobGas: block.excessBlobGas,
            miner: block.miner,
            prevRandao: getValue(block.prevRandao),
            extraData: block.extraData,
            baseFeePerGas: getValue(block.baseFeePerGas),
            stateRoot: block.stateRoot,
            receiptsRoot: block.receiptsRoot
        });
    }
}
exports.Block = Block;
//////////////////////
// Log
/**
 *  A **Log** in Ethereum represents an event that has been included in a
 *  transaction using the ``LOG*`` opcodes, which are most commonly used by
 *  Solidity's emit for announcing events.
 */ class Log {
    /**
     *  Returns a JSON-compatible object.
     */ toJSON() {
        const { address, blockHash, blockNumber, data, index, removed, topics, transactionHash, transactionIndex } = this;
        return {
            _type: "log",
            address,
            blockHash,
            blockNumber,
            data,
            index,
            removed,
            topics,
            transactionHash,
            transactionIndex
        };
    }
    /**
     *  Returns the block that this log occurred in.
     */ async getBlock() {
        const block = await this.provider.getBlock(this.blockHash);
        (0, index_js_1.assert)(!!block, "failed to find transaction", "UNKNOWN_ERROR", {});
        return block;
    }
    /**
     *  Returns the transaction that this log occurred in.
     */ async getTransaction() {
        const tx = await this.provider.getTransaction(this.transactionHash);
        (0, index_js_1.assert)(!!tx, "failed to find transaction", "UNKNOWN_ERROR", {});
        return tx;
    }
    /**
     *  Returns the transaction receipt fot the transaction that this
     *  log occurred in.
     */ async getTransactionReceipt() {
        const receipt = await this.provider.getTransactionReceipt(this.transactionHash);
        (0, index_js_1.assert)(!!receipt, "failed to find transaction receipt", "UNKNOWN_ERROR", {});
        return receipt;
    }
    /**
     *  @_ignore:
     */ removedEvent() {
        return createRemovedLogFilter(this);
    }
    /**
     *  @_ignore:
     */ constructor(log, provider){
        /**
     *  The provider connected to the log used to fetch additional details
     *  if necessary.
     */ _define_property._(this, "provider", void 0);
        /**
     *  The transaction hash of the transaction this log occurred in. Use the
     *  [[Log-getTransaction]] to get the [[TransactionResponse]].
     */ _define_property._(this, "transactionHash", void 0);
        /**
     *  The block hash of the block this log occurred in. Use the
     *  [[Log-getBlock]] to get the [[Block]].
     */ _define_property._(this, "blockHash", void 0);
        /**
     *  The block number of the block this log occurred in. It is preferred
     *  to use the [[Block-hash]] when fetching the related [[Block]],
     *  since in the case of an orphaned block, the block at that height may
     *  have changed.
     */ _define_property._(this, "blockNumber", void 0);
        /**
     *  If the **Log** represents a block that was removed due to an orphaned
     *  block, this will be true.
     *
     *  This can only happen within an orphan event listener.
     */ _define_property._(this, "removed", void 0);
        /**
     *  The address of the contract that emitted this log.
     */ _define_property._(this, "address", void 0);
        /**
     *  The data included in this log when it was emitted.
     */ _define_property._(this, "data", void 0);
        /**
     *  The indexed topics included in this log when it was emitted.
     *
     *  All topics are included in the bloom filters, so they can be
     *  efficiently filtered using the [[Provider-getLogs]] method.
     */ _define_property._(this, "topics", void 0);
        /**
     *  The index within the block this log occurred at. This is generally
     *  not useful to developers, but can be used with the various roots
     *  to proof inclusion within a block.
     */ _define_property._(this, "index", void 0);
        /**
     *  The index within the transaction of this log.
     */ _define_property._(this, "transactionIndex", void 0);
        this.provider = provider;
        const topics = Object.freeze(log.topics.slice());
        (0, index_js_1.defineProperties)(this, {
            transactionHash: log.transactionHash,
            blockHash: log.blockHash,
            blockNumber: log.blockNumber,
            removed: log.removed,
            address: log.address,
            data: log.data,
            topics,
            index: log.index,
            transactionIndex: log.transactionIndex
        });
    }
}
exports.Log = Log;
var _logs = /*#__PURE__*/ new WeakMap();
//////////////////////
// Transaction Receipt
/*
export interface LegacyTransactionReceipt {
    byzantium: false;
    status: null;
    root: string;
}

export interface ByzantiumTransactionReceipt {
    byzantium: true;
    status: number;
    root: null;
}
*/ /**
 *  A **TransactionReceipt** includes additional information about a
 *  transaction that is only available after it has been mined.
 */ class TransactionReceipt {
    /**
     *  The logs for this transaction.
     */ get logs() {
        return _class_private_field_get._(this, _logs);
    }
    /**
     *  Returns a JSON-compatible representation.
     */ toJSON() {
        const { to, from, contractAddress, hash, index, blockHash, blockNumber, logsBloom, logs, status, root } = this;
        return {
            _type: "TransactionReceipt",
            blockHash,
            blockNumber,
            //byzantium, 
            contractAddress,
            cumulativeGasUsed: toJson(this.cumulativeGasUsed),
            from,
            gasPrice: toJson(this.gasPrice),
            blobGasUsed: toJson(this.blobGasUsed),
            blobGasPrice: toJson(this.blobGasPrice),
            gasUsed: toJson(this.gasUsed),
            hash,
            index,
            logs,
            logsBloom,
            root,
            status,
            to
        };
    }
    /**
     *  @_ignore:
     */ get length() {
        return this.logs.length;
    }
    [Symbol.iterator]() {
        let index = 0;
        return {
            next: ()=>{
                if (index < this.length) {
                    return {
                        value: this.logs[index++],
                        done: false
                    };
                }
                return {
                    value: undefined,
                    done: true
                };
            }
        };
    }
    /**
     *  The total fee for this transaction, in wei.
     */ get fee() {
        return this.gasUsed * this.gasPrice;
    }
    /**
     *  Resolves to the block this transaction occurred in.
     */ async getBlock() {
        const block = await this.provider.getBlock(this.blockHash);
        if (block == null) {
            throw new Error("TODO");
        }
        return block;
    }
    /**
     *  Resolves to the transaction this transaction occurred in.
     */ async getTransaction() {
        const tx = await this.provider.getTransaction(this.hash);
        if (tx == null) {
            throw new Error("TODO");
        }
        return tx;
    }
    /**
     *  Resolves to the return value of the execution of this transaction.
     *
     *  Support for this feature is limited, as it requires an archive node
     *  with the ``debug_`` or ``trace_`` API enabled.
     */ async getResult() {
        return await this.provider.getTransactionResult(this.hash);
    }
    /**
     *  Resolves to the number of confirmations this transaction has.
     */ async confirmations() {
        return await this.provider.getBlockNumber() - this.blockNumber + 1;
    }
    /**
     *  @_ignore:
     */ removedEvent() {
        return createRemovedTransactionFilter(this);
    }
    /**
     *  @_ignore:
     */ reorderedEvent(other) {
        (0, index_js_1.assert)(!other || other.isMined(), "unmined 'other' transction cannot be orphaned", "UNSUPPORTED_OPERATION", {
            operation: "reorderedEvent(other)"
        });
        return createReorderedTransactionFilter(this, other);
    }
    /**
     *  @_ignore:
     */ constructor(tx, provider){
        /**
     *  The provider connected to the log used to fetch additional details
     *  if necessary.
     */ _define_property._(this, "provider", void 0);
        /**
     *  The address the transaction was sent to.
     */ _define_property._(this, "to", void 0);
        /**
     *  The sender of the transaction.
     */ _define_property._(this, "from", void 0);
        /**
     *  The address of the contract if the transaction was directly
     *  responsible for deploying one.
     *
     *  This is non-null **only** if the ``to`` is empty and the ``data``
     *  was successfully executed as initcode.
     */ _define_property._(this, "contractAddress", void 0);
        /**
     *  The transaction hash.
     */ _define_property._(this, "hash", void 0);
        /**
     *  The index of this transaction within the block transactions.
     */ _define_property._(this, "index", void 0);
        /**
     *  The block hash of the [[Block]] this transaction was included in.
     */ _define_property._(this, "blockHash", void 0);
        /**
     *  The block number of the [[Block]] this transaction was included in.
     */ _define_property._(this, "blockNumber", void 0);
        /**
     *  The bloom filter bytes that represent all logs that occurred within
     *  this transaction. This is generally not useful for most developers,
     *  but can be used to validate the included logs.
     */ _define_property._(this, "logsBloom", void 0);
        /**
     *  The actual amount of gas used by this transaction.
     *
     *  When creating a transaction, the amount of gas that will be used can
     *  only be approximated, but the sender must pay the gas fee for the
     *  entire gas limit. After the transaction, the difference is refunded.
     */ _define_property._(this, "gasUsed", void 0);
        /**
     *  The gas used for BLObs. See [[link-eip-4844]].
     */ _define_property._(this, "blobGasUsed", void 0);
        /**
     *  The amount of gas used by all transactions within the block for this
     *  and all transactions with a lower ``index``.
     *
     *  This is generally not useful for developers but can be used to
     *  validate certain aspects of execution.
     */ _define_property._(this, "cumulativeGasUsed", void 0);
        /**
     *  The actual gas price used during execution.
     *
     *  Due to the complexity of [[link-eip-1559]] this value can only
     *  be caluclated after the transaction has been mined, snce the base
     *  fee is protocol-enforced.
     */ _define_property._(this, "gasPrice", void 0);
        /**
     *  The price paid per BLOB in gas. See [[link-eip-4844]].
     */ _define_property._(this, "blobGasPrice", void 0);
        /**
     *  The [[link-eip-2718]] transaction type.
     */ _define_property._(this, "type", void 0);
        //readonly byzantium!: boolean;
        /**
     *  The status of this transaction, indicating success (i.e. ``1``) or
     *  a revert (i.e. ``0``).
     *
     *  This is available in post-byzantium blocks, but some backends may
     *  backfill this value.
     */ _define_property._(this, "status", void 0);
        /**
     *  The root hash of this transaction.
     *
     *  This is no present and was only included in pre-byzantium blocks, but
     *  could be used to validate certain parts of the receipt.
     */ _define_property._(this, "root", void 0);
        _class_private_field_init._(this, _logs, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _logs, Object.freeze(tx.logs.map((log)=>{
            return new Log(log, provider);
        })));
        let gasPrice = BN_0;
        if (tx.effectiveGasPrice != null) {
            gasPrice = tx.effectiveGasPrice;
        } else if (tx.gasPrice != null) {
            gasPrice = tx.gasPrice;
        }
        (0, index_js_1.defineProperties)(this, {
            provider,
            to: tx.to,
            from: tx.from,
            contractAddress: tx.contractAddress,
            hash: tx.hash,
            index: tx.index,
            blockHash: tx.blockHash,
            blockNumber: tx.blockNumber,
            logsBloom: tx.logsBloom,
            gasUsed: tx.gasUsed,
            cumulativeGasUsed: tx.cumulativeGasUsed,
            blobGasUsed: tx.blobGasUsed,
            gasPrice,
            blobGasPrice: tx.blobGasPrice,
            type: tx.type,
            //byzantium: tx.byzantium,
            status: tx.status,
            root: tx.root
        });
    }
}
exports.TransactionReceipt = TransactionReceipt;
var _startBlock = /*#__PURE__*/ new WeakMap();
/**
 *  A **TransactionResponse** includes all properties about a transaction
 *  that was sent to the network, which may or may not be included in a
 *  block.
 *
 *  The [[TransactionResponse-isMined]] can be used to check if the
 *  transaction has been mined as well as type guard that the otherwise
 *  possibly ``null`` properties are defined.
 */ class TransactionResponse {
    /**
     *  Returns a JSON-compatible representation of this transaction.
     */ toJSON() {
        const { blockNumber, blockHash, index, hash, type, to, from, nonce, data, signature, accessList, blobVersionedHashes } = this;
        return {
            _type: "TransactionResponse",
            accessList,
            blockNumber,
            blockHash,
            blobVersionedHashes,
            chainId: toJson(this.chainId),
            data,
            from,
            gasLimit: toJson(this.gasLimit),
            gasPrice: toJson(this.gasPrice),
            hash,
            maxFeePerGas: toJson(this.maxFeePerGas),
            maxPriorityFeePerGas: toJson(this.maxPriorityFeePerGas),
            maxFeePerBlobGas: toJson(this.maxFeePerBlobGas),
            nonce,
            signature,
            to,
            index,
            type,
            value: toJson(this.value)
        };
    }
    /**
     *  Resolves to the Block that this transaction was included in.
     *
     *  This will return null if the transaction has not been included yet.
     */ async getBlock() {
        let blockNumber = this.blockNumber;
        if (blockNumber == null) {
            const tx = await this.getTransaction();
            if (tx) {
                blockNumber = tx.blockNumber;
            }
        }
        if (blockNumber == null) {
            return null;
        }
        const block = this.provider.getBlock(blockNumber);
        if (block == null) {
            throw new Error("TODO");
        }
        return block;
    }
    /**
     *  Resolves to this transaction being re-requested from the
     *  provider. This can be used if you have an unmined transaction
     *  and wish to get an up-to-date populated instance.
     */ async getTransaction() {
        return this.provider.getTransaction(this.hash);
    }
    /**
     *  Resolve to the number of confirmations this transaction has.
     */ async confirmations() {
        if (this.blockNumber == null) {
            const { tx, blockNumber } = await (0, index_js_1.resolveProperties)({
                tx: this.getTransaction(),
                blockNumber: this.provider.getBlockNumber()
            });
            // Not mined yet...
            if (tx == null || tx.blockNumber == null) {
                return 0;
            }
            return blockNumber - tx.blockNumber + 1;
        }
        const blockNumber = await this.provider.getBlockNumber();
        return blockNumber - this.blockNumber + 1;
    }
    /**
     *  Resolves once this transaction has been mined and has
     *  %%confirms%% blocks including it (default: ``1``) with an
     *  optional %%timeout%%.
     *
     *  This can resolve to ``null`` only if %%confirms%% is ``0``
     *  and the transaction has not been mined, otherwise this will
     *  wait until enough confirmations have completed.
     */ async wait(_confirms, _timeout) {
        const confirms = _confirms == null ? 1 : _confirms;
        const timeout = _timeout == null ? 0 : _timeout;
        let startBlock = _class_private_field_get._(this, _startBlock);
        let nextScan = -1;
        let stopScanning = startBlock === -1 ? true : false;
        const checkReplacement = async ()=>{
            // Get the current transaction count for this sender
            if (stopScanning) {
                return null;
            }
            const { blockNumber, nonce } = await (0, index_js_1.resolveProperties)({
                blockNumber: this.provider.getBlockNumber(),
                nonce: this.provider.getTransactionCount(this.from)
            });
            // No transaction or our nonce has not been mined yet; but we
            // can start scanning later when we do start
            if (nonce < this.nonce) {
                startBlock = blockNumber;
                return;
            }
            // We were mined; no replacement
            if (stopScanning) {
                return null;
            }
            const mined = await this.getTransaction();
            if (mined && mined.blockNumber != null) {
                return;
            }
            // We were replaced; start scanning for that transaction
            // Starting to scan; look back a few extra blocks for safety
            if (nextScan === -1) {
                nextScan = startBlock - 3;
                if (nextScan < _class_private_field_get._(this, _startBlock)) {
                    nextScan = _class_private_field_get._(this, _startBlock);
                }
            }
            while(nextScan <= blockNumber){
                // Get the next block to scan
                if (stopScanning) {
                    return null;
                }
                const block = await this.provider.getBlock(nextScan, true);
                // This should not happen; but we'll try again shortly
                if (block == null) {
                    return;
                }
                // We were mined; no replacement
                for (const hash of block){
                    if (hash === this.hash) {
                        return;
                    }
                }
                // Search for the transaction that replaced us
                for(let i = 0; i < block.length; i++){
                    const tx = await block.getTransaction(i);
                    if (tx.from === this.from && tx.nonce === this.nonce) {
                        // Get the receipt
                        if (stopScanning) {
                            return null;
                        }
                        const receipt = await this.provider.getTransactionReceipt(tx.hash);
                        // This should not happen; but we'll try again shortly
                        if (receipt == null) {
                            return;
                        }
                        // We will retry this on the next block (this case could be optimized)
                        if (blockNumber - receipt.blockNumber + 1 < confirms) {
                            return;
                        }
                        // The reason we were replaced
                        let reason = "replaced";
                        if (tx.data === this.data && tx.to === this.to && tx.value === this.value) {
                            reason = "repriced";
                        } else if (tx.data === "0x" && tx.from === tx.to && tx.value === BN_0) {
                            reason = "cancelled";
                        }
                        (0, index_js_1.assert)(false, "transaction was replaced", "TRANSACTION_REPLACED", {
                            cancelled: reason === "replaced" || reason === "cancelled",
                            reason,
                            replacement: tx.replaceableTransaction(startBlock),
                            hash: tx.hash,
                            receipt
                        });
                    }
                }
                nextScan++;
            }
            return;
        };
        const checkReceipt = (receipt)=>{
            if (receipt == null || receipt.status !== 0) {
                return receipt;
            }
            (0, index_js_1.assert)(false, "transaction execution reverted", "CALL_EXCEPTION", {
                action: "sendTransaction",
                data: null,
                reason: null,
                invocation: null,
                revert: null,
                transaction: {
                    to: receipt.to,
                    from: receipt.from,
                    data: "" // @TODO: in v7, split out sendTransaction properties
                },
                receipt
            });
        };
        const receipt = await this.provider.getTransactionReceipt(this.hash);
        if (confirms === 0) {
            return checkReceipt(receipt);
        }
        if (receipt) {
            if (confirms === 1 || await receipt.confirmations() >= confirms) {
                return checkReceipt(receipt);
            }
        } else {
            // Check for a replacement; throws if a replacement was found
            await checkReplacement();
            // Allow null only when the confirms is 0
            if (confirms === 0) {
                return null;
            }
        }
        const waiter = new Promise((resolve, reject)=>{
            // List of things to cancel when we have a result (one way or the other)
            const cancellers = [];
            const cancel = ()=>{
                cancellers.forEach((c)=>c());
            };
            // On cancel, stop scanning for replacements
            cancellers.push(()=>{
                stopScanning = true;
            });
            // Set up any timeout requested
            if (timeout > 0) {
                const timer = setTimeout(()=>{
                    cancel();
                    reject((0, index_js_1.makeError)("wait for transaction timeout", "TIMEOUT"));
                }, timeout);
                cancellers.push(()=>{
                    clearTimeout(timer);
                });
            }
            const txListener = async (receipt)=>{
                // Done; return it!
                if (await receipt.confirmations() >= confirms) {
                    cancel();
                    try {
                        resolve(checkReceipt(receipt));
                    } catch (error) {
                        reject(error);
                    }
                }
            };
            cancellers.push(()=>{
                this.provider.off(this.hash, txListener);
            });
            this.provider.on(this.hash, txListener);
            // We support replacement detection; start checking
            if (startBlock >= 0) {
                const replaceListener = async ()=>{
                    try {
                        // Check for a replacement; this throws only if one is found
                        await checkReplacement();
                    } catch (error) {
                        // We were replaced (with enough confirms); re-throw the error
                        if ((0, index_js_1.isError)(error, "TRANSACTION_REPLACED")) {
                            cancel();
                            reject(error);
                            return;
                        }
                    }
                    // Rescheudle a check on the next block
                    if (!stopScanning) {
                        this.provider.once("block", replaceListener);
                    }
                };
                cancellers.push(()=>{
                    this.provider.off("block", replaceListener);
                });
                this.provider.once("block", replaceListener);
            }
        });
        return await waiter;
    }
    /**
     *  Returns ``true`` if this transaction has been included.
     *
     *  This is effective only as of the time the TransactionResponse
     *  was instantiated. To get up-to-date information, use
     *  [[getTransaction]].
     *
     *  This provides a Type Guard that this transaction will have
     *  non-null property values for properties that are null for
     *  unmined transactions.
     */ isMined() {
        return this.blockHash != null;
    }
    /**
     *  Returns true if the transaction is a legacy (i.e. ``type == 0``)
     *  transaction.
     *
     *  This provides a Type Guard that this transaction will have
     *  the ``null``-ness for hardfork-specific properties set correctly.
     */ isLegacy() {
        return this.type === 0;
    }
    /**
     *  Returns true if the transaction is a Berlin (i.e. ``type == 1``)
     *  transaction. See [[link-eip-2070]].
     *
     *  This provides a Type Guard that this transaction will have
     *  the ``null``-ness for hardfork-specific properties set correctly.
     */ isBerlin() {
        return this.type === 1;
    }
    /**
     *  Returns true if the transaction is a London (i.e. ``type == 2``)
     *  transaction. See [[link-eip-1559]].
     *
     *  This provides a Type Guard that this transaction will have
     *  the ``null``-ness for hardfork-specific properties set correctly.
     */ isLondon() {
        return this.type === 2;
    }
    /**
     *  Returns true if hte transaction is a Cancun (i.e. ``type == 3``)
     *  transaction. See [[link-eip-4844]].
     */ isCancun() {
        return this.type === 3;
    }
    /**
     *  Returns a filter which can be used to listen for orphan events
     *  that evict this transaction.
     */ removedEvent() {
        (0, index_js_1.assert)(this.isMined(), "unmined transaction canot be orphaned", "UNSUPPORTED_OPERATION", {
            operation: "removeEvent()"
        });
        return createRemovedTransactionFilter(this);
    }
    /**
     *  Returns a filter which can be used to listen for orphan events
     *  that re-order this event against %%other%%.
     */ reorderedEvent(other) {
        (0, index_js_1.assert)(this.isMined(), "unmined transaction canot be orphaned", "UNSUPPORTED_OPERATION", {
            operation: "removeEvent()"
        });
        (0, index_js_1.assert)(!other || other.isMined(), "unmined 'other' transaction canot be orphaned", "UNSUPPORTED_OPERATION", {
            operation: "removeEvent()"
        });
        return createReorderedTransactionFilter(this, other);
    }
    /**
     *  Returns a new TransactionResponse instance which has the ability to
     *  detect (and throw an error) if the transaction is replaced, which
     *  will begin scanning at %%startBlock%%.
     *
     *  This should generally not be used by developers and is intended
     *  primarily for internal use. Setting an incorrect %%startBlock%% can
     *  have devastating performance consequences if used incorrectly.
     */ replaceableTransaction(startBlock) {
        (0, index_js_1.assertArgument)(Number.isInteger(startBlock) && startBlock >= 0, "invalid startBlock", "startBlock", startBlock);
        const tx = new TransactionResponse(this, this.provider);
        _class_private_field_set._(tx, _startBlock, startBlock);
        return tx;
    }
    /**
     *  @_ignore:
     */ constructor(tx, provider){
        /**
     *  The provider this is connected to, which will influence how its
     *  methods will resolve its async inspection methods.
     */ _define_property._(this, "provider", void 0);
        /**
     *  The block number of the block that this transaction was included in.
     *
     *  This is ``null`` for pending transactions.
     */ _define_property._(this, "blockNumber", void 0);
        /**
     *  The blockHash of the block that this transaction was included in.
     *
     *  This is ``null`` for pending transactions.
     */ _define_property._(this, "blockHash", void 0);
        /**
     *  The index within the block that this transaction resides at.
     */ _define_property._(this, "index", void 0);
        /**
     *  The transaction hash.
     */ _define_property._(this, "hash", void 0);
        /**
     *  The [[link-eip-2718]] transaction envelope type. This is
     *  ``0`` for legacy transactions types.
     */ _define_property._(this, "type", void 0);
        /**
     *  The receiver of this transaction.
     *
     *  If ``null``, then the transaction is an initcode transaction.
     *  This means the result of executing the [[data]] will be deployed
     *  as a new contract on chain (assuming it does not revert) and the
     *  address may be computed using [[getCreateAddress]].
     */ _define_property._(this, "to", void 0);
        /**
     *  The sender of this transaction. It is implicitly computed
     *  from the transaction pre-image hash (as the digest) and the
     *  [[signature]] using ecrecover.
     */ _define_property._(this, "from", void 0);
        /**
     *  The nonce, which is used to prevent replay attacks and offer
     *  a method to ensure transactions from a given sender are explicitly
     *  ordered.
     *
     *  When sending a transaction, this must be equal to the number of
     *  transactions ever sent by [[from]].
     */ _define_property._(this, "nonce", void 0);
        /**
     *  The maximum units of gas this transaction can consume. If execution
     *  exceeds this, the entries transaction is reverted and the sender
     *  is charged for the full amount, despite not state changes being made.
     */ _define_property._(this, "gasLimit", void 0);
        /**
     *  The gas price can have various values, depending on the network.
     *
     *  In modern networks, for transactions that are included this is
     *  the //effective gas price// (the fee per gas that was actually
     *  charged), while for transactions that have not been included yet
     *  is the [[maxFeePerGas]].
     *
     *  For legacy transactions, or transactions on legacy networks, this
     *  is the fee that will be charged per unit of gas the transaction
     *  consumes.
     */ _define_property._(this, "gasPrice", void 0);
        /**
     *  The maximum priority fee (per unit of gas) to allow a
     *  validator to charge the sender. This is inclusive of the
     *  [[maxFeeFeePerGas]].
     */ _define_property._(this, "maxPriorityFeePerGas", void 0);
        /**
     *  The maximum fee (per unit of gas) to allow this transaction
     *  to charge the sender.
     */ _define_property._(this, "maxFeePerGas", void 0);
        /**
     *  The [[link-eip-4844]] max fee per BLOb gas.
     */ _define_property._(this, "maxFeePerBlobGas", void 0);
        /**
     *  The data.
     */ _define_property._(this, "data", void 0);
        /**
     *  The value, in wei. Use [[formatEther]] to format this value
     *  as ether.
     */ _define_property._(this, "value", void 0);
        /**
     *  The chain ID.
     */ _define_property._(this, "chainId", void 0);
        /**
     *  The signature.
     */ _define_property._(this, "signature", void 0);
        /**
     *  The [[link-eip-2930]] access list for transaction types that
     *  support it, otherwise ``null``.
     */ _define_property._(this, "accessList", void 0);
        /**
     *  The [[link-eip-4844]] BLOb versioned hashes.
     */ _define_property._(this, "blobVersionedHashes", void 0);
        /**
     *  The [[link-eip-7702]] authorizations (if any).
     */ _define_property._(this, "authorizationList", void 0);
        _class_private_field_init._(this, _startBlock, {
            writable: true,
            value: void 0
        });
        this.provider = provider;
        this.blockNumber = tx.blockNumber != null ? tx.blockNumber : null;
        this.blockHash = tx.blockHash != null ? tx.blockHash : null;
        this.hash = tx.hash;
        this.index = tx.index;
        this.type = tx.type;
        this.from = tx.from;
        this.to = tx.to || null;
        this.gasLimit = tx.gasLimit;
        this.nonce = tx.nonce;
        this.data = tx.data;
        this.value = tx.value;
        this.gasPrice = tx.gasPrice;
        this.maxPriorityFeePerGas = tx.maxPriorityFeePerGas != null ? tx.maxPriorityFeePerGas : null;
        this.maxFeePerGas = tx.maxFeePerGas != null ? tx.maxFeePerGas : null;
        this.maxFeePerBlobGas = tx.maxFeePerBlobGas != null ? tx.maxFeePerBlobGas : null;
        this.chainId = tx.chainId;
        this.signature = tx.signature;
        this.accessList = tx.accessList != null ? tx.accessList : null;
        this.blobVersionedHashes = tx.blobVersionedHashes != null ? tx.blobVersionedHashes : null;
        this.authorizationList = tx.authorizationList != null ? tx.authorizationList : null;
        _class_private_field_set._(this, _startBlock, -1);
    }
}
exports.TransactionResponse = TransactionResponse;
function createOrphanedBlockFilter(block) {
    return {
        orphan: "drop-block",
        hash: block.hash,
        number: block.number
    };
}
function createReorderedTransactionFilter(tx, other) {
    return {
        orphan: "reorder-transaction",
        tx,
        other
    };
}
function createRemovedTransactionFilter(tx) {
    return {
        orphan: "drop-transaction",
        tx
    };
}
function createRemovedLogFilter(log) {
    return {
        orphan: "drop-log",
        log: {
            transactionHash: log.transactionHash,
            blockHash: log.blockHash,
            blockNumber: log.blockNumber,
            address: log.address,
            data: log.data,
            topics: Object.freeze(log.topics.slice()),
            index: log.index
        }
    };
} //# sourceMappingURL=provider.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/wrappers.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ContractEventPayload = exports.ContractUnknownEventPayload = exports.ContractTransactionResponse = exports.ContractTransactionReceipt = exports.UndecodedEventLog = exports.EventLog = void 0;
// import from provider.ts instead of index.ts to prevent circular dep
// from EtherscanProvider
const provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 *  An **EventLog** contains additional properties parsed from the [[Log]].
 */ class EventLog extends provider_js_1.Log {
    /**
     *  The name of the event.
     */ get eventName() {
        return this.fragment.name;
    }
    /**
     *  The signature of the event.
     */ get eventSignature() {
        return this.fragment.format();
    }
    /**
     * @_ignore:
     */ constructor(log, iface, fragment){
        super(log, log.provider), /**
     *  The Contract Interface.
     */ _define_property._(this, "interface", void 0), /**
     *  The matching event.
     */ _define_property._(this, "fragment", void 0), /**
     *  The parsed arguments passed to the event by ``emit``.
     */ _define_property._(this, "args", void 0);
        const args = iface.decodeEventLog(fragment, log.data, log.topics);
        (0, index_js_1.defineProperties)(this, {
            args,
            fragment,
            interface: iface
        });
    }
}
exports.EventLog = EventLog;
/**
 *  An **EventLog** contains additional properties parsed from the [[Log]].
 */ class UndecodedEventLog extends provider_js_1.Log {
    /**
     * @_ignore:
     */ constructor(log, error){
        super(log, log.provider), /**
     *  The error encounted when trying to decode the log.
     */ _define_property._(this, "error", void 0);
        (0, index_js_1.defineProperties)(this, {
            error
        });
    }
}
exports.UndecodedEventLog = UndecodedEventLog;
var _iface = /*#__PURE__*/ new WeakMap();
/**
 *  A **ContractTransactionReceipt** includes the parsed logs from a
 *  [[TransactionReceipt]].
 */ class ContractTransactionReceipt extends provider_js_1.TransactionReceipt {
    /**
     *  The parsed logs for any [[Log]] which has a matching event in the
     *  Contract ABI.
     */ get logs() {
        return super.logs.map((log)=>{
            const fragment = log.topics.length ? _class_private_field_get._(this, _iface).getEvent(log.topics[0]) : null;
            if (fragment) {
                try {
                    return new EventLog(log, _class_private_field_get._(this, _iface), fragment);
                } catch (error) {
                    return new UndecodedEventLog(log, error);
                }
            }
            return log;
        });
    }
    /**
     *  @_ignore:
     */ constructor(iface, provider, tx){
        super(tx, provider), _class_private_field_init._(this, _iface, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _iface, iface);
    }
}
exports.ContractTransactionReceipt = ContractTransactionReceipt;
var _iface1 = /*#__PURE__*/ new WeakMap();
/**
 *  A **ContractTransactionResponse** will return a
 *  [[ContractTransactionReceipt]] when waited on.
 */ class ContractTransactionResponse extends provider_js_1.TransactionResponse {
    /**
     *  Resolves once this transaction has been mined and has
     *  %%confirms%% blocks including it (default: ``1``) with an
     *  optional %%timeout%%.
     *
     *  This can resolve to ``null`` only if %%confirms%% is ``0``
     *  and the transaction has not been mined, otherwise this will
     *  wait until enough confirmations have completed.
     */ async wait(confirms, timeout) {
        const receipt = await super.wait(confirms, timeout);
        if (receipt == null) {
            return null;
        }
        return new ContractTransactionReceipt(_class_private_field_get._(this, _iface1), this.provider, receipt);
    }
    /**
     *  @_ignore:
     */ constructor(iface, provider, tx){
        super(tx, provider), _class_private_field_init._(this, _iface1, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _iface1, iface);
    }
}
exports.ContractTransactionResponse = ContractTransactionResponse;
/**
 *  A **ContractUnknownEventPayload** is included as the last parameter to
 *  Contract Events when the event does not match any events in the ABI.
 */ class ContractUnknownEventPayload extends index_js_1.EventPayload {
    /**
     *  Resolves to the block the event occured in.
     */ async getBlock() {
        return await this.log.getBlock();
    }
    /**
     *  Resolves to the transaction the event occured in.
     */ async getTransaction() {
        return await this.log.getTransaction();
    }
    /**
     *  Resolves to the transaction receipt the event occured in.
     */ async getTransactionReceipt() {
        return await this.log.getTransactionReceipt();
    }
    /**
     *  @_event:
     */ constructor(contract, listener, filter, log){
        super(contract, listener, filter), /**
     *  The log with no matching events.
     */ _define_property._(this, "log", void 0);
        (0, index_js_1.defineProperties)(this, {
            log
        });
    }
}
exports.ContractUnknownEventPayload = ContractUnknownEventPayload;
/**
 *  A **ContractEventPayload** is included as the last parameter to
 *  Contract Events when the event is known.
 */ class ContractEventPayload extends ContractUnknownEventPayload {
    /**
     *  The event name.
     */ get eventName() {
        return this.fragment.name;
    }
    /**
     *  The event signature.
     */ get eventSignature() {
        return this.fragment.format();
    }
    /**
     *  @_ignore:
     */ constructor(contract, listener, filter, fragment, _log){
        super(contract, listener, filter, new EventLog(_log, contract.interface, fragment));
        const args = contract.interface.decodeEventLog(fragment, this.log.data, this.log.topics);
        (0, index_js_1.defineProperties)(this, {
            args,
            fragment
        });
    }
}
exports.ContractEventPayload = ContractEventPayload; //# sourceMappingURL=wrappers.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/contract.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Contract = exports.BaseContract = exports.resolveArgs = exports.copyOverrides = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
// import from provider.ts instead of index.ts to prevent circular dep
// from EtherscanProvider
const provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const wrappers_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/wrappers.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
function canCall(value) {
    return value && typeof value.call === "function";
}
function canEstimate(value) {
    return value && typeof value.estimateGas === "function";
}
function canResolve(value) {
    return value && typeof value.resolveName === "function";
}
function canSend(value) {
    return value && typeof value.sendTransaction === "function";
}
function getResolver(value) {
    if (value != null) {
        if (canResolve(value)) {
            return value;
        }
        if (value.provider) {
            return value.provider;
        }
    }
    return undefined;
}
var _filter = /*#__PURE__*/ new WeakMap();
class PreparedTopicFilter {
    getTopicFilter() {
        return _class_private_field_get._(this, _filter);
    }
    constructor(contract, fragment, args){
        _class_private_field_init._(this, _filter, {
            writable: true,
            value: void 0
        });
        _define_property._(this, "fragment", void 0);
        (0, index_js_3.defineProperties)(this, {
            fragment
        });
        if (fragment.inputs.length < args.length) {
            throw new Error("too many arguments");
        }
        // Recursively descend into args and resolve any addresses
        const runner = getRunner(contract.runner, "resolveName");
        const resolver = canResolve(runner) ? runner : null;
        _class_private_field_set._(this, _filter, async function() {
            const resolvedArgs = await Promise.all(fragment.inputs.map((param, index)=>{
                const arg = args[index];
                if (arg == null) {
                    return null;
                }
                return param.walkAsync(args[index], (type, value)=>{
                    if (type === "address") {
                        if (Array.isArray(value)) {
                            return Promise.all(value.map((v)=>(0, index_js_2.resolveAddress)(v, resolver)));
                        }
                        return (0, index_js_2.resolveAddress)(value, resolver);
                    }
                    return value;
                });
            }));
            return contract.interface.encodeFilterTopics(fragment, resolvedArgs);
        }());
    }
}
// A = Arguments passed in as a tuple
// R = The result type of the call (i.e. if only one return type,
//     the qualified type, otherwise Result)
// D = The type the default call will return (i.e. R for view/pure,
//     TransactionResponse otherwise)
//export interface ContractMethod<A extends Array<any> = Array<any>, R = any, D extends R | ContractTransactionResponse = ContractTransactionResponse> {
function getRunner(value, feature) {
    if (value == null) {
        return null;
    }
    if (typeof value[feature] === "function") {
        return value;
    }
    if (value.provider && typeof value.provider[feature] === "function") {
        return value.provider;
    }
    return null;
}
function getProvider(value) {
    if (value == null) {
        return null;
    }
    return value.provider || null;
}
/**
 *  @_ignore:
 */ async function copyOverrides(arg, allowed) {
    // Make sure the overrides passed in are a valid overrides object
    const _overrides = index_js_1.Typed.dereference(arg, "overrides");
    (0, index_js_3.assertArgument)(typeof _overrides === "object", "invalid overrides parameter", "overrides", arg);
    // Create a shallow copy (we'll deep-ify anything needed during normalizing)
    const overrides = (0, provider_js_1.copyRequest)(_overrides);
    (0, index_js_3.assertArgument)(overrides.to == null || (allowed || []).indexOf("to") >= 0, "cannot override to", "overrides.to", overrides.to);
    (0, index_js_3.assertArgument)(overrides.data == null || (allowed || []).indexOf("data") >= 0, "cannot override data", "overrides.data", overrides.data);
    // Resolve any from
    if (overrides.from) {
        overrides.from = overrides.from;
    }
    return overrides;
}
exports.copyOverrides = copyOverrides;
/**
 *  @_ignore:
 */ async function resolveArgs(_runner, inputs, args) {
    // Recursively descend into args and resolve any addresses
    const runner = getRunner(_runner, "resolveName");
    const resolver = canResolve(runner) ? runner : null;
    return await Promise.all(inputs.map((param, index)=>{
        return param.walkAsync(args[index], (type, value)=>{
            value = index_js_1.Typed.dereference(value, type);
            if (type === "address") {
                return (0, index_js_2.resolveAddress)(value, resolver);
            }
            return value;
        });
    }));
}
exports.resolveArgs = resolveArgs;
function buildWrappedFallback(contract) {
    const populateTransaction = async function(overrides) {
        // If an overrides was passed in, copy it and normalize the values
        const tx = await copyOverrides(overrides, [
            "data"
        ]);
        tx.to = await contract.getAddress();
        if (tx.from) {
            tx.from = await (0, index_js_2.resolveAddress)(tx.from, getResolver(contract.runner));
        }
        const iface = contract.interface;
        const noValue = (0, index_js_3.getBigInt)(tx.value || BN_0, "overrides.value") === BN_0;
        const noData = (tx.data || "0x") === "0x";
        if (iface.fallback && !iface.fallback.payable && iface.receive && !noData && !noValue) {
            (0, index_js_3.assertArgument)(false, "cannot send data to receive or send value to non-payable fallback", "overrides", overrides);
        }
        (0, index_js_3.assertArgument)(iface.fallback || noData, "cannot send data to receive-only contract", "overrides.data", tx.data);
        // Only allow payable contracts to set non-zero value
        const payable = iface.receive || iface.fallback && iface.fallback.payable;
        (0, index_js_3.assertArgument)(payable || noValue, "cannot send value to non-payable fallback", "overrides.value", tx.value);
        // Only allow fallback contracts to set non-empty data
        (0, index_js_3.assertArgument)(iface.fallback || noData, "cannot send data to receive-only contract", "overrides.data", tx.data);
        return tx;
    };
    const staticCall = async function(overrides) {
        const runner = getRunner(contract.runner, "call");
        (0, index_js_3.assert)(canCall(runner), "contract runner does not support calling", "UNSUPPORTED_OPERATION", {
            operation: "call"
        });
        const tx = await populateTransaction(overrides);
        try {
            return await runner.call(tx);
        } catch (error) {
            if ((0, index_js_3.isCallException)(error) && error.data) {
                throw contract.interface.makeError(error.data, tx);
            }
            throw error;
        }
    };
    const send = async function(overrides) {
        const runner = contract.runner;
        (0, index_js_3.assert)(canSend(runner), "contract runner does not support sending transactions", "UNSUPPORTED_OPERATION", {
            operation: "sendTransaction"
        });
        const tx = await runner.sendTransaction(await populateTransaction(overrides));
        const provider = getProvider(contract.runner);
        // @TODO: the provider can be null; make a custom dummy provider that will throw a
        // meaningful error
        return new wrappers_js_1.ContractTransactionResponse(contract.interface, provider, tx);
    };
    const estimateGas = async function(overrides) {
        const runner = getRunner(contract.runner, "estimateGas");
        (0, index_js_3.assert)(canEstimate(runner), "contract runner does not support gas estimation", "UNSUPPORTED_OPERATION", {
            operation: "estimateGas"
        });
        return await runner.estimateGas(await populateTransaction(overrides));
    };
    const method = async (overrides)=>{
        return await send(overrides);
    };
    (0, index_js_3.defineProperties)(method, {
        _contract: contract,
        estimateGas,
        populateTransaction,
        send,
        staticCall
    });
    return method;
}
function buildWrappedMethod(contract, key) {
    const getFragment = function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const fragment = contract.interface.getFunction(key, args);
        (0, index_js_3.assert)(fragment, "no matching fragment", "UNSUPPORTED_OPERATION", {
            operation: "fragment",
            info: {
                key,
                args
            }
        });
        return fragment;
    };
    const populateTransaction = async function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const fragment = getFragment(...args);
        // If an overrides was passed in, copy it and normalize the values
        let overrides = {};
        if (fragment.inputs.length + 1 === args.length) {
            overrides = await copyOverrides(args.pop());
            if (overrides.from) {
                overrides.from = await (0, index_js_2.resolveAddress)(overrides.from, getResolver(contract.runner));
            }
        }
        if (fragment.inputs.length !== args.length) {
            throw new Error("internal error: fragment inputs doesn't match arguments; should not happen");
        }
        const resolvedArgs = await resolveArgs(contract.runner, fragment.inputs, args);
        return Object.assign({}, overrides, await (0, index_js_3.resolveProperties)({
            to: contract.getAddress(),
            data: contract.interface.encodeFunctionData(fragment, resolvedArgs)
        }));
    };
    const staticCall = async function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const result = await staticCallResult(...args);
        if (result.length === 1) {
            return result[0];
        }
        return result;
    };
    const send = async function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const runner = contract.runner;
        (0, index_js_3.assert)(canSend(runner), "contract runner does not support sending transactions", "UNSUPPORTED_OPERATION", {
            operation: "sendTransaction"
        });
        const tx = await runner.sendTransaction(await populateTransaction(...args));
        const provider = getProvider(contract.runner);
        // @TODO: the provider can be null; make a custom dummy provider that will throw a
        // meaningful error
        return new wrappers_js_1.ContractTransactionResponse(contract.interface, provider, tx);
    };
    const estimateGas = async function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const runner = getRunner(contract.runner, "estimateGas");
        (0, index_js_3.assert)(canEstimate(runner), "contract runner does not support gas estimation", "UNSUPPORTED_OPERATION", {
            operation: "estimateGas"
        });
        return await runner.estimateGas(await populateTransaction(...args));
    };
    const staticCallResult = async function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const runner = getRunner(contract.runner, "call");
        (0, index_js_3.assert)(canCall(runner), "contract runner does not support calling", "UNSUPPORTED_OPERATION", {
            operation: "call"
        });
        const tx = await populateTransaction(...args);
        let result = "0x";
        try {
            result = await runner.call(tx);
        } catch (error) {
            if ((0, index_js_3.isCallException)(error) && error.data) {
                throw contract.interface.makeError(error.data, tx);
            }
            throw error;
        }
        const fragment = getFragment(...args);
        return contract.interface.decodeFunctionResult(fragment, result);
    };
    const method = async function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const fragment = getFragment(...args);
        if (fragment.constant) {
            return await staticCall(...args);
        }
        return await send(...args);
    };
    (0, index_js_3.defineProperties)(method, {
        name: contract.interface.getFunctionName(key),
        _contract: contract,
        _key: key,
        getFragment,
        estimateGas,
        populateTransaction,
        send,
        staticCall,
        staticCallResult
    });
    // Only works on non-ambiguous keys (refined fragment is always non-ambiguous)
    Object.defineProperty(method, "fragment", {
        configurable: false,
        enumerable: true,
        get: ()=>{
            const fragment = contract.interface.getFunction(key);
            (0, index_js_3.assert)(fragment, "no matching fragment", "UNSUPPORTED_OPERATION", {
                operation: "fragment",
                info: {
                    key
                }
            });
            return fragment;
        }
    });
    return method;
}
function buildWrappedEvent(contract, key) {
    const getFragment = function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const fragment = contract.interface.getEvent(key, args);
        (0, index_js_3.assert)(fragment, "no matching fragment", "UNSUPPORTED_OPERATION", {
            operation: "fragment",
            info: {
                key,
                args
            }
        });
        return fragment;
    };
    const method = function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        return new PreparedTopicFilter(contract, getFragment(...args), args);
    };
    (0, index_js_3.defineProperties)(method, {
        name: contract.interface.getEventName(key),
        _contract: contract,
        _key: key,
        getFragment
    });
    // Only works on non-ambiguous keys (refined fragment is always non-ambiguous)
    Object.defineProperty(method, "fragment", {
        configurable: false,
        enumerable: true,
        get: ()=>{
            const fragment = contract.interface.getEvent(key);
            (0, index_js_3.assert)(fragment, "no matching fragment", "UNSUPPORTED_OPERATION", {
                operation: "fragment",
                info: {
                    key
                }
            });
            return fragment;
        }
    });
    return method;
}
// The combination of TypeScrype, Private Fields and Proxies makes
// the world go boom; so we hide variables with some trickery keeping
// a symbol attached to each BaseContract which its sub-class (even
// via a Proxy) can reach and use to look up its internal values.
const internal = Symbol.for("_ethersInternal_contract");
const internalValues = new WeakMap();
function setInternal(contract, values) {
    internalValues.set(contract[internal], values);
}
function getInternal(contract) {
    return internalValues.get(contract[internal]);
}
function isDeferred(value) {
    return value && typeof value === "object" && "getTopicFilter" in value && typeof value.getTopicFilter === "function" && value.fragment;
}
async function getSubInfo(contract, event) {
    let topics;
    let fragment = null;
    // Convert named events to topicHash and get the fragment for
    // events which need deconstructing.
    if (Array.isArray(event)) {
        const topicHashify = function(name) {
            if ((0, index_js_3.isHexString)(name, 32)) {
                return name;
            }
            const fragment = contract.interface.getEvent(name);
            (0, index_js_3.assertArgument)(fragment, "unknown fragment", "name", name);
            return fragment.topicHash;
        };
        // Array of Topics and Names; e.g. `[ "0x1234...89ab", "Transfer(address)" ]`
        topics = event.map((e)=>{
            if (e == null) {
                return null;
            }
            if (Array.isArray(e)) {
                return e.map(topicHashify);
            }
            return topicHashify(e);
        });
    } else if (event === "*") {
        topics = [
            null
        ];
    } else if (typeof event === "string") {
        if ((0, index_js_3.isHexString)(event, 32)) {
            // Topic Hash
            topics = [
                event
            ];
        } else {
            // Name or Signature; e.g. `"Transfer", `"Transfer(address)"`
            fragment = contract.interface.getEvent(event);
            (0, index_js_3.assertArgument)(fragment, "unknown fragment", "event", event);
            topics = [
                fragment.topicHash
            ];
        }
    } else if (isDeferred(event)) {
        // Deferred Topic Filter; e.g. `contract.filter.Transfer(from)`
        topics = await event.getTopicFilter();
    } else if ("fragment" in event) {
        // ContractEvent; e.g. `contract.filter.Transfer`
        fragment = event.fragment;
        topics = [
            fragment.topicHash
        ];
    } else {
        (0, index_js_3.assertArgument)(false, "unknown event name", "event", event);
    }
    // Normalize topics and sort TopicSets
    topics = topics.map((t)=>{
        if (t == null) {
            return null;
        }
        if (Array.isArray(t)) {
            const items = Array.from(new Set(t.map((t)=>t.toLowerCase())).values());
            if (items.length === 1) {
                return items[0];
            }
            items.sort();
            return items;
        }
        return t.toLowerCase();
    });
    const tag = topics.map((t)=>{
        if (t == null) {
            return "null";
        }
        if (Array.isArray(t)) {
            return t.join("|");
        }
        return t;
    }).join("&");
    return {
        fragment,
        tag,
        topics
    };
}
async function hasSub(contract, event) {
    const { subs } = getInternal(contract);
    return subs.get((await getSubInfo(contract, event)).tag) || null;
}
async function getSub(contract, operation, event) {
    // Make sure our runner can actually subscribe to events
    const provider = getProvider(contract.runner);
    (0, index_js_3.assert)(provider, "contract runner does not support subscribing", "UNSUPPORTED_OPERATION", {
        operation
    });
    const { fragment, tag, topics } = await getSubInfo(contract, event);
    const { addr, subs } = getInternal(contract);
    let sub = subs.get(tag);
    if (!sub) {
        const address = addr ? addr : contract;
        const filter = {
            address,
            topics
        };
        const listener = (log)=>{
            let foundFragment = fragment;
            if (foundFragment == null) {
                try {
                    foundFragment = contract.interface.getEvent(log.topics[0]);
                } catch (error) {}
            }
            // If fragment is null, we do not deconstruct the args to emit
            if (foundFragment) {
                const _foundFragment = foundFragment;
                const args = fragment ? contract.interface.decodeEventLog(fragment, log.data, log.topics) : [];
                emit(contract, event, args, (listener)=>{
                    return new wrappers_js_1.ContractEventPayload(contract, listener, event, _foundFragment, log);
                });
            } else {
                emit(contract, event, [], (listener)=>{
                    return new wrappers_js_1.ContractUnknownEventPayload(contract, listener, event, log);
                });
            }
        };
        let starting = [];
        const start = ()=>{
            if (starting.length) {
                return;
            }
            starting.push(provider.on(filter, listener));
        };
        const stop = async ()=>{
            if (starting.length == 0) {
                return;
            }
            let started = starting;
            starting = [];
            await Promise.all(started);
            provider.off(filter, listener);
        };
        sub = {
            tag,
            listeners: [],
            start,
            stop
        };
        subs.set(tag, sub);
    }
    return sub;
}
// We use this to ensure one emit resolves before firing the next to
// ensure correct ordering (note this cannot throw and just adds the
// notice to the event queu using setTimeout).
let lastEmit = Promise.resolve();
async function _emit(contract, event, args, payloadFunc) {
    await lastEmit;
    const sub = await hasSub(contract, event);
    if (!sub) {
        return false;
    }
    const count = sub.listeners.length;
    sub.listeners = sub.listeners.filter((param)=>{
        let { listener, once } = param;
        const passArgs = Array.from(args);
        if (payloadFunc) {
            passArgs.push(payloadFunc(once ? null : listener));
        }
        try {
            listener.call(contract, ...passArgs);
        } catch (error) {}
        return !once;
    });
    if (sub.listeners.length === 0) {
        sub.stop();
        getInternal(contract).subs.delete(sub.tag);
    }
    return count > 0;
}
async function emit(contract, event, args, payloadFunc) {
    try {
        await lastEmit;
    } catch (error) {}
    const resultPromise = _emit(contract, event, args, payloadFunc);
    lastEmit = resultPromise;
    return await resultPromise;
}
const passProperties = [
    "then"
];
let _internal = internal;
class BaseContract {
    /**
     *  Return a new Contract instance with the same target and ABI, but
     *  a different %%runner%%.
     */ connect(runner) {
        return new BaseContract(this.target, this.interface, runner);
    }
    /**
     *  Return a new Contract instance with the same ABI and runner, but
     *  a different %%target%%.
     */ attach(target) {
        return new BaseContract(target, this.interface, this.runner);
    }
    /**
     *  Return the resolved address of this Contract.
     */ async getAddress() {
        return await getInternal(this).addrPromise;
    }
    /**
     *  Return the deployed bytecode or null if no bytecode is found.
     */ async getDeployedCode() {
        const provider = getProvider(this.runner);
        (0, index_js_3.assert)(provider, "runner does not support .provider", "UNSUPPORTED_OPERATION", {
            operation: "getDeployedCode"
        });
        const code = await provider.getCode(await this.getAddress());
        if (code === "0x") {
            return null;
        }
        return code;
    }
    /**
     *  Resolve to this Contract once the bytecode has been deployed, or
     *  resolve immediately if already deployed.
     */ async waitForDeployment() {
        // We have the deployement transaction; just use that (throws if deployement fails)
        const deployTx = this.deploymentTransaction();
        if (deployTx) {
            await deployTx.wait();
            return this;
        }
        // Check for code
        const code = await this.getDeployedCode();
        if (code != null) {
            return this;
        }
        // Make sure we can subscribe to a provider event
        const provider = getProvider(this.runner);
        (0, index_js_3.assert)(provider != null, "contract runner does not support .provider", "UNSUPPORTED_OPERATION", {
            operation: "waitForDeployment"
        });
        return new Promise((resolve, reject)=>{
            const checkCode = async ()=>{
                try {
                    const code = await this.getDeployedCode();
                    if (code != null) {
                        return resolve(this);
                    }
                    provider.once("block", checkCode);
                } catch (error) {
                    reject(error);
                }
            };
            checkCode();
        });
    }
    /**
     *  Return the transaction used to deploy this contract.
     *
     *  This is only available if this instance was returned from a
     *  [[ContractFactory]].
     */ deploymentTransaction() {
        return getInternal(this).deployTx;
    }
    /**
     *  Return the function for a given name. This is useful when a contract
     *  method name conflicts with a JavaScript name such as ``prototype`` or
     *  when using a Contract programatically.
     */ getFunction(key) {
        if (typeof key !== "string") {
            key = key.format();
        }
        const func = buildWrappedMethod(this, key);
        return func;
    }
    /**
     *  Return the event for a given name. This is useful when a contract
     *  event name conflicts with a JavaScript name such as ``prototype`` or
     *  when using a Contract programatically.
     */ getEvent(key) {
        if (typeof key !== "string") {
            key = key.format();
        }
        return buildWrappedEvent(this, key);
    }
    /**
     *  @_ignore:
     */ async queryTransaction(hash) {
        throw new Error("@TODO");
    }
    /*
    // @TODO: this is a non-backwards compatible change, but will be added
    //        in v7 and in a potential SmartContract class in an upcoming
    //        v6 release
    async getTransactionReceipt(hash: string): Promise<null | ContractTransactionReceipt> {
        const provider = getProvider(this.runner);
        assert(provider, "contract runner does not have a provider",
            "UNSUPPORTED_OPERATION", { operation: "queryTransaction" });

        const receipt = await provider.getTransactionReceipt(hash);
        if (receipt == null) { return null; }

        return new ContractTransactionReceipt(this.interface, provider, receipt);
    }
    */ /**
     *  Provide historic access to event data for %%event%% in the range
     *  %%fromBlock%% (default: ``0``) to %%toBlock%% (default: ``"latest"``)
     *  inclusive.
     */ async queryFilter(event, fromBlock, toBlock) {
        if (fromBlock == null) {
            fromBlock = 0;
        }
        if (toBlock == null) {
            toBlock = "latest";
        }
        const { addr, addrPromise } = getInternal(this);
        const address = addr ? addr : await addrPromise;
        const { fragment, topics } = await getSubInfo(this, event);
        const filter = {
            address,
            topics,
            fromBlock,
            toBlock
        };
        const provider = getProvider(this.runner);
        (0, index_js_3.assert)(provider, "contract runner does not have a provider", "UNSUPPORTED_OPERATION", {
            operation: "queryFilter"
        });
        return (await provider.getLogs(filter)).map((log)=>{
            let foundFragment = fragment;
            if (foundFragment == null) {
                try {
                    foundFragment = this.interface.getEvent(log.topics[0]);
                } catch (error) {}
            }
            if (foundFragment) {
                try {
                    return new wrappers_js_1.EventLog(log, this.interface, foundFragment);
                } catch (error) {
                    return new wrappers_js_1.UndecodedEventLog(log, error);
                }
            }
            return new provider_js_1.Log(log, provider);
        });
    }
    /**
     *  Add an event %%listener%% for the %%event%%.
     */ async on(event, listener) {
        const sub = await getSub(this, "on", event);
        sub.listeners.push({
            listener,
            once: false
        });
        sub.start();
        return this;
    }
    /**
     *  Add an event %%listener%% for the %%event%%, but remove the listener
     *  after it is fired once.
     */ async once(event, listener) {
        const sub = await getSub(this, "once", event);
        sub.listeners.push({
            listener,
            once: true
        });
        sub.start();
        return this;
    }
    /**
     *  Emit an %%event%% calling all listeners with %%args%%.
     *
     *  Resolves to ``true`` if any listeners were called.
     */ async emit(event) {
        for(var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++){
            args[_key - 1] = arguments[_key];
        }
        return await emit(this, event, args, null);
    }
    /**
     *  Resolves to the number of listeners of %%event%% or the total number
     *  of listeners if unspecified.
     */ async listenerCount(event) {
        if (event) {
            const sub = await hasSub(this, event);
            if (!sub) {
                return 0;
            }
            return sub.listeners.length;
        }
        const { subs } = getInternal(this);
        let total = 0;
        for (const { listeners } of subs.values()){
            total += listeners.length;
        }
        return total;
    }
    /**
     *  Resolves to the listeners subscribed to %%event%% or all listeners
     *  if unspecified.
     */ async listeners(event) {
        if (event) {
            const sub = await hasSub(this, event);
            if (!sub) {
                return [];
            }
            return sub.listeners.map((param)=>{
                let { listener } = param;
                return listener;
            });
        }
        const { subs } = getInternal(this);
        let result = [];
        for (const { listeners } of subs.values()){
            result = result.concat(listeners.map((param)=>{
                let { listener } = param;
                return listener;
            }));
        }
        return result;
    }
    /**
     *  Remove the %%listener%% from the listeners for %%event%% or remove
     *  all listeners if unspecified.
     */ async off(event, listener) {
        const sub = await hasSub(this, event);
        if (!sub) {
            return this;
        }
        if (listener) {
            const index = sub.listeners.map((param)=>{
                let { listener } = param;
                return listener;
            }).indexOf(listener);
            if (index >= 0) {
                sub.listeners.splice(index, 1);
            }
        }
        if (listener == null || sub.listeners.length === 0) {
            sub.stop();
            getInternal(this).subs.delete(sub.tag);
        }
        return this;
    }
    /**
     *  Remove all the listeners for %%event%% or remove all listeners if
     *  unspecified.
     */ async removeAllListeners(event) {
        if (event) {
            const sub = await hasSub(this, event);
            if (!sub) {
                return this;
            }
            sub.stop();
            getInternal(this).subs.delete(sub.tag);
        } else {
            const { subs } = getInternal(this);
            for (const { tag, stop } of subs.values()){
                stop();
                subs.delete(tag);
            }
        }
        return this;
    }
    /**
     *  Alias for [on].
     */ async addListener(event, listener) {
        return await this.on(event, listener);
    }
    /**
     *  Alias for [off].
     */ async removeListener(event, listener) {
        return await this.off(event, listener);
    }
    /**
     *  Create a new Class for the %%abi%%.
     */ static buildClass(abi) {
        class CustomContract extends BaseContract {
            constructor(address, runner = null){
                super(address, abi, runner);
            }
        }
        return CustomContract;
    }
    /**
     *  Create a new BaseContract with a specified Interface.
     */ static from(target, abi, runner) {
        if (runner == null) {
            runner = null;
        }
        const contract = new this(target, abi, runner);
        return contract;
    }
    /**
     *  Creates a new contract connected to %%target%% with the %%abi%% and
     *  optionally connected to a %%runner%% to perform operations on behalf
     *  of.
     */ constructor(target, abi, runner, _deployTx){
        /**
     *  The target to connect to.
     *
     *  This can be an address, ENS name or any [[Addressable]], such as
     *  another contract. To get the resovled address, use the ``getAddress``
     *  method.
     */ _define_property._(this, "target", void 0);
        /**
     *  The contract Interface.
     */ _define_property._(this, "interface", void 0);
        /**
     *  The connected runner. This is generally a [[Provider]] or a
     *  [[Signer]], which dictates what operations are supported.
     *
     *  For example, a **Contract** connected to a [[Provider]] may
     *  only execute read-only operations.
     */ _define_property._(this, "runner", void 0);
        /**
     *  All the Events available on this contract.
     */ _define_property._(this, "filters", void 0);
        /**
     *  @_ignore:
     */ _define_property._(this, _internal, void 0);
        /**
     *  The fallback or receive function if any.
     */ _define_property._(this, "fallback", void 0);
        (0, index_js_3.assertArgument)(typeof target === "string" || (0, index_js_2.isAddressable)(target), "invalid value for Contract target", "target", target);
        if (runner == null) {
            runner = null;
        }
        const iface = index_js_1.Interface.from(abi);
        (0, index_js_3.defineProperties)(this, {
            target,
            runner,
            interface: iface
        });
        Object.defineProperty(this, internal, {
            value: {}
        });
        let addrPromise;
        let addr = null;
        let deployTx = null;
        if (_deployTx) {
            const provider = getProvider(runner);
            // @TODO: the provider can be null; make a custom dummy provider that will throw a
            // meaningful error
            deployTx = new wrappers_js_1.ContractTransactionResponse(this.interface, provider, _deployTx);
        }
        let subs = new Map();
        // Resolve the target as the address
        if (typeof target === "string") {
            if ((0, index_js_3.isHexString)(target)) {
                addr = target;
                addrPromise = Promise.resolve(target);
            } else {
                const resolver = getRunner(runner, "resolveName");
                if (!canResolve(resolver)) {
                    throw (0, index_js_3.makeError)("contract runner does not support name resolution", "UNSUPPORTED_OPERATION", {
                        operation: "resolveName"
                    });
                }
                addrPromise = resolver.resolveName(target).then((addr)=>{
                    if (addr == null) {
                        throw (0, index_js_3.makeError)("an ENS name used for a contract target must be correctly configured", "UNCONFIGURED_NAME", {
                            value: target
                        });
                    }
                    getInternal(this).addr = addr;
                    return addr;
                });
            }
        } else {
            addrPromise = target.getAddress().then((addr)=>{
                if (addr == null) {
                    throw new Error("TODO");
                }
                getInternal(this).addr = addr;
                return addr;
            });
        }
        // Set our private values
        setInternal(this, {
            addrPromise,
            addr,
            deployTx,
            subs
        });
        // Add the event filters
        const filters = new Proxy({}, {
            get: (target, prop, receiver)=>{
                // Pass important checks (like `then` for Promise) through
                if (typeof prop === "symbol" || passProperties.indexOf(prop) >= 0) {
                    return Reflect.get(target, prop, receiver);
                }
                try {
                    return this.getEvent(prop);
                } catch (error) {
                    if (!(0, index_js_3.isError)(error, "INVALID_ARGUMENT") || error.argument !== "key") {
                        throw error;
                    }
                }
                return undefined;
            },
            has: (target, prop)=>{
                // Pass important checks (like `then` for Promise) through
                if (passProperties.indexOf(prop) >= 0) {
                    return Reflect.has(target, prop);
                }
                return Reflect.has(target, prop) || this.interface.hasEvent(String(prop));
            }
        });
        (0, index_js_3.defineProperties)(this, {
            filters
        });
        (0, index_js_3.defineProperties)(this, {
            fallback: iface.receive || iface.fallback ? buildWrappedFallback(this) : null
        });
        // Return a Proxy that will respond to functions
        return new Proxy(this, {
            get: (target, prop, receiver)=>{
                if (typeof prop === "symbol" || prop in target || passProperties.indexOf(prop) >= 0) {
                    return Reflect.get(target, prop, receiver);
                }
                // Undefined properties should return undefined
                try {
                    return target.getFunction(prop);
                } catch (error) {
                    if (!(0, index_js_3.isError)(error, "INVALID_ARGUMENT") || error.argument !== "key") {
                        throw error;
                    }
                }
                return undefined;
            },
            has: (target, prop)=>{
                if (typeof prop === "symbol" || prop in target || passProperties.indexOf(prop) >= 0) {
                    return Reflect.has(target, prop);
                }
                return target.interface.hasFunction(prop);
            }
        });
    }
}
exports.BaseContract = BaseContract;
function _ContractBase() {
    return BaseContract;
}
/**
 *  A [[BaseContract]] with no type guards on its methods or events.
 */ class Contract extends _ContractBase() {
}
exports.Contract = Contract; //# sourceMappingURL=contract.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/factory.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ContractFactory = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/contract.js [app-client] (ecmascript)");
// A = Arguments to the constructor
// I = Interface of deployed contracts
/**
 *  A **ContractFactory** is used to deploy a Contract to the blockchain.
 */ class ContractFactory {
    attach(target) {
        return new contract_js_1.BaseContract(target, this.interface, this.runner);
    }
    /**
     *  Resolves to the transaction to deploy the contract, passing %%args%%
     *  into the constructor.
     */ async getDeployTransaction() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        let overrides = {};
        const fragment = this.interface.deploy;
        if (fragment.inputs.length + 1 === args.length) {
            overrides = await (0, contract_js_1.copyOverrides)(args.pop());
        }
        if (fragment.inputs.length !== args.length) {
            throw new Error("incorrect number of arguments to constructor");
        }
        const resolvedArgs = await (0, contract_js_1.resolveArgs)(this.runner, fragment.inputs, args);
        const data = (0, index_js_3.concat)([
            this.bytecode,
            this.interface.encodeDeploy(resolvedArgs)
        ]);
        return Object.assign({}, overrides, {
            data
        });
    }
    /**
     *  Resolves to the Contract deployed by passing %%args%% into the
     *  constructor.
     *
     *  This will resolve to the Contract before it has been deployed to the
     *  network, so the [[BaseContract-waitForDeployment]] should be used before
     *  sending any transactions to it.
     */ async deploy() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        const tx = await this.getDeployTransaction(...args);
        (0, index_js_3.assert)(this.runner && typeof this.runner.sendTransaction === "function", "factory runner does not support sending transactions", "UNSUPPORTED_OPERATION", {
            operation: "sendTransaction"
        });
        const sentTx = await this.runner.sendTransaction(tx);
        const address = (0, index_js_2.getCreateAddress)(sentTx);
        return new contract_js_1.BaseContract(address, this.interface, this.runner, sentTx);
    }
    /**
     *  Return a new **ContractFactory** with the same ABI and bytecode,
     *  but connected to %%runner%%.
     */ connect(runner) {
        return new ContractFactory(this.interface, this.bytecode, runner);
    }
    /**
     *  Create a new **ContractFactory** from the standard Solidity JSON output.
     */ static fromSolidity(output, runner) {
        (0, index_js_3.assertArgument)(output != null, "bad compiler output", "output", output);
        if (typeof output === "string") {
            output = JSON.parse(output);
        }
        const abi = output.abi;
        let bytecode = "";
        if (output.bytecode) {
            bytecode = output.bytecode;
        } else if (output.evm && output.evm.bytecode) {
            bytecode = output.evm.bytecode;
        }
        return new this(abi, bytecode, runner);
    }
    /**
     *  Create a new **ContractFactory** with %%abi%% and %%bytecode%%,
     *  optionally connected to %%runner%%.
     *
     *  The %%bytecode%% may be the ``bytecode`` property within the
     *  standard Solidity JSON output.
     */ constructor(abi, bytecode, runner){
        /**
     *  The Contract Interface.
     */ _define_property._(this, "interface", void 0);
        /**
     *  The Contract deployment bytecode. Often called the initcode.
     */ _define_property._(this, "bytecode", void 0);
        /**
     *  The ContractRunner to deploy the Contract as.
     */ _define_property._(this, "runner", void 0);
        const iface = index_js_1.Interface.from(abi);
        // Dereference Solidity bytecode objects and allow a missing `0x`-prefix
        if (bytecode instanceof Uint8Array) {
            bytecode = (0, index_js_3.hexlify)((0, index_js_3.getBytes)(bytecode));
        } else {
            if (typeof bytecode === "object") {
                bytecode = bytecode.object;
            }
            if (!bytecode.startsWith("0x")) {
                bytecode = "0x" + bytecode;
            }
            bytecode = (0, index_js_3.hexlify)((0, index_js_3.getBytes)(bytecode));
        }
        (0, index_js_3.defineProperties)(this, {
            bytecode,
            interface: iface,
            runner: runner || null
        });
    }
}
exports.ContractFactory = ContractFactory; //# sourceMappingURL=factory.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.UndecodedEventLog = exports.EventLog = exports.ContractTransactionResponse = exports.ContractTransactionReceipt = exports.ContractUnknownEventPayload = exports.ContractEventPayload = exports.ContractFactory = exports.Contract = exports.BaseContract = void 0;
/**
 *  A **Contract** object is a meta-class (a class whose definition is
 *  defined at runtime), which communicates with a deployed smart contract
 *  on the blockchain and provides a simple JavaScript interface to call
 *  methods, send transaction, query historic logs and listen for its events.
 *
 *  @_section: api/contract:Contracts  [about-contracts]
 */ var contract_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/contract.js [app-client] (ecmascript)");
Object.defineProperty(exports, "BaseContract", {
    enumerable: true,
    get: function() {
        return contract_js_1.BaseContract;
    }
});
Object.defineProperty(exports, "Contract", {
    enumerable: true,
    get: function() {
        return contract_js_1.Contract;
    }
});
var factory_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/factory.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ContractFactory", {
    enumerable: true,
    get: function() {
        return factory_js_1.ContractFactory;
    }
});
var wrappers_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/wrappers.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ContractEventPayload", {
    enumerable: true,
    get: function() {
        return wrappers_js_1.ContractEventPayload;
    }
});
Object.defineProperty(exports, "ContractUnknownEventPayload", {
    enumerable: true,
    get: function() {
        return wrappers_js_1.ContractUnknownEventPayload;
    }
});
Object.defineProperty(exports, "ContractTransactionReceipt", {
    enumerable: true,
    get: function() {
        return wrappers_js_1.ContractTransactionReceipt;
    }
});
Object.defineProperty(exports, "ContractTransactionResponse", {
    enumerable: true,
    get: function() {
        return wrappers_js_1.ContractTransactionResponse;
    }
});
Object.defineProperty(exports, "EventLog", {
    enumerable: true,
    get: function() {
        return wrappers_js_1.EventLog;
    }
});
Object.defineProperty(exports, "UndecodedEventLog", {
    enumerable: true,
    get: function() {
        return wrappers_js_1.UndecodedEventLog;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/ens-resolver.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
var _class_static_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_static_private_method_get.cjs [app-client] (ecmascript)");
/**
 *  ENS is a service which allows easy-to-remember names to map to
 *  network addresses.
 *
 *  @_section: api/providers/ens-resolver:ENS Resolver  [about-ens-rsolver]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.EnsResolver = exports.BasicMulticoinProviderPlugin = exports.MulticoinProviderPlugin = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
const index_js_5 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
// @TODO: This should use the fetch-data:ipfs gateway
// Trim off the ipfs:// prefix and return the default gateway URL
function getIpfsLink(link) {
    if (link.match(/^ipfs:\/\/ipfs\//i)) {
        link = link.substring(12);
    } else if (link.match(/^ipfs:\/\//i)) {
        link = link.substring(7);
    } else {
        (0, index_js_5.assertArgument)(false, "unsupported IPFS format", "link", link);
    }
    return "https://gateway.ipfs.io/ipfs/".concat(link);
}
;
;
/**
 *  A provider plugin super-class for processing multicoin address types.
 */ class MulticoinProviderPlugin {
    connect(proivder) {
        return this;
    }
    /**
     *  Returns ``true`` if %%coinType%% is supported by this plugin.
     */ supportsCoinType(coinType) {
        return false;
    }
    /**
     *  Resolves to the encoded %%address%% for %%coinType%%.
     */ async encodeAddress(coinType, address) {
        throw new Error("unsupported coin");
    }
    /**
     *  Resolves to the decoded %%data%% for %%coinType%%.
     */ async decodeAddress(coinType, data) {
        throw new Error("unsupported coin");
    }
    /**
     *  Creates a new **MulticoinProviderPluing** for %%name%%.
     */ constructor(name){
        /**
     *  The name.
     */ _define_property._(this, "name", void 0);
        (0, index_js_5.defineProperties)(this, {
            name
        });
    }
}
exports.MulticoinProviderPlugin = MulticoinProviderPlugin;
const BasicMulticoinPluginId = "org.ethers.plugins.provider.BasicMulticoin";
/**
 *  A **BasicMulticoinProviderPlugin** provides service for common
 *  coin types, which do not require additional libraries to encode or
 *  decode.
 */ class BasicMulticoinProviderPlugin extends MulticoinProviderPlugin {
    /**
     *  Creates a new **BasicMulticoinProviderPlugin**.
     */ constructor(){
        super(BasicMulticoinPluginId);
    }
}
exports.BasicMulticoinProviderPlugin = BasicMulticoinProviderPlugin;
const matcherIpfs = new RegExp("^(ipfs):/\/(.*)$", "i");
const matchers = [
    new RegExp("^(https):/\/(.*)$", "i"),
    new RegExp("^(data):(.*)$", "i"),
    matcherIpfs,
    new RegExp("^eip155:[0-9]+/(erc[0-9]+):(.*)$", "i")
];
var // For EIP-2544 names, the ancestor that provided the resolver
_supports2544 = /*#__PURE__*/ new WeakMap(), _resolver = /*#__PURE__*/ new WeakMap(), _fetch = /*#__PURE__*/ new WeakSet();
/**
 *  A connected object to a resolved ENS name resolver, which can be
 *  used to query additional details.
 */ class EnsResolver {
    /**
     *  Resolves to true if the resolver supports wildcard resolution.
     */ async supportsWildcard() {
        if (_class_private_field_get._(this, _supports2544) == null) {
            _class_private_field_set._(this, _supports2544, (async ()=>{
                try {
                    return await _class_private_field_get._(this, _resolver).supportsInterface("0x9061b923");
                } catch (error) {
                    // Wildcard resolvers must understand supportsInterface
                    // and return true.
                    if ((0, index_js_5.isError)(error, "CALL_EXCEPTION")) {
                        return false;
                    }
                    // Let future attempts try again...
                    _class_private_field_set._(this, _supports2544, null);
                    throw error;
                }
            })());
        }
        return await _class_private_field_get._(this, _supports2544);
    }
    /**
     *  Resolves to the address for %%coinType%% or null if the
     *  provided %%coinType%% has not been configured.
     */ async getAddress(coinType) {
        if (coinType == null) {
            coinType = 60;
        }
        if (coinType === 60) {
            try {
                const result = await _class_private_method_get._(this, _fetch, fetch).call(this, "addr(bytes32)");
                // No address
                if (result == null || result === index_js_2.ZeroAddress) {
                    return null;
                }
                return result;
            } catch (error) {
                if ((0, index_js_5.isError)(error, "CALL_EXCEPTION")) {
                    return null;
                }
                throw error;
            }
        }
        // Try decoding its EVM canonical chain as an EVM chain address first
        if (coinType >= 0 && coinType < 0x80000000) {
            let ethCoinType = coinType + 0x80000000;
            const data = await _class_private_method_get._(this, _fetch, fetch).call(this, "addr(bytes32,uint)", [
                ethCoinType
            ]);
            if ((0, index_js_5.isHexString)(data, 20)) {
                return (0, index_js_1.getAddress)(data);
            }
        }
        let coinPlugin = null;
        for (const plugin of this.provider.plugins){
            if (!(plugin instanceof MulticoinProviderPlugin)) {
                continue;
            }
            if (plugin.supportsCoinType(coinType)) {
                coinPlugin = plugin;
                break;
            }
        }
        if (coinPlugin == null) {
            return null;
        }
        // keccak256("addr(bytes32,uint256")
        const data = await _class_private_method_get._(this, _fetch, fetch).call(this, "addr(bytes32,uint)", [
            coinType
        ]);
        // No address
        if (data == null || data === "0x") {
            return null;
        }
        // Compute the address
        const address = await coinPlugin.decodeAddress(coinType, data);
        if (address != null) {
            return address;
        }
        (0, index_js_5.assert)(false, "invalid coin data", "UNSUPPORTED_OPERATION", {
            operation: "getAddress(".concat(coinType, ")"),
            info: {
                coinType,
                data
            }
        });
    }
    /**
     *  Resolves to the EIP-634 text record for %%key%%, or ``null``
     *  if unconfigured.
     */ async getText(key) {
        const data = await _class_private_method_get._(this, _fetch, fetch).call(this, "text(bytes32,string)", [
            key
        ]);
        if (data == null || data === "0x") {
            return null;
        }
        return data;
    }
    /**
     *  Rsolves to the content-hash or ``null`` if unconfigured.
     */ async getContentHash() {
        // keccak256("contenthash()")
        const data = await _class_private_method_get._(this, _fetch, fetch).call(this, "contenthash(bytes32)");
        // No contenthash
        if (data == null || data === "0x") {
            return null;
        }
        // IPFS (CID: 1, Type: 70=DAG-PB, 72=libp2p-key)
        const ipfs = data.match(/^0x(e3010170|e5010172)(([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f]*))$/);
        if (ipfs) {
            const scheme = ipfs[1] === "e3010170" ? "ipfs" : "ipns";
            const length = parseInt(ipfs[4], 16);
            if (ipfs[5].length === length * 2) {
                return "".concat(scheme, "://").concat((0, index_js_5.encodeBase58)("0x" + ipfs[2]));
            }
        }
        // Swarm (CID: 1, Type: swarm-manifest; hash/length hard-coded to keccak256/32)
        const swarm = data.match(/^0xe40101fa011b20([0-9a-f]*)$/);
        if (swarm && swarm[1].length === 64) {
            return "bzz://".concat(swarm[1]);
        }
        (0, index_js_5.assert)(false, "invalid or unsupported content hash data", "UNSUPPORTED_OPERATION", {
            operation: "getContentHash()",
            info: {
                data
            }
        });
    }
    /**
     *  Resolves to the avatar url or ``null`` if the avatar is either
     *  unconfigured or incorrectly configured (e.g. references an NFT
     *  not owned by the address).
     *
     *  If diagnosing issues with configurations, the [[_getAvatar]]
     *  method may be useful.
     */ async getAvatar() {
        const avatar = await this._getAvatar();
        return avatar.url;
    }
    /**
     *  When resolving an avatar, there are many steps involved, such
     *  fetching metadata and possibly validating ownership of an
     *  NFT.
     *
     *  This method can be used to examine each step and the value it
     *  was working from.
     */ async _getAvatar() {
        const linkage = [
            {
                type: "name",
                value: this.name
            }
        ];
        try {
            // test data for ricmoo.eth
            //const avatar = "eip155:1/erc721:0x265385c7f4132228A0d54EB1A9e7460b91c0cC68/29233";
            const avatar = await this.getText("avatar");
            if (avatar == null) {
                linkage.push({
                    type: "!avatar",
                    value: ""
                });
                return {
                    url: null,
                    linkage
                };
            }
            linkage.push({
                type: "avatar",
                value: avatar
            });
            for(let i = 0; i < matchers.length; i++){
                const match = avatar.match(matchers[i]);
                if (match == null) {
                    continue;
                }
                const scheme = match[1].toLowerCase();
                switch(scheme){
                    case "https":
                    case "data":
                        linkage.push({
                            type: "url",
                            value: avatar
                        });
                        return {
                            linkage,
                            url: avatar
                        };
                    case "ipfs":
                        {
                            const url = getIpfsLink(avatar);
                            linkage.push({
                                type: "ipfs",
                                value: avatar
                            });
                            linkage.push({
                                type: "url",
                                value: url
                            });
                            return {
                                linkage,
                                url
                            };
                        }
                    case "erc721":
                    case "erc1155":
                        {
                            // Depending on the ERC type, use tokenURI(uint256) or url(uint256)
                            const selector = scheme === "erc721" ? "tokenURI(uint256)" : "uri(uint256)";
                            linkage.push({
                                type: scheme,
                                value: avatar
                            });
                            // The owner of this name
                            const owner = await this.getAddress();
                            if (owner == null) {
                                linkage.push({
                                    type: "!owner",
                                    value: ""
                                });
                                return {
                                    url: null,
                                    linkage
                                };
                            }
                            const comps = (match[2] || "").split("/");
                            if (comps.length !== 2) {
                                linkage.push({
                                    type: "!".concat(scheme, "caip"),
                                    value: match[2] || ""
                                });
                                return {
                                    url: null,
                                    linkage
                                };
                            }
                            const tokenId = comps[1];
                            const contract = new index_js_3.Contract(comps[0], [
                                // ERC-721
                                "function tokenURI(uint) view returns (string)",
                                "function ownerOf(uint) view returns (address)",
                                // ERC-1155
                                "function uri(uint) view returns (string)",
                                "function balanceOf(address, uint256) view returns (uint)"
                            ], this.provider);
                            // Check that this account owns the token
                            if (scheme === "erc721") {
                                const tokenOwner = await contract.ownerOf(tokenId);
                                if (owner !== tokenOwner) {
                                    linkage.push({
                                        type: "!owner",
                                        value: tokenOwner
                                    });
                                    return {
                                        url: null,
                                        linkage
                                    };
                                }
                                linkage.push({
                                    type: "owner",
                                    value: tokenOwner
                                });
                            } else if (scheme === "erc1155") {
                                const balance = await contract.balanceOf(owner, tokenId);
                                if (!balance) {
                                    linkage.push({
                                        type: "!balance",
                                        value: "0"
                                    });
                                    return {
                                        url: null,
                                        linkage
                                    };
                                }
                                linkage.push({
                                    type: "balance",
                                    value: balance.toString()
                                });
                            }
                            // Call the token contract for the metadata URL
                            let metadataUrl = await contract[selector](tokenId);
                            if (metadataUrl == null || metadataUrl === "0x") {
                                linkage.push({
                                    type: "!metadata-url",
                                    value: ""
                                });
                                return {
                                    url: null,
                                    linkage
                                };
                            }
                            linkage.push({
                                type: "metadata-url-base",
                                value: metadataUrl
                            });
                            // ERC-1155 allows a generic {id} in the URL
                            if (scheme === "erc1155") {
                                metadataUrl = metadataUrl.replace("{id}", (0, index_js_5.toBeHex)(tokenId, 32).substring(2));
                                linkage.push({
                                    type: "metadata-url-expanded",
                                    value: metadataUrl
                                });
                            }
                            // Transform IPFS metadata links
                            if (metadataUrl.match(/^ipfs:/i)) {
                                metadataUrl = getIpfsLink(metadataUrl);
                            }
                            linkage.push({
                                type: "metadata-url",
                                value: metadataUrl
                            });
                            // Get the token metadata
                            let metadata = {};
                            const response = await new index_js_5.FetchRequest(metadataUrl).send();
                            response.assertOk();
                            try {
                                metadata = response.bodyJson;
                            } catch (error) {
                                try {
                                    linkage.push({
                                        type: "!metadata",
                                        value: response.bodyText
                                    });
                                } catch (error) {
                                    const bytes = response.body;
                                    if (bytes) {
                                        linkage.push({
                                            type: "!metadata",
                                            value: (0, index_js_5.hexlify)(bytes)
                                        });
                                    }
                                    return {
                                        url: null,
                                        linkage
                                    };
                                }
                                return {
                                    url: null,
                                    linkage
                                };
                            }
                            if (!metadata) {
                                linkage.push({
                                    type: "!metadata",
                                    value: ""
                                });
                                return {
                                    url: null,
                                    linkage
                                };
                            }
                            linkage.push({
                                type: "metadata",
                                value: JSON.stringify(metadata)
                            });
                            // Pull the image URL out
                            let imageUrl = metadata.image;
                            if (typeof imageUrl !== "string") {
                                linkage.push({
                                    type: "!imageUrl",
                                    value: ""
                                });
                                return {
                                    url: null,
                                    linkage
                                };
                            }
                            if (imageUrl.match(/^(https:\/\/|data:)/i)) {
                            // Allow
                            } else {
                                // Transform IPFS link to gateway
                                const ipfs = imageUrl.match(matcherIpfs);
                                if (ipfs == null) {
                                    linkage.push({
                                        type: "!imageUrl-ipfs",
                                        value: imageUrl
                                    });
                                    return {
                                        url: null,
                                        linkage
                                    };
                                }
                                linkage.push({
                                    type: "imageUrl-ipfs",
                                    value: imageUrl
                                });
                                imageUrl = getIpfsLink(imageUrl);
                            }
                            linkage.push({
                                type: "url",
                                value: imageUrl
                            });
                            return {
                                linkage,
                                url: imageUrl
                            };
                        }
                }
            }
        } catch (error) {}
        return {
            linkage,
            url: null
        };
    }
    static async getEnsAddress(provider) {
        const network = await provider.getNetwork();
        const ensPlugin = network.getPlugin("org.ethers.plugins.network.Ens");
        // No ENS...
        (0, index_js_5.assert)(ensPlugin, "network does not support ENS", "UNSUPPORTED_OPERATION", {
            operation: "getEnsAddress",
            info: {
                network
            }
        });
        return ensPlugin.address;
    }
    /**
     *  Resolve to the ENS resolver for %%name%% using %%provider%% or
     *  ``null`` if unconfigured.
     */ static async fromName(provider, name) {
        let currentName = name;
        while(true){
            if (currentName === "" || currentName === ".") {
                return null;
            }
            // Optimization since the eth node cannot change and does
            // not have a wildcard resolver
            if (name !== "eth" && currentName === "eth") {
                return null;
            }
            // Check the current node for a resolver
            const addr = await _class_static_private_method_get._(EnsResolver, EnsResolver, getResolver).call(EnsResolver, provider, currentName);
            // Found a resolver!
            if (addr != null) {
                const resolver = new EnsResolver(provider, addr, name);
                // Legacy resolver found, using EIP-2544 so it isn't safe to use
                if (currentName !== name && !await resolver.supportsWildcard()) {
                    return null;
                }
                return resolver;
            }
            // Get the parent node
            currentName = currentName.split(".").slice(1).join(".");
        }
    }
    constructor(provider, address, name){
        _class_private_method_init._(this, _fetch);
        /**
     *  The connected provider.
     */ _define_property._(this, "provider", void 0);
        /**
     *  The address of the resolver.
     */ _define_property._(this, "address", void 0);
        /**
     *  The name this resolver was resolved against.
     */ _define_property._(this, "name", void 0);
        _class_private_field_init._(this, _supports2544, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _resolver, {
            writable: true,
            value: void 0
        });
        (0, index_js_5.defineProperties)(this, {
            provider,
            address,
            name
        });
        _class_private_field_set._(this, _supports2544, null);
        _class_private_field_set._(this, _resolver, new index_js_3.Contract(address, [
            "function supportsInterface(bytes4) view returns (bool)",
            "function resolve(bytes, bytes) view returns (bytes)",
            "function addr(bytes32) view returns (address)",
            "function addr(bytes32, uint) view returns (bytes)",
            "function text(bytes32, string) view returns (string)",
            "function contenthash(bytes32) view returns (bytes)"
        ], provider));
    }
}
async function fetch(funcName, params) {
    params = (params || []).slice();
    const iface = _class_private_field_get._(this, _resolver).interface;
    // The first parameters is always the nodehash
    params.unshift((0, index_js_4.namehash)(this.name));
    let fragment = null;
    if (await this.supportsWildcard()) {
        fragment = iface.getFunction(funcName);
        (0, index_js_5.assert)(fragment, "missing fragment", "UNKNOWN_ERROR", {
            info: {
                funcName
            }
        });
        params = [
            (0, index_js_4.dnsEncode)(this.name, 255),
            iface.encodeFunctionData(fragment, params)
        ];
        funcName = "resolve(bytes,bytes)";
    }
    params.push({
        enableCcipRead: true
    });
    try {
        const result = await _class_private_field_get._(this, _resolver)[funcName](...params);
        if (fragment) {
            return iface.decodeFunctionResult(fragment, result)[0];
        }
        return result;
    } catch (error) {
        if (!(0, index_js_5.isError)(error, "CALL_EXCEPTION")) {
            throw error;
        }
    }
    return null;
}
async function getResolver(provider, name) {
    const ensAddr = await EnsResolver.getEnsAddress(provider);
    try {
        const contract = new index_js_3.Contract(ensAddr, [
            "function resolver(bytes32) view returns (address)"
        ], provider);
        const addr = await contract.resolver((0, index_js_4.namehash)(name), {
            enableCcipRead: true
        });
        if (addr === index_js_2.ZeroAddress) {
            return null;
        }
        return addr;
    } catch (error) {
        // ENS registry cannot throw errors on resolver(bytes32),
        // so probably a link error
        throw error;
    }
    return null;
}
exports.EnsResolver = EnsResolver; //# sourceMappingURL=ens-resolver.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/format.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatTransactionResponse = exports.formatTransactionReceipt = exports.formatReceiptLog = exports.formatBlock = exports.formatLog = exports.formatUint256 = exports.formatHash = exports.formatData = exports.formatBoolean = exports.object = exports.arrayOf = exports.allowNull = void 0;
/**
 *  @_ignore
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const BN_0 = BigInt(0);
function allowNull(format, nullValue) {
    return function(value) {
        if (value == null) {
            return nullValue;
        }
        return format(value);
    };
}
exports.allowNull = allowNull;
function arrayOf(format, allowNull) {
    return (array)=>{
        if (allowNull && array == null) {
            return null;
        }
        if (!Array.isArray(array)) {
            throw new Error("not an array");
        }
        return array.map((i)=>format(i));
    };
}
exports.arrayOf = arrayOf;
// Requires an object which matches a fleet of other formatters
// Any FormatFunc may return `undefined` to have the value omitted
// from the result object. Calls preserve `this`.
function object(format, altNames) {
    return (value)=>{
        const result = {};
        for(const key in format){
            let srcKey = key;
            if (altNames && key in altNames && !(srcKey in value)) {
                for (const altKey of altNames[key]){
                    if (altKey in value) {
                        srcKey = altKey;
                        break;
                    }
                }
            }
            try {
                const nv = format[key](value[srcKey]);
                if (nv !== undefined) {
                    result[key] = nv;
                }
            } catch (error) {
                const message = error instanceof Error ? error.message : "not-an-error";
                (0, index_js_4.assert)(false, "invalid value for value.".concat(key, " (").concat(message, ")"), "BAD_DATA", {
                    value
                });
            }
        }
        return result;
    };
}
exports.object = object;
function formatBoolean(value) {
    switch(value){
        case true:
        case "true":
            return true;
        case false:
        case "false":
            return false;
    }
    (0, index_js_4.assertArgument)(false, "invalid boolean; ".concat(JSON.stringify(value)), "value", value);
}
exports.formatBoolean = formatBoolean;
function formatData(value) {
    (0, index_js_4.assertArgument)((0, index_js_4.isHexString)(value, true), "invalid data", "value", value);
    return value;
}
exports.formatData = formatData;
function formatHash(value) {
    (0, index_js_4.assertArgument)((0, index_js_4.isHexString)(value, 32), "invalid hash", "value", value);
    return value;
}
exports.formatHash = formatHash;
function formatUint256(value) {
    if (!(0, index_js_4.isHexString)(value)) {
        throw new Error("invalid uint256");
    }
    return (0, index_js_4.zeroPadValue)(value, 32);
}
exports.formatUint256 = formatUint256;
const _formatLog = object({
    address: index_js_1.getAddress,
    blockHash: formatHash,
    blockNumber: index_js_4.getNumber,
    data: formatData,
    index: index_js_4.getNumber,
    removed: allowNull(formatBoolean, false),
    topics: arrayOf(formatHash),
    transactionHash: formatHash,
    transactionIndex: index_js_4.getNumber
}, {
    index: [
        "logIndex"
    ]
});
function formatLog(value) {
    return _formatLog(value);
}
exports.formatLog = formatLog;
const _formatBlock = object({
    hash: allowNull(formatHash),
    parentHash: formatHash,
    parentBeaconBlockRoot: allowNull(formatHash, null),
    number: index_js_4.getNumber,
    timestamp: index_js_4.getNumber,
    nonce: allowNull(formatData),
    difficulty: index_js_4.getBigInt,
    gasLimit: index_js_4.getBigInt,
    gasUsed: index_js_4.getBigInt,
    stateRoot: allowNull(formatHash, null),
    receiptsRoot: allowNull(formatHash, null),
    blobGasUsed: allowNull(index_js_4.getBigInt, null),
    excessBlobGas: allowNull(index_js_4.getBigInt, null),
    miner: allowNull(index_js_1.getAddress),
    prevRandao: allowNull(formatHash, null),
    extraData: formatData,
    baseFeePerGas: allowNull(index_js_4.getBigInt)
}, {
    prevRandao: [
        "mixHash"
    ]
});
function formatBlock(value) {
    const result = _formatBlock(value);
    result.transactions = value.transactions.map((tx)=>{
        if (typeof tx === "string") {
            return tx;
        }
        return formatTransactionResponse(tx);
    });
    return result;
}
exports.formatBlock = formatBlock;
const _formatReceiptLog = object({
    transactionIndex: index_js_4.getNumber,
    blockNumber: index_js_4.getNumber,
    transactionHash: formatHash,
    address: index_js_1.getAddress,
    topics: arrayOf(formatHash),
    data: formatData,
    index: index_js_4.getNumber,
    blockHash: formatHash
}, {
    index: [
        "logIndex"
    ]
});
function formatReceiptLog(value) {
    return _formatReceiptLog(value);
}
exports.formatReceiptLog = formatReceiptLog;
const _formatTransactionReceipt = object({
    to: allowNull(index_js_1.getAddress, null),
    from: allowNull(index_js_1.getAddress, null),
    contractAddress: allowNull(index_js_1.getAddress, null),
    // should be allowNull(hash), but broken-EIP-658 support is handled in receipt
    index: index_js_4.getNumber,
    root: allowNull(index_js_4.hexlify),
    gasUsed: index_js_4.getBigInt,
    blobGasUsed: allowNull(index_js_4.getBigInt, null),
    logsBloom: allowNull(formatData),
    blockHash: formatHash,
    hash: formatHash,
    logs: arrayOf(formatReceiptLog),
    blockNumber: index_js_4.getNumber,
    //confirmations: allowNull(getNumber, null),
    cumulativeGasUsed: index_js_4.getBigInt,
    effectiveGasPrice: allowNull(index_js_4.getBigInt),
    blobGasPrice: allowNull(index_js_4.getBigInt, null),
    status: allowNull(index_js_4.getNumber),
    type: allowNull(index_js_4.getNumber, 0)
}, {
    effectiveGasPrice: [
        "gasPrice"
    ],
    hash: [
        "transactionHash"
    ],
    index: [
        "transactionIndex"
    ]
});
function formatTransactionReceipt(value) {
    return _formatTransactionReceipt(value);
}
exports.formatTransactionReceipt = formatTransactionReceipt;
function formatTransactionResponse(value) {
    // Some clients (TestRPC) do strange things like return 0x0 for the
    // 0 address; correct this to be a real address
    if (value.to && (0, index_js_4.getBigInt)(value.to) === BN_0) {
        value.to = "0x0000000000000000000000000000000000000000";
    }
    const result = object({
        hash: formatHash,
        // Some nodes do not return this, usually test nodes (like Ganache)
        index: allowNull(index_js_4.getNumber, undefined),
        type: (value)=>{
            if (value === "0x" || value == null) {
                return 0;
            }
            return (0, index_js_4.getNumber)(value);
        },
        accessList: allowNull(index_js_3.accessListify, null),
        blobVersionedHashes: allowNull(arrayOf(formatHash, true), null),
        authorizationList: allowNull(arrayOf((v)=>{
            let sig;
            if (v.signature) {
                sig = v.signature;
            } else {
                let yParity = v.yParity;
                if (yParity === "0x1b") {
                    yParity = 0;
                } else if (yParity === "0x1c") {
                    yParity = 1;
                }
                sig = Object.assign({}, v, {
                    yParity
                });
            }
            return {
                address: (0, index_js_1.getAddress)(v.address),
                chainId: (0, index_js_4.getBigInt)(v.chainId),
                nonce: (0, index_js_4.getBigInt)(v.nonce),
                signature: index_js_2.Signature.from(sig)
            };
        }, false), null),
        blockHash: allowNull(formatHash, null),
        blockNumber: allowNull(index_js_4.getNumber, null),
        transactionIndex: allowNull(index_js_4.getNumber, null),
        from: index_js_1.getAddress,
        // either (gasPrice) or (maxPriorityFeePerGas + maxFeePerGas) must be set
        gasPrice: allowNull(index_js_4.getBigInt),
        maxPriorityFeePerGas: allowNull(index_js_4.getBigInt),
        maxFeePerGas: allowNull(index_js_4.getBigInt),
        maxFeePerBlobGas: allowNull(index_js_4.getBigInt, null),
        gasLimit: index_js_4.getBigInt,
        to: allowNull(index_js_1.getAddress, null),
        value: index_js_4.getBigInt,
        nonce: index_js_4.getNumber,
        data: formatData,
        creates: allowNull(index_js_1.getAddress, null),
        chainId: allowNull(index_js_4.getBigInt, null)
    }, {
        data: [
            "input"
        ],
        gasLimit: [
            "gas"
        ],
        index: [
            "transactionIndex"
        ]
    })(value);
    // If to and creates are empty, populate the creates from the value
    if (result.to == null && result.creates == null) {
        result.creates = (0, index_js_1.getCreateAddress)(result);
    }
    // @TODO: Check fee data
    // Add an access list to supported transaction types
    if ((value.type === 1 || value.type === 2) && value.accessList == null) {
        result.accessList = [];
    }
    // Compute the signature
    if (value.signature) {
        result.signature = index_js_2.Signature.from(value.signature);
    } else {
        result.signature = index_js_2.Signature.from(value);
    }
    // Some backends omit ChainId on legacy transactions, but we can compute it
    if (result.chainId == null) {
        const chainId = result.signature.legacyChainId;
        if (chainId != null) {
            result.chainId = chainId;
        }
    }
    // @TODO: check chainID
    /*
    if (value.chainId != null) {
        let chainId = value.chainId;

        if (isHexString(chainId)) {
            chainId = BigNumber.from(chainId).toNumber();
        }

        result.chainId = chainId;

    } else {
        let chainId = value.networkId;

        // geth-etc returns chainId
        if (chainId == null && result.v == null) {
            chainId = value.chainId;
        }

        if (isHexString(chainId)) {
            chainId = BigNumber.from(chainId).toNumber();
        }

        if (typeof(chainId) !== "number" && result.v != null) {
            chainId = (result.v - 35) / 2;
            if (chainId < 0) { chainId = 0; }
            chainId = parseInt(chainId);
        }

        if (typeof(chainId) !== "number") { chainId = 0; }

        result.chainId = chainId;
    }
    */ // 0x0000... should actually be null
    if (result.blockHash && (0, index_js_4.getBigInt)(result.blockHash) === BN_0) {
        result.blockHash = null;
    }
    return result;
}
exports.formatTransactionResponse = formatTransactionResponse; //# sourceMappingURL=format.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/plugins-network.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FetchUrlFeeDataNetworkPlugin = exports.FeeDataNetworkPlugin = exports.EnsPlugin = exports.GasCostPlugin = exports.NetworkPlugin = void 0;
const properties_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/properties.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const EnsAddress = "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e";
/**
 *  A **NetworkPlugin** provides additional functionality on a [[Network]].
 */ class NetworkPlugin {
    /**
     *  Creates a copy of this plugin.
     */ clone() {
        return new NetworkPlugin(this.name);
    }
    /**
     *  Creates a new **NetworkPlugin**.
     */ constructor(name){
        /**
     *  The name of the plugin.
     *
     *  It is recommended to use reverse-domain-notation, which permits
     *  unique names with a known authority as well as hierarchal entries.
     */ _define_property._(this, "name", void 0);
        (0, properties_js_1.defineProperties)(this, {
            name
        });
    }
}
exports.NetworkPlugin = NetworkPlugin;
/**
 *  A **GasCostPlugin** allows a network to provide alternative values when
 *  computing the intrinsic gas required for a transaction.
 */ class GasCostPlugin extends NetworkPlugin {
    clone() {
        return new GasCostPlugin(this.effectiveBlock, this);
    }
    /**
     *  Creates a new GasCostPlugin from %%effectiveBlock%% until the
     *  latest block or another GasCostPlugin supercedes that block number,
     *  with the associated %%costs%%.
     */ constructor(effectiveBlock, costs){
        if (effectiveBlock == null) {
            effectiveBlock = 0;
        }
        super("org.ethers.network.plugins.GasCost#".concat(effectiveBlock || 0)), /**
     *  The block number to treat these values as valid from.
     *
     *  This allows a hardfork to have updated values included as well as
     *  mulutiple hardforks to be supported.
     */ _define_property._(this, "effectiveBlock", void 0), /**
     *  The transactions base fee.
     */ _define_property._(this, "txBase", void 0), /**
     *  The fee for creating a new account.
     */ _define_property._(this, "txCreate", void 0), /**
     *  The fee per zero-byte in the data.
     */ _define_property._(this, "txDataZero", void 0), /**
     *  The fee per non-zero-byte in the data.
     */ _define_property._(this, "txDataNonzero", void 0), /**
     *  The fee per storage key in the [[link-eip-2930]] access list.
     */ _define_property._(this, "txAccessListStorageKey", void 0), /**
     *  The fee per address in the [[link-eip-2930]] access list.
     */ _define_property._(this, "txAccessListAddress", void 0);
        const props = {
            effectiveBlock
        };
        function set(name, nullish) {
            let value = (costs || {})[name];
            if (value == null) {
                value = nullish;
            }
            (0, index_js_1.assertArgument)(typeof value === "number", "invalud value for ".concat(name), "costs", costs);
            props[name] = value;
        }
        set("txBase", 21000);
        set("txCreate", 32000);
        set("txDataZero", 4);
        set("txDataNonzero", 16);
        set("txAccessListStorageKey", 1900);
        set("txAccessListAddress", 2400);
        (0, properties_js_1.defineProperties)(this, props);
    }
}
exports.GasCostPlugin = GasCostPlugin;
/**
 *  An **EnsPlugin** allows a [[Network]] to specify the ENS Registry
 *  Contract address and the target network to use when using that
 *  contract.
 *
 *  Various testnets have their own instance of the contract to use, but
 *  in general, the mainnet instance supports multi-chain addresses and
 *  should be used.
 */ class EnsPlugin extends NetworkPlugin {
    clone() {
        return new EnsPlugin(this.address, this.targetNetwork);
    }
    /**
     *  Creates a new **EnsPlugin** connected to %%address%% on the
     *  %%targetNetwork%%. The default ENS address and mainnet is used
     *  if unspecified.
     */ constructor(address, targetNetwork){
        super("org.ethers.plugins.network.Ens"), /**
     *  The ENS Registrty Contract address.
     */ _define_property._(this, "address", void 0), /**
     *  The chain ID that the ENS contract lives on.
     */ _define_property._(this, "targetNetwork", void 0);
        (0, properties_js_1.defineProperties)(this, {
            address: address || EnsAddress,
            targetNetwork: targetNetwork == null ? 1 : targetNetwork
        });
    }
}
exports.EnsPlugin = EnsPlugin;
var _feeDataFunc = /*#__PURE__*/ new WeakMap();
/**
 *  A **FeeDataNetworkPlugin** allows a network to provide and alternate
 *  means to specify its fee data.
 *
 *  For example, a network which does not support [[link-eip-1559]] may
 *  choose to use a Gas Station site to approximate the gas price.
 */ class FeeDataNetworkPlugin extends NetworkPlugin {
    /**
     *  The fee data function provided to the constructor.
     */ get feeDataFunc() {
        return _class_private_field_get._(this, _feeDataFunc);
    }
    /**
     *  Resolves to the fee data.
     */ async getFeeData(provider) {
        return await _class_private_field_get._(this, _feeDataFunc).call(this, provider);
    }
    clone() {
        return new FeeDataNetworkPlugin(_class_private_field_get._(this, _feeDataFunc));
    }
    /**
     *  Creates a new **FeeDataNetworkPlugin**.
     */ constructor(feeDataFunc){
        super("org.ethers.plugins.network.FeeData"), _class_private_field_init._(this, _feeDataFunc, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _feeDataFunc, feeDataFunc);
    }
}
exports.FeeDataNetworkPlugin = FeeDataNetworkPlugin;
var _url = /*#__PURE__*/ new WeakMap(), _processFunc = /*#__PURE__*/ new WeakMap();
class FetchUrlFeeDataNetworkPlugin extends NetworkPlugin {
    /**
     *  The URL to initialize the FetchRequest with in %%processFunc%%.
     */ get url() {
        return _class_private_field_get._(this, _url);
    }
    /**
     *  The callback to use when computing the FeeData.
     */ get processFunc() {
        return _class_private_field_get._(this, _processFunc);
    }
    // We are immutable, so we can serve as our own clone
    clone() {
        return this;
    }
    /**
     *  Creates a new **FetchUrlFeeDataNetworkPlugin** which will
     *  be used when computing the fee data for the network.
     */ constructor(url, processFunc){
        super("org.ethers.plugins.network.FetchUrlFeeDataPlugin"), _class_private_field_init._(this, _url, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _processFunc, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _url, url);
        _class_private_field_set._(this, _processFunc, processFunc);
    }
}
exports.FetchUrlFeeDataNetworkPlugin = FetchUrlFeeDataNetworkPlugin; /*
export class CustomBlockNetworkPlugin extends NetworkPlugin {
    readonly #blockFunc: (provider: Provider, block: BlockParams<string>) => Block<string>;
    readonly #blockWithTxsFunc: (provider: Provider, block: BlockParams<TransactionResponseParams>) => Block<TransactionResponse>;

    constructor(blockFunc: (provider: Provider, block: BlockParams<string>) => Block<string>, blockWithTxsFunc: (provider: Provider, block: BlockParams<TransactionResponseParams>) => Block<TransactionResponse>) {
        super("org.ethers.network-plugins.custom-block");
        this.#blockFunc = blockFunc;
        this.#blockWithTxsFunc = blockWithTxsFunc;
    }

    async getBlock(provider: Provider, block: BlockParams<string>): Promise<Block<string>> {
        return await this.#blockFunc(provider, block);
    }

    async getBlockions(provider: Provider, block: BlockParams<TransactionResponseParams>): Promise<Block<TransactionResponse>> {
        return await this.#blockWithTxsFunc(provider, block);
    }

    clone(): CustomBlockNetworkPlugin {
        return new CustomBlockNetworkPlugin(this.#blockFunc, this.#blockWithTxsFunc);
    }
}
*/  //# sourceMappingURL=plugins-network.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
/**
 *  A **Network** encapsulates the various properties required to
 *  interact with a specific chain.
 *
 *  @_subsection: api/providers:Networks  [networks]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Network = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const plugins_network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/plugins-network.js [app-client] (ecmascript)");
/* * * *
// Networks which operation against an L2 can use this plugin to
// specify how to access L1, for the purpose of resolving ENS,
// for example.
export class LayerOneConnectionPlugin extends NetworkPlugin {
    readonly provider!: Provider;
// @TODO: Rename to ChainAccess and allow for connecting to any chain
    constructor(provider: Provider) {
        super("org.ethers.plugins.layer-one-connection");
        defineProperties<LayerOneConnectionPlugin>(this, { provider });
    }

    clone(): LayerOneConnectionPlugin {
        return new LayerOneConnectionPlugin(this.provider);
    }
}
*/ const Networks = new Map();
var _name = /*#__PURE__*/ new WeakMap(), _chainId = /*#__PURE__*/ new WeakMap(), _plugins = /*#__PURE__*/ new WeakMap();
/**
 *  A **Network** provides access to a chain's properties and allows
 *  for plug-ins to extend functionality.
 */ class Network {
    /**
     *  Returns a JSON-compatible representation of a Network.
     */ toJSON() {
        return {
            name: this.name,
            chainId: String(this.chainId)
        };
    }
    /**
     *  The network common name.
     *
     *  This is the canonical name, as networks migh have multiple
     *  names.
     */ get name() {
        return _class_private_field_get._(this, _name);
    }
    set name(value) {
        _class_private_field_set._(this, _name, value);
    }
    /**
     *  The network chain ID.
     */ get chainId() {
        return _class_private_field_get._(this, _chainId);
    }
    set chainId(value) {
        _class_private_field_set._(this, _chainId, (0, index_js_2.getBigInt)(value, "chainId"));
    }
    /**
     *  Returns true if %%other%% matches this network. Any chain ID
     *  must match, and if no chain ID is present, the name must match.
     *
     *  This method does not currently check for additional properties,
     *  such as ENS address or plug-in compatibility.
     */ matches(other) {
        if (other == null) {
            return false;
        }
        if (typeof other === "string") {
            try {
                return this.chainId === (0, index_js_2.getBigInt)(other);
            } catch (error) {}
            return this.name === other;
        }
        if (typeof other === "number" || typeof other === "bigint") {
            try {
                return this.chainId === (0, index_js_2.getBigInt)(other);
            } catch (error) {}
            return false;
        }
        if (typeof other === "object") {
            if (other.chainId != null) {
                try {
                    return this.chainId === (0, index_js_2.getBigInt)(other.chainId);
                } catch (error) {}
                return false;
            }
            if (other.name != null) {
                return this.name === other.name;
            }
            return false;
        }
        return false;
    }
    /**
     *  Returns the list of plugins currently attached to this Network.
     */ get plugins() {
        return Array.from(_class_private_field_get._(this, _plugins).values());
    }
    /**
     *  Attach a new %%plugin%% to this Network. The network name
     *  must be unique, excluding any fragment.
     */ attachPlugin(plugin) {
        if (_class_private_field_get._(this, _plugins).get(plugin.name)) {
            throw new Error("cannot replace existing plugin: ".concat(plugin.name, " "));
        }
        _class_private_field_get._(this, _plugins).set(plugin.name, plugin.clone());
        return this;
    }
    /**
     *  Return the plugin, if any, matching %%name%% exactly. Plugins
     *  with fragments will not be returned unless %%name%% includes
     *  a fragment.
     */ getPlugin(name) {
        return _class_private_field_get._(this, _plugins).get(name) || null;
    }
    /**
     *  Gets a list of all plugins that match %%name%%, with otr without
     *  a fragment.
     */ getPlugins(basename) {
        return this.plugins.filter((p)=>p.name.split("#")[0] === basename);
    }
    /**
     *  Create a copy of this Network.
     */ clone() {
        const clone = new Network(this.name, this.chainId);
        this.plugins.forEach((plugin)=>{
            clone.attachPlugin(plugin.clone());
        });
        return clone;
    }
    /**
     *  Compute the intrinsic gas required for a transaction.
     *
     *  A GasCostPlugin can be attached to override the default
     *  values.
     */ computeIntrinsicGas(tx) {
        const costs = this.getPlugin("org.ethers.plugins.network.GasCost") || new plugins_network_js_1.GasCostPlugin();
        let gas = costs.txBase;
        if (tx.to == null) {
            gas += costs.txCreate;
        }
        if (tx.data) {
            for(let i = 2; i < tx.data.length; i += 2){
                if (tx.data.substring(i, i + 2) === "00") {
                    gas += costs.txDataZero;
                } else {
                    gas += costs.txDataNonzero;
                }
            }
        }
        if (tx.accessList) {
            const accessList = (0, index_js_1.accessListify)(tx.accessList);
            for(const addr in accessList){
                gas += costs.txAccessListAddress + costs.txAccessListStorageKey * accessList[addr].storageKeys.length;
            }
        }
        return gas;
    }
    /**
     *  Returns a new Network for the %%network%% name or chainId.
     */ static from(network) {
        injectCommonNetworks();
        // Default network
        if (network == null) {
            return Network.from("mainnet");
        }
        // Canonical name or chain ID
        if (typeof network === "number") {
            network = BigInt(network);
        }
        if (typeof network === "string" || typeof network === "bigint") {
            const networkFunc = Networks.get(network);
            if (networkFunc) {
                return networkFunc();
            }
            if (typeof network === "bigint") {
                return new Network("unknown", network);
            }
            (0, index_js_2.assertArgument)(false, "unknown network", "network", network);
        }
        // Clonable with network-like abilities
        if (typeof network.clone === "function") {
            const clone = network.clone();
            //if (typeof(network.name) !== "string" || typeof(network.chainId) !== "number") {
            //}
            return clone;
        }
        // Networkish
        if (typeof network === "object") {
            (0, index_js_2.assertArgument)(typeof network.name === "string" && typeof network.chainId === "number", "invalid network object name or chainId", "network", network);
            const custom = new Network(network.name, network.chainId);
            if (network.ensAddress || network.ensNetwork != null) {
                custom.attachPlugin(new plugins_network_js_1.EnsPlugin(network.ensAddress, network.ensNetwork));
            }
            //if ((<any>network).layerOneConnection) {
            //    custom.attachPlugin(new LayerOneConnectionPlugin((<any>network).layerOneConnection));
            //}
            return custom;
        }
        (0, index_js_2.assertArgument)(false, "invalid network", "network", network);
    }
    /**
     *  Register %%nameOrChainId%% with a function which returns
     *  an instance of a Network representing that chain.
     */ static register(nameOrChainId, networkFunc) {
        if (typeof nameOrChainId === "number") {
            nameOrChainId = BigInt(nameOrChainId);
        }
        const existing = Networks.get(nameOrChainId);
        if (existing) {
            (0, index_js_2.assertArgument)(false, "conflicting network for ".concat(JSON.stringify(existing.name)), "nameOrChainId", nameOrChainId);
        }
        Networks.set(nameOrChainId, networkFunc);
    }
    /**
     *  Creates a new **Network** for %%name%% and %%chainId%%.
     */ constructor(name, chainId){
        _class_private_field_init._(this, _name, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _chainId, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _plugins, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _name, name);
        _class_private_field_set._(this, _chainId, (0, index_js_2.getBigInt)(chainId));
        _class_private_field_set._(this, _plugins, new Map());
    }
}
exports.Network = Network;
// We don't want to bring in formatUnits because it is backed by
// FixedNumber and we want to keep Networks tiny. The values
// included by the Gas Stations are also IEEE 754 with lots of
// rounding issues and exceed the strict checks formatUnits has.
function parseUnits(_value, decimals) {
    const value = String(_value);
    if (!value.match(/^[0-9.]+$/)) {
        throw new Error("invalid gwei value: ".concat(_value));
    }
    // Break into [ whole, fraction ]
    const comps = value.split(".");
    if (comps.length === 1) {
        comps.push("");
    }
    // More than 1 decimal point or too many fractional positions
    if (comps.length !== 2) {
        throw new Error("invalid gwei value: ".concat(_value));
    }
    // Pad the fraction to 9 decimalplaces
    while(comps[1].length < decimals){
        comps[1] += "0";
    }
    // Too many decimals and some non-zero ending, take the ceiling
    if (comps[1].length > 9) {
        let frac = BigInt(comps[1].substring(0, 9));
        if (!comps[1].substring(9).match(/^0+$/)) {
            frac++;
        }
        comps[1] = frac.toString();
    }
    return BigInt(comps[0] + comps[1]);
}
// Used by Polygon to use a gas station for fee data
function getGasStationPlugin(url) {
    return new plugins_network_js_1.FetchUrlFeeDataNetworkPlugin(url, async (fetchFeeData, provider, request)=>{
        // Prevent Cloudflare from blocking our request in node.js
        request.setHeader("User-Agent", "ethers");
        let response;
        try {
            const [_response, _feeData] = await Promise.all([
                request.send(),
                fetchFeeData()
            ]);
            response = _response;
            const payload = response.bodyJson.standard;
            const feeData = {
                gasPrice: _feeData.gasPrice,
                maxFeePerGas: parseUnits(payload.maxFee, 9),
                maxPriorityFeePerGas: parseUnits(payload.maxPriorityFee, 9)
            };
            return feeData;
        } catch (error) {
            (0, index_js_2.assert)(false, "error encountered with polygon gas station (".concat(JSON.stringify(request.url), ")"), "SERVER_ERROR", {
                request,
                response,
                error
            });
        }
    });
}
// See: https://chainlist.org
let injected = false;
function injectCommonNetworks() {
    if (injected) {
        return;
    }
    injected = true;
    /// Register popular Ethereum networks
    function registerEth(name, chainId, options) {
        const func = function() {
            const network = new Network(name, chainId);
            // We use 0 to disable ENS
            if (options.ensNetwork != null) {
                network.attachPlugin(new plugins_network_js_1.EnsPlugin(null, options.ensNetwork));
            }
            network.attachPlugin(new plugins_network_js_1.GasCostPlugin());
            (options.plugins || []).forEach((plugin)=>{
                network.attachPlugin(plugin);
            });
            return network;
        };
        // Register the network by name and chain ID
        Network.register(name, func);
        Network.register(chainId, func);
        if (options.altNames) {
            options.altNames.forEach((name)=>{
                Network.register(name, func);
            });
        }
    }
    registerEth("mainnet", 1, {
        ensNetwork: 1,
        altNames: [
            "homestead"
        ]
    });
    registerEth("ropsten", 3, {
        ensNetwork: 3
    });
    registerEth("rinkeby", 4, {
        ensNetwork: 4
    });
    registerEth("goerli", 5, {
        ensNetwork: 5
    });
    registerEth("kovan", 42, {
        ensNetwork: 42
    });
    registerEth("sepolia", 11155111, {
        ensNetwork: 11155111
    });
    registerEth("holesky", 17000, {
        ensNetwork: 17000
    });
    registerEth("classic", 61, {});
    registerEth("classicKotti", 6, {});
    registerEth("arbitrum", 42161, {
        ensNetwork: 1
    });
    registerEth("arbitrum-goerli", 421613, {});
    registerEth("arbitrum-sepolia", 421614, {});
    registerEth("base", 8453, {
        ensNetwork: 1
    });
    registerEth("base-goerli", 84531, {});
    registerEth("base-sepolia", 84532, {});
    registerEth("bnb", 56, {
        ensNetwork: 1
    });
    registerEth("bnbt", 97, {});
    registerEth("linea", 59144, {
        ensNetwork: 1
    });
    registerEth("linea-goerli", 59140, {});
    registerEth("linea-sepolia", 59141, {});
    registerEth("matic", 137, {
        ensNetwork: 1,
        plugins: [
            getGasStationPlugin("https:/\/gasstation.polygon.technology/v2")
        ]
    });
    registerEth("matic-amoy", 80002, {});
    registerEth("matic-mumbai", 80001, {
        altNames: [
            "maticMumbai",
            "maticmum"
        ],
        plugins: [
            getGasStationPlugin("https:/\/gasstation-testnet.polygon.technology/v2")
        ]
    });
    registerEth("optimism", 10, {
        ensNetwork: 1,
        plugins: []
    });
    registerEth("optimism-goerli", 420, {});
    registerEth("optimism-sepolia", 11155420, {});
    registerEth("xdai", 100, {
        ensNetwork: 1
    });
} //# sourceMappingURL=network.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/subscriber-polling.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PollingEventSubscriber = exports.PollingTransactionSubscriber = exports.PollingOrphanSubscriber = exports.PollingBlockTagSubscriber = exports.OnBlockSubscriber = exports.PollingBlockSubscriber = exports.getPollingSubscriber = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
function copy(obj) {
    return JSON.parse(JSON.stringify(obj));
}
/**
 *  Return the polling subscriber for common events.
 *
 *  @_docloc: api/providers/abstract-provider
 */ function getPollingSubscriber(provider, event) {
    if (event === "block") {
        return new PollingBlockSubscriber(provider);
    }
    if ((0, index_js_1.isHexString)(event, 32)) {
        return new PollingTransactionSubscriber(provider, event);
    }
    (0, index_js_1.assert)(false, "unsupported polling event", "UNSUPPORTED_OPERATION", {
        operation: "getPollingSubscriber",
        info: {
            event
        }
    });
}
exports.getPollingSubscriber = getPollingSubscriber;
var _provider = /*#__PURE__*/ new WeakMap(), _poller = /*#__PURE__*/ new WeakMap(), _interval = /*#__PURE__*/ new WeakMap(), // The most recent block we have scanned for events. The value -2
// indicates we still need to fetch an initial block number
_blockNumber = /*#__PURE__*/ new WeakMap(), _poll = /*#__PURE__*/ new WeakSet();
// @TODO: refactor this
/**
 *  A **PollingBlockSubscriber** polls at a regular interval for a change
 *  in the block number.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class PollingBlockSubscriber {
    /**
     *  The polling interval.
     */ get pollingInterval() {
        return _class_private_field_get._(this, _interval);
    }
    set pollingInterval(value) {
        _class_private_field_set._(this, _interval, value);
    }
    start() {
        if (_class_private_field_get._(this, _poller)) {
            return;
        }
        _class_private_field_set._(this, _poller, _class_private_field_get._(this, _provider)._setTimeout(_class_private_method_get._(this, _poll, poll).bind(this), _class_private_field_get._(this, _interval)));
        _class_private_method_get._(this, _poll, poll).call(this);
    }
    stop() {
        if (!_class_private_field_get._(this, _poller)) {
            return;
        }
        _class_private_field_get._(this, _provider)._clearTimeout(_class_private_field_get._(this, _poller));
        _class_private_field_set._(this, _poller, null);
    }
    pause(dropWhilePaused) {
        this.stop();
        if (dropWhilePaused) {
            _class_private_field_set._(this, _blockNumber, -2);
        }
    }
    resume() {
        this.start();
    }
    /**
     *  Create a new **PollingBlockSubscriber** attached to %%provider%%.
     */ constructor(provider){
        _class_private_method_init._(this, _poll);
        _class_private_field_init._(this, _provider, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _poller, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _interval, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _blockNumber, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _provider, provider);
        _class_private_field_set._(this, _poller, null);
        _class_private_field_set._(this, _interval, 4000);
        _class_private_field_set._(this, _blockNumber, -2);
    }
}
async function poll() {
    try {
        const blockNumber = await _class_private_field_get._(this, _provider).getBlockNumber();
        // Bootstrap poll to setup our initial block number
        if (_class_private_field_get._(this, _blockNumber) === -2) {
            _class_private_field_set._(this, _blockNumber, blockNumber);
            return;
        }
        // @TODO: Put a cap on the maximum number of events per loop?
        if (blockNumber !== _class_private_field_get._(this, _blockNumber)) {
            for(let b = _class_private_field_get._(this, _blockNumber) + 1; b <= blockNumber; b++){
                // We have been stopped
                if (_class_private_field_get._(this, _poller) == null) {
                    return;
                }
                await _class_private_field_get._(this, _provider).emit("block", b);
            }
            _class_private_field_set._(this, _blockNumber, blockNumber);
        }
    } catch (error) {
    // @TODO: Minor bump, add an "error" event to let subscribers
    //        know things went awry.
    //console.log(error);
    }
    // We have been stopped
    if (_class_private_field_get._(this, _poller) == null) {
        return;
    }
    _class_private_field_set._(this, _poller, _class_private_field_get._(this, _provider)._setTimeout(_class_private_method_get._(this, _poll, poll).bind(this), _class_private_field_get._(this, _interval)));
}
exports.PollingBlockSubscriber = PollingBlockSubscriber;
var _provider1 = /*#__PURE__*/ new WeakMap(), _poll1 = /*#__PURE__*/ new WeakMap(), _running = /*#__PURE__*/ new WeakMap();
/**
 *  An **OnBlockSubscriber** can be sub-classed, with a [[_poll]]
 *  implmentation which will be called on every new block.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class OnBlockSubscriber {
    /**
     *  Called on every new block.
     */ async _poll(blockNumber, provider) {
        throw new Error("sub-classes must override this");
    }
    start() {
        if (_class_private_field_get._(this, _running)) {
            return;
        }
        _class_private_field_set._(this, _running, true);
        _class_private_field_get._(this, _poll1).call(this, -2);
        _class_private_field_get._(this, _provider1).on("block", _class_private_field_get._(this, _poll1));
    }
    stop() {
        if (!_class_private_field_get._(this, _running)) {
            return;
        }
        _class_private_field_set._(this, _running, false);
        _class_private_field_get._(this, _provider1).off("block", _class_private_field_get._(this, _poll1));
    }
    pause(dropWhilePaused) {
        this.stop();
    }
    resume() {
        this.start();
    }
    /**
     *  Create a new **OnBlockSubscriber** attached to %%provider%%.
     */ constructor(provider){
        _class_private_field_init._(this, _provider1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _poll1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _running, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _provider1, provider);
        _class_private_field_set._(this, _running, false);
        _class_private_field_set._(this, _poll1, (blockNumber)=>{
            this._poll(blockNumber, _class_private_field_get._(this, _provider1));
        });
    }
}
exports.OnBlockSubscriber = OnBlockSubscriber;
var _tag = /*#__PURE__*/ new WeakMap(), _lastBlock = /*#__PURE__*/ new WeakMap();
class PollingBlockTagSubscriber extends OnBlockSubscriber {
    pause(dropWhilePaused) {
        if (dropWhilePaused) {
            _class_private_field_set._(this, _lastBlock, -2);
        }
        super.pause(dropWhilePaused);
    }
    async _poll(blockNumber, provider) {
        const block = await provider.getBlock(_class_private_field_get._(this, _tag));
        if (block == null) {
            return;
        }
        if (_class_private_field_get._(this, _lastBlock) === -2) {
            _class_private_field_set._(this, _lastBlock, block.number);
        } else if (block.number > _class_private_field_get._(this, _lastBlock)) {
            provider.emit(_class_private_field_get._(this, _tag), block.number);
            _class_private_field_set._(this, _lastBlock, block.number);
        }
    }
    constructor(provider, tag){
        super(provider), _class_private_field_init._(this, _tag, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _lastBlock, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _tag, tag);
        _class_private_field_set._(this, _lastBlock, -2);
    }
}
exports.PollingBlockTagSubscriber = PollingBlockTagSubscriber;
var _filter = /*#__PURE__*/ new WeakMap();
/**
 *  @_ignore:
 *
 *  @_docloc: api/providers/abstract-provider
 */ class PollingOrphanSubscriber extends OnBlockSubscriber {
    async _poll(blockNumber, provider) {
        throw new Error("@TODO");
        console.log(_class_private_field_get._(this, _filter));
    }
    constructor(provider, filter){
        super(provider), _class_private_field_init._(this, _filter, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _filter, copy(filter));
    }
}
exports.PollingOrphanSubscriber = PollingOrphanSubscriber;
var _hash = /*#__PURE__*/ new WeakMap();
/**
 *  A **PollingTransactionSubscriber** will poll for a given transaction
 *  hash for its receipt.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class PollingTransactionSubscriber extends OnBlockSubscriber {
    async _poll(blockNumber, provider) {
        const tx = await provider.getTransactionReceipt(_class_private_field_get._(this, _hash));
        if (tx) {
            provider.emit(_class_private_field_get._(this, _hash), tx);
        }
    }
    /**
     *  Create a new **PollingTransactionSubscriber** attached to
     *  %%provider%%, listening for %%hash%%.
     */ constructor(provider, hash){
        super(provider), _class_private_field_init._(this, _hash, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _hash, hash);
    }
}
exports.PollingTransactionSubscriber = PollingTransactionSubscriber;
var _provider2 = /*#__PURE__*/ new WeakMap(), _filter1 = /*#__PURE__*/ new WeakMap(), _poller1 = /*#__PURE__*/ new WeakMap(), _running1 = /*#__PURE__*/ new WeakMap(), // The most recent block we have scanned for events. The value -2
// indicates we still need to fetch an initial block number
_blockNumber1 = /*#__PURE__*/ new WeakMap(), _poll2 = /*#__PURE__*/ new WeakSet();
/**
 *  A **PollingEventSubscriber** will poll for a given filter for its logs.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class PollingEventSubscriber {
    start() {
        if (_class_private_field_get._(this, _running1)) {
            return;
        }
        _class_private_field_set._(this, _running1, true);
        if (_class_private_field_get._(this, _blockNumber1) === -2) {
            _class_private_field_get._(this, _provider2).getBlockNumber().then((blockNumber)=>{
                _class_private_field_set._(this, _blockNumber1, blockNumber);
            });
        }
        _class_private_field_get._(this, _provider2).on("block", _class_private_field_get._(this, _poller1));
    }
    stop() {
        if (!_class_private_field_get._(this, _running1)) {
            return;
        }
        _class_private_field_set._(this, _running1, false);
        _class_private_field_get._(this, _provider2).off("block", _class_private_field_get._(this, _poller1));
    }
    pause(dropWhilePaused) {
        this.stop();
        if (dropWhilePaused) {
            _class_private_field_set._(this, _blockNumber1, -2);
        }
    }
    resume() {
        this.start();
    }
    /**
     *  Create a new **PollingTransactionSubscriber** attached to
     *  %%provider%%, listening for %%filter%%.
     */ constructor(provider, filter){
        _class_private_method_init._(this, _poll2);
        _class_private_field_init._(this, _provider2, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _filter1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _poller1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _running1, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _blockNumber1, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _provider2, provider);
        _class_private_field_set._(this, _filter1, copy(filter));
        _class_private_field_set._(this, _poller1, _class_private_method_get._(this, _poll2, poll1).bind(this));
        _class_private_field_set._(this, _running1, false);
        _class_private_field_set._(this, _blockNumber1, -2);
    }
}
async function poll1(blockNumber) {
    // The initial block hasn't been determined yet
    if (_class_private_field_get._(this, _blockNumber1) === -2) {
        return;
    }
    const filter = copy(_class_private_field_get._(this, _filter1));
    filter.fromBlock = _class_private_field_get._(this, _blockNumber1) + 1;
    filter.toBlock = blockNumber;
    const logs = await _class_private_field_get._(this, _provider2).getLogs(filter);
    // No logs could just mean the node has not indexed them yet,
    // so we keep a sliding window of 60 blocks to keep scanning
    if (logs.length === 0) {
        if (_class_private_field_get._(this, _blockNumber1) < blockNumber - 60) {
            _class_private_field_set._(this, _blockNumber1, blockNumber - 60);
        }
        return;
    }
    for (const log of logs){
        _class_private_field_get._(this, _provider2).emit(_class_private_field_get._(this, _filter1), log);
        // Only advance the block number when logs were found to
        // account for networks (like BNB and Polygon) which may
        // sacrifice event consistency for block event speed
        _class_private_field_set._(this, _blockNumber1, log.blockNumber);
    }
}
exports.PollingEventSubscriber = PollingEventSubscriber; //# sourceMappingURL=subscriber-polling.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-provider.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_field_update = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_update.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  The available providers should suffice for most developers purposes,
 *  but the [[AbstractProvider]] class has many features which enable
 *  sub-classing it for specific purposes.
 *
 *  @_section: api/providers/abstract-provider: Subclassing Provider  [abstract-provider]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AbstractProvider = exports.UnmanagedSubscriber = void 0;
// @TODO
// Event coalescence
//   When we register an event with an async value (e.g. address is a Signer
//   or ENS name), we need to add it immeidately for the Event API, but also
//   need time to resolve the address. Upon resolving the address, we need to
//   migrate the listener to the static event. We also need to maintain a map
//   of Signer/ENS name to address so we can sync respond to listenerCount.
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/constants/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
const index_js_5 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_6 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const ens_resolver_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/ens-resolver.js [app-client] (ecmascript)");
const format_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/format.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider.js [app-client] (ecmascript)");
const subscriber_polling_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/subscriber-polling.js [app-client] (ecmascript)");
// Constants
const BN_2 = BigInt(2);
const MAX_CCIP_REDIRECTS = 10;
function isPromise(value) {
    return value && typeof value.then === "function";
}
function getTag(prefix, value) {
    return prefix + ":" + JSON.stringify(value, (k, v)=>{
        if (v == null) {
            return "null";
        }
        if (typeof v === "bigint") {
            return "bigint:".concat(v.toString());
        }
        if (typeof v === "string") {
            return v.toLowerCase();
        }
        // Sort object keys
        if (typeof v === "object" && !Array.isArray(v)) {
            const keys = Object.keys(v);
            keys.sort();
            return keys.reduce((accum, key)=>{
                accum[key] = v[key];
                return accum;
            }, {});
        }
        return v;
    });
}
/**
 *  An **UnmanagedSubscriber** is useful for events which do not require
 *  any additional management, such as ``"debug"`` which only requires
 *  emit in synchronous event loop triggered calls.
 */ class UnmanagedSubscriber {
    start() {}
    stop() {}
    pause(dropWhilePaused) {}
    resume() {}
    /**
     *  Create a new UnmanagedSubscriber with %%name%%.
     */ constructor(name){
        /**
     *  The name fof the event.
     */ _define_property._(this, "name", void 0);
        (0, index_js_6.defineProperties)(this, {
            name
        });
    }
}
exports.UnmanagedSubscriber = UnmanagedSubscriber;
function copy(value) {
    return JSON.parse(JSON.stringify(value));
}
function concisify(items) {
    items = Array.from(new Set(items).values());
    items.sort();
    return items;
}
async function getSubscription(_event, provider) {
    if (_event == null) {
        throw new Error("invalid event");
    }
    // Normalize topic array info an EventFilter
    if (Array.isArray(_event)) {
        _event = {
            topics: _event
        };
    }
    if (typeof _event === "string") {
        switch(_event){
            case "block":
            case "debug":
            case "error":
            case "finalized":
            case "network":
            case "pending":
            case "safe":
                {
                    return {
                        type: _event,
                        tag: _event
                    };
                }
        }
    }
    if ((0, index_js_6.isHexString)(_event, 32)) {
        const hash = _event.toLowerCase();
        return {
            type: "transaction",
            tag: getTag("tx", {
                hash
            }),
            hash
        };
    }
    if (_event.orphan) {
        const event = _event;
        // @TODO: Should lowercase and whatnot things here instead of copy...
        return {
            type: "orphan",
            tag: getTag("orphan", event),
            filter: copy(event)
        };
    }
    if (_event.address || _event.topics) {
        const event = _event;
        const filter = {
            topics: (event.topics || []).map((t)=>{
                if (t == null) {
                    return null;
                }
                if (Array.isArray(t)) {
                    return concisify(t.map((t)=>t.toLowerCase()));
                }
                return t.toLowerCase();
            })
        };
        if (event.address) {
            const addresses = [];
            const promises = [];
            const addAddress = (addr)=>{
                if ((0, index_js_6.isHexString)(addr)) {
                    addresses.push(addr);
                } else {
                    promises.push((async ()=>{
                        addresses.push(await (0, index_js_1.resolveAddress)(addr, provider));
                    })());
                }
            };
            if (Array.isArray(event.address)) {
                event.address.forEach(addAddress);
            } else {
                addAddress(event.address);
            }
            if (promises.length) {
                await Promise.all(promises);
            }
            filter.address = concisify(addresses.map((a)=>a.toLowerCase()));
        }
        return {
            filter,
            tag: getTag("event", filter),
            type: "event"
        };
    }
    (0, index_js_6.assertArgument)(false, "unknown ProviderEvent", "event", _event);
}
function getTime() {
    return new Date().getTime();
}
const defaultOptions = {
    cacheTimeout: 250,
    pollingInterval: 4000
};
var _subs = /*#__PURE__*/ new WeakMap(), _plugins = /*#__PURE__*/ new WeakMap(), // null=unpaused, true=paused+dropWhilePaused, false=paused
_pausedState = /*#__PURE__*/ new WeakMap(), _destroyed = /*#__PURE__*/ new WeakMap(), _networkPromise = /*#__PURE__*/ new WeakMap(), _anyNetwork = /*#__PURE__*/ new WeakMap(), _performCache = /*#__PURE__*/ new WeakMap(), // The most recent block number if running an event or -1 if no "block" event
_lastBlockNumber = /*#__PURE__*/ new WeakMap(), _nextTimer = /*#__PURE__*/ new WeakMap(), _timers = /*#__PURE__*/ new WeakMap(), _disableCcipRead = /*#__PURE__*/ new WeakMap(), _options = /*#__PURE__*/ new WeakMap(), _perform = /*#__PURE__*/ new WeakSet(), _call = /*#__PURE__*/ new WeakSet(), _checkNetwork = /*#__PURE__*/ new WeakSet(), _getAccountValue = /*#__PURE__*/ new WeakSet(), _getBlock = /*#__PURE__*/ new WeakSet(), _hasSub = /*#__PURE__*/ new WeakSet(), _getSub = /*#__PURE__*/ new WeakSet();
/**
 *  An **AbstractProvider** provides a base class for other sub-classes to
 *  implement the [[Provider]] API by normalizing input arguments and
 *  formatting output results as well as tracking events for consistent
 *  behaviour on an eventually-consistent network.
 */ class AbstractProvider {
    get pollingInterval() {
        return _class_private_field_get._(this, _options).pollingInterval;
    }
    /**
     *  Returns ``this``, to allow an **AbstractProvider** to implement
     *  the [[ContractRunner]] interface.
     */ get provider() {
        return this;
    }
    /**
     *  Returns all the registered plug-ins.
     */ get plugins() {
        return Array.from(_class_private_field_get._(this, _plugins).values());
    }
    /**
     *  Attach a new plug-in.
     */ attachPlugin(plugin) {
        if (_class_private_field_get._(this, _plugins).get(plugin.name)) {
            throw new Error("cannot replace existing plugin: ".concat(plugin.name, " "));
        }
        _class_private_field_get._(this, _plugins).set(plugin.name, plugin.connect(this));
        return this;
    }
    /**
     *  Get a plugin by name.
     */ getPlugin(name) {
        return _class_private_field_get._(this, _plugins).get(name) || null;
    }
    /**
     *  Prevent any CCIP-read operation, regardless of whether requested
     *  in a [[call]] using ``enableCcipRead``.
     */ get disableCcipRead() {
        return _class_private_field_get._(this, _disableCcipRead);
    }
    set disableCcipRead(value) {
        _class_private_field_set._(this, _disableCcipRead, !!value);
    }
    /**
     *  Resolves to the data for executing the CCIP-read operations.
     */ async ccipReadFetch(tx, calldata, urls) {
        if (this.disableCcipRead || urls.length === 0 || tx.to == null) {
            return null;
        }
        const sender = tx.to.toLowerCase();
        const data = calldata.toLowerCase();
        const errorMessages = [];
        for(let i = 0; i < urls.length; i++){
            const url = urls[i];
            // URL expansion
            const href = url.replace("{sender}", sender).replace("{data}", data);
            // If no {data} is present, use POST; otherwise GET
            //const json: string | null = (url.indexOf("{data}") >= 0) ? null: JSON.stringify({ data, sender });
            //const result = await fetchJson({ url: href, errorPassThrough: true }, json, (value, response) => {
            //    value.status = response.statusCode;
            //    return value;
            //});
            const request = new index_js_6.FetchRequest(href);
            if (url.indexOf("{data}") === -1) {
                request.body = {
                    data,
                    sender
                };
            }
            this.emit("debug", {
                action: "sendCcipReadFetchRequest",
                request,
                index: i,
                urls
            });
            let errorMessage = "unknown error";
            // Fetch the resource...
            let resp;
            try {
                resp = await request.send();
            } catch (error) {
                // ...low-level fetch error (missing host, bad SSL, etc.),
                // so try next URL
                errorMessages.push(error.message);
                this.emit("debug", {
                    action: "receiveCcipReadFetchError",
                    request,
                    result: {
                        error
                    }
                });
                continue;
            }
            try {
                const result = resp.bodyJson;
                if (result.data) {
                    this.emit("debug", {
                        action: "receiveCcipReadFetchResult",
                        request,
                        result
                    });
                    return result.data;
                }
                if (result.message) {
                    errorMessage = result.message;
                }
                this.emit("debug", {
                    action: "receiveCcipReadFetchError",
                    request,
                    result
                });
            } catch (error) {}
            // 4xx indicates the result is not present; stop
            (0, index_js_6.assert)(resp.statusCode < 400 || resp.statusCode >= 500, "response not found during CCIP fetch: ".concat(errorMessage), "OFFCHAIN_FAULT", {
                reason: "404_MISSING_RESOURCE",
                transaction: tx,
                info: {
                    url,
                    errorMessage
                }
            });
            // 5xx indicates server issue; try the next url
            errorMessages.push(errorMessage);
        }
        (0, index_js_6.assert)(false, "error encountered during CCIP fetch: ".concat(errorMessages.map((m)=>JSON.stringify(m)).join(", ")), "OFFCHAIN_FAULT", {
            reason: "500_SERVER_ERROR",
            transaction: tx,
            info: {
                urls,
                errorMessages
            }
        });
    }
    /**
     *  Provides the opportunity for a sub-class to wrap a block before
     *  returning it, to add additional properties or an alternate
     *  sub-class of [[Block]].
     */ _wrapBlock(value, network) {
        return new provider_js_1.Block((0, format_js_1.formatBlock)(value), this);
    }
    /**
     *  Provides the opportunity for a sub-class to wrap a log before
     *  returning it, to add additional properties or an alternate
     *  sub-class of [[Log]].
     */ _wrapLog(value, network) {
        return new provider_js_1.Log((0, format_js_1.formatLog)(value), this);
    }
    /**
     *  Provides the opportunity for a sub-class to wrap a transaction
     *  receipt before returning it, to add additional properties or an
     *  alternate sub-class of [[TransactionReceipt]].
     */ _wrapTransactionReceipt(value, network) {
        return new provider_js_1.TransactionReceipt((0, format_js_1.formatTransactionReceipt)(value), this);
    }
    /**
     *  Provides the opportunity for a sub-class to wrap a transaction
     *  response before returning it, to add additional properties or an
     *  alternate sub-class of [[TransactionResponse]].
     */ _wrapTransactionResponse(tx, network) {
        return new provider_js_1.TransactionResponse((0, format_js_1.formatTransactionResponse)(tx), this);
    }
    /**
     *  Resolves to the Network, forcing a network detection using whatever
     *  technique the sub-class requires.
     *
     *  Sub-classes **must** override this.
     */ _detectNetwork() {
        (0, index_js_6.assert)(false, "sub-classes must implement this", "UNSUPPORTED_OPERATION", {
            operation: "_detectNetwork"
        });
    }
    /**
     *  Sub-classes should use this to perform all built-in operations. All
     *  methods sanitizes and normalizes the values passed into this.
     *
     *  Sub-classes **must** override this.
     */ async _perform(req) {
        (0, index_js_6.assert)(false, "unsupported method: ".concat(req.method), "UNSUPPORTED_OPERATION", {
            operation: req.method,
            info: req
        });
    }
    // State
    async getBlockNumber() {
        const blockNumber = (0, index_js_6.getNumber)(await _class_private_method_get._(this, _perform, perform).call(this, {
            method: "getBlockNumber"
        }), "%response");
        if (_class_private_field_get._(this, _lastBlockNumber) >= 0) {
            _class_private_field_set._(this, _lastBlockNumber, blockNumber);
        }
        return blockNumber;
    }
    /**
     *  Returns or resolves to the address for %%address%%, resolving ENS
     *  names and [[Addressable]] objects and returning if already an
     *  address.
     */ _getAddress(address) {
        return (0, index_js_1.resolveAddress)(address, this);
    }
    /**
     *  Returns or resolves to a valid block tag for %%blockTag%%, resolving
     *  negative values and returning if already a valid block tag.
     */ _getBlockTag(blockTag) {
        if (blockTag == null) {
            return "latest";
        }
        switch(blockTag){
            case "earliest":
                return "0x0";
            case "finalized":
            case "latest":
            case "pending":
            case "safe":
                return blockTag;
        }
        if ((0, index_js_6.isHexString)(blockTag)) {
            if ((0, index_js_6.isHexString)(blockTag, 32)) {
                return blockTag;
            }
            return (0, index_js_6.toQuantity)(blockTag);
        }
        if (typeof blockTag === "bigint") {
            blockTag = (0, index_js_6.getNumber)(blockTag, "blockTag");
        }
        if (typeof blockTag === "number") {
            if (blockTag >= 0) {
                return (0, index_js_6.toQuantity)(blockTag);
            }
            if (_class_private_field_get._(this, _lastBlockNumber) >= 0) {
                return (0, index_js_6.toQuantity)(_class_private_field_get._(this, _lastBlockNumber) + blockTag);
            }
            return this.getBlockNumber().then((b)=>(0, index_js_6.toQuantity)(b + blockTag));
        }
        (0, index_js_6.assertArgument)(false, "invalid blockTag", "blockTag", blockTag);
    }
    /**
     *  Returns or resolves to a filter for %%filter%%, resolving any ENS
     *  names or [[Addressable]] object and returning if already a valid
     *  filter.
     */ _getFilter(filter) {
        // Create a canonical representation of the topics
        const topics = (filter.topics || []).map((t)=>{
            if (t == null) {
                return null;
            }
            if (Array.isArray(t)) {
                return concisify(t.map((t)=>t.toLowerCase()));
            }
            return t.toLowerCase();
        });
        const blockHash = "blockHash" in filter ? filter.blockHash : undefined;
        const resolve = (_address, fromBlock, toBlock)=>{
            let address = undefined;
            switch(_address.length){
                case 0:
                    break;
                case 1:
                    address = _address[0];
                    break;
                default:
                    _address.sort();
                    address = _address;
            }
            if (blockHash) {
                if (fromBlock != null || toBlock != null) {
                    throw new Error("invalid filter");
                }
            }
            const filter = {};
            if (address) {
                filter.address = address;
            }
            if (topics.length) {
                filter.topics = topics;
            }
            if (fromBlock) {
                filter.fromBlock = fromBlock;
            }
            if (toBlock) {
                filter.toBlock = toBlock;
            }
            if (blockHash) {
                filter.blockHash = blockHash;
            }
            return filter;
        };
        // Addresses could be async (ENS names or Addressables)
        let address = [];
        if (filter.address) {
            if (Array.isArray(filter.address)) {
                for (const addr of filter.address){
                    address.push(this._getAddress(addr));
                }
            } else {
                address.push(this._getAddress(filter.address));
            }
        }
        let fromBlock = undefined;
        if ("fromBlock" in filter) {
            fromBlock = this._getBlockTag(filter.fromBlock);
        }
        let toBlock = undefined;
        if ("toBlock" in filter) {
            toBlock = this._getBlockTag(filter.toBlock);
        }
        if (address.filter((a)=>typeof a !== "string").length || fromBlock != null && typeof fromBlock !== "string" || toBlock != null && typeof toBlock !== "string") {
            return Promise.all([
                Promise.all(address),
                fromBlock,
                toBlock
            ]).then((result)=>{
                return resolve(result[0], result[1], result[2]);
            });
        }
        return resolve(address, fromBlock, toBlock);
    }
    /**
     *  Returns or resolves to a transaction for %%request%%, resolving
     *  any ENS names or [[Addressable]] and returning if already a valid
     *  transaction.
     */ _getTransactionRequest(_request) {
        const request = (0, provider_js_1.copyRequest)(_request);
        const promises = [];
        [
            "to",
            "from"
        ].forEach((key)=>{
            if (request[key] == null) {
                return;
            }
            const addr = (0, index_js_1.resolveAddress)(request[key], this);
            if (isPromise(addr)) {
                promises.push(async function() {
                    request[key] = await addr;
                }());
            } else {
                request[key] = addr;
            }
        });
        if (request.blockTag != null) {
            const blockTag = this._getBlockTag(request.blockTag);
            if (isPromise(blockTag)) {
                promises.push(async function() {
                    request.blockTag = await blockTag;
                }());
            } else {
                request.blockTag = blockTag;
            }
        }
        if (promises.length) {
            return async function() {
                await Promise.all(promises);
                return request;
            }();
        }
        return request;
    }
    async getNetwork() {
        // No explicit network was set and this is our first time
        if (_class_private_field_get._(this, _networkPromise) == null) {
            // Detect the current network (shared with all calls)
            const detectNetwork = (async ()=>{
                try {
                    const network = await this._detectNetwork();
                    this.emit("network", network, null);
                    return network;
                } catch (error) {
                    if (_class_private_field_get._(this, _networkPromise) === detectNetwork) {
                        _class_private_field_set._(this, _networkPromise, null);
                    }
                    throw error;
                }
            })();
            _class_private_field_set._(this, _networkPromise, detectNetwork);
            return (await detectNetwork).clone();
        }
        const networkPromise = _class_private_field_get._(this, _networkPromise);
        const [expected, actual] = await Promise.all([
            networkPromise,
            this._detectNetwork() // The actual connected network
        ]);
        if (expected.chainId !== actual.chainId) {
            if (_class_private_field_get._(this, _anyNetwork)) {
                // The "any" network can change, so notify listeners
                this.emit("network", actual, expected);
                // Update the network if something else hasn't already changed it
                if (_class_private_field_get._(this, _networkPromise) === networkPromise) {
                    _class_private_field_set._(this, _networkPromise, Promise.resolve(actual));
                }
            } else {
                // Otherwise, we do not allow changes to the underlying network
                (0, index_js_6.assert)(false, "network changed: ".concat(expected.chainId, " => ").concat(actual.chainId, " "), "NETWORK_ERROR", {
                    event: "changed"
                });
            }
        }
        return expected.clone();
    }
    async getFeeData() {
        const network = await this.getNetwork();
        const getFeeDataFunc = async ()=>{
            const { _block, gasPrice, priorityFee } = await (0, index_js_6.resolveProperties)({
                _block: _class_private_method_get._(this, _getBlock, getBlock).call(this, "latest", false),
                gasPrice: (async ()=>{
                    try {
                        const value = await _class_private_method_get._(this, _perform, perform).call(this, {
                            method: "getGasPrice"
                        });
                        return (0, index_js_6.getBigInt)(value, "%response");
                    } catch (error) {}
                    return null;
                })(),
                priorityFee: (async ()=>{
                    try {
                        const value = await _class_private_method_get._(this, _perform, perform).call(this, {
                            method: "getPriorityFee"
                        });
                        return (0, index_js_6.getBigInt)(value, "%response");
                    } catch (error) {}
                    return null;
                })()
            });
            let maxFeePerGas = null;
            let maxPriorityFeePerGas = null;
            // These are the recommended EIP-1559 heuristics for fee data
            const block = this._wrapBlock(_block, network);
            if (block && block.baseFeePerGas) {
                maxPriorityFeePerGas = priorityFee != null ? priorityFee : BigInt("1000000000");
                maxFeePerGas = block.baseFeePerGas * BN_2 + maxPriorityFeePerGas;
            }
            return new provider_js_1.FeeData(gasPrice, maxFeePerGas, maxPriorityFeePerGas);
        };
        // Check for a FeeDataNetWorkPlugin
        const plugin = network.getPlugin("org.ethers.plugins.network.FetchUrlFeeDataPlugin");
        if (plugin) {
            const req = new index_js_6.FetchRequest(plugin.url);
            const feeData = await plugin.processFunc(getFeeDataFunc, this, req);
            return new provider_js_1.FeeData(feeData.gasPrice, feeData.maxFeePerGas, feeData.maxPriorityFeePerGas);
        }
        return await getFeeDataFunc();
    }
    async estimateGas(_tx) {
        let tx = this._getTransactionRequest(_tx);
        if (isPromise(tx)) {
            tx = await tx;
        }
        return (0, index_js_6.getBigInt)(await _class_private_method_get._(this, _perform, perform).call(this, {
            method: "estimateGas",
            transaction: tx
        }), "%response");
    }
    async call(_tx) {
        const { tx, blockTag } = await (0, index_js_6.resolveProperties)({
            tx: this._getTransactionRequest(_tx),
            blockTag: this._getBlockTag(_tx.blockTag)
        });
        return await _class_private_method_get._(this, _checkNetwork, checkNetwork).call(this, _class_private_method_get._(this, _call, call).call(this, tx, blockTag, _tx.enableCcipRead ? 0 : -1));
    }
    async getBalance(address, blockTag) {
        return (0, index_js_6.getBigInt)(await _class_private_method_get._(this, _getAccountValue, getAccountValue).call(this, {
            method: "getBalance"
        }, address, blockTag), "%response");
    }
    async getTransactionCount(address, blockTag) {
        return (0, index_js_6.getNumber)(await _class_private_method_get._(this, _getAccountValue, getAccountValue).call(this, {
            method: "getTransactionCount"
        }, address, blockTag), "%response");
    }
    async getCode(address, blockTag) {
        return (0, index_js_6.hexlify)(await _class_private_method_get._(this, _getAccountValue, getAccountValue).call(this, {
            method: "getCode"
        }, address, blockTag));
    }
    async getStorage(address, _position, blockTag) {
        const position = (0, index_js_6.getBigInt)(_position, "position");
        return (0, index_js_6.hexlify)(await _class_private_method_get._(this, _getAccountValue, getAccountValue).call(this, {
            method: "getStorage",
            position
        }, address, blockTag));
    }
    // Write
    async broadcastTransaction(signedTx) {
        const { blockNumber, hash, network } = await (0, index_js_6.resolveProperties)({
            blockNumber: this.getBlockNumber(),
            hash: this._perform({
                method: "broadcastTransaction",
                signedTransaction: signedTx
            }),
            network: this.getNetwork()
        });
        const tx = index_js_5.Transaction.from(signedTx);
        if (tx.hash !== hash) {
            throw new Error("@TODO: the returned hash did not match");
        }
        return this._wrapTransactionResponse(tx, network).replaceableTransaction(blockNumber);
    }
    // Queries
    async getBlock(block, prefetchTxs) {
        const { network, params } = await (0, index_js_6.resolveProperties)({
            network: this.getNetwork(),
            params: _class_private_method_get._(this, _getBlock, getBlock).call(this, block, !!prefetchTxs)
        });
        if (params == null) {
            return null;
        }
        return this._wrapBlock(params, network);
    }
    async getTransaction(hash) {
        const { network, params } = await (0, index_js_6.resolveProperties)({
            network: this.getNetwork(),
            params: _class_private_method_get._(this, _perform, perform).call(this, {
                method: "getTransaction",
                hash
            })
        });
        if (params == null) {
            return null;
        }
        return this._wrapTransactionResponse(params, network);
    }
    async getTransactionReceipt(hash) {
        const { network, params } = await (0, index_js_6.resolveProperties)({
            network: this.getNetwork(),
            params: _class_private_method_get._(this, _perform, perform).call(this, {
                method: "getTransactionReceipt",
                hash
            })
        });
        if (params == null) {
            return null;
        }
        // Some backends did not backfill the effectiveGasPrice into old transactions
        // in the receipt, so we look it up manually and inject it.
        if (params.gasPrice == null && params.effectiveGasPrice == null) {
            const tx = await _class_private_method_get._(this, _perform, perform).call(this, {
                method: "getTransaction",
                hash
            });
            if (tx == null) {
                throw new Error("report this; could not find tx or effectiveGasPrice");
            }
            params.effectiveGasPrice = tx.gasPrice;
        }
        return this._wrapTransactionReceipt(params, network);
    }
    async getTransactionResult(hash) {
        const { result } = await (0, index_js_6.resolveProperties)({
            network: this.getNetwork(),
            result: _class_private_method_get._(this, _perform, perform).call(this, {
                method: "getTransactionResult",
                hash
            })
        });
        if (result == null) {
            return null;
        }
        return (0, index_js_6.hexlify)(result);
    }
    // Bloom-filter Queries
    async getLogs(_filter) {
        let filter = this._getFilter(_filter);
        if (isPromise(filter)) {
            filter = await filter;
        }
        const { network, params } = await (0, index_js_6.resolveProperties)({
            network: this.getNetwork(),
            params: _class_private_method_get._(this, _perform, perform).call(this, {
                method: "getLogs",
                filter
            })
        });
        return params.map((p)=>this._wrapLog(p, network));
    }
    // ENS
    _getProvider(chainId) {
        (0, index_js_6.assert)(false, "provider cannot connect to target network", "UNSUPPORTED_OPERATION", {
            operation: "_getProvider()"
        });
    }
    async getResolver(name) {
        return await ens_resolver_js_1.EnsResolver.fromName(this, name);
    }
    async getAvatar(name) {
        const resolver = await this.getResolver(name);
        if (resolver) {
            return await resolver.getAvatar();
        }
        return null;
    }
    async resolveName(name) {
        const resolver = await this.getResolver(name);
        if (resolver) {
            return await resolver.getAddress();
        }
        return null;
    }
    async lookupAddress(address) {
        address = (0, index_js_1.getAddress)(address);
        const node = (0, index_js_4.namehash)(address.substring(2).toLowerCase() + ".addr.reverse");
        try {
            const ensAddr = await ens_resolver_js_1.EnsResolver.getEnsAddress(this);
            const ensContract = new index_js_3.Contract(ensAddr, [
                "function resolver(bytes32) view returns (address)"
            ], this);
            const resolver = await ensContract.resolver(node);
            if (resolver == null || resolver === index_js_2.ZeroAddress) {
                return null;
            }
            const resolverContract = new index_js_3.Contract(resolver, [
                "function name(bytes32) view returns (string)"
            ], this);
            const name = await resolverContract.name(node);
            // Failed forward resolution
            const check = await this.resolveName(name);
            if (check !== address) {
                return null;
            }
            return name;
        } catch (error) {
            // No data was returned from the resolver
            if ((0, index_js_6.isError)(error, "BAD_DATA") && error.value === "0x") {
                return null;
            }
            // Something reerted
            if ((0, index_js_6.isError)(error, "CALL_EXCEPTION")) {
                return null;
            }
            throw error;
        }
        return null;
    }
    async waitForTransaction(hash, _confirms, timeout) {
        const confirms = _confirms != null ? _confirms : 1;
        if (confirms === 0) {
            return this.getTransactionReceipt(hash);
        }
        return new Promise(async (resolve, reject)=>{
            let timer = null;
            const listener = async (blockNumber)=>{
                try {
                    const receipt = await this.getTransactionReceipt(hash);
                    if (receipt != null) {
                        if (blockNumber - receipt.blockNumber + 1 >= confirms) {
                            resolve(receipt);
                            //this.off("block", listener);
                            if (timer) {
                                clearTimeout(timer);
                                timer = null;
                            }
                            return;
                        }
                    }
                } catch (error) {
                    console.log("EEE", error);
                }
                this.once("block", listener);
            };
            if (timeout != null) {
                timer = setTimeout(()=>{
                    if (timer == null) {
                        return;
                    }
                    timer = null;
                    this.off("block", listener);
                    reject((0, index_js_6.makeError)("timeout", "TIMEOUT", {
                        reason: "timeout"
                    }));
                }, timeout);
            }
            listener(await this.getBlockNumber());
        });
    }
    async waitForBlock(blockTag) {
        (0, index_js_6.assert)(false, "not implemented yet", "NOT_IMPLEMENTED", {
            operation: "waitForBlock"
        });
    }
    /**
     *  Clear a timer created using the [[_setTimeout]] method.
     */ _clearTimeout(timerId) {
        const timer = _class_private_field_get._(this, _timers).get(timerId);
        if (!timer) {
            return;
        }
        if (timer.timer) {
            clearTimeout(timer.timer);
        }
        _class_private_field_get._(this, _timers).delete(timerId);
    }
    /**
     *  Create a timer that will execute %%func%% after at least %%timeout%%
     *  (in ms). If %%timeout%% is unspecified, then %%func%% will execute
     *  in the next event loop.
     *
     *  [Pausing](AbstractProvider-paused) the provider will pause any
     *  associated timers.
     */ _setTimeout(_func, timeout) {
        if (timeout == null) {
            timeout = 0;
        }
        const timerId = _class_private_field_update._(this, _nextTimer).value++;
        const func = ()=>{
            _class_private_field_get._(this, _timers).delete(timerId);
            _func();
        };
        if (this.paused) {
            _class_private_field_get._(this, _timers).set(timerId, {
                timer: null,
                func,
                time: timeout
            });
        } else {
            const timer = setTimeout(func, timeout);
            _class_private_field_get._(this, _timers).set(timerId, {
                timer,
                func,
                time: getTime()
            });
        }
        return timerId;
    }
    /**
     *  Perform %%func%% on each subscriber.
     */ _forEachSubscriber(func) {
        for (const sub of _class_private_field_get._(this, _subs).values()){
            func(sub.subscriber);
        }
    }
    /**
     *  Sub-classes may override this to customize subscription
     *  implementations.
     */ _getSubscriber(sub) {
        switch(sub.type){
            case "debug":
            case "error":
            case "network":
                return new UnmanagedSubscriber(sub.type);
            case "block":
                {
                    const subscriber = new subscriber_polling_js_1.PollingBlockSubscriber(this);
                    subscriber.pollingInterval = this.pollingInterval;
                    return subscriber;
                }
            case "safe":
            case "finalized":
                return new subscriber_polling_js_1.PollingBlockTagSubscriber(this, sub.type);
            case "event":
                return new subscriber_polling_js_1.PollingEventSubscriber(this, sub.filter);
            case "transaction":
                return new subscriber_polling_js_1.PollingTransactionSubscriber(this, sub.hash);
            case "orphan":
                return new subscriber_polling_js_1.PollingOrphanSubscriber(this, sub.filter);
        }
        throw new Error("unsupported event: ".concat(sub.type));
    }
    /**
     *  If a [[Subscriber]] fails and needs to replace itself, this
     *  method may be used.
     *
     *  For example, this is used for providers when using the
     *  ``eth_getFilterChanges`` method, which can return null if state
     *  filters are not supported by the backend, allowing the Subscriber
     *  to swap in a [[PollingEventSubscriber]].
     */ _recoverSubscriber(oldSub, newSub) {
        for (const sub of _class_private_field_get._(this, _subs).values()){
            if (sub.subscriber === oldSub) {
                if (sub.started) {
                    sub.subscriber.stop();
                }
                sub.subscriber = newSub;
                if (sub.started) {
                    newSub.start();
                }
                if (_class_private_field_get._(this, _pausedState) != null) {
                    newSub.pause(_class_private_field_get._(this, _pausedState));
                }
                break;
            }
        }
    }
    async on(event, listener) {
        const sub = await _class_private_method_get._(this, _getSub, getSub).call(this, event);
        sub.listeners.push({
            listener,
            once: false
        });
        if (!sub.started) {
            sub.subscriber.start();
            sub.started = true;
            if (_class_private_field_get._(this, _pausedState) != null) {
                sub.subscriber.pause(_class_private_field_get._(this, _pausedState));
            }
        }
        return this;
    }
    async once(event, listener) {
        const sub = await _class_private_method_get._(this, _getSub, getSub).call(this, event);
        sub.listeners.push({
            listener,
            once: true
        });
        if (!sub.started) {
            sub.subscriber.start();
            sub.started = true;
            if (_class_private_field_get._(this, _pausedState) != null) {
                sub.subscriber.pause(_class_private_field_get._(this, _pausedState));
            }
        }
        return this;
    }
    async emit(event) {
        for(var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++){
            args[_key - 1] = arguments[_key];
        }
        const sub = await _class_private_method_get._(this, _hasSub, hasSub).call(this, event, args);
        // If there is not subscription or if a recent emit removed
        // the last of them (which also deleted the sub) do nothing
        if (!sub || sub.listeners.length === 0) {
            return false;
        }
        ;
        const count = sub.listeners.length;
        sub.listeners = sub.listeners.filter((param)=>{
            let { listener, once } = param;
            const payload = new index_js_6.EventPayload(this, once ? null : listener, event);
            try {
                listener.call(this, ...args, payload);
            } catch (error) {}
            return !once;
        });
        if (sub.listeners.length === 0) {
            if (sub.started) {
                sub.subscriber.stop();
            }
            _class_private_field_get._(this, _subs).delete(sub.tag);
        }
        return count > 0;
    }
    async listenerCount(event) {
        if (event) {
            const sub = await _class_private_method_get._(this, _hasSub, hasSub).call(this, event);
            if (!sub) {
                return 0;
            }
            return sub.listeners.length;
        }
        let total = 0;
        for (const { listeners } of _class_private_field_get._(this, _subs).values()){
            total += listeners.length;
        }
        return total;
    }
    async listeners(event) {
        if (event) {
            const sub = await _class_private_method_get._(this, _hasSub, hasSub).call(this, event);
            if (!sub) {
                return [];
            }
            return sub.listeners.map((param)=>{
                let { listener } = param;
                return listener;
            });
        }
        let result = [];
        for (const { listeners } of _class_private_field_get._(this, _subs).values()){
            result = result.concat(listeners.map((param)=>{
                let { listener } = param;
                return listener;
            }));
        }
        return result;
    }
    async off(event, listener) {
        const sub = await _class_private_method_get._(this, _hasSub, hasSub).call(this, event);
        if (!sub) {
            return this;
        }
        if (listener) {
            const index = sub.listeners.map((param)=>{
                let { listener } = param;
                return listener;
            }).indexOf(listener);
            if (index >= 0) {
                sub.listeners.splice(index, 1);
            }
        }
        if (!listener || sub.listeners.length === 0) {
            if (sub.started) {
                sub.subscriber.stop();
            }
            _class_private_field_get._(this, _subs).delete(sub.tag);
        }
        return this;
    }
    async removeAllListeners(event) {
        if (event) {
            const { tag, started, subscriber } = await _class_private_method_get._(this, _getSub, getSub).call(this, event);
            if (started) {
                subscriber.stop();
            }
            _class_private_field_get._(this, _subs).delete(tag);
        } else {
            for (const [tag, { started, subscriber }] of _class_private_field_get._(this, _subs)){
                if (started) {
                    subscriber.stop();
                }
                _class_private_field_get._(this, _subs).delete(tag);
            }
        }
        return this;
    }
    // Alias for "on"
    async addListener(event, listener) {
        return await this.on(event, listener);
    }
    // Alias for "off"
    async removeListener(event, listener) {
        return this.off(event, listener);
    }
    /**
     *  If this provider has been destroyed using the [[destroy]] method.
     *
     *  Once destroyed, all resources are reclaimed, internal event loops
     *  and timers are cleaned up and no further requests may be sent to
     *  the provider.
     */ get destroyed() {
        return _class_private_field_get._(this, _destroyed);
    }
    /**
     *  Sub-classes may use this to shutdown any sockets or release their
     *  resources and reject any pending requests.
     *
     *  Sub-classes **must** call ``super.destroy()``.
     */ destroy() {
        // Stop all listeners
        this.removeAllListeners();
        // Shut down all tiemrs
        for (const timerId of _class_private_field_get._(this, _timers).keys()){
            this._clearTimeout(timerId);
        }
        _class_private_field_set._(this, _destroyed, true);
    }
    /**
     *  Whether the provider is currently paused.
     *
     *  A paused provider will not emit any events, and generally should
     *  not make any requests to the network, but that is up to sub-classes
     *  to manage.
     *
     *  Setting ``paused = true`` is identical to calling ``.pause(false)``,
     *  which will buffer any events that occur while paused until the
     *  provider is unpaused.
     */ get paused() {
        return _class_private_field_get._(this, _pausedState) != null;
    }
    set paused(pause) {
        if (!!pause === this.paused) {
            return;
        }
        if (this.paused) {
            this.resume();
        } else {
            this.pause(false);
        }
    }
    /**
     *  Pause the provider. If %%dropWhilePaused%%, any events that occur
     *  while paused are dropped, otherwise all events will be emitted once
     *  the provider is unpaused.
     */ pause(dropWhilePaused) {
        _class_private_field_set._(this, _lastBlockNumber, -1);
        if (_class_private_field_get._(this, _pausedState) != null) {
            if (_class_private_field_get._(this, _pausedState) == !!dropWhilePaused) {
                return;
            }
            (0, index_js_6.assert)(false, "cannot change pause type; resume first", "UNSUPPORTED_OPERATION", {
                operation: "pause"
            });
        }
        this._forEachSubscriber((s)=>s.pause(dropWhilePaused));
        _class_private_field_set._(this, _pausedState, !!dropWhilePaused);
        for (const timer of _class_private_field_get._(this, _timers).values()){
            // Clear the timer
            if (timer.timer) {
                clearTimeout(timer.timer);
            }
            // Remaining time needed for when we become unpaused
            timer.time = getTime() - timer.time;
        }
    }
    /**
     *  Resume the provider.
     */ resume() {
        if (_class_private_field_get._(this, _pausedState) == null) {
            return;
        }
        this._forEachSubscriber((s)=>s.resume());
        _class_private_field_set._(this, _pausedState, null);
        for (const timer of _class_private_field_get._(this, _timers).values()){
            // Remaining time when we were paused
            let timeout = timer.time;
            if (timeout < 0) {
                timeout = 0;
            }
            // Start time (in cause paused, so we con compute remaininf time)
            timer.time = getTime();
            // Start the timer
            setTimeout(timer.func, timeout);
        }
    }
    /**
     *  Create a new **AbstractProvider** connected to %%network%%, or
     *  use the various network detection capabilities to discover the
     *  [[Network]] if necessary.
     */ constructor(_network, options){
        // Shares multiple identical requests made during the same 250ms
        _class_private_method_init._(this, _perform);
        _class_private_method_init._(this, _call);
        _class_private_method_init._(this, _checkNetwork);
        // Account
        _class_private_method_init._(this, _getAccountValue);
        _class_private_method_init._(this, _getBlock);
        _class_private_method_init._(this, _hasSub);
        _class_private_method_init._(this, _getSub);
        _class_private_field_init._(this, _subs, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _plugins, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _pausedState, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _destroyed, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _networkPromise, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _anyNetwork, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _performCache, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _lastBlockNumber, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _nextTimer, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _timers, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _disableCcipRead, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _options, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _options, Object.assign({}, defaultOptions, options || {}));
        if (_network === "any") {
            _class_private_field_set._(this, _anyNetwork, true);
            _class_private_field_set._(this, _networkPromise, null);
        } else if (_network) {
            const network = network_js_1.Network.from(_network);
            _class_private_field_set._(this, _anyNetwork, false);
            _class_private_field_set._(this, _networkPromise, Promise.resolve(network));
            setTimeout(()=>{
                this.emit("network", network, null);
            }, 0);
        } else {
            _class_private_field_set._(this, _anyNetwork, false);
            _class_private_field_set._(this, _networkPromise, null);
        }
        _class_private_field_set._(this, _lastBlockNumber, -1);
        _class_private_field_set._(this, _performCache, new Map());
        _class_private_field_set._(this, _subs, new Map());
        _class_private_field_set._(this, _plugins, new Map());
        _class_private_field_set._(this, _pausedState, null);
        _class_private_field_set._(this, _destroyed, false);
        _class_private_field_set._(this, _nextTimer, 1);
        _class_private_field_set._(this, _timers, new Map());
        _class_private_field_set._(this, _disableCcipRead, false);
    }
}
async function perform(req) {
    const timeout = _class_private_field_get._(this, _options).cacheTimeout;
    // Caching disabled
    if (timeout < 0) {
        return await this._perform(req);
    }
    // Create a tag
    const tag = getTag(req.method, req);
    let perform = _class_private_field_get._(this, _performCache).get(tag);
    if (!perform) {
        perform = this._perform(req);
        _class_private_field_get._(this, _performCache).set(tag, perform);
        setTimeout(()=>{
            if (_class_private_field_get._(this, _performCache).get(tag) === perform) {
                _class_private_field_get._(this, _performCache).delete(tag);
            }
        }, timeout);
    }
    return await perform;
}
async function call(tx, blockTag, attempt) {
    (0, index_js_6.assert)(attempt < MAX_CCIP_REDIRECTS, "CCIP read exceeded maximum redirections", "OFFCHAIN_FAULT", {
        reason: "TOO_MANY_REDIRECTS",
        transaction: Object.assign({}, tx, {
            blockTag,
            enableCcipRead: true
        })
    });
    // This came in as a PerformActionTransaction, so to/from are safe; we can cast
    const transaction = (0, provider_js_1.copyRequest)(tx);
    try {
        return (0, index_js_6.hexlify)(await this._perform({
            method: "call",
            transaction,
            blockTag
        }));
    } catch (error) {
        // CCIP Read OffchainLookup
        if (!this.disableCcipRead && (0, index_js_6.isCallException)(error) && error.data && attempt >= 0 && blockTag === "latest" && transaction.to != null && (0, index_js_6.dataSlice)(error.data, 0, 4) === "0x556f1830") {
            const data = error.data;
            const txSender = await (0, index_js_1.resolveAddress)(transaction.to, this);
            // Parse the CCIP Read Arguments
            let ccipArgs;
            try {
                ccipArgs = parseOffchainLookup((0, index_js_6.dataSlice)(error.data, 4));
            } catch (error) {
                (0, index_js_6.assert)(false, error.message, "OFFCHAIN_FAULT", {
                    reason: "BAD_DATA",
                    transaction,
                    info: {
                        data
                    }
                });
            }
            // Check the sender of the OffchainLookup matches the transaction
            (0, index_js_6.assert)(ccipArgs.sender.toLowerCase() === txSender.toLowerCase(), "CCIP Read sender mismatch", "CALL_EXCEPTION", {
                action: "call",
                data,
                reason: "OffchainLookup",
                transaction: transaction,
                invocation: null,
                revert: {
                    signature: "OffchainLookup(address,string[],bytes,bytes4,bytes)",
                    name: "OffchainLookup",
                    args: ccipArgs.errorArgs
                }
            });
            const ccipResult = await this.ccipReadFetch(transaction, ccipArgs.calldata, ccipArgs.urls);
            (0, index_js_6.assert)(ccipResult != null, "CCIP Read failed to fetch data", "OFFCHAIN_FAULT", {
                reason: "FETCH_FAILED",
                transaction,
                info: {
                    data: error.data,
                    errorArgs: ccipArgs.errorArgs
                }
            });
            const tx = {
                to: txSender,
                data: (0, index_js_6.concat)([
                    ccipArgs.selector,
                    encodeBytes([
                        ccipResult,
                        ccipArgs.extraData
                    ])
                ])
            };
            this.emit("debug", {
                action: "sendCcipReadCall",
                transaction: tx
            });
            try {
                const result = await _class_private_method_get._(this, _call, call).call(this, tx, blockTag, attempt + 1);
                this.emit("debug", {
                    action: "receiveCcipReadCallResult",
                    transaction: Object.assign({}, tx),
                    result
                });
                return result;
            } catch (error) {
                this.emit("debug", {
                    action: "receiveCcipReadCallError",
                    transaction: Object.assign({}, tx),
                    error
                });
                throw error;
            }
        }
        throw error;
    }
}
async function checkNetwork(promise) {
    const { value } = await (0, index_js_6.resolveProperties)({
        network: this.getNetwork(),
        value: promise
    });
    return value;
}
async function getAccountValue(request, _address, _blockTag) {
    let address = this._getAddress(_address);
    let blockTag = this._getBlockTag(_blockTag);
    if (typeof address !== "string" || typeof blockTag !== "string") {
        [address, blockTag] = await Promise.all([
            address,
            blockTag
        ]);
    }
    return await _class_private_method_get._(this, _checkNetwork, checkNetwork).call(this, _class_private_method_get._(this, _perform, perform).call(this, Object.assign(request, {
        address,
        blockTag
    })));
}
async function getBlock(block, includeTransactions) {
    // @TODO: Add CustomBlockPlugin check
    if ((0, index_js_6.isHexString)(block, 32)) {
        return await _class_private_method_get._(this, _perform, perform).call(this, {
            method: "getBlock",
            blockHash: block,
            includeTransactions
        });
    }
    let blockTag = this._getBlockTag(block);
    if (typeof blockTag !== "string") {
        blockTag = await blockTag;
    }
    return await _class_private_method_get._(this, _perform, perform).call(this, {
        method: "getBlock",
        blockTag,
        includeTransactions
    });
}
async function hasSub(event, emitArgs) {
    let sub = await getSubscription(event, this);
    // This is a log that is removing an existing log; we actually want
    // to emit an orphan event for the removed log
    if (sub.type === "event" && emitArgs && emitArgs.length > 0 && emitArgs[0].removed === true) {
        sub = await getSubscription({
            orphan: "drop-log",
            log: emitArgs[0]
        }, this);
    }
    return _class_private_field_get._(this, _subs).get(sub.tag) || null;
}
async function getSub(event) {
    const subscription = await getSubscription(event, this);
    // Prevent tampering with our tag in any subclass' _getSubscriber
    const tag = subscription.tag;
    let sub = _class_private_field_get._(this, _subs).get(tag);
    if (!sub) {
        const subscriber = this._getSubscriber(subscription);
        const addressableMap = new WeakMap();
        const nameMap = new Map();
        sub = {
            subscriber,
            tag,
            addressableMap,
            nameMap,
            started: false,
            listeners: []
        };
        _class_private_field_get._(this, _subs).set(tag, sub);
    }
    return sub;
}
exports.AbstractProvider = AbstractProvider;
function _parseString(result, start) {
    try {
        const bytes = _parseBytes(result, start);
        if (bytes) {
            return (0, index_js_6.toUtf8String)(bytes);
        }
    } catch (error) {}
    return null;
}
function _parseBytes(result, start) {
    if (result === "0x") {
        return null;
    }
    try {
        const offset = (0, index_js_6.getNumber)((0, index_js_6.dataSlice)(result, start, start + 32));
        const length = (0, index_js_6.getNumber)((0, index_js_6.dataSlice)(result, offset, offset + 32));
        return (0, index_js_6.dataSlice)(result, offset + 32, offset + 32 + length);
    } catch (error) {}
    return null;
}
function numPad(value) {
    const result = (0, index_js_6.toBeArray)(value);
    if (result.length > 32) {
        throw new Error("internal; should not happen");
    }
    const padded = new Uint8Array(32);
    padded.set(result, 32 - result.length);
    return padded;
}
function bytesPad(value) {
    if (value.length % 32 === 0) {
        return value;
    }
    const result = new Uint8Array(Math.ceil(value.length / 32) * 32);
    result.set(value);
    return result;
}
const empty = new Uint8Array([]);
// ABI Encodes a series of (bytes, bytes, ...)
function encodeBytes(datas) {
    const result = [];
    let byteCount = 0;
    // Add place-holders for pointers as we add items
    for(let i = 0; i < datas.length; i++){
        result.push(empty);
        byteCount += 32;
    }
    for(let i = 0; i < datas.length; i++){
        const data = (0, index_js_6.getBytes)(datas[i]);
        // Update the bytes offset
        result[i] = numPad(byteCount);
        // The length and padded value of data
        result.push(numPad(data.length));
        result.push(bytesPad(data));
        byteCount += 32 + Math.ceil(data.length / 32) * 32;
    }
    return (0, index_js_6.concat)(result);
}
const zeros = "0x0000000000000000000000000000000000000000000000000000000000000000";
function parseOffchainLookup(data) {
    const result = {
        sender: "",
        urls: [],
        calldata: "",
        selector: "",
        extraData: "",
        errorArgs: []
    };
    (0, index_js_6.assert)((0, index_js_6.dataLength)(data) >= 5 * 32, "insufficient OffchainLookup data", "OFFCHAIN_FAULT", {
        reason: "insufficient OffchainLookup data"
    });
    const sender = (0, index_js_6.dataSlice)(data, 0, 32);
    (0, index_js_6.assert)((0, index_js_6.dataSlice)(sender, 0, 12) === (0, index_js_6.dataSlice)(zeros, 0, 12), "corrupt OffchainLookup sender", "OFFCHAIN_FAULT", {
        reason: "corrupt OffchainLookup sender"
    });
    result.sender = (0, index_js_6.dataSlice)(sender, 12);
    // Read the URLs from the response
    try {
        const urls = [];
        const urlsOffset = (0, index_js_6.getNumber)((0, index_js_6.dataSlice)(data, 32, 64));
        const urlsLength = (0, index_js_6.getNumber)((0, index_js_6.dataSlice)(data, urlsOffset, urlsOffset + 32));
        const urlsData = (0, index_js_6.dataSlice)(data, urlsOffset + 32);
        for(let u = 0; u < urlsLength; u++){
            const url = _parseString(urlsData, u * 32);
            if (url == null) {
                throw new Error("abort");
            }
            urls.push(url);
        }
        result.urls = urls;
    } catch (error) {
        (0, index_js_6.assert)(false, "corrupt OffchainLookup urls", "OFFCHAIN_FAULT", {
            reason: "corrupt OffchainLookup urls"
        });
    }
    // Get the CCIP calldata to forward
    try {
        const calldata = _parseBytes(data, 64);
        if (calldata == null) {
            throw new Error("abort");
        }
        result.calldata = calldata;
    } catch (error) {
        (0, index_js_6.assert)(false, "corrupt OffchainLookup calldata", "OFFCHAIN_FAULT", {
            reason: "corrupt OffchainLookup calldata"
        });
    }
    // Get the callbackSelector (bytes4)
    (0, index_js_6.assert)((0, index_js_6.dataSlice)(data, 100, 128) === (0, index_js_6.dataSlice)(zeros, 0, 28), "corrupt OffchainLookup callbaackSelector", "OFFCHAIN_FAULT", {
        reason: "corrupt OffchainLookup callbaackSelector"
    });
    result.selector = (0, index_js_6.dataSlice)(data, 96, 100);
    // Get the extra data to send back to the contract as context
    try {
        const extraData = _parseBytes(data, 128);
        if (extraData == null) {
            throw new Error("abort");
        }
        result.extraData = extraData;
    } catch (error) {
        (0, index_js_6.assert)(false, "corrupt OffchainLookup extraData", "OFFCHAIN_FAULT", {
            reason: "corrupt OffchainLookup extraData"
        });
    }
    result.errorArgs = "sender,urls,calldata,selector,extraData".split(/,/).map((k)=>result[k]);
    return result;
} //# sourceMappingURL=abstract-provider.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-signer.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.VoidSigner = exports.AbstractSigner = void 0;
/**
 *  Generally the [[Wallet]] and [[JsonRpcSigner]] and their sub-classes
 *  are sufficent for most developers, but this is provided to
 *  fascilitate more complex Signers.
 *
 *  @_section: api/providers/abstract-signer: Subclassing Signer [abstract-signer]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider.js [app-client] (ecmascript)");
function checkProvider(signer, operation) {
    if (signer.provider) {
        return signer.provider;
    }
    (0, index_js_3.assert)(false, "missing provider", "UNSUPPORTED_OPERATION", {
        operation
    });
}
async function populate(signer, tx) {
    let pop = (0, provider_js_1.copyRequest)(tx);
    if (pop.to != null) {
        pop.to = (0, index_js_1.resolveAddress)(pop.to, signer);
    }
    if (pop.from != null) {
        const from = pop.from;
        pop.from = Promise.all([
            signer.getAddress(),
            (0, index_js_1.resolveAddress)(from, signer)
        ]).then((param)=>{
            let [address, from] = param;
            (0, index_js_3.assertArgument)(address.toLowerCase() === from.toLowerCase(), "transaction from mismatch", "tx.from", from);
            return address;
        });
    } else {
        pop.from = signer.getAddress();
    }
    return await (0, index_js_3.resolveProperties)(pop);
}
/**
 *  An **AbstractSigner** includes most of teh functionality required
 *  to get a [[Signer]] working as expected, but requires a few
 *  Signer-specific methods be overridden.
 *
 */ class AbstractSigner {
    async getNonce(blockTag) {
        return checkProvider(this, "getTransactionCount").getTransactionCount(await this.getAddress(), blockTag);
    }
    async populateCall(tx) {
        const pop = await populate(this, tx);
        return pop;
    }
    async populateTransaction(tx) {
        const provider = checkProvider(this, "populateTransaction");
        const pop = await populate(this, tx);
        if (pop.nonce == null) {
            pop.nonce = await this.getNonce("pending");
        }
        if (pop.gasLimit == null) {
            pop.gasLimit = await this.estimateGas(pop);
        }
        // Populate the chain ID
        const network = await this.provider.getNetwork();
        if (pop.chainId != null) {
            const chainId = (0, index_js_3.getBigInt)(pop.chainId);
            (0, index_js_3.assertArgument)(chainId === network.chainId, "transaction chainId mismatch", "tx.chainId", tx.chainId);
        } else {
            pop.chainId = network.chainId;
        }
        // Do not allow mixing pre-eip-1559 and eip-1559 properties
        const hasEip1559 = pop.maxFeePerGas != null || pop.maxPriorityFeePerGas != null;
        if (pop.gasPrice != null && (pop.type === 2 || hasEip1559)) {
            (0, index_js_3.assertArgument)(false, "eip-1559 transaction do not support gasPrice", "tx", tx);
        } else if ((pop.type === 0 || pop.type === 1) && hasEip1559) {
            (0, index_js_3.assertArgument)(false, "pre-eip-1559 transaction do not support maxFeePerGas/maxPriorityFeePerGas", "tx", tx);
        }
        if ((pop.type === 2 || pop.type == null) && pop.maxFeePerGas != null && pop.maxPriorityFeePerGas != null) {
            // Fully-formed EIP-1559 transaction (skip getFeeData)
            pop.type = 2;
        } else if (pop.type === 0 || pop.type === 1) {
            // Explicit Legacy or EIP-2930 transaction
            // We need to get fee data to determine things
            const feeData = await provider.getFeeData();
            (0, index_js_3.assert)(feeData.gasPrice != null, "network does not support gasPrice", "UNSUPPORTED_OPERATION", {
                operation: "getGasPrice"
            });
            // Populate missing gasPrice
            if (pop.gasPrice == null) {
                pop.gasPrice = feeData.gasPrice;
            }
        } else {
            // We need to get fee data to determine things
            const feeData = await provider.getFeeData();
            if (pop.type == null) {
                // We need to auto-detect the intended type of this transaction...
                if (feeData.maxFeePerGas != null && feeData.maxPriorityFeePerGas != null) {
                    // The network supports EIP-1559!
                    // Upgrade transaction from null to eip-1559
                    if (pop.authorizationList && pop.authorizationList.length) {
                        pop.type = 4;
                    } else {
                        pop.type = 2;
                    }
                    if (pop.gasPrice != null) {
                        // Using legacy gasPrice property on an eip-1559 network,
                        // so use gasPrice as both fee properties
                        const gasPrice = pop.gasPrice;
                        delete pop.gasPrice;
                        pop.maxFeePerGas = gasPrice;
                        pop.maxPriorityFeePerGas = gasPrice;
                    } else {
                        // Populate missing fee data
                        if (pop.maxFeePerGas == null) {
                            pop.maxFeePerGas = feeData.maxFeePerGas;
                        }
                        if (pop.maxPriorityFeePerGas == null) {
                            pop.maxPriorityFeePerGas = feeData.maxPriorityFeePerGas;
                        }
                    }
                } else if (feeData.gasPrice != null) {
                    // Network doesn't support EIP-1559...
                    // ...but they are trying to use EIP-1559 properties
                    (0, index_js_3.assert)(!hasEip1559, "network does not support EIP-1559", "UNSUPPORTED_OPERATION", {
                        operation: "populateTransaction"
                    });
                    // Populate missing fee data
                    if (pop.gasPrice == null) {
                        pop.gasPrice = feeData.gasPrice;
                    }
                    // Explicitly set untyped transaction to legacy
                    // @TODO: Maybe this shold allow type 1?
                    pop.type = 0;
                } else {
                    // getFeeData has failed us.
                    (0, index_js_3.assert)(false, "failed to get consistent fee data", "UNSUPPORTED_OPERATION", {
                        operation: "signer.getFeeData"
                    });
                }
            } else if (pop.type === 2 || pop.type === 3 || pop.type === 4) {
                // Explicitly using EIP-1559 or EIP-4844
                // Populate missing fee data
                if (pop.maxFeePerGas == null) {
                    pop.maxFeePerGas = feeData.maxFeePerGas;
                }
                if (pop.maxPriorityFeePerGas == null) {
                    pop.maxPriorityFeePerGas = feeData.maxPriorityFeePerGas;
                }
            }
        }
        //@TOOD: Don't await all over the place; save them up for
        // the end for better batching
        return await (0, index_js_3.resolveProperties)(pop);
    }
    async populateAuthorization(_auth) {
        const auth = Object.assign({}, _auth);
        // Add a chain ID if not explicitly set to 0
        if (auth.chainId == null) {
            auth.chainId = (await checkProvider(this, "getNetwork").getNetwork()).chainId;
        }
        // @TODO: Take chain ID into account when populating noce?
        if (auth.nonce == null) {
            auth.nonce = await this.getNonce();
        }
        return auth;
    }
    async estimateGas(tx) {
        return checkProvider(this, "estimateGas").estimateGas(await this.populateCall(tx));
    }
    async call(tx) {
        return checkProvider(this, "call").call(await this.populateCall(tx));
    }
    async resolveName(name) {
        const provider = checkProvider(this, "resolveName");
        return await provider.resolveName(name);
    }
    async sendTransaction(tx) {
        const provider = checkProvider(this, "sendTransaction");
        const pop = await this.populateTransaction(tx);
        delete pop.from;
        const txObj = index_js_2.Transaction.from(pop);
        return await provider.broadcastTransaction(await this.signTransaction(txObj));
    }
    // @TODO: in v7 move this to be abstract
    authorize(authorization) {
        (0, index_js_3.assert)(false, "authorization not implemented for this signer", "UNSUPPORTED_OPERATION", {
            operation: "authorize"
        });
    }
    /**
     *  Creates a new Signer connected to %%provider%%.
     */ constructor(provider){
        /**
     *  The provider this signer is connected to.
     */ _define_property._(this, "provider", void 0);
        (0, index_js_3.defineProperties)(this, {
            provider: provider || null
        });
    }
}
exports.AbstractSigner = AbstractSigner;
var _throwUnsupported = /*#__PURE__*/ new WeakSet();
/**
 *  A **VoidSigner** is a class deisgned to allow an address to be used
 *  in any API which accepts a Signer, but for which there are no
 *  credentials available to perform any actual signing.
 *
 *  This for example allow impersonating an account for the purpose of
 *  static calls or estimating gas, but does not allow sending transactions.
 */ class VoidSigner extends AbstractSigner {
    async getAddress() {
        return this.address;
    }
    connect(provider) {
        return new VoidSigner(this.address, provider);
    }
    async signTransaction(tx) {
        _class_private_method_get._(this, _throwUnsupported, throwUnsupported).call(this, "transactions", "signTransaction");
    }
    async signMessage(message) {
        _class_private_method_get._(this, _throwUnsupported, throwUnsupported).call(this, "messages", "signMessage");
    }
    async signTypedData(domain, types, value) {
        _class_private_method_get._(this, _throwUnsupported, throwUnsupported).call(this, "typed-data", "signTypedData");
    }
    /**
     *  Creates a new **VoidSigner** with %%address%% attached to
     *  %%provider%%.
     */ constructor(address, provider){
        super(provider), _class_private_method_init._(this, _throwUnsupported), /**
     *  The signer address.
     */ _define_property._(this, "address", void 0);
        (0, index_js_3.defineProperties)(this, {
            address
        });
    }
}
function throwUnsupported(suffix, operation) {
    (0, index_js_3.assert)(false, "VoidSigner cannot sign ".concat(suffix), "UNSUPPORTED_OPERATION", {
        operation
    });
}
exports.VoidSigner = VoidSigner; //# sourceMappingURL=abstract-signer.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  There are many awesome community services that provide Ethereum
 *  nodes both for developers just starting out and for large-scale
 *  communities.
 *
 *  @_section: api/providers/thirdparty: Community Providers  [thirdparty]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.showThrottleMessage = void 0;
// Show the throttle message only once per service
const shown = new Set();
/**
 *  Displays a warning in the console when the community resource is
 *  being used too heavily by the app, recommending the developer
 *  acquire their own credentials instead of using the community
 *  credentials.
 *
 *  The notification will only occur once per service.
 */ function showThrottleMessage(service) {
    if (shown.has(service)) {
        return;
    }
    shown.add(service);
    console.log("========= NOTICE =========");
    console.log("Request-Rate Exceeded for ".concat(service, " (this message will not be repeated)"));
    console.log("");
    console.log("The default API keys for each service are provided as a highly-throttled,");
    console.log("community resource for low-traffic projects and early prototyping.");
    console.log("");
    console.log("While your application will continue to function, we highly recommended");
    console.log("signing up for your own API keys to improve performance, increase your");
    console.log("request rate/limit and enable other perks, such as metrics and advanced APIs.");
    console.log("");
    console.log("For more details: https:/\/docs.ethers.org/api-keys/");
    console.log("==========================");
}
exports.showThrottleMessage = showThrottleMessage; //# sourceMappingURL=community.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/subscriber-filterid.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FilterIdPendingSubscriber = exports.FilterIdEventSubscriber = exports.FilterIdSubscriber = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const subscriber_polling_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/subscriber-polling.js [app-client] (ecmascript)");
function copy(obj) {
    return JSON.parse(JSON.stringify(obj));
}
var _provider = /*#__PURE__*/ new WeakMap(), _filterIdPromise = /*#__PURE__*/ new WeakMap(), _poller = /*#__PURE__*/ new WeakMap(), _running = /*#__PURE__*/ new WeakMap(), _network = /*#__PURE__*/ new WeakMap(), _hault = /*#__PURE__*/ new WeakMap(), _poll = /*#__PURE__*/ new WeakSet(), _teardown = /*#__PURE__*/ new WeakSet();
/**
 *  Some backends support subscribing to events using a Filter ID.
 *
 *  When subscribing with this technique, the node issues a unique
 *  //Filter ID//. At this point the node dedicates resources to
 *  the filter, so that periodic calls to follow up on the //Filter ID//
 *  will receive any events since the last call.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class FilterIdSubscriber {
    /**
     *  Sub-classes **must** override this to begin the subscription.
     */ _subscribe(provider) {
        throw new Error("subclasses must override this");
    }
    /**
     *  Sub-classes **must** override this handle the events.
     */ _emitResults(provider, result) {
        throw new Error("subclasses must override this");
    }
    /**
     *  Sub-classes **must** override this handle recovery on errors.
     */ _recover(provider) {
        throw new Error("subclasses must override this");
    }
    start() {
        if (_class_private_field_get._(this, _running)) {
            return;
        }
        _class_private_field_set._(this, _running, true);
        _class_private_method_get._(this, _poll, poll).call(this, -2);
    }
    stop() {
        if (!_class_private_field_get._(this, _running)) {
            return;
        }
        _class_private_field_set._(this, _running, false);
        _class_private_field_set._(this, _hault, true);
        _class_private_method_get._(this, _teardown, teardown).call(this);
        _class_private_field_get._(this, _provider).off("block", _class_private_field_get._(this, _poller));
    }
    pause(dropWhilePaused) {
        if (dropWhilePaused) {
            _class_private_method_get._(this, _teardown, teardown).call(this);
        }
        _class_private_field_get._(this, _provider).off("block", _class_private_field_get._(this, _poller));
    }
    resume() {
        this.start();
    }
    /**
     *  Creates a new **FilterIdSubscriber** which will used [[_subscribe]]
     *  and [[_emitResults]] to setup the subscription and provide the event
     *  to the %%provider%%.
     */ constructor(provider){
        _class_private_method_init._(this, _poll);
        _class_private_method_init._(this, _teardown);
        _class_private_field_init._(this, _provider, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _filterIdPromise, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _poller, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _running, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _network, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _hault, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _provider, provider);
        _class_private_field_set._(this, _filterIdPromise, null);
        _class_private_field_set._(this, _poller, _class_private_method_get._(this, _poll, poll).bind(this));
        _class_private_field_set._(this, _running, false);
        _class_private_field_set._(this, _network, null);
        _class_private_field_set._(this, _hault, false);
    }
}
async function poll(blockNumber) {
    try {
        // Subscribe if necessary
        if (_class_private_field_get._(this, _filterIdPromise) == null) {
            _class_private_field_set._(this, _filterIdPromise, this._subscribe(_class_private_field_get._(this, _provider)));
        }
        // Get the Filter ID
        let filterId = null;
        try {
            filterId = await _class_private_field_get._(this, _filterIdPromise);
        } catch (error) {
            if (!(0, index_js_1.isError)(error, "UNSUPPORTED_OPERATION") || error.operation !== "eth_newFilter") {
                throw error;
            }
        }
        // The backend does not support Filter ID; downgrade to
        // polling
        if (filterId == null) {
            _class_private_field_set._(this, _filterIdPromise, null);
            _class_private_field_get._(this, _provider)._recoverSubscriber(this, this._recover(_class_private_field_get._(this, _provider)));
            return;
        }
        const network = await _class_private_field_get._(this, _provider).getNetwork();
        if (!_class_private_field_get._(this, _network)) {
            _class_private_field_set._(this, _network, network);
        }
        if (_class_private_field_get._(this, _network).chainId !== network.chainId) {
            throw new Error("chaid changed");
        }
        if (_class_private_field_get._(this, _hault)) {
            return;
        }
        const result = await _class_private_field_get._(this, _provider).send("eth_getFilterChanges", [
            filterId
        ]);
        await this._emitResults(_class_private_field_get._(this, _provider), result);
    } catch (error) {
        console.log("@TODO", error);
    }
    _class_private_field_get._(this, _provider).once("block", _class_private_field_get._(this, _poller));
}
function teardown() {
    const filterIdPromise = _class_private_field_get._(this, _filterIdPromise);
    if (filterIdPromise) {
        _class_private_field_set._(this, _filterIdPromise, null);
        filterIdPromise.then((filterId)=>{
            if (_class_private_field_get._(this, _provider).destroyed) {
                return;
            }
            _class_private_field_get._(this, _provider).send("eth_uninstallFilter", [
                filterId
            ]);
        });
    }
}
exports.FilterIdSubscriber = FilterIdSubscriber;
var _event = /*#__PURE__*/ new WeakMap();
/**
 *  A **FilterIdSubscriber** for receiving contract events.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class FilterIdEventSubscriber extends FilterIdSubscriber {
    _recover(provider) {
        return new subscriber_polling_js_1.PollingEventSubscriber(provider, _class_private_field_get._(this, _event));
    }
    async _subscribe(provider) {
        const filterId = await provider.send("eth_newFilter", [
            _class_private_field_get._(this, _event)
        ]);
        return filterId;
    }
    async _emitResults(provider, results) {
        for (const result of results){
            provider.emit(_class_private_field_get._(this, _event), provider._wrapLog(result, provider._network));
        }
    }
    /**
     *  Creates a new **FilterIdEventSubscriber** attached to %%provider%%
     *  listening for %%filter%%.
     */ constructor(provider, filter){
        super(provider), _class_private_field_init._(this, _event, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _event, copy(filter));
    }
}
exports.FilterIdEventSubscriber = FilterIdEventSubscriber;
/**
 *  A **FilterIdSubscriber** for receiving pending transactions events.
 *
 *  @_docloc: api/providers/abstract-provider
 */ class FilterIdPendingSubscriber extends FilterIdSubscriber {
    async _subscribe(provider) {
        return await provider.send("eth_newPendingTransactionFilter", []);
    }
    async _emitResults(provider, results) {
        for (const result of results){
            provider.emit("pending", result);
        }
    }
}
exports.FilterIdPendingSubscriber = FilterIdPendingSubscriber; //# sourceMappingURL=subscriber-filterid.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_field_update = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_update.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  One of the most common ways to interact with the blockchain is
 *  by a node running a JSON-RPC interface which can be connected to,
 *  based on the transport, using:
 *
 *  - HTTP or HTTPS - [[JsonRpcProvider]]
 *  - WebSocket - [[WebSocketProvider]]
 *  - IPC - [[IpcSocketProvider]]
 *
 * @_section: api/providers/jsonrpc:JSON-RPC Provider  [about-jsonrpcProvider]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.JsonRpcProvider = exports.JsonRpcApiPollingProvider = exports.JsonRpcApiProvider = exports.JsonRpcSigner = void 0;
// @TODO:
// - Add the batching API
// https://playground.open-rpc.org/?schemaUrl=https://raw.githubusercontent.com/ethereum/eth1.0-apis/assembled-spec/openrpc.json&uiSchema%5BappBar%5D%5Bui:splitView%5D=true&uiSchema%5BappBar%5D%5Bui:input%5D=false&uiSchema%5BappBar%5D%5Bui:examplesDropdown%5D=false
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_5 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abstract_provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-provider.js [app-client] (ecmascript)");
const abstract_signer_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-signer.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const subscriber_filterid_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/subscriber-filterid.js [app-client] (ecmascript)");
const subscriber_polling_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/subscriber-polling.js [app-client] (ecmascript)");
const Primitive = "bigint,boolean,function,number,string,symbol".split(/,/g);
//const Methods = "getAddress,then".split(/,/g);
function deepCopy(value) {
    if (value == null || Primitive.indexOf(typeof value) >= 0) {
        return value;
    }
    // Keep any Addressable
    if (typeof value.getAddress === "function") {
        return value;
    }
    if (Array.isArray(value)) {
        return value.map(deepCopy);
    }
    if (typeof value === "object") {
        return Object.keys(value).reduce((accum, key)=>{
            accum[key] = value[key];
            return accum;
        }, {});
    }
    throw new Error("should not happen: ".concat(value, " (").concat(typeof value, ")"));
}
function stall(duration) {
    return new Promise((resolve)=>{
        setTimeout(resolve, duration);
    });
}
function getLowerCase(value) {
    if (value) {
        return value.toLowerCase();
    }
    return value;
}
function isPollable(value) {
    return value && typeof value.pollingInterval === "number";
}
const defaultOptions = {
    polling: false,
    staticNetwork: null,
    batchStallTime: 10,
    batchMaxSize: 1 << 20,
    batchMaxCount: 100,
    cacheTimeout: 250,
    pollingInterval: 4000
};
// @TODO: Unchecked Signers
class JsonRpcSigner extends abstract_signer_js_1.AbstractSigner {
    connect(provider) {
        (0, index_js_5.assert)(false, "cannot reconnect JsonRpcSigner", "UNSUPPORTED_OPERATION", {
            operation: "signer.connect"
        });
    }
    async getAddress() {
        return this.address;
    }
    // JSON-RPC will automatially fill in nonce, etc. so we just check from
    async populateTransaction(tx) {
        return await this.populateCall(tx);
    }
    // Returns just the hash of the transaction after sent, which is what
    // the bare JSON-RPC API does;
    async sendUncheckedTransaction(_tx) {
        const tx = deepCopy(_tx);
        const promises = [];
        // Make sure the from matches the sender
        if (tx.from) {
            const _from = tx.from;
            promises.push((async ()=>{
                const from = await (0, index_js_2.resolveAddress)(_from, this.provider);
                (0, index_js_5.assertArgument)(from != null && from.toLowerCase() === this.address.toLowerCase(), "from address mismatch", "transaction", _tx);
                tx.from = from;
            })());
        } else {
            tx.from = this.address;
        }
        // The JSON-RPC for eth_sendTransaction uses 90000 gas; if the user
        // wishes to use this, it is easy to specify explicitly, otherwise
        // we look it up for them.
        if (tx.gasLimit == null) {
            promises.push((async ()=>{
                tx.gasLimit = await this.provider.estimateGas({
                    ...tx,
                    from: this.address
                });
            })());
        }
        // The address may be an ENS name or Addressable
        if (tx.to != null) {
            const _to = tx.to;
            promises.push((async ()=>{
                tx.to = await (0, index_js_2.resolveAddress)(_to, this.provider);
            })());
        }
        // Wait until all of our properties are filled in
        if (promises.length) {
            await Promise.all(promises);
        }
        const hexTx = this.provider.getRpcTransaction(tx);
        return this.provider.send("eth_sendTransaction", [
            hexTx
        ]);
    }
    async sendTransaction(tx) {
        // This cannot be mined any earlier than any recent block
        const blockNumber = await this.provider.getBlockNumber();
        // Send the transaction
        const hash = await this.sendUncheckedTransaction(tx);
        // Unfortunately, JSON-RPC only provides and opaque transaction hash
        // for a response, and we need the actual transaction, so we poll
        // for it; it should show up very quickly
        return await new Promise((resolve, reject)=>{
            const timeouts = [
                1000,
                100
            ];
            let invalids = 0;
            const checkTx = async ()=>{
                try {
                    // Try getting the transaction
                    const tx = await this.provider.getTransaction(hash);
                    if (tx != null) {
                        resolve(tx.replaceableTransaction(blockNumber));
                        return;
                    }
                } catch (error) {
                    // If we were cancelled: stop polling.
                    // If the data is bad: the node returns bad transactions
                    // If the network changed: calling again will also fail
                    // If unsupported: likely destroyed
                    if ((0, index_js_5.isError)(error, "CANCELLED") || (0, index_js_5.isError)(error, "BAD_DATA") || (0, index_js_5.isError)(error, "NETWORK_ERROR") || (0, index_js_5.isError)(error, "UNSUPPORTED_OPERATION")) {
                        if (error.info == null) {
                            error.info = {};
                        }
                        error.info.sendTransactionHash = hash;
                        reject(error);
                        return;
                    }
                    // Stop-gap for misbehaving backends; see #4513
                    if ((0, index_js_5.isError)(error, "INVALID_ARGUMENT")) {
                        invalids++;
                        if (error.info == null) {
                            error.info = {};
                        }
                        error.info.sendTransactionHash = hash;
                        if (invalids > 10) {
                            reject(error);
                            return;
                        }
                    }
                    // Notify anyone that cares; but we will try again, since
                    // it is likely an intermittent service error
                    this.provider.emit("error", (0, index_js_5.makeError)("failed to fetch transation after sending (will try again)", "UNKNOWN_ERROR", {
                        error
                    }));
                }
                // Wait another 4 seconds
                this.provider._setTimeout(()=>{
                    checkTx();
                }, timeouts.pop() || 4000);
            };
            checkTx();
        });
    }
    async signTransaction(_tx) {
        const tx = deepCopy(_tx);
        // Make sure the from matches the sender
        if (tx.from) {
            const from = await (0, index_js_2.resolveAddress)(tx.from, this.provider);
            (0, index_js_5.assertArgument)(from != null && from.toLowerCase() === this.address.toLowerCase(), "from address mismatch", "transaction", _tx);
            tx.from = from;
        } else {
            tx.from = this.address;
        }
        const hexTx = this.provider.getRpcTransaction(tx);
        return await this.provider.send("eth_signTransaction", [
            hexTx
        ]);
    }
    async signMessage(_message) {
        const message = typeof _message === "string" ? (0, index_js_5.toUtf8Bytes)(_message) : _message;
        return await this.provider.send("personal_sign", [
            (0, index_js_5.hexlify)(message),
            this.address.toLowerCase()
        ]);
    }
    async signTypedData(domain, types, _value) {
        const value = deepCopy(_value);
        // Populate any ENS names (in-place)
        const populated = await index_js_3.TypedDataEncoder.resolveNames(domain, types, value, async (value)=>{
            const address = await (0, index_js_2.resolveAddress)(value);
            (0, index_js_5.assertArgument)(address != null, "TypedData does not support null address", "value", value);
            return address;
        });
        return await this.provider.send("eth_signTypedData_v4", [
            this.address.toLowerCase(),
            JSON.stringify(index_js_3.TypedDataEncoder.getPayload(populated.domain, types, populated.value))
        ]);
    }
    async unlock(password) {
        return this.provider.send("personal_unlockAccount", [
            this.address.toLowerCase(),
            password,
            null
        ]);
    }
    // https://github.com/ethereum/wiki/wiki/JSON-RPC#eth_sign
    async _legacySignMessage(_message) {
        const message = typeof _message === "string" ? (0, index_js_5.toUtf8Bytes)(_message) : _message;
        return await this.provider.send("eth_sign", [
            this.address.toLowerCase(),
            (0, index_js_5.hexlify)(message)
        ]);
    }
    constructor(provider, address){
        super(provider), _define_property._(this, "address", void 0);
        address = (0, index_js_2.getAddress)(address);
        (0, index_js_5.defineProperties)(this, {
            address
        });
    }
}
exports.JsonRpcSigner = JsonRpcSigner;
var _options = /*#__PURE__*/ new WeakMap(), // The next ID to use for the JSON-RPC ID field
_nextId = /*#__PURE__*/ new WeakMap(), // Payloads are queued and triggered in batches using the drainTimer
_payloads = /*#__PURE__*/ new WeakMap(), _drainTimer = /*#__PURE__*/ new WeakMap(), _notReady = /*#__PURE__*/ new WeakMap(), _network = /*#__PURE__*/ new WeakMap(), _pendingDetectNetwork = /*#__PURE__*/ new WeakMap(), _scheduleDrain = /*#__PURE__*/ new WeakSet();
/**
 *  The JsonRpcApiProvider is an abstract class and **MUST** be
 *  sub-classed.
 *
 *  It provides the base for all JSON-RPC-based Provider interaction.
 *
 *  Sub-classing Notes:
 *  - a sub-class MUST override _send
 *  - a sub-class MUST call the `_start()` method once connected
 */ class JsonRpcApiProvider extends abstract_provider_js_1.AbstractProvider {
    /**
     *  Returns the value associated with the option %%key%%.
     *
     *  Sub-classes can use this to inquire about configuration options.
     */ _getOption(key) {
        return _class_private_field_get._(this, _options)[key];
    }
    /**
     *  Gets the [[Network]] this provider has committed to. On each call, the network
     *  is detected, and if it has changed, the call will reject.
     */ get _network() {
        (0, index_js_5.assert)(_class_private_field_get._(this, _network), "network is not available yet", "NETWORK_ERROR");
        return _class_private_field_get._(this, _network);
    }
    /**
     *  Resolves to the non-normalized value by performing %%req%%.
     *
     *  Sub-classes may override this to modify behavior of actions,
     *  and should generally call ``super._perform`` as a fallback.
     */ async _perform(req) {
        // Legacy networks do not like the type field being passed along (which
        // is fair), so we delete type if it is 0 and a non-EIP-1559 network
        if (req.method === "call" || req.method === "estimateGas") {
            let tx = req.transaction;
            if (tx && tx.type != null && (0, index_js_5.getBigInt)(tx.type)) {
                // If there are no EIP-1559 or newer properties, it might be pre-EIP-1559
                if (tx.maxFeePerGas == null && tx.maxPriorityFeePerGas == null) {
                    const feeData = await this.getFeeData();
                    if (feeData.maxFeePerGas == null && feeData.maxPriorityFeePerGas == null) {
                        // Network doesn't know about EIP-1559 (and hence type)
                        req = Object.assign({}, req, {
                            transaction: Object.assign({}, tx, {
                                type: undefined
                            })
                        });
                    }
                }
            }
        }
        const request = this.getRpcRequest(req);
        if (request != null) {
            return await this.send(request.method, request.args);
        }
        return super._perform(req);
    }
    /**
     *  Sub-classes may override this; it detects the *actual* network that
     *  we are **currently** connected to.
     *
     *  Keep in mind that [[send]] may only be used once [[ready]], otherwise the
     *  _send primitive must be used instead.
     */ async _detectNetwork() {
        const network = this._getOption("staticNetwork");
        if (network) {
            if (network === true) {
                if (_class_private_field_get._(this, _network)) {
                    return _class_private_field_get._(this, _network);
                }
            } else {
                return network;
            }
        }
        if (_class_private_field_get._(this, _pendingDetectNetwork)) {
            return await _class_private_field_get._(this, _pendingDetectNetwork);
        }
        // If we are ready, use ``send``, which enabled requests to be batched
        if (this.ready) {
            _class_private_field_set._(this, _pendingDetectNetwork, (async ()=>{
                try {
                    const result = network_js_1.Network.from((0, index_js_5.getBigInt)(await this.send("eth_chainId", [])));
                    _class_private_field_set._(this, _pendingDetectNetwork, null);
                    return result;
                } catch (error) {
                    _class_private_field_set._(this, _pendingDetectNetwork, null);
                    throw error;
                }
            })());
            return await _class_private_field_get._(this, _pendingDetectNetwork);
        }
        // We are not ready yet; use the primitive _send
        _class_private_field_set._(this, _pendingDetectNetwork, (async ()=>{
            const payload = {
                id: _class_private_field_update._(this, _nextId).value++,
                method: "eth_chainId",
                params: [],
                jsonrpc: "2.0"
            };
            this.emit("debug", {
                action: "sendRpcPayload",
                payload
            });
            let result;
            try {
                result = (await this._send(payload))[0];
                _class_private_field_set._(this, _pendingDetectNetwork, null);
            } catch (error) {
                _class_private_field_set._(this, _pendingDetectNetwork, null);
                this.emit("debug", {
                    action: "receiveRpcError",
                    error
                });
                throw error;
            }
            this.emit("debug", {
                action: "receiveRpcResult",
                result
            });
            if ("result" in result) {
                return network_js_1.Network.from((0, index_js_5.getBigInt)(result.result));
            }
            throw this.getRpcError(payload, result);
        })());
        return await _class_private_field_get._(this, _pendingDetectNetwork);
    }
    /**
     *  Sub-classes **MUST** call this. Until [[_start]] has been called, no calls
     *  will be passed to [[_send]] from [[send]]. If it is overridden, then
     *  ``super._start()`` **MUST** be called.
     *
     *  Calling it multiple times is safe and has no effect.
     */ _start() {
        if (_class_private_field_get._(this, _notReady) == null || _class_private_field_get._(this, _notReady).resolve == null) {
            return;
        }
        _class_private_field_get._(this, _notReady).resolve();
        _class_private_field_set._(this, _notReady, null);
        (async ()=>{
            // Bootstrap the network
            while(_class_private_field_get._(this, _network) == null && !this.destroyed){
                try {
                    _class_private_field_set._(this, _network, await this._detectNetwork());
                } catch (error) {
                    if (this.destroyed) {
                        break;
                    }
                    console.log("JsonRpcProvider failed to detect network and cannot start up; retry in 1s (perhaps the URL is wrong or the node is not started)");
                    this.emit("error", (0, index_js_5.makeError)("failed to bootstrap network detection", "NETWORK_ERROR", {
                        event: "initial-network-discovery",
                        info: {
                            error
                        }
                    }));
                    await stall(1000);
                }
            }
            // Start dispatching requests
            _class_private_method_get._(this, _scheduleDrain, scheduleDrain).call(this);
        })();
    }
    /**
     *  Resolves once the [[_start]] has been called. This can be used in
     *  sub-classes to defer sending data until the connection has been
     *  established.
     */ async _waitUntilReady() {
        if (_class_private_field_get._(this, _notReady) == null) {
            return;
        }
        return await _class_private_field_get._(this, _notReady).promise;
    }
    /**
     *  Return a Subscriber that will manage the %%sub%%.
     *
     *  Sub-classes may override this to modify the behavior of
     *  subscription management.
     */ _getSubscriber(sub) {
        // Pending Filters aren't availble via polling
        if (sub.type === "pending") {
            return new subscriber_filterid_js_1.FilterIdPendingSubscriber(this);
        }
        if (sub.type === "event") {
            if (this._getOption("polling")) {
                return new subscriber_polling_js_1.PollingEventSubscriber(this, sub.filter);
            }
            return new subscriber_filterid_js_1.FilterIdEventSubscriber(this, sub.filter);
        }
        // Orphaned Logs are handled automatically, by the filter, since
        // logs with removed are emitted by it
        if (sub.type === "orphan" && sub.filter.orphan === "drop-log") {
            return new abstract_provider_js_1.UnmanagedSubscriber("orphan");
        }
        return super._getSubscriber(sub);
    }
    /**
     *  Returns true only if the [[_start]] has been called.
     */ get ready() {
        return _class_private_field_get._(this, _notReady) == null;
    }
    /**
     *  Returns %%tx%% as a normalized JSON-RPC transaction request,
     *  which has all values hexlified and any numeric values converted
     *  to Quantity values.
     */ getRpcTransaction(tx) {
        const result = {};
        // JSON-RPC now requires numeric values to be "quantity" values
        [
            "chainId",
            "gasLimit",
            "gasPrice",
            "type",
            "maxFeePerGas",
            "maxPriorityFeePerGas",
            "nonce",
            "value"
        ].forEach((key)=>{
            if (tx[key] == null) {
                return;
            }
            let dstKey = key;
            if (key === "gasLimit") {
                dstKey = "gas";
            }
            result[dstKey] = (0, index_js_5.toQuantity)((0, index_js_5.getBigInt)(tx[key], "tx.".concat(key)));
        });
        // Make sure addresses and data are lowercase
        [
            "from",
            "to",
            "data"
        ].forEach((key)=>{
            if (tx[key] == null) {
                return;
            }
            result[key] = (0, index_js_5.hexlify)(tx[key]);
        });
        // Normalize the access list object
        if (tx.accessList) {
            result["accessList"] = (0, index_js_4.accessListify)(tx.accessList);
        }
        if (tx.blobVersionedHashes) {
            // @TODO: Remove this <any> case once EIP-4844 added to prepared tx
            result["blobVersionedHashes"] = tx.blobVersionedHashes.map((h)=>h.toLowerCase());
        }
        if (tx.authorizationList) {
            result["authorizationList"] = tx.authorizationList.map((_a)=>{
                const a = (0, index_js_4.authorizationify)(_a);
                return {
                    address: a.address,
                    nonce: (0, index_js_5.toQuantity)(a.nonce),
                    chainId: (0, index_js_5.toQuantity)(a.chainId),
                    yParity: (0, index_js_5.toQuantity)(a.signature.yParity),
                    r: (0, index_js_5.toQuantity)(a.signature.r),
                    s: (0, index_js_5.toQuantity)(a.signature.s)
                };
            });
        }
        // @TODO: blobs should probably also be copied over, optionally
        // accounting for the kzg property to backfill blobVersionedHashes
        // using the commitment. Or should that be left as an exercise to
        // the caller?
        return result;
    }
    /**
     *  Returns the request method and arguments required to perform
     *  %%req%%.
     */ getRpcRequest(req) {
        switch(req.method){
            case "chainId":
                return {
                    method: "eth_chainId",
                    args: []
                };
            case "getBlockNumber":
                return {
                    method: "eth_blockNumber",
                    args: []
                };
            case "getGasPrice":
                return {
                    method: "eth_gasPrice",
                    args: []
                };
            case "getPriorityFee":
                return {
                    method: "eth_maxPriorityFeePerGas",
                    args: []
                };
            case "getBalance":
                return {
                    method: "eth_getBalance",
                    args: [
                        getLowerCase(req.address),
                        req.blockTag
                    ]
                };
            case "getTransactionCount":
                return {
                    method: "eth_getTransactionCount",
                    args: [
                        getLowerCase(req.address),
                        req.blockTag
                    ]
                };
            case "getCode":
                return {
                    method: "eth_getCode",
                    args: [
                        getLowerCase(req.address),
                        req.blockTag
                    ]
                };
            case "getStorage":
                return {
                    method: "eth_getStorageAt",
                    args: [
                        getLowerCase(req.address),
                        "0x" + req.position.toString(16),
                        req.blockTag
                    ]
                };
            case "broadcastTransaction":
                return {
                    method: "eth_sendRawTransaction",
                    args: [
                        req.signedTransaction
                    ]
                };
            case "getBlock":
                if ("blockTag" in req) {
                    return {
                        method: "eth_getBlockByNumber",
                        args: [
                            req.blockTag,
                            !!req.includeTransactions
                        ]
                    };
                } else if ("blockHash" in req) {
                    return {
                        method: "eth_getBlockByHash",
                        args: [
                            req.blockHash,
                            !!req.includeTransactions
                        ]
                    };
                }
                break;
            case "getTransaction":
                return {
                    method: "eth_getTransactionByHash",
                    args: [
                        req.hash
                    ]
                };
            case "getTransactionReceipt":
                return {
                    method: "eth_getTransactionReceipt",
                    args: [
                        req.hash
                    ]
                };
            case "call":
                return {
                    method: "eth_call",
                    args: [
                        this.getRpcTransaction(req.transaction),
                        req.blockTag
                    ]
                };
            case "estimateGas":
                {
                    return {
                        method: "eth_estimateGas",
                        args: [
                            this.getRpcTransaction(req.transaction)
                        ]
                    };
                }
            case "getLogs":
                if (req.filter && req.filter.address != null) {
                    if (Array.isArray(req.filter.address)) {
                        req.filter.address = req.filter.address.map(getLowerCase);
                    } else {
                        req.filter.address = getLowerCase(req.filter.address);
                    }
                }
                return {
                    method: "eth_getLogs",
                    args: [
                        req.filter
                    ]
                };
        }
        return null;
    }
    /**
     *  Returns an ethers-style Error for the given JSON-RPC error
     *  %%payload%%, coalescing the various strings and error shapes
     *  that different nodes return, coercing them into a machine-readable
     *  standardized error.
     */ getRpcError(payload, _error) {
        const { method } = payload;
        const { error } = _error;
        if (method === "eth_estimateGas" && error.message) {
            const msg = error.message;
            if (!msg.match(/revert/i) && msg.match(/insufficient funds/i)) {
                return (0, index_js_5.makeError)("insufficient funds", "INSUFFICIENT_FUNDS", {
                    transaction: payload.params[0],
                    info: {
                        payload,
                        error
                    }
                });
            } else if (msg.match(/nonce/i) && msg.match(/too low/i)) {
                return (0, index_js_5.makeError)("nonce has already been used", "NONCE_EXPIRED", {
                    transaction: payload.params[0],
                    info: {
                        payload,
                        error
                    }
                });
            }
        }
        if (method === "eth_call" || method === "eth_estimateGas") {
            const result = spelunkData(error);
            const e = index_js_1.AbiCoder.getBuiltinCallException(method === "eth_call" ? "call" : "estimateGas", payload.params[0], result ? result.data : null);
            e.info = {
                error,
                payload
            };
            return e;
        }
        // Only estimateGas and call can return arbitrary contract-defined text, so now we
        // we can process text safely.
        const message = JSON.stringify(spelunkMessage(error));
        if (typeof error.message === "string" && error.message.match(/user denied|ethers-user-denied/i)) {
            const actionMap = {
                eth_sign: "signMessage",
                personal_sign: "signMessage",
                eth_signTypedData_v4: "signTypedData",
                eth_signTransaction: "signTransaction",
                eth_sendTransaction: "sendTransaction",
                eth_requestAccounts: "requestAccess",
                wallet_requestAccounts: "requestAccess"
            };
            return (0, index_js_5.makeError)("user rejected action", "ACTION_REJECTED", {
                action: actionMap[method] || "unknown",
                reason: "rejected",
                info: {
                    payload,
                    error
                }
            });
        }
        if (method === "eth_sendRawTransaction" || method === "eth_sendTransaction") {
            const transaction = payload.params[0];
            if (message.match(/insufficient funds|base fee exceeds gas limit/i)) {
                return (0, index_js_5.makeError)("insufficient funds for intrinsic transaction cost", "INSUFFICIENT_FUNDS", {
                    transaction,
                    info: {
                        error
                    }
                });
            }
            if (message.match(/nonce/i) && message.match(/too low/i)) {
                return (0, index_js_5.makeError)("nonce has already been used", "NONCE_EXPIRED", {
                    transaction,
                    info: {
                        error
                    }
                });
            }
            // "replacement transaction underpriced"
            if (message.match(/replacement transaction/i) && message.match(/underpriced/i)) {
                return (0, index_js_5.makeError)("replacement fee too low", "REPLACEMENT_UNDERPRICED", {
                    transaction,
                    info: {
                        error
                    }
                });
            }
            if (message.match(/only replay-protected/i)) {
                return (0, index_js_5.makeError)("legacy pre-eip-155 transactions not supported", "UNSUPPORTED_OPERATION", {
                    operation: method,
                    info: {
                        transaction,
                        info: {
                            error
                        }
                    }
                });
            }
        }
        let unsupported = !!message.match(/the method .* does not exist/i);
        if (!unsupported) {
            if (error && error.details && error.details.startsWith("Unauthorized method:")) {
                unsupported = true;
            }
        }
        if (unsupported) {
            return (0, index_js_5.makeError)("unsupported operation", "UNSUPPORTED_OPERATION", {
                operation: payload.method,
                info: {
                    error,
                    payload
                }
            });
        }
        return (0, index_js_5.makeError)("could not coalesce error", "UNKNOWN_ERROR", {
            error,
            payload
        });
    }
    /**
     *  Requests the %%method%% with %%params%% via the JSON-RPC protocol
     *  over the underlying channel. This can be used to call methods
     *  on the backend that do not have a high-level API within the Provider
     *  API.
     *
     *  This method queues requests according to the batch constraints
     *  in the options, assigns the request a unique ID.
     *
     *  **Do NOT override** this method in sub-classes; instead
     *  override [[_send]] or force the options values in the
     *  call to the constructor to modify this method's behavior.
     */ send(method, params) {
        // @TODO: cache chainId?? purge on switch_networks
        // We have been destroyed; no operations are supported anymore
        if (this.destroyed) {
            return Promise.reject((0, index_js_5.makeError)("provider destroyed; cancelled request", "UNSUPPORTED_OPERATION", {
                operation: method
            }));
        }
        const id = _class_private_field_update._(this, _nextId).value++;
        const promise = new Promise((resolve, reject)=>{
            _class_private_field_get._(this, _payloads).push({
                resolve,
                reject,
                payload: {
                    method,
                    params,
                    id,
                    jsonrpc: "2.0"
                }
            });
        });
        // If there is not a pending drainTimer, set one
        _class_private_method_get._(this, _scheduleDrain, scheduleDrain).call(this);
        return promise;
    }
    /**
     *  Resolves to the [[Signer]] account for  %%address%% managed by
     *  the client.
     *
     *  If the %%address%% is a number, it is used as an index in the
     *  the accounts from [[listAccounts]].
     *
     *  This can only be used on clients which manage accounts (such as
     *  Geth with imported account or MetaMask).
     *
     *  Throws if the account doesn't exist.
     */ async getSigner(address) {
        if (address == null) {
            address = 0;
        }
        const accountsPromise = this.send("eth_accounts", []);
        // Account index
        if (typeof address === "number") {
            const accounts = await accountsPromise;
            if (address >= accounts.length) {
                throw new Error("no such account");
            }
            return new JsonRpcSigner(this, accounts[address]);
        }
        const { accounts } = await (0, index_js_5.resolveProperties)({
            network: this.getNetwork(),
            accounts: accountsPromise
        });
        // Account address
        address = (0, index_js_2.getAddress)(address);
        for (const account of accounts){
            if ((0, index_js_2.getAddress)(account) === address) {
                return new JsonRpcSigner(this, address);
            }
        }
        throw new Error("invalid account");
    }
    async listAccounts() {
        const accounts = await this.send("eth_accounts", []);
        return accounts.map((a)=>new JsonRpcSigner(this, a));
    }
    destroy() {
        // Stop processing requests
        if (_class_private_field_get._(this, _drainTimer)) {
            clearTimeout(_class_private_field_get._(this, _drainTimer));
            _class_private_field_set._(this, _drainTimer, null);
        }
        // Cancel all pending requests
        for (const { payload, reject } of _class_private_field_get._(this, _payloads)){
            reject((0, index_js_5.makeError)("provider destroyed; cancelled request", "UNSUPPORTED_OPERATION", {
                operation: payload.method
            }));
        }
        _class_private_field_set._(this, _payloads, []);
        // Parent clean-up
        super.destroy();
    }
    constructor(network, options){
        super(network, options), _class_private_method_init._(this, _scheduleDrain), _class_private_field_init._(this, _options, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _nextId, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _payloads, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _drainTimer, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _notReady, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _network, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _pendingDetectNetwork, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _nextId, 1);
        _class_private_field_set._(this, _options, Object.assign({}, defaultOptions, options || {}));
        _class_private_field_set._(this, _payloads, []);
        _class_private_field_set._(this, _drainTimer, null);
        _class_private_field_set._(this, _network, null);
        _class_private_field_set._(this, _pendingDetectNetwork, null);
        {
            let resolve = null;
            const promise = new Promise((_resolve)=>{
                resolve = _resolve;
            });
            _class_private_field_set._(this, _notReady, {
                promise,
                resolve
            });
        }
        const staticNetwork = this._getOption("staticNetwork");
        if (typeof staticNetwork === "boolean") {
            (0, index_js_5.assertArgument)(!staticNetwork || network !== "any", "staticNetwork cannot be used on special network 'any'", "options", options);
            if (staticNetwork && network != null) {
                _class_private_field_set._(this, _network, network_js_1.Network.from(network));
            }
        } else if (staticNetwork) {
            // Make sure any static network is compatbile with the provided netwrok
            (0, index_js_5.assertArgument)(network == null || staticNetwork.matches(network), "staticNetwork MUST match network object", "options", options);
            _class_private_field_set._(this, _network, staticNetwork);
        }
    }
}
function scheduleDrain() {
    if (_class_private_field_get._(this, _drainTimer)) {
        return;
    }
    // If we aren't using batching, no harm in sending it immediately
    const stallTime = this._getOption("batchMaxCount") === 1 ? 0 : this._getOption("batchStallTime");
    _class_private_field_set._(this, _drainTimer, setTimeout(()=>{
        _class_private_field_set._(this, _drainTimer, null);
        const payloads = _class_private_field_get._(this, _payloads);
        _class_private_field_set._(this, _payloads, []);
        while(payloads.length){
            // Create payload batches that satisfy our batch constraints
            const batch = [
                payloads.shift()
            ];
            while(payloads.length){
                if (batch.length === _class_private_field_get._(this, _options).batchMaxCount) {
                    break;
                }
                batch.push(payloads.shift());
                const bytes = JSON.stringify(batch.map((p)=>p.payload));
                if (bytes.length > _class_private_field_get._(this, _options).batchMaxSize) {
                    payloads.unshift(batch.pop());
                    break;
                }
            }
            // Process the result to each payload
            (async ()=>{
                const payload = batch.length === 1 ? batch[0].payload : batch.map((p)=>p.payload);
                this.emit("debug", {
                    action: "sendRpcPayload",
                    payload
                });
                try {
                    const result = await this._send(payload);
                    this.emit("debug", {
                        action: "receiveRpcResult",
                        result
                    });
                    // Process results in batch order
                    for (const { resolve, reject, payload } of batch){
                        if (this.destroyed) {
                            reject((0, index_js_5.makeError)("provider destroyed; cancelled request", "UNSUPPORTED_OPERATION", {
                                operation: payload.method
                            }));
                            continue;
                        }
                        // Find the matching result
                        const resp = result.filter((r)=>r.id === payload.id)[0];
                        // No result; the node failed us in unexpected ways
                        if (resp == null) {
                            const error = (0, index_js_5.makeError)("missing response for request", "BAD_DATA", {
                                value: result,
                                info: {
                                    payload
                                }
                            });
                            this.emit("error", error);
                            reject(error);
                            continue;
                        }
                        // The response is an error
                        if ("error" in resp) {
                            reject(this.getRpcError(payload, resp));
                            continue;
                        }
                        // All good; send the result
                        resolve(resp.result);
                    }
                } catch (error) {
                    this.emit("debug", {
                        action: "receiveRpcError",
                        error
                    });
                    for (const { reject } of batch){
                        // @TODO: augment the error with the payload
                        reject(error);
                    }
                }
            })();
        }
    }, stallTime));
}
exports.JsonRpcApiProvider = JsonRpcApiProvider;
var _pollingInterval = /*#__PURE__*/ new WeakMap();
// @TODO: remove this in v7, it is not exported because this functionality
// is exposed in the JsonRpcApiProvider by setting polling to true. It should
// be safe to remove regardless, because it isn't reachable, but just in case.
/**
 *  @_ignore:
 */ class JsonRpcApiPollingProvider extends JsonRpcApiProvider {
    _getSubscriber(sub) {
        const subscriber = super._getSubscriber(sub);
        if (isPollable(subscriber)) {
            subscriber.pollingInterval = _class_private_field_get._(this, _pollingInterval);
        }
        return subscriber;
    }
    /**
     *  The polling interval (default: 4000 ms)
     */ get pollingInterval() {
        return _class_private_field_get._(this, _pollingInterval);
    }
    set pollingInterval(value) {
        if (!Number.isInteger(value) || value < 0) {
            throw new Error("invalid interval");
        }
        _class_private_field_set._(this, _pollingInterval, value);
        this._forEachSubscriber((sub)=>{
            if (isPollable(sub)) {
                sub.pollingInterval = _class_private_field_get._(this, _pollingInterval);
            }
        });
    }
    constructor(network, options){
        super(network, options), _class_private_field_init._(this, _pollingInterval, {
            writable: true,
            value: void 0
        });
        let pollingInterval = this._getOption("pollingInterval");
        if (pollingInterval == null) {
            pollingInterval = defaultOptions.pollingInterval;
        }
        _class_private_field_set._(this, _pollingInterval, pollingInterval);
    }
}
exports.JsonRpcApiPollingProvider = JsonRpcApiPollingProvider;
var _connect = /*#__PURE__*/ new WeakMap();
/**
 *  The JsonRpcProvider is one of the most common Providers,
 *  which performs all operations over HTTP (or HTTPS) requests.
 *
 *  Events are processed by polling the backend for the current block
 *  number; when it advances, all block-base events are then checked
 *  for updates.
 */ class JsonRpcProvider extends JsonRpcApiPollingProvider {
    _getConnection() {
        return _class_private_field_get._(this, _connect).clone();
    }
    async send(method, params) {
        // All requests are over HTTP, so we can just start handling requests
        // We do this here rather than the constructor so that we don't send any
        // requests to the network (i.e. eth_chainId) until we absolutely have to.
        await this._start();
        return await super.send(method, params);
    }
    async _send(payload) {
        // Configure a POST connection for the requested method
        const request = this._getConnection();
        request.body = JSON.stringify(payload);
        request.setHeader("content-type", "application/json");
        const response = await request.send();
        response.assertOk();
        let resp = response.bodyJson;
        if (!Array.isArray(resp)) {
            resp = [
                resp
            ];
        }
        return resp;
    }
    constructor(url, network, options){
        if (url == null) {
            url = "http:/\/localhost:8545";
        }
        super(network, options), _class_private_field_init._(this, _connect, {
            writable: true,
            value: void 0
        });
        if (typeof url === "string") {
            _class_private_field_set._(this, _connect, new index_js_5.FetchRequest(url));
        } else {
            _class_private_field_set._(this, _connect, url.clone());
        }
    }
}
exports.JsonRpcProvider = JsonRpcProvider;
function spelunkData(value) {
    if (value == null) {
        return null;
    }
    // These *are* the droids we're looking for.
    if (typeof value.message === "string" && value.message.match(/revert/i) && (0, index_js_5.isHexString)(value.data)) {
        return {
            message: value.message,
            data: value.data
        };
    }
    // Spelunk further...
    if (typeof value === "object") {
        for(const key in value){
            const result = spelunkData(value[key]);
            if (result) {
                return result;
            }
        }
        return null;
    }
    // Might be a JSON string we can further descend...
    if (typeof value === "string") {
        try {
            return spelunkData(JSON.parse(value));
        } catch (error) {}
    }
    return null;
}
function _spelunkMessage(value, result) {
    if (value == null) {
        return;
    }
    // These *are* the droids we're looking for.
    if (typeof value.message === "string") {
        result.push(value.message);
    }
    // Spelunk further...
    if (typeof value === "object") {
        for(const key in value){
            _spelunkMessage(value[key], result);
        }
    }
    // Might be a JSON string we can further descend...
    if (typeof value === "string") {
        try {
            return _spelunkMessage(JSON.parse(value), result);
        } catch (error) {}
    }
}
function spelunkMessage(value) {
    const result = [];
    _spelunkMessage(value, result);
    return result;
} //# sourceMappingURL=provider-jsonrpc.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-ankr.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AnkrProvider = void 0;
/**
 *  [[link-ankr]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Goerli Testnet (``goerli``)
 *  - Sepolia Testnet (``sepolia``)
 *  - Arbitrum (``arbitrum``)
 *  - Base (``base``)
 *  - Base Goerlia Testnet (``base-goerli``)
 *  - Base Sepolia Testnet (``base-sepolia``)
 *  - BNB (``bnb``)
 *  - BNB Testnet (``bnbt``)
 *  - Optimism (``optimism``)
 *  - Optimism Goerli Testnet (``optimism-goerli``)
 *  - Optimism Sepolia Testnet (``optimism-sepolia``)
 *  - Polygon (``matic``)
 *  - Polygon Mumbai Testnet (``matic-mumbai``)
 *
 *  @_subsection: api/providers/thirdparty:Ankr  [providers-ankr]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
const defaultApiKey = "9f7d929b018cdffb338517efa06f58359e86ff1ffd350bc889738523659e7972";
function getHost(name) {
    switch(name){
        case "mainnet":
            return "rpc.ankr.com/eth";
        case "goerli":
            return "rpc.ankr.com/eth_goerli";
        case "sepolia":
            return "rpc.ankr.com/eth_sepolia";
        case "arbitrum":
            return "rpc.ankr.com/arbitrum";
        case "base":
            return "rpc.ankr.com/base";
        case "base-goerli":
            return "rpc.ankr.com/base_goerli";
        case "base-sepolia":
            return "rpc.ankr.com/base_sepolia";
        case "bnb":
            return "rpc.ankr.com/bsc";
        case "bnbt":
            return "rpc.ankr.com/bsc_testnet_chapel";
        case "matic":
            return "rpc.ankr.com/polygon";
        case "matic-mumbai":
            return "rpc.ankr.com/polygon_mumbai";
        case "optimism":
            return "rpc.ankr.com/optimism";
        case "optimism-goerli":
            return "rpc.ankr.com/optimism_testnet";
        case "optimism-sepolia":
            return "rpc.ankr.com/optimism_sepolia";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/**
 *  The **AnkrProvider** connects to the [[link-ankr]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-ankr-signup).
 */ class AnkrProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new AnkrProvider(chainId, this.apiKey);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    /**
     *  Returns a prepared request for connecting to %%network%% with
     *  %%apiKey%%.
     */ static getRequest(network, apiKey) {
        if (apiKey == null) {
            apiKey = defaultApiKey;
        }
        const request = new index_js_1.FetchRequest("https://".concat(getHost(network.name), "/").concat(apiKey));
        request.allowGzip = true;
        if (apiKey === defaultApiKey) {
            request.retryFunc = async (request, response, attempt)=>{
                (0, community_js_1.showThrottleMessage)("AnkrProvider");
                return true;
            };
        }
        return request;
    }
    getRpcError(payload, error) {
        if (payload.method === "eth_sendRawTransaction") {
            if (error && error.error && error.error.message === "INTERNAL_ERROR: could not replace existing tx") {
                error.error.message = "replacement transaction underpriced";
            }
        }
        return super.getRpcError(payload, error);
    }
    isCommunityResource() {
        return this.apiKey === defaultApiKey;
    }
    /**
     *  Create a new **AnkrProvider**.
     *
     *  By default connecting to ``mainnet`` with a highly throttled
     *  API key.
     */ constructor(_network, apiKey){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (apiKey == null) {
            apiKey = defaultApiKey;
        }
        // Ankr does not support filterId, so we force polling
        const options = {
            polling: true,
            staticNetwork: network
        };
        const request = AnkrProvider.getRequest(network, apiKey);
        super(request, network, options), /**
     *  The API key for the Ankr connection.
     */ _define_property._(this, "apiKey", void 0);
        (0, index_js_1.defineProperties)(this, {
            apiKey
        });
    }
}
exports.AnkrProvider = AnkrProvider; //# sourceMappingURL=provider-ankr.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-alchemy.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  [[link-alchemy]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Goerli Testnet (``goerli``)
 *  - Sepolia Testnet (``sepolia``)
 *  - Arbitrum (``arbitrum``)
 *  - Arbitrum Goerli Testnet (``arbitrum-goerli``)
 *  - Arbitrum Sepolia Testnet (``arbitrum-sepolia``)
 *  - Base (``base``)
 *  - Base Goerlia Testnet (``base-goerli``)
 *  - Base Sepolia Testnet (``base-sepolia``)
 *  - Optimism (``optimism``)
 *  - Optimism Goerli Testnet (``optimism-goerli``)
 *  - Optimism Sepolia Testnet (``optimism-sepolia``)
 *  - Polygon (``matic``)
 *  - Polygon Amoy Testnet (``matic-amoy``)
 *  - Polygon Mumbai Testnet (``matic-mumbai``)
 *
 *  @_subsection: api/providers/thirdparty:Alchemy  [providers-alchemy]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AlchemyProvider = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
const defaultApiKey = "_gg7wSSi0KMBsdKnGVfHDueq6xMB9EkC";
function getHost(name) {
    switch(name){
        case "mainnet":
            return "eth-mainnet.alchemyapi.io";
        case "goerli":
            return "eth-goerli.g.alchemy.com";
        case "sepolia":
            return "eth-sepolia.g.alchemy.com";
        case "arbitrum":
            return "arb-mainnet.g.alchemy.com";
        case "arbitrum-goerli":
            return "arb-goerli.g.alchemy.com";
        case "arbitrum-sepolia":
            return "arb-sepolia.g.alchemy.com";
        case "base":
            return "base-mainnet.g.alchemy.com";
        case "base-goerli":
            return "base-goerli.g.alchemy.com";
        case "base-sepolia":
            return "base-sepolia.g.alchemy.com";
        case "matic":
            return "polygon-mainnet.g.alchemy.com";
        case "matic-amoy":
            return "polygon-amoy.g.alchemy.com";
        case "matic-mumbai":
            return "polygon-mumbai.g.alchemy.com";
        case "optimism":
            return "opt-mainnet.g.alchemy.com";
        case "optimism-goerli":
            return "opt-goerli.g.alchemy.com";
        case "optimism-sepolia":
            return "opt-sepolia.g.alchemy.com";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/**
 *  The **AlchemyProvider** connects to the [[link-alchemy]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-alchemy-signup).
 *
 *  @_docloc: api/providers/thirdparty
 */ class AlchemyProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new AlchemyProvider(chainId, this.apiKey);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    async _perform(req) {
        // https://docs.alchemy.com/reference/trace-transaction
        if (req.method === "getTransactionResult") {
            const { trace, tx } = await (0, index_js_1.resolveProperties)({
                trace: this.send("trace_transaction", [
                    req.hash
                ]),
                tx: this.getTransaction(req.hash)
            });
            if (trace == null || tx == null) {
                return null;
            }
            let data;
            let error = false;
            try {
                data = trace[0].result.output;
                error = trace[0].error === "Reverted";
            } catch (error) {}
            if (data) {
                (0, index_js_1.assert)(!error, "an error occurred during transaction executions", "CALL_EXCEPTION", {
                    action: "getTransactionResult",
                    data,
                    reason: null,
                    transaction: tx,
                    invocation: null,
                    revert: null // @TODO
                });
                return data;
            }
            (0, index_js_1.assert)(false, "could not parse trace result", "BAD_DATA", {
                value: trace
            });
        }
        return await super._perform(req);
    }
    isCommunityResource() {
        return this.apiKey === defaultApiKey;
    }
    static getRequest(network, apiKey) {
        if (apiKey == null) {
            apiKey = defaultApiKey;
        }
        const request = new index_js_1.FetchRequest("https://".concat(getHost(network.name), "/v2/").concat(apiKey));
        request.allowGzip = true;
        if (apiKey === defaultApiKey) {
            request.retryFunc = async (request, response, attempt)=>{
                (0, community_js_1.showThrottleMessage)("alchemy");
                return true;
            };
        }
        return request;
    }
    constructor(_network, apiKey){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (apiKey == null) {
            apiKey = defaultApiKey;
        }
        const request = AlchemyProvider.getRequest(network, apiKey);
        super(request, network, {
            staticNetwork: network
        }), _define_property._(this, "apiKey", void 0);
        (0, index_js_1.defineProperties)(this, {
            apiKey
        });
    }
}
exports.AlchemyProvider = AlchemyProvider; //# sourceMappingURL=provider-alchemy.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-chainstack.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ChainstackProvider = void 0;
/**
 *  [[link-chainstack]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Arbitrum (``arbitrum``)
 *  - BNB Smart Chain Mainnet (``bnb``)
 *  - Polygon (``matic``)
 *
 *  @_subsection: api/providers/thirdparty:Chainstack  [providers-chainstack]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
function getApiKey(name) {
    switch(name){
        case "mainnet":
            return "39f1d67cedf8b7831010a665328c9197";
        case "arbitrum":
            return "0550c209db33c3abf4cc927e1e18cea1";
        case "bnb":
            return "98b5a77e531614387366f6fc5da097f8";
        case "matic":
            return "cd9d4d70377471aa7c142ec4a4205249";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
function getHost(name) {
    switch(name){
        case "mainnet":
            return "ethereum-mainnet.core.chainstack.com";
        case "arbitrum":
            return "arbitrum-mainnet.core.chainstack.com";
        case "bnb":
            return "bsc-mainnet.core.chainstack.com";
        case "matic":
            return "polygon-mainnet.core.chainstack.com";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/**
 *  The **ChainstackProvider** connects to the [[link-chainstack]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-chainstack).
 */ class ChainstackProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new ChainstackProvider(chainId, this.apiKey);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    isCommunityResource() {
        return this.apiKey === getApiKey(this._network.name);
    }
    /**
     *  Returns a prepared request for connecting to %%network%%
     *  with %%apiKey%% and %%projectSecret%%.
     */ static getRequest(network, apiKey) {
        if (apiKey == null) {
            apiKey = getApiKey(network.name);
        }
        const request = new index_js_1.FetchRequest("https://".concat(getHost(network.name), "/").concat(apiKey));
        request.allowGzip = true;
        if (apiKey === getApiKey(network.name)) {
            request.retryFunc = async (request, response, attempt)=>{
                (0, community_js_1.showThrottleMessage)("ChainstackProvider");
                return true;
            };
        }
        return request;
    }
    /**
     *  Creates a new **ChainstackProvider**.
     */ constructor(_network, apiKey){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (apiKey == null) {
            apiKey = getApiKey(network.name);
        }
        const request = ChainstackProvider.getRequest(network, apiKey);
        super(request, network, {
            staticNetwork: network
        }), /**
     *  The API key for the Chainstack connection.
     */ _define_property._(this, "apiKey", void 0);
        (0, index_js_1.defineProperties)(this, {
            apiKey
        });
    }
}
exports.ChainstackProvider = ChainstackProvider; //# sourceMappingURL=provider-chainstack.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-cloudflare.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  About Cloudflare
 *
 *  @_subsection: api/providers/thirdparty:Cloudflare  [providers-cloudflare]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CloudflareProvider = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
/**
 *  About Cloudflare...
 */ class CloudflareProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    constructor(_network){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        (0, index_js_1.assertArgument)(network.name === "mainnet", "unsupported network", "network", _network);
        super("https:/\/cloudflare-eth.com/", network, {
            staticNetwork: network
        });
    }
}
exports.CloudflareProvider = CloudflareProvider; //# sourceMappingURL=provider-cloudflare.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-etherscan.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  [[link-etherscan]] provides a third-party service for connecting to
 *  various blockchains over a combination of JSON-RPC and custom API
 *  endpoints.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Goerli Testnet (``goerli``)
 *  - Sepolia Testnet (``sepolia``)
 *  - Holesky Testnet (``holesky``)
 *  - Arbitrum (``arbitrum``)
 *  - Arbitrum Goerli Testnet (``arbitrum-goerli``)
 *  - Base (``base``)
 *  - Base Sepolia Testnet (``base-sepolia``)
 *  - BNB Smart Chain Mainnet (``bnb``)
 *  - BNB Smart Chain Testnet (``bnbt``)
 *  - Optimism (``optimism``)
 *  - Optimism Goerli Testnet (``optimism-goerli``)
 *  - Polygon (``matic``)
 *  - Polygon Mumbai Testnet (``matic-mumbai``)
 *  - Polygon Amoy Testnet (``matic-amoy``)
 *
 *  @_subsection api/providers/thirdparty:Etherscan  [providers-etherscan]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.EtherscanProvider = exports.EtherscanPlugin = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/abi/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/contract/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abstract_provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-provider.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const plugins_network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/plugins-network.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const THROTTLE = 2000;
function isPromise(value) {
    return value && typeof value.then === "function";
}
const EtherscanPluginId = "org.ethers.plugins.provider.Etherscan";
/**
 *  A Network can include an **EtherscanPlugin** to provide
 *  a custom base URL.
 *
 *  @_docloc: api/providers/thirdparty:Etherscan
 */ class EtherscanPlugin extends plugins_network_js_1.NetworkPlugin {
    clone() {
        return new EtherscanPlugin(this.baseUrl);
    }
    /**
     *  Creates a new **EtherscanProvider** which will use
     *  %%baseUrl%%.
     */ constructor(baseUrl){
        super(EtherscanPluginId), /**
     *  The Etherscan API base URL.
     */ _define_property._(this, "baseUrl", void 0);
        (0, index_js_4.defineProperties)(this, {
            baseUrl
        });
    }
}
exports.EtherscanPlugin = EtherscanPlugin;
const skipKeys = [
    "enableCcipRead"
];
let nextId = 1;
var _plugin = /*#__PURE__*/ new WeakMap();
/**
 *  The **EtherscanBaseProvider** is the super-class of
 *  [[EtherscanProvider]], which should generally be used instead.
 *
 *  Since the **EtherscanProvider** includes additional code for
 *  [[Contract]] access, in //rare cases// that contracts are not
 *  used, this class can reduce code size.
 *
 *  @_docloc: api/providers/thirdparty:Etherscan
 */ class EtherscanProvider extends abstract_provider_js_1.AbstractProvider {
    /**
     *  Returns the base URL.
     *
     *  If an [[EtherscanPlugin]] is configured on the
     *  [[EtherscanBaseProvider_network]], returns the plugin's
     *  baseUrl.
     *
     *  Deprecated; for Etherscan v2 the base is no longer a simply
     *  host, but instead a URL including a chainId parameter. Changing
     *  this to return a URL prefix could break some libraries, so it
     *  is left intact but will be removed in the future as it is unused.
     */ getBaseUrl() {
        if (_class_private_field_get._(this, _plugin)) {
            return _class_private_field_get._(this, _plugin).baseUrl;
        }
        switch(this.network.name){
            case "mainnet":
                return "https:/\/api.etherscan.io";
            case "goerli":
                return "https:/\/api-goerli.etherscan.io";
            case "sepolia":
                return "https:/\/api-sepolia.etherscan.io";
            case "holesky":
                return "https:/\/api-holesky.etherscan.io";
            case "arbitrum":
                return "https:/\/api.arbiscan.io";
            case "arbitrum-goerli":
                return "https:/\/api-goerli.arbiscan.io";
            case "base":
                return "https:/\/api.basescan.org";
            case "base-sepolia":
                return "https:/\/api-sepolia.basescan.org";
            case "bnb":
                return "https:/\/api.bscscan.com";
            case "bnbt":
                return "https:/\/api-testnet.bscscan.com";
            case "matic":
                return "https:/\/api.polygonscan.com";
            case "matic-amoy":
                return "https:/\/api-amoy.polygonscan.com";
            case "matic-mumbai":
                return "https:/\/api-testnet.polygonscan.com";
            case "optimism":
                return "https:/\/api-optimistic.etherscan.io";
            case "optimism-goerli":
                return "https:/\/api-goerli-optimistic.etherscan.io";
            default:
        }
        (0, index_js_4.assertArgument)(false, "unsupported network", "network", this.network);
    }
    /**
     *  Returns the URL for the %%module%% and %%params%%.
     */ getUrl(module, params) {
        let query = Object.keys(params).reduce((accum, key)=>{
            const value = params[key];
            if (value != null) {
                accum += "&".concat(key, "=").concat(value);
            }
            return accum;
        }, "");
        if (this.apiKey) {
            query += "&apikey=".concat(this.apiKey);
        }
        return "https://api.etherscan.io/v2/api?chainid=".concat(this.network.chainId, "&module=").concat(module).concat(query);
    }
    /**
     *  Returns the URL for using POST requests.
     */ getPostUrl() {
        return "https://api.etherscan.io/v2/api?chainid=".concat(this.network.chainId);
    }
    /**
     *  Returns the parameters for using POST requests.
     */ getPostData(module, params) {
        params.module = module;
        params.apikey = this.apiKey;
        params.chainid = this.network.chainId;
        return params;
    }
    async detectNetwork() {
        return this.network;
    }
    /**
     *  Resolves to the result of calling %%module%% with %%params%%.
     *
     *  If %%post%%, the request is made as a POST request.
     */ async fetch(module, params, post) {
        const id = nextId++;
        const url = post ? this.getPostUrl() : this.getUrl(module, params);
        const payload = post ? this.getPostData(module, params) : null;
        this.emit("debug", {
            action: "sendRequest",
            id,
            url,
            payload: payload
        });
        const request = new index_js_4.FetchRequest(url);
        request.setThrottleParams({
            slotInterval: 1000
        });
        request.retryFunc = (req, resp, attempt)=>{
            if (this.isCommunityResource()) {
                (0, community_js_1.showThrottleMessage)("Etherscan");
            }
            return Promise.resolve(true);
        };
        request.processFunc = async (request, response)=>{
            const result = response.hasBody() ? JSON.parse((0, index_js_4.toUtf8String)(response.body)) : {};
            const throttle = (typeof result.result === "string" ? result.result : "").toLowerCase().indexOf("rate limit") >= 0;
            if (module === "proxy") {
                // This JSON response indicates we are being throttled
                if (result && result.status == 0 && result.message == "NOTOK" && throttle) {
                    this.emit("debug", {
                        action: "receiveError",
                        id,
                        reason: "proxy-NOTOK",
                        error: result
                    });
                    response.throwThrottleError(result.result, THROTTLE);
                }
            } else {
                if (throttle) {
                    this.emit("debug", {
                        action: "receiveError",
                        id,
                        reason: "null result",
                        error: result.result
                    });
                    response.throwThrottleError(result.result, THROTTLE);
                }
            }
            return response;
        };
        if (payload) {
            request.setHeader("content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            request.body = Object.keys(payload).map((k)=>"".concat(k, "=").concat(payload[k])).join("&");
        }
        const response = await request.send();
        try {
            response.assertOk();
        } catch (error) {
            this.emit("debug", {
                action: "receiveError",
                id,
                error,
                reason: "assertOk"
            });
            (0, index_js_4.assert)(false, "response error", "SERVER_ERROR", {
                request,
                response
            });
        }
        if (!response.hasBody()) {
            this.emit("debug", {
                action: "receiveError",
                id,
                error: "missing body",
                reason: "null body"
            });
            (0, index_js_4.assert)(false, "missing response", "SERVER_ERROR", {
                request,
                response
            });
        }
        const result = JSON.parse((0, index_js_4.toUtf8String)(response.body));
        if (module === "proxy") {
            if (result.jsonrpc != "2.0") {
                this.emit("debug", {
                    action: "receiveError",
                    id,
                    result,
                    reason: "invalid JSON-RPC"
                });
                (0, index_js_4.assert)(false, "invalid JSON-RPC response (missing jsonrpc='2.0')", "SERVER_ERROR", {
                    request,
                    response,
                    info: {
                        result
                    }
                });
            }
            if (result.error) {
                this.emit("debug", {
                    action: "receiveError",
                    id,
                    result,
                    reason: "JSON-RPC error"
                });
                (0, index_js_4.assert)(false, "error response", "SERVER_ERROR", {
                    request,
                    response,
                    info: {
                        result
                    }
                });
            }
            this.emit("debug", {
                action: "receiveRequest",
                id,
                result
            });
            return result.result;
        } else {
            // getLogs, getHistory have weird success responses
            if (result.status == 0 && (result.message === "No records found" || result.message === "No transactions found")) {
                this.emit("debug", {
                    action: "receiveRequest",
                    id,
                    result
                });
                return result.result;
            }
            if (result.status != 1 || typeof result.message === "string" && !result.message.match(/^OK/)) {
                this.emit("debug", {
                    action: "receiveError",
                    id,
                    result
                });
                (0, index_js_4.assert)(false, "error response", "SERVER_ERROR", {
                    request,
                    response,
                    info: {
                        result
                    }
                });
            }
            this.emit("debug", {
                action: "receiveRequest",
                id,
                result
            });
            return result.result;
        }
    }
    /**
     *  Returns %%transaction%% normalized for the Etherscan API.
     */ _getTransactionPostData(transaction) {
        const result = {};
        for(let key in transaction){
            if (skipKeys.indexOf(key) >= 0) {
                continue;
            }
            if (transaction[key] == null) {
                continue;
            }
            let value = transaction[key];
            if (key === "type" && value === 0) {
                continue;
            }
            if (key === "blockTag" && value === "latest") {
                continue;
            }
            // Quantity-types require no leading zero, unless 0
            if (({
                type: true,
                gasLimit: true,
                gasPrice: true,
                maxFeePerGs: true,
                maxPriorityFeePerGas: true,
                nonce: true,
                value: true
            })[key]) {
                value = (0, index_js_4.toQuantity)(value);
            } else if (key === "accessList") {
                value = "[" + (0, index_js_3.accessListify)(value).map((set)=>{
                    return '{address:"'.concat(set.address, '",storageKeys:["').concat(set.storageKeys.join('","'), '"]}');
                }).join(",") + "]";
            } else if (key === "blobVersionedHashes") {
                if (value.length === 0) {
                    continue;
                }
                // @TODO: update this once the API supports blobs
                (0, index_js_4.assert)(false, "Etherscan API does not support blobVersionedHashes", "UNSUPPORTED_OPERATION", {
                    operation: "_getTransactionPostData",
                    info: {
                        transaction
                    }
                });
            } else {
                value = (0, index_js_4.hexlify)(value);
            }
            result[key] = value;
        }
        return result;
    }
    /**
     *  Throws the normalized Etherscan error.
     */ _checkError(req, error, transaction) {
        // Pull any message out if, possible
        let message = "";
        if ((0, index_js_4.isError)(error, "SERVER_ERROR")) {
            // Check for an error emitted by a proxy call
            try {
                message = error.info.result.error.message;
            } catch (e) {}
            if (!message) {
                try {
                    message = error.info.message;
                } catch (e) {}
            }
        }
        if (req.method === "estimateGas") {
            if (!message.match(/revert/i) && message.match(/insufficient funds/i)) {
                (0, index_js_4.assert)(false, "insufficient funds", "INSUFFICIENT_FUNDS", {
                    transaction: req.transaction
                });
            }
        }
        if (req.method === "call" || req.method === "estimateGas") {
            if (message.match(/execution reverted/i)) {
                let data = "";
                try {
                    data = error.info.result.error.data;
                } catch (error) {}
                const e = index_js_1.AbiCoder.getBuiltinCallException(req.method, req.transaction, data);
                e.info = {
                    request: req,
                    error
                };
                throw e;
            }
        }
        if (message) {
            if (req.method === "broadcastTransaction") {
                const transaction = index_js_3.Transaction.from(req.signedTransaction);
                if (message.match(/replacement/i) && message.match(/underpriced/i)) {
                    (0, index_js_4.assert)(false, "replacement fee too low", "REPLACEMENT_UNDERPRICED", {
                        transaction
                    });
                }
                if (message.match(/insufficient funds/)) {
                    (0, index_js_4.assert)(false, "insufficient funds for intrinsic transaction cost", "INSUFFICIENT_FUNDS", {
                        transaction
                    });
                }
                if (message.match(/same hash was already imported|transaction nonce is too low|nonce too low/)) {
                    (0, index_js_4.assert)(false, "nonce has already been used", "NONCE_EXPIRED", {
                        transaction
                    });
                }
            }
        }
        // Something we could not process
        throw error;
    }
    async _detectNetwork() {
        return this.network;
    }
    async _perform(req) {
        switch(req.method){
            case "chainId":
                return this.network.chainId;
            case "getBlockNumber":
                return this.fetch("proxy", {
                    action: "eth_blockNumber"
                });
            case "getGasPrice":
                return this.fetch("proxy", {
                    action: "eth_gasPrice"
                });
            case "getPriorityFee":
                // This is temporary until Etherscan completes support
                if (this.network.name === "mainnet") {
                    return "1000000000";
                } else if (this.network.name === "optimism") {
                    return "1000000";
                } else {
                    throw new Error("fallback onto the AbstractProvider default");
                }
            /* Working with Etherscan to get this added:
            try {
                const test = await this.fetch("proxy", {
                    action: "eth_maxPriorityFeePerGas"
                });
                console.log(test);
                return test;
            } catch (e) {
                console.log("DEBUG", e);
                throw e;
            }
            */ /* This might be safe; but due to rounding neither myself
               or Etherscan are necessarily comfortable with this. :)
            try {
                const result = await this.fetch("gastracker", { action: "gasoracle" });
                console.log(result);
                const gasPrice = parseUnits(result.SafeGasPrice, "gwei");
                const baseFee = parseUnits(result.suggestBaseFee, "gwei");
                const priorityFee = gasPrice - baseFee;
                if (priorityFee < 0) { throw new Error("negative priority fee; defer to abstract provider default"); }
                return priorityFee;
            } catch (error) {
                console.log("DEBUG", error);
                throw error;
            }
            */ case "getBalance":
                // Returns base-10 result
                return this.fetch("account", {
                    action: "balance",
                    address: req.address,
                    tag: req.blockTag
                });
            case "getTransactionCount":
                return this.fetch("proxy", {
                    action: "eth_getTransactionCount",
                    address: req.address,
                    tag: req.blockTag
                });
            case "getCode":
                return this.fetch("proxy", {
                    action: "eth_getCode",
                    address: req.address,
                    tag: req.blockTag
                });
            case "getStorage":
                return this.fetch("proxy", {
                    action: "eth_getStorageAt",
                    address: req.address,
                    position: req.position,
                    tag: req.blockTag
                });
            case "broadcastTransaction":
                return this.fetch("proxy", {
                    action: "eth_sendRawTransaction",
                    hex: req.signedTransaction
                }, true).catch((error)=>{
                    return this._checkError(req, error, req.signedTransaction);
                });
            case "getBlock":
                if ("blockTag" in req) {
                    return this.fetch("proxy", {
                        action: "eth_getBlockByNumber",
                        tag: req.blockTag,
                        boolean: req.includeTransactions ? "true" : "false"
                    });
                }
                (0, index_js_4.assert)(false, "getBlock by blockHash not supported by Etherscan", "UNSUPPORTED_OPERATION", {
                    operation: "getBlock(blockHash)"
                });
            case "getTransaction":
                return this.fetch("proxy", {
                    action: "eth_getTransactionByHash",
                    txhash: req.hash
                });
            case "getTransactionReceipt":
                return this.fetch("proxy", {
                    action: "eth_getTransactionReceipt",
                    txhash: req.hash
                });
            case "call":
                {
                    if (req.blockTag !== "latest") {
                        throw new Error("EtherscanProvider does not support blockTag for call");
                    }
                    const postData = this._getTransactionPostData(req.transaction);
                    postData.module = "proxy";
                    postData.action = "eth_call";
                    try {
                        return await this.fetch("proxy", postData, true);
                    } catch (error) {
                        return this._checkError(req, error, req.transaction);
                    }
                }
            case "estimateGas":
                {
                    const postData = this._getTransactionPostData(req.transaction);
                    postData.module = "proxy";
                    postData.action = "eth_estimateGas";
                    try {
                        return await this.fetch("proxy", postData, true);
                    } catch (error) {
                        return this._checkError(req, error, req.transaction);
                    }
                }
            /*
                        case "getLogs": {
                            // Needs to complain if more than one address is passed in
                            const args: Record<string, any> = { action: "getLogs" }
            
                            if (params.filter.fromBlock) {
                                args.fromBlock = checkLogTag(params.filter.fromBlock);
                            }
            
                            if (params.filter.toBlock) {
                                args.toBlock = checkLogTag(params.filter.toBlock);
                            }
            
                            if (params.filter.address) {
                                args.address = params.filter.address;
                            }
            
                            // @TODO: We can handle slightly more complicated logs using the logs API
                            if (params.filter.topics && params.filter.topics.length > 0) {
                                if (params.filter.topics.length > 1) {
                                    logger.throwError("unsupported topic count", Logger.Errors.UNSUPPORTED_OPERATION, { topics: params.filter.topics });
                                }
                                if (params.filter.topics.length === 1) {
                                    const topic0 = params.filter.topics[0];
                                    if (typeof(topic0) !== "string" || topic0.length !== 66) {
                                        logger.throwError("unsupported topic format", Logger.Errors.UNSUPPORTED_OPERATION, { topic0: topic0 });
                                    }
                                    args.topic0 = topic0;
                                }
                            }
            
                            const logs: Array<any> = await this.fetch("logs", args);
            
                            // Cache txHash => blockHash
                            let blocks: { [tag: string]: string } = {};
            
                            // Add any missing blockHash to the logs
                            for (let i = 0; i < logs.length; i++) {
                                const log = logs[i];
                                if (log.blockHash != null) { continue; }
                                if (blocks[log.blockNumber] == null) {
                                    const block = await this.getBlock(log.blockNumber);
                                    if (block) {
                                        blocks[log.blockNumber] = block.hash;
                                    }
                                }
            
                                log.blockHash = blocks[log.blockNumber];
                            }
            
                            return logs;
                        }
            */ default:
                break;
        }
        return super._perform(req);
    }
    async getNetwork() {
        return this.network;
    }
    /**
     *  Resolves to the current price of ether.
     *
     *  This returns ``0`` on any network other than ``mainnet``.
     */ async getEtherPrice() {
        if (this.network.name !== "mainnet") {
            return 0.0;
        }
        return parseFloat((await this.fetch("stats", {
            action: "ethprice"
        })).ethusd);
    }
    /**
     *  Resolves to a [Contract]] for %%address%%, using the
     *  Etherscan API to retreive the Contract ABI.
     */ async getContract(_address) {
        let address = this._getAddress(_address);
        if (isPromise(address)) {
            address = await address;
        }
        try {
            const resp = await this.fetch("contract", {
                action: "getabi",
                address
            });
            const abi = JSON.parse(resp);
            return new index_js_2.Contract(address, abi, this);
        } catch (error) {
            return null;
        }
    }
    isCommunityResource() {
        return this.apiKey == null;
    }
    /**
     *  Creates a new **EtherscanBaseProvider**.
     */ constructor(_network, _apiKey){
        const apiKey = _apiKey != null ? _apiKey : null;
        super(), /**
     *  The connected network.
     */ _define_property._(this, "network", void 0), /**
     *  The API key or null if using the community provided bandwidth.
     */ _define_property._(this, "apiKey", void 0), _class_private_field_init._(this, _plugin, {
            writable: true,
            value: void 0
        });
        const network = network_js_1.Network.from(_network);
        _class_private_field_set._(this, _plugin, network.getPlugin(EtherscanPluginId));
        (0, index_js_4.defineProperties)(this, {
            apiKey,
            network
        });
    }
}
exports.EtherscanProvider = EtherscanProvider; //# sourceMappingURL=provider-etherscan.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/ws-browser.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WebSocket = void 0;
function getGlobal() {
    if (typeof self !== 'undefined') {
        return self;
    }
    if (typeof window !== 'undefined') {
        return window;
    }
    if ("TURBOPACK compile-time truthy", 1) {
        return /*TURBOPACK member replacement*/ __turbopack_context__.g;
    }
    //TURBOPACK unreachable
    ;
}
;
const _WebSocket = getGlobal().WebSocket;
exports.WebSocket = _WebSocket; //# sourceMappingURL=ws-browser.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-socket.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
/**
 *  Generic long-lived socket provider.
 *
 *  Sub-classing notes
 *  - a sub-class MUST call the `_start()` method once connected
 *  - a sub-class MUST override the `_write(string)` method
 *  - a sub-class MUST call `_processMessage(string)` for each message
 *
 *  @_subsection: api/providers/abstract-provider:Socket Providers  [about-socketProvider]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SocketProvider = exports.SocketEventSubscriber = exports.SocketPendingSubscriber = exports.SocketBlockSubscriber = exports.SocketSubscriber = void 0;
const abstract_provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-provider.js [app-client] (ecmascript)");
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
var _provider = /*#__PURE__*/ new WeakMap(), _filter = /*#__PURE__*/ new WeakMap(), _filterId = /*#__PURE__*/ new WeakMap(), _paused = /*#__PURE__*/ new WeakMap(), _emitPromise = /*#__PURE__*/ new WeakMap();
/**
 *  A **SocketSubscriber** uses a socket transport to handle events and
 *  should use [[_emit]] to manage the events.
 */ class SocketSubscriber {
    /**
     *  The filter.
     */ get filter() {
        return JSON.parse(_class_private_field_get._(this, _filter));
    }
    start() {
        _class_private_field_set._(this, _filterId, _class_private_field_get._(this, _provider).send("eth_subscribe", this.filter).then((filterId)=>{
            ;
            _class_private_field_get._(this, _provider)._register(filterId, this);
            return filterId;
        }));
    }
    stop() {
        _class_private_field_get._(this, _filterId).then((filterId)=>{
            if (_class_private_field_get._(this, _provider).destroyed) {
                return;
            }
            _class_private_field_get._(this, _provider).send("eth_unsubscribe", [
                filterId
            ]);
        });
        _class_private_field_set._(this, _filterId, null);
    }
    // @TODO: pause should trap the current blockNumber, unsub, and on resume use getLogs
    //        and resume
    pause(dropWhilePaused) {
        (0, index_js_1.assert)(dropWhilePaused, "preserve logs while paused not supported by SocketSubscriber yet", "UNSUPPORTED_OPERATION", {
            operation: "pause(false)"
        });
        _class_private_field_set._(this, _paused, !!dropWhilePaused);
    }
    resume() {
        _class_private_field_set._(this, _paused, null);
    }
    /**
     *  @_ignore:
     */ _handleMessage(message) {
        if (_class_private_field_get._(this, _filterId) == null) {
            return;
        }
        if (_class_private_field_get._(this, _paused) === null) {
            let emitPromise = _class_private_field_get._(this, _emitPromise);
            if (emitPromise == null) {
                emitPromise = this._emit(_class_private_field_get._(this, _provider), message);
            } else {
                emitPromise = emitPromise.then(async ()=>{
                    await this._emit(_class_private_field_get._(this, _provider), message);
                });
            }
            _class_private_field_set._(this, _emitPromise, emitPromise.then(()=>{
                if (_class_private_field_get._(this, _emitPromise) === emitPromise) {
                    _class_private_field_set._(this, _emitPromise, null);
                }
            }));
        }
    }
    /**
     *  Sub-classes **must** override this to emit the events on the
     *  provider.
     */ async _emit(provider, message) {
        throw new Error("sub-classes must implemente this; _emit");
    }
    /**
     *  Creates a new **SocketSubscriber** attached to %%provider%% listening
     *  to %%filter%%.
     */ constructor(provider, filter){
        _class_private_field_init._(this, _provider, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _filter, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _filterId, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _paused, {
            writable: true,
            value: void 0
        });
        _class_private_field_init._(this, _emitPromise, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _provider, provider);
        _class_private_field_set._(this, _filter, JSON.stringify(filter));
        _class_private_field_set._(this, _filterId, null);
        _class_private_field_set._(this, _paused, null);
        _class_private_field_set._(this, _emitPromise, null);
    }
}
exports.SocketSubscriber = SocketSubscriber;
/**
 *  A **SocketBlockSubscriber** listens for ``newHeads`` events and emits
 *  ``"block"`` events.
 */ class SocketBlockSubscriber extends SocketSubscriber {
    async _emit(provider, message) {
        provider.emit("block", parseInt(message.number));
    }
    /**
     *  @_ignore:
     */ constructor(provider){
        super(provider, [
            "newHeads"
        ]);
    }
}
exports.SocketBlockSubscriber = SocketBlockSubscriber;
/**
 *  A **SocketPendingSubscriber** listens for pending transacitons and emits
 *  ``"pending"`` events.
 */ class SocketPendingSubscriber extends SocketSubscriber {
    async _emit(provider, message) {
        provider.emit("pending", message);
    }
    /**
     *  @_ignore:
     */ constructor(provider){
        super(provider, [
            "newPendingTransactions"
        ]);
    }
}
exports.SocketPendingSubscriber = SocketPendingSubscriber;
var _logFilter = /*#__PURE__*/ new WeakMap();
/**
 *  A **SocketEventSubscriber** listens for event logs.
 */ class SocketEventSubscriber extends SocketSubscriber {
    /**
     *  The filter.
     */ get logFilter() {
        return JSON.parse(_class_private_field_get._(this, _logFilter));
    }
    async _emit(provider, message) {
        provider.emit(this.logFilter, provider._wrapLog(message, provider._network));
    }
    /**
     *  @_ignore:
     */ constructor(provider, filter){
        super(provider, [
            "logs",
            filter
        ]), _class_private_field_init._(this, _logFilter, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _logFilter, JSON.stringify(filter));
    }
}
exports.SocketEventSubscriber = SocketEventSubscriber;
var _callbacks = /*#__PURE__*/ new WeakMap(), // Maps each filterId to its subscriber
_subs = /*#__PURE__*/ new WeakMap(), // If any events come in before a subscriber has finished
// registering, queue them
_pending = /*#__PURE__*/ new WeakMap();
/**
 *  A **SocketProvider** is backed by a long-lived connection over a
 *  socket, which can subscribe and receive real-time messages over
 *  its communication channel.
 */ class SocketProvider extends provider_jsonrpc_js_1.JsonRpcApiProvider {
    // This value is only valid after _start has been called
    /*
    get _network(): Network {
        if (this.#network == null) {
            throw new Error("this shouldn't happen");
        }
        return this.#network.clone();
    }
    */ _getSubscriber(sub) {
        switch(sub.type){
            case "close":
                return new abstract_provider_js_1.UnmanagedSubscriber("close");
            case "block":
                return new SocketBlockSubscriber(this);
            case "pending":
                return new SocketPendingSubscriber(this);
            case "event":
                return new SocketEventSubscriber(this, sub.filter);
            case "orphan":
                // Handled auto-matically within AbstractProvider
                // when the log.removed = true
                if (sub.filter.orphan === "drop-log") {
                    return new abstract_provider_js_1.UnmanagedSubscriber("drop-log");
                }
        }
        return super._getSubscriber(sub);
    }
    /**
     *  Register a new subscriber. This is used internalled by Subscribers
     *  and generally is unecessary unless extending capabilities.
     */ _register(filterId, subscriber) {
        _class_private_field_get._(this, _subs).set(filterId, subscriber);
        const pending = _class_private_field_get._(this, _pending).get(filterId);
        if (pending) {
            for (const message of pending){
                subscriber._handleMessage(message);
            }
            _class_private_field_get._(this, _pending).delete(filterId);
        }
    }
    async _send(payload) {
        // WebSocket provider doesn't accept batches
        (0, index_js_1.assertArgument)(!Array.isArray(payload), "WebSocket does not support batch send", "payload", payload);
        // @TODO: stringify payloads here and store to prevent mutations
        // Prepare a promise to respond to
        const promise = new Promise((resolve, reject)=>{
            _class_private_field_get._(this, _callbacks).set(payload.id, {
                payload,
                resolve,
                reject
            });
        });
        // Wait until the socket is connected before writing to it
        await this._waitUntilReady();
        // Write the request to the socket
        await this._write(JSON.stringify(payload));
        return [
            await promise
        ];
    }
    // Sub-classes must call this once they are connected
    /*
    async _start(): Promise<void> {
        if (this.#ready) { return; }

        for (const { payload } of this.#callbacks.values()) {
            await this._write(JSON.stringify(payload));
        }

        this.#ready = (async function() {
            await super._start();
        })();
    }
    */ /**
     *  Sub-classes **must** call this with messages received over their
     *  transport to be processed and dispatched.
     */ async _processMessage(message) {
        const result = JSON.parse(message);
        if (result && typeof result === "object" && "id" in result) {
            const callback = _class_private_field_get._(this, _callbacks).get(result.id);
            if (callback == null) {
                this.emit("error", (0, index_js_1.makeError)("received result for unknown id", "UNKNOWN_ERROR", {
                    reasonCode: "UNKNOWN_ID",
                    result
                }));
                return;
            }
            _class_private_field_get._(this, _callbacks).delete(result.id);
            callback.resolve(result);
        } else if (result && result.method === "eth_subscription") {
            const filterId = result.params.subscription;
            const subscriber = _class_private_field_get._(this, _subs).get(filterId);
            if (subscriber) {
                subscriber._handleMessage(result.params.result);
            } else {
                let pending = _class_private_field_get._(this, _pending).get(filterId);
                if (pending == null) {
                    pending = [];
                    _class_private_field_get._(this, _pending).set(filterId, pending);
                }
                pending.push(result.params.result);
            }
        } else {
            this.emit("error", (0, index_js_1.makeError)("received unexpected message", "UNKNOWN_ERROR", {
                reasonCode: "UNEXPECTED_MESSAGE",
                result
            }));
            return;
        }
    }
    /**
     *  Sub-classes **must** override this to send %%message%% over their
     *  transport.
     */ async _write(message) {
        throw new Error("sub-classes must override this");
    }
    /**
     *  Creates a new **SocketProvider** connected to %%network%%.
     *
     *  If unspecified, the network will be discovered.
     */ constructor(network, _options){
        // Copy the options
        const options = Object.assign({}, _options != null ? _options : {});
        // Support for batches is generally not supported for
        // connection-base providers; if this changes in the future
        // the _send should be updated to reflect this
        (0, index_js_1.assertArgument)(options.batchMaxCount == null || options.batchMaxCount === 1, "sockets-based providers do not support batches", "options.batchMaxCount", _options);
        options.batchMaxCount = 1;
        // Socket-based Providers (generally) cannot change their network,
        // since they have a long-lived connection; but let people override
        // this if they have just cause.
        if (options.staticNetwork == null) {
            options.staticNetwork = true;
        }
        super(network, options), _class_private_field_init._(this, _callbacks, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _subs, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _pending, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _callbacks, new Map());
        _class_private_field_set._(this, _subs, new Map());
        _class_private_field_set._(this, _pending, new Map());
    }
}
exports.SocketProvider = SocketProvider; //# sourceMappingURL=provider-socket.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-websocket.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WebSocketProvider = void 0;
const ws_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/ws-browser.js [app-client] (ecmascript)"); /*-browser*/ 
const provider_socket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-socket.js [app-client] (ecmascript)");
var _connect = /*#__PURE__*/ new WeakMap(), _websocket = /*#__PURE__*/ new WeakMap();
/**
 *  A JSON-RPC provider which is backed by a WebSocket.
 *
 *  WebSockets are often preferred because they retain a live connection
 *  to a server, which permits more instant access to events.
 *
 *  However, this incurs higher server infrasturture costs, so additional
 *  resources may be required to host your own WebSocket nodes and many
 *  third-party services charge additional fees for WebSocket endpoints.
 */ class WebSocketProvider extends provider_socket_js_1.SocketProvider {
    get websocket() {
        if (_class_private_field_get._(this, _websocket) == null) {
            throw new Error("websocket closed");
        }
        return _class_private_field_get._(this, _websocket);
    }
    async _write(message) {
        this.websocket.send(message);
    }
    async destroy() {
        if (_class_private_field_get._(this, _websocket) != null) {
            _class_private_field_get._(this, _websocket).close();
            _class_private_field_set._(this, _websocket, null);
        }
        super.destroy();
    }
    constructor(url, network, options){
        super(network, options), _class_private_field_init._(this, _connect, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _websocket, {
            writable: true,
            value: void 0
        });
        if (typeof url === "string") {
            _class_private_field_set._(this, _connect, ()=>{
                return new ws_js_1.WebSocket(url);
            });
            _class_private_field_set._(this, _websocket, _class_private_field_get._(this, _connect).call(this));
        } else if (typeof url === "function") {
            _class_private_field_set._(this, _connect, url);
            _class_private_field_set._(this, _websocket, url());
        } else {
            _class_private_field_set._(this, _connect, null);
            _class_private_field_set._(this, _websocket, url);
        }
        this.websocket.onopen = async ()=>{
            try {
                await this._start();
                this.resume();
            } catch (error) {
                console.log("failed to start WebsocketProvider", error);
            // @TODO: now what? Attempt reconnect?
            }
        };
        this.websocket.onmessage = (message)=>{
            this._processMessage(message.data);
        };
    /*
                this.websocket.onclose = (event) => {
                    // @TODO: What event.code should we reconnect on?
                    const reconnect = false;
                    if (reconnect) {
                        this.pause(true);
                        if (this.#connect) {
                            this.#websocket = this.#connect();
                            this.#websocket.onopen = ...
                            // @TODO: this requires the super class to rebroadcast; move it there
                        }
                        this._reconnect();
                    }
                };
        */ }
}
exports.WebSocketProvider = WebSocketProvider; //# sourceMappingURL=provider-websocket.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-infura.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InfuraProvider = exports.InfuraWebSocketProvider = void 0;
/**
 *  [[link-infura]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Goerli Testnet (``goerli``)
 *  - Sepolia Testnet (``sepolia``)
 *  - Arbitrum (``arbitrum``)
 *  - Arbitrum Goerli Testnet (``arbitrum-goerli``)
 *  - Arbitrum Sepolia Testnet (``arbitrum-sepolia``)
 *  - Base (``base``)
 *  - Base Goerlia Testnet (``base-goerli``)
 *  - Base Sepolia Testnet (``base-sepolia``)
 *  - BNB Smart Chain Mainnet (``bnb``)
 *  - BNB Smart Chain Testnet (``bnbt``)
 *  - Linea (``linea``)
 *  - Linea Goerli Testnet (``linea-goerli``)
 *  - Linea Sepolia Testnet (``linea-sepolia``)
 *  - Optimism (``optimism``)
 *  - Optimism Goerli Testnet (``optimism-goerli``)
 *  - Optimism Sepolia Testnet (``optimism-sepolia``)
 *  - Polygon (``matic``)
 *  - Polygon Amoy Testnet (``matic-amoy``)
 *  - Polygon Mumbai Testnet (``matic-mumbai``)
 *
 *  @_subsection: api/providers/thirdparty:INFURA  [providers-infura]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
const provider_websocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-websocket.js [app-client] (ecmascript)");
const defaultProjectId = "84842078b09946638c03157f83405213";
function getHost(name) {
    switch(name){
        case "mainnet":
            return "mainnet.infura.io";
        case "goerli":
            return "goerli.infura.io";
        case "sepolia":
            return "sepolia.infura.io";
        case "arbitrum":
            return "arbitrum-mainnet.infura.io";
        case "arbitrum-goerli":
            return "arbitrum-goerli.infura.io";
        case "arbitrum-sepolia":
            return "arbitrum-sepolia.infura.io";
        case "base":
            return "base-mainnet.infura.io";
        case "base-goerlia":
        case "base-goerli":
            return "base-goerli.infura.io";
        case "base-sepolia":
            return "base-sepolia.infura.io";
        case "bnb":
            return "bsc-mainnet.infura.io";
        case "bnbt":
            return "bsc-testnet.infura.io";
        case "linea":
            return "linea-mainnet.infura.io";
        case "linea-goerli":
            return "linea-goerli.infura.io";
        case "linea-sepolia":
            return "linea-sepolia.infura.io";
        case "matic":
            return "polygon-mainnet.infura.io";
        case "matic-amoy":
            return "polygon-amoy.infura.io";
        case "matic-mumbai":
            return "polygon-mumbai.infura.io";
        case "optimism":
            return "optimism-mainnet.infura.io";
        case "optimism-goerli":
            return "optimism-goerli.infura.io";
        case "optimism-sepolia":
            return "optimism-sepolia.infura.io";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/**
 *  The **InfuraWebSocketProvider** connects to the [[link-infura]]
 *  WebSocket end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-infura-signup).
 */ class InfuraWebSocketProvider extends provider_websocket_js_1.WebSocketProvider {
    isCommunityResource() {
        return this.projectId === defaultProjectId;
    }
    /**
     *  Creates a new **InfuraWebSocketProvider**.
     */ constructor(network, projectId){
        const provider = new InfuraProvider(network, projectId);
        const req = provider._getConnection();
        (0, index_js_1.assert)(!req.credentials, "INFURA WebSocket project secrets unsupported", "UNSUPPORTED_OPERATION", {
            operation: "InfuraProvider.getWebSocketProvider()"
        });
        const url = req.url.replace(/^http/i, "ws").replace("/v3/", "/ws/v3/");
        super(url, provider._network), /**
     *  The Project ID for the INFURA connection.
     */ _define_property._(this, "projectId", void 0), /**
     *  The Project Secret.
     *
     *  If null, no authenticated requests are made. This should not
     *  be used outside of private contexts.
     */ _define_property._(this, "projectSecret", void 0);
        (0, index_js_1.defineProperties)(this, {
            projectId: provider.projectId,
            projectSecret: provider.projectSecret
        });
    }
}
exports.InfuraWebSocketProvider = InfuraWebSocketProvider;
/**
 *  The **InfuraProvider** connects to the [[link-infura]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-infura-signup).
 */ class InfuraProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new InfuraProvider(chainId, this.projectId, this.projectSecret);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    isCommunityResource() {
        return this.projectId === defaultProjectId;
    }
    /**
     *  Creates a new **InfuraWebSocketProvider**.
     */ static getWebSocketProvider(network, projectId) {
        return new InfuraWebSocketProvider(network, projectId);
    }
    /**
     *  Returns a prepared request for connecting to %%network%%
     *  with %%projectId%% and %%projectSecret%%.
     */ static getRequest(network, projectId, projectSecret) {
        if (projectId == null) {
            projectId = defaultProjectId;
        }
        if (projectSecret == null) {
            projectSecret = null;
        }
        const request = new index_js_1.FetchRequest("https://".concat(getHost(network.name), "/v3/").concat(projectId));
        request.allowGzip = true;
        if (projectSecret) {
            request.setCredentials("", projectSecret);
        }
        if (projectId === defaultProjectId) {
            request.retryFunc = async (request, response, attempt)=>{
                (0, community_js_1.showThrottleMessage)("InfuraProvider");
                return true;
            };
        }
        return request;
    }
    /**
     *  Creates a new **InfuraProvider**.
     */ constructor(_network, projectId, projectSecret){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (projectId == null) {
            projectId = defaultProjectId;
        }
        if (projectSecret == null) {
            projectSecret = null;
        }
        const request = InfuraProvider.getRequest(network, projectId, projectSecret);
        super(request, network, {
            staticNetwork: network
        }), /**
     *  The Project ID for the INFURA connection.
     */ _define_property._(this, "projectId", void 0), /**
     *  The Project Secret.
     *
     *  If null, no authenticated requests are made. This should not
     *  be used outside of private contexts.
     */ _define_property._(this, "projectSecret", void 0);
        (0, index_js_1.defineProperties)(this, {
            projectId,
            projectSecret
        });
    }
}
exports.InfuraProvider = InfuraProvider; //# sourceMappingURL=provider-infura.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-quicknode.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
/**
 *  [[link-quicknode]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Goerli Testnet (``goerli``)
 *  - Sepolia Testnet (``sepolia``)
 *  - Holesky Testnet (``holesky``)
 *  - Arbitrum (``arbitrum``)
 *  - Arbitrum Goerli Testnet (``arbitrum-goerli``)
 *  - Arbitrum Sepolia Testnet (``arbitrum-sepolia``)
 *  - Base Mainnet (``base``);
 *  - Base Goerli Testnet (``base-goerli``);
 *  - Base Sepolia Testnet (``base-sepolia``);
 *  - BNB Smart Chain Mainnet (``bnb``)
 *  - BNB Smart Chain Testnet (``bnbt``)
 *  - Optimism (``optimism``)
 *  - Optimism Goerli Testnet (``optimism-goerli``)
 *  - Optimism Sepolia Testnet (``optimism-sepolia``)
 *  - Polygon (``matic``)
 *  - Polygon Mumbai Testnet (``matic-mumbai``)
 *
 *  @_subsection: api/providers/thirdparty:QuickNode  [providers-quicknode]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.QuickNodeProvider = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
const defaultToken = "919b412a057b5e9c9b6dce193c5a60242d6efadb";
function getHost(name) {
    switch(name){
        case "mainnet":
            return "ethers.quiknode.pro";
        case "goerli":
            return "ethers.ethereum-goerli.quiknode.pro";
        case "sepolia":
            return "ethers.ethereum-sepolia.quiknode.pro";
        case "holesky":
            return "ethers.ethereum-holesky.quiknode.pro";
        case "arbitrum":
            return "ethers.arbitrum-mainnet.quiknode.pro";
        case "arbitrum-goerli":
            return "ethers.arbitrum-goerli.quiknode.pro";
        case "arbitrum-sepolia":
            return "ethers.arbitrum-sepolia.quiknode.pro";
        case "base":
            return "ethers.base-mainnet.quiknode.pro";
        case "base-goerli":
            return "ethers.base-goerli.quiknode.pro";
        case "base-spolia":
            return "ethers.base-sepolia.quiknode.pro";
        case "bnb":
            return "ethers.bsc.quiknode.pro";
        case "bnbt":
            return "ethers.bsc-testnet.quiknode.pro";
        case "matic":
            return "ethers.matic.quiknode.pro";
        case "matic-mumbai":
            return "ethers.matic-testnet.quiknode.pro";
        case "optimism":
            return "ethers.optimism.quiknode.pro";
        case "optimism-goerli":
            return "ethers.optimism-goerli.quiknode.pro";
        case "optimism-sepolia":
            return "ethers.optimism-sepolia.quiknode.pro";
        case "xdai":
            return "ethers.xdai.quiknode.pro";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/*
@TODO:
  These networks are not currently present in the Network
  default included networks. Research them and ensure they
  are EVM compatible and work with ethers

  http://ethers.matic-amoy.quiknode.pro

  http://ethers.avalanche-mainnet.quiknode.pro
  http://ethers.avalanche-testnet.quiknode.pro
  http://ethers.blast-sepolia.quiknode.pro
  http://ethers.celo-mainnet.quiknode.pro
  http://ethers.fantom.quiknode.pro
  http://ethers.imx-demo.quiknode.pro
  http://ethers.imx-mainnet.quiknode.pro
  http://ethers.imx-testnet.quiknode.pro
  http://ethers.near-mainnet.quiknode.pro
  http://ethers.near-testnet.quiknode.pro
  http://ethers.nova-mainnet.quiknode.pro
  http://ethers.scroll-mainnet.quiknode.pro
  http://ethers.scroll-testnet.quiknode.pro
  http://ethers.tron-mainnet.quiknode.pro
  http://ethers.zkevm-mainnet.quiknode.pro
  http://ethers.zkevm-testnet.quiknode.pro
  http://ethers.zksync-mainnet.quiknode.pro
  http://ethers.zksync-testnet.quiknode.pro
*/ /**
 *  The **QuickNodeProvider** connects to the [[link-quicknode]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API token is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-quicknode).
 */ class QuickNodeProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new QuickNodeProvider(chainId, this.token);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    isCommunityResource() {
        return this.token === defaultToken;
    }
    /**
     *  Returns a new request prepared for %%network%% and the
     *  %%token%%.
     */ static getRequest(network, token) {
        if (token == null) {
            token = defaultToken;
        }
        const request = new index_js_1.FetchRequest("https://".concat(getHost(network.name), "/").concat(token));
        request.allowGzip = true;
        //if (projectSecret) { request.setCredentials("", projectSecret); }
        if (token === defaultToken) {
            request.retryFunc = async (request, response, attempt)=>{
                (0, community_js_1.showThrottleMessage)("QuickNodeProvider");
                return true;
            };
        }
        return request;
    }
    /**
     *  Creates a new **QuickNodeProvider**.
     */ constructor(_network, token){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (token == null) {
            token = defaultToken;
        }
        const request = QuickNodeProvider.getRequest(network, token);
        super(request, network, {
            staticNetwork: network
        }), /**
     *  The API token.
     */ _define_property._(this, "token", void 0);
        (0, index_js_1.defineProperties)(this, {
            token
        });
    }
}
exports.QuickNodeProvider = QuickNodeProvider; //# sourceMappingURL=provider-quicknode.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-fallback.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FallbackProvider = void 0;
/**
 *  A **FallbackProvider** provides resilience, security and performance
 *  in a way that is customizable and configurable.
 *
 *  @_section: api/providers/fallback-provider:Fallback Provider [about-fallback-provider]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abstract_provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-provider.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const BN_1 = BigInt("1");
const BN_2 = BigInt("2");
function shuffle(array) {
    for(let i = array.length - 1; i > 0; i--){
        const j = Math.floor(Math.random() * (i + 1));
        const tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }
}
function stall(duration) {
    return new Promise((resolve)=>{
        setTimeout(resolve, duration);
    });
}
function getTime() {
    return new Date().getTime();
}
function stringify(value) {
    return JSON.stringify(value, (key, value)=>{
        if (typeof value === "bigint") {
            return {
                type: "bigint",
                value: value.toString()
            };
        }
        return value;
    });
}
;
const defaultConfig = {
    stallTimeout: 400,
    priority: 1,
    weight: 1
};
const defaultState = {
    blockNumber: -2,
    requests: 0,
    lateResponses: 0,
    errorResponses: 0,
    outOfSync: -1,
    unsupportedEvents: 0,
    rollingDuration: 0,
    score: 0,
    _network: null,
    _updateNumber: null,
    _totalTime: 0,
    _lastFatalError: null,
    _lastFatalErrorTimestamp: 0
};
async function waitForSync(config, blockNumber) {
    while(config.blockNumber < 0 || config.blockNumber < blockNumber){
        if (!config._updateNumber) {
            config._updateNumber = (async ()=>{
                try {
                    const blockNumber = await config.provider.getBlockNumber();
                    if (blockNumber > config.blockNumber) {
                        config.blockNumber = blockNumber;
                    }
                } catch (error) {
                    config.blockNumber = -2;
                    config._lastFatalError = error;
                    config._lastFatalErrorTimestamp = getTime();
                }
                config._updateNumber = null;
            })();
        }
        await config._updateNumber;
        config.outOfSync++;
        if (config._lastFatalError) {
            break;
        }
    }
}
function _normalize(value) {
    if (value == null) {
        return "null";
    }
    if (Array.isArray(value)) {
        return "[" + value.map(_normalize).join(",") + "]";
    }
    if (typeof value === "object" && typeof value.toJSON === "function") {
        return _normalize(value.toJSON());
    }
    switch(typeof value){
        case "boolean":
        case "symbol":
            return value.toString();
        case "bigint":
        case "number":
            return BigInt(value).toString();
        case "string":
            return JSON.stringify(value);
        case "object":
            {
                const keys = Object.keys(value);
                keys.sort();
                return "{" + keys.map((k)=>"".concat(JSON.stringify(k), ":").concat(_normalize(value[k]))).join(",") + "}";
            }
    }
    console.log("Could not serialize", value);
    throw new Error("Hmm...");
}
function normalizeResult(method, value) {
    if ("error" in value) {
        const error = value.error;
        let tag;
        if ((0, index_js_1.isError)(error, "CALL_EXCEPTION")) {
            tag = _normalize(Object.assign({}, error, {
                shortMessage: undefined,
                reason: undefined,
                info: undefined
            }));
        } else {
            tag = _normalize(error);
        }
        return {
            tag,
            value: error
        };
    }
    const result = value.result;
    return {
        tag: _normalize(result),
        value: result
    };
}
// This strategy picks the highest weight result, as long as the weight is
// equal to or greater than quorum
function checkQuorum(quorum, results) {
    const tally = new Map();
    for (const { value, tag, weight } of results){
        const t = tally.get(tag) || {
            value,
            weight: 0
        };
        t.weight += weight;
        tally.set(tag, t);
    }
    let best = null;
    for (const r of tally.values()){
        if (r.weight >= quorum && (!best || r.weight > best.weight)) {
            best = r;
        }
    }
    if (best) {
        return best.value;
    }
    return undefined;
}
function getMedian(quorum, results) {
    let resultWeight = 0;
    const errorMap = new Map();
    let bestError = null;
    const values = [];
    for (const { value, tag, weight } of results){
        if (value instanceof Error) {
            const e = errorMap.get(tag) || {
                value,
                weight: 0
            };
            e.weight += weight;
            errorMap.set(tag, e);
            if (bestError == null || e.weight > bestError.weight) {
                bestError = e;
            }
        } else {
            values.push(BigInt(value));
            resultWeight += weight;
        }
    }
    if (resultWeight < quorum) {
        // We have quorum for an error
        if (bestError && bestError.weight >= quorum) {
            return bestError.value;
        }
        // We do not have quorum for a result
        return undefined;
    }
    // Get the sorted values
    values.sort((a, b)=>a < b ? -1 : b > a ? 1 : 0);
    const mid = Math.floor(values.length / 2);
    // Odd-length; take the middle value
    if (values.length % 2) {
        return values[mid];
    }
    // Even length; take the ceiling of the mean of the center two values
    return (values[mid - 1] + values[mid] + BN_1) / BN_2;
}
function getAnyResult(quorum, results) {
    // If any value or error meets quorum, that is our preferred result
    const result = checkQuorum(quorum, results);
    if (result !== undefined) {
        return result;
    }
    // Otherwise, do we have any result?
    for (const r of results){
        if (r.value) {
            return r.value;
        }
    }
    // Nope!
    return undefined;
}
function getFuzzyMode(quorum, results) {
    if (quorum === 1) {
        return (0, index_js_1.getNumber)(getMedian(quorum, results), "%internal");
    }
    const tally = new Map();
    const add = (result, weight)=>{
        const t = tally.get(result) || {
            result,
            weight: 0
        };
        t.weight += weight;
        tally.set(result, t);
    };
    for (const { weight, value } of results){
        const r = (0, index_js_1.getNumber)(value);
        add(r - 1, weight);
        add(r, weight);
        add(r + 1, weight);
    }
    let bestWeight = 0;
    let bestResult = undefined;
    for (const { weight, result } of tally.values()){
        // Use this result, if this result meets quorum and has either:
        // - a better weight
        // - or equal weight, but the result is larger
        if (weight >= quorum && (weight > bestWeight || bestResult != null && weight === bestWeight && result > bestResult)) {
            bestWeight = weight;
            bestResult = result;
        }
    }
    return bestResult;
}
var _configs = /*#__PURE__*/ new WeakMap(), _height = /*#__PURE__*/ new WeakMap(), _initialSyncPromise = /*#__PURE__*/ new WeakMap(), // Grab the next (random) config that is not already part of
// the running set
_getNextConfig = /*#__PURE__*/ new WeakSet(), // Adds a new runner (if available) to running.
_addRunner = /*#__PURE__*/ new WeakSet(), _initialSync = /*#__PURE__*/ new WeakSet(), _checkQuorum = /*#__PURE__*/ new WeakSet(), _waitForQuorum = /*#__PURE__*/ new WeakSet();
/**
 *  A **FallbackProvider** manages several [[Providers]] providing
 *  resilience by switching between slow or misbehaving nodes, security
 *  by requiring multiple backends to aggree and performance by allowing
 *  faster backends to respond earlier.
 *
 */ class FallbackProvider extends abstract_provider_js_1.AbstractProvider {
    get providerConfigs() {
        return _class_private_field_get._(this, _configs).map((c)=>{
            const result = Object.assign({}, c);
            for(const key in result){
                if (key[0] === "_") {
                    delete result[key];
                }
            }
            return result;
        });
    }
    async _detectNetwork() {
        return network_js_1.Network.from((0, index_js_1.getBigInt)(await this._perform({
            method: "chainId"
        })));
    }
    // @TODO: Add support to select providers to be the event subscriber
    //_getSubscriber(sub: Subscription): Subscriber {
    //    throw new Error("@TODO");
    //}
    /**
     *  Transforms a %%req%% into the correct method call on %%provider%%.
     */ async _translatePerform(provider, req) {
        switch(req.method){
            case "broadcastTransaction":
                return await provider.broadcastTransaction(req.signedTransaction);
            case "call":
                return await provider.call(Object.assign({}, req.transaction, {
                    blockTag: req.blockTag
                }));
            case "chainId":
                return (await provider.getNetwork()).chainId;
            case "estimateGas":
                return await provider.estimateGas(req.transaction);
            case "getBalance":
                return await provider.getBalance(req.address, req.blockTag);
            case "getBlock":
                {
                    const block = "blockHash" in req ? req.blockHash : req.blockTag;
                    return await provider.getBlock(block, req.includeTransactions);
                }
            case "getBlockNumber":
                return await provider.getBlockNumber();
            case "getCode":
                return await provider.getCode(req.address, req.blockTag);
            case "getGasPrice":
                return (await provider.getFeeData()).gasPrice;
            case "getPriorityFee":
                return (await provider.getFeeData()).maxPriorityFeePerGas;
            case "getLogs":
                return await provider.getLogs(req.filter);
            case "getStorage":
                return await provider.getStorage(req.address, req.position, req.blockTag);
            case "getTransaction":
                return await provider.getTransaction(req.hash);
            case "getTransactionCount":
                return await provider.getTransactionCount(req.address, req.blockTag);
            case "getTransactionReceipt":
                return await provider.getTransactionReceipt(req.hash);
            case "getTransactionResult":
                return await provider.getTransactionResult(req.hash);
        }
    }
    async _perform(req) {
        // Broadcasting a transaction is rare (ish) and already incurs
        // a cost on the user, so spamming is safe-ish. Just send it to
        // every backend.
        if (req.method === "broadcastTransaction") {
            // Once any broadcast provides a positive result, use it. No
            // need to wait for anyone else
            const results = _class_private_field_get._(this, _configs).map((c)=>null);
            const broadcasts = _class_private_field_get._(this, _configs).map(async (param, index)=>{
                let { provider, weight } = param;
                try {
                    const result = await provider._perform(req);
                    results[index] = Object.assign(normalizeResult(req.method, {
                        result
                    }), {
                        weight
                    });
                } catch (error) {
                    results[index] = Object.assign(normalizeResult(req.method, {
                        error
                    }), {
                        weight
                    });
                }
            });
            // As each promise finishes...
            while(true){
                // Check for a valid broadcast result
                const done = results.filter((r)=>r != null);
                for (const { value } of done){
                    if (!(value instanceof Error)) {
                        return value;
                    }
                }
                // Check for a legit broadcast error (one which we cannot
                // recover from; some nodes may return the following red
                // herring events:
                // - alredy seend (UNKNOWN_ERROR)
                // - NONCE_EXPIRED
                // - REPLACEMENT_UNDERPRICED
                const result = checkQuorum(this.quorum, results.filter((r)=>r != null));
                if ((0, index_js_1.isError)(result, "INSUFFICIENT_FUNDS")) {
                    throw result;
                }
                // Kick off the next provider (if any)
                const waiting = broadcasts.filter((b, i)=>results[i] == null);
                if (waiting.length === 0) {
                    break;
                }
                await Promise.race(waiting);
            }
            // Use standard quorum results; any result was returned above,
            // so this will find any error that met quorum if any
            const result = getAnyResult(this.quorum, results);
            (0, index_js_1.assert)(result !== undefined, "problem multi-broadcasting", "SERVER_ERROR", {
                request: "%sub-requests",
                info: {
                    request: req,
                    results: results.map(stringify)
                }
            });
            if (result instanceof Error) {
                throw result;
            }
            return result;
        }
        await _class_private_method_get._(this, _initialSync, initialSync).call(this);
        // Bootstrap enough runners to meet quorum
        const running = new Set();
        let inflightQuorum = 0;
        while(true){
            const runner = _class_private_method_get._(this, _addRunner, addRunner).call(this, running, req);
            if (runner == null) {
                break;
            }
            inflightQuorum += runner.config.weight;
            if (inflightQuorum >= this.quorum) {
                break;
            }
        }
        const result = await _class_private_method_get._(this, _waitForQuorum, waitForQuorum).call(this, running, req);
        // Track requests sent to a provider that are still
        // outstanding after quorum has been otherwise found
        for (const runner of running){
            if (runner.perform && runner.result == null) {
                runner.config.lateResponses++;
            }
        }
        return result;
    }
    async destroy() {
        for (const { provider } of _class_private_field_get._(this, _configs)){
            provider.destroy();
        }
        super.destroy();
    }
    /**
     *  Creates a new **FallbackProvider** with %%providers%% connected to
     *  %%network%%.
     *
     *  If a [[Provider]] is included in %%providers%%, defaults are used
     *  for the configuration.
     */ constructor(providers, network, options){
        super(network, options), _class_private_method_init._(this, _getNextConfig), _class_private_method_init._(this, _addRunner), // Initializes the blockNumber and network for each runner and
        // blocks until initialized
        _class_private_method_init._(this, _initialSync), _class_private_method_init._(this, _checkQuorum), _class_private_method_init._(this, _waitForQuorum), /**
     *  The number of backends that must agree on a value before it is
     *  accpeted.
     */ _define_property._(this, "quorum", void 0), /**
     *  @_ignore:
     */ _define_property._(this, "eventQuorum", void 0), /**
     *  @_ignore:
     */ _define_property._(this, "eventWorkers", void 0), _class_private_field_init._(this, _configs, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _height, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _initialSyncPromise, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _configs, providers.map((p)=>{
            if (p instanceof abstract_provider_js_1.AbstractProvider) {
                return Object.assign({
                    provider: p
                }, defaultConfig, defaultState);
            } else {
                return Object.assign({}, defaultConfig, p, defaultState);
            }
        }));
        _class_private_field_set._(this, _height, -2);
        _class_private_field_set._(this, _initialSyncPromise, null);
        if (options && options.quorum != null) {
            this.quorum = options.quorum;
        } else {
            this.quorum = Math.ceil(_class_private_field_get._(this, _configs).reduce((accum, config)=>{
                accum += config.weight;
                return accum;
            }, 0) / 2);
        }
        this.eventQuorum = 1;
        this.eventWorkers = 1;
        (0, index_js_1.assertArgument)(this.quorum <= _class_private_field_get._(this, _configs).reduce((a, c)=>a + c.weight, 0), "quorum exceed provider weight", "quorum", this.quorum);
    }
}
function getNextConfig(running) {
    // @TODO: Maybe do a check here to favour (heavily) providers that
    //        do not require waitForSync and disfavour providers that
    //        seem down-ish or are behaving slowly
    const configs = Array.from(running).map((r)=>r.config);
    // Shuffle the states, sorted by priority
    const allConfigs = _class_private_field_get._(this, _configs).slice();
    shuffle(allConfigs);
    allConfigs.sort((a, b)=>a.priority - b.priority);
    for (const config of allConfigs){
        if (config._lastFatalError) {
            continue;
        }
        if (configs.indexOf(config) === -1) {
            return config;
        }
    }
    return null;
}
function addRunner(running, req) {
    const config = _class_private_method_get._(this, _getNextConfig, getNextConfig).call(this, running);
    // No runners available
    if (config == null) {
        return null;
    }
    // Create a new runner
    const runner = {
        config,
        result: null,
        didBump: false,
        perform: null,
        staller: null
    };
    const now = getTime();
    // Start performing this operation
    runner.perform = (async ()=>{
        try {
            config.requests++;
            const result = await this._translatePerform(config.provider, req);
            runner.result = {
                result
            };
        } catch (error) {
            config.errorResponses++;
            runner.result = {
                error
            };
        }
        const dt = getTime() - now;
        config._totalTime += dt;
        config.rollingDuration = 0.95 * config.rollingDuration + 0.05 * dt;
        runner.perform = null;
    })();
    // Start a staller; when this times out, it's time to force
    // kicking off another runner because we are taking too long
    runner.staller = (async ()=>{
        await stall(config.stallTimeout);
        runner.staller = null;
    })();
    running.add(runner);
    return runner;
}
async function initialSync() {
    let initialSync = _class_private_field_get._(this, _initialSyncPromise);
    if (!initialSync) {
        const promises = [];
        _class_private_field_get._(this, _configs).forEach((config)=>{
            promises.push((async ()=>{
                await waitForSync(config, 0);
                if (!config._lastFatalError) {
                    config._network = await config.provider.getNetwork();
                }
            })());
        });
        _class_private_field_set._(this, _initialSyncPromise, initialSync = (async ()=>{
            // Wait for all providers to have a block number and network
            await Promise.all(promises);
            // Check all the networks match
            let chainId = null;
            for (const config of _class_private_field_get._(this, _configs)){
                if (config._lastFatalError) {
                    continue;
                }
                const network = config._network;
                if (chainId == null) {
                    chainId = network.chainId;
                } else if (network.chainId !== chainId) {
                    (0, index_js_1.assert)(false, "cannot mix providers on different networks", "UNSUPPORTED_OPERATION", {
                        operation: "new FallbackProvider"
                    });
                }
            }
        })());
    }
    await initialSync;
}
async function checkQuorum1(running, req) {
    // Get all the result objects
    const results = [];
    for (const runner of running){
        if (runner.result != null) {
            const { tag, value } = normalizeResult(req.method, runner.result);
            results.push({
                tag,
                value,
                weight: runner.config.weight
            });
        }
    }
    // Are there enough results to event meet quorum?
    if (results.reduce((a, r)=>a + r.weight, 0) < this.quorum) {
        return undefined;
    }
    switch(req.method){
        case "getBlockNumber":
            {
                // We need to get the bootstrap block height
                if (_class_private_field_get._(this, _height) === -2) {
                    _class_private_field_set._(this, _height, Math.ceil((0, index_js_1.getNumber)(getMedian(this.quorum, _class_private_field_get._(this, _configs).filter((c)=>!c._lastFatalError).map((c)=>({
                            value: c.blockNumber,
                            tag: (0, index_js_1.getNumber)(c.blockNumber).toString(),
                            weight: c.weight
                        }))))));
                }
                // Find the mode across all the providers, allowing for
                // a little drift between block heights
                const mode = getFuzzyMode(this.quorum, results);
                if (mode === undefined) {
                    return undefined;
                }
                if (mode > _class_private_field_get._(this, _height)) {
                    _class_private_field_set._(this, _height, mode);
                }
                return _class_private_field_get._(this, _height);
            }
        case "getGasPrice":
        case "getPriorityFee":
        case "estimateGas":
            return getMedian(this.quorum, results);
        case "getBlock":
            // Pending blocks are in the mempool and already
            // quite untrustworthy; just grab anything
            if ("blockTag" in req && req.blockTag === "pending") {
                return getAnyResult(this.quorum, results);
            }
            return checkQuorum(this.quorum, results);
        case "call":
        case "chainId":
        case "getBalance":
        case "getTransactionCount":
        case "getCode":
        case "getStorage":
        case "getTransaction":
        case "getTransactionReceipt":
        case "getLogs":
            return checkQuorum(this.quorum, results);
        case "broadcastTransaction":
            return getAnyResult(this.quorum, results);
    }
    (0, index_js_1.assert)(false, "unsupported method", "UNSUPPORTED_OPERATION", {
        operation: "_perform(".concat(stringify(req.method), ")")
    });
}
async function waitForQuorum(running, req) {
    if (running.size === 0) {
        throw new Error("no runners?!");
    }
    // Any promises that are interesting to watch for; an expired stall
    // or a successful perform
    const interesting = [];
    let newRunners = 0;
    for (const runner of running){
        // No responses, yet; keep an eye on it
        if (runner.perform) {
            interesting.push(runner.perform);
        }
        // Still stalling...
        if (runner.staller) {
            interesting.push(runner.staller);
            continue;
        }
        // This runner has already triggered another runner
        if (runner.didBump) {
            continue;
        }
        // Got a response (result or error) or stalled; kick off another runner
        runner.didBump = true;
        newRunners++;
    }
    // Check if we have reached quorum on a result (or error)
    const value = await _class_private_method_get._(this, _checkQuorum, checkQuorum1).call(this, running, req);
    if (value !== undefined) {
        if (value instanceof Error) {
            throw value;
        }
        return value;
    }
    // Add any new runners, because a staller timed out or a result
    // or error response came in.
    for(let i = 0; i < newRunners; i++){
        _class_private_method_get._(this, _addRunner, addRunner).call(this, running, req);
    }
    // All providers have returned, and we have no result
    (0, index_js_1.assert)(interesting.length > 0, "quorum not met", "SERVER_ERROR", {
        request: "%sub-requests",
        info: {
            request: req,
            results: Array.from(running).map((r)=>stringify(r.result))
        }
    });
    // Wait for someone to either complete its perform or stall out
    await Promise.race(interesting);
    // This is recursive, but at worst case the depth is 2x the
    // number of providers (each has a perform and a staller)
    return await _class_private_method_get._(this, _waitForQuorum, waitForQuorum).call(this, running, req);
}
exports.FallbackProvider = FallbackProvider; //# sourceMappingURL=provider-fallback.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/default-provider.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getDefaultProvider = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const provider_ankr_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-ankr.js [app-client] (ecmascript)");
const provider_alchemy_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-alchemy.js [app-client] (ecmascript)");
//import { BlockscoutProvider } from "./provider-blockscout.js";
const provider_chainstack_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-chainstack.js [app-client] (ecmascript)");
const provider_cloudflare_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-cloudflare.js [app-client] (ecmascript)");
const provider_etherscan_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-etherscan.js [app-client] (ecmascript)");
const provider_infura_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-infura.js [app-client] (ecmascript)");
//import { PocketProvider } from "./provider-pocket.js";
const provider_quicknode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-quicknode.js [app-client] (ecmascript)");
const provider_fallback_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-fallback.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_websocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-websocket.js [app-client] (ecmascript)");
function isWebSocketLike(value) {
    return value && typeof value.send === "function" && typeof value.close === "function";
}
const Testnets = "goerli kovan sepolia classicKotti optimism-goerli arbitrum-goerli matic-mumbai bnbt".split(" ");
/**
 *  Returns a default provider for %%network%%.
 *
 *  If %%network%% is a [[WebSocketLike]] or string that begins with
 *  ``"ws:"`` or ``"wss:"``, a [[WebSocketProvider]] is returned backed
 *  by that WebSocket or URL.
 *
 *  If %%network%% is a string that begins with ``"HTTP:"`` or ``"HTTPS:"``,
 *  a [[JsonRpcProvider]] is returned connected to that URL.
 *
 *  Otherwise, a default provider is created backed by well-known public
 *  Web3 backends (such as [[link-infura]]) using community-provided API
 *  keys.
 *
 *  The %%options%% allows specifying custom API keys per backend (setting
 *  an API key to ``"-"`` will omit that provider) and ``options.exclusive``
 *  can be set to either a backend name or and array of backend names, which
 *  will whitelist **only** those backends.
 *
 *  Current backend strings supported are:
 *  - ``"alchemy"``
 *  - ``"ankr"``
 *  - ``"cloudflare"``
 *  - ``"chainstack"``
 *  - ``"etherscan"``
 *  - ``"infura"``
 *  - ``"publicPolygon"``
 *  - ``"quicknode"``
 *
 *  @example:
 *    // Connect to a local Geth node
 *    provider = getDefaultProvider("http://localhost:8545/");
 *
 *    // Connect to Ethereum mainnet with any current and future
 *    // third-party services available
 *    provider = getDefaultProvider("mainnet");
 *
 *    // Connect to Polygon, but only allow Etherscan and
 *    // INFURA and use "MY_API_KEY" in calls to Etherscan.
 *    provider = getDefaultProvider("matic", {
 *      etherscan: "MY_API_KEY",
 *      exclusive: [ "etherscan", "infura" ]
 *    });
 */ function getDefaultProvider(network, options) {
    if (options == null) {
        options = {};
    }
    const allowService = (name)=>{
        if (options[name] === "-") {
            return false;
        }
        if (typeof options.exclusive === "string") {
            return name === options.exclusive;
        }
        if (Array.isArray(options.exclusive)) {
            return options.exclusive.indexOf(name) !== -1;
        }
        return true;
    };
    if (typeof network === "string" && network.match(/^https?:/)) {
        return new provider_jsonrpc_js_1.JsonRpcProvider(network);
    }
    if (typeof network === "string" && network.match(/^wss?:/) || isWebSocketLike(network)) {
        return new provider_websocket_js_1.WebSocketProvider(network);
    }
    // Get the network and name, if possible
    let staticNetwork = null;
    try {
        staticNetwork = network_js_1.Network.from(network);
    } catch (error) {}
    const providers = [];
    if (allowService("publicPolygon") && staticNetwork) {
        if (staticNetwork.name === "matic") {
            providers.push(new provider_jsonrpc_js_1.JsonRpcProvider("https:/\/polygon-rpc.com/", staticNetwork, {
                staticNetwork
            }));
        } else if (staticNetwork.name === "matic-amoy") {
            providers.push(new provider_jsonrpc_js_1.JsonRpcProvider("https:/\/rpc-amoy.polygon.technology/", staticNetwork, {
                staticNetwork
            }));
        }
    }
    if (allowService("alchemy")) {
        try {
            providers.push(new provider_alchemy_js_1.AlchemyProvider(network, options.alchemy));
        } catch (error) {}
    }
    if (allowService("ankr") && options.ankr != null) {
        try {
            providers.push(new provider_ankr_js_1.AnkrProvider(network, options.ankr));
        } catch (error) {}
    }
    /* Temporarily remove until custom error issue is fixed
        if (allowService("blockscout")) {
            try {
                providers.push(new BlockscoutProvider(network, options.blockscout));
            } catch (error) { }
        }
    */ if (allowService("chainstack")) {
        try {
            providers.push(new provider_chainstack_js_1.ChainstackProvider(network, options.chainstack));
        } catch (error) {}
    }
    if (allowService("cloudflare")) {
        try {
            providers.push(new provider_cloudflare_js_1.CloudflareProvider(network));
        } catch (error) {}
    }
    if (allowService("etherscan")) {
        try {
            providers.push(new provider_etherscan_js_1.EtherscanProvider(network, options.etherscan));
        } catch (error) {}
    }
    if (allowService("infura")) {
        try {
            let projectId = options.infura;
            let projectSecret = undefined;
            if (typeof projectId === "object") {
                projectSecret = projectId.projectSecret;
                projectId = projectId.projectId;
            }
            providers.push(new provider_infura_js_1.InfuraProvider(network, projectId, projectSecret));
        } catch (error) {}
    }
    /*
        if (options.pocket !== "-") {
            try {
                let appId = options.pocket;
                let secretKey: undefined | string = undefined;
                let loadBalancer: undefined | boolean = undefined;
                if (typeof(appId) === "object") {
                    loadBalancer = !!appId.loadBalancer;
                    secretKey = appId.secretKey;
                    appId = appId.appId;
                }
                providers.push(new PocketProvider(network, appId, secretKey, loadBalancer));
            } catch (error) { console.log(error); }
        }
    */ if (allowService("quicknode")) {
        try {
            let token = options.quicknode;
            providers.push(new provider_quicknode_js_1.QuickNodeProvider(network, token));
        } catch (error) {}
    }
    (0, index_js_1.assert)(providers.length, "unsupported default network", "UNSUPPORTED_OPERATION", {
        operation: "getDefaultProvider"
    });
    // No need for a FallbackProvider
    if (providers.length === 1) {
        return providers[0];
    }
    // We use the floor because public third-party providers can be unreliable,
    // so a low number of providers with a large quorum will fail too often
    let quorum = Math.floor(providers.length / 2);
    if (quorum > 2) {
        quorum = 2;
    }
    // Testnets don't need as strong a security gaurantee and speed is
    // more useful during testing
    if (staticNetwork && Testnets.indexOf(staticNetwork.name) !== -1) {
        quorum = 1;
    }
    // Provided override qorum takes priority
    if (options && options.quorum) {
        quorum = options.quorum;
    }
    return new provider_fallback_js_1.FallbackProvider(providers, undefined, {
        quorum
    });
}
exports.getDefaultProvider = getDefaultProvider; //# sourceMappingURL=default-provider.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/signer-noncemanager.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_field_update = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_update.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NonceManager = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const abstract_signer_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-signer.js [app-client] (ecmascript)");
var _noncePromise = /*#__PURE__*/ new WeakMap(), _delta = /*#__PURE__*/ new WeakMap();
/**
 *  A **NonceManager** wraps another [[Signer]] and automatically manages
 *  the nonce, ensuring serialized and sequential nonces are used during
 *  transaction.
 */ class NonceManager extends abstract_signer_js_1.AbstractSigner {
    async getAddress() {
        return this.signer.getAddress();
    }
    connect(provider) {
        return new NonceManager(this.signer.connect(provider));
    }
    async getNonce(blockTag) {
        if (blockTag === "pending") {
            if (_class_private_field_get._(this, _noncePromise) == null) {
                _class_private_field_set._(this, _noncePromise, super.getNonce("pending"));
            }
            const delta = _class_private_field_get._(this, _delta);
            return await _class_private_field_get._(this, _noncePromise) + delta;
        }
        return super.getNonce(blockTag);
    }
    /**
     *  Manually increment the nonce. This may be useful when managng
     *  offline transactions.
     */ increment() {
        _class_private_field_update._(this, _delta).value++;
    }
    /**
     *  Resets the nonce, causing the **NonceManager** to reload the current
     *  nonce from the blockchain on the next transaction.
     */ reset() {
        _class_private_field_set._(this, _delta, 0);
        _class_private_field_set._(this, _noncePromise, null);
    }
    async sendTransaction(tx) {
        const noncePromise = this.getNonce("pending");
        this.increment();
        tx = await this.signer.populateTransaction(tx);
        tx.nonce = await noncePromise;
        // @TODO: Maybe handle interesting/recoverable errors?
        // Like don't increment if the tx was certainly not sent
        return await this.signer.sendTransaction(tx);
    }
    signTransaction(tx) {
        return this.signer.signTransaction(tx);
    }
    signMessage(message) {
        return this.signer.signMessage(message);
    }
    signTypedData(domain, types, value) {
        return this.signer.signTypedData(domain, types, value);
    }
    /**
     *  Creates a new **NonceManager** to manage %%signer%%.
     */ constructor(signer){
        super(signer.provider), /**
     *  The Signer being managed.
     */ _define_property._(this, "signer", void 0), _class_private_field_init._(this, _noncePromise, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _delta, {
            writable: true,
            value: void 0
        });
        (0, index_js_1.defineProperties)(this, {
            signer
        });
        _class_private_field_set._(this, _noncePromise, null);
        _class_private_field_set._(this, _delta, 0);
    }
}
exports.NonceManager = NonceManager; //# sourceMappingURL=signer-noncemanager.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-browser.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BrowserProvider = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
;
var _request = /*#__PURE__*/ new WeakMap(), _providerInfo = /*#__PURE__*/ new WeakMap();
/**
 *  A **BrowserProvider** is intended to wrap an injected provider which
 *  adheres to the [[link-eip-1193]] standard, which most (if not all)
 *  currently do.
 */ class BrowserProvider extends provider_jsonrpc_js_1.JsonRpcApiPollingProvider {
    get providerInfo() {
        return _class_private_field_get._(this, _providerInfo);
    }
    async send(method, params) {
        await this._start();
        return await super.send(method, params);
    }
    async _send(payload) {
        (0, index_js_1.assertArgument)(!Array.isArray(payload), "EIP-1193 does not support batch request", "payload", payload);
        try {
            const result = await _class_private_field_get._(this, _request).call(this, payload.method, payload.params || []);
            return [
                {
                    id: payload.id,
                    result
                }
            ];
        } catch (e) {
            return [
                {
                    id: payload.id,
                    error: {
                        code: e.code,
                        data: e.data,
                        message: e.message
                    }
                }
            ];
        }
    }
    getRpcError(payload, error) {
        error = JSON.parse(JSON.stringify(error));
        // EIP-1193 gives us some machine-readable error codes, so rewrite
        // them into Ethers standard errors.
        switch(error.error.code || -1){
            case 4001:
                error.error.message = "ethers-user-denied: ".concat(error.error.message);
                break;
            case 4200:
                error.error.message = "ethers-unsupported: ".concat(error.error.message);
                break;
        }
        return super.getRpcError(payload, error);
    }
    /**
     *  Resolves to ``true`` if the provider manages the %%address%%.
     */ async hasSigner(address) {
        if (address == null) {
            address = 0;
        }
        const accounts = await this.send("eth_accounts", []);
        if (typeof address === "number") {
            return accounts.length > address;
        }
        address = address.toLowerCase();
        return accounts.filter((a)=>a.toLowerCase() === address).length !== 0;
    }
    async getSigner(address) {
        if (address == null) {
            address = 0;
        }
        if (!await this.hasSigner(address)) {
            try {
                await _class_private_field_get._(this, _request).call(this, "eth_requestAccounts", []);
            } catch (error) {
                const payload = error.payload;
                throw this.getRpcError(payload, {
                    id: payload.id,
                    error
                });
            }
        }
        return await super.getSigner(address);
    }
    /**
     *  Discover and connect to a Provider in the Browser using the
     *  [[link-eip-6963]] discovery mechanism. If no providers are
     *  present, ``null`` is resolved.
     */ static async discover(options) {
        if (options == null) {
            options = {};
        }
        if (options.provider) {
            return new BrowserProvider(options.provider);
        }
        const context = options.window ? options.window : typeof window !== "undefined" ? window : null;
        if (context == null) {
            return null;
        }
        const anyProvider = options.anyProvider;
        if (anyProvider && context.ethereum) {
            return new BrowserProvider(context.ethereum);
        }
        if (!("addEventListener" in context && "dispatchEvent" in context && "removeEventListener" in context)) {
            return null;
        }
        const timeout = options.timeout ? options.timeout : 300;
        if (timeout === 0) {
            return null;
        }
        return await new Promise((resolve, reject)=>{
            let found = [];
            const addProvider = (event)=>{
                found.push(event.detail);
                if (anyProvider) {
                    finalize();
                }
            };
            const finalize = ()=>{
                clearTimeout(timer);
                if (found.length) {
                    // If filtering is provided:
                    if (options && options.filter) {
                        // Call filter, with a copies of found provider infos
                        const filtered = options.filter(found.map((i)=>Object.assign({}, i.info)));
                        if (filtered == null) {
                            // No provider selected
                            resolve(null);
                        } else if (filtered instanceof BrowserProvider) {
                            // Custom provider created
                            resolve(filtered);
                        } else {
                            // Find the matching provider
                            let match = null;
                            if (filtered.uuid) {
                                const matches = found.filter((f)=>filtered.uuid === f.info.uuid);
                                // @TODO: What should happen if multiple values
                                //        for the same UUID?
                                match = matches[0];
                            }
                            if (match) {
                                const { provider, info } = match;
                                resolve(new BrowserProvider(provider, undefined, {
                                    providerInfo: info
                                }));
                            } else {
                                reject((0, index_js_1.makeError)("filter returned unknown info", "UNSUPPORTED_OPERATION", {
                                    value: filtered
                                }));
                            }
                        }
                    } else {
                        // Pick the first found provider
                        const { provider, info } = found[0];
                        resolve(new BrowserProvider(provider, undefined, {
                            providerInfo: info
                        }));
                    }
                } else {
                    // Nothing found
                    resolve(null);
                }
                context.removeEventListener("eip6963:announceProvider", addProvider);
            };
            const timer = setTimeout(()=>{
                finalize();
            }, timeout);
            context.addEventListener("eip6963:announceProvider", addProvider);
            context.dispatchEvent(new Event("eip6963:requestProvider"));
        });
    }
    /**
     *  Connect to the %%ethereum%% provider, optionally forcing the
     *  %%network%%.
     */ constructor(ethereum, network, _options){
        // Copy the options
        const options = Object.assign({}, _options != null ? _options : {}, {
            batchMaxCount: 1
        });
        (0, index_js_1.assertArgument)(ethereum && ethereum.request, "invalid EIP-1193 provider", "ethereum", ethereum);
        super(network, options), _class_private_field_init._(this, _request, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _providerInfo, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _providerInfo, null);
        if (_options && _options.providerInfo) {
            _class_private_field_set._(this, _providerInfo, _options.providerInfo);
        }
        _class_private_field_set._(this, _request, async (method, params)=>{
            const payload = {
                method,
                params
            };
            this.emit("debug", {
                action: "sendEip1193Request",
                payload
            });
            try {
                const result = await ethereum.request(payload);
                this.emit("debug", {
                    action: "receiveEip1193Result",
                    result
                });
                return result;
            } catch (e) {
                const error = new Error(e.message);
                error.code = e.code;
                error.data = e.data;
                error.payload = payload;
                this.emit("debug", {
                    action: "receiveEip1193Error",
                    error
                });
                throw error;
            }
        });
    }
}
exports.BrowserProvider = BrowserProvider; //# sourceMappingURL=provider-browser.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-blockscout.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BlockscoutProvider = void 0;
/**
 *  [[link-blockscout]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Sepolia Testnet (``sepolia``)
 *  - Holesky Testnet (``holesky``)
 *  - Ethereum Classic (``classic``)
 *  - Arbitrum (``arbitrum``)
 *  - Base (``base``)
 *  - Base Sepolia Testnet (``base-sepolia``)
 *  - Gnosis (``xdai``)
 *  - Optimism (``optimism``)
 *  - Optimism Sepolia Testnet (``optimism-sepolia``)
 *  - Polygon (``matic``)
 *
 *  @_subsection: api/providers/thirdparty:Blockscout  [providers-blockscout]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
function getUrl(name) {
    switch(name){
        case "mainnet":
            return "https:/\/eth.blockscout.com/api/eth-rpc";
        case "sepolia":
            return "https:/\/eth-sepolia.blockscout.com/api/eth-rpc";
        case "holesky":
            return "https:/\/eth-holesky.blockscout.com/api/eth-rpc";
        case "classic":
            return "https:/\/etc.blockscout.com/api/eth-rpc";
        case "arbitrum":
            return "https:/\/arbitrum.blockscout.com/api/eth-rpc";
        case "base":
            return "https:/\/base.blockscout.com/api/eth-rpc";
        case "base-sepolia":
            return "https:/\/base-sepolia.blockscout.com/api/eth-rpc";
        case "matic":
            return "https:/\/polygon.blockscout.com/api/eth-rpc";
        case "optimism":
            return "https:/\/optimism.blockscout.com/api/eth-rpc";
        case "optimism-sepolia":
            return "https:/\/optimism-sepolia.blockscout.com/api/eth-rpc";
        case "xdai":
            return "https:/\/gnosis.blockscout.com/api/eth-rpc";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/**
 *  The **BlockscoutProvider** connects to the [[link-blockscout]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-blockscout).
 */ class BlockscoutProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new BlockscoutProvider(chainId, this.apiKey);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    isCommunityResource() {
        return this.apiKey === null;
    }
    getRpcRequest(req) {
        // Blockscout enforces the TAG argument for estimateGas
        const resp = super.getRpcRequest(req);
        if (resp && resp.method === "eth_estimateGas" && resp.args.length == 1) {
            resp.args = resp.args.slice();
            resp.args.push("latest");
        }
        return resp;
    }
    getRpcError(payload, _error) {
        const error = _error ? _error.error : null;
        // Blockscout currently drops the VM result and replaces it with a
        // human-readable string, so we need to make it machine-readable.
        if (error && error.code === -32015 && !(0, index_js_1.isHexString)(error.data || "", true)) {
            const panicCodes = {
                "assert(false)": "01",
                "arithmetic underflow or overflow": "11",
                "division or modulo by zero": "12",
                "out-of-bounds array access; popping on an empty array": "31",
                "out-of-bounds access of an array or bytesN": "32"
            };
            let panicCode = "";
            if (error.message === "VM execution error.") {
                // eth_call passes this message
                panicCode = panicCodes[error.data] || "";
            } else if (panicCodes[error.message || ""]) {
                panicCode = panicCodes[error.message || ""];
            }
            if (panicCode) {
                error.message += " (reverted: ".concat(error.data, ")");
                error.data = "0x4e487b7100000000000000000000000000000000000000000000000000000000000000" + panicCode;
            }
        } else if (error && error.code === -32000) {
            if (error.message === "wrong transaction nonce") {
                error.message += " (nonce too low)";
            }
        }
        return super.getRpcError(payload, _error);
    }
    /**
     *  Returns a prepared request for connecting to %%network%%
     *  with %%apiKey%%.
     */ static getRequest(network) {
        const request = new index_js_1.FetchRequest(getUrl(network.name));
        request.allowGzip = true;
        return request;
    }
    /**
     *  Creates a new **BlockscoutProvider**.
     */ constructor(_network, apiKey){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (apiKey == null) {
            apiKey = null;
        }
        const request = BlockscoutProvider.getRequest(network);
        super(request, network, {
            staticNetwork: network
        }), /**
     *  The API key.
     */ _define_property._(this, "apiKey", void 0);
        (0, index_js_1.defineProperties)(this, {
            apiKey
        });
    }
}
exports.BlockscoutProvider = BlockscoutProvider; //# sourceMappingURL=provider-blockscout.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-pocket.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PocketProvider = void 0;
/**
 *  [[link-pocket]] provides a third-party service for connecting to
 *  various blockchains over JSON-RPC.
 *
 *  **Supported Networks**
 *
 *  - Ethereum Mainnet (``mainnet``)
 *  - Goerli Testnet (``goerli``)
 *  - Polygon (``matic``)
 *  - Arbitrum (``arbitrum``)
 *
 *  @_subsection: api/providers/thirdparty:Pocket  [providers-pocket]
 */ const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
const network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
const provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
const defaultApplicationId = "62e1ad51b37b8e00394bda3b";
function getHost(name) {
    switch(name){
        case "mainnet":
            return "eth-mainnet.gateway.pokt.network";
        case "goerli":
            return "eth-goerli.gateway.pokt.network";
        case "matic":
            return "poly-mainnet.gateway.pokt.network";
        case "matic-mumbai":
            return "polygon-mumbai-rpc.gateway.pokt.network";
    }
    (0, index_js_1.assertArgument)(false, "unsupported network", "network", name);
}
/**
 *  The **PocketProvider** connects to the [[link-pocket]]
 *  JSON-RPC end-points.
 *
 *  By default, a highly-throttled API key is used, which is
 *  appropriate for quick prototypes and simple scripts. To
 *  gain access to an increased rate-limit, it is highly
 *  recommended to [sign up here](link-pocket-signup).
 */ class PocketProvider extends provider_jsonrpc_js_1.JsonRpcProvider {
    _getProvider(chainId) {
        try {
            return new PocketProvider(chainId, this.applicationId, this.applicationSecret);
        } catch (error) {}
        return super._getProvider(chainId);
    }
    /**
     *  Returns a prepared request for connecting to %%network%% with
     *  %%applicationId%%.
     */ static getRequest(network, applicationId, applicationSecret) {
        if (applicationId == null) {
            applicationId = defaultApplicationId;
        }
        const request = new index_js_1.FetchRequest("https://".concat(getHost(network.name), "/v1/lb/").concat(applicationId));
        request.allowGzip = true;
        if (applicationSecret) {
            request.setCredentials("", applicationSecret);
        }
        if (applicationId === defaultApplicationId) {
            request.retryFunc = async (request, response, attempt)=>{
                (0, community_js_1.showThrottleMessage)("PocketProvider");
                return true;
            };
        }
        return request;
    }
    isCommunityResource() {
        return this.applicationId === defaultApplicationId;
    }
    /**
     *  Create a new **PocketProvider**.
     *
     *  By default connecting to ``mainnet`` with a highly throttled
     *  API key.
     */ constructor(_network, applicationId, applicationSecret){
        if (_network == null) {
            _network = "mainnet";
        }
        const network = network_js_1.Network.from(_network);
        if (applicationId == null) {
            applicationId = defaultApplicationId;
        }
        if (applicationSecret == null) {
            applicationSecret = null;
        }
        const options = {
            staticNetwork: network
        };
        const request = PocketProvider.getRequest(network, applicationId, applicationSecret);
        super(request, network, options), /**
     *  The Application ID for the Pocket connection.
     */ _define_property._(this, "applicationId", void 0), /**
     *  The Application Secret for making authenticated requests
     *  to the Pocket connection.
     */ _define_property._(this, "applicationSecret", void 0);
        (0, index_js_1.defineProperties)(this, {
            applicationId,
            applicationSecret
        });
    }
}
exports.PocketProvider = PocketProvider; //# sourceMappingURL=provider-pocket.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-ipcsocket-browser.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.IpcSocketProvider = void 0;
const IpcSocketProvider = undefined;
exports.IpcSocketProvider = IpcSocketProvider; //# sourceMappingURL=provider-ipcsocket-browser.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 *  A **Provider** provides a connection to the blockchain, whch can be
 *  used to query its current state, simulate execution and send transactions
 *  to update the state.
 *
 *  It is one of the most fundamental components of interacting with a
 *  blockchain application, and there are many ways to connect, such as over
 *  HTTP, WebSockets or injected providers such as [MetaMask](link-metamask).
 *
 *  @_section: api/providers:Providers  [about-providers]
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SocketEventSubscriber = exports.SocketPendingSubscriber = exports.SocketBlockSubscriber = exports.SocketSubscriber = exports.WebSocketProvider = exports.SocketProvider = exports.IpcSocketProvider = exports.QuickNodeProvider = exports.PocketProvider = exports.InfuraWebSocketProvider = exports.InfuraProvider = exports.EtherscanPlugin = exports.EtherscanProvider = exports.ChainstackProvider = exports.CloudflareProvider = exports.AnkrProvider = exports.BlockscoutProvider = exports.AlchemyProvider = exports.BrowserProvider = exports.JsonRpcSigner = exports.JsonRpcProvider = exports.JsonRpcApiProvider = exports.FallbackProvider = exports.copyRequest = exports.TransactionResponse = exports.TransactionReceipt = exports.Log = exports.FeeData = exports.Block = exports.FetchUrlFeeDataNetworkPlugin = exports.FeeDataNetworkPlugin = exports.EnsPlugin = exports.GasCostPlugin = exports.NetworkPlugin = exports.NonceManager = exports.Network = exports.MulticoinProviderPlugin = exports.EnsResolver = exports.getDefaultProvider = exports.showThrottleMessage = exports.VoidSigner = exports.AbstractSigner = exports.UnmanagedSubscriber = exports.AbstractProvider = void 0;
var abstract_provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-provider.js [app-client] (ecmascript)");
Object.defineProperty(exports, "AbstractProvider", {
    enumerable: true,
    get: function() {
        return abstract_provider_js_1.AbstractProvider;
    }
});
Object.defineProperty(exports, "UnmanagedSubscriber", {
    enumerable: true,
    get: function() {
        return abstract_provider_js_1.UnmanagedSubscriber;
    }
});
var abstract_signer_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/abstract-signer.js [app-client] (ecmascript)");
Object.defineProperty(exports, "AbstractSigner", {
    enumerable: true,
    get: function() {
        return abstract_signer_js_1.AbstractSigner;
    }
});
Object.defineProperty(exports, "VoidSigner", {
    enumerable: true,
    get: function() {
        return abstract_signer_js_1.VoidSigner;
    }
});
var community_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/community.js [app-client] (ecmascript)");
Object.defineProperty(exports, "showThrottleMessage", {
    enumerable: true,
    get: function() {
        return community_js_1.showThrottleMessage;
    }
});
var default_provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/default-provider.js [app-client] (ecmascript)");
Object.defineProperty(exports, "getDefaultProvider", {
    enumerable: true,
    get: function() {
        return default_provider_js_1.getDefaultProvider;
    }
});
var ens_resolver_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/ens-resolver.js [app-client] (ecmascript)");
Object.defineProperty(exports, "EnsResolver", {
    enumerable: true,
    get: function() {
        return ens_resolver_js_1.EnsResolver;
    }
});
Object.defineProperty(exports, "MulticoinProviderPlugin", {
    enumerable: true,
    get: function() {
        return ens_resolver_js_1.MulticoinProviderPlugin;
    }
});
var network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/network.js [app-client] (ecmascript)");
Object.defineProperty(exports, "Network", {
    enumerable: true,
    get: function() {
        return network_js_1.Network;
    }
});
var signer_noncemanager_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/signer-noncemanager.js [app-client] (ecmascript)");
Object.defineProperty(exports, "NonceManager", {
    enumerable: true,
    get: function() {
        return signer_noncemanager_js_1.NonceManager;
    }
});
var plugins_network_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/plugins-network.js [app-client] (ecmascript)");
Object.defineProperty(exports, "NetworkPlugin", {
    enumerable: true,
    get: function() {
        return plugins_network_js_1.NetworkPlugin;
    }
});
Object.defineProperty(exports, "GasCostPlugin", {
    enumerable: true,
    get: function() {
        return plugins_network_js_1.GasCostPlugin;
    }
});
Object.defineProperty(exports, "EnsPlugin", {
    enumerable: true,
    get: function() {
        return plugins_network_js_1.EnsPlugin;
    }
});
Object.defineProperty(exports, "FeeDataNetworkPlugin", {
    enumerable: true,
    get: function() {
        return plugins_network_js_1.FeeDataNetworkPlugin;
    }
});
Object.defineProperty(exports, "FetchUrlFeeDataNetworkPlugin", {
    enumerable: true,
    get: function() {
        return plugins_network_js_1.FetchUrlFeeDataNetworkPlugin;
    }
});
var provider_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider.js [app-client] (ecmascript)");
Object.defineProperty(exports, "Block", {
    enumerable: true,
    get: function() {
        return provider_js_1.Block;
    }
});
Object.defineProperty(exports, "FeeData", {
    enumerable: true,
    get: function() {
        return provider_js_1.FeeData;
    }
});
Object.defineProperty(exports, "Log", {
    enumerable: true,
    get: function() {
        return provider_js_1.Log;
    }
});
Object.defineProperty(exports, "TransactionReceipt", {
    enumerable: true,
    get: function() {
        return provider_js_1.TransactionReceipt;
    }
});
Object.defineProperty(exports, "TransactionResponse", {
    enumerable: true,
    get: function() {
        return provider_js_1.TransactionResponse;
    }
});
Object.defineProperty(exports, "copyRequest", {
    enumerable: true,
    get: function() {
        return provider_js_1.copyRequest;
    }
});
var provider_fallback_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-fallback.js [app-client] (ecmascript)");
Object.defineProperty(exports, "FallbackProvider", {
    enumerable: true,
    get: function() {
        return provider_fallback_js_1.FallbackProvider;
    }
});
var provider_jsonrpc_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-jsonrpc.js [app-client] (ecmascript)");
Object.defineProperty(exports, "JsonRpcApiProvider", {
    enumerable: true,
    get: function() {
        return provider_jsonrpc_js_1.JsonRpcApiProvider;
    }
});
Object.defineProperty(exports, "JsonRpcProvider", {
    enumerable: true,
    get: function() {
        return provider_jsonrpc_js_1.JsonRpcProvider;
    }
});
Object.defineProperty(exports, "JsonRpcSigner", {
    enumerable: true,
    get: function() {
        return provider_jsonrpc_js_1.JsonRpcSigner;
    }
});
var provider_browser_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-browser.js [app-client] (ecmascript)");
Object.defineProperty(exports, "BrowserProvider", {
    enumerable: true,
    get: function() {
        return provider_browser_js_1.BrowserProvider;
    }
});
var provider_alchemy_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-alchemy.js [app-client] (ecmascript)");
Object.defineProperty(exports, "AlchemyProvider", {
    enumerable: true,
    get: function() {
        return provider_alchemy_js_1.AlchemyProvider;
    }
});
var provider_blockscout_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-blockscout.js [app-client] (ecmascript)");
Object.defineProperty(exports, "BlockscoutProvider", {
    enumerable: true,
    get: function() {
        return provider_blockscout_js_1.BlockscoutProvider;
    }
});
var provider_ankr_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-ankr.js [app-client] (ecmascript)");
Object.defineProperty(exports, "AnkrProvider", {
    enumerable: true,
    get: function() {
        return provider_ankr_js_1.AnkrProvider;
    }
});
var provider_cloudflare_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-cloudflare.js [app-client] (ecmascript)");
Object.defineProperty(exports, "CloudflareProvider", {
    enumerable: true,
    get: function() {
        return provider_cloudflare_js_1.CloudflareProvider;
    }
});
var provider_chainstack_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-chainstack.js [app-client] (ecmascript)");
Object.defineProperty(exports, "ChainstackProvider", {
    enumerable: true,
    get: function() {
        return provider_chainstack_js_1.ChainstackProvider;
    }
});
var provider_etherscan_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-etherscan.js [app-client] (ecmascript)");
Object.defineProperty(exports, "EtherscanProvider", {
    enumerable: true,
    get: function() {
        return provider_etherscan_js_1.EtherscanProvider;
    }
});
Object.defineProperty(exports, "EtherscanPlugin", {
    enumerable: true,
    get: function() {
        return provider_etherscan_js_1.EtherscanPlugin;
    }
});
var provider_infura_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-infura.js [app-client] (ecmascript)");
Object.defineProperty(exports, "InfuraProvider", {
    enumerable: true,
    get: function() {
        return provider_infura_js_1.InfuraProvider;
    }
});
Object.defineProperty(exports, "InfuraWebSocketProvider", {
    enumerable: true,
    get: function() {
        return provider_infura_js_1.InfuraWebSocketProvider;
    }
});
var provider_pocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-pocket.js [app-client] (ecmascript)");
Object.defineProperty(exports, "PocketProvider", {
    enumerable: true,
    get: function() {
        return provider_pocket_js_1.PocketProvider;
    }
});
var provider_quicknode_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-quicknode.js [app-client] (ecmascript)");
Object.defineProperty(exports, "QuickNodeProvider", {
    enumerable: true,
    get: function() {
        return provider_quicknode_js_1.QuickNodeProvider;
    }
});
const provider_ipcsocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-ipcsocket-browser.js [app-client] (ecmascript)"); /*-browser*/ 
Object.defineProperty(exports, "IpcSocketProvider", {
    enumerable: true,
    get: function() {
        return provider_ipcsocket_js_1.IpcSocketProvider;
    }
});
var provider_socket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-socket.js [app-client] (ecmascript)");
Object.defineProperty(exports, "SocketProvider", {
    enumerable: true,
    get: function() {
        return provider_socket_js_1.SocketProvider;
    }
});
var provider_websocket_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-websocket.js [app-client] (ecmascript)");
Object.defineProperty(exports, "WebSocketProvider", {
    enumerable: true,
    get: function() {
        return provider_websocket_js_1.WebSocketProvider;
    }
});
var provider_socket_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/provider-socket.js [app-client] (ecmascript)");
Object.defineProperty(exports, "SocketSubscriber", {
    enumerable: true,
    get: function() {
        return provider_socket_js_2.SocketSubscriber;
    }
});
Object.defineProperty(exports, "SocketBlockSubscriber", {
    enumerable: true,
    get: function() {
        return provider_socket_js_2.SocketBlockSubscriber;
    }
});
Object.defineProperty(exports, "SocketPendingSubscriber", {
    enumerable: true,
    get: function() {
        return provider_socket_js_2.SocketPendingSubscriber;
    }
});
Object.defineProperty(exports, "SocketEventSubscriber", {
    enumerable: true,
    get: function() {
        return provider_socket_js_2.SocketEventSubscriber;
    }
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wallet/base-wallet.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BaseWallet = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/address/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
const index_js_3 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/providers/index.js [app-client] (ecmascript)");
const index_js_4 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/transaction/index.js [app-client] (ecmascript)");
const index_js_5 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
var _signingKey = /*#__PURE__*/ new WeakMap();
/**
 *  The **BaseWallet** is a stream-lined implementation of a
 *  [[Signer]] that operates with a private key.
 *
 *  It is preferred to use the [[Wallet]] class, as it offers
 *  additional functionality and simplifies loading a variety
 *  of JSON formats, Mnemonic Phrases, etc.
 *
 *  This class may be of use for those attempting to implement
 *  a minimal Signer.
 */ class BaseWallet extends index_js_3.AbstractSigner {
    // Store private values behind getters to reduce visibility
    // in console.log
    /**
     *  The [[SigningKey]] used for signing payloads.
     */ get signingKey() {
        return _class_private_field_get._(this, _signingKey);
    }
    /**
     *  The private key for this wallet.
     */ get privateKey() {
        return this.signingKey.privateKey;
    }
    async getAddress() {
        return this.address;
    }
    connect(provider) {
        return new BaseWallet(_class_private_field_get._(this, _signingKey), provider);
    }
    async signTransaction(tx) {
        tx = (0, index_js_3.copyRequest)(tx);
        // Replace any Addressable or ENS name with an address
        const { to, from } = await (0, index_js_5.resolveProperties)({
            to: tx.to ? (0, index_js_1.resolveAddress)(tx.to, this) : undefined,
            from: tx.from ? (0, index_js_1.resolveAddress)(tx.from, this) : undefined
        });
        if (to != null) {
            tx.to = to;
        }
        if (from != null) {
            tx.from = from;
        }
        if (tx.from != null) {
            (0, index_js_5.assertArgument)((0, index_js_1.getAddress)(tx.from) === this.address, "transaction from address mismatch", "tx.from", tx.from);
            delete tx.from;
        }
        // Build the transaction
        const btx = index_js_4.Transaction.from(tx);
        btx.signature = this.signingKey.sign(btx.unsignedHash);
        return btx.serialized;
    }
    async signMessage(message) {
        return this.signMessageSync(message);
    }
    // @TODO: Add a secialized signTx and signTyped sync that enforces
    // all parameters are known?
    /**
     *  Returns the signature for %%message%% signed with this wallet.
     */ signMessageSync(message) {
        return this.signingKey.sign((0, index_js_2.hashMessage)(message)).serialized;
    }
    /**
     *  Returns the Authorization for %%auth%%.
     */ authorizeSync(auth) {
        (0, index_js_5.assertArgument)(typeof auth.address === "string", "invalid address for authorizeSync", "auth.address", auth);
        const signature = this.signingKey.sign((0, index_js_2.hashAuthorization)(auth));
        return Object.assign({}, {
            address: (0, index_js_1.getAddress)(auth.address),
            nonce: (0, index_js_5.getBigInt)(auth.nonce || 0),
            chainId: (0, index_js_5.getBigInt)(auth.chainId || 0)
        }, {
            signature
        });
    }
    /**
     *  Resolves to the Authorization for %%auth%%.
     */ async authorize(auth) {
        auth = Object.assign({}, auth, {
            address: await (0, index_js_1.resolveAddress)(auth.address, this)
        });
        return this.authorizeSync(await this.populateAuthorization(auth));
    }
    async signTypedData(domain, types, value) {
        // Populate any ENS names
        const populated = await index_js_2.TypedDataEncoder.resolveNames(domain, types, value, async (name)=>{
            // @TODO: this should use resolveName; addresses don't
            //        need a provider
            (0, index_js_5.assert)(this.provider != null, "cannot resolve ENS names without a provider", "UNSUPPORTED_OPERATION", {
                operation: "resolveName",
                info: {
                    name
                }
            });
            const address = await this.provider.resolveName(name);
            (0, index_js_5.assert)(address != null, "unconfigured ENS name", "UNCONFIGURED_NAME", {
                value: name
            });
            return address;
        });
        return this.signingKey.sign(index_js_2.TypedDataEncoder.hash(populated.domain, types, populated.value)).serialized;
    }
    /**
     *  Creates a new BaseWallet for %%privateKey%%, optionally
     *  connected to %%provider%%.
     *
     *  If %%provider%% is not specified, only offline methods can
     *  be used.
     */ constructor(privateKey, provider){
        super(provider), /**
     *  The wallet address.
     */ _define_property._(this, "address", void 0), _class_private_field_init._(this, _signingKey, {
            writable: true,
            value: void 0
        });
        (0, index_js_5.assertArgument)(privateKey && typeof privateKey.sign === "function", "invalid private key", "privateKey", "[ REDACTED ]");
        _class_private_field_set._(this, _signingKey, privateKey);
        const address = (0, index_js_4.computeAddress)(this.signingKey.publicKey);
        (0, index_js_5.defineProperties)(this, {
            address
        });
    }
}
exports.BaseWallet = BaseWallet; //# sourceMappingURL=base-wallet.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/decode-owl.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.decodeOwl = exports.decode = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const subsChrs = " !#$%&'()*+,-./<=>?@[]^_`{|}~";
const Word = /^[a-z]*$/i;
function unfold(words, sep) {
    let initial = 97;
    return words.reduce((accum, word)=>{
        if (word === sep) {
            initial++;
        } else if (word.match(Word)) {
            accum.push(String.fromCharCode(initial) + word);
        } else {
            initial = 97;
            accum.push(word);
        }
        return accum;
    }, []);
}
/**
 *  @_ignore
 */ function decode(data, subs) {
    // Replace all the substitutions with their expanded form
    for(let i = subsChrs.length - 1; i >= 0; i--){
        data = data.split(subsChrs[i]).join(subs.substring(2 * i, 2 * i + 2));
    }
    // Get all tle clumps; each suffix, first-increment and second-increment
    const clumps = [];
    const leftover = data.replace(/(:|([0-9])|([A-Z][a-z]*))/g, (all, item, semi, word)=>{
        if (semi) {
            for(let i = parseInt(semi); i >= 0; i--){
                clumps.push(";");
            }
        } else {
            clumps.push(item.toLowerCase());
        }
        return "";
    });
    /* c8 ignore start */ if (leftover) {
        throw new Error("leftovers: ".concat(JSON.stringify(leftover)));
    }
    /* c8 ignore stop */ return unfold(unfold(clumps, ";"), ":");
}
exports.decode = decode;
/**
 *  @_ignore
 */ function decodeOwl(data) {
    (0, index_js_1.assertArgument)(data[0] === "0", "unsupported auwl data", "data", data);
    return decode(data.substring(1 + 2 * subsChrs.length), data.substring(1, 1 + 2 * subsChrs.length));
}
exports.decodeOwl = decodeOwl; //# sourceMappingURL=decode-owl.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/wordlist.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Wordlist = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
/**
 *  A Wordlist represents a collection of language-specific
 *  words used to encode and devoce [[link-bip-39]] encoded data
 *  by mapping words to 11-bit values and vice versa.
 */ class Wordlist {
    /**
     *  Sub-classes may override this to provide a language-specific
     *  method for spliting %%phrase%% into individual words.
     *
     *  By default, %%phrase%% is split using any sequences of
     *  white-space as defined by regular expressions (i.e. ``/\s+/``).
     */ split(phrase) {
        return phrase.toLowerCase().split(/\s+/g);
    }
    /**
     *  Sub-classes may override this to provider a language-specific
     *  method for joining %%words%% into a phrase.
     *
     *  By default, %%words%% are joined by a single space.
     */ join(words) {
        return words.join(" ");
    }
    /**
     *  Creates a new Wordlist instance.
     *
     *  Sub-classes MUST call this if they provide their own constructor,
     *  passing in the locale string of the language.
     *
     *  Generally there is no need to create instances of a Wordlist,
     *  since each language-specific Wordlist creates an instance and
     *  there is no state kept internally, so they are safe to share.
     */ constructor(locale){
        _define_property._(this, "locale", void 0);
        (0, index_js_1.defineProperties)(this, {
            locale
        });
    }
}
exports.Wordlist = Wordlist; //# sourceMappingURL=wordlist.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/wordlist-owl.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _class_private_field_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_get.cjs [app-client] (ecmascript)");
var _class_private_field_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_init.cjs [app-client] (ecmascript)");
var _class_private_field_set = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_field_set.cjs [app-client] (ecmascript)");
var _class_private_method_get = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_get.cjs [app-client] (ecmascript)");
var _class_private_method_init = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_class_private_method_init.cjs [app-client] (ecmascript)");
// Use the encode-latin.js script to create the necessary
// data files to be consumed by this class
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WordlistOwl = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/hash/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const decode_owl_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/decode-owl.js [app-client] (ecmascript)");
const wordlist_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/wordlist.js [app-client] (ecmascript)");
var _data = /*#__PURE__*/ new WeakMap(), _checksum = /*#__PURE__*/ new WeakMap(), _words = /*#__PURE__*/ new WeakMap(), _loadWords = /*#__PURE__*/ new WeakSet();
/**
 *  An OWL format Wordlist is an encoding method that exploits
 *  the general locality of alphabetically sorted words to
 *  achieve a simple but effective means of compression.
 *
 *  This class is generally not useful to most developers as
 *  it is used mainly internally to keep Wordlists for languages
 *  based on ASCII-7 small.
 *
 *  If necessary, there are tools within the ``generation/`` folder
 *  to create the necessary data.
 */ class WordlistOwl extends wordlist_js_1.Wordlist {
    /**
     *  The OWL-encoded data.
     */ get _data() {
        return _class_private_field_get._(this, _data);
    }
    /**
     *  Decode all the words for the wordlist.
     */ _decodeWords() {
        return (0, decode_owl_js_1.decodeOwl)(_class_private_field_get._(this, _data));
    }
    getWord(index) {
        const words = _class_private_method_get._(this, _loadWords, loadWords).call(this);
        (0, index_js_2.assertArgument)(index >= 0 && index < words.length, "invalid word index: ".concat(index), "index", index);
        return words[index];
    }
    getWordIndex(word) {
        return _class_private_method_get._(this, _loadWords, loadWords).call(this).indexOf(word);
    }
    /**
     *  Creates a new Wordlist for %%locale%% using the OWL %%data%%
     *  and validated against the %%checksum%%.
     */ constructor(locale, data, checksum){
        super(locale), _class_private_method_init._(this, _loadWords), _class_private_field_init._(this, _data, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _checksum, {
            writable: true,
            value: void 0
        }), _class_private_field_init._(this, _words, {
            writable: true,
            value: void 0
        });
        _class_private_field_set._(this, _data, data);
        _class_private_field_set._(this, _checksum, checksum);
        _class_private_field_set._(this, _words, null);
    }
}
function loadWords() {
    if (_class_private_field_get._(this, _words) == null) {
        const words = this._decodeWords();
        // Verify the computed list matches the official list
        const checksum = (0, index_js_1.id)(words.join("\n") + "\n");
        /* c8 ignore start */ if (checksum !== _class_private_field_get._(this, _checksum)) {
            throw new Error("BIP39 Wordlist for ".concat(this.locale, " FAILED"));
        }
        /* c8 ignore stop */ _class_private_field_set._(this, _words, words);
    }
    return _class_private_field_get._(this, _words);
}
exports.WordlistOwl = WordlistOwl; //# sourceMappingURL=wordlist-owl.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/lang-en.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LangEn = void 0;
const wordlist_owl_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/wordlist-owl.js [app-client] (ecmascript)");
const words = "0erleonalorenseinceregesticitStanvetearctssi#ch2Athck&tneLl0And#Il.yLeOutO=S|S%b/ra@SurdU'0Ce[Cid|CountCu'Hie=IdOu,-Qui*Ro[TT]T%T*[Tu$0AptDD-tD*[Ju,M.UltV<)Vi)0Rob-0FairF%dRaid0A(EEntRee0Ead0MRRp%tS!_rmBumCoholErtI&LLeyLowMo,O}PhaReadySoT Ways0A>urAz(gOngOuntU'd0Aly,Ch%Ci|G G!GryIm$K!Noun)Nu$O` Sw T&naTiqueXietyY1ArtOlogyPe?P!Pro=Ril1ChCt-EaEnaGueMMedM%MyOundR<+Re,Ri=RowTTefa@Ti,Tw%k0KPe@SaultSetSi,SumeThma0H!>OmTa{T&dT.udeTra@0Ct]D.Gu,NtTh%ToTumn0Era+OcadoOid0AkeA*AyEsomeFulKw?d0Is:ByChel%C#D+GL<)Lc#y~MbooN<aNn RRelyRga(R*lSeS-SketTt!3A^AnAutyCau'ComeEfF%eG(Ha=H(dLie=LowLtN^Nef./TrayTt Twe&Y#d3Cyc!DKeNdOlogyRdR`Tt _{AdeAmeAnketA,EakE[IndOodO[omOu'UeUrUsh_rdAtDyIlMbNeNusOkO,Rd R(gRrowSsTtomUn)XY_{etA(AndA[A=EadEezeI{Id+IefIghtIngIskOccoliOk&OnzeOomO` OwnUsh2Bb!DdyD+tFf$oIldLbLkL!tNd!Nk Rd&Rg R,SS(e[SyTt Y Zz:Bba+B(B!CtusGeKe~LmM aMpNN$N)lNdyNn#NoeNvasNy#Pab!P.$Pta(RRb#RdRgoRpetRryRtSeShS(o/!Su$TT$ogT^Teg%yTt!UghtU'Ut]Ve3Il(gL yM|NsusNturyRe$Rta(_irAlkAmp]An+AosApt Ar+A'AtEapE{Ee'EfErryE,I{&IefIldIm}yOi)Oo'R#-U{!UnkUrn0G?Nnam#Rc!Tiz&TyVil_imApArifyAwAyE<ErkEv I{I|IffImbIn-IpO{OgO'O`OudOwnUbUmpU, Ut^_^A,C#utDeFfeeIlInL!@L%LumnMb(eMeMf%tM-Mm#Mp<yNc tNdu@NfirmNg*[N}@Nsid NtrolNv()OkOlPp PyR$ReRnR*@/Tt#U^UntryUp!Ur'Us(V Yo>_{Ad!AftAmA}AshAt AwlAzyEamEd.EekEwI{etImeIspIt-OpO[Ou^OwdUci$UelUi'Umb!Un^UshYY,$2BeLtu*PPbo?dRiousRr|Rta(R=Sh]/omTe3C!:DMa+MpN)Ng R(gShUght WnY3AlBa>BrisCadeCemb CideCl(eC%a>C*a'ErF&'F(eFyG*eLayLiv M<dMi'Ni$Nti,NyP?tP&dPos.P`PutyRi=ScribeS tSignSkSpair/royTailTe@VelopVi)Vo>3AgramAlAm#dAryCeE'lEtFf G.$Gn.yLemmaNn NosaurRe@RtSag*eScov Sea'ShSmi[S%d Splay/<)V tVideV%)Zzy5Ct%Cum|G~Lph(Ma(Na>NkeyN%OrSeUb!Ve_ftAg#AmaA,-AwEamE[IftIllInkIpI=OpUmY2CkMbNeR(g/T^Ty1Arf1Nam-:G G!RlyRnR`Sily/Sy1HoOlogyOnomy0GeItUca>1F%t0G1GhtTh 2BowD E@r-Eg<tEm|Eph<tEvat%I>Se0B?kBodyBra)Er+Ot]PloyPow Pty0Ab!A@DD![D%'EmyErgyF%)Ga+G(eH<)JoyLi,OughR-hRollSu*T Ti*TryVelope1Isode0U$Uip0AA'OdeOs]R%Upt0CapeSayS&)Ta>0Ern$H-s1Id&)IlOkeOl=1A@Amp!Ce[Ch<+C.eCludeCu'Ecu>Erci'Hau,Hib.I!I,ItOt-P<dPe@Pi*Pla(Po'P*[T&dTra0EEbrow:Br-CeCultyDeIntI`~L'MeMilyMousNNcyNtasyRmSh]TT$Th TigueUltV%.e3Atu*Bru?yD $EEdElMa!N)/iv$T^V W3B Ct]EldGu*LeLmLt N$NdNeNg NishReRmR,Sc$ShTT}[X_gAmeAshAtAv%EeIghtIpOatO{O%Ow UidUshY_mCusGIlLd~owOdOtR)Re,R+tRkRtu}RumRw?dSsil/ UndX_gi!AmeEqu|EshI&dIn+OgOntO,OwnOz&U.2ElNNnyRna)RyTu*:D+tInLaxy~ yMePRa+Rba+Rd&Rl-Rm|SSpTeTh U+Ze3N $NiusN*Nt!Nu(e/u*2O,0AntFtGg!Ng RaffeRlVe_dAn)A*A[IdeImp'ObeOomOryO=OwUe_tDde[LdOdO'RillaSpelSsipV nWn_bA)A(AntApeA[Av.yEatE&IdIefItOc yOupOwUnt_rdE[IdeIltIt?N3M:B.IrLfMm M, NdPpyRb%RdRshR=,TVeWkZ?d3AdAl`ArtAvyD+hogIght~oLmetLpNRo3Dd&Gh~NtPRe/%y5BbyCkeyLdLeLiday~owMeNeyOdPeRnRr%R'Sp.$/TelUrV 5BGeM<Mb!M%Nd*dNgryNtRd!RryRtSb<d3Brid:1EOn0EaEntifyLe2N%e4LLeg$L}[0A+Ita>M&'Mu}Pa@Po'Pro=Pul'0ChCludeComeC*a'DexD-a>Do%Du,ryF<tFl-tF%mHa!H .Iti$Je@JuryMa>N Noc|PutQuiryS<eSe@SideSpi*/$lTa@T e,ToVe,V.eVol=3On0L<dOla>Sue0Em1Ory:CketGu?RZz3AlousAns~yWel9BInKeUr}yY5D+I)MpNg!Ni%Nk/:Ng?oo3EnEpT^upY3CkDD}yNdNgdomSsTT^&TeTt&Wi4EeIfeO{Ow:BBelB%Dd DyKeMpNgua+PtopR+T T(UghUndryVaWWnWsu.Y Zy3Ad AfArnA=Ctu*FtGG$G&dIsu*M#NdNg`NsOp?dSs#Tt Vel3ArB tyBr?yC&'FeFtGhtKeMbM.NkOnQuid/Tt!VeZ?d5AdAnB, C$CkG-NelyNgOpTt yUdUn+VeY$5CkyGga+Mb N?N^Xury3R-s:Ch(eDG-G}tIdIlInJ%KeMm$NNa+Nda>NgoNs]Nu$P!Rb!R^Rg(R(eRketRria+SkSs/ T^T i$ThTrixTt XimumZe3AdowAnAsu*AtCh<-D$DiaLodyLtMb M%yNt]NuRcyR+R.RryShSsa+T$Thod3Dd!DnightLk~]M-NdNimumN%Nu>Rac!Rr%S ySs/akeXXedXtu*5Bi!DelDifyMM|N.%NkeyN, N`OnR$ReRn(gSqu.oTh T]T%Unta(U'VeVie5ChFf(LeLtiplySc!SeumShroomS-/Tu$3Self/ yTh:I=MePk(Rrow/yT]Tu*3ArCkEdGati=G!@I` PhewR=/TTw%kUtr$V WsXt3CeGht5B!I'M(eeOd!Rm$R`SeTab!TeTh(gTi)VelW5C!?Mb R'T:K0EyJe@Li+Scu*S =Ta(Vious0CurE<Tob 0Or1FF Fi)T&2L1Ay0DI=Ymp-0It0CeEI#L(eLy1EnEraIn]Po'T]1An+B.Ch?dD D(?yG<I|Ig($Ph<0Tr-h0H 0Tdo%T TputTside0AlEnEr0NN 0Yg&0/ 0O}:CtDd!GeIrLa)LmNdaNelN-N` P RadeR|RkRrotRtySsT^ThTi|TrolTt nU'VeYm|3A)AnutArAs<tL-<NN$tyNcilOp!Pp Rfe@Rm.Rs#T2O}OtoRa'Ys-$0AnoCn-Ctu*E)GGe#~LotNkO} Pe/olT^Zza_)A}tA,-A>AyEa'Ed+U{UgUn+2EmEtIntL?LeLi)NdNyOlPul?Rt]S.]Ssib!/TatoTt yV tyWd W _@i)Ai'Ed-tEf Epa*Es|EttyEv|I)IdeIm?yIntI%.yIs#Iva>IzeOb!mO)[Odu)Of.OgramOje@Omo>OofOp tyOsp O>@OudOvide2Bl-Dd(g~LpL'Mpk(N^PilPpyR^a'R.yRpo'R'ShTZz!3Ramid:99Al.yAntumArt E,]I{ItIzO>:Bb.Cco#CeCkD?DioIlInI'~yMpN^NdomN+PidReTeTh V&WZ%3AdyAlAs#BelBuildC$lCei=CipeC%dCyc!Du)F!@F%mFu'G]G*tGul?Je@LaxLea'LiefLyMa(Memb M(dMo=Nd NewNtOp&PairPeatPla)P%tQui*ScueSemb!Si,Sour)Sp#'SultTi*T*atTurnUn]Ve$ViewW?d2Y`m0BBb#CeChDeD+F!GhtGidNgOtPp!SkTu$V$V 5AdA,BotBu,CketM<)OfOkieOmSeTa>UghUndU>Y$5Bb DeGLeNNwayR$:DDd!D}[FeIlLadLm#L#LtLu>MeMp!NdTisfyToshiU)Usa+VeY1A!AnA*Att E}HemeHoolI&)I[%sOrp]OutRapRe&RiptRub1AAr^As#AtC#dC*tCt]Cur.yEdEkGm|Le@~M(?Ni%N'Nt&)RiesRvi)Ss]Tt!TupV&_dowAftAllowA*EdEllEriffIeldIftI}IpIv O{OeOotOpOrtOuld O=RimpRugUff!Y0Bl(gCkDeE+GhtGnL|Lk~yLv Mil?Mp!N)NgR&/ Tua>XZe1A>Et^IIllInIrtUll0AbAmEepEnd I)IdeIghtImOg<OtOwUsh0AllArtI!OkeOo`0A{AkeApIffOw0ApCc Ci$CkDaFtL?Ldi LidLut]L=Me#eNgOnRryRtUlUndUpUr)U`0A)A*Ati$AwnEakEci$EedEllEndH eI)Id IkeInIr.L.OilOns%O#OrtOtRayReadR(gY0Ua*UeezeUir*l_b!AdiumAffA+AirsAmpAndArtA>AyEakEelEmEpE*oI{IllIngO{Oma^O}OolOryO=Ra>gyReetRikeR#gRugg!Ud|UffUmb!Y!0Bje@Bm.BwayC)[ChDd&Ff G?G+,ItMm NNnyN'tP PplyP*meReRfa)R+Rpri'RroundR=ySpe@/a(1AllowAmpApArmE?EetIftImIngIt^Ord1MbolMptomRup/em:B!Ck!GIlL|LkNkPeR+tSk/eTtooXi3A^Am~NN<tNnisNtRm/Xt_nkAtEmeEnE%yE*EyIngIsOughtReeRi=RowUmbUnd 0CketDeG LtMb MeNyPRedSsueT!5A,BaccoDayDdl EGe` I!tK&MatoM%rowNeNgueNightOlO`PP-Pp!R^RnadoRtoi'SsT$Uri,W?dW WnY_{AdeAff-Ag-A(Ansf ApAshA=lAyEatEeEndI$IbeI{Igg ImIpOphyOub!U{UeUlyUmpetU,U`Y2BeIt]Mb!NaN}lRkeyRnRt!1El=EntyI)InI,O1PeP-$:5Ly5B*lla0Ab!Awa*C!Cov D DoFairFoldHappyIf%mIqueItIv 'KnownLo{TilUsu$Veil1Da>GradeHoldOnP Set1B<Ge0A+EEdEfulE![U$0Il.y:C<tCuumGueLidL!yL=NNishP%Rious/Ult3H-!L=tNd%Ntu*NueRbRifyRs]RyS'lT <3Ab!Br<tCiousCt%yDeoEw~a+Nta+Ol(Rtu$RusSaS.Su$T$Vid5C$I)IdLc<oLumeTeYa+:GeG#ItLk~LnutNtRfa*RmRri%ShSp/eT VeY3Al`Ap#ArA'lA` BDd(gEk&dIrdLcome/T_!AtEatEelEnE*IpIsp 0DeD`FeLd~NNdowNeNgNkNn Nt ReSdomSeShT}[5LfM<Nd OdOlRdRkRldRryR`_pE{E,!I,I>Ong::Rd3Ar~ow9UUngU`:3BraRo9NeO";
const checksum = "0x3c8acc1e7b08d8e76f9fda015ef48dc8c710a73cb7e0f77b2c18a9b5a7adde60";
let wordlist = null;
/**
 *  The [[link-bip39-en]] for [mnemonic phrases](link-bip-39).
 *
 *  @_docloc: api/wordlists
 */ class LangEn extends wordlist_owl_js_1.WordlistOwl {
    /**
     *  Returns a singleton instance of a ``LangEn``, creating it
     *  if this is the first time being called.
     */ static wordlist() {
        if (wordlist == null) {
            wordlist = new LangEn();
        }
        return wordlist;
    }
    /**
     *  Creates a new instance of the English language Wordlist.
     *
     *  This should be unnecessary most of the time as the exported
     *  [[langEn]] should suffice.
     *
     *  @_ignore:
     */ constructor(){
        super("en", words, checksum);
    }
}
exports.LangEn = LangEn; //# sourceMappingURL=lang-en.js.map
}),
"[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wallet/mnemonic.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var _define_property = __turbopack_context__.r("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/cjs/_define_property.cjs [app-client] (ecmascript)");
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Mnemonic = void 0;
const index_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/crypto/index.js [app-client] (ecmascript)");
const index_js_2 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/utils/index.js [app-client] (ecmascript)");
const lang_en_js_1 = __turbopack_context__.r("[project]/node_modules/.pnpm/ethers@6.15.0_bufferutil@4.0.9_utf-8-validate@5.0.10/node_modules/ethers/lib.commonjs/wordlists/lang-en.js [app-client] (ecmascript)");
// Returns a byte with the MSB bits set
function getUpperMask(bits) {
    return (1 << bits) - 1 << 8 - bits & 0xff;
}
// Returns a byte with the LSB bits set
function getLowerMask(bits) {
    return (1 << bits) - 1 & 0xff;
}