(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/exports/features.js [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
;
 //# sourceMappingURL=features.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/index.js [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
;
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/ReownAuthenticationMessenger.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ReownAuthenticationMessenger",
    ()=>ReownAuthenticationMessenger
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NetworkUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NetworkUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ChainController.js [app-client] (ecmascript)");
;
;
class ReownAuthenticationMessenger {
    async createMessage(input) {
        const params = {
            accountAddress: input.accountAddress,
            chainId: input.chainId,
            version: '1',
            domain: typeof document === 'undefined' ? 'Unknown Domain' : document.location.host,
            uri: typeof document === 'undefined' ? 'Unknown URI' : document.location.href,
            resources: this.resources,
            nonce: await this.getNonce(input),
            issuedAt: this.stringifyDate(new Date()),
            statement: undefined,
            expirationTime: undefined,
            notBefore: undefined
        };
        const methods = {
            toString: ()=>this.stringify(params)
        };
        return Object.assign(params, methods);
    }
    stringify(params) {
        var _params_resources;
        const networkName = this.getNetworkName(params.chainId);
        return [
            "".concat(params.domain, " wants you to sign in with your ").concat(networkName, " account:"),
            params.accountAddress,
            params.statement ? "\n".concat(params.statement, "\n") : '',
            "URI: ".concat(params.uri),
            "Version: ".concat(params.version),
            "Chain ID: ".concat(params.chainId),
            "Nonce: ".concat(params.nonce),
            params.issuedAt && "Issued At: ".concat(params.issuedAt),
            params.expirationTime && "Expiration Time: ".concat(params.expirationTime),
            params.notBefore && "Not Before: ".concat(params.notBefore),
            params.requestId && "Request ID: ".concat(params.requestId),
            ((_params_resources = params.resources) === null || _params_resources === void 0 ? void 0 : _params_resources.length) && params.resources.reduce((acc, resource)=>"".concat(acc, "\n- ").concat(resource), 'Resources:')
        ].filter((line)=>typeof line === 'string').join('\n').trim();
    }
    getNetworkName(chainId) {
        const requestedNetworks = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].getAllRequestedCaipNetworks();
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NetworkUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NetworkUtil"].getNetworkNameByCaipNetworkId(requestedNetworks, chainId);
    }
    stringifyDate(date) {
        return date.toISOString();
    }
    constructor(params){
        this.getNonce = params.getNonce;
    }
} //# sourceMappingURL=ReownAuthenticationMessenger.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/ReownAuthentication.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

//
__turbopack_context__.s([
    "ReownAuthentication",
    ()=>ReownAuthentication
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/ConstantsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/SafeLocalStorage.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ApiController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/BlockchainApiController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ChainController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/ChainControllerUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$ReownAuthenticationMessenger$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/ReownAuthenticationMessenger.js [app-client] (ecmascript)");
;
;
;
;
;
;
class ReownAuthentication {
    async createMessage(input) {
        return this.messenger.createMessage(input);
    }
    async addSession(session) {
        const response = await this.request({
            method: 'POST',
            key: 'authenticate',
            body: {
                data: session.data,
                message: session.message,
                signature: session.signature,
                clientId: this.getClientId(),
                walletInfo: this.getWalletInfo()
            },
            headers: [
                'nonce',
                'otp'
            ]
        });
        this.setStorageToken(response.token, this.localAuthStorageKey);
        this.emit('sessionChanged', session);
        this.setAppKitAccountUser(jwtDecode(response.token));
        this.otpUuid = null;
    }
    async getSessions(chainId, address) {
        try {
            if (!this.getStorageToken(this.localAuthStorageKey)) {
                return [];
            }
            const account = await this.request({
                method: 'GET',
                key: 'me',
                query: {},
                headers: [
                    'auth'
                ]
            });
            if (!account) {
                return [];
            }
            const isSameAddress = account.address.toLowerCase() === address.toLowerCase();
            const isSameNetwork = account.caip2Network === chainId;
            if (!isSameAddress || !isSameNetwork) {
                return [];
            }
            const session = {
                data: {
                    accountAddress: account.address,
                    chainId: account.caip2Network
                },
                message: '',
                signature: ''
            };
            this.emit('sessionChanged', session);
            this.setAppKitAccountUser(account);
            return [
                session
            ];
        } catch (e) {
            return [];
        }
    }
    async revokeSession(_chainId, _address) {
        return Promise.resolve(this.clearStorageTokens());
    }
    async setSessions(sessions) {
        if (sessions.length === 0) {
            this.clearStorageTokens();
        } else {
            const session = sessions.find((s)=>{
                var _getActiveCaipNetwork;
                return s.data.chainId === ((_getActiveCaipNetwork = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getActiveCaipNetwork"])()) === null || _getActiveCaipNetwork === void 0 ? void 0 : _getActiveCaipNetwork.caipNetworkId);
            }) || sessions[0];
            await this.addSession(session);
        }
    }
    getRequired() {
        return this.required;
    }
    async getSessionAccount() {
        if (!this.getStorageToken(this.localAuthStorageKey)) {
            throw new Error('Not authenticated');
        }
        return this.request({
            method: 'GET',
            key: 'me',
            body: undefined,
            query: {
                includeAppKitAccount: true
            },
            headers: [
                'auth'
            ]
        });
    }
    async setSessionAccountMetadata() {
        let metadata = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : null;
        if (!this.getStorageToken(this.localAuthStorageKey)) {
            throw new Error('Not authenticated');
        }
        return this.request({
            method: 'PUT',
            key: 'account-metadata',
            body: {
                metadata
            },
            headers: [
                'auth'
            ]
        });
    }
    on(event, callback) {
        this.listeners[event].push(callback);
        return ()=>{
            this.listeners[event] = this.listeners[event].filter((cb)=>cb !== callback);
        };
    }
    removeAllListeners() {
        const keys = Object.keys(this.listeners);
        keys.forEach((key)=>{
            this.listeners[key] = [];
        });
    }
    async requestEmailOtp(param) {
        let { email, account } = param;
        const otp = await this.request({
            method: 'POST',
            key: 'otp',
            body: {
                email,
                account
            }
        });
        this.otpUuid = otp.uuid;
        this.messenger.resources = [
            "email:".concat(email)
        ];
        return otp;
    }
    confirmEmailOtp(param) {
        let { code } = param;
        return this.request({
            method: 'PUT',
            key: 'otp',
            body: {
                code
            },
            headers: [
                'otp'
            ]
        });
    }
    async request(param) {
        let { method, key, query, body, headers } = param;
        var _response_headers_get;
        const { projectId, st, sv } = this.getSDKProperties();
        const url = new URL("".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].W3M_API_URL, "/auth/v1/").concat(String(key)));
        url.searchParams.set('projectId', projectId);
        url.searchParams.set('st', st);
        url.searchParams.set('sv', sv);
        if (query) {
            Object.entries(query).forEach((param)=>{
                let [queryKey, queryValue] = param;
                return url.searchParams.set(queryKey, String(queryValue));
            });
        }
        const response = await fetch(url, {
            method,
            body: body ? JSON.stringify(body) : undefined,
            headers: Array.isArray(headers) ? headers.reduce((acc, header)=>{
                switch(header){
                    case 'nonce':
                        acc['x-nonce-jwt'] = "Bearer ".concat(this.getStorageToken(this.localNonceStorageKey));
                        break;
                    case 'auth':
                        acc['Authorization'] = "Bearer ".concat(this.getStorageToken(this.localAuthStorageKey));
                        break;
                    case 'otp':
                        if (this.otpUuid) {
                            acc['x-otp'] = this.otpUuid;
                        }
                        break;
                    default:
                        break;
                }
                return acc;
            }, {}) : undefined
        });
        if (!response.ok) {
            throw new Error(await response.text());
        }
        if ((_response_headers_get = response.headers.get('content-type')) === null || _response_headers_get === void 0 ? void 0 : _response_headers_get.includes('application/json')) {
            return response.json();
        }
        return null;
    }
    getStorageToken(key) {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SafeLocalStorage"].getItem(key);
    }
    setStorageToken(token, key) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SafeLocalStorage"].setItem(key, token);
    }
    clearStorageTokens() {
        this.otpUuid = null;
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SafeLocalStorage"].removeItem(this.localAuthStorageKey);
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SafeLocalStorage"].removeItem(this.localNonceStorageKey);
        this.emit('sessionChanged', undefined);
    }
    async getNonce() {
        const { nonce, token } = await this.request({
            method: 'GET',
            key: 'nonce'
        });
        this.setStorageToken(token, this.localNonceStorageKey);
        return nonce;
    }
    getClientId() {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BlockchainApiController"].state.clientId;
    }
    getWalletInfo() {
        var _ChainController_getAccountData;
        const walletInfo = (_ChainController_getAccountData = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].getAccountData()) === null || _ChainController_getAccountData === void 0 ? void 0 : _ChainController_getAccountData.connectedWalletInfo;
        if (!walletInfo) {
            return undefined;
        }
        if ('social' in walletInfo && 'identifier' in walletInfo) {
            const social = walletInfo['social'];
            const identifier = walletInfo['identifier'];
            return {
                type: 'social',
                social,
                identifier
            };
        }
        const { name, icon } = walletInfo;
        let type = 'unknown';
        switch(walletInfo.type){
            case 'EXTERNAL':
            case 'INJECTED':
            case 'ANNOUNCED':
                type = 'extension';
                break;
            case 'WALLET_CONNECT':
                type = 'walletconnect';
                break;
            default:
                type = 'unknown';
        }
        return {
            type,
            name,
            icon
        };
    }
    getSDKProperties() {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ApiController"]._getSdkProperties();
    }
    emit(event, data) {
        this.listeners[event].forEach((listener)=>listener(data));
    }
    setAppKitAccountUser(session) {
        const { email } = session;
        if (email) {
            Object.values(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN).forEach((chainNamespace)=>{
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].setAccountProp('user', {
                    email
                }, chainNamespace);
            });
        }
    }
    constructor(params = {}){
        this.otpUuid = null;
        this.listeners = {
            sessionChanged: []
        };
        this.localAuthStorageKey = params.localAuthStorageKey || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SafeLocalStorageKeys"].SIWX_AUTH_TOKEN;
        this.localNonceStorageKey = params.localNonceStorageKey || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$SafeLocalStorage$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SafeLocalStorageKeys"].SIWX_NONCE_TOKEN;
        var _params_required;
        this.required = (_params_required = params.required) !== null && _params_required !== void 0 ? _params_required : true;
        this.messenger = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$ReownAuthenticationMessenger$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ReownAuthenticationMessenger"]({
            getNonce: this.getNonce.bind(this)
        });
    }
}
/**
 * Decodes a JWT token and returns its payload
 * @param token - The JWT token to decode
 * @returns The decoded payload or null if invalid
 */ function jwtDecode(token) {
    // Split the token into parts
    const parts = token.split('.');
    // Check if the token has the correct format (header.payload.signature)
    if (parts.length !== 3) {
        throw new Error('Invalid token');
    }
    // Decode the payload (second part)
    const payload = parts[1];
    if (typeof payload !== 'string') {
        throw new Error('Invalid token');
    }
    // Convert base64url to base64
    const base64 = payload.replace(/-/gu, '+').replace(/_/gu, '/');
    // Add padding if needed
    const padded = base64.padEnd(base64.length + (4 - base64.length % 4) % 4, '=');
    // Decode and parse the JSON
    const decoded = JSON.parse(atob(padded));
    return decoded;
} //# sourceMappingURL=ReownAuthentication.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ReownAuthentication",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$ReownAuthentication$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ReownAuthentication"],
    "ReownAuthenticationMessenger",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$ReownAuthenticationMessenger$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ReownAuthenticationMessenger"]
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$ReownAuthentication$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/ReownAuthentication.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$ReownAuthenticationMessenger$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/ReownAuthenticationMessenger.js [app-client] (ecmascript)");
}),
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/exports/features.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ReownAuthentication",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ReownAuthentication"],
    "ReownAuthenticationMessenger",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ReownAuthenticationMessenger"]
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$exports$2f$features$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/exports/features.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$features$2f$siwx$2f$reown$2d$authentication$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/features/siwx/reown-authentication/index.js [app-client] (ecmascript)");
}),
]);

//# sourceMappingURL=dec89_%40reown_appkit-controllers_dist_esm_e3283cd7._.js.map