(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/frontend/components/ui/textarea.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "Textarea",
    ()=>Textarea
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/utils.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/x.js [app-client] (ecmascript) <export default as X>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$validation$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/validation.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
;
;
;
;
const Textarea = /*#__PURE__*/ _s(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["forwardRef"](_c = _s((param, ref)=>{
    let { className, title, label, error = false, errorMessage, description, validationRules, validateOnChange = false, size = "default", value, ...props } = param;
    _s();
    // State to store validation error messages
    const [validationError, setValidationError] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"]("");
    const hasError = error || !!validationError;
    const errorMsg = errorMessage || validationError;
    // Adjust padding based on size
    const paddingClass = size === "sm" ? "px-2 py-1.5" : size === "lg" ? "px-4 py-3" : "px-3 py-2";
    // Function to validate the textarea's value using the provided rules
    const validate = (value)=>{
        if (!validationRules) return;
        const result = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$validation$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validateValue"])(value, validationRules);
        setValidationError(result.isValid ? "" : result.message);
        return result.isValid;
    };
    const handleBlur = (e)=>{
        if (validationRules) {
            validate(e.target.value);
        }
        if (props.onBlur) {
            props.onBlur(e);
        }
    };
    const handleChange = (e)=>{
        if (validationRules && validateOnChange) {
            validate(e.target.value);
        }
        if (props.onChange) {
            props.onChange(e);
        }
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "flex flex-col w-full",
        children: [
            (title || label) && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                className: "mb-1 text-sm font-medium text-gray-700 dark:text-gray-200",
                children: title || label
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/textarea.tsx",
                lineNumber: 80,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("textarea", {
                "data-slot": "textarea",
                ref: ref,
                className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$utils$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["cn"])("border-input placeholder:text-muted-foreground focus-visible:border-ring focus-visible:ring-ring/50 aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive flex field-sizing-content min-h-16 w-full rounded-md border bg-transparent shadow-2xs transition-[color,box-shadow] outline-hidden focus-visible:ring-[3px] disabled:cursor-not-allowed disabled:opacity-50 text-sm", paddingClass, hasError && "border-2 border-red-500 focus:ring-red-500 focus:ring-2", className),
                onBlur: handleBlur,
                onChange: handleChange,
                value: value != null ? value : "",
                ...props
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/textarea.tsx",
                lineNumber: 84,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)),
            description && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                className: "mt-1 text-xs text-muted-foreground",
                children: description
            }, void 0, false, {
                fileName: "[project]/frontend/components/ui/textarea.tsx",
                lineNumber: 100,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0)),
            hasError && errorMsg && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex items-center gap-2 text-red-500 text-sm mt-1 bg-red-50 dark:bg-red-900/10 p-2 rounded-md",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__["X"], {
                        className: "h-4 w-4 flex-shrink-0"
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/ui/textarea.tsx",
                        lineNumber: 104,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0)),
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                        children: errorMsg
                    }, void 0, false, {
                        fileName: "[project]/frontend/components/ui/textarea.tsx",
                        lineNumber: 105,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0))
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/components/ui/textarea.tsx",
                lineNumber: 103,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/components/ui/textarea.tsx",
        lineNumber: 78,
        columnNumber: 7
    }, ("TURBOPACK compile-time value", void 0));
}, "pY/WLsLrWKqoVtOAd7aa3sZZYEs=")), "pY/WLsLrWKqoVtOAd7aa3sZZYEs=");
_c1 = Textarea;
Textarea.displayName = "Textarea";
;
var _c, _c1;
__turbopack_context__.k.register(_c, "Textarea$React.forwardRef");
__turbopack_context__.k.register(_c1, "Textarea");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/utils/upload.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "imageUploader",
    ()=>imageUploader
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-client] (ecmascript)");
;
// Helper function to convert a file to Base64 format
const fileToBase64 = async (file)=>{
    return new Promise((resolve, reject)=>{
        const reader = new FileReader();
        reader.onload = ()=>resolve(reader.result);
        reader.onerror = ()=>reject("Error reading file");
        reader.readAsDataURL(file);
    });
};
// Helper function to handle HEIC conversion using a server-side endpoint
const convertHeicFile = async (base64File, dir, mimeType)=>{
    try {
        const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
            url: "/api/upload/heic",
            method: "POST",
            body: {
                file: base64File,
                dir,
                mimeType
            }
        });
        if (data) {
            return data; // Return the converted file data
        } else {
            console.error("HEIC conversion failed:", error);
            throw new Error("HEIC conversion failed");
        }
    } catch (error) {
        console.error("Error converting HEIC file:", error);
        throw error;
    }
};
const imageUploader = async (param)=>{
    let { file, dir, size = {
        maxWidth: 1024,
        maxHeight: 728
    }, oldPath = "" } = param;
    // Step 1: Convert the file to Base64 format
    const base64File = await fileToBase64(file);
    // Step 2: Ensure MIME type is correctly set
    let mimeType = file.type;
    // Check if MIME type is not set or empty (common for HEIC files)
    if (!mimeType || mimeType === "") {
        // Fallback logic to set MIME type based on file extension
        if (file.name.toLowerCase().endsWith(".heic")) {
            mimeType = "image/heic";
        } else if (file.name.toLowerCase().endsWith(".heif")) {
            mimeType = "image/heif";
        }
    }
    // Step 3: Check if the file is a HEIC file, and if so, convert it using the server API
    if (mimeType === "image/heic" || mimeType === "image/heif") {
        try {
            const convertedData = await convertHeicFile(base64File, dir, mimeType);
            return {
                success: true,
                ...convertedData
            };
        } catch (error) {
            console.error("Error converting HEIC/HEIF file:", error);
            return {
                success: false,
                error: "HEIC/HEIF file conversion failed"
            };
        }
    }
    // Step 4: Load image dimensions using JavaScript Image object
    const img = new Image();
    img.src = base64File;
    await new Promise((resolve, reject)=>{
        img.onload = ()=>{
            console.log("Image loaded successfully:", img.naturalWidth, img.naturalHeight);
            resolve();
        };
        img.onerror = ()=>{
            console.error("Error loading image. Base64 might be invalid.");
            reject("Image loading failed");
        };
    });
    // Step 5: Prepare the payload for uploading
    const { width, height, maxWidth, maxHeight } = size;
    const filePayload = {
        file: base64File,
        dir,
        mimeType,
        width: Math.min(Number(width || img.naturalWidth), maxWidth),
        height: Math.min(Number(height || img.naturalHeight), maxHeight),
        oldPath
    };
    // Step 6: Upload the file using the upload endpoint
    try {
        const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
            url: "/api/upload",
            method: "POST",
            body: filePayload,
            silentSuccess: true
        });
        if (error) {
            throw new Error("File upload failed");
        }
        return {
            success: true,
            url: data.url
        };
    } catch (error) {
        console.error("Error uploading file:", error);
        return {
            success: false,
            error: "File upload failed"
        };
    }
};
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/services/ws-manager.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ConnectionStatus",
    ()=>ConnectionStatus,
    "wsManager",
    ()=>wsManager
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_define_property.js [app-client] (ecmascript)");
;
var ConnectionStatus = /*#__PURE__*/ function(ConnectionStatus) {
    ConnectionStatus["CONNECTING"] = "connecting";
    ConnectionStatus["CONNECTED"] = "connected";
    ConnectionStatus["DISCONNECTED"] = "disconnected";
    ConnectionStatus["RECONNECTING"] = "reconnecting";
    ConnectionStatus["ERROR"] = "error";
    return ConnectionStatus;
}({});
class WebSocketManager {
    // Get singleton instance
    static getInstance() {
        if (!WebSocketManager.instance) {
            WebSocketManager.instance = new WebSocketManager();
        }
        return WebSocketManager.instance;
    }
    // Connect to a WebSocket server
    connect(url) {
        let connectionId = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "default";
        // If already connected or connecting, do nothing
        if (this.connections.has(connectionId) && (this.connectionStatus.get(connectionId) === "connected" || this.connectionStatus.get(connectionId) === "connecting")) {
            return;
        }
        // Initialize message queue for this connection if it doesn't exist
        if (!this.messageQueues.has(connectionId)) {
            this.messageQueues.set(connectionId, []);
        }
        // Update connection status
        this.connectionStatus.set(connectionId, "connecting");
        this.notifyStatusListeners(connectionId);
        // Create a new WebSocket connection
        // Note: WebSocket in browser automatically includes cookies for same-origin requests
        try {
            // Get access token from cookies if available
            const getCookie = (name)=>{
                var _parts_pop;
                const value = "; ".concat(document.cookie);
                const parts = value.split("; ".concat(name, "="));
                if (parts.length === 2) return (_parts_pop = parts.pop()) === null || _parts_pop === void 0 ? void 0 : _parts_pop.split(';').shift();
                return null;
            };
            const accessToken = getCookie('accessToken');
            // Add token to URL if available (for authentication)
            let authUrl = url;
            if (accessToken) {
                const separator = url.includes('?') ? '&' : '?';
                authUrl = "".concat(url).concat(separator, "token=").concat(accessToken);
            }
            const ws = new WebSocket(authUrl);
            // Set up event handlers
            ws.onopen = ()=>this.handleOpen(connectionId);
            ws.onmessage = (event)=>this.handleMessage(event, connectionId);
            ws.onclose = ()=>this.handleClose(connectionId, url);
            ws.onerror = (error)=>this.handleError(error, connectionId);
            // Store the connection
            this.connections.set(connectionId, ws);
        } catch (error) {
            console.error("Error creating WebSocket connection for ".concat(connectionId, ":"), error);
            this.handleError(new Event("error"), connectionId);
        }
    }
    // Handle WebSocket open event
    handleOpen(connectionId) {
        this.connectionStatus.set(connectionId, "connected");
        this.reconnectAttempts.set(connectionId, 0); // Reset reconnect attempts
        this.notifyStatusListeners(connectionId);
        // Process any queued messages
        this.processMessageQueue(connectionId);
    }
    // Process queued messages
    processMessageQueue(connectionId) {
        if (!this.messageQueues.has(connectionId)) return;
        const queue = this.messageQueues.get(connectionId);
        if (queue.length === 0) return;
        // Send all queued messages
        while(queue.length > 0){
            const message = queue.shift();
            this.sendMessageImmediate(message, connectionId);
        }
    }
    // Handle WebSocket message event
    handleMessage(event, connectionId) {
        try {
            var _data_payload, _data_payload1;
            const data = JSON.parse(event.data);
            // Handle different message formats
            let streamKey = data.stream || "default";
            // Special handling for support ticket messages
            if (data.method === "reply" && ((_data_payload = data.payload) === null || _data_payload === void 0 ? void 0 : _data_payload.id)) {
                streamKey = "ticket-".concat(data.payload.id);
            } else if (data.method === "update" && ((_data_payload1 = data.payload) === null || _data_payload1 === void 0 ? void 0 : _data_payload1.id)) {
                streamKey = "ticket-".concat(data.payload.id);
            }
            // Notify subscribers
            if (this.subscriptions.has(connectionId)) {
                const connectionSubscriptions = this.subscriptions.get(connectionId);
                if (connectionSubscriptions.has(streamKey)) {
                    const callbacks = connectionSubscriptions.get(streamKey);
                    callbacks.forEach((callback)=>{
                        try {
                            callback(data.data || data);
                        } catch (error) {
                            console.error("Error in callback for ".concat(streamKey, ":"), error);
                        }
                    });
                }
            }
        } catch (error) {
            console.error("Error parsing WebSocket message for ".concat(connectionId, ":"), error);
        }
    }
    // Handle WebSocket close event
    handleClose(connectionId, url) {
        this.connections.delete(connectionId);
        this.connectionStatus.set(connectionId, "disconnected");
        this.notifyStatusListeners(connectionId);
        // Attempt to reconnect
        this.reconnect(connectionId, url);
    }
    // Handle WebSocket error event
    handleError(error, connectionId) {
        console.error("WebSocket error for ".concat(connectionId, ":"), error);
    }
    // Attempt to reconnect to the WebSocket server
    reconnect(connectionId, url) {
        // Clear any existing reconnect timeout
        if (this.reconnectTimeouts.has(connectionId)) {
            clearTimeout(this.reconnectTimeouts.get(connectionId));
        }
        // Get current reconnect attempts
        const attempts = this.reconnectAttempts.get(connectionId) || 0;
        // Check if we've exceeded the maximum number of reconnect attempts
        if (attempts >= this.maxReconnectAttempts) {
            console.error("Maximum reconnect attempts (".concat(this.maxReconnectAttempts, ") reached for ").concat(connectionId));
            return;
        }
        // Update connection status
        this.connectionStatus.set(connectionId, "reconnecting");
        this.notifyStatusListeners(connectionId);
        // Calculate exponential backoff delay
        const delay = Math.min(this.reconnectDelay * Math.pow(2, attempts), 30000); // Max 30 seconds
        // Set a timeout to reconnect
        const timeout = setTimeout(()=>{
            this.reconnectAttempts.set(connectionId, attempts + 1);
            this.connect(url, connectionId);
        }, delay);
        // Store the timeout
        this.reconnectTimeouts.set(connectionId, timeout);
    }
    // Subscribe to a WebSocket stream
    subscribe(streamKey, callback) {
        let connectionId = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "default";
        // Initialize subscriptions map for this connection if it doesn't exist
        if (!this.subscriptions.has(connectionId)) {
            this.subscriptions.set(connectionId, new Map());
        }
        // Initialize callbacks set for this stream if it doesn't exist
        const connectionSubscriptions = this.subscriptions.get(connectionId);
        if (!connectionSubscriptions.has(streamKey)) {
            connectionSubscriptions.set(streamKey, new Set());
        }
        // Add the callback to the set
        connectionSubscriptions.get(streamKey).add(callback);
    }
    // Unsubscribe from a WebSocket stream
    unsubscribe(streamKey, callback) {
        let connectionId = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "default";
        if (this.subscriptions.has(connectionId)) {
            const connectionSubscriptions = this.subscriptions.get(connectionId);
            if (connectionSubscriptions.has(streamKey)) {
                const callbacks = connectionSubscriptions.get(streamKey);
                callbacks.delete(callback);
                // If no more callbacks, remove the stream
                if (callbacks.size === 0) {
                    connectionSubscriptions.delete(streamKey);
                }
            }
        }
    }
    // Send a message to the WebSocket server (queues if not connected)
    sendMessage(message) {
        let connectionId = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "default";
        // Check if the connection is ready
        if (this.connections.has(connectionId) && this.connectionStatus.get(connectionId) === "connected") {
            // Connection is ready, send immediately
            this.sendMessageImmediate(message, connectionId);
        } else {
            // Connection is not ready, queue the message
            if (!this.messageQueues.has(connectionId)) {
                this.messageQueues.set(connectionId, []);
            }
            this.messageQueues.get(connectionId).push(message);
        }
    }
    // Send a message immediately without queueing
    sendMessageImmediate(message, connectionId) {
        const connection = this.connections.get(connectionId);
        if (connection && connection.readyState === WebSocket.OPEN) {
            const messageStr = JSON.stringify(message);
            connection.send(messageStr);
        } else {
            console.error("Cannot send message: WebSocket for ".concat(connectionId, " is not open"));
        }
    }
    // Add a status listener
    addStatusListener(callback) {
        let connectionId = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "default";
        // Initialize status listeners set for this connection if it doesn't exist
        if (!this.statusListeners.has(connectionId)) {
            this.statusListeners.set(connectionId, new Set());
        }
        // Add the callback to the set
        this.statusListeners.get(connectionId).add(callback);
        // Notify the listener of the current status
        const status = this.connectionStatus.get(connectionId) || "disconnected";
        callback(status);
    }
    // Remove a status listener
    removeStatusListener(callback) {
        let connectionId = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "default";
        if (this.statusListeners.has(connectionId)) {
            this.statusListeners.get(connectionId).delete(callback);
        }
    }
    // Notify all status listeners of a status change
    notifyStatusListeners(connectionId) {
        const status = this.connectionStatus.get(connectionId) || "disconnected";
        if (this.statusListeners.has(connectionId)) {
            this.statusListeners.get(connectionId).forEach((callback)=>{
                try {
                    callback(status);
                } catch (error) {
                    console.error("Error in status listener for ".concat(connectionId, ":"), error);
                }
            });
        }
    }
    // Get the current connection status
    getStatus() {
        let connectionId = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "default";
        return this.connectionStatus.get(connectionId) || "disconnected";
    }
    // Close a WebSocket connection
    close() {
        let connectionId = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "default";
        // Clear any reconnect timeouts for this connection
        const timeout = this.reconnectTimeouts.get(connectionId);
        if (timeout) {
            clearTimeout(timeout);
            this.reconnectTimeouts.delete(connectionId);
        }
        const connection = this.connections.get(connectionId);
        if (connection) {
            connection.close();
            this.connections.delete(connectionId);
            this.connectionStatus.set(connectionId, "disconnected");
            this.notifyStatusListeners(connectionId);
            // Clear associated data
            this.subscriptions.delete(connectionId);
            this.messageQueues.delete(connectionId);
            this.reconnectAttempts.delete(connectionId);
        }
    }
    // Close all WebSocket connections
    closeAll() {
        this.connections.forEach((connection, connectionId)=>{
            this.close(connectionId);
        });
    }
    constructor(){
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "connections", new Map());
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "connectionStatus", new Map());
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "subscriptions", new Map());
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "statusListeners", new Map());
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "reconnectTimeouts", new Map());
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "reconnectAttempts", new Map());
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "messageQueues", new Map()); // Queue messages until connection is ready
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "maxReconnectAttempts", 5);
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "reconnectDelay", 1000); // Start with 1 second delay
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(this, "debug", ("TURBOPACK compile-time value", "development") !== "production"); // Enable debug in development
    }
}
(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_define_property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])(WebSocketManager, "instance", void 0);
const wsManager = WebSocketManager.getInstance();
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>LiveChat
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$message$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MessageCircle$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/message-circle.js [app-client] (ecmascript) <export default as MessageCircle>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/x.js [app-client] (ecmascript) <export default as X>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$send$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Send$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/send.js [app-client] (ecmascript) <export default as Send>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$minimize$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Minimize2$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/minimize-2.js [app-client] (ecmascript) <export default as Minimize2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$maximize$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Maximize2$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/maximize-2.js [app-client] (ecmascript) <export default as Maximize2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$paperclip$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Paperclip$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/paperclip.js [app-client] (ecmascript) <export default as Paperclip>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$loader$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Loader2$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/loader-circle.js [app-client] (ecmascript) <export default as Loader2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$user$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__User$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lucide-react@0.468.0_react@19.1.1/node_modules/lucide-react/dist/esm/icons/user.js [app-client] (ecmascript) <export default as User>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/button.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/card.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/avatar.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$textarea$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/textarea.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$badge$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/components/ui/badge.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$upload$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/utils/upload.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/lib/api.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/services/ws-manager.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/next-intl@4.3.4_next@15.5.4_b3bf31b962ed33195b62be321e96b2b6/node_modules/next-intl/dist/esm/development/react-client/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/store/user.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
;
;
;
;
;
;
// Add this helper function near the top of the component, after the interfaces
const mapTicketStatusToChatStatus = (ticketStatus)=>{
    switch(ticketStatus){
        case "PENDING":
            return "WAITING";
        case "OPEN":
        case "REPLIED":
            return "CONNECTED";
        case "CLOSED":
            return "ENDED";
        default:
            return "WAITING";
    }
};
// Add this helper function to parse messages
const parseMessages = (messagesData)=>{
    if (!messagesData) return [];
    try {
        let parsedMessages = [];
        if (typeof messagesData === "string") {
            // Handle double-encoded JSON like "\"[]\""
            const cleanedString = messagesData.replace(/^"|"$/g, "").replace(/\\"/g, '"');
            parsedMessages = JSON.parse(cleanedString);
        } else if (Array.isArray(messagesData)) {
            parsedMessages = messagesData;
        }
        return parsedMessages.map((msg, index)=>({
                id: msg.id || "msg-".concat(Date.now(), "-").concat(index),
                content: msg.text || msg.content || "",
                sender: msg.type === "client" ? "user" : msg.sender === "user" ? "user" : "agent",
                timestamp: new Date(msg.time || msg.timestamp || Date.now()),
                senderName: msg.senderName,
                imageUrl: msg.imageUrl || msg.attachment,
                fileName: msg.fileName,
                sessionId: msg.sessionId
            }));
    } catch (e) {
        console.error("Error parsing messages:", e);
        return [];
    }
};
function LiveChat() {
    _s();
    const t = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"])("support/ticket/components/live-chat");
    const { user } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useUserStore"])();
    const [isOpen, setIsOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isMinimized, setIsMinimized] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [messages, setMessages] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [newMessage, setNewMessage] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])("");
    const [session, setSession] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [unreadCount, setUnreadCount] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(0);
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false); // Fixed: removed duplicate declaration
    const [error, setError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [isTextareaFocused, setIsTextareaFocused] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [isUploading, setIsUploading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [wsConnected, setWsConnected] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const messagesEndRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const textareaRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const fileInputRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const scrollToBottom = ()=>{
        if (messagesEndRef.current) {
            const chatContainer = messagesEndRef.current.closest('.overflow-y-auto');
            if (chatContainer) {
                chatContainer.scrollTop = chatContainer.scrollHeight;
            } else {
                messagesEndRef.current.scrollIntoView({
                    behavior: "smooth",
                    block: "end",
                    inline: "nearest"
                });
            }
        }
    };
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LiveChat.useEffect": ()=>{
            scrollToBottom();
        }
    }["LiveChat.useEffect"], [
        messages
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LiveChat.useEffect": ()=>{
            if (isOpen) {
                setUnreadCount(0);
            }
        }
    }["LiveChat.useEffect"], [
        isOpen
    ]);
    // Auto-resize textarea based on content
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LiveChat.useEffect": ()=>{
            if (textareaRef.current) {
                textareaRef.current.style.height = "auto";
                textareaRef.current.style.height = "".concat(textareaRef.current.scrollHeight, "px");
            }
        }
    }["LiveChat.useEffect"], [
        newMessage
    ]);
    // WebSocket connection management for live chat
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LiveChat.useEffect": ()=>{
            if (!(session === null || session === void 0 ? void 0 : session.id)) return;
            const connectionId = "live-chat";
            const wsUrl = "".concat(window.location.protocol === "https:" ? "wss:" : "ws:", "//").concat(window.location.host, "/api/user/support/ticket");
            // Connect to WebSocket
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].connect(wsUrl, connectionId);
            // Subscribe to WebSocket status changes
            const handleStatusChange = {
                "LiveChat.useEffect.handleStatusChange": (status)=>{
                    setWsConnected(status === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED);
                    // Send subscribe message when connected
                    if (status === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
                        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].sendMessage({
                            action: "SUBSCRIBE",
                            payload: {
                                id: session.id
                            }
                        }, connectionId);
                    }
                }
            }["LiveChat.useEffect.handleStatusChange"];
            // Subscribe to chat messages
            const handleMessage = {
                "LiveChat.useEffect.handleMessage": (data)=>{
                    if (data.method) {
                        switch(data.method){
                            case "update":
                                {
                                    // Now consistently using 'payload' structure
                                    const updateData = data.payload;
                                    setSession({
                                        "LiveChat.useEffect.handleMessage": (prev)=>prev && updateData ? {
                                                ...prev,
                                                ...updateData,
                                                status: updateData.status ? mapTicketStatusToChatStatus(updateData.status) : prev.status,
                                                createdAt: updateData.createdAt ? new Date(updateData.createdAt) : prev.createdAt,
                                                updatedAt: updateData.updatedAt ? new Date(updateData.updatedAt) : prev.updatedAt
                                            } : null
                                    }["LiveChat.useEffect.handleMessage"]);
                                    break;
                                }
                            case "reply":
                                {
                                    // Now consistently using 'payload' structure
                                    const replyData = data.payload;
                                    if (replyData && replyData.message) {
                                        const messageContent = replyData.message.text || replyData.message.content || "";
                                        const messageTime = new Date(replyData.message.timestamp || replyData.message.time || Date.now());
                                        const messageSender = replyData.message.sender || (replyData.message.type === "client" ? "user" : "agent");
                                        const newMessage = {
                                            id: replyData.message.id || "server-".concat(replyData.message.time || Date.now(), "-").concat(Math.random().toString(36).substr(2, 9)),
                                            content: messageContent,
                                            sender: messageSender,
                                            timestamp: messageTime,
                                            senderName: replyData.message.senderName,
                                            imageUrl: replyData.message.imageUrl,
                                            fileName: replyData.message.fileName,
                                            sessionId: session.id,
                                            agentProfile: replyData.message.agentProfile
                                        };
                                        setMessages({
                                            "LiveChat.useEffect.handleMessage": (prev)=>{
                                                // Check if there's an optimistic message with the same content and sender that was sent recently (within 10 seconds)
                                                const optimisticIndex = prev.findIndex({
                                                    "LiveChat.useEffect.handleMessage.optimisticIndex": (msg)=>msg.content === messageContent && msg.sender === messageSender && Math.abs(msg.timestamp.getTime() - messageTime.getTime()) < 10000 // Within 10 seconds
                                                }["LiveChat.useEffect.handleMessage.optimisticIndex"]);
                                                if (optimisticIndex !== -1) {
                                                    // Replace the optimistic message with the confirmed one
                                                    const updated = [
                                                        ...prev
                                                    ];
                                                    updated[optimisticIndex] = newMessage;
                                                    return updated;
                                                } else if (prev.some({
                                                    "LiveChat.useEffect.handleMessage": (msg)=>msg.id === newMessage.id
                                                }["LiveChat.useEffect.handleMessage"])) {
                                                    // Avoid duplicate messages with same ID
                                                    return prev;
                                                } else {
                                                    // Add as new message
                                                    return [
                                                        ...prev,
                                                        newMessage
                                                    ];
                                                }
                                            }
                                        }["LiveChat.useEffect.handleMessage"]);
                                        // Count new messages for unread badge
                                        if (!isOpen || isMinimized) {
                                            setUnreadCount({
                                                "LiveChat.useEffect.handleMessage": (prev)=>prev + 1
                                            }["LiveChat.useEffect.handleMessage"]);
                                        }
                                    }
                                    // Update session status and updatedAt if provided
                                    if (replyData && (replyData.status || replyData.updatedAt)) {
                                        setSession({
                                            "LiveChat.useEffect.handleMessage": (prev)=>prev ? {
                                                    ...prev,
                                                    ...replyData.status && {
                                                        status: mapTicketStatusToChatStatus(replyData.status)
                                                    },
                                                    ...replyData.updatedAt && {
                                                        updatedAt: new Date(replyData.updatedAt)
                                                    },
                                                    ...replyData.agentId && {
                                                        agentId: replyData.agentId
                                                    },
                                                    ...replyData.agentName && {
                                                        agentName: replyData.agentName
                                                    }
                                                } : null
                                        }["LiveChat.useEffect.handleMessage"]);
                                    }
                                    break;
                                }
                            default:
                                console.log("Unknown WebSocket method:", data.method);
                                break;
                        }
                    }
                }
            }["LiveChat.useEffect.handleMessage"];
            // Add status listener and message subscriber
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].addStatusListener(handleStatusChange, connectionId);
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].subscribe("ticket-".concat(session.id), handleMessage, connectionId);
            // Cleanup on unmount
            return ({
                "LiveChat.useEffect": ()=>{
                    // Send unsubscribe message before cleaning up (only if connected)
                    if (__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].getStatus(connectionId) === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
                        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].sendMessage({
                            action: "UNSUBSCRIBE",
                            payload: {
                                id: session.id
                            }
                        }, connectionId);
                    }
                    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].removeStatusListener(handleStatusChange, connectionId);
                    __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].unsubscribe("ticket-".concat(session.id), handleMessage, connectionId);
                // Remove this line: wsManager.close(connectionId)
                // Keep the WebSocket connection open for potential reuse
                }
            })["LiveChat.useEffect"];
        }
    }["LiveChat.useEffect"], [
        session === null || session === void 0 ? void 0 : session.id,
        isOpen,
        isMinimized
    ]);
    // Listen for external events to open live chat
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LiveChat.useEffect": ()=>{
            const handleOpenLiveChat = {
                "LiveChat.useEffect.handleOpenLiveChat": (event)=>{
                    const { sessionId } = event.detail || {};
                    setIsOpen(true);
                    setIsMinimized(false);
                    // If a specific session ID is provided, try to resume that session
                    if (sessionId && !session) {
                        resumeOrStartChat(sessionId);
                    } else if (!session) {
                        // If no session exists, start a new one
                        startLiveChat();
                    }
                }
            }["LiveChat.useEffect.handleOpenLiveChat"];
            window.addEventListener("openLiveChat", handleOpenLiveChat);
            return ({
                "LiveChat.useEffect": ()=>{
                    window.removeEventListener("openLiveChat", handleOpenLiveChat);
                }
            })["LiveChat.useEffect"];
        }
    }["LiveChat.useEffect"], [
        session
    ]);
    const resumeOrStartChat = async (sessionId)=>{
        setIsLoading(true);
        setError(null);
        try {
            // Try to get existing session first
            const { data: existingData, error: fetchError } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
                url: sessionId ? "/api/user/support/ticket/".concat(sessionId) : "/api/user/support/chat",
                silent: true
            });
            if (existingData && !fetchError) {
                // Check if this is a ticket response (has subject, importance, etc.) or a chat session
                if (existingData.type === "LIVE" || existingData.subject === "Live Chat") {
                    // This is a live chat ticket, convert it to session format
                    const chatSession = {
                        id: existingData.id,
                        userId: existingData.userId,
                        status: mapTicketStatusToChatStatus(existingData.status),
                        agentId: existingData.agentId,
                        agentName: existingData.agentName,
                        messages: parseMessages(existingData.messages),
                        createdAt: new Date(existingData.createdAt),
                        updatedAt: new Date(existingData.updatedAt)
                    };
                    setSession(chatSession); // Set the converted session, not the original ticket
                    setMessages(chatSession.messages);
                } else if (existingData.messages !== undefined) {
                    // This is already a chat session format
                    setSession({
                        ...existingData,
                        createdAt: new Date(existingData.createdAt),
                        updatedAt: new Date(existingData.updatedAt)
                    });
                    setMessages(Array.isArray(existingData.messages) ? existingData.messages : []);
                } else {
                    // Create new session
                    await startLiveChat();
                }
            } else {
                // Create new session
                await startLiveChat();
            }
        } catch (error) {
            console.error("Error resuming chat:", error);
            // Fallback to creating new session
            await startLiveChat();
        } finally{
            setIsLoading(false);
        }
    };
    const startLiveChat = async ()=>{
        setIsLoading(true);
        setError(null);
        const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
            url: "/api/user/support/chat",
            silentSuccess: true,
            errorMessage: "Unable to connect to chat service"
        });
        if (data) {
            // Check if the response is a ticket format that needs conversion
            if (data.type === "LIVE" || data.subject === "Live Chat") {
                const chatSession = {
                    id: data.id,
                    userId: data.userId,
                    status: mapTicketStatusToChatStatus(data.status),
                    agentId: data.agentId,
                    agentName: data.agentName,
                    messages: parseMessages(data.messages),
                    createdAt: new Date(data.createdAt),
                    updatedAt: new Date(data.updatedAt)
                };
                setSession(chatSession);
                setMessages(chatSession.messages);
            } else {
                // Already in session format
                setSession({
                    ...data,
                    createdAt: new Date(data.createdAt),
                    updatedAt: new Date(data.updatedAt)
                });
                setMessages(Array.isArray(data.messages) ? data.messages : []);
            }
        } else if (error) {
            setError(error);
        }
        setIsLoading(false);
    };
    const handleFileUpload = async (event)=>{
        var _event_target_files;
        const file = (_event_target_files = event.target.files) === null || _event_target_files === void 0 ? void 0 : _event_target_files[0];
        if (!file || !session) return;
        // Check if file is an image
        if (!file.type.startsWith("image/")) {
            setError("Please select an image file");
            return;
        }
        // Check file size (max 10MB)
        if (file.size > 10 * 1024 * 1024) {
            setError("File size must be less than 10MB");
            return;
        }
        setIsUploading(true);
        setError(null);
        try {
            const uploadResult = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$utils$2f$upload$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["imageUploader"])({
                file,
                dir: "live-chat-images",
                size: {
                    maxWidth: 800,
                    maxHeight: 600
                }
            });
            if (uploadResult.success && uploadResult.url) {
                // Send image message via API (backend will notify WebSocket)
                const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
                    url: "/api/user/support/chat",
                    method: "POST",
                    body: {
                        sessionId: session.id,
                        content: "Shared an image: ".concat(file.name),
                        sender: "user",
                        imageUrl: uploadResult.url,
                        fileName: file.name
                    },
                    silent: true
                });
                if (error) {
                    setError("Failed to send image");
                }
            // Note: We don't add the message to UI here since it will come via WebSocket
            } else {
                setError(uploadResult.error || "Failed to upload image");
            }
        } catch (error) {
            console.error("Error uploading file:", error);
            setError("Failed to upload image");
        } finally{
            setIsUploading(false);
            // Reset file input
            if (fileInputRef.current) {
                fileInputRef.current.value = "";
            }
        }
    };
    const sendMessage = async ()=>{
        if (!newMessage.trim() || !session) return;
        const messageContent = newMessage;
        setNewMessage("");
        setError(null);
        // Add message optimistically to UI since WebSocket might not be working
        const userMessage = {
            id: "temp-".concat(Date.now()),
            content: messageContent,
            sender: "user",
            timestamp: new Date(),
            sessionId: session.id
        };
        setMessages((prev)=>[
                ...prev,
                userMessage
            ]);
        // Send via HTTP API
        const { data, error } = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
            url: "/api/user/support/chat",
            method: "POST",
            body: {
                sessionId: session.id,
                content: messageContent,
                sender: "user"
            },
            silent: true
        });
        if (error) {
            console.error("Failed to send message:", error);
            setError("Failed to send message. Please try again.");
            // Remove the optimistic message and restore input
            setMessages((prev)=>prev.filter((msg)=>msg.id !== userMessage.id));
            setNewMessage(messageContent);
        } else if (data) {
            // Update session with latest data if provided
            if (data.success) {
                // Remove the temporary message since it should come via WebSocket with real ID
                setMessages((prev)=>prev.filter((msg)=>msg.id !== userMessage.id));
                // Update session status if needed
                setSession((prev)=>prev ? {
                        ...prev,
                        updatedAt: new Date()
                    } : null);
            }
        }
    };
    const endChat = async ()=>{
        if (session) {
            // Send unsubscribe message if WebSocket is connected
            const connectionId = "live-chat";
            if (__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].getStatus(connectionId) === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].sendMessage({
                    action: "UNSUBSCRIBE",
                    payload: {
                        id: session.id
                    }
                }, connectionId);
            }
            // Remove listeners for this specific session
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].unsubscribe("ticket-".concat(session.id), ()=>{}, connectionId);
            // Call the API to end the session
            await (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$lib$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["$fetch"])({
                url: "/api/user/support/chat",
                method: "DELETE",
                body: {
                    sessionId: session.id
                },
                silent: true
            });
        }
        setSession(null);
        setMessages([]);
        setUnreadCount(0);
        setError(null);
        setIsOpen(false);
    };
    const handleCloseChat = ()=>{
        if (session) {
            const connectionId = "live-chat";
            // Send unsubscribe message if WebSocket is connected
            if (__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].getStatus(connectionId) === __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionStatus"].CONNECTED) {
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].sendMessage({
                    action: "UNSUBSCRIBE",
                    payload: {
                        id: session.id
                    }
                }, connectionId);
            }
            // Remove listeners for this specific session
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$services$2f$ws$2d$manager$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["wsManager"].unsubscribe("ticket-".concat(session.id), ()=>{}, connectionId);
        }
        setIsOpen(false);
    // Keep session data so it can be resumed later
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "fixed bottom-6 right-6 z-50",
        children: [
            !isOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "relative",
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                        onClick: ()=>setIsOpen(true),
                        className: "rounded-full h-12 w-12 shadow-2xl hover:shadow-3xl transition-all duration-300 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white transform hover:scale-105",
                        size: "icon",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$message$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MessageCircle$3e$__["MessageCircle"], {
                            className: "h-5 w-5"
                        }, void 0, false, {
                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                            lineNumber: 623,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                        lineNumber: 618,
                        columnNumber: 11
                    }, this),
                    unreadCount > 0 && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$badge$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Badge"], {
                        className: "absolute -top-2 -right-2 h-6 w-6 rounded-full bg-red-500 text-white text-xs flex items-center justify-center animate-bounce",
                        children: unreadCount
                    }, void 0, false, {
                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                        lineNumber: 626,
                        columnNumber: 13
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                lineNumber: 617,
                columnNumber: 9
            }, this),
            isOpen && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Card"], {
                className: "w-96 shadow-2xl border-0 bg-white dark:bg-zinc-900 transition-all duration-300 ".concat(isMinimized ? "h-16" : "h-[32rem]", " rounded-2xl overflow-hidden"),
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CardHeader"], {
                        className: "pb-2 px-4 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex items-center justify-between",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex items-center gap-3",
                                    children: [
                                        (session === null || session === void 0 ? void 0 : session.status) === "CONNECTED" && session.agentName && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Avatar"], {
                                            className: "h-8 w-8 border-2 border-white/20",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AvatarFallback"], {
                                                className: "bg-blue-500 text-white text-xs font-semibold",
                                                children: session.agentName.split(" ").map((n)=>n[0]).join("").substring(0, 2)
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 642,
                                                columnNumber: 21
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 641,
                                            columnNumber: 19
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CardTitle"], {
                                                    className: "text-sm font-medium",
                                                    children: (session === null || session === void 0 ? void 0 : session.status) === "CONNECTED" ? session.agentName || "Support Agent" : (session === null || session === void 0 ? void 0 : session.status) === "WAITING" ? "Waiting for agent..." : "Live Support"
                                                }, void 0, false, {
                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                    lineNumber: 648,
                                                    columnNumber: 19
                                                }, this),
                                                (session === null || session === void 0 ? void 0 : session.status) === "WAITING" && session.queuePosition && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                    className: "text-xs text-blue-100",
                                                    children: [
                                                        t("position_#"),
                                                        session.queuePosition,
                                                        session.estimatedWaitTime && " • ~".concat(session.estimatedWaitTime, "min wait")
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                    lineNumber: 656,
                                                    columnNumber: 21
                                                }, this),
                                                (session === null || session === void 0 ? void 0 : session.status) === "CONNECTED" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "text-xs text-blue-100 flex items-center gap-1",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "w-2 h-2 bg-green-400 rounded-full animate-pulse"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                            lineNumber: 665,
                                                            columnNumber: 23
                                                        }, this),
                                                        t("Online")
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                    lineNumber: 664,
                                                    columnNumber: 21
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 647,
                                            columnNumber: 17
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 639,
                                    columnNumber: 15
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex gap-1",
                                    children: [
                                        (session === null || session === void 0 ? void 0 : session.status) === "CONNECTED" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                            variant: "ghost",
                                            size: "sm",
                                            onClick: endChat,
                                            className: "text-xs text-white hover:bg-white/20 px-2 py-1",
                                            children: t("end_chat")
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 673,
                                            columnNumber: 19
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                            variant: "ghost",
                                            size: "icon",
                                            className: "h-7 w-7 text-white hover:bg-white/20",
                                            onClick: ()=>setIsMinimized(!isMinimized),
                                            children: isMinimized ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$maximize$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Maximize2$3e$__["Maximize2"], {
                                                className: "h-4 w-4"
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 689,
                                                columnNumber: 21
                                            }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$minimize$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Minimize2$3e$__["Minimize2"], {
                                                className: "h-4 w-4"
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 691,
                                                columnNumber: 21
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 682,
                                            columnNumber: 17
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                            variant: "ghost",
                                            size: "icon",
                                            className: "h-7 w-7 text-white hover:bg-white/20",
                                            onClick: handleCloseChat,
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__["X"], {
                                                className: "h-4 w-4"
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 700,
                                                columnNumber: 19
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 694,
                                            columnNumber: 17
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 671,
                                    columnNumber: 15
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                            lineNumber: 638,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                        lineNumber: 637,
                        columnNumber: 11
                    }, this),
                    !isMinimized && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$card$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CardContent"], {
                        className: "p-0 flex flex-col h-[28rem]",
                        children: !session ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex-1 flex flex-col items-center justify-center p-6 text-center bg-gradient-to-b from-blue-50 to-white dark:from-zinc-800 dark:to-zinc-900",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "w-16 h-16 bg-gradient-to-r from-blue-500 to-blue-600 rounded-full flex items-center justify-center mb-6",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$message$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MessageCircle$3e$__["MessageCircle"], {
                                        className: "h-8 w-8 text-white"
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                        lineNumber: 711,
                                        columnNumber: 21
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 710,
                                    columnNumber: 19
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                    className: "text-lg font-semibold mb-2 text-gray-900 dark:text-zinc-100",
                                    children: t("start_live_chat")
                                }, void 0, false, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 713,
                                    columnNumber: 19
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                    className: "text-sm text-gray-600 dark:text-zinc-400 mb-6 max-w-sm",
                                    children: [
                                        t("connect_instantly_with_our_expert_support_team"),
                                        ".",
                                        " ",
                                        t("were_here_to_help_you_with_any_questions_or_issues"),
                                        "."
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 716,
                                    columnNumber: 19
                                }, this),
                                error && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "mb-4 p-3 bg-red-50 dark:bg-red-950 border border-red-200 dark:border-red-800 rounded-lg",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                        className: "text-sm text-red-600 dark:text-red-400",
                                        children: error
                                    }, void 0, false, {
                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                        lineNumber: 722,
                                        columnNumber: 23
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 721,
                                    columnNumber: 21
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                    onClick: startLiveChat,
                                    disabled: isLoading,
                                    className: "w-full bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white shadow-lg hover:shadow-xl transition-all duration-200 transform hover:scale-105 disabled:opacity-50 disabled:cursor-not-allowed disabled:transform-none",
                                    size: "lg",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$message$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MessageCircle$3e$__["MessageCircle"], {
                                            className: "h-4 w-4 mr-2"
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 733,
                                            columnNumber: 21
                                        }, this),
                                        isLoading ? "Connecting..." : "Start Chat Now"
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 727,
                                    columnNumber: 19
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                            lineNumber: 709,
                            columnNumber: 17
                        }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Fragment"], {
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "flex-1 overflow-y-auto p-4 space-y-4 bg-gray-50 dark:bg-zinc-800",
                                    children: [
                                        session.status === "WAITING" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "text-center",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "inline-flex items-center gap-2 bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200 px-4 py-2 rounded-full text-sm",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "flex gap-1",
                                                        children: [
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "w-2 h-2 bg-blue-500 rounded-full animate-pulse"
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 744,
                                                                columnNumber: 29
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "w-2 h-2 bg-blue-500 rounded-full animate-pulse",
                                                                style: {
                                                                    animationDelay: "0.2s"
                                                                }
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 745,
                                                                columnNumber: 29
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "w-2 h-2 bg-blue-500 rounded-full animate-pulse",
                                                                style: {
                                                                    animationDelay: "0.4s"
                                                                }
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 749,
                                                                columnNumber: 29
                                                            }, this)
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 743,
                                                        columnNumber: 27
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                        children: [
                                                            t("waiting_for_an_agent"),
                                                            "."
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 754,
                                                        columnNumber: 27
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 742,
                                                columnNumber: 25
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 741,
                                            columnNumber: 23
                                        }, this),
                                        Array.isArray(messages) && messages.map((message)=>{
                                            var _message_agentProfile, _user_firstName, _user_lastName;
                                            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "flex gap-3 ".concat(message.sender === "user" ? "justify-end" : "justify-start", " ").concat(message.sender === "system" ? "justify-center" : ""),
                                                children: [
                                                    message.sender === "agent" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Avatar"], {
                                                        className: "h-8 w-8 border-2 border-white shadow-md",
                                                        children: [
                                                            ((_message_agentProfile = message.agentProfile) === null || _message_agentProfile === void 0 ? void 0 : _message_agentProfile.avatar) && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AvatarImage"], {
                                                                src: message.agentProfile.avatar,
                                                                alt: "".concat(message.agentProfile.firstName, " ").concat(message.agentProfile.lastName)
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 770,
                                                                columnNumber: 33
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AvatarFallback"], {
                                                                className: "text-xs bg-gradient-to-r from-blue-500 to-blue-600 text-white font-semibold",
                                                                children: (()=>{
                                                                    var _message_agentProfile, _message_agentProfile1;
                                                                    let initials = "SA";
                                                                    // Try to get initials from agent profile first
                                                                    if (((_message_agentProfile = message.agentProfile) === null || _message_agentProfile === void 0 ? void 0 : _message_agentProfile.firstName) || ((_message_agentProfile1 = message.agentProfile) === null || _message_agentProfile1 === void 0 ? void 0 : _message_agentProfile1.lastName)) {
                                                                        const firstName = message.agentProfile.firstName || "";
                                                                        const lastName = message.agentProfile.lastName || "";
                                                                        initials = "".concat(firstName.charAt(0)).concat(lastName.charAt(0)).toUpperCase().substring(0, 2);
                                                                    } else if (message.senderName) {
                                                                        initials = message.senderName.split(" ").map((n)=>n[0]).join("").substring(0, 2);
                                                                    } else if (session === null || session === void 0 ? void 0 : session.agentName) {
                                                                        initials = session.agentName.split(" ").map((n)=>n[0]).join("").substring(0, 2);
                                                                    }
                                                                    return initials;
                                                                })()
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 772,
                                                                columnNumber: 31
                                                            }, this)
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 768,
                                                        columnNumber: 29
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "max-w-[85%] ".concat(message.sender === "user" ? "order-first" : ""),
                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "rounded-2xl px-4 py-2 ".concat(message.sender === "user" ? "bg-gradient-to-r from-blue-500 to-blue-600 text-white shadow-lg" : message.sender === "system" ? "bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-200 text-center text-xs py-1 px-3" : "bg-white dark:bg-zinc-700 border border-gray-200 dark:border-zinc-600 text-gray-900 dark:text-zinc-100 shadow-md"),
                                                            children: [
                                                                message.imageUrl ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "space-y-2",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("img", {
                                                                            src: message.imageUrl || "/placeholder.svg",
                                                                            alt: message.fileName || "Uploaded image",
                                                                            className: "max-w-full h-auto rounded-lg",
                                                                            style: {
                                                                                maxHeight: "200px"
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                            lineNumber: 811,
                                                                            columnNumber: 35
                                                                        }, this),
                                                                        message.fileName && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                            className: "text-xs ".concat(message.sender === "user" ? "text-blue-100" : "text-gray-500 dark:text-zinc-400"),
                                                                            children: message.fileName
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                            lineNumber: 818,
                                                                            columnNumber: 37
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                    lineNumber: 810,
                                                                    columnNumber: 33
                                                                }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                    className: "text-sm ".concat(message.sender === "system" ? "text-xs" : ""),
                                                                    children: message.content
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                    lineNumber: 826,
                                                                    columnNumber: 33
                                                                }, this),
                                                                message.sender !== "system" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                    className: "text-xs mt-1 ".concat(message.sender === "user" ? "text-blue-100" : "text-gray-500 dark:text-zinc-400"),
                                                                    children: new Date(message.timestamp).toLocaleTimeString([], {
                                                                        hour: "2-digit",
                                                                        minute: "2-digit"
                                                                    })
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                    lineNumber: 833,
                                                                    columnNumber: 33
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                            lineNumber: 800,
                                                            columnNumber: 29
                                                        }, this)
                                                    }, void 0, false, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 797,
                                                        columnNumber: 27
                                                    }, this),
                                                    message.sender === "user" && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Avatar"], {
                                                        className: "h-8 w-8 border-2 border-white shadow-md",
                                                        children: [
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AvatarImage"], {
                                                                src: (user === null || user === void 0 ? void 0 : user.avatar) || "/placeholder.svg?height=32&width=32&query=user avatar"
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 853,
                                                                columnNumber: 31
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$avatar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AvatarFallback"], {
                                                                className: "bg-gradient-to-r from-gray-500 to-gray-600 text-white text-xs",
                                                                children: (user === null || user === void 0 ? void 0 : (_user_firstName = user.firstName) === null || _user_firstName === void 0 ? void 0 : _user_firstName.charAt(0)) || (user === null || user === void 0 ? void 0 : (_user_lastName = user.lastName) === null || _user_lastName === void 0 ? void 0 : _user_lastName.charAt(0)) || /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$user$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__User$3e$__["User"], {
                                                                    className: "h-4 w-4"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                    lineNumber: 855,
                                                                    columnNumber: 93
                                                                }, this)
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 854,
                                                                columnNumber: 31
                                                            }, this)
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 852,
                                                        columnNumber: 29
                                                    }, this)
                                                ]
                                            }, message.id, true, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 761,
                                                columnNumber: 25
                                            }, this);
                                        }),
                                        isUploading && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "flex justify-end",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "bg-gradient-to-r from-blue-500 to-blue-600 text-white rounded-2xl px-4 py-2 shadow-lg",
                                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "flex items-center gap-2",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$loader$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Loader2$3e$__["Loader2"], {
                                                            className: "h-4 w-4 animate-spin"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                            lineNumber: 866,
                                                            columnNumber: 29
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                            className: "text-sm",
                                                            children: [
                                                                t("uploading_image"),
                                                                "."
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                            lineNumber: 867,
                                                            columnNumber: 29
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                    lineNumber: 865,
                                                    columnNumber: 27
                                                }, this)
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 864,
                                                columnNumber: 25
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 863,
                                            columnNumber: 23
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            ref: messagesEndRef
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                            lineNumber: 875,
                                            columnNumber: 21
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 739,
                                    columnNumber: 19
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "p-4 border-t border-gray-200 dark:border-zinc-700 bg-white dark:bg-zinc-900",
                                    children: session.status === "CONNECTED" || session.status === "WAITING" ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "space-y-2",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "flex gap-2 items-end",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "flex-1 relative",
                                                        children: [
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$textarea$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Textarea"], {
                                                                ref: textareaRef,
                                                                value: newMessage,
                                                                onChange: (e)=>setNewMessage(e.target.value),
                                                                onFocus: ()=>setIsTextareaFocused(true),
                                                                onBlur: ()=>setIsTextareaFocused(false),
                                                                placeholder: session.status === "WAITING" ? "Type your message (will be sent when agent connects)..." : "Type your message...",
                                                                className: "flex-1 text-sm resize-none bg-gray-50 dark:bg-zinc-800 border-gray-200 dark:border-zinc-700 rounded-xl focus:ring-2 focus:ring-blue-500 pr-10 transition-all duration-200 ".concat(isTextareaFocused || newMessage.length > 0 ? "min-h-[40px] max-h-[120px]" : "h-[40px] max-h-[40px] overflow-hidden"),
                                                                style: {
                                                                    height: isTextareaFocused || newMessage.length > 0 ? "auto" : "40px"
                                                                },
                                                                onKeyPress: (e)=>{
                                                                    if (e.key === "Enter" && !e.shiftKey) {
                                                                        e.preventDefault();
                                                                        sendMessage();
                                                                    }
                                                                }
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 884,
                                                                columnNumber: 29
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                                                variant: "ghost",
                                                                size: "icon",
                                                                onClick: ()=>{
                                                                    var _fileInputRef_current;
                                                                    return (_fileInputRef_current = fileInputRef.current) === null || _fileInputRef_current === void 0 ? void 0 : _fileInputRef_current.click();
                                                                },
                                                                disabled: isUploading,
                                                                className: "absolute right-1 bottom-1 h-6 w-6 text-gray-400 hover:text-gray-600",
                                                                children: isUploading ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$loader$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Loader2$3e$__["Loader2"], {
                                                                    className: "h-4 w-4 animate-spin"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                    lineNumber: 921,
                                                                    columnNumber: 33
                                                                }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$paperclip$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Paperclip$3e$__["Paperclip"], {
                                                                    className: "h-4 w-4"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                    lineNumber: 923,
                                                                    columnNumber: 33
                                                                }, this)
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 913,
                                                                columnNumber: 29
                                                            }, this)
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 883,
                                                        columnNumber: 27
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                                        onClick: sendMessage,
                                                        disabled: !newMessage.trim() || isUploading,
                                                        size: "icon",
                                                        className: "bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white shadow-lg hover:shadow-xl transition-all duration-200 h-[40px] w-[40px] rounded-xl flex-shrink-0",
                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lucide$2d$react$40$0$2e$468$2e$0_react$40$19$2e$1$2e$1$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$send$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Send$3e$__["Send"], {
                                                            className: "h-4 w-4"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                            lineNumber: 933,
                                                            columnNumber: 29
                                                        }, this)
                                                    }, void 0, false, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 927,
                                                        columnNumber: 27
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 882,
                                                columnNumber: 25
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "flex items-center justify-between text-xs text-gray-500 dark:text-zinc-400",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                        children: t("press_enter_to_send_shift+enter_for_new_line")
                                                    }, void 0, false, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 937,
                                                        columnNumber: 27
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "flex items-center gap-2",
                                                        children: [
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "w-2 h-2 rounded-full ".concat(wsConnected ? "bg-green-500" : "bg-gray-400")
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 941,
                                                                columnNumber: 29
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                                children: wsConnected ? "Connected" : "Connecting..."
                                                            }, void 0, false, {
                                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                                lineNumber: 944,
                                                                columnNumber: 29
                                                            }, this)
                                                        ]
                                                    }, void 0, true, {
                                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                        lineNumber: 940,
                                                        columnNumber: 27
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 936,
                                                columnNumber: 25
                                            }, this),
                                            error && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "p-2 bg-red-50 dark:bg-red-950 border border-red-200 dark:border-red-800 rounded-lg",
                                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                    className: "text-xs text-red-600 dark:text-red-400",
                                                    children: error
                                                }, void 0, false, {
                                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                    lineNumber: 951,
                                                    columnNumber: 29
                                                }, this)
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 950,
                                                columnNumber: 27
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                        lineNumber: 881,
                                        columnNumber: 23
                                    }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "text-center",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                className: "text-sm text-gray-500 dark:text-zinc-400 mb-3",
                                                children: t("chat_session_has_ended")
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 959,
                                                columnNumber: 25
                                            }, this),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$components$2f$ui$2f$button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Button"], {
                                                variant: "outline",
                                                size: "sm",
                                                onClick: ()=>setIsOpen(false),
                                                className: "border-gray-200 dark:border-zinc-700 text-gray-900 dark:text-zinc-100",
                                                children: t("Close")
                                            }, void 0, false, {
                                                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                                lineNumber: 962,
                                                columnNumber: 25
                                            }, this)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                        lineNumber: 958,
                                        columnNumber: 23
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                                    lineNumber: 878,
                                    columnNumber: 19
                                }, this)
                            ]
                        }, void 0, true)
                    }, void 0, false, {
                        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                        lineNumber: 707,
                        columnNumber: 13
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                lineNumber: 634,
                columnNumber: 9
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                ref: fileInputRef,
                type: "file",
                accept: "image/*",
                onChange: handleFileUpload,
                className: "hidden"
            }, void 0, false, {
                fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
                lineNumber: 981,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx",
        lineNumber: 615,
        columnNumber: 5
    }, this);
}
_s(LiveChat, "00K2n/Ee8ZKQwusxf4Dy1qKCWNo=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$2d$intl$40$4$2e$3$2e$4_next$40$15$2e$5$2e$4_b3bf31b962ed33195b62be321e96b2b6$2f$node_modules$2f$next$2d$intl$2f$dist$2f$esm$2f$development$2f$react$2d$client$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__["useTranslations"],
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$store$2f$user$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useUserStore"]
    ];
});
_c = LiveChat;
var _c;
__turbopack_context__.k.register(_c, "LiveChat");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx [app-client] (ecmascript, next/dynamic entry)", ((__turbopack_context__) => {

__turbopack_context__.n(__turbopack_context__.i("[project]/frontend/app/[locale]/support/ticket/components/live-chat.tsx [app-client] (ecmascript)"));
}),
]);

//# sourceMappingURL=frontend_af7b0c6a._.js.map