(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/SwapCalculationUtil.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// -- Types --------------------------------------------- //
__turbopack_context__.s([
    "SwapCalculationUtil",
    ()=>SwapCalculationUtil
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
;
const SwapCalculationUtil = {
    getGasPriceInEther (gas, gasPrice) {
        const totalGasCostInWei = gasPrice * gas;
        const totalGasCostInEther = Number(totalGasCostInWei) / 1e18;
        return totalGasCostInEther;
    },
    getGasPriceInUSD (networkPrice, gas, gasPrice) {
        const totalGasCostInEther = SwapCalculationUtil.getGasPriceInEther(gas, gasPrice);
        const networkPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(networkPrice);
        const gasCostInUSD = networkPriceInUSD.times(totalGasCostInEther);
        return gasCostInUSD.toNumber();
    },
    getPriceImpact (param) {
        let { sourceTokenAmount, sourceTokenPriceInUSD, toTokenPriceInUSD, toTokenAmount } = param;
        const inputValue = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(sourceTokenAmount).times(sourceTokenPriceInUSD);
        const outputValue = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(toTokenAmount).times(toTokenPriceInUSD);
        const priceImpact = inputValue.minus(outputValue).div(inputValue).times(100);
        return priceImpact.toNumber();
    },
    getMaxSlippage (slippage, toTokenAmount) {
        const slippageToleranceDecimal = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(slippage).div(100);
        const maxSlippageAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].multiply(toTokenAmount, slippageToleranceDecimal);
        return maxSlippageAmount.toNumber();
    },
    getProviderFee (sourceTokenAmount) {
        let feePercentage = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0.0085;
        const providerFee = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(sourceTokenAmount).times(feePercentage);
        return providerFee.toString();
    },
    isInsufficientNetworkTokenForGas (networkBalanceInUSD, gasPriceInUSD) {
        const gasPrice = gasPriceInUSD || '0';
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(networkBalanceInUSD).eq(0)) {
            return true;
        }
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(gasPrice)).gt(networkBalanceInUSD);
    },
    isInsufficientSourceTokenForSwap (sourceTokenAmount, sourceTokenAddress, balance) {
        var _balance_find_quantity, _balance_find;
        const sourceTokenBalance = balance === null || balance === void 0 ? void 0 : (_balance_find = balance.find((token)=>token.address === sourceTokenAddress)) === null || _balance_find === void 0 ? void 0 : (_balance_find_quantity = _balance_find.quantity) === null || _balance_find_quantity === void 0 ? void 0 : _balance_find_quantity.numeric;
        const isInSufficientBalance = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(sourceTokenBalance || '0').lt(sourceTokenAmount);
        return isInSufficientBalance;
    }
}; //# sourceMappingURL=SwapCalculationUtil.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/SwapController.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "INITIAL_GAS_LIMIT",
    ()=>INITIAL_GAS_LIMIT,
    "SwapController",
    ()=>SwapController,
    "TO_AMOUNT_DECIMALS",
    ()=>TO_AMOUNT_DECIMALS
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$valtio$40$2$2e$1$2e$7_$40$types$2b$react$40$19$2e$1$2e$9_react$40$19$2e$1$2e$1$2f$node_modules$2f$valtio$2f$esm$2f$vanilla$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/valtio@2.1.7_@types+react@19.1.9_react@19.1.1/node_modules/valtio/esm/vanilla.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$valtio$40$2$2e$1$2e$7_$40$types$2b$react$40$19$2e$1$2e$9_react$40$19$2e$1$2e$1$2f$node_modules$2f$valtio$2f$esm$2f$vanilla$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/valtio@2.1.7_@types+react@19.1.9_react@19.1.1/node_modules/valtio/esm/vanilla/utils.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/ConstantsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$wallet$40$1$2e$8$2e$12_2a80c740d42bc806b726af94f1528827$2f$node_modules$2f40$reown$2f$appkit$2d$wallet$2f$dist$2f$esm$2f$src$2f$W3mFrameConstants$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-wallet@1.8.12_2a80c740d42bc806b726af94f1528827/node_modules/@reown/appkit-wallet/dist/esm/src/W3mFrameConstants.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$BalanceUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/BalanceUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/ChainControllerUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/ConstantsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$CoreHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/CoreHelperUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapApiUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/SwapApiUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/SwapCalculationUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$withErrorBoundary$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/withErrorBoundary.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$AlertController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/AlertController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/BlockchainApiController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ChainController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ConnectionController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ConnectionController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ConnectorController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ConnectorController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/EventsController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/RouterController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/SnackController.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
const INITIAL_GAS_LIMIT = 150000;
const TO_AMOUNT_DECIMALS = 6;
class TransactionError extends Error {
    constructor(message, displayMessage){
        super(message);
        this.name = 'TransactionError';
        this.displayMessage = displayMessage;
    }
}
// -- State --------------------------------------------- //
const initialState = {
    // Loading states
    initializing: false,
    initialized: false,
    loadingPrices: false,
    loadingQuote: false,
    loadingApprovalTransaction: false,
    loadingBuildTransaction: false,
    loadingTransaction: false,
    // Control states
    switchingTokens: false,
    // Error states
    fetchError: false,
    // Approval & Swap transaction states
    approvalTransaction: undefined,
    swapTransaction: undefined,
    transactionError: undefined,
    // Input values
    sourceToken: undefined,
    sourceTokenAmount: '',
    sourceTokenPriceInUSD: 0,
    toToken: undefined,
    toTokenAmount: '',
    toTokenPriceInUSD: 0,
    networkPrice: '0',
    networkBalanceInUSD: '0',
    networkTokenSymbol: '',
    inputError: undefined,
    // Request values
    slippage: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CONVERT_SLIPPAGE_TOLERANCE,
    // Tokens
    tokens: undefined,
    popularTokens: undefined,
    suggestedTokens: undefined,
    foundTokens: undefined,
    myTokensWithBalance: undefined,
    tokensPriceMap: {},
    // Calculations
    gasFee: '0',
    gasPriceInUSD: 0,
    priceImpact: undefined,
    maxSlippage: undefined,
    providerFee: undefined
};
const state = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$valtio$40$2$2e$1$2e$7_$40$types$2b$react$40$19$2e$1$2e$9_react$40$19$2e$1$2e$1$2f$node_modules$2f$valtio$2f$esm$2f$vanilla$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["proxy"])({
    ...initialState
});
// -- Controller ---------------------------------------- //
const controller = {
    state,
    subscribe (callback) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$valtio$40$2$2e$1$2e$7_$40$types$2b$react$40$19$2e$1$2e$9_react$40$19$2e$1$2e$1$2f$node_modules$2f$valtio$2f$esm$2f$vanilla$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["subscribe"])(state, ()=>callback(state));
    },
    subscribeKey (key, callback) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$valtio$40$2$2e$1$2e$7_$40$types$2b$react$40$19$2e$1$2e$9_react$40$19$2e$1$2e$1$2f$node_modules$2f$valtio$2f$esm$2f$vanilla$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["subscribeKey"])(state, key, callback);
    },
    getParams () {
        var _ChainController_getAccountData, _state_toToken, _state_toToken1, _state_sourceToken, _state_sourceToken1, _state_sourceToken2, _state_toToken2, _state_toToken3, _state_sourceToken3;
        const namespace = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeChain;
        var _ChainController_getAccountData_caipAddress;
        const caipAddress = (_ChainController_getAccountData_caipAddress = (_ChainController_getAccountData = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].getAccountData(namespace)) === null || _ChainController_getAccountData === void 0 ? void 0 : _ChainController_getAccountData.caipAddress) !== null && _ChainController_getAccountData_caipAddress !== void 0 ? _ChainController_getAccountData_caipAddress : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipAddress;
        const address = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$CoreHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CoreHelperUtil"].getPlainAddress(caipAddress);
        const networkAddress = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getActiveNetworkTokenAddress"])();
        const connectorId = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ConnectorController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectorController"].getConnectorId(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeChain);
        if (!address) {
            throw new Error('No address found to swap the tokens from.');
        }
        const invalidToToken = !((_state_toToken = state.toToken) === null || _state_toToken === void 0 ? void 0 : _state_toToken.address) || !((_state_toToken1 = state.toToken) === null || _state_toToken1 === void 0 ? void 0 : _state_toToken1.decimals);
        const invalidSourceToken = !((_state_sourceToken = state.sourceToken) === null || _state_sourceToken === void 0 ? void 0 : _state_sourceToken.address) || !((_state_sourceToken1 = state.sourceToken) === null || _state_sourceToken1 === void 0 ? void 0 : _state_sourceToken1.decimals) || !__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(state.sourceTokenAmount).gt(0);
        const invalidSourceTokenAmount = !state.sourceTokenAmount;
        return {
            networkAddress,
            fromAddress: address,
            fromCaipAddress: caipAddress,
            sourceTokenAddress: (_state_sourceToken2 = state.sourceToken) === null || _state_sourceToken2 === void 0 ? void 0 : _state_sourceToken2.address,
            toTokenAddress: (_state_toToken2 = state.toToken) === null || _state_toToken2 === void 0 ? void 0 : _state_toToken2.address,
            toTokenAmount: state.toTokenAmount,
            toTokenDecimals: (_state_toToken3 = state.toToken) === null || _state_toToken3 === void 0 ? void 0 : _state_toToken3.decimals,
            sourceTokenAmount: state.sourceTokenAmount,
            sourceTokenDecimals: (_state_sourceToken3 = state.sourceToken) === null || _state_sourceToken3 === void 0 ? void 0 : _state_sourceToken3.decimals,
            invalidToToken,
            invalidSourceToken,
            invalidSourceTokenAmount,
            availableToSwap: caipAddress && !invalidToToken && !invalidSourceToken && !invalidSourceTokenAmount,
            isAuthConnector: connectorId === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CONNECTOR_ID.AUTH
        };
    },
    async setSourceToken (sourceToken) {
        if (!sourceToken) {
            state.sourceToken = sourceToken;
            state.sourceTokenAmount = '';
            state.sourceTokenPriceInUSD = 0;
            return;
        }
        state.sourceToken = sourceToken;
        await SwapController.setTokenPrice(sourceToken.address, 'sourceToken');
    },
    setSourceTokenAmount (amount) {
        state.sourceTokenAmount = amount;
    },
    async setToToken (toToken) {
        if (!toToken) {
            state.toToken = toToken;
            state.toTokenAmount = '';
            state.toTokenPriceInUSD = 0;
            return;
        }
        state.toToken = toToken;
        await SwapController.setTokenPrice(toToken.address, 'toToken');
    },
    setToTokenAmount (amount) {
        state.toTokenAmount = amount ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].toFixed(amount, TO_AMOUNT_DECIMALS) : '';
    },
    async setTokenPrice (address, target) {
        let price = state.tokensPriceMap[address] || 0;
        if (!price) {
            state.loadingPrices = true;
            price = await SwapController.getAddressPrice(address);
        }
        if (target === 'sourceToken') {
            state.sourceTokenPriceInUSD = price;
        } else if (target === 'toToken') {
            state.toTokenPriceInUSD = price;
        }
        if (state.loadingPrices) {
            state.loadingPrices = false;
        }
        if (SwapController.getParams().availableToSwap && !state.switchingTokens) {
            SwapController.swapTokens();
        }
    },
    async switchTokens () {
        if (state.initializing || !state.initialized || state.switchingTokens) {
            return;
        }
        state.switchingTokens = true;
        try {
            const newSourceToken = state.toToken ? {
                ...state.toToken
            } : undefined;
            const newToToken = state.sourceToken ? {
                ...state.sourceToken
            } : undefined;
            const newSourceTokenAmount = newSourceToken && state.toTokenAmount === '' ? '1' : state.toTokenAmount;
            SwapController.setSourceTokenAmount(newSourceTokenAmount);
            SwapController.setToTokenAmount('');
            await SwapController.setSourceToken(newSourceToken);
            await SwapController.setToToken(newToToken);
            state.switchingTokens = false;
            SwapController.swapTokens();
        } catch (error) {
            state.switchingTokens = false;
            throw error;
        }
    },
    resetState () {
        state.myTokensWithBalance = initialState.myTokensWithBalance;
        state.tokensPriceMap = initialState.tokensPriceMap;
        state.initialized = initialState.initialized;
        state.initializing = initialState.initializing;
        state.switchingTokens = initialState.switchingTokens;
        state.sourceToken = initialState.sourceToken;
        state.sourceTokenAmount = initialState.sourceTokenAmount;
        state.sourceTokenPriceInUSD = initialState.sourceTokenPriceInUSD;
        state.toToken = initialState.toToken;
        state.toTokenAmount = initialState.toTokenAmount;
        state.toTokenPriceInUSD = initialState.toTokenPriceInUSD;
        state.networkPrice = initialState.networkPrice;
        state.networkTokenSymbol = initialState.networkTokenSymbol;
        state.networkBalanceInUSD = initialState.networkBalanceInUSD;
        state.inputError = initialState.inputError;
    },
    resetValues () {
        var _state_tokens;
        const { networkAddress } = SwapController.getParams();
        const networkToken = (_state_tokens = state.tokens) === null || _state_tokens === void 0 ? void 0 : _state_tokens.find((token)=>token.address === networkAddress);
        SwapController.setSourceToken(networkToken);
        SwapController.setToToken(undefined);
    },
    getApprovalLoadingState () {
        return state.loadingApprovalTransaction;
    },
    clearError () {
        state.transactionError = undefined;
    },
    async initializeState () {
        if (state.initializing) {
            return;
        }
        state.initializing = true;
        if (!state.initialized) {
            try {
                await SwapController.fetchTokens();
                state.initialized = true;
            } catch (error) {
                state.initialized = false;
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError('Failed to initialize swap');
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
            }
        }
        state.initializing = false;
    },
    async fetchTokens () {
        var _state_myTokensWithBalance;
        const { networkAddress } = SwapController.getParams();
        await SwapController.getNetworkTokenPrice();
        await SwapController.getMyTokensWithBalance();
        const networkToken = (_state_myTokensWithBalance = state.myTokensWithBalance) === null || _state_myTokensWithBalance === void 0 ? void 0 : _state_myTokensWithBalance.find((token)=>token.address === networkAddress);
        if (networkToken) {
            state.networkTokenSymbol = networkToken.symbol;
            SwapController.setSourceToken(networkToken);
            SwapController.setSourceTokenAmount('0');
        }
    },
    async getTokenList () {
        var _ChainController_state_activeCaipNetwork;
        const activeCaipNetworkId = (_ChainController_state_activeCaipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork === void 0 ? void 0 : _ChainController_state_activeCaipNetwork.caipNetworkId;
        if (state.caipNetworkId === activeCaipNetworkId && state.tokens) {
            return;
        }
        try {
            var _ConstantsUtil_SUGGESTED_TOKENS_BY_CHAIN;
            state.tokensLoading = true;
            const tokens = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapApiUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapApiUtil"].getTokenList(activeCaipNetworkId);
            state.tokens = tokens;
            state.caipNetworkId = activeCaipNetworkId;
            state.popularTokens = tokens.sort((aTokenInfo, bTokenInfo)=>{
                if (aTokenInfo.symbol < bTokenInfo.symbol) {
                    return -1;
                }
                if (aTokenInfo.symbol > bTokenInfo.symbol) {
                    return 1;
                }
                return 0;
            });
            const suggestedTokensByChain = activeCaipNetworkId && ((_ConstantsUtil_SUGGESTED_TOKENS_BY_CHAIN = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].SUGGESTED_TOKENS_BY_CHAIN) === null || _ConstantsUtil_SUGGESTED_TOKENS_BY_CHAIN === void 0 ? void 0 : _ConstantsUtil_SUGGESTED_TOKENS_BY_CHAIN[activeCaipNetworkId]) || [];
            const suggestedTokenObjects = suggestedTokensByChain.map((symbol)=>tokens.find((t)=>t.symbol === symbol)).filter((t)=>Boolean(t));
            const allSuggestedTokens = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].SWAP_SUGGESTED_TOKENS || [];
            const allSuggestedTokenObjects = allSuggestedTokens.map((symbol)=>tokens.find((t)=>t.symbol === symbol)).filter((t)=>Boolean(t)).filter((t)=>!suggestedTokenObjects.some((ct)=>ct.address === t.address));
            state.suggestedTokens = [
                ...suggestedTokenObjects,
                ...allSuggestedTokenObjects
            ];
        } catch (error) {
            state.tokens = [];
            state.popularTokens = [];
            state.suggestedTokens = [];
        } finally{
            state.tokensLoading = false;
        }
    },
    async getAddressPrice (address) {
        var _allTokens_find, _fungibles_find;
        const existPrice = state.tokensPriceMap[address];
        if (existPrice) {
            return existPrice;
        }
        const response = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BlockchainApiController"].fetchTokenPrice({
            addresses: [
                address
            ]
        });
        const fungibles = (response === null || response === void 0 ? void 0 : response.fungibles) || [];
        const allTokens = [
            ...state.tokens || [],
            ...state.myTokensWithBalance || []
        ];
        const symbol = allTokens === null || allTokens === void 0 ? void 0 : (_allTokens_find = allTokens.find((token)=>token.address === address)) === null || _allTokens_find === void 0 ? void 0 : _allTokens_find.symbol;
        const price = ((_fungibles_find = fungibles.find((p)=>p.symbol.toLowerCase() === (symbol === null || symbol === void 0 ? void 0 : symbol.toLowerCase()))) === null || _fungibles_find === void 0 ? void 0 : _fungibles_find.price) || 0;
        const priceAsFloat = parseFloat(price.toString());
        state.tokensPriceMap[address] = priceAsFloat;
        return priceAsFloat;
    },
    async getNetworkTokenPrice () {
        var _response_fungibles;
        const { networkAddress } = SwapController.getParams();
        const response = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BlockchainApiController"].fetchTokenPrice({
            addresses: [
                networkAddress
            ]
        }).catch(()=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError('Failed to fetch network token price');
            return {
                fungibles: []
            };
        });
        const token = (_response_fungibles = response.fungibles) === null || _response_fungibles === void 0 ? void 0 : _response_fungibles[0];
        const price = (token === null || token === void 0 ? void 0 : token.price.toString()) || '0';
        state.tokensPriceMap[networkAddress] = parseFloat(price);
        state.networkTokenSymbol = (token === null || token === void 0 ? void 0 : token.symbol) || '';
        state.networkPrice = price;
    },
    async getMyTokensWithBalance (forceUpdate) {
        const balances = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$BalanceUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BalanceUtil"].getMyTokensWithBalance(forceUpdate);
        const swapBalances = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapApiUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapApiUtil"].mapBalancesToSwapTokens(balances);
        if (!swapBalances) {
            return;
        }
        await SwapController.getInitialGasPrice();
        SwapController.setBalances(swapBalances);
    },
    setBalances (balances) {
        const { networkAddress } = SwapController.getParams();
        const caipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork;
        if (!caipNetwork) {
            return;
        }
        const networkToken = balances.find((token)=>token.address === networkAddress);
        balances.forEach((token)=>{
            state.tokensPriceMap[token.address] = token.price || 0;
        });
        state.myTokensWithBalance = balances.filter((token)=>token.address.startsWith(caipNetwork.caipNetworkId));
        state.networkBalanceInUSD = networkToken ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].multiply(networkToken.quantity.numeric, networkToken.price).toString() : '0';
    },
    async getInitialGasPrice () {
        var _ChainController_state_activeCaipNetwork, _ChainController_state;
        const res = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapApiUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapApiUtil"].fetchGasPrice();
        if (!res) {
            return {
                gasPrice: null,
                gasPriceInUSD: null
            };
        }
        switch((_ChainController_state = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state) === null || _ChainController_state === void 0 ? void 0 : (_ChainController_state_activeCaipNetwork = _ChainController_state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork === void 0 ? void 0 : _ChainController_state_activeCaipNetwork.chainNamespace){
            case __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.SOLANA:
                var _res_standard;
                state.gasFee = (_res_standard = res.standard) !== null && _res_standard !== void 0 ? _res_standard : '0';
                state.gasPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].multiply(res.standard, state.networkPrice).div(1e9).toNumber();
                return {
                    gasPrice: BigInt(state.gasFee),
                    gasPriceInUSD: Number(state.gasPriceInUSD)
                };
            case __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.EVM:
            default:
                var _res_standard1;
                // eslint-disable-next-line no-case-declarations
                const value = (_res_standard1 = res.standard) !== null && _res_standard1 !== void 0 ? _res_standard1 : '0';
                // eslint-disable-next-line no-case-declarations
                const gasFee = BigInt(value);
                // eslint-disable-next-line no-case-declarations
                const gasLimit = BigInt(INITIAL_GAS_LIMIT);
                // eslint-disable-next-line no-case-declarations
                const gasPrice = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].getGasPriceInUSD(state.networkPrice, gasLimit, gasFee);
                state.gasFee = value;
                state.gasPriceInUSD = gasPrice;
                return {
                    gasPrice: gasFee,
                    gasPriceInUSD: gasPrice
                };
        }
    },
    // -- Swap -------------------------------------- //
    async swapTokens () {
        var _ChainController_getAccountData;
        const address = (_ChainController_getAccountData = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].getAccountData()) === null || _ChainController_getAccountData === void 0 ? void 0 : _ChainController_getAccountData.address;
        const sourceToken = state.sourceToken;
        const toToken = state.toToken;
        const haveSourceTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(state.sourceTokenAmount).gt(0);
        if (!haveSourceTokenAmount) {
            SwapController.setToTokenAmount('');
        }
        if (!toToken || !sourceToken || state.loadingPrices || !haveSourceTokenAmount || !address) {
            return;
        }
        state.loadingQuote = true;
        const amountDecimal = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(state.sourceTokenAmount).times(10 ** sourceToken.decimals).round(0);
        try {
            var _quoteResponse_quotes_, _quoteResponse_quotes;
            const quoteResponse = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BlockchainApiController"].fetchSwapQuote({
                userAddress: address,
                from: sourceToken.address,
                to: toToken.address,
                gasPrice: state.gasFee,
                amount: amountDecimal.toString()
            });
            state.loadingQuote = false;
            const quoteToAmount = quoteResponse === null || quoteResponse === void 0 ? void 0 : (_quoteResponse_quotes = quoteResponse.quotes) === null || _quoteResponse_quotes === void 0 ? void 0 : (_quoteResponse_quotes_ = _quoteResponse_quotes[0]) === null || _quoteResponse_quotes_ === void 0 ? void 0 : _quoteResponse_quotes_.toAmount;
            if (!quoteToAmount) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$AlertController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AlertController"].open({
                    displayMessage: 'Incorrect amount',
                    debugMessage: 'Please enter a valid amount'
                }, 'error');
                return;
            }
            const toTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(quoteToAmount).div(10 ** toToken.decimals).toString();
            SwapController.setToTokenAmount(toTokenAmount);
            const isInsufficientToken = SwapController.hasInsufficientToken(state.sourceTokenAmount, sourceToken.address);
            if (isInsufficientToken) {
                state.inputError = 'Insufficient balance';
            } else {
                state.inputError = undefined;
                SwapController.setTransactionDetails();
            }
        } catch (error) {
            const response = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapApiUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapApiUtil"].handleSwapError(error);
            state.loadingQuote = false;
            state.inputError = response || 'Insufficient balance';
        }
    },
    // -- Create Transactions -------------------------------------- //
    async getTransaction () {
        const { fromCaipAddress, availableToSwap } = SwapController.getParams();
        const sourceToken = state.sourceToken;
        const toToken = state.toToken;
        if (!fromCaipAddress || !availableToSwap || !sourceToken || !toToken || state.loadingQuote) {
            return undefined;
        }
        try {
            state.loadingBuildTransaction = true;
            const hasAllowance = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapApiUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapApiUtil"].fetchSwapAllowance({
                userAddress: fromCaipAddress,
                tokenAddress: sourceToken.address,
                sourceTokenAmount: state.sourceTokenAmount,
                sourceTokenDecimals: sourceToken.decimals
            });
            let transaction = undefined;
            if (hasAllowance) {
                transaction = await SwapController.createSwapTransaction();
            } else {
                transaction = await SwapController.createAllowanceTransaction();
            }
            state.loadingBuildTransaction = false;
            state.fetchError = false;
            return transaction;
        } catch (error) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError('Failed to check allowance');
            state.loadingBuildTransaction = false;
            state.approvalTransaction = undefined;
            state.swapTransaction = undefined;
            state.fetchError = true;
            return undefined;
        }
    },
    async createAllowanceTransaction () {
        const { fromCaipAddress, sourceTokenAddress, toTokenAddress } = SwapController.getParams();
        if (!fromCaipAddress || !toTokenAddress) {
            return undefined;
        }
        if (!sourceTokenAddress) {
            throw new Error('createAllowanceTransaction - No source token address found.');
        }
        try {
            const response = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BlockchainApiController"].generateApproveCalldata({
                from: sourceTokenAddress,
                to: toTokenAddress,
                userAddress: fromCaipAddress
            });
            const address = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$CoreHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CoreHelperUtil"].getPlainAddress(response.tx.from);
            if (!address) {
                throw new Error('SwapController:createAllowanceTransaction - address is required');
            }
            const transaction = {
                data: response.tx.data,
                to: address,
                gasPrice: BigInt(response.tx.eip155.gasPrice),
                value: BigInt(response.tx.value),
                toAmount: state.toTokenAmount
            };
            state.swapTransaction = undefined;
            state.approvalTransaction = {
                data: transaction.data,
                to: transaction.to,
                gasPrice: transaction.gasPrice,
                value: transaction.value,
                toAmount: transaction.toAmount
            };
            return {
                data: transaction.data,
                to: transaction.to,
                gasPrice: transaction.gasPrice,
                value: transaction.value,
                toAmount: transaction.toAmount
            };
        } catch (error) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError('Failed to create approval transaction');
            state.approvalTransaction = undefined;
            state.swapTransaction = undefined;
            state.fetchError = true;
            return undefined;
        }
    },
    async createSwapTransaction () {
        var _ConnectionController_parseUnits;
        const { networkAddress, fromCaipAddress, sourceTokenAmount } = SwapController.getParams();
        const sourceToken = state.sourceToken;
        const toToken = state.toToken;
        if (!fromCaipAddress || !sourceTokenAmount || !sourceToken || !toToken) {
            return undefined;
        }
        const amount = (_ConnectionController_parseUnits = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ConnectionController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionController"].parseUnits(sourceTokenAmount, sourceToken.decimals)) === null || _ConnectionController_parseUnits === void 0 ? void 0 : _ConnectionController_parseUnits.toString();
        try {
            const response = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$BlockchainApiController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BlockchainApiController"].generateSwapCalldata({
                userAddress: fromCaipAddress,
                from: sourceToken.address,
                to: toToken.address,
                amount: amount,
                disableEstimate: true
            });
            const isSourceTokenIsNetworkToken = sourceToken.address === networkAddress;
            const gas = BigInt(response.tx.eip155.gas);
            const gasPrice = BigInt(response.tx.eip155.gasPrice);
            const address = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$CoreHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CoreHelperUtil"].getPlainAddress(response.tx.to);
            if (!address) {
                throw new Error('SwapController:createSwapTransaction - address is required');
            }
            const transaction = {
                data: response.tx.data,
                to: address,
                gas,
                gasPrice,
                value: isSourceTokenIsNetworkToken ? BigInt(amount !== null && amount !== void 0 ? amount : '0') : BigInt('0'),
                toAmount: state.toTokenAmount
            };
            state.gasPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].getGasPriceInUSD(state.networkPrice, gas, gasPrice);
            state.approvalTransaction = undefined;
            state.swapTransaction = transaction;
            return transaction;
        } catch (error) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError('Failed to create transaction');
            state.approvalTransaction = undefined;
            state.swapTransaction = undefined;
            state.fetchError = true;
            return undefined;
        }
    },
    onEmbeddedWalletApprovalSuccess () {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showLoading('Approve limit increase in your wallet');
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].replace('SwapPreview');
    },
    // -- Send Transactions --------------------------------- //
    async sendTransactionForApproval (data) {
        const { fromAddress, isAuthConnector } = SwapController.getParams();
        state.loadingApprovalTransaction = true;
        const approveLimitMessage = "Approve limit increase in your wallet";
        if (isAuthConnector) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].pushTransactionStack({
                onSuccess: SwapController.onEmbeddedWalletApprovalSuccess
            });
        } else {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showLoading(approveLimitMessage);
        }
        try {
            await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ConnectionController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionController"].sendTransaction({
                address: fromAddress,
                to: data.to,
                data: data.data,
                value: data.value,
                chainNamespace: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.EVM
            });
            await SwapController.swapTokens();
            await SwapController.getTransaction();
            state.approvalTransaction = undefined;
            state.loadingApprovalTransaction = false;
        } catch (err) {
            var _ChainController_state_activeCaipNetwork, _SwapController_state_sourceToken, _SwapController_state_toToken;
            const error = err;
            state.transactionError = error === null || error === void 0 ? void 0 : error.displayMessage;
            state.loadingApprovalTransaction = false;
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError((error === null || error === void 0 ? void 0 : error.displayMessage) || 'Transaction error');
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EventsController"].sendEvent({
                type: 'track',
                event: 'SWAP_APPROVAL_ERROR',
                properties: {
                    message: (error === null || error === void 0 ? void 0 : error.displayMessage) || (error === null || error === void 0 ? void 0 : error.message) || 'Unknown',
                    network: ((_ChainController_state_activeCaipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork === void 0 ? void 0 : _ChainController_state_activeCaipNetwork.caipNetworkId) || '',
                    swapFromToken: ((_SwapController_state_sourceToken = SwapController.state.sourceToken) === null || _SwapController_state_sourceToken === void 0 ? void 0 : _SwapController_state_sourceToken.symbol) || '',
                    swapToToken: ((_SwapController_state_toToken = SwapController.state.toToken) === null || _SwapController_state_toToken === void 0 ? void 0 : _SwapController_state_toToken.symbol) || '',
                    swapFromAmount: SwapController.state.sourceTokenAmount || '',
                    swapToAmount: SwapController.state.toTokenAmount || '',
                    isSmartAccount: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getPreferredAccountType"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.EVM) === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$wallet$40$1$2e$8$2e$12_2a80c740d42bc806b726af94f1528827$2f$node_modules$2f40$reown$2f$appkit$2d$wallet$2f$dist$2f$esm$2f$src$2f$W3mFrameConstants$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mFrameRpcConstants"].ACCOUNT_TYPES.SMART_ACCOUNT
                }
            });
        }
    },
    async sendTransactionForSwap (data) {
        var _state_sourceToken, _state_toToken, _state_sourceToken1, _state_toToken1;
        if (!data) {
            return undefined;
        }
        const { fromAddress, toTokenAmount, isAuthConnector } = SwapController.getParams();
        state.loadingTransaction = true;
        const snackbarPendingMessage = "Swapping ".concat((_state_sourceToken = state.sourceToken) === null || _state_sourceToken === void 0 ? void 0 : _state_sourceToken.symbol, " to ").concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(toTokenAmount, 3), " ").concat((_state_toToken = state.toToken) === null || _state_toToken === void 0 ? void 0 : _state_toToken.symbol);
        const snackbarSuccessMessage = "Swapped ".concat((_state_sourceToken1 = state.sourceToken) === null || _state_sourceToken1 === void 0 ? void 0 : _state_sourceToken1.symbol, " to ").concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(toTokenAmount, 3), " ").concat((_state_toToken1 = state.toToken) === null || _state_toToken1 === void 0 ? void 0 : _state_toToken1.symbol);
        if (isAuthConnector) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].pushTransactionStack({
                onSuccess () {
                    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].replace('Account');
                    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showLoading(snackbarPendingMessage);
                    controller.resetState();
                }
            });
        } else {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showLoading('Confirm transaction in your wallet');
        }
        try {
            var _state_sourceToken2, _state_toToken2, _ChainController_state_activeCaipNetwork, _SwapController_state_sourceToken, _SwapController_state_toToken;
            const forceUpdateAddresses = [
                (_state_sourceToken2 = state.sourceToken) === null || _state_sourceToken2 === void 0 ? void 0 : _state_sourceToken2.address,
                (_state_toToken2 = state.toToken) === null || _state_toToken2 === void 0 ? void 0 : _state_toToken2.address
            ].join(',');
            const transactionHash = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ConnectionController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectionController"].sendTransaction({
                address: fromAddress,
                to: data.to,
                data: data.data,
                value: data.value,
                chainNamespace: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.EVM
            });
            state.loadingTransaction = false;
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showSuccess(snackbarSuccessMessage);
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EventsController"].sendEvent({
                type: 'track',
                event: 'SWAP_SUCCESS',
                properties: {
                    network: ((_ChainController_state_activeCaipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork === void 0 ? void 0 : _ChainController_state_activeCaipNetwork.caipNetworkId) || '',
                    swapFromToken: ((_SwapController_state_sourceToken = SwapController.state.sourceToken) === null || _SwapController_state_sourceToken === void 0 ? void 0 : _SwapController_state_sourceToken.symbol) || '',
                    swapToToken: ((_SwapController_state_toToken = SwapController.state.toToken) === null || _SwapController_state_toToken === void 0 ? void 0 : _SwapController_state_toToken.symbol) || '',
                    swapFromAmount: SwapController.state.sourceTokenAmount || '',
                    swapToAmount: SwapController.state.toTokenAmount || '',
                    isSmartAccount: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getPreferredAccountType"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.EVM) === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$wallet$40$1$2e$8$2e$12_2a80c740d42bc806b726af94f1528827$2f$node_modules$2f40$reown$2f$appkit$2d$wallet$2f$dist$2f$esm$2f$src$2f$W3mFrameConstants$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mFrameRpcConstants"].ACCOUNT_TYPES.SMART_ACCOUNT
                }
            });
            controller.resetState();
            if (!isAuthConnector) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].replace('Account');
            }
            controller.getMyTokensWithBalance(forceUpdateAddresses);
            return transactionHash;
        } catch (err) {
            var _ChainController_state_activeCaipNetwork1, _SwapController_state_sourceToken1, _SwapController_state_toToken1;
            const error = err;
            state.transactionError = error === null || error === void 0 ? void 0 : error.displayMessage;
            state.loadingTransaction = false;
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SnackController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SnackController"].showError((error === null || error === void 0 ? void 0 : error.displayMessage) || 'Transaction error');
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EventsController"].sendEvent({
                type: 'track',
                event: 'SWAP_ERROR',
                properties: {
                    message: (error === null || error === void 0 ? void 0 : error.displayMessage) || (error === null || error === void 0 ? void 0 : error.message) || 'Unknown',
                    network: ((_ChainController_state_activeCaipNetwork1 = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork1 === void 0 ? void 0 : _ChainController_state_activeCaipNetwork1.caipNetworkId) || '',
                    swapFromToken: ((_SwapController_state_sourceToken1 = SwapController.state.sourceToken) === null || _SwapController_state_sourceToken1 === void 0 ? void 0 : _SwapController_state_sourceToken1.symbol) || '',
                    swapToToken: ((_SwapController_state_toToken1 = SwapController.state.toToken) === null || _SwapController_state_toToken1 === void 0 ? void 0 : _SwapController_state_toToken1.symbol) || '',
                    swapFromAmount: SwapController.state.sourceTokenAmount || '',
                    swapToAmount: SwapController.state.toTokenAmount || '',
                    isSmartAccount: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getPreferredAccountType"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CHAIN.EVM) === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$wallet$40$1$2e$8$2e$12_2a80c740d42bc806b726af94f1528827$2f$node_modules$2f40$reown$2f$appkit$2d$wallet$2f$dist$2f$esm$2f$src$2f$W3mFrameConstants$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mFrameRpcConstants"].ACCOUNT_TYPES.SMART_ACCOUNT
                }
            });
            return undefined;
        }
    },
    // -- Checks -------------------------------------------- //
    hasInsufficientToken (sourceTokenAmount, sourceTokenAddress) {
        const isInsufficientSourceTokenForSwap = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].isInsufficientSourceTokenForSwap(sourceTokenAmount, sourceTokenAddress, state.myTokensWithBalance);
        return isInsufficientSourceTokenForSwap;
    },
    // -- Calculations -------------------------------------- //
    setTransactionDetails () {
        const { toTokenAddress, toTokenDecimals } = SwapController.getParams();
        if (!toTokenAddress || !toTokenDecimals) {
            return;
        }
        state.gasPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].getGasPriceInUSD(state.networkPrice, BigInt(state.gasFee), BigInt(INITIAL_GAS_LIMIT));
        state.priceImpact = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].getPriceImpact({
            sourceTokenAmount: state.sourceTokenAmount,
            sourceTokenPriceInUSD: state.sourceTokenPriceInUSD,
            toTokenPriceInUSD: state.toTokenPriceInUSD,
            toTokenAmount: state.toTokenAmount
        });
        state.maxSlippage = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].getMaxSlippage(state.slippage, state.toTokenAmount);
        state.providerFee = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$SwapCalculationUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapCalculationUtil"].getProviderFee(state.sourceTokenAmount);
    }
};
const SwapController = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$withErrorBoundary$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["withErrorBoundary"])(controller); //# sourceMappingURL=SwapController.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-details/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host {\n    width: 100%;\n  }\n\n  .details-container > wui-flex {\n    background: ",
        ";\n    border-radius: ",
        ";\n    width: 100%;\n  }\n\n  .details-container > wui-flex > button {\n    border: none;\n    background: none;\n    padding: ",
        ";\n    border-radius: ",
        ";\n    cursor: pointer;\n  }\n\n  .details-content-container {\n    padding: ",
        ";\n    padding-top: 0px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n\n  .details-content-container > wui-flex {\n    width: 100%;\n  }\n\n  .details-row {\n    width: 100%;\n    padding: ",
        ";\n    padding-left: ",
        ";\n    padding-right: ",
        ";\n    border-radius: calc(\n      ",
        " + ",
        "\n    );\n    background: ",
        ";\n  }\n\n  .details-row-title {\n    white-space: nowrap;\n  }\n\n  .details-row.provider-free-row {\n    padding-right: ",
        ";\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['1'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['1'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-details/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "WuiSwapDetails",
    ()=>WuiSwapDetails
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/property.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/state.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ChainController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/ConstantsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/SwapController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$flex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-flex.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$icon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-icon.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-text.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$tooltip$2d$trigger$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-tooltip-trigger/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$tooltip$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-tooltip/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$details$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-details/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        ' <wui-flex flexDirection="column" gap="2">\n                        <wui-flex\n                          justifyContent="space-between"\n                          alignItems="center"\n                          class="details-row"\n                        >\n                          <wui-flex alignItems="center" gap="2">\n                            <wui-text\n                              class="details-row-title"\n                              variant="sm-regular"\n                              color="secondary"\n                            >\n                              Price impact\n                            </wui-text>\n                            <w3m-tooltip-trigger\n                              text="Price impact reflects the change in market price due to your trade"\n                            >\n                              <wui-icon size="sm" color="default" name="info"></wui-icon>\n                            </w3m-tooltip-trigger>\n                          </wui-flex>\n                          <wui-flex>\n                            <wui-text variant="sm-regular" color="secondary">\n                              ',
        "%\n                            </wui-text>\n                          </wui-flex>\n                        </wui-flex>\n                      </wui-flex>"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-flex flexDirection="column" gap="2">\n                        <wui-flex\n                          justifyContent="space-between"\n                          alignItems="center"\n                          class="details-row"\n                        >\n                          <wui-flex alignItems="center" gap="2">\n                            <wui-text\n                              class="details-row-title"\n                              variant="sm-regular"\n                              color="secondary"\n                            >\n                              Max. slippage\n                            </wui-text>\n                            <w3m-tooltip-trigger\n                              text=',
        '\n                            >\n                              <wui-icon size="sm" color="default" name="info"></wui-icon>\n                            </w3m-tooltip-trigger>\n                          </wui-flex>\n                          <wui-flex>\n                            <wui-text variant="sm-regular" color="secondary">\n                              ',
        "\n                              ",
        " ",
        "%\n                            </wui-text>\n                          </wui-flex>\n                        </wui-flex>\n                      </wui-flex>"
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n                <wui-flex flexDirection="column" gap="2" class="details-content-container">\n                  ',
        "\n                  ",
        '\n                  <wui-flex flexDirection="column" gap="2">\n                    <wui-flex\n                      justifyContent="space-between"\n                      alignItems="center"\n                      class="details-row provider-free-row"\n                    >\n                      <wui-flex alignItems="center" gap="2">\n                        <wui-text class="details-row-title" variant="sm-regular" color="secondary">\n                          Provider fee\n                        </wui-text>\n                      </wui-flex>\n                      <wui-flex>\n                        <wui-text variant="sm-regular" color="secondary">0.85%</wui-text>\n                      </wui-flex>\n                    </wui-flex>\n                  </wui-flex>\n                </wui-flex>\n              '
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
function _templateObject3() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" alignItems="center" gap="01" class="details-container">\n        <wui-flex flexDirection="column">\n          <button @click=',
        '>\n            <wui-flex justifyContent="space-between" .padding=',
        '>\n              <wui-flex justifyContent="flex-start" flexGrow="1" gap="2">\n                <wui-text variant="sm-regular" color="primary">\n                  1 ',
        " =\n                  ",
        "\n                  ",
        '\n                </wui-text>\n                <wui-text variant="sm-regular" color="secondary">\n                  $',
        '\n                </wui-text>\n              </wui-flex>\n              <wui-icon name="chevronBottom"></wui-icon>\n            </wui-flex>\n          </button>\n          ',
        "\n        </wui-flex>\n      </wui-flex>\n    "
    ]);
    _templateObject3 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
;
;
const slippageRate = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ConstantsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConstantsUtil"].CONVERT_SLIPPAGE_TOLERANCE;
let WuiSwapDetails = class WuiSwapDetails extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    render() {
        const minReceivedAmount = this.toTokenAmount && this.maxSlippage ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(this.toTokenAmount).minus(this.maxSlippage).toString() : null;
        if (!this.sourceToken || !this.toToken || this.inputError) {
            return null;
        }
        const toTokenSwappedAmount = this.sourceTokenPriceInUSD && this.toTokenPriceInUSD ? 1 / this.toTokenPriceInUSD * this.sourceTokenPriceInUSD : 0;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject3(), this.toggleDetails.bind(this), [
            '0',
            '2',
            '0',
            '2'
        ], this.sourceToken.symbol, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(toTokenSwappedAmount, 3), this.toToken.symbol, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(this.sourceTokenPriceInUSD), this.detailsOpen ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), this.priceImpact ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(this.priceImpact, 3)) : null, this.maxSlippage && this.sourceToken.symbol ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), "Max slippage sets the minimum amount you must receive for the transaction to proceed. ".concat(minReceivedAmount ? "Transaction will be reversed if you receive less than ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(minReceivedAmount, 6), " ").concat(this.toToken.symbol, " due to price changes.") : ''), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(this.maxSlippage, 6), this.toToken.symbol, slippageRate) : null) : null);
    }
    toggleDetails() {
        this.detailsOpen = !this.detailsOpen;
    }
    constructor(){
        var _ChainController_state_activeCaipNetwork;
        super();
        this.unsubscribe = [];
        this.networkName = (_ChainController_state_activeCaipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork === void 0 ? void 0 : _ChainController_state_activeCaipNetwork.name;
        this.detailsOpen = false;
        this.sourceToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceToken;
        this.toToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toToken;
        this.toTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toTokenAmount;
        this.sourceTokenPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceTokenPriceInUSD;
        this.toTokenPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toTokenPriceInUSD;
        this.priceImpact = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.priceImpact;
        this.maxSlippage = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.maxSlippage;
        this.networkTokenSymbol = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.networkTokenSymbol;
        this.inputError = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.inputError;
        this.unsubscribe.push(...[
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].subscribe((newState)=>{
                this.sourceToken = newState.sourceToken;
                this.toToken = newState.toToken;
                this.toTokenAmount = newState.toTokenAmount;
                this.priceImpact = newState.priceImpact;
                this.maxSlippage = newState.maxSlippage;
                this.sourceTokenPriceInUSD = newState.sourceTokenPriceInUSD;
                this.toTokenPriceInUSD = newState.toTokenPriceInUSD;
                this.inputError = newState.inputError;
            })
        ]);
    }
};
WuiSwapDetails.styles = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$details$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]
];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "networkName", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiSwapDetails.prototype, "detailsOpen", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "sourceToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "toToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "toTokenAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "sourceTokenPriceInUSD", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "toTokenPriceInUSD", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "priceImpact", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "maxSlippage", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "networkTokenSymbol", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiSwapDetails.prototype, "inputError", void 0);
WuiSwapDetails = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('w3m-swap-details')
], WuiSwapDetails);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input-skeleton/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host {\n    width: 100%;\n  }\n\n  :host > wui-flex {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    align-items: center;\n    border-radius: ",
        ";\n    padding: ",
        ";\n    padding-right: ",
        ";\n    background-color: ",
        ";\n    box-shadow: inset 0px 0px 0px 1px ",
        ";\n    width: 100%;\n    height: 100px;\n    box-sizing: border-box;\n    position: relative;\n  }\n\n  wui-shimmer.market-value {\n    opacity: 0;\n  }\n\n  :host > wui-flex > svg.input_mask {\n    position: absolute;\n    inset: 0;\n    z-index: 5;\n  }\n\n  :host wui-flex .input_mask__border,\n  :host wui-flex .input_mask__background {\n    transition: fill ",
        "\n      ",
        ";\n    will-change: fill;\n  }\n\n  :host wui-flex .input_mask__border {\n    fill: ",
        ";\n  }\n\n  :host wui-flex .input_mask__background {\n    fill: ",
        ";\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { borderRadius } = param;
    return borderRadius['5'];
}, (param)=>{
    let { spacing } = param;
    return spacing['5'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { durations } = param;
    return durations['md'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-1'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input-skeleton/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "W3mSwapInputSkeleton",
    ()=>W3mSwapInputSkeleton
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/property.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$flex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-flex.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$shimmer$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-shimmer.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$input$2d$skeleton$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input-skeleton/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex class justifyContent="space-between">\n        <wui-flex\n          flex="1"\n          flexDirection="column"\n          alignItems="flex-start"\n          justifyContent="center"\n          class="swap-input"\n          gap="1"\n        >\n          <wui-shimmer width="80px" height="40px" rounded variant="light"></wui-shimmer>\n        </wui-flex>\n        ',
        "\n      </wui-flex>\n    "
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex\n        class="swap-token-button"\n        flexDirection="column"\n        alignItems="flex-end"\n        justifyContent="center"\n        gap="1"\n      >\n        <wui-shimmer width="80px" height="40px" rounded variant="light"></wui-shimmer>\n      </wui-flex>\n    '
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
let W3mSwapInputSkeleton = class W3mSwapInputSkeleton extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    render() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), this.templateTokenSelectButton());
    }
    templateTokenSelectButton() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1());
    }
    constructor(){
        super(...arguments);
        this.target = 'sourceToken';
    }
};
W3mSwapInputSkeleton.styles = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$input$2d$skeleton$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]
];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInputSkeleton.prototype, "target", void 0);
W3mSwapInputSkeleton = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('w3m-swap-input-skeleton')
], W3mSwapInputSkeleton);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/InputUtil.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InputUtil",
    ()=>InputUtil
]);
const InputUtil = {
    numericInputKeyDown (event, currentValue, onChange) {
        const allowedKeys = [
            'Backspace',
            'Meta',
            'Ctrl',
            'a',
            'A',
            'c',
            'C',
            'x',
            'X',
            'v',
            'V',
            'ArrowLeft',
            'ArrowRight',
            'Tab'
        ];
        const controlPressed = event.metaKey || event.ctrlKey;
        const eventKey = event.key;
        const lowercaseEventKey = eventKey.toLocaleLowerCase();
        const selectAll = lowercaseEventKey === 'a';
        const copyKey = lowercaseEventKey === 'c';
        const pasteKey = lowercaseEventKey === 'v';
        const cutKey = lowercaseEventKey === 'x';
        const isComma = eventKey === ',';
        const isDot = eventKey === '.';
        const isNumericKey = eventKey >= '0' && eventKey <= '9';
        if (!controlPressed && (selectAll || copyKey || pasteKey || cutKey)) {
            event.preventDefault();
        }
        if (currentValue === '0' && !isComma && !isDot && eventKey === '0') {
            event.preventDefault();
        }
        if (currentValue === '0' && isNumericKey) {
            onChange(eventKey);
            event.preventDefault();
        }
        if (isComma || isDot) {
            if (!currentValue) {
                onChange('0.');
                event.preventDefault();
            }
            if ((currentValue === null || currentValue === void 0 ? void 0 : currentValue.includes('.')) || (currentValue === null || currentValue === void 0 ? void 0 : currentValue.includes(','))) {
                event.preventDefault();
            }
        }
        if (!isNumericKey && !allowedKeys.includes(eventKey) && !isDot && !isComma) {
            event.preventDefault();
        }
    }
}; //# sourceMappingURL=InputUtil.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-button/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  button {\n    display: block;\n    display: flex;\n    align-items: center;\n    padding: ",
        ";\n    transition: background-color ",
        "\n      ",
        ";\n    will-change: background-color;\n    background-color: ",
        ";\n    border-radius: ",
        ";\n  }\n\n  wui-image {\n    border-radius: ",
        ";\n  }\n\n  wui-text {\n    padding-left: ",
        ";\n    padding-right: ",
        ";\n  }\n\n  .left-icon-container {\n    width: 24px;\n    height: 24px;\n    justify-content: center;\n    align-items: center;\n  }\n\n  .left-image-container {\n    position: relative;\n    justify-content: center;\n    align-items: center;\n  }\n\n  .chain-image {\n    position: absolute;\n    border: 1px solid ",
        ";\n  }\n\n  /* -- Sizes --------------------------------------------------- */\n  button[data-size='lg'] {\n    height: 32px;\n  }\n\n  button[data-size='md'] {\n    height: 28px;\n  }\n\n  button[data-size='sm'] {\n    height: 24px;\n  }\n\n  button[data-size='lg'] .token-image {\n    width: 24px;\n    height: 24px;\n  }\n\n  button[data-size='md'] .token-image {\n    width: 20px;\n    height: 20px;\n  }\n\n  button[data-size='sm'] .token-image {\n    width: 16px;\n    height: 16px;\n  }\n\n  button[data-size='lg'] .left-icon-container {\n    width: 24px;\n    height: 24px;\n  }\n\n  button[data-size='md'] .left-icon-container {\n    width: 20px;\n    height: 20px;\n  }\n\n  button[data-size='sm'] .left-icon-container {\n    width: 16px;\n    height: 16px;\n  }\n\n  button[data-size='lg'] .chain-image {\n    width: 12px;\n    height: 12px;\n    bottom: 2px;\n    right: -4px;\n  }\n\n  button[data-size='md'] .chain-image {\n    width: 10px;\n    height: 10px;\n    bottom: 2px;\n    right: -4px;\n  }\n\n  button[data-size='sm'] .chain-image {\n    width: 8px;\n    height: 8px;\n    bottom: 2px;\n    right: -3px;\n  }\n\n  /* -- Focus states --------------------------------------------------- */\n  button:focus-visible:enabled {\n    background-color: ",
        ";\n    box-shadow: 0 0 0 4px ",
        ";\n  }\n\n  /* -- Hover & Active states ----------------------------------------------------------- */\n  @media (hover: hover) {\n    button:hover:enabled,\n    button:active:enabled {\n      background-color: ",
        ";\n    }\n  }\n\n  /* -- Disabled states --------------------------------------------------- */\n  button:disabled {\n    background-color: ",
        ";\n    opacity: 0.5;\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { spacing } = param;
    return spacing[1];
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius[32];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius[32];
}, (param)=>{
    let { spacing } = param;
    return spacing[1];
}, (param)=>{
    let { spacing } = param;
    return spacing[1];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundSecondary;
}, (param)=>{
    let { tokens } = param;
    return tokens.core.foregroundAccent040;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundSecondary;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundSecondary;
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-button/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "WuiTokenButton",
    ()=>WuiTokenButton
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/property.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$icon$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-icon/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$image$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-image/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$shimmer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-shimmer/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$text$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-text/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$layout$2f$wui$2d$flex$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/layout/wui-flex/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$button$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-button/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        ' <wui-flex alignItems="center" gap="01" padding="01">\n        <wui-shimmer width="20px" height="20px"></wui-shimmer>\n        <wui-shimmer width="32px" height="18px" borderRadius="4xs"></wui-shimmer>\n      </wui-flex>'
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n      <button ?disabled=",
        " data-size=",
        ">\n        ",
        " ",
        "\n      </button>\n    "
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-flex class="left-image-container">\n        <wui-image src=',
        ' class="token-image"></wui-image>\n        <wui-image src=',
        ' class="chain-image"></wui-image>\n      </wui-flex>'
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
function _templateObject3() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "<wui-image src=",
        ' class="token-image"></wui-image>'
    ]);
    _templateObject3 = function() {
        return data;
    };
    return data;
}
function _templateObject4() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-flex class="left-icon-container">\n      <wui-icon size=',
        ' name="networkPlaceholder"></wui-icon>\n    </wui-flex>'
    ]);
    _templateObject4 = function() {
        return data;
    };
    return data;
}
function _templateObject5() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-text color="primary" variant=',
        "\n      >",
        "</wui-text\n    >"
    ]);
    _templateObject5 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
;
const TEXT_VARIANT_BY_SIZE = {
    lg: 'lg-regular',
    md: 'lg-regular',
    sm: 'md-regular'
};
const ICON_SIZE_BY_SIZE = {
    lg: 'lg',
    md: 'md',
    sm: 'sm'
};
let WuiTokenButton = class WuiTokenButton extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    render() {
        if (this.loading) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject());
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), this.disabled, this.size, this.imageTemplate(), this.textTemplate());
    }
    imageTemplate() {
        if (this.imageSrc && this.chainImageSrc) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), this.imageSrc, this.chainImageSrc);
        }
        if (this.imageSrc) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject3(), this.imageSrc);
        }
        const iconSize = ICON_SIZE_BY_SIZE[this.size];
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject4(), iconSize);
    }
    textTemplate() {
        const textVariant = TEXT_VARIANT_BY_SIZE[this.size];
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject5(), textVariant, this.text);
    }
    constructor(){
        super(...arguments);
        this.size = 'md';
        this.disabled = false;
        this.text = '';
        this.loading = false;
    }
};
WuiTokenButton.styles = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["resetStyles"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["elementStyles"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$button$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]
];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenButton.prototype, "size", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenButton.prototype, "imageSrc", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenButton.prototype, "chainImageSrc", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])({
        type: Boolean
    })
], WuiTokenButton.prototype, "disabled", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenButton.prototype, "text", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])({
        type: Boolean
    })
], WuiTokenButton.prototype, "loading", void 0);
WuiTokenButton = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('wui-token-button')
], WuiTokenButton);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-button.js [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$button$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-button/index.js [app-client] (ecmascript)"); //# sourceMappingURL=wui-token-button.js.map
;
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host > wui-flex {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    align-items: center;\n    border-radius: ",
        ";\n    background-color: ",
        ";\n    padding: ",
        ";\n    padding-right: ",
        ";\n    width: 100%;\n    height: 100px;\n    box-sizing: border-box;\n    box-shadow: inset 0px 0px 0px 1px ",
        ";\n    position: relative;\n    transition: box-shadow ",
        "\n      ",
        ";\n    will-change: background-color;\n  }\n\n  :host wui-flex.focus {\n    box-shadow: inset 0px 0px 0px 1px ",
        ";\n  }\n\n  :host > wui-flex .swap-input,\n  :host > wui-flex .swap-token-button {\n    z-index: 10;\n  }\n\n  :host > wui-flex .swap-input {\n    -webkit-mask-image: linear-gradient(\n      270deg,\n      transparent 0px,\n      transparent 8px,\n      black 24px,\n      black 25px,\n      black 32px,\n      black 100%\n    );\n    mask-image: linear-gradient(\n      270deg,\n      transparent 0px,\n      transparent 8px,\n      black 24px,\n      black 25px,\n      black 32px,\n      black 100%\n    );\n  }\n\n  :host > wui-flex .swap-input input {\n    background: none;\n    border: none;\n    height: 42px;\n    width: 100%;\n    font-size: 32px;\n    font-style: normal;\n    font-weight: 400;\n    line-height: 130%;\n    letter-spacing: -1.28px;\n    outline: none;\n    caret-color: ",
        ";\n    color: ",
        ";\n    padding: 0px;\n  }\n\n  :host > wui-flex .swap-input input:focus-visible {\n    outline: none;\n  }\n\n  :host > wui-flex .swap-input input::-webkit-outer-spin-button,\n  :host > wui-flex .swap-input input::-webkit-inner-spin-button {\n    -webkit-appearance: none;\n    margin: 0;\n  }\n\n  .max-value-button {\n    background-color: transparent;\n    border: none;\n    cursor: pointer;\n    color: ",
        ";\n    padding-left: 0px;\n  }\n\n  .market-value {\n    min-height: 18px;\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { borderRadius } = param;
    return borderRadius['5'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['5'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-1'];
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { tokens } = param;
    return tokens.core.textAccentPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.textPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "W3mSwapInput",
    ()=>W3mSwapInput
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/property.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$InputUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/InputUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/EventsController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/RouterController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$flex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-flex.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-text.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$token$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$input$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex\n        class="',
        '"\n        justifyContent="space-between"\n        alignItems="center"\n      >\n        <wui-flex\n          flex="1"\n          flexDirection="column"\n          alignItems="flex-start"\n          justifyContent="center"\n          class="swap-input"\n        >\n          <input\n            data-testid="swap-input-',
        '"\n            @focusin=',
        "\n            @focusout=",
        "\n            ?disabled=",
        "\n            value=",
        "\n            @input=",
        "\n            @keydown=",
        '\n            placeholder="0"\n            type="text"\n            inputmode="decimal"\n            pattern="[0-9,.]*"\n          />\n          <wui-text class="market-value" variant="sm-regular" color="secondary">\n            ',
        "\n          </wui-text>\n        </wui-flex>\n        ",
        "\n      </wui-flex>\n    "
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        ' <wui-button\n        data-testid="swap-select-token-button-',
        '"\n        class="swap-token-button"\n        size="md"\n        variant="neutral-secondary"\n        @click=',
        "\n      >\n        Select token\n      </wui-button>"
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex\n        class="swap-token-button"\n        flexDirection="column"\n        alignItems="flex-end"\n        justifyContent="center"\n        gap="1"\n      >\n        <wui-token-button\n          data-testid="swap-input-token-',
        '"\n          text=',
        "\n          imageSrc=",
        "\n          @click=",
        '\n        >\n        </wui-token-button>\n        <wui-flex alignItems="center" gap="1"> ',
        " </wui-flex>\n      </wui-flex>\n    "
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
function _templateObject3() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-text variant="sm-regular" color="secondary">\n            ',
        "\n          </wui-text>"
    ]);
    _templateObject3 = function() {
        return data;
    };
    return data;
}
function _templateObject4() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n      ",
        "\n      ",
        "\n    "
    ]);
    _templateObject4 = function() {
        return data;
    };
    return data;
}
function _templateObject5() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        ' <button class="max-value-button" @click=',
        '>\n        <wui-text color="accent-primary" variant="sm-medium">Max</wui-text>\n      </button>'
    ]);
    _templateObject5 = function() {
        return data;
    };
    return data;
}
function _templateObject6() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        ' <button class="max-value-button" @click=',
        '>\n      <wui-text color="accent-primary" variant="sm-medium">Buy</wui-text>\n    </button>'
    ]);
    _templateObject6 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
;
const MINIMUM_USD_VALUE_TO_CONVERT = 0.00005;
let W3mSwapInput = class W3mSwapInput extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    render() {
        const marketValue = this.marketValue || '0';
        const isMarketValueGreaterThanZero = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(marketValue).gt('0');
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), this.focused ? 'focus' : '', this.target, ()=>this.onFocusChange(true), ()=>this.onFocusChange(false), this.disabled, this.value || '', this.dispatchInputChangeEvent, this.handleKeydown, isMarketValueGreaterThanZero ? "$".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(this.marketValue, 2)) : null, this.templateTokenSelectButton());
    }
    handleKeydown(event) {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$InputUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InputUtil"].numericInputKeyDown(event, this.value, (value)=>{
            var _this_onSetAmount, _this;
            return (_this_onSetAmount = (_this = this).onSetAmount) === null || _this_onSetAmount === void 0 ? void 0 : _this_onSetAmount.call(_this, this.target, value);
        });
    }
    dispatchInputChangeEvent(event) {
        if (!this.onSetAmount) {
            return;
        }
        const value = event.target.value.replace(/[^0-9.]/gu, '');
        if (value === ',' || value === '.') {
            this.onSetAmount(this.target, '0.');
        } else if (value.endsWith(',')) {
            this.onSetAmount(this.target, value.replace(',', '.'));
        } else {
            this.onSetAmount(this.target, value);
        }
    }
    setMaxValueToInput() {
        var _this_onSetMaxValue, _this;
        (_this_onSetMaxValue = (_this = this).onSetMaxValue) === null || _this_onSetMaxValue === void 0 ? void 0 : _this_onSetMaxValue.call(_this, this.target, this.balance);
    }
    templateTokenSelectButton() {
        if (!this.token) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), this.target, this.onSelectToken.bind(this));
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), this.target, this.token.symbol, this.token.logoUri, this.onSelectToken.bind(this), this.tokenBalanceTemplate());
    }
    tokenBalanceTemplate() {
        const balanceValueInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].multiply(this.balance, this.price);
        const haveBalance = balanceValueInUSD ? balanceValueInUSD === null || balanceValueInUSD === void 0 ? void 0 : balanceValueInUSD.gt(MINIMUM_USD_VALUE_TO_CONVERT) : false;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject4(), haveBalance ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject3(), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(this.balance, 2)) : null, this.target === 'sourceToken' ? this.tokenActionButtonTemplate(haveBalance) : null);
    }
    tokenActionButtonTemplate(haveBalance) {
        if (haveBalance) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject5(), this.setMaxValueToInput.bind(this));
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject6(), this.onBuyToken.bind(this));
    }
    onFocusChange(state) {
        this.focused = state;
    }
    onSelectToken() {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EventsController"].sendEvent({
            type: 'track',
            event: 'CLICK_SELECT_TOKEN_TO_SWAP'
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].push('SwapSelectToken', {
            target: this.target
        });
    }
    onBuyToken() {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].push('OnRampProviders');
    }
    constructor(){
        super(...arguments);
        this.focused = false;
        this.price = 0;
        this.target = 'sourceToken';
        this.onSetAmount = null;
        this.onSetMaxValue = null;
    }
};
W3mSwapInput.styles = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$input$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]
];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "focused", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "balance", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "value", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "price", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "marketValue", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "disabled", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "target", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "token", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "onSetAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], W3mSwapInput.prototype, "onSetMaxValue", void 0);
W3mSwapInput = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('w3m-swap-input')
], W3mSwapInput);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-view/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host > wui-flex:first-child {\n    overflow-y: auto;\n    overflow-x: hidden;\n    scrollbar-width: none;\n  }\n\n  :host > wui-flex:first-child::-webkit-scrollbar {\n    display: none;\n  }\n\n  wui-loading-hexagon {\n    position: absolute;\n  }\n\n  .action-button {\n    width: 100%;\n    border-radius: ",
        ";\n  }\n\n  .action-button:disabled {\n    border-color: 1px solid ",
        ";\n  }\n\n  .swap-inputs-container {\n    position: relative;\n  }\n\n  wui-icon-box {\n    width: 32px;\n    height: 32px;\n    border-radius: ",
        " !important;\n    border: 4px solid ",
        ";\n    background: ",
        ";\n    position: absolute;\n    top: 50%;\n    left: 50%;\n    transform: translate(-50%, -50%);\n    z-index: 3;\n  }\n\n  .replace-tokens-button-container {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    position: absolute;\n    top: 50%;\n    left: 50%;\n    transform: translate(-50%, -50%);\n    gap: ",
        ";\n    border-radius: ",
        ";\n    background-color: ",
        ";\n    padding: ",
        ";\n  }\n\n  .details-container > wui-flex {\n    background: ",
        ";\n    border-radius: ",
        ";\n    width: 100%;\n  }\n\n  .details-container > wui-flex > button {\n    border: none;\n    background: none;\n    padding: ",
        ";\n    border-radius: ",
        ";\n    transition: background ",
        "\n      ",
        ";\n    will-change: background;\n  }\n\n  .details-container > wui-flex > button:hover {\n    background: ",
        ";\n  }\n\n  .details-content-container {\n    padding: ",
        ";\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n\n  .details-content-container > wui-flex {\n    width: 100%;\n  }\n\n  .details-row {\n    width: 100%;\n    padding: ",
        " ",
        ";\n    border-radius: ",
        ";\n    background: ",
        ";\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { borderRadius } = param;
    return borderRadius['4'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['10'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.backgroundPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['4'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.backgroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['5'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-view/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "W3mSwapView",
    ()=>W3mSwapView
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/property.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/state.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ChainController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$CoreHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/CoreHelperUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/EventsController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ModalController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ModalController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/RouterController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/SwapController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/utils/ChainControllerUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$flex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-flex.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$icon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-icon.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$icon$2d$box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-icon-box.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-text.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$wallet$40$1$2e$8$2e$12_2a80c740d42bc806b726af94f1528827$2f$node_modules$2f40$reown$2f$appkit$2d$wallet$2f$dist$2f$esm$2f$src$2f$W3mFrameConstants$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-wallet@1.8.12_2a80c740d42bc806b726af94f1528827/node_modules/@reown/appkit-wallet/dist/esm/src/W3mFrameConstants.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$details$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-details/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$input$2d$skeleton$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input-skeleton/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$input$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-input/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$view$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-view/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" .padding=',
        ' gap="3">\n        ',
        "\n      </wui-flex>\n    "
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" gap="3">\n        <wui-flex flexDirection="column" alignItems="center" gap="2" class="swap-inputs-container">\n          ',
        "\n          ",
        " ",
        "\n        </wui-flex>\n        ",
        " ",
        "\n      </wui-flex>\n    "
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex class="replace-tokens-button-container">\n        <wui-icon-box\n          @click=',
        '\n          icon="recycleHorizontal"\n          size="md"\n          variant="default"\n        ></wui-icon-box>\n      </wui-flex>\n    '
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
function _templateObject3() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" gap="4">\n        <wui-flex flexDirection="column" alignItems="center" gap="2" class="swap-inputs-container">\n          <w3m-swap-input-skeleton target="sourceToken"></w3m-swap-input-skeleton>\n          <w3m-swap-input-skeleton target="toToken"></w3m-swap-input-skeleton>\n          ',
        "\n        </wui-flex>\n        ",
        "\n      </wui-flex>\n    "
    ]);
    _templateObject3 = function() {
        return data;
    };
    return data;
}
function _templateObject4() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "<w3m-swap-input\n      .value=",
        "\n      .disabled=",
        "\n      .onSetAmount=",
        "\n      target=",
        "\n      .token=",
        "\n      .balance=",
        "\n      .price=",
        "\n      .marketValue=",
        "\n      .onSetMaxValue=",
        "\n    ></w3m-swap-input>"
    ]);
    _templateObject4 = function() {
        return data;
    };
    return data;
}
function _templateObject5() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "<w3m-swap-details .detailsOpen=",
        "></w3m-swap-details>"
    ]);
    _templateObject5 = function() {
        return data;
    };
    return data;
}
function _templateObject6() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        ' <wui-flex gap="2">\n      <wui-button\n        data-testid="swap-action-button"\n        class="action-button"\n        fullWidth\n        size="lg"\n        borderRadius="xs"\n        variant="accent-primary"\n        ?loading=',
        "\n        ?disabled=",
        "\n        @click=",
        "\n      >\n        ",
        "\n      </wui-button>\n    </wui-flex>"
    ]);
    _templateObject6 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
let W3mSwapView = class W3mSwapView extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    subscribe(param) {
        let { resetSwapState, initializeSwapState } = param;
        return ()=>{
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].subscribeKey('activeCaipNetwork', (newCaipNetwork)=>this.onCaipNetworkChange({
                    newCaipNetwork,
                    resetSwapState,
                    initializeSwapState
                }));
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].subscribeChainProp('accountState', (val)=>{
                this.onCaipAddressChange({
                    newCaipAddress: val === null || val === void 0 ? void 0 : val.caipAddress,
                    resetSwapState,
                    initializeSwapState
                });
            });
        };
    }
    async firstUpdated() {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].initializeState();
        this.watchTokensAndValues();
        await this.handleSwapParameters();
    }
    disconnectedCallback() {
        var _document;
        this.unsubscribe.forEach((unsubscribe)=>unsubscribe === null || unsubscribe === void 0 ? void 0 : unsubscribe());
        clearInterval(this.interval);
        (_document = document) === null || _document === void 0 ? void 0 : _document.removeEventListener('visibilitychange', this.visibilityChangeHandler);
    }
    render() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), [
            '0',
            '4',
            '4',
            '4'
        ], this.initialized ? this.templateSwap() : this.templateLoading());
    }
    subscribeToVisibilityChange() {
        var _document, _document1;
        (_document = document) === null || _document === void 0 ? void 0 : _document.removeEventListener('visibilitychange', this.visibilityChangeHandler);
        (_document1 = document) === null || _document1 === void 0 ? void 0 : _document1.addEventListener('visibilitychange', this.visibilityChangeHandler);
    }
    fetchTokensAndValues() {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].getNetworkTokenPrice();
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].getMyTokensWithBalance();
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].swapTokens();
        this.lastTokenPriceUpdate = Date.now();
    }
    templateSwap() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), this.templateTokenInput('sourceToken', this.sourceToken), this.templateTokenInput('toToken', this.toToken), this.templateReplaceTokensButton(), this.templateDetails(), this.templateActionButton());
    }
    actionButtonLabel() {
        const haveNoAmount = !this.sourceTokenAmount || this.sourceTokenAmount === '0';
        if (this.fetchError) {
            return 'Swap';
        }
        if (!this.sourceToken || !this.toToken) {
            return 'Select token';
        }
        if (haveNoAmount) {
            return 'Enter amount';
        }
        if (this.inputError) {
            return this.inputError;
        }
        return 'Review swap';
    }
    templateReplaceTokensButton() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), this.onSwitchTokens.bind(this));
    }
    templateLoading() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject3(), this.templateReplaceTokensButton(), this.templateActionButton());
    }
    templateTokenInput(target, token) {
        var _SwapController_state_myTokensWithBalance, _myToken_quantity;
        const myToken = (_SwapController_state_myTokensWithBalance = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.myTokensWithBalance) === null || _SwapController_state_myTokensWithBalance === void 0 ? void 0 : _SwapController_state_myTokensWithBalance.find((ct)=>(ct === null || ct === void 0 ? void 0 : ct.address) === (token === null || token === void 0 ? void 0 : token.address));
        const amount = target === 'toToken' ? this.toTokenAmount : this.sourceTokenAmount;
        const price = target === 'toToken' ? this.toTokenPriceInUSD : this.sourceTokenPriceInUSD;
        const marketValue = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].parseLocalStringToNumber(amount) * price;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject4(), target === 'toToken' ? this.toTokenAmount : this.sourceTokenAmount, target === 'toToken', this.handleChangeAmount.bind(this), target, token, myToken === null || myToken === void 0 ? void 0 : (_myToken_quantity = myToken.quantity) === null || _myToken_quantity === void 0 ? void 0 : _myToken_quantity.numeric, myToken === null || myToken === void 0 ? void 0 : myToken.price, marketValue, this.onSetMaxValue.bind(this));
    }
    onSetMaxValue(target, balance) {
        const maxValue = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].bigNumber(balance || '0');
        this.handleChangeAmount(target, maxValue.gt(0) ? maxValue.toFixed(20) : '0');
    }
    templateDetails() {
        if (!this.sourceToken || !this.toToken || this.inputError) {
            return null;
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject5(), this.detailsOpen);
    }
    handleChangeAmount(target, value) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].clearError();
        if (target === 'sourceToken') {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setSourceTokenAmount(value);
        } else {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setToTokenAmount(value);
        }
        this.onDebouncedGetSwapCalldata();
    }
    templateActionButton() {
        const haveNoTokenSelected = !this.toToken || !this.sourceToken;
        const haveNoAmount = !this.sourceTokenAmount || this.sourceTokenAmount === '0';
        const loading = this.loadingQuote || this.loadingPrices || this.loadingTransaction;
        const disabled = loading || haveNoTokenSelected || haveNoAmount || this.inputError;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject6(), Boolean(loading), Boolean(disabled), this.onSwapPreview.bind(this), this.actionButtonLabel());
    }
    async onSwitchTokens() {
        await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].switchTokens();
    }
    async onSwapPreview() {
        var _this_sourceToken, _this_toToken;
        if (this.fetchError) {
            await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].swapTokens();
        }
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$EventsController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EventsController"].sendEvent({
            type: 'track',
            event: 'INITIATE_SWAP',
            properties: {
                network: this.caipNetworkId || '',
                swapFromToken: ((_this_sourceToken = this.sourceToken) === null || _this_sourceToken === void 0 ? void 0 : _this_sourceToken.symbol) || '',
                swapToToken: ((_this_toToken = this.toToken) === null || _this_toToken === void 0 ? void 0 : _this_toToken.symbol) || '',
                swapFromAmount: this.sourceTokenAmount || '',
                swapToAmount: this.toTokenAmount || '',
                isSmartAccount: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$ChainControllerUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getPreferredAccountType"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeChain) === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$wallet$40$1$2e$8$2e$12_2a80c740d42bc806b726af94f1528827$2f$node_modules$2f40$reown$2f$appkit$2d$wallet$2f$dist$2f$esm$2f$src$2f$W3mFrameConstants$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mFrameRpcConstants"].ACCOUNT_TYPES.SMART_ACCOUNT
            }
        });
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].push('SwapPreview');
    }
    async handleSwapParameters() {
        if (!this.initialParams) {
            return;
        }
        if (!__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.initialized) {
            const waitForInitialization = new Promise((resolve)=>{
                const unsubscribe = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].subscribeKey('initialized', (initialized)=>{
                    if (initialized) {
                        unsubscribe === null || unsubscribe === void 0 ? void 0 : unsubscribe();
                        resolve();
                    }
                });
            });
            await waitForInitialization;
        }
        await this.setSwapParameters(this.initialParams);
    }
    async setSwapParameters(param) {
        let { amount, fromToken, toToken } = param;
        if (!__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.tokens || !__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.myTokensWithBalance) {
            const waitForTokens = new Promise((resolve)=>{
                const unsubscribe = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].subscribeKey('myTokensWithBalance', (tokens)=>{
                    if (tokens && tokens.length > 0) {
                        unsubscribe === null || unsubscribe === void 0 ? void 0 : unsubscribe();
                        resolve();
                    }
                });
                setTimeout(()=>{
                    unsubscribe === null || unsubscribe === void 0 ? void 0 : unsubscribe();
                    resolve();
                }, 5000);
            });
            await waitForTokens;
        }
        const allTokens = [
            ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.tokens || [],
            ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.myTokensWithBalance || []
        ];
        if (fromToken) {
            const token = allTokens.find((t)=>t.symbol.toLowerCase() === fromToken.toLowerCase());
            if (token) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setSourceToken(token);
            }
        }
        if (toToken) {
            const token = allTokens.find((t)=>t.symbol.toLowerCase() === toToken.toLowerCase());
            if (token) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setToToken(token);
            }
        }
        if (amount && !isNaN(Number(amount))) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setSourceTokenAmount(amount);
        }
    }
    onCaipAddressChange(param) {
        let { newCaipAddress, resetSwapState, initializeSwapState } = param;
        if (this.caipAddress !== newCaipAddress) {
            this.caipAddress = newCaipAddress;
            if (resetSwapState) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].resetState();
            }
            if (initializeSwapState) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].initializeState();
            }
        }
    }
    onCaipNetworkChange(param) {
        let { newCaipNetwork, resetSwapState, initializeSwapState } = param;
        if (this.caipNetworkId !== (newCaipNetwork === null || newCaipNetwork === void 0 ? void 0 : newCaipNetwork.caipNetworkId)) {
            this.caipNetworkId = newCaipNetwork === null || newCaipNetwork === void 0 ? void 0 : newCaipNetwork.caipNetworkId;
            if (resetSwapState) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].resetState();
            }
            if (initializeSwapState) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].initializeState();
            }
        }
    }
    constructor(){
        var _RouterController_state_data, _ChainController_getAccountData, _ChainController_state_activeCaipNetwork;
        super();
        this.unsubscribe = [];
        this.initialParams = (_RouterController_state_data = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].state.data) === null || _RouterController_state_data === void 0 ? void 0 : _RouterController_state_data.swap;
        this.detailsOpen = false;
        this.caipAddress = (_ChainController_getAccountData = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].getAccountData()) === null || _ChainController_getAccountData === void 0 ? void 0 : _ChainController_getAccountData.caipAddress;
        this.caipNetworkId = (_ChainController_state_activeCaipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork) === null || _ChainController_state_activeCaipNetwork === void 0 ? void 0 : _ChainController_state_activeCaipNetwork.caipNetworkId;
        this.initialized = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.initialized;
        this.loadingQuote = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingQuote;
        this.loadingPrices = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingPrices;
        this.loadingTransaction = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingTransaction;
        this.sourceToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceToken;
        this.sourceTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceTokenAmount;
        this.sourceTokenPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceTokenPriceInUSD;
        this.toToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toToken;
        this.toTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toTokenAmount;
        this.toTokenPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toTokenPriceInUSD;
        this.inputError = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.inputError;
        this.fetchError = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.fetchError;
        this.lastTokenPriceUpdate = 0;
        this.minTokenPriceUpdateInterval = 10_000;
        this.visibilityChangeHandler = ()=>{
            var _document;
            if ((_document = document) === null || _document === void 0 ? void 0 : _document.hidden) {
                clearInterval(this.interval);
                this.interval = undefined;
            } else {
                this.startTokenPriceInterval();
            }
        };
        this.startTokenPriceInterval = ()=>{
            if (this.interval && Date.now() - this.lastTokenPriceUpdate < this.minTokenPriceUpdateInterval) {
                return;
            }
            if (this.lastTokenPriceUpdate && Date.now() - this.lastTokenPriceUpdate > this.minTokenPriceUpdateInterval) {
                this.fetchTokensAndValues();
            }
            clearInterval(this.interval);
            this.interval = setInterval(()=>{
                this.fetchTokensAndValues();
            }, this.minTokenPriceUpdateInterval);
        };
        this.watchTokensAndValues = ()=>{
            if (!this.sourceToken || !this.toToken) {
                return;
            }
            this.subscribeToVisibilityChange();
            this.startTokenPriceInterval();
        };
        this.onDebouncedGetSwapCalldata = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$utils$2f$CoreHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CoreHelperUtil"].debounce(async ()=>{
            await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].swapTokens();
        }, 200);
        this.subscribe({
            resetSwapState: true,
            initializeSwapState: false
        })();
        this.unsubscribe.push(...[
            this.subscribe({
                resetSwapState: false,
                initializeSwapState: true
            }),
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ModalController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ModalController"].subscribeKey('open', (isOpen)=>{
                if (!isOpen) {
                    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].resetState();
                }
            }),
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].subscribeKey('view', (newRoute)=>{
                if (!newRoute.includes('Swap')) {
                    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].resetValues();
                }
            }),
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].subscribe((newState)=>{
                this.initialized = newState.initialized;
                this.loadingQuote = newState.loadingQuote;
                this.loadingPrices = newState.loadingPrices;
                this.loadingTransaction = newState.loadingTransaction;
                this.sourceToken = newState.sourceToken;
                this.sourceTokenAmount = newState.sourceTokenAmount;
                this.sourceTokenPriceInUSD = newState.sourceTokenPriceInUSD;
                this.toToken = newState.toToken;
                this.toTokenAmount = newState.toTokenAmount;
                this.toTokenPriceInUSD = newState.toTokenPriceInUSD;
                this.inputError = newState.inputError;
                this.fetchError = newState.fetchError;
                if (newState.sourceToken && newState.toToken) {
                    this.watchTokensAndValues();
                }
            })
        ]);
    }
};
W3mSwapView.styles = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$view$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])({
        type: Object
    })
], W3mSwapView.prototype, "initialParams", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "interval", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "detailsOpen", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "caipAddress", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "caipNetworkId", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "initialized", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "loadingQuote", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "loadingPrices", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "loadingTransaction", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "sourceToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "sourceTokenAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "sourceTokenPriceInUSD", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "toToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "toTokenAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "toTokenPriceInUSD", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "inputError", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "fetchError", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapView.prototype, "lastTokenPriceUpdate", void 0);
W3mSwapView = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('w3m-swap-view')
], W3mSwapView);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-preview-view/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host > wui-flex:first-child {\n    overflow-y: auto;\n    overflow-x: hidden;\n    scrollbar-width: none;\n  }\n\n  :host > wui-flex:first-child::-webkit-scrollbar {\n    display: none;\n  }\n\n  .preview-container,\n  .details-container {\n    width: 100%;\n  }\n\n  .token-image {\n    width: 24px;\n    height: 24px;\n    box-shadow: 0 0 0 2px ",
        ";\n    border-radius: 12px;\n  }\n\n  wui-loading-hexagon {\n    position: absolute;\n  }\n\n  .token-item {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    gap: ",
        ";\n    padding: ",
        ";\n    height: 40px;\n    border: none;\n    border-radius: 80px;\n    background: ",
        ";\n    box-shadow: inset 0 0 0 1px ",
        ";\n    cursor: pointer;\n    transition: background ",
        "\n      ",
        ";\n    will-change: background;\n  }\n\n  .token-item:hover {\n    background: ",
        ";\n  }\n\n  .preview-token-details-container {\n    width: 100%;\n  }\n\n  .details-row {\n    width: 100%;\n    padding: ",
        " ",
        ";\n    border-radius: ",
        ";\n    background: ",
        ";\n  }\n\n  .action-buttons-container {\n    width: 100%;\n    gap: ",
        ";\n  }\n\n  .action-buttons-container > button {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background: transparent;\n    height: 48px;\n    border-radius: ",
        ";\n    border: none;\n    box-shadow: inset 0 0 0 1px ",
        ";\n  }\n\n  .action-buttons-container > button:disabled {\n    opacity: 0.8;\n    cursor: not-allowed;\n  }\n\n  .action-button > wui-loading-spinner {\n    display: inline-block;\n  }\n\n  .cancel-button:hover,\n  .action-button:hover {\n    cursor: pointer;\n  }\n\n  .action-buttons-container > wui-button.cancel-button {\n    flex: 2;\n  }\n\n  .action-buttons-container > wui-button.action-button {\n    flex: 4;\n  }\n\n  .action-buttons-container > button.action-button > wui-text {\n    color: white;\n  }\n\n  .details-container > wui-flex {\n    background: ",
        ";\n    border-radius: ",
        ";\n    width: 100%;\n  }\n\n  .details-container > wui-flex > button {\n    border: none;\n    background: none;\n    padding: ",
        ";\n    border-radius: ",
        ";\n    transition: background ",
        "\n      ",
        ";\n    will-change: background;\n  }\n\n  .details-container > wui-flex > button:hover {\n    background: ",
        ";\n  }\n\n  .details-content-container {\n    padding: ",
        ";\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n\n  .details-content-container > wui-flex {\n    width: 100%;\n  }\n\n  .details-row {\n    width: 100%;\n    padding: ",
        " ",
        ";\n    border-radius: ",
        ";\n    background: ",
        ";\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['5'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['4'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['5'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-preview-view/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "W3mSwapPreviewView",
    ()=>W3mSwapPreviewView
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/state.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/ChainController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/RouterController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/SwapController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$flex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-flex.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$icon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-icon.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-text.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$token$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$partials$2f$w3m$2d$swap$2d$details$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/partials/w3m-swap-details/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$preview$2d$view$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-preview-view/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" .padding=',
        ' gap="3">\n        ',
        "\n      </wui-flex>\n    "
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" alignItems="center" gap="4">\n        <wui-flex class="preview-container" flexDirection="column" alignItems="flex-start" gap="4">\n          <wui-flex\n            class="preview-token-details-container"\n            alignItems="center"\n            justifyContent="space-between"\n            gap="4"\n          >\n            <wui-flex flexDirection="column" alignItems="flex-start" gap="01">\n              <wui-text variant="sm-regular" color="secondary">Send</wui-text>\n              <wui-text variant="md-regular" color="primary">$',
        '</wui-text>\n            </wui-flex>\n            <wui-token-button\n              flexDirection="row-reverse"\n              text=',
        "\n              imageSrc=",
        '\n            >\n            </wui-token-button>\n          </wui-flex>\n          <wui-icon name="recycleHorizontal" color="default" size="md"></wui-icon>\n          <wui-flex\n            class="preview-token-details-container"\n            alignItems="center"\n            justifyContent="space-between"\n            gap="4"\n          >\n            <wui-flex flexDirection="column" alignItems="flex-start" gap="01">\n              <wui-text variant="sm-regular" color="secondary">Receive</wui-text>\n              <wui-text variant="md-regular" color="primary">$',
        '</wui-text>\n            </wui-flex>\n            <wui-token-button\n              flexDirection="row-reverse"\n              text=',
        "\n              imageSrc=",
        "\n            >\n            </wui-token-button>\n          </wui-flex>\n        </wui-flex>\n\n        ",
        '\n\n        <wui-flex flexDirection="row" alignItems="center" justifyContent="center" gap="2">\n          <wui-icon size="sm" color="default" name="info"></wui-icon>\n          <wui-text variant="sm-regular" color="secondary">Review transaction carefully</wui-text>\n        </wui-flex>\n\n        <wui-flex\n          class="action-buttons-container"\n          flexDirection="row"\n          alignItems="center"\n          justifyContent="space-between"\n          gap="2"\n        >\n          <wui-button\n            class="cancel-button"\n            fullWidth\n            size="lg"\n            borderRadius="xs"\n            variant="neutral-secondary"\n            @click=',
        '\n          >\n            <wui-text variant="md-medium" color="secondary">Cancel</wui-text>\n          </wui-button>\n          <wui-button\n            class="action-button"\n            fullWidth\n            size="lg"\n            borderRadius="xs"\n            variant="accent-primary"\n            ?loading=',
        "\n            ?disabled=",
        "\n            @click=",
        '\n          >\n            <wui-text variant="md-medium" color="invert"> ',
        " </wui-text>\n          </wui-button>\n        </wui-flex>\n      </wui-flex>\n    "
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "<w3m-swap-details .detailsOpen=",
        "></w3m-swap-details>"
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
;
;
;
let W3mSwapPreviewView = class W3mSwapPreviewView extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    firstUpdated() {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].getTransaction();
        this.refreshTransaction();
    }
    disconnectedCallback() {
        this.unsubscribe.forEach((unsubscribe)=>unsubscribe === null || unsubscribe === void 0 ? void 0 : unsubscribe());
        clearInterval(this.interval);
    }
    render() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), [
            '0',
            '4',
            '4',
            '4'
        ], this.templateSwap());
    }
    refreshTransaction() {
        this.interval = setInterval(()=>{
            if (!__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].getApprovalLoadingState()) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].getTransaction();
            }
        }, 10_000);
    }
    templateSwap() {
        var _this_sourceToken, _this_toToken, _this_sourceToken1, _this_toToken1;
        const sourceTokenText = "".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(parseFloat(this.sourceTokenAmount)), " ").concat((_this_sourceToken = this.sourceToken) === null || _this_sourceToken === void 0 ? void 0 : _this_sourceToken.symbol);
        const toTokenText = "".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(parseFloat(this.toTokenAmount)), " ").concat((_this_toToken = this.toToken) === null || _this_toToken === void 0 ? void 0 : _this_toToken.symbol);
        const sourceTokenValue = parseFloat(this.sourceTokenAmount) * this.sourceTokenPriceInUSD;
        const toTokenValue = parseFloat(this.toTokenAmount) * this.toTokenPriceInUSD;
        const sentPrice = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(sourceTokenValue);
        const receivePrice = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(toTokenValue);
        const loading = this.loadingQuote || this.loadingBuildTransaction || this.loadingTransaction || this.loadingApprovalTransaction;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), sentPrice, sourceTokenText, (_this_sourceToken1 = this.sourceToken) === null || _this_sourceToken1 === void 0 ? void 0 : _this_sourceToken1.logoUri, receivePrice, toTokenText, (_this_toToken1 = this.toToken) === null || _this_toToken1 === void 0 ? void 0 : _this_toToken1.logoUri, this.templateDetails(), this.onCancelTransaction.bind(this), loading, loading, this.onSendTransaction.bind(this), this.actionButtonLabel());
    }
    templateDetails() {
        if (!this.sourceToken || !this.toToken || this.inputError) {
            return null;
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), this.detailsOpen);
    }
    actionButtonLabel() {
        if (this.loadingApprovalTransaction) {
            return 'Approving...';
        }
        if (this.approvalTransaction) {
            return 'Approve';
        }
        return 'Swap';
    }
    onCancelTransaction() {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
    }
    onSendTransaction() {
        if (this.approvalTransaction) {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].sendTransactionForApproval(this.approvalTransaction);
        } else {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].sendTransactionForSwap(this.swapTransaction);
        }
    }
    constructor(){
        var _ChainController_getAccountData;
        super();
        this.unsubscribe = [];
        this.detailsOpen = true;
        this.approvalTransaction = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.approvalTransaction;
        this.swapTransaction = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.swapTransaction;
        this.sourceToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceToken;
        var _SwapController_state_sourceTokenAmount;
        this.sourceTokenAmount = (_SwapController_state_sourceTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceTokenAmount) !== null && _SwapController_state_sourceTokenAmount !== void 0 ? _SwapController_state_sourceTokenAmount : '';
        this.sourceTokenPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceTokenPriceInUSD;
        this.balanceSymbol = (_ChainController_getAccountData = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].getAccountData()) === null || _ChainController_getAccountData === void 0 ? void 0 : _ChainController_getAccountData.balanceSymbol;
        this.toToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toToken;
        var _SwapController_state_toTokenAmount;
        this.toTokenAmount = (_SwapController_state_toTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toTokenAmount) !== null && _SwapController_state_toTokenAmount !== void 0 ? _SwapController_state_toTokenAmount : '';
        this.toTokenPriceInUSD = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toTokenPriceInUSD;
        this.caipNetwork = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].state.activeCaipNetwork;
        this.inputError = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.inputError;
        this.loadingQuote = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingQuote;
        this.loadingApprovalTransaction = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingApprovalTransaction;
        this.loadingBuildTransaction = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingBuildTransaction;
        this.loadingTransaction = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.loadingTransaction;
        this.unsubscribe.push(...[
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].subscribeChainProp('accountState', (val)=>{
                if ((val === null || val === void 0 ? void 0 : val.balanceSymbol) !== this.balanceSymbol) {
                    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
                }
            }),
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$ChainController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainController"].subscribeKey('activeCaipNetwork', (newCaipNetwork)=>{
                if (this.caipNetwork !== newCaipNetwork) {
                    this.caipNetwork = newCaipNetwork;
                }
            }),
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].subscribe((newState)=>{
                this.approvalTransaction = newState.approvalTransaction;
                this.swapTransaction = newState.swapTransaction;
                this.sourceToken = newState.sourceToken;
                this.toToken = newState.toToken;
                this.toTokenPriceInUSD = newState.toTokenPriceInUSD;
                var _newState_sourceTokenAmount;
                this.sourceTokenAmount = (_newState_sourceTokenAmount = newState.sourceTokenAmount) !== null && _newState_sourceTokenAmount !== void 0 ? _newState_sourceTokenAmount : '';
                var _newState_toTokenAmount;
                this.toTokenAmount = (_newState_toTokenAmount = newState.toTokenAmount) !== null && _newState_toTokenAmount !== void 0 ? _newState_toTokenAmount : '';
                this.inputError = newState.inputError;
                if (newState.inputError) {
                    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
                }
                this.loadingQuote = newState.loadingQuote;
                this.loadingApprovalTransaction = newState.loadingApprovalTransaction;
                this.loadingBuildTransaction = newState.loadingBuildTransaction;
                this.loadingTransaction = newState.loadingTransaction;
            })
        ]);
    }
};
W3mSwapPreviewView.styles = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$preview$2d$view$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "interval", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "detailsOpen", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "approvalTransaction", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "swapTransaction", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "sourceToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "sourceTokenAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "sourceTokenPriceInUSD", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "balanceSymbol", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "toToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "toTokenAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "toTokenPriceInUSD", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "caipNetwork", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "inputError", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "loadingQuote", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "loadingApprovalTransaction", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "loadingBuildTransaction", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapPreviewView.prototype, "loadingTransaction", void 0);
W3mSwapPreviewView = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('w3m-swap-preview-view')
], W3mSwapPreviewView);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host {\n    width: 100%;\n    height: 60px;\n    min-height: 60px;\n  }\n\n  :host > wui-flex {\n    cursor: pointer;\n    height: 100%;\n    display: flex;\n    column-gap: ",
        ";\n    padding: ",
        ";\n    padding-right: ",
        ";\n    width: 100%;\n    background-color: transparent;\n    border-radius: ",
        ";\n    color: ",
        ";\n    transition:\n      background-color ",
        "\n        ",
        ",\n      opacity ",
        " ",
        ";\n    will-change: background-color, opacity;\n  }\n\n  @media (hover: hover) and (pointer: fine) {\n    :host > wui-flex:hover {\n      background-color: ",
        ";\n    }\n\n    :host > wui-flex:active {\n      background-color: ",
        ";\n    }\n  }\n\n  :host([disabled]) > wui-flex {\n    opacity: 0.6;\n  }\n\n  :host([disabled]) > wui-flex:hover {\n    background-color: transparent;\n  }\n\n  :host > wui-flex > wui-flex {\n    flex: 1;\n  }\n\n  :host > wui-flex > wui-image,\n  :host > wui-flex > .token-item-image-placeholder {\n    width: 40px;\n    max-width: 40px;\n    height: 40px;\n    border-radius: ",
        ";\n    position: relative;\n  }\n\n  :host > wui-flex > .token-item-image-placeholder {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n\n  :host > wui-flex > wui-image::after,\n  :host > wui-flex > .token-item-image-placeholder::after {\n    position: absolute;\n    content: '';\n    inset: 0;\n    box-shadow: inset 0 0 0 1px ",
        ";\n    border-radius: ",
        ";\n  }\n\n  button > wui-icon-box[data-variant='square-blue'] {\n    border-radius: ",
        ";\n    position: relative;\n    border: none;\n    width: 36px;\n    height: 36px;\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { spacing } = param;
    return spacing['4'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['4'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundSecondary;
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['20'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['8'];
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['2'];
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "WuiTokenListItem",
    ()=>WuiTokenListItem
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/property.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/state.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-common@1.8.12_0c0b5a574bad561884ab1bf37c6536ee/node_modules/@reown/appkit-common/dist/esm/src/utils/NumberUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$image$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-image/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$text$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-text/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$layout$2f$wui$2d$flex$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/layout/wui-flex/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$list$2d$item$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n                  <wui-text variant="md-medium" color="primary">\n                    $',
        "\n                  </wui-text>\n                "
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-text variant="sm-regular" color="secondary">\n                  ',
        "\n                </wui-text>"
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex alignItems="center">\n        ',
        '\n        <wui-flex flexDirection="column" gap="1">\n          <wui-flex justifyContent="space-between">\n            <wui-text variant="md-medium" color="primary" lineClamp="1">',
        "</wui-text>\n            ",
        '\n          </wui-flex>\n          <wui-flex justifyContent="space-between">\n            <wui-text variant="sm-regular" color="secondary" lineClamp="1">',
        "</wui-text>\n            ",
        "\n          </wui-flex>\n        </wui-flex>\n      </wui-flex>\n    "
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
function _templateObject3() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-flex class="token-item-image-placeholder">\n        <wui-icon name="image" color="inherit"></wui-icon>\n      </wui-flex>'
    ]);
    _templateObject3 = function() {
        return data;
    };
    return data;
}
function _templateObject4() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-image\n        width="40"\n        height="40"\n        src=',
        "\n        @onLoadError=",
        "\n      ></wui-image>"
    ]);
    _templateObject4 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
let WuiTokenListItem = class WuiTokenListItem extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    firstUpdated() {
        this.observer.observe(this);
    }
    disconnectedCallback() {
        this.observer.disconnect();
    }
    render() {
        var _NumberUtil_multiply;
        if (!this.visible) {
            return null;
        }
        const value = this.amount && this.price ? (_NumberUtil_multiply = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].multiply(this.price, this.amount)) === null || _NumberUtil_multiply === void 0 ? void 0 : _NumberUtil_multiply.toFixed(3) : null;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), this.visualTemplate(), this.name, value ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(value, 3)) : null, this.symbol, this.amount ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$common$40$1$2e$8$2e$12_0c0b5a574bad561884ab1bf37c6536ee$2f$node_modules$2f40$reown$2f$appkit$2d$common$2f$dist$2f$esm$2f$src$2f$utils$2f$NumberUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NumberUtil"].formatNumberToLocalString(this.amount, 5)) : null);
    }
    visualTemplate() {
        if (this.imageError) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject3());
        }
        if (this.imageSrc) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject4(), this.imageSrc, this.imageLoadError);
        }
        return null;
    }
    imageLoadError() {
        this.imageError = true;
    }
    constructor(){
        super();
        this.observer = new IntersectionObserver(()=>undefined);
        this.imageSrc = undefined;
        this.name = undefined;
        this.symbol = undefined;
        this.price = undefined;
        this.amount = undefined;
        this.visible = false;
        this.imageError = false;
        this.observer = new IntersectionObserver((entries)=>{
            entries.forEach((entry)=>{
                if (entry.isIntersecting) {
                    this.visible = true;
                } else {
                    this.visible = false;
                }
            });
        }, {
            threshold: 0.1
        });
    }
};
WuiTokenListItem.styles = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["resetStyles"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["elementStyles"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$list$2d$item$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]
];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenListItem.prototype, "imageSrc", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenListItem.prototype, "name", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenListItem.prototype, "symbol", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenListItem.prototype, "price", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$property$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["property"])()
], WuiTokenListItem.prototype, "amount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiTokenListItem.prototype, "visible", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], WuiTokenListItem.prototype, "imageError", void 0);
WuiTokenListItem = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('wui-token-list-item')
], WuiTokenListItem);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-list-item.js [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$list$2d$item$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item/index.js [app-client] (ecmascript)"); //# sourceMappingURL=wui-token-list-item.js.map
;
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item-loader/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host {\n    width: 100%;\n  }\n\n  :host > wui-flex {\n    cursor: pointer;\n    height: 100%;\n    width: 100%;\n    display: flex;\n    column-gap: ",
        ";\n    padding: ",
        ";\n    padding-right: ",
        ";\n  }\n\n  wui-flex {\n    display: flex;\n    flex: 1;\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { spacing } = param;
    return spacing['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { spacing } = param;
    return spacing['4'];
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item-loader/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "WuiTokenListItemLoader",
    ()=>WuiTokenListItemLoader
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$components$2f$wui$2d$shimmer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/components/wui-shimmer/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$layout$2f$wui$2d$flex$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/layout/wui-flex/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$list$2d$item$2d$loader$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item-loader/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex alignItems="center">\n        <wui-shimmer width="40px" height="40px"></wui-shimmer>\n        <wui-flex flexDirection="column" gap="1">\n          <wui-shimmer width="72px" height="16px" borderRadius="4xs"></wui-shimmer>\n          <wui-shimmer width="148px" height="14px" borderRadius="4xs"></wui-shimmer>\n        </wui-flex>\n        <wui-flex flexDirection="column" gap="1" alignItems="flex-end">\n          <wui-shimmer width="24px" height="12px" borderRadius="4xs"></wui-shimmer>\n          <wui-shimmer width="32px" height="12px" borderRadius="4xs"></wui-shimmer>\n        </wui-flex>\n      </wui-flex>\n    '
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
let WuiTokenListItemLoader = class WuiTokenListItemLoader extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    render() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject());
    }
};
WuiTokenListItemLoader.styles = [
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["resetStyles"],
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$list$2d$item$2d$loader$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]
];
WuiTokenListItemLoader = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('wui-token-list-item-loader')
], WuiTokenListItemLoader);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-list-item-loader.js [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$composites$2f$wui$2d$token$2d$list$2d$item$2d$loader$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/composites/wui-token-list-item-loader/index.js [app-client] (ecmascript)"); //# sourceMappingURL=wui-token-list-item-loader.js.map
;
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-select-token-view/styles.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/ThemeHelperUtil.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n  :host {\n    --tokens-scroll--top-opacity: 0;\n    --tokens-scroll--bottom-opacity: 1;\n    --suggested-tokens-scroll--left-opacity: 0;\n    --suggested-tokens-scroll--right-opacity: 1;\n  }\n\n  :host > wui-flex:first-child {\n    overflow-y: hidden;\n    overflow-x: hidden;\n    scrollbar-width: none;\n    scrollbar-height: none;\n  }\n\n  :host > wui-flex:first-child::-webkit-scrollbar {\n    display: none;\n  }\n\n  wui-loading-hexagon {\n    position: absolute;\n  }\n\n  .suggested-tokens-container {\n    overflow-x: auto;\n    mask-image: linear-gradient(\n      to right,\n      rgba(0, 0, 0, calc(1 - var(--suggested-tokens-scroll--left-opacity))) 0px,\n      rgba(200, 200, 200, calc(1 - var(--suggested-tokens-scroll--left-opacity))) 1px,\n      black 50px,\n      black 90px,\n      black calc(100% - 90px),\n      black calc(100% - 50px),\n      rgba(155, 155, 155, calc(1 - var(--suggested-tokens-scroll--right-opacity))) calc(100% - 1px),\n      rgba(0, 0, 0, calc(1 - var(--suggested-tokens-scroll--right-opacity))) 100%\n    );\n  }\n\n  .suggested-tokens-container::-webkit-scrollbar {\n    display: none;\n  }\n\n  .tokens-container {\n    border-top: 1px solid ",
        ";\n    height: 100%;\n    max-height: 390px;\n  }\n\n  .tokens {\n    width: 100%;\n    overflow-y: auto;\n    mask-image: linear-gradient(\n      to bottom,\n      rgba(0, 0, 0, calc(1 - var(--tokens-scroll--top-opacity))) 0px,\n      rgba(200, 200, 200, calc(1 - var(--tokens-scroll--top-opacity))) 1px,\n      black 50px,\n      black 90px,\n      black calc(100% - 90px),\n      black calc(100% - 50px),\n      rgba(155, 155, 155, calc(1 - var(--tokens-scroll--bottom-opacity))) calc(100% - 1px),\n      rgba(0, 0, 0, calc(1 - var(--tokens-scroll--bottom-opacity))) 100%\n    );\n  }\n\n  .network-search-input,\n  .select-network-button {\n    height: 40px;\n  }\n\n  .select-network-button {\n    border: none;\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    justify-content: center;\n    gap: ",
        ";\n    box-shadow: inset 0 0 0 1px ",
        ";\n    background-color: transparent;\n    border-radius: ",
        ";\n    padding: ",
        ";\n    align-items: center;\n    transition: background-color ",
        "\n      ",
        ";\n    will-change: background-color;\n  }\n\n  .select-network-button:hover {\n    background-color: ",
        ";\n  }\n\n  .select-network-button > wui-image {\n    width: 26px;\n    height: 26px;\n    border-radius: ",
        ";\n    box-shadow: inset 0 0 0 1px ",
        ";\n  }\n"
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
;
const __TURBOPACK__default__export__ = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$ThemeHelperUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["css"])(_templateObject(), (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['3'];
}, (param)=>{
    let { spacing } = param;
    return spacing['2'];
}, (param)=>{
    let { durations } = param;
    return durations['lg'];
}, (param)=>{
    let { easings } = param;
    return easings['ease-out-power-2'];
}, (param)=>{
    let { tokens } = param;
    return tokens.theme.foregroundPrimary;
}, (param)=>{
    let { borderRadius } = param;
    return borderRadius['4'];
}, (param)=>{
    let { tokens } = param;
    return tokens.core.glass010;
});
 //# sourceMappingURL=styles.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-select-token-view/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "W3mSwapSelectTokenView",
    ()=>W3mSwapSelectTokenView
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@swc+helpers@0.5.15/node_modules/@swc/helpers/esm/_tagged_template_literal.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-element@4.2.1/node_modules/lit-element/development/lit-element.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit-html@3.3.1/node_modules/lit-html/development/lit-html.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2f$decorators$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/lit@3.3.1/node_modules/lit/decorators.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@lit+reactive-element@2.1.1/node_modules/@lit/reactive-element/development/decorators/state.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/RouterController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-controllers@1_49cdd9744ebe2acac144d0e70cd96288/node_modules/@reown/appkit-controllers/dist/esm/src/controllers/SwapController.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/index.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$MathUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/MathUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/src/utils/WebComponentsUtil.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$flex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-flex.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$icon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-icon.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$input$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-input-text.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-text.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$token$2d$button$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-button.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$token$2d$list$2d$item$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-list-item.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$exports$2f$wui$2d$token$2d$list$2d$item$2d$loader$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-ui@1.8.12_@ty_fde04c48c19efb26add9ff8f1c7b1ea5/node_modules/@reown/appkit-ui/dist/esm/exports/wui-token-list-item-loader.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$select$2d$token$2d$view$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-select-token-view/styles.js [app-client] (ecmascript)");
;
function _templateObject() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex flexDirection="column" gap="3">\n        ',
        " ",
        " ",
        "\n      </wui-flex>\n    "
    ]);
    _templateObject = function() {
        return data;
    };
    return data;
}
function _templateObject1() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n      <wui-flex .padding=",
        ' gap="2">\n        <wui-input-text\n          data-testid="swap-select-token-search-input"\n          class="network-search-input"\n          size="sm"\n          placeholder="Search token"\n          icon="search"\n          .value=',
        "\n          @inputChange=",
        "\n        ></wui-input-text>\n      </wui-flex>\n    "
    ]);
    _templateObject1 = function() {
        return data;
    };
    return data;
}
function _templateObject2() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n            <wui-token-list-item\n              data-testid="swap-select-token-item-',
        '"\n              name=',
        "\n              ?disabled=",
        "\n              symbol=",
        "\n              price=",
        "\n              amount=",
        "\n              imageSrc=",
        "\n              @click=",
        "\n            >\n            </wui-token-list-item>\n          "
    ]);
    _templateObject2 = function() {
        return data;
    };
    return data;
}
function _templateObject3() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '<wui-flex justifyContent="flex-start" padding="2">\n          <wui-text variant="md-medium" color="secondary">Your tokens</wui-text>\n        </wui-flex>\n        ',
        ""
    ]);
    _templateObject3 = function() {
        return data;
    };
    return data;
}
function _templateObject4() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n        <wui-token-list-item-loader></wui-token-list-item-loader>\n        <wui-token-list-item-loader></wui-token-list-item-loader>\n        <wui-token-list-item-loader></wui-token-list-item-loader>\n        <wui-token-list-item-loader></wui-token-list-item-loader>\n        <wui-token-list-item-loader></wui-token-list-item-loader>\n      "
    ]);
    _templateObject4 = function() {
        return data;
    };
    return data;
}
function _templateObject5() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n            <wui-token-list-item\n              data-testid="swap-select-token-item-',
        '"\n              name=',
        "\n              symbol=",
        "\n              imageSrc=",
        "\n              @click=",
        "\n            >\n            </wui-token-list-item>\n          "
    ]);
    _templateObject5 = function() {
        return data;
    };
    return data;
}
function _templateObject6() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n        ",
        "\n      "
    ]);
    _templateObject6 = function() {
        return data;
    };
    return data;
}
function _templateObject7() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex class="tokens-container">\n        <wui-flex class="tokens" .padding=',
        ' flexDirection="column">\n          ',
        '\n          <wui-flex justifyContent="flex-start" padding="3">\n            <wui-text variant="md-medium" color="secondary">Tokens</wui-text>\n          </wui-flex>\n          ',
        "\n        </wui-flex>\n      </wui-flex>\n    "
    ]);
    _templateObject7 = function() {
        return data;
    };
    return data;
}
function _templateObject8() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n        <wui-flex\n          class="suggested-tokens-container"\n          .padding=',
        '\n          gap="2"\n        >\n          <wui-token-button loading></wui-token-button>\n          <wui-token-button loading></wui-token-button>\n          <wui-token-button loading></wui-token-button>\n          <wui-token-button loading></wui-token-button>\n          <wui-token-button loading></wui-token-button>\n        </wui-flex>\n      '
    ]);
    _templateObject8 = function() {
        return data;
    };
    return data;
}
function _templateObject9() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        "\n            <wui-token-button\n              text=",
        "\n              imageSrc=",
        "\n              @click=",
        "\n            >\n            </wui-token-button>\n          "
    ]);
    _templateObject9 = function() {
        return data;
    };
    return data;
}
function _templateObject10() {
    const data = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$swc$2b$helpers$40$0$2e$5$2e$15$2f$node_modules$2f40$swc$2f$helpers$2f$esm$2f$_tagged_template_literal$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["_"])([
        '\n      <wui-flex\n        class="suggested-tokens-container"\n        .padding=',
        '\n        gap="2"\n      >\n        ',
        "\n      </wui-flex>\n    "
    ]);
    _templateObject10 = function() {
        return data;
    };
    return data;
}
var __decorate = ("TURBOPACK compile-time value", void 0) && ("TURBOPACK compile-time value", void 0).__decorate || function(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for(var i = decorators.length - 1; i >= 0; i--)if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
;
;
;
;
;
;
;
;
;
;
;
;
;
let W3mSwapSelectTokenView = class W3mSwapSelectTokenView extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$element$40$4$2e$2$2e$1$2f$node_modules$2f$lit$2d$element$2f$development$2f$lit$2d$element$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LitElement"] {
    async firstUpdated() {
        await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].getTokenList();
    }
    updated() {
        var _this_renderRoot, _this_renderRoot1;
        const suggestedTokensContainer = (_this_renderRoot = this.renderRoot) === null || _this_renderRoot === void 0 ? void 0 : _this_renderRoot.querySelector('.suggested-tokens-container');
        suggestedTokensContainer === null || suggestedTokensContainer === void 0 ? void 0 : suggestedTokensContainer.addEventListener('scroll', this.handleSuggestedTokensScroll.bind(this));
        const tokensList = (_this_renderRoot1 = this.renderRoot) === null || _this_renderRoot1 === void 0 ? void 0 : _this_renderRoot1.querySelector('.tokens');
        tokensList === null || tokensList === void 0 ? void 0 : tokensList.addEventListener('scroll', this.handleTokenListScroll.bind(this));
    }
    disconnectedCallback() {
        var _this_renderRoot, _this_renderRoot1;
        super.disconnectedCallback();
        const suggestedTokensContainer = (_this_renderRoot = this.renderRoot) === null || _this_renderRoot === void 0 ? void 0 : _this_renderRoot.querySelector('.suggested-tokens-container');
        const tokensList = (_this_renderRoot1 = this.renderRoot) === null || _this_renderRoot1 === void 0 ? void 0 : _this_renderRoot1.querySelector('.tokens');
        suggestedTokensContainer === null || suggestedTokensContainer === void 0 ? void 0 : suggestedTokensContainer.removeEventListener('scroll', this.handleSuggestedTokensScroll.bind(this));
        tokensList === null || tokensList === void 0 ? void 0 : tokensList.removeEventListener('scroll', this.handleTokenListScroll.bind(this));
        clearInterval(this.interval);
    }
    render() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject(), this.templateSearchInput(), this.templateSuggestedTokens(), this.templateTokens());
    }
    onSelectToken(token) {
        if (this.targetToken === 'sourceToken') {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setSourceToken(token);
        } else {
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].setToToken(token);
            if (this.sourceToken && this.sourceTokenAmount) {
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].swapTokens();
            }
        }
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].goBack();
    }
    templateSearchInput() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject1(), [
            '1',
            '3',
            '0',
            '3'
        ], this.searchValue, this.onSearchInputChange.bind(this));
    }
    templateMyTokens() {
        const yourTokens = this.myTokensWithBalance ? Object.values(this.myTokensWithBalance) : [];
        const filteredYourTokens = this.filterTokensWithText(yourTokens, this.searchValue);
        if ((filteredYourTokens === null || filteredYourTokens === void 0 ? void 0 : filteredYourTokens.length) > 0) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject3(), filteredYourTokens.map((token)=>{
                var _this_sourceToken, _this_toToken, _token_quantity;
                const selected = token.symbol === ((_this_sourceToken = this.sourceToken) === null || _this_sourceToken === void 0 ? void 0 : _this_sourceToken.symbol) || token.symbol === ((_this_toToken = this.toToken) === null || _this_toToken === void 0 ? void 0 : _this_toToken.symbol);
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject2(), token.symbol, token.name, selected, token.symbol, token === null || token === void 0 ? void 0 : token.price, token === null || token === void 0 ? void 0 : (_token_quantity = token.quantity) === null || _token_quantity === void 0 ? void 0 : _token_quantity.numeric, token.logoUri, ()=>{
                    if (!selected) {
                        this.onSelectToken(token);
                    }
                });
            }));
        }
        return null;
    }
    templateAllTokens() {
        const tokens = this.popularTokens ? this.popularTokens : [];
        const filteredTokens = this.filterTokensWithText(tokens, this.searchValue);
        if (this.tokensLoading) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject4());
        }
        if ((filteredTokens === null || filteredTokens === void 0 ? void 0 : filteredTokens.length) > 0) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject6(), filteredTokens.map((token)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject5(), token.symbol, token.name, token.symbol, token.logoUri, ()=>this.onSelectToken(token))));
        }
        return null;
    }
    templateTokens() {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject7(), [
            '0',
            '2',
            '2',
            '2'
        ], this.templateMyTokens(), this.templateAllTokens());
    }
    templateSuggestedTokens() {
        const tokens = this.suggestedTokens ? this.suggestedTokens.slice(0, 8) : null;
        if (this.tokensLoading) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject8(), [
                '0',
                '3',
                '0',
                '3'
            ]);
        }
        if (!tokens) {
            return null;
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject10(), [
            '0',
            '3',
            '0',
            '3'
        ], tokens.map((token)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$lit$2d$html$40$3$2e$3$2e$1$2f$node_modules$2f$lit$2d$html$2f$development$2f$lit$2d$html$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["html"])(_templateObject9(), token.symbol, token.logoUri, ()=>this.onSelectToken(token))));
    }
    onSearchInputChange(event) {
        this.searchValue = event.detail;
    }
    handleSuggestedTokensScroll() {
        var _this_renderRoot;
        const container = (_this_renderRoot = this.renderRoot) === null || _this_renderRoot === void 0 ? void 0 : _this_renderRoot.querySelector('.suggested-tokens-container');
        if (!container) {
            return;
        }
        container.style.setProperty('--suggested-tokens-scroll--left-opacity', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$MathUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["MathUtil"].interpolate([
            0,
            100
        ], [
            0,
            1
        ], container.scrollLeft).toString());
        container.style.setProperty('--suggested-tokens-scroll--right-opacity', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$MathUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["MathUtil"].interpolate([
            0,
            100
        ], [
            0,
            1
        ], container.scrollWidth - container.scrollLeft - container.offsetWidth).toString());
    }
    handleTokenListScroll() {
        var _this_renderRoot;
        const container = (_this_renderRoot = this.renderRoot) === null || _this_renderRoot === void 0 ? void 0 : _this_renderRoot.querySelector('.tokens');
        if (!container) {
            return;
        }
        container.style.setProperty('--tokens-scroll--top-opacity', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$MathUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["MathUtil"].interpolate([
            0,
            100
        ], [
            0,
            1
        ], container.scrollTop).toString());
        container.style.setProperty('--tokens-scroll--bottom-opacity', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$MathUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["MathUtil"].interpolate([
            0,
            100
        ], [
            0,
            1
        ], container.scrollHeight - container.scrollTop - container.offsetHeight).toString());
    }
    filterTokensWithText(tokens, text) {
        return tokens.filter((token)=>"".concat(token.symbol, " ").concat(token.name, " ").concat(token.address).toLowerCase().includes(text.toLowerCase())).sort((a, b)=>{
            const aText = "".concat(a.symbol, " ").concat(a.name, " ").concat(a.address).toLowerCase();
            const bText = "".concat(b.symbol, " ").concat(b.name, " ").concat(b.address).toLowerCase();
            const aIndex = aText.indexOf(text.toLowerCase());
            const bIndex = bText.indexOf(text.toLowerCase());
            return aIndex - bIndex;
        });
    }
    constructor(){
        var _RouterController_state_data;
        super();
        this.unsubscribe = [];
        this.targetToken = (_RouterController_state_data = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$RouterController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RouterController"].state.data) === null || _RouterController_state_data === void 0 ? void 0 : _RouterController_state_data.target;
        this.sourceToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceToken;
        this.sourceTokenAmount = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.sourceTokenAmount;
        this.toToken = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.toToken;
        this.myTokensWithBalance = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.myTokensWithBalance;
        this.popularTokens = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.popularTokens;
        this.suggestedTokens = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.suggestedTokens;
        this.tokensLoading = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].state.tokensLoading;
        this.searchValue = '';
        this.unsubscribe.push(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$controllers$40$1_49cdd9744ebe2acac144d0e70cd96288$2f$node_modules$2f40$reown$2f$appkit$2d$controllers$2f$dist$2f$esm$2f$src$2f$controllers$2f$SwapController$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwapController"].subscribe((newState)=>{
            this.sourceToken = newState.sourceToken;
            this.toToken = newState.toToken;
            this.myTokensWithBalance = newState.myTokensWithBalance;
            this.popularTokens = newState.popularTokens;
            this.suggestedTokens = newState.suggestedTokens;
            this.tokensLoading = newState.tokensLoading;
        }));
    }
};
W3mSwapSelectTokenView.styles = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$select$2d$token$2d$view$2f$styles$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"];
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "interval", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "targetToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "sourceToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "sourceTokenAmount", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "toToken", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "myTokensWithBalance", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "popularTokens", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "suggestedTokens", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "tokensLoading", void 0);
__decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$lit$2b$reactive$2d$element$40$2$2e$1$2e$1$2f$node_modules$2f40$lit$2f$reactive$2d$element$2f$development$2f$decorators$2f$state$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["state"])()
], W3mSwapSelectTokenView.prototype, "searchValue", void 0);
W3mSwapSelectTokenView = __decorate([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$ui$40$1$2e$8$2e$12_$40$ty_fde04c48c19efb26add9ff8f1c7b1ea5$2f$node_modules$2f40$reown$2f$appkit$2d$ui$2f$dist$2f$esm$2f$src$2f$utils$2f$WebComponentsUtil$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["customElement"])('w3m-swap-select-token-view')
], W3mSwapSelectTokenView);
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/exports/swaps.js [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-view/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$preview$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-preview-view/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$select$2d$token$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-select-token-view/index.js [app-client] (ecmascript)");
;
;
;
;
 //# sourceMappingURL=swaps.js.map
}),
"[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/exports/swaps.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "W3mSwapPreviewView",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$preview$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mSwapPreviewView"],
    "W3mSwapSelectTokenView",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$select$2d$token$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mSwapSelectTokenView"],
    "W3mSwapView",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["W3mSwapView"]
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$exports$2f$swaps$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/exports/swaps.js [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-view/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$preview$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-preview-view/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$reown$2b$appkit$2d$scaffold$2d$ui$40$1_9c578030aaadde8b008902713dcb7d50$2f$node_modules$2f40$reown$2f$appkit$2d$scaffold$2d$ui$2f$dist$2f$esm$2f$src$2f$views$2f$w3m$2d$swap$2d$select$2d$token$2d$view$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@reown+appkit-scaffold-ui@1_9c578030aaadde8b008902713dcb7d50/node_modules/@reown/appkit-scaffold-ui/dist/esm/src/views/w3m-swap-select-token-view/index.js [app-client] (ecmascript)");
}),
]);

//# sourceMappingURL=node_modules__pnpm_1ad691c1._.js.map