(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/RpcResponse.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// eslint-disable-next-line jsdoc/require-jsdoc
__turbopack_context__.s([
    "BaseError",
    ()=>BaseError,
    "InternalError",
    ()=>InternalError,
    "InvalidInputError",
    ()=>InvalidInputError,
    "InvalidParamsError",
    ()=>InvalidParamsError,
    "InvalidRequestError",
    ()=>InvalidRequestError,
    "LimitExceededError",
    ()=>LimitExceededError,
    "MethodNotFoundError",
    ()=>MethodNotFoundError,
    "MethodNotSupportedError",
    ()=>MethodNotSupportedError,
    "ParseError",
    ()=>ParseError,
    "ResourceNotFoundError",
    ()=>ResourceNotFoundError,
    "ResourceUnavailableError",
    ()=>ResourceUnavailableError,
    "TransactionRejectedError",
    ()=>TransactionRejectedError,
    "VersionNotSupportedError",
    ()=>VersionNotSupportedError,
    "from",
    ()=>from,
    "parse",
    ()=>parse,
    "parseError",
    ()=>parseError
]);
function from(response) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { request } = options;
    var _response_id, _response_jsonrpc;
    return {
        ...response,
        id: (_response_id = response.id) !== null && _response_id !== void 0 ? _response_id : request === null || request === void 0 ? void 0 : request.id,
        jsonrpc: (_response_jsonrpc = response.jsonrpc) !== null && _response_jsonrpc !== void 0 ? _response_jsonrpc : request.jsonrpc
    };
}
function parse(response) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { raw = false } = options;
    const response_ = response;
    if (raw) return response;
    if (response_.error) throw parseError(response_.error);
    return response_.result;
}
function parseError(error) {
    const error_ = error;
    if (error_ instanceof Error && !('code' in error_)) return new InternalError({
        cause: error_,
        data: error_,
        message: error_.message,
        stack: error_.stack
    });
    const { code } = error_;
    if (code === InternalError.code) return new InternalError(error_);
    if (code === InvalidInputError.code) return new InvalidInputError(error_);
    if (code === InvalidParamsError.code) return new InvalidParamsError(error_);
    if (code === InvalidRequestError.code) return new InvalidRequestError(error_);
    if (code === LimitExceededError.code) return new LimitExceededError(error_);
    if (code === MethodNotFoundError.code) return new MethodNotFoundError(error_);
    if (code === MethodNotSupportedError.code) return new MethodNotSupportedError(error_);
    if (code === ParseError.code) return new ParseError(error_);
    if (code === ResourceNotFoundError.code) return new ResourceNotFoundError(error_);
    if (code === ResourceUnavailableError.code) return new ResourceUnavailableError(error_);
    if (code === TransactionRejectedError.code) return new TransactionRejectedError(error_);
    if (code === VersionNotSupportedError.code) return new VersionNotSupportedError(error_);
    return new InternalError({
        cause: error_ instanceof Error ? error_ : undefined,
        data: error_,
        message: error_.message,
        stack: error_ instanceof Error ? error_.stack : undefined
    });
}
class BaseError extends Error {
    constructor(errorObject){
        const { cause, code, message, data, stack } = errorObject;
        super(message, {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.BaseError'
        });
        Object.defineProperty(this, "cause", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "stack", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.cause = cause;
        this.code = code;
        this.data = data;
        this.stack = stack !== null && stack !== void 0 ? stack : '';
    }
}
class InvalidInputError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: InvalidInputError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Missing or invalid parameters.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32000
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.InvalidInputError'
        });
    }
}
Object.defineProperty(InvalidInputError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32000
});
class ResourceNotFoundError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: ResourceNotFoundError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Requested resource not found.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32001
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.ResourceNotFoundError'
        });
    }
}
Object.defineProperty(ResourceNotFoundError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32001
});
class ResourceUnavailableError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: ResourceUnavailableError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Requested resource not available.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32002
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.ResourceUnavailableError'
        });
    }
}
Object.defineProperty(ResourceUnavailableError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32002
});
class TransactionRejectedError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: TransactionRejectedError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Transaction creation failed.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32003
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.TransactionRejectedError'
        });
    }
}
Object.defineProperty(TransactionRejectedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32003
});
class MethodNotSupportedError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: MethodNotSupportedError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Method is not implemented.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32004
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.MethodNotSupportedError'
        });
    }
}
Object.defineProperty(MethodNotSupportedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32004
});
class LimitExceededError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: LimitExceededError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Rate limit exceeded.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32005
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.LimitExceededError'
        });
    }
}
Object.defineProperty(LimitExceededError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32005
});
class VersionNotSupportedError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: VersionNotSupportedError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'JSON-RPC version not supported.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32006
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.VersionNotSupportedError'
        });
    }
}
Object.defineProperty(VersionNotSupportedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32006
});
class InvalidRequestError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: InvalidRequestError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Input is not a valid JSON-RPC request.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32600
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.InvalidRequestError'
        });
    }
}
Object.defineProperty(InvalidRequestError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32600
});
class MethodNotFoundError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: MethodNotFoundError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Method does not exist.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32601
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.MethodNotFoundError'
        });
    }
}
Object.defineProperty(MethodNotFoundError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32601
});
class InvalidParamsError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: InvalidParamsError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Invalid method parameters.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32602
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.InvalidParamsError'
        });
    }
}
Object.defineProperty(InvalidParamsError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32602
});
class InternalError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            cause: parameters.cause,
            code: InternalError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Internal JSON-RPC error.',
            stack: parameters.stack
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32603
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.InternalError'
        });
    }
}
Object.defineProperty(InternalError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32603
});
class ParseError extends BaseError {
    constructor(parameters = {}){
        var _parameters_message;
        super({
            code: ParseError.code,
            data: parameters.data,
            message: (_parameters_message = parameters.message) !== null && _parameters_message !== void 0 ? _parameters_message : 'Failed to parse JSON-RPC response.'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: -32700
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'RpcResponse.ParseError'
        });
    }
}
Object.defineProperty(ParseError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: -32700
}); //# sourceMappingURL=RpcResponse.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Provider.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AtomicReadyWalletRejectedUpgradeError",
    ()=>AtomicReadyWalletRejectedUpgradeError,
    "AtomicityNotSupportedError",
    ()=>AtomicityNotSupportedError,
    "BundleTooLargeError",
    ()=>BundleTooLargeError,
    "ChainDisconnectedError",
    ()=>ChainDisconnectedError,
    "DisconnectedError",
    ()=>DisconnectedError,
    "DuplicateIdError",
    ()=>DuplicateIdError,
    "IsUndefinedError",
    ()=>IsUndefinedError,
    "ProviderRpcError",
    ()=>ProviderRpcError,
    "SwitchChainError",
    ()=>SwitchChainError,
    "UnauthorizedError",
    ()=>UnauthorizedError,
    "UnknownBundleIdError",
    ()=>UnknownBundleIdError,
    "UnsupportedChainIdError",
    ()=>UnsupportedChainIdError,
    "UnsupportedMethodError",
    ()=>UnsupportedMethodError,
    "UnsupportedNonOptionalCapabilityError",
    ()=>UnsupportedNonOptionalCapabilityError,
    "UserRejectedRequestError",
    ()=>UserRejectedRequestError,
    "createEmitter",
    ()=>createEmitter,
    "from",
    ()=>from,
    "parseError",
    ()=>parseError
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$eventemitter3$40$5$2e$0$2e$1$2f$node_modules$2f$eventemitter3$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/eventemitter3@5.0.1/node_modules/eventemitter3/index.mjs [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$eventemitter3$40$5$2e$0$2e$1$2f$node_modules$2f$eventemitter3$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__EventEmitter$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/eventemitter3@5.0.1/node_modules/eventemitter3/index.js [app-client] (ecmascript) <export default as EventEmitter>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$RpcResponse$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/RpcResponse.js [app-client] (ecmascript)");
;
;
;
class ProviderRpcError extends Error {
    constructor(code, message){
        super(message);
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'ProviderRpcError'
        });
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "details", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.code = code;
        this.details = message;
    }
}
class UserRejectedRequestError extends ProviderRpcError {
    constructor({ message = 'The user rejected the request.' } = {}){
        super(4001, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 4001
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.UserRejectedRequestError'
        });
    }
}
Object.defineProperty(UserRejectedRequestError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4001
});
class UnauthorizedError extends ProviderRpcError {
    constructor({ message = 'The requested method and/or account has not been authorized by the user.' } = {}){
        super(4100, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 4100
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.UnauthorizedError'
        });
    }
}
Object.defineProperty(UnauthorizedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4100
});
class UnsupportedMethodError extends ProviderRpcError {
    constructor({ message = 'The provider does not support the requested method.' } = {}){
        super(4200, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 4200
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.UnsupportedMethodError'
        });
    }
}
Object.defineProperty(UnsupportedMethodError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4200
});
class DisconnectedError extends ProviderRpcError {
    constructor({ message = 'The provider is disconnected from all chains.' } = {}){
        super(4900, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 4900
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.DisconnectedError'
        });
    }
}
Object.defineProperty(DisconnectedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4900
});
class ChainDisconnectedError extends ProviderRpcError {
    constructor({ message = 'The provider is not connected to the requested chain.' } = {}){
        super(4901, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 4901
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.ChainDisconnectedError'
        });
    }
}
Object.defineProperty(ChainDisconnectedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4901
});
class SwitchChainError extends ProviderRpcError {
    constructor({ message = 'An error occurred when attempting to switch chain.' } = {}){
        super(4902, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 4902
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.SwitchChainError'
        });
    }
}
Object.defineProperty(SwitchChainError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 4902
});
class UnsupportedNonOptionalCapabilityError extends ProviderRpcError {
    constructor({ message = 'This Wallet does not support a capability that was not marked as optional.' } = {}){
        super(5700, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5700
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.UnsupportedNonOptionalCapabilityError'
        });
    }
}
Object.defineProperty(UnsupportedNonOptionalCapabilityError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5700
});
class UnsupportedChainIdError extends ProviderRpcError {
    constructor({ message = 'This Wallet does not support the requested chain ID.' } = {}){
        super(5710, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5710
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.UnsupportedChainIdError'
        });
    }
}
Object.defineProperty(UnsupportedChainIdError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5710
});
class DuplicateIdError extends ProviderRpcError {
    constructor({ message = 'There is already a bundle submitted with this ID.' } = {}){
        super(5720, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5720
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.DuplicateIdError'
        });
    }
}
Object.defineProperty(DuplicateIdError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5720
});
class UnknownBundleIdError extends ProviderRpcError {
    constructor({ message = 'This bundle id is unknown / has not been submitted.' } = {}){
        super(5730, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5730
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.UnknownBundleIdError'
        });
    }
}
Object.defineProperty(UnknownBundleIdError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5730
});
class BundleTooLargeError extends ProviderRpcError {
    constructor({ message = 'The call bundle is too large for the Wallet to process.' } = {}){
        super(5740, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5740
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.BundleTooLargeError'
        });
    }
}
Object.defineProperty(BundleTooLargeError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5740
});
class AtomicReadyWalletRejectedUpgradeError extends ProviderRpcError {
    constructor({ message = 'The Wallet can support atomicity after an upgrade, but the user rejected the upgrade.' } = {}){
        super(5750, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5750
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.AtomicReadyWalletRejectedUpgradeError'
        });
    }
}
Object.defineProperty(AtomicReadyWalletRejectedUpgradeError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5750
});
class AtomicityNotSupportedError extends ProviderRpcError {
    constructor({ message = 'The wallet does not support atomic execution but the request requires it.' } = {}){
        super(5760, message);
        Object.defineProperty(this, "code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 5760
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.AtomicityNotSupportedError'
        });
    }
}
Object.defineProperty(AtomicityNotSupportedError, "code", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: 5760
});
function createEmitter() {
    const emitter = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$eventemitter3$40$5$2e$0$2e$1$2f$node_modules$2f$eventemitter3$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__EventEmitter$3e$__["EventEmitter"]();
    return {
        get eventNames () {
            return emitter.eventNames.bind(emitter);
        },
        get listenerCount () {
            return emitter.listenerCount.bind(emitter);
        },
        get listeners () {
            return emitter.listeners.bind(emitter);
        },
        addListener: emitter.addListener.bind(emitter),
        emit: emitter.emit.bind(emitter),
        off: emitter.off.bind(emitter),
        on: emitter.on.bind(emitter),
        once: emitter.once.bind(emitter),
        removeAllListeners: emitter.removeAllListeners.bind(emitter),
        removeListener: emitter.removeListener.bind(emitter)
    };
}
function from(provider) {
    let _options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (!provider) throw new IsUndefinedError();
    return {
        ...provider,
        async request (args) {
            try {
                const result = await provider.request(args);
                if (result && typeof result === 'object' && 'jsonrpc' in result) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$RpcResponse$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parse"](result);
                return result;
            } catch (error) {
                throw parseError(error);
            }
        }
    };
}
function parseError(error) {
    const error_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$RpcResponse$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseError"](error);
    if (error_ instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$RpcResponse$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InternalError"]) {
        if (!error_.data) return error_;
        const { code } = error_.data;
        if (code === DisconnectedError.code) return new DisconnectedError(error_);
        if (code === ChainDisconnectedError.code) return new ChainDisconnectedError(error_);
        if (code === UserRejectedRequestError.code) return new UserRejectedRequestError(error_);
        if (code === UnauthorizedError.code) return new UnauthorizedError(error_);
        if (code === UnsupportedMethodError.code) return new UnsupportedMethodError(error_);
        if (code === SwitchChainError.code) return new SwitchChainError(error_);
        if (code === AtomicReadyWalletRejectedUpgradeError.code) return new AtomicReadyWalletRejectedUpgradeError(error_);
        if (code === AtomicityNotSupportedError.code) return new AtomicityNotSupportedError(error_);
        if (code === BundleTooLargeError.code) return new BundleTooLargeError(error_);
        if (code === UnknownBundleIdError.code) return new UnknownBundleIdError(error_);
        if (code === DuplicateIdError.code) return new DuplicateIdError(error_);
        if (code === UnsupportedChainIdError.code) return new UnsupportedChainIdError(error_);
        if (code === UnsupportedNonOptionalCapabilityError.code) return new UnsupportedNonOptionalCapabilityError(error_);
    }
    return error_;
}
class IsUndefinedError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('`provider` is undefined.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Provider.IsUndefinedError'
        });
    }
} //# sourceMappingURL=Provider.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "keccak256",
    ()=>keccak256,
    "ripemd160",
    ()=>ripemd160,
    "sha256",
    ()=>sha256,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$ripemd160$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/esm/ripemd160.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha3$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/esm/sha3.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/esm/sha256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
;
;
;
function keccak256(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = typeof value === 'string' ? 'Hex' : 'Bytes' } = options;
    const bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha3$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak_256"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value));
    if (as === 'Bytes') return bytes;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
}
function ripemd160(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = typeof value === 'string' ? 'Hex' : 'Bytes' } = options;
    const bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$ripemd160$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ripemd160"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value));
    if (as === 'Bytes') return bytes;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
}
function sha256(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = typeof value === 'string' ? 'Hex' : 'Bytes' } = options;
    const bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sha256"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value));
    if (as === 'Bytes') return bytes;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
}
function validate(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value) && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) === 32;
} //# sourceMappingURL=Hash.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/lru.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @internal
 *
 * Map with a LRU (Least recently used) policy.
 * @see https://en.wikipedia.org/wiki/Cache_replacement_policies#LRU
 */ __turbopack_context__.s([
    "LruMap",
    ()=>LruMap
]);
class LruMap extends Map {
    get(key) {
        const value = super.get(key);
        if (super.has(key) && value !== undefined) {
            this.delete(key);
            super.set(key, value);
        }
        return value;
    }
    set(key, value) {
        super.set(key, value);
        if (this.maxSize && this.size > this.maxSize) {
            const firstKey = this.keys().next().value;
            if (firstKey) this.delete(firstKey);
        }
        return this;
    }
    constructor(size){
        super();
        Object.defineProperty(this, "maxSize", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.maxSize = size;
    }
} //# sourceMappingURL=lru.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Caches.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "checksum",
    ()=>checksum,
    "clear",
    ()=>clear
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$lru$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/lru.js [app-client] (ecmascript)");
;
const caches = {
    checksum: /*#__PURE__*/ new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$lru$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LruMap"](8192)
};
const checksum = caches.checksum;
function clear() {
    for (const cache of Object.values(caches))cache.clear();
} //# sourceMappingURL=Caches.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidCompressedPrefixError",
    ()=>InvalidCompressedPrefixError,
    "InvalidError",
    ()=>InvalidError,
    "InvalidPrefixError",
    ()=>InvalidPrefixError,
    "InvalidSerializedSizeError",
    ()=>InvalidSerializedSizeError,
    "InvalidUncompressedPrefixError",
    ()=>InvalidUncompressedPrefixError,
    "assert",
    ()=>assert,
    "compress",
    ()=>compress,
    "from",
    ()=>from,
    "fromBytes",
    ()=>fromBytes,
    "fromHex",
    ()=>fromHex,
    "toBytes",
    ()=>toBytes,
    "toHex",
    ()=>toHex,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
;
;
;
;
function assert(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { compressed } = options;
    const { prefix, x, y } = publicKey;
    // Uncompressed
    if (compressed === false || typeof x === 'bigint' && typeof y === 'bigint') {
        if (prefix !== 4) throw new InvalidPrefixError({
            prefix,
            cause: new InvalidUncompressedPrefixError()
        });
        return;
    }
    // Compressed
    if (compressed === true || typeof x === 'bigint' && typeof y === 'undefined') {
        if (prefix !== 3 && prefix !== 2) throw new InvalidPrefixError({
            prefix,
            cause: new InvalidCompressedPrefixError()
        });
        return;
    }
    // Unknown/invalid
    throw new InvalidError({
        publicKey
    });
}
function compress(publicKey) {
    const { x, y } = publicKey;
    return {
        prefix: y % 2n === 0n ? 2 : 3,
        x
    };
}
function from(value) {
    const publicKey = (()=>{
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value)) return fromHex(value);
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value)) return fromBytes(value);
        const { prefix, x, y } = value;
        if (typeof x === 'bigint' && typeof y === 'bigint') return {
            prefix: prefix !== null && prefix !== void 0 ? prefix : 0x04,
            x,
            y
        };
        return {
            prefix,
            x
        };
    })();
    assert(publicKey);
    return publicKey;
}
function fromBytes(publicKey) {
    return fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](publicKey));
}
function fromHex(publicKey) {
    if (publicKey.length !== 132 && publicKey.length !== 130 && publicKey.length !== 68) throw new InvalidSerializedSizeError({
        publicKey
    });
    if (publicKey.length === 130) {
        const x = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 0, 32));
        const y = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 32, 64));
        return {
            prefix: 4,
            x,
            y
        };
    }
    if (publicKey.length === 132) {
        const prefix = Number(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 0, 1));
        const x = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 1, 33));
        const y = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 33, 65));
        return {
            prefix,
            x,
            y
        };
    }
    const prefix = Number(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 0, 1));
    const x = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 1, 33));
    return {
        prefix,
        x
    };
}
function toBytes(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](toHex(publicKey, options));
}
function toHex(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    assert(publicKey);
    const { prefix, x, y } = publicKey;
    const { includePrefix = true } = options;
    const publicKey_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](includePrefix ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](prefix, {
        size: 1
    }) : '0x', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](x, {
        size: 32
    }), // If the public key is not compressed, add the y coordinate.
    typeof y === 'bigint' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](y, {
        size: 32
    }) : '0x');
    return publicKey_;
}
function validate(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    try {
        assert(publicKey, options);
        return true;
    } catch (_error) {
        return false;
    }
}
class InvalidError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ publicKey }){
        super("Value `".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](publicKey), "` is not a valid public key."), {
            metaMessages: [
                'Public key must contain:',
                '- an `x` and `prefix` value (compressed)',
                '- an `x`, `y`, and `prefix` value (uncompressed)'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidError'
        });
    }
}
class InvalidPrefixError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ prefix, cause }){
        super('Prefix "'.concat(prefix, '" is invalid.'), {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidPrefixError'
        });
    }
}
class InvalidCompressedPrefixError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Prefix must be 2 or 3 for compressed public keys.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidCompressedPrefixError'
        });
    }
}
class InvalidUncompressedPrefixError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Prefix must be 4 for uncompressed public keys.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidUncompressedPrefixError'
        });
    }
}
class InvalidSerializedSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ publicKey }){
        super("Value `".concat(publicKey, "` is an invalid public key size."), {
            metaMessages: [
                'Expected: 33 bytes (compressed + prefix), 64 bytes (uncompressed) or 65 bytes (uncompressed + prefix).',
                "Received ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](publicKey)), " bytes.")
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidSerializedSizeError'
        });
    }
} //# sourceMappingURL=PublicKey.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidAddressError",
    ()=>InvalidAddressError,
    "InvalidChecksumError",
    ()=>InvalidChecksumError,
    "InvalidInputError",
    ()=>InvalidInputError,
    "assert",
    ()=>assert,
    "checksum",
    ()=>checksum,
    "from",
    ()=>from,
    "fromPublicKey",
    ()=>fromPublicKey,
    "isEqual",
    ()=>isEqual,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Caches.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
;
;
;
;
;
const addressRegex = /^0x[a-fA-F0-9]{40}$/;
function assert(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { strict = true } = options;
    if (!addressRegex.test(value)) throw new InvalidAddressError({
        address: value,
        cause: new InvalidInputError()
    });
    if (strict) {
        if (value.toLowerCase() === value) return;
        if (checksum(value) !== value) throw new InvalidAddressError({
            address: value,
            cause: new InvalidChecksumError()
        });
    }
}
function checksum(address) {
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"].has(address)) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"].get(address);
    assert(address, {
        strict: false
    });
    const hexAddress = address.substring(2).toLowerCase();
    const hash = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](hexAddress), {
        as: 'Bytes'
    });
    const characters = hexAddress.split('');
    for(let i = 0; i < 40; i += 2){
        if (hash[i >> 1] >> 4 >= 8 && characters[i]) {
            characters[i] = characters[i].toUpperCase();
        }
        if ((hash[i >> 1] & 0x0f) >= 8 && characters[i + 1]) {
            characters[i + 1] = characters[i + 1].toUpperCase();
        }
    }
    const result = "0x".concat(characters.join(''));
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"].set(address, result);
    return result;
}
function from(address) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { checksum: checksumVal = false } = options;
    assert(address);
    if (checksumVal) return checksum(address);
    return address;
}
function fromPublicKey(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const address = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"]("0x".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toHex"](publicKey).slice(4))).substring(26);
    return from("0x".concat(address), options);
}
function isEqual(addressA, addressB) {
    assert(addressA, {
        strict: false
    });
    assert(addressB, {
        strict: false
    });
    return addressA.toLowerCase() === addressB.toLowerCase();
}
function validate(address) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { strict = true } = options !== null && options !== void 0 ? options : {};
    try {
        assert(address, {
            strict
        });
        return true;
    } catch (e) {
        return false;
    }
}
class InvalidAddressError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ address, cause }){
        super('Address "'.concat(address, '" is invalid.'), {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Address.InvalidAddressError'
        });
    }
}
class InvalidInputError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Address is not a 20 byte (40 hexadecimal character) value.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Address.InvalidInputError'
        });
    }
}
class InvalidChecksumError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Address does not match its checksum counterpart.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Address.InvalidChecksumError'
        });
    }
} //# sourceMappingURL=Address.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/abiItem.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getAmbiguousTypes",
    ()=>getAmbiguousTypes,
    "isArgOfType",
    ()=>isArgOfType,
    "normalizeSignature",
    ()=>normalizeSignature
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
;
;
function normalizeSignature(signature) {
    let active = true;
    let current = '';
    let level = 0;
    let result = '';
    let valid = false;
    for(let i = 0; i < signature.length; i++){
        const char = signature[i];
        // If the character is a separator, we want to reactivate.
        if ([
            '(',
            ')',
            ','
        ].includes(char)) active = true;
        // If the character is a "level" token, we want to increment/decrement.
        if (char === '(') level++;
        if (char === ')') level--;
        // If we aren't active, we don't want to mutate the result.
        if (!active) continue;
        // If level === 0, we are at the definition level.
        if (level === 0) {
            if (char === ' ' && [
                'event',
                'function',
                'error',
                ''
            ].includes(result)) result = '';
            else {
                result += char;
                // If we are at the end of the definition, we must be finished.
                if (char === ')') {
                    valid = true;
                    break;
                }
            }
            continue;
        }
        // Ignore spaces
        if (char === ' ') {
            // If the previous character is a separator, and the current section isn't empty, we want to deactivate.
            if (signature[i - 1] !== ',' && current !== ',' && current !== ',(') {
                current = '';
                active = false;
            }
            continue;
        }
        result += char;
        current += char;
    }
    if (!valid) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Unable to normalize signature.');
    return result;
}
function isArgOfType(arg, abiParameter) {
    const argType = typeof arg;
    const abiParameterType = abiParameter.type;
    switch(abiParameterType){
        case 'address':
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](arg, {
                strict: false
            });
        case 'bool':
            return argType === 'boolean';
        case 'function':
            return argType === 'string';
        case 'string':
            return argType === 'string';
        default:
            {
                if (abiParameterType === 'tuple' && 'components' in abiParameter) return Object.values(abiParameter.components).every((component, index)=>{
                    return isArgOfType(Object.values(arg)[index], component);
                });
                // `(u)int<M>`: (un)signed integer type of `M` bits, `0 < M <= 256`, `M % 8 == 0`
                // https://regexr.com/6v8hp
                if (/^u?int(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/.test(abiParameterType)) return argType === 'number' || argType === 'bigint';
                // `bytes<M>`: binary type of `M` bytes, `0 < M <= 32`
                // https://regexr.com/6va55
                if (/^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/.test(abiParameterType)) return argType === 'string' || arg instanceof Uint8Array;
                // fixed-length (`<type>[M]`) and dynamic (`<type>[]`) arrays
                // https://regexr.com/6va6i
                if (/[a-z]+[1-9]{0,3}(\[[0-9]{0,}\])+$/.test(abiParameterType)) {
                    return Array.isArray(arg) && arg.every((x)=>isArgOfType(x, {
                            ...abiParameter,
                            // Pop off `[]` or `[M]` from end of type
                            type: abiParameterType.replace(/(\[[0-9]{0,}\])$/, '')
                        }));
                }
                return false;
            }
    }
}
function getAmbiguousTypes(sourceParameters, targetParameters, args) {
    for(const parameterIndex in sourceParameters){
        const sourceParameter = sourceParameters[parameterIndex];
        const targetParameter = targetParameters[parameterIndex];
        if (sourceParameter.type === 'tuple' && targetParameter.type === 'tuple' && 'components' in sourceParameter && 'components' in targetParameter) return getAmbiguousTypes(sourceParameter.components, targetParameter.components, args[parameterIndex]);
        const types = [
            sourceParameter.type,
            targetParameter.type
        ];
        const ambiguous = (()=>{
            if (types.includes('address') && types.includes('bytes20')) return true;
            if (types.includes('address') && types.includes('string')) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](args[parameterIndex], {
                strict: false
            });
            if (types.includes('address') && types.includes('bytes')) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](args[parameterIndex], {
                strict: false
            });
            return false;
        })();
        if (ambiguous) return types;
    }
    return;
} //# sourceMappingURL=abiItem.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiItem.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AmbiguityError",
    ()=>AmbiguityError,
    "InvalidSelectorSizeError",
    ()=>InvalidSelectorSizeError,
    "NotFoundError",
    ()=>NotFoundError,
    "format",
    ()=>format,
    "from",
    ()=>from,
    "fromAbi",
    ()=>fromAbi,
    "getSelector",
    ()=>getSelector,
    "getSignature",
    ()=>getSignature,
    "getSignatureHash",
    ()=>getSignatureHash
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.1_typescript@5.9.3_zod@4.1.12/node_modules/abitype/dist/esm/human-readable/formatAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.1_typescript@5.9.3_zod@4.1.12/node_modules/abitype/dist/esm/human-readable/parseAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/abiItem.js [app-client] (ecmascript)");
;
;
;
;
;
function format(abiItem) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiItem);
}
function from(abiItem) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { prepare = true } = options;
    const item = (()=>{
        if (Array.isArray(abiItem)) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiItem"](abiItem);
        if (typeof abiItem === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiItem"](abiItem);
        return abiItem;
    })();
    return {
        ...item,
        ...prepare ? {
            hash: getSignatureHash(item)
        } : {}
    };
}
function fromAbi(abi, name, options) {
    const { args = [], prepare = true } = options !== null && options !== void 0 ? options : {};
    const isSelector = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](name, {
        strict: false
    });
    const abiItems = abi.filter((abiItem)=>{
        if (isSelector) {
            if (abiItem.type === 'function' || abiItem.type === 'error') return getSelector(abiItem) === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](name, 0, 4);
            if (abiItem.type === 'event') return getSignatureHash(abiItem) === name;
            return false;
        }
        return 'name' in abiItem && abiItem.name === name;
    });
    if (abiItems.length === 0) throw new NotFoundError({
        name: name
    });
    if (abiItems.length === 1) return {
        ...abiItems[0],
        ...prepare ? {
            hash: getSignatureHash(abiItems[0])
        } : {}
    };
    let matchedAbiItem;
    for (const abiItem of abiItems){
        if (!('inputs' in abiItem)) continue;
        if (!args || args.length === 0) {
            if (!abiItem.inputs || abiItem.inputs.length === 0) return {
                ...abiItem,
                ...prepare ? {
                    hash: getSignatureHash(abiItem)
                } : {}
            };
            continue;
        }
        if (!abiItem.inputs) continue;
        if (abiItem.inputs.length === 0) continue;
        if (abiItem.inputs.length !== args.length) continue;
        const matched = args.every((arg, index)=>{
            const abiParameter = 'inputs' in abiItem && abiItem.inputs[index];
            if (!abiParameter) return false;
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isArgOfType"](arg, abiParameter);
        });
        if (matched) {
            // Check for ambiguity against already matched parameters (e.g. `address` vs `bytes20`).
            if (matchedAbiItem && 'inputs' in matchedAbiItem && matchedAbiItem.inputs) {
                const ambiguousTypes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAmbiguousTypes"](abiItem.inputs, matchedAbiItem.inputs, args);
                if (ambiguousTypes) throw new AmbiguityError({
                    abiItem,
                    type: ambiguousTypes[0]
                }, {
                    abiItem: matchedAbiItem,
                    type: ambiguousTypes[1]
                });
            }
            matchedAbiItem = abiItem;
        }
    }
    const abiItem = (()=>{
        if (matchedAbiItem) return matchedAbiItem;
        const [abiItem, ...overloads] = abiItems;
        return {
            ...abiItem,
            overloads
        };
    })();
    if (!abiItem) throw new NotFoundError({
        name: name
    });
    return {
        ...abiItem,
        ...prepare ? {
            hash: getSignatureHash(abiItem)
        } : {}
    };
}
function getSelector() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const abiItem = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name] = parameters;
            return fromAbi(abi, name);
        }
        return parameters[0];
    })();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](getSignatureHash(abiItem), 0, 4);
}
function getSignature() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const abiItem = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name] = parameters;
            return fromAbi(abi, name);
        }
        return parameters[0];
    })();
    const signature = (()=>{
        if (typeof abiItem === 'string') return abiItem;
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiItem);
    })();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["normalizeSignature"](signature);
}
function getSignatureHash() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const abiItem = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name] = parameters;
            return fromAbi(abi, name);
        }
        return parameters[0];
    })();
    if (typeof abiItem !== 'string' && 'hash' in abiItem && abiItem.hash) return abiItem.hash;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](getSignature(abiItem)));
}
class AmbiguityError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(x, y){
        super('Found ambiguous types in overloaded ABI Items.', {
            metaMessages: [
                // TODO: abitype to add support for signature-formatted ABI items.
                "`".concat(x.type, "` in `").concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["normalizeSignature"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](x.abiItem)), "`, and"),
                "`".concat(y.type, "` in `").concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["normalizeSignature"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](y.abiItem)), "`"),
                '',
                'These types encode differently and cannot be distinguished at runtime.',
                'Remove one of the ambiguous items in the ABI.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiItem.AmbiguityError'
        });
    }
}
class NotFoundError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ name, data, type = 'item' }){
        const selector = (()=>{
            if (name) return ' with name "'.concat(name, '"');
            if (data) return ' with data "'.concat(data, '"');
            return '';
        })();
        super("ABI ".concat(type).concat(selector, " not found."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiItem.NotFoundError'
        });
    }
}
class InvalidSelectorSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ data }){
        super("Selector size is invalid. Expected 4 bytes. Received ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](data), ' bytes ("').concat(data, '").'));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiItem.InvalidSelectorSizeError'
        });
    }
} //# sourceMappingURL=AbiItem.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "arrayRegex",
    ()=>arrayRegex,
    "bytesRegex",
    ()=>bytesRegex,
    "integerRegex",
    ()=>integerRegex,
    "maxInt104",
    ()=>maxInt104,
    "maxInt112",
    ()=>maxInt112,
    "maxInt120",
    ()=>maxInt120,
    "maxInt128",
    ()=>maxInt128,
    "maxInt136",
    ()=>maxInt136,
    "maxInt144",
    ()=>maxInt144,
    "maxInt152",
    ()=>maxInt152,
    "maxInt16",
    ()=>maxInt16,
    "maxInt160",
    ()=>maxInt160,
    "maxInt168",
    ()=>maxInt168,
    "maxInt176",
    ()=>maxInt176,
    "maxInt184",
    ()=>maxInt184,
    "maxInt192",
    ()=>maxInt192,
    "maxInt200",
    ()=>maxInt200,
    "maxInt208",
    ()=>maxInt208,
    "maxInt216",
    ()=>maxInt216,
    "maxInt224",
    ()=>maxInt224,
    "maxInt232",
    ()=>maxInt232,
    "maxInt24",
    ()=>maxInt24,
    "maxInt240",
    ()=>maxInt240,
    "maxInt248",
    ()=>maxInt248,
    "maxInt256",
    ()=>maxInt256,
    "maxInt32",
    ()=>maxInt32,
    "maxInt40",
    ()=>maxInt40,
    "maxInt48",
    ()=>maxInt48,
    "maxInt56",
    ()=>maxInt56,
    "maxInt64",
    ()=>maxInt64,
    "maxInt72",
    ()=>maxInt72,
    "maxInt8",
    ()=>maxInt8,
    "maxInt80",
    ()=>maxInt80,
    "maxInt88",
    ()=>maxInt88,
    "maxInt96",
    ()=>maxInt96,
    "maxUint104",
    ()=>maxUint104,
    "maxUint112",
    ()=>maxUint112,
    "maxUint120",
    ()=>maxUint120,
    "maxUint128",
    ()=>maxUint128,
    "maxUint136",
    ()=>maxUint136,
    "maxUint144",
    ()=>maxUint144,
    "maxUint152",
    ()=>maxUint152,
    "maxUint16",
    ()=>maxUint16,
    "maxUint160",
    ()=>maxUint160,
    "maxUint168",
    ()=>maxUint168,
    "maxUint176",
    ()=>maxUint176,
    "maxUint184",
    ()=>maxUint184,
    "maxUint192",
    ()=>maxUint192,
    "maxUint200",
    ()=>maxUint200,
    "maxUint208",
    ()=>maxUint208,
    "maxUint216",
    ()=>maxUint216,
    "maxUint224",
    ()=>maxUint224,
    "maxUint232",
    ()=>maxUint232,
    "maxUint24",
    ()=>maxUint24,
    "maxUint240",
    ()=>maxUint240,
    "maxUint248",
    ()=>maxUint248,
    "maxUint256",
    ()=>maxUint256,
    "maxUint32",
    ()=>maxUint32,
    "maxUint40",
    ()=>maxUint40,
    "maxUint48",
    ()=>maxUint48,
    "maxUint56",
    ()=>maxUint56,
    "maxUint64",
    ()=>maxUint64,
    "maxUint72",
    ()=>maxUint72,
    "maxUint8",
    ()=>maxUint8,
    "maxUint80",
    ()=>maxUint80,
    "maxUint88",
    ()=>maxUint88,
    "maxUint96",
    ()=>maxUint96,
    "minInt104",
    ()=>minInt104,
    "minInt112",
    ()=>minInt112,
    "minInt120",
    ()=>minInt120,
    "minInt128",
    ()=>minInt128,
    "minInt136",
    ()=>minInt136,
    "minInt144",
    ()=>minInt144,
    "minInt152",
    ()=>minInt152,
    "minInt16",
    ()=>minInt16,
    "minInt160",
    ()=>minInt160,
    "minInt168",
    ()=>minInt168,
    "minInt176",
    ()=>minInt176,
    "minInt184",
    ()=>minInt184,
    "minInt192",
    ()=>minInt192,
    "minInt200",
    ()=>minInt200,
    "minInt208",
    ()=>minInt208,
    "minInt216",
    ()=>minInt216,
    "minInt224",
    ()=>minInt224,
    "minInt232",
    ()=>minInt232,
    "minInt24",
    ()=>minInt24,
    "minInt240",
    ()=>minInt240,
    "minInt248",
    ()=>minInt248,
    "minInt256",
    ()=>minInt256,
    "minInt32",
    ()=>minInt32,
    "minInt40",
    ()=>minInt40,
    "minInt48",
    ()=>minInt48,
    "minInt56",
    ()=>minInt56,
    "minInt64",
    ()=>minInt64,
    "minInt72",
    ()=>minInt72,
    "minInt8",
    ()=>minInt8,
    "minInt80",
    ()=>minInt80,
    "minInt88",
    ()=>minInt88,
    "minInt96",
    ()=>minInt96
]);
const arrayRegex = /^(.*)\[([0-9]*)\]$/;
const bytesRegex = /^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/;
const integerRegex = /^(u?int)(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/;
const maxInt8 = 2n ** (8n - 1n) - 1n;
const maxInt16 = 2n ** (16n - 1n) - 1n;
const maxInt24 = 2n ** (24n - 1n) - 1n;
const maxInt32 = 2n ** (32n - 1n) - 1n;
const maxInt40 = 2n ** (40n - 1n) - 1n;
const maxInt48 = 2n ** (48n - 1n) - 1n;
const maxInt56 = 2n ** (56n - 1n) - 1n;
const maxInt64 = 2n ** (64n - 1n) - 1n;
const maxInt72 = 2n ** (72n - 1n) - 1n;
const maxInt80 = 2n ** (80n - 1n) - 1n;
const maxInt88 = 2n ** (88n - 1n) - 1n;
const maxInt96 = 2n ** (96n - 1n) - 1n;
const maxInt104 = 2n ** (104n - 1n) - 1n;
const maxInt112 = 2n ** (112n - 1n) - 1n;
const maxInt120 = 2n ** (120n - 1n) - 1n;
const maxInt128 = 2n ** (128n - 1n) - 1n;
const maxInt136 = 2n ** (136n - 1n) - 1n;
const maxInt144 = 2n ** (144n - 1n) - 1n;
const maxInt152 = 2n ** (152n - 1n) - 1n;
const maxInt160 = 2n ** (160n - 1n) - 1n;
const maxInt168 = 2n ** (168n - 1n) - 1n;
const maxInt176 = 2n ** (176n - 1n) - 1n;
const maxInt184 = 2n ** (184n - 1n) - 1n;
const maxInt192 = 2n ** (192n - 1n) - 1n;
const maxInt200 = 2n ** (200n - 1n) - 1n;
const maxInt208 = 2n ** (208n - 1n) - 1n;
const maxInt216 = 2n ** (216n - 1n) - 1n;
const maxInt224 = 2n ** (224n - 1n) - 1n;
const maxInt232 = 2n ** (232n - 1n) - 1n;
const maxInt240 = 2n ** (240n - 1n) - 1n;
const maxInt248 = 2n ** (248n - 1n) - 1n;
const maxInt256 = 2n ** (256n - 1n) - 1n;
const minInt8 = -(2n ** (8n - 1n));
const minInt16 = -(2n ** (16n - 1n));
const minInt24 = -(2n ** (24n - 1n));
const minInt32 = -(2n ** (32n - 1n));
const minInt40 = -(2n ** (40n - 1n));
const minInt48 = -(2n ** (48n - 1n));
const minInt56 = -(2n ** (56n - 1n));
const minInt64 = -(2n ** (64n - 1n));
const minInt72 = -(2n ** (72n - 1n));
const minInt80 = -(2n ** (80n - 1n));
const minInt88 = -(2n ** (88n - 1n));
const minInt96 = -(2n ** (96n - 1n));
const minInt104 = -(2n ** (104n - 1n));
const minInt112 = -(2n ** (112n - 1n));
const minInt120 = -(2n ** (120n - 1n));
const minInt128 = -(2n ** (128n - 1n));
const minInt136 = -(2n ** (136n - 1n));
const minInt144 = -(2n ** (144n - 1n));
const minInt152 = -(2n ** (152n - 1n));
const minInt160 = -(2n ** (160n - 1n));
const minInt168 = -(2n ** (168n - 1n));
const minInt176 = -(2n ** (176n - 1n));
const minInt184 = -(2n ** (184n - 1n));
const minInt192 = -(2n ** (192n - 1n));
const minInt200 = -(2n ** (200n - 1n));
const minInt208 = -(2n ** (208n - 1n));
const minInt216 = -(2n ** (216n - 1n));
const minInt224 = -(2n ** (224n - 1n));
const minInt232 = -(2n ** (232n - 1n));
const minInt240 = -(2n ** (240n - 1n));
const minInt248 = -(2n ** (248n - 1n));
const minInt256 = -(2n ** (256n - 1n));
const maxUint8 = 2n ** 8n - 1n;
const maxUint16 = 2n ** 16n - 1n;
const maxUint24 = 2n ** 24n - 1n;
const maxUint32 = 2n ** 32n - 1n;
const maxUint40 = 2n ** 40n - 1n;
const maxUint48 = 2n ** 48n - 1n;
const maxUint56 = 2n ** 56n - 1n;
const maxUint64 = 2n ** 64n - 1n;
const maxUint72 = 2n ** 72n - 1n;
const maxUint80 = 2n ** 80n - 1n;
const maxUint88 = 2n ** 88n - 1n;
const maxUint96 = 2n ** 96n - 1n;
const maxUint104 = 2n ** 104n - 1n;
const maxUint112 = 2n ** 112n - 1n;
const maxUint120 = 2n ** 120n - 1n;
const maxUint128 = 2n ** 128n - 1n;
const maxUint136 = 2n ** 136n - 1n;
const maxUint144 = 2n ** 144n - 1n;
const maxUint152 = 2n ** 152n - 1n;
const maxUint160 = 2n ** 160n - 1n;
const maxUint168 = 2n ** 168n - 1n;
const maxUint176 = 2n ** 176n - 1n;
const maxUint184 = 2n ** 184n - 1n;
const maxUint192 = 2n ** 192n - 1n;
const maxUint200 = 2n ** 200n - 1n;
const maxUint208 = 2n ** 208n - 1n;
const maxUint216 = 2n ** 216n - 1n;
const maxUint224 = 2n ** 224n - 1n;
const maxUint232 = 2n ** 232n - 1n;
const maxUint240 = 2n ** 240n - 1n;
const maxUint248 = 2n ** 248n - 1n;
const maxUint256 = 2n ** 256n - 1n; //# sourceMappingURL=Solidity.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/abiParameters.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decodeAddress",
    ()=>decodeAddress,
    "decodeArray",
    ()=>decodeArray,
    "decodeBool",
    ()=>decodeBool,
    "decodeBytes",
    ()=>decodeBytes,
    "decodeNumber",
    ()=>decodeNumber,
    "decodeParameter",
    ()=>decodeParameter,
    "decodeString",
    ()=>decodeString,
    "decodeTuple",
    ()=>decodeTuple,
    "encode",
    ()=>encode,
    "encodeAddress",
    ()=>encodeAddress,
    "encodeArray",
    ()=>encodeArray,
    "encodeBoolean",
    ()=>encodeBoolean,
    "encodeBytes",
    ()=>encodeBytes,
    "encodeNumber",
    ()=>encodeNumber,
    "encodeString",
    ()=>encodeString,
    "encodeTuple",
    ()=>encodeTuple,
    "getArrayComponents",
    ()=>getArrayComponents,
    "hasDynamicChild",
    ()=>hasDynamicChild,
    "prepareParameter",
    ()=>prepareParameter,
    "prepareParameters",
    ()=>prepareParameters
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
function decodeParameter(cursor, param, options) {
    const { checksumAddress, staticPosition } = options;
    const arrayComponents = getArrayComponents(param.type);
    if (arrayComponents) {
        const [length, type] = arrayComponents;
        return decodeArray(cursor, {
            ...param,
            type
        }, {
            checksumAddress,
            length,
            staticPosition
        });
    }
    if (param.type === 'tuple') return decodeTuple(cursor, param, {
        checksumAddress,
        staticPosition
    });
    if (param.type === 'address') return decodeAddress(cursor, {
        checksum: checksumAddress
    });
    if (param.type === 'bool') return decodeBool(cursor);
    if (param.type.startsWith('bytes')) return decodeBytes(cursor, param, {
        staticPosition
    });
    if (param.type.startsWith('uint') || param.type.startsWith('int')) return decodeNumber(cursor, param);
    if (param.type === 'string') return decodeString(cursor, {
        staticPosition
    });
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidTypeError"](param.type);
}
const sizeOfLength = 32;
const sizeOfOffset = 32;
function decodeAddress(cursor) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { checksum = false } = options;
    const value = cursor.readBytes(32);
    const wrap = (address)=>checksum ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"](address) : address;
    return [
        wrap(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](value, -20))),
        32
    ];
}
function decodeArray(cursor, param, options) {
    const { checksumAddress, length, staticPosition } = options;
    // If the length of the array is not known in advance (dynamic array),
    // this means we will need to wonder off to the pointer and decode.
    if (!length) {
        // Dealing with a dynamic type, so get the offset of the array data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfOffset));
        // Start is the static position of current slot + offset.
        const start = staticPosition + offset;
        const startOfData = start + sizeOfLength;
        // Get the length of the array from the offset.
        cursor.setPosition(start);
        const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfLength));
        // Check if the array has any dynamic children.
        const dynamicChild = hasDynamicChild(param);
        let consumed = 0;
        const value = [];
        for(let i = 0; i < length; ++i){
            // If any of the children is dynamic, then all elements will be offset pointer, thus size of one slot (32 bytes).
            // Otherwise, elements will be the size of their encoding (consumed bytes).
            cursor.setPosition(startOfData + (dynamicChild ? i * 32 : consumed));
            const [data, consumed_] = decodeParameter(cursor, param, {
                checksumAddress,
                staticPosition: startOfData
            });
            consumed += consumed_;
            value.push(data);
        }
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    // If the length of the array is known in advance,
    // and the length of an element deeply nested in the array is not known,
    // we need to decode the offset of the array data.
    if (hasDynamicChild(param)) {
        // Dealing with dynamic types, so get the offset of the array data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfOffset));
        // Start is the static position of current slot + offset.
        const start = staticPosition + offset;
        const value = [];
        for(let i = 0; i < length; ++i){
            // Move cursor along to the next slot (next offset pointer).
            cursor.setPosition(start + i * 32);
            const [data] = decodeParameter(cursor, param, {
                checksumAddress,
                staticPosition: start
            });
            value.push(data);
        }
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    // If the length of the array is known in advance and the array is deeply static,
    // then we can just decode each element in sequence.
    let consumed = 0;
    const value = [];
    for(let i = 0; i < length; ++i){
        const [data, consumed_] = decodeParameter(cursor, param, {
            checksumAddress,
            staticPosition: staticPosition + consumed
        });
        consumed += consumed_;
        value.push(data);
    }
    return [
        value,
        consumed
    ];
}
function decodeBool(cursor) {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBoolean"](cursor.readBytes(32), {
            size: 32
        }),
        32
    ];
}
function decodeBytes(cursor, param, param1) {
    let { staticPosition } = param1;
    const [_, size] = param.type.split('bytes');
    if (!size) {
        // Dealing with dynamic types, so get the offset of the bytes data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
        // Set position of the cursor to start of bytes data.
        cursor.setPosition(staticPosition + offset);
        const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
        // If there is no length, we have zero data.
        if (length === 0) {
            // As we have gone wondering, restore to the original position + next slot.
            cursor.setPosition(staticPosition + 32);
            return [
                '0x',
                32
            ];
        }
        const data = cursor.readBytes(length);
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](data),
            32
        ];
    }
    const value = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](cursor.readBytes(Number.parseInt(size, 10), 32));
    return [
        value,
        32
    ];
}
function decodeNumber(cursor, param) {
    const signed = param.type.startsWith('int');
    const size = Number.parseInt(param.type.split('int')[1] || '256', 10);
    const value = cursor.readBytes(32);
    return [
        size > 48 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBigInt"](value, {
            signed
        }) : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](value, {
            signed
        }),
        32
    ];
}
function decodeTuple(cursor, param, options) {
    const { checksumAddress, staticPosition } = options;
    // Tuples can have unnamed components (i.e. they are arrays), so we must
    // determine whether the tuple is named or unnamed. In the case of a named
    // tuple, the value will be an object where each property is the name of the
    // component. In the case of an unnamed tuple, the value will be an array.
    const hasUnnamedChild = param.components.length === 0 || param.components.some((param)=>{
        let { name } = param;
        return !name;
    });
    // Initialize the value to an object or an array, depending on whether the
    // tuple is named or unnamed.
    const value = hasUnnamedChild ? [] : {};
    let consumed = 0;
    // If the tuple has a dynamic child, we must first decode the offset to the
    // tuple data.
    if (hasDynamicChild(param)) {
        // Dealing with dynamic types, so get the offset of the tuple data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfOffset));
        // Start is the static position of referencing slot + offset.
        const start = staticPosition + offset;
        for(let i = 0; i < param.components.length; ++i){
            const component = param.components[i];
            cursor.setPosition(start + consumed);
            const [data, consumed_] = decodeParameter(cursor, component, {
                checksumAddress,
                staticPosition: start
            });
            consumed += consumed_;
            value[hasUnnamedChild ? i : component === null || component === void 0 ? void 0 : component.name] = data;
        }
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    // If the tuple has static children, we can just decode each component
    // in sequence.
    for(let i = 0; i < param.components.length; ++i){
        const component = param.components[i];
        const [data, consumed_] = decodeParameter(cursor, component, {
            checksumAddress,
            staticPosition
        });
        value[hasUnnamedChild ? i : component === null || component === void 0 ? void 0 : component.name] = data;
        consumed += consumed_;
    }
    return [
        value,
        consumed
    ];
}
function decodeString(cursor, param) {
    let { staticPosition } = param;
    // Get offset to start of string data.
    const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
    // Start is the static position of current slot + offset.
    const start = staticPosition + offset;
    cursor.setPosition(start);
    const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
    // If there is no length, we have zero data (empty string).
    if (length === 0) {
        cursor.setPosition(staticPosition + 32);
        return [
            '',
            32
        ];
    }
    const data = cursor.readBytes(length, 32);
    const value = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toString"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimLeft"](data));
    // As we have gone wondering, restore to the original position + next slot.
    cursor.setPosition(staticPosition + 32);
    return [
        value,
        32
    ];
}
function prepareParameters(param) {
    let { checksumAddress, parameters, values } = param;
    const preparedParameters = [];
    for(let i = 0; i < parameters.length; i++){
        preparedParameters.push(prepareParameter({
            checksumAddress,
            parameter: parameters[i],
            value: values[i]
        }));
    }
    return preparedParameters;
}
function prepareParameter(param) {
    let { checksumAddress = false, parameter: parameter_, value } = param;
    const parameter = parameter_;
    const arrayComponents = getArrayComponents(parameter.type);
    if (arrayComponents) {
        const [length, type] = arrayComponents;
        return encodeArray(value, {
            checksumAddress,
            length,
            parameter: {
                ...parameter,
                type
            }
        });
    }
    if (parameter.type === 'tuple') {
        return encodeTuple(value, {
            checksumAddress,
            parameter: parameter
        });
    }
    if (parameter.type === 'address') {
        return encodeAddress(value, {
            checksum: checksumAddress
        });
    }
    if (parameter.type === 'bool') {
        return encodeBoolean(value);
    }
    if (parameter.type.startsWith('uint') || parameter.type.startsWith('int')) {
        const signed = parameter.type.startsWith('int');
        var _integerRegex_exec;
        const [, , size = '256'] = (_integerRegex_exec = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integerRegex"].exec(parameter.type)) !== null && _integerRegex_exec !== void 0 ? _integerRegex_exec : [];
        return encodeNumber(value, {
            signed,
            size: Number(size)
        });
    }
    if (parameter.type.startsWith('bytes')) {
        return encodeBytes(value, {
            type: parameter.type
        });
    }
    if (parameter.type === 'string') {
        return encodeString(value);
    }
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidTypeError"](parameter.type);
}
function encode(preparedParameters) {
    // 1. Compute the size of the static part of the parameters.
    let staticSize = 0;
    for(let i = 0; i < preparedParameters.length; i++){
        const { dynamic, encoded } = preparedParameters[i];
        if (dynamic) staticSize += 32;
        else staticSize += __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](encoded);
    }
    // 2. Split the parameters into static and dynamic parts.
    const staticParameters = [];
    const dynamicParameters = [];
    let dynamicSize = 0;
    for(let i = 0; i < preparedParameters.length; i++){
        const { dynamic, encoded } = preparedParameters[i];
        if (dynamic) {
            staticParameters.push(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](staticSize + dynamicSize, {
                size: 32
            }));
            dynamicParameters.push(encoded);
            dynamicSize += __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](encoded);
        } else {
            staticParameters.push(encoded);
        }
    }
    // 3. Concatenate static and dynamic parts.
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...staticParameters, ...dynamicParameters);
}
function encodeAddress(value, options) {
    const { checksum = false } = options;
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"](value, {
        strict: checksum
    });
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](value.toLowerCase())
    };
}
function encodeArray(value, options) {
    const { checksumAddress, length, parameter } = options;
    const dynamic = length === null;
    if (!Array.isArray(value)) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidArrayError"](value);
    if (!dynamic && value.length !== length) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ArrayLengthMismatchError"]({
        expectedLength: length,
        givenLength: value.length,
        type: "".concat(parameter.type, "[").concat(length, "]")
    });
    let dynamicChild = false;
    const preparedParameters = [];
    for(let i = 0; i < value.length; i++){
        const preparedParam = prepareParameter({
            checksumAddress,
            parameter,
            value: value[i]
        });
        if (preparedParam.dynamic) dynamicChild = true;
        preparedParameters.push(preparedParam);
    }
    if (dynamic || dynamicChild) {
        const data = encode(preparedParameters);
        if (dynamic) {
            const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](preparedParameters.length, {
                size: 32
            });
            return {
                dynamic: true,
                encoded: preparedParameters.length > 0 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](length, data) : length
            };
        }
        if (dynamicChild) return {
            dynamic: true,
            encoded: data
        };
    }
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...preparedParameters.map((param)=>{
            let { encoded } = param;
            return encoded;
        }))
    };
}
function encodeBytes(value, param) {
    let { type } = param;
    const [, parametersize] = type.split('bytes');
    const bytesSize = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value);
    if (!parametersize) {
        let value_ = value;
        // If the size is not divisible by 32 bytes, pad the end
        // with empty bytes to the ceiling 32 bytes.
        if (bytesSize % 32 !== 0) value_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value_, Math.ceil((value.length - 2) / 2 / 32) * 32);
        return {
            dynamic: true,
            encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](bytesSize, {
                size: 32
            })), value_)
        };
    }
    if (bytesSize !== Number.parseInt(parametersize, 10)) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BytesSizeMismatchError"]({
        expectedSize: Number.parseInt(parametersize, 10),
        value
    });
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value)
    };
}
function encodeBoolean(value) {
    if (typeof value !== 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Invalid boolean value: "'.concat(value, '" (type: ').concat(typeof value, "). Expected: `true` or `false`."));
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBoolean"](value))
    };
}
function encodeNumber(value, param) {
    let { signed, size } = param;
    if (typeof size === 'number') {
        const max = 2n ** (BigInt(size) - (signed ? 1n : 0n)) - 1n;
        const min = signed ? -max - 1n : 0n;
        if (value > max || value < min) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["IntegerOutOfRangeError"]({
            max: max.toString(),
            min: min.toString(),
            signed,
            size: size / 8,
            value: value.toString()
        });
    }
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](value, {
            size: 32,
            signed
        })
    };
}
function encodeString(value) {
    const hexValue = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](value);
    const partsLength = Math.ceil(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](hexValue) / 32);
    const parts = [];
    for(let i = 0; i < partsLength; i++){
        parts.push(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](hexValue, i * 32, (i + 1) * 32)));
    }
    return {
        dynamic: true,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](hexValue), {
            size: 32
        })), ...parts)
    };
}
function encodeTuple(value, options) {
    const { checksumAddress, parameter } = options;
    let dynamic = false;
    const preparedParameters = [];
    for(let i = 0; i < parameter.components.length; i++){
        const param_ = parameter.components[i];
        const index = Array.isArray(value) ? i : param_.name;
        const preparedParam = prepareParameter({
            checksumAddress,
            parameter: param_,
            value: value[index]
        });
        preparedParameters.push(preparedParam);
        if (preparedParam.dynamic) dynamic = true;
    }
    return {
        dynamic,
        encoded: dynamic ? encode(preparedParameters) : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...preparedParameters.map((param)=>{
            let { encoded } = param;
            return encoded;
        }))
    };
}
function getArrayComponents(type) {
    const matches = type.match(/^(.*)\[(\d+)?\]$/);
    return matches ? [
        matches[2] ? Number(matches[2]) : null,
        matches[1]
    ] : undefined;
}
function hasDynamicChild(param) {
    var _param_components;
    const { type } = param;
    if (type === 'string') return true;
    if (type === 'bytes') return true;
    if (type.endsWith('[]')) return true;
    if (type === 'tuple') return (_param_components = param.components) === null || _param_components === void 0 ? void 0 : _param_components.some(hasDynamicChild);
    const arrayComponents = getArrayComponents(param.type);
    if (arrayComponents && hasDynamicChild({
        ...param,
        type: arrayComponents[1]
    })) return true;
    return false;
} //# sourceMappingURL=abiParameters.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/cursor.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "NegativeOffsetError",
    ()=>NegativeOffsetError,
    "PositionOutOfBoundsError",
    ()=>PositionOutOfBoundsError,
    "RecursiveReadLimitExceededError",
    ()=>RecursiveReadLimitExceededError,
    "create",
    ()=>create
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
;
const staticCursor = {
    bytes: new Uint8Array(),
    dataView: new DataView(new ArrayBuffer(0)),
    position: 0,
    positionReadCount: new Map(),
    recursiveReadCount: 0,
    recursiveReadLimit: Number.POSITIVE_INFINITY,
    assertReadLimit () {
        if (this.recursiveReadCount >= this.recursiveReadLimit) throw new RecursiveReadLimitExceededError({
            count: this.recursiveReadCount + 1,
            limit: this.recursiveReadLimit
        });
    },
    assertPosition (position) {
        if (position < 0 || position > this.bytes.length - 1) throw new PositionOutOfBoundsError({
            length: this.bytes.length,
            position
        });
    },
    decrementPosition (offset) {
        if (offset < 0) throw new NegativeOffsetError({
            offset
        });
        const position = this.position - offset;
        this.assertPosition(position);
        this.position = position;
    },
    getReadCount (position) {
        return this.positionReadCount.get(position || this.position) || 0;
    },
    incrementPosition (offset) {
        if (offset < 0) throw new NegativeOffsetError({
            offset
        });
        const position = this.position + offset;
        this.assertPosition(position);
        this.position = position;
    },
    inspectByte (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position);
        return this.bytes[position];
    },
    inspectBytes (length, position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + length - 1);
        return this.bytes.subarray(position, position + length);
    },
    inspectUint8 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position);
        return this.bytes[position];
    },
    inspectUint16 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 1);
        return this.dataView.getUint16(position);
    },
    inspectUint24 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 2);
        return (this.dataView.getUint16(position) << 8) + this.dataView.getUint8(position + 2);
    },
    inspectUint32 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 3);
        return this.dataView.getUint32(position);
    },
    pushByte (byte) {
        this.assertPosition(this.position);
        this.bytes[this.position] = byte;
        this.position++;
    },
    pushBytes (bytes) {
        this.assertPosition(this.position + bytes.length - 1);
        this.bytes.set(bytes, this.position);
        this.position += bytes.length;
    },
    pushUint8 (value) {
        this.assertPosition(this.position);
        this.bytes[this.position] = value;
        this.position++;
    },
    pushUint16 (value) {
        this.assertPosition(this.position + 1);
        this.dataView.setUint16(this.position, value);
        this.position += 2;
    },
    pushUint24 (value) {
        this.assertPosition(this.position + 2);
        this.dataView.setUint16(this.position, value >> 8);
        this.dataView.setUint8(this.position + 2, value & ~4294967040);
        this.position += 3;
    },
    pushUint32 (value) {
        this.assertPosition(this.position + 3);
        this.dataView.setUint32(this.position, value);
        this.position += 4;
    },
    readByte () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectByte();
        this.position++;
        return value;
    },
    readBytes (length, size) {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectBytes(length);
        this.position += size !== null && size !== void 0 ? size : length;
        return value;
    },
    readUint8 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint8();
        this.position += 1;
        return value;
    },
    readUint16 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint16();
        this.position += 2;
        return value;
    },
    readUint24 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint24();
        this.position += 3;
        return value;
    },
    readUint32 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint32();
        this.position += 4;
        return value;
    },
    get remaining () {
        return this.bytes.length - this.position;
    },
    setPosition (position) {
        const oldPosition = this.position;
        this.assertPosition(position);
        this.position = position;
        return ()=>this.position = oldPosition;
    },
    _touch () {
        if (this.recursiveReadLimit === Number.POSITIVE_INFINITY) return;
        const count = this.getReadCount();
        this.positionReadCount.set(this.position, count + 1);
        if (count > 0) this.recursiveReadCount++;
    }
};
function create(bytes) {
    let { recursiveReadLimit = 8_192 } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const cursor = Object.create(staticCursor);
    cursor.bytes = bytes;
    cursor.dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
    cursor.positionReadCount = new Map();
    cursor.recursiveReadLimit = recursiveReadLimit;
    return cursor;
}
class NegativeOffsetError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ offset }){
        super("Offset `".concat(offset, "` cannot be negative."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Cursor.NegativeOffsetError'
        });
    }
}
class PositionOutOfBoundsError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ length, position }){
        super("Position `".concat(position, "` is out of bounds (`0 < position < ").concat(length, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Cursor.PositionOutOfBoundsError'
        });
    }
}
class RecursiveReadLimitExceededError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ count, limit }){
        super("Recursive read limit of `".concat(limit, "` exceeded (recursive read count: `").concat(count, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Cursor.RecursiveReadLimitExceededError'
        });
    }
} //# sourceMappingURL=cursor.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ArrayLengthMismatchError",
    ()=>ArrayLengthMismatchError,
    "BytesSizeMismatchError",
    ()=>BytesSizeMismatchError,
    "DataSizeTooSmallError",
    ()=>DataSizeTooSmallError,
    "InvalidArrayError",
    ()=>InvalidArrayError,
    "InvalidTypeError",
    ()=>InvalidTypeError,
    "LengthMismatchError",
    ()=>LengthMismatchError,
    "ZeroDataError",
    ()=>ZeroDataError,
    "decode",
    ()=>decode,
    "encode",
    ()=>encode,
    "encodePacked",
    ()=>encodePacked,
    "format",
    ()=>format,
    "from",
    ()=>from
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.1_typescript@5.9.3_zod@4.1.12/node_modules/abitype/dist/esm/human-readable/formatAbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.1_typescript@5.9.3_zod@4.1.12/node_modules/abitype/dist/esm/human-readable/parseAbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/abiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/cursor.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
;
function decode(parameters, data) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    const { as = 'Array', checksumAddress = false } = options;
    const bytes = typeof data === 'string' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](data) : data;
    const cursor = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"](bytes);
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) === 0 && parameters.length > 0) throw new ZeroDataError();
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) < 32) throw new DataSizeTooSmallError({
        data: typeof data === 'string' ? data : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](data),
        parameters: parameters,
        size: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes)
    });
    let consumed = 0;
    const values = as === 'Array' ? [] : {};
    for(let i = 0; i < parameters.length; ++i){
        const param = parameters[i];
        cursor.setPosition(consumed);
        const [data, consumed_] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decodeParameter"](cursor, param, {
            checksumAddress,
            staticPosition: 0
        });
        consumed += consumed_;
        var _param_name;
        if (as === 'Array') values.push(data);
        else values[(_param_name = param.name) !== null && _param_name !== void 0 ? _param_name : i] = data;
    }
    return values;
}
function encode(parameters, values, options) {
    const { checksumAddress = false } = options !== null && options !== void 0 ? options : {};
    if (parameters.length !== values.length) throw new LengthMismatchError({
        expectedLength: parameters.length,
        givenLength: values.length
    });
    // Prepare the parameters to determine dynamic types to encode.
    const preparedParameters = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["prepareParameters"]({
        checksumAddress,
        parameters: parameters,
        values: values
    });
    const data = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](preparedParameters);
    if (data.length === 0) return '0x';
    return data;
}
function encodePacked(types, values) {
    if (types.length !== values.length) throw new LengthMismatchError({
        expectedLength: types.length,
        givenLength: values.length
    });
    const data = [];
    for(let i = 0; i < types.length; i++){
        const type = types[i];
        const value = values[i];
        data.push(encodePacked.encode(type, value));
    }
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...data);
}
(function(encodePacked) {
    // eslint-disable-next-line jsdoc/require-jsdoc
    function encode(type, value) {
        let isArray = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
        if (type === 'address') {
            const address = value;
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"](address);
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](address.toLowerCase(), isArray ? 32 : 0);
        }
        if (type === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](value);
        if (type === 'bytes') return value;
        if (type === 'bool') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBoolean"](value), isArray ? 32 : 1);
        const intMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integerRegex"]);
        if (intMatch) {
            const [_type, baseType, bits = '256'] = intMatch;
            const size = Number.parseInt(bits, 10) / 8;
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](value, {
                size: isArray ? 32 : size,
                signed: baseType === 'int'
            });
        }
        const bytesMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["bytesRegex"]);
        if (bytesMatch) {
            const [_type, size] = bytesMatch;
            if (Number.parseInt(size, 10) !== (value.length - 2) / 2) throw new BytesSizeMismatchError({
                expectedSize: Number.parseInt(size, 10),
                value: value
            });
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value, isArray ? 32 : 0);
        }
        const arrayMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arrayRegex"]);
        if (arrayMatch && Array.isArray(value)) {
            const [_type, childType] = arrayMatch;
            const data = [];
            for(let i = 0; i < value.length; i++){
                data.push(encode(childType, value[i], true));
            }
            if (data.length === 0) return '0x';
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...data);
        }
        throw new InvalidTypeError(type);
    }
    encodePacked.encode = encode;
})(encodePacked || (encodePacked = {}));
function format(parameters) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiParameters"](parameters);
}
function from(parameters) {
    if (Array.isArray(parameters) && typeof parameters[0] === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiParameters"](parameters);
    if (typeof parameters === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiParameters"](parameters);
    return parameters;
}
class DataSizeTooSmallError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ data, parameters, size }){
        super("Data size of ".concat(size, " bytes is too small for given parameters."), {
            metaMessages: [
                "Params: (".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiParameters"](parameters), ")"),
                "Data:   ".concat(data, " (").concat(size, " bytes)")
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.DataSizeTooSmallError'
        });
    }
}
class ZeroDataError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Cannot decode zero data ("0x") with ABI parameters.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.ZeroDataError'
        });
    }
}
class ArrayLengthMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedLength, givenLength, type }){
        super("Array length mismatch for type `".concat(type, "`. Expected: `").concat(expectedLength, "`. Given: `").concat(givenLength, "`."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.ArrayLengthMismatchError'
        });
    }
}
class BytesSizeMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedSize, value }){
        super('Size of bytes "'.concat(value, '" (bytes').concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value), ") does not match expected size (bytes").concat(expectedSize, ")."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.BytesSizeMismatchError'
        });
    }
}
class LengthMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedLength, givenLength }){
        super([
            'ABI encoding parameters/values length mismatch.',
            "Expected length (parameters): ".concat(expectedLength),
            "Given length (values): ".concat(givenLength)
        ].join('\n'));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.LengthMismatchError'
        });
    }
}
class InvalidArrayError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(value){
        super("Value `".concat(value, "` is not a valid array."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.InvalidArrayError'
        });
    }
}
class InvalidTypeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(type){
        super("Type `".concat(type, "` is not a valid ABI Type."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.InvalidTypeError'
        });
    }
} //# sourceMappingURL=AbiParameters.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiFunction.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decodeData",
    ()=>decodeData,
    "decodeResult",
    ()=>decodeResult,
    "encodeData",
    ()=>encodeData,
    "encodeResult",
    ()=>encodeResult,
    "format",
    ()=>format,
    "from",
    ()=>from,
    "fromAbi",
    ()=>fromAbi,
    "getSelector",
    ()=>getSelector
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.1_typescript@5.9.3_zod@4.1.12/node_modules/abitype/dist/esm/human-readable/formatAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
;
;
function decodeData() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiFunction, data] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, data] = parameters;
            return [
                fromAbi(abi, name),
                data
            ];
        }
        return parameters;
    })();
    const { overloads } = abiFunction;
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](data) < 4) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidSelectorSizeError"]({
        data
    });
    if (abiFunction.inputs.length === 0) return undefined;
    const item = overloads ? fromAbi([
        abiFunction,
        ...overloads
    ], data) : abiFunction;
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](data) <= 4) return undefined;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](item.inputs, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](data, 4));
}
function decodeResult() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiFunction, data, options = {}] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, data, options] = parameters;
            return [
                fromAbi(abi, name),
                data,
                options
            ];
        }
        return parameters;
    })();
    const values = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](abiFunction.outputs, data, options);
    if (values && Object.keys(values).length === 0) return undefined;
    if (values && Object.keys(values).length === 1) {
        if (Array.isArray(values)) return values[0];
        return Object.values(values)[0];
    }
    return values;
}
function encodeData() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiFunction, args = []] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, args] = parameters;
            return [
                fromAbi(abi, name, {
                    args
                }),
                args
            ];
        }
        const [abiFunction, args] = parameters;
        return [
            abiFunction,
            args
        ];
    })();
    const { overloads } = abiFunction;
    const item = overloads ? fromAbi([
        abiFunction,
        ...overloads
    ], abiFunction.name, {
        args
    }) : abiFunction;
    const selector = getSelector(item);
    const data = args.length > 0 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](item.inputs, args) : undefined;
    return data ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](selector, data) : selector;
}
function encodeResult() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiFunction, output, options = {}] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, output, options] = parameters;
            return [
                fromAbi(abi, name),
                output,
                options
            ];
        }
        return parameters;
    })();
    const { as = 'Array' } = options;
    const values = (()=>{
        if (abiFunction.outputs.length === 1) return [
            output
        ];
        if (Array.isArray(output)) return output;
        if (as === 'Object') return Object.values(output);
        return [
            output
        ];
    })();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](abiFunction.outputs, values);
}
function format(abiFunction) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiFunction);
}
function from(abiFunction) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](abiFunction, options);
}
function fromAbi(abi, name, options) {
    const item = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromAbi"](abi, name, options);
    if (item.type !== 'function') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NotFoundError"]({
        name,
        type: 'function'
    });
    return item;
}
function getSelector(abiItem) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getSelector"](abiItem);
} //# sourceMappingURL=AbiFunction.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/entropy.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "extraEntropy",
    ()=>extraEntropy,
    "setExtraEntropy",
    ()=>setExtraEntropy
]);
let extraEntropy = false;
function setExtraEntropy(entropy) {
    extraEntropy = entropy;
} //# sourceMappingURL=entropy.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/P256.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createKeyPair",
    ()=>createKeyPair,
    "getPublicKey",
    ()=>getPublicKey,
    "getSharedSecret",
    ()=>getSharedSecret,
    "noble",
    ()=>noble,
    "randomPrivateKey",
    ()=>randomPrivateKey,
    "recoverPublicKey",
    ()=>recoverPublicKey,
    "sign",
    ()=>sign,
    "verify",
    ()=>verify
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/p256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$entropy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/entropy.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
;
;
;
;
;
const noble = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"];
function createKeyPair() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { as = 'Hex' } = options;
    const privateKey = randomPrivateKey({
        as
    });
    const publicKey = getPublicKey({
        privateKey
    });
    return {
        privateKey: privateKey,
        publicKey
    };
}
function getPublicKey(options) {
    const { privateKey } = options;
    const point = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].ProjectivePoint.fromPrivateKey(typeof privateKey === 'string' ? privateKey.slice(2) : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](privateKey).slice(2));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](point);
}
function getSharedSecret(options) {
    const { as = 'Hex', privateKey, publicKey } = options;
    const point = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].ProjectivePoint.fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toHex"](publicKey).slice(2));
    const privateKeyHex = typeof privateKey === 'string' ? privateKey.slice(2) : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](privateKey).slice(2);
    const sharedPoint = point.multiply(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].utils.normPrivateKeyToScalar(privateKeyHex));
    const sharedSecret = sharedPoint.toRawBytes(true); // compressed format
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](sharedSecret);
    return sharedSecret;
}
function randomPrivateKey() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { as = 'Hex' } = options;
    const bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].utils.randomPrivateKey();
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
    return bytes;
}
function recoverPublicKey(options) {
    const { payload, signature } = options;
    const { r, s, yParity } = signature;
    const signature_ = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].Signature(BigInt(r), BigInt(s)).addRecoveryBit(yParity);
    const payload_ = payload instanceof Uint8Array ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](payload) : payload;
    const point = signature_.recoverPublicKey(payload_.substring(2));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](point);
}
function sign(options) {
    const { extraEntropy = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$entropy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extraEntropy"], hash, payload, privateKey } = options;
    const { r, s, recovery } = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].sign(payload instanceof Uint8Array ? payload : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](payload), privateKey instanceof Uint8Array ? privateKey : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](privateKey), {
        extraEntropy: typeof extraEntropy === 'boolean' ? extraEntropy : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](extraEntropy).slice(2),
        lowS: true,
        ...hash ? {
            prehash: true
        } : {}
    });
    return {
        r,
        s,
        yParity: recovery
    };
}
function verify(options) {
    const { hash, payload, publicKey, signature } = options;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256r1"].verify(signature, payload instanceof Uint8Array ? payload : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](payload), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toHex"](publicKey).substring(2), ...hash ? [
        {
            prehash: true,
            lowS: true
        }
    ] : []);
} //# sourceMappingURL=P256.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Secp256k1.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createKeyPair",
    ()=>createKeyPair,
    "getPublicKey",
    ()=>getPublicKey,
    "getSharedSecret",
    ()=>getSharedSecret,
    "noble",
    ()=>noble,
    "randomPrivateKey",
    ()=>randomPrivateKey,
    "recoverAddress",
    ()=>recoverAddress,
    "recoverPublicKey",
    ()=>recoverPublicKey,
    "sign",
    ()=>sign,
    "verify",
    ()=>verify
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/secp256k1.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$entropy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/entropy.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
;
;
;
;
;
;
const noble = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"];
function createKeyPair() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { as = 'Hex' } = options;
    const privateKey = randomPrivateKey({
        as
    });
    const publicKey = getPublicKey({
        privateKey
    });
    return {
        privateKey: privateKey,
        publicKey
    };
}
function getPublicKey(options) {
    const { privateKey } = options;
    const point = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].ProjectivePoint.fromPrivateKey(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](privateKey).slice(2));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](point);
}
function getSharedSecret(options) {
    const { as = 'Hex', privateKey, publicKey } = options;
    const point = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].ProjectivePoint.fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toHex"](publicKey).slice(2));
    const sharedPoint = point.multiply(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].utils.normPrivateKeyToScalar(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](privateKey).slice(2)));
    const sharedSecret = sharedPoint.toRawBytes(true); // compressed format
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](sharedSecret);
    return sharedSecret;
}
function randomPrivateKey() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { as = 'Hex' } = options;
    const bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].utils.randomPrivateKey();
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
    return bytes;
}
function recoverAddress(options) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromPublicKey"](recoverPublicKey(options));
}
function recoverPublicKey(options) {
    const { payload, signature } = options;
    const { r, s, yParity } = signature;
    const signature_ = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature(BigInt(r), BigInt(s)).addRecoveryBit(yParity);
    const point = signature_.recoverPublicKey(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload).substring(2));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](point);
}
function sign(options) {
    const { extraEntropy = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$entropy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extraEntropy"], hash, payload, privateKey } = options;
    const { r, s, recovery } = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].sign(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](privateKey), {
        extraEntropy: typeof extraEntropy === 'boolean' ? extraEntropy : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](extraEntropy).slice(2),
        lowS: true,
        ...hash ? {
            prehash: true
        } : {}
    });
    return {
        r,
        s,
        yParity: recovery
    };
}
function verify(options) {
    const { address, hash, payload, publicKey, signature } = options;
    if (address) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isEqual"](address, recoverAddress({
        payload,
        signature
    }));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].verify(signature, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](publicKey), ...hash ? [
        {
            prehash: true,
            lowS: true
        }
    ] : []);
} //# sourceMappingURL=Secp256k1.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Signature.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidRError",
    ()=>InvalidRError,
    "InvalidSError",
    ()=>InvalidSError,
    "InvalidSerializedSizeError",
    ()=>InvalidSerializedSizeError,
    "InvalidVError",
    ()=>InvalidVError,
    "InvalidYParityError",
    ()=>InvalidYParityError,
    "MissingPropertiesError",
    ()=>MissingPropertiesError,
    "assert",
    ()=>assert,
    "extract",
    ()=>extract,
    "from",
    ()=>from,
    "fromBytes",
    ()=>fromBytes,
    "fromDerBytes",
    ()=>fromDerBytes,
    "fromDerHex",
    ()=>fromDerHex,
    "fromHex",
    ()=>fromHex,
    "fromLegacy",
    ()=>fromLegacy,
    "fromRpc",
    ()=>fromRpc,
    "fromTuple",
    ()=>fromTuple,
    "toBytes",
    ()=>toBytes,
    "toDerBytes",
    ()=>toDerBytes,
    "toDerHex",
    ()=>toDerHex,
    "toHex",
    ()=>toHex,
    "toLegacy",
    ()=>toLegacy,
    "toRpc",
    ()=>toRpc,
    "toTuple",
    ()=>toTuple,
    "vToYParity",
    ()=>vToYParity,
    "validate",
    ()=>validate,
    "yParityToV",
    ()=>yParityToV
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/secp256k1.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
function assert(signature) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { recovered } = options;
    if (typeof signature.r === 'undefined') throw new MissingPropertiesError({
        signature
    });
    if (typeof signature.s === 'undefined') throw new MissingPropertiesError({
        signature
    });
    if (recovered && typeof signature.yParity === 'undefined') throw new MissingPropertiesError({
        signature
    });
    if (signature.r < 0n || signature.r > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["maxUint256"]) throw new InvalidRError({
        value: signature.r
    });
    if (signature.s < 0n || signature.s > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["maxUint256"]) throw new InvalidSError({
        value: signature.s
    });
    if (typeof signature.yParity === 'number' && signature.yParity !== 0 && signature.yParity !== 1) throw new InvalidYParityError({
        value: signature.yParity
    });
}
function fromBytes(signature) {
    return fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](signature));
}
function fromHex(signature) {
    if (signature.length !== 130 && signature.length !== 132) throw new InvalidSerializedSizeError({
        signature
    });
    const r = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](signature, 0, 32));
    const s = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](signature, 32, 64));
    const yParity = (()=>{
        const yParity = Number("0x".concat(signature.slice(130)));
        if (Number.isNaN(yParity)) return undefined;
        try {
            return vToYParity(yParity);
        } catch (e) {
            throw new InvalidYParityError({
                value: yParity
            });
        }
    })();
    if (typeof yParity === 'undefined') return {
        r,
        s
    };
    return {
        r,
        s,
        yParity
    };
}
function extract(value) {
    if (typeof value.r === 'undefined') return undefined;
    if (typeof value.s === 'undefined') return undefined;
    return from(value);
}
function from(signature) {
    const signature_ = (()=>{
        if (typeof signature === 'string') return fromHex(signature);
        if (signature instanceof Uint8Array) return fromBytes(signature);
        if (typeof signature.r === 'string') return fromRpc(signature);
        if (signature.v) return fromLegacy(signature);
        return {
            r: signature.r,
            s: signature.s,
            ...typeof signature.yParity !== 'undefined' ? {
                yParity: signature.yParity
            } : {}
        };
    })();
    assert(signature_);
    return signature_;
}
function fromDerBytes(signature) {
    return fromDerHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](signature));
}
function fromDerHex(signature) {
    const { r, s } = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature.fromDER(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](signature).slice(2));
    return {
        r,
        s
    };
}
function fromLegacy(signature) {
    return {
        r: signature.r,
        s: signature.s,
        yParity: vToYParity(signature.v)
    };
}
function fromRpc(signature) {
    const yParity = (()=>{
        const v = signature.v ? Number(signature.v) : undefined;
        let yParity = signature.yParity ? Number(signature.yParity) : undefined;
        if (typeof v === 'number' && typeof yParity !== 'number') yParity = vToYParity(v);
        if (typeof yParity !== 'number') throw new InvalidYParityError({
            value: signature.yParity
        });
        return yParity;
    })();
    return {
        r: BigInt(signature.r),
        s: BigInt(signature.s),
        yParity
    };
}
function fromTuple(tuple) {
    const [yParity, r, s] = tuple;
    return from({
        r: r === '0x' ? 0n : BigInt(r),
        s: s === '0x' ? 0n : BigInt(s),
        yParity: yParity === '0x' ? 0 : Number(yParity)
    });
}
function toBytes(signature) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](toHex(signature));
}
function toHex(signature) {
    assert(signature);
    const r = signature.r;
    const s = signature.s;
    const signature_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](r, {
        size: 32
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](s, {
        size: 32
    }), // If the signature is recovered, add the recovery byte to the signature.
    typeof signature.yParity === 'number' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](yParityToV(signature.yParity), {
        size: 1
    }) : '0x');
    return signature_;
}
function toDerBytes(signature) {
    const sig = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature(signature.r, signature.s);
    return sig.toDERRawBytes();
}
function toDerHex(signature) {
    const sig = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature(signature.r, signature.s);
    return "0x".concat(sig.toDERHex());
}
function toLegacy(signature) {
    return {
        r: signature.r,
        s: signature.s,
        v: yParityToV(signature.yParity)
    };
}
function toRpc(signature) {
    const { r, s, yParity } = signature;
    return {
        r: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](r, {
            size: 32
        }),
        s: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](s, {
            size: 32
        }),
        yParity: yParity === 0 ? '0x0' : '0x1'
    };
}
function toTuple(signature) {
    const { r, s, yParity } = signature;
    return [
        yParity ? '0x01' : '0x',
        r === 0n ? '0x' : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](r)),
        s === 0n ? '0x' : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](s))
    ];
}
function validate(signature) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    try {
        assert(signature, options);
        return true;
    } catch (e) {
        return false;
    }
}
function vToYParity(v) {
    if (v === 0 || v === 27) return 0;
    if (v === 1 || v === 28) return 1;
    if (v >= 35) return v % 2 === 0 ? 1 : 0;
    throw new InvalidVError({
        value: v
    });
}
function yParityToV(yParity) {
    if (yParity === 0) return 27;
    if (yParity === 1) return 28;
    throw new InvalidYParityError({
        value: yParity
    });
}
class InvalidSerializedSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ signature }){
        super("Value `".concat(signature, "` is an invalid signature size."), {
            metaMessages: [
                'Expected: 64 bytes or 65 bytes.',
                "Received ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](signature)), " bytes.")
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidSerializedSizeError'
        });
    }
}
class MissingPropertiesError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ signature }){
        super("Signature `".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](signature), "` is missing either an `r`, `s`, or `yParity` property."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.MissingPropertiesError'
        });
    }
}
class InvalidRError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid r value. r must be a positive integer less than 2^256."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidRError'
        });
    }
}
class InvalidSError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid s value. s must be a positive integer less than 2^256."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidSError'
        });
    }
}
class InvalidYParityError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid y-parity value. Y-parity must be 0 or 1."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidYParityError'
        });
    }
}
class InvalidVError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid v value. v must be 27, 28 or >=35."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidVError'
        });
    }
} //# sourceMappingURL=Signature.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/TypedData.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "BytesSizeMismatchError",
    ()=>BytesSizeMismatchError,
    "InvalidDomainError",
    ()=>InvalidDomainError,
    "InvalidPrimaryTypeError",
    ()=>InvalidPrimaryTypeError,
    "InvalidStructTypeError",
    ()=>InvalidStructTypeError,
    "assert",
    ()=>assert,
    "domainSeparator",
    ()=>domainSeparator,
    "encode",
    ()=>encode,
    "encodeData",
    ()=>encodeData,
    "encodeField",
    ()=>encodeField,
    "encodeType",
    ()=>encodeType,
    "extractEip712DomainTypes",
    ()=>extractEip712DomainTypes,
    "findTypeDependencies",
    ()=>findTypeDependencies,
    "getSignPayload",
    ()=>getSignPayload,
    "hashDomain",
    ()=>hashDomain,
    "hashStruct",
    ()=>hashStruct,
    "hashType",
    ()=>hashType,
    "serialize",
    ()=>serialize,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
;
function assert(value) {
    const { domain, message, primaryType, types } = value;
    const validateData = (struct, data)=>{
        for (const param of struct){
            const { name, type } = param;
            const value = data[name];
            const integerMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integerRegex"]);
            if (integerMatch && (typeof value === 'number' || typeof value === 'bigint')) {
                const [, base, size_] = integerMatch;
                // If number cannot be cast to a sized hex value, it is out of range
                // and will throw.
                __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](value, {
                    signed: base === 'int',
                    size: Number.parseInt(size_ !== null && size_ !== void 0 ? size_ : '', 10) / 8
                });
            }
            if (type === 'address' && typeof value === 'string' && !__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value)) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidAddressError"]({
                address: value,
                cause: new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidInputError"]()
            });
            const bytesMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["bytesRegex"]);
            if (bytesMatch) {
                const [, size] = bytesMatch;
                if (size && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) !== Number.parseInt(size, 10)) throw new BytesSizeMismatchError({
                    expectedSize: Number.parseInt(size, 10),
                    givenSize: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value)
                });
            }
            const struct = types[type];
            if (struct) {
                validateReference(type);
                validateData(struct, value);
            }
        }
    };
    // Validate domain types.
    if (types.EIP712Domain && domain) {
        if (typeof domain !== 'object') throw new InvalidDomainError({
            domain
        });
        validateData(types.EIP712Domain, domain);
    }
    // Validate message types.
    if (primaryType !== 'EIP712Domain') {
        if (types[primaryType]) validateData(types[primaryType], message);
        else throw new InvalidPrimaryTypeError({
            primaryType,
            types
        });
    }
}
function domainSeparator(domain) {
    return hashDomain({
        domain
    });
}
function encode(value) {
    const { domain = {}, message, primaryType } = value;
    const types = {
        EIP712Domain: extractEip712DomainTypes(domain),
        ...value.types
    };
    // Need to do a runtime validation check on addresses, byte ranges, integer ranges, etc
    // as we can't statically check this with TypeScript.
    assert({
        domain,
        message,
        primaryType,
        types
    });
    // Typed Data Format: `0x19 ‖ 0x01 ‖ domainSeparator ‖ hashStruct(message)`
    const parts = [
        '0x19',
        '0x01'
    ];
    if (domain) parts.push(hashDomain({
        domain,
        types
    }));
    if (primaryType !== 'EIP712Domain') parts.push(hashStruct({
        data: message,
        primaryType,
        types
    }));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...parts);
}
function encodeType(value) {
    const { primaryType, types } = value;
    let result = '';
    const unsortedDeps = findTypeDependencies({
        primaryType,
        types
    });
    unsortedDeps.delete(primaryType);
    const deps = [
        primaryType,
        ...Array.from(unsortedDeps).sort()
    ];
    for (const type of deps){
        var _types_type;
        result += "".concat(type, "(").concat(((_types_type = types[type]) !== null && _types_type !== void 0 ? _types_type : []).map((param)=>{
            let { name, type: t } = param;
            return "".concat(t, " ").concat(name);
        }).join(','), ")");
    }
    return result;
}
function extractEip712DomainTypes(domain) {
    return [
        typeof (domain === null || domain === void 0 ? void 0 : domain.name) === 'string' && {
            name: 'name',
            type: 'string'
        },
        (domain === null || domain === void 0 ? void 0 : domain.version) && {
            name: 'version',
            type: 'string'
        },
        (typeof (domain === null || domain === void 0 ? void 0 : domain.chainId) === 'number' || typeof (domain === null || domain === void 0 ? void 0 : domain.chainId) === 'bigint') && {
            name: 'chainId',
            type: 'uint256'
        },
        (domain === null || domain === void 0 ? void 0 : domain.verifyingContract) && {
            name: 'verifyingContract',
            type: 'address'
        },
        (domain === null || domain === void 0 ? void 0 : domain.salt) && {
            name: 'salt',
            type: 'bytes32'
        }
    ].filter(Boolean);
}
function getSignPayload(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](encode(value));
}
function hashDomain(value) {
    const { domain, types } = value;
    return hashStruct({
        data: domain,
        primaryType: 'EIP712Domain',
        types: {
            ...types,
            EIP712Domain: (types === null || types === void 0 ? void 0 : types.EIP712Domain) || extractEip712DomainTypes(domain)
        }
    });
}
function hashStruct(value) {
    const { data, primaryType, types } = value;
    const encoded = encodeData({
        data,
        primaryType,
        types
    });
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](encoded);
}
function serialize(value) {
    const { domain: domain_, message: message_, primaryType, types } = value;
    const normalizeData = (struct, value)=>{
        const data = {
            ...value
        };
        for (const param of struct){
            const { name, type } = param;
            if (type === 'address') data[name] = data[name].toLowerCase();
        }
        return data;
    };
    const domain = (()=>{
        if (!domain_) return {};
        var _types_EIP712Domain;
        const type = (_types_EIP712Domain = types.EIP712Domain) !== null && _types_EIP712Domain !== void 0 ? _types_EIP712Domain : extractEip712DomainTypes(domain_);
        return normalizeData(type, domain_);
    })();
    const message = (()=>{
        if (primaryType === 'EIP712Domain') return undefined;
        if (!types[primaryType]) return {};
        return normalizeData(types[primaryType], message_);
    })();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"]({
        domain,
        message,
        primaryType,
        types
    }, (_, value)=>{
        if (typeof value === 'bigint') return value.toString();
        return value;
    });
}
function validate(value) {
    try {
        assert(value);
        return true;
    } catch (e) {
        return false;
    }
}
class BytesSizeMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedSize, givenSize }){
        super("Expected bytes".concat(expectedSize, ", got bytes").concat(givenSize, "."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'TypedData.BytesSizeMismatchError'
        });
    }
}
class InvalidDomainError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ domain }){
        super('Invalid domain "'.concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](domain), '".'), {
            metaMessages: [
                'Must be a valid EIP-712 domain.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'TypedData.InvalidDomainError'
        });
    }
}
class InvalidPrimaryTypeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ primaryType, types }){
        super("Invalid primary type `".concat(primaryType, "` must be one of `").concat(JSON.stringify(Object.keys(types)), "`."), {
            metaMessages: [
                'Check that the primary type is a key in `types`.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'TypedData.InvalidPrimaryTypeError'
        });
    }
}
class InvalidStructTypeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ type }){
        super('Struct type "'.concat(type, '" is invalid.'), {
            metaMessages: [
                'Struct type must not be a Solidity type.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'TypedData.InvalidStructTypeError'
        });
    }
}
function encodeData(value) {
    const { data, primaryType, types } = value;
    const encodedTypes = [
        {
            type: 'bytes32'
        }
    ];
    const encodedValues = [
        hashType({
            primaryType,
            types
        })
    ];
    var _types_primaryType;
    for (const field of (_types_primaryType = types[primaryType]) !== null && _types_primaryType !== void 0 ? _types_primaryType : []){
        const [type, value] = encodeField({
            types,
            name: field.name,
            type: field.type,
            value: data[field.name]
        });
        encodedTypes.push(type);
        encodedValues.push(value);
    }
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](encodedTypes, encodedValues);
}
function hashType(value) {
    const { primaryType, types } = value;
    const encodedHashType = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](encodeType({
        primaryType,
        types
    }));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](encodedHashType);
}
function encodeField(properties) {
    let { types, name, type, value } = properties;
    if (types[type] !== undefined) return [
        {
            type: 'bytes32'
        },
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](encodeData({
            data: value,
            primaryType: type,
            types
        }))
    ];
    if (type === 'bytes') {
        const prepend = value.length % 2 ? '0' : '';
        value = "0x".concat(prepend + value.slice(2));
        return [
            {
                type: 'bytes32'
            },
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](value, {
                as: 'Hex'
            })
        ];
    }
    if (type === 'string') return [
        {
            type: 'bytes32'
        },
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](value), {
            as: 'Hex'
        })
    ];
    if (type.lastIndexOf(']') === type.length - 1) {
        const parsedType = type.slice(0, type.lastIndexOf('['));
        const typeValuePairs = value.map((item)=>encodeField({
                name,
                type: parsedType,
                types,
                value: item
            }));
        return [
            {
                type: 'bytes32'
            },
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](typeValuePairs.map((param)=>{
                let [t] = param;
                return t;
            }), typeValuePairs.map((param)=>{
                let [, v] = param;
                return v;
            })))
        ];
    }
    return [
        {
            type
        },
        value
    ];
}
function findTypeDependencies(value) {
    let results = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : new Set();
    const { primaryType: primaryType_, types } = value;
    const match = primaryType_.match(/^\w*/u);
    const primaryType = match === null || match === void 0 ? void 0 : match[0];
    if (results.has(primaryType) || types[primaryType] === undefined) return results;
    results.add(primaryType);
    for (const field of types[primaryType])findTypeDependencies({
        primaryType: field.type,
        types
    }, results);
    return results;
}
/** @internal */ function validateReference(type) {
    // Struct type must not be a Solidity type.
    if (type === 'address' || type === 'bool' || type === 'string' || type.startsWith('bytes') || type.startsWith('uint') || type.startsWith('int')) throw new InvalidStructTypeError({
        type
    });
} //# sourceMappingURL=TypedData.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Value.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidDecimalNumberError",
    ()=>InvalidDecimalNumberError,
    "exponents",
    ()=>exponents,
    "format",
    ()=>format,
    "formatEther",
    ()=>formatEther,
    "formatGwei",
    ()=>formatGwei,
    "from",
    ()=>from,
    "fromEther",
    ()=>fromEther,
    "fromGwei",
    ()=>fromGwei
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
;
const exponents = {
    wei: 0,
    gwei: 9,
    szabo: 12,
    finney: 15,
    ether: 18
};
function format(value) {
    let decimals = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0;
    let display = value.toString();
    const negative = display.startsWith('-');
    if (negative) display = display.slice(1);
    display = display.padStart(decimals, '0');
    let [integer, fraction] = [
        display.slice(0, display.length - decimals),
        display.slice(display.length - decimals)
    ];
    fraction = fraction.replace(/(0+)$/, '');
    return "".concat(negative ? '-' : '').concat(integer || '0').concat(fraction ? ".".concat(fraction) : '');
}
function formatEther(wei) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return format(wei, exponents.ether - exponents[unit]);
}
function formatGwei(wei) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return format(wei, exponents.gwei - exponents[unit]);
}
function from(value) {
    let decimals = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0;
    if (!/^(-?)([0-9]*)\.?([0-9]*)$/.test(value)) throw new InvalidDecimalNumberError({
        value
    });
    let [integer = '', fraction = '0'] = value.split('.');
    const negative = integer.startsWith('-');
    if (negative) integer = integer.slice(1);
    // trim trailing zeros.
    fraction = fraction.replace(/(0+)$/, '');
    // round off if the fraction is larger than the number of decimals.
    if (decimals === 0) {
        if (Math.round(Number(".".concat(fraction))) === 1) integer = "".concat(BigInt(integer) + 1n);
        fraction = '';
    } else if (fraction.length > decimals) {
        const [left, unit, right] = [
            fraction.slice(0, decimals - 1),
            fraction.slice(decimals - 1, decimals),
            fraction.slice(decimals)
        ];
        const rounded = Math.round(Number("".concat(unit, ".").concat(right)));
        if (rounded > 9) fraction = "".concat(BigInt(left) + BigInt(1), "0").padStart(left.length + 1, '0');
        else fraction = "".concat(left).concat(rounded);
        if (fraction.length > decimals) {
            fraction = fraction.slice(1);
            integer = "".concat(BigInt(integer) + 1n);
        }
        fraction = fraction.slice(0, decimals);
    } else {
        fraction = fraction.padEnd(decimals, '0');
    }
    return BigInt("".concat(negative ? '-' : '').concat(integer).concat(fraction));
}
function fromEther(ether) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return from(ether, exponents.ether - exponents[unit]);
}
function fromGwei(gwei) {
    let unit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'wei';
    return from(gwei, exponents.gwei - exponents[unit]);
}
class InvalidDecimalNumberError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is not a valid decimal number."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Value.InvalidDecimalNumberError'
        });
    }
} //# sourceMappingURL=Value.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Base64.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "fromBytes",
    ()=>fromBytes,
    "fromHex",
    ()=>fromHex,
    "fromString",
    ()=>fromString,
    "toBytes",
    ()=>toBytes,
    "toHex",
    ()=>toHex,
    "toString",
    ()=>toString
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
const encoder = /*#__PURE__*/ new TextEncoder();
const decoder = /*#__PURE__*/ new TextDecoder();
const integerToCharacter = /*#__PURE__*/ Object.fromEntries(Array.from('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/').map((a, i)=>[
        i,
        a.charCodeAt(0)
    ]));
const characterToInteger = /*#__PURE__*/ {
    ...Object.fromEntries(Array.from('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/').map((a, i)=>[
            a.charCodeAt(0),
            i
        ])),
    ['='.charCodeAt(0)]: 0,
    ['-'.charCodeAt(0)]: 62,
    ['_'.charCodeAt(0)]: 63
};
function fromBytes(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { pad = true, url = false } = options;
    const encoded = new Uint8Array(Math.ceil(value.length / 3) * 4);
    for(let i = 0, j = 0; j < value.length; i += 4, j += 3){
        const y = (value[j] << 16) + (value[j + 1] << 8) + (value[j + 2] | 0);
        encoded[i] = integerToCharacter[y >> 18];
        encoded[i + 1] = integerToCharacter[y >> 12 & 0x3f];
        encoded[i + 2] = integerToCharacter[y >> 6 & 0x3f];
        encoded[i + 3] = integerToCharacter[y & 0x3f];
    }
    const k = value.length % 3;
    const end = Math.floor(value.length / 3) * 4 + (k && k + 1);
    let base64 = decoder.decode(new Uint8Array(encoded.buffer, 0, end));
    if (pad && k === 1) base64 += '==';
    if (pad && k === 2) base64 += '=';
    if (url) base64 = base64.replaceAll('+', '-').replaceAll('/', '_');
    return base64;
}
function fromHex(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return fromBytes(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](value), options);
}
function fromString(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return fromBytes(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](value), options);
}
function toBytes(value) {
    const base64 = value.replace(/=+$/, '');
    const size = base64.length;
    const decoded = new Uint8Array(size + 3);
    encoder.encodeInto(base64 + '===', decoded);
    for(let i = 0, j = 0; i < base64.length; i += 4, j += 3){
        const x = (characterToInteger[decoded[i]] << 18) + (characterToInteger[decoded[i + 1]] << 12) + (characterToInteger[decoded[i + 2]] << 6) + characterToInteger[decoded[i + 3]];
        decoded[j] = x >> 16;
        decoded[j + 1] = x >> 8 & 0xff;
        decoded[j + 2] = x & 0xff;
    }
    const decodedSize = (size >> 2) * 3 + (size % 4 && size % 4 - 1);
    return new Uint8Array(decoded.buffer, 0, decodedSize);
}
function toHex(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](toBytes(value));
}
function toString(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toString"](toBytes(value));
} //# sourceMappingURL=Base64.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/webauthn.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "parseAsn1Signature",
    ()=>parseAsn1Signature,
    "parseCredentialPublicKey",
    ()=>parseCredentialPublicKey
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/p256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$WebAuthnP256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/WebAuthnP256.js [app-client] (ecmascript)");
;
;
;
;
function parseAsn1Signature(bytes) {
    const r_start = bytes[4] === 0 ? 5 : 4;
    const r_end = r_start + 32;
    const s_start = bytes[r_end + 2] === 0 ? r_end + 3 : r_end + 2;
    const r = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes.slice(r_start, r_end)));
    const s = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes.slice(s_start)));
    return {
        r,
        s: s > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["p256"].CURVE.n / 2n ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["p256"].CURVE.n - s : s
    };
}
async function parseCredentialPublicKey(response) {
    try {
        const publicKeyBuffer = response.getPublicKey();
        if (!publicKeyBuffer) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$WebAuthnP256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CredentialCreationFailedError"]();
        // Converting `publicKeyBuffer` throws when credential is created by 1Password Firefox Add-on
        const publicKeyBytes = new Uint8Array(publicKeyBuffer);
        const cryptoKey = await crypto.subtle.importKey('spki', new Uint8Array(publicKeyBytes), {
            name: 'ECDSA',
            namedCurve: 'P-256',
            hash: 'SHA-256'
        }, true, [
            'verify'
        ]);
        const publicKey = new Uint8Array(await crypto.subtle.exportKey('raw', cryptoKey));
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](publicKey);
    } catch (error) {
        // Fallback for 1Password Firefox Add-on restricts access to certain credential properties
        // so we need to use `attestationObject` to extract the public key.
        // https://github.com/passwordless-id/webauthn/issues/50#issuecomment-2072902094
        if (error.message !== 'Permission denied to access object') throw error;
        const data = new Uint8Array(response.attestationObject);
        const coordinateLength = 0x20;
        const cborPrefix = 0x58;
        const findStart = (key)=>{
            const coordinate = new Uint8Array([
                key,
                cborPrefix,
                coordinateLength
            ]);
            for(let i = 0; i < data.length - coordinate.length; i++)if (coordinate.every((byte, j)=>data[i + j] === byte)) return i + coordinate.length;
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$WebAuthnP256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CredentialCreationFailedError"]();
        };
        const xStart = findStart(0x21);
        const yStart = findStart(0x22);
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](new Uint8Array([
            0x04,
            ...data.slice(xStart, xStart + coordinateLength),
            ...data.slice(yStart, yStart + coordinateLength)
        ]));
    }
} //# sourceMappingURL=webauthn.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/WebAuthnP256.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "CredentialCreationFailedError",
    ()=>CredentialCreationFailedError,
    "CredentialRequestFailedError",
    ()=>CredentialRequestFailedError,
    "createChallenge",
    ()=>createChallenge,
    "createCredential",
    ()=>createCredential,
    "getAuthenticatorData",
    ()=>getAuthenticatorData,
    "getClientDataJSON",
    ()=>getClientDataJSON,
    "getCredentialCreationOptions",
    ()=>getCredentialCreationOptions,
    "getCredentialRequestOptions",
    ()=>getCredentialRequestOptions,
    "getSignPayload",
    ()=>getSignPayload,
    "sign",
    ()=>sign,
    "verify",
    ()=>verify
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Base64$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Base64.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$webauthn$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/webauthn.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$P256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/P256.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
const createChallenge = Uint8Array.from([
    105,
    171,
    180,
    181,
    160,
    222,
    75,
    198,
    42,
    42,
    32,
    31,
    141,
    37,
    186,
    233
]);
async function createCredential(options) {
    const { createFn = window.navigator.credentials.create.bind(window.navigator.credentials), ...rest } = options;
    const creationOptions = getCredentialCreationOptions(rest);
    try {
        const credential = await createFn(creationOptions);
        if (!credential) throw new CredentialCreationFailedError();
        const response = credential.response;
        const publicKey = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$webauthn$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseCredentialPublicKey"](response);
        return {
            id: credential.id,
            publicKey,
            raw: credential
        };
    } catch (error) {
        throw new CredentialCreationFailedError({
            cause: error
        });
    }
}
function getAuthenticatorData() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { flag = 5, rpId = window.location.hostname, signCount = 0 } = options;
    const rpIdHash = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sha256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](rpId));
    const flag_bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](flag, {
        size: 1
    });
    const signCount_bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](signCount, {
        size: 4
    });
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](rpIdHash, flag_bytes, signCount_bytes);
}
function getClientDataJSON(options) {
    const { challenge, crossOrigin = false, extraClientData, origin = window.location.origin } = options;
    return JSON.stringify({
        type: 'webauthn.get',
        challenge: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Base64$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](challenge, {
            url: true,
            pad: false
        }),
        origin,
        crossOrigin,
        ...extraClientData
    });
}
function getCredentialCreationOptions(options) {
    const { attestation = 'none', authenticatorSelection = {
        residentKey: 'preferred',
        requireResidentKey: false,
        userVerification: 'required'
    }, challenge = createChallenge, excludeCredentialIds, extensions, name: name_, rp = {
        id: window.location.hostname,
        name: window.document.title
    }, user } = options;
    var _user_name;
    const name = (_user_name = user === null || user === void 0 ? void 0 : user.name) !== null && _user_name !== void 0 ? _user_name : name_;
    var _user_id, _user_displayName;
    return {
        publicKey: {
            attestation,
            authenticatorSelection,
            challenge,
            ...excludeCredentialIds ? {
                excludeCredentials: excludeCredentialIds === null || excludeCredentialIds === void 0 ? void 0 : excludeCredentialIds.map((id)=>({
                        id: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Base64$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](id),
                        type: 'public-key'
                    }))
            } : {},
            pubKeyCredParams: [
                {
                    type: 'public-key',
                    alg: -7
                }
            ],
            ...extensions && {
                extensions
            },
            rp,
            user: {
                id: (_user_id = user === null || user === void 0 ? void 0 : user.id) !== null && _user_id !== void 0 ? _user_id : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](name), {
                    as: 'Bytes'
                }),
                name,
                displayName: (_user_displayName = user === null || user === void 0 ? void 0 : user.displayName) !== null && _user_displayName !== void 0 ? _user_displayName : name
            }
        }
    };
}
function getCredentialRequestOptions(options) {
    const { credentialId, challenge, extensions, rpId = window.location.hostname, userVerification = 'required' } = options;
    return {
        publicKey: {
            ...credentialId ? {
                allowCredentials: Array.isArray(credentialId) ? credentialId.map((id)=>({
                        id: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Base64$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](id),
                        type: 'public-key'
                    })) : [
                    {
                        id: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Base64$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](credentialId),
                        type: 'public-key'
                    }
                ]
            } : {},
            challenge: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](challenge),
            ...extensions && {
                extensions
            },
            rpId,
            userVerification
        }
    };
}
function getSignPayload(options) {
    const { challenge, crossOrigin, extraClientData, flag, origin, rpId, signCount, userVerification = 'required' } = options;
    const authenticatorData = getAuthenticatorData({
        flag,
        rpId,
        signCount
    });
    const clientDataJSON = getClientDataJSON({
        challenge,
        crossOrigin,
        extraClientData,
        origin
    });
    const clientDataJSONHash = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sha256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](clientDataJSON));
    const challengeIndex = clientDataJSON.indexOf('"challenge"');
    const typeIndex = clientDataJSON.indexOf('"type"');
    const metadata = {
        authenticatorData,
        clientDataJSON,
        challengeIndex,
        typeIndex,
        userVerificationRequired: userVerification === 'required'
    };
    const payload = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](authenticatorData, clientDataJSONHash);
    return {
        metadata,
        payload
    };
}
async function sign(options) {
    const { getFn = window.navigator.credentials.get.bind(window.navigator.credentials), ...rest } = options;
    const requestOptions = getCredentialRequestOptions(rest);
    try {
        const credential = await getFn(requestOptions);
        if (!credential) throw new CredentialRequestFailedError();
        const response = credential.response;
        const clientDataJSON = String.fromCharCode(...new Uint8Array(response.clientDataJSON));
        const challengeIndex = clientDataJSON.indexOf('"challenge"');
        const typeIndex = clientDataJSON.indexOf('"type"');
        const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$webauthn$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAsn1Signature"](new Uint8Array(response.signature));
        return {
            metadata: {
                authenticatorData: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](new Uint8Array(response.authenticatorData)),
                clientDataJSON,
                challengeIndex,
                typeIndex,
                userVerificationRequired: requestOptions.publicKey.userVerification === 'required'
            },
            signature,
            raw: credential
        };
    } catch (error) {
        throw new CredentialRequestFailedError({
            cause: error
        });
    }
}
function verify(options) {
    const { challenge, hash = true, metadata, publicKey, signature } = options;
    const { authenticatorData, challengeIndex, clientDataJSON, typeIndex, userVerificationRequired } = metadata;
    const authenticatorDataBytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](authenticatorData);
    // Check length of `authenticatorData`.
    if (authenticatorDataBytes.length < 37) return false;
    const flag = authenticatorDataBytes[32];
    // Verify that the UP bit of the flags in authData is set.
    if ((flag & 0x01) !== 0x01) return false;
    // If user verification was determined to be required, verify that
    // the UV bit of the flags in authData is set. Otherwise, ignore the
    // value of the UV flag.
    if (userVerificationRequired && (flag & 0x04) !== 0x04) return false;
    // If the BE bit of the flags in authData is not set, verify that
    // the BS bit is not set.
    if ((flag & 0x08) !== 0x08 && (flag & 0x10) === 0x10) return false;
    // Check that response is for an authentication assertion
    const type = '"type":"webauthn.get"';
    if (type !== clientDataJSON.slice(Number(typeIndex), type.length + 1)) return false;
    // Check that hash is in the clientDataJSON.
    const match = clientDataJSON.slice(Number(challengeIndex)).match(/^"challenge":"(.*?)"/);
    if (!match) return false;
    // Validate the challenge in the clientDataJSON.
    const [_, challenge_extracted] = match;
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Base64$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](challenge_extracted)) !== challenge) return false;
    const clientDataJSONHash = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sha256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](clientDataJSON), {
        as: 'Bytes'
    });
    const payload = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](authenticatorDataBytes, clientDataJSONHash);
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$P256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["verify"]({
        hash,
        payload,
        publicKey,
        signature
    });
}
class CredentialCreationFailedError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ cause } = {}){
        super('Failed to create credential.', {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'WebAuthnP256.CredentialCreationFailedError'
        });
    }
}
class CredentialRequestFailedError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ cause } = {}){
        super('Failed to request credential.', {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'WebAuthnP256.CredentialRequestFailedError'
        });
    }
} //# sourceMappingURL=WebAuthnP256.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/WebCryptoP256.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createKeyPair",
    ()=>createKeyPair,
    "createKeyPairECDH",
    ()=>createKeyPairECDH,
    "getSharedSecret",
    ()=>getSharedSecret,
    "sign",
    ()=>sign,
    "verify",
    ()=>verify
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/p256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
;
;
;
;
async function createKeyPair() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { extractable = false } = options;
    const keypair = await globalThis.crypto.subtle.generateKey({
        name: 'ECDSA',
        namedCurve: 'P-256'
    }, extractable, [
        'sign',
        'verify'
    ]);
    const publicKey_raw = await globalThis.crypto.subtle.exportKey('raw', keypair.publicKey);
    const publicKey = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](new Uint8Array(publicKey_raw));
    return {
        privateKey: keypair.privateKey,
        publicKey
    };
}
async function createKeyPairECDH() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { extractable = false } = options;
    const keypair = await globalThis.crypto.subtle.generateKey({
        name: 'ECDH',
        namedCurve: 'P-256'
    }, extractable, [
        'deriveKey',
        'deriveBits'
    ]);
    const publicKey_raw = await globalThis.crypto.subtle.exportKey('raw', keypair.publicKey);
    const publicKey = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](new Uint8Array(publicKey_raw));
    return {
        privateKey: keypair.privateKey,
        publicKey
    };
}
async function getSharedSecret(options) {
    const { as = 'Hex', privateKey, publicKey } = options;
    if (privateKey.algorithm.name === 'ECDSA') {
        throw new Error('privateKey is not compatible with ECDH. please use `createKeyPairECDH` to create an ECDH key.');
    }
    const publicKeyCrypto = await globalThis.crypto.subtle.importKey('raw', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](publicKey), {
        name: 'ECDH',
        namedCurve: 'P-256'
    }, false, []);
    const sharedSecretBuffer = await globalThis.crypto.subtle.deriveBits({
        name: 'ECDH',
        public: publicKeyCrypto
    }, privateKey, 256);
    const sharedSecret = new Uint8Array(sharedSecretBuffer);
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](sharedSecret);
    return sharedSecret;
}
async function sign(options) {
    const { payload, privateKey } = options;
    const signature = await globalThis.crypto.subtle.sign({
        name: 'ECDSA',
        hash: 'SHA-256'
    }, privateKey, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload));
    const signature_bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromArray"](new Uint8Array(signature));
    const r = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBigInt"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](signature_bytes, 0, 32));
    let s = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBigInt"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](signature_bytes, 32, 64));
    if (s > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["p256"].CURVE.n / 2n) s = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$p256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["p256"].CURVE.n - s;
    return {
        r,
        s
    };
}
async function verify(options) {
    const { payload, signature } = options;
    const publicKey = await globalThis.crypto.subtle.importKey('raw', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](options.publicKey), {
        name: 'ECDSA',
        namedCurve: 'P-256'
    }, true, [
        'verify'
    ]);
    return await globalThis.crypto.subtle.verify({
        name: 'ECDSA',
        hash: 'SHA-256'
    }, publicKey, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](signature.r), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](signature.s)), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload));
} //# sourceMappingURL=WebCryptoP256.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/RpcRequest.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Creates a JSON-RPC request store to build requests with an incrementing `id`.
 *
 * Returns a type-safe `prepare` function to build a JSON-RPC request object as per the [JSON-RPC 2.0 specification](https://www.jsonrpc.org/specification#request_object).
 *
 * @example
 * ```ts twoslash
 * import { RpcRequest } from 'ox'
 *
 * const store = RpcRequest.createStore()
 *
 * const request_1 = store.prepare({
 *   method: 'eth_blockNumber',
 * })
 * // @log: { id: 0, jsonrpc: '2.0', method: 'eth_blockNumber' }
 *
 * const request_2 = store.prepare({
 *   method: 'eth_call',
 *   params: [
 *     {
 *       to: '0x0000000000000000000000000000000000000000',
 *       data: '0xdeadbeef',
 *     },
 *   ],
 * })
 * // @log: { id: 1, jsonrpc: '2.0', method: 'eth_call', params: [{ to: '0x0000000000000000000000000000000000000000', data: '0xdeadbeef' }] }
 * ```
 *
 * @example
 * ### Type-safe Custom Schemas
 *
 * It is possible to define your own type-safe schema by using {@link ox#RpcSchema.from}.
 *
 * ```ts twoslash
 * import { RpcSchema, RpcRequest } from 'ox'
 *
 * const schema = RpcSchema.from<{ // [!code focus]
 *   Request: { // [!code focus]
 *     method: 'eth_foobar' // [!code focus]
 *     params: [number] // [!code focus]
 *   } // [!code focus]
 *   ReturnType: string // [!code focus]
 * } | { // [!code focus]
 *   Request: { // [!code focus]
 *     method: 'eth_foobaz' // [!code focus]
 *     params: [string] // [!code focus]
 *   } // [!code focus]
 *   ReturnType: string // [!code focus]
 * }>() // [!code focus]
 *
 * const store = RpcRequest.createStore({ schema }) // [!code focus]
 *
 * const request = store.prepare({
 *   method: 'eth_foobar', // [!code focus]
 *   // ^?
 *   params: [42],
 * })
 * ```
 *
 * @param options - Request store options.
 * @returns The request store
 */ __turbopack_context__.s([
    "createStore",
    ()=>createStore,
    "from",
    ()=>from
]);
function createStore() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var _options_id;
    let id = (_options_id = options.id) !== null && _options_id !== void 0 ? _options_id : 0;
    return {
        prepare (options) {
            return from({
                id: id++,
                ...options
            });
        },
        get id () {
            return id;
        }
    };
}
function from(options) {
    return {
        ...options,
        jsonrpc: '2.0'
    };
} //# sourceMappingURL=RpcRequest.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/RpcSchema.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Instantiates a statically typed Schema. This is a runtime-noop function, and is purposed
 * to be used as a type-level tag to be used with {@link ox#Provider.(from:function)} or
 * {@link ox#RpcTransport.(fromHttp:function)}.
 *
 * @example
 * ### Using with `Provider.from`
 *
 * ```ts twoslash
 * // @noErrors
 * import 'ox/window'
 * import { Provider, RpcSchema } from 'ox'
 *
 * const schema = RpcSchema.from<
 *   | RpcSchema.Default
 *   | {
 *       Request: {
 *         method: 'abe_foo',
 *         params: [id: number],
 *       }
 *       ReturnType: string
 *     }
 *   | {
 *       Request: {
 *         method: 'abe_bar',
 *         params: [id: string],
 *       }
 *       ReturnType: string
 *     }
 * >()
 *
 * const provider = Provider.from(window.ethereum, { schema })
 *
 * const blockNumber = await provider.request({ method: 'e' })
 * //                                                    ^|
 *
 *
 *
 *
 *
 * ```
 */ __turbopack_context__.s([
    "from",
    ()=>from
]);
function from() {
    return null;
} //# sourceMappingURL=RpcSchema.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/uid.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "uid",
    ()=>uid
]);
const size = 256;
let index = size;
let buffer;
function uid() {
    let length = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 11;
    if (!buffer || index + length > size * 2) {
        buffer = '';
        index = 0;
        for(let i = 0; i < size; i++){
            buffer += (256 + Math.random() * 256 | 0).toString(16).substring(1);
        }
    }
    return buffer.substring(index, index++ + length);
} //# sourceMappingURL=uid.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Siwe.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidMessageFieldError",
    ()=>InvalidMessageFieldError,
    "createMessage",
    ()=>createMessage,
    "domainRegex",
    ()=>domainRegex,
    "generateNonce",
    ()=>generateNonce,
    "ipRegex",
    ()=>ipRegex,
    "isUri",
    ()=>isUri,
    "localhostRegex",
    ()=>localhostRegex,
    "nonceRegex",
    ()=>nonceRegex,
    "parseMessage",
    ()=>parseMessage,
    "prefixRegex",
    ()=>prefixRegex,
    "schemeRegex",
    ()=>schemeRegex,
    "suffixRegex",
    ()=>suffixRegex,
    "validateMessage",
    ()=>validateMessage
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$uid$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/uid.js [app-client] (ecmascript)");
;
;
;
const domainRegex = /^([a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,}(:[0-9]{1,5})?$/;
const ipRegex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(:[0-9]{1,5})?$/;
const localhostRegex = /^localhost(:[0-9]{1,5})?$/;
const nonceRegex = /^[a-zA-Z0-9]{8,}$/;
const schemeRegex = /^([a-zA-Z][a-zA-Z0-9+-.]*)$/;
const prefixRegex = RegExp("^(?:(?<scheme>[a-zA-Z][a-zA-Z0-9+-.]*):\\/\\/)?(?<domain>[a-zA-Z0-9+-.]*(?::[0-9]{1,5})?) (?:wants you to sign in with your Ethereum account:\\n)(?<address>0x[a-fA-F0-9]{40})\\n\\n(?:(?<statement>.*)\\n\\n)?");
const suffixRegex = RegExp("(?:URI: (?<uri>.+))\\n(?:Version: (?<version>.+))\\n(?:Chain ID: (?<chainId>\\d+))\\n(?:Nonce: (?<nonce>[a-zA-Z0-9]+))\\n(?:Issued At: (?<issuedAt>.+))(?:\\nExpiration Time: (?<expirationTime>.+))?(?:\\nNot Before: (?<notBefore>.+))?(?:\\nRequest ID: (?<requestId>.+))?");
function createMessage(value) {
    const { chainId, domain, expirationTime, issuedAt = new Date(), nonce, notBefore, requestId, resources, scheme, uri, version } = value;
    // Validate fields
    {
        // Required fields
        if (chainId !== Math.floor(chainId)) throw new InvalidMessageFieldError({
            field: 'chainId',
            metaMessages: [
                '- Chain ID must be a EIP-155 chain ID.',
                '- See https://eips.ethereum.org/EIPS/eip-155',
                '',
                "Provided value: ".concat(chainId)
            ]
        });
        if (!(domainRegex.test(domain) || ipRegex.test(domain) || localhostRegex.test(domain))) throw new InvalidMessageFieldError({
            field: 'domain',
            metaMessages: [
                '- Domain must be an RFC 3986 authority.',
                '- See https://www.rfc-editor.org/rfc/rfc3986',
                '',
                "Provided value: ".concat(domain)
            ]
        });
        if (!nonceRegex.test(nonce)) throw new InvalidMessageFieldError({
            field: 'nonce',
            metaMessages: [
                '- Nonce must be at least 8 characters.',
                '- Nonce must be alphanumeric.',
                '',
                "Provided value: ".concat(nonce)
            ]
        });
        if (!isUri(uri)) throw new InvalidMessageFieldError({
            field: 'uri',
            metaMessages: [
                '- URI must be a RFC 3986 URI referring to the resource that is the subject of the signing.',
                '- See https://www.rfc-editor.org/rfc/rfc3986',
                '',
                "Provided value: ".concat(uri)
            ]
        });
        if (version !== '1') throw new InvalidMessageFieldError({
            field: 'version',
            metaMessages: [
                "- Version must be '1'.",
                '',
                "Provided value: ".concat(version)
            ]
        });
        // Optional fields
        if (scheme && !schemeRegex.test(scheme)) throw new InvalidMessageFieldError({
            field: 'scheme',
            metaMessages: [
                '- Scheme must be an RFC 3986 URI scheme.',
                '- See https://www.rfc-editor.org/rfc/rfc3986#section-3.1',
                '',
                "Provided value: ".concat(scheme)
            ]
        });
        const statement = value.statement;
        if (statement === null || statement === void 0 ? void 0 : statement.includes('\n')) throw new InvalidMessageFieldError({
            field: 'statement',
            metaMessages: [
                "- Statement must not include '\\n'.",
                '',
                "Provided value: ".concat(statement)
            ]
        });
    }
    // Construct message
    const address = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value.address, {
        checksum: true
    });
    const origin = (()=>{
        if (scheme) return "".concat(scheme, "://").concat(domain);
        return domain;
    })();
    const statement = (()=>{
        if (!value.statement) return '';
        return "".concat(value.statement, "\n");
    })();
    const prefix = "".concat(origin, " wants you to sign in with your Ethereum account:\n").concat(address, "\n\n").concat(statement);
    let suffix = "URI: ".concat(uri, "\nVersion: ").concat(version, "\nChain ID: ").concat(chainId, "\nNonce: ").concat(nonce, "\nIssued At: ").concat(issuedAt.toISOString());
    if (expirationTime) suffix += "\nExpiration Time: ".concat(expirationTime.toISOString());
    if (notBefore) suffix += "\nNot Before: ".concat(notBefore.toISOString());
    if (requestId) suffix += "\nRequest ID: ".concat(requestId);
    if (resources) {
        let content = '\nResources:';
        for (const resource of resources){
            if (!isUri(resource)) throw new InvalidMessageFieldError({
                field: 'resources',
                metaMessages: [
                    '- Every resource must be a RFC 3986 URI.',
                    '- See https://www.rfc-editor.org/rfc/rfc3986',
                    '',
                    "Provided value: ".concat(resource)
                ]
            });
            content += "\n- ".concat(resource);
        }
        suffix += content;
    }
    return "".concat(prefix, "\n").concat(suffix);
}
function generateNonce() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$uid$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["uid"])(96);
}
function isUri(value) {
    // check for illegal characters
    if (/[^a-z0-9:/?#[\]@!$&'()*+,;=.\-_~%]/i.test(value)) return false;
    // check for hex escapes that aren't complete
    if (/%[^0-9a-f]/i.test(value)) return false;
    if (/%[0-9a-f](:?[^0-9a-f]|$)/i.test(value)) return false;
    // from RFC 3986
    const splitted = splitUri(value);
    const scheme = splitted[1];
    const authority = splitted[2];
    const path = splitted[3];
    const query = splitted[4];
    const fragment = splitted[5];
    // scheme and path are required, though the path can be empty
    if (!((scheme === null || scheme === void 0 ? void 0 : scheme.length) && path && path.length >= 0)) return false;
    // if authority is present, the path must be empty or begin with a /
    if (authority === null || authority === void 0 ? void 0 : authority.length) {
        if (!(path.length === 0 || /^\//.test(path))) return false;
    } else {
        // if authority is not present, the path must not start with //
        if (/^\/\//.test(path)) return false;
    }
    // scheme must begin with a letter, then consist of letters, digits, +, ., or -
    if (!/^[a-z][a-z0-9+\-.]*$/.test(scheme.toLowerCase())) return false;
    let out = '';
    // re-assemble the URL per section 5.3 in RFC 3986
    out += "".concat(scheme, ":");
    if (authority === null || authority === void 0 ? void 0 : authority.length) out += "//".concat(authority);
    out += path;
    if (query === null || query === void 0 ? void 0 : query.length) out += "?".concat(query);
    if (fragment === null || fragment === void 0 ? void 0 : fragment.length) out += "#".concat(fragment);
    return out;
}
function splitUri(value) {
    return value.match(/(?:([^:/?#]+):)?(?:\/\/([^/?#]*))?([^?#]*)(?:\?([^#]*))?(?:#(.*))?/);
}
function parseMessage(message) {
    var _message_match, _message_match1, _message_split_;
    var _message_match_groups;
    const { scheme, statement, ...prefix } = (_message_match_groups = (_message_match = message.match(prefixRegex)) === null || _message_match === void 0 ? void 0 : _message_match.groups) !== null && _message_match_groups !== void 0 ? _message_match_groups : {};
    var _message_match_groups1;
    const { chainId, expirationTime, issuedAt, notBefore, requestId, ...suffix } = (_message_match_groups1 = (_message_match1 = message.match(suffixRegex)) === null || _message_match1 === void 0 ? void 0 : _message_match1.groups) !== null && _message_match_groups1 !== void 0 ? _message_match_groups1 : {};
    const resources = (_message_split_ = message.split('Resources:')[1]) === null || _message_split_ === void 0 ? void 0 : _message_split_.split('\n- ').slice(1);
    return {
        ...prefix,
        ...suffix,
        ...chainId ? {
            chainId: Number(chainId)
        } : {},
        ...expirationTime ? {
            expirationTime: new Date(expirationTime)
        } : {},
        ...issuedAt ? {
            issuedAt: new Date(issuedAt)
        } : {},
        ...notBefore ? {
            notBefore: new Date(notBefore)
        } : {},
        ...requestId ? {
            requestId
        } : {},
        ...resources ? {
            resources
        } : {},
        ...scheme ? {
            scheme
        } : {},
        ...statement ? {
            statement
        } : {}
    };
}
function validateMessage(value) {
    const { address, domain, message, nonce, scheme, time = new Date() } = value;
    if (domain && message.domain !== domain) return false;
    if (nonce && message.nonce !== nonce) return false;
    if (scheme && message.scheme !== scheme) return false;
    if (message.expirationTime && time >= message.expirationTime) return false;
    if (message.notBefore && time < message.notBefore) return false;
    try {
        if (!message.address) return false;
        if (address && !__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isEqual"](message.address, address)) return false;
    } catch (e) {
        return false;
    }
    return true;
}
class InvalidMessageFieldError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(parameters){
        const { field, metaMessages } = parameters;
        super('Invalid Sign-In with Ethereum message field "'.concat(field, '".'), {
            metaMessages
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Siwe.InvalidMessageFieldError'
        });
    }
} //# sourceMappingURL=Siwe.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/PersonalMessage.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "encode",
    ()=>encode,
    "getSignPayload",
    ()=>getSignPayload
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
function encode(data) {
    const message = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](data);
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](// Personal Sign Format: `0x19 ‖ "Ethereum Signed Message:\n" ‖ message.length ‖ message`
    '0x19', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"]('Ethereum Signed Message:\n' + __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](message)), message);
}
function getSignPayload(data) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](encode(data));
} //# sourceMappingURL=PersonalMessage.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiError.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decode",
    ()=>decode,
    "encode",
    ()=>encode,
    "format",
    ()=>format,
    "from",
    ()=>from,
    "fromAbi",
    ()=>fromAbi,
    "getSelector",
    ()=>getSelector,
    "panicReasons",
    ()=>panicReasons,
    "solidityError",
    ()=>solidityError,
    "solidityErrorSelector",
    ()=>solidityErrorSelector,
    "solidityPanic",
    ()=>solidityPanic,
    "solidityPanicSelector",
    ()=>solidityPanicSelector
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.1_typescript@5.9.3_zod@4.1.12/node_modules/abitype/dist/esm/human-readable/formatAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
;
;
function decode() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiError, data, options = {}] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, data, options] = parameters;
            return [
                fromAbi(abi, name),
                data,
                options
            ];
        }
        return parameters;
    })();
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](data) < 4) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidSelectorSizeError"]({
        data
    });
    if (abiError.inputs.length === 0) return undefined;
    const values = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](abiError.inputs, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](data, 4), options);
    if (values && Object.keys(values).length === 1) {
        if (Array.isArray(values)) return values[0];
        return Object.values(values)[0];
    }
    return values;
}
function encode() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiError, args] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, ...args] = parameters;
            return [
                fromAbi(abi, name),
                args
            ];
        }
        const [abiError, ...args] = parameters;
        return [
            abiError,
            args
        ];
    })();
    const selector = getSelector(abiError);
    const data = args.length > 0 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](abiError.inputs, args[0]) : undefined;
    return data ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](selector, data) : selector;
}
function format(abiError) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$1_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiError);
}
function from(abiError) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](abiError, options);
}
function fromAbi(abi, name, options) {
    if (name === 'Error') return solidityError;
    if (name === 'Panic') return solidityPanic;
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](name, {
        strict: false
    })) {
        const selector = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](name, 0, 4);
        if (selector === solidityErrorSelector) return solidityError;
        if (selector === solidityPanicSelector) return solidityPanic;
    }
    const item = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromAbi"](abi, name, options);
    if (item.type !== 'error') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NotFoundError"]({
        name,
        type: 'error'
    });
    return item;
}
function getSelector(abiItem) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getSelector"](abiItem);
}
const panicReasons = {
    1: 'An `assert` condition failed.',
    17: 'Arithmetic operation resulted in underflow or overflow.',
    18: 'Division or modulo by zero (e.g. `5 / 0` or `23 % 0`).',
    33: 'Attempted to convert to an invalid type.',
    34: 'Attempted to access a storage byte array that is incorrectly encoded.',
    49: 'Performed `.pop()` on an empty array',
    50: 'Array index is out of bounds.',
    65: 'Allocated too much memory or created an array which is too large.',
    81: 'Attempted to call a zero-initialized variable of internal function type.'
};
const solidityError = /*#__PURE__*/ from({
    inputs: [
        {
            name: 'message',
            type: 'string'
        }
    ],
    name: 'Error',
    type: 'error'
});
const solidityErrorSelector = '0x08c379a0';
const solidityPanic = /*#__PURE__*/ from({
    inputs: [
        {
            name: 'reason',
            type: 'uint8'
        }
    ],
    name: 'Panic',
    type: 'error'
});
const solidityPanicSelector = '0x4e487b71'; //# sourceMappingURL=AbiError.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Rlp.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decodeRlpCursor",
    ()=>decodeRlpCursor,
    "from",
    ()=>from,
    "fromBytes",
    ()=>fromBytes,
    "fromHex",
    ()=>fromHex,
    "readLength",
    ()=>readLength,
    "readList",
    ()=>readList,
    "to",
    ()=>to,
    "toBytes",
    ()=>toBytes,
    "toHex",
    ()=>toHex
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/cursor.js [app-client] (ecmascript)");
;
;
;
;
function toBytes(value) {
    return to(value, 'Bytes');
}
function toHex(value) {
    return to(value, 'Hex');
}
function to(value, to) {
    const to_ = to !== null && to !== void 0 ? to : typeof value === 'string' ? 'Hex' : 'Bytes';
    const bytes = (()=>{
        if (typeof value === 'string') {
            if (value.length > 3 && value.length % 2 !== 0) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidLengthError"](value);
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](value);
        }
        return value;
    })();
    const cursor = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"](bytes, {
        recursiveReadLimit: Number.POSITIVE_INFINITY
    });
    const result = decodeRlpCursor(cursor, to_);
    return result;
}
function decodeRlpCursor(cursor) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'Hex';
    if (cursor.bytes.length === 0) return to === 'Hex' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](cursor.bytes) : cursor.bytes;
    const prefix = cursor.readByte();
    if (prefix < 0x80) cursor.decrementPosition(1);
    // bytes
    if (prefix < 0xc0) {
        const length = readLength(cursor, prefix, 0x80);
        const bytes = cursor.readBytes(length);
        return to === 'Hex' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes) : bytes;
    }
    // list
    const length = readLength(cursor, prefix, 0xc0);
    return readList(cursor, length, to);
}
function readLength(cursor, prefix, offset) {
    if (offset === 0x80 && prefix < 0x80) return 1;
    if (prefix <= offset + 55) return prefix - offset;
    if (prefix === offset + 55 + 1) return cursor.readUint8();
    if (prefix === offset + 55 + 2) return cursor.readUint16();
    if (prefix === offset + 55 + 3) return cursor.readUint24();
    if (prefix === offset + 55 + 4) return cursor.readUint32();
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Invalid RLP prefix');
}
function readList(cursor, length, to) {
    const position = cursor.position;
    const value = [];
    while(cursor.position - position < length)value.push(decodeRlpCursor(cursor, to));
    return value;
}
function from(value, options) {
    const { as } = options;
    const encodable = getEncodable(value);
    const cursor = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"](new Uint8Array(encodable.length));
    encodable.encode(cursor);
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](cursor.bytes);
    return cursor.bytes;
}
function fromBytes(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = 'Bytes' } = options;
    return from(bytes, {
        as
    });
}
function fromHex(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = 'Hex' } = options;
    return from(hex, {
        as
    });
}
/////////////////////////////////////////////////////////////////////////////////
// Internal
/////////////////////////////////////////////////////////////////////////////////
function getEncodable(bytes) {
    if (Array.isArray(bytes)) return getEncodableList(bytes.map((x)=>getEncodable(x)));
    return getEncodableBytes(bytes);
}
function getEncodableList(list) {
    const bodyLength = list.reduce((acc, x)=>acc + x.length, 0);
    const sizeOfBodyLength = getSizeOfLength(bodyLength);
    const length = (()=>{
        if (bodyLength <= 55) return 1 + bodyLength;
        return 1 + sizeOfBodyLength + bodyLength;
    })();
    return {
        length,
        encode (cursor) {
            if (bodyLength <= 55) {
                cursor.pushByte(0xc0 + bodyLength);
            } else {
                cursor.pushByte(0xc0 + 55 + sizeOfBodyLength);
                if (sizeOfBodyLength === 1) cursor.pushUint8(bodyLength);
                else if (sizeOfBodyLength === 2) cursor.pushUint16(bodyLength);
                else if (sizeOfBodyLength === 3) cursor.pushUint24(bodyLength);
                else cursor.pushUint32(bodyLength);
            }
            for (const { encode } of list){
                encode(cursor);
            }
        }
    };
}
function getEncodableBytes(bytesOrHex) {
    const bytes = typeof bytesOrHex === 'string' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](bytesOrHex) : bytesOrHex;
    const sizeOfBytesLength = getSizeOfLength(bytes.length);
    const length = (()=>{
        if (bytes.length === 1 && bytes[0] < 0x80) return 1;
        if (bytes.length <= 55) return 1 + bytes.length;
        return 1 + sizeOfBytesLength + bytes.length;
    })();
    return {
        length,
        encode (cursor) {
            if (bytes.length === 1 && bytes[0] < 0x80) {
                cursor.pushBytes(bytes);
            } else if (bytes.length <= 55) {
                cursor.pushByte(0x80 + bytes.length);
                cursor.pushBytes(bytes);
            } else {
                cursor.pushByte(0x80 + 55 + sizeOfBytesLength);
                if (sizeOfBytesLength === 1) cursor.pushUint8(bytes.length);
                else if (sizeOfBytesLength === 2) cursor.pushUint16(bytes.length);
                else if (sizeOfBytesLength === 3) cursor.pushUint24(bytes.length);
                else cursor.pushUint32(bytes.length);
                cursor.pushBytes(bytes);
            }
        }
    };
}
function getSizeOfLength(length) {
    if (length <= 0xff) return 1;
    if (length <= 0xff_ff) return 2;
    if (length <= 0xff_ff_ff) return 3;
    if (length <= 0xff_ff_ff_ff) return 4;
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Length is too large.');
} //# sourceMappingURL=Rlp.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Authorization.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "from",
    ()=>from,
    "fromRpc",
    ()=>fromRpc,
    "fromRpcList",
    ()=>fromRpcList,
    "fromTuple",
    ()=>fromTuple,
    "fromTupleList",
    ()=>fromTupleList,
    "getSignPayload",
    ()=>getSignPayload,
    "hash",
    ()=>hash,
    "toRpc",
    ()=>toRpc,
    "toRpcList",
    ()=>toRpcList,
    "toTuple",
    ()=>toTuple,
    "toTupleList",
    ()=>toTupleList
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Rlp$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Rlp.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Signature.js [app-client] (ecmascript)");
;
;
;
;
function from(authorization) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof authorization.chainId === 'string') return fromRpc(authorization);
    return {
        ...authorization,
        ...options.signature
    };
}
function fromRpc(authorization) {
    const { address, chainId, nonce } = authorization;
    const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extract"](authorization);
    return {
        address,
        chainId: Number(chainId),
        nonce: BigInt(nonce),
        ...signature
    };
}
function fromRpcList(authorizationList) {
    return authorizationList.map(fromRpc);
}
function fromTuple(tuple) {
    const [chainId, address, nonce, yParity, r, s] = tuple;
    let args = {
        address,
        chainId: chainId === '0x' ? 0 : Number(chainId),
        nonce: nonce === '0x' ? 0n : BigInt(nonce)
    };
    if (yParity && r && s) args = {
        ...args,
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromTuple"]([
            yParity,
            r,
            s
        ])
    };
    return from(args);
}
function fromTupleList(tupleList) {
    const list = [];
    for (const tuple of tupleList)list.push(fromTuple(tuple));
    return list;
}
function getSignPayload(authorization) {
    return hash(authorization, {
        presign: true
    });
}
function hash(authorization) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { presign } = options;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"]('0x05', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Rlp$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](toTuple(presign ? {
        address: authorization.address,
        chainId: authorization.chainId,
        nonce: authorization.nonce
    } : authorization))));
}
function toRpc(authorization) {
    const { address, chainId, nonce, ...signature } = authorization;
    return {
        address,
        chainId: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](chainId),
        nonce: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](nonce),
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toRpc"](signature)
    };
}
function toRpcList(authorizationList) {
    return authorizationList.map(toRpc);
}
function toTuple(authorization) {
    const { address, chainId, nonce } = authorization;
    const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extract"](authorization);
    return [
        chainId ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](chainId) : '0x',
        address,
        nonce ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](nonce) : '0x',
        ...signature ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toTuple"](signature) : []
    ];
}
function toTupleList(list) {
    if (!list || list.length === 0) return [];
    const tupleList = [];
    for (const authorization of list)tupleList.push(toTuple(authorization));
    return tupleList;
} //# sourceMappingURL=Authorization.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/lru.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * @internal
 *
 * Map with a LRU (Least recently used) policy.
 * @see https://en.wikipedia.org/wiki/Cache_replacement_policies#LRU
 */ __turbopack_context__.s([
    "LruMap",
    ()=>LruMap
]);
class LruMap extends Map {
    get(key) {
        const value = super.get(key);
        if (super.has(key) && value !== undefined) {
            this.delete(key);
            super.set(key, value);
        }
        return value;
    }
    set(key, value) {
        super.set(key, value);
        if (this.maxSize && this.size > this.maxSize) {
            const firstKey = this.keys().next().value;
            if (firstKey) this.delete(firstKey);
        }
        return this;
    }
    constructor(size){
        super();
        Object.defineProperty(this, "maxSize", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.maxSize = size;
    }
} //# sourceMappingURL=lru.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Caches.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "checksum",
    ()=>checksum,
    "clear",
    ()=>clear
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$lru$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/lru.js [app-client] (ecmascript)");
;
const caches = {
    checksum: /*#__PURE__*/ new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$lru$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["LruMap"](8192)
};
const checksum = caches.checksum;
function clear() {
    for (const cache of Object.values(caches))cache.clear();
} //# sourceMappingURL=Caches.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "keccak256",
    ()=>keccak256,
    "ripemd160",
    ()=>ripemd160,
    "sha256",
    ()=>sha256,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$ripemd160$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/esm/ripemd160.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha3$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/esm/sha3.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+hashes@1.8.0/node_modules/@noble/hashes/esm/sha256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
;
;
;
function keccak256(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = typeof value === 'string' ? 'Hex' : 'Bytes' } = options;
    const bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha3$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak_256"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value));
    if (as === 'Bytes') return bytes;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
}
function ripemd160(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = typeof value === 'string' ? 'Hex' : 'Bytes' } = options;
    const bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$ripemd160$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ripemd160"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value));
    if (as === 'Bytes') return bytes;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
}
function sha256(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = typeof value === 'string' ? 'Hex' : 'Bytes' } = options;
    const bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$hashes$40$1$2e$8$2e$0$2f$node_modules$2f40$noble$2f$hashes$2f$esm$2f$sha256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sha256"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value));
    if (as === 'Bytes') return bytes;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
}
function validate(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value) && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) === 32;
} //# sourceMappingURL=Hash.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidCompressedPrefixError",
    ()=>InvalidCompressedPrefixError,
    "InvalidError",
    ()=>InvalidError,
    "InvalidPrefixError",
    ()=>InvalidPrefixError,
    "InvalidSerializedSizeError",
    ()=>InvalidSerializedSizeError,
    "InvalidUncompressedPrefixError",
    ()=>InvalidUncompressedPrefixError,
    "assert",
    ()=>assert,
    "compress",
    ()=>compress,
    "from",
    ()=>from,
    "fromBytes",
    ()=>fromBytes,
    "fromHex",
    ()=>fromHex,
    "toBytes",
    ()=>toBytes,
    "toHex",
    ()=>toHex,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
;
;
;
;
function assert(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { compressed } = options;
    const { prefix, x, y } = publicKey;
    // Uncompressed
    if (compressed === false || typeof x === 'bigint' && typeof y === 'bigint') {
        if (prefix !== 4) throw new InvalidPrefixError({
            prefix,
            cause: new InvalidUncompressedPrefixError()
        });
        return;
    }
    // Compressed
    if (compressed === true || typeof x === 'bigint' && typeof y === 'undefined') {
        if (prefix !== 3 && prefix !== 2) throw new InvalidPrefixError({
            prefix,
            cause: new InvalidCompressedPrefixError()
        });
        return;
    }
    // Unknown/invalid
    throw new InvalidError({
        publicKey
    });
}
function compress(publicKey) {
    const { x, y } = publicKey;
    return {
        prefix: y % 2n === 0n ? 2 : 3,
        x
    };
}
function from(value) {
    const publicKey = (()=>{
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value)) return fromHex(value);
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](value)) return fromBytes(value);
        const { prefix, x, y } = value;
        if (typeof x === 'bigint' && typeof y === 'bigint') return {
            prefix: prefix !== null && prefix !== void 0 ? prefix : 0x04,
            x,
            y
        };
        return {
            prefix,
            x
        };
    })();
    assert(publicKey);
    return publicKey;
}
function fromBytes(publicKey) {
    return fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](publicKey));
}
function fromHex(publicKey) {
    if (publicKey.length !== 132 && publicKey.length !== 130 && publicKey.length !== 68) throw new InvalidSerializedSizeError({
        publicKey
    });
    if (publicKey.length === 130) {
        const x = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 0, 32));
        const y = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 32, 64));
        return {
            prefix: 4,
            x,
            y
        };
    }
    if (publicKey.length === 132) {
        const prefix = Number(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 0, 1));
        const x = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 1, 33));
        const y = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 33, 65));
        return {
            prefix,
            x,
            y
        };
    }
    const prefix = Number(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 0, 1));
    const x = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](publicKey, 1, 33));
    return {
        prefix,
        x
    };
}
function toBytes(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](toHex(publicKey, options));
}
function toHex(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    assert(publicKey);
    const { prefix, x, y } = publicKey;
    const { includePrefix = true } = options;
    const publicKey_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](includePrefix ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](prefix, {
        size: 1
    }) : '0x', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](x, {
        size: 32
    }), // If the public key is not compressed, add the y coordinate.
    typeof y === 'bigint' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](y, {
        size: 32
    }) : '0x');
    return publicKey_;
}
function validate(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    try {
        assert(publicKey, options);
        return true;
    } catch (_error) {
        return false;
    }
}
class InvalidError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ publicKey }){
        super("Value `".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](publicKey), "` is not a valid public key."), {
            metaMessages: [
                'Public key must contain:',
                '- an `x` and `prefix` value (compressed)',
                '- an `x`, `y`, and `prefix` value (uncompressed)'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidError'
        });
    }
}
class InvalidPrefixError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ prefix, cause }){
        super('Prefix "'.concat(prefix, '" is invalid.'), {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidPrefixError'
        });
    }
}
class InvalidCompressedPrefixError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Prefix must be 2 or 3 for compressed public keys.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidCompressedPrefixError'
        });
    }
}
class InvalidUncompressedPrefixError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Prefix must be 4 for uncompressed public keys.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidUncompressedPrefixError'
        });
    }
}
class InvalidSerializedSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ publicKey }){
        super("Value `".concat(publicKey, "` is an invalid public key size."), {
            metaMessages: [
                'Expected: 33 bytes (compressed + prefix), 64 bytes (uncompressed) or 65 bytes (uncompressed + prefix).',
                "Received ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](publicKey)), " bytes.")
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'PublicKey.InvalidSerializedSizeError'
        });
    }
} //# sourceMappingURL=PublicKey.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidAddressError",
    ()=>InvalidAddressError,
    "InvalidChecksumError",
    ()=>InvalidChecksumError,
    "InvalidInputError",
    ()=>InvalidInputError,
    "assert",
    ()=>assert,
    "checksum",
    ()=>checksum,
    "from",
    ()=>from,
    "fromPublicKey",
    ()=>fromPublicKey,
    "isEqual",
    ()=>isEqual,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Caches.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
;
;
;
;
;
const addressRegex = /^0x[a-fA-F0-9]{40}$/;
function assert(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { strict = true } = options;
    if (!addressRegex.test(value)) throw new InvalidAddressError({
        address: value,
        cause: new InvalidInputError()
    });
    if (strict) {
        if (value.toLowerCase() === value) return;
        if (checksum(value) !== value) throw new InvalidAddressError({
            address: value,
            cause: new InvalidChecksumError()
        });
    }
}
function checksum(address) {
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"].has(address)) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"].get(address);
    assert(address, {
        strict: false
    });
    const hexAddress = address.substring(2).toLowerCase();
    const hash = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](hexAddress), {
        as: 'Bytes'
    });
    const characters = hexAddress.split('');
    for(let i = 0; i < 40; i += 2){
        if (hash[i >> 1] >> 4 >= 8 && characters[i]) {
            characters[i] = characters[i].toUpperCase();
        }
        if ((hash[i >> 1] & 0x0f) >= 8 && characters[i + 1]) {
            characters[i + 1] = characters[i + 1].toUpperCase();
        }
    }
    const result = "0x".concat(characters.join(''));
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Caches$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"].set(address, result);
    return result;
}
function from(address) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { checksum: checksumVal = false } = options;
    assert(address);
    if (checksumVal) return checksum(address);
    return address;
}
function fromPublicKey(publicKey) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const address = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"]("0x".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toHex"](publicKey).slice(4))).substring(26);
    return from("0x".concat(address), options);
}
function isEqual(addressA, addressB) {
    assert(addressA, {
        strict: false
    });
    assert(addressB, {
        strict: false
    });
    return addressA.toLowerCase() === addressB.toLowerCase();
}
function validate(address) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { strict = true } = options !== null && options !== void 0 ? options : {};
    try {
        assert(address, {
            strict
        });
        return true;
    } catch (e) {
        return false;
    }
}
class InvalidAddressError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ address, cause }){
        super('Address "'.concat(address, '" is invalid.'), {
            cause
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Address.InvalidAddressError'
        });
    }
}
class InvalidInputError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Address is not a 20 byte (40 hexadecimal character) value.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Address.InvalidInputError'
        });
    }
}
class InvalidChecksumError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Address does not match its checksum counterpart.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Address.InvalidChecksumError'
        });
    }
} //# sourceMappingURL=Address.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "arrayRegex",
    ()=>arrayRegex,
    "bytesRegex",
    ()=>bytesRegex,
    "integerRegex",
    ()=>integerRegex,
    "maxInt104",
    ()=>maxInt104,
    "maxInt112",
    ()=>maxInt112,
    "maxInt120",
    ()=>maxInt120,
    "maxInt128",
    ()=>maxInt128,
    "maxInt136",
    ()=>maxInt136,
    "maxInt144",
    ()=>maxInt144,
    "maxInt152",
    ()=>maxInt152,
    "maxInt16",
    ()=>maxInt16,
    "maxInt160",
    ()=>maxInt160,
    "maxInt168",
    ()=>maxInt168,
    "maxInt176",
    ()=>maxInt176,
    "maxInt184",
    ()=>maxInt184,
    "maxInt192",
    ()=>maxInt192,
    "maxInt200",
    ()=>maxInt200,
    "maxInt208",
    ()=>maxInt208,
    "maxInt216",
    ()=>maxInt216,
    "maxInt224",
    ()=>maxInt224,
    "maxInt232",
    ()=>maxInt232,
    "maxInt24",
    ()=>maxInt24,
    "maxInt240",
    ()=>maxInt240,
    "maxInt248",
    ()=>maxInt248,
    "maxInt256",
    ()=>maxInt256,
    "maxInt32",
    ()=>maxInt32,
    "maxInt40",
    ()=>maxInt40,
    "maxInt48",
    ()=>maxInt48,
    "maxInt56",
    ()=>maxInt56,
    "maxInt64",
    ()=>maxInt64,
    "maxInt72",
    ()=>maxInt72,
    "maxInt8",
    ()=>maxInt8,
    "maxInt80",
    ()=>maxInt80,
    "maxInt88",
    ()=>maxInt88,
    "maxInt96",
    ()=>maxInt96,
    "maxUint104",
    ()=>maxUint104,
    "maxUint112",
    ()=>maxUint112,
    "maxUint120",
    ()=>maxUint120,
    "maxUint128",
    ()=>maxUint128,
    "maxUint136",
    ()=>maxUint136,
    "maxUint144",
    ()=>maxUint144,
    "maxUint152",
    ()=>maxUint152,
    "maxUint16",
    ()=>maxUint16,
    "maxUint160",
    ()=>maxUint160,
    "maxUint168",
    ()=>maxUint168,
    "maxUint176",
    ()=>maxUint176,
    "maxUint184",
    ()=>maxUint184,
    "maxUint192",
    ()=>maxUint192,
    "maxUint200",
    ()=>maxUint200,
    "maxUint208",
    ()=>maxUint208,
    "maxUint216",
    ()=>maxUint216,
    "maxUint224",
    ()=>maxUint224,
    "maxUint232",
    ()=>maxUint232,
    "maxUint24",
    ()=>maxUint24,
    "maxUint240",
    ()=>maxUint240,
    "maxUint248",
    ()=>maxUint248,
    "maxUint256",
    ()=>maxUint256,
    "maxUint32",
    ()=>maxUint32,
    "maxUint40",
    ()=>maxUint40,
    "maxUint48",
    ()=>maxUint48,
    "maxUint56",
    ()=>maxUint56,
    "maxUint64",
    ()=>maxUint64,
    "maxUint72",
    ()=>maxUint72,
    "maxUint8",
    ()=>maxUint8,
    "maxUint80",
    ()=>maxUint80,
    "maxUint88",
    ()=>maxUint88,
    "maxUint96",
    ()=>maxUint96,
    "minInt104",
    ()=>minInt104,
    "minInt112",
    ()=>minInt112,
    "minInt120",
    ()=>minInt120,
    "minInt128",
    ()=>minInt128,
    "minInt136",
    ()=>minInt136,
    "minInt144",
    ()=>minInt144,
    "minInt152",
    ()=>minInt152,
    "minInt16",
    ()=>minInt16,
    "minInt160",
    ()=>minInt160,
    "minInt168",
    ()=>minInt168,
    "minInt176",
    ()=>minInt176,
    "minInt184",
    ()=>minInt184,
    "minInt192",
    ()=>minInt192,
    "minInt200",
    ()=>minInt200,
    "minInt208",
    ()=>minInt208,
    "minInt216",
    ()=>minInt216,
    "minInt224",
    ()=>minInt224,
    "minInt232",
    ()=>minInt232,
    "minInt24",
    ()=>minInt24,
    "minInt240",
    ()=>minInt240,
    "minInt248",
    ()=>minInt248,
    "minInt256",
    ()=>minInt256,
    "minInt32",
    ()=>minInt32,
    "minInt40",
    ()=>minInt40,
    "minInt48",
    ()=>minInt48,
    "minInt56",
    ()=>minInt56,
    "minInt64",
    ()=>minInt64,
    "minInt72",
    ()=>minInt72,
    "minInt8",
    ()=>minInt8,
    "minInt80",
    ()=>minInt80,
    "minInt88",
    ()=>minInt88,
    "minInt96",
    ()=>minInt96
]);
const arrayRegex = /^(.*)\[([0-9]*)\]$/;
const bytesRegex = /^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/;
const integerRegex = /^(u?int)(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/;
const maxInt8 = 2n ** (8n - 1n) - 1n;
const maxInt16 = 2n ** (16n - 1n) - 1n;
const maxInt24 = 2n ** (24n - 1n) - 1n;
const maxInt32 = 2n ** (32n - 1n) - 1n;
const maxInt40 = 2n ** (40n - 1n) - 1n;
const maxInt48 = 2n ** (48n - 1n) - 1n;
const maxInt56 = 2n ** (56n - 1n) - 1n;
const maxInt64 = 2n ** (64n - 1n) - 1n;
const maxInt72 = 2n ** (72n - 1n) - 1n;
const maxInt80 = 2n ** (80n - 1n) - 1n;
const maxInt88 = 2n ** (88n - 1n) - 1n;
const maxInt96 = 2n ** (96n - 1n) - 1n;
const maxInt104 = 2n ** (104n - 1n) - 1n;
const maxInt112 = 2n ** (112n - 1n) - 1n;
const maxInt120 = 2n ** (120n - 1n) - 1n;
const maxInt128 = 2n ** (128n - 1n) - 1n;
const maxInt136 = 2n ** (136n - 1n) - 1n;
const maxInt144 = 2n ** (144n - 1n) - 1n;
const maxInt152 = 2n ** (152n - 1n) - 1n;
const maxInt160 = 2n ** (160n - 1n) - 1n;
const maxInt168 = 2n ** (168n - 1n) - 1n;
const maxInt176 = 2n ** (176n - 1n) - 1n;
const maxInt184 = 2n ** (184n - 1n) - 1n;
const maxInt192 = 2n ** (192n - 1n) - 1n;
const maxInt200 = 2n ** (200n - 1n) - 1n;
const maxInt208 = 2n ** (208n - 1n) - 1n;
const maxInt216 = 2n ** (216n - 1n) - 1n;
const maxInt224 = 2n ** (224n - 1n) - 1n;
const maxInt232 = 2n ** (232n - 1n) - 1n;
const maxInt240 = 2n ** (240n - 1n) - 1n;
const maxInt248 = 2n ** (248n - 1n) - 1n;
const maxInt256 = 2n ** (256n - 1n) - 1n;
const minInt8 = -(2n ** (8n - 1n));
const minInt16 = -(2n ** (16n - 1n));
const minInt24 = -(2n ** (24n - 1n));
const minInt32 = -(2n ** (32n - 1n));
const minInt40 = -(2n ** (40n - 1n));
const minInt48 = -(2n ** (48n - 1n));
const minInt56 = -(2n ** (56n - 1n));
const minInt64 = -(2n ** (64n - 1n));
const minInt72 = -(2n ** (72n - 1n));
const minInt80 = -(2n ** (80n - 1n));
const minInt88 = -(2n ** (88n - 1n));
const minInt96 = -(2n ** (96n - 1n));
const minInt104 = -(2n ** (104n - 1n));
const minInt112 = -(2n ** (112n - 1n));
const minInt120 = -(2n ** (120n - 1n));
const minInt128 = -(2n ** (128n - 1n));
const minInt136 = -(2n ** (136n - 1n));
const minInt144 = -(2n ** (144n - 1n));
const minInt152 = -(2n ** (152n - 1n));
const minInt160 = -(2n ** (160n - 1n));
const minInt168 = -(2n ** (168n - 1n));
const minInt176 = -(2n ** (176n - 1n));
const minInt184 = -(2n ** (184n - 1n));
const minInt192 = -(2n ** (192n - 1n));
const minInt200 = -(2n ** (200n - 1n));
const minInt208 = -(2n ** (208n - 1n));
const minInt216 = -(2n ** (216n - 1n));
const minInt224 = -(2n ** (224n - 1n));
const minInt232 = -(2n ** (232n - 1n));
const minInt240 = -(2n ** (240n - 1n));
const minInt248 = -(2n ** (248n - 1n));
const minInt256 = -(2n ** (256n - 1n));
const maxUint8 = 2n ** 8n - 1n;
const maxUint16 = 2n ** 16n - 1n;
const maxUint24 = 2n ** 24n - 1n;
const maxUint32 = 2n ** 32n - 1n;
const maxUint40 = 2n ** 40n - 1n;
const maxUint48 = 2n ** 48n - 1n;
const maxUint56 = 2n ** 56n - 1n;
const maxUint64 = 2n ** 64n - 1n;
const maxUint72 = 2n ** 72n - 1n;
const maxUint80 = 2n ** 80n - 1n;
const maxUint88 = 2n ** 88n - 1n;
const maxUint96 = 2n ** 96n - 1n;
const maxUint104 = 2n ** 104n - 1n;
const maxUint112 = 2n ** 112n - 1n;
const maxUint120 = 2n ** 120n - 1n;
const maxUint128 = 2n ** 128n - 1n;
const maxUint136 = 2n ** 136n - 1n;
const maxUint144 = 2n ** 144n - 1n;
const maxUint152 = 2n ** 152n - 1n;
const maxUint160 = 2n ** 160n - 1n;
const maxUint168 = 2n ** 168n - 1n;
const maxUint176 = 2n ** 176n - 1n;
const maxUint184 = 2n ** 184n - 1n;
const maxUint192 = 2n ** 192n - 1n;
const maxUint200 = 2n ** 200n - 1n;
const maxUint208 = 2n ** 208n - 1n;
const maxUint216 = 2n ** 216n - 1n;
const maxUint224 = 2n ** 224n - 1n;
const maxUint232 = 2n ** 232n - 1n;
const maxUint240 = 2n ** 240n - 1n;
const maxUint248 = 2n ** 248n - 1n;
const maxUint256 = 2n ** 256n - 1n; //# sourceMappingURL=Solidity.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/abiParameters.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decodeAddress",
    ()=>decodeAddress,
    "decodeArray",
    ()=>decodeArray,
    "decodeBool",
    ()=>decodeBool,
    "decodeBytes",
    ()=>decodeBytes,
    "decodeNumber",
    ()=>decodeNumber,
    "decodeParameter",
    ()=>decodeParameter,
    "decodeString",
    ()=>decodeString,
    "decodeTuple",
    ()=>decodeTuple,
    "encode",
    ()=>encode,
    "encodeAddress",
    ()=>encodeAddress,
    "encodeArray",
    ()=>encodeArray,
    "encodeBoolean",
    ()=>encodeBoolean,
    "encodeBytes",
    ()=>encodeBytes,
    "encodeNumber",
    ()=>encodeNumber,
    "encodeString",
    ()=>encodeString,
    "encodeTuple",
    ()=>encodeTuple,
    "getArrayComponents",
    ()=>getArrayComponents,
    "hasDynamicChild",
    ()=>hasDynamicChild,
    "prepareParameter",
    ()=>prepareParameter,
    "prepareParameters",
    ()=>prepareParameters
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
function decodeParameter(cursor, param, options) {
    const { checksumAddress, staticPosition } = options;
    const arrayComponents = getArrayComponents(param.type);
    if (arrayComponents) {
        const [length, type] = arrayComponents;
        return decodeArray(cursor, {
            ...param,
            type
        }, {
            checksumAddress,
            length,
            staticPosition
        });
    }
    if (param.type === 'tuple') return decodeTuple(cursor, param, {
        checksumAddress,
        staticPosition
    });
    if (param.type === 'address') return decodeAddress(cursor, {
        checksum: checksumAddress
    });
    if (param.type === 'bool') return decodeBool(cursor);
    if (param.type.startsWith('bytes')) return decodeBytes(cursor, param, {
        staticPosition
    });
    if (param.type.startsWith('uint') || param.type.startsWith('int')) return decodeNumber(cursor, param);
    if (param.type === 'string') return decodeString(cursor, {
        staticPosition
    });
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidTypeError"](param.type);
}
const sizeOfLength = 32;
const sizeOfOffset = 32;
function decodeAddress(cursor) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { checksum = false } = options;
    const value = cursor.readBytes(32);
    const wrap = (address)=>checksum ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["checksum"](address) : address;
    return [
        wrap(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](value, -20))),
        32
    ];
}
function decodeArray(cursor, param, options) {
    const { checksumAddress, length, staticPosition } = options;
    // If the length of the array is not known in advance (dynamic array),
    // this means we will need to wonder off to the pointer and decode.
    if (!length) {
        // Dealing with a dynamic type, so get the offset of the array data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfOffset));
        // Start is the static position of current slot + offset.
        const start = staticPosition + offset;
        const startOfData = start + sizeOfLength;
        // Get the length of the array from the offset.
        cursor.setPosition(start);
        const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfLength));
        // Check if the array has any dynamic children.
        const dynamicChild = hasDynamicChild(param);
        let consumed = 0;
        const value = [];
        for(let i = 0; i < length; ++i){
            // If any of the children is dynamic, then all elements will be offset pointer, thus size of one slot (32 bytes).
            // Otherwise, elements will be the size of their encoding (consumed bytes).
            cursor.setPosition(startOfData + (dynamicChild ? i * 32 : consumed));
            const [data, consumed_] = decodeParameter(cursor, param, {
                checksumAddress,
                staticPosition: startOfData
            });
            consumed += consumed_;
            value.push(data);
        }
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    // If the length of the array is known in advance,
    // and the length of an element deeply nested in the array is not known,
    // we need to decode the offset of the array data.
    if (hasDynamicChild(param)) {
        // Dealing with dynamic types, so get the offset of the array data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfOffset));
        // Start is the static position of current slot + offset.
        const start = staticPosition + offset;
        const value = [];
        for(let i = 0; i < length; ++i){
            // Move cursor along to the next slot (next offset pointer).
            cursor.setPosition(start + i * 32);
            const [data] = decodeParameter(cursor, param, {
                checksumAddress,
                staticPosition: start
            });
            value.push(data);
        }
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    // If the length of the array is known in advance and the array is deeply static,
    // then we can just decode each element in sequence.
    let consumed = 0;
    const value = [];
    for(let i = 0; i < length; ++i){
        const [data, consumed_] = decodeParameter(cursor, param, {
            checksumAddress,
            staticPosition: staticPosition + consumed
        });
        consumed += consumed_;
        value.push(data);
    }
    return [
        value,
        consumed
    ];
}
function decodeBool(cursor) {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBoolean"](cursor.readBytes(32), {
            size: 32
        }),
        32
    ];
}
function decodeBytes(cursor, param, param1) {
    let { staticPosition } = param1;
    const [_, size] = param.type.split('bytes');
    if (!size) {
        // Dealing with dynamic types, so get the offset of the bytes data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
        // Set position of the cursor to start of bytes data.
        cursor.setPosition(staticPosition + offset);
        const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
        // If there is no length, we have zero data.
        if (length === 0) {
            // As we have gone wondering, restore to the original position + next slot.
            cursor.setPosition(staticPosition + 32);
            return [
                '0x',
                32
            ];
        }
        const data = cursor.readBytes(length);
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](data),
            32
        ];
    }
    const value = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](cursor.readBytes(Number.parseInt(size, 10), 32));
    return [
        value,
        32
    ];
}
function decodeNumber(cursor, param) {
    const signed = param.type.startsWith('int');
    const size = Number.parseInt(param.type.split('int')[1] || '256', 10);
    const value = cursor.readBytes(32);
    return [
        size > 48 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBigInt"](value, {
            signed
        }) : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](value, {
            signed
        }),
        32
    ];
}
function decodeTuple(cursor, param, options) {
    const { checksumAddress, staticPosition } = options;
    // Tuples can have unnamed components (i.e. they are arrays), so we must
    // determine whether the tuple is named or unnamed. In the case of a named
    // tuple, the value will be an object where each property is the name of the
    // component. In the case of an unnamed tuple, the value will be an array.
    const hasUnnamedChild = param.components.length === 0 || param.components.some((param)=>{
        let { name } = param;
        return !name;
    });
    // Initialize the value to an object or an array, depending on whether the
    // tuple is named or unnamed.
    const value = hasUnnamedChild ? [] : {};
    let consumed = 0;
    // If the tuple has a dynamic child, we must first decode the offset to the
    // tuple data.
    if (hasDynamicChild(param)) {
        // Dealing with dynamic types, so get the offset of the tuple data.
        const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(sizeOfOffset));
        // Start is the static position of referencing slot + offset.
        const start = staticPosition + offset;
        for(let i = 0; i < param.components.length; ++i){
            const component = param.components[i];
            cursor.setPosition(start + consumed);
            const [data, consumed_] = decodeParameter(cursor, component, {
                checksumAddress,
                staticPosition: start
            });
            consumed += consumed_;
            value[hasUnnamedChild ? i : component === null || component === void 0 ? void 0 : component.name] = data;
        }
        // As we have gone wondering, restore to the original position + next slot.
        cursor.setPosition(staticPosition + 32);
        return [
            value,
            32
        ];
    }
    // If the tuple has static children, we can just decode each component
    // in sequence.
    for(let i = 0; i < param.components.length; ++i){
        const component = param.components[i];
        const [data, consumed_] = decodeParameter(cursor, component, {
            checksumAddress,
            staticPosition
        });
        value[hasUnnamedChild ? i : component === null || component === void 0 ? void 0 : component.name] = data;
        consumed += consumed_;
    }
    return [
        value,
        consumed
    ];
}
function decodeString(cursor, param) {
    let { staticPosition } = param;
    // Get offset to start of string data.
    const offset = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
    // Start is the static position of current slot + offset.
    const start = staticPosition + offset;
    cursor.setPosition(start);
    const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](cursor.readBytes(32));
    // If there is no length, we have zero data (empty string).
    if (length === 0) {
        cursor.setPosition(staticPosition + 32);
        return [
            '',
            32
        ];
    }
    const data = cursor.readBytes(length, 32);
    const value = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toString"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimLeft"](data));
    // As we have gone wondering, restore to the original position + next slot.
    cursor.setPosition(staticPosition + 32);
    return [
        value,
        32
    ];
}
function prepareParameters(param) {
    let { checksumAddress, parameters, values } = param;
    const preparedParameters = [];
    for(let i = 0; i < parameters.length; i++){
        preparedParameters.push(prepareParameter({
            checksumAddress,
            parameter: parameters[i],
            value: values[i]
        }));
    }
    return preparedParameters;
}
function prepareParameter(param) {
    let { checksumAddress = false, parameter: parameter_, value } = param;
    const parameter = parameter_;
    const arrayComponents = getArrayComponents(parameter.type);
    if (arrayComponents) {
        const [length, type] = arrayComponents;
        return encodeArray(value, {
            checksumAddress,
            length,
            parameter: {
                ...parameter,
                type
            }
        });
    }
    if (parameter.type === 'tuple') {
        return encodeTuple(value, {
            checksumAddress,
            parameter: parameter
        });
    }
    if (parameter.type === 'address') {
        return encodeAddress(value, {
            checksum: checksumAddress
        });
    }
    if (parameter.type === 'bool') {
        return encodeBoolean(value);
    }
    if (parameter.type.startsWith('uint') || parameter.type.startsWith('int')) {
        const signed = parameter.type.startsWith('int');
        var _integerRegex_exec;
        const [, , size = '256'] = (_integerRegex_exec = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integerRegex"].exec(parameter.type)) !== null && _integerRegex_exec !== void 0 ? _integerRegex_exec : [];
        return encodeNumber(value, {
            signed,
            size: Number(size)
        });
    }
    if (parameter.type.startsWith('bytes')) {
        return encodeBytes(value, {
            type: parameter.type
        });
    }
    if (parameter.type === 'string') {
        return encodeString(value);
    }
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidTypeError"](parameter.type);
}
function encode(preparedParameters) {
    // 1. Compute the size of the static part of the parameters.
    let staticSize = 0;
    for(let i = 0; i < preparedParameters.length; i++){
        const { dynamic, encoded } = preparedParameters[i];
        if (dynamic) staticSize += 32;
        else staticSize += __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](encoded);
    }
    // 2. Split the parameters into static and dynamic parts.
    const staticParameters = [];
    const dynamicParameters = [];
    let dynamicSize = 0;
    for(let i = 0; i < preparedParameters.length; i++){
        const { dynamic, encoded } = preparedParameters[i];
        if (dynamic) {
            staticParameters.push(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](staticSize + dynamicSize, {
                size: 32
            }));
            dynamicParameters.push(encoded);
            dynamicSize += __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](encoded);
        } else {
            staticParameters.push(encoded);
        }
    }
    // 3. Concatenate static and dynamic parts.
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...staticParameters, ...dynamicParameters);
}
function encodeAddress(value, options) {
    const { checksum = false } = options;
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"](value, {
        strict: checksum
    });
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](value.toLowerCase())
    };
}
function encodeArray(value, options) {
    const { checksumAddress, length, parameter } = options;
    const dynamic = length === null;
    if (!Array.isArray(value)) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidArrayError"](value);
    if (!dynamic && value.length !== length) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ArrayLengthMismatchError"]({
        expectedLength: length,
        givenLength: value.length,
        type: "".concat(parameter.type, "[").concat(length, "]")
    });
    let dynamicChild = false;
    const preparedParameters = [];
    for(let i = 0; i < value.length; i++){
        const preparedParam = prepareParameter({
            checksumAddress,
            parameter,
            value: value[i]
        });
        if (preparedParam.dynamic) dynamicChild = true;
        preparedParameters.push(preparedParam);
    }
    if (dynamic || dynamicChild) {
        const data = encode(preparedParameters);
        if (dynamic) {
            const length = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](preparedParameters.length, {
                size: 32
            });
            return {
                dynamic: true,
                encoded: preparedParameters.length > 0 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](length, data) : length
            };
        }
        if (dynamicChild) return {
            dynamic: true,
            encoded: data
        };
    }
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...preparedParameters.map((param)=>{
            let { encoded } = param;
            return encoded;
        }))
    };
}
function encodeBytes(value, param) {
    let { type } = param;
    const [, parametersize] = type.split('bytes');
    const bytesSize = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value);
    if (!parametersize) {
        let value_ = value;
        // If the size is not divisible by 32 bytes, pad the end
        // with empty bytes to the ceiling 32 bytes.
        if (bytesSize % 32 !== 0) value_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value_, Math.ceil((value.length - 2) / 2 / 32) * 32);
        return {
            dynamic: true,
            encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](bytesSize, {
                size: 32
            })), value_)
        };
    }
    if (bytesSize !== Number.parseInt(parametersize, 10)) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BytesSizeMismatchError"]({
        expectedSize: Number.parseInt(parametersize, 10),
        value
    });
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value)
    };
}
function encodeBoolean(value) {
    if (typeof value !== 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Invalid boolean value: "'.concat(value, '" (type: ').concat(typeof value, "). Expected: `true` or `false`."));
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBoolean"](value))
    };
}
function encodeNumber(value, param) {
    let { signed, size } = param;
    if (typeof size === 'number') {
        const max = 2n ** (BigInt(size) - (signed ? 1n : 0n)) - 1n;
        const min = signed ? -max - 1n : 0n;
        if (value > max || value < min) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["IntegerOutOfRangeError"]({
            max: max.toString(),
            min: min.toString(),
            signed,
            size: size / 8,
            value: value.toString()
        });
    }
    return {
        dynamic: false,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](value, {
            size: 32,
            signed
        })
    };
}
function encodeString(value) {
    const hexValue = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](value);
    const partsLength = Math.ceil(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](hexValue) / 32);
    const parts = [];
    for(let i = 0; i < partsLength; i++){
        parts.push(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](hexValue, i * 32, (i + 1) * 32)));
    }
    return {
        dynamic: true,
        encoded: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](hexValue), {
            size: 32
        })), ...parts)
    };
}
function encodeTuple(value, options) {
    const { checksumAddress, parameter } = options;
    let dynamic = false;
    const preparedParameters = [];
    for(let i = 0; i < parameter.components.length; i++){
        const param_ = parameter.components[i];
        const index = Array.isArray(value) ? i : param_.name;
        const preparedParam = prepareParameter({
            checksumAddress,
            parameter: param_,
            value: value[index]
        });
        preparedParameters.push(preparedParam);
        if (preparedParam.dynamic) dynamic = true;
    }
    return {
        dynamic,
        encoded: dynamic ? encode(preparedParameters) : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...preparedParameters.map((param)=>{
            let { encoded } = param;
            return encoded;
        }))
    };
}
function getArrayComponents(type) {
    const matches = type.match(/^(.*)\[(\d+)?\]$/);
    return matches ? [
        matches[2] ? Number(matches[2]) : null,
        matches[1]
    ] : undefined;
}
function hasDynamicChild(param) {
    var _param_components;
    const { type } = param;
    if (type === 'string') return true;
    if (type === 'bytes') return true;
    if (type.endsWith('[]')) return true;
    if (type === 'tuple') return (_param_components = param.components) === null || _param_components === void 0 ? void 0 : _param_components.some(hasDynamicChild);
    const arrayComponents = getArrayComponents(param.type);
    if (arrayComponents && hasDynamicChild({
        ...param,
        type: arrayComponents[1]
    })) return true;
    return false;
} //# sourceMappingURL=abiParameters.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/cursor.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "NegativeOffsetError",
    ()=>NegativeOffsetError,
    "PositionOutOfBoundsError",
    ()=>PositionOutOfBoundsError,
    "RecursiveReadLimitExceededError",
    ()=>RecursiveReadLimitExceededError,
    "create",
    ()=>create
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
;
const staticCursor = {
    bytes: new Uint8Array(),
    dataView: new DataView(new ArrayBuffer(0)),
    position: 0,
    positionReadCount: new Map(),
    recursiveReadCount: 0,
    recursiveReadLimit: Number.POSITIVE_INFINITY,
    assertReadLimit () {
        if (this.recursiveReadCount >= this.recursiveReadLimit) throw new RecursiveReadLimitExceededError({
            count: this.recursiveReadCount + 1,
            limit: this.recursiveReadLimit
        });
    },
    assertPosition (position) {
        if (position < 0 || position > this.bytes.length - 1) throw new PositionOutOfBoundsError({
            length: this.bytes.length,
            position
        });
    },
    decrementPosition (offset) {
        if (offset < 0) throw new NegativeOffsetError({
            offset
        });
        const position = this.position - offset;
        this.assertPosition(position);
        this.position = position;
    },
    getReadCount (position) {
        return this.positionReadCount.get(position || this.position) || 0;
    },
    incrementPosition (offset) {
        if (offset < 0) throw new NegativeOffsetError({
            offset
        });
        const position = this.position + offset;
        this.assertPosition(position);
        this.position = position;
    },
    inspectByte (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position);
        return this.bytes[position];
    },
    inspectBytes (length, position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + length - 1);
        return this.bytes.subarray(position, position + length);
    },
    inspectUint8 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position);
        return this.bytes[position];
    },
    inspectUint16 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 1);
        return this.dataView.getUint16(position);
    },
    inspectUint24 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 2);
        return (this.dataView.getUint16(position) << 8) + this.dataView.getUint8(position + 2);
    },
    inspectUint32 (position_) {
        const position = position_ !== null && position_ !== void 0 ? position_ : this.position;
        this.assertPosition(position + 3);
        return this.dataView.getUint32(position);
    },
    pushByte (byte) {
        this.assertPosition(this.position);
        this.bytes[this.position] = byte;
        this.position++;
    },
    pushBytes (bytes) {
        this.assertPosition(this.position + bytes.length - 1);
        this.bytes.set(bytes, this.position);
        this.position += bytes.length;
    },
    pushUint8 (value) {
        this.assertPosition(this.position);
        this.bytes[this.position] = value;
        this.position++;
    },
    pushUint16 (value) {
        this.assertPosition(this.position + 1);
        this.dataView.setUint16(this.position, value);
        this.position += 2;
    },
    pushUint24 (value) {
        this.assertPosition(this.position + 2);
        this.dataView.setUint16(this.position, value >> 8);
        this.dataView.setUint8(this.position + 2, value & ~4294967040);
        this.position += 3;
    },
    pushUint32 (value) {
        this.assertPosition(this.position + 3);
        this.dataView.setUint32(this.position, value);
        this.position += 4;
    },
    readByte () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectByte();
        this.position++;
        return value;
    },
    readBytes (length, size) {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectBytes(length);
        this.position += size !== null && size !== void 0 ? size : length;
        return value;
    },
    readUint8 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint8();
        this.position += 1;
        return value;
    },
    readUint16 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint16();
        this.position += 2;
        return value;
    },
    readUint24 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint24();
        this.position += 3;
        return value;
    },
    readUint32 () {
        this.assertReadLimit();
        this._touch();
        const value = this.inspectUint32();
        this.position += 4;
        return value;
    },
    get remaining () {
        return this.bytes.length - this.position;
    },
    setPosition (position) {
        const oldPosition = this.position;
        this.assertPosition(position);
        this.position = position;
        return ()=>this.position = oldPosition;
    },
    _touch () {
        if (this.recursiveReadLimit === Number.POSITIVE_INFINITY) return;
        const count = this.getReadCount();
        this.positionReadCount.set(this.position, count + 1);
        if (count > 0) this.recursiveReadCount++;
    }
};
function create(bytes) {
    let { recursiveReadLimit = 8_192 } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const cursor = Object.create(staticCursor);
    cursor.bytes = bytes;
    cursor.dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
    cursor.positionReadCount = new Map();
    cursor.recursiveReadLimit = recursiveReadLimit;
    return cursor;
}
class NegativeOffsetError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ offset }){
        super("Offset `".concat(offset, "` cannot be negative."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Cursor.NegativeOffsetError'
        });
    }
}
class PositionOutOfBoundsError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ length, position }){
        super("Position `".concat(position, "` is out of bounds (`0 < position < ").concat(length, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Cursor.PositionOutOfBoundsError'
        });
    }
}
class RecursiveReadLimitExceededError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ count, limit }){
        super("Recursive read limit of `".concat(limit, "` exceeded (recursive read count: `").concat(count, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Cursor.RecursiveReadLimitExceededError'
        });
    }
} //# sourceMappingURL=cursor.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ArrayLengthMismatchError",
    ()=>ArrayLengthMismatchError,
    "BytesSizeMismatchError",
    ()=>BytesSizeMismatchError,
    "DataSizeTooSmallError",
    ()=>DataSizeTooSmallError,
    "InvalidArrayError",
    ()=>InvalidArrayError,
    "InvalidTypeError",
    ()=>InvalidTypeError,
    "LengthMismatchError",
    ()=>LengthMismatchError,
    "ZeroDataError",
    ()=>ZeroDataError,
    "decode",
    ()=>decode,
    "encode",
    ()=>encode,
    "encodePacked",
    ()=>encodePacked,
    "format",
    ()=>format,
    "from",
    ()=>from
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/esm/human-readable/formatAbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/esm/human-readable/parseAbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/abiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/cursor.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
;
function decode(parameters, data) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    const { as = 'Array', checksumAddress = false } = options;
    const bytes = typeof data === 'string' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](data) : data;
    const cursor = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"](bytes);
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) === 0 && parameters.length > 0) throw new ZeroDataError();
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) < 32) throw new DataSizeTooSmallError({
        data: typeof data === 'string' ? data : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](data),
        parameters: parameters,
        size: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes)
    });
    let consumed = 0;
    const values = as === 'Array' ? [] : {};
    for(let i = 0; i < parameters.length; ++i){
        const param = parameters[i];
        cursor.setPosition(consumed);
        const [data, consumed_] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decodeParameter"](cursor, param, {
            checksumAddress,
            staticPosition: 0
        });
        consumed += consumed_;
        var _param_name;
        if (as === 'Array') values.push(data);
        else values[(_param_name = param.name) !== null && _param_name !== void 0 ? _param_name : i] = data;
    }
    return values;
}
function encode(parameters, values, options) {
    const { checksumAddress = false } = options !== null && options !== void 0 ? options : {};
    if (parameters.length !== values.length) throw new LengthMismatchError({
        expectedLength: parameters.length,
        givenLength: values.length
    });
    // Prepare the parameters to determine dynamic types to encode.
    const preparedParameters = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["prepareParameters"]({
        checksumAddress,
        parameters: parameters,
        values: values
    });
    const data = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](preparedParameters);
    if (data.length === 0) return '0x';
    return data;
}
function encodePacked(types, values) {
    if (types.length !== values.length) throw new LengthMismatchError({
        expectedLength: types.length,
        givenLength: values.length
    });
    const data = [];
    for(let i = 0; i < types.length; i++){
        const type = types[i];
        const value = values[i];
        data.push(encodePacked.encode(type, value));
    }
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...data);
}
(function(encodePacked) {
    // eslint-disable-next-line jsdoc/require-jsdoc
    function encode(type, value) {
        let isArray = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
        if (type === 'address') {
            const address = value;
            __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"](address);
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](address.toLowerCase(), isArray ? 32 : 0);
        }
        if (type === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](value);
        if (type === 'bytes') return value;
        if (type === 'bool') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBoolean"](value), isArray ? 32 : 1);
        const intMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integerRegex"]);
        if (intMatch) {
            const [_type, baseType, bits = '256'] = intMatch;
            const size = Number.parseInt(bits, 10) / 8;
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](value, {
                size: isArray ? 32 : size,
                signed: baseType === 'int'
            });
        }
        const bytesMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["bytesRegex"]);
        if (bytesMatch) {
            const [_type, size] = bytesMatch;
            if (Number.parseInt(size, 10) !== (value.length - 2) / 2) throw new BytesSizeMismatchError({
                expectedSize: Number.parseInt(size, 10),
                value: value
            });
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value, isArray ? 32 : 0);
        }
        const arrayMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arrayRegex"]);
        if (arrayMatch && Array.isArray(value)) {
            const [_type, childType] = arrayMatch;
            const data = [];
            for(let i = 0; i < value.length; i++){
                data.push(encode(childType, value[i], true));
            }
            if (data.length === 0) return '0x';
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](...data);
        }
        throw new InvalidTypeError(type);
    }
    encodePacked.encode = encode;
})(encodePacked || (encodePacked = {}));
function format(parameters) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiParameters"](parameters);
}
function from(parameters) {
    if (Array.isArray(parameters) && typeof parameters[0] === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiParameters"](parameters);
    if (typeof parameters === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiParameters"](parameters);
    return parameters;
}
class DataSizeTooSmallError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ data, parameters, size }){
        super("Data size of ".concat(size, " bytes is too small for given parameters."), {
            metaMessages: [
                "Params: (".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiParameters"](parameters), ")"),
                "Data:   ".concat(data, " (").concat(size, " bytes)")
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.DataSizeTooSmallError'
        });
    }
}
class ZeroDataError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(){
        super('Cannot decode zero data ("0x") with ABI parameters.');
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.ZeroDataError'
        });
    }
}
class ArrayLengthMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedLength, givenLength, type }){
        super("Array length mismatch for type `".concat(type, "`. Expected: `").concat(expectedLength, "`. Given: `").concat(givenLength, "`."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.ArrayLengthMismatchError'
        });
    }
}
class BytesSizeMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedSize, value }){
        super('Size of bytes "'.concat(value, '" (bytes').concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value), ") does not match expected size (bytes").concat(expectedSize, ")."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.BytesSizeMismatchError'
        });
    }
}
class LengthMismatchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ expectedLength, givenLength }){
        super([
            'ABI encoding parameters/values length mismatch.',
            "Expected length (parameters): ".concat(expectedLength),
            "Given length (values): ".concat(givenLength)
        ].join('\n'));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.LengthMismatchError'
        });
    }
}
class InvalidArrayError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(value){
        super("Value `".concat(value, "` is not a valid array."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.InvalidArrayError'
        });
    }
}
class InvalidTypeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(type){
        super("Type `".concat(type, "` is not a valid ABI Type."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiParameters.InvalidTypeError'
        });
    }
} //# sourceMappingURL=AbiParameters.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/abiItem.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getAmbiguousTypes",
    ()=>getAmbiguousTypes,
    "isArgOfType",
    ()=>isArgOfType,
    "normalizeSignature",
    ()=>normalizeSignature
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
;
;
function normalizeSignature(signature) {
    let active = true;
    let current = '';
    let level = 0;
    let result = '';
    let valid = false;
    for(let i = 0; i < signature.length; i++){
        const char = signature[i];
        // If the character is a separator, we want to reactivate.
        if ([
            '(',
            ')',
            ','
        ].includes(char)) active = true;
        // If the character is a "level" token, we want to increment/decrement.
        if (char === '(') level++;
        if (char === ')') level--;
        // If we aren't active, we don't want to mutate the result.
        if (!active) continue;
        // If level === 0, we are at the definition level.
        if (level === 0) {
            if (char === ' ' && [
                'event',
                'function',
                'error',
                ''
            ].includes(result)) result = '';
            else {
                result += char;
                // If we are at the end of the definition, we must be finished.
                if (char === ')') {
                    valid = true;
                    break;
                }
            }
            continue;
        }
        // Ignore spaces
        if (char === ' ') {
            // If the previous character is a separator, and the current section isn't empty, we want to deactivate.
            if (signature[i - 1] !== ',' && current !== ',' && current !== ',(') {
                current = '';
                active = false;
            }
            continue;
        }
        result += char;
        current += char;
    }
    if (!valid) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Unable to normalize signature.');
    return result;
}
function isArgOfType(arg, abiParameter) {
    const argType = typeof arg;
    const abiParameterType = abiParameter.type;
    switch(abiParameterType){
        case 'address':
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](arg, {
                strict: false
            });
        case 'bool':
            return argType === 'boolean';
        case 'function':
            return argType === 'string';
        case 'string':
            return argType === 'string';
        default:
            {
                if (abiParameterType === 'tuple' && 'components' in abiParameter) return Object.values(abiParameter.components).every((component, index)=>{
                    return isArgOfType(Object.values(arg)[index], component);
                });
                // `(u)int<M>`: (un)signed integer type of `M` bits, `0 < M <= 256`, `M % 8 == 0`
                // https://regexr.com/6v8hp
                if (/^u?int(8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?$/.test(abiParameterType)) return argType === 'number' || argType === 'bigint';
                // `bytes<M>`: binary type of `M` bytes, `0 < M <= 32`
                // https://regexr.com/6va55
                if (/^bytes([1-9]|1[0-9]|2[0-9]|3[0-2])?$/.test(abiParameterType)) return argType === 'string' || arg instanceof Uint8Array;
                // fixed-length (`<type>[M]`) and dynamic (`<type>[]`) arrays
                // https://regexr.com/6va6i
                if (/[a-z]+[1-9]{0,3}(\[[0-9]{0,}\])+$/.test(abiParameterType)) {
                    return Array.isArray(arg) && arg.every((x)=>isArgOfType(x, {
                            ...abiParameter,
                            // Pop off `[]` or `[M]` from end of type
                            type: abiParameterType.replace(/(\[[0-9]{0,}\])$/, '')
                        }));
                }
                return false;
            }
    }
}
function getAmbiguousTypes(sourceParameters, targetParameters, args) {
    for(const parameterIndex in sourceParameters){
        const sourceParameter = sourceParameters[parameterIndex];
        const targetParameter = targetParameters[parameterIndex];
        if (sourceParameter.type === 'tuple' && targetParameter.type === 'tuple' && 'components' in sourceParameter && 'components' in targetParameter) return getAmbiguousTypes(sourceParameter.components, targetParameter.components, args[parameterIndex]);
        const types = [
            sourceParameter.type,
            targetParameter.type
        ];
        const ambiguous = (()=>{
            if (types.includes('address') && types.includes('bytes20')) return true;
            if (types.includes('address') && types.includes('string')) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](args[parameterIndex], {
                strict: false
            });
            if (types.includes('address') && types.includes('bytes')) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](args[parameterIndex], {
                strict: false
            });
            return false;
        })();
        if (ambiguous) return types;
    }
    return;
} //# sourceMappingURL=abiItem.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiItem.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AmbiguityError",
    ()=>AmbiguityError,
    "InvalidSelectorSizeError",
    ()=>InvalidSelectorSizeError,
    "NotFoundError",
    ()=>NotFoundError,
    "format",
    ()=>format,
    "from",
    ()=>from,
    "fromAbi",
    ()=>fromAbi,
    "getSelector",
    ()=>getSelector,
    "getSignature",
    ()=>getSignature,
    "getSignatureHash",
    ()=>getSignatureHash
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/esm/human-readable/formatAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/esm/human-readable/parseAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/abiItem.js [app-client] (ecmascript)");
;
;
;
;
;
function format(abiItem) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiItem);
}
function from(abiItem) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { prepare = true } = options;
    const item = (()=>{
        if (Array.isArray(abiItem)) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiItem"](abiItem);
        if (typeof abiItem === 'string') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$parseAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["parseAbiItem"](abiItem);
        return abiItem;
    })();
    return {
        ...item,
        ...prepare ? {
            hash: getSignatureHash(item)
        } : {}
    };
}
function fromAbi(abi, name, options) {
    const { args = [], prepare = true } = options !== null && options !== void 0 ? options : {};
    const isSelector = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](name, {
        strict: false
    });
    const abiItems = abi.filter((abiItem)=>{
        if (isSelector) {
            if (abiItem.type === 'function' || abiItem.type === 'error') return getSelector(abiItem) === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](name, 0, 4);
            if (abiItem.type === 'event') return getSignatureHash(abiItem) === name;
            return false;
        }
        return 'name' in abiItem && abiItem.name === name;
    });
    if (abiItems.length === 0) throw new NotFoundError({
        name: name
    });
    if (abiItems.length === 1) return {
        ...abiItems[0],
        ...prepare ? {
            hash: getSignatureHash(abiItems[0])
        } : {}
    };
    let matchedAbiItem;
    for (const abiItem of abiItems){
        if (!('inputs' in abiItem)) continue;
        if (!args || args.length === 0) {
            if (!abiItem.inputs || abiItem.inputs.length === 0) return {
                ...abiItem,
                ...prepare ? {
                    hash: getSignatureHash(abiItem)
                } : {}
            };
            continue;
        }
        if (!abiItem.inputs) continue;
        if (abiItem.inputs.length === 0) continue;
        if (abiItem.inputs.length !== args.length) continue;
        const matched = args.every((arg, index)=>{
            const abiParameter = 'inputs' in abiItem && abiItem.inputs[index];
            if (!abiParameter) return false;
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isArgOfType"](arg, abiParameter);
        });
        if (matched) {
            // Check for ambiguity against already matched parameters (e.g. `address` vs `bytes20`).
            if (matchedAbiItem && 'inputs' in matchedAbiItem && matchedAbiItem.inputs) {
                const ambiguousTypes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAmbiguousTypes"](abiItem.inputs, matchedAbiItem.inputs, args);
                if (ambiguousTypes) throw new AmbiguityError({
                    abiItem,
                    type: ambiguousTypes[0]
                }, {
                    abiItem: matchedAbiItem,
                    type: ambiguousTypes[1]
                });
            }
            matchedAbiItem = abiItem;
        }
    }
    const abiItem = (()=>{
        if (matchedAbiItem) return matchedAbiItem;
        const [abiItem, ...overloads] = abiItems;
        return {
            ...abiItem,
            overloads
        };
    })();
    if (!abiItem) throw new NotFoundError({
        name: name
    });
    return {
        ...abiItem,
        ...prepare ? {
            hash: getSignatureHash(abiItem)
        } : {}
    };
}
function getSelector() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const abiItem = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name] = parameters;
            return fromAbi(abi, name);
        }
        return parameters[0];
    })();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](getSignatureHash(abiItem), 0, 4);
}
function getSignature() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const abiItem = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name] = parameters;
            return fromAbi(abi, name);
        }
        return parameters[0];
    })();
    const signature = (()=>{
        if (typeof abiItem === 'string') return abiItem;
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiItem);
    })();
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["normalizeSignature"](signature);
}
function getSignatureHash() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const abiItem = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name] = parameters;
            return fromAbi(abi, name);
        }
        return parameters[0];
    })();
    if (typeof abiItem !== 'string' && 'hash' in abiItem && abiItem.hash) return abiItem.hash;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromString"](getSignature(abiItem)));
}
class AmbiguityError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(x, y){
        super('Found ambiguous types in overloaded ABI Items.', {
            metaMessages: [
                // TODO: abitype to add support for signature-formatted ABI items.
                "`".concat(x.type, "` in `").concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["normalizeSignature"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](x.abiItem)), "`, and"),
                "`".concat(y.type, "` in `").concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$abiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["normalizeSignature"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](y.abiItem)), "`"),
                '',
                'These types encode differently and cannot be distinguished at runtime.',
                'Remove one of the ambiguous items in the ABI.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiItem.AmbiguityError'
        });
    }
}
class NotFoundError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ name, data, type = 'item' }){
        const selector = (()=>{
            if (name) return ' with name "'.concat(name, '"');
            if (data) return ' with data "'.concat(data, '"');
            return '';
        })();
        super("ABI ".concat(type).concat(selector, " not found."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiItem.NotFoundError'
        });
    }
}
class InvalidSelectorSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ data }){
        super("Selector size is invalid. Expected 4 bytes. Received ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](data), ' bytes ("').concat(data, '").'));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'AbiItem.InvalidSelectorSizeError'
        });
    }
} //# sourceMappingURL=AbiItem.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiError.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decode",
    ()=>decode,
    "encode",
    ()=>encode,
    "format",
    ()=>format,
    "from",
    ()=>from,
    "fromAbi",
    ()=>fromAbi,
    "getSelector",
    ()=>getSelector,
    "panicReasons",
    ()=>panicReasons,
    "solidityError",
    ()=>solidityError,
    "solidityErrorSelector",
    ()=>solidityErrorSelector,
    "solidityPanic",
    ()=>solidityPanic,
    "solidityPanicSelector",
    ()=>solidityPanicSelector
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/abitype@1.1.0_typescript@5.9.3_zod@3.24.1/node_modules/abitype/dist/esm/human-readable/formatAbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiItem.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
;
;
function decode() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiError, data, options = {}] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, data, options] = parameters;
            return [
                fromAbi(abi, name),
                data,
                options
            ];
        }
        return parameters;
    })();
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](data) < 4) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidSelectorSizeError"]({
        data
    });
    if (abiError.inputs.length === 0) return undefined;
    const values = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](abiError.inputs, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](data, 4), options);
    if (values && Object.keys(values).length === 1) {
        if (Array.isArray(values)) return values[0];
        return Object.values(values)[0];
    }
    return values;
}
function encode() {
    for(var _len = arguments.length, parameters = new Array(_len), _key = 0; _key < _len; _key++){
        parameters[_key] = arguments[_key];
    }
    const [abiError, args] = (()=>{
        if (Array.isArray(parameters[0])) {
            const [abi, name, ...args] = parameters;
            return [
                fromAbi(abi, name),
                args
            ];
        }
        const [abiError, ...args] = parameters;
        return [
            abiError,
            args
        ];
    })();
    const selector = getSelector(abiError);
    const data = args.length > 0 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](abiError.inputs, args[0]) : undefined;
    return data ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](selector, data) : selector;
}
function format(abiError) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$abitype$40$1$2e$1$2e$0_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$abitype$2f$dist$2f$esm$2f$human$2d$readable$2f$formatAbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["formatAbiItem"](abiError);
}
function from(abiError) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](abiError, options);
}
function fromAbi(abi, name, options) {
    if (name === 'Error') return solidityError;
    if (name === 'Panic') return solidityPanic;
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["validate"](name, {
        strict: false
    })) {
        const selector = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](name, 0, 4);
        if (selector === solidityErrorSelector) return solidityError;
        if (selector === solidityPanicSelector) return solidityPanic;
    }
    const item = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromAbi"](abi, name, options);
    if (item.type !== 'error') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["NotFoundError"]({
        name,
        type: 'error'
    });
    return item;
}
function getSelector(abiItem) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiItem$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getSelector"](abiItem);
}
const panicReasons = {
    1: 'An `assert` condition failed.',
    17: 'Arithmetic operation resulted in underflow or overflow.',
    18: 'Division or modulo by zero (e.g. `5 / 0` or `23 % 0`).',
    33: 'Attempted to convert to an invalid type.',
    34: 'Attempted to access a storage byte array that is incorrectly encoded.',
    49: 'Performed `.pop()` on an empty array',
    50: 'Array index is out of bounds.',
    65: 'Allocated too much memory or created an array which is too large.',
    81: 'Attempted to call a zero-initialized variable of internal function type.'
};
const solidityError = /*#__PURE__*/ from({
    inputs: [
        {
            name: 'message',
            type: 'string'
        }
    ],
    name: 'Error',
    type: 'error'
});
const solidityErrorSelector = '0x08c379a0';
const solidityPanic = /*#__PURE__*/ from({
    inputs: [
        {
            name: 'reason',
            type: 'uint8'
        }
    ],
    name: 'Panic',
    type: 'error'
});
const solidityPanicSelector = '0x4e487b71'; //# sourceMappingURL=AbiError.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/erc6492/SignatureErc6492.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidWrappedSignatureError",
    ()=>InvalidWrappedSignatureError,
    "assert",
    ()=>assert,
    "from",
    ()=>from,
    "magicBytes",
    ()=>magicBytes,
    "universalSignatureValidatorAbi",
    ()=>universalSignatureValidatorAbi,
    "universalSignatureValidatorBytecode",
    ()=>universalSignatureValidatorBytecode,
    "unwrap",
    ()=>unwrap,
    "validate",
    ()=>validate,
    "wrap",
    ()=>wrap
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
;
;
const magicBytes = '0x6492649264926492649264926492649264926492649264926492649264926492';
const universalSignatureValidatorBytecode = '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';
const universalSignatureValidatorAbi = [
    {
        inputs: [
            {
                name: '_signer',
                type: 'address'
            },
            {
                name: '_hash',
                type: 'bytes32'
            },
            {
                name: '_signature',
                type: 'bytes'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'constructor'
    },
    {
        inputs: [
            {
                name: '_signer',
                type: 'address'
            },
            {
                name: '_hash',
                type: 'bytes32'
            },
            {
                name: '_signature',
                type: 'bytes'
            }
        ],
        outputs: [
            {
                type: 'bool'
            }
        ],
        stateMutability: 'nonpayable',
        type: 'function',
        name: 'isValidSig'
    }
];
function assert(wrapped) {
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, -32) !== magicBytes) throw new InvalidWrappedSignatureError(wrapped);
}
function from(wrapped) {
    if (typeof wrapped === 'string') return unwrap(wrapped);
    return wrapped;
}
function unwrap(wrapped) {
    assert(wrapped);
    const [to, data, signature] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"]('address, bytes, bytes'), wrapped);
    return {
        data,
        signature,
        to
    };
}
function wrap(value) {
    const { data, signature, to } = value;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"]('address, bytes, bytes'), [
        to,
        data,
        signature
    ]), magicBytes);
}
function validate(wrapped) {
    try {
        assert(wrapped);
        return true;
    } catch (e) {
        return false;
    }
}
class InvalidWrappedSignatureError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(wrapped){
        super("Value `".concat(wrapped, "` is an invalid ERC-6492 wrapped signature."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'SignatureErc6492.InvalidWrappedSignatureError'
        });
    }
} //# sourceMappingURL=SignatureErc6492.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/erc6492/SignatureErc6492.js [app-client] (ecmascript) <export * as SignatureErc6492>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "SignatureErc6492",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$erc6492$2f$SignatureErc6492$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$erc6492$2f$SignatureErc6492$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/erc6492/SignatureErc6492.js [app-client] (ecmascript)");
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Rlp.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decodeRlpCursor",
    ()=>decodeRlpCursor,
    "from",
    ()=>from,
    "fromBytes",
    ()=>fromBytes,
    "fromHex",
    ()=>fromHex,
    "readLength",
    ()=>readLength,
    "readList",
    ()=>readList,
    "to",
    ()=>to,
    "toBytes",
    ()=>toBytes,
    "toHex",
    ()=>toHex
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/cursor.js [app-client] (ecmascript)");
;
;
;
;
function toBytes(value) {
    return to(value, 'Bytes');
}
function toHex(value) {
    return to(value, 'Hex');
}
function to(value, to) {
    const to_ = to !== null && to !== void 0 ? to : typeof value === 'string' ? 'Hex' : 'Bytes';
    const bytes = (()=>{
        if (typeof value === 'string') {
            if (value.length > 3 && value.length % 2 !== 0) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidLengthError"](value);
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](value);
        }
        return value;
    })();
    const cursor = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"](bytes, {
        recursiveReadLimit: Number.POSITIVE_INFINITY
    });
    const result = decodeRlpCursor(cursor, to_);
    return result;
}
function decodeRlpCursor(cursor) {
    let to = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'Hex';
    if (cursor.bytes.length === 0) return to === 'Hex' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](cursor.bytes) : cursor.bytes;
    const prefix = cursor.readByte();
    if (prefix < 0x80) cursor.decrementPosition(1);
    // bytes
    if (prefix < 0xc0) {
        const length = readLength(cursor, prefix, 0x80);
        const bytes = cursor.readBytes(length);
        return to === 'Hex' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes) : bytes;
    }
    // list
    const length = readLength(cursor, prefix, 0xc0);
    return readList(cursor, length, to);
}
function readLength(cursor, prefix, offset) {
    if (offset === 0x80 && prefix < 0x80) return 1;
    if (prefix <= offset + 55) return prefix - offset;
    if (prefix === offset + 55 + 1) return cursor.readUint8();
    if (prefix === offset + 55 + 2) return cursor.readUint16();
    if (prefix === offset + 55 + 3) return cursor.readUint24();
    if (prefix === offset + 55 + 4) return cursor.readUint32();
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Invalid RLP prefix');
}
function readList(cursor, length, to) {
    const position = cursor.position;
    const value = [];
    while(cursor.position - position < length)value.push(decodeRlpCursor(cursor, to));
    return value;
}
function from(value, options) {
    const { as } = options;
    const encodable = getEncodable(value);
    const cursor = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$cursor$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"](new Uint8Array(encodable.length));
    encodable.encode(cursor);
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](cursor.bytes);
    return cursor.bytes;
}
function fromBytes(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = 'Bytes' } = options;
    return from(bytes, {
        as
    });
}
function fromHex(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { as = 'Hex' } = options;
    return from(hex, {
        as
    });
}
/////////////////////////////////////////////////////////////////////////////////
// Internal
/////////////////////////////////////////////////////////////////////////////////
function getEncodable(bytes) {
    if (Array.isArray(bytes)) return getEncodableList(bytes.map((x)=>getEncodable(x)));
    return getEncodableBytes(bytes);
}
function getEncodableList(list) {
    const bodyLength = list.reduce((acc, x)=>acc + x.length, 0);
    const sizeOfBodyLength = getSizeOfLength(bodyLength);
    const length = (()=>{
        if (bodyLength <= 55) return 1 + bodyLength;
        return 1 + sizeOfBodyLength + bodyLength;
    })();
    return {
        length,
        encode (cursor) {
            if (bodyLength <= 55) {
                cursor.pushByte(0xc0 + bodyLength);
            } else {
                cursor.pushByte(0xc0 + 55 + sizeOfBodyLength);
                if (sizeOfBodyLength === 1) cursor.pushUint8(bodyLength);
                else if (sizeOfBodyLength === 2) cursor.pushUint16(bodyLength);
                else if (sizeOfBodyLength === 3) cursor.pushUint24(bodyLength);
                else cursor.pushUint32(bodyLength);
            }
            for (const { encode } of list){
                encode(cursor);
            }
        }
    };
}
function getEncodableBytes(bytesOrHex) {
    const bytes = typeof bytesOrHex === 'string' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](bytesOrHex) : bytesOrHex;
    const sizeOfBytesLength = getSizeOfLength(bytes.length);
    const length = (()=>{
        if (bytes.length === 1 && bytes[0] < 0x80) return 1;
        if (bytes.length <= 55) return 1 + bytes.length;
        return 1 + sizeOfBytesLength + bytes.length;
    })();
    return {
        length,
        encode (cursor) {
            if (bytes.length === 1 && bytes[0] < 0x80) {
                cursor.pushBytes(bytes);
            } else if (bytes.length <= 55) {
                cursor.pushByte(0x80 + bytes.length);
                cursor.pushBytes(bytes);
            } else {
                cursor.pushByte(0x80 + 55 + sizeOfBytesLength);
                if (sizeOfBytesLength === 1) cursor.pushUint8(bytes.length);
                else if (sizeOfBytesLength === 2) cursor.pushUint16(bytes.length);
                else if (sizeOfBytesLength === 3) cursor.pushUint24(bytes.length);
                else cursor.pushUint32(bytes.length);
                cursor.pushBytes(bytes);
            }
        }
    };
}
function getSizeOfLength(length) {
    if (length < 2 ** 8) return 1;
    if (length < 2 ** 16) return 2;
    if (length < 2 ** 24) return 3;
    if (length < 2 ** 32) return 4;
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Length is too large.');
} //# sourceMappingURL=Rlp.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Signature.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidRError",
    ()=>InvalidRError,
    "InvalidSError",
    ()=>InvalidSError,
    "InvalidSerializedSizeError",
    ()=>InvalidSerializedSizeError,
    "InvalidVError",
    ()=>InvalidVError,
    "InvalidYParityError",
    ()=>InvalidYParityError,
    "MissingPropertiesError",
    ()=>MissingPropertiesError,
    "assert",
    ()=>assert,
    "extract",
    ()=>extract,
    "from",
    ()=>from,
    "fromBytes",
    ()=>fromBytes,
    "fromDerBytes",
    ()=>fromDerBytes,
    "fromDerHex",
    ()=>fromDerHex,
    "fromHex",
    ()=>fromHex,
    "fromLegacy",
    ()=>fromLegacy,
    "fromRpc",
    ()=>fromRpc,
    "fromTuple",
    ()=>fromTuple,
    "toBytes",
    ()=>toBytes,
    "toDerBytes",
    ()=>toDerBytes,
    "toDerHex",
    ()=>toDerHex,
    "toHex",
    ()=>toHex,
    "toLegacy",
    ()=>toLegacy,
    "toRpc",
    ()=>toRpc,
    "toTuple",
    ()=>toTuple,
    "vToYParity",
    ()=>vToYParity,
    "validate",
    ()=>validate,
    "yParityToV",
    ()=>yParityToV
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/secp256k1.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Solidity.js [app-client] (ecmascript)");
;
;
;
;
;
;
function assert(signature) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { recovered } = options;
    if (typeof signature.r === 'undefined') throw new MissingPropertiesError({
        signature
    });
    if (typeof signature.s === 'undefined') throw new MissingPropertiesError({
        signature
    });
    if (recovered && typeof signature.yParity === 'undefined') throw new MissingPropertiesError({
        signature
    });
    if (signature.r < 0n || signature.r > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["maxUint256"]) throw new InvalidRError({
        value: signature.r
    });
    if (signature.s < 0n || signature.s > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Solidity$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["maxUint256"]) throw new InvalidSError({
        value: signature.s
    });
    if (typeof signature.yParity === 'number' && signature.yParity !== 0 && signature.yParity !== 1) throw new InvalidYParityError({
        value: signature.yParity
    });
}
function fromBytes(signature) {
    return fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](signature));
}
function fromHex(signature) {
    if (signature.length !== 130 && signature.length !== 132) throw new InvalidSerializedSizeError({
        signature
    });
    const r = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](signature, 0, 32));
    const s = BigInt(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](signature, 32, 64));
    const yParity = (()=>{
        const yParity = Number("0x".concat(signature.slice(130)));
        if (Number.isNaN(yParity)) return undefined;
        try {
            return vToYParity(yParity);
        } catch (e) {
            throw new InvalidYParityError({
                value: yParity
            });
        }
    })();
    if (typeof yParity === 'undefined') return {
        r,
        s
    };
    return {
        r,
        s,
        yParity
    };
}
function extract(value) {
    if (typeof value.r === 'undefined') return undefined;
    if (typeof value.s === 'undefined') return undefined;
    return from(value);
}
function from(signature) {
    const signature_ = (()=>{
        if (typeof signature === 'string') return fromHex(signature);
        if (signature instanceof Uint8Array) return fromBytes(signature);
        if (typeof signature.r === 'string') return fromRpc(signature);
        if (signature.v) return fromLegacy(signature);
        return {
            r: signature.r,
            s: signature.s,
            ...typeof signature.yParity !== 'undefined' ? {
                yParity: signature.yParity
            } : {}
        };
    })();
    assert(signature_);
    return signature_;
}
function fromDerBytes(signature) {
    return fromDerHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](signature));
}
function fromDerHex(signature) {
    const { r, s } = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature.fromDER(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](signature).slice(2));
    return {
        r,
        s
    };
}
function fromLegacy(signature) {
    return {
        r: signature.r,
        s: signature.s,
        yParity: vToYParity(signature.v)
    };
}
function fromRpc(signature) {
    const yParity = (()=>{
        const v = signature.v ? Number(signature.v) : undefined;
        let yParity = signature.yParity ? Number(signature.yParity) : undefined;
        if (typeof v === 'number' && typeof yParity !== 'number') yParity = vToYParity(v);
        if (typeof yParity !== 'number') throw new InvalidYParityError({
            value: signature.yParity
        });
        return yParity;
    })();
    return {
        r: BigInt(signature.r),
        s: BigInt(signature.s),
        yParity
    };
}
function fromTuple(tuple) {
    const [yParity, r, s] = tuple;
    return from({
        r: r === '0x' ? 0n : BigInt(r),
        s: s === '0x' ? 0n : BigInt(s),
        yParity: yParity === '0x' ? 0 : Number(yParity)
    });
}
function toBytes(signature) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](toHex(signature));
}
function toHex(signature) {
    assert(signature);
    const r = signature.r;
    const s = signature.s;
    const signature_ = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](r, {
        size: 32
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](s, {
        size: 32
    }), // If the signature is recovered, add the recovery byte to the signature.
    typeof signature.yParity === 'number' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](yParityToV(signature.yParity), {
        size: 1
    }) : '0x');
    return signature_;
}
function toDerBytes(signature) {
    const sig = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature(signature.r, signature.s);
    return sig.toDERRawBytes();
}
function toDerHex(signature) {
    const sig = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature(signature.r, signature.s);
    return "0x".concat(sig.toDERHex());
}
function toLegacy(signature) {
    return {
        r: signature.r,
        s: signature.s,
        v: yParityToV(signature.yParity)
    };
}
function toRpc(signature) {
    const { r, s, yParity } = signature;
    return {
        r: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](r, {
            size: 32
        }),
        s: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](s, {
            size: 32
        }),
        yParity: yParity === 0 ? '0x0' : '0x1'
    };
}
function toTuple(signature) {
    const { r, s, yParity } = signature;
    return [
        yParity ? '0x01' : '0x',
        r === 0n ? '0x' : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](r)),
        s === 0n ? '0x' : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimLeft"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](s))
    ];
}
function validate(signature) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    try {
        assert(signature, options);
        return true;
    } catch (e) {
        return false;
    }
}
function vToYParity(v) {
    if (v === 0 || v === 27) return 0;
    if (v === 1 || v === 28) return 1;
    if (v >= 35) return v % 2 === 0 ? 1 : 0;
    throw new InvalidVError({
        value: v
    });
}
function yParityToV(yParity) {
    if (yParity === 0) return 27;
    if (yParity === 1) return 28;
    throw new InvalidYParityError({
        value: yParity
    });
}
class InvalidSerializedSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ signature }){
        super("Value `".concat(signature, "` is an invalid signature size."), {
            metaMessages: [
                'Expected: 64 bytes or 65 bytes.',
                "Received ".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](signature)), " bytes.")
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidSerializedSizeError'
        });
    }
}
class MissingPropertiesError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ signature }){
        super("Signature `".concat(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](signature), "` is missing either an `r`, `s`, or `yParity` property."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.MissingPropertiesError'
        });
    }
}
class InvalidRError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid r value. r must be a positive integer less than 2^256."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidRError'
        });
    }
}
class InvalidSError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid s value. s must be a positive integer less than 2^256."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidSError'
        });
    }
}
class InvalidYParityError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid y-parity value. Y-parity must be 0 or 1."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidYParityError'
        });
    }
}
class InvalidVError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ value }){
        super("Value `".concat(value, "` is an invalid v value. v must be 27, 28 or >=35."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Signature.InvalidVError'
        });
    }
} //# sourceMappingURL=Signature.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Authorization.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "from",
    ()=>from,
    "fromRpc",
    ()=>fromRpc,
    "fromRpcList",
    ()=>fromRpcList,
    "fromTuple",
    ()=>fromTuple,
    "fromTupleList",
    ()=>fromTupleList,
    "getSignPayload",
    ()=>getSignPayload,
    "hash",
    ()=>hash,
    "toRpc",
    ()=>toRpc,
    "toRpcList",
    ()=>toRpcList,
    "toTuple",
    ()=>toTuple,
    "toTupleList",
    ()=>toTupleList
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hash.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Rlp$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Rlp.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Signature.js [app-client] (ecmascript)");
;
;
;
;
function from(authorization) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (typeof authorization.chainId === 'string') return fromRpc(authorization);
    return {
        ...authorization,
        ...options.signature
    };
}
function fromRpc(authorization) {
    const { address, chainId, nonce } = authorization;
    const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extract"](authorization);
    return {
        address,
        chainId: Number(chainId),
        nonce: BigInt(nonce),
        ...signature
    };
}
function fromRpcList(authorizationList) {
    return authorizationList.map(fromRpc);
}
function fromTuple(tuple) {
    const [chainId, address, nonce, yParity, r, s] = tuple;
    let args = {
        address,
        chainId: chainId === '0x' ? 0 : Number(chainId),
        nonce: nonce === '0x' ? 0n : BigInt(nonce)
    };
    if (yParity && r && s) args = {
        ...args,
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromTuple"]([
            yParity,
            r,
            s
        ])
    };
    return from(args);
}
function fromTupleList(tupleList) {
    const list = [];
    for (const tuple of tupleList)list.push(fromTuple(tuple));
    return list;
}
function getSignPayload(authorization) {
    return hash(authorization, {
        presign: true
    });
}
function hash(authorization) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { presign } = options;
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hash$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"]('0x05', __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Rlp$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](toTuple(presign ? {
        address: authorization.address,
        chainId: authorization.chainId,
        nonce: authorization.nonce
    } : authorization))));
}
function toRpc(authorization) {
    const { address, chainId, nonce, ...signature } = authorization;
    return {
        address,
        chainId: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](chainId),
        nonce: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](nonce),
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toRpc"](signature)
    };
}
function toRpcList(authorizationList) {
    return authorizationList.map(toRpc);
}
function toTuple(authorization) {
    const { address, chainId, nonce } = authorization;
    const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extract"](authorization);
    return [
        chainId ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](chainId) : '0x',
        address,
        nonce ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](nonce) : '0x',
        ...signature ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toTuple"](signature) : []
    ];
}
function toTupleList(list) {
    if (!list || list.length === 0) return [];
    const tupleList = [];
    for (const authorization of list)tupleList.push(toTuple(authorization));
    return tupleList;
} //# sourceMappingURL=Authorization.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/entropy.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "extraEntropy",
    ()=>extraEntropy,
    "setExtraEntropy",
    ()=>setExtraEntropy
]);
let extraEntropy = false;
function setExtraEntropy(entropy) {
    extraEntropy = entropy;
} //# sourceMappingURL=entropy.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Secp256k1.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "createKeyPair",
    ()=>createKeyPair,
    "getPublicKey",
    ()=>getPublicKey,
    "getSharedSecret",
    ()=>getSharedSecret,
    "noble",
    ()=>noble,
    "randomPrivateKey",
    ()=>randomPrivateKey,
    "recoverAddress",
    ()=>recoverAddress,
    "recoverPublicKey",
    ()=>recoverPublicKey,
    "sign",
    ()=>sign,
    "verify",
    ()=>verify
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/secp256k1.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$entropy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/internal/entropy.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/PublicKey.js [app-client] (ecmascript)");
;
;
;
;
;
;
const noble = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"];
function createKeyPair() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { as = 'Hex' } = options;
    const privateKey = randomPrivateKey({
        as
    });
    const publicKey = getPublicKey({
        privateKey
    });
    return {
        privateKey: privateKey,
        publicKey
    };
}
function getPublicKey(options) {
    const { privateKey } = options;
    const point = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].ProjectivePoint.fromPrivateKey(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](privateKey).slice(2));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](point);
}
function getSharedSecret(options) {
    const { as = 'Hex', privateKey, publicKey } = options;
    const point = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].ProjectivePoint.fromHex(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toHex"](publicKey).slice(2));
    const sharedPoint = point.multiply(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].utils.normPrivateKeyToScalar(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](privateKey).slice(2)));
    const sharedSecret = sharedPoint.toRawBytes(true); // compressed format
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](sharedSecret);
    return sharedSecret;
}
function randomPrivateKey() {
    let options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    const { as = 'Hex' } = options;
    const bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].utils.randomPrivateKey();
    if (as === 'Hex') return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes);
    return bytes;
}
function recoverAddress(options) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromPublicKey"](recoverPublicKey(options));
}
function recoverPublicKey(options) {
    const { payload, signature } = options;
    const { r, s, yParity } = signature;
    const signature_ = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].Signature(BigInt(r), BigInt(s)).addRecoveryBit(yParity);
    const point = signature_.recoverPublicKey(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload).substring(2));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](point);
}
function sign(options) {
    const { extraEntropy = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$entropy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["extraEntropy"], hash, payload, privateKey } = options;
    const { r, s, recovery } = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].sign(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](privateKey), {
        extraEntropy: typeof extraEntropy === 'boolean' ? extraEntropy : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](extraEntropy).slice(2),
        lowS: true,
        ...hash ? {
            prehash: true
        } : {}
    });
    return {
        r,
        s,
        yParity: recovery
    };
}
function verify(options) {
    const { address, hash, payload, publicKey, signature } = options;
    if (address) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isEqual"](address, recoverAddress({
        payload,
        signature
    }));
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["secp256k1"].verify(signature, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](payload), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$PublicKey$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"](publicKey), ...hash ? [
        {
            prehash: true,
            lowS: true
        }
    ] : []);
} //# sourceMappingURL=Secp256k1.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/erc8010/SignatureErc8010.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidWrappedSignatureError",
    ()=>InvalidWrappedSignatureError,
    "assert",
    ()=>assert,
    "from",
    ()=>from,
    "magicBytes",
    ()=>magicBytes,
    "suffixParameters",
    ()=>suffixParameters,
    "unwrap",
    ()=>unwrap,
    "validate",
    ()=>validate,
    "wrap",
    ()=>wrap
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Authorization$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Authorization.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Secp256k1.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/core/Signature.js [app-client] (ecmascript)");
;
;
;
;
;
;
const magicBytes = '0x8010801080108010801080108010801080108010801080108010801080108010';
const suffixParameters = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"]('(uint256 chainId, address delegation, uint256 nonce, uint8 yParity, uint256 r, uint256 s), address to, bytes data');
function assert(value) {
    if (typeof value === 'string') {
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](value, -32) !== magicBytes) throw new InvalidWrappedSignatureError(value);
    } else __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"](value.authorization);
}
function from(value) {
    if (typeof value === 'string') return unwrap(value);
    return value;
}
function unwrap(wrapped) {
    assert(wrapped);
    const suffixLength = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, -64, -32));
    const suffix = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, -suffixLength - 64, -64);
    const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, 0, -suffixLength - 64);
    const [auth, to, data] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](suffixParameters, suffix);
    const authorization = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Authorization$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"]({
        address: auth.delegation,
        chainId: Number(auth.chainId),
        nonce: auth.nonce,
        yParity: auth.yParity,
        r: auth.r,
        s: auth.s
    });
    return {
        authorization,
        signature,
        ...data && data !== '0x' ? {
            data,
            to
        } : {}
    };
}
function wrap(value) {
    const { data, signature } = value;
    assert(value);
    const self = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["recoverAddress"]({
        payload: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Authorization$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getSignPayload"](value.authorization),
        signature: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value.authorization)
    });
    var _value_to;
    const suffix = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](suffixParameters, [
        {
            ...value.authorization,
            delegation: value.authorization.address,
            chainId: BigInt(value.authorization.chainId)
        },
        (_value_to = value.to) !== null && _value_to !== void 0 ? _value_to : self,
        data !== null && data !== void 0 ? data : '0x'
    ]);
    const suffixLength = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](suffix), {
        size: 32
    });
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](signature, suffix, suffixLength, magicBytes);
}
function validate(value) {
    try {
        assert(value);
        return true;
    } catch (e) {
        return false;
    }
}
class InvalidWrappedSignatureError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(wrapped){
        super("Value `".concat(wrapped, "` is an invalid ERC-8010 wrapped signature."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'SignatureErc8010.InvalidWrappedSignatureError'
        });
    }
} //# sourceMappingURL=SignatureErc8010.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/erc8010/SignatureErc8010.js [app-client] (ecmascript) <export * as SignatureErc8010>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "SignatureErc8010",
    ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$erc8010$2f$SignatureErc8010$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$6_typescript$40$5$2e$9$2e$3_zod$40$3$2e$24$2e$1$2f$node_modules$2f$ox$2f$_esm$2f$erc8010$2f$SignatureErc8010$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.6_typescript@5.9.3_zod@3.24.1/node_modules/ox/_esm/erc8010/SignatureErc8010.js [app-client] (ecmascript)");
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/erc8010/SignatureErc8010.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidWrappedSignatureError",
    ()=>InvalidWrappedSignatureError,
    "assert",
    ()=>assert,
    "from",
    ()=>from,
    "magicBytes",
    ()=>magicBytes,
    "suffixParameters",
    ()=>suffixParameters,
    "unwrap",
    ()=>unwrap,
    "validate",
    ()=>validate,
    "wrap",
    ()=>wrap
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/AbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Authorization$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Authorization.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Secp256k1.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Signature.js [app-client] (ecmascript)");
;
;
;
;
;
;
const magicBytes = '0x8010801080108010801080108010801080108010801080108010801080108010';
const suffixParameters = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"]('(uint256 chainId, address delegation, uint256 nonce, uint8 yParity, uint256 r, uint256 s), address to, bytes data');
function assert(value) {
    if (typeof value === 'string') {
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](value, -32) !== magicBytes) throw new InvalidWrappedSignatureError(value);
    } else __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"](value.authorization);
}
function from(value) {
    if (typeof value === 'string') return unwrap(value);
    return value;
}
function unwrap(wrapped) {
    assert(wrapped);
    const suffixLength = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, -64, -32));
    const suffix = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, -suffixLength - 64, -64);
    const signature = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"](wrapped, 0, -suffixLength - 64);
    const [auth, to, data] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["decode"](suffixParameters, suffix);
    const authorization = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Authorization$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"]({
        address: auth.delegation,
        chainId: Number(auth.chainId),
        nonce: auth.nonce,
        yParity: auth.yParity,
        r: auth.r,
        s: auth.s
    });
    return {
        authorization,
        signature,
        ...data && data !== '0x' ? {
            data,
            to
        } : {}
    };
}
function wrap(value) {
    const { data, signature } = value;
    assert(value);
    const self = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Secp256k1$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["recoverAddress"]({
        payload: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Authorization$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getSignPayload"](value.authorization),
        signature: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Signature$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["from"](value.authorization)
    });
    var _value_to;
    const suffix = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$AbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encode"](suffixParameters, [
        {
            ...value.authorization,
            delegation: value.authorization.address,
            chainId: BigInt(value.authorization.chainId)
        },
        (_value_to = value.to) !== null && _value_to !== void 0 ? _value_to : self,
        data !== null && data !== void 0 ? data : '0x'
    ]);
    const suffixLength = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](suffix), {
        size: 32
    });
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"](signature, suffix, suffixLength, magicBytes);
}
function validate(value) {
    try {
        assert(value);
        return true;
    } catch (e) {
        return false;
    }
}
class InvalidWrappedSignatureError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(wrapped){
        super("Value `".concat(wrapped, "` is an invalid ERC-8010 wrapped signature."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'SignatureErc8010.InvalidWrappedSignatureError'
        });
    }
} //# sourceMappingURL=SignatureErc8010.js.map
}),
]);

//# sourceMappingURL=node_modules__pnpm_26a5bc70._.js.map