(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/socket.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getSocketRpcClient",
    ()=>getSocketRpcClient,
    "socketClientCache",
    ()=>socketClientCache
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/errors/request.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$promise$2f$createBatchScheduler$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/promise/createBatchScheduler.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$promise$2f$withTimeout$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/promise/withTimeout.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$id$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/id.js [app-client] (ecmascript)");
;
;
;
;
const socketClientCache = /*#__PURE__*/ new Map();
async function getSocketRpcClient(parameters) {
    const { getSocket, keepAlive = true, key = 'socket', reconnect = true, url } = parameters;
    const { interval: keepAliveInterval = 30_000 } = typeof keepAlive === 'object' ? keepAlive : {};
    const { attempts = 5, delay = 2_000 } = typeof reconnect === 'object' ? reconnect : {};
    const id = JSON.stringify({
        keepAlive,
        key,
        url,
        reconnect
    });
    let socketClient = socketClientCache.get(id);
    // If the socket already exists, return it.
    if (socketClient) return socketClient;
    let reconnectCount = 0;
    const { schedule } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$promise$2f$createBatchScheduler$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["createBatchScheduler"])({
        id,
        fn: async ()=>{
            // Set up a cache for incoming "synchronous" requests.
            const requests = new Map();
            // Set up a cache for subscriptions (eth_subscribe).
            const subscriptions = new Map();
            let error;
            let socket;
            let keepAliveTimer;
            let reconnectInProgress = false;
            function attemptReconnect() {
                // Attempt to reconnect.
                if (reconnect && reconnectCount < attempts) {
                    if (reconnectInProgress) return;
                    reconnectInProgress = true;
                    reconnectCount++;
                    // Make sure the previous socket is definitely closed.
                    socket === null || socket === void 0 ? void 0 : socket.close();
                    setTimeout(async ()=>{
                        // biome-ignore lint/suspicious/noConsole: _
                        await setup().catch(console.error);
                        reconnectInProgress = false;
                    }, delay);
                } else {
                    requests.clear();
                    subscriptions.clear();
                }
            }
            // Set up socket implementation.
            async function setup() {
                const result = await getSocket({
                    onClose () {
                        var _request_onError, _subscription_onError;
                        // Notify all requests and subscriptions of the closure error.
                        for (const request of requests.values())(_request_onError = request.onError) === null || _request_onError === void 0 ? void 0 : _request_onError.call(request, new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SocketClosedError"]({
                            url
                        }));
                        for (const subscription of subscriptions.values())(_subscription_onError = subscription.onError) === null || _subscription_onError === void 0 ? void 0 : _subscription_onError.call(subscription, new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SocketClosedError"]({
                            url
                        }));
                        attemptReconnect();
                    },
                    onError (error_) {
                        var _request_onError, _subscription_onError;
                        error = error_;
                        // Notify all requests and subscriptions of the error.
                        for (const request of requests.values())(_request_onError = request.onError) === null || _request_onError === void 0 ? void 0 : _request_onError.call(request, error);
                        for (const subscription of subscriptions.values())(_subscription_onError = subscription.onError) === null || _subscription_onError === void 0 ? void 0 : _subscription_onError.call(subscription, error);
                        attemptReconnect();
                    },
                    onOpen () {
                        error = undefined;
                        reconnectCount = 0;
                    },
                    onResponse (data) {
                        const isSubscription = data.method === 'eth_subscription';
                        const id = isSubscription ? data.params.subscription : data.id;
                        const cache = isSubscription ? subscriptions : requests;
                        const callback = cache.get(id);
                        if (callback) callback.onResponse(data);
                        if (!isSubscription) cache.delete(id);
                    }
                });
                socket = result;
                if (keepAlive) {
                    if (keepAliveTimer) clearInterval(keepAliveTimer);
                    keepAliveTimer = setInterval(()=>{
                        var _socket_ping;
                        return (_socket_ping = socket.ping) === null || _socket_ping === void 0 ? void 0 : _socket_ping.call(socket);
                    }, keepAliveInterval);
                }
                if (reconnect && subscriptions.size > 0) {
                    const subscriptionEntries = subscriptions.entries();
                    for (const [key, { onResponse, body, onError }] of subscriptionEntries){
                        if (!body) continue;
                        subscriptions.delete(key);
                        socketClient === null || socketClient === void 0 ? void 0 : socketClient.request({
                            body,
                            onResponse,
                            onError
                        });
                    }
                }
                return result;
            }
            await setup();
            error = undefined;
            // Create a new socket instance.
            socketClient = {
                close () {
                    keepAliveTimer && clearInterval(keepAliveTimer);
                    socket.close();
                    socketClientCache.delete(id);
                },
                get socket () {
                    return socket;
                },
                request (param) {
                    let { body, onError, onResponse } = param;
                    if (error && onError) onError(error);
                    var _body_id;
                    const id = (_body_id = body.id) !== null && _body_id !== void 0 ? _body_id : __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$id$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["idCache"].take();
                    const callback = (response)=>{
                        var _body_params;
                        if (typeof response.id === 'number' && id !== response.id) return;
                        // If we are subscribing to a topic, we want to set up a listener for incoming
                        // messages.
                        if (body.method === 'eth_subscribe' && typeof response.result === 'string') subscriptions.set(response.result, {
                            onResponse: callback,
                            onError,
                            body
                        });
                        // If we are unsubscribing from a topic, we want to remove the listener.
                        if (body.method === 'eth_unsubscribe') subscriptions.delete((_body_params = body.params) === null || _body_params === void 0 ? void 0 : _body_params[0]);
                        onResponse(response);
                    };
                    requests.set(id, {
                        onResponse: callback,
                        onError
                    });
                    try {
                        socket.request({
                            body: {
                                jsonrpc: '2.0',
                                id,
                                ...body
                            }
                        });
                    } catch (error) {
                        onError === null || onError === void 0 ? void 0 : onError(error);
                    }
                },
                requestAsync (param) {
                    let { body, timeout = 10_000 } = param;
                    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$promise$2f$withTimeout$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["withTimeout"])(()=>new Promise((onResponse, onError)=>this.request({
                                body,
                                onError,
                                onResponse
                            })), {
                        errorInstance: new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["TimeoutError"]({
                            body,
                            url
                        }),
                        timeout
                    });
                },
                requests,
                subscriptions,
                url
            };
            socketClientCache.set(id, socketClient);
            return [
                socketClient
            ];
        }
    });
    const [_, [socketClient_]] = await schedule();
    return socketClient_;
} //# sourceMappingURL=socket.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/webSocket.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getWebSocketRpcClient",
    ()=>getWebSocketRpcClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/errors/request.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$socket$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/socket.js [app-client] (ecmascript)");
;
;
async function getWebSocketRpcClient(url) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { keepAlive, reconnect } = options;
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$socket$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getSocketRpcClient"])({
        async getSocket (param) {
            let { onClose, onError, onOpen, onResponse } = param;
            const WebSocket = await __turbopack_context__.A("[project]/node_modules/.pnpm/isows@1.0.7_ws@8.18.3_buffe_82b1f2f4f4867a5d127bd94621a34eb0/node_modules/isows/_esm/native.js [app-client] (ecmascript, async loader)").then((module)=>module.WebSocket);
            const socket = new WebSocket(url);
            function onClose_() {
                socket.removeEventListener('close', onClose_);
                socket.removeEventListener('message', onMessage);
                socket.removeEventListener('error', onError);
                socket.removeEventListener('open', onOpen);
                onClose();
            }
            function onMessage(param) {
                let { data } = param;
                // ignore empty messages
                if (typeof data === 'string' && data.trim().length === 0) return;
                try {
                    const _data = JSON.parse(data);
                    onResponse(_data);
                } catch (error) {
                    onError(error);
                }
            }
            // Setup event listeners for RPC & subscription responses.
            socket.addEventListener('close', onClose_);
            socket.addEventListener('message', onMessage);
            socket.addEventListener('error', onError);
            socket.addEventListener('open', onOpen);
            // Wait for the socket to open.
            if (socket.readyState === WebSocket.CONNECTING) {
                await new Promise((resolve, reject)=>{
                    if (!socket) return;
                    socket.onopen = resolve;
                    socket.onerror = reject;
                });
            }
            const { close: close_ } = socket;
            return Object.assign(socket, {
                close () {
                    close_.bind(socket)();
                    onClose_();
                },
                ping () {
                    try {
                        if (socket.readyState === socket.CLOSED || socket.readyState === socket.CLOSING) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["WebSocketRequestError"]({
                            url: socket.url,
                            cause: new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SocketClosedError"]({
                                url: socket.url
                            })
                        });
                        const body = {
                            jsonrpc: '2.0',
                            id: null,
                            method: 'net_version',
                            params: []
                        };
                        socket.send(JSON.stringify(body));
                    } catch (error) {
                        onError(error);
                    }
                },
                request (param) {
                    let { body } = param;
                    if (socket.readyState === socket.CLOSED || socket.readyState === socket.CLOSING) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["WebSocketRequestError"]({
                        body,
                        url: socket.url,
                        cause: new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SocketClosedError"]({
                            url: socket.url
                        })
                    });
                    return socket.send(JSON.stringify(body));
                }
            });
        },
        keepAlive,
        reconnect,
        url
    });
} //# sourceMappingURL=webSocket.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/compat.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// TODO(v3): This file is here for backwards compatibility, and to prevent breaking changes.
// These APIs will be removed in v3.
__turbopack_context__.s([
    "getSocket",
    ()=>getSocket,
    "rpc",
    ()=>rpc
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$http$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/http.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$webSocket$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/webSocket.js [app-client] (ecmascript)");
;
;
function webSocket(socketClient, param) {
    let { body, onError, onResponse } = param;
    socketClient.request({
        body,
        onError,
        onResponse
    });
    return socketClient;
}
async function webSocketAsync(socketClient, param) {
    let { body, timeout = 10_000 } = param;
    return socketClient.requestAsync({
        body,
        timeout
    });
}
async function getSocket(url) {
    const client = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$webSocket$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getWebSocketRpcClient"])(url);
    return Object.assign(client.socket, {
        requests: client.requests,
        subscriptions: client.subscriptions
    });
}
const rpc = {
    /**
     * @deprecated use `getHttpRpcClient` instead.
     *
     * ```diff
     * -import { rpc } from 'viem/utils'
     * +import { getHttpRpcClient } from 'viem/utils'
     *
     * -rpc.http(url, params)
     * +const httpClient = getHttpRpcClient(url)
     * +httpClient.request(params)
     * ```
     */ http (url, params) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$http$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getHttpRpcClient"])(url).request(params);
    },
    /**
     * @deprecated use `getWebSocketRpcClient` instead.
     *
     * ```diff
     * -import { rpc } from 'viem/utils'
     * +import { getWebSocketRpcClient } from 'viem/utils'
     *
     * -rpc.webSocket(url, params)
     * +const webSocketClient = getWebSocketRpcClient(url)
     * +webSocketClient.request(params)
     * ```
     */ webSocket,
    /**
     * @deprecated use `getWebSocketRpcClient` instead.
     *
     * ```diff
     * -import { rpc } from 'viem/utils'
     * +import { getWebSocketRpcClient } from 'viem/utils'
     *
     * -const response = await rpc.webSocketAsync(url, params)
     * +const webSocketClient = getWebSocketRpcClient(url)
     * +const response = await webSocketClient.requestAsync(params)
     * ```
     */ webSocketAsync
}; /* c8 ignore end */  //# sourceMappingURL=compat.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/arbitrumSepolia.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "arbitrumSepolia",
    ()=>arbitrumSepolia
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/chain/defineChain.js [app-client] (ecmascript)");
;
const arbitrumSepolia = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    id: 421_614,
    name: 'Arbitrum Sepolia',
    blockTime: 250,
    nativeCurrency: {
        name: 'Arbitrum Sepolia Ether',
        symbol: 'ETH',
        decimals: 18
    },
    rpcUrls: {
        default: {
            http: [
                'https://sepolia-rollup.arbitrum.io/rpc'
            ]
        }
    },
    blockExplorers: {
        default: {
            name: 'Arbiscan',
            url: 'https://sepolia.arbiscan.io',
            apiUrl: 'https://api-sepolia.arbiscan.io/api'
        }
    },
    contracts: {
        multicall3: {
            address: '0xca11bde05977b3631167028862be2a173976ca11',
            blockCreated: 81930
        }
    },
    testnet: true
}); //# sourceMappingURL=arbitrumSepolia.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/base.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "base",
    ()=>base,
    "basePreconf",
    ()=>basePreconf
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/op-stack/chainConfig.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/chain/defineChain.js [app-client] (ecmascript)");
;
;
const sourceId = 1; // mainnet
const base = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["chainConfig"],
    id: 8453,
    name: 'Base',
    nativeCurrency: {
        name: 'Ether',
        symbol: 'ETH',
        decimals: 18
    },
    rpcUrls: {
        default: {
            http: [
                'https://mainnet.base.org'
            ]
        }
    },
    blockExplorers: {
        default: {
            name: 'Basescan',
            url: 'https://basescan.org',
            apiUrl: 'https://api.basescan.org/api'
        }
    },
    contracts: {
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["chainConfig"].contracts,
        disputeGameFactory: {
            [sourceId]: {
                address: '0x43edB88C4B80fDD2AdFF2412A7BebF9dF42cB40e'
            }
        },
        l2OutputOracle: {
            [sourceId]: {
                address: '0x56315b90c40730925ec5485cf004d835058518A0'
            }
        },
        multicall3: {
            address: '0xca11bde05977b3631167028862be2a173976ca11',
            blockCreated: 5022
        },
        portal: {
            [sourceId]: {
                address: '0x49048044D57e1C92A77f79988d21Fa8fAF74E97e',
                blockCreated: 17482143
            }
        },
        l1StandardBridge: {
            [sourceId]: {
                address: '0x3154Cf16ccdb4C6d922629664174b904d80F2C35',
                blockCreated: 17482143
            }
        }
    },
    sourceId
});
const basePreconf = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    ...base,
    experimental_preconfirmationTime: 200,
    rpcUrls: {
        default: {
            http: [
                'https://mainnet-preconf.base.org'
            ]
        }
    }
}); //# sourceMappingURL=base.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/baseSepolia.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "baseSepolia",
    ()=>baseSepolia,
    "baseSepoliaPreconf",
    ()=>baseSepoliaPreconf
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/op-stack/chainConfig.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/chain/defineChain.js [app-client] (ecmascript)");
;
;
const sourceId = 11_155_111; // sepolia
const baseSepolia = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["chainConfig"],
    id: 84532,
    network: 'base-sepolia',
    name: 'Base Sepolia',
    nativeCurrency: {
        name: 'Sepolia Ether',
        symbol: 'ETH',
        decimals: 18
    },
    rpcUrls: {
        default: {
            http: [
                'https://sepolia.base.org'
            ]
        }
    },
    blockExplorers: {
        default: {
            name: 'Basescan',
            url: 'https://sepolia.basescan.org',
            apiUrl: 'https://api-sepolia.basescan.org/api'
        }
    },
    contracts: {
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["chainConfig"].contracts,
        disputeGameFactory: {
            [sourceId]: {
                address: '0xd6E6dBf4F7EA0ac412fD8b65ED297e64BB7a06E1'
            }
        },
        l2OutputOracle: {
            [sourceId]: {
                address: '0x84457ca9D0163FbC4bbfe4Dfbb20ba46e48DF254'
            }
        },
        portal: {
            [sourceId]: {
                address: '0x49f53e41452c74589e85ca1677426ba426459e85',
                blockCreated: 4446677
            }
        },
        l1StandardBridge: {
            [sourceId]: {
                address: '0xfd0Bf71F60660E2f608ed56e1659C450eB113120',
                blockCreated: 4446677
            }
        },
        multicall3: {
            address: '0xca11bde05977b3631167028862be2a173976ca11',
            blockCreated: 1059647
        }
    },
    testnet: true,
    sourceId
});
const baseSepoliaPreconf = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    ...baseSepolia,
    experimental_preconfirmationTime: 200,
    rpcUrls: {
        default: {
            http: [
                'https://sepolia-preconf.base.org'
            ]
        }
    }
}); //# sourceMappingURL=baseSepolia.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/optimismSepolia.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "optimismSepolia",
    ()=>optimismSepolia
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/op-stack/chainConfig.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/chain/defineChain.js [app-client] (ecmascript)");
;
;
const sourceId = 11_155_111; // sepolia
const optimismSepolia = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["chainConfig"],
    id: 11155420,
    name: 'OP Sepolia',
    nativeCurrency: {
        name: 'Sepolia Ether',
        symbol: 'ETH',
        decimals: 18
    },
    rpcUrls: {
        default: {
            http: [
                'https://sepolia.optimism.io'
            ]
        }
    },
    blockExplorers: {
        default: {
            name: 'Blockscout',
            url: 'https://optimism-sepolia.blockscout.com',
            apiUrl: 'https://optimism-sepolia.blockscout.com/api'
        }
    },
    contracts: {
        ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$op$2d$stack$2f$chainConfig$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["chainConfig"].contracts,
        disputeGameFactory: {
            [sourceId]: {
                address: '0x05F9613aDB30026FFd634f38e5C4dFd30a197Fa1'
            }
        },
        l2OutputOracle: {
            [sourceId]: {
                address: '0x90E9c4f8a994a250F6aEfd61CAFb4F2e895D458F'
            }
        },
        multicall3: {
            address: '0xca11bde05977b3631167028862be2a173976ca11',
            blockCreated: 1620204
        },
        portal: {
            [sourceId]: {
                address: '0x16Fc5058F25648194471939df75CF27A2fdC48BC'
            }
        },
        l1StandardBridge: {
            [sourceId]: {
                address: '0xFBb0621E0B23b5478B630BD55a5f21f67730B0F1'
            }
        }
    },
    testnet: true,
    sourceId
}); //# sourceMappingURL=optimismSepolia.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/polygonAmoy.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "polygonAmoy",
    ()=>polygonAmoy
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/chain/defineChain.js [app-client] (ecmascript)");
;
const polygonAmoy = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    id: 80_002,
    name: 'Polygon Amoy',
    nativeCurrency: {
        name: 'POL',
        symbol: 'POL',
        decimals: 18
    },
    rpcUrls: {
        default: {
            http: [
                'https://rpc-amoy.polygon.technology'
            ]
        }
    },
    blockExplorers: {
        default: {
            name: 'PolygonScan',
            url: 'https://amoy.polygonscan.com',
            apiUrl: 'https://api-amoy.polygonscan.com/api'
        }
    },
    contracts: {
        multicall3: {
            address: '0xca11bde05977b3631167028862be2a173976ca11',
            blockCreated: 3127388
        }
    },
    testnet: true
}); //# sourceMappingURL=polygonAmoy.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/sepolia.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "sepolia",
    ()=>sepolia
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/chain/defineChain.js [app-client] (ecmascript)");
;
const sepolia = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$chain$2f$defineChain$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["defineChain"])({
    id: 11_155_111,
    name: 'Sepolia',
    nativeCurrency: {
        name: 'Sepolia Ether',
        symbol: 'ETH',
        decimals: 18
    },
    rpcUrls: {
        default: {
            http: [
                'https://11155111.rpc.thirdweb.com'
            ]
        }
    },
    blockExplorers: {
        default: {
            name: 'Etherscan',
            url: 'https://sepolia.etherscan.io',
            apiUrl: 'https://api-sepolia.etherscan.io/api'
        }
    },
    contracts: {
        multicall3: {
            address: '0xca11bde05977b3631167028862be2a173976ca11',
            blockCreated: 751532
        },
        ensUniversalResolver: {
            address: '0xeeeeeeee14d718c2b47d9923deab1335e144eeee',
            blockCreated: 8_928_790
        }
    },
    testnet: true
}); //# sourceMappingURL=sepolia.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/abi/encodePacked.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "encodePacked",
    ()=>encodePacked
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$abi$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/errors/abi.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/errors/address.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$isAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/address/isAddress.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/concat.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$pad$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/pad.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/encoding/toHex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$regex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/regex.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
function encodePacked(types, values) {
    if (types.length !== values.length) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$abi$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AbiEncodingLengthMismatchError"]({
        expectedLength: types.length,
        givenLength: values.length
    });
    const data = [];
    for(let i = 0; i < types.length; i++){
        const type = types[i];
        const value = values[i];
        data.push(encode(type, value));
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concatHex"])(data);
}
function encode(type, value) {
    let isArray = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
    if (type === 'address') {
        const address = value;
        if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$isAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isAddress"])(address)) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$address$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["InvalidAddressError"]({
            address
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$pad$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"])(address.toLowerCase(), {
            size: isArray ? 32 : null
        });
    }
    if (type === 'string') return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringToHex"])(value);
    if (type === 'bytes') return value;
    if (type === 'bool') return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$pad$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["boolToHex"])(value), {
        size: isArray ? 32 : 1
    });
    const intMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$regex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integerRegex"]);
    if (intMatch) {
        const [_type, baseType, bits = '256'] = intMatch;
        const size = Number.parseInt(bits, 10) / 8;
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["numberToHex"])(value, {
            size: isArray ? 32 : size,
            signed: baseType === 'int'
        });
    }
    const bytesMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$regex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["bytesRegex"]);
    if (bytesMatch) {
        const [_type, size] = bytesMatch;
        if (Number.parseInt(size, 10) !== (value.length - 2) / 2) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$abi$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BytesSizeMismatchError"]({
            expectedSize: Number.parseInt(size, 10),
            givenSize: (value.length - 2) / 2
        });
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$pad$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"])(value, {
            dir: 'right',
            size: isArray ? 32 : null
        });
    }
    const arrayMatch = type.match(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$regex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arrayRegex"]);
    if (arrayMatch && Array.isArray(value)) {
        const [_type, childType] = arrayMatch;
        const data = [];
        for(let i = 0; i < value.length; i++){
            data.push(encode(childType, value[i], true));
        }
        if (data.length === 0) return '0x';
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concatHex"])(data);
    }
    throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$abi$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["UnsupportedPackedAbiType"](type);
} //# sourceMappingURL=encodePacked.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/isBytes.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "isBytes",
    ()=>isBytes
]);
function isBytes(value) {
    if (!value) return false;
    if (typeof value !== 'object') return false;
    if (!('BYTES_PER_ELEMENT' in value)) return false;
    return value.BYTES_PER_ELEMENT === 1 && value.constructor.name === 'Uint8Array';
} //# sourceMappingURL=isBytes.js.map
}),
"[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/address/getContractAddress.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getContractAddress",
    ()=>getContractAddress,
    "getCreate2Address",
    ()=>getCreate2Address,
    "getCreateAddress",
    ()=>getCreateAddress
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/concat.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$isBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/isBytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$pad$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/pad.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$slice$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/slice.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/encoding/toBytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toRlp$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/encoding/toRlp.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/hash/keccak256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/address/getAddress.js [app-client] (ecmascript)");
;
;
;
;
;
;
;
;
function getContractAddress(opts) {
    if (opts.opcode === 'CREATE2') return getCreate2Address(opts);
    return getCreateAddress(opts);
}
function getCreateAddress(opts) {
    const from = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])(opts.from));
    let nonce = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"])(opts.nonce);
    if (nonce[0] === 0) nonce = new Uint8Array([]);
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])("0x".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toRlp$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toRlp"])([
        from,
        nonce
    ], 'bytes')).slice(26)));
}
function getCreate2Address(opts) {
    const from = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])(opts.from));
    const salt = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$pad$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$isBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isBytes"])(opts.salt) ? opts.salt : (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"])(opts.salt), {
        size: 32
    });
    const bytecodeHash = (()=>{
        if ('bytecodeHash' in opts) {
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$isBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isBytes"])(opts.bytecodeHash)) return opts.bytecodeHash;
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"])(opts.bytecodeHash);
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])(opts.bytecode, 'bytes');
    })();
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$slice$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["slice"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$concat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["concat"])([
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toBytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBytes"])('0xff'),
        from,
        salt,
        bytecodeHash
    ])), 12));
} //# sourceMappingURL=getContractAddress.js.map
}),
"[project]/node_modules/.pnpm/@wagmi+core@2.22.1_@tanstac_330bb306678ae270c70864ae393d7210/node_modules/@wagmi/core/dist/esm/connectors/mock.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "mock",
    ()=>mock
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$custom$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/clients/transports/custom.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$fromHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/encoding/fromHex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/address/getAddress.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/hash/keccak256.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/encoding/toHex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/errors/request.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/errors/rpc.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$compat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/rpc/compat.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$wagmi$2b$core$40$2$2e$22$2e$1_$40$tanstac_330bb306678ae270c70864ae393d7210$2f$node_modules$2f40$wagmi$2f$core$2f$dist$2f$esm$2f$errors$2f$config$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@wagmi+core@2.22.1_@tanstac_330bb306678ae270c70864ae393d7210/node_modules/@wagmi/core/dist/esm/errors/config.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$wagmi$2b$core$40$2$2e$22$2e$1_$40$tanstac_330bb306678ae270c70864ae393d7210$2f$node_modules$2f40$wagmi$2f$core$2f$dist$2f$esm$2f$connectors$2f$createConnector$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@wagmi+core@2.22.1_@tanstac_330bb306678ae270c70864ae393d7210/node_modules/@wagmi/core/dist/esm/connectors/createConnector.js [app-client] (ecmascript)");
;
;
;
;
mock.type = 'mock';
function mock(parameters) {
    const transactionCache = new Map();
    var _parameters_features;
    const features = (_parameters_features = parameters.features) !== null && _parameters_features !== void 0 ? _parameters_features : {
        defaultConnected: false
    };
    let connected = features.defaultConnected;
    let connectedChainId;
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$wagmi$2b$core$40$2$2e$22$2e$1_$40$tanstac_330bb306678ae270c70864ae393d7210$2f$node_modules$2f40$wagmi$2f$core$2f$dist$2f$esm$2f$connectors$2f$createConnector$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["createConnector"])((config)=>({
            id: 'mock',
            name: 'Mock Connector',
            type: mock.type,
            async setup () {
                connectedChainId = config.chains[0].id;
            },
            async connect () {
                let { chainId, withCapabilities } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
                if (features.connectError) {
                    if (typeof features.connectError === 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["UserRejectedRequestError"](new Error('Failed to connect.'));
                    throw features.connectError;
                }
                const provider = await this.getProvider();
                const accounts = await provider.request({
                    method: 'eth_requestAccounts'
                });
                let currentChainId = await this.getChainId();
                if (chainId && currentChainId !== chainId) {
                    const chain = await this.switchChain({
                        chainId
                    });
                    currentChainId = chain.id;
                }
                connected = true;
                return {
                    accounts: withCapabilities ? accounts.map((x)=>({
                            address: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])(x),
                            capabilities: {
                                foo: {
                                    bar: x
                                }
                            }
                        })) : accounts.map((x)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])(x)),
                    chainId: currentChainId
                };
            },
            async disconnect () {
                connected = false;
            },
            async getAccounts () {
                if (!connected) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$wagmi$2b$core$40$2$2e$22$2e$1_$40$tanstac_330bb306678ae270c70864ae393d7210$2f$node_modules$2f40$wagmi$2f$core$2f$dist$2f$esm$2f$errors$2f$config$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ConnectorNotConnectedError"]();
                const provider = await this.getProvider();
                const accounts = await provider.request({
                    method: 'eth_accounts'
                });
                return accounts.map((x)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])(x));
            },
            async getChainId () {
                const provider = await this.getProvider();
                const hexChainId = await provider.request({
                    method: 'eth_chainId'
                });
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$fromHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"])(hexChainId, 'number');
            },
            async isAuthorized () {
                if (!features.reconnect) return false;
                if (!connected) return false;
                const accounts = await this.getAccounts();
                return !!accounts.length;
            },
            async switchChain (param) {
                let { chainId } = param;
                const provider = await this.getProvider();
                const chain = config.chains.find((x)=>x.id === chainId);
                if (!chain) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SwitchChainError"](new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$wagmi$2b$core$40$2$2e$22$2e$1_$40$tanstac_330bb306678ae270c70864ae393d7210$2f$node_modules$2f40$wagmi$2f$core$2f$dist$2f$esm$2f$errors$2f$config$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ChainNotConfiguredError"]());
                await provider.request({
                    method: 'wallet_switchEthereumChain',
                    params: [
                        {
                            chainId: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["numberToHex"])(chainId)
                        }
                    ]
                });
                return chain;
            },
            onAccountsChanged (accounts) {
                if (accounts.length === 0) this.onDisconnect();
                else config.emitter.emit('change', {
                    accounts: accounts.map((x)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getAddress"])(x))
                });
            },
            onChainChanged (chain) {
                const chainId = Number(chain);
                config.emitter.emit('change', {
                    chainId
                });
            },
            async onDisconnect (_error) {
                config.emitter.emit('disconnect');
                connected = false;
            },
            async getProvider () {
                let { chainId } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
                var _config_chains_find;
                const chain = (_config_chains_find = config.chains.find((x)=>x.id === chainId)) !== null && _config_chains_find !== void 0 ? _config_chains_find : config.chains[0];
                const url = chain.rpcUrls.default.http[0];
                const request = async (param)=>{
                    let { method, params } = param;
                    // eth methods
                    if (method === 'eth_chainId') return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["numberToHex"])(connectedChainId);
                    if (method === 'eth_requestAccounts') return parameters.accounts;
                    if (method === 'eth_signTypedData_v4') {
                        if (features.signTypedDataError) {
                            if (typeof features.signTypedDataError === 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["UserRejectedRequestError"](new Error('Failed to sign typed data.'));
                            throw features.signTypedDataError;
                        }
                    }
                    // wallet methods
                    if (method === 'wallet_switchEthereumChain') {
                        if (features.switchChainError) {
                            if (typeof features.switchChainError === 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["UserRejectedRequestError"](new Error('Failed to switch chain.'));
                            throw features.switchChainError;
                        }
                        connectedChainId = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$fromHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"])(params[0].chainId, 'number');
                        this.onChainChanged(connectedChainId.toString());
                        return;
                    }
                    if (method === 'wallet_watchAsset') {
                        if (features.watchAssetError) {
                            if (typeof features.watchAssetError === 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["UserRejectedRequestError"](new Error('Failed to switch chain.'));
                            throw features.watchAssetError;
                        }
                        return connected;
                    }
                    if (method === 'wallet_getCapabilities') return {
                        '0x2105': {
                            paymasterService: {
                                supported: params[0] === '0x95132632579b073D12a6673e18Ab05777a6B86f8'
                            },
                            sessionKeys: {
                                supported: true
                            }
                        },
                        '0x14A34': {
                            paymasterService: {
                                supported: params[0] === '0x95132632579b073D12a6673e18Ab05777a6B86f8'
                            }
                        }
                    };
                    if (method === 'wallet_sendCalls') {
                        const hashes = [];
                        const calls = params[0].calls;
                        const from = params[0].from;
                        for (const call of calls){
                            const { result, error } = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$compat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpc"].http(url, {
                                body: {
                                    method: 'eth_sendTransaction',
                                    params: [
                                        {
                                            ...call,
                                            ...typeof from !== 'undefined' ? {
                                                from
                                            } : {}
                                        }
                                    ]
                                }
                            });
                            if (error) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RpcRequestError"]({
                                body: {
                                    method,
                                    params
                                },
                                error,
                                url
                            });
                            hashes.push(result);
                        }
                        const id = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$encoding$2f$toHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringToHex"])(JSON.stringify(calls)));
                        transactionCache.set(id, hashes);
                        return {
                            id
                        };
                    }
                    if (method === 'wallet_getCallsStatus') {
                        const hashes = transactionCache.get(params[0]);
                        if (!hashes) return {
                            atomic: false,
                            chainId: '0x1',
                            id: params[0],
                            status: 100,
                            receipts: [],
                            version: '2.0.0'
                        };
                        const receipts = await Promise.all(hashes.map(async (hash)=>{
                            const { result, error } = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$compat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpc"].http(url, {
                                body: {
                                    method: 'eth_getTransactionReceipt',
                                    params: [
                                        hash
                                    ],
                                    id: 0
                                }
                            });
                            if (error) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RpcRequestError"]({
                                body: {
                                    method,
                                    params
                                },
                                error,
                                url
                            });
                            if (!result) return null;
                            return {
                                blockHash: result.blockHash,
                                blockNumber: result.blockNumber,
                                gasUsed: result.gasUsed,
                                logs: result.logs,
                                status: result.status,
                                transactionHash: result.transactionHash
                            };
                        }));
                        const receipts_ = receipts.filter((x)=>x !== null);
                        if (receipts_.length === 0) return {
                            atomic: false,
                            chainId: '0x1',
                            id: params[0],
                            status: 100,
                            receipts: [],
                            version: '2.0.0'
                        };
                        return {
                            atomic: false,
                            chainId: '0x1',
                            id: params[0],
                            status: 200,
                            receipts: receipts_,
                            version: '2.0.0'
                        };
                    }
                    if (method === 'wallet_showCallsStatus') return;
                    // other methods
                    if (method === 'personal_sign') {
                        if (features.signMessageError) {
                            if (typeof features.signMessageError === 'boolean') throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$rpc$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["UserRejectedRequestError"](new Error('Failed to sign message.'));
                            throw features.signMessageError;
                        }
                        // Change `personal_sign` to `eth_sign` and swap params
                        method = 'eth_sign';
                        params = [
                            params[1],
                            params[0]
                        ];
                    }
                    const body = {
                        method,
                        params
                    };
                    const { error, result } = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$rpc$2f$compat$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpc"].http(url, {
                        body
                    });
                    if (error) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$errors$2f$request$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["RpcRequestError"]({
                        body,
                        error,
                        url
                    });
                    return result;
                };
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$clients$2f$transports$2f$custom$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["custom"])({
                    request
                })({
                    retryCount: 0
                });
            }
        }));
} //# sourceMappingURL=mock.js.map
}),
"[project]/node_modules/.pnpm/@wagmi+core@2.22.1_@tanstac_330bb306678ae270c70864ae393d7210/node_modules/@wagmi/core/dist/esm/utils/extractRpcUrls.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "extractRpcUrls",
    ()=>extractRpcUrls
]);
function extractRpcUrls(parameters) {
    var _parameters_transports_chain_id, _parameters_transports, _transport_value;
    const { chain } = parameters;
    const fallbackUrl = chain.rpcUrls.default.http[0];
    if (!parameters.transports) return [
        fallbackUrl
    ];
    const transport = (_parameters_transports = parameters.transports) === null || _parameters_transports === void 0 ? void 0 : (_parameters_transports_chain_id = _parameters_transports[chain.id]) === null || _parameters_transports_chain_id === void 0 ? void 0 : _parameters_transports_chain_id.call(_parameters_transports, {
        chain
    });
    const transports = (transport === null || transport === void 0 ? void 0 : (_transport_value = transport.value) === null || _transport_value === void 0 ? void 0 : _transport_value.transports) || [
        transport
    ];
    return transports.map((param)=>{
        let { value } = param;
        return (value === null || value === void 0 ? void 0 : value.url) || fallbackUrl;
    });
} //# sourceMappingURL=extractRpcUrls.js.map
}),
"[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/misc.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

//
// Types
//
//
// Type Guards
//
/**
 * A {@link NonEmptyArray} type guard.
 *
 * @template Element - The non-empty array member type.
 * @param value - The value to check.
 * @returns Whether the value is a non-empty array.
 */ __turbopack_context__.s([
    "ESCAPE_CHARACTERS_REGEXP",
    ()=>ESCAPE_CHARACTERS_REGEXP,
    "JsonSize",
    ()=>JsonSize,
    "calculateNumberSize",
    ()=>calculateNumberSize,
    "calculateStringSize",
    ()=>calculateStringSize,
    "getKnownPropertyNames",
    ()=>getKnownPropertyNames,
    "hasProperty",
    ()=>hasProperty,
    "isASCII",
    ()=>isASCII,
    "isNonEmptyArray",
    ()=>isNonEmptyArray,
    "isNullOrUndefined",
    ()=>isNullOrUndefined,
    "isObject",
    ()=>isObject,
    "isPlainObject",
    ()=>isPlainObject
]);
function isNonEmptyArray(value) {
    return Array.isArray(value) && value.length > 0;
}
function isNullOrUndefined(value) {
    return value === null || value === undefined;
}
function isObject(value) {
    return Boolean(value) && typeof value === 'object' && !Array.isArray(value);
}
const hasProperty = (objectToCheck, name)=>Object.hasOwnProperty.call(objectToCheck, name);
function getKnownPropertyNames(object) {
    return Object.getOwnPropertyNames(object);
}
var JsonSize;
(function(JsonSize) {
    JsonSize[JsonSize["Null"] = 4] = "Null";
    JsonSize[JsonSize["Comma"] = 1] = "Comma";
    JsonSize[JsonSize["Wrapper"] = 1] = "Wrapper";
    JsonSize[JsonSize["True"] = 4] = "True";
    JsonSize[JsonSize["False"] = 5] = "False";
    JsonSize[JsonSize["Quote"] = 1] = "Quote";
    JsonSize[JsonSize["Colon"] = 1] = "Colon";
    // eslint-disable-next-line @typescript-eslint/no-shadow
    JsonSize[JsonSize["Date"] = 24] = "Date";
})(JsonSize = JsonSize || (JsonSize = {}));
const ESCAPE_CHARACTERS_REGEXP = /"|\\|\n|\r|\t/gu;
function isPlainObject(value) {
    if (typeof value !== 'object' || value === null) {
        return false;
    }
    try {
        let proto = value;
        while(Object.getPrototypeOf(proto) !== null){
            proto = Object.getPrototypeOf(proto);
        }
        return Object.getPrototypeOf(value) === proto;
    } catch (_) {
        return false;
    }
}
function isASCII(character) {
    return character.charCodeAt(0) <= 127;
}
function calculateStringSize(value) {
    const size = value.split('').reduce((total, character)=>{
        if (isASCII(character)) {
            return total + 1;
        }
        return total + 2;
    }, 0);
    var _value_match;
    // Also detect characters that need backslash escape
    return size + ((_value_match = value.match(ESCAPE_CHARACTERS_REGEXP)) !== null && _value_match !== void 0 ? _value_match : []).length;
}
function calculateNumberSize(value) {
    return value.toString().length;
} //# sourceMappingURL=misc.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/errors.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getErrorMessage",
    ()=>getErrorMessage,
    "isErrorWithCode",
    ()=>isErrorWithCode,
    "isErrorWithMessage",
    ()=>isErrorWithMessage,
    "isErrorWithStack",
    ()=>isErrorWithStack,
    "wrapError",
    ()=>wrapError
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$pony$2d$cause$40$2$2e$1$2e$11$2f$node_modules$2f$pony$2d$cause$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/index.mjs [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$pony$2d$cause$40$2$2e$1$2e$11$2f$node_modules$2f$pony$2d$cause$2f$lib$2f$error$2d$with$2d$cause$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/lib/error-with-cause.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/misc.mjs [app-client] (ecmascript)");
;
;
/**
 * Type guard for determining whether the given value is an instance of Error.
 * For errors generated via `fs.promises`, `error instanceof Error` won't work,
 * so we have to come up with another way of testing.
 *
 * @param error - The object to check.
 * @returns A boolean.
 */ function isError(error) {
    return error instanceof Error || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(error) && error.constructor.name === 'Error';
}
function isErrorWithCode(error) {
    return typeof error === 'object' && error !== null && 'code' in error;
}
function isErrorWithMessage(error) {
    return typeof error === 'object' && error !== null && 'message' in error;
}
function isErrorWithStack(error) {
    return typeof error === 'object' && error !== null && 'stack' in error;
}
function getErrorMessage(error) {
    if (isErrorWithMessage(error) && typeof error.message === 'string') {
        return error.message;
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isNullOrUndefined"])(error)) {
        return '';
    }
    return String(error);
}
function wrapError(originalError, message) {
    if (isError(originalError)) {
        let error;
        if (Error.length === 2) {
            // for some reason `tsserver` is not complaining that the
            // Error constructor doesn't support a second argument in the editor,
            // but `tsc` does. Error causes are not supported by our current tsc target (ES2020, we need ES2022 to make this work)
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            error = new Error(message, {
                cause: originalError
            });
        } else {
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            error = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$pony$2d$cause$40$2$2e$1$2e$11$2f$node_modules$2f$pony$2d$cause$2f$lib$2f$error$2d$with$2d$cause$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ErrorWithCause"](message, {
                cause: originalError
            });
        }
        if (isErrorWithCode(originalError)) {
            error.code = originalError.code;
        }
        return error;
    }
    if (message.length > 0) {
        return new Error("".concat(String(originalError), ": ").concat(message));
    }
    return new Error(String(originalError));
} //# sourceMappingURL=errors.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/assert.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AssertionError",
    ()=>AssertionError,
    "assert",
    ()=>assert,
    "assertExhaustive",
    ()=>assertExhaustive,
    "assertStruct",
    ()=>assertStruct
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/errors.mjs [app-client] (ecmascript)");
;
;
/**
 * Check if a value is a constructor, i.e., a function that can be called with
 * the `new` keyword.
 *
 * @param fn - The value to check.
 * @returns `true` if the value is a constructor, or `false` otherwise.
 */ function isConstructable(fn) {
    var _fn_prototype_constructor, _fn_prototype;
    /* istanbul ignore next */ return Boolean(typeof (fn === null || fn === void 0 ? void 0 : (_fn_prototype = fn.prototype) === null || _fn_prototype === void 0 ? void 0 : (_fn_prototype_constructor = _fn_prototype.constructor) === null || _fn_prototype_constructor === void 0 ? void 0 : _fn_prototype_constructor.name) === 'string');
}
/**
 * Attempts to obtain the message from a possible error object. If it is
 * possible to do so, any trailing period will be removed from the message;
 * otherwise an empty string is returned.
 *
 * @param error - The error object to get the message from.
 * @returns The message without any trailing period if `error` is an object
 * with a `message` property; the string version of `error` without any trailing
 * period if it is not `undefined` or `null`; otherwise an empty string.
 */ function getErrorMessageWithoutTrailingPeriod(error) {
    // We'll add our own period.
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getErrorMessage"])(error).replace(/\.$/u, '');
}
/**
 * Initialise an {@link AssertionErrorConstructor} error.
 *
 * @param ErrorWrapper - The error class to use.
 * @param message - The error message.
 * @returns The error object.
 */ // eslint-disable-next-line @typescript-eslint/naming-convention
function getError(ErrorWrapper, message) {
    if (isConstructable(ErrorWrapper)) {
        return new ErrorWrapper({
            message
        });
    }
    return ErrorWrapper({
        message
    });
}
class AssertionError extends Error {
    constructor(options){
        super(options.message);
        this.code = 'ERR_ASSERTION';
    }
}
function assert(value) {
    let message = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'Assertion failed.', // eslint-disable-next-line @typescript-eslint/naming-convention
    ErrorWrapper = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : AssertionError;
    if (!value) {
        if (message instanceof Error) {
            throw message;
        }
        throw getError(ErrorWrapper, message);
    }
}
function assertStruct(value, struct) {
    let errorPrefix = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 'Assertion failed', // eslint-disable-next-line @typescript-eslint/naming-convention
    ErrorWrapper = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : AssertionError;
    try {
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assert"])(value, struct);
    } catch (error) {
        throw getError(ErrorWrapper, "".concat(errorPrefix, ": ").concat(getErrorMessageWithoutTrailingPeriod(error), "."));
    }
}
function assertExhaustive(_object) {
    throw new Error('Invalid branch reached. Should be detected during compilation.');
} //# sourceMappingURL=assert.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/json.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "JsonRpcErrorStruct",
    ()=>JsonRpcErrorStruct,
    "JsonRpcFailureStruct",
    ()=>JsonRpcFailureStruct,
    "JsonRpcIdStruct",
    ()=>JsonRpcIdStruct,
    "JsonRpcNotificationStruct",
    ()=>JsonRpcNotificationStruct,
    "JsonRpcParamsStruct",
    ()=>JsonRpcParamsStruct,
    "JsonRpcRequestStruct",
    ()=>JsonRpcRequestStruct,
    "JsonRpcResponseStruct",
    ()=>JsonRpcResponseStruct,
    "JsonRpcSuccessStruct",
    ()=>JsonRpcSuccessStruct,
    "JsonRpcVersionStruct",
    ()=>JsonRpcVersionStruct,
    "JsonStruct",
    ()=>JsonStruct,
    "PendingJsonRpcResponseStruct",
    ()=>PendingJsonRpcResponseStruct,
    "UnsafeJsonStruct",
    ()=>UnsafeJsonStruct,
    "assertIsJsonRpcError",
    ()=>assertIsJsonRpcError,
    "assertIsJsonRpcFailure",
    ()=>assertIsJsonRpcFailure,
    "assertIsJsonRpcNotification",
    ()=>assertIsJsonRpcNotification,
    "assertIsJsonRpcRequest",
    ()=>assertIsJsonRpcRequest,
    "assertIsJsonRpcResponse",
    ()=>assertIsJsonRpcResponse,
    "assertIsJsonRpcSuccess",
    ()=>assertIsJsonRpcSuccess,
    "assertIsPendingJsonRpcResponse",
    ()=>assertIsPendingJsonRpcResponse,
    "exactOptional",
    ()=>exactOptional,
    "getJsonRpcIdValidator",
    ()=>getJsonRpcIdValidator,
    "getJsonSize",
    ()=>getJsonSize,
    "getSafeJson",
    ()=>getSafeJson,
    "isJsonRpcError",
    ()=>isJsonRpcError,
    "isJsonRpcFailure",
    ()=>isJsonRpcFailure,
    "isJsonRpcNotification",
    ()=>isJsonRpcNotification,
    "isJsonRpcRequest",
    ()=>isJsonRpcRequest,
    "isJsonRpcResponse",
    ()=>isJsonRpcResponse,
    "isJsonRpcSuccess",
    ()=>isJsonRpcSuccess,
    "isPendingJsonRpcResponse",
    ()=>isPendingJsonRpcResponse,
    "isValidJson",
    ()=>isValidJson,
    "jsonrpc2",
    ()=>jsonrpc2,
    "object",
    ()=>object
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/types.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$coercions$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/coercions.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/utilities.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$refinements$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/refinements.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/assert.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/misc.mjs [app-client] (ecmascript)");
;
;
;
const object = (schema)=>// The type is slightly different from a regular object struct, because we
    // want to make properties with `undefined` in their type optional, but not
    // `undefined` itself. This means that we need a type cast.
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["object"])(schema);
/**
 * Check the last field of a path is present.
 *
 * @param context - The context to check.
 * @param context.path - The path to check.
 * @param context.branch - The branch to check.
 * @returns Whether the last field of a path is present.
 */ function hasOptional(param) {
    let { path, branch } = param;
    const field = path[path.length - 1];
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hasProperty"])(branch[branch.length - 2], field);
}
function exactOptional(struct) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        ...struct,
        type: "optional ".concat(struct.type),
        validator: (value, context)=>!hasOptional(context) || struct.validator(value, context),
        refiner: (value, context)=>!hasOptional(context) || struct.refiner(value, context)
    });
}
/**
 * Validate an unknown input to be valid JSON.
 *
 * Useful for constructing JSON structs.
 *
 * @param json - An unknown value.
 * @returns True if the value is valid JSON, otherwise false.
 */ function validateJson(json) {
    if (json === null || typeof json === 'boolean' || typeof json === 'string') {
        return true;
    }
    if (typeof json === 'number' && Number.isFinite(json)) {
        return true;
    }
    if (typeof json === 'object') {
        let every = true;
        if (Array.isArray(json)) {
            // Ignoring linting error since for-of is significantly slower than a normal for-loop
            // and performance is important in this specific function.
            // eslint-disable-next-line @typescript-eslint/prefer-for-of
            for(let i = 0; i < json.length; i++){
                if (!validateJson(json[i])) {
                    every = false;
                    break;
                }
            }
            return every;
        }
        const entries = Object.entries(json);
        // Ignoring linting errors since for-of is significantly slower than a normal for-loop
        // and performance is important in this specific function.
        // eslint-disable-next-line @typescript-eslint/prefer-for-of
        for(let i = 0; i < entries.length; i++){
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            if (typeof entries[i][0] !== 'string' || !validateJson(entries[i][1])) {
                every = false;
                break;
            }
        }
        return every;
    }
    return false;
}
const UnsafeJsonStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('JSON', (json)=>validateJson(json));
const JsonStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$coercions$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["coerce"])(UnsafeJsonStruct, (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$refinements$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["refine"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["any"])(), 'JSON', (value)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, UnsafeJsonStruct)), (value)=>JSON.parse(JSON.stringify(value, (propKey, propValue)=>{
        // Strip __proto__ and constructor properties to prevent prototype pollution.
        if (propKey === '__proto__' || propKey === 'constructor') {
            return undefined;
        }
        return propValue;
    })));
function isValidJson(value) {
    try {
        getSafeJson(value);
        return true;
    } catch (e) {
        return false;
    }
}
function getSafeJson(value) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["create"])(value, JsonStruct);
}
function getJsonSize(value) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonStruct, 'Invalid JSON value');
    const json = JSON.stringify(value);
    return new TextEncoder().encode(json).byteLength;
}
const jsonrpc2 = '2.0';
const JsonRpcVersionStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["literal"])(jsonrpc2);
const JsonRpcIdStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["nullable"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["union"])([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["number"])(),
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])()
]));
const JsonRpcErrorStruct = object({
    code: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["integer"])(),
    message: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])(),
    data: exactOptional(JsonStruct),
    stack: exactOptional((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])())
});
const JsonRpcParamsStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["union"])([
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["record"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])(), JsonStruct),
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["array"])(JsonStruct)
]);
const JsonRpcRequestStruct = object({
    id: JsonRpcIdStruct,
    jsonrpc: JsonRpcVersionStruct,
    method: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])(),
    params: exactOptional(JsonRpcParamsStruct)
});
const JsonRpcNotificationStruct = object({
    jsonrpc: JsonRpcVersionStruct,
    method: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])(),
    params: exactOptional(JsonRpcParamsStruct)
});
function isJsonRpcNotification(value) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, JsonRpcNotificationStruct);
}
function assertIsJsonRpcNotification(value, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonRpcNotificationStruct, 'Invalid JSON-RPC notification', ErrorWrapper);
}
function isJsonRpcRequest(value) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, JsonRpcRequestStruct);
}
function assertIsJsonRpcRequest(value, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonRpcRequestStruct, 'Invalid JSON-RPC request', ErrorWrapper);
}
const PendingJsonRpcResponseStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["object"])({
    id: JsonRpcIdStruct,
    jsonrpc: JsonRpcVersionStruct,
    result: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optional"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["unknown"])()),
    error: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optional"])(JsonRpcErrorStruct)
});
const JsonRpcSuccessStruct = object({
    id: JsonRpcIdStruct,
    jsonrpc: JsonRpcVersionStruct,
    result: JsonStruct
});
const JsonRpcFailureStruct = object({
    id: JsonRpcIdStruct,
    jsonrpc: JsonRpcVersionStruct,
    error: JsonRpcErrorStruct
});
const JsonRpcResponseStruct = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["union"])([
    JsonRpcSuccessStruct,
    JsonRpcFailureStruct
]);
function isPendingJsonRpcResponse(response) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(response, PendingJsonRpcResponseStruct);
}
function assertIsPendingJsonRpcResponse(response, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(response, PendingJsonRpcResponseStruct, 'Invalid pending JSON-RPC response', ErrorWrapper);
}
function isJsonRpcResponse(response) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(response, JsonRpcResponseStruct);
}
function assertIsJsonRpcResponse(value, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonRpcResponseStruct, 'Invalid JSON-RPC response', ErrorWrapper);
}
function isJsonRpcSuccess(value) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, JsonRpcSuccessStruct);
}
function assertIsJsonRpcSuccess(value, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonRpcSuccessStruct, 'Invalid JSON-RPC success response', ErrorWrapper);
}
function isJsonRpcFailure(value) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, JsonRpcFailureStruct);
}
function assertIsJsonRpcFailure(value, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonRpcFailureStruct, 'Invalid JSON-RPC failure response', ErrorWrapper);
}
function isJsonRpcError(value) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, JsonRpcErrorStruct);
}
function assertIsJsonRpcError(value, // eslint-disable-next-line @typescript-eslint/naming-convention
ErrorWrapper) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$assert$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStruct"])(value, JsonRpcErrorStruct, 'Invalid JSON-RPC error', ErrorWrapper);
}
function getJsonRpcIdValidator(options) {
    const { permitEmptyString, permitFractions, permitNull } = {
        permitEmptyString: true,
        permitFractions: false,
        permitNull: true,
        ...options
    };
    /**
     * Type guard for {@link JsonRpcId}.
     *
     * @param id - The JSON-RPC ID value to check.
     * @returns Whether the given ID is valid per the options given to the
     * factory.
     */ const isValidJsonRpcId = (id)=>{
        return Boolean(typeof id === 'number' && (permitFractions || Number.isInteger(id)) || typeof id === 'string' && (permitEmptyString || id.length > 0) || permitNull && id === null);
    };
    return isValidJsonRpcId;
} //# sourceMappingURL=json.mjs.map
}),
"[project]/node_modules/.pnpm/fast-safe-stringify@2.1.1/node_modules/fast-safe-stringify/index.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {

module.exports = stringify;
stringify.default = stringify;
stringify.stable = deterministicStringify;
stringify.stableStringify = deterministicStringify;
var LIMIT_REPLACE_NODE = '[...]';
var CIRCULAR_REPLACE_NODE = '[Circular]';
var arr = [];
var replacerStack = [];
function defaultOptions() {
    return {
        depthLimit: Number.MAX_SAFE_INTEGER,
        edgesLimit: Number.MAX_SAFE_INTEGER
    };
}
// Regular stringify
function stringify(obj, replacer, spacer, options) {
    if (typeof options === 'undefined') {
        options = defaultOptions();
    }
    decirc(obj, '', 0, [], undefined, 0, options);
    var res;
    try {
        if (replacerStack.length === 0) {
            res = JSON.stringify(obj, replacer, spacer);
        } else {
            res = JSON.stringify(obj, replaceGetterValues(replacer), spacer);
        }
    } catch (_) {
        return JSON.stringify('[unable to serialize, circular reference is too complex to analyze]');
    } finally{
        while(arr.length !== 0){
            var part = arr.pop();
            if (part.length === 4) {
                Object.defineProperty(part[0], part[1], part[3]);
            } else {
                part[0][part[1]] = part[2];
            }
        }
    }
    return res;
}
function setReplace(replace, val, k, parent) {
    var propertyDescriptor = Object.getOwnPropertyDescriptor(parent, k);
    if (propertyDescriptor.get !== undefined) {
        if (propertyDescriptor.configurable) {
            Object.defineProperty(parent, k, {
                value: replace
            });
            arr.push([
                parent,
                k,
                val,
                propertyDescriptor
            ]);
        } else {
            replacerStack.push([
                val,
                k,
                replace
            ]);
        }
    } else {
        parent[k] = replace;
        arr.push([
            parent,
            k,
            val
        ]);
    }
}
function decirc(val, k, edgeIndex, stack, parent, depth, options) {
    depth += 1;
    var i;
    if (typeof val === 'object' && val !== null) {
        for(i = 0; i < stack.length; i++){
            if (stack[i] === val) {
                setReplace(CIRCULAR_REPLACE_NODE, val, k, parent);
                return;
            }
        }
        if (typeof options.depthLimit !== 'undefined' && depth > options.depthLimit) {
            setReplace(LIMIT_REPLACE_NODE, val, k, parent);
            return;
        }
        if (typeof options.edgesLimit !== 'undefined' && edgeIndex + 1 > options.edgesLimit) {
            setReplace(LIMIT_REPLACE_NODE, val, k, parent);
            return;
        }
        stack.push(val);
        // Optimize for Arrays. Big arrays could kill the performance otherwise!
        if (Array.isArray(val)) {
            for(i = 0; i < val.length; i++){
                decirc(val[i], i, i, stack, val, depth, options);
            }
        } else {
            var keys = Object.keys(val);
            for(i = 0; i < keys.length; i++){
                var key = keys[i];
                decirc(val[key], key, i, stack, val, depth, options);
            }
        }
        stack.pop();
    }
}
// Stable-stringify
function compareFunction(a, b) {
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    }
    return 0;
}
function deterministicStringify(obj, replacer, spacer, options) {
    if (typeof options === 'undefined') {
        options = defaultOptions();
    }
    var tmp = deterministicDecirc(obj, '', 0, [], undefined, 0, options) || obj;
    var res;
    try {
        if (replacerStack.length === 0) {
            res = JSON.stringify(tmp, replacer, spacer);
        } else {
            res = JSON.stringify(tmp, replaceGetterValues(replacer), spacer);
        }
    } catch (_) {
        return JSON.stringify('[unable to serialize, circular reference is too complex to analyze]');
    } finally{
        // Ensure that we restore the object as it was.
        while(arr.length !== 0){
            var part = arr.pop();
            if (part.length === 4) {
                Object.defineProperty(part[0], part[1], part[3]);
            } else {
                part[0][part[1]] = part[2];
            }
        }
    }
    return res;
}
function deterministicDecirc(val, k, edgeIndex, stack, parent, depth, options) {
    depth += 1;
    var i;
    if (typeof val === 'object' && val !== null) {
        for(i = 0; i < stack.length; i++){
            if (stack[i] === val) {
                setReplace(CIRCULAR_REPLACE_NODE, val, k, parent);
                return;
            }
        }
        try {
            if (typeof val.toJSON === 'function') {
                return;
            }
        } catch (_) {
            return;
        }
        if (typeof options.depthLimit !== 'undefined' && depth > options.depthLimit) {
            setReplace(LIMIT_REPLACE_NODE, val, k, parent);
            return;
        }
        if (typeof options.edgesLimit !== 'undefined' && edgeIndex + 1 > options.edgesLimit) {
            setReplace(LIMIT_REPLACE_NODE, val, k, parent);
            return;
        }
        stack.push(val);
        // Optimize for Arrays. Big arrays could kill the performance otherwise!
        if (Array.isArray(val)) {
            for(i = 0; i < val.length; i++){
                deterministicDecirc(val[i], i, i, stack, val, depth, options);
            }
        } else {
            // Create a temporary object in the required way
            var tmp = {};
            var keys = Object.keys(val).sort(compareFunction);
            for(i = 0; i < keys.length; i++){
                var key = keys[i];
                deterministicDecirc(val[key], key, i, stack, val, depth, options);
                tmp[key] = val[key];
            }
            if (typeof parent !== 'undefined') {
                arr.push([
                    parent,
                    k,
                    val
                ]);
                parent[k] = tmp;
            } else {
                return tmp;
            }
        }
        stack.pop();
    }
}
// wraps replacer function to handle values we couldn't replace
// and mark them as replaced value
function replaceGetterValues(replacer) {
    replacer = typeof replacer !== 'undefined' ? replacer : function(k, v) {
        return v;
    };
    return function(key, val) {
        if (replacerStack.length > 0) {
            for(var i = 0; i < replacerStack.length; i++){
                var part = replacerStack[i];
                if (part[1] === key && part[0] === val) {
                    val = part[2];
                    replacerStack.splice(i, 1);
                    break;
                }
            }
        }
        return replacer.call(this, key, val);
    };
}
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/error.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * A `StructFailure` represents a single specific failure in validation.
 */ /**
 * `StructError` objects are thrown (or returned) when validation fails.
 *
 * Validation logic is design to exit early for maximum performance. The error
 * represents the first error encountered during validation. For more detail,
 * the `error.failures` property is a generator function that can be run to
 * continue validation and receive all the failures in the data.
 */ __turbopack_context__.s([
    "StructError",
    ()=>StructError
]);
class StructError extends TypeError {
    constructor(failure, failures){
        let cached;
        const { message, explanation, ...rest } = failure;
        const { path } = failure;
        const cause = path.length === 0 ? message : "At path: ".concat(path.join('.'), " -- ").concat(message);
        super(explanation !== null && explanation !== void 0 ? explanation : cause);
        if (explanation !== null && explanation !== undefined) {
            this.cause = cause;
        }
        Object.assign(this, rest);
        this.name = this.constructor.name;
        this.failures = ()=>{
            return cached !== null && cached !== void 0 ? cached : cached = [
                failure,
                ...failures()
            ];
        };
    }
} //# sourceMappingURL=error.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/utils.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Check if a value is an iterator.
 *
 * @param value - The value to check.
 * @returns Whether the value is an iterator.
 */ __turbopack_context__.s([
    "isObject",
    ()=>isObject,
    "isPlainObject",
    ()=>isPlainObject,
    "print",
    ()=>print,
    "run",
    ()=>run,
    "shiftIterator",
    ()=>shiftIterator,
    "toFailure",
    ()=>toFailure,
    "toFailures",
    ()=>toFailures
]);
function isIterable(value) {
    return isObject(value) && typeof value[Symbol.iterator] === 'function';
}
function isObject(value) {
    return typeof value === 'object' && value !== null;
}
function isPlainObject(value) {
    if (Object.prototype.toString.call(value) !== '[object Object]') {
        return false;
    }
    const prototype = Object.getPrototypeOf(value);
    return prototype === null || prototype === Object.prototype;
}
function print(value) {
    if (typeof value === 'symbol') {
        return value.toString();
    }
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    return typeof value === 'string' ? JSON.stringify(value) : "".concat(value);
}
function shiftIterator(input) {
    const { done, value } = input.next();
    return done ? undefined : value;
}
function toFailure(result, context, struct, value) {
    if (result === true) {
        return undefined;
    } else if (result === false) {
        // eslint-disable-next-line no-param-reassign
        result = {};
    } else if (typeof result === 'string') {
        // eslint-disable-next-line no-param-reassign
        result = {
            message: result
        };
    }
    const { path, branch } = context;
    const { type } = struct;
    const { refinement, message = "Expected a value of type `".concat(type, "`").concat(refinement ? " with refinement `".concat(refinement, "`") : '', ", but received: `").concat(print(value), "`") } = result;
    return {
        value,
        type,
        refinement,
        key: path[path.length - 1],
        path,
        branch,
        ...result,
        message
    };
}
function* toFailures(result, context, struct, value) {
    if (!isIterable(result)) {
        // eslint-disable-next-line no-param-reassign
        result = [
            result
        ];
    }
    for (const validationResult of result){
        const failure = toFailure(validationResult, context, struct, value);
        if (failure) {
            yield failure;
        }
    }
}
function* run(value, struct) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    const { path = [], branch = [
        value
    ], coerce = false, mask = false } = options;
    const context = {
        path,
        branch
    };
    if (coerce) {
        // eslint-disable-next-line no-param-reassign
        value = struct.coercer(value, context);
        if (mask && struct.type !== 'type' && isObject(struct.schema) && isObject(value) && !Array.isArray(value)) {
            for(const key in value){
                if (struct.schema[key] === undefined) {
                    delete value[key];
                }
            }
        }
    }
    let status = 'valid';
    for (const failure of struct.validator(value, context)){
        failure.explanation = options.message;
        status = 'not_valid';
        yield [
            failure,
            undefined
        ];
    }
    // eslint-disable-next-line prefer-const
    for (let [innerKey, innerValue, innerStruct] of struct.entries(value, context)){
        const iterable = run(innerValue, innerStruct, {
            path: innerKey === undefined ? path : [
                ...path,
                innerKey
            ],
            branch: innerKey === undefined ? branch : [
                ...branch,
                innerValue
            ],
            coerce,
            mask,
            message: options.message
        });
        for (const result of iterable){
            if (result[0]) {
                status = result[0].refinement === null || result[0].refinement === undefined ? 'not_valid' : 'not_refined';
                yield [
                    result[0],
                    undefined
                ];
            } else if (coerce) {
                innerValue = result[1];
                if (innerKey === undefined) {
                    // eslint-disable-next-line no-param-reassign
                    value = innerValue;
                } else if (value instanceof Map) {
                    value.set(innerKey, innerValue);
                } else if (value instanceof Set) {
                    value.add(innerValue);
                } else if (isObject(value)) {
                    if (innerValue !== undefined || innerKey in value) {
                        value[innerKey] = innerValue;
                    }
                }
            }
        }
    }
    if (status !== 'not_valid') {
        for (const failure of struct.refiner(value, context)){
            failure.explanation = options.message;
            status = 'not_refined';
            yield [
                failure,
                undefined
            ];
        }
    }
    if (status === 'valid') {
        yield [
            undefined,
            value
        ];
    }
} //# sourceMappingURL=utils.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ExactOptionalStruct",
    ()=>ExactOptionalStruct,
    "Struct",
    ()=>Struct,
    "assert",
    ()=>assert,
    "create",
    ()=>create,
    "is",
    ()=>is,
    "mask",
    ()=>mask,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$error$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/error.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/utils.mjs [app-client] (ecmascript)");
;
;
class Struct {
    /**
     * Assert that a value passes the struct's validation, throwing if it doesn't.
     */ assert(value, message) {
        return assert(value, this, message);
    }
    /**
     * Create a value with the struct's coercion logic, then validate it.
     */ create(value, message) {
        return create(value, this, message);
    }
    /**
     * Check if a value passes the struct's validation.
     */ is(value) {
        return is(value, this);
    }
    /**
     * Mask a value, coercing and validating it, but returning only the subset of
     * properties defined by the struct's schema.
     */ mask(value, message) {
        return mask(value, this, message);
    }
    /**
     * Validate a value with the struct's validation logic, returning a tuple
     * representing the result.
     *
     * You may optionally pass `true` for the `withCoercion` argument to coerce
     * the value before attempting to validate it. If you do, the result will
     * contain the coerced result when successful.
     */ validate(value) {
        let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        return validate(value, this, options);
    }
    constructor(props){
        const { type, schema, validator, refiner, coercer = (value)=>value, entries = function*() {
        /* noop */ } } = props;
        this.type = type;
        this.schema = schema;
        this.entries = entries;
        this.coercer = coercer;
        if (validator) {
            this.validator = (value, context)=>{
                const result = validator(value, context);
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toFailures"])(result, context, this, value);
            };
        } else {
            this.validator = ()=>[];
        }
        if (refiner) {
            this.refiner = (value, context)=>{
                const result = refiner(value, context);
                return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toFailures"])(result, context, this, value);
            };
        } else {
            this.refiner = ()=>[];
        }
    }
}
// String instead of a Symbol in case of multiple different versions of this library.
const ExactOptionalBrand = 'EXACT_OPTIONAL';
class ExactOptionalStruct extends Struct {
    static isExactOptional(value) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value) && 'brand' in value && value.brand === ExactOptionalBrand;
    }
    constructor(props){
        super({
            ...props,
            type: "exact optional ".concat(props.type)
        });
        this.brand = ExactOptionalBrand;
    }
}
function assert(value, struct, message) {
    const result = validate(value, struct, {
        message
    });
    if (result[0]) {
        throw result[0];
    }
}
function create(value, struct, message) {
    const result = validate(value, struct, {
        coerce: true,
        message
    });
    if (result[0]) {
        throw result[0];
    } else {
        return result[1];
    }
}
function mask(value, struct, message) {
    const result = validate(value, struct, {
        coerce: true,
        mask: true,
        message
    });
    if (result[0]) {
        throw result[0];
    } else {
        return result[1];
    }
}
function is(value, struct) {
    const result = validate(value, struct);
    return !result[0];
}
function validate(value, struct) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    const tuples = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["run"])(value, struct, options);
    const tuple = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["shiftIterator"])(tuples);
    if (tuple[0]) {
        const error = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$error$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["StructError"](tuple[0], function*() {
            for (const innerTuple of tuples){
                if (innerTuple[0]) {
                    yield innerTuple[0];
                }
            }
        });
        return [
            error,
            undefined
        ];
    }
    const validatedValue = tuple[1];
    return [
        undefined,
        validatedValue
    ];
} //# sourceMappingURL=struct.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/utilities.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "assign",
    ()=>assign,
    "define",
    ()=>define,
    "deprecated",
    ()=>deprecated,
    "dynamic",
    ()=>dynamic,
    "lazy",
    ()=>lazy,
    "omit",
    ()=>omit,
    "partial",
    ()=>partial,
    "pick",
    ()=>pick
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/types.mjs [app-client] (ecmascript)");
;
;
function assign() {
    for(var _len = arguments.length, Structs = new Array(_len), _key = 0; _key < _len; _key++){
        Structs[_key] = arguments[_key];
    }
    var _Structs_;
    const isType = ((_Structs_ = Structs[0]) === null || _Structs_ === void 0 ? void 0 : _Structs_.type) === 'type';
    const schemas = Structs.map((param)=>{
        let { schema } = param;
        return schema;
    });
    const schema = Object.assign({}, ...schemas);
    return isType ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["type"])(schema) : (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["object"])(schema);
}
function define(name, validator) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: name,
        schema: null,
        validator
    });
}
function deprecated(struct, log) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        ...struct,
        refiner: (value, ctx)=>value === undefined || struct.refiner(value, ctx),
        validator (value, ctx) {
            if (value === undefined) {
                return true;
            }
            log(value, ctx);
            return struct.validator(value, ctx);
        }
    });
}
function dynamic(fn) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'dynamic',
        schema: null,
        *entries (value, ctx) {
            const struct = fn(value, ctx);
            yield* struct.entries(value, ctx);
        },
        validator (value, ctx) {
            const struct = fn(value, ctx);
            return struct.validator(value, ctx);
        },
        coercer (value, ctx) {
            const struct = fn(value, ctx);
            return struct.coercer(value, ctx);
        },
        refiner (value, ctx) {
            const struct = fn(value, ctx);
            return struct.refiner(value, ctx);
        }
    });
}
function lazy(fn) {
    let struct;
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'lazy',
        schema: null,
        *entries (value, ctx) {
            struct !== null && struct !== void 0 ? struct : struct = fn();
            yield* struct.entries(value, ctx);
        },
        validator (value, ctx) {
            struct !== null && struct !== void 0 ? struct : struct = fn();
            return struct.validator(value, ctx);
        },
        coercer (value, ctx) {
            struct !== null && struct !== void 0 ? struct : struct = fn();
            return struct.coercer(value, ctx);
        },
        refiner (value, ctx) {
            struct !== null && struct !== void 0 ? struct : struct = fn();
            return struct.refiner(value, ctx);
        }
    });
}
function omit(struct, keys) {
    const { schema } = struct;
    const subschema = {
        ...schema
    };
    for (const key of keys){
        delete subschema[key];
    }
    switch(struct.type){
        case 'type':
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["type"])(subschema);
        default:
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["object"])(subschema);
    }
}
function partial(struct) {
    const isStruct = struct instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"];
    const schema = isStruct ? {
        ...struct.schema
    } : {
        ...struct
    };
    // eslint-disable-next-line guard-for-in
    for(const key in schema){
        schema[key] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optional"])(schema[key]);
    }
    if (isStruct && struct.type === 'type') {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["type"])(schema);
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["object"])(schema);
}
function pick(struct, keys) {
    const { schema } = struct;
    const subschema = {};
    for (const key of keys){
        subschema[key] = schema[key];
    }
    switch(struct.type){
        case 'type':
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["type"])(subschema);
        default:
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["object"])(subschema);
    }
} //# sourceMappingURL=utilities.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/types.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "any",
    ()=>any,
    "array",
    ()=>array,
    "bigint",
    ()=>bigint,
    "boolean",
    ()=>boolean,
    "date",
    ()=>date,
    "enums",
    ()=>enums,
    "exactOptional",
    ()=>exactOptional,
    "func",
    ()=>func,
    "instance",
    ()=>instance,
    "integer",
    ()=>integer,
    "intersection",
    ()=>intersection,
    "literal",
    ()=>literal,
    "map",
    ()=>map,
    "never",
    ()=>never,
    "nullable",
    ()=>nullable,
    "number",
    ()=>number,
    "object",
    ()=>object,
    "optional",
    ()=>optional,
    "record",
    ()=>record,
    "regexp",
    ()=>regexp,
    "set",
    ()=>set,
    "string",
    ()=>string,
    "tuple",
    ()=>tuple,
    "type",
    ()=>type,
    "union",
    ()=>union,
    "unknown",
    ()=>unknown
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/utils.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/utilities.mjs [app-client] (ecmascript)");
;
;
;
function any() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('any', ()=>true);
}
function array(Element) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'array',
        schema: Element,
        *entries (value) {
            if (Element && Array.isArray(value)) {
                for (const [index, arrayValue] of value.entries()){
                    yield [
                        index,
                        arrayValue,
                        Element
                    ];
                }
            }
        },
        coercer (value) {
            return Array.isArray(value) ? value.slice() : value;
        },
        validator (value) {
            return Array.isArray(value) || "Expected an array value, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function bigint() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('bigint', (value)=>{
        return typeof value === 'bigint';
    });
}
function boolean() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('boolean', (value)=>{
        return typeof value === 'boolean';
    });
}
function date() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('date', (value)=>{
        return value instanceof Date && !isNaN(value.getTime()) || "Expected a valid `Date` object, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
    });
}
function enums(values) {
    const schema = {};
    const description = values.map((value)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value)).join();
    for (const key of values){
        schema[key] = key;
    }
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'enums',
        schema,
        validator (value) {
            return values.includes(value) || "Expected one of `".concat(description, "`, but received: ").concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function func() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('func', (value)=>{
        return typeof value === 'function' || "Expected a function, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
    });
}
function instance(Class) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('instance', (value)=>{
        return value instanceof Class || "Expected a `".concat(Class.name, "` instance, but received: ").concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
    });
}
function integer() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('integer', (value)=>{
        return typeof value === 'number' && !isNaN(value) && Number.isInteger(value) || "Expected an integer, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
    });
}
function intersection(Structs) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'intersection',
        schema: null,
        *entries (value, context) {
            for (const { entries } of Structs){
                yield* entries(value, context);
            }
        },
        *validator (value, context) {
            for (const { validator } of Structs){
                yield* validator(value, context);
            }
        },
        *refiner (value, context) {
            for (const { refiner } of Structs){
                yield* refiner(value, context);
            }
        }
    });
}
function literal(constant) {
    const description = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(constant);
    const valueType = typeof constant;
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'literal',
        schema: valueType === 'string' || valueType === 'number' || valueType === 'boolean' ? constant : null,
        validator (value) {
            return value === constant || "Expected the literal `".concat(description, "`, but received: ").concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function map(Key, Value) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'map',
        schema: null,
        *entries (value) {
            if (Key && Value && value instanceof Map) {
                for (const [mapKey, mapValue] of value.entries()){
                    yield [
                        mapKey,
                        mapKey,
                        Key
                    ];
                    yield [
                        mapKey,
                        mapValue,
                        Value
                    ];
                }
            }
        },
        coercer (value) {
            return value instanceof Map ? new Map(value) : value;
        },
        validator (value) {
            return value instanceof Map || "Expected a `Map` object, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function never() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('never', ()=>false);
}
function nullable(struct) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        ...struct,
        validator: (value, ctx)=>value === null || struct.validator(value, ctx),
        refiner: (value, ctx)=>value === null || struct.refiner(value, ctx)
    });
}
function number() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('number', (value)=>{
        return typeof value === 'number' && !isNaN(value) || "Expected a number, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
    });
}
function object(schema) {
    const knowns = schema ? Object.keys(schema) : [];
    const Never = never();
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'object',
        schema: schema !== null && schema !== void 0 ? schema : null,
        *entries (value) {
            if (schema && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value)) {
                const unknowns = new Set(Object.keys(value));
                for (const key of knowns){
                    unknowns.delete(key);
                    const propertySchema = schema[key];
                    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ExactOptionalStruct"].isExactOptional(propertySchema) && !Object.prototype.hasOwnProperty.call(value, key)) {
                        continue;
                    }
                    yield [
                        key,
                        value[key],
                        schema[key]
                    ];
                }
                for (const key of unknowns){
                    yield [
                        key,
                        value[key],
                        Never
                    ];
                }
            }
        },
        validator (value) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value) || "Expected an object, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        },
        coercer (value) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value) ? {
                ...value
            } : value;
        }
    });
}
function optional(struct) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        ...struct,
        validator: (value, ctx)=>value === undefined || struct.validator(value, ctx),
        refiner: (value, ctx)=>value === undefined || struct.refiner(value, ctx)
    });
}
function exactOptional(struct) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ExactOptionalStruct"](struct);
}
function record(Key, Value) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'record',
        schema: null,
        *entries (value) {
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value)) {
                // eslint-disable-next-line guard-for-in
                for(const objectKey in value){
                    const objectValue = value[objectKey];
                    yield [
                        objectKey,
                        objectKey,
                        Key
                    ];
                    yield [
                        objectKey,
                        objectValue,
                        Value
                    ];
                }
            }
        },
        validator (value) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value) || "Expected an object, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function regexp() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('regexp', (value)=>{
        return value instanceof RegExp;
    });
}
function set(Element) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'set',
        schema: null,
        *entries (value) {
            if (Element && value instanceof Set) {
                for (const setValue of value){
                    yield [
                        setValue,
                        setValue,
                        Element
                    ];
                }
            }
        },
        coercer (value) {
            return value instanceof Set ? new Set(value) : value;
        },
        validator (value) {
            return value instanceof Set || "Expected a `Set` object, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function string() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('string', (value)=>{
        return typeof value === 'string' || "Expected a string, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
    });
}
function tuple(Structs) {
    const Never = never();
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'tuple',
        schema: null,
        *entries (value) {
            if (Array.isArray(value)) {
                const length = Math.max(Structs.length, value.length);
                for(let i = 0; i < length; i++){
                    yield [
                        i,
                        value[i],
                        Structs[i] || Never
                    ];
                }
            }
        },
        validator (value) {
            return Array.isArray(value) || "Expected an array, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        }
    });
}
function type(schema) {
    const keys = Object.keys(schema);
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'type',
        schema,
        *entries (value) {
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value)) {
                for (const k of keys){
                    yield [
                        k,
                        value[k],
                        schema[k]
                    ];
                }
            }
        },
        validator (value) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value) || "Expected an object, but received: ".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value));
        },
        coercer (value) {
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(value) ? {
                ...value
            } : value;
        }
    });
}
function union(Structs) {
    const description = Structs.map((struct)=>struct.type).join(' | ');
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        type: 'union',
        schema: null,
        coercer (value) {
            for (const InnerStruct of Structs){
                const [error, coerced] = InnerStruct.validate(value, {
                    coerce: true
                });
                if (!error) {
                    return coerced;
                }
            }
            return value;
        },
        validator (value, ctx) {
            const failures = [];
            for (const InnerStruct of Structs){
                const [...tuples] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["run"])(value, InnerStruct, ctx);
                const [first] = tuples;
                if (!(first === null || first === void 0 ? void 0 : first[0])) {
                    return [];
                }
                for (const [failure] of tuples){
                    if (failure) {
                        failures.push(failure);
                    }
                }
            }
            return [
                "Expected the value to satisfy a union of `".concat(description, "`, but received: ").concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["print"])(value)),
                ...failures
            ];
        }
    });
}
function unknown() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$utilities$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["define"])('unknown', ()=>true);
} //# sourceMappingURL=types.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/coercions.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "coerce",
    ()=>coerce,
    "defaulted",
    ()=>defaulted,
    "trimmed",
    ()=>trimmed
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/utils.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/types.mjs [app-client] (ecmascript)");
;
;
;
function coerce(struct, condition, coercer) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        ...struct,
        coercer: (value, ctx)=>{
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["is"])(value, condition) ? struct.coercer(coercer(value, ctx), ctx) : struct.coercer(value, ctx);
        }
    });
}
function defaulted(struct, fallback) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    return coerce(struct, (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["unknown"])(), (value)=>{
        const result = typeof fallback === 'function' ? fallback() : fallback;
        if (value === undefined) {
            return result;
        }
        if (!options.strict && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isPlainObject"])(value) && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isPlainObject"])(result)) {
            const ret = {
                ...value
            };
            let changed = false;
            for(const key in result){
                if (ret[key] === undefined) {
                    ret[key] = result[key];
                    changed = true;
                }
            }
            if (changed) {
                return ret;
            }
        }
        return value;
    });
}
function trimmed(struct) {
    return coerce(struct, (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$structs$2f$types$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["string"])(), (value)=>value.trim());
} //# sourceMappingURL=coercions.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/structs/refinements.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "empty",
    ()=>empty,
    "max",
    ()=>max,
    "min",
    ()=>min,
    "nonempty",
    ()=>nonempty,
    "pattern",
    ()=>pattern,
    "refine",
    ()=>refine,
    "size",
    ()=>size
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/struct.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+superstruct@3.2.1/node_modules/@metamask/superstruct/dist/utils.mjs [app-client] (ecmascript)");
;
;
function empty(struct) {
    return refine(struct, 'empty', (value)=>{
        // eslint-disable-next-line @typescript-eslint/no-shadow
        const size = getSize(value);
        return size === 0 || "Expected an empty ".concat(struct.type, " but received one with a size of `").concat(size, "`");
    });
}
/**
 * Get the size of a string, array, map, or set.
 *
 * @param value - The value to measure.
 * @returns The size of the value.
 */ function getSize(value) {
    if (value instanceof Map || value instanceof Set) {
        return value.size;
    }
    return value.length;
}
function max(struct, threshold) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    const { exclusive } = options;
    return refine(struct, 'max', (value)=>{
        return exclusive ? value < threshold : value <= threshold || "Expected a ".concat(struct.type, " less than ").concat(exclusive ? '' : 'or equal to ').concat(threshold, " but received `").concat(value, "`");
    });
}
function min(struct, threshold) {
    let options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    const { exclusive } = options;
    return refine(struct, 'min', (value)=>{
        return exclusive ? value > threshold : value >= threshold || "Expected a ".concat(struct.type, " greater than ").concat(exclusive ? '' : 'or equal to ').concat(threshold, " but received `").concat(value, "`");
    });
}
function nonempty(struct) {
    return refine(struct, 'nonempty', (value)=>{
        // eslint-disable-next-line @typescript-eslint/no-shadow
        const size = getSize(value);
        return size > 0 || "Expected a nonempty ".concat(struct.type, " but received an empty one");
    });
}
function pattern(struct, regexp) {
    return refine(struct, 'pattern', (value)=>{
        return regexp.test(value) || "Expected a ".concat(struct.type, " matching `/").concat(regexp.source, '/` but received "').concat(value, '"');
    });
}
function size(struct, minimum) {
    let maximum = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : minimum;
    const expected = "Expected a ".concat(struct.type);
    const of = minimum === maximum ? "of `".concat(minimum, "`") : "between `".concat(minimum, "` and `").concat(maximum, "`");
    return refine(struct, 'size', (value)=>{
        if (typeof value === 'number' || value instanceof Date) {
            return minimum <= value && value <= maximum || // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            "".concat(expected, " ").concat(of, " but received `").concat(value, "`");
        } else if (value instanceof Map || value instanceof Set) {
            // eslint-disable-next-line @typescript-eslint/no-shadow
            const { size } = value;
            return minimum <= size && size <= maximum || "".concat(expected, " with a size ").concat(of, " but received one with a size of `").concat(size, "`");
        }
        const { length } = value;
        return minimum <= length && length <= maximum || "".concat(expected, " with a length ").concat(of, " but received one with a length of `").concat(length, "`");
    });
}
function refine(struct, name, refiner) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$struct$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Struct"]({
        ...struct,
        *refiner (value, ctx) {
            yield* struct.refiner(value, ctx);
            const result = refiner(value, ctx);
            const failures = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$superstruct$40$3$2e$2$2e$1$2f$node_modules$2f40$metamask$2f$superstruct$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toFailures"])(result, ctx, struct, value);
            for (const failure of failures){
                yield {
                    ...failure,
                    refinement: name
                };
            }
        }
    });
} //# sourceMappingURL=refinements.mjs.map
}),
"[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/lib/error-with-cause.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "ErrorWithCause",
    ()=>ErrorWithCause
]);
'use strict';
class ErrorWithCause extends Error {
    /**
   * @param {string} message
   * @param {{ cause?: T }} options
   */ constructor(message, { cause } = {}){
        super(message);
        /** @type {string} */ this.name = ErrorWithCause.name;
        if (cause) {
            /** @type {T} */ this.cause = cause;
        }
        /** @type {string} */ this.message = message;
    }
}
}),
"[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/lib/helpers.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "findCauseByReference",
    ()=>findCauseByReference,
    "getErrorCause",
    ()=>getErrorCause,
    "messageWithCauses",
    ()=>messageWithCauses,
    "stackWithCauses",
    ()=>stackWithCauses
]);
'use strict';
const findCauseByReference = (err, reference)=>{
    if (!err || !reference) return;
    if (!(err instanceof Error)) return;
    if (!(reference.prototype instanceof Error) && // @ts-ignore
    reference !== Error) return;
    /**
   * Ensures we don't go circular
   *
   * @type {Set<Error>}
   */ const seen = new Set();
    /** @type {Error|undefined} */ let currentErr = err;
    while(currentErr && !seen.has(currentErr)){
        seen.add(currentErr);
        if (currentErr instanceof reference) {
            return currentErr;
        }
        currentErr = getErrorCause(currentErr);
    }
};
const getErrorCause = (err)=>{
    if (!err || typeof err !== 'object' || !('cause' in err)) {
        return;
    }
    // VError / NError style causes
    if (typeof err.cause === 'function') {
        const causeResult = err.cause();
        return causeResult instanceof Error ? causeResult : undefined;
    } else {
        return err.cause instanceof Error ? err.cause : undefined;
    }
};
/**
 * Internal method that keeps a track of which error we have already added, to avoid circular recursion
 *
 * @private
 * @param {Error} err
 * @param {Set<Error>} seen
 * @returns {string}
 */ const _stackWithCauses = (err, seen)=>{
    if (!(err instanceof Error)) return '';
    const stack = err.stack || '';
    // Ensure we don't go circular or crazily deep
    if (seen.has(err)) {
        return stack + '\ncauses have become circular...';
    }
    const cause = getErrorCause(err);
    // TODO: Follow up in https://github.com/nodejs/node/issues/38725#issuecomment-920309092 on how to log stuff
    if (cause) {
        seen.add(err);
        return stack + '\ncaused by: ' + _stackWithCauses(cause, seen);
    } else {
        return stack;
    }
};
const stackWithCauses = (err)=>_stackWithCauses(err, new Set());
/**
 * Internal method that keeps a track of which error we have already added, to avoid circular recursion
 *
 * @private
 * @param {Error} err
 * @param {Set<Error>} seen
 * @param {boolean} [skip]
 * @returns {string}
 */ const _messageWithCauses = (err, seen, skip)=>{
    if (!(err instanceof Error)) return '';
    const message = skip ? '' : err.message || '';
    // Ensure we don't go circular or crazily deep
    if (seen.has(err)) {
        return message + ': ...';
    }
    const cause = getErrorCause(err);
    if (cause) {
        seen.add(err);
        const skipIfVErrorStyleCause = 'cause' in err && typeof err.cause === 'function';
        return message + (skipIfVErrorStyleCause ? '' : ': ') + _messageWithCauses(cause, seen, skipIfVErrorStyleCause);
    } else {
        return message;
    }
};
const messageWithCauses = (err)=>_messageWithCauses(err, new Set());
}),
"[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/index.mjs [app-client] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$pony$2d$cause$40$2$2e$1$2e$11$2f$node_modules$2f$pony$2d$cause$2f$lib$2f$error$2d$with$2d$cause$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/lib/error-with-cause.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$pony$2d$cause$40$2$2e$1$2e$11$2f$node_modules$2f$pony$2d$cause$2f$lib$2f$helpers$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/pony-cause@2.1.11/node_modules/pony-cause/lib/helpers.mjs [app-client] (ecmascript)");
'use strict';
;
;
}),
"[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/error-constants.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "errorCodes",
    ()=>errorCodes,
    "errorValues",
    ()=>errorValues
]);
const errorCodes = {
    rpc: {
        invalidInput: -32000,
        resourceNotFound: -32001,
        resourceUnavailable: -32002,
        transactionRejected: -32003,
        methodNotSupported: -32004,
        limitExceeded: -32005,
        parse: -32700,
        invalidRequest: -32600,
        methodNotFound: -32601,
        invalidParams: -32602,
        internal: -32603
    },
    provider: {
        userRejectedRequest: 4001,
        unauthorized: 4100,
        unsupportedMethod: 4200,
        disconnected: 4900,
        chainDisconnected: 4901
    }
};
const errorValues = {
    '-32700': {
        standard: 'JSON RPC 2.0',
        message: 'Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text.'
    },
    '-32600': {
        standard: 'JSON RPC 2.0',
        message: 'The JSON sent is not a valid Request object.'
    },
    '-32601': {
        standard: 'JSON RPC 2.0',
        message: 'The method does not exist / is not available.'
    },
    '-32602': {
        standard: 'JSON RPC 2.0',
        message: 'Invalid method parameter(s).'
    },
    '-32603': {
        standard: 'JSON RPC 2.0',
        message: 'Internal JSON-RPC error.'
    },
    '-32000': {
        standard: 'EIP-1474',
        message: 'Invalid input.'
    },
    '-32001': {
        standard: 'EIP-1474',
        message: 'Resource not found.'
    },
    '-32002': {
        standard: 'EIP-1474',
        message: 'Resource unavailable.'
    },
    '-32003': {
        standard: 'EIP-1474',
        message: 'Transaction rejected.'
    },
    '-32004': {
        standard: 'EIP-1474',
        message: 'Method not supported.'
    },
    '-32005': {
        standard: 'EIP-1474',
        message: 'Request limit exceeded.'
    },
    '4001': {
        standard: 'EIP-1193',
        message: 'User rejected the request.'
    },
    '4100': {
        standard: 'EIP-1193',
        message: 'The requested account and/or method has not been authorized by the user.'
    },
    '4200': {
        standard: 'EIP-1193',
        message: 'The requested method is not supported by this Ethereum provider.'
    },
    '4900': {
        standard: 'EIP-1193',
        message: 'The provider is disconnected from all chains.'
    },
    '4901': {
        standard: 'EIP-1193',
        message: 'The provider is disconnected from the specified chain.'
    }
}; /* eslint-enable @typescript-eslint/naming-convention */  //# sourceMappingURL=error-constants.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/utils.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "JSON_RPC_SERVER_ERROR_MESSAGE",
    ()=>JSON_RPC_SERVER_ERROR_MESSAGE,
    "dataHasCause",
    ()=>dataHasCause,
    "getMessageFromCode",
    ()=>getMessageFromCode,
    "isValidCode",
    ()=>isValidCode,
    "serializeCause",
    ()=>serializeCause,
    "serializeError",
    ()=>serializeError
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/misc.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$json$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/json.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/error-constants.mjs [app-client] (ecmascript)");
;
;
const FALLBACK_ERROR_CODE = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.internal;
const FALLBACK_MESSAGE = 'Unspecified error message. This is a bug, please report it.';
const FALLBACK_ERROR = {
    code: FALLBACK_ERROR_CODE,
    message: getMessageFromCode(FALLBACK_ERROR_CODE)
};
const JSON_RPC_SERVER_ERROR_MESSAGE = 'Unspecified server error.';
function getMessageFromCode(code) {
    let fallbackMessage = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : FALLBACK_MESSAGE;
    if (isValidCode(code)) {
        const codeString = code.toString();
        if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hasProperty"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorValues"], codeString)) {
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorValues"][codeString].message;
        }
        if (isJsonRpcServerError(code)) {
            return JSON_RPC_SERVER_ERROR_MESSAGE;
        }
    }
    return fallbackMessage;
}
function isValidCode(code) {
    return Number.isInteger(code);
}
function serializeError(error) {
    let { fallbackError = FALLBACK_ERROR, shouldIncludeStack = true, shouldPreserveMessage = true } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$json$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isJsonRpcError"])(fallbackError)) {
        throw new Error('Must provide fallback error with integer number code and string message.');
    }
    const serialized = buildError(error, fallbackError, shouldPreserveMessage);
    if (!shouldIncludeStack) {
        delete serialized.stack;
    }
    return serialized;
}
/**
 * Construct a JSON-serializable object given an error and a JSON-serializable `fallbackError`
 *
 * @param error - The error in question.
 * @param fallbackError - A JSON-serializable fallback error.
 * @param shouldPreserveMessage - Whether to preserve the error's message if the fallback
 * error is used.
 * @returns A JSON-serializable error object.
 */ function buildError(error, fallbackError, shouldPreserveMessage) {
    // If an error specifies a `serialize` function, we call it and return the result.
    if (error && typeof error === 'object' && 'serialize' in error && typeof error.serialize === 'function') {
        return error.serialize();
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$json$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isJsonRpcError"])(error)) {
        return error;
    }
    const originalMessage = getOriginalMessage(error);
    // If the error does not match the JsonRpcError type, use the fallback error, but try to include the original error as `cause`.
    const cause = serializeCause(error);
    const fallbackWithCause = {
        ...fallbackError,
        ...shouldPreserveMessage && originalMessage && {
            message: originalMessage
        },
        data: {
            cause
        }
    };
    return fallbackWithCause;
}
/**
 * Attempts to extract the original `message` property from an error value of uncertain shape.
 *
 * @param error - The error in question.
 * @returns The original message, if it exists and is a non-empty string.
 */ function getOriginalMessage(error) {
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(error) && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hasProperty"])(error, 'message') && typeof error.message === 'string' && error.message.length > 0) {
        return error.message;
    }
    return undefined;
}
/**
 * Check if the given code is a valid JSON-RPC server error code.
 *
 * @param code - The error code.
 * @returns Whether the given code is a valid JSON-RPC server error code.
 */ function isJsonRpcServerError(code) {
    return code >= -32099 && code <= -32000;
}
function serializeCause(error) {
    if (Array.isArray(error)) {
        return error.map((entry)=>{
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$json$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isValidJson"])(entry)) {
                return entry;
            } else if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(entry)) {
                return serializeObject(entry);
            }
            return null;
        });
    } else if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(error)) {
        return serializeObject(error);
    }
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$json$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isValidJson"])(error)) {
        return error;
    }
    return null;
}
/**
 * Extracts all JSON-serializable properties from an object.
 *
 * @param object - The object in question.
 * @returns An object containing all the JSON-serializable properties.
 */ function serializeObject(object) {
    return Object.getOwnPropertyNames(object).reduce((acc, key)=>{
        const value = object[key];
        if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$json$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isValidJson"])(value)) {
            acc[key] = value;
        }
        return acc;
    }, {});
}
function dataHasCause(data) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(data) && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hasProperty"])(data, 'cause') && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isObject"])(data.cause);
} //# sourceMappingURL=utils.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/classes.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "EthereumProviderError",
    ()=>EthereumProviderError,
    "JsonRpcError",
    ()=>JsonRpcError
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+utils@11.8.1/node_modules/@metamask/utils/dist/misc.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$fast$2d$safe$2d$stringify$40$2$2e$1$2e$1$2f$node_modules$2f$fast$2d$safe$2d$stringify$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/fast-safe-stringify@2.1.1/node_modules/fast-safe-stringify/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/utils.mjs [app-client] (ecmascript)");
function $importDefault(module) {
    if (module === null || module === void 0 ? void 0 : module.__esModule) {
        return module.default;
    }
    return module;
}
;
;
const safeStringify = $importDefault(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$fast$2d$safe$2d$stringify$40$2$2e$1$2e$1$2f$node_modules$2f$fast$2d$safe$2d$stringify$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"]);
;
class JsonRpcError extends Error {
    /**
     * Get the error as JSON-serializable object.
     *
     * @returns A plain object with all public class properties.
     */ serialize() {
        const serialized = {
            code: this.code,
            message: this.message
        };
        if (this.data !== undefined) {
            // `this.data` is not guaranteed to be a plain object, but this simplifies
            // the type guard below. We can safely cast it because we know it's a
            // JSON-serializable value.
            serialized.data = this.data;
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isPlainObject"])(this.data)) {
                serialized.data.cause = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["serializeCause"])(this.data.cause);
            }
        }
        if (this.stack) {
            serialized.stack = this.stack;
        }
        return serialized;
    }
    /**
     * Get a string representation of the serialized error, omitting any circular
     * references.
     *
     * @returns A string representation of the serialized error.
     */ toString() {
        return safeStringify(this.serialize(), stringifyReplacer, 2);
    }
    constructor(code, message, data){
        if (!Number.isInteger(code)) {
            throw new Error('"code" must be an integer.');
        }
        if (!message || typeof message !== 'string') {
            throw new Error('"message" must be a non-empty string.');
        }
        if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["dataHasCause"])(data)) {
            // @ts-expect-error - Error class does accept options argument depending on runtime, but types are mapping to oldest supported
            super(message, {
                cause: data.cause
            });
            // Browser backwards-compatibility fallback
            if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$utils$40$11$2e$8$2e$1$2f$node_modules$2f40$metamask$2f$utils$2f$dist$2f$misc$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["hasProperty"])(this, 'cause')) {
                Object.assign(this, {
                    cause: data.cause
                });
            }
        } else {
            super(message);
        }
        if (data !== undefined) {
            this.data = data;
        }
        this.code = code;
    }
}
class EthereumProviderError extends JsonRpcError {
    /**
     * Create an Ethereum Provider JSON-RPC error.
     *
     * @param code - The JSON-RPC error code. Must be an integer in the
     * `1000 <= n <= 4999` range.
     * @param message - The JSON-RPC error message.
     * @param data - Optional data to include in the error.
     */ constructor(code, message, data){
        if (!isValidEthProviderCode(code)) {
            throw new Error('"code" must be an integer such that: 1000 <= code <= 4999');
        }
        super(code, message, data);
    }
}
/**
 * Check if the given code is a valid JSON-RPC error code.
 *
 * @param code - The code to check.
 * @returns Whether the code is valid.
 */ function isValidEthProviderCode(code) {
    return Number.isInteger(code) && code >= 1000 && code <= 4999;
}
/**
 * A JSON replacer function that omits circular references.
 *
 * @param _ - The key being replaced.
 * @param value - The value being replaced.
 * @returns The value to use in place of the original value.
 */ function stringifyReplacer(_, value) {
    if (value === '[Circular]') {
        return undefined;
    }
    return value;
} //# sourceMappingURL=classes.mjs.map
}),
"[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/errors.mjs [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "providerErrors",
    ()=>providerErrors,
    "rpcErrors",
    ()=>rpcErrors
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$classes$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/classes.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/error-constants.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/utils.mjs [app-client] (ecmascript)");
;
;
;
const rpcErrors = {
    /**
     * Get a JSON RPC 2.0 Parse (-32700) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ parse: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.parse, arg),
    /**
     * Get a JSON RPC 2.0 Invalid Request (-32600) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ invalidRequest: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.invalidRequest, arg),
    /**
     * Get a JSON RPC 2.0 Invalid Params (-32602) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ invalidParams: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.invalidParams, arg),
    /**
     * Get a JSON RPC 2.0 Method Not Found (-32601) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ methodNotFound: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.methodNotFound, arg),
    /**
     * Get a JSON RPC 2.0 Internal (-32603) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ internal: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.internal, arg),
    /**
     * Get a JSON RPC 2.0 Server error.
     * Permits integer error codes in the [ -32099 <= -32005 ] range.
     * Codes -32000 through -32004 are reserved by EIP-1474.
     *
     * @param opts - The error options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ server: (opts)=>{
        if (!opts || typeof opts !== 'object' || Array.isArray(opts)) {
            throw new Error('Ethereum RPC Server errors must provide single object argument.');
        }
        const { code } = opts;
        if (!Number.isInteger(code) || code > -32005 || code < -32099) {
            throw new Error('"code" must be an integer such that: -32099 <= code <= -32005');
        }
        return getJsonRpcError(code, opts);
    },
    /**
     * Get an Ethereum JSON RPC Invalid Input (-32000) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ invalidInput: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.invalidInput, arg),
    /**
     * Get an Ethereum JSON RPC Resource Not Found (-32001) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ resourceNotFound: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.resourceNotFound, arg),
    /**
     * Get an Ethereum JSON RPC Resource Unavailable (-32002) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ resourceUnavailable: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.resourceUnavailable, arg),
    /**
     * Get an Ethereum JSON RPC Transaction Rejected (-32003) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ transactionRejected: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.transactionRejected, arg),
    /**
     * Get an Ethereum JSON RPC Method Not Supported (-32004) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ methodNotSupported: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.methodNotSupported, arg),
    /**
     * Get an Ethereum JSON RPC Limit Exceeded (-32005) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link JsonRpcError} class.
     */ limitExceeded: (arg)=>getJsonRpcError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].rpc.limitExceeded, arg)
};
const providerErrors = {
    /**
     * Get an Ethereum Provider User Rejected Request (4001) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link EthereumProviderError} class.
     */ userRejectedRequest: (arg)=>{
        return getEthProviderError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].provider.userRejectedRequest, arg);
    },
    /**
     * Get an Ethereum Provider Unauthorized (4100) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link EthereumProviderError} class.
     */ unauthorized: (arg)=>{
        return getEthProviderError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].provider.unauthorized, arg);
    },
    /**
     * Get an Ethereum Provider Unsupported Method (4200) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link EthereumProviderError} class.
     */ unsupportedMethod: (arg)=>{
        return getEthProviderError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].provider.unsupportedMethod, arg);
    },
    /**
     * Get an Ethereum Provider Not Connected (4900) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link EthereumProviderError} class.
     */ disconnected: (arg)=>{
        return getEthProviderError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].provider.disconnected, arg);
    },
    /**
     * Get an Ethereum Provider Chain Not Connected (4901) error.
     *
     * @param arg - The error message or options bag.
     * @returns An instance of the {@link EthereumProviderError} class.
     */ chainDisconnected: (arg)=>{
        return getEthProviderError(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].provider.chainDisconnected, arg);
    },
    /**
     * Get a custom Ethereum Provider error.
     *
     * @param opts - The error options bag.
     * @returns An instance of the {@link EthereumProviderError} class.
     */ custom: (opts)=>{
        if (!opts || typeof opts !== 'object' || Array.isArray(opts)) {
            throw new Error('Ethereum Provider custom errors must provide single object argument.');
        }
        const { code, message, data } = opts;
        if (!message || typeof message !== 'string') {
            throw new Error('"message" must be a nonempty string');
        }
        return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$classes$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EthereumProviderError"](code, message, data);
    }
};
/**
 * Get a generic JSON-RPC error class instance.
 *
 * @param code - The error code.
 * @param arg - The error message or options bag.
 * @returns An instance of the {@link JsonRpcError} class.
 */ function getJsonRpcError(code, arg) {
    const [message, data] = parseOpts(arg);
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$classes$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["JsonRpcError"](code, message !== null && message !== void 0 ? message : (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getMessageFromCode"])(code), data);
}
/**
 * Get an Ethereum Provider error class instance.
 *
 * @param code - The error code.
 * @param arg - The error message or options bag.
 * @returns An instance of the {@link EthereumProviderError} class.
 */ function getEthProviderError(code, arg) {
    const [message, data] = parseOpts(arg);
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$classes$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["EthereumProviderError"](code, message !== null && message !== void 0 ? message : (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getMessageFromCode"])(code), data);
}
/**
 * Get an error message and optional data from an options bag.
 *
 * @param arg - The error message or options bag.
 * @returns A tuple containing the error message and optional data.
 */ function parseOpts(arg) {
    if (arg) {
        if (typeof arg === 'string') {
            return [
                arg
            ];
        } else if (typeof arg === 'object' && !Array.isArray(arg)) {
            const { message, data } = arg;
            if (message && typeof message !== 'string') {
                throw new Error('Must specify string message.');
            }
            return [
                message !== null && message !== void 0 ? message : undefined,
                data
            ];
        }
    }
    return [];
} //# sourceMappingURL=errors.mjs.map
}),
"[project]/node_modules/.pnpm/@gemini-wallet+core@0.3.1_v_f0f23207fba9e26e92a51ec355f63fe9/node_modules/@gemini-wallet/core/dist/index.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// src/communicator.ts
__turbopack_context__.s([
    "Communicator",
    ()=>Communicator,
    "DEFAULT_CHAIN_ID",
    ()=>DEFAULT_CHAIN_ID,
    "GeminiSdkEvent",
    ()=>GeminiSdkEvent,
    "GeminiStorage",
    ()=>GeminiStorage,
    "GeminiWallet",
    ()=>GeminiWallet,
    "GeminiWalletProvider",
    ()=>GeminiWalletProvider,
    "POPUP_HEIGHT",
    ()=>POPUP_HEIGHT,
    "POPUP_WIDTH",
    ()=>POPUP_WIDTH,
    "PlatformType",
    ()=>PlatformType,
    "ProviderEventEmitter",
    ()=>ProviderEventEmitter,
    "SDK_BACKEND_URL",
    ()=>SDK_BACKEND_URL,
    "SDK_VERSION",
    ()=>SDK_VERSION,
    "STORAGE_ETH_ACCOUNTS_KEY",
    ()=>STORAGE_ETH_ACCOUNTS_KEY,
    "STORAGE_ETH_ACTIVE_CHAIN_KEY",
    ()=>STORAGE_ETH_ACTIVE_CHAIN_KEY,
    "STORAGE_PASSKEY_CREDENTIAL_KEY",
    ()=>STORAGE_PASSKEY_CREDENTIAL_KEY,
    "STORAGE_PRESERVED_PASSKEY_CREDENTIALS_KEY",
    ()=>STORAGE_PRESERVED_PASSKEY_CREDENTIALS_KEY,
    "STORAGE_SETTINGS_KEY",
    ()=>STORAGE_SETTINGS_KEY,
    "STORAGE_SMART_ACCOUNT_KEY",
    ()=>STORAGE_SMART_ACCOUNT_KEY,
    "STORAGE_WC_REQUESTS_KEY",
    ()=>STORAGE_WC_REQUESTS_KEY,
    "base64ToHex",
    ()=>base64ToHex,
    "bufferToBase64URLString",
    ()=>bufferToBase64URLString,
    "calculateV1Address",
    ()=>calculateV1Address,
    "calculateWalletAddress",
    ()=>calculateWalletAddress,
    "closePopup",
    ()=>closePopup,
    "convertSendValuesToBigInt",
    ()=>convertSendValuesToBigInt,
    "decodeBase64",
    ()=>decodeBase64,
    "encodeBase64",
    ()=>encodeBase64,
    "fetchRpcRequest",
    ()=>fetchRpcRequest,
    "generateAuthenticatorIdHash",
    ()=>generateAuthenticatorIdHash,
    "hexStringFromNumber",
    ()=>hexStringFromNumber,
    "isChainSupportedByGeminiSw",
    ()=>isChainSupportedByGeminiSw,
    "openPopup",
    ()=>openPopup,
    "reverseResolveEns",
    ()=>reverseResolveEns,
    "safeJsonStringify",
    ()=>safeJsonStringify,
    "utf8StringToBuffer",
    ()=>utf8StringToBuffer,
    "validateRpcRequestArgs",
    ()=>validateRpcRequestArgs,
    "validateWebAuthnKey",
    ()=>validateWebAuthnKey
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/.pnpm/next@15.5.4_@babel+core@7.2_86eae7538a832346b889b1fcab4b65e9/node_modules/next/dist/compiled/buffer/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/errors.mjs [app-client] (ecmascript)");
// src/constants.ts
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/arbitrum.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrumSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/arbitrumSepolia.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/base.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/baseSepolia.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/mainnet.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/optimism.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimismSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/optimismSepolia.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/polygon.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygonAmoy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/polygonAmoy.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/chains/definitions/sepolia.js [app-client] (ecmascript)");
// src/types.ts
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$eventemitter3$40$5$2e$0$2e$1$2f$node_modules$2f$eventemitter3$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/eventemitter3@5.0.1/node_modules/eventemitter3/index.mjs [app-client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$eventemitter3$40$5$2e$0$2e$1$2f$node_modules$2f$eventemitter3$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__EventEmitter$3e$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/eventemitter3@5.0.1/node_modules/eventemitter3/index.js [app-client] (ecmascript) <export default as EventEmitter>");
// src/utils/calculateWalletAddress.ts
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/abi/encodeAbiParameters.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/abi/encodeFunctionData.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodePacked$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/abi/encodePacked.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getContractAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/address/getContractAddress.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/hash/keccak256.js [app-client] (ecmascript)");
// src/provider/provider.ts
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/error-constants.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@metamask+rpc-errors@7.0.2/node_modules/@metamask/rpc-errors/dist/utils.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$isHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/viem@2.38.6_bufferutil@4.0._faf8f695e98485156111a5d00d2d55da/node_modules/viem/_esm/utils/data/isHex.js [app-client] (ecmascript)");
;
;
// package.json
var package_default = {
    name: "@gemini-wallet/core",
    version: "0.3.1",
    description: "Core SDK for Gemini Wallet integration with popup communication",
    main: "./dist/index.cjs",
    types: "./dist/index.d.ts",
    type: "module",
    repository: {
        type: "git",
        url: "git+https://github.com/gemini/gemini-wallet-core.git"
    },
    homepage: "https://keys.gemini.com",
    bugs: {
        url: "https://github.com/gemini/gemini-wallet-core/issues"
    },
    license: "MIT",
    author: "Gemini",
    files: [
        "dist",
        "src",
        "README.md",
        "LICENSE"
    ],
    exports: {
        ".": {
            types: "./dist/index.d.ts",
            import: "./dist/index.js",
            require: "./dist/index.cjs"
        },
        "./package.json": "./package.json"
    },
    scripts: {
        build: "dotenv -e .env.production -- tsup",
        dev: "dotenv -e .env.local -- tsup --watch",
        typecheck: "tsc --noEmit",
        lint: "eslint ./src",
        "lint:ci": "eslint --max-warnings 0 ./src",
        "lint:fix": "eslint ./src --fix",
        test: "bun test"
    },
    dependencies: {
        "@metamask/rpc-errors": "7.0.2",
        eventemitter3: "5.0.1"
    },
    devDependencies: {
        "@eslint/eslintrc": "3.3.1",
        "@eslint/js": "9.33.0",
        "@next/eslint-plugin-next": "15.4.7",
        "@types/node": "22.13.0",
        "dotenv-cli": "10.0.0",
        "esbuild-plugin-replace": "1.4.0",
        eslint: "9.33.0",
        "eslint-config-prettier": "10.1.8",
        "eslint-config-turbo": "2.5.6",
        "eslint-plugin-import": "2.32.0",
        "eslint-plugin-jsx-a11y": "6.10.2",
        "eslint-plugin-only-warn": "1.1.0",
        "eslint-plugin-prettier": "5.5.4",
        "eslint-plugin-react": "7.37.5",
        "eslint-plugin-react-hooks": "5.2.0",
        "eslint-plugin-simple-import-sort": "12.1.1",
        "eslint-plugin-sort-keys-fix": "1.1.2",
        globals: "16.3.0",
        prettier: "3.6.2",
        tsup: "8.4.0",
        typescript: "5.5.3",
        "typescript-eslint": "8.40.0",
        vitest: "3.2.4"
    },
    peerDependencies: {
        viem: ">=2.0.0"
    },
    keywords: [
        "gemini",
        "wallet",
        "sdk",
        "ethereum",
        "web3",
        "crypto"
    ],
    module: "./dist/index.js"
};
// src/constants.ts
var DEFAULT_BACKEND_URL = "https://keys.gemini.com";
var SDK_BACKEND_URL = typeof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"] !== "undefined" && "undefined" || DEFAULT_BACKEND_URL;
var ENS_API_URL = "https://horizon-api.gemini.com/api/ens";
var SDK_VERSION = package_default.version;
var DEFAULT_CHAIN_ID = 42161;
var MAINNET_CHAIN_IDS = {
    ARBITRUM_ONE: 42161,
    BASE: 8453,
    ETHEREUM: 1,
    OP_MAINNET: 10,
    POLYGON: 137
};
var TESTNET_CHAIN_IDS = {
    ARBITRUM_SEPOLIA: 421614,
    BASE_SEPOLIA: 84532,
    OP_SEPOLIA: 11155420,
    POLYGON_AMOY: 80002,
    SEPOLIA: 11155111
};
var SUPPORTED_CHAIN_IDS = [
    ...Object.values(MAINNET_CHAIN_IDS),
    ...Object.values(TESTNET_CHAIN_IDS)
];
function getDefaultRpcUrl(chainId) {
    const chainMap = {
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["mainnet"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$mainnet$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["mainnet"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arbitrum"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrum$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arbitrum"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optimism"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimism$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optimism"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["base"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$base$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["base"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["polygon"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygon$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["polygon"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sepolia"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$sepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["sepolia"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrumSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arbitrumSepolia"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$arbitrumSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["arbitrumSepolia"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimismSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optimismSepolia"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$optimismSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["optimismSepolia"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["baseSepolia"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$baseSepolia$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["baseSepolia"].rpcUrls.default.http[0],
        [__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygonAmoy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["polygonAmoy"].id]: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$chains$2f$definitions$2f$polygonAmoy$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["polygonAmoy"].rpcUrls.default.http[0]
    };
    return chainMap[chainId];
}
var POPUP_WIDTH = 420;
var POPUP_HEIGHT = 650;
;
var GeminiSdkEvent = /* @__PURE__ */ ((GeminiSdkEvent2)=>{
    GeminiSdkEvent2["POPUP_LOADED"] = "POPUP_LOADED";
    GeminiSdkEvent2["POPUP_UNLOADED"] = "POPUP_UNLOADED";
    GeminiSdkEvent2["POPUP_APP_CONTEXT"] = "POPUP_APP_CONTEXT";
    GeminiSdkEvent2["SDK_CONNECT"] = "SDK_CONNECT";
    GeminiSdkEvent2["SDK_DISCONNECT"] = "SDK_DISCONNECT";
    GeminiSdkEvent2["SDK_SEND_TRANSACTION"] = "SDK_SEND_TRANSACTION";
    GeminiSdkEvent2["SDK_SIGN_DATA"] = "SDK_SIGN_DATA";
    GeminiSdkEvent2["SDK_SIGN_TYPED_DATA"] = "SDK_SIGN_TYPED_DATA";
    GeminiSdkEvent2["SDK_SWITCH_CHAIN"] = "SDK_SWITCH_CHAIN";
    GeminiSdkEvent2["SDK_OPEN_SETTINGS"] = "SDK_OPEN_SETTINGS";
    GeminiSdkEvent2["SDK_CURRENT_ACCOUNT"] = "SDK_CURRENT_ACCOUNT";
    return GeminiSdkEvent2;
})(GeminiSdkEvent || {});
var PlatformType = {
    REACT_NATIVE: "REACT_NATIVE",
    WEB: "WEB"
};
var ProviderEventEmitter = class extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$eventemitter3$40$5$2e$0$2e$1$2f$node_modules$2f$eventemitter3$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__EventEmitter$3e$__["EventEmitter"] {
};
// src/utils/base64.ts
function encodeBase64(array) {
    let base64;
    if (typeof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Buffer"] !== "undefined") {
        base64 = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Buffer"].from(array).toString("base64");
    } else {
        base64 = btoa(Array.from(array).map((b)=>String.fromCharCode(b)).join(""));
    }
    return base64.replace(/\+/g, "-").replace(/\//g, "_").replace(/=+$/, "");
}
function decodeBase64(base64url) {
    let base64 = base64url.replace(/-/g, "+").replace(/_/g, "/");
    while(base64.length % 4 !== 0){
        base64 += "=";
    }
    if (typeof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Buffer"] !== "undefined") {
        return new Uint8Array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Buffer"].from(base64, "base64"));
    } else {
        const binaryString = atob(base64);
        const bytes = new Uint8Array(binaryString.length);
        for(let i = 0; i < binaryString.length; i++){
            bytes[i] = binaryString.charCodeAt(i);
        }
        return bytes;
    }
}
function bufferToBase64URLString(buffer) {
    const bytes = buffer instanceof Uint8Array ? buffer : new Uint8Array(buffer);
    return encodeBase64(bytes);
}
function utf8StringToBuffer(value) {
    if (typeof TextEncoder !== "undefined") {
        return new TextEncoder().encode(value);
    } else if (typeof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Buffer"] !== "undefined") {
        return new Uint8Array(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$next$40$15$2e$5$2e$4_$40$babel$2b$core$40$7$2e$2_86eae7538a832346b889b1fcab4b65e9$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$buffer$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Buffer"].from(value, "utf8"));
    } else {
        const bytes = new Uint8Array(value.length);
        for(let i = 0; i < value.length; i++){
            bytes[i] = value.charCodeAt(i);
        }
        return bytes;
    }
}
function base64ToHex(base64) {
    const bytes = decodeBase64(base64);
    return Array.from(bytes).map((b)=>b.toString(16).padStart(2, "0")).join("");
}
;
var SHARED_CONTRACT_ADDRESSES = {
    ATTESTER: "0x000474392a9cd86a4687354f1Ce2964B52e97484",
    BOOTSTRAPPER: "0x00000000D3254452a909E4eeD47455Af7E27C289",
    REGISTRY: "0x000000000069E2a187AEFFb852bF3cCdC95151B2"
};
var V2_CONTRACT_ADDRESSES = {
    ...SHARED_CONTRACT_ADDRESSES,
    ACCOUNT_IMPLEMENTATION: "0x00000000029d9c8b864DD51d6bb0d99FB72D650b",
    FACTORY: "0x000000000452377e1Bd9e72E939855ECb9363Cab",
    WEBAUTHN_VALIDATOR: "0x7ab16Ff354AcB328452F1D445b3Ddee9a91e9e69"
};
var V1_CONTRACT_ADDRESSES = {
    ...SHARED_CONTRACT_ADDRESSES,
    ACCOUNT_IMPLEMENTATION: "0x0006050168DE255a8672ACaD4821e721CBA44337",
    FACTORY: "0x00E58DF70FaB983a324c4C068c82d20407579FaC",
    WEBAUTHN_VALIDATOR: "0xbA45a2BFb8De3D24cA9D7F1B551E14dFF5d690Fd"
};
function processWalletAddressParams(params, contractAddresses) {
    const { publicKey, credentialId, index = 0n } = params;
    if (!publicKey.startsWith("0x") || publicKey.length !== 130) {
        throw new Error("Invalid public key: must be 64-byte hex string (0x + 128 chars)");
    }
    const pubKeyX = "0x".concat(publicKey.slice(2, 66));
    const pubKeyY = "0x".concat(publicKey.slice(66, 130));
    const webAuthnData = {
        pubKeyX: BigInt(pubKeyX),
        pubKeyY: BigInt(pubKeyY)
    };
    if (!validateWebAuthnKey(webAuthnData)) {
        throw new Error("Invalid WebAuthn key: coordinates are not on secp256r1 curve");
    }
    const authenticatorIdHash = generateAuthenticatorIdHash(credentialId);
    return calculateAddressInternal({
        authenticatorIdHash,
        contractAddresses,
        index,
        webAuthnData
    });
}
function calculateWalletAddress(params) {
    return processWalletAddressParams(params, V2_CONTRACT_ADDRESSES);
}
function calculateV1Address(params) {
    return processWalletAddressParams(params, V1_CONTRACT_ADDRESSES);
}
function generateAuthenticatorIdHash(credentialId) {
    const padding = "=".repeat((4 - credentialId.length % 4) % 4);
    const base64 = credentialId.replace(/-/g, "+").replace(/_/g, "/") + padding;
    const binaryString = atob(base64);
    const bytes = new Uint8Array(binaryString.length);
    for(let i = 0; i < binaryString.length; i++){
        bytes[i] = binaryString.charCodeAt(i);
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])(bytes);
}
function validateWebAuthnKey(webAuthnData) {
    const SECP256R1_P = 0xffffffff00000001000000000000000000000000ffffffffffffffffffffffffn;
    const SECP256R1_B = 0x5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604bn;
    const { pubKeyX, pubKeyY } = webAuthnData;
    if (pubKeyX === 0n || pubKeyY === 0n || pubKeyX >= SECP256R1_P || pubKeyY >= SECP256R1_P) {
        return false;
    }
    const ySquared = pubKeyY * pubKeyY % SECP256R1_P;
    const xCubed = pubKeyX * pubKeyX * pubKeyX % SECP256R1_P;
    const threeX = 3n * pubKeyX % SECP256R1_P;
    const rightSide = (xCubed + SECP256R1_P - threeX + SECP256R1_B) % SECP256R1_P;
    return ySquared === rightSide;
}
function calculateAddressInternal(params) {
    const { webAuthnData, authenticatorIdHash, index, contractAddresses } = params;
    const factoryAddress = contractAddresses.FACTORY;
    const accountImplementation = contractAddresses.ACCOUNT_IMPLEMENTATION;
    const webAuthnValidator = contractAddresses.WEBAUTHN_VALIDATOR;
    const attester = contractAddresses.ATTESTER;
    const bootstrapper = contractAddresses.BOOTSTRAPPER;
    const registry = contractAddresses.REGISTRY;
    const salt = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodePacked$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodePacked"])([
        "uint256",
        "uint256",
        "bytes32",
        "uint256"
    ], [
        webAuthnData.pubKeyX,
        webAuthnData.pubKeyY,
        authenticatorIdHash,
        index
    ]));
    const validatorInitData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodeAbiParameters"])([
        {
            components: [
                {
                    name: "pubKeyX",
                    type: "uint256"
                },
                {
                    name: "pubKeyY",
                    type: "uint256"
                }
            ],
            type: "tuple"
        },
        {
            type: "bytes32"
        }
    ], [
        webAuthnData,
        authenticatorIdHash
    ]);
    const registryConfig = {
        attesters: [
            attester
        ],
        registry,
        threshold: 1n
    };
    const bootstrapCall = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
        abi: [
            {
                inputs: [
                    {
                        name: "validator",
                        type: "address"
                    },
                    {
                        name: "validatorInitData",
                        type: "bytes"
                    },
                    {
                        components: [
                            {
                                name: "registry",
                                type: "address"
                            },
                            {
                                name: "attesters",
                                type: "address[]"
                            },
                            {
                                name: "threshold",
                                type: "uint8"
                            }
                        ],
                        name: "registryConfig",
                        type: "tuple"
                    }
                ],
                name: "initNexusWithSingleValidator",
                type: "function"
            }
        ],
        args: [
            webAuthnValidator,
            validatorInitData,
            registryConfig
        ],
        functionName: "initNexusWithSingleValidator"
    });
    const initData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodeAbiParameters"])([
        {
            type: "address"
        },
        {
            type: "bytes"
        }
    ], [
        bootstrapper,
        bootstrapCall
    ]);
    return predictProxyAddress(accountImplementation, salt, initData, factoryAddress);
}
function predictProxyAddress(implementation, salt, initData, deployer) {
    const initializeCall = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeFunctionData$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodeFunctionData"])({
        abi: [
            {
                inputs: [
                    {
                        name: "data",
                        type: "bytes"
                    }
                ],
                name: "initializeAccount",
                type: "function"
            }
        ],
        args: [
            initData
        ],
        functionName: "initializeAccount"
    });
    const constructorArgs = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodeAbiParameters$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodeAbiParameters"])([
        {
            type: "address"
        },
        {
            type: "bytes"
        }
    ], [
        implementation,
        initializeCall
    ]);
    const nexusProxyCreationCode = "0x60806040526102c8803803806100148161018c565b92833981016040828203126101885781516001600160a01b03811692909190838303610188576020810151906001600160401b03821161018857019281601f8501121561018857835161006e610069826101c5565b61018c565b9481865260208601936020838301011161018857815f926020809301865e8601015260017f90b772c2cb8a51aa7a8a65fc23543c6d022d5b3f8e2b92eed79fba7eef8293005d823b15610176577f360894a13ba1a3210667c828492db98dca3e2076cc3735a920a3ca505d382bbc80546001600160a01b031916821790557fbc7cd75a20ee27fd9adebab32041f755214dbc6bffa90cc0225b39da2e5c2d3b5f80a282511561015e575f8091610146945190845af43d15610156573d91610137610069846101c5565b9283523d5f602085013e6101e0565b505b6040516089908161023f8239f35b6060916101e0565b50505034156101485763b398979f60e01b5f5260045ffd5b634c9c8ce360e01b5f5260045260245ffd5b5f80fd5b6040519190601f01601f191682016001600160401b038111838210176101b157604052565b634e487b7160e01b5f52604160045260245ffd5b6001600160401b0381116101b157601f01601f191660200190565b9061020457508051156101f557805190602001fd5b63d6bda27560e01b5f5260045ffd5b81511580610235575b610215575090565b639996b31560e01b5f9081526001600160a01b0391909116600452602490fd5b50803b1561020d56fe608060405236156051577f360894a13ba1a3210667c828492db98dca3e2076cc3735a920a3ca505d382bbc545f9081906001600160a01b0316368280378136915af43d5f803e15604d573d5ff35b3d5ffd5b00fea264697066735822122041b5f70a351952142223f22504ca7b4e6d975f3a302d114ff820442fcf815ac264736f6c634300081b0033";
    const initCodeHash = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$hash$2f$keccak256$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["keccak256"])((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$abi$2f$encodePacked$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["encodePacked"])([
        "bytes",
        "bytes"
    ], [
        nexusProxyCreationCode,
        constructorArgs
    ]));
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$address$2f$getContractAddress$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getCreate2Address"])({
        bytecodeHash: initCodeHash,
        from: deployer,
        salt
    });
}
// src/utils/ens.ts
async function reverseResolveEns(address) {
    try {
        const response = await fetch("".concat(ENS_API_URL, "/reverse/").concat(address));
        if (!response.ok) {
            throw new Error("ENS API request failed: ".concat(response.status, " ").concat(response.statusText));
        }
        const data = await response.json();
        return {
            address: data.address,
            name: data.name || null
        };
    } catch (error) {
        console.error("Failed to resolve ENS name:", error);
        return {
            address,
            name: null
        };
    }
}
;
var POPUP_WIDTH2 = 420;
var POPUP_HEIGHT2 = 650;
var openPopup = (url)=>{
    var _window_crypto, _window;
    const left = (window.innerWidth - POPUP_WIDTH2) / 2 + window.screenX;
    const top = (window.innerHeight - POPUP_HEIGHT2) / 2 + window.screenY;
    const popupId = "wallet_".concat((_window = window) === null || _window === void 0 ? void 0 : (_window_crypto = _window.crypto) === null || _window_crypto === void 0 ? void 0 : _window_crypto.randomUUID());
    const popup = window.open(url, popupId, "width=".concat(POPUP_WIDTH2, ", height=").concat(POPUP_HEIGHT2, ", left=").concat(left, ", top=").concat(top));
    popup === null || popup === void 0 ? void 0 : popup.focus();
    if (!popup) {
        throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].internal("Pop up window failed to open");
    }
    return popup;
};
var closePopup = (popup)=>{
    if (popup && !popup.closed) {
        var _popup_opener;
        (_popup_opener = popup.opener) === null || _popup_opener === void 0 ? void 0 : _popup_opener.focus();
        popup.close();
    }
};
// src/utils/strings.ts
var hexStringFromNumber = (num)=>{
    return "0x".concat(BigInt(num).toString(16));
};
var safeJsonStringify = (obj)=>JSON.stringify(obj, (_, value)=>typeof value === "bigint" ? value.toString() + "n" : value, 2);
// src/communicator.ts
var Communicator = class {
    constructor({ appMetadata, onDisconnectCallback }){
        this.popup = null;
        this.listeners = /* @__PURE__ */ new Map();
        // posts a message to the popup window
        this.postMessage = async (message)=>{
            const popup = await this.waitForPopupLoaded();
            popup.postMessage(message, this.url.origin);
        };
        // posts a request to the popup window and waits for a response
        this.postRequestAndWaitForResponse = async (request)=>{
            const responsePromise = this.onMessage((param)=>{
                let { requestId } = param;
                return requestId === request.requestId;
            });
            this.postMessage(request);
            return await responsePromise;
        };
        // listens for messages from the popup window that match a given predicate
        this.onMessage = (predicate)=>{
            return new Promise((resolve, reject)=>{
                const listener = (event)=>{
                    if (event.origin !== this.url.origin) return;
                    const message = event.data;
                    if (predicate(message)) {
                        resolve(message);
                        window.removeEventListener("message", listener);
                        this.listeners.delete(listener);
                    }
                };
                window.addEventListener("message", listener);
                this.listeners.set(listener, {
                    reject
                });
            });
        };
        // closes the popup, rejects all requests and clears event listeners
        this.onRequestCancelled = ()=>{
            closePopup(this.popup);
            this.popup = null;
            this.listeners.forEach((param, listener)=>{
                let { reject } = param;
                reject(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["providerErrors"].userRejectedRequest());
                window.removeEventListener("message", listener);
            });
            this.listeners.clear();
        };
        // waits for the popup window to fully load and then sends a version message
        this.waitForPopupLoaded = ()=>{
            if (this.popup && !this.popup.closed) {
                this.popup.focus();
                return Promise.resolve(this.popup);
            }
            this.popup = openPopup(this.url);
            this.onMessage((param)=>{
                let { event } = param;
                return event === "POPUP_UNLOADED" /* POPUP_UNLOADED */ ;
            }).then(this.onRequestCancelled).catch(()=>{});
            this.onMessage((param)=>{
                let { event } = param;
                return event === "SDK_DISCONNECT" /* SDK_DISCONNECT */ ;
            }).then(()=>{
                var _this_onDisconnectCallback, _this;
                (_this_onDisconnectCallback = (_this = this).onDisconnectCallback) === null || _this_onDisconnectCallback === void 0 ? void 0 : _this_onDisconnectCallback.call(_this);
                this.onRequestCancelled();
            }).catch(()=>{});
            return this.onMessage((param)=>{
                let { event } = param;
                return event === "POPUP_LOADED" /* POPUP_LOADED */ ;
            }).then((message)=>{
                this.postMessage({
                    chainId: DEFAULT_CHAIN_ID,
                    data: {
                        appMetadata: this.appMetadata,
                        origin: window.location.origin,
                        sdkVersion: SDK_VERSION
                    },
                    event: "POPUP_APP_CONTEXT" /* POPUP_APP_CONTEXT */ ,
                    origin: window.location.origin,
                    requestId: message.requestId
                });
            }).then(()=>{
                if (!this.popup) throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].internal();
                return this.popup;
            });
        };
        this.url = new URL(SDK_BACKEND_URL);
        this.appMetadata = appMetadata;
        this.onDisconnectCallback = onDisconnectCallback;
    }
};
;
// src/storage/storage.ts
var memoryStorage = {};
var GeminiStorage = class {
    scopedKey(key) {
        return "".concat(this.scope, ".").concat(this.module, ".").concat(key);
    }
    async storeObject(key, item) {
        const json = safeJsonStringify(item);
        await this.setItem(key, json);
    }
    async loadObject(key, fallback) {
        const item = await this.getItem(key);
        if (!item) {
            await this.storeObject(key, fallback);
            return fallback;
        }
        try {
            return JSON.parse(item);
        } catch (error) {
            console.error("Error parsing JSON for key ".concat(key, ":"), error);
            return fallback;
        }
    }
    // eslint-disable-next-line require-await
    async setItem(key, value) {
        const scoped = this.scopedKey(key);
        try {
            localStorage.setItem(scoped, value);
        } catch (e) {
            console.warn("localStorage not available, using memory storage", e);
            memoryStorage[scoped] = value;
        }
    }
    // eslint-disable-next-line require-await
    async getItem(key) {
        const scoped = this.scopedKey(key);
        try {
            return localStorage.getItem(scoped);
        } catch (e) {
            console.warn("localStorage not available, using memory storage", e);
            return memoryStorage[scoped] || null;
        }
    }
    // eslint-disable-next-line require-await
    async removeItem(key) {
        const scoped = this.scopedKey(key);
        try {
            localStorage.removeItem(scoped);
        } catch (e) {
            console.warn("localStorage not available, using memory storage", e);
            delete memoryStorage[scoped];
        }
    }
    async removeItems(keys) {
        await Promise.all(keys.map((key)=>this.removeItem(key)));
    }
    constructor({ scope = "@gemini", module = "wallet" } = {}){
        this.scope = scope;
        this.module = module;
    }
};
// src/storage/storageInterface.ts
var STORAGE_ETH_ACCOUNTS_KEY = "eth-accounts";
var STORAGE_ETH_ACTIVE_CHAIN_KEY = "eth-active-chain";
var STORAGE_PASSKEY_CREDENTIAL_KEY = "passkey-credential";
var STORAGE_PRESERVED_PASSKEY_CREDENTIALS_KEY = "preserved-passkey-credentials";
var STORAGE_SMART_ACCOUNT_KEY = "smart-account";
var STORAGE_SETTINGS_KEY = "settings";
var STORAGE_WC_REQUESTS_KEY = "wc-requests";
// src/wallets/wallet.ts
function isChainSupportedByGeminiSw(chainId) {
    return SUPPORTED_CHAIN_IDS.includes(chainId);
}
var GeminiWallet = class {
    async initializeFromStorage(defaultChain) {
        const fallbackChain = {
            ...defaultChain,
            rpcUrl: defaultChain.rpcUrl || getDefaultRpcUrl(defaultChain.id)
        };
        const [storedChain, storedAccounts] = await Promise.all([
            this.storage.loadObject(STORAGE_ETH_ACTIVE_CHAIN_KEY, fallbackChain),
            this.storage.loadObject(STORAGE_ETH_ACCOUNTS_KEY, this.accounts)
        ]);
        this.chain = {
            ...storedChain,
            rpcUrl: storedChain.rpcUrl || getDefaultRpcUrl(storedChain.id)
        };
        this.accounts = storedAccounts;
    }
    async ensureInitialized() {
        await this.initPromise;
    }
    async connect() {
        await this.ensureInitialized();
        const response = await this.sendMessageToPopup({
            chainId: this.chain.id,
            event: "SDK_CONNECT" /* SDK_CONNECT */ ,
            origin: window.location.origin
        });
        this.accounts = response.data.address ? [
            response.data.address
        ] : [];
        await this.storage.storeObject(STORAGE_ETH_ACCOUNTS_KEY, this.accounts);
        return this.accounts;
    }
    async disconnect() {
        await this.ensureInitialized();
        this.accounts = [];
        await this.storage.storeObject(STORAGE_ETH_ACCOUNTS_KEY, this.accounts);
    }
    async switchChain(param) {
        let { id } = param;
        await this.ensureInitialized();
        if (isChainSupportedByGeminiSw(id)) {
            this.chain = {
                id,
                rpcUrl: getDefaultRpcUrl(id)
            };
            await this.storage.storeObject(STORAGE_ETH_ACTIVE_CHAIN_KEY, this.chain);
            return null;
        }
        const response = await this.sendMessageToPopup({
            chainId: this.chain.id,
            data: id,
            event: "SDK_SWITCH_CHAIN" /* SDK_SWITCH_CHAIN */ ,
            origin: window.location.origin
        });
        var _response_data_error;
        return (_response_data_error = response.data.error) !== null && _response_data_error !== void 0 ? _response_data_error : "Unsupported chain.";
    }
    async sendTransaction(txData) {
        await this.ensureInitialized();
        const response = await this.sendMessageToPopup({
            chainId: this.chain.id,
            data: txData,
            event: "SDK_SEND_TRANSACTION" /* SDK_SEND_TRANSACTION */ ,
            origin: window.location.origin
        });
        return response.data;
    }
    async signData(param) {
        let { message } = param;
        await this.ensureInitialized();
        const response = await this.sendMessageToPopup({
            chainId: this.chain.id,
            data: {
                message
            },
            event: "SDK_SIGN_DATA" /* SDK_SIGN_DATA */ ,
            origin: window.location.origin
        });
        return response.data;
    }
    async signTypedData(param) {
        let { message, types, primaryType, domain } = param;
        await this.ensureInitialized();
        const response = await this.sendMessageToPopup({
            chainId: this.chain.id,
            data: {
                domain,
                message,
                primaryType,
                types
            },
            event: "SDK_SIGN_TYPED_DATA" /* SDK_SIGN_TYPED_DATA */ ,
            origin: window.location.origin
        });
        return response.data;
    }
    async openSettings() {
        await this.ensureInitialized();
        await this.sendMessageToPopup({
            chainId: this.chain.id,
            data: {},
            event: "SDK_OPEN_SETTINGS" /* SDK_OPEN_SETTINGS */ ,
            origin: window.location.origin
        });
    }
    sendMessageToPopup(request) {
        var _window_crypto, _window;
        return this.communicator.postRequestAndWaitForResponse({
            ...request,
            requestId: (_window = window) === null || _window === void 0 ? void 0 : (_window_crypto = _window.crypto) === null || _window_crypto === void 0 ? void 0 : _window_crypto.randomUUID()
        });
    }
    constructor({ appMetadata, chain, onDisconnectCallback, storage }){
        this.accounts = [];
        this.chain = {
            id: DEFAULT_CHAIN_ID
        };
        this.communicator = new Communicator({
            appMetadata,
            onDisconnectCallback
        });
        this.storage = storage || new GeminiStorage();
        var _chain_id;
        const fallbackChainId = (_chain_id = chain === null || chain === void 0 ? void 0 : chain.id) !== null && _chain_id !== void 0 ? _chain_id : DEFAULT_CHAIN_ID;
        var _chain_rpcUrl;
        const fallbackRpcUrl = (_chain_rpcUrl = chain === null || chain === void 0 ? void 0 : chain.rpcUrl) !== null && _chain_rpcUrl !== void 0 ? _chain_rpcUrl : getDefaultRpcUrl(fallbackChainId);
        const defaultChain = {
            id: fallbackChainId,
            rpcUrl: fallbackRpcUrl
        };
        this.initPromise = this.initializeFromStorage(defaultChain);
    }
};
;
;
var fetchRpcRequest = async (request, rpcUrl)=>{
    var _window_crypto, _window;
    const requestBody = {
        ...request,
        id: (_window = window) === null || _window === void 0 ? void 0 : (_window_crypto = _window.crypto) === null || _window_crypto === void 0 ? void 0 : _window_crypto.randomUUID(),
        jsonrpc: "2.0"
    };
    const res = await window.fetch(rpcUrl, {
        body: JSON.stringify(requestBody),
        headers: {
            "Content-Type": "application/json"
        },
        method: "POST",
        mode: "cors"
    });
    const { result, error } = await res.json();
    if (error) throw error;
    return result;
};
function validateRpcRequestArgs(args) {
    if (!args || typeof args !== "object" || Array.isArray(args)) {
        throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].invalidParams({
            message: "Expected a single, non-array, object argument."
        });
    }
    const { method, params } = args;
    if (typeof method !== "string" || method.length === 0) {
        throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].invalidParams({
            message: "'args.method' must be a non-empty string."
        });
    }
    if (params !== void 0 && !Array.isArray(params) && (typeof params !== "object" || params === null)) {
        throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].invalidParams({
            message: "'args.params' must be an object or array if provided."
        });
    }
}
function convertSendValuesToBigInt(tx) {
    const FIELDS_TO_NORMALIZE = [
        "value",
        "gas",
        "gasPrice",
        "maxPriorityFeePerGas",
        "maxFeePerGas"
    ];
    const normalized = {
        ...tx
    };
    for (const field of FIELDS_TO_NORMALIZE){
        if (!(field in tx)) continue;
        const value = tx[field];
        if (typeof value === "bigint") continue;
        if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$viem$40$2$2e$38$2e$6_bufferutil$40$4$2e$0$2e$_faf8f695e98485156111a5d00d2d55da$2f$node_modules$2f$viem$2f$_esm$2f$utils$2f$data$2f$isHex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isHex"])(value)) {
            normalized[field] = BigInt(value);
        }
    }
    return normalized;
}
// src/provider/provider.ts
var GeminiWalletProvider = class extends ProviderEventEmitter {
    async request(args) {
        try {
            var _this_wallet_accounts, _this_wallet;
            validateRpcRequestArgs(args);
            if (!((_this_wallet = this.wallet) === null || _this_wallet === void 0 ? void 0 : (_this_wallet_accounts = _this_wallet.accounts) === null || _this_wallet_accounts === void 0 ? void 0 : _this_wallet_accounts.length)) {
                switch(args.method){
                    case "eth_requestAccounts":
                        {
                            if (!this.wallet) {
                                const userDisconnectCallback = this.config.onDisconnectCallback;
                                this.wallet = new GeminiWallet({
                                    ...this.config,
                                    onDisconnectCallback: ()=>{
                                        userDisconnectCallback === null || userDisconnectCallback === void 0 ? void 0 : userDisconnectCallback();
                                        this.disconnect();
                                    }
                                });
                            }
                            await this.wallet.connect();
                            this.emit("accountsChanged", this.wallet.accounts);
                            break;
                        }
                    case "net_version":
                        return DEFAULT_CHAIN_ID;
                    case "eth_chainId":
                        return hexStringFromNumber(DEFAULT_CHAIN_ID);
                    default:
                        {
                            throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["providerErrors"].unauthorized();
                        }
                }
            }
            let response;
            let requestParams;
            switch(args.method){
                case "eth_requestAccounts":
                case "eth_accounts":
                    response = this.wallet.accounts;
                    break;
                case "net_version":
                    response = this.wallet.chain.id;
                    break;
                case "eth_chainId":
                    response = hexStringFromNumber(this.wallet.chain.id);
                    break;
                case "personal_sign":
                case "wallet_sign":
                    requestParams = args.params;
                    response = await this.wallet.signData({
                        account: requestParams[1],
                        message: requestParams[0]
                    });
                    if (response.error) {
                        throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].transactionRejected(response.error);
                    } else {
                        response = response.hash;
                    }
                    break;
                case "eth_sendTransaction":
                case "wallet_sendTransaction":
                    requestParams = args.params;
                    requestParams = convertSendValuesToBigInt(requestParams[0]);
                    response = await this.wallet.sendTransaction(requestParams);
                    if (response.error) {
                        throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].transactionRejected(response.error);
                    } else {
                        response = response.hash;
                    }
                    break;
                case "wallet_switchEthereumChain":
                    {
                        var _rawParams_;
                        const rawParams = args.params;
                        let chainId;
                        if (Array.isArray(rawParams) && ((_rawParams_ = rawParams[0]) === null || _rawParams_ === void 0 ? void 0 : _rawParams_.chainId)) {
                            chainId = parseInt(rawParams[0].chainId, 16);
                        } else if (rawParams && typeof rawParams === "object" && "id" in rawParams && Number.isInteger(rawParams.id)) {
                            chainId = rawParams.id;
                        } else {
                            throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].invalidParams("Invalid chain id argument. Expected [{ chainId: hex_string }] or { id: number }.");
                        }
                        response = await this.wallet.switchChain({
                            id: chainId
                        });
                        if (response) {
                            throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["providerErrors"].custom({
                                code: 4902,
                                message: response
                            });
                        }
                        await this.emit("chainChanged", hexStringFromNumber(chainId));
                        break;
                    }
                case "eth_signTypedData_v1":
                case "eth_signTypedData_v2":
                case "eth_signTypedData_v3":
                case "eth_signTypedData_v4":
                case "eth_signTypedData":
                    {
                        requestParams = args.params;
                        const signedTypedDataParams = JSON.parse(requestParams[1]);
                        response = await this.wallet.signTypedData({
                            account: requestParams[0],
                            domain: signedTypedDataParams.domain,
                            message: signedTypedDataParams.message,
                            primaryType: signedTypedDataParams.primaryType,
                            types: signedTypedDataParams.types
                        });
                        if (response.error) {
                            throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].transactionRejected(response.error);
                        } else {
                            response = response.hash;
                        }
                        break;
                    }
                // TODO: not yet implemented or unclear if we support
                case "eth_ecRecover":
                case "eth_subscribe":
                case "eth_unsubscribe":
                case "personal_ecRecover":
                case "eth_signTransaction":
                case "wallet_watchAsset":
                case "wallet_sendCalls":
                case "wallet_getCallsStatus":
                case "wallet_getCapabilities":
                case "wallet_showCallsStatus":
                case "wallet_grantPermissions":
                    throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].methodNotSupported("Not yet implemented.");
                // not supported
                case "eth_sign":
                case "eth_coinbase":
                case "wallet_addEthereumChain":
                    throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].methodNotSupported();
                // call rpc directly for everything else
                default:
                    if (!this.wallet.chain.rpcUrl) throw __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$errors$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["rpcErrors"].internal("RPC URL missing for current chain (".concat(this.wallet.chain.id, ")"));
                    return fetchRpcRequest(args, this.wallet.chain.rpcUrl);
            }
            return response;
        } catch (error) {
            const { code } = error;
            if (code === __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$error$2d$constants$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["errorCodes"].provider.unauthorized) this.disconnect();
            return Promise.reject((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$metamask$2b$rpc$2d$errors$40$7$2e$0$2e$2$2f$node_modules$2f40$metamask$2f$rpc$2d$errors$2f$dist$2f$utils$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["serializeError"])(error));
        }
    }
    // custom wallet function to open settings page
    async openSettings() {
        var _this_wallet;
        await ((_this_wallet = this.wallet) === null || _this_wallet === void 0 ? void 0 : _this_wallet.openSettings());
    }
    async disconnect() {
        var _this_config_onDisconnectCallback, _this_config;
        if (this.wallet) {
            const storage = this.config.storage || new GeminiStorage();
            await storage.removeItem(STORAGE_ETH_ACCOUNTS_KEY);
            await storage.removeItem(STORAGE_ETH_ACTIVE_CHAIN_KEY);
        }
        this.wallet = null;
        (_this_config_onDisconnectCallback = (_this_config = this.config).onDisconnectCallback) === null || _this_config_onDisconnectCallback === void 0 ? void 0 : _this_config_onDisconnectCallback.call(_this_config);
        await this.emit("disconnect", "User initiated disconnection");
        await this.emit("accountsChanged", []);
    }
    constructor(providerConfig){
        super();
        this.wallet = null;
        this.config = providerConfig;
        const userDisconnectCallback = providerConfig.onDisconnectCallback;
        this.wallet = new GeminiWallet({
            ...providerConfig,
            onDisconnectCallback: ()=>{
                userDisconnectCallback === null || userDisconnectCallback === void 0 ? void 0 : userDisconnectCallback();
                this.disconnect();
            }
        });
    }
};
;
 //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/version.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/** @internal */ __turbopack_context__.s([
    "version",
    ()=>version
]);
const version = '0.1.1'; //# sourceMappingURL=version.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/errors.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "getUrl",
    ()=>getUrl,
    "getVersion",
    ()=>getVersion,
    "prettyPrint",
    ()=>prettyPrint
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$version$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/version.js [app-client] (ecmascript)");
;
function getUrl(url) {
    return url;
}
function getVersion() {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$version$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["version"];
}
function prettyPrint(args) {
    if (!args) return '';
    const entries = Object.entries(args).map((param)=>{
        let [key, value] = param;
        if (value === undefined || value === false) return null;
        return [
            key,
            value
        ];
    }).filter(Boolean);
    const maxLength = entries.reduce((acc, param)=>{
        let [key] = param;
        return Math.max(acc, key.length);
    }, 0);
    return entries.map((param)=>{
        let [key, value] = param;
        return "  ".concat("".concat(key, ":").padEnd(maxLength + 1), "  ").concat(value);
    }).join('\n');
} //# sourceMappingURL=errors.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "BaseError",
    ()=>BaseError
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/errors.js [app-client] (ecmascript)");
;
class BaseError extends Error {
    walk(fn) {
        return walk(this, fn);
    }
    constructor(shortMessage, options = {}){
        const details = (()=>{
            var _options_cause;
            if (options.cause instanceof BaseError) {
                if (options.cause.details) return options.cause.details;
                if (options.cause.shortMessage) return options.cause.shortMessage;
            }
            if (options.cause && 'details' in options.cause && typeof options.cause.details === 'string') return options.cause.details;
            if ((_options_cause = options.cause) === null || _options_cause === void 0 ? void 0 : _options_cause.message) return options.cause.message;
            return options.details;
        })();
        const docsPath = (()=>{
            if (options.cause instanceof BaseError) return options.cause.docsPath || options.docsPath;
            return options.docsPath;
        })();
        var _options_docsOrigin;
        const docsBaseUrl = (_options_docsOrigin = options.docsOrigin) !== null && _options_docsOrigin !== void 0 ? _options_docsOrigin : 'https://oxlib.sh';
        const docs = "".concat(docsBaseUrl).concat(docsPath !== null && docsPath !== void 0 ? docsPath : '');
        const message = [
            shortMessage || 'An error occurred.',
            ...options.metaMessages ? [
                '',
                ...options.metaMessages
            ] : [],
            ...details || docsPath || options.version ? [
                '',
                details ? "Details: ".concat(details) : undefined,
                docsPath ? "See: ".concat(docs) : undefined,
                options.version ? "Version: ".concat(options.version) : undefined
            ] : []
        ].filter((x)=>typeof x === 'string').join('\n');
        super(message, options.cause ? {
            cause: options.cause
        } : undefined);
        Object.defineProperty(this, "details", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "docs", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "docsPath", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "shortMessage", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "version", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "cause", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'BaseError'
        });
        this.cause = options.cause;
        this.details = details;
        this.docs = docs;
        this.docsPath = docsPath;
        this.shortMessage = shortMessage;
        var _options_version;
        this.version = (_options_version = options.version) !== null && _options_version !== void 0 ? _options_version : "ox@".concat((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getVersion"])());
    }
}
/** @internal */ function walk(err, fn) {
    if (fn === null || fn === void 0 ? void 0 : fn(err)) return err;
    if (err && typeof err === 'object' && 'cause' in err && err.cause) return walk(err.cause, fn);
    return fn ? null : err;
} //# sourceMappingURL=Errors.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/bytes.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "assertEndOffset",
    ()=>assertEndOffset,
    "assertSize",
    ()=>assertSize,
    "assertStartOffset",
    ()=>assertStartOffset,
    "charCodeMap",
    ()=>charCodeMap,
    "charCodeToBase16",
    ()=>charCodeToBase16,
    "pad",
    ()=>pad,
    "trim",
    ()=>trim
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
;
function assertSize(bytes, size_) {
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes) > size_) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SizeOverflowError"]({
        givenSize: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](bytes),
        maxSize: size_
    });
}
function assertStartOffset(value, start) {
    if (typeof start === 'number' && start > 0 && start > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) - 1) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SliceOffsetOutOfBoundsError"]({
        offset: start,
        position: 'start',
        size: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value)
    });
}
function assertEndOffset(value, start, end) {
    if (typeof start === 'number' && typeof end === 'number' && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) !== end - start) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SliceOffsetOutOfBoundsError"]({
            offset: end,
            position: 'end',
            size: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value)
        });
    }
}
const charCodeMap = {
    zero: 48,
    nine: 57,
    A: 65,
    F: 70,
    a: 97,
    f: 102
};
function charCodeToBase16(char) {
    if (char >= charCodeMap.zero && char <= charCodeMap.nine) return char - charCodeMap.zero;
    if (char >= charCodeMap.A && char <= charCodeMap.F) return char - (charCodeMap.A - 10);
    if (char >= charCodeMap.a && char <= charCodeMap.f) return char - (charCodeMap.a - 10);
    return undefined;
}
function pad(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { dir, size = 32 } = options;
    if (size === 0) return bytes;
    if (bytes.length > size) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SizeExceedsPaddingSizeError"]({
        size: bytes.length,
        targetSize: size,
        type: 'Bytes'
    });
    const paddedBytes = new Uint8Array(size);
    for(let i = 0; i < size; i++){
        const padEnd = dir === 'right';
        paddedBytes[padEnd ? i : size - i - 1] = bytes[padEnd ? i : bytes.length - i - 1];
    }
    return paddedBytes;
}
function trim(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { dir = 'left' } = options;
    let data = value;
    let sliceLength = 0;
    for(let i = 0; i < data.length - 1; i++){
        if (data[dir === 'left' ? i : data.length - i - 1].toString() === '0') sliceLength++;
        else break;
    }
    data = dir === 'left' ? data.slice(sliceLength) : data.slice(0, data.length - sliceLength);
    return data;
} //# sourceMappingURL=bytes.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/hex.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "assertEndOffset",
    ()=>assertEndOffset,
    "assertSize",
    ()=>assertSize,
    "assertStartOffset",
    ()=>assertStartOffset,
    "pad",
    ()=>pad,
    "trim",
    ()=>trim
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
;
function assertSize(hex, size_) {
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](hex) > size_) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SizeOverflowError"]({
        givenSize: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](hex),
        maxSize: size_
    });
}
function assertStartOffset(value, start) {
    if (typeof start === 'number' && start > 0 && start > __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) - 1) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SliceOffsetOutOfBoundsError"]({
        offset: start,
        position: 'start',
        size: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value)
    });
}
function assertEndOffset(value, start, end) {
    if (typeof start === 'number' && typeof end === 'number' && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value) !== end - start) {
        throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SliceOffsetOutOfBoundsError"]({
            offset: end,
            position: 'end',
            size: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["size"](value)
        });
    }
}
function pad(hex_) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { dir, size = 32 } = options;
    if (size === 0) return hex_;
    const hex = hex_.replace('0x', '');
    if (hex.length > size * 2) throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["SizeExceedsPaddingSizeError"]({
        size: Math.ceil(hex.length / 2),
        targetSize: size,
        type: 'Hex'
    });
    return "0x".concat(hex[dir === 'right' ? 'padEnd' : 'padStart'](size * 2, '0'));
}
function trim(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { dir = 'left' } = options;
    let data = value.replace('0x', '');
    let sliceLength = 0;
    for(let i = 0; i < data.length - 1; i++){
        if (data[dir === 'left' ? i : data.length - i - 1].toString() === '0') sliceLength++;
        else break;
    }
    data = dir === 'left' ? data.slice(sliceLength) : data.slice(0, data.length - sliceLength);
    if (data === '0') return '0x';
    if (dir === 'right' && data.length % 2 === 1) return "0x".concat(data, "0");
    return "0x".concat(data);
} //# sourceMappingURL=hex.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "parse",
    ()=>parse,
    "stringify",
    ()=>stringify
]);
const bigIntSuffix = '#__bigint';
function parse(string, reviver) {
    return JSON.parse(string, (key, value_)=>{
        const value = value_;
        if (typeof value === 'string' && value.endsWith(bigIntSuffix)) return BigInt(value.slice(0, -bigIntSuffix.length));
        return typeof reviver === 'function' ? reviver(key, value) : value;
    });
}
function stringify(value, replacer, space) {
    return JSON.stringify(value, (key, value)=>{
        if (typeof replacer === 'function') return replacer(key, value);
        if (typeof value === 'bigint') return value.toString() + bigIntSuffix;
        return value;
    }, space);
} //# sourceMappingURL=Json.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "InvalidBytesBooleanError",
    ()=>InvalidBytesBooleanError,
    "InvalidBytesTypeError",
    ()=>InvalidBytesTypeError,
    "SizeExceedsPaddingSizeError",
    ()=>SizeExceedsPaddingSizeError,
    "SizeOverflowError",
    ()=>SizeOverflowError,
    "SliceOffsetOutOfBoundsError",
    ()=>SliceOffsetOutOfBoundsError,
    "assert",
    ()=>assert,
    "concat",
    ()=>concat,
    "from",
    ()=>from,
    "fromArray",
    ()=>fromArray,
    "fromBoolean",
    ()=>fromBoolean,
    "fromHex",
    ()=>fromHex,
    "fromNumber",
    ()=>fromNumber,
    "fromString",
    ()=>fromString,
    "isEqual",
    ()=>isEqual,
    "padLeft",
    ()=>padLeft,
    "padRight",
    ()=>padRight,
    "random",
    ()=>random,
    "size",
    ()=>size,
    "slice",
    ()=>slice,
    "toBigInt",
    ()=>toBigInt,
    "toBoolean",
    ()=>toBoolean,
    "toHex",
    ()=>toHex,
    "toNumber",
    ()=>toNumber,
    "toString",
    ()=>toString,
    "trimLeft",
    ()=>trimLeft,
    "trimRight",
    ()=>trimRight,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$abstract$2f$utils$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/abstract/utils.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
;
;
;
;
;
;
const decoder = /*#__PURE__*/ new TextDecoder();
const encoder = /*#__PURE__*/ new TextEncoder();
function assert(value) {
    if (value instanceof Uint8Array) return;
    if (!value) throw new InvalidBytesTypeError(value);
    if (typeof value !== 'object') throw new InvalidBytesTypeError(value);
    if (!('BYTES_PER_ELEMENT' in value)) throw new InvalidBytesTypeError(value);
    if (value.BYTES_PER_ELEMENT !== 1 || value.constructor.name !== 'Uint8Array') throw new InvalidBytesTypeError(value);
}
function concat() {
    for(var _len = arguments.length, values = new Array(_len), _key = 0; _key < _len; _key++){
        values[_key] = arguments[_key];
    }
    let length = 0;
    for (const arr of values){
        length += arr.length;
    }
    const result = new Uint8Array(length);
    for(let i = 0, index = 0; i < values.length; i++){
        const arr = values[i];
        result.set(arr, index);
        index += arr.length;
    }
    return result;
}
function from(value) {
    if (value instanceof Uint8Array) return value;
    if (typeof value === 'string') return fromHex(value);
    return fromArray(value);
}
function fromArray(value) {
    return value instanceof Uint8Array ? value : new Uint8Array(value);
}
function fromBoolean(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    const bytes = new Uint8Array(1);
    bytes[0] = Number(value);
    if (typeof size === 'number') {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes, size);
        return padLeft(bytes, size);
    }
    return bytes;
}
function fromHex(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    let hex = value;
    if (size) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](value, size);
        hex = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["padRight"](value, size);
    }
    let hexString = hex.slice(2);
    if (hexString.length % 2) hexString = "0".concat(hexString);
    const length = hexString.length / 2;
    const bytes = new Uint8Array(length);
    for(let index = 0, j = 0; index < length; index++){
        const nibbleLeft = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["charCodeToBase16"](hexString.charCodeAt(j++));
        const nibbleRight = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["charCodeToBase16"](hexString.charCodeAt(j++));
        if (nibbleLeft === undefined || nibbleRight === undefined) {
            throw new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"]('Invalid byte sequence ("'.concat(hexString[j - 2]).concat(hexString[j - 1], '" in "').concat(hexString, '").'));
        }
        bytes[index] = nibbleLeft << 4 | nibbleRight;
    }
    return bytes;
}
function fromNumber(value, options) {
    const hex = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromNumber"](value, options);
    return fromHex(hex);
}
function fromString(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    const bytes = encoder.encode(value);
    if (typeof size === 'number') {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes, size);
        return padRight(bytes, size);
    }
    return bytes;
}
function isEqual(bytesA, bytesB) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$abstract$2f$utils$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["equalBytes"])(bytesA, bytesB);
}
function padLeft(value, size) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"](value, {
        dir: 'left',
        size
    });
}
function padRight(value, size) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"](value, {
        dir: 'right',
        size
    });
}
function random(length) {
    return crypto.getRandomValues(new Uint8Array(length));
}
function size(value) {
    return value.length;
}
function slice(value, start, end) {
    let options = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : {};
    const { strict } = options;
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStartOffset"](value, start);
    const value_ = value.slice(start, end);
    if (strict) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertEndOffset"](value_, start, end);
    return value_;
}
function toBigInt(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    if (typeof size !== 'undefined') __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes, size);
    const hex = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes, options);
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toBigInt"](hex, options);
}
function toBoolean(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    let bytes_ = bytes;
    if (typeof size !== 'undefined') {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes_, size);
        bytes_ = trimLeft(bytes_);
    }
    if (bytes_.length > 1 || bytes_[0] > 1) throw new InvalidBytesBooleanError(bytes_);
    return Boolean(bytes_[0]);
}
function toHex(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](value, options);
}
function toNumber(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    if (typeof size !== 'undefined') __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes, size);
    const hex = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromBytes"](bytes, options);
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["toNumber"](hex, options);
}
function toString(bytes) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    let bytes_ = bytes;
    if (typeof size !== 'undefined') {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes_, size);
        bytes_ = trimRight(bytes_);
    }
    return decoder.decode(bytes_);
}
function trimLeft(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trim"](value, {
        dir: 'left'
    });
}
function trimRight(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trim"](value, {
        dir: 'right'
    });
}
function validate(value) {
    try {
        assert(value);
        return true;
    } catch (e) {
        return false;
    }
}
class InvalidBytesBooleanError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(bytes){
        super("Bytes value `".concat(bytes, "` is not a valid boolean."), {
            metaMessages: [
                'The bytes array must contain a single byte of either a `0` or `1` value.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Bytes.InvalidBytesBooleanError'
        });
    }
}
class InvalidBytesTypeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(value){
        super("Value `".concat(typeof value === 'object' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](value) : value, "` of type `").concat(typeof value, "` is an invalid Bytes value."), {
            metaMessages: [
                'Bytes values must be of type `Bytes`.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Bytes.InvalidBytesTypeError'
        });
    }
}
class SizeOverflowError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ givenSize, maxSize }){
        super("Size cannot exceed `".concat(maxSize, "` bytes. Given size: `").concat(givenSize, "` bytes."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Bytes.SizeOverflowError'
        });
    }
}
class SliceOffsetOutOfBoundsError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ offset, position, size }){
        super("Slice ".concat(position === 'start' ? 'starting' : 'ending', " at offset `").concat(offset, "` is out-of-bounds (size: `").concat(size, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Bytes.SliceOffsetOutOfBoundsError'
        });
    }
}
class SizeExceedsPaddingSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ size, targetSize, type }){
        super("".concat(type.charAt(0).toUpperCase()).concat(type.slice(1).toLowerCase(), " size (`").concat(size, "`) exceeds padding size (`").concat(targetSize, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Bytes.SizeExceedsPaddingSizeError'
        });
    }
} //# sourceMappingURL=Bytes.js.map
}),
"[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Hex.js [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "IntegerOutOfRangeError",
    ()=>IntegerOutOfRangeError,
    "InvalidHexBooleanError",
    ()=>InvalidHexBooleanError,
    "InvalidHexTypeError",
    ()=>InvalidHexTypeError,
    "InvalidHexValueError",
    ()=>InvalidHexValueError,
    "InvalidLengthError",
    ()=>InvalidLengthError,
    "SizeExceedsPaddingSizeError",
    ()=>SizeExceedsPaddingSizeError,
    "SizeOverflowError",
    ()=>SizeOverflowError,
    "SliceOffsetOutOfBoundsError",
    ()=>SliceOffsetOutOfBoundsError,
    "assert",
    ()=>assert,
    "concat",
    ()=>concat,
    "from",
    ()=>from,
    "fromBoolean",
    ()=>fromBoolean,
    "fromBytes",
    ()=>fromBytes,
    "fromNumber",
    ()=>fromNumber,
    "fromString",
    ()=>fromString,
    "isEqual",
    ()=>isEqual,
    "padLeft",
    ()=>padLeft,
    "padRight",
    ()=>padRight,
    "random",
    ()=>random,
    "size",
    ()=>size,
    "slice",
    ()=>slice,
    "toBigInt",
    ()=>toBigInt,
    "toBoolean",
    ()=>toBoolean,
    "toBytes",
    ()=>toBytes,
    "toNumber",
    ()=>toNumber,
    "toString",
    ()=>toString,
    "trimLeft",
    ()=>trimLeft,
    "trimRight",
    ()=>trimRight,
    "validate",
    ()=>validate
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$abstract$2f$utils$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/@noble+curves@1.9.1/node_modules/@noble/curves/esm/abstract/utils.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Errors.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/bytes.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/internal/hex.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/.pnpm/ox@0.9.14_typescript@5.9.3_zod@4.1.12/node_modules/ox/_esm/core/Json.js [app-client] (ecmascript)");
;
;
;
;
;
;
const encoder = /*#__PURE__*/ new TextEncoder();
const hexes = /*#__PURE__*/ Array.from({
    length: 256
}, (_v, i)=>i.toString(16).padStart(2, '0'));
function assert(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { strict = false } = options;
    if (!value) throw new InvalidHexTypeError(value);
    if (typeof value !== 'string') throw new InvalidHexTypeError(value);
    if (strict) {
        if (!/^0x[0-9a-fA-F]*$/.test(value)) throw new InvalidHexValueError(value);
    }
    if (!value.startsWith('0x')) throw new InvalidHexValueError(value);
}
function concat() {
    for(var _len = arguments.length, values = new Array(_len), _key = 0; _key < _len; _key++){
        values[_key] = arguments[_key];
    }
    return "0x".concat(values.reduce((acc, x)=>acc + x.replace('0x', ''), ''));
}
function from(value) {
    if (value instanceof Uint8Array) return fromBytes(value);
    if (Array.isArray(value)) return fromBytes(new Uint8Array(value));
    return value;
}
function fromBoolean(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const hex = "0x".concat(Number(value));
    if (typeof options.size === 'number') {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](hex, options.size);
        return padLeft(hex, options.size);
    }
    return hex;
}
function fromBytes(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let string = '';
    for(let i = 0; i < value.length; i++)string += hexes[value[i]];
    const hex = "0x".concat(string);
    if (typeof options.size === 'number') {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](hex, options.size);
        return padRight(hex, options.size);
    }
    return hex;
}
function fromNumber(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { signed, size } = options;
    const value_ = BigInt(value);
    let maxValue;
    if (size) {
        if (signed) maxValue = (1n << BigInt(size) * 8n - 1n) - 1n;
        else maxValue = 2n ** (BigInt(size) * 8n) - 1n;
    } else if (typeof value === 'number') {
        maxValue = BigInt(Number.MAX_SAFE_INTEGER);
    }
    const minValue = typeof maxValue === 'bigint' && signed ? -maxValue - 1n : 0;
    if (maxValue && value_ > maxValue || value_ < minValue) {
        const suffix = typeof value === 'bigint' ? 'n' : '';
        throw new IntegerOutOfRangeError({
            max: maxValue ? "".concat(maxValue).concat(suffix) : undefined,
            min: "".concat(minValue).concat(suffix),
            signed,
            size,
            value: "".concat(value).concat(suffix)
        });
    }
    const stringValue = (signed && value_ < 0 ? BigInt.asUintN(size * 8, BigInt(value_)) : value_).toString(16);
    const hex = "0x".concat(stringValue);
    if (size) return padLeft(hex, size);
    return hex;
}
function fromString(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return fromBytes(encoder.encode(value), options);
}
function isEqual(hexA, hexB) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f40$noble$2b$curves$40$1$2e$9$2e$1$2f$node_modules$2f40$noble$2f$curves$2f$esm$2f$abstract$2f$utils$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["equalBytes"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](hexA), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](hexB));
}
function padLeft(value, size) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"](value, {
        dir: 'left',
        size
    });
}
function padRight(value, size) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["pad"](value, {
        dir: 'right',
        size
    });
}
function random(length) {
    return fromBytes(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["random"](length));
}
function slice(value, start, end) {
    let options = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : {};
    const { strict } = options;
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertStartOffset"](value, start);
    const value_ = "0x".concat(value.replace('0x', '').slice((start !== null && start !== void 0 ? start : 0) * 2, (end !== null && end !== void 0 ? end : value.length) * 2));
    if (strict) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertEndOffset"](value_, start, end);
    return value_;
}
function size(value) {
    return Math.ceil((value.length - 2) / 2);
}
function trimLeft(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trim"](value, {
        dir: 'left'
    });
}
function trimRight(value) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trim"](value, {
        dir: 'right'
    });
}
function toBigInt(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { signed } = options;
    if (options.size) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](hex, options.size);
    const value = BigInt(hex);
    if (!signed) return value;
    const size = (hex.length - 2) / 2;
    const max_unsigned = (1n << BigInt(size) * 8n) - 1n;
    const max_signed = max_unsigned >> 1n;
    if (value <= max_signed) return value;
    return value - max_unsigned - 1n;
}
function toBoolean(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (options.size) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$hex$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](hex, options.size);
    const hex_ = trimLeft(hex);
    if (hex_ === '0x') return false;
    if (hex_ === '0x1') return true;
    throw new InvalidHexBooleanError(hex);
}
function toBytes(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](hex, options);
}
function toNumber(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { signed, size } = options;
    if (!signed && !size) return Number(hex);
    return Number(toBigInt(hex, options));
}
function toString(hex) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { size } = options;
    let bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["fromHex"](hex);
    if (size) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$internal$2f$bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["assertSize"](bytes, size);
        bytes = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Bytes$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["trimRight"](bytes);
    }
    return new TextDecoder().decode(bytes);
}
function validate(value) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    const { strict = false } = options;
    try {
        assert(value, {
            strict
        });
        return true;
    } catch (e) {
        return false;
    }
}
class IntegerOutOfRangeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ max, min, signed, size, value }){
        super("Number `".concat(value, "` is not in safe").concat(size ? " ".concat(size * 8, "-bit") : '').concat(signed ? ' signed' : ' unsigned', " integer range ").concat(max ? "(`".concat(min, "` to `").concat(max, "`)") : "(above `".concat(min, "`)")));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.IntegerOutOfRangeError'
        });
    }
}
class InvalidHexBooleanError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(hex){
        super('Hex value `"'.concat(hex, '"` is not a valid boolean.'), {
            metaMessages: [
                'The hex value must be `"0x0"` (false) or `"0x1"` (true).'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.InvalidHexBooleanError'
        });
    }
}
class InvalidHexTypeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(value){
        super("Value `".concat(typeof value === 'object' ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Json$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["stringify"](value) : value, "` of type `").concat(typeof value, "` is an invalid hex type."), {
            metaMessages: [
                'Hex types must be represented as `"0x${string}"`.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.InvalidHexTypeError'
        });
    }
}
class InvalidHexValueError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(value){
        super("Value `".concat(value, "` is an invalid hex value."), {
            metaMessages: [
                'Hex values must start with `"0x"` and contain only hexadecimal characters (0-9, a-f, A-F).'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.InvalidHexValueError'
        });
    }
}
class InvalidLengthError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor(value){
        super('Hex value `"'.concat(value, '"` is an odd length (').concat(value.length - 2, " nibbles)."), {
            metaMessages: [
                'It must be an even length.'
            ]
        });
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.InvalidLengthError'
        });
    }
}
class SizeOverflowError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ givenSize, maxSize }){
        super("Size cannot exceed `".concat(maxSize, "` bytes. Given size: `").concat(givenSize, "` bytes."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.SizeOverflowError'
        });
    }
}
class SliceOffsetOutOfBoundsError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ offset, position, size }){
        super("Slice ".concat(position === 'start' ? 'starting' : 'ending', " at offset `").concat(offset, "` is out-of-bounds (size: `").concat(size, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.SliceOffsetOutOfBoundsError'
        });
    }
}
class SizeExceedsPaddingSizeError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f2e$pnpm$2f$ox$40$0$2e$9$2e$14_typescript$40$5$2e$9$2e$3_zod$40$4$2e$1$2e$12$2f$node_modules$2f$ox$2f$_esm$2f$core$2f$Errors$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["BaseError"] {
    constructor({ size, targetSize, type }){
        super("".concat(type.charAt(0).toUpperCase()).concat(type.slice(1).toLowerCase(), " size (`").concat(size, "`) exceeds padding size (`").concat(targetSize, "`)."));
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 'Hex.SizeExceedsPaddingSizeError'
        });
    }
} //# sourceMappingURL=Hex.js.map
}),
]);

//# sourceMappingURL=node_modules__pnpm_3c6a99c1._.js.map